/*
**  CXSC is a C++ library for eXtended Scientific Computing (V 2.5.4)
**
**  Copyright (C) 1990-2000 Institut fuer Angewandte Mathematik,
**                          Universitaet Karlsruhe, Germany
**            (C) 2000-2014 Wiss. Rechnen/Softwaretechnologie
**                          Universitaet Wuppertal, Germany   
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Library General Public
**  License as published by the Free Software Foundation; either
**  version 2 of the License, or (at your option) any later version.
**
**  This library is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
**  Library General Public License for more details.
**
**  You should have received a copy of the GNU Library General Public
**  License along with this library; if not, write to the Free
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* CVS $Id: t_glbl.c,v 1.21 2014/01/30 17:24:16 cxsc Exp $ */

/****************************************************************/
/*                                                              */
/*      Filename: t_glbl.c                                      */
/*                                                              */
/****************************************************************/

#ifdef AIX
#include "/u/p88c/runtime/tbyte/t_mach.h"
#include "/u/p88c/runtime/o_defs.h"
#else
#include "o_defs.h"
#include "t_mach.h"
#endif

#if SUN4_CPP_C
/* switch off caused by initialization difficulites */
#undef ANSI_C
#endif

#ifdef ANSI_C

#ifdef AIX
#include "/u/p88c/runtime/tbyte/t_defs.h"
#else
#include "t_defs.h"
#endif
#else  /* NOT ANSI_C */

#define const

#ifdef IEEE_HARDWARE
#if SUN4_OS4_C+SUN4_GNU_C+SUN4_CPP_C
/* #define __CB_SUN4_OS4_HARDWARE */
#endif
#endif

#ifdef __CB_SUN4_OS4_HARDWARE	/* fuer SUN4 ist LSBFIRST=false */
#  define EXTREAL(y0,y1,y2,y3,y4,y5,y6,y7,y8,y9) \
	{  /* Exponent+VZ */	y0, y1,	\
	   /* 64bit Mant  */    (((y2<<1)&0x0fe)+((y3>>7)&0x001)),	\
                             (((y3<<1)&0x0fe)+((y4>>7)&0x001)),	\
                             (((y4<<1)&0x0fe)+((y5>>7)&0x001)),	\
                             (((y5<<1)&0x0fe)+((y6>>7)&0x001)),	\
                             (((y6<<1)&0x0fe)+((y7>>7)&0x001)),	\
                             (((y7<<1)&0x0fe)+((y8>>7)&0x001)),	\
                             (((y8<<1)&0x0fe)+((y9>>7)&0x001)),	\
                             ((y9<<1)&0x0fe),			\
       /* Rest 0       */	0, 0, 0, 0, 0, 0  }
#else
#if LSBFIRST                    /* aus ieeedev.h */
#  define EXTREAL(y0,y1,y2,y3,y4,y5,y6,y7,y8,y9) \
                 {y9,y8,y7,y6,y5,y4,y3,y2,y1,y0}
#else
#  define EXTREAL(y0,y1,y2,y3,y4,y5,y6,y7,y8,y9) \
                 {y0,y1,y2,y3,y4,y5,y6,y7,y8,y9}
#endif /* LSBFIRST */
#endif

typedef char ExtReal[t_size];
typedef struct IExtReal { ExtReal u,l; } IExtReal;

#endif /* ANSI_C */


const ExtReal Zero
= EXTREAL(0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00);

const ExtReal One
= EXTREAL(0x3f,0xff,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00);

const ExtReal Half
= EXTREAL(0x3f,0xfe,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00);

const ExtReal Quarter
= EXTREAL(0x3f,0xfd,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00);

const ExtReal ThreeQuart
= EXTREAL(0x3f,0xfe,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00);

const ExtReal Two
= EXTREAL(0x40,0x00,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00);

const ExtReal Four
= EXTREAL(0x40,0x01,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00);

const ExtReal Eight
= EXTREAL(0x40,0x02,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00);

const ExtReal MinusOne
= EXTREAL(0xbf,0xff,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00);

const ExtReal MinExtReal
= EXTREAL(0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01);

const ExtReal MinNormExtReal
= EXTREAL(0x00,0x01,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00);

const ExtReal MaxNormExtReal
= EXTREAL(0x7f,0xfe,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff);

const ExtReal TwoPow63
= EXTREAL(0x40,0x3e,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00);

const ExtReal TwoPow127
= EXTREAL(0x40,0x7e,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00);

const ExtReal SqrtHalf
= EXTREAL(0x3f,0xfe,0xb5,0x04,0xf3,0x33,0xf9,0xde,0x64,0x84);

const ExtReal Pi /* NEAR */
= EXTREAL(0x40,0x00,0xc9,0x0f,0xda,0xa2,0x21,0x68,0xc2,0x35);

const ExtReal MinusPi
= EXTREAL(0xc0,0x00,0xc9,0x0f,0xda,0xa2,0x21,0x68,0xc2,0x35);

const ExtReal PiHalf /* NEAR */
= EXTREAL(0x3f,0xff,0xc9,0x0f,0xda,0xa2,0x21,0x68,0xc2,0x35);

const ExtReal MinusPiHalf
= EXTREAL(0xbf,0xff,0xc9,0x0f,0xda,0xa2,0x21,0x68,0xc2,0x35);

const ExtReal PiQuart /* NEAR */
= EXTREAL(0x3f,0xfe,0xc9,0x0f,0xda,0xa2,0x21,0x68,0xc2,0x35);

const ExtReal PiDiv16 =
EXTREAL(0x3F, 0xFC,
        0xC9, 0x0F, 0xDA, 0xA2,
        0x21, 0x68, 0xC2, 0x34);      /* +1.963495408493621E-001 */

const ExtReal PiDiv8 =
EXTREAL(0x3F, 0xFD,
        0xC9, 0x0F, 0xDA, 0xA2,
        0x21, 0x68, 0xC2, 0x34);      /* +3.926990816987241E-001 */

const ExtReal Pi3Div16 =
EXTREAL(0x3F, 0xFE,
        0x96, 0xCB, 0xE3, 0xF9,
        0x99, 0x0E, 0x91, 0xA7);      /* +5.890486225480862E-001 */

const ExtReal SqrtTwo /* (NEAR): */
= EXTREAL(0x3f,0xff,0xb5,0x04,0xf3,0x33,0xf9,0xde,0x64,0x84);
                                 /* +1.414213562373095E+000 */

const ExtReal Ln2  = /* NEAR ln(2) */
EXTREAL(0x3F, 0xFE,
        0xB1, 0x72, 0x17, 0xF7,
        0xD1, 0xCF, 0x79, 0xAC);      /* +6.931471805599453E-001 */

/* --- eigene Konstante in dexp ---
const ExtReal LdE
= EXTREAL(0x3f,0xff,0xb8,0xaa,0x3b,0x29,0x5c,0x17,0xf0,0xbc);
*/
                                 /* +1.442695040888963E+000 */

const ExtReal PInfty = EXTREAL(0x7F, 0xFF,
               0x80, 0x00, 0x00, 0x00,
               0x00, 0x00, 0x00, 0x00); /* +Infinity        */
const ExtReal MInfty =
EXTREAL(0xFF, 0xFF,
        0x80, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00);      /* -Infinity              */
/*--------------------------------------------------------------*/

const IExtReal IOne
= { EXTREAL(0x3f,0xff,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00),
    EXTREAL(0x3f,0xff,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00) };

const IExtReal IHalf
= { EXTREAL(0x3f,0xfe,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00),
    EXTREAL(0x3f,0xfe,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00) };

const IExtReal IPi
= { EXTREAL(0x40,0x00,0xc9,0x0f,0xda,0xa2,0x21,0x68,0xc2,0x35),
    EXTREAL(0x40,0x00,0xc9,0x0f,0xda,0xa2,0x21,0x68,0xc2,0x34) };

const IExtReal IPiHalf
= { EXTREAL(0x3f,0xff,0xc9,0x0f,0xda,0xa2,0x21,0x68,0xc2,0x35),
    EXTREAL(0x3f,0xff,0xc9,0x0f,0xda,0xa2,0x21,0x68,0xc2,0x34) };

const IExtReal ITwoDivPi
= { EXTREAL(0x3f,0xfe,0xa2,0xf9,0x83,0x6e,0x4e,0x44,0x15,0x2b),
    EXTREAL(0x3f,0xfe,0xa2,0xf9,0x83,0x6e,0x4e,0x44,0x15,0x29) };

const IExtReal ISqrtTwo 
= { EXTREAL(0x3f,0xff,0xb5,0x04,0xf3,0x33,0xf9,0xde,0x64,0x85),
    EXTREAL(0x3f,0xff,0xb5,0x04,0xf3,0x33,0xf9,0xde,0x64,0x84) };

#if VAX_VMS_C+CRAY_UNIX_C
#ifdef LINT_ARGS
local void t_glbl(void)
#else
local void t_glbl()
#endif
        {
        }
#endif





