/*
Copyright The cert-manager Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	corev1 "k8s.io/api/core/v1"
	apisv1 "sigs.k8s.io/gateway-api/apis/v1"
)

// ACMEChallengeSolverHTTP01GatewayHTTPRouteApplyConfiguration represents a declarative configuration of the ACMEChallengeSolverHTTP01GatewayHTTPRoute type for use
// with apply.
type ACMEChallengeSolverHTTP01GatewayHTTPRouteApplyConfiguration struct {
	ServiceType *corev1.ServiceType                                            `json:"serviceType,omitempty"`
	Labels      map[string]string                                              `json:"labels,omitempty"`
	ParentRefs  []apisv1.ParentReference                                       `json:"parentRefs,omitempty"`
	PodTemplate *ACMEChallengeSolverHTTP01IngressPodTemplateApplyConfiguration `json:"podTemplate,omitempty"`
}

// ACMEChallengeSolverHTTP01GatewayHTTPRouteApplyConfiguration constructs a declarative configuration of the ACMEChallengeSolverHTTP01GatewayHTTPRoute type for use with
// apply.
func ACMEChallengeSolverHTTP01GatewayHTTPRoute() *ACMEChallengeSolverHTTP01GatewayHTTPRouteApplyConfiguration {
	return &ACMEChallengeSolverHTTP01GatewayHTTPRouteApplyConfiguration{}
}

// WithServiceType sets the ServiceType field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ServiceType field is set to the value of the last call.
func (b *ACMEChallengeSolverHTTP01GatewayHTTPRouteApplyConfiguration) WithServiceType(value corev1.ServiceType) *ACMEChallengeSolverHTTP01GatewayHTTPRouteApplyConfiguration {
	b.ServiceType = &value
	return b
}

// WithLabels puts the entries into the Labels field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, the entries provided by each call will be put on the Labels field,
// overwriting an existing map entries in Labels field with the same key.
func (b *ACMEChallengeSolverHTTP01GatewayHTTPRouteApplyConfiguration) WithLabels(entries map[string]string) *ACMEChallengeSolverHTTP01GatewayHTTPRouteApplyConfiguration {
	if b.Labels == nil && len(entries) > 0 {
		b.Labels = make(map[string]string, len(entries))
	}
	for k, v := range entries {
		b.Labels[k] = v
	}
	return b
}

// WithParentRefs adds the given value to the ParentRefs field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the ParentRefs field.
func (b *ACMEChallengeSolverHTTP01GatewayHTTPRouteApplyConfiguration) WithParentRefs(values ...apisv1.ParentReference) *ACMEChallengeSolverHTTP01GatewayHTTPRouteApplyConfiguration {
	for i := range values {
		b.ParentRefs = append(b.ParentRefs, values[i])
	}
	return b
}

// WithPodTemplate sets the PodTemplate field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the PodTemplate field is set to the value of the last call.
func (b *ACMEChallengeSolverHTTP01GatewayHTTPRouteApplyConfiguration) WithPodTemplate(value *ACMEChallengeSolverHTTP01IngressPodTemplateApplyConfiguration) *ACMEChallengeSolverHTTP01GatewayHTTPRouteApplyConfiguration {
	b.PodTemplate = value
	return b
}
