/*
Copyright The cert-manager Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	metav1 "github.com/cert-manager/cert-manager/pkg/client/applyconfigurations/meta/v1"
	apismetav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
)

// OrderSpecApplyConfiguration represents a declarative configuration of the OrderSpec type for use
// with apply.
type OrderSpecApplyConfiguration struct {
	Request     []byte                                    `json:"request,omitempty"`
	IssuerRef   *metav1.IssuerReferenceApplyConfiguration `json:"issuerRef,omitempty"`
	CommonName  *string                                   `json:"commonName,omitempty"`
	DNSNames    []string                                  `json:"dnsNames,omitempty"`
	IPAddresses []string                                  `json:"ipAddresses,omitempty"`
	Duration    *apismetav1.Duration                      `json:"duration,omitempty"`
	Profile     *string                                   `json:"profile,omitempty"`
}

// OrderSpecApplyConfiguration constructs a declarative configuration of the OrderSpec type for use with
// apply.
func OrderSpec() *OrderSpecApplyConfiguration {
	return &OrderSpecApplyConfiguration{}
}

// WithRequest adds the given value to the Request field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Request field.
func (b *OrderSpecApplyConfiguration) WithRequest(values ...byte) *OrderSpecApplyConfiguration {
	for i := range values {
		b.Request = append(b.Request, values[i])
	}
	return b
}

// WithIssuerRef sets the IssuerRef field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the IssuerRef field is set to the value of the last call.
func (b *OrderSpecApplyConfiguration) WithIssuerRef(value *metav1.IssuerReferenceApplyConfiguration) *OrderSpecApplyConfiguration {
	b.IssuerRef = value
	return b
}

// WithCommonName sets the CommonName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the CommonName field is set to the value of the last call.
func (b *OrderSpecApplyConfiguration) WithCommonName(value string) *OrderSpecApplyConfiguration {
	b.CommonName = &value
	return b
}

// WithDNSNames adds the given value to the DNSNames field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the DNSNames field.
func (b *OrderSpecApplyConfiguration) WithDNSNames(values ...string) *OrderSpecApplyConfiguration {
	for i := range values {
		b.DNSNames = append(b.DNSNames, values[i])
	}
	return b
}

// WithIPAddresses adds the given value to the IPAddresses field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the IPAddresses field.
func (b *OrderSpecApplyConfiguration) WithIPAddresses(values ...string) *OrderSpecApplyConfiguration {
	for i := range values {
		b.IPAddresses = append(b.IPAddresses, values[i])
	}
	return b
}

// WithDuration sets the Duration field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Duration field is set to the value of the last call.
func (b *OrderSpecApplyConfiguration) WithDuration(value apismetav1.Duration) *OrderSpecApplyConfiguration {
	b.Duration = &value
	return b
}

// WithProfile sets the Profile field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Profile field is set to the value of the last call.
func (b *OrderSpecApplyConfiguration) WithProfile(value string) *OrderSpecApplyConfiguration {
	b.Profile = &value
	return b
}
