/*
Copyright The cert-manager Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

// CertificateKeystoresApplyConfiguration represents a declarative configuration of the CertificateKeystores type for use
// with apply.
type CertificateKeystoresApplyConfiguration struct {
	JKS    *JKSKeystoreApplyConfiguration    `json:"jks,omitempty"`
	PKCS12 *PKCS12KeystoreApplyConfiguration `json:"pkcs12,omitempty"`
}

// CertificateKeystoresApplyConfiguration constructs a declarative configuration of the CertificateKeystores type for use with
// apply.
func CertificateKeystores() *CertificateKeystoresApplyConfiguration {
	return &CertificateKeystoresApplyConfiguration{}
}

// WithJKS sets the JKS field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the JKS field is set to the value of the last call.
func (b *CertificateKeystoresApplyConfiguration) WithJKS(value *JKSKeystoreApplyConfiguration) *CertificateKeystoresApplyConfiguration {
	b.JKS = value
	return b
}

// WithPKCS12 sets the PKCS12 field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the PKCS12 field is set to the value of the last call.
func (b *CertificateKeystoresApplyConfiguration) WithPKCS12(value *PKCS12KeystoreApplyConfiguration) *CertificateKeystoresApplyConfiguration {
	b.PKCS12 = value
	return b
}
