/*
Copyright The cert-manager Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	metav1 "github.com/cert-manager/cert-manager/pkg/client/applyconfigurations/meta/v1"
)

// VaultIssuerApplyConfiguration represents a declarative configuration of the VaultIssuer type for use
// with apply.
type VaultIssuerApplyConfiguration struct {
	Auth                *VaultAuthApplyConfiguration                `json:"auth,omitempty"`
	Server              *string                                     `json:"server,omitempty"`
	ServerName          *string                                     `json:"serverName,omitempty"`
	Path                *string                                     `json:"path,omitempty"`
	Namespace           *string                                     `json:"namespace,omitempty"`
	CABundle            []byte                                      `json:"caBundle,omitempty"`
	CABundleSecretRef   *metav1.SecretKeySelectorApplyConfiguration `json:"caBundleSecretRef,omitempty"`
	ClientCertSecretRef *metav1.SecretKeySelectorApplyConfiguration `json:"clientCertSecretRef,omitempty"`
	ClientKeySecretRef  *metav1.SecretKeySelectorApplyConfiguration `json:"clientKeySecretRef,omitempty"`
}

// VaultIssuerApplyConfiguration constructs a declarative configuration of the VaultIssuer type for use with
// apply.
func VaultIssuer() *VaultIssuerApplyConfiguration {
	return &VaultIssuerApplyConfiguration{}
}

// WithAuth sets the Auth field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Auth field is set to the value of the last call.
func (b *VaultIssuerApplyConfiguration) WithAuth(value *VaultAuthApplyConfiguration) *VaultIssuerApplyConfiguration {
	b.Auth = value
	return b
}

// WithServer sets the Server field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Server field is set to the value of the last call.
func (b *VaultIssuerApplyConfiguration) WithServer(value string) *VaultIssuerApplyConfiguration {
	b.Server = &value
	return b
}

// WithServerName sets the ServerName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ServerName field is set to the value of the last call.
func (b *VaultIssuerApplyConfiguration) WithServerName(value string) *VaultIssuerApplyConfiguration {
	b.ServerName = &value
	return b
}

// WithPath sets the Path field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Path field is set to the value of the last call.
func (b *VaultIssuerApplyConfiguration) WithPath(value string) *VaultIssuerApplyConfiguration {
	b.Path = &value
	return b
}

// WithNamespace sets the Namespace field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Namespace field is set to the value of the last call.
func (b *VaultIssuerApplyConfiguration) WithNamespace(value string) *VaultIssuerApplyConfiguration {
	b.Namespace = &value
	return b
}

// WithCABundle adds the given value to the CABundle field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the CABundle field.
func (b *VaultIssuerApplyConfiguration) WithCABundle(values ...byte) *VaultIssuerApplyConfiguration {
	for i := range values {
		b.CABundle = append(b.CABundle, values[i])
	}
	return b
}

// WithCABundleSecretRef sets the CABundleSecretRef field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the CABundleSecretRef field is set to the value of the last call.
func (b *VaultIssuerApplyConfiguration) WithCABundleSecretRef(value *metav1.SecretKeySelectorApplyConfiguration) *VaultIssuerApplyConfiguration {
	b.CABundleSecretRef = value
	return b
}

// WithClientCertSecretRef sets the ClientCertSecretRef field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ClientCertSecretRef field is set to the value of the last call.
func (b *VaultIssuerApplyConfiguration) WithClientCertSecretRef(value *metav1.SecretKeySelectorApplyConfiguration) *VaultIssuerApplyConfiguration {
	b.ClientCertSecretRef = value
	return b
}

// WithClientKeySecretRef sets the ClientKeySecretRef field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ClientKeySecretRef field is set to the value of the last call.
func (b *VaultIssuerApplyConfiguration) WithClientKeySecretRef(value *metav1.SecretKeySelectorApplyConfiguration) *VaultIssuerApplyConfiguration {
	b.ClientKeySecretRef = value
	return b
}
