
// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "pyfalkon_python.h"

// main header
#include "networkmanager_wrapper.h"

// Wrappers providing overrides
#include "tabtreemodel_wrapper.h"
#include "webview_wrapper.h"

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_NetworkManager_Type = nullptr;
static PyTypeObject *Sbk_NetworkManager_TypeF(void)
{
    return _Sbk_NetworkManager_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void NetworkManagerWrapper::pysideInitQtMetaTypes()
{
}

void NetworkManagerWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

NetworkManagerWrapper::NetworkManagerWrapper(::QObject * parent) : NetworkManager(parent)
{
}

void NetworkManagerWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_NetworkManager_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    WebViewWrapper::sbk_o_childEvent("NetworkManager", funcName, gil, pyOverride, event);
}

void NetworkManagerWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_NetworkManager_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("NetworkManager", funcName, gil, pyOverride, signal);
}

::QNetworkReply * NetworkManagerWrapper::createRequest(::QNetworkAccessManager::Operation op, const ::QNetworkRequest & request, ::QIODevice * outgoingData)
{
    static const char *funcName = "createRequest";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_NetworkManager_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::NetworkManager::createRequest(op, request, outgoingData);
    }
    return sbk_o_createRequest("NetworkManager", funcName, gil, pyOverride, op, request, outgoingData);
}

::QNetworkReply * NetworkManagerWrapper::sbk_o_createRequest(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QNetworkAccessManager::Operation op, const ::QNetworkRequest & request, ::QIODevice * outgoingData)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[3] = {
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtNetworkTypeStructs[SBK_QNetworkAccessManager_Operation_IDX])))->converter, &op),
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtNetworkTypeStructs[SBK_QNetworkRequest_IDX]), &request),
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QIODevice_IDX]), outgoingData)
    };

    const bool invalidateArg3 = Py_REFCNT(pyArgArray[2]) == 1;
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NNN)",
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtNetworkTypeStructs[SBK_QNetworkAccessManager_Operation_IDX])))->converter, &op),
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtNetworkTypeStructs[SBK_QNetworkRequest_IDX]), &request),
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QIODevice_IDX]), outgoingData)
    ));
    bool invalidateArg3 = Py_REFCNT(PyTuple_GetItem(pyArgs, 2)) == 1;
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 3, nullptr));
    if (invalidateArg3)
        Shiboken::Object::invalidate(pyArgArray[2]);
    Py_DECREF(pyArgArray[0]);
    Py_DECREF(pyArgArray[1]);
    Py_DECREF(pyArgArray[2]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    if (invalidateArg3)
        Shiboken::Object::invalidate(PyTuple_GetItem(pyArgs, 2));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return nullptr;
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtNetworkTypeStructs[SBK_QNetworkReply_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, PepType_GetFullyQualifiedNameStr(Shiboken::SbkType< QNetworkReply >()), Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QNetworkReply *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void NetworkManagerWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_NetworkManager_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    WebViewWrapper::sbk_o_customEvent("NetworkManager", funcName, gil, pyOverride, event);
}

void NetworkManagerWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_NetworkManager_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("NetworkManager", funcName, gil, pyOverride, signal);
}

bool NetworkManagerWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_NetworkManager_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::event(event);
    }
    return WebViewWrapper::sbk_o_event("NetworkManager", funcName, gil, pyOverride, event);
}

bool NetworkManagerWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_NetworkManager_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return WebViewWrapper::sbk_o_eventFilter("NetworkManager", funcName, gil, pyOverride, watched, event);
}

::QStringList NetworkManagerWrapper::supportedSchemes() const
{
    static const char *funcName = "supportedSchemes";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_NetworkManager_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QNetworkAccessManager::supportedSchemes();
    }
    return TabTreeModelWrapper::sbk_o_mimeTypes("NetworkManager", funcName, gil, pyOverride);
}

void NetworkManagerWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_NetworkManager_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    WebViewWrapper::sbk_o_timerEvent("NetworkManager", funcName, gil, pyOverride, event);
}

const QMetaObject *NetworkManagerWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return NetworkManager::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int NetworkManagerWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = NetworkManager::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *NetworkManagerWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< NetworkManagerWrapper *>(this));
    }
    return NetworkManager::qt_metacast(_clname);
}

NetworkManagerWrapper::~NetworkManagerWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_NetworkManager_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_NetworkManager_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::NetworkManager >()))
        return -1;

    NetworkManagerWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|O:NetworkManager", &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: NetworkManager::NetworkManager(QObject*=)
    if (numArgs == 0) {
        overloadId = 0; // NetworkManager(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))) {
        overloadId = 0; // NetworkManager(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_NetworkManager_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkPyFalkonTypeStructs[SBK_NetworkManager_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_NetworkManager_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // NetworkManager(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) NetworkManagerWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new NetworkManagerWrapper(cppArg0);
            }

            // Ownership transferences (constructor heuristics).
            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< NetworkManager >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_NetworkManager_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_NetworkManager_IDX]);
    };


    return 1;
}

static PyObject *Sbk_NetworkManagerFunc_authentication(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<NetworkManagerWrapper *>(reinterpret_cast< ::NetworkManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_NetworkManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 2, 3));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "authentication", errInfo, SbkPyFalkonTypeStructs[SBK_NetworkManager_IDX]);

    if (PyArg_ParseTuple(args, "|OOO:authentication", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: NetworkManager::authentication(QUrl,QAuthenticator*,QWidget*=)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtNetworkTypeStructs[SBK_QAuthenticator_IDX]), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // authentication(QUrl,QAuthenticator*,QWidget*)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[2])))) {
            overloadId = 0; // authentication(QUrl,QAuthenticator*,QWidget*)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "authentication", errInfo, SbkPyFalkonTypeStructs[SBK_NetworkManager_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 2}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[2]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "authentication", errInfo, SbkPyFalkonTypeStructs[SBK_NetworkManager_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0].isValue())
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QAuthenticator *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QWidget *cppArg2 = nullptr;
        if (pythonToCpp[2])
            pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // authentication(QUrl,QAuthenticator*,QWidget*)
            cppSelf->authentication(*cppArg0, cppArg1, cppArg2);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_NetworkManagerFunc_createRequest(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<NetworkManagerWrapper *>(reinterpret_cast< ::NetworkManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_NetworkManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "createRequest", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: QNetworkAccessManager::createRequest(QNetworkAccessManager::Operation,QNetworkRequest,QIODevice*)->QNetworkReply*
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtNetworkTypeStructs[SBK_QNetworkAccessManager_Operation_IDX])))->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtNetworkTypeStructs[SBK_QNetworkRequest_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QIODevice_IDX]), (pyArgs[2])))) {
        overloadId = 0; // createRequest(QNetworkAccessManager::Operation,QNetworkRequest,QIODevice*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "createRequest", errInfo, SbkPyFalkonTypeStructs[SBK_NetworkManager_IDX]);

    // Call function/method
    {
        ::QNetworkAccessManager::Operation cppArg0{QNetworkAccessManager::UnknownOperation};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QNetworkRequest cppArg1_local;
        ::QNetworkRequest *cppArg1 = &cppArg1_local;
        if (pythonToCpp[1].isValue())
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QIODevice *cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // createRequest(QNetworkAccessManager::Operation,QNetworkRequest,QIODevice*)
            QNetworkReply * cppResult = static_cast<NetworkManagerWrapper *>(cppSelf)->NetworkManagerWrapper::createRequest_protected(cppArg0, *cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtNetworkTypeStructs[SBK_QNetworkReply_IDX]), cppResult);

            // Ownership transferences.
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_NetworkManagerFunc_ignoredSslErrors(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<NetworkManagerWrapper *>(reinterpret_cast< ::NetworkManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_NetworkManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // ignoredSslErrors()const
        const QHash<QString,QWebEngineCertificateError::Type> cppResult = const_cast<const NetworkManagerWrapper *>(cppSelf)->ignoredSslErrors();
        pyResult = Shiboken::Conversions::copyToPython(SbkPyFalkonTypeConverters[SBK_PyFalkon_QHash_QString_QWebEngineCertificateError_Type_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_NetworkManagerFunc_ignoredSslHosts(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<NetworkManagerWrapper *>(reinterpret_cast< ::NetworkManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_NetworkManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // ignoredSslHosts()const
        const QStringList cppResult = const_cast<const NetworkManagerWrapper *>(cppSelf)->ignoredSslHosts();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_NetworkManagerFunc_installUrlInterceptor(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<NetworkManagerWrapper *>(reinterpret_cast< ::NetworkManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_NetworkManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: NetworkManager::installUrlInterceptor(UrlInterceptor*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_UrlInterceptor_IDX]), (pyArg)))) {
        overloadId = 0; // installUrlInterceptor(UrlInterceptor*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "installUrlInterceptor", errInfo, SbkPyFalkonTypeStructs[SBK_NetworkManager_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::UrlInterceptor *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // installUrlInterceptor(UrlInterceptor*)
            cppSelf->installUrlInterceptor(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_NetworkManagerFunc_loadSettings(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<NetworkManagerWrapper *>(reinterpret_cast< ::NetworkManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_NetworkManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // loadSettings()
        cppSelf->loadSettings();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_NetworkManagerFunc_proxyAuthentication(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<NetworkManagerWrapper *>(reinterpret_cast< ::NetworkManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_NetworkManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 2, 3));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "proxyAuthentication", errInfo, SbkPyFalkonTypeStructs[SBK_NetworkManager_IDX]);

    if (PyArg_ParseTuple(args, "|OOO:proxyAuthentication", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: NetworkManager::proxyAuthentication(QString,QAuthenticator*,QWidget*=)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtNetworkTypeStructs[SBK_QAuthenticator_IDX]), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // proxyAuthentication(QString,QAuthenticator*,QWidget*)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[2])))) {
            overloadId = 0; // proxyAuthentication(QString,QAuthenticator*,QWidget*)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "proxyAuthentication", errInfo, SbkPyFalkonTypeStructs[SBK_NetworkManager_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 2}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[2]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "proxyAuthentication", errInfo, SbkPyFalkonTypeStructs[SBK_NetworkManager_IDX]);
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QAuthenticator *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QWidget *cppArg2 = nullptr;
        if (pythonToCpp[2])
            pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // proxyAuthentication(QString,QAuthenticator*,QWidget*)
            cppSelf->proxyAuthentication(cppArg0, cppArg1, cppArg2);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_NetworkManagerFunc_registerExtensionSchemeHandler(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<NetworkManagerWrapper *>(reinterpret_cast< ::NetworkManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_NetworkManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "registerExtensionSchemeHandler", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: NetworkManager::registerExtensionSchemeHandler(QString,ExtensionSchemeHandler*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ExtensionSchemeHandler_IDX]), (pyArgs[1])))) {
        overloadId = 0; // registerExtensionSchemeHandler(QString,ExtensionSchemeHandler*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "registerExtensionSchemeHandler", errInfo, SbkPyFalkonTypeStructs[SBK_NetworkManager_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::ExtensionSchemeHandler *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // registerExtensionSchemeHandler(QString,ExtensionSchemeHandler*)
            cppSelf->registerExtensionSchemeHandler(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_NetworkManagerFunc_registerSchemes(PyObject *self)
{
    SBK_UNUSED(self)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // registerSchemes()
        ::NetworkManager::registerSchemes();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_NetworkManagerFunc_rejectedSslErrors(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<NetworkManagerWrapper *>(reinterpret_cast< ::NetworkManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_NetworkManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // rejectedSslErrors()const
        const QHash<QString,QWebEngineCertificateError::Type> cppResult = const_cast<const NetworkManagerWrapper *>(cppSelf)->rejectedSslErrors();
        pyResult = Shiboken::Conversions::copyToPython(SbkPyFalkonTypeConverters[SBK_PyFalkon_QHash_QString_QWebEngineCertificateError_Type_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_NetworkManagerFunc_removeUrlInterceptor(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<NetworkManagerWrapper *>(reinterpret_cast< ::NetworkManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_NetworkManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: NetworkManager::removeUrlInterceptor(UrlInterceptor*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_UrlInterceptor_IDX]), (pyArg)))) {
        overloadId = 0; // removeUrlInterceptor(UrlInterceptor*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "removeUrlInterceptor", errInfo, SbkPyFalkonTypeStructs[SBK_NetworkManager_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::UrlInterceptor *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // removeUrlInterceptor(UrlInterceptor*)
            cppSelf->removeUrlInterceptor(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_NetworkManagerFunc_shutdown(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<NetworkManagerWrapper *>(reinterpret_cast< ::NetworkManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_NetworkManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // shutdown()
        cppSelf->shutdown();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_NetworkManagerFunc_sslErrorDescription(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<NetworkManagerWrapper *>(reinterpret_cast< ::NetworkManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_NetworkManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: NetworkManager::sslErrorDescription(QWebEngineCertificateError::Type)const->QString
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtWebEngineCoreTypeStructs[SBK_QWebEngineCertificateError_Type_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // sslErrorDescription(QWebEngineCertificateError::Type)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "sslErrorDescription", errInfo, SbkPyFalkonTypeStructs[SBK_NetworkManager_IDX]);

    // Call function/method
    {
        ::QWebEngineCertificateError::Type cppArg0{QWebEngineCertificateError::Ok};
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // sslErrorDescription(QWebEngineCertificateError::Type)const
            QString cppResult = const_cast<const NetworkManagerWrapper *>(cppSelf)->sslErrorDescription(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_NetworkManagerFunc_unregisterExtensionSchemeHandler(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<NetworkManagerWrapper *>(reinterpret_cast< ::NetworkManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_NetworkManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: NetworkManager::unregisterExtensionSchemeHandler(ExtensionSchemeHandler*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ExtensionSchemeHandler_IDX]), (pyArg)))) {
        overloadId = 0; // unregisterExtensionSchemeHandler(ExtensionSchemeHandler*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "unregisterExtensionSchemeHandler", errInfo, SbkPyFalkonTypeStructs[SBK_NetworkManager_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::ExtensionSchemeHandler *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // unregisterExtensionSchemeHandler(ExtensionSchemeHandler*)
            cppSelf->unregisterExtensionSchemeHandler(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_NetworkManager_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_NetworkManager_methods[] = {
    {"authentication", reinterpret_cast<PyCFunction>(Sbk_NetworkManagerFunc_authentication), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"createRequest", reinterpret_cast<PyCFunction>(Sbk_NetworkManagerFunc_createRequest), METH_VARARGS, nullptr},
    {"ignoredSslErrors", reinterpret_cast<PyCFunction>(Sbk_NetworkManagerFunc_ignoredSslErrors), METH_NOARGS, nullptr},
    {"ignoredSslHosts", reinterpret_cast<PyCFunction>(Sbk_NetworkManagerFunc_ignoredSslHosts), METH_NOARGS, nullptr},
    {"installUrlInterceptor", reinterpret_cast<PyCFunction>(Sbk_NetworkManagerFunc_installUrlInterceptor), METH_O, nullptr},
    {"loadSettings", reinterpret_cast<PyCFunction>(Sbk_NetworkManagerFunc_loadSettings), METH_NOARGS, nullptr},
    {"proxyAuthentication", reinterpret_cast<PyCFunction>(Sbk_NetworkManagerFunc_proxyAuthentication), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"registerExtensionSchemeHandler", reinterpret_cast<PyCFunction>(Sbk_NetworkManagerFunc_registerExtensionSchemeHandler), METH_VARARGS, nullptr},
    {"registerSchemes", reinterpret_cast<PyCFunction>(Sbk_NetworkManagerFunc_registerSchemes), METH_NOARGS|METH_STATIC, nullptr},
    {"rejectedSslErrors", reinterpret_cast<PyCFunction>(Sbk_NetworkManagerFunc_rejectedSslErrors), METH_NOARGS, nullptr},
    {"removeUrlInterceptor", reinterpret_cast<PyCFunction>(Sbk_NetworkManagerFunc_removeUrlInterceptor), METH_O, nullptr},
    {"shutdown", reinterpret_cast<PyCFunction>(Sbk_NetworkManagerFunc_shutdown), METH_NOARGS, nullptr},
    {"sslErrorDescription", reinterpret_cast<PyCFunction>(Sbk_NetworkManagerFunc_sslErrorDescription), METH_O, nullptr},
    {"unregisterExtensionSchemeHandler", reinterpret_cast<PyCFunction>(Sbk_NetworkManagerFunc_unregisterExtensionSchemeHandler), METH_O, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_NetworkManager_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::NetworkManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_NetworkManager_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<NetworkManagerWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_NetworkManager_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_NetworkManager_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_NetworkManager_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_NetworkManager_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_NetworkManager_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_NetworkManager_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_NetworkManager_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_NetworkManager_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_NetworkManager_spec = {
    "1:PyFalkon.NetworkManager",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_NetworkManager_slots
};

} //extern "C"

static void *Sbk_NetworkManager_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::NetworkManager *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void NetworkManager_PythonToCpp_NetworkManager_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_NetworkManager_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_NetworkManager_PythonToCpp_NetworkManager_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_NetworkManager_TypeF()))
        return NetworkManager_PythonToCpp_NetworkManager_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *NetworkManager_PTR_CppToPython_NetworkManager(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::NetworkManager *>(const_cast<void *>(cppIn)), Sbk_NetworkManager_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *NetworkManager_SignatureStrings[] = {
    "PyFalkon.NetworkManager(self,parent:PySide6.QtCore.QObject=nullptr)",
    "PyFalkon.NetworkManager.authentication(self,url:typing.Union[PySide6.QtCore.QUrl, QString],auth:PySide6.QtNetwork.QAuthenticator,parent:PySide6.QtWidgets.QWidget=nullptr)",
    "PyFalkon.NetworkManager.createRequest(self,op:PySide6.QtNetwork.QNetworkAccessManager.Operation,request:PySide6.QtNetwork.QNetworkRequest,outgoingData:PySide6.QtCore.QIODevice)->PySide6.QtNetwork.QNetworkReply",
    "PyFalkon.NetworkManager.ignoredSslErrors(self)->QHash[QString, PySide6.QtWebEngineCore.QWebEngineCertificateError.Type]",
    "PyFalkon.NetworkManager.ignoredSslHosts(self)->QStringList",
    "PyFalkon.NetworkManager.installUrlInterceptor(self,interceptor:PyFalkon.UrlInterceptor)",
    "PyFalkon.NetworkManager.loadSettings(self)",
    "PyFalkon.NetworkManager.proxyAuthentication(self,proxyHost:QString,auth:PySide6.QtNetwork.QAuthenticator,parent:PySide6.QtWidgets.QWidget=nullptr)",
    "PyFalkon.NetworkManager.registerExtensionSchemeHandler(self,name:QString,handler:PyFalkon.ExtensionSchemeHandler)",
    "PyFalkon.NetworkManager.registerSchemes()",
    "PyFalkon.NetworkManager.rejectedSslErrors(self)->QHash[QString, PySide6.QtWebEngineCore.QWebEngineCertificateError.Type]",
    "PyFalkon.NetworkManager.removeUrlInterceptor(self,interceptor:PyFalkon.UrlInterceptor)",
    "PyFalkon.NetworkManager.shutdown(self)",
    "PyFalkon.NetworkManager.sslErrorDescription(self,error:PySide6.QtWebEngineCore.QWebEngineCertificateError.Type)->QString",
    "PyFalkon.NetworkManager.unregisterExtensionSchemeHandler(self,handler:PyFalkon.ExtensionSchemeHandler)",
    nullptr}; // Sentinel
#else
static constexpr size_t NetworkManager_SignatureByteSize = 425;
static constexpr uint8_t NetworkManager_SignatureBytes[425] = {
    0x78, 0xda, 0xc5, 0x54, 0xcf, 0x4f, 0xdb, 0x30, 0x14, 0xbe, 0xef, 0xaf, 0xe0, 0x08, 0x52, 0x96,
    0x23, 0x87, 0x48, 0x9b, 0x54, 0xad, 0x9d, 0x8a, 0xb4, 0xad, 0x0d, 0x19, 0xda, 0x01, 0x71, 0x30,
    0xce, 0x47, 0xe2, 0xe1, 0xda, 0xe6, 0xf9, 0x05, 0xc8, 0x7f, 0x3f, 0xa7, 0x4e, 0x09, 0x83, 0xa6,
    0xad, 0xa6, 0x09, 0x6e, 0x8e, 0xfd, 0xde, 0xf7, 0xe3, 0xf9, 0x73, 0x96, 0xed, 0x57, 0xa1, 0x6f,
    0xad, 0x49, 0x7f, 0x80, 0x1f, 0x2c, 0xdd, 0x7e, 0x17, 0x46, 0x54, 0xa0, 0x63, 0x0f, 0x7d, 0x93,
    0x38, 0x41, 0x30, 0x9c, 0x2d, 0xdb, 0x42, 0x95, 0x38, 0x4d, 0x73, 0xfe, 0x62, 0x09, 0x69, 0xbe,
    0xb8, 0xfe, 0x0d, 0xc9, 0x9f, 0x4c, 0xa3, 0xb5, 0x63, 0x3a, 0xf9, 0xb0, 0xdc, 0x8e, 0x91, 0x8a,
    0x86, 0xeb, 0xd0, 0xaf, 0xa4, 0x60, 0x65, 0x4d, 0x84, 0x6c, 0x48, 0x67, 0xdc, 0x3a, 0x65, 0xaa,
    0xf4, 0xc2, 0x84, 0xdd, 0xcb, 0x97, 0xe0, 0x17, 0xa4, 0x93, 0xa3, 0xbc, 0x60, 0x0a, 0x25, 0x57,
    0x49, 0x07, 0xf1, 0x8c, 0xbf, 0x27, 0x48, 0xf3, 0xc9, 0x00, 0x6d, 0xe9, 0xb5, 0xce, 0x5f, 0xaa,
    0xac, 0xc0, 0x3e, 0xcd, 0xe3, 0x62, 0xbf, 0x54, 0x49, 0x10, 0x8c, 0x73, 0xdc, 0x35, 0xf0, 0x1c,
    0x95, 0x5a, 0xb7, 0x8d, 0xb8, 0x5f, 0x4c, 0xa4, 0x84, 0xf7, 0x9b, 0xee, 0x85, 0x03, 0xad, 0x3d,
    0x26, 0x14, 0x11, 0x76, 0x74, 0xf6, 0x1c, 0x89, 0x6d, 0xb8, 0xb2, 0xc1, 0xe3, 0x54, 0xb0, 0x78,
    0x35, 0xe1, 0xb3, 0xc5, 0x14, 0xf7, 0x4a, 0xe2, 0xe4, 0xe3, 0xe7, 0x5d, 0x48, 0x4e, 0xb7, 0xa3,
    0x8e, 0x54, 0x65, 0x02, 0x54, 0x59, 0x78, 0x3d, 0x23, 0xb2, 0xe4, 0xd7, 0xa6, 0x02, 0x5e, 0x3e,
    0x17, 0xbe, 0xbe, 0xec, 0x07, 0x9c, 0x1c, 0x3d, 0x9b, 0x19, 0xae, 0x67, 0xa6, 0x52, 0x06, 0x51,
    0xc2, 0xf0, 0x09, 0x62, 0x75, 0xd3, 0x4d, 0x1a, 0x6b, 0xa4, 0xf4, 0x67, 0xeb, 0x70, 0x75, 0x00,
    0xef, 0xdc, 0x7a, 0x1e, 0x68, 0x23, 0xe1, 0x37, 0xe5, 0x79, 0xbc, 0xd5, 0x78, 0x16, 0x5a, 0x87,
    0x04, 0x9c, 0x19, 0x06, 0x49, 0xb8, 0x70, 0xb9, 0xf1, 0x32, 0xd4, 0xb0, 0x91, 0x3d, 0xb5, 0xff,
    0x5d, 0x38, 0x7e, 0xb9, 0xda, 0x8a, 0xb2, 0x00, 0x73, 0xe0, 0xef, 0xf5, 0x8c, 0x96, 0x3a, 0xb2,
    0x8f, 0xed, 0x64, 0x4b, 0x6e, 0xd7, 0x07, 0x9d, 0xa3, 0x6c, 0x33, 0xba, 0xb7, 0x8a, 0x26, 0xa1,
    0x0a, 0x43, 0x03, 0xcd, 0x1e, 0x19, 0xc6, 0x07, 0x41, 0x85, 0xac, 0xb1, 0xc2, 0x5c, 0x98, 0x52,
    0x6f, 0x1e, 0xaa, 0x11, 0x2b, 0x3c, 0x09, 0xab, 0xe3, 0xc9, 0x30, 0xa7, 0xed, 0x9d, 0xfb, 0x19,
    0x63, 0xb9, 0x3f, 0xde, 0x55, 0xd9, 0xfd, 0x09, 0xde, 0x21, 0x65, 0x84, 0x95, 0xbd, 0xc7, 0x7f,
    0x4f, 0x8a, 0xaf, 0x1b, 0x2e, 0xed, 0x83, 0xd9, 0x93, 0x12, 0xdf, 0xdb, 0x9d, 0xc2, 0x4b, 0x52,
    0x6e, 0x48, 0x09, 0xba, 0xdd, 0xec, 0x1f, 0xdd, 0x0e, 0xaf, 0x64, 0x94, 0xb8, 0x31, 0x87, 0xa4,
    0xe1, 0xe0, 0x00, 0xfc, 0x01, 0xae, 0x82, 0x41, 0xc6
};
#endif

PyTypeObject *init_NetworkManager(PyObject *module)
{
    if (SbkPyFalkonTypeStructs[SBK_NetworkManager_IDX].type != nullptr)
        return SbkPyFalkonTypeStructs[SBK_NetworkManager_IDX].type;

    Shiboken::AutoDecRef Sbk_NetworkManager_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtNetworkTypeStructs[SBK_QNetworkAccessManager_IDX]))));

    _Sbk_NetworkManager_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "NetworkManager",
        "NetworkManager*",
        &Sbk_NetworkManager_spec,
        &Shiboken::callCppDestructor< NetworkManager >,
        Sbk_NetworkManager_Type_bases.object(),
        0);
    auto *pyType = _Sbk_NetworkManager_Type; // references _Sbk_NetworkManager_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, NetworkManager_SignatureStrings);
#else
    InitSignatureBytes(pyType, NetworkManager_SignatureBytes, NetworkManager_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_NetworkManager_PropertyStrings);
    SbkPyFalkonTypeStructs[SBK_NetworkManager_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        NetworkManager_PythonToCpp_NetworkManager_PTR,
        is_NetworkManager_PythonToCpp_NetworkManager_PTR_Convertible,
        NetworkManager_PTR_CppToPython_NetworkManager);

    Shiboken::Conversions::registerConverterName(converter, "NetworkManager");
    Shiboken::Conversions::registerConverterName(converter, "NetworkManager*");
    Shiboken::Conversions::registerConverterName(converter, "NetworkManager&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::NetworkManager).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(NetworkManagerWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_NetworkManager_TypeF(), &Sbk_NetworkManager_typeDiscovery);

    NetworkManagerWrapper::pysideInitQtMetaTypes();
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::NetworkManager::staticMetaObject, sizeof(NetworkManagerWrapper));

    return pyType;
}
