/* THIS FILE IS AUTOGENERATED FROM MIDIInputMap.webidl BY Codegen.py - DO NOT EDIT */

#include <type_traits>
#include "MIDIInputMapBinding.h"
#include "MainThreadUtils.h"
#include "WrapperFactory.h"
#include "XrayWrapper.h"
#include "js/CallAndConstruct.h"
#include "js/Exception.h"
#include "js/MapAndSet.h"
#include "js/Object.h"
#include "js/PropertyAndElement.h"
#include "js/PropertyDescriptor.h"
#include "js/Symbol.h"
#include "js/experimental/JitInfo.h"
#include "mozilla/Atomics.h"
#include "mozilla/OwningNonNull.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/StaticPrefs_dom.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/DOMJSClass.h"
#include "mozilla/dom/MIDIInput.h"
#include "mozilla/dom/MIDIInputMap.h"
#include "mozilla/dom/NonRefcountedDOMObject.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/ToJSValue.h"
#include "mozilla/dom/XrayExpandoClass.h"

namespace mozilla::dom {

namespace binding_detail {}; // Just to make sure it's known as a namespace
using namespace mozilla::dom::binding_detail;


namespace MIDIInputMap_Binding {

namespace MaplikeHelpers {
void
Clear(mozilla::dom::MIDIInputMap* self, ErrorResult& aRv)
{
  MOZ_ASSERT(self);
  AutoJSAPI jsapi;
  jsapi.Init();
  JSContext* cx = jsapi.cx();
  // It's safe to use UnprivilegedJunkScopeOrWorkerGlobal here because
  // all we want is to wrap into _some_ scope and then unwrap to find
  // the reflector, and wrapping has no side-effects.
  JSObject* scope = UnprivilegedJunkScopeOrWorkerGlobal(fallible);
  if (!scope) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  JSAutoRealm tempRealm(cx, scope);
  JS::Rooted<JS::Value> v(cx);
  if(!ToJSValue(cx, self, &v)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  // This is a reflector, but due to trying to name things
  // similarly across method generators, it's called obj here.
  JS::Rooted<JSObject*> obj(cx);
  obj = js::UncheckedUnwrap(&v.toObject(), /* stopAtWindowProxy = */ false);
  JSAutoRealm reflectorRealm(cx, obj);

  JS::Rooted<JSObject*> backingObj(cx);
  bool created = false;
  if (!GetMaplikeBackingObject(cx, obj, (DOM_INSTANCE_RESERVED_SLOTS + 0), &backingObj, &created)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  if (created) {
    PreserveWrapper<mozilla::dom::MIDIInputMap>(self);
  }
  if (!JS::MapClear(cx, backingObj)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
}
bool
Delete(mozilla::dom::MIDIInputMap* self, const nsAString& aKey, ErrorResult& aRv)
{
  MOZ_ASSERT(self);
  AutoJSAPI jsapi;
  jsapi.Init();
  JSContext* cx = jsapi.cx();
  // It's safe to use UnprivilegedJunkScopeOrWorkerGlobal here because
  // all we want is to wrap into _some_ scope and then unwrap to find
  // the reflector, and wrapping has no side-effects.
  JSObject* scope = UnprivilegedJunkScopeOrWorkerGlobal(fallible);
  if (!scope) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return bool(0);
  }
  JSAutoRealm tempRealm(cx, scope);
  JS::Rooted<JS::Value> v(cx);
  if(!ToJSValue(cx, self, &v)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return bool(0);
  }
  // This is a reflector, but due to trying to name things
  // similarly across method generators, it's called obj here.
  JS::Rooted<JSObject*> obj(cx);
  obj = js::UncheckedUnwrap(&v.toObject(), /* stopAtWindowProxy = */ false);
  JSAutoRealm reflectorRealm(cx, obj);
  JS::RootedVector<JS::Value> argv(cx);
  if (!argv.resize(1)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return bool(0);
  }
  do {
    if (!xpc::NonVoidStringToJsval(cx, aKey, argv[0])) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return bool(0);
    }
    break;
  } while (false);

  JS::Rooted<JSObject*> backingObj(cx);
  bool created = false;
  if (!GetMaplikeBackingObject(cx, obj, (DOM_INSTANCE_RESERVED_SLOTS + 0), &backingObj, &created)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return bool(0);
  }
  if (created) {
    PreserveWrapper<mozilla::dom::MIDIInputMap>(self);
  }
  bool retVal;
  if (!JS::MapDelete(cx, backingObj, argv[0], &retVal)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return bool(0);
  }
  return retVal;
}
bool
Has(mozilla::dom::MIDIInputMap* self, const nsAString& aKey, ErrorResult& aRv)
{
  MOZ_ASSERT(self);
  AutoJSAPI jsapi;
  jsapi.Init();
  JSContext* cx = jsapi.cx();
  // It's safe to use UnprivilegedJunkScopeOrWorkerGlobal here because
  // all we want is to wrap into _some_ scope and then unwrap to find
  // the reflector, and wrapping has no side-effects.
  JSObject* scope = UnprivilegedJunkScopeOrWorkerGlobal(fallible);
  if (!scope) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return bool(0);
  }
  JSAutoRealm tempRealm(cx, scope);
  JS::Rooted<JS::Value> v(cx);
  if(!ToJSValue(cx, self, &v)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return bool(0);
  }
  // This is a reflector, but due to trying to name things
  // similarly across method generators, it's called obj here.
  JS::Rooted<JSObject*> obj(cx);
  obj = js::UncheckedUnwrap(&v.toObject(), /* stopAtWindowProxy = */ false);
  JSAutoRealm reflectorRealm(cx, obj);
  JS::RootedVector<JS::Value> argv(cx);
  if (!argv.resize(1)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return bool(0);
  }
  do {
    if (!xpc::NonVoidStringToJsval(cx, aKey, argv[0])) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return bool(0);
    }
    break;
  } while (false);

  JS::Rooted<JSObject*> backingObj(cx);
  bool created = false;
  if (!GetMaplikeBackingObject(cx, obj, (DOM_INSTANCE_RESERVED_SLOTS + 0), &backingObj, &created)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return bool(0);
  }
  if (created) {
    PreserveWrapper<mozilla::dom::MIDIInputMap>(self);
  }
  bool retVal;
  if (!JS::MapHas(cx, backingObj, argv[0], &retVal)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return bool(0);
  }
  return retVal;
}
void
Set(mozilla::dom::MIDIInputMap* self, const nsAString& aKey, MIDIInput& aValue, ErrorResult& aRv)
{
  MOZ_ASSERT(self);
  AutoJSAPI jsapi;
  jsapi.Init();
  JSContext* cx = jsapi.cx();
  // It's safe to use UnprivilegedJunkScopeOrWorkerGlobal here because
  // all we want is to wrap into _some_ scope and then unwrap to find
  // the reflector, and wrapping has no side-effects.
  JSObject* scope = UnprivilegedJunkScopeOrWorkerGlobal(fallible);
  if (!scope) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  JSAutoRealm tempRealm(cx, scope);
  JS::Rooted<JS::Value> v(cx);
  if(!ToJSValue(cx, self, &v)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  // This is a reflector, but due to trying to name things
  // similarly across method generators, it's called obj here.
  JS::Rooted<JSObject*> obj(cx);
  obj = js::UncheckedUnwrap(&v.toObject(), /* stopAtWindowProxy = */ false);
  JSAutoRealm reflectorRealm(cx, obj);
  JS::RootedVector<JS::Value> argv(cx);
  if (!argv.resize(2)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  do {
    if (!GetOrCreateDOMReflector(cx, aValue, argv[1])) {
      MOZ_ASSERT(JS_IsExceptionPending(cx));
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    break;
  } while (false);

  do {
    if (!xpc::NonVoidStringToJsval(cx, aKey, argv[0])) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    break;
  } while (false);

  JS::Rooted<JSObject*> backingObj(cx);
  bool created = false;
  if (!GetMaplikeBackingObject(cx, obj, (DOM_INSTANCE_RESERVED_SLOTS + 0), &backingObj, &created)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  if (created) {
    PreserveWrapper<mozilla::dom::MIDIInputMap>(self);
  }
  if (!JS::MapSet(cx, backingObj, argv[0], argv[1])) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
}
already_AddRefed<MIDIInput>
Get(mozilla::dom::MIDIInputMap* self, const nsAString& aKey, ErrorResult& aRv)
{
  MOZ_ASSERT(self);
  AutoJSAPI jsapi;
  jsapi.Init();
  JSContext* cx = jsapi.cx();
  // It's safe to use UnprivilegedJunkScopeOrWorkerGlobal here because
  // all we want is to wrap into _some_ scope and then unwrap to find
  // the reflector, and wrapping has no side-effects.
  JSObject* scope = UnprivilegedJunkScopeOrWorkerGlobal(fallible);
  if (!scope) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return nullptr;
  }
  JSAutoRealm tempRealm(cx, scope);
  JS::Rooted<JS::Value> v(cx);
  if(!ToJSValue(cx, self, &v)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return nullptr;
  }
  // This is a reflector, but due to trying to name things
  // similarly across method generators, it's called obj here.
  JS::Rooted<JSObject*> obj(cx);
  obj = js::UncheckedUnwrap(&v.toObject(), /* stopAtWindowProxy = */ false);
  JSAutoRealm reflectorRealm(cx, obj);
  JS::RootedVector<JS::Value> argv(cx);
  if (!argv.resize(1)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return nullptr;
  }
  do {
    if (!xpc::NonVoidStringToJsval(cx, aKey, argv[0])) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }
    break;
  } while (false);

  JS::Rooted<JSObject*> backingObj(cx);
  bool created = false;
  if (!GetMaplikeBackingObject(cx, obj, (DOM_INSTANCE_RESERVED_SLOTS + 0), &backingObj, &created)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return nullptr;
  }
  if (created) {
    PreserveWrapper<mozilla::dom::MIDIInputMap>(self);
  }
  JS::Rooted<JS::Value> result(cx);
  if (!JS::MapGet(cx, backingObj, argv[0], &result)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return nullptr;
  }
  if (result.isUndefined()) {
    aRv.Throw(NS_ERROR_NOT_AVAILABLE);
    return nullptr;
  }
  RefPtr<mozilla::dom::MIDIInput> rvalDecl;
  static_assert(IsRefcounted<mozilla::dom::MIDIInput>::value, "We can only store refcounted classes.");
  {
    // Our JSContext should be in the right global to do unwrapping in.
    nsresult rv = UnwrapObject<prototypes::id::MIDIInput, mozilla::dom::MIDIInput>(result, rvalDecl, cx);
    if (NS_FAILED(rv)) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }
  }
  return rvalDecl.forget();
}
} // namespace MaplikeHelpers

MOZ_CAN_RUN_SCRIPT static bool
get_size(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "MIDIInputMap", "size", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::MIDIInputMap*>(void_self);
  JS::Rooted<JSObject*> backingObj(cx);
  bool created = false;
  if (!GetMaplikeBackingObject(cx, obj, (DOM_INSTANCE_RESERVED_SLOTS + 0), &backingObj, &created)) {
    return false;
  }
  if (created) {
    PreserveWrapper<mozilla::dom::MIDIInputMap>(self);
  }
  uint32_t result = JS::MapSize(cx, backingObj);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setNumber(result);
  return true;
}

static const JSJitInfo size_getterinfo = {
  { get_size },
  { prototypes::id::MIDIInputMap },
  { PrototypeTraits<prototypes::id::MIDIInputMap>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_DOUBLE,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
entries(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "MIDIInputMap", "entries", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::MIDIInputMap*>(void_self);
  JS::Rooted<JSObject*> backingObj(cx);
  bool created = false;
  if (!GetMaplikeBackingObject(cx, obj, (DOM_INSTANCE_RESERVED_SLOTS + 0), &backingObj, &created)) {
    return false;
  }
  if (created) {
    PreserveWrapper<mozilla::dom::MIDIInputMap>(self);
  }
  // TODO (Bug 1173651): Xrays currently cannot wrap iterators. Change
  // after bug 1023984 is fixed.
  if (xpc::WrapperFactory::IsXrayWrapper(obj)) {
    JS_ReportErrorASCII(cx, "Xray wrapping of iterators not supported.");
    return false;
  }
  JS::Rooted<JSObject*> result(cx);
  JS::Rooted<JS::Value> v(cx);
  if (!JS::MapEntries(cx, backingObj, &v)) {
    return false;
  }
  result = &v.toObject();
  JS::ExposeObjectToActiveJS(result);
  args.rval().setObject(*result);
  if (!MaybeWrapObjectValue(cx, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo::ArgType entries_methodinfo_argTypes[] = { JSJitInfo::ArgTypeListEnd };
static const JSTypedMethodJitInfo entries_methodinfo = {
  {
    { (JSJitGetterOp)entries },
    { prototypes::id::MIDIInputMap },
    { PrototypeTraits<prototypes::id::MIDIInputMap>::Depth },
    JSJitInfo::Method,
    JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
    JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
    false,  /* isInfallible. False in setters. */
    false,  /* isMovable.  Not relevant for setters. */
    false, /* isEliminatable.  Not relevant for setters. */
    false, /* isAlwaysInSlot.  Only relevant for getters. */
    false, /* isLazilyCachedInSlot.  Only relevant for getters. */
    true,  /* isTypedMethod.  Only relevant for methods. */
    0   /* Reserved slot index, if we're stored in a slot, else 0. */
  },
  entries_methodinfo_argTypes
};

MOZ_CAN_RUN_SCRIPT static bool
keys(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "MIDIInputMap", "keys", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::MIDIInputMap*>(void_self);
  JS::Rooted<JSObject*> backingObj(cx);
  bool created = false;
  if (!GetMaplikeBackingObject(cx, obj, (DOM_INSTANCE_RESERVED_SLOTS + 0), &backingObj, &created)) {
    return false;
  }
  if (created) {
    PreserveWrapper<mozilla::dom::MIDIInputMap>(self);
  }
  // TODO (Bug 1173651): Xrays currently cannot wrap iterators. Change
  // after bug 1023984 is fixed.
  if (xpc::WrapperFactory::IsXrayWrapper(obj)) {
    JS_ReportErrorASCII(cx, "Xray wrapping of iterators not supported.");
    return false;
  }
  JS::Rooted<JSObject*> result(cx);
  JS::Rooted<JS::Value> v(cx);
  if (!JS::MapKeys(cx, backingObj, &v)) {
    return false;
  }
  result = &v.toObject();
  JS::ExposeObjectToActiveJS(result);
  args.rval().setObject(*result);
  if (!MaybeWrapObjectValue(cx, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo::ArgType keys_methodinfo_argTypes[] = { JSJitInfo::ArgTypeListEnd };
static const JSTypedMethodJitInfo keys_methodinfo = {
  {
    { (JSJitGetterOp)keys },
    { prototypes::id::MIDIInputMap },
    { PrototypeTraits<prototypes::id::MIDIInputMap>::Depth },
    JSJitInfo::Method,
    JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
    JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
    false,  /* isInfallible. False in setters. */
    false,  /* isMovable.  Not relevant for setters. */
    false, /* isEliminatable.  Not relevant for setters. */
    false, /* isAlwaysInSlot.  Only relevant for getters. */
    false, /* isLazilyCachedInSlot.  Only relevant for getters. */
    true,  /* isTypedMethod.  Only relevant for methods. */
    0   /* Reserved slot index, if we're stored in a slot, else 0. */
  },
  keys_methodinfo_argTypes
};

MOZ_CAN_RUN_SCRIPT static bool
values(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "MIDIInputMap", "values", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::MIDIInputMap*>(void_self);
  JS::Rooted<JSObject*> backingObj(cx);
  bool created = false;
  if (!GetMaplikeBackingObject(cx, obj, (DOM_INSTANCE_RESERVED_SLOTS + 0), &backingObj, &created)) {
    return false;
  }
  if (created) {
    PreserveWrapper<mozilla::dom::MIDIInputMap>(self);
  }
  // TODO (Bug 1173651): Xrays currently cannot wrap iterators. Change
  // after bug 1023984 is fixed.
  if (xpc::WrapperFactory::IsXrayWrapper(obj)) {
    JS_ReportErrorASCII(cx, "Xray wrapping of iterators not supported.");
    return false;
  }
  JS::Rooted<JSObject*> result(cx);
  JS::Rooted<JS::Value> v(cx);
  if (!JS::MapValues(cx, backingObj, &v)) {
    return false;
  }
  result = &v.toObject();
  JS::ExposeObjectToActiveJS(result);
  args.rval().setObject(*result);
  if (!MaybeWrapObjectValue(cx, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo::ArgType values_methodinfo_argTypes[] = { JSJitInfo::ArgTypeListEnd };
static const JSTypedMethodJitInfo values_methodinfo = {
  {
    { (JSJitGetterOp)values },
    { prototypes::id::MIDIInputMap },
    { PrototypeTraits<prototypes::id::MIDIInputMap>::Depth },
    JSJitInfo::Method,
    JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
    JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
    false,  /* isInfallible. False in setters. */
    false,  /* isMovable.  Not relevant for setters. */
    false, /* isEliminatable.  Not relevant for setters. */
    false, /* isAlwaysInSlot.  Only relevant for getters. */
    false, /* isLazilyCachedInSlot.  Only relevant for getters. */
    true,  /* isTypedMethod.  Only relevant for methods. */
    0   /* Reserved slot index, if we're stored in a slot, else 0. */
  },
  values_methodinfo_argTypes
};

MOZ_CAN_RUN_SCRIPT static bool
forEach(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "MIDIInputMap.forEach");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "MIDIInputMap", "forEach", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::MIDIInputMap*>(void_self);
  JS::Rooted<JSObject*> arg0(cx);
  if (args.get(0).isObject()) {
    arg0 = &args.get(0).toObject();
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  JS::Rooted<JS::Value> arg1(cx);
  if (args.hasDefined(1)) {
    arg1 = args.get(1);
  } else {
    arg1 = JS::UndefinedValue();
  }
  JS::Rooted<JSObject*> backingObj(cx);
  bool created = false;
  if (!GetMaplikeBackingObject(cx, obj, (DOM_INSTANCE_RESERVED_SLOTS + 0), &backingObj, &created)) {
    return false;
  }
  if (created) {
    PreserveWrapper<mozilla::dom::MIDIInputMap>(self);
  }
  // Create a wrapper function.
  JSFunction* func = js::NewFunctionWithReserved(cx, ForEachHandler, 3, 0, nullptr);
  if (!func) {
    return false;
  }
  JS::Rooted<JSObject*> funcObj(cx, JS_GetFunctionObject(func));
  JS::Rooted<JS::Value> funcVal(cx, JS::ObjectValue(*funcObj));
  js::SetFunctionNativeReserved(funcObj, FOREACH_CALLBACK_SLOT,
                                JS::ObjectValue(*arg0));
  js::SetFunctionNativeReserved(funcObj, FOREACH_MAPLIKEORSETLIKEOBJ_SLOT,
                                JS::ObjectValue(*obj));
  if (!JS::MapForEach(cx, backingObj, funcVal, arg1)) {
    return false;
  }
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo forEach_methodinfo = {
  { (JSJitGetterOp)forEach },
  { prototypes::id::MIDIInputMap },
  { PrototypeTraits<prototypes::id::MIDIInputMap>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
has(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "MIDIInputMap", "has", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::MIDIInputMap*>(void_self);
  binding_detail::FakeString<char16_t> arg0;
  if (!ConvertJSValueToString(cx, args.get(0), eStringify, eStringify, arg0)) {
    return false;
  }
  JS::Rooted<JSObject*> backingObj(cx);
  bool created = false;
  if (!GetMaplikeBackingObject(cx, obj, (DOM_INSTANCE_RESERVED_SLOTS + 0), &backingObj, &created)) {
    return false;
  }
  if (created) {
    PreserveWrapper<mozilla::dom::MIDIInputMap>(self);
  }
  JS::Rooted<JS::Value> arg0Val(cx);
  if (!ToJSValue(cx, arg0, &arg0Val)) {
    return false;
  }
  bool result;
  if (!JS::MapHas(cx, backingObj, arg0Val, &result)) {
    return false;
  }
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo::ArgType has_methodinfo_argTypes[] = { JSJitInfo::String, JSJitInfo::ArgTypeListEnd };
static const JSTypedMethodJitInfo has_methodinfo = {
  {
    { (JSJitGetterOp)has },
    { prototypes::id::MIDIInputMap },
    { PrototypeTraits<prototypes::id::MIDIInputMap>::Depth },
    JSJitInfo::Method,
    JSJitInfo::AliasDOMSets, /* aliasSet.  Not relevant for setters. */
    JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
    false,  /* isInfallible. False in setters. */
    false,  /* isMovable.  Not relevant for setters. */
    false, /* isEliminatable.  Not relevant for setters. */
    false, /* isAlwaysInSlot.  Only relevant for getters. */
    false, /* isLazilyCachedInSlot.  Only relevant for getters. */
    true,  /* isTypedMethod.  Only relevant for methods. */
    0   /* Reserved slot index, if we're stored in a slot, else 0. */
  },
  has_methodinfo_argTypes
};

MOZ_CAN_RUN_SCRIPT static bool
get(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "MIDIInputMap", "get", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::MIDIInputMap*>(void_self);
  binding_detail::FakeString<char16_t> arg0;
  if (!ConvertJSValueToString(cx, args.get(0), eStringify, eStringify, arg0)) {
    return false;
  }
  JS::Rooted<JSObject*> backingObj(cx);
  bool created = false;
  if (!GetMaplikeBackingObject(cx, obj, (DOM_INSTANCE_RESERVED_SLOTS + 0), &backingObj, &created)) {
    return false;
  }
  if (created) {
    PreserveWrapper<mozilla::dom::MIDIInputMap>(self);
  }
  JS::Rooted<JS::Value> arg0Val(cx);
  if (!ToJSValue(cx, arg0, &arg0Val)) {
    return false;
  }
  JS::Rooted<JS::Value> result(cx);
  if (!JS::MapGet(cx, backingObj, arg0Val, &result)) {
    return false;
  }
  JS::ExposeValueToActiveJS(result);
  args.rval().set(result);
  if (!MaybeWrapValue(cx, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo::ArgType get_methodinfo_argTypes[] = { JSJitInfo::String, JSJitInfo::ArgTypeListEnd };
static const JSTypedMethodJitInfo get_methodinfo = {
  {
    { (JSJitGetterOp)get },
    { prototypes::id::MIDIInputMap },
    { PrototypeTraits<prototypes::id::MIDIInputMap>::Depth },
    JSJitInfo::Method,
    JSJitInfo::AliasDOMSets, /* aliasSet.  Not relevant for setters. */
    JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
    false,  /* isInfallible. False in setters. */
    false,  /* isMovable.  Not relevant for setters. */
    false, /* isEliminatable.  Not relevant for setters. */
    false, /* isAlwaysInSlot.  Only relevant for getters. */
    false, /* isLazilyCachedInSlot.  Only relevant for getters. */
    true,  /* isTypedMethod.  Only relevant for methods. */
    0   /* Reserved slot index, if we're stored in a slot, else 0. */
  },
  get_methodinfo_argTypes
};

static void
_finalize(JS::GCContext* gcx, JSObject* obj)
{
  mozilla::dom::MIDIInputMap* self = UnwrapPossiblyNotInitializedDOMObject<mozilla::dom::MIDIInputMap>(obj);
  if (self) {
    JS::SetReservedSlot(obj, DOM_OBJECT_SLOT, JS::UndefinedValue());
    ClearWrapper(self, self, obj);
    if (size_t mallocBytes = BindingJSObjectMallocBytes(self)) {
      JS::RemoveAssociatedMemory(obj, mallocBytes,
                                 JS::MemoryUse::DOMBinding);
    }
    AddForDeferredFinalization<mozilla::dom::MIDIInputMap>(self);
  }
}

MOZ_GLOBINIT static const JSFunctionSpec sMethods_specs[] = {
  JS_FNSPEC("entries", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&entries_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("keys", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&keys_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("values", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&values_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("forEach", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&forEach_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("has", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&has_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("get", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&get_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FS_END
};


static const Prefable<const JSFunctionSpec> sMethods[] = {
  { nullptr, &sMethods_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(6 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");

MOZ_GLOBINIT static const JSPropertySpec sAttributes_specs[] = {
  JSPropertySpec::nativeAccessors("size", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &size_getterinfo, nullptr, nullptr),
  JS_PS_END
};


static const Prefable<const JSPropertySpec> sAttributes[] = {
  { nullptr, &sAttributes_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");


static uint16_t sNativeProperties_sortedPropertyIndices[7];
static PropertyInfo sNativeProperties_propertyInfos[7];

static const NativePropertiesN<2> sNativeProperties = {
  false, 0,
  false, 0,
  true,  0 /* sMethods */,
  true,  1 /* sAttributes */,
  false, 0,
  false, 0,
  false, 0,
  0,
  7,
  sNativeProperties_sortedPropertyIndices,
  {
    { sMethods, &sNativeProperties_propertyInfos[0] },
    { sAttributes, &sNativeProperties_propertyInfos[6] }
  }
};
static_assert(7 < 1ull << (CHAR_BIT * sizeof(sNativeProperties.propertyInfoCount)),
    "We have a property info count that is oversized");

// This may allocate too many slots, because we only really need
// slots for our non-interface-typed members that we cache.  But
// allocating slots only for those would make the slot index
// computations much more complicated, so let's do this the simple
// way for now.
DEFINE_XRAY_EXPANDO_CLASS_WITH_OPS(static, sXrayExpandoObjectClass, 1,
                                   &xpc::XrayExpandoObjectClassOps);

bool sNativePropertiesInited = false;
const NativePropertyHooks sNativePropertyHooks = {
  nullptr,
  { sNativeProperties.Upcast(), nullptr, &sNativePropertiesInited },
  prototypes::id::MIDIInputMap,
  constructors::id::MIDIInputMap,
  &sXrayExpandoObjectClass
};

static const DOMInterfaceInfo sInterfaceObjectInfo = {
  { ThrowingConstructor, &sNativePropertyHooks },
  JS::GetRealmFunctionPrototypeHandle,
  PrototypeTraits<prototypes::id::MIDIInputMap>::Depth,
  prototypes::id::MIDIInputMap,
  true,
  0,
  "MIDIInputMap",
};

static const DOMIfaceAndProtoJSClass sPrototypeClass = {
  {
    "MIDIInputMapPrototype",
    JSCLASS_IS_DOMIFACEANDPROTOJSCLASS | JSCLASS_HAS_RESERVED_SLOTS(DOM_INTERFACE_PROTO_SLOTS_BASE),
    JS_NULL_CLASS_OPS,
    JS_NULL_CLASS_SPEC,
    JS_NULL_CLASS_EXT,
    JS_NULL_OBJECT_OPS
  },
  eInterfacePrototype,
  prototypes::id::MIDIInputMap,
  PrototypeTraits<prototypes::id::MIDIInputMap>::Depth,
  &sNativePropertyHooks,
  JS::GetRealmObjectPrototype
};

bool
ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj)
{
  return StaticPrefs::dom_webmidi_enabled() &&
         mozilla::dom::IsSecureContextOrObjectIsFromSecureContext(aCx, aObj);
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx);

static const JSClassOps sClassOps = {
  nullptr,               /* addProperty */
  nullptr,               /* delProperty */
  nullptr,               /* enumerate */
  nullptr, /* newEnumerate */
  nullptr, /* resolve */
  nullptr, /* mayResolve */
  _finalize, /* finalize */
  nullptr, /* call */
  nullptr,               /* construct */
  nullptr, /* trace */
};

static const DOMJSClass sClass = {
  { "MIDIInputMap",
    JSCLASS_IS_DOMJSCLASS | JSCLASS_FOREGROUND_FINALIZE | JSCLASS_HAS_RESERVED_SLOTS(2) | JSCLASS_PRESERVES_WRAPPER,
    &sClassOps,
    JS_NULL_CLASS_SPEC,
    &NativeTypeHelpers<mozilla::dom::MIDIInputMap>::sClassExtension,
    JS_NULL_OBJECT_OPS
  },
  { prototypes::id::MIDIInputMap, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count },
  std::is_base_of_v<nsISupports, mozilla::dom::MIDIInputMap>,
  &sNativePropertyHooks,
  FindAssociatedGlobalForNative<mozilla::dom::MIDIInputMap>::Get,
  GetProtoObjectHandle,
  GetCCParticipant<mozilla::dom::MIDIInputMap>::Get(),
  nullptr,
  NativeTypeHelpers<mozilla::dom::MIDIInputMap>::GetWrapperCache
};
static_assert(1 == DOM_INSTANCE_RESERVED_SLOTS,
              "Must have the right minimal number of reserved slots.");
static_assert(2 >= 2,
              "Must have enough reserved slots.");

bool
Wrap(JSContext* aCx, mozilla::dom::MIDIInputMap* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector)
{
  static_assert(!std::is_base_of_v<NonRefcountedDOMObject, mozilla::dom::MIDIInputMap>,
                "Shouldn't have wrappercached things that are not refcounted.");
  static_assert(std::is_same_v<decltype(aObject), mozilla::dom::MIDIInputMap*>);
  MOZ_ASSERT(ToSupportsIsCorrect(aObject));
  MOZ_ASSERT_IF(aGivenProto, js::IsObjectInContextCompartment(aGivenProto, aCx));
  MOZ_ASSERT(!aCache->GetWrapper(),
             "You should probably not be using Wrap() directly; use "
             "GetOrCreateDOMReflector instead");

  MOZ_ASSERT(ToSupportsIsOnPrimaryInheritanceChain(aObject, aCache),
             "nsISupports must be on our primary inheritance chain");

  // If the wrapper cache contains a dead reflector then finalize that
  // now, ensuring that the finalizer for the old reflector always
  // runs before the new reflector is created and attached. This
  // avoids the awkward situation where there are multiple reflector
  // objects that contain pointers to the same native.

  if (JSObject* oldReflector = aCache->GetWrapperMaybeDead()) {
    _finalize(nullptr /* unused */, oldReflector);
    MOZ_ASSERT(!aCache->GetWrapperMaybeDead());
  }

  JS::Rooted<JSObject*> global(aCx, FindAssociatedGlobal(aCx, aObject->GetParentObject()));
  if (!global) {
    return false;
  }
  MOZ_ASSERT(JS_IsGlobalObject(global));
  JS::AssertObjectIsNotGray(global);

  // That might have ended up wrapping us already, due to the wonders
  // of XBL.  Check for that, and bail out as needed.
  aReflector.set(aCache->GetWrapper());
  if (aReflector) {
#ifdef DEBUG
    AssertReflectorHasGivenProto(aCx, aReflector, aGivenProto);
#endif // DEBUG
    return true;
  }

  JSAutoRealm ar(aCx, global);
  JS::Handle<JSObject*> canonicalProto = GetProtoObjectHandle(aCx);
  if (!canonicalProto) {
    return false;
  }
  JS::Rooted<JSObject*> proto(aCx);
  if (aGivenProto) {
    proto = aGivenProto;
    // Unfortunately, while aGivenProto was in the compartment of aCx
    // coming in, we changed compartments to that of "parent" so may need
    // to wrap the proto here.
    if (js::GetContextCompartment(aCx) != JS::GetCompartment(proto)) {
      if (!JS_WrapObject(aCx, &proto)) {
        return false;
      }
    }
  } else {
    proto = canonicalProto;
  }

  BindingJSObjectCreator<mozilla::dom::MIDIInputMap> creator(aCx);
  creator.CreateObject(aCx, sClass.ToJSClass(), proto, aObject, aReflector);
  if (!aReflector) {
    return false;
  }

  aCache->SetWrapper(aReflector);
  creator.InitializationSucceeded();

  MOZ_ASSERT(aCache->GetWrapperPreserveColor() &&
             aCache->GetWrapperPreserveColor() == aReflector);
  // If proto != canonicalProto, we have to preserve our wrapper;
  // otherwise we won't be able to properly recreate it later, since
  // we won't know what proto to use.  Note that we don't check
  // aGivenProto here, since it's entirely possible (and even
  // somewhat common) to have a non-null aGivenProto which is the
  // same as canonicalProto.
  if (proto != canonicalProto) {
    PreserveWrapper(aObject);
  }

  return true;
}

void
CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal)
{
  JS::Heap<JSObject*>* protoCache = &aProtoAndIfaceCache.EntrySlotOrCreate(prototypes::id::MIDIInputMap);
  JS::Heap<JSObject*>* interfaceCache = &aProtoAndIfaceCache.EntrySlotOrCreate(constructors::id::MIDIInputMap);

  JS::Handle<JSObject*> parentProto(JS::GetRealmObjectPrototypeHandle(aCx));
  if (!parentProto) {
    return;
  }

  JS::Handle<JSObject*> constructorProto(JS::GetRealmFunctionPrototypeHandle(aCx));
  if (!constructorProto) {
    return;
  }

  dom::CreateInterfaceObjects(aCx, aGlobal, parentProto,
                              &sPrototypeClass, protoCache,
                              constructorProto, &sInterfaceObjectInfo, 0, false, Span<const LegacyFactoryFunction, 0>{},
                              interfaceCache,
                              sNativeProperties.Upcast(),
                              nullptr,
                              "MIDIInputMap",
                              ShouldExpose<MIDIInputMap_Binding::ConstructorEnabled>(aCx, aGlobal, aDefineOnGlobal),
                              nullptr,
                              false,
                              nullptr);

  JS::AssertObjectIsNotGray(*protoCache);
  JS::Handle<JSObject*> proto = JS::Handle<JSObject*>::fromMarkedLocation(protoCache->unsafeAddress());
  if (!proto) {
    *protoCache = nullptr;
    if (interfaceCache) {
      *interfaceCache = nullptr;
    }
    return;
  }

  // Set up aliases on the interface prototype object we just created.
  JS::Rooted<JS::Value> aliasedVal(aCx);

  if (!JS_GetProperty(aCx, proto, "entries", &aliasedVal)) {
    *protoCache = nullptr;
    if (interfaceCache) {
      *interfaceCache = nullptr;
    }
    return;
  }
  JS::Rooted<jsid> iteratorId(aCx, JS::GetWellKnownSymbolKey(aCx, JS::SymbolCode::iterator));
  if (!JS_DefinePropertyById(aCx, proto, iteratorId, aliasedVal, 0)) {
    *protoCache = nullptr;
    if (interfaceCache) {
      *interfaceCache = nullptr;
    }
    return;
  }
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx)
{
  /* Get the interface prototype object for this class.  This will create the
     object as needed. */
  return GetPerInterfaceObjectHandle(aCx, prototypes::id::MIDIInputMap,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);

}

JS::Handle<JSObject*>
GetConstructorObjectHandle(JSContext* aCx)
{
  /* Get the interface object for this class.  This will create the object as
     needed. */

  return GetPerInterfaceObjectHandle(aCx, constructors::id::MIDIInputMap,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);
}

} // namespace MIDIInputMap_Binding



} // namespace mozilla::dom
