/* THIS FILE IS AUTOGENERATED FROM WebGL2RenderingContext.webidl BY Codegen.py - DO NOT EDIT */

#include <type_traits>
#include "BufferSourceBinding.h"
#include "ClientWebGLContext.h"
#include "ClientWebGLExtensions.h"
#include "MainThreadUtils.h"
#include "WebGL2RenderingContextBinding.h"
#include "WebGLRenderingContextBinding.h"
#include "WrapperFactory.h"
#include "js/Array.h"
#include "js/CallAndConstruct.h"
#include "js/Exception.h"
#include "js/ForOfIterator.h"
#include "js/MapAndSet.h"
#include "js/Object.h"
#include "js/PropertyAndElement.h"
#include "js/PropertyDescriptor.h"
#include "js/experimental/JitInfo.h"
#include "jsfriendapi.h"
#include "mozilla/Atomics.h"
#include "mozilla/OwningNonNull.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/StaticPrefs_webgl.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/DOMJSClass.h"
#include "mozilla/dom/HTMLCanvasElement.h"
#include "mozilla/dom/HTMLImageElement.h"
#include "mozilla/dom/HTMLVideoElement.h"
#include "mozilla/dom/ImageBitmap.h"
#include "mozilla/dom/ImageData.h"
#include "mozilla/dom/NonRefcountedDOMObject.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/OffscreenCanvas.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/Promise.h"
#include "mozilla/dom/ToJSValue.h"
#include "mozilla/dom/TypedArray.h"
#include "mozilla/dom/UnionTypes.h"
#include "mozilla/dom/VideoFrame.h"
#include "mozilla/dom/WebIDLPrefs.h"
#include "mozilla/dom/XrayExpandoClass.h"
#include "nsContentUtils.h"

namespace mozilla::dom {

namespace binding_detail {}; // Just to make sure it's known as a namespace
using namespace mozilla::dom::binding_detail;


bool
MaybeSharedUint32ArrayOrUnsignedLongSequence::TrySetToUint32Array(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    RootedSpiderMonkeyInterface<Uint32Array>& memberSlot = RawSetAsUint32Array(cx);
    if (!memberSlot.Init(&value.toObject())) {
      DestroyUint32Array();
      tryNext = true;
      return true;
    }
    if (JS::IsLargeArrayBufferView(memberSlot.Obj())) {
      cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_LARGE>("Uint32Array branch of (Uint32Array or sequence<unsigned long>)");
      return false;
    }
    if (JS::IsResizableArrayBufferView(memberSlot.Obj())) {
      cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_RESIZABLE>("Uint32Array branch of (Uint32Array or sequence<unsigned long>)");
      return false;
    }
    if (JS::IsImmutableArrayBufferView(memberSlot.Obj())) {
      cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_IMMUTABLE>("Uint32Array branch of (Uint32Array or sequence<unsigned long>)");
      return false;
    }
  }
  return true;
}

bool
MaybeSharedUint32ArrayOrUnsignedLongSequence::TrySetToUint32Array(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToUint32Array(cx, value, tryNext, passedToJSImpl);
}







bool
MaybeSharedUint32ArrayOrUnsignedLongSequence::TrySetToUnsignedLongSequence(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    binding_detail::AutoSequence<uint32_t>& memberSlot = RawSetAsUnsignedLongSequence();
    JS::ForOfIterator iter(cx);
    if (!iter.init(value, JS::ForOfIterator::AllowNonIterable)) {
      return false;
    }
    if (!iter.valueIsIterable()) {
      DestroyUnsignedLongSequence();
      tryNext = true;
      return true;
    }
    binding_detail::AutoSequence<uint32_t> &arr = memberSlot;
    JS::Rooted<JS::Value> temp(cx);
    while (true) {
      bool done;
      if (!iter.next(&temp, &done)) {
        return false;
      }
      if (done) {
        break;
      }
      uint32_t* slotPtr = arr.AppendElement(mozilla::fallible);
      if (!slotPtr) {
        JS_ReportOutOfMemory(cx);
        return false;
      }
      uint32_t& slot = *slotPtr;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, temp, "Element of sequence<unsigned long> branch of (Uint32Array or sequence<unsigned long>)", &slot)) {
        return false;
      }
    }
  }
  return true;
}

bool
MaybeSharedUint32ArrayOrUnsignedLongSequence::TrySetToUnsignedLongSequence(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToUnsignedLongSequence(cx, value, tryNext, passedToJSImpl);
}







bool
MaybeSharedUint32ArrayOrUnsignedLongSequence::Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  MOZ_ASSERT(mType == eUninitialized);

  bool done = false, failed = false, tryNext;
  if (value.isObject()) {
    done = (failed = !TrySetToUint32Array(cx, value, tryNext, passedToJSImpl)) || !tryNext;
    if (!done) {
      done = (failed = !TrySetToUnsignedLongSequence(cx, value, tryNext, passedToJSImpl)) || !tryNext;
    }
  }
  if (failed) {
    return false;
  }
  if (!done) {
    cx.ThrowErrorMessage<MSG_NOT_IN_UNION>(sourceDescription, "Uint32Array, sequence<unsigned long>");
    return false;
  }
  return true;
}

bool
MaybeSharedUint32ArrayOrUnsignedLongSequence::Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, value, sourceDescription, passedToJSImpl);
}


bool
MaybeSharedUint32ArrayOrUnsignedLongSequence::ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const
{
  switch (mType) {
    case eUninitialized: {
      return false;
    }
    case eUint32Array: {
      rval.setObject(*mValue.mUint32Array.Value().Obj());
      if (!MaybeWrapNonDOMObjectValue(cx, rval)) {
        return false;
      }
      return true;
    }
    case eUnsignedLongSequence: {

      uint32_t length = mValue.mUnsignedLongSequence.Value().Length();
      JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
      if (!returnArray) {
        return false;
      }
      // Scope for 'tmp'
      {
        JS::Rooted<JS::Value> tmp(cx);
        for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
          // Control block to let us common up the JS_DefineElement calls when there
          // are different ways to succeed at wrapping the object.
          do {
            tmp.setNumber(mValue.mUnsignedLongSequence.Value()[sequenceIdx0]);
            break;
          } while (false);
          if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                                JSPROP_ENUMERATE)) {
            return false;
          }
        }
      }
      rval.setObject(*returnArray);
      return true;
    }
    default: {
      return false;
    }
  }
}



OwningMaybeSharedUint32ArrayOrUnsignedLongSequence::OwningMaybeSharedUint32ArrayOrUnsignedLongSequence(OwningMaybeSharedUint32ArrayOrUnsignedLongSequence&& aOther)
  : mType(eUninitialized)
{
  switch (aOther.mType) {
    case eUninitialized: {
      MOZ_ASSERT(mType == eUninitialized,
                 "We need to destroy ourselves?");
      break;
    }
    case eUint32Array: {
      mType = eUint32Array;
      mValue.mUint32Array.SetValue(std::move(aOther.mValue.mUint32Array.Value()));
      break;
    }
    case eUnsignedLongSequence: {
      mType = eUnsignedLongSequence;
      mValue.mUnsignedLongSequence.SetValue(std::move(aOther.mValue.mUnsignedLongSequence.Value()));
      break;
    }
  }
}


bool
OwningMaybeSharedUint32ArrayOrUnsignedLongSequence::TrySetToUint32Array(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    Uint32Array& memberSlot = RawSetAsUint32Array();
    if (!memberSlot.Init(&value.toObject())) {
      DestroyUint32Array();
      tryNext = true;
      return true;
    }
    if (JS::IsLargeArrayBufferView(memberSlot.Obj())) {
      cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_LARGE>("Uint32Array branch of (Uint32Array or sequence<unsigned long>)");
      return false;
    }
    if (JS::IsResizableArrayBufferView(memberSlot.Obj())) {
      cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_RESIZABLE>("Uint32Array branch of (Uint32Array or sequence<unsigned long>)");
      return false;
    }
    if (JS::IsImmutableArrayBufferView(memberSlot.Obj())) {
      cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_IMMUTABLE>("Uint32Array branch of (Uint32Array or sequence<unsigned long>)");
      return false;
    }
  }
  return true;
}

bool
OwningMaybeSharedUint32ArrayOrUnsignedLongSequence::TrySetToUint32Array(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToUint32Array(cx, value, tryNext, passedToJSImpl);
}

[[nodiscard]] Uint32Array&
OwningMaybeSharedUint32ArrayOrUnsignedLongSequence::RawSetAsUint32Array()
{
  if (mType == eUint32Array) {
    return mValue.mUint32Array.Value();
  }
  MOZ_ASSERT(mType == eUninitialized);
  mType = eUint32Array;
  return mValue.mUint32Array.SetValue();
}

[[nodiscard]] Uint32Array&
OwningMaybeSharedUint32ArrayOrUnsignedLongSequence::SetAsUint32Array()
{
  if (mType == eUint32Array) {
    return mValue.mUint32Array.Value();
  }
  Uninit();
  mType = eUint32Array;
  return mValue.mUint32Array.SetValue();
}


void
OwningMaybeSharedUint32ArrayOrUnsignedLongSequence::DestroyUint32Array()
{
  MOZ_RELEASE_ASSERT(IsUint32Array(), "Wrong type!");
  mValue.mUint32Array.Destroy();
  mType = eUninitialized;
}



bool
OwningMaybeSharedUint32ArrayOrUnsignedLongSequence::TrySetToUnsignedLongSequence(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    Sequence<uint32_t>& memberSlot = RawSetAsUnsignedLongSequence();
    JS::ForOfIterator iter(cx);
    if (!iter.init(value, JS::ForOfIterator::AllowNonIterable)) {
      return false;
    }
    if (!iter.valueIsIterable()) {
      DestroyUnsignedLongSequence();
      tryNext = true;
      return true;
    }
    Sequence<uint32_t> &arr = memberSlot;
    JS::Rooted<JS::Value> temp(cx);
    while (true) {
      bool done;
      if (!iter.next(&temp, &done)) {
        return false;
      }
      if (done) {
        break;
      }
      uint32_t* slotPtr = arr.AppendElement(mozilla::fallible);
      if (!slotPtr) {
        JS_ReportOutOfMemory(cx);
        return false;
      }
      uint32_t& slot = *slotPtr;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, temp, "Element of sequence<unsigned long> branch of (Uint32Array or sequence<unsigned long>)", &slot)) {
        return false;
      }
    }
  }
  return true;
}

bool
OwningMaybeSharedUint32ArrayOrUnsignedLongSequence::TrySetToUnsignedLongSequence(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToUnsignedLongSequence(cx, value, tryNext, passedToJSImpl);
}

[[nodiscard]] Sequence<uint32_t>&
OwningMaybeSharedUint32ArrayOrUnsignedLongSequence::RawSetAsUnsignedLongSequence()
{
  if (mType == eUnsignedLongSequence) {
    return mValue.mUnsignedLongSequence.Value();
  }
  MOZ_ASSERT(mType == eUninitialized);
  mType = eUnsignedLongSequence;
  return mValue.mUnsignedLongSequence.SetValue();
}

[[nodiscard]] Sequence<uint32_t>&
OwningMaybeSharedUint32ArrayOrUnsignedLongSequence::SetAsUnsignedLongSequence()
{
  if (mType == eUnsignedLongSequence) {
    return mValue.mUnsignedLongSequence.Value();
  }
  Uninit();
  mType = eUnsignedLongSequence;
  return mValue.mUnsignedLongSequence.SetValue();
}


void
OwningMaybeSharedUint32ArrayOrUnsignedLongSequence::DestroyUnsignedLongSequence()
{
  MOZ_RELEASE_ASSERT(IsUnsignedLongSequence(), "Wrong type!");
  mValue.mUnsignedLongSequence.Destroy();
  mType = eUninitialized;
}



bool
OwningMaybeSharedUint32ArrayOrUnsignedLongSequence::Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  MOZ_ASSERT(mType == eUninitialized);

  bool done = false, failed = false, tryNext;
  if (value.isObject()) {
    done = (failed = !TrySetToUint32Array(cx, value, tryNext, passedToJSImpl)) || !tryNext;
    if (!done) {
      done = (failed = !TrySetToUnsignedLongSequence(cx, value, tryNext, passedToJSImpl)) || !tryNext;
    }
  }
  if (failed) {
    return false;
  }
  if (!done) {
    cx.ThrowErrorMessage<MSG_NOT_IN_UNION>(sourceDescription, "Uint32Array, sequence<unsigned long>");
    return false;
  }
  return true;
}

bool
OwningMaybeSharedUint32ArrayOrUnsignedLongSequence::Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, value, sourceDescription, passedToJSImpl);
}

void
OwningMaybeSharedUint32ArrayOrUnsignedLongSequence::Uninit()
{
  switch (mType) {
    case eUninitialized: {
      break;
    }
    case eUint32Array: {
      DestroyUint32Array();
      break;
    }
    case eUnsignedLongSequence: {
      DestroyUnsignedLongSequence();
      break;
    }
  }
}

bool
OwningMaybeSharedUint32ArrayOrUnsignedLongSequence::ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const
{
  switch (mType) {
    case eUninitialized: {
      return false;
    }
    case eUint32Array: {
      rval.setObject(*mValue.mUint32Array.Value().Obj());
      if (!MaybeWrapNonDOMObjectValue(cx, rval)) {
        return false;
      }
      return true;
    }
    case eUnsignedLongSequence: {

      uint32_t length = mValue.mUnsignedLongSequence.Value().Length();
      JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
      if (!returnArray) {
        return false;
      }
      // Scope for 'tmp'
      {
        JS::Rooted<JS::Value> tmp(cx);
        for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
          // Control block to let us common up the JS_DefineElement calls when there
          // are different ways to succeed at wrapping the object.
          do {
            tmp.setNumber(mValue.mUnsignedLongSequence.Value()[sequenceIdx0]);
            break;
          } while (false);
          if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                                JSPROP_ENUMERATE)) {
            return false;
          }
        }
      }
      rval.setObject(*returnArray);
      return true;
    }
    default: {
      return false;
    }
  }
}

void
OwningMaybeSharedUint32ArrayOrUnsignedLongSequence::TraceUnion(JSTracer* trc)
{
  switch (mType) {
    case eUint32Array: {
      mValue.mUint32Array.Value().TraceSelf(trc);
      break;
    }
    default: {
    }
  }
}

OwningMaybeSharedUint32ArrayOrUnsignedLongSequence&
OwningMaybeSharedUint32ArrayOrUnsignedLongSequence::operator=(OwningMaybeSharedUint32ArrayOrUnsignedLongSequence&& aOther)
{
  this->~OwningMaybeSharedUint32ArrayOrUnsignedLongSequence();
  new (this) OwningMaybeSharedUint32ArrayOrUnsignedLongSequence (std::move(aOther));
  return *this;
}



namespace EXT_color_buffer_float_Binding {

static void
_finalize(JS::GCContext* gcx, JSObject* obj)
{
  mozilla::ClientWebGLExtensionEXTColorBufferFloat* self = UnwrapPossiblyNotInitializedDOMObject<mozilla::ClientWebGLExtensionEXTColorBufferFloat>(obj);
  if (self) {
    JS::SetReservedSlot(obj, DOM_OBJECT_SLOT, JS::UndefinedValue());
    ClearWrapper(self, self, obj);
    if (size_t mallocBytes = BindingJSObjectMallocBytes(self)) {
      JS::RemoveAssociatedMemory(obj, mallocBytes,
                                 JS::MemoryUse::DOMBinding);
    }
    AddForDeferredFinalization<mozilla::ClientWebGLExtensionEXTColorBufferFloat>(self);
  }
}

bool sNativePropertiesInited = false;
const NativePropertyHooks sNativePropertyHooks = {
  nullptr,
  { nullptr, nullptr, &sNativePropertiesInited },
  prototypes::id::EXT_color_buffer_float,
  constructors::id::_ID_Count,
  &DefaultXrayExpandoObjectClass
};

static const DOMIfaceAndProtoJSClass sPrototypeClass = {
  {
    "EXT_color_buffer_floatPrototype",
    JSCLASS_IS_DOMIFACEANDPROTOJSCLASS | JSCLASS_HAS_RESERVED_SLOTS(DOM_INTERFACE_PROTO_SLOTS_BASE),
    JS_NULL_CLASS_OPS,
    JS_NULL_CLASS_SPEC,
    JS_NULL_CLASS_EXT,
    JS_NULL_OBJECT_OPS
  },
  eInterfacePrototype,
  prototypes::id::EXT_color_buffer_float,
  PrototypeTraits<prototypes::id::EXT_color_buffer_float>::Depth,
  &sNativePropertyHooks,
  JS::GetRealmObjectPrototype
};

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx);

static const JSClassOps sClassOps = {
  nullptr,               /* addProperty */
  nullptr,               /* delProperty */
  nullptr,               /* enumerate */
  nullptr, /* newEnumerate */
  nullptr, /* resolve */
  nullptr, /* mayResolve */
  _finalize, /* finalize */
  nullptr, /* call */
  nullptr,               /* construct */
  nullptr, /* trace */
};

static const DOMJSClass sClass = {
  { "EXT_color_buffer_float",
    JSCLASS_IS_DOMJSCLASS | JSCLASS_FOREGROUND_FINALIZE | JSCLASS_HAS_RESERVED_SLOTS(1) | JSCLASS_PRESERVES_WRAPPER,
    &sClassOps,
    JS_NULL_CLASS_SPEC,
    &NativeTypeHelpers<mozilla::ClientWebGLExtensionEXTColorBufferFloat>::sClassExtension,
    JS_NULL_OBJECT_OPS
  },
  { prototypes::id::EXT_color_buffer_float, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count },
  std::is_base_of_v<nsISupports, mozilla::ClientWebGLExtensionEXTColorBufferFloat>,
  &sNativePropertyHooks,
  FindAssociatedGlobalForNative<mozilla::ClientWebGLExtensionEXTColorBufferFloat>::Get,
  GetProtoObjectHandle,
  GetCCParticipant<mozilla::ClientWebGLExtensionEXTColorBufferFloat>::Get(),
  nullptr,
  NativeTypeHelpers<mozilla::ClientWebGLExtensionEXTColorBufferFloat>::GetWrapperCache
};
static_assert(1 == DOM_INSTANCE_RESERVED_SLOTS,
              "Must have the right minimal number of reserved slots.");
static_assert(1 >= 1,
              "Must have enough reserved slots.");

bool
Wrap(JSContext* aCx, mozilla::ClientWebGLExtensionEXTColorBufferFloat* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector)
{
  static_assert(!std::is_base_of_v<NonRefcountedDOMObject, mozilla::ClientWebGLExtensionEXTColorBufferFloat>,
                "Shouldn't have wrappercached things that are not refcounted.");
  static_assert(std::is_same_v<decltype(aObject), mozilla::ClientWebGLExtensionEXTColorBufferFloat*>);
  MOZ_ASSERT(ToSupportsIsCorrect(aObject));
  MOZ_ASSERT_IF(aGivenProto, js::IsObjectInContextCompartment(aGivenProto, aCx));
  MOZ_ASSERT(!aCache->GetWrapper(),
             "You should probably not be using Wrap() directly; use "
             "GetOrCreateDOMReflector instead");

  MOZ_ASSERT(ToSupportsIsOnPrimaryInheritanceChain(aObject, aCache),
             "nsISupports must be on our primary inheritance chain");

  // If the wrapper cache contains a dead reflector then finalize that
  // now, ensuring that the finalizer for the old reflector always
  // runs before the new reflector is created and attached. This
  // avoids the awkward situation where there are multiple reflector
  // objects that contain pointers to the same native.

  if (JSObject* oldReflector = aCache->GetWrapperMaybeDead()) {
    _finalize(nullptr /* unused */, oldReflector);
    MOZ_ASSERT(!aCache->GetWrapperMaybeDead());
  }

  JS::Rooted<JSObject*> global(aCx, FindAssociatedGlobal(aCx, aObject->GetParentObject()));
  if (!global) {
    return false;
  }
  MOZ_ASSERT(JS_IsGlobalObject(global));
  JS::AssertObjectIsNotGray(global);

  // That might have ended up wrapping us already, due to the wonders
  // of XBL.  Check for that, and bail out as needed.
  aReflector.set(aCache->GetWrapper());
  if (aReflector) {
#ifdef DEBUG
    AssertReflectorHasGivenProto(aCx, aReflector, aGivenProto);
#endif // DEBUG
    return true;
  }

  JSAutoRealm ar(aCx, global);
  JS::Handle<JSObject*> canonicalProto = GetProtoObjectHandle(aCx);
  if (!canonicalProto) {
    return false;
  }
  JS::Rooted<JSObject*> proto(aCx);
  if (aGivenProto) {
    proto = aGivenProto;
    // Unfortunately, while aGivenProto was in the compartment of aCx
    // coming in, we changed compartments to that of "parent" so may need
    // to wrap the proto here.
    if (js::GetContextCompartment(aCx) != JS::GetCompartment(proto)) {
      if (!JS_WrapObject(aCx, &proto)) {
        return false;
      }
    }
  } else {
    proto = canonicalProto;
  }

  BindingJSObjectCreator<mozilla::ClientWebGLExtensionEXTColorBufferFloat> creator(aCx);
  creator.CreateObject(aCx, sClass.ToJSClass(), proto, aObject, aReflector);
  if (!aReflector) {
    return false;
  }

  aCache->SetWrapper(aReflector);
  creator.InitializationSucceeded();

  MOZ_ASSERT(aCache->GetWrapperPreserveColor() &&
             aCache->GetWrapperPreserveColor() == aReflector);
  // If proto != canonicalProto, we have to preserve our wrapper;
  // otherwise we won't be able to properly recreate it later, since
  // we won't know what proto to use.  Note that we don't check
  // aGivenProto here, since it's entirely possible (and even
  // somewhat common) to have a non-null aGivenProto which is the
  // same as canonicalProto.
  if (proto != canonicalProto) {
    PreserveWrapper(aObject);
  }

  return true;
}

void
CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal)
{
  JS::Heap<JSObject*>* protoCache = &aProtoAndIfaceCache.EntrySlotOrCreate(prototypes::id::EXT_color_buffer_float);
  JS::Heap<JSObject*>* interfaceCache = nullptr;

  JS::Handle<JSObject*> parentProto(JS::GetRealmObjectPrototypeHandle(aCx));
  if (!parentProto) {
    return;
  }

  dom::CreateInterfaceObjects(aCx, aGlobal, parentProto,
                              &sPrototypeClass, protoCache,
                              nullptr, nullptr, 0, false, Span<const LegacyFactoryFunction, 0>{},
                              interfaceCache,
                              nullptr,
                              nullptr,
                              "EXT_color_buffer_float",
                              aDefineOnGlobal != DefineInterfaceProperty::No,
                              nullptr,
                              false,
                              nullptr);
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx)
{
  /* Get the interface prototype object for this class.  This will create the
     object as needed. */
  return GetPerInterfaceObjectHandle(aCx, prototypes::id::EXT_color_buffer_float,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);

}

} // namespace EXT_color_buffer_float_Binding



namespace OVR_multiview2_Binding {

MOZ_CAN_RUN_SCRIPT static bool
framebufferTextureMultiviewOVR(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "OVR_multiview2.framebufferTextureMultiviewOVR");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OVR_multiview2", "framebufferTextureMultiviewOVR", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLExtensionMultiview*>(void_self);
  if (!args.requireAtLeast(cx, "OVR_multiview2.framebufferTextureMultiviewOVR", 6)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  uint32_t arg1;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  mozilla::WebGLTextureJS* arg2;
  if (args[2].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLTexture, mozilla::WebGLTextureJS>(args[2], arg2, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 3", "WebGLTexture");
        return false;
      }
    }
  } else if (args[2].isNullOrUndefined()) {
    arg2 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 3");
    return false;
  }
  int32_t arg3;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
    return false;
  }
  int32_t arg4;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[4], "Argument 5", &arg4)) {
    return false;
  }
  int32_t arg5;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[5], "Argument 6", &arg5)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->FramebufferTextureMultiviewOVR(arg0, arg1, MOZ_KnownLive(Constify(arg2)), arg3, arg4, arg5))>, "Should be returning void here");
  MOZ_KnownLive(self)->FramebufferTextureMultiviewOVR(arg0, arg1, MOZ_KnownLive(Constify(arg2)), arg3, arg4, arg5);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo framebufferTextureMultiviewOVR_methodinfo = {
  { (JSJitGetterOp)framebufferTextureMultiviewOVR },
  { prototypes::id::OVR_multiview2 },
  { PrototypeTraits<prototypes::id::OVR_multiview2>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

static void
_finalize(JS::GCContext* gcx, JSObject* obj)
{
  mozilla::ClientWebGLExtensionMultiview* self = UnwrapPossiblyNotInitializedDOMObject<mozilla::ClientWebGLExtensionMultiview>(obj);
  if (self) {
    JS::SetReservedSlot(obj, DOM_OBJECT_SLOT, JS::UndefinedValue());
    ClearWrapper(self, self, obj);
    if (size_t mallocBytes = BindingJSObjectMallocBytes(self)) {
      JS::RemoveAssociatedMemory(obj, mallocBytes,
                                 JS::MemoryUse::DOMBinding);
    }
    AddForDeferredFinalization<mozilla::ClientWebGLExtensionMultiview>(self);
  }
}

MOZ_GLOBINIT static const JSFunctionSpec sMethods_specs[] = {
  JS_FNSPEC("framebufferTextureMultiviewOVR", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&framebufferTextureMultiviewOVR_methodinfo), 6, JSPROP_ENUMERATE, nullptr),
  JS_FS_END
};


static const Prefable<const JSFunctionSpec> sMethods[] = {
  { nullptr, &sMethods_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");

MOZ_GLOBINIT static const ConstantSpec sConstants_specs[] = {
  { "FRAMEBUFFER_ATTACHMENT_TEXTURE_NUM_VIEWS_OVR", JS::NumberValue(38448U) },
  { "FRAMEBUFFER_ATTACHMENT_TEXTURE_BASE_VIEW_INDEX_OVR", JS::NumberValue(38450U) },
  { "MAX_VIEWS_OVR", JS::NumberValue(38449U) },
  { "FRAMEBUFFER_INCOMPLETE_VIEW_TARGETS_OVR", JS::NumberValue(38451U) },
  { 0, JS::UndefinedValue() }
};


static const Prefable<const ConstantSpec> sConstants[] = {
  { nullptr, &sConstants_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(4 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");


static uint16_t sNativeProperties_sortedPropertyIndices[5];
static PropertyInfo sNativeProperties_propertyInfos[5];

static const NativePropertiesN<2> sNativeProperties = {
  false, 0,
  false, 0,
  true,  0 /* sMethods */,
  false, 0,
  false, 0,
  false, 0,
  true,  1 /* sConstants */,
  -1,
  5,
  sNativeProperties_sortedPropertyIndices,
  {
    { sMethods, &sNativeProperties_propertyInfos[0] },
    { sConstants, &sNativeProperties_propertyInfos[1] }
  }
};
static_assert(5 < 1ull << (CHAR_BIT * sizeof(sNativeProperties.propertyInfoCount)),
    "We have a property info count that is oversized");

bool sNativePropertiesInited = false;
const NativePropertyHooks sNativePropertyHooks = {
  nullptr,
  { sNativeProperties.Upcast(), nullptr, &sNativePropertiesInited },
  prototypes::id::OVR_multiview2,
  constructors::id::_ID_Count,
  &DefaultXrayExpandoObjectClass
};

static const DOMIfaceAndProtoJSClass sPrototypeClass = {
  {
    "OVR_multiview2Prototype",
    JSCLASS_IS_DOMIFACEANDPROTOJSCLASS | JSCLASS_HAS_RESERVED_SLOTS(DOM_INTERFACE_PROTO_SLOTS_BASE),
    JS_NULL_CLASS_OPS,
    JS_NULL_CLASS_SPEC,
    JS_NULL_CLASS_EXT,
    JS_NULL_OBJECT_OPS
  },
  eInterfacePrototype,
  prototypes::id::OVR_multiview2,
  PrototypeTraits<prototypes::id::OVR_multiview2>::Depth,
  &sNativePropertyHooks,
  JS::GetRealmObjectPrototype
};

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx);

static const JSClassOps sClassOps = {
  nullptr,               /* addProperty */
  nullptr,               /* delProperty */
  nullptr,               /* enumerate */
  nullptr, /* newEnumerate */
  nullptr, /* resolve */
  nullptr, /* mayResolve */
  _finalize, /* finalize */
  nullptr, /* call */
  nullptr,               /* construct */
  nullptr, /* trace */
};

static const DOMJSClass sClass = {
  { "OVR_multiview2",
    JSCLASS_IS_DOMJSCLASS | JSCLASS_FOREGROUND_FINALIZE | JSCLASS_HAS_RESERVED_SLOTS(1) | JSCLASS_PRESERVES_WRAPPER,
    &sClassOps,
    JS_NULL_CLASS_SPEC,
    &NativeTypeHelpers<mozilla::ClientWebGLExtensionMultiview>::sClassExtension,
    JS_NULL_OBJECT_OPS
  },
  { prototypes::id::OVR_multiview2, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count },
  std::is_base_of_v<nsISupports, mozilla::ClientWebGLExtensionMultiview>,
  &sNativePropertyHooks,
  FindAssociatedGlobalForNative<mozilla::ClientWebGLExtensionMultiview>::Get,
  GetProtoObjectHandle,
  GetCCParticipant<mozilla::ClientWebGLExtensionMultiview>::Get(),
  nullptr,
  NativeTypeHelpers<mozilla::ClientWebGLExtensionMultiview>::GetWrapperCache
};
static_assert(1 == DOM_INSTANCE_RESERVED_SLOTS,
              "Must have the right minimal number of reserved slots.");
static_assert(1 >= 1,
              "Must have enough reserved slots.");

bool
Wrap(JSContext* aCx, mozilla::ClientWebGLExtensionMultiview* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector)
{
  static_assert(!std::is_base_of_v<NonRefcountedDOMObject, mozilla::ClientWebGLExtensionMultiview>,
                "Shouldn't have wrappercached things that are not refcounted.");
  static_assert(std::is_same_v<decltype(aObject), mozilla::ClientWebGLExtensionMultiview*>);
  MOZ_ASSERT(ToSupportsIsCorrect(aObject));
  MOZ_ASSERT_IF(aGivenProto, js::IsObjectInContextCompartment(aGivenProto, aCx));
  MOZ_ASSERT(!aCache->GetWrapper(),
             "You should probably not be using Wrap() directly; use "
             "GetOrCreateDOMReflector instead");

  MOZ_ASSERT(ToSupportsIsOnPrimaryInheritanceChain(aObject, aCache),
             "nsISupports must be on our primary inheritance chain");

  // If the wrapper cache contains a dead reflector then finalize that
  // now, ensuring that the finalizer for the old reflector always
  // runs before the new reflector is created and attached. This
  // avoids the awkward situation where there are multiple reflector
  // objects that contain pointers to the same native.

  if (JSObject* oldReflector = aCache->GetWrapperMaybeDead()) {
    _finalize(nullptr /* unused */, oldReflector);
    MOZ_ASSERT(!aCache->GetWrapperMaybeDead());
  }

  JS::Rooted<JSObject*> global(aCx, FindAssociatedGlobal(aCx, aObject->GetParentObject()));
  if (!global) {
    return false;
  }
  MOZ_ASSERT(JS_IsGlobalObject(global));
  JS::AssertObjectIsNotGray(global);

  // That might have ended up wrapping us already, due to the wonders
  // of XBL.  Check for that, and bail out as needed.
  aReflector.set(aCache->GetWrapper());
  if (aReflector) {
#ifdef DEBUG
    AssertReflectorHasGivenProto(aCx, aReflector, aGivenProto);
#endif // DEBUG
    return true;
  }

  JSAutoRealm ar(aCx, global);
  JS::Handle<JSObject*> canonicalProto = GetProtoObjectHandle(aCx);
  if (!canonicalProto) {
    return false;
  }
  JS::Rooted<JSObject*> proto(aCx);
  if (aGivenProto) {
    proto = aGivenProto;
    // Unfortunately, while aGivenProto was in the compartment of aCx
    // coming in, we changed compartments to that of "parent" so may need
    // to wrap the proto here.
    if (js::GetContextCompartment(aCx) != JS::GetCompartment(proto)) {
      if (!JS_WrapObject(aCx, &proto)) {
        return false;
      }
    }
  } else {
    proto = canonicalProto;
  }

  BindingJSObjectCreator<mozilla::ClientWebGLExtensionMultiview> creator(aCx);
  creator.CreateObject(aCx, sClass.ToJSClass(), proto, aObject, aReflector);
  if (!aReflector) {
    return false;
  }

  aCache->SetWrapper(aReflector);
  creator.InitializationSucceeded();

  MOZ_ASSERT(aCache->GetWrapperPreserveColor() &&
             aCache->GetWrapperPreserveColor() == aReflector);
  // If proto != canonicalProto, we have to preserve our wrapper;
  // otherwise we won't be able to properly recreate it later, since
  // we won't know what proto to use.  Note that we don't check
  // aGivenProto here, since it's entirely possible (and even
  // somewhat common) to have a non-null aGivenProto which is the
  // same as canonicalProto.
  if (proto != canonicalProto) {
    PreserveWrapper(aObject);
  }

  return true;
}

void
CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal)
{
  JS::Heap<JSObject*>* protoCache = &aProtoAndIfaceCache.EntrySlotOrCreate(prototypes::id::OVR_multiview2);
  JS::Heap<JSObject*>* interfaceCache = nullptr;

  JS::Handle<JSObject*> parentProto(JS::GetRealmObjectPrototypeHandle(aCx));
  if (!parentProto) {
    return;
  }

  dom::CreateInterfaceObjects(aCx, aGlobal, parentProto,
                              &sPrototypeClass, protoCache,
                              nullptr, nullptr, 0, false, Span<const LegacyFactoryFunction, 0>{},
                              interfaceCache,
                              sNativeProperties.Upcast(),
                              nullptr,
                              "OVR_multiview2",
                              aDefineOnGlobal != DefineInterfaceProperty::No,
                              nullptr,
                              false,
                              nullptr);
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx)
{
  /* Get the interface prototype object for this class.  This will create the
     object as needed. */
  return GetPerInterfaceObjectHandle(aCx, prototypes::id::OVR_multiview2,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);

}

} // namespace OVR_multiview2_Binding



namespace WebGL2RenderingContext_Binding {

MOZ_CAN_RUN_SCRIPT static bool
bufferData(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.bufferData");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "bufferData", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  unsigned argcount = std::min(args.length(), 5u);
  switch (argcount) {
    case 3: {
      uint32_t arg0;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
        return false;
      }
      if (args[1].isNullOrUndefined()) {
        RootedSpiderMonkeyInterface<Nullable<ArrayBuffer>> arg1(cx);
        arg1.SetNull();
        uint32_t arg2;
        if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
          return false;
        }
        // NOTE: This assert does NOT call the function.
        static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->BufferData(arg0, Constify(arg1), arg2))>, "Should be returning void here");
        MOZ_KnownLive(self)->BufferData(arg0, Constify(arg1), arg2);
        MOZ_ASSERT(!JS_IsExceptionPending(cx));
        args.rval().setUndefined();
        return true;
      }
      if (args[1].isObject()) {
        do {
          RootedSpiderMonkeyInterface<Nullable<ArrayBuffer>> arg1(cx);
          if (!arg1.SetValue().Init(&args[1].toObject())) {
            break;
          }
          if (JS::IsLargeArrayBufferMaybeShared(arg1.SetValue().Obj())) {
            cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_LARGE>("Argument 2");
            return false;
          }
          if (JS::IsResizableArrayBufferMaybeShared(arg1.SetValue().Obj())) {
            cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_RESIZABLE>("Argument 2");
            return false;
          }
          if (JS::IsImmutableArrayBufferMaybeShared(arg1.SetValue().Obj())) {
            cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_IMMUTABLE>("Argument 2");
            return false;
          }
          uint32_t arg2;
          if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
            return false;
          }
          // NOTE: This assert does NOT call the function.
          static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->BufferData(arg0, Constify(arg1), arg2))>, "Should be returning void here");
          MOZ_KnownLive(self)->BufferData(arg0, Constify(arg1), arg2);
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          args.rval().setUndefined();
          return true;
        } while (false);
        do {
          RootedSpiderMonkeyInterface<ArrayBufferView> arg1(cx);
          if (!arg1.Init(&args[1].toObject())) {
            break;
          }
          if (JS::IsLargeArrayBufferView(arg1.Obj())) {
            cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_LARGE>("Argument 2");
            return false;
          }
          if (JS::IsResizableArrayBufferView(arg1.Obj())) {
            cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_RESIZABLE>("Argument 2");
            return false;
          }
          if (JS::IsImmutableArrayBufferView(arg1.Obj())) {
            cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_IMMUTABLE>("Argument 2");
            return false;
          }
          uint32_t arg2;
          if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
            return false;
          }
          // NOTE: This assert does NOT call the function.
          static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->BufferData(arg0, Constify(arg1), arg2))>, "Should be returning void here");
          MOZ_KnownLive(self)->BufferData(arg0, Constify(arg1), arg2);
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          args.rval().setUndefined();
          return true;
        } while (false);
      }
      int64_t arg1;
      if (!ValueToPrimitive<int64_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
        return false;
      }
      uint32_t arg2;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
        return false;
      }
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->BufferData(arg0, arg1, arg2))>, "Should be returning void here");
      MOZ_KnownLive(self)->BufferData(arg0, arg1, arg2);
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      args.rval().setUndefined();
      return true;
      break;
    }
    case 4: {
      [[fallthrough]];
    }
    case 5: {
      uint32_t arg0;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
        return false;
      }
      RootedSpiderMonkeyInterface<ArrayBufferView> arg1(cx);
      if (args[1].isObject()) {
        if (!arg1.Init(&args[1].toObject())) {
          cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 2", "ArrayBufferView");
          return false;
        }
        if (JS::IsLargeArrayBufferView(arg1.Obj())) {
          cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_LARGE>("Argument 2");
          return false;
        }
        if (JS::IsResizableArrayBufferView(arg1.Obj())) {
          cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_RESIZABLE>("Argument 2");
          return false;
        }
        if (JS::IsImmutableArrayBufferView(arg1.Obj())) {
          cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_IMMUTABLE>("Argument 2");
          return false;
        }
      } else {
        cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 2");
        return false;
      }
      uint32_t arg2;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
        return false;
      }
      uint32_t arg3;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
        return false;
      }
      uint32_t arg4;
      if (args.hasDefined(4)) {
        if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[4], "Argument 5", &arg4)) {
          return false;
        }
      } else {
        arg4 = 0U;
      }
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->BufferData(arg0, Constify(arg1), arg2, arg3, arg4))>, "Should be returning void here");
      MOZ_KnownLive(self)->BufferData(arg0, Constify(arg1), arg2, arg3, arg4);
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      args.rval().setUndefined();
      return true;
      break;
    }
    default: {
      // Using nsPrintfCString here would require including that
      // header.  Let's not worry about it.
      nsAutoCString argCountStr;
      argCountStr.AppendPrintf("%u", args.length());
      return cx.ThrowErrorMessage<MSG_INVALID_OVERLOAD_ARGCOUNT>(argCountStr.get());
    }
  }
  MOZ_CRASH("We have an always-returning default case");
  return false;
}

static const JSJitInfo bufferData_methodinfo = {
  { (JSJitGetterOp)bufferData },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
bufferSubData(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.bufferSubData");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "bufferSubData", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  unsigned argcount = std::min(args.length(), 5u);
  switch (argcount) {
    case 3: {
      uint32_t arg0;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
        return false;
      }
      int64_t arg1;
      if (!ValueToPrimitive<int64_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
        return false;
      }
      MaybeSharedArrayBufferOrMaybeSharedArrayBufferView arg2;
      if (!arg2.Init(cx, args[2], "Argument 3", false)) {
        return false;
      }
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->BufferSubData(arg0, arg1, Constify(arg2)))>, "Should be returning void here");
      MOZ_KnownLive(self)->BufferSubData(arg0, arg1, Constify(arg2));
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      args.rval().setUndefined();
      return true;
      break;
    }
    case 4: {
      [[fallthrough]];
    }
    case 5: {
      uint32_t arg0;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
        return false;
      }
      int64_t arg1;
      if (!ValueToPrimitive<int64_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
        return false;
      }
      RootedSpiderMonkeyInterface<ArrayBufferView> arg2(cx);
      if (args[2].isObject()) {
        if (!arg2.Init(&args[2].toObject())) {
          cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 3", "ArrayBufferView");
          return false;
        }
        if (JS::IsLargeArrayBufferView(arg2.Obj())) {
          cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_LARGE>("Argument 3");
          return false;
        }
        if (JS::IsResizableArrayBufferView(arg2.Obj())) {
          cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_RESIZABLE>("Argument 3");
          return false;
        }
        if (JS::IsImmutableArrayBufferView(arg2.Obj())) {
          cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_IMMUTABLE>("Argument 3");
          return false;
        }
      } else {
        cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 3");
        return false;
      }
      uint32_t arg3;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
        return false;
      }
      uint32_t arg4;
      if (args.hasDefined(4)) {
        if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[4], "Argument 5", &arg4)) {
          return false;
        }
      } else {
        arg4 = 0U;
      }
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->BufferSubData(arg0, arg1, Constify(arg2), arg3, arg4))>, "Should be returning void here");
      MOZ_KnownLive(self)->BufferSubData(arg0, arg1, Constify(arg2), arg3, arg4);
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      args.rval().setUndefined();
      return true;
      break;
    }
    default: {
      // Using nsPrintfCString here would require including that
      // header.  Let's not worry about it.
      nsAutoCString argCountStr;
      argCountStr.AppendPrintf("%u", args.length());
      return cx.ThrowErrorMessage<MSG_INVALID_OVERLOAD_ARGCOUNT>(argCountStr.get());
    }
  }
  MOZ_CRASH("We have an always-returning default case");
  return false;
}

static const JSJitInfo bufferSubData_methodinfo = {
  { (JSJitGetterOp)bufferSubData },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
copyBufferSubData(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "copyBufferSubData", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.copyBufferSubData", 5)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  uint32_t arg1;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  int64_t arg2;
  if (!ValueToPrimitive<int64_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  }
  int64_t arg3;
  if (!ValueToPrimitive<int64_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
    return false;
  }
  int64_t arg4;
  if (!ValueToPrimitive<int64_t, eDefault>(cx, args[4], "Argument 5", &arg4)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->CopyBufferSubData(arg0, arg1, arg2, arg3, arg4))>, "Should be returning void here");
  MOZ_KnownLive(self)->CopyBufferSubData(arg0, arg1, arg2, arg3, arg4);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo copyBufferSubData_methodinfo = {
  { (JSJitGetterOp)copyBufferSubData },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getBufferSubData(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.getBufferSubData");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "getBufferSubData", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.getBufferSubData", 3)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  int64_t arg1;
  if (!ValueToPrimitive<int64_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  RootedSpiderMonkeyInterface<ArrayBufferView> arg2(cx);
  if (args[2].isObject()) {
    if (!arg2.Init(&args[2].toObject())) {
      cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 3", "ArrayBufferView");
      return false;
    }
    if (JS::IsLargeArrayBufferView(arg2.Obj())) {
      cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_LARGE>("Argument 3");
      return false;
    }
    if (JS::IsResizableArrayBufferView(arg2.Obj())) {
      cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_RESIZABLE>("Argument 3");
      return false;
    }
    if (JS::IsImmutableArrayBufferView(arg2.Obj())) {
      cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_IMMUTABLE>("Argument 3");
      return false;
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 3");
    return false;
  }
  uint32_t arg3;
  if (args.hasDefined(3)) {
    if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
      return false;
    }
  } else {
    arg3 = 0U;
  }
  uint32_t arg4;
  if (args.hasDefined(4)) {
    if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[4], "Argument 5", &arg4)) {
      return false;
    }
  } else {
    arg4 = 0U;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetBufferSubData(arg0, arg1, Constify(arg2), arg3, arg4))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetBufferSubData(arg0, arg1, Constify(arg2), arg3, arg4);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo getBufferSubData_methodinfo = {
  { (JSJitGetterOp)getBufferSubData },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
blitFramebuffer(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "blitFramebuffer", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.blitFramebuffer", 10)) {
    return false;
  }
  int32_t arg0;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  int32_t arg1;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  int32_t arg2;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  }
  int32_t arg3;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
    return false;
  }
  int32_t arg4;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[4], "Argument 5", &arg4)) {
    return false;
  }
  int32_t arg5;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[5], "Argument 6", &arg5)) {
    return false;
  }
  int32_t arg6;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[6], "Argument 7", &arg6)) {
    return false;
  }
  int32_t arg7;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[7], "Argument 8", &arg7)) {
    return false;
  }
  uint32_t arg8;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[8], "Argument 9", &arg8)) {
    return false;
  }
  uint32_t arg9;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[9], "Argument 10", &arg9)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->BlitFramebuffer(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9))>, "Should be returning void here");
  MOZ_KnownLive(self)->BlitFramebuffer(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo blitFramebuffer_methodinfo = {
  { (JSJitGetterOp)blitFramebuffer },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
framebufferTextureLayer(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.framebufferTextureLayer");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "framebufferTextureLayer", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.framebufferTextureLayer", 5)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  uint32_t arg1;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  mozilla::WebGLTextureJS* arg2;
  if (args[2].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLTexture, mozilla::WebGLTextureJS>(args[2], arg2, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 3", "WebGLTexture");
        return false;
      }
    }
  } else if (args[2].isNullOrUndefined()) {
    arg2 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 3");
    return false;
  }
  int32_t arg3;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
    return false;
  }
  int32_t arg4;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[4], "Argument 5", &arg4)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->FramebufferTextureLayer(arg0, arg1, MOZ_KnownLive(Constify(arg2)), arg3, arg4))>, "Should be returning void here");
  MOZ_KnownLive(self)->FramebufferTextureLayer(arg0, arg1, MOZ_KnownLive(Constify(arg2)), arg3, arg4);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo framebufferTextureLayer_methodinfo = {
  { (JSJitGetterOp)framebufferTextureLayer },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
invalidateFramebuffer(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.invalidateFramebuffer");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "invalidateFramebuffer", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.invalidateFramebuffer", 2)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  binding_detail::AutoSequence<uint32_t> arg1;
  if (args[1].isObject()) {
    JS::ForOfIterator iter(cx);
    if (!iter.init(args[1], JS::ForOfIterator::AllowNonIterable)) {
      return false;
    }
    if (!iter.valueIsIterable()) {
      cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("Argument 2", "sequence");
      return false;
    }
    binding_detail::AutoSequence<uint32_t> &arr = arg1;
    JS::Rooted<JS::Value> temp(cx);
    while (true) {
      bool done;
      if (!iter.next(&temp, &done)) {
        return false;
      }
      if (done) {
        break;
      }
      uint32_t* slotPtr = arr.AppendElement(mozilla::fallible);
      if (!slotPtr) {
        JS_ReportOutOfMemory(cx);
        return false;
      }
      uint32_t& slot = *slotPtr;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, temp, "Element of argument 2", &slot)) {
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("Argument 2", "sequence");
    return false;
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->InvalidateFramebuffer(arg0, Constify(arg1), rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->InvalidateFramebuffer(arg0, Constify(arg1), rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "WebGL2RenderingContext.invalidateFramebuffer"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo invalidateFramebuffer_methodinfo = {
  { (JSJitGetterOp)invalidateFramebuffer },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
invalidateSubFramebuffer(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.invalidateSubFramebuffer");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "invalidateSubFramebuffer", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.invalidateSubFramebuffer", 6)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  binding_detail::AutoSequence<uint32_t> arg1;
  if (args[1].isObject()) {
    JS::ForOfIterator iter(cx);
    if (!iter.init(args[1], JS::ForOfIterator::AllowNonIterable)) {
      return false;
    }
    if (!iter.valueIsIterable()) {
      cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("Argument 2", "sequence");
      return false;
    }
    binding_detail::AutoSequence<uint32_t> &arr = arg1;
    JS::Rooted<JS::Value> temp(cx);
    while (true) {
      bool done;
      if (!iter.next(&temp, &done)) {
        return false;
      }
      if (done) {
        break;
      }
      uint32_t* slotPtr = arr.AppendElement(mozilla::fallible);
      if (!slotPtr) {
        JS_ReportOutOfMemory(cx);
        return false;
      }
      uint32_t& slot = *slotPtr;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, temp, "Element of argument 2", &slot)) {
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("Argument 2", "sequence");
    return false;
  }
  int32_t arg2;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  }
  int32_t arg3;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
    return false;
  }
  int32_t arg4;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[4], "Argument 5", &arg4)) {
    return false;
  }
  int32_t arg5;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[5], "Argument 6", &arg5)) {
    return false;
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->InvalidateSubFramebuffer(arg0, Constify(arg1), arg2, arg3, arg4, arg5, rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->InvalidateSubFramebuffer(arg0, Constify(arg1), arg2, arg3, arg4, arg5, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "WebGL2RenderingContext.invalidateSubFramebuffer"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo invalidateSubFramebuffer_methodinfo = {
  { (JSJitGetterOp)invalidateSubFramebuffer },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
readBuffer(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "readBuffer", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.readBuffer", 1)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->ReadBuffer(arg0))>, "Should be returning void here");
  MOZ_KnownLive(self)->ReadBuffer(arg0);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo readBuffer_methodinfo = {
  { (JSJitGetterOp)readBuffer },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getInternalformatParameter(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "getInternalformatParameter", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.getInternalformatParameter", 3)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  uint32_t arg1;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  uint32_t arg2;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  }
  FastErrorResult rv;
  JS::Rooted<JS::Value> result(cx);
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetInternalformatParameter(cx, arg0, arg1, arg2, &result, rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetInternalformatParameter(cx, arg0, arg1, arg2, &result, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "WebGL2RenderingContext.getInternalformatParameter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  JS::ExposeValueToActiveJS(result);
  args.rval().set(result);
  if (!MaybeWrapValue(cx, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo getInternalformatParameter_methodinfo = {
  { (JSJitGetterOp)getInternalformatParameter },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
renderbufferStorageMultisample(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "renderbufferStorageMultisample", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.renderbufferStorageMultisample", 5)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  int32_t arg1;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  uint32_t arg2;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  }
  int32_t arg3;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
    return false;
  }
  int32_t arg4;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[4], "Argument 5", &arg4)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->RenderbufferStorageMultisample(arg0, arg1, arg2, arg3, arg4))>, "Should be returning void here");
  MOZ_KnownLive(self)->RenderbufferStorageMultisample(arg0, arg1, arg2, arg3, arg4);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo renderbufferStorageMultisample_methodinfo = {
  { (JSJitGetterOp)renderbufferStorageMultisample },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
texStorage2D(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "texStorage2D", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.texStorage2D", 5)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  int32_t arg1;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  uint32_t arg2;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  }
  int32_t arg3;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
    return false;
  }
  int32_t arg4;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[4], "Argument 5", &arg4)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->TexStorage2D(arg0, arg1, arg2, arg3, arg4))>, "Should be returning void here");
  MOZ_KnownLive(self)->TexStorage2D(arg0, arg1, arg2, arg3, arg4);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo texStorage2D_methodinfo = {
  { (JSJitGetterOp)texStorage2D },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
texStorage3D(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "texStorage3D", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.texStorage3D", 6)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  int32_t arg1;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  uint32_t arg2;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  }
  int32_t arg3;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
    return false;
  }
  int32_t arg4;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[4], "Argument 5", &arg4)) {
    return false;
  }
  int32_t arg5;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[5], "Argument 6", &arg5)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->TexStorage3D(arg0, arg1, arg2, arg3, arg4, arg5))>, "Should be returning void here");
  MOZ_KnownLive(self)->TexStorage3D(arg0, arg1, arg2, arg3, arg4, arg5);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo texStorage3D_methodinfo = {
  { (JSJitGetterOp)texStorage3D },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
texImage2D(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.texImage2D");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "texImage2D", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  unsigned argcount = std::min(args.length(), 10u);
  switch (argcount) {
    case 6: {
      uint32_t arg0;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
        return false;
      }
      int32_t arg1;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
        return false;
      }
      int32_t arg2;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
        return false;
      }
      uint32_t arg3;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
        return false;
      }
      uint32_t arg4;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[4], "Argument 5", &arg4)) {
        return false;
      }
      if (args[5].isObject()) {
        do {
          NonNull<mozilla::dom::HTMLCanvasElement> arg5;
          {
            // Our JSContext should be in the right global to do unwrapping in.
            nsresult rv = UnwrapObject<prototypes::id::HTMLCanvasElement, mozilla::dom::HTMLCanvasElement>(args[5], arg5, cx);
            if (NS_FAILED(rv)) {
              break;
            }
          }
          FastErrorResult rv;
          // NOTE: This assert does NOT call the function.
          static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->TexImage2D(arg0, arg1, arg2, arg3, arg4, MOZ_KnownLive(NonNullHelper(arg5)), rv))>, "Should be returning void here");
          MOZ_KnownLive(self)->TexImage2D(arg0, arg1, arg2, arg3, arg4, MOZ_KnownLive(NonNullHelper(arg5)), rv);
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "WebGL2RenderingContext.texImage2D"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          args.rval().setUndefined();
          return true;
        } while (false);
        do {
          NonNull<mozilla::dom::HTMLImageElement> arg5;
          {
            // Our JSContext should be in the right global to do unwrapping in.
            nsresult rv = UnwrapObject<prototypes::id::HTMLImageElement, mozilla::dom::HTMLImageElement>(args[5], arg5, cx);
            if (NS_FAILED(rv)) {
              break;
            }
          }
          FastErrorResult rv;
          // NOTE: This assert does NOT call the function.
          static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->TexImage2D(arg0, arg1, arg2, arg3, arg4, MOZ_KnownLive(NonNullHelper(arg5)), rv))>, "Should be returning void here");
          MOZ_KnownLive(self)->TexImage2D(arg0, arg1, arg2, arg3, arg4, MOZ_KnownLive(NonNullHelper(arg5)), rv);
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "WebGL2RenderingContext.texImage2D"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          args.rval().setUndefined();
          return true;
        } while (false);
        do {
          NonNull<mozilla::dom::HTMLVideoElement> arg5;
          {
            // Our JSContext should be in the right global to do unwrapping in.
            nsresult rv = UnwrapObject<prototypes::id::HTMLVideoElement, mozilla::dom::HTMLVideoElement>(args[5], arg5, cx);
            if (NS_FAILED(rv)) {
              break;
            }
          }
          FastErrorResult rv;
          // NOTE: This assert does NOT call the function.
          static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->TexImage2D(arg0, arg1, arg2, arg3, arg4, MOZ_KnownLive(NonNullHelper(arg5)), rv))>, "Should be returning void here");
          MOZ_KnownLive(self)->TexImage2D(arg0, arg1, arg2, arg3, arg4, MOZ_KnownLive(NonNullHelper(arg5)), rv);
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "WebGL2RenderingContext.texImage2D"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          args.rval().setUndefined();
          return true;
        } while (false);
        do {
          NonNull<mozilla::dom::ImageBitmap> arg5;
          {
            // Our JSContext should be in the right global to do unwrapping in.
            nsresult rv = UnwrapObject<prototypes::id::ImageBitmap, mozilla::dom::ImageBitmap>(args[5], arg5, cx);
            if (NS_FAILED(rv)) {
              break;
            }
          }
          FastErrorResult rv;
          // NOTE: This assert does NOT call the function.
          static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->TexImage2D(arg0, arg1, arg2, arg3, arg4, MOZ_KnownLive(NonNullHelper(arg5)), rv))>, "Should be returning void here");
          MOZ_KnownLive(self)->TexImage2D(arg0, arg1, arg2, arg3, arg4, MOZ_KnownLive(NonNullHelper(arg5)), rv);
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "WebGL2RenderingContext.texImage2D"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          args.rval().setUndefined();
          return true;
        } while (false);
        do {
          NonNull<mozilla::dom::ImageData> arg5;
          {
            // Our JSContext should be in the right global to do unwrapping in.
            nsresult rv = UnwrapObject<prototypes::id::ImageData, mozilla::dom::ImageData>(args[5], arg5, cx);
            if (NS_FAILED(rv)) {
              break;
            }
          }
          FastErrorResult rv;
          // NOTE: This assert does NOT call the function.
          static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->TexImage2D(arg0, arg1, arg2, arg3, arg4, MOZ_KnownLive(NonNullHelper(arg5)), rv))>, "Should be returning void here");
          MOZ_KnownLive(self)->TexImage2D(arg0, arg1, arg2, arg3, arg4, MOZ_KnownLive(NonNullHelper(arg5)), rv);
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "WebGL2RenderingContext.texImage2D"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          args.rval().setUndefined();
          return true;
        } while (false);
        do {
          NonNull<mozilla::dom::OffscreenCanvas> arg5;
          {
            // Our JSContext should be in the right global to do unwrapping in.
            nsresult rv = UnwrapObject<prototypes::id::OffscreenCanvas, mozilla::dom::OffscreenCanvas>(args[5], arg5, cx);
            if (NS_FAILED(rv)) {
              break;
            }
          }
          FastErrorResult rv;
          // NOTE: This assert does NOT call the function.
          static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->TexImage2D(arg0, arg1, arg2, arg3, arg4, MOZ_KnownLive(NonNullHelper(arg5)), rv))>, "Should be returning void here");
          MOZ_KnownLive(self)->TexImage2D(arg0, arg1, arg2, arg3, arg4, MOZ_KnownLive(NonNullHelper(arg5)), rv);
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "WebGL2RenderingContext.texImage2D"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          args.rval().setUndefined();
          return true;
        } while (false);
        do {
          NonNull<mozilla::dom::VideoFrame> arg5;
          {
            // Our JSContext should be in the right global to do unwrapping in.
            nsresult rv = UnwrapObject<prototypes::id::VideoFrame, mozilla::dom::VideoFrame>(args[5], arg5, cx);
            if (NS_FAILED(rv)) {
              break;
            }
          }
          FastErrorResult rv;
          // NOTE: This assert does NOT call the function.
          static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->TexImage2D(arg0, arg1, arg2, arg3, arg4, MOZ_KnownLive(NonNullHelper(arg5)), rv))>, "Should be returning void here");
          MOZ_KnownLive(self)->TexImage2D(arg0, arg1, arg2, arg3, arg4, MOZ_KnownLive(NonNullHelper(arg5)), rv);
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "WebGL2RenderingContext.texImage2D"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          args.rval().setUndefined();
          return true;
        } while (false);
      }
      return cx.ThrowErrorMessage<MSG_OVERLOAD_RESOLUTION_FAILED>("6", "6");
      break;
    }
    case 9: {
      uint32_t arg0;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
        return false;
      }
      int32_t arg1;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
        return false;
      }
      int32_t arg2;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
        return false;
      }
      int32_t arg3;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
        return false;
      }
      int32_t arg4;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[4], "Argument 5", &arg4)) {
        return false;
      }
      int32_t arg5;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[5], "Argument 6", &arg5)) {
        return false;
      }
      uint32_t arg6;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[6], "Argument 7", &arg6)) {
        return false;
      }
      uint32_t arg7;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[7], "Argument 8", &arg7)) {
        return false;
      }
      if (args[8].isNullOrUndefined()) {
        RootedSpiderMonkeyInterface<Nullable<ArrayBufferView>> arg8(cx);
        arg8.SetNull();
        FastErrorResult rv;
        // NOTE: This assert does NOT call the function.
        static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->TexImage2D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, Constify(arg8), rv))>, "Should be returning void here");
        MOZ_KnownLive(self)->TexImage2D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, Constify(arg8), rv);
        if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "WebGL2RenderingContext.texImage2D"))) {
          return false;
        }
        MOZ_ASSERT(!JS_IsExceptionPending(cx));
        args.rval().setUndefined();
        return true;
      }
      if (args[8].isObject()) {
        do {
          RootedSpiderMonkeyInterface<Nullable<ArrayBufferView>> arg8(cx);
          if (!arg8.SetValue().Init(&args[8].toObject())) {
            break;
          }
          if (JS::IsLargeArrayBufferView(arg8.SetValue().Obj())) {
            cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_LARGE>("Argument 9");
            return false;
          }
          if (JS::IsResizableArrayBufferView(arg8.SetValue().Obj())) {
            cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_RESIZABLE>("Argument 9");
            return false;
          }
          if (JS::IsImmutableArrayBufferView(arg8.SetValue().Obj())) {
            cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_IMMUTABLE>("Argument 9");
            return false;
          }
          FastErrorResult rv;
          // NOTE: This assert does NOT call the function.
          static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->TexImage2D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, Constify(arg8), rv))>, "Should be returning void here");
          MOZ_KnownLive(self)->TexImage2D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, Constify(arg8), rv);
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "WebGL2RenderingContext.texImage2D"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          args.rval().setUndefined();
          return true;
        } while (false);
        do {
          NonNull<mozilla::dom::HTMLCanvasElement> arg8;
          {
            // Our JSContext should be in the right global to do unwrapping in.
            nsresult rv = UnwrapObject<prototypes::id::HTMLCanvasElement, mozilla::dom::HTMLCanvasElement>(args[8], arg8, cx);
            if (NS_FAILED(rv)) {
              break;
            }
          }
          FastErrorResult rv;
          // NOTE: This assert does NOT call the function.
          static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->TexImage2D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, MOZ_KnownLive(NonNullHelper(arg8)), rv))>, "Should be returning void here");
          MOZ_KnownLive(self)->TexImage2D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, MOZ_KnownLive(NonNullHelper(arg8)), rv);
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "WebGL2RenderingContext.texImage2D"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          args.rval().setUndefined();
          return true;
        } while (false);
        do {
          NonNull<mozilla::dom::HTMLImageElement> arg8;
          {
            // Our JSContext should be in the right global to do unwrapping in.
            nsresult rv = UnwrapObject<prototypes::id::HTMLImageElement, mozilla::dom::HTMLImageElement>(args[8], arg8, cx);
            if (NS_FAILED(rv)) {
              break;
            }
          }
          FastErrorResult rv;
          // NOTE: This assert does NOT call the function.
          static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->TexImage2D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, MOZ_KnownLive(NonNullHelper(arg8)), rv))>, "Should be returning void here");
          MOZ_KnownLive(self)->TexImage2D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, MOZ_KnownLive(NonNullHelper(arg8)), rv);
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "WebGL2RenderingContext.texImage2D"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          args.rval().setUndefined();
          return true;
        } while (false);
        do {
          NonNull<mozilla::dom::HTMLVideoElement> arg8;
          {
            // Our JSContext should be in the right global to do unwrapping in.
            nsresult rv = UnwrapObject<prototypes::id::HTMLVideoElement, mozilla::dom::HTMLVideoElement>(args[8], arg8, cx);
            if (NS_FAILED(rv)) {
              break;
            }
          }
          FastErrorResult rv;
          // NOTE: This assert does NOT call the function.
          static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->TexImage2D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, MOZ_KnownLive(NonNullHelper(arg8)), rv))>, "Should be returning void here");
          MOZ_KnownLive(self)->TexImage2D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, MOZ_KnownLive(NonNullHelper(arg8)), rv);
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "WebGL2RenderingContext.texImage2D"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          args.rval().setUndefined();
          return true;
        } while (false);
        do {
          NonNull<mozilla::dom::ImageBitmap> arg8;
          {
            // Our JSContext should be in the right global to do unwrapping in.
            nsresult rv = UnwrapObject<prototypes::id::ImageBitmap, mozilla::dom::ImageBitmap>(args[8], arg8, cx);
            if (NS_FAILED(rv)) {
              break;
            }
          }
          FastErrorResult rv;
          // NOTE: This assert does NOT call the function.
          static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->TexImage2D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, MOZ_KnownLive(NonNullHelper(arg8)), rv))>, "Should be returning void here");
          MOZ_KnownLive(self)->TexImage2D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, MOZ_KnownLive(NonNullHelper(arg8)), rv);
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "WebGL2RenderingContext.texImage2D"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          args.rval().setUndefined();
          return true;
        } while (false);
        do {
          NonNull<mozilla::dom::ImageData> arg8;
          {
            // Our JSContext should be in the right global to do unwrapping in.
            nsresult rv = UnwrapObject<prototypes::id::ImageData, mozilla::dom::ImageData>(args[8], arg8, cx);
            if (NS_FAILED(rv)) {
              break;
            }
          }
          FastErrorResult rv;
          // NOTE: This assert does NOT call the function.
          static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->TexImage2D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, MOZ_KnownLive(NonNullHelper(arg8)), rv))>, "Should be returning void here");
          MOZ_KnownLive(self)->TexImage2D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, MOZ_KnownLive(NonNullHelper(arg8)), rv);
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "WebGL2RenderingContext.texImage2D"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          args.rval().setUndefined();
          return true;
        } while (false);
        do {
          NonNull<mozilla::dom::OffscreenCanvas> arg8;
          {
            // Our JSContext should be in the right global to do unwrapping in.
            nsresult rv = UnwrapObject<prototypes::id::OffscreenCanvas, mozilla::dom::OffscreenCanvas>(args[8], arg8, cx);
            if (NS_FAILED(rv)) {
              break;
            }
          }
          FastErrorResult rv;
          // NOTE: This assert does NOT call the function.
          static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->TexImage2D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, MOZ_KnownLive(NonNullHelper(arg8)), rv))>, "Should be returning void here");
          MOZ_KnownLive(self)->TexImage2D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, MOZ_KnownLive(NonNullHelper(arg8)), rv);
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "WebGL2RenderingContext.texImage2D"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          args.rval().setUndefined();
          return true;
        } while (false);
        do {
          NonNull<mozilla::dom::VideoFrame> arg8;
          {
            // Our JSContext should be in the right global to do unwrapping in.
            nsresult rv = UnwrapObject<prototypes::id::VideoFrame, mozilla::dom::VideoFrame>(args[8], arg8, cx);
            if (NS_FAILED(rv)) {
              break;
            }
          }
          FastErrorResult rv;
          // NOTE: This assert does NOT call the function.
          static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->TexImage2D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, MOZ_KnownLive(NonNullHelper(arg8)), rv))>, "Should be returning void here");
          MOZ_KnownLive(self)->TexImage2D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, MOZ_KnownLive(NonNullHelper(arg8)), rv);
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "WebGL2RenderingContext.texImage2D"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          args.rval().setUndefined();
          return true;
        } while (false);
      }
      int64_t arg8;
      if (!ValueToPrimitive<int64_t, eDefault>(cx, args[8], "Argument 9", &arg8)) {
        return false;
      }
      FastErrorResult rv;
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->TexImage2D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, rv))>, "Should be returning void here");
      MOZ_KnownLive(self)->TexImage2D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, rv);
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "WebGL2RenderingContext.texImage2D"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      args.rval().setUndefined();
      return true;
      break;
    }
    case 10: {
      uint32_t arg0;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
        return false;
      }
      int32_t arg1;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
        return false;
      }
      int32_t arg2;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
        return false;
      }
      int32_t arg3;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
        return false;
      }
      int32_t arg4;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[4], "Argument 5", &arg4)) {
        return false;
      }
      int32_t arg5;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[5], "Argument 6", &arg5)) {
        return false;
      }
      uint32_t arg6;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[6], "Argument 7", &arg6)) {
        return false;
      }
      uint32_t arg7;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[7], "Argument 8", &arg7)) {
        return false;
      }
      RootedSpiderMonkeyInterface<ArrayBufferView> arg8(cx);
      if (args[8].isObject()) {
        if (!arg8.Init(&args[8].toObject())) {
          cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 9", "ArrayBufferView");
          return false;
        }
        if (JS::IsLargeArrayBufferView(arg8.Obj())) {
          cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_LARGE>("Argument 9");
          return false;
        }
        if (JS::IsResizableArrayBufferView(arg8.Obj())) {
          cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_RESIZABLE>("Argument 9");
          return false;
        }
        if (JS::IsImmutableArrayBufferView(arg8.Obj())) {
          cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_IMMUTABLE>("Argument 9");
          return false;
        }
      } else {
        cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 9");
        return false;
      }
      uint32_t arg9;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[9], "Argument 10", &arg9)) {
        return false;
      }
      FastErrorResult rv;
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->TexImage2D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, Constify(arg8), arg9, rv))>, "Should be returning void here");
      MOZ_KnownLive(self)->TexImage2D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, Constify(arg8), arg9, rv);
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "WebGL2RenderingContext.texImage2D"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      args.rval().setUndefined();
      return true;
      break;
    }
    default: {
      // Using nsPrintfCString here would require including that
      // header.  Let's not worry about it.
      nsAutoCString argCountStr;
      argCountStr.AppendPrintf("%u", args.length());
      return cx.ThrowErrorMessage<MSG_INVALID_OVERLOAD_ARGCOUNT>(argCountStr.get());
    }
  }
  MOZ_CRASH("We have an always-returning default case");
  return false;
}

static const JSJitInfo texImage2D_methodinfo = {
  { (JSJitGetterOp)texImage2D },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
texSubImage2D(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.texSubImage2D");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "texSubImage2D", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  unsigned argcount = std::min(args.length(), 10u);
  switch (argcount) {
    case 7: {
      uint32_t arg0;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
        return false;
      }
      int32_t arg1;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
        return false;
      }
      int32_t arg2;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
        return false;
      }
      int32_t arg3;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
        return false;
      }
      uint32_t arg4;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[4], "Argument 5", &arg4)) {
        return false;
      }
      uint32_t arg5;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[5], "Argument 6", &arg5)) {
        return false;
      }
      if (args[6].isObject()) {
        do {
          NonNull<mozilla::dom::HTMLCanvasElement> arg6;
          {
            // Our JSContext should be in the right global to do unwrapping in.
            nsresult rv = UnwrapObject<prototypes::id::HTMLCanvasElement, mozilla::dom::HTMLCanvasElement>(args[6], arg6, cx);
            if (NS_FAILED(rv)) {
              break;
            }
          }
          FastErrorResult rv;
          // NOTE: This assert does NOT call the function.
          static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->TexSubImage2D(arg0, arg1, arg2, arg3, arg4, arg5, MOZ_KnownLive(NonNullHelper(arg6)), rv))>, "Should be returning void here");
          MOZ_KnownLive(self)->TexSubImage2D(arg0, arg1, arg2, arg3, arg4, arg5, MOZ_KnownLive(NonNullHelper(arg6)), rv);
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "WebGL2RenderingContext.texSubImage2D"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          args.rval().setUndefined();
          return true;
        } while (false);
        do {
          NonNull<mozilla::dom::HTMLImageElement> arg6;
          {
            // Our JSContext should be in the right global to do unwrapping in.
            nsresult rv = UnwrapObject<prototypes::id::HTMLImageElement, mozilla::dom::HTMLImageElement>(args[6], arg6, cx);
            if (NS_FAILED(rv)) {
              break;
            }
          }
          FastErrorResult rv;
          // NOTE: This assert does NOT call the function.
          static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->TexSubImage2D(arg0, arg1, arg2, arg3, arg4, arg5, MOZ_KnownLive(NonNullHelper(arg6)), rv))>, "Should be returning void here");
          MOZ_KnownLive(self)->TexSubImage2D(arg0, arg1, arg2, arg3, arg4, arg5, MOZ_KnownLive(NonNullHelper(arg6)), rv);
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "WebGL2RenderingContext.texSubImage2D"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          args.rval().setUndefined();
          return true;
        } while (false);
        do {
          NonNull<mozilla::dom::HTMLVideoElement> arg6;
          {
            // Our JSContext should be in the right global to do unwrapping in.
            nsresult rv = UnwrapObject<prototypes::id::HTMLVideoElement, mozilla::dom::HTMLVideoElement>(args[6], arg6, cx);
            if (NS_FAILED(rv)) {
              break;
            }
          }
          FastErrorResult rv;
          // NOTE: This assert does NOT call the function.
          static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->TexSubImage2D(arg0, arg1, arg2, arg3, arg4, arg5, MOZ_KnownLive(NonNullHelper(arg6)), rv))>, "Should be returning void here");
          MOZ_KnownLive(self)->TexSubImage2D(arg0, arg1, arg2, arg3, arg4, arg5, MOZ_KnownLive(NonNullHelper(arg6)), rv);
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "WebGL2RenderingContext.texSubImage2D"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          args.rval().setUndefined();
          return true;
        } while (false);
        do {
          NonNull<mozilla::dom::ImageBitmap> arg6;
          {
            // Our JSContext should be in the right global to do unwrapping in.
            nsresult rv = UnwrapObject<prototypes::id::ImageBitmap, mozilla::dom::ImageBitmap>(args[6], arg6, cx);
            if (NS_FAILED(rv)) {
              break;
            }
          }
          FastErrorResult rv;
          // NOTE: This assert does NOT call the function.
          static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->TexSubImage2D(arg0, arg1, arg2, arg3, arg4, arg5, MOZ_KnownLive(NonNullHelper(arg6)), rv))>, "Should be returning void here");
          MOZ_KnownLive(self)->TexSubImage2D(arg0, arg1, arg2, arg3, arg4, arg5, MOZ_KnownLive(NonNullHelper(arg6)), rv);
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "WebGL2RenderingContext.texSubImage2D"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          args.rval().setUndefined();
          return true;
        } while (false);
        do {
          NonNull<mozilla::dom::ImageData> arg6;
          {
            // Our JSContext should be in the right global to do unwrapping in.
            nsresult rv = UnwrapObject<prototypes::id::ImageData, mozilla::dom::ImageData>(args[6], arg6, cx);
            if (NS_FAILED(rv)) {
              break;
            }
          }
          FastErrorResult rv;
          // NOTE: This assert does NOT call the function.
          static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->TexSubImage2D(arg0, arg1, arg2, arg3, arg4, arg5, MOZ_KnownLive(NonNullHelper(arg6)), rv))>, "Should be returning void here");
          MOZ_KnownLive(self)->TexSubImage2D(arg0, arg1, arg2, arg3, arg4, arg5, MOZ_KnownLive(NonNullHelper(arg6)), rv);
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "WebGL2RenderingContext.texSubImage2D"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          args.rval().setUndefined();
          return true;
        } while (false);
        do {
          NonNull<mozilla::dom::OffscreenCanvas> arg6;
          {
            // Our JSContext should be in the right global to do unwrapping in.
            nsresult rv = UnwrapObject<prototypes::id::OffscreenCanvas, mozilla::dom::OffscreenCanvas>(args[6], arg6, cx);
            if (NS_FAILED(rv)) {
              break;
            }
          }
          FastErrorResult rv;
          // NOTE: This assert does NOT call the function.
          static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->TexSubImage2D(arg0, arg1, arg2, arg3, arg4, arg5, MOZ_KnownLive(NonNullHelper(arg6)), rv))>, "Should be returning void here");
          MOZ_KnownLive(self)->TexSubImage2D(arg0, arg1, arg2, arg3, arg4, arg5, MOZ_KnownLive(NonNullHelper(arg6)), rv);
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "WebGL2RenderingContext.texSubImage2D"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          args.rval().setUndefined();
          return true;
        } while (false);
        do {
          NonNull<mozilla::dom::VideoFrame> arg6;
          {
            // Our JSContext should be in the right global to do unwrapping in.
            nsresult rv = UnwrapObject<prototypes::id::VideoFrame, mozilla::dom::VideoFrame>(args[6], arg6, cx);
            if (NS_FAILED(rv)) {
              break;
            }
          }
          FastErrorResult rv;
          // NOTE: This assert does NOT call the function.
          static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->TexSubImage2D(arg0, arg1, arg2, arg3, arg4, arg5, MOZ_KnownLive(NonNullHelper(arg6)), rv))>, "Should be returning void here");
          MOZ_KnownLive(self)->TexSubImage2D(arg0, arg1, arg2, arg3, arg4, arg5, MOZ_KnownLive(NonNullHelper(arg6)), rv);
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "WebGL2RenderingContext.texSubImage2D"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          args.rval().setUndefined();
          return true;
        } while (false);
      }
      return cx.ThrowErrorMessage<MSG_OVERLOAD_RESOLUTION_FAILED>("7", "7");
      break;
    }
    case 9: {
      uint32_t arg0;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
        return false;
      }
      int32_t arg1;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
        return false;
      }
      int32_t arg2;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
        return false;
      }
      int32_t arg3;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
        return false;
      }
      int32_t arg4;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[4], "Argument 5", &arg4)) {
        return false;
      }
      int32_t arg5;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[5], "Argument 6", &arg5)) {
        return false;
      }
      uint32_t arg6;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[6], "Argument 7", &arg6)) {
        return false;
      }
      uint32_t arg7;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[7], "Argument 8", &arg7)) {
        return false;
      }
      if (args[8].isNullOrUndefined()) {
        RootedSpiderMonkeyInterface<Nullable<ArrayBufferView>> arg8(cx);
        arg8.SetNull();
        FastErrorResult rv;
        // NOTE: This assert does NOT call the function.
        static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->TexSubImage2D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, Constify(arg8), rv))>, "Should be returning void here");
        MOZ_KnownLive(self)->TexSubImage2D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, Constify(arg8), rv);
        if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "WebGL2RenderingContext.texSubImage2D"))) {
          return false;
        }
        MOZ_ASSERT(!JS_IsExceptionPending(cx));
        args.rval().setUndefined();
        return true;
      }
      if (args[8].isObject()) {
        do {
          RootedSpiderMonkeyInterface<Nullable<ArrayBufferView>> arg8(cx);
          if (!arg8.SetValue().Init(&args[8].toObject())) {
            break;
          }
          if (JS::IsLargeArrayBufferView(arg8.SetValue().Obj())) {
            cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_LARGE>("Argument 9");
            return false;
          }
          if (JS::IsResizableArrayBufferView(arg8.SetValue().Obj())) {
            cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_RESIZABLE>("Argument 9");
            return false;
          }
          if (JS::IsImmutableArrayBufferView(arg8.SetValue().Obj())) {
            cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_IMMUTABLE>("Argument 9");
            return false;
          }
          FastErrorResult rv;
          // NOTE: This assert does NOT call the function.
          static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->TexSubImage2D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, Constify(arg8), rv))>, "Should be returning void here");
          MOZ_KnownLive(self)->TexSubImage2D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, Constify(arg8), rv);
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "WebGL2RenderingContext.texSubImage2D"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          args.rval().setUndefined();
          return true;
        } while (false);
        do {
          NonNull<mozilla::dom::HTMLCanvasElement> arg8;
          {
            // Our JSContext should be in the right global to do unwrapping in.
            nsresult rv = UnwrapObject<prototypes::id::HTMLCanvasElement, mozilla::dom::HTMLCanvasElement>(args[8], arg8, cx);
            if (NS_FAILED(rv)) {
              break;
            }
          }
          FastErrorResult rv;
          // NOTE: This assert does NOT call the function.
          static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->TexSubImage2D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, MOZ_KnownLive(NonNullHelper(arg8)), rv))>, "Should be returning void here");
          MOZ_KnownLive(self)->TexSubImage2D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, MOZ_KnownLive(NonNullHelper(arg8)), rv);
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "WebGL2RenderingContext.texSubImage2D"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          args.rval().setUndefined();
          return true;
        } while (false);
        do {
          NonNull<mozilla::dom::HTMLImageElement> arg8;
          {
            // Our JSContext should be in the right global to do unwrapping in.
            nsresult rv = UnwrapObject<prototypes::id::HTMLImageElement, mozilla::dom::HTMLImageElement>(args[8], arg8, cx);
            if (NS_FAILED(rv)) {
              break;
            }
          }
          FastErrorResult rv;
          // NOTE: This assert does NOT call the function.
          static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->TexSubImage2D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, MOZ_KnownLive(NonNullHelper(arg8)), rv))>, "Should be returning void here");
          MOZ_KnownLive(self)->TexSubImage2D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, MOZ_KnownLive(NonNullHelper(arg8)), rv);
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "WebGL2RenderingContext.texSubImage2D"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          args.rval().setUndefined();
          return true;
        } while (false);
        do {
          NonNull<mozilla::dom::HTMLVideoElement> arg8;
          {
            // Our JSContext should be in the right global to do unwrapping in.
            nsresult rv = UnwrapObject<prototypes::id::HTMLVideoElement, mozilla::dom::HTMLVideoElement>(args[8], arg8, cx);
            if (NS_FAILED(rv)) {
              break;
            }
          }
          FastErrorResult rv;
          // NOTE: This assert does NOT call the function.
          static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->TexSubImage2D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, MOZ_KnownLive(NonNullHelper(arg8)), rv))>, "Should be returning void here");
          MOZ_KnownLive(self)->TexSubImage2D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, MOZ_KnownLive(NonNullHelper(arg8)), rv);
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "WebGL2RenderingContext.texSubImage2D"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          args.rval().setUndefined();
          return true;
        } while (false);
        do {
          NonNull<mozilla::dom::ImageBitmap> arg8;
          {
            // Our JSContext should be in the right global to do unwrapping in.
            nsresult rv = UnwrapObject<prototypes::id::ImageBitmap, mozilla::dom::ImageBitmap>(args[8], arg8, cx);
            if (NS_FAILED(rv)) {
              break;
            }
          }
          FastErrorResult rv;
          // NOTE: This assert does NOT call the function.
          static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->TexSubImage2D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, MOZ_KnownLive(NonNullHelper(arg8)), rv))>, "Should be returning void here");
          MOZ_KnownLive(self)->TexSubImage2D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, MOZ_KnownLive(NonNullHelper(arg8)), rv);
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "WebGL2RenderingContext.texSubImage2D"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          args.rval().setUndefined();
          return true;
        } while (false);
        do {
          NonNull<mozilla::dom::ImageData> arg8;
          {
            // Our JSContext should be in the right global to do unwrapping in.
            nsresult rv = UnwrapObject<prototypes::id::ImageData, mozilla::dom::ImageData>(args[8], arg8, cx);
            if (NS_FAILED(rv)) {
              break;
            }
          }
          FastErrorResult rv;
          // NOTE: This assert does NOT call the function.
          static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->TexSubImage2D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, MOZ_KnownLive(NonNullHelper(arg8)), rv))>, "Should be returning void here");
          MOZ_KnownLive(self)->TexSubImage2D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, MOZ_KnownLive(NonNullHelper(arg8)), rv);
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "WebGL2RenderingContext.texSubImage2D"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          args.rval().setUndefined();
          return true;
        } while (false);
        do {
          NonNull<mozilla::dom::OffscreenCanvas> arg8;
          {
            // Our JSContext should be in the right global to do unwrapping in.
            nsresult rv = UnwrapObject<prototypes::id::OffscreenCanvas, mozilla::dom::OffscreenCanvas>(args[8], arg8, cx);
            if (NS_FAILED(rv)) {
              break;
            }
          }
          FastErrorResult rv;
          // NOTE: This assert does NOT call the function.
          static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->TexSubImage2D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, MOZ_KnownLive(NonNullHelper(arg8)), rv))>, "Should be returning void here");
          MOZ_KnownLive(self)->TexSubImage2D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, MOZ_KnownLive(NonNullHelper(arg8)), rv);
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "WebGL2RenderingContext.texSubImage2D"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          args.rval().setUndefined();
          return true;
        } while (false);
        do {
          NonNull<mozilla::dom::VideoFrame> arg8;
          {
            // Our JSContext should be in the right global to do unwrapping in.
            nsresult rv = UnwrapObject<prototypes::id::VideoFrame, mozilla::dom::VideoFrame>(args[8], arg8, cx);
            if (NS_FAILED(rv)) {
              break;
            }
          }
          FastErrorResult rv;
          // NOTE: This assert does NOT call the function.
          static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->TexSubImage2D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, MOZ_KnownLive(NonNullHelper(arg8)), rv))>, "Should be returning void here");
          MOZ_KnownLive(self)->TexSubImage2D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, MOZ_KnownLive(NonNullHelper(arg8)), rv);
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "WebGL2RenderingContext.texSubImage2D"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          args.rval().setUndefined();
          return true;
        } while (false);
      }
      int64_t arg8;
      if (!ValueToPrimitive<int64_t, eDefault>(cx, args[8], "Argument 9", &arg8)) {
        return false;
      }
      FastErrorResult rv;
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->TexSubImage2D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, rv))>, "Should be returning void here");
      MOZ_KnownLive(self)->TexSubImage2D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, rv);
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "WebGL2RenderingContext.texSubImage2D"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      args.rval().setUndefined();
      return true;
      break;
    }
    case 10: {
      uint32_t arg0;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
        return false;
      }
      int32_t arg1;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
        return false;
      }
      int32_t arg2;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
        return false;
      }
      int32_t arg3;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
        return false;
      }
      int32_t arg4;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[4], "Argument 5", &arg4)) {
        return false;
      }
      int32_t arg5;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[5], "Argument 6", &arg5)) {
        return false;
      }
      uint32_t arg6;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[6], "Argument 7", &arg6)) {
        return false;
      }
      uint32_t arg7;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[7], "Argument 8", &arg7)) {
        return false;
      }
      RootedSpiderMonkeyInterface<ArrayBufferView> arg8(cx);
      if (args[8].isObject()) {
        if (!arg8.Init(&args[8].toObject())) {
          cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 9", "ArrayBufferView");
          return false;
        }
        if (JS::IsLargeArrayBufferView(arg8.Obj())) {
          cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_LARGE>("Argument 9");
          return false;
        }
        if (JS::IsResizableArrayBufferView(arg8.Obj())) {
          cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_RESIZABLE>("Argument 9");
          return false;
        }
        if (JS::IsImmutableArrayBufferView(arg8.Obj())) {
          cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_IMMUTABLE>("Argument 9");
          return false;
        }
      } else {
        cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 9");
        return false;
      }
      uint32_t arg9;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[9], "Argument 10", &arg9)) {
        return false;
      }
      FastErrorResult rv;
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->TexSubImage2D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, Constify(arg8), arg9, rv))>, "Should be returning void here");
      MOZ_KnownLive(self)->TexSubImage2D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, Constify(arg8), arg9, rv);
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "WebGL2RenderingContext.texSubImage2D"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      args.rval().setUndefined();
      return true;
      break;
    }
    default: {
      // Using nsPrintfCString here would require including that
      // header.  Let's not worry about it.
      nsAutoCString argCountStr;
      argCountStr.AppendPrintf("%u", args.length());
      return cx.ThrowErrorMessage<MSG_INVALID_OVERLOAD_ARGCOUNT>(argCountStr.get());
    }
  }
  MOZ_CRASH("We have an always-returning default case");
  return false;
}

static const JSJitInfo texSubImage2D_methodinfo = {
  { (JSJitGetterOp)texSubImage2D },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
texImage3D(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.texImage3D");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "texImage3D", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  unsigned argcount = std::min(args.length(), 11u);
  switch (argcount) {
    case 10: {
      uint32_t arg0;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
        return false;
      }
      int32_t arg1;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
        return false;
      }
      int32_t arg2;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
        return false;
      }
      int32_t arg3;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
        return false;
      }
      int32_t arg4;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[4], "Argument 5", &arg4)) {
        return false;
      }
      int32_t arg5;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[5], "Argument 6", &arg5)) {
        return false;
      }
      int32_t arg6;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[6], "Argument 7", &arg6)) {
        return false;
      }
      uint32_t arg7;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[7], "Argument 8", &arg7)) {
        return false;
      }
      uint32_t arg8;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[8], "Argument 9", &arg8)) {
        return false;
      }
      if (args[9].isNullOrUndefined()) {
        RootedSpiderMonkeyInterface<Nullable<ArrayBufferView>> arg9(cx);
        arg9.SetNull();
        FastErrorResult rv;
        // NOTE: This assert does NOT call the function.
        static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->TexImage3D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, Constify(arg9), rv))>, "Should be returning void here");
        MOZ_KnownLive(self)->TexImage3D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, Constify(arg9), rv);
        if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "WebGL2RenderingContext.texImage3D"))) {
          return false;
        }
        MOZ_ASSERT(!JS_IsExceptionPending(cx));
        args.rval().setUndefined();
        return true;
      }
      if (args[9].isObject()) {
        do {
          NonNull<mozilla::dom::HTMLCanvasElement> arg9;
          {
            // Our JSContext should be in the right global to do unwrapping in.
            nsresult rv = UnwrapObject<prototypes::id::HTMLCanvasElement, mozilla::dom::HTMLCanvasElement>(args[9], arg9, cx);
            if (NS_FAILED(rv)) {
              break;
            }
          }
          FastErrorResult rv;
          // NOTE: This assert does NOT call the function.
          static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->TexImage3D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, MOZ_KnownLive(NonNullHelper(arg9)), rv))>, "Should be returning void here");
          MOZ_KnownLive(self)->TexImage3D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, MOZ_KnownLive(NonNullHelper(arg9)), rv);
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "WebGL2RenderingContext.texImage3D"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          args.rval().setUndefined();
          return true;
        } while (false);
        do {
          NonNull<mozilla::dom::HTMLImageElement> arg9;
          {
            // Our JSContext should be in the right global to do unwrapping in.
            nsresult rv = UnwrapObject<prototypes::id::HTMLImageElement, mozilla::dom::HTMLImageElement>(args[9], arg9, cx);
            if (NS_FAILED(rv)) {
              break;
            }
          }
          FastErrorResult rv;
          // NOTE: This assert does NOT call the function.
          static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->TexImage3D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, MOZ_KnownLive(NonNullHelper(arg9)), rv))>, "Should be returning void here");
          MOZ_KnownLive(self)->TexImage3D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, MOZ_KnownLive(NonNullHelper(arg9)), rv);
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "WebGL2RenderingContext.texImage3D"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          args.rval().setUndefined();
          return true;
        } while (false);
        do {
          NonNull<mozilla::dom::HTMLVideoElement> arg9;
          {
            // Our JSContext should be in the right global to do unwrapping in.
            nsresult rv = UnwrapObject<prototypes::id::HTMLVideoElement, mozilla::dom::HTMLVideoElement>(args[9], arg9, cx);
            if (NS_FAILED(rv)) {
              break;
            }
          }
          FastErrorResult rv;
          // NOTE: This assert does NOT call the function.
          static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->TexImage3D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, MOZ_KnownLive(NonNullHelper(arg9)), rv))>, "Should be returning void here");
          MOZ_KnownLive(self)->TexImage3D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, MOZ_KnownLive(NonNullHelper(arg9)), rv);
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "WebGL2RenderingContext.texImage3D"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          args.rval().setUndefined();
          return true;
        } while (false);
        do {
          NonNull<mozilla::dom::ImageBitmap> arg9;
          {
            // Our JSContext should be in the right global to do unwrapping in.
            nsresult rv = UnwrapObject<prototypes::id::ImageBitmap, mozilla::dom::ImageBitmap>(args[9], arg9, cx);
            if (NS_FAILED(rv)) {
              break;
            }
          }
          FastErrorResult rv;
          // NOTE: This assert does NOT call the function.
          static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->TexImage3D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, MOZ_KnownLive(NonNullHelper(arg9)), rv))>, "Should be returning void here");
          MOZ_KnownLive(self)->TexImage3D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, MOZ_KnownLive(NonNullHelper(arg9)), rv);
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "WebGL2RenderingContext.texImage3D"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          args.rval().setUndefined();
          return true;
        } while (false);
        do {
          NonNull<mozilla::dom::ImageData> arg9;
          {
            // Our JSContext should be in the right global to do unwrapping in.
            nsresult rv = UnwrapObject<prototypes::id::ImageData, mozilla::dom::ImageData>(args[9], arg9, cx);
            if (NS_FAILED(rv)) {
              break;
            }
          }
          FastErrorResult rv;
          // NOTE: This assert does NOT call the function.
          static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->TexImage3D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, MOZ_KnownLive(NonNullHelper(arg9)), rv))>, "Should be returning void here");
          MOZ_KnownLive(self)->TexImage3D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, MOZ_KnownLive(NonNullHelper(arg9)), rv);
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "WebGL2RenderingContext.texImage3D"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          args.rval().setUndefined();
          return true;
        } while (false);
        do {
          NonNull<mozilla::dom::OffscreenCanvas> arg9;
          {
            // Our JSContext should be in the right global to do unwrapping in.
            nsresult rv = UnwrapObject<prototypes::id::OffscreenCanvas, mozilla::dom::OffscreenCanvas>(args[9], arg9, cx);
            if (NS_FAILED(rv)) {
              break;
            }
          }
          FastErrorResult rv;
          // NOTE: This assert does NOT call the function.
          static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->TexImage3D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, MOZ_KnownLive(NonNullHelper(arg9)), rv))>, "Should be returning void here");
          MOZ_KnownLive(self)->TexImage3D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, MOZ_KnownLive(NonNullHelper(arg9)), rv);
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "WebGL2RenderingContext.texImage3D"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          args.rval().setUndefined();
          return true;
        } while (false);
        do {
          NonNull<mozilla::dom::VideoFrame> arg9;
          {
            // Our JSContext should be in the right global to do unwrapping in.
            nsresult rv = UnwrapObject<prototypes::id::VideoFrame, mozilla::dom::VideoFrame>(args[9], arg9, cx);
            if (NS_FAILED(rv)) {
              break;
            }
          }
          FastErrorResult rv;
          // NOTE: This assert does NOT call the function.
          static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->TexImage3D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, MOZ_KnownLive(NonNullHelper(arg9)), rv))>, "Should be returning void here");
          MOZ_KnownLive(self)->TexImage3D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, MOZ_KnownLive(NonNullHelper(arg9)), rv);
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "WebGL2RenderingContext.texImage3D"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          args.rval().setUndefined();
          return true;
        } while (false);
        do {
          RootedSpiderMonkeyInterface<Nullable<ArrayBufferView>> arg9(cx);
          if (!arg9.SetValue().Init(&args[9].toObject())) {
            break;
          }
          if (JS::IsLargeArrayBufferView(arg9.SetValue().Obj())) {
            cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_LARGE>("Argument 10");
            return false;
          }
          if (JS::IsResizableArrayBufferView(arg9.SetValue().Obj())) {
            cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_RESIZABLE>("Argument 10");
            return false;
          }
          if (JS::IsImmutableArrayBufferView(arg9.SetValue().Obj())) {
            cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_IMMUTABLE>("Argument 10");
            return false;
          }
          FastErrorResult rv;
          // NOTE: This assert does NOT call the function.
          static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->TexImage3D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, Constify(arg9), rv))>, "Should be returning void here");
          MOZ_KnownLive(self)->TexImage3D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, Constify(arg9), rv);
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "WebGL2RenderingContext.texImage3D"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          args.rval().setUndefined();
          return true;
        } while (false);
      }
      int64_t arg9;
      if (!ValueToPrimitive<int64_t, eDefault>(cx, args[9], "Argument 10", &arg9)) {
        return false;
      }
      FastErrorResult rv;
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->TexImage3D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, rv))>, "Should be returning void here");
      MOZ_KnownLive(self)->TexImage3D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, rv);
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "WebGL2RenderingContext.texImage3D"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      args.rval().setUndefined();
      return true;
      break;
    }
    case 11: {
      uint32_t arg0;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
        return false;
      }
      int32_t arg1;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
        return false;
      }
      int32_t arg2;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
        return false;
      }
      int32_t arg3;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
        return false;
      }
      int32_t arg4;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[4], "Argument 5", &arg4)) {
        return false;
      }
      int32_t arg5;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[5], "Argument 6", &arg5)) {
        return false;
      }
      int32_t arg6;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[6], "Argument 7", &arg6)) {
        return false;
      }
      uint32_t arg7;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[7], "Argument 8", &arg7)) {
        return false;
      }
      uint32_t arg8;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[8], "Argument 9", &arg8)) {
        return false;
      }
      RootedSpiderMonkeyInterface<ArrayBufferView> arg9(cx);
      if (args[9].isObject()) {
        if (!arg9.Init(&args[9].toObject())) {
          cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 10", "ArrayBufferView");
          return false;
        }
        if (JS::IsLargeArrayBufferView(arg9.Obj())) {
          cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_LARGE>("Argument 10");
          return false;
        }
        if (JS::IsResizableArrayBufferView(arg9.Obj())) {
          cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_RESIZABLE>("Argument 10");
          return false;
        }
        if (JS::IsImmutableArrayBufferView(arg9.Obj())) {
          cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_IMMUTABLE>("Argument 10");
          return false;
        }
      } else {
        cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 10");
        return false;
      }
      uint32_t arg10;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[10], "Argument 11", &arg10)) {
        return false;
      }
      FastErrorResult rv;
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->TexImage3D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, Constify(arg9), arg10, rv))>, "Should be returning void here");
      MOZ_KnownLive(self)->TexImage3D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, Constify(arg9), arg10, rv);
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "WebGL2RenderingContext.texImage3D"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      args.rval().setUndefined();
      return true;
      break;
    }
    default: {
      // Using nsPrintfCString here would require including that
      // header.  Let's not worry about it.
      nsAutoCString argCountStr;
      argCountStr.AppendPrintf("%u", args.length());
      return cx.ThrowErrorMessage<MSG_INVALID_OVERLOAD_ARGCOUNT>(argCountStr.get());
    }
  }
  MOZ_CRASH("We have an always-returning default case");
  return false;
}

static const JSJitInfo texImage3D_methodinfo = {
  { (JSJitGetterOp)texImage3D },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
texSubImage3D(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.texSubImage3D");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "texSubImage3D", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  unsigned argcount = std::min(args.length(), 12u);
  switch (argcount) {
    case 11: {
      uint32_t arg0;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
        return false;
      }
      int32_t arg1;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
        return false;
      }
      int32_t arg2;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
        return false;
      }
      int32_t arg3;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
        return false;
      }
      int32_t arg4;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[4], "Argument 5", &arg4)) {
        return false;
      }
      int32_t arg5;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[5], "Argument 6", &arg5)) {
        return false;
      }
      int32_t arg6;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[6], "Argument 7", &arg6)) {
        return false;
      }
      int32_t arg7;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[7], "Argument 8", &arg7)) {
        return false;
      }
      uint32_t arg8;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[8], "Argument 9", &arg8)) {
        return false;
      }
      uint32_t arg9;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[9], "Argument 10", &arg9)) {
        return false;
      }
      if (args[10].isNullOrUndefined()) {
        RootedSpiderMonkeyInterface<Nullable<ArrayBufferView>> arg10(cx);
        arg10.SetNull();
        uint32_t arg11;
        if (args.hasDefined(11)) {
          if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[11], "Argument 12", &arg11)) {
            return false;
          }
        } else {
          arg11 = 0U;
        }
        FastErrorResult rv;
        // NOTE: This assert does NOT call the function.
        static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->TexSubImage3D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, Constify(arg10), arg11, rv))>, "Should be returning void here");
        MOZ_KnownLive(self)->TexSubImage3D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, Constify(arg10), arg11, rv);
        if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "WebGL2RenderingContext.texSubImage3D"))) {
          return false;
        }
        MOZ_ASSERT(!JS_IsExceptionPending(cx));
        args.rval().setUndefined();
        return true;
      }
      if (args[10].isObject()) {
        do {
          NonNull<mozilla::dom::HTMLCanvasElement> arg10;
          {
            // Our JSContext should be in the right global to do unwrapping in.
            nsresult rv = UnwrapObject<prototypes::id::HTMLCanvasElement, mozilla::dom::HTMLCanvasElement>(args[10], arg10, cx);
            if (NS_FAILED(rv)) {
              break;
            }
          }
          FastErrorResult rv;
          // NOTE: This assert does NOT call the function.
          static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->TexSubImage3D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, MOZ_KnownLive(NonNullHelper(arg10)), rv))>, "Should be returning void here");
          MOZ_KnownLive(self)->TexSubImage3D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, MOZ_KnownLive(NonNullHelper(arg10)), rv);
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "WebGL2RenderingContext.texSubImage3D"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          args.rval().setUndefined();
          return true;
        } while (false);
        do {
          NonNull<mozilla::dom::HTMLImageElement> arg10;
          {
            // Our JSContext should be in the right global to do unwrapping in.
            nsresult rv = UnwrapObject<prototypes::id::HTMLImageElement, mozilla::dom::HTMLImageElement>(args[10], arg10, cx);
            if (NS_FAILED(rv)) {
              break;
            }
          }
          FastErrorResult rv;
          // NOTE: This assert does NOT call the function.
          static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->TexSubImage3D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, MOZ_KnownLive(NonNullHelper(arg10)), rv))>, "Should be returning void here");
          MOZ_KnownLive(self)->TexSubImage3D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, MOZ_KnownLive(NonNullHelper(arg10)), rv);
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "WebGL2RenderingContext.texSubImage3D"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          args.rval().setUndefined();
          return true;
        } while (false);
        do {
          NonNull<mozilla::dom::HTMLVideoElement> arg10;
          {
            // Our JSContext should be in the right global to do unwrapping in.
            nsresult rv = UnwrapObject<prototypes::id::HTMLVideoElement, mozilla::dom::HTMLVideoElement>(args[10], arg10, cx);
            if (NS_FAILED(rv)) {
              break;
            }
          }
          FastErrorResult rv;
          // NOTE: This assert does NOT call the function.
          static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->TexSubImage3D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, MOZ_KnownLive(NonNullHelper(arg10)), rv))>, "Should be returning void here");
          MOZ_KnownLive(self)->TexSubImage3D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, MOZ_KnownLive(NonNullHelper(arg10)), rv);
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "WebGL2RenderingContext.texSubImage3D"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          args.rval().setUndefined();
          return true;
        } while (false);
        do {
          NonNull<mozilla::dom::ImageBitmap> arg10;
          {
            // Our JSContext should be in the right global to do unwrapping in.
            nsresult rv = UnwrapObject<prototypes::id::ImageBitmap, mozilla::dom::ImageBitmap>(args[10], arg10, cx);
            if (NS_FAILED(rv)) {
              break;
            }
          }
          FastErrorResult rv;
          // NOTE: This assert does NOT call the function.
          static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->TexSubImage3D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, MOZ_KnownLive(NonNullHelper(arg10)), rv))>, "Should be returning void here");
          MOZ_KnownLive(self)->TexSubImage3D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, MOZ_KnownLive(NonNullHelper(arg10)), rv);
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "WebGL2RenderingContext.texSubImage3D"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          args.rval().setUndefined();
          return true;
        } while (false);
        do {
          NonNull<mozilla::dom::ImageData> arg10;
          {
            // Our JSContext should be in the right global to do unwrapping in.
            nsresult rv = UnwrapObject<prototypes::id::ImageData, mozilla::dom::ImageData>(args[10], arg10, cx);
            if (NS_FAILED(rv)) {
              break;
            }
          }
          FastErrorResult rv;
          // NOTE: This assert does NOT call the function.
          static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->TexSubImage3D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, MOZ_KnownLive(NonNullHelper(arg10)), rv))>, "Should be returning void here");
          MOZ_KnownLive(self)->TexSubImage3D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, MOZ_KnownLive(NonNullHelper(arg10)), rv);
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "WebGL2RenderingContext.texSubImage3D"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          args.rval().setUndefined();
          return true;
        } while (false);
        do {
          NonNull<mozilla::dom::OffscreenCanvas> arg10;
          {
            // Our JSContext should be in the right global to do unwrapping in.
            nsresult rv = UnwrapObject<prototypes::id::OffscreenCanvas, mozilla::dom::OffscreenCanvas>(args[10], arg10, cx);
            if (NS_FAILED(rv)) {
              break;
            }
          }
          FastErrorResult rv;
          // NOTE: This assert does NOT call the function.
          static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->TexSubImage3D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, MOZ_KnownLive(NonNullHelper(arg10)), rv))>, "Should be returning void here");
          MOZ_KnownLive(self)->TexSubImage3D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, MOZ_KnownLive(NonNullHelper(arg10)), rv);
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "WebGL2RenderingContext.texSubImage3D"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          args.rval().setUndefined();
          return true;
        } while (false);
        do {
          NonNull<mozilla::dom::VideoFrame> arg10;
          {
            // Our JSContext should be in the right global to do unwrapping in.
            nsresult rv = UnwrapObject<prototypes::id::VideoFrame, mozilla::dom::VideoFrame>(args[10], arg10, cx);
            if (NS_FAILED(rv)) {
              break;
            }
          }
          FastErrorResult rv;
          // NOTE: This assert does NOT call the function.
          static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->TexSubImage3D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, MOZ_KnownLive(NonNullHelper(arg10)), rv))>, "Should be returning void here");
          MOZ_KnownLive(self)->TexSubImage3D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, MOZ_KnownLive(NonNullHelper(arg10)), rv);
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "WebGL2RenderingContext.texSubImage3D"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          args.rval().setUndefined();
          return true;
        } while (false);
        do {
          RootedSpiderMonkeyInterface<Nullable<ArrayBufferView>> arg10(cx);
          if (!arg10.SetValue().Init(&args[10].toObject())) {
            break;
          }
          if (JS::IsLargeArrayBufferView(arg10.SetValue().Obj())) {
            cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_LARGE>("Argument 11");
            return false;
          }
          if (JS::IsResizableArrayBufferView(arg10.SetValue().Obj())) {
            cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_RESIZABLE>("Argument 11");
            return false;
          }
          if (JS::IsImmutableArrayBufferView(arg10.SetValue().Obj())) {
            cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_IMMUTABLE>("Argument 11");
            return false;
          }
          uint32_t arg11;
          if (args.hasDefined(11)) {
            if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[11], "Argument 12", &arg11)) {
              return false;
            }
          } else {
            arg11 = 0U;
          }
          FastErrorResult rv;
          // NOTE: This assert does NOT call the function.
          static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->TexSubImage3D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, Constify(arg10), arg11, rv))>, "Should be returning void here");
          MOZ_KnownLive(self)->TexSubImage3D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, Constify(arg10), arg11, rv);
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "WebGL2RenderingContext.texSubImage3D"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          args.rval().setUndefined();
          return true;
        } while (false);
      }
      int64_t arg10;
      if (!ValueToPrimitive<int64_t, eDefault>(cx, args[10], "Argument 11", &arg10)) {
        return false;
      }
      FastErrorResult rv;
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->TexSubImage3D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, rv))>, "Should be returning void here");
      MOZ_KnownLive(self)->TexSubImage3D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, rv);
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "WebGL2RenderingContext.texSubImage3D"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      args.rval().setUndefined();
      return true;
      break;
    }
    case 12: {
      uint32_t arg0;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
        return false;
      }
      int32_t arg1;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
        return false;
      }
      int32_t arg2;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
        return false;
      }
      int32_t arg3;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
        return false;
      }
      int32_t arg4;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[4], "Argument 5", &arg4)) {
        return false;
      }
      int32_t arg5;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[5], "Argument 6", &arg5)) {
        return false;
      }
      int32_t arg6;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[6], "Argument 7", &arg6)) {
        return false;
      }
      int32_t arg7;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[7], "Argument 8", &arg7)) {
        return false;
      }
      uint32_t arg8;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[8], "Argument 9", &arg8)) {
        return false;
      }
      uint32_t arg9;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[9], "Argument 10", &arg9)) {
        return false;
      }
      RootedSpiderMonkeyInterface<Nullable<ArrayBufferView>> arg10(cx);
      if (args[10].isObject()) {
        if (!arg10.SetValue().Init(&args[10].toObject())) {
          cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 11", "ArrayBufferViewOrNull");
          return false;
        }
        if (JS::IsLargeArrayBufferView(arg10.SetValue().Obj())) {
          cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_LARGE>("Argument 11");
          return false;
        }
        if (JS::IsResizableArrayBufferView(arg10.SetValue().Obj())) {
          cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_RESIZABLE>("Argument 11");
          return false;
        }
        if (JS::IsImmutableArrayBufferView(arg10.SetValue().Obj())) {
          cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_IMMUTABLE>("Argument 11");
          return false;
        }
      } else if (args[10].isNullOrUndefined()) {
        arg10.SetNull();
      } else {
        cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 11");
        return false;
      }
      uint32_t arg11;
      if (args.hasDefined(11)) {
        if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[11], "Argument 12", &arg11)) {
          return false;
        }
      } else {
        arg11 = 0U;
      }
      FastErrorResult rv;
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->TexSubImage3D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, Constify(arg10), arg11, rv))>, "Should be returning void here");
      MOZ_KnownLive(self)->TexSubImage3D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, Constify(arg10), arg11, rv);
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "WebGL2RenderingContext.texSubImage3D"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      args.rval().setUndefined();
      return true;
      break;
    }
    default: {
      // Using nsPrintfCString here would require including that
      // header.  Let's not worry about it.
      nsAutoCString argCountStr;
      argCountStr.AppendPrintf("%u", args.length());
      return cx.ThrowErrorMessage<MSG_INVALID_OVERLOAD_ARGCOUNT>(argCountStr.get());
    }
  }
  MOZ_CRASH("We have an always-returning default case");
  return false;
}

static const JSJitInfo texSubImage3D_methodinfo = {
  { (JSJitGetterOp)texSubImage3D },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
copyTexSubImage3D(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "copyTexSubImage3D", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.copyTexSubImage3D", 9)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  int32_t arg1;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  int32_t arg2;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  }
  int32_t arg3;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
    return false;
  }
  int32_t arg4;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[4], "Argument 5", &arg4)) {
    return false;
  }
  int32_t arg5;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[5], "Argument 6", &arg5)) {
    return false;
  }
  int32_t arg6;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[6], "Argument 7", &arg6)) {
    return false;
  }
  int32_t arg7;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[7], "Argument 8", &arg7)) {
    return false;
  }
  int32_t arg8;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[8], "Argument 9", &arg8)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->CopyTexSubImage3D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8))>, "Should be returning void here");
  MOZ_KnownLive(self)->CopyTexSubImage3D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo copyTexSubImage3D_methodinfo = {
  { (JSJitGetterOp)copyTexSubImage3D },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
compressedTexImage2D(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.compressedTexImage2D");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "compressedTexImage2D", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  unsigned argcount = std::min(args.length(), 9u);
  switch (argcount) {
    case 7: {
      uint32_t arg0;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
        return false;
      }
      int32_t arg1;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
        return false;
      }
      uint32_t arg2;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
        return false;
      }
      int32_t arg3;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
        return false;
      }
      int32_t arg4;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[4], "Argument 5", &arg4)) {
        return false;
      }
      int32_t arg5;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[5], "Argument 6", &arg5)) {
        return false;
      }
      RootedSpiderMonkeyInterface<ArrayBufferView> arg6(cx);
      if (args[6].isObject()) {
        if (!arg6.Init(&args[6].toObject())) {
          cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 7", "ArrayBufferView");
          return false;
        }
        if (JS::IsLargeArrayBufferView(arg6.Obj())) {
          cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_LARGE>("Argument 7");
          return false;
        }
        if (JS::IsResizableArrayBufferView(arg6.Obj())) {
          cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_RESIZABLE>("Argument 7");
          return false;
        }
        if (JS::IsImmutableArrayBufferView(arg6.Obj())) {
          cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_IMMUTABLE>("Argument 7");
          return false;
        }
      } else {
        cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 7");
        return false;
      }
      uint32_t arg7;
      if (args.hasDefined(7)) {
        if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[7], "Argument 8", &arg7)) {
          return false;
        }
      } else {
        arg7 = 0U;
      }
      uint32_t arg8;
      if (args.hasDefined(8)) {
        if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[8], "Argument 9", &arg8)) {
          return false;
        }
      } else {
        arg8 = 0U;
      }
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->CompressedTexImage2D(arg0, arg1, arg2, arg3, arg4, arg5, Constify(arg6), arg7, arg8))>, "Should be returning void here");
      MOZ_KnownLive(self)->CompressedTexImage2D(arg0, arg1, arg2, arg3, arg4, arg5, Constify(arg6), arg7, arg8);
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      args.rval().setUndefined();
      return true;
      break;
    }
    case 8: {
      uint32_t arg0;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
        return false;
      }
      int32_t arg1;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
        return false;
      }
      uint32_t arg2;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
        return false;
      }
      int32_t arg3;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
        return false;
      }
      int32_t arg4;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[4], "Argument 5", &arg4)) {
        return false;
      }
      int32_t arg5;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[5], "Argument 6", &arg5)) {
        return false;
      }
      if (args[6].isObject()) {
        do {
          RootedSpiderMonkeyInterface<ArrayBufferView> arg6(cx);
          if (!arg6.Init(&args[6].toObject())) {
            break;
          }
          if (JS::IsLargeArrayBufferView(arg6.Obj())) {
            cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_LARGE>("Argument 7");
            return false;
          }
          if (JS::IsResizableArrayBufferView(arg6.Obj())) {
            cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_RESIZABLE>("Argument 7");
            return false;
          }
          if (JS::IsImmutableArrayBufferView(arg6.Obj())) {
            cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_IMMUTABLE>("Argument 7");
            return false;
          }
          uint32_t arg7;
          if (args.hasDefined(7)) {
            if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[7], "Argument 8", &arg7)) {
              return false;
            }
          } else {
            arg7 = 0U;
          }
          uint32_t arg8;
          if (args.hasDefined(8)) {
            if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[8], "Argument 9", &arg8)) {
              return false;
            }
          } else {
            arg8 = 0U;
          }
          // NOTE: This assert does NOT call the function.
          static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->CompressedTexImage2D(arg0, arg1, arg2, arg3, arg4, arg5, Constify(arg6), arg7, arg8))>, "Should be returning void here");
          MOZ_KnownLive(self)->CompressedTexImage2D(arg0, arg1, arg2, arg3, arg4, arg5, Constify(arg6), arg7, arg8);
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          args.rval().setUndefined();
          return true;
        } while (false);
      }
      int32_t arg6;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[6], "Argument 7", &arg6)) {
        return false;
      }
      int64_t arg7;
      if (!ValueToPrimitive<int64_t, eDefault>(cx, args[7], "Argument 8", &arg7)) {
        return false;
      }
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->CompressedTexImage2D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7))>, "Should be returning void here");
      MOZ_KnownLive(self)->CompressedTexImage2D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      args.rval().setUndefined();
      return true;
      break;
    }
    case 9: {
      uint32_t arg0;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
        return false;
      }
      int32_t arg1;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
        return false;
      }
      uint32_t arg2;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
        return false;
      }
      int32_t arg3;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
        return false;
      }
      int32_t arg4;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[4], "Argument 5", &arg4)) {
        return false;
      }
      int32_t arg5;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[5], "Argument 6", &arg5)) {
        return false;
      }
      RootedSpiderMonkeyInterface<ArrayBufferView> arg6(cx);
      if (args[6].isObject()) {
        if (!arg6.Init(&args[6].toObject())) {
          cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 7", "ArrayBufferView");
          return false;
        }
        if (JS::IsLargeArrayBufferView(arg6.Obj())) {
          cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_LARGE>("Argument 7");
          return false;
        }
        if (JS::IsResizableArrayBufferView(arg6.Obj())) {
          cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_RESIZABLE>("Argument 7");
          return false;
        }
        if (JS::IsImmutableArrayBufferView(arg6.Obj())) {
          cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_IMMUTABLE>("Argument 7");
          return false;
        }
      } else {
        cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 7");
        return false;
      }
      uint32_t arg7;
      if (args.hasDefined(7)) {
        if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[7], "Argument 8", &arg7)) {
          return false;
        }
      } else {
        arg7 = 0U;
      }
      uint32_t arg8;
      if (args.hasDefined(8)) {
        if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[8], "Argument 9", &arg8)) {
          return false;
        }
      } else {
        arg8 = 0U;
      }
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->CompressedTexImage2D(arg0, arg1, arg2, arg3, arg4, arg5, Constify(arg6), arg7, arg8))>, "Should be returning void here");
      MOZ_KnownLive(self)->CompressedTexImage2D(arg0, arg1, arg2, arg3, arg4, arg5, Constify(arg6), arg7, arg8);
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      args.rval().setUndefined();
      return true;
      break;
    }
    default: {
      // Using nsPrintfCString here would require including that
      // header.  Let's not worry about it.
      nsAutoCString argCountStr;
      argCountStr.AppendPrintf("%u", args.length());
      return cx.ThrowErrorMessage<MSG_INVALID_OVERLOAD_ARGCOUNT>(argCountStr.get());
    }
  }
  MOZ_CRASH("We have an always-returning default case");
  return false;
}

static const JSJitInfo compressedTexImage2D_methodinfo = {
  { (JSJitGetterOp)compressedTexImage2D },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
compressedTexImage3D(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.compressedTexImage3D");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "compressedTexImage3D", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  unsigned argcount = std::min(args.length(), 10u);
  switch (argcount) {
    case 8: {
      uint32_t arg0;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
        return false;
      }
      int32_t arg1;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
        return false;
      }
      uint32_t arg2;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
        return false;
      }
      int32_t arg3;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
        return false;
      }
      int32_t arg4;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[4], "Argument 5", &arg4)) {
        return false;
      }
      int32_t arg5;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[5], "Argument 6", &arg5)) {
        return false;
      }
      int32_t arg6;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[6], "Argument 7", &arg6)) {
        return false;
      }
      RootedSpiderMonkeyInterface<ArrayBufferView> arg7(cx);
      if (args[7].isObject()) {
        if (!arg7.Init(&args[7].toObject())) {
          cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 8", "ArrayBufferView");
          return false;
        }
        if (JS::IsLargeArrayBufferView(arg7.Obj())) {
          cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_LARGE>("Argument 8");
          return false;
        }
        if (JS::IsResizableArrayBufferView(arg7.Obj())) {
          cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_RESIZABLE>("Argument 8");
          return false;
        }
        if (JS::IsImmutableArrayBufferView(arg7.Obj())) {
          cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_IMMUTABLE>("Argument 8");
          return false;
        }
      } else {
        cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 8");
        return false;
      }
      uint32_t arg8;
      if (args.hasDefined(8)) {
        if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[8], "Argument 9", &arg8)) {
          return false;
        }
      } else {
        arg8 = 0U;
      }
      uint32_t arg9;
      if (args.hasDefined(9)) {
        if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[9], "Argument 10", &arg9)) {
          return false;
        }
      } else {
        arg9 = 0U;
      }
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->CompressedTexImage3D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, Constify(arg7), arg8, arg9))>, "Should be returning void here");
      MOZ_KnownLive(self)->CompressedTexImage3D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, Constify(arg7), arg8, arg9);
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      args.rval().setUndefined();
      return true;
      break;
    }
    case 9: {
      uint32_t arg0;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
        return false;
      }
      int32_t arg1;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
        return false;
      }
      uint32_t arg2;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
        return false;
      }
      int32_t arg3;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
        return false;
      }
      int32_t arg4;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[4], "Argument 5", &arg4)) {
        return false;
      }
      int32_t arg5;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[5], "Argument 6", &arg5)) {
        return false;
      }
      int32_t arg6;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[6], "Argument 7", &arg6)) {
        return false;
      }
      if (args[7].isObject()) {
        do {
          RootedSpiderMonkeyInterface<ArrayBufferView> arg7(cx);
          if (!arg7.Init(&args[7].toObject())) {
            break;
          }
          if (JS::IsLargeArrayBufferView(arg7.Obj())) {
            cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_LARGE>("Argument 8");
            return false;
          }
          if (JS::IsResizableArrayBufferView(arg7.Obj())) {
            cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_RESIZABLE>("Argument 8");
            return false;
          }
          if (JS::IsImmutableArrayBufferView(arg7.Obj())) {
            cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_IMMUTABLE>("Argument 8");
            return false;
          }
          uint32_t arg8;
          if (args.hasDefined(8)) {
            if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[8], "Argument 9", &arg8)) {
              return false;
            }
          } else {
            arg8 = 0U;
          }
          uint32_t arg9;
          if (args.hasDefined(9)) {
            if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[9], "Argument 10", &arg9)) {
              return false;
            }
          } else {
            arg9 = 0U;
          }
          // NOTE: This assert does NOT call the function.
          static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->CompressedTexImage3D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, Constify(arg7), arg8, arg9))>, "Should be returning void here");
          MOZ_KnownLive(self)->CompressedTexImage3D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, Constify(arg7), arg8, arg9);
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          args.rval().setUndefined();
          return true;
        } while (false);
      }
      int32_t arg7;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[7], "Argument 8", &arg7)) {
        return false;
      }
      int64_t arg8;
      if (!ValueToPrimitive<int64_t, eDefault>(cx, args[8], "Argument 9", &arg8)) {
        return false;
      }
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->CompressedTexImage3D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8))>, "Should be returning void here");
      MOZ_KnownLive(self)->CompressedTexImage3D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      args.rval().setUndefined();
      return true;
      break;
    }
    case 10: {
      uint32_t arg0;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
        return false;
      }
      int32_t arg1;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
        return false;
      }
      uint32_t arg2;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
        return false;
      }
      int32_t arg3;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
        return false;
      }
      int32_t arg4;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[4], "Argument 5", &arg4)) {
        return false;
      }
      int32_t arg5;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[5], "Argument 6", &arg5)) {
        return false;
      }
      int32_t arg6;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[6], "Argument 7", &arg6)) {
        return false;
      }
      RootedSpiderMonkeyInterface<ArrayBufferView> arg7(cx);
      if (args[7].isObject()) {
        if (!arg7.Init(&args[7].toObject())) {
          cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 8", "ArrayBufferView");
          return false;
        }
        if (JS::IsLargeArrayBufferView(arg7.Obj())) {
          cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_LARGE>("Argument 8");
          return false;
        }
        if (JS::IsResizableArrayBufferView(arg7.Obj())) {
          cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_RESIZABLE>("Argument 8");
          return false;
        }
        if (JS::IsImmutableArrayBufferView(arg7.Obj())) {
          cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_IMMUTABLE>("Argument 8");
          return false;
        }
      } else {
        cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 8");
        return false;
      }
      uint32_t arg8;
      if (args.hasDefined(8)) {
        if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[8], "Argument 9", &arg8)) {
          return false;
        }
      } else {
        arg8 = 0U;
      }
      uint32_t arg9;
      if (args.hasDefined(9)) {
        if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[9], "Argument 10", &arg9)) {
          return false;
        }
      } else {
        arg9 = 0U;
      }
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->CompressedTexImage3D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, Constify(arg7), arg8, arg9))>, "Should be returning void here");
      MOZ_KnownLive(self)->CompressedTexImage3D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, Constify(arg7), arg8, arg9);
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      args.rval().setUndefined();
      return true;
      break;
    }
    default: {
      // Using nsPrintfCString here would require including that
      // header.  Let's not worry about it.
      nsAutoCString argCountStr;
      argCountStr.AppendPrintf("%u", args.length());
      return cx.ThrowErrorMessage<MSG_INVALID_OVERLOAD_ARGCOUNT>(argCountStr.get());
    }
  }
  MOZ_CRASH("We have an always-returning default case");
  return false;
}

static const JSJitInfo compressedTexImage3D_methodinfo = {
  { (JSJitGetterOp)compressedTexImage3D },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
compressedTexSubImage2D(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.compressedTexSubImage2D");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "compressedTexSubImage2D", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  unsigned argcount = std::min(args.length(), 10u);
  switch (argcount) {
    case 8: {
      uint32_t arg0;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
        return false;
      }
      int32_t arg1;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
        return false;
      }
      int32_t arg2;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
        return false;
      }
      int32_t arg3;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
        return false;
      }
      int32_t arg4;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[4], "Argument 5", &arg4)) {
        return false;
      }
      int32_t arg5;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[5], "Argument 6", &arg5)) {
        return false;
      }
      uint32_t arg6;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[6], "Argument 7", &arg6)) {
        return false;
      }
      RootedSpiderMonkeyInterface<ArrayBufferView> arg7(cx);
      if (args[7].isObject()) {
        if (!arg7.Init(&args[7].toObject())) {
          cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 8", "ArrayBufferView");
          return false;
        }
        if (JS::IsLargeArrayBufferView(arg7.Obj())) {
          cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_LARGE>("Argument 8");
          return false;
        }
        if (JS::IsResizableArrayBufferView(arg7.Obj())) {
          cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_RESIZABLE>("Argument 8");
          return false;
        }
        if (JS::IsImmutableArrayBufferView(arg7.Obj())) {
          cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_IMMUTABLE>("Argument 8");
          return false;
        }
      } else {
        cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 8");
        return false;
      }
      uint32_t arg8;
      if (args.hasDefined(8)) {
        if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[8], "Argument 9", &arg8)) {
          return false;
        }
      } else {
        arg8 = 0U;
      }
      uint32_t arg9;
      if (args.hasDefined(9)) {
        if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[9], "Argument 10", &arg9)) {
          return false;
        }
      } else {
        arg9 = 0U;
      }
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->CompressedTexSubImage2D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, Constify(arg7), arg8, arg9))>, "Should be returning void here");
      MOZ_KnownLive(self)->CompressedTexSubImage2D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, Constify(arg7), arg8, arg9);
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      args.rval().setUndefined();
      return true;
      break;
    }
    case 9: {
      uint32_t arg0;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
        return false;
      }
      int32_t arg1;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
        return false;
      }
      int32_t arg2;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
        return false;
      }
      int32_t arg3;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
        return false;
      }
      int32_t arg4;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[4], "Argument 5", &arg4)) {
        return false;
      }
      int32_t arg5;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[5], "Argument 6", &arg5)) {
        return false;
      }
      uint32_t arg6;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[6], "Argument 7", &arg6)) {
        return false;
      }
      if (args[7].isObject()) {
        do {
          RootedSpiderMonkeyInterface<ArrayBufferView> arg7(cx);
          if (!arg7.Init(&args[7].toObject())) {
            break;
          }
          if (JS::IsLargeArrayBufferView(arg7.Obj())) {
            cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_LARGE>("Argument 8");
            return false;
          }
          if (JS::IsResizableArrayBufferView(arg7.Obj())) {
            cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_RESIZABLE>("Argument 8");
            return false;
          }
          if (JS::IsImmutableArrayBufferView(arg7.Obj())) {
            cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_IMMUTABLE>("Argument 8");
            return false;
          }
          uint32_t arg8;
          if (args.hasDefined(8)) {
            if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[8], "Argument 9", &arg8)) {
              return false;
            }
          } else {
            arg8 = 0U;
          }
          uint32_t arg9;
          if (args.hasDefined(9)) {
            if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[9], "Argument 10", &arg9)) {
              return false;
            }
          } else {
            arg9 = 0U;
          }
          // NOTE: This assert does NOT call the function.
          static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->CompressedTexSubImage2D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, Constify(arg7), arg8, arg9))>, "Should be returning void here");
          MOZ_KnownLive(self)->CompressedTexSubImage2D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, Constify(arg7), arg8, arg9);
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          args.rval().setUndefined();
          return true;
        } while (false);
      }
      int32_t arg7;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[7], "Argument 8", &arg7)) {
        return false;
      }
      int64_t arg8;
      if (!ValueToPrimitive<int64_t, eDefault>(cx, args[8], "Argument 9", &arg8)) {
        return false;
      }
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->CompressedTexSubImage2D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8))>, "Should be returning void here");
      MOZ_KnownLive(self)->CompressedTexSubImage2D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      args.rval().setUndefined();
      return true;
      break;
    }
    case 10: {
      uint32_t arg0;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
        return false;
      }
      int32_t arg1;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
        return false;
      }
      int32_t arg2;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
        return false;
      }
      int32_t arg3;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
        return false;
      }
      int32_t arg4;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[4], "Argument 5", &arg4)) {
        return false;
      }
      int32_t arg5;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[5], "Argument 6", &arg5)) {
        return false;
      }
      uint32_t arg6;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[6], "Argument 7", &arg6)) {
        return false;
      }
      RootedSpiderMonkeyInterface<ArrayBufferView> arg7(cx);
      if (args[7].isObject()) {
        if (!arg7.Init(&args[7].toObject())) {
          cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 8", "ArrayBufferView");
          return false;
        }
        if (JS::IsLargeArrayBufferView(arg7.Obj())) {
          cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_LARGE>("Argument 8");
          return false;
        }
        if (JS::IsResizableArrayBufferView(arg7.Obj())) {
          cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_RESIZABLE>("Argument 8");
          return false;
        }
        if (JS::IsImmutableArrayBufferView(arg7.Obj())) {
          cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_IMMUTABLE>("Argument 8");
          return false;
        }
      } else {
        cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 8");
        return false;
      }
      uint32_t arg8;
      if (args.hasDefined(8)) {
        if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[8], "Argument 9", &arg8)) {
          return false;
        }
      } else {
        arg8 = 0U;
      }
      uint32_t arg9;
      if (args.hasDefined(9)) {
        if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[9], "Argument 10", &arg9)) {
          return false;
        }
      } else {
        arg9 = 0U;
      }
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->CompressedTexSubImage2D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, Constify(arg7), arg8, arg9))>, "Should be returning void here");
      MOZ_KnownLive(self)->CompressedTexSubImage2D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, Constify(arg7), arg8, arg9);
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      args.rval().setUndefined();
      return true;
      break;
    }
    default: {
      // Using nsPrintfCString here would require including that
      // header.  Let's not worry about it.
      nsAutoCString argCountStr;
      argCountStr.AppendPrintf("%u", args.length());
      return cx.ThrowErrorMessage<MSG_INVALID_OVERLOAD_ARGCOUNT>(argCountStr.get());
    }
  }
  MOZ_CRASH("We have an always-returning default case");
  return false;
}

static const JSJitInfo compressedTexSubImage2D_methodinfo = {
  { (JSJitGetterOp)compressedTexSubImage2D },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
compressedTexSubImage3D(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.compressedTexSubImage3D");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "compressedTexSubImage3D", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  unsigned argcount = std::min(args.length(), 12u);
  switch (argcount) {
    case 10: {
      uint32_t arg0;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
        return false;
      }
      int32_t arg1;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
        return false;
      }
      int32_t arg2;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
        return false;
      }
      int32_t arg3;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
        return false;
      }
      int32_t arg4;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[4], "Argument 5", &arg4)) {
        return false;
      }
      int32_t arg5;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[5], "Argument 6", &arg5)) {
        return false;
      }
      int32_t arg6;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[6], "Argument 7", &arg6)) {
        return false;
      }
      int32_t arg7;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[7], "Argument 8", &arg7)) {
        return false;
      }
      uint32_t arg8;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[8], "Argument 9", &arg8)) {
        return false;
      }
      RootedSpiderMonkeyInterface<ArrayBufferView> arg9(cx);
      if (args[9].isObject()) {
        if (!arg9.Init(&args[9].toObject())) {
          cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 10", "ArrayBufferView");
          return false;
        }
        if (JS::IsLargeArrayBufferView(arg9.Obj())) {
          cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_LARGE>("Argument 10");
          return false;
        }
        if (JS::IsResizableArrayBufferView(arg9.Obj())) {
          cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_RESIZABLE>("Argument 10");
          return false;
        }
        if (JS::IsImmutableArrayBufferView(arg9.Obj())) {
          cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_IMMUTABLE>("Argument 10");
          return false;
        }
      } else {
        cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 10");
        return false;
      }
      uint32_t arg10;
      if (args.hasDefined(10)) {
        if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[10], "Argument 11", &arg10)) {
          return false;
        }
      } else {
        arg10 = 0U;
      }
      uint32_t arg11;
      if (args.hasDefined(11)) {
        if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[11], "Argument 12", &arg11)) {
          return false;
        }
      } else {
        arg11 = 0U;
      }
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->CompressedTexSubImage3D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, Constify(arg9), arg10, arg11))>, "Should be returning void here");
      MOZ_KnownLive(self)->CompressedTexSubImage3D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, Constify(arg9), arg10, arg11);
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      args.rval().setUndefined();
      return true;
      break;
    }
    case 11: {
      uint32_t arg0;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
        return false;
      }
      int32_t arg1;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
        return false;
      }
      int32_t arg2;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
        return false;
      }
      int32_t arg3;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
        return false;
      }
      int32_t arg4;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[4], "Argument 5", &arg4)) {
        return false;
      }
      int32_t arg5;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[5], "Argument 6", &arg5)) {
        return false;
      }
      int32_t arg6;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[6], "Argument 7", &arg6)) {
        return false;
      }
      int32_t arg7;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[7], "Argument 8", &arg7)) {
        return false;
      }
      uint32_t arg8;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[8], "Argument 9", &arg8)) {
        return false;
      }
      if (args[9].isObject()) {
        do {
          RootedSpiderMonkeyInterface<ArrayBufferView> arg9(cx);
          if (!arg9.Init(&args[9].toObject())) {
            break;
          }
          if (JS::IsLargeArrayBufferView(arg9.Obj())) {
            cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_LARGE>("Argument 10");
            return false;
          }
          if (JS::IsResizableArrayBufferView(arg9.Obj())) {
            cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_RESIZABLE>("Argument 10");
            return false;
          }
          if (JS::IsImmutableArrayBufferView(arg9.Obj())) {
            cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_IMMUTABLE>("Argument 10");
            return false;
          }
          uint32_t arg10;
          if (args.hasDefined(10)) {
            if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[10], "Argument 11", &arg10)) {
              return false;
            }
          } else {
            arg10 = 0U;
          }
          uint32_t arg11;
          if (args.hasDefined(11)) {
            if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[11], "Argument 12", &arg11)) {
              return false;
            }
          } else {
            arg11 = 0U;
          }
          // NOTE: This assert does NOT call the function.
          static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->CompressedTexSubImage3D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, Constify(arg9), arg10, arg11))>, "Should be returning void here");
          MOZ_KnownLive(self)->CompressedTexSubImage3D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, Constify(arg9), arg10, arg11);
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          args.rval().setUndefined();
          return true;
        } while (false);
      }
      int32_t arg9;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[9], "Argument 10", &arg9)) {
        return false;
      }
      int64_t arg10;
      if (!ValueToPrimitive<int64_t, eDefault>(cx, args[10], "Argument 11", &arg10)) {
        return false;
      }
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->CompressedTexSubImage3D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10))>, "Should be returning void here");
      MOZ_KnownLive(self)->CompressedTexSubImage3D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10);
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      args.rval().setUndefined();
      return true;
      break;
    }
    case 12: {
      uint32_t arg0;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
        return false;
      }
      int32_t arg1;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
        return false;
      }
      int32_t arg2;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
        return false;
      }
      int32_t arg3;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
        return false;
      }
      int32_t arg4;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[4], "Argument 5", &arg4)) {
        return false;
      }
      int32_t arg5;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[5], "Argument 6", &arg5)) {
        return false;
      }
      int32_t arg6;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[6], "Argument 7", &arg6)) {
        return false;
      }
      int32_t arg7;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[7], "Argument 8", &arg7)) {
        return false;
      }
      uint32_t arg8;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[8], "Argument 9", &arg8)) {
        return false;
      }
      RootedSpiderMonkeyInterface<ArrayBufferView> arg9(cx);
      if (args[9].isObject()) {
        if (!arg9.Init(&args[9].toObject())) {
          cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 10", "ArrayBufferView");
          return false;
        }
        if (JS::IsLargeArrayBufferView(arg9.Obj())) {
          cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_LARGE>("Argument 10");
          return false;
        }
        if (JS::IsResizableArrayBufferView(arg9.Obj())) {
          cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_RESIZABLE>("Argument 10");
          return false;
        }
        if (JS::IsImmutableArrayBufferView(arg9.Obj())) {
          cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_IMMUTABLE>("Argument 10");
          return false;
        }
      } else {
        cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 10");
        return false;
      }
      uint32_t arg10;
      if (args.hasDefined(10)) {
        if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[10], "Argument 11", &arg10)) {
          return false;
        }
      } else {
        arg10 = 0U;
      }
      uint32_t arg11;
      if (args.hasDefined(11)) {
        if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[11], "Argument 12", &arg11)) {
          return false;
        }
      } else {
        arg11 = 0U;
      }
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->CompressedTexSubImage3D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, Constify(arg9), arg10, arg11))>, "Should be returning void here");
      MOZ_KnownLive(self)->CompressedTexSubImage3D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, Constify(arg9), arg10, arg11);
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      args.rval().setUndefined();
      return true;
      break;
    }
    default: {
      // Using nsPrintfCString here would require including that
      // header.  Let's not worry about it.
      nsAutoCString argCountStr;
      argCountStr.AppendPrintf("%u", args.length());
      return cx.ThrowErrorMessage<MSG_INVALID_OVERLOAD_ARGCOUNT>(argCountStr.get());
    }
  }
  MOZ_CRASH("We have an always-returning default case");
  return false;
}

static const JSJitInfo compressedTexSubImage3D_methodinfo = {
  { (JSJitGetterOp)compressedTexSubImage3D },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getFragDataLocation(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.getFragDataLocation");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "getFragDataLocation", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.getFragDataLocation", 2)) {
    return false;
  }
  NonNull<mozilla::WebGLProgramJS> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLProgram, mozilla::WebGLProgramJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLProgram");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  binding_detail::FakeString<char16_t> arg1;
  if (!ConvertJSValueToString(cx, args[1], eStringify, eStringify, arg1)) {
    return false;
  }
  int32_t result(MOZ_KnownLive(self)->GetFragDataLocation(MOZ_KnownLive(NonNullHelper(arg0)), NonNullHelper(Constify(arg1))));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setInt32(int32_t(result));
  return true;
}

static const JSJitInfo getFragDataLocation_methodinfo = {
  { (JSJitGetterOp)getFragDataLocation },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_INT32,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
uniform1ui(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.uniform1ui");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "uniform1ui", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.uniform1ui", 2)) {
    return false;
  }
  mozilla::WebGLUniformLocationJS* arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLUniformLocation, mozilla::WebGLUniformLocationJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLUniformLocation");
        return false;
      }
    }
  } else if (args[0].isNullOrUndefined()) {
    arg0 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  uint32_t arg1;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Uniform1ui(MOZ_KnownLive(Constify(arg0)), arg1))>, "Should be returning void here");
  MOZ_KnownLive(self)->Uniform1ui(MOZ_KnownLive(Constify(arg0)), arg1);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo uniform1ui_methodinfo = {
  { (JSJitGetterOp)uniform1ui },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
uniform2ui(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.uniform2ui");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "uniform2ui", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.uniform2ui", 3)) {
    return false;
  }
  mozilla::WebGLUniformLocationJS* arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLUniformLocation, mozilla::WebGLUniformLocationJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLUniformLocation");
        return false;
      }
    }
  } else if (args[0].isNullOrUndefined()) {
    arg0 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  uint32_t arg1;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  uint32_t arg2;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Uniform2ui(MOZ_KnownLive(Constify(arg0)), arg1, arg2))>, "Should be returning void here");
  MOZ_KnownLive(self)->Uniform2ui(MOZ_KnownLive(Constify(arg0)), arg1, arg2);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo uniform2ui_methodinfo = {
  { (JSJitGetterOp)uniform2ui },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
uniform3ui(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.uniform3ui");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "uniform3ui", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.uniform3ui", 4)) {
    return false;
  }
  mozilla::WebGLUniformLocationJS* arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLUniformLocation, mozilla::WebGLUniformLocationJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLUniformLocation");
        return false;
      }
    }
  } else if (args[0].isNullOrUndefined()) {
    arg0 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  uint32_t arg1;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  uint32_t arg2;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  }
  uint32_t arg3;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Uniform3ui(MOZ_KnownLive(Constify(arg0)), arg1, arg2, arg3))>, "Should be returning void here");
  MOZ_KnownLive(self)->Uniform3ui(MOZ_KnownLive(Constify(arg0)), arg1, arg2, arg3);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo uniform3ui_methodinfo = {
  { (JSJitGetterOp)uniform3ui },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
uniform4ui(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.uniform4ui");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "uniform4ui", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.uniform4ui", 5)) {
    return false;
  }
  mozilla::WebGLUniformLocationJS* arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLUniformLocation, mozilla::WebGLUniformLocationJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLUniformLocation");
        return false;
      }
    }
  } else if (args[0].isNullOrUndefined()) {
    arg0 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  uint32_t arg1;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  uint32_t arg2;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  }
  uint32_t arg3;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
    return false;
  }
  uint32_t arg4;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[4], "Argument 5", &arg4)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Uniform4ui(MOZ_KnownLive(Constify(arg0)), arg1, arg2, arg3, arg4))>, "Should be returning void here");
  MOZ_KnownLive(self)->Uniform4ui(MOZ_KnownLive(Constify(arg0)), arg1, arg2, arg3, arg4);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo uniform4ui_methodinfo = {
  { (JSJitGetterOp)uniform4ui },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
uniform1fv(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.uniform1fv");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "uniform1fv", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.uniform1fv", 2)) {
    return false;
  }
  mozilla::WebGLUniformLocationJS* arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLUniformLocation, mozilla::WebGLUniformLocationJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLUniformLocation");
        return false;
      }
    }
  } else if (args[0].isNullOrUndefined()) {
    arg0 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  MaybeSharedFloat32ArrayOrUnrestrictedFloatSequence arg1;
  if (!arg1.Init(cx, args[1], "Argument 2", false)) {
    return false;
  }
  uint32_t arg2;
  if (args.hasDefined(2)) {
    if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
      return false;
    }
  } else {
    arg2 = 0U;
  }
  uint32_t arg3;
  if (args.hasDefined(3)) {
    if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
      return false;
    }
  } else {
    arg3 = 0U;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Uniform1fv(MOZ_KnownLive(Constify(arg0)), Constify(arg1), arg2, arg3))>, "Should be returning void here");
  MOZ_KnownLive(self)->Uniform1fv(MOZ_KnownLive(Constify(arg0)), Constify(arg1), arg2, arg3);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo uniform1fv_methodinfo = {
  { (JSJitGetterOp)uniform1fv },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
uniform2fv(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.uniform2fv");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "uniform2fv", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.uniform2fv", 2)) {
    return false;
  }
  mozilla::WebGLUniformLocationJS* arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLUniformLocation, mozilla::WebGLUniformLocationJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLUniformLocation");
        return false;
      }
    }
  } else if (args[0].isNullOrUndefined()) {
    arg0 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  MaybeSharedFloat32ArrayOrUnrestrictedFloatSequence arg1;
  if (!arg1.Init(cx, args[1], "Argument 2", false)) {
    return false;
  }
  uint32_t arg2;
  if (args.hasDefined(2)) {
    if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
      return false;
    }
  } else {
    arg2 = 0U;
  }
  uint32_t arg3;
  if (args.hasDefined(3)) {
    if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
      return false;
    }
  } else {
    arg3 = 0U;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Uniform2fv(MOZ_KnownLive(Constify(arg0)), Constify(arg1), arg2, arg3))>, "Should be returning void here");
  MOZ_KnownLive(self)->Uniform2fv(MOZ_KnownLive(Constify(arg0)), Constify(arg1), arg2, arg3);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo uniform2fv_methodinfo = {
  { (JSJitGetterOp)uniform2fv },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
uniform3fv(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.uniform3fv");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "uniform3fv", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.uniform3fv", 2)) {
    return false;
  }
  mozilla::WebGLUniformLocationJS* arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLUniformLocation, mozilla::WebGLUniformLocationJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLUniformLocation");
        return false;
      }
    }
  } else if (args[0].isNullOrUndefined()) {
    arg0 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  MaybeSharedFloat32ArrayOrUnrestrictedFloatSequence arg1;
  if (!arg1.Init(cx, args[1], "Argument 2", false)) {
    return false;
  }
  uint32_t arg2;
  if (args.hasDefined(2)) {
    if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
      return false;
    }
  } else {
    arg2 = 0U;
  }
  uint32_t arg3;
  if (args.hasDefined(3)) {
    if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
      return false;
    }
  } else {
    arg3 = 0U;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Uniform3fv(MOZ_KnownLive(Constify(arg0)), Constify(arg1), arg2, arg3))>, "Should be returning void here");
  MOZ_KnownLive(self)->Uniform3fv(MOZ_KnownLive(Constify(arg0)), Constify(arg1), arg2, arg3);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo uniform3fv_methodinfo = {
  { (JSJitGetterOp)uniform3fv },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
uniform4fv(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.uniform4fv");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "uniform4fv", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.uniform4fv", 2)) {
    return false;
  }
  mozilla::WebGLUniformLocationJS* arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLUniformLocation, mozilla::WebGLUniformLocationJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLUniformLocation");
        return false;
      }
    }
  } else if (args[0].isNullOrUndefined()) {
    arg0 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  MaybeSharedFloat32ArrayOrUnrestrictedFloatSequence arg1;
  if (!arg1.Init(cx, args[1], "Argument 2", false)) {
    return false;
  }
  uint32_t arg2;
  if (args.hasDefined(2)) {
    if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
      return false;
    }
  } else {
    arg2 = 0U;
  }
  uint32_t arg3;
  if (args.hasDefined(3)) {
    if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
      return false;
    }
  } else {
    arg3 = 0U;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Uniform4fv(MOZ_KnownLive(Constify(arg0)), Constify(arg1), arg2, arg3))>, "Should be returning void here");
  MOZ_KnownLive(self)->Uniform4fv(MOZ_KnownLive(Constify(arg0)), Constify(arg1), arg2, arg3);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo uniform4fv_methodinfo = {
  { (JSJitGetterOp)uniform4fv },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
uniform1iv(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.uniform1iv");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "uniform1iv", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.uniform1iv", 2)) {
    return false;
  }
  mozilla::WebGLUniformLocationJS* arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLUniformLocation, mozilla::WebGLUniformLocationJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLUniformLocation");
        return false;
      }
    }
  } else if (args[0].isNullOrUndefined()) {
    arg0 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  MaybeSharedInt32ArrayOrLongSequence arg1;
  if (!arg1.Init(cx, args[1], "Argument 2", false)) {
    return false;
  }
  uint32_t arg2;
  if (args.hasDefined(2)) {
    if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
      return false;
    }
  } else {
    arg2 = 0U;
  }
  uint32_t arg3;
  if (args.hasDefined(3)) {
    if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
      return false;
    }
  } else {
    arg3 = 0U;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Uniform1iv(MOZ_KnownLive(Constify(arg0)), Constify(arg1), arg2, arg3))>, "Should be returning void here");
  MOZ_KnownLive(self)->Uniform1iv(MOZ_KnownLive(Constify(arg0)), Constify(arg1), arg2, arg3);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo uniform1iv_methodinfo = {
  { (JSJitGetterOp)uniform1iv },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
uniform2iv(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.uniform2iv");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "uniform2iv", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.uniform2iv", 2)) {
    return false;
  }
  mozilla::WebGLUniformLocationJS* arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLUniformLocation, mozilla::WebGLUniformLocationJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLUniformLocation");
        return false;
      }
    }
  } else if (args[0].isNullOrUndefined()) {
    arg0 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  MaybeSharedInt32ArrayOrLongSequence arg1;
  if (!arg1.Init(cx, args[1], "Argument 2", false)) {
    return false;
  }
  uint32_t arg2;
  if (args.hasDefined(2)) {
    if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
      return false;
    }
  } else {
    arg2 = 0U;
  }
  uint32_t arg3;
  if (args.hasDefined(3)) {
    if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
      return false;
    }
  } else {
    arg3 = 0U;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Uniform2iv(MOZ_KnownLive(Constify(arg0)), Constify(arg1), arg2, arg3))>, "Should be returning void here");
  MOZ_KnownLive(self)->Uniform2iv(MOZ_KnownLive(Constify(arg0)), Constify(arg1), arg2, arg3);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo uniform2iv_methodinfo = {
  { (JSJitGetterOp)uniform2iv },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
uniform3iv(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.uniform3iv");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "uniform3iv", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.uniform3iv", 2)) {
    return false;
  }
  mozilla::WebGLUniformLocationJS* arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLUniformLocation, mozilla::WebGLUniformLocationJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLUniformLocation");
        return false;
      }
    }
  } else if (args[0].isNullOrUndefined()) {
    arg0 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  MaybeSharedInt32ArrayOrLongSequence arg1;
  if (!arg1.Init(cx, args[1], "Argument 2", false)) {
    return false;
  }
  uint32_t arg2;
  if (args.hasDefined(2)) {
    if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
      return false;
    }
  } else {
    arg2 = 0U;
  }
  uint32_t arg3;
  if (args.hasDefined(3)) {
    if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
      return false;
    }
  } else {
    arg3 = 0U;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Uniform3iv(MOZ_KnownLive(Constify(arg0)), Constify(arg1), arg2, arg3))>, "Should be returning void here");
  MOZ_KnownLive(self)->Uniform3iv(MOZ_KnownLive(Constify(arg0)), Constify(arg1), arg2, arg3);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo uniform3iv_methodinfo = {
  { (JSJitGetterOp)uniform3iv },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
uniform4iv(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.uniform4iv");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "uniform4iv", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.uniform4iv", 2)) {
    return false;
  }
  mozilla::WebGLUniformLocationJS* arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLUniformLocation, mozilla::WebGLUniformLocationJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLUniformLocation");
        return false;
      }
    }
  } else if (args[0].isNullOrUndefined()) {
    arg0 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  MaybeSharedInt32ArrayOrLongSequence arg1;
  if (!arg1.Init(cx, args[1], "Argument 2", false)) {
    return false;
  }
  uint32_t arg2;
  if (args.hasDefined(2)) {
    if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
      return false;
    }
  } else {
    arg2 = 0U;
  }
  uint32_t arg3;
  if (args.hasDefined(3)) {
    if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
      return false;
    }
  } else {
    arg3 = 0U;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Uniform4iv(MOZ_KnownLive(Constify(arg0)), Constify(arg1), arg2, arg3))>, "Should be returning void here");
  MOZ_KnownLive(self)->Uniform4iv(MOZ_KnownLive(Constify(arg0)), Constify(arg1), arg2, arg3);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo uniform4iv_methodinfo = {
  { (JSJitGetterOp)uniform4iv },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
uniform1uiv(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.uniform1uiv");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "uniform1uiv", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.uniform1uiv", 2)) {
    return false;
  }
  mozilla::WebGLUniformLocationJS* arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLUniformLocation, mozilla::WebGLUniformLocationJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLUniformLocation");
        return false;
      }
    }
  } else if (args[0].isNullOrUndefined()) {
    arg0 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  MaybeSharedUint32ArrayOrUnsignedLongSequence arg1;
  if (!arg1.Init(cx, args[1], "Argument 2", false)) {
    return false;
  }
  uint32_t arg2;
  if (args.hasDefined(2)) {
    if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
      return false;
    }
  } else {
    arg2 = 0U;
  }
  uint32_t arg3;
  if (args.hasDefined(3)) {
    if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
      return false;
    }
  } else {
    arg3 = 0U;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Uniform1uiv(MOZ_KnownLive(Constify(arg0)), Constify(arg1), arg2, arg3))>, "Should be returning void here");
  MOZ_KnownLive(self)->Uniform1uiv(MOZ_KnownLive(Constify(arg0)), Constify(arg1), arg2, arg3);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo uniform1uiv_methodinfo = {
  { (JSJitGetterOp)uniform1uiv },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
uniform2uiv(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.uniform2uiv");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "uniform2uiv", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.uniform2uiv", 2)) {
    return false;
  }
  mozilla::WebGLUniformLocationJS* arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLUniformLocation, mozilla::WebGLUniformLocationJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLUniformLocation");
        return false;
      }
    }
  } else if (args[0].isNullOrUndefined()) {
    arg0 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  MaybeSharedUint32ArrayOrUnsignedLongSequence arg1;
  if (!arg1.Init(cx, args[1], "Argument 2", false)) {
    return false;
  }
  uint32_t arg2;
  if (args.hasDefined(2)) {
    if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
      return false;
    }
  } else {
    arg2 = 0U;
  }
  uint32_t arg3;
  if (args.hasDefined(3)) {
    if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
      return false;
    }
  } else {
    arg3 = 0U;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Uniform2uiv(MOZ_KnownLive(Constify(arg0)), Constify(arg1), arg2, arg3))>, "Should be returning void here");
  MOZ_KnownLive(self)->Uniform2uiv(MOZ_KnownLive(Constify(arg0)), Constify(arg1), arg2, arg3);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo uniform2uiv_methodinfo = {
  { (JSJitGetterOp)uniform2uiv },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
uniform3uiv(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.uniform3uiv");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "uniform3uiv", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.uniform3uiv", 2)) {
    return false;
  }
  mozilla::WebGLUniformLocationJS* arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLUniformLocation, mozilla::WebGLUniformLocationJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLUniformLocation");
        return false;
      }
    }
  } else if (args[0].isNullOrUndefined()) {
    arg0 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  MaybeSharedUint32ArrayOrUnsignedLongSequence arg1;
  if (!arg1.Init(cx, args[1], "Argument 2", false)) {
    return false;
  }
  uint32_t arg2;
  if (args.hasDefined(2)) {
    if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
      return false;
    }
  } else {
    arg2 = 0U;
  }
  uint32_t arg3;
  if (args.hasDefined(3)) {
    if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
      return false;
    }
  } else {
    arg3 = 0U;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Uniform3uiv(MOZ_KnownLive(Constify(arg0)), Constify(arg1), arg2, arg3))>, "Should be returning void here");
  MOZ_KnownLive(self)->Uniform3uiv(MOZ_KnownLive(Constify(arg0)), Constify(arg1), arg2, arg3);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo uniform3uiv_methodinfo = {
  { (JSJitGetterOp)uniform3uiv },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
uniform4uiv(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.uniform4uiv");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "uniform4uiv", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.uniform4uiv", 2)) {
    return false;
  }
  mozilla::WebGLUniformLocationJS* arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLUniformLocation, mozilla::WebGLUniformLocationJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLUniformLocation");
        return false;
      }
    }
  } else if (args[0].isNullOrUndefined()) {
    arg0 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  MaybeSharedUint32ArrayOrUnsignedLongSequence arg1;
  if (!arg1.Init(cx, args[1], "Argument 2", false)) {
    return false;
  }
  uint32_t arg2;
  if (args.hasDefined(2)) {
    if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
      return false;
    }
  } else {
    arg2 = 0U;
  }
  uint32_t arg3;
  if (args.hasDefined(3)) {
    if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
      return false;
    }
  } else {
    arg3 = 0U;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Uniform4uiv(MOZ_KnownLive(Constify(arg0)), Constify(arg1), arg2, arg3))>, "Should be returning void here");
  MOZ_KnownLive(self)->Uniform4uiv(MOZ_KnownLive(Constify(arg0)), Constify(arg1), arg2, arg3);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo uniform4uiv_methodinfo = {
  { (JSJitGetterOp)uniform4uiv },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
uniformMatrix2fv(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.uniformMatrix2fv");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "uniformMatrix2fv", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.uniformMatrix2fv", 3)) {
    return false;
  }
  mozilla::WebGLUniformLocationJS* arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLUniformLocation, mozilla::WebGLUniformLocationJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLUniformLocation");
        return false;
      }
    }
  } else if (args[0].isNullOrUndefined()) {
    arg0 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  bool arg1;
  if (!ValueToPrimitive<bool, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  MaybeSharedFloat32ArrayOrUnrestrictedFloatSequence arg2;
  if (!arg2.Init(cx, args[2], "Argument 3", false)) {
    return false;
  }
  uint32_t arg3;
  if (args.hasDefined(3)) {
    if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
      return false;
    }
  } else {
    arg3 = 0U;
  }
  uint32_t arg4;
  if (args.hasDefined(4)) {
    if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[4], "Argument 5", &arg4)) {
      return false;
    }
  } else {
    arg4 = 0U;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->UniformMatrix2fv(MOZ_KnownLive(Constify(arg0)), arg1, Constify(arg2), arg3, arg4))>, "Should be returning void here");
  MOZ_KnownLive(self)->UniformMatrix2fv(MOZ_KnownLive(Constify(arg0)), arg1, Constify(arg2), arg3, arg4);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo uniformMatrix2fv_methodinfo = {
  { (JSJitGetterOp)uniformMatrix2fv },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
uniformMatrix3x2fv(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.uniformMatrix3x2fv");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "uniformMatrix3x2fv", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.uniformMatrix3x2fv", 3)) {
    return false;
  }
  mozilla::WebGLUniformLocationJS* arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLUniformLocation, mozilla::WebGLUniformLocationJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLUniformLocation");
        return false;
      }
    }
  } else if (args[0].isNullOrUndefined()) {
    arg0 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  bool arg1;
  if (!ValueToPrimitive<bool, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  MaybeSharedFloat32ArrayOrUnrestrictedFloatSequence arg2;
  if (!arg2.Init(cx, args[2], "Argument 3", false)) {
    return false;
  }
  uint32_t arg3;
  if (args.hasDefined(3)) {
    if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
      return false;
    }
  } else {
    arg3 = 0U;
  }
  uint32_t arg4;
  if (args.hasDefined(4)) {
    if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[4], "Argument 5", &arg4)) {
      return false;
    }
  } else {
    arg4 = 0U;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->UniformMatrix3x2fv(MOZ_KnownLive(Constify(arg0)), arg1, Constify(arg2), arg3, arg4))>, "Should be returning void here");
  MOZ_KnownLive(self)->UniformMatrix3x2fv(MOZ_KnownLive(Constify(arg0)), arg1, Constify(arg2), arg3, arg4);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo uniformMatrix3x2fv_methodinfo = {
  { (JSJitGetterOp)uniformMatrix3x2fv },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
uniformMatrix4x2fv(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.uniformMatrix4x2fv");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "uniformMatrix4x2fv", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.uniformMatrix4x2fv", 3)) {
    return false;
  }
  mozilla::WebGLUniformLocationJS* arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLUniformLocation, mozilla::WebGLUniformLocationJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLUniformLocation");
        return false;
      }
    }
  } else if (args[0].isNullOrUndefined()) {
    arg0 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  bool arg1;
  if (!ValueToPrimitive<bool, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  MaybeSharedFloat32ArrayOrUnrestrictedFloatSequence arg2;
  if (!arg2.Init(cx, args[2], "Argument 3", false)) {
    return false;
  }
  uint32_t arg3;
  if (args.hasDefined(3)) {
    if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
      return false;
    }
  } else {
    arg3 = 0U;
  }
  uint32_t arg4;
  if (args.hasDefined(4)) {
    if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[4], "Argument 5", &arg4)) {
      return false;
    }
  } else {
    arg4 = 0U;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->UniformMatrix4x2fv(MOZ_KnownLive(Constify(arg0)), arg1, Constify(arg2), arg3, arg4))>, "Should be returning void here");
  MOZ_KnownLive(self)->UniformMatrix4x2fv(MOZ_KnownLive(Constify(arg0)), arg1, Constify(arg2), arg3, arg4);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo uniformMatrix4x2fv_methodinfo = {
  { (JSJitGetterOp)uniformMatrix4x2fv },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
uniformMatrix2x3fv(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.uniformMatrix2x3fv");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "uniformMatrix2x3fv", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.uniformMatrix2x3fv", 3)) {
    return false;
  }
  mozilla::WebGLUniformLocationJS* arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLUniformLocation, mozilla::WebGLUniformLocationJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLUniformLocation");
        return false;
      }
    }
  } else if (args[0].isNullOrUndefined()) {
    arg0 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  bool arg1;
  if (!ValueToPrimitive<bool, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  MaybeSharedFloat32ArrayOrUnrestrictedFloatSequence arg2;
  if (!arg2.Init(cx, args[2], "Argument 3", false)) {
    return false;
  }
  uint32_t arg3;
  if (args.hasDefined(3)) {
    if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
      return false;
    }
  } else {
    arg3 = 0U;
  }
  uint32_t arg4;
  if (args.hasDefined(4)) {
    if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[4], "Argument 5", &arg4)) {
      return false;
    }
  } else {
    arg4 = 0U;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->UniformMatrix2x3fv(MOZ_KnownLive(Constify(arg0)), arg1, Constify(arg2), arg3, arg4))>, "Should be returning void here");
  MOZ_KnownLive(self)->UniformMatrix2x3fv(MOZ_KnownLive(Constify(arg0)), arg1, Constify(arg2), arg3, arg4);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo uniformMatrix2x3fv_methodinfo = {
  { (JSJitGetterOp)uniformMatrix2x3fv },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
uniformMatrix3fv(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.uniformMatrix3fv");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "uniformMatrix3fv", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.uniformMatrix3fv", 3)) {
    return false;
  }
  mozilla::WebGLUniformLocationJS* arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLUniformLocation, mozilla::WebGLUniformLocationJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLUniformLocation");
        return false;
      }
    }
  } else if (args[0].isNullOrUndefined()) {
    arg0 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  bool arg1;
  if (!ValueToPrimitive<bool, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  MaybeSharedFloat32ArrayOrUnrestrictedFloatSequence arg2;
  if (!arg2.Init(cx, args[2], "Argument 3", false)) {
    return false;
  }
  uint32_t arg3;
  if (args.hasDefined(3)) {
    if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
      return false;
    }
  } else {
    arg3 = 0U;
  }
  uint32_t arg4;
  if (args.hasDefined(4)) {
    if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[4], "Argument 5", &arg4)) {
      return false;
    }
  } else {
    arg4 = 0U;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->UniformMatrix3fv(MOZ_KnownLive(Constify(arg0)), arg1, Constify(arg2), arg3, arg4))>, "Should be returning void here");
  MOZ_KnownLive(self)->UniformMatrix3fv(MOZ_KnownLive(Constify(arg0)), arg1, Constify(arg2), arg3, arg4);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo uniformMatrix3fv_methodinfo = {
  { (JSJitGetterOp)uniformMatrix3fv },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
uniformMatrix4x3fv(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.uniformMatrix4x3fv");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "uniformMatrix4x3fv", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.uniformMatrix4x3fv", 3)) {
    return false;
  }
  mozilla::WebGLUniformLocationJS* arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLUniformLocation, mozilla::WebGLUniformLocationJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLUniformLocation");
        return false;
      }
    }
  } else if (args[0].isNullOrUndefined()) {
    arg0 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  bool arg1;
  if (!ValueToPrimitive<bool, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  MaybeSharedFloat32ArrayOrUnrestrictedFloatSequence arg2;
  if (!arg2.Init(cx, args[2], "Argument 3", false)) {
    return false;
  }
  uint32_t arg3;
  if (args.hasDefined(3)) {
    if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
      return false;
    }
  } else {
    arg3 = 0U;
  }
  uint32_t arg4;
  if (args.hasDefined(4)) {
    if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[4], "Argument 5", &arg4)) {
      return false;
    }
  } else {
    arg4 = 0U;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->UniformMatrix4x3fv(MOZ_KnownLive(Constify(arg0)), arg1, Constify(arg2), arg3, arg4))>, "Should be returning void here");
  MOZ_KnownLive(self)->UniformMatrix4x3fv(MOZ_KnownLive(Constify(arg0)), arg1, Constify(arg2), arg3, arg4);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo uniformMatrix4x3fv_methodinfo = {
  { (JSJitGetterOp)uniformMatrix4x3fv },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
uniformMatrix2x4fv(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.uniformMatrix2x4fv");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "uniformMatrix2x4fv", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.uniformMatrix2x4fv", 3)) {
    return false;
  }
  mozilla::WebGLUniformLocationJS* arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLUniformLocation, mozilla::WebGLUniformLocationJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLUniformLocation");
        return false;
      }
    }
  } else if (args[0].isNullOrUndefined()) {
    arg0 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  bool arg1;
  if (!ValueToPrimitive<bool, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  MaybeSharedFloat32ArrayOrUnrestrictedFloatSequence arg2;
  if (!arg2.Init(cx, args[2], "Argument 3", false)) {
    return false;
  }
  uint32_t arg3;
  if (args.hasDefined(3)) {
    if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
      return false;
    }
  } else {
    arg3 = 0U;
  }
  uint32_t arg4;
  if (args.hasDefined(4)) {
    if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[4], "Argument 5", &arg4)) {
      return false;
    }
  } else {
    arg4 = 0U;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->UniformMatrix2x4fv(MOZ_KnownLive(Constify(arg0)), arg1, Constify(arg2), arg3, arg4))>, "Should be returning void here");
  MOZ_KnownLive(self)->UniformMatrix2x4fv(MOZ_KnownLive(Constify(arg0)), arg1, Constify(arg2), arg3, arg4);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo uniformMatrix2x4fv_methodinfo = {
  { (JSJitGetterOp)uniformMatrix2x4fv },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
uniformMatrix3x4fv(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.uniformMatrix3x4fv");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "uniformMatrix3x4fv", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.uniformMatrix3x4fv", 3)) {
    return false;
  }
  mozilla::WebGLUniformLocationJS* arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLUniformLocation, mozilla::WebGLUniformLocationJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLUniformLocation");
        return false;
      }
    }
  } else if (args[0].isNullOrUndefined()) {
    arg0 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  bool arg1;
  if (!ValueToPrimitive<bool, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  MaybeSharedFloat32ArrayOrUnrestrictedFloatSequence arg2;
  if (!arg2.Init(cx, args[2], "Argument 3", false)) {
    return false;
  }
  uint32_t arg3;
  if (args.hasDefined(3)) {
    if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
      return false;
    }
  } else {
    arg3 = 0U;
  }
  uint32_t arg4;
  if (args.hasDefined(4)) {
    if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[4], "Argument 5", &arg4)) {
      return false;
    }
  } else {
    arg4 = 0U;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->UniformMatrix3x4fv(MOZ_KnownLive(Constify(arg0)), arg1, Constify(arg2), arg3, arg4))>, "Should be returning void here");
  MOZ_KnownLive(self)->UniformMatrix3x4fv(MOZ_KnownLive(Constify(arg0)), arg1, Constify(arg2), arg3, arg4);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo uniformMatrix3x4fv_methodinfo = {
  { (JSJitGetterOp)uniformMatrix3x4fv },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
uniformMatrix4fv(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.uniformMatrix4fv");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "uniformMatrix4fv", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.uniformMatrix4fv", 3)) {
    return false;
  }
  mozilla::WebGLUniformLocationJS* arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLUniformLocation, mozilla::WebGLUniformLocationJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLUniformLocation");
        return false;
      }
    }
  } else if (args[0].isNullOrUndefined()) {
    arg0 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  bool arg1;
  if (!ValueToPrimitive<bool, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  MaybeSharedFloat32ArrayOrUnrestrictedFloatSequence arg2;
  if (!arg2.Init(cx, args[2], "Argument 3", false)) {
    return false;
  }
  uint32_t arg3;
  if (args.hasDefined(3)) {
    if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
      return false;
    }
  } else {
    arg3 = 0U;
  }
  uint32_t arg4;
  if (args.hasDefined(4)) {
    if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[4], "Argument 5", &arg4)) {
      return false;
    }
  } else {
    arg4 = 0U;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->UniformMatrix4fv(MOZ_KnownLive(Constify(arg0)), arg1, Constify(arg2), arg3, arg4))>, "Should be returning void here");
  MOZ_KnownLive(self)->UniformMatrix4fv(MOZ_KnownLive(Constify(arg0)), arg1, Constify(arg2), arg3, arg4);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo uniformMatrix4fv_methodinfo = {
  { (JSJitGetterOp)uniformMatrix4fv },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
vertexAttribI4i(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "vertexAttribI4i", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.vertexAttribI4i", 5)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  int32_t arg1;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  int32_t arg2;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  }
  int32_t arg3;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
    return false;
  }
  int32_t arg4;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[4], "Argument 5", &arg4)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->VertexAttribI4i(arg0, arg1, arg2, arg3, arg4))>, "Should be returning void here");
  MOZ_KnownLive(self)->VertexAttribI4i(arg0, arg1, arg2, arg3, arg4);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo vertexAttribI4i_methodinfo = {
  { (JSJitGetterOp)vertexAttribI4i },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
vertexAttribI4iv(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.vertexAttribI4iv");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "vertexAttribI4iv", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.vertexAttribI4iv", 2)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  MaybeSharedInt32ArrayOrLongSequence arg1;
  if (!arg1.Init(cx, args[1], "Argument 2", false)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->VertexAttribI4iv(arg0, Constify(arg1)))>, "Should be returning void here");
  MOZ_KnownLive(self)->VertexAttribI4iv(arg0, Constify(arg1));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo vertexAttribI4iv_methodinfo = {
  { (JSJitGetterOp)vertexAttribI4iv },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
vertexAttribI4ui(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "vertexAttribI4ui", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.vertexAttribI4ui", 5)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  uint32_t arg1;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  uint32_t arg2;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  }
  uint32_t arg3;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
    return false;
  }
  uint32_t arg4;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[4], "Argument 5", &arg4)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->VertexAttribI4ui(arg0, arg1, arg2, arg3, arg4))>, "Should be returning void here");
  MOZ_KnownLive(self)->VertexAttribI4ui(arg0, arg1, arg2, arg3, arg4);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo vertexAttribI4ui_methodinfo = {
  { (JSJitGetterOp)vertexAttribI4ui },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
vertexAttribI4uiv(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.vertexAttribI4uiv");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "vertexAttribI4uiv", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.vertexAttribI4uiv", 2)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  MaybeSharedUint32ArrayOrUnsignedLongSequence arg1;
  if (!arg1.Init(cx, args[1], "Argument 2", false)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->VertexAttribI4uiv(arg0, Constify(arg1)))>, "Should be returning void here");
  MOZ_KnownLive(self)->VertexAttribI4uiv(arg0, Constify(arg1));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo vertexAttribI4uiv_methodinfo = {
  { (JSJitGetterOp)vertexAttribI4uiv },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
vertexAttribIPointer(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "vertexAttribIPointer", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.vertexAttribIPointer", 5)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  int32_t arg1;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  uint32_t arg2;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  }
  int32_t arg3;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
    return false;
  }
  int64_t arg4;
  if (!ValueToPrimitive<int64_t, eDefault>(cx, args[4], "Argument 5", &arg4)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->VertexAttribIPointer(arg0, arg1, arg2, arg3, arg4))>, "Should be returning void here");
  MOZ_KnownLive(self)->VertexAttribIPointer(arg0, arg1, arg2, arg3, arg4);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo vertexAttribIPointer_methodinfo = {
  { (JSJitGetterOp)vertexAttribIPointer },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
vertexAttribDivisor(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "vertexAttribDivisor", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.vertexAttribDivisor", 2)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  uint32_t arg1;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->VertexAttribDivisor(arg0, arg1))>, "Should be returning void here");
  MOZ_KnownLive(self)->VertexAttribDivisor(arg0, arg1);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo vertexAttribDivisor_methodinfo = {
  { (JSJitGetterOp)vertexAttribDivisor },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
drawArraysInstanced(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "drawArraysInstanced", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.drawArraysInstanced", 4)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  int32_t arg1;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  int32_t arg2;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  }
  int32_t arg3;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->DrawArraysInstanced(arg0, arg1, arg2, arg3))>, "Should be returning void here");
  MOZ_KnownLive(self)->DrawArraysInstanced(arg0, arg1, arg2, arg3);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo drawArraysInstanced_methodinfo = {
  { (JSJitGetterOp)drawArraysInstanced },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
drawElementsInstanced(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "drawElementsInstanced", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.drawElementsInstanced", 5)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  int32_t arg1;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  uint32_t arg2;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  }
  int64_t arg3;
  if (!ValueToPrimitive<int64_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
    return false;
  }
  int32_t arg4;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[4], "Argument 5", &arg4)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->DrawElementsInstanced(arg0, arg1, arg2, arg3, arg4))>, "Should be returning void here");
  MOZ_KnownLive(self)->DrawElementsInstanced(arg0, arg1, arg2, arg3, arg4);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo drawElementsInstanced_methodinfo = {
  { (JSJitGetterOp)drawElementsInstanced },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
drawRangeElements(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "drawRangeElements", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.drawRangeElements", 6)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  uint32_t arg1;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  uint32_t arg2;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  }
  int32_t arg3;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
    return false;
  }
  uint32_t arg4;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[4], "Argument 5", &arg4)) {
    return false;
  }
  int64_t arg5;
  if (!ValueToPrimitive<int64_t, eDefault>(cx, args[5], "Argument 6", &arg5)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->DrawRangeElements(arg0, arg1, arg2, arg3, arg4, arg5))>, "Should be returning void here");
  MOZ_KnownLive(self)->DrawRangeElements(arg0, arg1, arg2, arg3, arg4, arg5);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo drawRangeElements_methodinfo = {
  { (JSJitGetterOp)drawRangeElements },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
readPixels(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.readPixels");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "readPixels", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  unsigned argcount = std::min(args.length(), 8u);
  switch (argcount) {
    case 7: {
      int32_t arg0;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
        return false;
      }
      int32_t arg1;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
        return false;
      }
      int32_t arg2;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
        return false;
      }
      int32_t arg3;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
        return false;
      }
      uint32_t arg4;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[4], "Argument 5", &arg4)) {
        return false;
      }
      uint32_t arg5;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[5], "Argument 6", &arg5)) {
        return false;
      }
      if (args[6].isNullOrUndefined()) {
        RootedSpiderMonkeyInterface<Nullable<ArrayBufferView>> arg6(cx);
        arg6.SetNull();
        FastErrorResult rv;
        // NOTE: This assert does NOT call the function.
        static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->ReadPixels(arg0, arg1, arg2, arg3, arg4, arg5, Constify(arg6), nsContentUtils::ThreadsafeIsSystemCaller(cx) ? CallerType::System : CallerType::NonSystem, rv))>, "Should be returning void here");
        MOZ_KnownLive(self)->ReadPixels(arg0, arg1, arg2, arg3, arg4, arg5, Constify(arg6), nsContentUtils::ThreadsafeIsSystemCaller(cx) ? CallerType::System : CallerType::NonSystem, rv);
        if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "WebGL2RenderingContext.readPixels"))) {
          return false;
        }
        MOZ_ASSERT(!JS_IsExceptionPending(cx));
        args.rval().setUndefined();
        return true;
      }
      if (args[6].isObject()) {
        do {
          RootedSpiderMonkeyInterface<Nullable<ArrayBufferView>> arg6(cx);
          if (!arg6.SetValue().Init(&args[6].toObject())) {
            break;
          }
          if (JS::IsLargeArrayBufferView(arg6.SetValue().Obj())) {
            cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_LARGE>("Argument 7");
            return false;
          }
          if (JS::IsResizableArrayBufferView(arg6.SetValue().Obj())) {
            cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_RESIZABLE>("Argument 7");
            return false;
          }
          if (JS::IsImmutableArrayBufferView(arg6.SetValue().Obj())) {
            cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_IMMUTABLE>("Argument 7");
            return false;
          }
          FastErrorResult rv;
          // NOTE: This assert does NOT call the function.
          static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->ReadPixels(arg0, arg1, arg2, arg3, arg4, arg5, Constify(arg6), nsContentUtils::ThreadsafeIsSystemCaller(cx) ? CallerType::System : CallerType::NonSystem, rv))>, "Should be returning void here");
          MOZ_KnownLive(self)->ReadPixels(arg0, arg1, arg2, arg3, arg4, arg5, Constify(arg6), nsContentUtils::ThreadsafeIsSystemCaller(cx) ? CallerType::System : CallerType::NonSystem, rv);
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "WebGL2RenderingContext.readPixels"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          args.rval().setUndefined();
          return true;
        } while (false);
      }
      int64_t arg6;
      if (!ValueToPrimitive<int64_t, eDefault>(cx, args[6], "Argument 7", &arg6)) {
        return false;
      }
      FastErrorResult rv;
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->ReadPixels(arg0, arg1, arg2, arg3, arg4, arg5, arg6, nsContentUtils::ThreadsafeIsSystemCaller(cx) ? CallerType::System : CallerType::NonSystem, rv))>, "Should be returning void here");
      MOZ_KnownLive(self)->ReadPixels(arg0, arg1, arg2, arg3, arg4, arg5, arg6, nsContentUtils::ThreadsafeIsSystemCaller(cx) ? CallerType::System : CallerType::NonSystem, rv);
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "WebGL2RenderingContext.readPixels"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      args.rval().setUndefined();
      return true;
      break;
    }
    case 8: {
      int32_t arg0;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
        return false;
      }
      int32_t arg1;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
        return false;
      }
      int32_t arg2;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
        return false;
      }
      int32_t arg3;
      if (!ValueToPrimitive<int32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
        return false;
      }
      uint32_t arg4;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[4], "Argument 5", &arg4)) {
        return false;
      }
      uint32_t arg5;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[5], "Argument 6", &arg5)) {
        return false;
      }
      RootedSpiderMonkeyInterface<ArrayBufferView> arg6(cx);
      if (args[6].isObject()) {
        if (!arg6.Init(&args[6].toObject())) {
          cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 7", "ArrayBufferView");
          return false;
        }
        if (JS::IsLargeArrayBufferView(arg6.Obj())) {
          cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_LARGE>("Argument 7");
          return false;
        }
        if (JS::IsResizableArrayBufferView(arg6.Obj())) {
          cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_RESIZABLE>("Argument 7");
          return false;
        }
        if (JS::IsImmutableArrayBufferView(arg6.Obj())) {
          cx.ThrowErrorMessage<MSG_TYPEDARRAY_IS_IMMUTABLE>("Argument 7");
          return false;
        }
      } else {
        cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 7");
        return false;
      }
      uint32_t arg7;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[7], "Argument 8", &arg7)) {
        return false;
      }
      FastErrorResult rv;
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->ReadPixels(arg0, arg1, arg2, arg3, arg4, arg5, Constify(arg6), arg7, nsContentUtils::ThreadsafeIsSystemCaller(cx) ? CallerType::System : CallerType::NonSystem, rv))>, "Should be returning void here");
      MOZ_KnownLive(self)->ReadPixels(arg0, arg1, arg2, arg3, arg4, arg5, Constify(arg6), arg7, nsContentUtils::ThreadsafeIsSystemCaller(cx) ? CallerType::System : CallerType::NonSystem, rv);
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "WebGL2RenderingContext.readPixels"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      args.rval().setUndefined();
      return true;
      break;
    }
    default: {
      // Using nsPrintfCString here would require including that
      // header.  Let's not worry about it.
      nsAutoCString argCountStr;
      argCountStr.AppendPrintf("%u", args.length());
      return cx.ThrowErrorMessage<MSG_INVALID_OVERLOAD_ARGCOUNT>(argCountStr.get());
    }
  }
  MOZ_CRASH("We have an always-returning default case");
  return false;
}

static const JSJitInfo readPixels_methodinfo = {
  { (JSJitGetterOp)readPixels },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
drawBuffers(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.drawBuffers");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "drawBuffers", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.drawBuffers", 1)) {
    return false;
  }
  binding_detail::AutoSequence<uint32_t> arg0;
  if (args[0].isObject()) {
    JS::ForOfIterator iter(cx);
    if (!iter.init(args[0], JS::ForOfIterator::AllowNonIterable)) {
      return false;
    }
    if (!iter.valueIsIterable()) {
      cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("Argument 1", "sequence");
      return false;
    }
    binding_detail::AutoSequence<uint32_t> &arr = arg0;
    JS::Rooted<JS::Value> temp(cx);
    while (true) {
      bool done;
      if (!iter.next(&temp, &done)) {
        return false;
      }
      if (done) {
        break;
      }
      uint32_t* slotPtr = arr.AppendElement(mozilla::fallible);
      if (!slotPtr) {
        JS_ReportOutOfMemory(cx);
        return false;
      }
      uint32_t& slot = *slotPtr;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, temp, "Element of argument 1", &slot)) {
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("Argument 1", "sequence");
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->DrawBuffers(Constify(arg0)))>, "Should be returning void here");
  MOZ_KnownLive(self)->DrawBuffers(Constify(arg0));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo drawBuffers_methodinfo = {
  { (JSJitGetterOp)drawBuffers },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
clearBufferfv(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.clearBufferfv");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "clearBufferfv", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.clearBufferfv", 3)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  int32_t arg1;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  MaybeSharedFloat32ArrayOrUnrestrictedFloatSequence arg2;
  if (!arg2.Init(cx, args[2], "Argument 3", false)) {
    return false;
  }
  uint32_t arg3;
  if (args.hasDefined(3)) {
    if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
      return false;
    }
  } else {
    arg3 = 0U;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->ClearBufferfv(arg0, arg1, Constify(arg2), arg3))>, "Should be returning void here");
  MOZ_KnownLive(self)->ClearBufferfv(arg0, arg1, Constify(arg2), arg3);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo clearBufferfv_methodinfo = {
  { (JSJitGetterOp)clearBufferfv },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
clearBufferiv(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.clearBufferiv");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "clearBufferiv", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.clearBufferiv", 3)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  int32_t arg1;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  MaybeSharedInt32ArrayOrLongSequence arg2;
  if (!arg2.Init(cx, args[2], "Argument 3", false)) {
    return false;
  }
  uint32_t arg3;
  if (args.hasDefined(3)) {
    if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
      return false;
    }
  } else {
    arg3 = 0U;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->ClearBufferiv(arg0, arg1, Constify(arg2), arg3))>, "Should be returning void here");
  MOZ_KnownLive(self)->ClearBufferiv(arg0, arg1, Constify(arg2), arg3);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo clearBufferiv_methodinfo = {
  { (JSJitGetterOp)clearBufferiv },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
clearBufferuiv(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.clearBufferuiv");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "clearBufferuiv", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.clearBufferuiv", 3)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  int32_t arg1;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  MaybeSharedUint32ArrayOrUnsignedLongSequence arg2;
  if (!arg2.Init(cx, args[2], "Argument 3", false)) {
    return false;
  }
  uint32_t arg3;
  if (args.hasDefined(3)) {
    if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
      return false;
    }
  } else {
    arg3 = 0U;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->ClearBufferuiv(arg0, arg1, Constify(arg2), arg3))>, "Should be returning void here");
  MOZ_KnownLive(self)->ClearBufferuiv(arg0, arg1, Constify(arg2), arg3);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo clearBufferuiv_methodinfo = {
  { (JSJitGetterOp)clearBufferuiv },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
clearBufferfi(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "clearBufferfi", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.clearBufferfi", 4)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  int32_t arg1;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  float arg2;
  if (!ValueToPrimitive<float, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  }
  int32_t arg3;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->ClearBufferfi(arg0, arg1, arg2, arg3))>, "Should be returning void here");
  MOZ_KnownLive(self)->ClearBufferfi(arg0, arg1, arg2, arg3);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo clearBufferfi_methodinfo = {
  { (JSJitGetterOp)clearBufferfi },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
createQuery(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "createQuery", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  auto result(StrongOrRawPtr<mozilla::WebGLQueryJS>(MOZ_KnownLive(self)->CreateQuery()));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo createQuery_methodinfo = {
  { (JSJitGetterOp)createQuery },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
deleteQuery(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.deleteQuery");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "deleteQuery", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.deleteQuery", 1)) {
    return false;
  }
  mozilla::WebGLQueryJS* arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLQuery, mozilla::WebGLQueryJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLQuery");
        return false;
      }
    }
  } else if (args[0].isNullOrUndefined()) {
    arg0 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->DeleteQuery(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->DeleteQuery(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo deleteQuery_methodinfo = {
  { (JSJitGetterOp)deleteQuery },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
isQuery(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.isQuery");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "isQuery", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.isQuery", 1)) {
    return false;
  }
  mozilla::WebGLQueryJS* arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLQuery, mozilla::WebGLQueryJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLQuery");
        return false;
      }
    }
  } else if (args[0].isNullOrUndefined()) {
    arg0 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  bool result(MOZ_KnownLive(self)->IsQuery(MOZ_KnownLive(Constify(arg0))));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo isQuery_methodinfo = {
  { (JSJitGetterOp)isQuery },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
beginQuery(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.beginQuery");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "beginQuery", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.beginQuery", 2)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  NonNull<mozilla::WebGLQueryJS> arg1;
  if (args[1].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLQuery, mozilla::WebGLQueryJS>(args[1], arg1, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 2", "WebGLQuery");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 2");
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->BeginQuery(arg0, MOZ_KnownLive(NonNullHelper(arg1))))>, "Should be returning void here");
  MOZ_KnownLive(self)->BeginQuery(arg0, MOZ_KnownLive(NonNullHelper(arg1)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo beginQuery_methodinfo = {
  { (JSJitGetterOp)beginQuery },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
endQuery(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "endQuery", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.endQuery", 1)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->EndQuery(arg0))>, "Should be returning void here");
  MOZ_KnownLive(self)->EndQuery(arg0);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo endQuery_methodinfo = {
  { (JSJitGetterOp)endQuery },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getQuery(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "getQuery", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.getQuery", 2)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  uint32_t arg1;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  JS::Rooted<JS::Value> result(cx);
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetQuery(cx, arg0, arg1, &result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetQuery(cx, arg0, arg1, &result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  JS::ExposeValueToActiveJS(result);
  args.rval().set(result);
  if (!MaybeWrapValue(cx, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo getQuery_methodinfo = {
  { (JSJitGetterOp)getQuery },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getQueryParameter(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.getQueryParameter");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "getQueryParameter", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.getQueryParameter", 2)) {
    return false;
  }
  NonNull<mozilla::WebGLQueryJS> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLQuery, mozilla::WebGLQueryJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLQuery");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  uint32_t arg1;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  JS::Rooted<JS::Value> result(cx);
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetQueryParameter(cx, MOZ_KnownLive(NonNullHelper(arg0)), arg1, &result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetQueryParameter(cx, MOZ_KnownLive(NonNullHelper(arg0)), arg1, &result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  JS::ExposeValueToActiveJS(result);
  args.rval().set(result);
  if (!MaybeWrapValue(cx, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo getQueryParameter_methodinfo = {
  { (JSJitGetterOp)getQueryParameter },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
createSampler(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "createSampler", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  auto result(StrongOrRawPtr<mozilla::WebGLSamplerJS>(MOZ_KnownLive(self)->CreateSampler()));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo createSampler_methodinfo = {
  { (JSJitGetterOp)createSampler },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
deleteSampler(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.deleteSampler");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "deleteSampler", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.deleteSampler", 1)) {
    return false;
  }
  mozilla::WebGLSamplerJS* arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLSampler, mozilla::WebGLSamplerJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLSampler");
        return false;
      }
    }
  } else if (args[0].isNullOrUndefined()) {
    arg0 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->DeleteSampler(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->DeleteSampler(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo deleteSampler_methodinfo = {
  { (JSJitGetterOp)deleteSampler },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
isSampler(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.isSampler");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "isSampler", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.isSampler", 1)) {
    return false;
  }
  mozilla::WebGLSamplerJS* arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLSampler, mozilla::WebGLSamplerJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLSampler");
        return false;
      }
    }
  } else if (args[0].isNullOrUndefined()) {
    arg0 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  bool result(MOZ_KnownLive(self)->IsSampler(MOZ_KnownLive(Constify(arg0))));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo isSampler_methodinfo = {
  { (JSJitGetterOp)isSampler },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
bindSampler(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.bindSampler");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "bindSampler", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.bindSampler", 2)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  mozilla::WebGLSamplerJS* arg1;
  if (args[1].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLSampler, mozilla::WebGLSamplerJS>(args[1], arg1, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 2", "WebGLSampler");
        return false;
      }
    }
  } else if (args[1].isNullOrUndefined()) {
    arg1 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 2");
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->BindSampler(arg0, MOZ_KnownLive(Constify(arg1))))>, "Should be returning void here");
  MOZ_KnownLive(self)->BindSampler(arg0, MOZ_KnownLive(Constify(arg1)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo bindSampler_methodinfo = {
  { (JSJitGetterOp)bindSampler },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
samplerParameteri(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.samplerParameteri");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "samplerParameteri", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.samplerParameteri", 3)) {
    return false;
  }
  NonNull<mozilla::WebGLSamplerJS> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLSampler, mozilla::WebGLSamplerJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLSampler");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  uint32_t arg1;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  int32_t arg2;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SamplerParameteri(MOZ_KnownLive(NonNullHelper(arg0)), arg1, arg2))>, "Should be returning void here");
  MOZ_KnownLive(self)->SamplerParameteri(MOZ_KnownLive(NonNullHelper(arg0)), arg1, arg2);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo samplerParameteri_methodinfo = {
  { (JSJitGetterOp)samplerParameteri },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
samplerParameterf(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.samplerParameterf");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "samplerParameterf", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.samplerParameterf", 3)) {
    return false;
  }
  NonNull<mozilla::WebGLSamplerJS> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLSampler, mozilla::WebGLSamplerJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLSampler");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  uint32_t arg1;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  float arg2;
  if (!ValueToPrimitive<float, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SamplerParameterf(MOZ_KnownLive(NonNullHelper(arg0)), arg1, arg2))>, "Should be returning void here");
  MOZ_KnownLive(self)->SamplerParameterf(MOZ_KnownLive(NonNullHelper(arg0)), arg1, arg2);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo samplerParameterf_methodinfo = {
  { (JSJitGetterOp)samplerParameterf },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getSamplerParameter(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.getSamplerParameter");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "getSamplerParameter", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.getSamplerParameter", 2)) {
    return false;
  }
  NonNull<mozilla::WebGLSamplerJS> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLSampler, mozilla::WebGLSamplerJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLSampler");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  uint32_t arg1;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  JS::Rooted<JS::Value> result(cx);
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetSamplerParameter(cx, MOZ_KnownLive(NonNullHelper(arg0)), arg1, &result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetSamplerParameter(cx, MOZ_KnownLive(NonNullHelper(arg0)), arg1, &result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  JS::ExposeValueToActiveJS(result);
  args.rval().set(result);
  if (!MaybeWrapValue(cx, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo getSamplerParameter_methodinfo = {
  { (JSJitGetterOp)getSamplerParameter },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
fenceSync(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "fenceSync", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.fenceSync", 2)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  uint32_t arg1;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  auto result(StrongOrRawPtr<mozilla::WebGLSyncJS>(MOZ_KnownLive(self)->FenceSync(arg0, arg1)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!result) {
    args.rval().setNull();
    return true;
  }
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo fenceSync_methodinfo = {
  { (JSJitGetterOp)fenceSync },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
isSync(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.isSync");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "isSync", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.isSync", 1)) {
    return false;
  }
  mozilla::WebGLSyncJS* arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLSync, mozilla::WebGLSyncJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLSync");
        return false;
      }
    }
  } else if (args[0].isNullOrUndefined()) {
    arg0 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  bool result(MOZ_KnownLive(self)->IsSync(MOZ_KnownLive(Constify(arg0))));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo isSync_methodinfo = {
  { (JSJitGetterOp)isSync },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
deleteSync(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.deleteSync");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "deleteSync", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.deleteSync", 1)) {
    return false;
  }
  mozilla::WebGLSyncJS* arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLSync, mozilla::WebGLSyncJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLSync");
        return false;
      }
    }
  } else if (args[0].isNullOrUndefined()) {
    arg0 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->DeleteSync(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->DeleteSync(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo deleteSync_methodinfo = {
  { (JSJitGetterOp)deleteSync },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
clientWaitSync(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.clientWaitSync");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "clientWaitSync", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.clientWaitSync", 3)) {
    return false;
  }
  NonNull<mozilla::WebGLSyncJS> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLSync, mozilla::WebGLSyncJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLSync");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  uint32_t arg1;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  uint64_t arg2;
  if (!ValueToPrimitive<uint64_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  }
  uint32_t result(MOZ_KnownLive(self)->ClientWaitSync(MOZ_KnownLive(NonNullHelper(arg0)), arg1, arg2));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setNumber(result);
  return true;
}

static const JSJitInfo clientWaitSync_methodinfo = {
  { (JSJitGetterOp)clientWaitSync },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_DOUBLE,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
waitSync(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.waitSync");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "waitSync", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.waitSync", 3)) {
    return false;
  }
  NonNull<mozilla::WebGLSyncJS> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLSync, mozilla::WebGLSyncJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLSync");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  uint32_t arg1;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  int64_t arg2;
  if (!ValueToPrimitive<int64_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->WaitSync(MOZ_KnownLive(NonNullHelper(arg0)), arg1, arg2))>, "Should be returning void here");
  MOZ_KnownLive(self)->WaitSync(MOZ_KnownLive(NonNullHelper(arg0)), arg1, arg2);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo waitSync_methodinfo = {
  { (JSJitGetterOp)waitSync },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getSyncParameter(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.getSyncParameter");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "getSyncParameter", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.getSyncParameter", 2)) {
    return false;
  }
  NonNull<mozilla::WebGLSyncJS> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLSync, mozilla::WebGLSyncJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLSync");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  uint32_t arg1;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  JS::Rooted<JS::Value> result(cx);
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetSyncParameter(cx, MOZ_KnownLive(NonNullHelper(arg0)), arg1, &result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetSyncParameter(cx, MOZ_KnownLive(NonNullHelper(arg0)), arg1, &result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  JS::ExposeValueToActiveJS(result);
  args.rval().set(result);
  if (!MaybeWrapValue(cx, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo getSyncParameter_methodinfo = {
  { (JSJitGetterOp)getSyncParameter },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
createTransformFeedback(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "createTransformFeedback", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  auto result(StrongOrRawPtr<mozilla::WebGLTransformFeedbackJS>(MOZ_KnownLive(self)->CreateTransformFeedback()));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo createTransformFeedback_methodinfo = {
  { (JSJitGetterOp)createTransformFeedback },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
deleteTransformFeedback(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.deleteTransformFeedback");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "deleteTransformFeedback", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.deleteTransformFeedback", 1)) {
    return false;
  }
  mozilla::WebGLTransformFeedbackJS* arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLTransformFeedback, mozilla::WebGLTransformFeedbackJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLTransformFeedback");
        return false;
      }
    }
  } else if (args[0].isNullOrUndefined()) {
    arg0 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->DeleteTransformFeedback(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->DeleteTransformFeedback(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo deleteTransformFeedback_methodinfo = {
  { (JSJitGetterOp)deleteTransformFeedback },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
isTransformFeedback(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.isTransformFeedback");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "isTransformFeedback", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.isTransformFeedback", 1)) {
    return false;
  }
  mozilla::WebGLTransformFeedbackJS* arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLTransformFeedback, mozilla::WebGLTransformFeedbackJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLTransformFeedback");
        return false;
      }
    }
  } else if (args[0].isNullOrUndefined()) {
    arg0 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  bool result(MOZ_KnownLive(self)->IsTransformFeedback(MOZ_KnownLive(Constify(arg0))));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo isTransformFeedback_methodinfo = {
  { (JSJitGetterOp)isTransformFeedback },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
bindTransformFeedback(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.bindTransformFeedback");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "bindTransformFeedback", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.bindTransformFeedback", 2)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  mozilla::WebGLTransformFeedbackJS* arg1;
  if (args[1].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLTransformFeedback, mozilla::WebGLTransformFeedbackJS>(args[1], arg1, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 2", "WebGLTransformFeedback");
        return false;
      }
    }
  } else if (args[1].isNullOrUndefined()) {
    arg1 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 2");
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->BindTransformFeedback(arg0, MOZ_KnownLive(Constify(arg1))))>, "Should be returning void here");
  MOZ_KnownLive(self)->BindTransformFeedback(arg0, MOZ_KnownLive(Constify(arg1)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo bindTransformFeedback_methodinfo = {
  { (JSJitGetterOp)bindTransformFeedback },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
beginTransformFeedback(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "beginTransformFeedback", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.beginTransformFeedback", 1)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->BeginTransformFeedback(arg0))>, "Should be returning void here");
  MOZ_KnownLive(self)->BeginTransformFeedback(arg0);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo beginTransformFeedback_methodinfo = {
  { (JSJitGetterOp)beginTransformFeedback },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
endTransformFeedback(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "endTransformFeedback", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->EndTransformFeedback())>, "Should be returning void here");
  MOZ_KnownLive(self)->EndTransformFeedback();
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo endTransformFeedback_methodinfo = {
  { (JSJitGetterOp)endTransformFeedback },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
transformFeedbackVaryings(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.transformFeedbackVaryings");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "transformFeedbackVaryings", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.transformFeedbackVaryings", 3)) {
    return false;
  }
  NonNull<mozilla::WebGLProgramJS> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLProgram, mozilla::WebGLProgramJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLProgram");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  binding_detail::AutoSequence<nsString> arg1;
  if (args[1].isObject()) {
    JS::ForOfIterator iter(cx);
    if (!iter.init(args[1], JS::ForOfIterator::AllowNonIterable)) {
      return false;
    }
    if (!iter.valueIsIterable()) {
      cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("Argument 2", "sequence");
      return false;
    }
    binding_detail::AutoSequence<nsString> &arr = arg1;
    JS::Rooted<JS::Value> temp(cx);
    while (true) {
      bool done;
      if (!iter.next(&temp, &done)) {
        return false;
      }
      if (done) {
        break;
      }
      nsString* slotPtr = arr.AppendElement(mozilla::fallible);
      if (!slotPtr) {
        JS_ReportOutOfMemory(cx);
        return false;
      }
      nsString& slot = *slotPtr;
      if (!ConvertJSValueToString(cx, temp, eStringify, eStringify, slot)) {
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("Argument 2", "sequence");
    return false;
  }
  uint32_t arg2;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->TransformFeedbackVaryings(MOZ_KnownLive(NonNullHelper(arg0)), Constify(arg1), arg2))>, "Should be returning void here");
  MOZ_KnownLive(self)->TransformFeedbackVaryings(MOZ_KnownLive(NonNullHelper(arg0)), Constify(arg1), arg2);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo transformFeedbackVaryings_methodinfo = {
  { (JSJitGetterOp)transformFeedbackVaryings },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getTransformFeedbackVarying(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.getTransformFeedbackVarying");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "getTransformFeedbackVarying", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.getTransformFeedbackVarying", 2)) {
    return false;
  }
  NonNull<mozilla::WebGLProgramJS> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLProgram, mozilla::WebGLProgramJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLProgram");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  uint32_t arg1;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  auto result(StrongOrRawPtr<mozilla::WebGLActiveInfoJS>(MOZ_KnownLive(self)->GetTransformFeedbackVarying(MOZ_KnownLive(NonNullHelper(arg0)), arg1)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!result) {
    args.rval().setNull();
    return true;
  }
  if (!WrapNewBindingNonWrapperCachedObject(cx, obj, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo getTransformFeedbackVarying_methodinfo = {
  { (JSJitGetterOp)getTransformFeedbackVarying },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
pauseTransformFeedback(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "pauseTransformFeedback", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->PauseTransformFeedback())>, "Should be returning void here");
  MOZ_KnownLive(self)->PauseTransformFeedback();
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo pauseTransformFeedback_methodinfo = {
  { (JSJitGetterOp)pauseTransformFeedback },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
resumeTransformFeedback(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "resumeTransformFeedback", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->ResumeTransformFeedback())>, "Should be returning void here");
  MOZ_KnownLive(self)->ResumeTransformFeedback();
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo resumeTransformFeedback_methodinfo = {
  { (JSJitGetterOp)resumeTransformFeedback },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
bindBufferBase(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.bindBufferBase");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "bindBufferBase", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.bindBufferBase", 3)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  uint32_t arg1;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  mozilla::WebGLBufferJS* arg2;
  if (args[2].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLBuffer, mozilla::WebGLBufferJS>(args[2], arg2, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 3", "WebGLBuffer");
        return false;
      }
    }
  } else if (args[2].isNullOrUndefined()) {
    arg2 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 3");
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->BindBufferBase(arg0, arg1, MOZ_KnownLive(Constify(arg2))))>, "Should be returning void here");
  MOZ_KnownLive(self)->BindBufferBase(arg0, arg1, MOZ_KnownLive(Constify(arg2)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo bindBufferBase_methodinfo = {
  { (JSJitGetterOp)bindBufferBase },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
bindBufferRange(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.bindBufferRange");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "bindBufferRange", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.bindBufferRange", 5)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  uint32_t arg1;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  mozilla::WebGLBufferJS* arg2;
  if (args[2].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLBuffer, mozilla::WebGLBufferJS>(args[2], arg2, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 3", "WebGLBuffer");
        return false;
      }
    }
  } else if (args[2].isNullOrUndefined()) {
    arg2 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 3");
    return false;
  }
  int64_t arg3;
  if (!ValueToPrimitive<int64_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
    return false;
  }
  int64_t arg4;
  if (!ValueToPrimitive<int64_t, eDefault>(cx, args[4], "Argument 5", &arg4)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->BindBufferRange(arg0, arg1, MOZ_KnownLive(Constify(arg2)), arg3, arg4))>, "Should be returning void here");
  MOZ_KnownLive(self)->BindBufferRange(arg0, arg1, MOZ_KnownLive(Constify(arg2)), arg3, arg4);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo bindBufferRange_methodinfo = {
  { (JSJitGetterOp)bindBufferRange },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getIndexedParameter(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "getIndexedParameter", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.getIndexedParameter", 2)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  uint32_t arg1;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  FastErrorResult rv;
  JS::Rooted<JS::Value> result(cx);
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetIndexedParameter(cx, arg0, arg1, &result, rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetIndexedParameter(cx, arg0, arg1, &result, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "WebGL2RenderingContext.getIndexedParameter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  JS::ExposeValueToActiveJS(result);
  args.rval().set(result);
  if (!MaybeWrapValue(cx, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo getIndexedParameter_methodinfo = {
  { (JSJitGetterOp)getIndexedParameter },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getUniformIndices(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.getUniformIndices");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "getUniformIndices", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.getUniformIndices", 2)) {
    return false;
  }
  NonNull<mozilla::WebGLProgramJS> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLProgram, mozilla::WebGLProgramJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLProgram");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  binding_detail::AutoSequence<nsString> arg1;
  if (args[1].isObject()) {
    JS::ForOfIterator iter(cx);
    if (!iter.init(args[1], JS::ForOfIterator::AllowNonIterable)) {
      return false;
    }
    if (!iter.valueIsIterable()) {
      cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("Argument 2", "sequence");
      return false;
    }
    binding_detail::AutoSequence<nsString> &arr = arg1;
    JS::Rooted<JS::Value> temp(cx);
    while (true) {
      bool done;
      if (!iter.next(&temp, &done)) {
        return false;
      }
      if (done) {
        break;
      }
      nsString* slotPtr = arr.AppendElement(mozilla::fallible);
      if (!slotPtr) {
        JS_ReportOutOfMemory(cx);
        return false;
      }
      nsString& slot = *slotPtr;
      if (!ConvertJSValueToString(cx, temp, eStringify, eStringify, slot)) {
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("Argument 2", "sequence");
    return false;
  }
  Nullable<nsTArray<uint32_t>> result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetUniformIndices(MOZ_KnownLive(NonNullHelper(arg0)), Constify(arg1), result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetUniformIndices(MOZ_KnownLive(NonNullHelper(arg0)), Constify(arg1), result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  if (result.IsNull()) {
    args.rval().setNull();
    return true;
  }

  uint32_t length = result.Value().Length();
  JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
  if (!returnArray) {
    return false;
  }
  // Scope for 'tmp'
  {
    JS::Rooted<JS::Value> tmp(cx);
    for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
      // Control block to let us common up the JS_DefineElement calls when there
      // are different ways to succeed at wrapping the object.
      do {
        tmp.setNumber(result.Value()[sequenceIdx0]);
        break;
      } while (false);
      if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                            JSPROP_ENUMERATE)) {
        return false;
      }
    }
  }
  args.rval().setObject(*returnArray);
  return true;
}

static const JSJitInfo getUniformIndices_methodinfo = {
  { (JSJitGetterOp)getUniformIndices },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getActiveUniforms(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.getActiveUniforms");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "getActiveUniforms", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.getActiveUniforms", 3)) {
    return false;
  }
  NonNull<mozilla::WebGLProgramJS> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLProgram, mozilla::WebGLProgramJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLProgram");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  binding_detail::AutoSequence<uint32_t> arg1;
  if (args[1].isObject()) {
    JS::ForOfIterator iter(cx);
    if (!iter.init(args[1], JS::ForOfIterator::AllowNonIterable)) {
      return false;
    }
    if (!iter.valueIsIterable()) {
      cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("Argument 2", "sequence");
      return false;
    }
    binding_detail::AutoSequence<uint32_t> &arr = arg1;
    JS::Rooted<JS::Value> temp(cx);
    while (true) {
      bool done;
      if (!iter.next(&temp, &done)) {
        return false;
      }
      if (done) {
        break;
      }
      uint32_t* slotPtr = arr.AppendElement(mozilla::fallible);
      if (!slotPtr) {
        JS_ReportOutOfMemory(cx);
        return false;
      }
      uint32_t& slot = *slotPtr;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, temp, "Element of argument 2", &slot)) {
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("Argument 2", "sequence");
    return false;
  }
  uint32_t arg2;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  }
  JS::Rooted<JS::Value> result(cx);
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetActiveUniforms(cx, MOZ_KnownLive(NonNullHelper(arg0)), Constify(arg1), arg2, &result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetActiveUniforms(cx, MOZ_KnownLive(NonNullHelper(arg0)), Constify(arg1), arg2, &result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  JS::ExposeValueToActiveJS(result);
  args.rval().set(result);
  if (!MaybeWrapValue(cx, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo getActiveUniforms_methodinfo = {
  { (JSJitGetterOp)getActiveUniforms },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getUniformBlockIndex(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.getUniformBlockIndex");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "getUniformBlockIndex", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.getUniformBlockIndex", 2)) {
    return false;
  }
  NonNull<mozilla::WebGLProgramJS> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLProgram, mozilla::WebGLProgramJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLProgram");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  binding_detail::FakeString<char16_t> arg1;
  if (!ConvertJSValueToString(cx, args[1], eStringify, eStringify, arg1)) {
    return false;
  }
  uint32_t result(MOZ_KnownLive(self)->GetUniformBlockIndex(MOZ_KnownLive(NonNullHelper(arg0)), NonNullHelper(Constify(arg1))));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setNumber(result);
  return true;
}

static const JSJitInfo getUniformBlockIndex_methodinfo = {
  { (JSJitGetterOp)getUniformBlockIndex },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_DOUBLE,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getActiveUniformBlockParameter(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.getActiveUniformBlockParameter");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "getActiveUniformBlockParameter", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.getActiveUniformBlockParameter", 3)) {
    return false;
  }
  NonNull<mozilla::WebGLProgramJS> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLProgram, mozilla::WebGLProgramJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLProgram");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  uint32_t arg1;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  uint32_t arg2;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  }
  FastErrorResult rv;
  JS::Rooted<JS::Value> result(cx);
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetActiveUniformBlockParameter(cx, MOZ_KnownLive(NonNullHelper(arg0)), arg1, arg2, &result, rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetActiveUniformBlockParameter(cx, MOZ_KnownLive(NonNullHelper(arg0)), arg1, arg2, &result, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "WebGL2RenderingContext.getActiveUniformBlockParameter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  JS::ExposeValueToActiveJS(result);
  args.rval().set(result);
  if (!MaybeWrapValue(cx, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo getActiveUniformBlockParameter_methodinfo = {
  { (JSJitGetterOp)getActiveUniformBlockParameter },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getActiveUniformBlockName(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.getActiveUniformBlockName");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "getActiveUniformBlockName", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.getActiveUniformBlockName", 2)) {
    return false;
  }
  NonNull<mozilla::WebGLProgramJS> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLProgram, mozilla::WebGLProgramJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLProgram");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  uint32_t arg1;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  DOMString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetActiveUniformBlockName(MOZ_KnownLive(NonNullHelper(arg0)), arg1, result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetActiveUniformBlockName(MOZ_KnownLive(NonNullHelper(arg0)), arg1, result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!xpc::StringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo getActiveUniformBlockName_methodinfo = {
  { (JSJitGetterOp)getActiveUniformBlockName },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
uniformBlockBinding(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.uniformBlockBinding");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "uniformBlockBinding", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.uniformBlockBinding", 3)) {
    return false;
  }
  NonNull<mozilla::WebGLProgramJS> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLProgram, mozilla::WebGLProgramJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLProgram");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  uint32_t arg1;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  uint32_t arg2;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->UniformBlockBinding(MOZ_KnownLive(NonNullHelper(arg0)), arg1, arg2))>, "Should be returning void here");
  MOZ_KnownLive(self)->UniformBlockBinding(MOZ_KnownLive(NonNullHelper(arg0)), arg1, arg2);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo uniformBlockBinding_methodinfo = {
  { (JSJitGetterOp)uniformBlockBinding },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
createVertexArray(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "createVertexArray", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  auto result(StrongOrRawPtr<mozilla::WebGLVertexArrayJS>(MOZ_KnownLive(self)->CreateVertexArray()));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo createVertexArray_methodinfo = {
  { (JSJitGetterOp)createVertexArray },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
deleteVertexArray(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.deleteVertexArray");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "deleteVertexArray", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.deleteVertexArray", 1)) {
    return false;
  }
  mozilla::WebGLVertexArrayJS* arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLVertexArrayObject, mozilla::WebGLVertexArrayJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLVertexArrayObject");
        return false;
      }
    }
  } else if (args[0].isNullOrUndefined()) {
    arg0 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->DeleteVertexArray(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->DeleteVertexArray(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo deleteVertexArray_methodinfo = {
  { (JSJitGetterOp)deleteVertexArray },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
isVertexArray(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.isVertexArray");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "isVertexArray", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.isVertexArray", 1)) {
    return false;
  }
  mozilla::WebGLVertexArrayJS* arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLVertexArrayObject, mozilla::WebGLVertexArrayJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLVertexArrayObject");
        return false;
      }
    }
  } else if (args[0].isNullOrUndefined()) {
    arg0 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  bool result(MOZ_KnownLive(self)->IsVertexArray(MOZ_KnownLive(Constify(arg0))));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo isVertexArray_methodinfo = {
  { (JSJitGetterOp)isVertexArray },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
bindVertexArray(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.bindVertexArray");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "bindVertexArray", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.bindVertexArray", 1)) {
    return false;
  }
  mozilla::WebGLVertexArrayJS* arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLVertexArrayObject, mozilla::WebGLVertexArrayJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLVertexArrayObject");
        return false;
      }
    }
  } else if (args[0].isNullOrUndefined()) {
    arg0 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->BindVertexArray(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->BindVertexArray(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo bindVertexArray_methodinfo = {
  { (JSJitGetterOp)bindVertexArray },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_canvas(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "canvas", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  Nullable<OwningHTMLCanvasElementOrOffscreenCanvas> result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetCanvas(result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetCanvas(result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result.IsNull()) {
    args.rval().setNull();
    return true;
  }
  if (!result.Value().ToJSVal(cx, obj, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo canvas_getterinfo = {
  { get_canvas },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_drawingBufferWidth(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "drawingBufferWidth", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  int32_t result(MOZ_KnownLive(self)->DrawingBufferWidth());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setInt32(int32_t(result));
  return true;
}

static const JSJitInfo drawingBufferWidth_getterinfo = {
  { get_drawingBufferWidth },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_INT32,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_drawingBufferHeight(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "drawingBufferHeight", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  int32_t result(MOZ_KnownLive(self)->DrawingBufferHeight());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setInt32(int32_t(result));
  return true;
}

static const JSJitInfo drawingBufferHeight_getterinfo = {
  { get_drawingBufferHeight },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_INT32,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_drawingBufferColorSpace(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "drawingBufferColorSpace", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  PredefinedColorSpace result(MOZ_KnownLive(self)->DrawingBufferColorSpace());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!ToJSValue(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_drawingBufferColorSpace(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.drawingBufferColorSpace setter");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "drawingBufferColorSpace", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  PredefinedColorSpace arg0;
  {
    int index;
    if (!binding_detail::FindEnumStringIndex<false>(cx, args[0],
                                                                       binding_detail::EnumStrings<PredefinedColorSpace>::Values,
                                                                       "PredefinedColorSpace", "value being assigned",
                                                                       &index)) {
      return false;
    }
    if (index < 0) {
      return true;
    }
    arg0 = static_cast<PredefinedColorSpace>(index);
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetDrawingBufferColorSpace(arg0))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetDrawingBufferColorSpace(arg0);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo drawingBufferColorSpace_getterinfo = {
  { get_drawingBufferColorSpace },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo drawingBufferColorSpace_setterinfo = {
  { (JSJitGetterOp)set_drawingBufferColorSpace },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_unpackColorSpace(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "unpackColorSpace", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  PredefinedColorSpace result(MOZ_KnownLive(self)->UnpackColorSpace());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!ToJSValue(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_unpackColorSpace(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.unpackColorSpace setter");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "unpackColorSpace", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  PredefinedColorSpace arg0;
  {
    int index;
    if (!binding_detail::FindEnumStringIndex<false>(cx, args[0],
                                                                       binding_detail::EnumStrings<PredefinedColorSpace>::Values,
                                                                       "PredefinedColorSpace", "value being assigned",
                                                                       &index)) {
      return false;
    }
    if (index < 0) {
      return true;
    }
    arg0 = static_cast<PredefinedColorSpace>(index);
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetUnpackColorSpace(arg0))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetUnpackColorSpace(arg0);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo unpackColorSpace_getterinfo = {
  { get_unpackColorSpace },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo unpackColorSpace_setterinfo = {
  { (JSJitGetterOp)set_unpackColorSpace },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getContextAttributes(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "getContextAttributes", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  Nullable<WebGLContextAttributes> result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetContextAttributes(result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetContextAttributes(result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result.IsNull()) {
    args.rval().setNull();
    return true;
  }
  if (!result.Value().ToObjectInternal(cx, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo getContextAttributes_methodinfo = {
  { (JSJitGetterOp)getContextAttributes },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
isContextLost(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "isContextLost", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  bool result(MOZ_KnownLive(self)->IsContextLost());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo isContextLost_methodinfo = {
  { (JSJitGetterOp)isContextLost },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getSupportedExtensions(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "getSupportedExtensions", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  Nullable<nsTArray<nsString>> result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetSupportedExtensions(result, nsContentUtils::ThreadsafeIsSystemCaller(cx) ? CallerType::System : CallerType::NonSystem))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetSupportedExtensions(result, nsContentUtils::ThreadsafeIsSystemCaller(cx) ? CallerType::System : CallerType::NonSystem);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  if (result.IsNull()) {
    args.rval().setNull();
    return true;
  }

  uint32_t length = result.Value().Length();
  JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
  if (!returnArray) {
    return false;
  }
  // Scope for 'tmp'
  {
    JS::Rooted<JS::Value> tmp(cx);
    for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
      // Control block to let us common up the JS_DefineElement calls when there
      // are different ways to succeed at wrapping the object.
      do {
        if (!xpc::NonVoidStringToJsval(cx, result.Value()[sequenceIdx0], &tmp)) {
          return false;
        }
        break;
      } while (false);
      if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                            JSPROP_ENUMERATE)) {
        return false;
      }
    }
  }
  args.rval().setObject(*returnArray);
  return true;
}

static const JSJitInfo getSupportedExtensions_methodinfo = {
  { (JSJitGetterOp)getSupportedExtensions },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getExtension(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "getExtension", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.getExtension", 1)) {
    return false;
  }
  binding_detail::FakeString<char16_t> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  FastErrorResult rv;
  JS::Rooted<JSObject*> result(cx);
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetExtension(cx, NonNullHelper(Constify(arg0)), &result, nsContentUtils::ThreadsafeIsSystemCaller(cx) ? CallerType::System : CallerType::NonSystem, rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetExtension(cx, NonNullHelper(Constify(arg0)), &result, nsContentUtils::ThreadsafeIsSystemCaller(cx) ? CallerType::System : CallerType::NonSystem, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "WebGL2RenderingContext.getExtension"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
                JS::ExposeObjectToActiveJS(result);
              }
              args.rval().setObjectOrNull(result);
  if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo getExtension_methodinfo = {
  { (JSJitGetterOp)getExtension },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
activeTexture(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "activeTexture", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.activeTexture", 1)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->ActiveTexture(arg0))>, "Should be returning void here");
  MOZ_KnownLive(self)->ActiveTexture(arg0);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo activeTexture_methodinfo = {
  { (JSJitGetterOp)activeTexture },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
attachShader(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.attachShader");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "attachShader", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.attachShader", 2)) {
    return false;
  }
  NonNull<mozilla::WebGLProgramJS> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLProgram, mozilla::WebGLProgramJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLProgram");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  NonNull<mozilla::WebGLShaderJS> arg1;
  if (args[1].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLShader, mozilla::WebGLShaderJS>(args[1], arg1, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 2", "WebGLShader");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 2");
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->AttachShader(MOZ_KnownLive(NonNullHelper(arg0)), MOZ_KnownLive(NonNullHelper(arg1))))>, "Should be returning void here");
  MOZ_KnownLive(self)->AttachShader(MOZ_KnownLive(NonNullHelper(arg0)), MOZ_KnownLive(NonNullHelper(arg1)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo attachShader_methodinfo = {
  { (JSJitGetterOp)attachShader },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
bindAttribLocation(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.bindAttribLocation");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "bindAttribLocation", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.bindAttribLocation", 3)) {
    return false;
  }
  NonNull<mozilla::WebGLProgramJS> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLProgram, mozilla::WebGLProgramJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLProgram");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  uint32_t arg1;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  binding_detail::FakeString<char16_t> arg2;
  if (!ConvertJSValueToString(cx, args[2], eStringify, eStringify, arg2)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->BindAttribLocation(MOZ_KnownLive(NonNullHelper(arg0)), arg1, NonNullHelper(Constify(arg2))))>, "Should be returning void here");
  MOZ_KnownLive(self)->BindAttribLocation(MOZ_KnownLive(NonNullHelper(arg0)), arg1, NonNullHelper(Constify(arg2)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo bindAttribLocation_methodinfo = {
  { (JSJitGetterOp)bindAttribLocation },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
bindBuffer(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.bindBuffer");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "bindBuffer", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.bindBuffer", 2)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  mozilla::WebGLBufferJS* arg1;
  if (args[1].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLBuffer, mozilla::WebGLBufferJS>(args[1], arg1, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 2", "WebGLBuffer");
        return false;
      }
    }
  } else if (args[1].isNullOrUndefined()) {
    arg1 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 2");
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->BindBuffer(arg0, MOZ_KnownLive(Constify(arg1))))>, "Should be returning void here");
  MOZ_KnownLive(self)->BindBuffer(arg0, MOZ_KnownLive(Constify(arg1)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo bindBuffer_methodinfo = {
  { (JSJitGetterOp)bindBuffer },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
bindFramebuffer(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.bindFramebuffer");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "bindFramebuffer", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.bindFramebuffer", 2)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  mozilla::WebGLFramebufferJS* arg1;
  if (args[1].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLFramebuffer, mozilla::WebGLFramebufferJS>(args[1], arg1, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 2", "WebGLFramebuffer");
        return false;
      }
    }
  } else if (args[1].isNullOrUndefined()) {
    arg1 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 2");
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->BindFramebuffer(arg0, MOZ_KnownLive(Constify(arg1))))>, "Should be returning void here");
  MOZ_KnownLive(self)->BindFramebuffer(arg0, MOZ_KnownLive(Constify(arg1)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo bindFramebuffer_methodinfo = {
  { (JSJitGetterOp)bindFramebuffer },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
bindRenderbuffer(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.bindRenderbuffer");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "bindRenderbuffer", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.bindRenderbuffer", 2)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  mozilla::WebGLRenderbufferJS* arg1;
  if (args[1].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLRenderbuffer, mozilla::WebGLRenderbufferJS>(args[1], arg1, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 2", "WebGLRenderbuffer");
        return false;
      }
    }
  } else if (args[1].isNullOrUndefined()) {
    arg1 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 2");
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->BindRenderbuffer(arg0, MOZ_KnownLive(Constify(arg1))))>, "Should be returning void here");
  MOZ_KnownLive(self)->BindRenderbuffer(arg0, MOZ_KnownLive(Constify(arg1)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo bindRenderbuffer_methodinfo = {
  { (JSJitGetterOp)bindRenderbuffer },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
bindTexture(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.bindTexture");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "bindTexture", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.bindTexture", 2)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  mozilla::WebGLTextureJS* arg1;
  if (args[1].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLTexture, mozilla::WebGLTextureJS>(args[1], arg1, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 2", "WebGLTexture");
        return false;
      }
    }
  } else if (args[1].isNullOrUndefined()) {
    arg1 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 2");
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->BindTexture(arg0, MOZ_KnownLive(Constify(arg1))))>, "Should be returning void here");
  MOZ_KnownLive(self)->BindTexture(arg0, MOZ_KnownLive(Constify(arg1)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo bindTexture_methodinfo = {
  { (JSJitGetterOp)bindTexture },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
blendColor(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "blendColor", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.blendColor", 4)) {
    return false;
  }
  float arg0;
  if (!ValueToPrimitive<float, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  float arg1;
  if (!ValueToPrimitive<float, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  float arg2;
  if (!ValueToPrimitive<float, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  }
  float arg3;
  if (!ValueToPrimitive<float, eDefault>(cx, args[3], "Argument 4", &arg3)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->BlendColor(arg0, arg1, arg2, arg3))>, "Should be returning void here");
  MOZ_KnownLive(self)->BlendColor(arg0, arg1, arg2, arg3);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo blendColor_methodinfo = {
  { (JSJitGetterOp)blendColor },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
blendEquation(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "blendEquation", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.blendEquation", 1)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->BlendEquation(arg0))>, "Should be returning void here");
  MOZ_KnownLive(self)->BlendEquation(arg0);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo blendEquation_methodinfo = {
  { (JSJitGetterOp)blendEquation },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
blendEquationSeparate(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "blendEquationSeparate", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.blendEquationSeparate", 2)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  uint32_t arg1;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->BlendEquationSeparate(arg0, arg1))>, "Should be returning void here");
  MOZ_KnownLive(self)->BlendEquationSeparate(arg0, arg1);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo blendEquationSeparate_methodinfo = {
  { (JSJitGetterOp)blendEquationSeparate },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
blendFunc(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "blendFunc", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.blendFunc", 2)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  uint32_t arg1;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->BlendFunc(arg0, arg1))>, "Should be returning void here");
  MOZ_KnownLive(self)->BlendFunc(arg0, arg1);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo blendFunc_methodinfo = {
  { (JSJitGetterOp)blendFunc },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
blendFuncSeparate(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "blendFuncSeparate", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.blendFuncSeparate", 4)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  uint32_t arg1;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  uint32_t arg2;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  }
  uint32_t arg3;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->BlendFuncSeparate(arg0, arg1, arg2, arg3))>, "Should be returning void here");
  MOZ_KnownLive(self)->BlendFuncSeparate(arg0, arg1, arg2, arg3);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo blendFuncSeparate_methodinfo = {
  { (JSJitGetterOp)blendFuncSeparate },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
checkFramebufferStatus(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "checkFramebufferStatus", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.checkFramebufferStatus", 1)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  uint32_t result(MOZ_KnownLive(self)->CheckFramebufferStatus(arg0));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setNumber(result);
  return true;
}

static const JSJitInfo checkFramebufferStatus_methodinfo = {
  { (JSJitGetterOp)checkFramebufferStatus },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_DOUBLE,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
clear(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "clear", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.clear", 1)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Clear(arg0))>, "Should be returning void here");
  MOZ_KnownLive(self)->Clear(arg0);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo clear_methodinfo = {
  { (JSJitGetterOp)clear },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
clearColor(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "clearColor", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.clearColor", 4)) {
    return false;
  }
  float arg0;
  if (!ValueToPrimitive<float, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  float arg1;
  if (!ValueToPrimitive<float, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  float arg2;
  if (!ValueToPrimitive<float, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  }
  float arg3;
  if (!ValueToPrimitive<float, eDefault>(cx, args[3], "Argument 4", &arg3)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->ClearColor(arg0, arg1, arg2, arg3))>, "Should be returning void here");
  MOZ_KnownLive(self)->ClearColor(arg0, arg1, arg2, arg3);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo clearColor_methodinfo = {
  { (JSJitGetterOp)clearColor },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
clearDepth(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "clearDepth", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.clearDepth", 1)) {
    return false;
  }
  float arg0;
  if (!ValueToPrimitive<float, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->ClearDepth(arg0))>, "Should be returning void here");
  MOZ_KnownLive(self)->ClearDepth(arg0);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo clearDepth_methodinfo = {
  { (JSJitGetterOp)clearDepth },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
clearStencil(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "clearStencil", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.clearStencil", 1)) {
    return false;
  }
  int32_t arg0;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->ClearStencil(arg0))>, "Should be returning void here");
  MOZ_KnownLive(self)->ClearStencil(arg0);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo clearStencil_methodinfo = {
  { (JSJitGetterOp)clearStencil },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
colorMask(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "colorMask", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.colorMask", 4)) {
    return false;
  }
  bool arg0;
  if (!ValueToPrimitive<bool, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  bool arg1;
  if (!ValueToPrimitive<bool, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  bool arg2;
  if (!ValueToPrimitive<bool, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  }
  bool arg3;
  if (!ValueToPrimitive<bool, eDefault>(cx, args[3], "Argument 4", &arg3)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->ColorMask(arg0, arg1, arg2, arg3))>, "Should be returning void here");
  MOZ_KnownLive(self)->ColorMask(arg0, arg1, arg2, arg3);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo colorMask_methodinfo = {
  { (JSJitGetterOp)colorMask },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
compileShader(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.compileShader");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "compileShader", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.compileShader", 1)) {
    return false;
  }
  NonNull<mozilla::WebGLShaderJS> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLShader, mozilla::WebGLShaderJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLShader");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->CompileShader(MOZ_KnownLive(NonNullHelper(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->CompileShader(MOZ_KnownLive(NonNullHelper(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo compileShader_methodinfo = {
  { (JSJitGetterOp)compileShader },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
copyTexImage2D(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "copyTexImage2D", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.copyTexImage2D", 8)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  int32_t arg1;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  uint32_t arg2;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  }
  int32_t arg3;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
    return false;
  }
  int32_t arg4;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[4], "Argument 5", &arg4)) {
    return false;
  }
  int32_t arg5;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[5], "Argument 6", &arg5)) {
    return false;
  }
  int32_t arg6;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[6], "Argument 7", &arg6)) {
    return false;
  }
  int32_t arg7;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[7], "Argument 8", &arg7)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->CopyTexImage2D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7))>, "Should be returning void here");
  MOZ_KnownLive(self)->CopyTexImage2D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo copyTexImage2D_methodinfo = {
  { (JSJitGetterOp)copyTexImage2D },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
copyTexSubImage2D(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "copyTexSubImage2D", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.copyTexSubImage2D", 8)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  int32_t arg1;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  int32_t arg2;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  }
  int32_t arg3;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
    return false;
  }
  int32_t arg4;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[4], "Argument 5", &arg4)) {
    return false;
  }
  int32_t arg5;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[5], "Argument 6", &arg5)) {
    return false;
  }
  int32_t arg6;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[6], "Argument 7", &arg6)) {
    return false;
  }
  int32_t arg7;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[7], "Argument 8", &arg7)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->CopyTexSubImage2D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7))>, "Should be returning void here");
  MOZ_KnownLive(self)->CopyTexSubImage2D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo copyTexSubImage2D_methodinfo = {
  { (JSJitGetterOp)copyTexSubImage2D },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
createBuffer(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "createBuffer", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  auto result(StrongOrRawPtr<mozilla::WebGLBufferJS>(MOZ_KnownLive(self)->CreateBuffer()));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo createBuffer_methodinfo = {
  { (JSJitGetterOp)createBuffer },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
createFramebuffer(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "createFramebuffer", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  auto result(StrongOrRawPtr<mozilla::WebGLFramebufferJS>(MOZ_KnownLive(self)->CreateFramebuffer()));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo createFramebuffer_methodinfo = {
  { (JSJitGetterOp)createFramebuffer },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
createProgram(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "createProgram", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  auto result(StrongOrRawPtr<mozilla::WebGLProgramJS>(MOZ_KnownLive(self)->CreateProgram()));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo createProgram_methodinfo = {
  { (JSJitGetterOp)createProgram },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
createRenderbuffer(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "createRenderbuffer", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  auto result(StrongOrRawPtr<mozilla::WebGLRenderbufferJS>(MOZ_KnownLive(self)->CreateRenderbuffer()));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo createRenderbuffer_methodinfo = {
  { (JSJitGetterOp)createRenderbuffer },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
createShader(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "createShader", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.createShader", 1)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  auto result(StrongOrRawPtr<mozilla::WebGLShaderJS>(MOZ_KnownLive(self)->CreateShader(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!result) {
    args.rval().setNull();
    return true;
  }
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo createShader_methodinfo = {
  { (JSJitGetterOp)createShader },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
createTexture(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "createTexture", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  auto result(StrongOrRawPtr<mozilla::WebGLTextureJS>(MOZ_KnownLive(self)->CreateTexture()));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo createTexture_methodinfo = {
  { (JSJitGetterOp)createTexture },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
cullFace(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "cullFace", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.cullFace", 1)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->CullFace(arg0))>, "Should be returning void here");
  MOZ_KnownLive(self)->CullFace(arg0);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo cullFace_methodinfo = {
  { (JSJitGetterOp)cullFace },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
deleteBuffer(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.deleteBuffer");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "deleteBuffer", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.deleteBuffer", 1)) {
    return false;
  }
  mozilla::WebGLBufferJS* arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLBuffer, mozilla::WebGLBufferJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLBuffer");
        return false;
      }
    }
  } else if (args[0].isNullOrUndefined()) {
    arg0 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->DeleteBuffer(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->DeleteBuffer(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo deleteBuffer_methodinfo = {
  { (JSJitGetterOp)deleteBuffer },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
deleteFramebuffer(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.deleteFramebuffer");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "deleteFramebuffer", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.deleteFramebuffer", 1)) {
    return false;
  }
  mozilla::WebGLFramebufferJS* arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLFramebuffer, mozilla::WebGLFramebufferJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLFramebuffer");
        return false;
      }
    }
  } else if (args[0].isNullOrUndefined()) {
    arg0 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->DeleteFramebuffer(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->DeleteFramebuffer(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo deleteFramebuffer_methodinfo = {
  { (JSJitGetterOp)deleteFramebuffer },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
deleteProgram(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.deleteProgram");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "deleteProgram", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.deleteProgram", 1)) {
    return false;
  }
  mozilla::WebGLProgramJS* arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLProgram, mozilla::WebGLProgramJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLProgram");
        return false;
      }
    }
  } else if (args[0].isNullOrUndefined()) {
    arg0 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->DeleteProgram(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->DeleteProgram(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo deleteProgram_methodinfo = {
  { (JSJitGetterOp)deleteProgram },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
deleteRenderbuffer(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.deleteRenderbuffer");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "deleteRenderbuffer", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.deleteRenderbuffer", 1)) {
    return false;
  }
  mozilla::WebGLRenderbufferJS* arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLRenderbuffer, mozilla::WebGLRenderbufferJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLRenderbuffer");
        return false;
      }
    }
  } else if (args[0].isNullOrUndefined()) {
    arg0 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->DeleteRenderbuffer(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->DeleteRenderbuffer(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo deleteRenderbuffer_methodinfo = {
  { (JSJitGetterOp)deleteRenderbuffer },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
deleteShader(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.deleteShader");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "deleteShader", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.deleteShader", 1)) {
    return false;
  }
  mozilla::WebGLShaderJS* arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLShader, mozilla::WebGLShaderJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLShader");
        return false;
      }
    }
  } else if (args[0].isNullOrUndefined()) {
    arg0 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->DeleteShader(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->DeleteShader(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo deleteShader_methodinfo = {
  { (JSJitGetterOp)deleteShader },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
deleteTexture(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.deleteTexture");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "deleteTexture", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.deleteTexture", 1)) {
    return false;
  }
  mozilla::WebGLTextureJS* arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLTexture, mozilla::WebGLTextureJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLTexture");
        return false;
      }
    }
  } else if (args[0].isNullOrUndefined()) {
    arg0 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->DeleteTexture(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->DeleteTexture(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo deleteTexture_methodinfo = {
  { (JSJitGetterOp)deleteTexture },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
depthFunc(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "depthFunc", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.depthFunc", 1)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->DepthFunc(arg0))>, "Should be returning void here");
  MOZ_KnownLive(self)->DepthFunc(arg0);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo depthFunc_methodinfo = {
  { (JSJitGetterOp)depthFunc },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
depthMask(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "depthMask", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.depthMask", 1)) {
    return false;
  }
  bool arg0;
  if (!ValueToPrimitive<bool, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->DepthMask(arg0))>, "Should be returning void here");
  MOZ_KnownLive(self)->DepthMask(arg0);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo depthMask_methodinfo = {
  { (JSJitGetterOp)depthMask },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
depthRange(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "depthRange", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.depthRange", 2)) {
    return false;
  }
  float arg0;
  if (!ValueToPrimitive<float, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  float arg1;
  if (!ValueToPrimitive<float, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->DepthRange(arg0, arg1))>, "Should be returning void here");
  MOZ_KnownLive(self)->DepthRange(arg0, arg1);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo depthRange_methodinfo = {
  { (JSJitGetterOp)depthRange },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
detachShader(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.detachShader");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "detachShader", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.detachShader", 2)) {
    return false;
  }
  NonNull<mozilla::WebGLProgramJS> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLProgram, mozilla::WebGLProgramJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLProgram");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  NonNull<mozilla::WebGLShaderJS> arg1;
  if (args[1].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLShader, mozilla::WebGLShaderJS>(args[1], arg1, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 2", "WebGLShader");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 2");
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->DetachShader(MOZ_KnownLive(NonNullHelper(arg0)), MOZ_KnownLive(NonNullHelper(arg1))))>, "Should be returning void here");
  MOZ_KnownLive(self)->DetachShader(MOZ_KnownLive(NonNullHelper(arg0)), MOZ_KnownLive(NonNullHelper(arg1)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo detachShader_methodinfo = {
  { (JSJitGetterOp)detachShader },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
disable(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "disable", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.disable", 1)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Disable(arg0))>, "Should be returning void here");
  MOZ_KnownLive(self)->Disable(arg0);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo disable_methodinfo = {
  { (JSJitGetterOp)disable },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
disableVertexAttribArray(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "disableVertexAttribArray", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.disableVertexAttribArray", 1)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->DisableVertexAttribArray(arg0))>, "Should be returning void here");
  MOZ_KnownLive(self)->DisableVertexAttribArray(arg0);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo disableVertexAttribArray_methodinfo = {
  { (JSJitGetterOp)disableVertexAttribArray },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
drawArrays(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "drawArrays", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.drawArrays", 3)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  int32_t arg1;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  int32_t arg2;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->DrawArrays(arg0, arg1, arg2))>, "Should be returning void here");
  MOZ_KnownLive(self)->DrawArrays(arg0, arg1, arg2);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo drawArrays_methodinfo = {
  { (JSJitGetterOp)drawArrays },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
drawElements(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "drawElements", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.drawElements", 4)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  int32_t arg1;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  uint32_t arg2;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  }
  int64_t arg3;
  if (!ValueToPrimitive<int64_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->DrawElements(arg0, arg1, arg2, arg3))>, "Should be returning void here");
  MOZ_KnownLive(self)->DrawElements(arg0, arg1, arg2, arg3);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo drawElements_methodinfo = {
  { (JSJitGetterOp)drawElements },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
enable(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "enable", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.enable", 1)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Enable(arg0))>, "Should be returning void here");
  MOZ_KnownLive(self)->Enable(arg0);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo enable_methodinfo = {
  { (JSJitGetterOp)enable },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
enableVertexAttribArray(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "enableVertexAttribArray", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.enableVertexAttribArray", 1)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->EnableVertexAttribArray(arg0))>, "Should be returning void here");
  MOZ_KnownLive(self)->EnableVertexAttribArray(arg0);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo enableVertexAttribArray_methodinfo = {
  { (JSJitGetterOp)enableVertexAttribArray },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
finish(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "finish", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Finish())>, "Should be returning void here");
  MOZ_KnownLive(self)->Finish();
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo finish_methodinfo = {
  { (JSJitGetterOp)finish },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
flush(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "flush", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Flush())>, "Should be returning void here");
  MOZ_KnownLive(self)->Flush();
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo flush_methodinfo = {
  { (JSJitGetterOp)flush },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
framebufferRenderbuffer(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.framebufferRenderbuffer");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "framebufferRenderbuffer", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.framebufferRenderbuffer", 4)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  uint32_t arg1;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  uint32_t arg2;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  }
  mozilla::WebGLRenderbufferJS* arg3;
  if (args[3].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLRenderbuffer, mozilla::WebGLRenderbufferJS>(args[3], arg3, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 4", "WebGLRenderbuffer");
        return false;
      }
    }
  } else if (args[3].isNullOrUndefined()) {
    arg3 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 4");
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->FramebufferRenderbuffer(arg0, arg1, arg2, MOZ_KnownLive(Constify(arg3))))>, "Should be returning void here");
  MOZ_KnownLive(self)->FramebufferRenderbuffer(arg0, arg1, arg2, MOZ_KnownLive(Constify(arg3)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo framebufferRenderbuffer_methodinfo = {
  { (JSJitGetterOp)framebufferRenderbuffer },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
framebufferTexture2D(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.framebufferTexture2D");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "framebufferTexture2D", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.framebufferTexture2D", 5)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  uint32_t arg1;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  uint32_t arg2;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  }
  mozilla::WebGLTextureJS* arg3;
  if (args[3].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLTexture, mozilla::WebGLTextureJS>(args[3], arg3, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 4", "WebGLTexture");
        return false;
      }
    }
  } else if (args[3].isNullOrUndefined()) {
    arg3 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 4");
    return false;
  }
  int32_t arg4;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[4], "Argument 5", &arg4)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->FramebufferTexture2D(arg0, arg1, arg2, MOZ_KnownLive(Constify(arg3)), arg4))>, "Should be returning void here");
  MOZ_KnownLive(self)->FramebufferTexture2D(arg0, arg1, arg2, MOZ_KnownLive(Constify(arg3)), arg4);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo framebufferTexture2D_methodinfo = {
  { (JSJitGetterOp)framebufferTexture2D },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
frontFace(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "frontFace", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.frontFace", 1)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->FrontFace(arg0))>, "Should be returning void here");
  MOZ_KnownLive(self)->FrontFace(arg0);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo frontFace_methodinfo = {
  { (JSJitGetterOp)frontFace },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
generateMipmap(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "generateMipmap", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.generateMipmap", 1)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GenerateMipmap(arg0))>, "Should be returning void here");
  MOZ_KnownLive(self)->GenerateMipmap(arg0);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo generateMipmap_methodinfo = {
  { (JSJitGetterOp)generateMipmap },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getActiveAttrib(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.getActiveAttrib");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "getActiveAttrib", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.getActiveAttrib", 2)) {
    return false;
  }
  NonNull<mozilla::WebGLProgramJS> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLProgram, mozilla::WebGLProgramJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLProgram");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  uint32_t arg1;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  auto result(StrongOrRawPtr<mozilla::WebGLActiveInfoJS>(MOZ_KnownLive(self)->GetActiveAttrib(MOZ_KnownLive(NonNullHelper(arg0)), arg1)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!result) {
    args.rval().setNull();
    return true;
  }
  if (!WrapNewBindingNonWrapperCachedObject(cx, obj, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo getActiveAttrib_methodinfo = {
  { (JSJitGetterOp)getActiveAttrib },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getActiveUniform(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.getActiveUniform");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "getActiveUniform", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.getActiveUniform", 2)) {
    return false;
  }
  NonNull<mozilla::WebGLProgramJS> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLProgram, mozilla::WebGLProgramJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLProgram");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  uint32_t arg1;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  auto result(StrongOrRawPtr<mozilla::WebGLActiveInfoJS>(MOZ_KnownLive(self)->GetActiveUniform(MOZ_KnownLive(NonNullHelper(arg0)), arg1)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!result) {
    args.rval().setNull();
    return true;
  }
  if (!WrapNewBindingNonWrapperCachedObject(cx, obj, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo getActiveUniform_methodinfo = {
  { (JSJitGetterOp)getActiveUniform },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getAttachedShaders(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.getAttachedShaders");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "getAttachedShaders", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.getAttachedShaders", 1)) {
    return false;
  }
  NonNull<mozilla::WebGLProgramJS> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLProgram, mozilla::WebGLProgramJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLProgram");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  Nullable<nsTArray<StrongPtrForMember<mozilla::WebGLShaderJS>>> result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetAttachedShaders(MOZ_KnownLive(NonNullHelper(arg0)), result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetAttachedShaders(MOZ_KnownLive(NonNullHelper(arg0)), result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  if (result.IsNull()) {
    args.rval().setNull();
    return true;
  }

  uint32_t length = result.Value().Length();
  JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
  if (!returnArray) {
    return false;
  }
  // Scope for 'tmp'
  {
    JS::Rooted<JS::Value> tmp(cx);
    for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
      // Control block to let us common up the JS_DefineElement calls when there
      // are different ways to succeed at wrapping the object.
      do {
        if (!GetOrCreateDOMReflector(cx, result.Value()[sequenceIdx0], &tmp)) {
          MOZ_ASSERT(JS_IsExceptionPending(cx));
          return false;
        }
        break;
      } while (false);
      if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                            JSPROP_ENUMERATE)) {
        return false;
      }
    }
  }
  args.rval().setObject(*returnArray);
  return true;
}

static const JSJitInfo getAttachedShaders_methodinfo = {
  { (JSJitGetterOp)getAttachedShaders },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getAttribLocation(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.getAttribLocation");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "getAttribLocation", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.getAttribLocation", 2)) {
    return false;
  }
  NonNull<mozilla::WebGLProgramJS> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLProgram, mozilla::WebGLProgramJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLProgram");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  binding_detail::FakeString<char16_t> arg1;
  if (!ConvertJSValueToString(cx, args[1], eStringify, eStringify, arg1)) {
    return false;
  }
  int32_t result(MOZ_KnownLive(self)->GetAttribLocation(MOZ_KnownLive(NonNullHelper(arg0)), NonNullHelper(Constify(arg1))));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setInt32(int32_t(result));
  return true;
}

static const JSJitInfo getAttribLocation_methodinfo = {
  { (JSJitGetterOp)getAttribLocation },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_INT32,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getBufferParameter(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "getBufferParameter", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.getBufferParameter", 2)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  uint32_t arg1;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  JS::Rooted<JS::Value> result(cx);
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetBufferParameter(cx, arg0, arg1, &result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetBufferParameter(cx, arg0, arg1, &result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  JS::ExposeValueToActiveJS(result);
  args.rval().set(result);
  if (!MaybeWrapValue(cx, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo getBufferParameter_methodinfo = {
  { (JSJitGetterOp)getBufferParameter },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getParameter(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "getParameter", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.getParameter", 1)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  FastErrorResult rv;
  JS::Rooted<JS::Value> result(cx);
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetParameter(cx, arg0, &result, rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetParameter(cx, arg0, &result, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "WebGL2RenderingContext.getParameter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  JS::ExposeValueToActiveJS(result);
  args.rval().set(result);
  if (!MaybeWrapValue(cx, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo getParameter_methodinfo = {
  { (JSJitGetterOp)getParameter },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getError(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "getError", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  uint32_t result(MOZ_KnownLive(self)->GetError());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setNumber(result);
  return true;
}

static const JSJitInfo getError_methodinfo = {
  { (JSJitGetterOp)getError },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_DOUBLE,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getFramebufferAttachmentParameter(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "getFramebufferAttachmentParameter", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.getFramebufferAttachmentParameter", 3)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  uint32_t arg1;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  uint32_t arg2;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  }
  FastErrorResult rv;
  JS::Rooted<JS::Value> result(cx);
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetFramebufferAttachmentParameter(cx, arg0, arg1, arg2, &result, rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetFramebufferAttachmentParameter(cx, arg0, arg1, arg2, &result, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "WebGL2RenderingContext.getFramebufferAttachmentParameter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  JS::ExposeValueToActiveJS(result);
  args.rval().set(result);
  if (!MaybeWrapValue(cx, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo getFramebufferAttachmentParameter_methodinfo = {
  { (JSJitGetterOp)getFramebufferAttachmentParameter },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getProgramParameter(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.getProgramParameter");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "getProgramParameter", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.getProgramParameter", 2)) {
    return false;
  }
  NonNull<mozilla::WebGLProgramJS> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLProgram, mozilla::WebGLProgramJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLProgram");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  uint32_t arg1;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  JS::Rooted<JS::Value> result(cx);
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetProgramParameter(cx, MOZ_KnownLive(NonNullHelper(arg0)), arg1, &result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetProgramParameter(cx, MOZ_KnownLive(NonNullHelper(arg0)), arg1, &result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  JS::ExposeValueToActiveJS(result);
  args.rval().set(result);
  if (!MaybeWrapValue(cx, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo getProgramParameter_methodinfo = {
  { (JSJitGetterOp)getProgramParameter },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getProgramInfoLog(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.getProgramInfoLog");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "getProgramInfoLog", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.getProgramInfoLog", 1)) {
    return false;
  }
  NonNull<mozilla::WebGLProgramJS> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLProgram, mozilla::WebGLProgramJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLProgram");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  DOMString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetProgramInfoLog(MOZ_KnownLive(NonNullHelper(arg0)), result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetProgramInfoLog(MOZ_KnownLive(NonNullHelper(arg0)), result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!xpc::StringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo getProgramInfoLog_methodinfo = {
  { (JSJitGetterOp)getProgramInfoLog },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getRenderbufferParameter(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "getRenderbufferParameter", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.getRenderbufferParameter", 2)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  uint32_t arg1;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  JS::Rooted<JS::Value> result(cx);
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetRenderbufferParameter(cx, arg0, arg1, &result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetRenderbufferParameter(cx, arg0, arg1, &result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  JS::ExposeValueToActiveJS(result);
  args.rval().set(result);
  if (!MaybeWrapValue(cx, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo getRenderbufferParameter_methodinfo = {
  { (JSJitGetterOp)getRenderbufferParameter },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getShaderParameter(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.getShaderParameter");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "getShaderParameter", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.getShaderParameter", 2)) {
    return false;
  }
  NonNull<mozilla::WebGLShaderJS> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLShader, mozilla::WebGLShaderJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLShader");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  uint32_t arg1;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  JS::Rooted<JS::Value> result(cx);
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetShaderParameter(cx, MOZ_KnownLive(NonNullHelper(arg0)), arg1, &result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetShaderParameter(cx, MOZ_KnownLive(NonNullHelper(arg0)), arg1, &result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  JS::ExposeValueToActiveJS(result);
  args.rval().set(result);
  if (!MaybeWrapValue(cx, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo getShaderParameter_methodinfo = {
  { (JSJitGetterOp)getShaderParameter },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getShaderPrecisionFormat(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "getShaderPrecisionFormat", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.getShaderPrecisionFormat", 2)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  uint32_t arg1;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  auto result(StrongOrRawPtr<mozilla::WebGLShaderPrecisionFormatJS>(MOZ_KnownLive(self)->GetShaderPrecisionFormat(arg0, arg1)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!result) {
    args.rval().setNull();
    return true;
  }
  if (!WrapNewBindingNonWrapperCachedObject(cx, obj, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo getShaderPrecisionFormat_methodinfo = {
  { (JSJitGetterOp)getShaderPrecisionFormat },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getShaderInfoLog(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.getShaderInfoLog");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "getShaderInfoLog", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.getShaderInfoLog", 1)) {
    return false;
  }
  NonNull<mozilla::WebGLShaderJS> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLShader, mozilla::WebGLShaderJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLShader");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  DOMString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetShaderInfoLog(MOZ_KnownLive(NonNullHelper(arg0)), result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetShaderInfoLog(MOZ_KnownLive(NonNullHelper(arg0)), result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!xpc::StringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo getShaderInfoLog_methodinfo = {
  { (JSJitGetterOp)getShaderInfoLog },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getShaderSource(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.getShaderSource");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "getShaderSource", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.getShaderSource", 1)) {
    return false;
  }
  NonNull<mozilla::WebGLShaderJS> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLShader, mozilla::WebGLShaderJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLShader");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  DOMString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetShaderSource(MOZ_KnownLive(NonNullHelper(arg0)), result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetShaderSource(MOZ_KnownLive(NonNullHelper(arg0)), result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!xpc::StringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo getShaderSource_methodinfo = {
  { (JSJitGetterOp)getShaderSource },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getTexParameter(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "getTexParameter", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.getTexParameter", 2)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  uint32_t arg1;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  JS::Rooted<JS::Value> result(cx);
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetTexParameter(cx, arg0, arg1, &result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetTexParameter(cx, arg0, arg1, &result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  JS::ExposeValueToActiveJS(result);
  args.rval().set(result);
  if (!MaybeWrapValue(cx, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo getTexParameter_methodinfo = {
  { (JSJitGetterOp)getTexParameter },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getUniform(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.getUniform");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "getUniform", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.getUniform", 2)) {
    return false;
  }
  NonNull<mozilla::WebGLProgramJS> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLProgram, mozilla::WebGLProgramJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLProgram");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  NonNull<mozilla::WebGLUniformLocationJS> arg1;
  if (args[1].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLUniformLocation, mozilla::WebGLUniformLocationJS>(args[1], arg1, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 2", "WebGLUniformLocation");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 2");
    return false;
  }
  JS::Rooted<JS::Value> result(cx);
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetUniform(cx, MOZ_KnownLive(NonNullHelper(arg0)), MOZ_KnownLive(NonNullHelper(arg1)), &result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetUniform(cx, MOZ_KnownLive(NonNullHelper(arg0)), MOZ_KnownLive(NonNullHelper(arg1)), &result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  JS::ExposeValueToActiveJS(result);
  args.rval().set(result);
  if (!MaybeWrapValue(cx, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo getUniform_methodinfo = {
  { (JSJitGetterOp)getUniform },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getUniformLocation(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.getUniformLocation");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "getUniformLocation", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.getUniformLocation", 2)) {
    return false;
  }
  NonNull<mozilla::WebGLProgramJS> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLProgram, mozilla::WebGLProgramJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLProgram");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  binding_detail::FakeString<char16_t> arg1;
  if (!ConvertJSValueToString(cx, args[1], eStringify, eStringify, arg1)) {
    return false;
  }
  auto result(StrongOrRawPtr<mozilla::WebGLUniformLocationJS>(MOZ_KnownLive(self)->GetUniformLocation(MOZ_KnownLive(NonNullHelper(arg0)), NonNullHelper(Constify(arg1)))));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!result) {
    args.rval().setNull();
    return true;
  }
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo getUniformLocation_methodinfo = {
  { (JSJitGetterOp)getUniformLocation },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getVertexAttrib(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "getVertexAttrib", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.getVertexAttrib", 2)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  uint32_t arg1;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  FastErrorResult rv;
  JS::Rooted<JS::Value> result(cx);
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetVertexAttrib(cx, arg0, arg1, &result, rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetVertexAttrib(cx, arg0, arg1, &result, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "WebGL2RenderingContext.getVertexAttrib"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  JS::ExposeValueToActiveJS(result);
  args.rval().set(result);
  if (!MaybeWrapValue(cx, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo getVertexAttrib_methodinfo = {
  { (JSJitGetterOp)getVertexAttrib },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getVertexAttribOffset(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "getVertexAttribOffset", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.getVertexAttribOffset", 2)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  uint32_t arg1;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  int64_t result(MOZ_KnownLive(self)->GetVertexAttribOffset(arg0, arg1));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().set(JS_NumberValue(double(result)));
  return true;
}

static const JSJitInfo getVertexAttribOffset_methodinfo = {
  { (JSJitGetterOp)getVertexAttribOffset },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_DOUBLE,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
hint(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "hint", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.hint", 2)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  uint32_t arg1;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Hint(arg0, arg1))>, "Should be returning void here");
  MOZ_KnownLive(self)->Hint(arg0, arg1);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo hint_methodinfo = {
  { (JSJitGetterOp)hint },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
isBuffer(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.isBuffer");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "isBuffer", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.isBuffer", 1)) {
    return false;
  }
  mozilla::WebGLBufferJS* arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLBuffer, mozilla::WebGLBufferJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLBuffer");
        return false;
      }
    }
  } else if (args[0].isNullOrUndefined()) {
    arg0 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  bool result(MOZ_KnownLive(self)->IsBuffer(MOZ_KnownLive(Constify(arg0))));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo isBuffer_methodinfo = {
  { (JSJitGetterOp)isBuffer },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
isEnabled(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "isEnabled", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.isEnabled", 1)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  bool result(MOZ_KnownLive(self)->IsEnabled(arg0));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo isEnabled_methodinfo = {
  { (JSJitGetterOp)isEnabled },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
isFramebuffer(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.isFramebuffer");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "isFramebuffer", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.isFramebuffer", 1)) {
    return false;
  }
  mozilla::WebGLFramebufferJS* arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLFramebuffer, mozilla::WebGLFramebufferJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLFramebuffer");
        return false;
      }
    }
  } else if (args[0].isNullOrUndefined()) {
    arg0 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  bool result(MOZ_KnownLive(self)->IsFramebuffer(MOZ_KnownLive(Constify(arg0))));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo isFramebuffer_methodinfo = {
  { (JSJitGetterOp)isFramebuffer },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
isProgram(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.isProgram");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "isProgram", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.isProgram", 1)) {
    return false;
  }
  mozilla::WebGLProgramJS* arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLProgram, mozilla::WebGLProgramJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLProgram");
        return false;
      }
    }
  } else if (args[0].isNullOrUndefined()) {
    arg0 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  bool result(MOZ_KnownLive(self)->IsProgram(MOZ_KnownLive(Constify(arg0))));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo isProgram_methodinfo = {
  { (JSJitGetterOp)isProgram },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
isRenderbuffer(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.isRenderbuffer");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "isRenderbuffer", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.isRenderbuffer", 1)) {
    return false;
  }
  mozilla::WebGLRenderbufferJS* arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLRenderbuffer, mozilla::WebGLRenderbufferJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLRenderbuffer");
        return false;
      }
    }
  } else if (args[0].isNullOrUndefined()) {
    arg0 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  bool result(MOZ_KnownLive(self)->IsRenderbuffer(MOZ_KnownLive(Constify(arg0))));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo isRenderbuffer_methodinfo = {
  { (JSJitGetterOp)isRenderbuffer },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
isShader(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.isShader");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "isShader", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.isShader", 1)) {
    return false;
  }
  mozilla::WebGLShaderJS* arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLShader, mozilla::WebGLShaderJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLShader");
        return false;
      }
    }
  } else if (args[0].isNullOrUndefined()) {
    arg0 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  bool result(MOZ_KnownLive(self)->IsShader(MOZ_KnownLive(Constify(arg0))));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo isShader_methodinfo = {
  { (JSJitGetterOp)isShader },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
isTexture(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.isTexture");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "isTexture", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.isTexture", 1)) {
    return false;
  }
  mozilla::WebGLTextureJS* arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLTexture, mozilla::WebGLTextureJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLTexture");
        return false;
      }
    }
  } else if (args[0].isNullOrUndefined()) {
    arg0 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  bool result(MOZ_KnownLive(self)->IsTexture(MOZ_KnownLive(Constify(arg0))));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo isTexture_methodinfo = {
  { (JSJitGetterOp)isTexture },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
lineWidth(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "lineWidth", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.lineWidth", 1)) {
    return false;
  }
  float arg0;
  if (!ValueToPrimitive<float, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->LineWidth(arg0))>, "Should be returning void here");
  MOZ_KnownLive(self)->LineWidth(arg0);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo lineWidth_methodinfo = {
  { (JSJitGetterOp)lineWidth },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
linkProgram(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.linkProgram");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "linkProgram", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.linkProgram", 1)) {
    return false;
  }
  NonNull<mozilla::WebGLProgramJS> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLProgram, mozilla::WebGLProgramJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLProgram");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->LinkProgram(MOZ_KnownLive(NonNullHelper(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->LinkProgram(MOZ_KnownLive(NonNullHelper(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo linkProgram_methodinfo = {
  { (JSJitGetterOp)linkProgram },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
pixelStorei(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "pixelStorei", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.pixelStorei", 2)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  int32_t arg1;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->PixelStorei(arg0, arg1))>, "Should be returning void here");
  MOZ_KnownLive(self)->PixelStorei(arg0, arg1);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo pixelStorei_methodinfo = {
  { (JSJitGetterOp)pixelStorei },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
polygonOffset(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "polygonOffset", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.polygonOffset", 2)) {
    return false;
  }
  float arg0;
  if (!ValueToPrimitive<float, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  float arg1;
  if (!ValueToPrimitive<float, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->PolygonOffset(arg0, arg1))>, "Should be returning void here");
  MOZ_KnownLive(self)->PolygonOffset(arg0, arg1);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo polygonOffset_methodinfo = {
  { (JSJitGetterOp)polygonOffset },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
renderbufferStorage(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "renderbufferStorage", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.renderbufferStorage", 4)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  uint32_t arg1;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  int32_t arg2;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  }
  int32_t arg3;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->RenderbufferStorage(arg0, arg1, arg2, arg3))>, "Should be returning void here");
  MOZ_KnownLive(self)->RenderbufferStorage(arg0, arg1, arg2, arg3);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo renderbufferStorage_methodinfo = {
  { (JSJitGetterOp)renderbufferStorage },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
sampleCoverage(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "sampleCoverage", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.sampleCoverage", 2)) {
    return false;
  }
  float arg0;
  if (!ValueToPrimitive<float, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  bool arg1;
  if (!ValueToPrimitive<bool, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SampleCoverage(arg0, arg1))>, "Should be returning void here");
  MOZ_KnownLive(self)->SampleCoverage(arg0, arg1);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo sampleCoverage_methodinfo = {
  { (JSJitGetterOp)sampleCoverage },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
scissor(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "scissor", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.scissor", 4)) {
    return false;
  }
  int32_t arg0;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  int32_t arg1;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  int32_t arg2;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  }
  int32_t arg3;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Scissor(arg0, arg1, arg2, arg3))>, "Should be returning void here");
  MOZ_KnownLive(self)->Scissor(arg0, arg1, arg2, arg3);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo scissor_methodinfo = {
  { (JSJitGetterOp)scissor },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
shaderSource(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.shaderSource");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "shaderSource", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.shaderSource", 2)) {
    return false;
  }
  NonNull<mozilla::WebGLShaderJS> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLShader, mozilla::WebGLShaderJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLShader");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  binding_detail::FakeString<char16_t> arg1;
  if (!ConvertJSValueToString(cx, args[1], eStringify, eStringify, arg1)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->ShaderSource(MOZ_KnownLive(NonNullHelper(arg0)), NonNullHelper(Constify(arg1))))>, "Should be returning void here");
  MOZ_KnownLive(self)->ShaderSource(MOZ_KnownLive(NonNullHelper(arg0)), NonNullHelper(Constify(arg1)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo shaderSource_methodinfo = {
  { (JSJitGetterOp)shaderSource },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
stencilFunc(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "stencilFunc", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.stencilFunc", 3)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  int32_t arg1;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  uint32_t arg2;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->StencilFunc(arg0, arg1, arg2))>, "Should be returning void here");
  MOZ_KnownLive(self)->StencilFunc(arg0, arg1, arg2);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo stencilFunc_methodinfo = {
  { (JSJitGetterOp)stencilFunc },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
stencilFuncSeparate(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "stencilFuncSeparate", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.stencilFuncSeparate", 4)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  uint32_t arg1;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  int32_t arg2;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  }
  uint32_t arg3;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->StencilFuncSeparate(arg0, arg1, arg2, arg3))>, "Should be returning void here");
  MOZ_KnownLive(self)->StencilFuncSeparate(arg0, arg1, arg2, arg3);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo stencilFuncSeparate_methodinfo = {
  { (JSJitGetterOp)stencilFuncSeparate },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
stencilMask(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "stencilMask", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.stencilMask", 1)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->StencilMask(arg0))>, "Should be returning void here");
  MOZ_KnownLive(self)->StencilMask(arg0);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo stencilMask_methodinfo = {
  { (JSJitGetterOp)stencilMask },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
stencilMaskSeparate(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "stencilMaskSeparate", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.stencilMaskSeparate", 2)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  uint32_t arg1;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->StencilMaskSeparate(arg0, arg1))>, "Should be returning void here");
  MOZ_KnownLive(self)->StencilMaskSeparate(arg0, arg1);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo stencilMaskSeparate_methodinfo = {
  { (JSJitGetterOp)stencilMaskSeparate },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
stencilOp(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "stencilOp", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.stencilOp", 3)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  uint32_t arg1;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  uint32_t arg2;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->StencilOp(arg0, arg1, arg2))>, "Should be returning void here");
  MOZ_KnownLive(self)->StencilOp(arg0, arg1, arg2);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo stencilOp_methodinfo = {
  { (JSJitGetterOp)stencilOp },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
stencilOpSeparate(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "stencilOpSeparate", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.stencilOpSeparate", 4)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  uint32_t arg1;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  uint32_t arg2;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  }
  uint32_t arg3;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->StencilOpSeparate(arg0, arg1, arg2, arg3))>, "Should be returning void here");
  MOZ_KnownLive(self)->StencilOpSeparate(arg0, arg1, arg2, arg3);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo stencilOpSeparate_methodinfo = {
  { (JSJitGetterOp)stencilOpSeparate },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
texParameterf(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "texParameterf", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.texParameterf", 3)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  uint32_t arg1;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  float arg2;
  if (!ValueToPrimitive<float, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->TexParameterf(arg0, arg1, arg2))>, "Should be returning void here");
  MOZ_KnownLive(self)->TexParameterf(arg0, arg1, arg2);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo texParameterf_methodinfo = {
  { (JSJitGetterOp)texParameterf },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
texParameteri(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "texParameteri", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.texParameteri", 3)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  uint32_t arg1;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  int32_t arg2;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->TexParameteri(arg0, arg1, arg2))>, "Should be returning void here");
  MOZ_KnownLive(self)->TexParameteri(arg0, arg1, arg2);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo texParameteri_methodinfo = {
  { (JSJitGetterOp)texParameteri },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
uniform1f(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.uniform1f");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "uniform1f", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.uniform1f", 2)) {
    return false;
  }
  mozilla::WebGLUniformLocationJS* arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLUniformLocation, mozilla::WebGLUniformLocationJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLUniformLocation");
        return false;
      }
    }
  } else if (args[0].isNullOrUndefined()) {
    arg0 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  float arg1;
  if (!ValueToPrimitive<float, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Uniform1f(MOZ_KnownLive(Constify(arg0)), arg1))>, "Should be returning void here");
  MOZ_KnownLive(self)->Uniform1f(MOZ_KnownLive(Constify(arg0)), arg1);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo uniform1f_methodinfo = {
  { (JSJitGetterOp)uniform1f },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
uniform2f(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.uniform2f");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "uniform2f", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.uniform2f", 3)) {
    return false;
  }
  mozilla::WebGLUniformLocationJS* arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLUniformLocation, mozilla::WebGLUniformLocationJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLUniformLocation");
        return false;
      }
    }
  } else if (args[0].isNullOrUndefined()) {
    arg0 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  float arg1;
  if (!ValueToPrimitive<float, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  float arg2;
  if (!ValueToPrimitive<float, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Uniform2f(MOZ_KnownLive(Constify(arg0)), arg1, arg2))>, "Should be returning void here");
  MOZ_KnownLive(self)->Uniform2f(MOZ_KnownLive(Constify(arg0)), arg1, arg2);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo uniform2f_methodinfo = {
  { (JSJitGetterOp)uniform2f },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
uniform3f(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.uniform3f");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "uniform3f", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.uniform3f", 4)) {
    return false;
  }
  mozilla::WebGLUniformLocationJS* arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLUniformLocation, mozilla::WebGLUniformLocationJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLUniformLocation");
        return false;
      }
    }
  } else if (args[0].isNullOrUndefined()) {
    arg0 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  float arg1;
  if (!ValueToPrimitive<float, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  float arg2;
  if (!ValueToPrimitive<float, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  }
  float arg3;
  if (!ValueToPrimitive<float, eDefault>(cx, args[3], "Argument 4", &arg3)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Uniform3f(MOZ_KnownLive(Constify(arg0)), arg1, arg2, arg3))>, "Should be returning void here");
  MOZ_KnownLive(self)->Uniform3f(MOZ_KnownLive(Constify(arg0)), arg1, arg2, arg3);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo uniform3f_methodinfo = {
  { (JSJitGetterOp)uniform3f },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
uniform4f(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.uniform4f");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "uniform4f", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.uniform4f", 5)) {
    return false;
  }
  mozilla::WebGLUniformLocationJS* arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLUniformLocation, mozilla::WebGLUniformLocationJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLUniformLocation");
        return false;
      }
    }
  } else if (args[0].isNullOrUndefined()) {
    arg0 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  float arg1;
  if (!ValueToPrimitive<float, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  float arg2;
  if (!ValueToPrimitive<float, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  }
  float arg3;
  if (!ValueToPrimitive<float, eDefault>(cx, args[3], "Argument 4", &arg3)) {
    return false;
  }
  float arg4;
  if (!ValueToPrimitive<float, eDefault>(cx, args[4], "Argument 5", &arg4)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Uniform4f(MOZ_KnownLive(Constify(arg0)), arg1, arg2, arg3, arg4))>, "Should be returning void here");
  MOZ_KnownLive(self)->Uniform4f(MOZ_KnownLive(Constify(arg0)), arg1, arg2, arg3, arg4);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo uniform4f_methodinfo = {
  { (JSJitGetterOp)uniform4f },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
uniform1i(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.uniform1i");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "uniform1i", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.uniform1i", 2)) {
    return false;
  }
  mozilla::WebGLUniformLocationJS* arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLUniformLocation, mozilla::WebGLUniformLocationJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLUniformLocation");
        return false;
      }
    }
  } else if (args[0].isNullOrUndefined()) {
    arg0 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  int32_t arg1;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Uniform1i(MOZ_KnownLive(Constify(arg0)), arg1))>, "Should be returning void here");
  MOZ_KnownLive(self)->Uniform1i(MOZ_KnownLive(Constify(arg0)), arg1);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo uniform1i_methodinfo = {
  { (JSJitGetterOp)uniform1i },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
uniform2i(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.uniform2i");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "uniform2i", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.uniform2i", 3)) {
    return false;
  }
  mozilla::WebGLUniformLocationJS* arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLUniformLocation, mozilla::WebGLUniformLocationJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLUniformLocation");
        return false;
      }
    }
  } else if (args[0].isNullOrUndefined()) {
    arg0 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  int32_t arg1;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  int32_t arg2;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Uniform2i(MOZ_KnownLive(Constify(arg0)), arg1, arg2))>, "Should be returning void here");
  MOZ_KnownLive(self)->Uniform2i(MOZ_KnownLive(Constify(arg0)), arg1, arg2);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo uniform2i_methodinfo = {
  { (JSJitGetterOp)uniform2i },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
uniform3i(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.uniform3i");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "uniform3i", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.uniform3i", 4)) {
    return false;
  }
  mozilla::WebGLUniformLocationJS* arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLUniformLocation, mozilla::WebGLUniformLocationJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLUniformLocation");
        return false;
      }
    }
  } else if (args[0].isNullOrUndefined()) {
    arg0 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  int32_t arg1;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  int32_t arg2;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  }
  int32_t arg3;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Uniform3i(MOZ_KnownLive(Constify(arg0)), arg1, arg2, arg3))>, "Should be returning void here");
  MOZ_KnownLive(self)->Uniform3i(MOZ_KnownLive(Constify(arg0)), arg1, arg2, arg3);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo uniform3i_methodinfo = {
  { (JSJitGetterOp)uniform3i },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
uniform4i(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.uniform4i");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "uniform4i", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.uniform4i", 5)) {
    return false;
  }
  mozilla::WebGLUniformLocationJS* arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLUniformLocation, mozilla::WebGLUniformLocationJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLUniformLocation");
        return false;
      }
    }
  } else if (args[0].isNullOrUndefined()) {
    arg0 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  int32_t arg1;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  int32_t arg2;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  }
  int32_t arg3;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
    return false;
  }
  int32_t arg4;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[4], "Argument 5", &arg4)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Uniform4i(MOZ_KnownLive(Constify(arg0)), arg1, arg2, arg3, arg4))>, "Should be returning void here");
  MOZ_KnownLive(self)->Uniform4i(MOZ_KnownLive(Constify(arg0)), arg1, arg2, arg3, arg4);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo uniform4i_methodinfo = {
  { (JSJitGetterOp)uniform4i },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
useProgram(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.useProgram");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "useProgram", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.useProgram", 1)) {
    return false;
  }
  mozilla::WebGLProgramJS* arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLProgram, mozilla::WebGLProgramJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLProgram");
        return false;
      }
    }
  } else if (args[0].isNullOrUndefined()) {
    arg0 = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->UseProgram(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->UseProgram(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo useProgram_methodinfo = {
  { (JSJitGetterOp)useProgram },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
validateProgram(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.validateProgram");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "validateProgram", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.validateProgram", 1)) {
    return false;
  }
  NonNull<mozilla::WebGLProgramJS> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::WebGLProgram, mozilla::WebGLProgramJS>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "WebGLProgram");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->ValidateProgram(MOZ_KnownLive(NonNullHelper(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->ValidateProgram(MOZ_KnownLive(NonNullHelper(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo validateProgram_methodinfo = {
  { (JSJitGetterOp)validateProgram },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
vertexAttrib1f(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "vertexAttrib1f", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.vertexAttrib1f", 2)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  float arg1;
  if (!ValueToPrimitive<float, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->VertexAttrib1f(arg0, arg1))>, "Should be returning void here");
  MOZ_KnownLive(self)->VertexAttrib1f(arg0, arg1);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo vertexAttrib1f_methodinfo = {
  { (JSJitGetterOp)vertexAttrib1f },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
vertexAttrib1fv(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.vertexAttrib1fv");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "vertexAttrib1fv", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.vertexAttrib1fv", 2)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  MaybeSharedFloat32ArrayOrUnrestrictedFloatSequence arg1;
  if (!arg1.Init(cx, args[1], "Argument 2", false)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->VertexAttrib1fv(arg0, Constify(arg1)))>, "Should be returning void here");
  MOZ_KnownLive(self)->VertexAttrib1fv(arg0, Constify(arg1));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo vertexAttrib1fv_methodinfo = {
  { (JSJitGetterOp)vertexAttrib1fv },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
vertexAttrib2f(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "vertexAttrib2f", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.vertexAttrib2f", 3)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  float arg1;
  if (!ValueToPrimitive<float, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  float arg2;
  if (!ValueToPrimitive<float, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->VertexAttrib2f(arg0, arg1, arg2))>, "Should be returning void here");
  MOZ_KnownLive(self)->VertexAttrib2f(arg0, arg1, arg2);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo vertexAttrib2f_methodinfo = {
  { (JSJitGetterOp)vertexAttrib2f },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
vertexAttrib2fv(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.vertexAttrib2fv");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "vertexAttrib2fv", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.vertexAttrib2fv", 2)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  MaybeSharedFloat32ArrayOrUnrestrictedFloatSequence arg1;
  if (!arg1.Init(cx, args[1], "Argument 2", false)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->VertexAttrib2fv(arg0, Constify(arg1)))>, "Should be returning void here");
  MOZ_KnownLive(self)->VertexAttrib2fv(arg0, Constify(arg1));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo vertexAttrib2fv_methodinfo = {
  { (JSJitGetterOp)vertexAttrib2fv },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
vertexAttrib3f(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "vertexAttrib3f", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.vertexAttrib3f", 4)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  float arg1;
  if (!ValueToPrimitive<float, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  float arg2;
  if (!ValueToPrimitive<float, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  }
  float arg3;
  if (!ValueToPrimitive<float, eDefault>(cx, args[3], "Argument 4", &arg3)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->VertexAttrib3f(arg0, arg1, arg2, arg3))>, "Should be returning void here");
  MOZ_KnownLive(self)->VertexAttrib3f(arg0, arg1, arg2, arg3);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo vertexAttrib3f_methodinfo = {
  { (JSJitGetterOp)vertexAttrib3f },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
vertexAttrib3fv(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.vertexAttrib3fv");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "vertexAttrib3fv", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.vertexAttrib3fv", 2)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  MaybeSharedFloat32ArrayOrUnrestrictedFloatSequence arg1;
  if (!arg1.Init(cx, args[1], "Argument 2", false)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->VertexAttrib3fv(arg0, Constify(arg1)))>, "Should be returning void here");
  MOZ_KnownLive(self)->VertexAttrib3fv(arg0, Constify(arg1));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo vertexAttrib3fv_methodinfo = {
  { (JSJitGetterOp)vertexAttrib3fv },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
vertexAttrib4f(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "vertexAttrib4f", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.vertexAttrib4f", 5)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  float arg1;
  if (!ValueToPrimitive<float, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  float arg2;
  if (!ValueToPrimitive<float, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  }
  float arg3;
  if (!ValueToPrimitive<float, eDefault>(cx, args[3], "Argument 4", &arg3)) {
    return false;
  }
  float arg4;
  if (!ValueToPrimitive<float, eDefault>(cx, args[4], "Argument 5", &arg4)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->VertexAttrib4f(arg0, arg1, arg2, arg3, arg4))>, "Should be returning void here");
  MOZ_KnownLive(self)->VertexAttrib4f(arg0, arg1, arg2, arg3, arg4);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo vertexAttrib4f_methodinfo = {
  { (JSJitGetterOp)vertexAttrib4f },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
vertexAttrib4fv(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "WebGL2RenderingContext.vertexAttrib4fv");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "vertexAttrib4fv", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.vertexAttrib4fv", 2)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  MaybeSharedFloat32ArrayOrUnrestrictedFloatSequence arg1;
  if (!arg1.Init(cx, args[1], "Argument 2", false)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->VertexAttrib4fv(arg0, Constify(arg1)))>, "Should be returning void here");
  MOZ_KnownLive(self)->VertexAttrib4fv(arg0, Constify(arg1));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo vertexAttrib4fv_methodinfo = {
  { (JSJitGetterOp)vertexAttrib4fv },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
vertexAttribPointer(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "vertexAttribPointer", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.vertexAttribPointer", 6)) {
    return false;
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  int32_t arg1;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  uint32_t arg2;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  }
  bool arg3;
  if (!ValueToPrimitive<bool, eDefault>(cx, args[3], "Argument 4", &arg3)) {
    return false;
  }
  int32_t arg4;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[4], "Argument 5", &arg4)) {
    return false;
  }
  int64_t arg5;
  if (!ValueToPrimitive<int64_t, eDefault>(cx, args[5], "Argument 6", &arg5)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->VertexAttribPointer(arg0, arg1, arg2, arg3, arg4, arg5))>, "Should be returning void here");
  MOZ_KnownLive(self)->VertexAttribPointer(arg0, arg1, arg2, arg3, arg4, arg5);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo vertexAttribPointer_methodinfo = {
  { (JSJitGetterOp)vertexAttribPointer },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
viewport(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "viewport", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  if (!args.requireAtLeast(cx, "WebGL2RenderingContext.viewport", 4)) {
    return false;
  }
  int32_t arg0;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  int32_t arg1;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  int32_t arg2;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  }
  int32_t arg3;
  if (!ValueToPrimitive<int32_t, eDefault>(cx, args[3], "Argument 4", &arg3)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Viewport(arg0, arg1, arg2, arg3))>, "Should be returning void here");
  MOZ_KnownLive(self)->Viewport(arg0, arg1, arg2, arg3);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo viewport_methodinfo = {
  { (JSJitGetterOp)viewport },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
makeXRCompatible(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "WebGL2RenderingContext", "makeXRCompatible", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::ClientWebGLContext*>(void_self);
  FastErrorResult rv;
  auto result(StrongOrRawPtr<Promise>(MOZ_KnownLive(self)->MakeXRCompatible(rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "WebGL2RenderingContext.makeXRCompatible"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!ToJSValue(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
makeXRCompatible_promiseWrapper(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  bool ok = makeXRCompatible(cx, obj, void_self, args);
  if (ok) {
    return true;
  }
  return ConvertExceptionToPromise(cx, args.rval());
}

static const JSJitInfo makeXRCompatible_methodinfo = {
  { (JSJitGetterOp)makeXRCompatible_promiseWrapper },
  { prototypes::id::WebGL2RenderingContext },
  { PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

static void
_finalize(JS::GCContext* gcx, JSObject* obj)
{
  mozilla::ClientWebGLContext* self = UnwrapPossiblyNotInitializedDOMObject<mozilla::ClientWebGLContext>(obj);
  if (self) {
    JS::SetReservedSlot(obj, DOM_OBJECT_SLOT, JS::UndefinedValue());
    ClearWrapper(self, self, obj);
    if (size_t mallocBytes = BindingJSObjectMallocBytes(self)) {
      JS::RemoveAssociatedMemory(obj, mallocBytes,
                                 JS::MemoryUse::DOMBinding);
    }
    AddForDeferredFinalization<mozilla::ClientWebGLContext>(self);
  }
}

MOZ_GLOBINIT static const JSFunctionSpec sMethods_specs[] = {
  JS_FNSPEC("bufferData", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&bufferData_methodinfo), 3, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("bufferSubData", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&bufferSubData_methodinfo), 3, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("copyBufferSubData", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&copyBufferSubData_methodinfo), 5, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getBufferSubData", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getBufferSubData_methodinfo), 3, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("blitFramebuffer", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&blitFramebuffer_methodinfo), 10, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("framebufferTextureLayer", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&framebufferTextureLayer_methodinfo), 5, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("invalidateFramebuffer", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&invalidateFramebuffer_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("invalidateSubFramebuffer", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&invalidateSubFramebuffer_methodinfo), 6, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("readBuffer", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&readBuffer_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getInternalformatParameter", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getInternalformatParameter_methodinfo), 3, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("renderbufferStorageMultisample", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&renderbufferStorageMultisample_methodinfo), 5, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("texStorage2D", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&texStorage2D_methodinfo), 5, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("texStorage3D", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&texStorage3D_methodinfo), 6, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("texImage2D", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&texImage2D_methodinfo), 6, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("texSubImage2D", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&texSubImage2D_methodinfo), 7, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("texImage3D", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&texImage3D_methodinfo), 10, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("texSubImage3D", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&texSubImage3D_methodinfo), 11, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("copyTexSubImage3D", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&copyTexSubImage3D_methodinfo), 9, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("compressedTexImage2D", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&compressedTexImage2D_methodinfo), 7, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("compressedTexImage3D", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&compressedTexImage3D_methodinfo), 8, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("compressedTexSubImage2D", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&compressedTexSubImage2D_methodinfo), 8, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("compressedTexSubImage3D", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&compressedTexSubImage3D_methodinfo), 10, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getFragDataLocation", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getFragDataLocation_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("uniform1ui", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&uniform1ui_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("uniform2ui", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&uniform2ui_methodinfo), 3, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("uniform3ui", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&uniform3ui_methodinfo), 4, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("uniform4ui", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&uniform4ui_methodinfo), 5, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("uniform1fv", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&uniform1fv_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("uniform2fv", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&uniform2fv_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("uniform3fv", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&uniform3fv_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("uniform4fv", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&uniform4fv_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("uniform1iv", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&uniform1iv_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("uniform2iv", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&uniform2iv_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("uniform3iv", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&uniform3iv_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("uniform4iv", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&uniform4iv_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("uniform1uiv", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&uniform1uiv_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("uniform2uiv", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&uniform2uiv_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("uniform3uiv", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&uniform3uiv_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("uniform4uiv", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&uniform4uiv_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("uniformMatrix2fv", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&uniformMatrix2fv_methodinfo), 3, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("uniformMatrix3x2fv", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&uniformMatrix3x2fv_methodinfo), 3, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("uniformMatrix4x2fv", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&uniformMatrix4x2fv_methodinfo), 3, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("uniformMatrix2x3fv", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&uniformMatrix2x3fv_methodinfo), 3, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("uniformMatrix3fv", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&uniformMatrix3fv_methodinfo), 3, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("uniformMatrix4x3fv", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&uniformMatrix4x3fv_methodinfo), 3, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("uniformMatrix2x4fv", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&uniformMatrix2x4fv_methodinfo), 3, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("uniformMatrix3x4fv", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&uniformMatrix3x4fv_methodinfo), 3, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("uniformMatrix4fv", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&uniformMatrix4fv_methodinfo), 3, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("vertexAttribI4i", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&vertexAttribI4i_methodinfo), 5, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("vertexAttribI4iv", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&vertexAttribI4iv_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("vertexAttribI4ui", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&vertexAttribI4ui_methodinfo), 5, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("vertexAttribI4uiv", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&vertexAttribI4uiv_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("vertexAttribIPointer", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&vertexAttribIPointer_methodinfo), 5, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("vertexAttribDivisor", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&vertexAttribDivisor_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("drawArraysInstanced", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&drawArraysInstanced_methodinfo), 4, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("drawElementsInstanced", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&drawElementsInstanced_methodinfo), 5, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("drawRangeElements", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&drawRangeElements_methodinfo), 6, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("readPixels", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&readPixels_methodinfo), 7, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("drawBuffers", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&drawBuffers_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("clearBufferfv", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&clearBufferfv_methodinfo), 3, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("clearBufferiv", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&clearBufferiv_methodinfo), 3, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("clearBufferuiv", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&clearBufferuiv_methodinfo), 3, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("clearBufferfi", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&clearBufferfi_methodinfo), 4, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("createQuery", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&createQuery_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("deleteQuery", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&deleteQuery_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("isQuery", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&isQuery_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("beginQuery", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&beginQuery_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("endQuery", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&endQuery_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getQuery", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getQuery_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getQueryParameter", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getQueryParameter_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("createSampler", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&createSampler_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("deleteSampler", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&deleteSampler_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("isSampler", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&isSampler_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("bindSampler", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&bindSampler_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("samplerParameteri", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&samplerParameteri_methodinfo), 3, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("samplerParameterf", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&samplerParameterf_methodinfo), 3, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getSamplerParameter", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getSamplerParameter_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("fenceSync", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&fenceSync_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("isSync", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&isSync_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("deleteSync", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&deleteSync_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("clientWaitSync", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&clientWaitSync_methodinfo), 3, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("waitSync", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&waitSync_methodinfo), 3, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getSyncParameter", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getSyncParameter_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("createTransformFeedback", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&createTransformFeedback_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("deleteTransformFeedback", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&deleteTransformFeedback_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("isTransformFeedback", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&isTransformFeedback_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("bindTransformFeedback", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&bindTransformFeedback_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("beginTransformFeedback", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&beginTransformFeedback_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("endTransformFeedback", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&endTransformFeedback_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("transformFeedbackVaryings", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&transformFeedbackVaryings_methodinfo), 3, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getTransformFeedbackVarying", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getTransformFeedbackVarying_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("pauseTransformFeedback", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&pauseTransformFeedback_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("resumeTransformFeedback", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&resumeTransformFeedback_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("bindBufferBase", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&bindBufferBase_methodinfo), 3, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("bindBufferRange", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&bindBufferRange_methodinfo), 5, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getIndexedParameter", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getIndexedParameter_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getUniformIndices", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getUniformIndices_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getActiveUniforms", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getActiveUniforms_methodinfo), 3, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getUniformBlockIndex", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getUniformBlockIndex_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getActiveUniformBlockParameter", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getActiveUniformBlockParameter_methodinfo), 3, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getActiveUniformBlockName", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getActiveUniformBlockName_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("uniformBlockBinding", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&uniformBlockBinding_methodinfo), 3, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("createVertexArray", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&createVertexArray_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("deleteVertexArray", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&deleteVertexArray_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("isVertexArray", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&isVertexArray_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("bindVertexArray", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&bindVertexArray_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getContextAttributes", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getContextAttributes_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("isContextLost", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&isContextLost_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getSupportedExtensions", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getSupportedExtensions_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getExtension", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getExtension_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("activeTexture", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&activeTexture_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("attachShader", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&attachShader_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("bindAttribLocation", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&bindAttribLocation_methodinfo), 3, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("bindBuffer", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&bindBuffer_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("bindFramebuffer", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&bindFramebuffer_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("bindRenderbuffer", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&bindRenderbuffer_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("bindTexture", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&bindTexture_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("blendColor", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&blendColor_methodinfo), 4, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("blendEquation", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&blendEquation_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("blendEquationSeparate", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&blendEquationSeparate_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("blendFunc", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&blendFunc_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("blendFuncSeparate", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&blendFuncSeparate_methodinfo), 4, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("checkFramebufferStatus", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&checkFramebufferStatus_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("clear", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&clear_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("clearColor", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&clearColor_methodinfo), 4, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("clearDepth", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&clearDepth_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("clearStencil", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&clearStencil_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("colorMask", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&colorMask_methodinfo), 4, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("compileShader", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&compileShader_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("copyTexImage2D", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&copyTexImage2D_methodinfo), 8, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("copyTexSubImage2D", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&copyTexSubImage2D_methodinfo), 8, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("createBuffer", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&createBuffer_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("createFramebuffer", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&createFramebuffer_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("createProgram", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&createProgram_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("createRenderbuffer", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&createRenderbuffer_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("createShader", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&createShader_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("createTexture", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&createTexture_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("cullFace", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&cullFace_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("deleteBuffer", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&deleteBuffer_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("deleteFramebuffer", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&deleteFramebuffer_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("deleteProgram", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&deleteProgram_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("deleteRenderbuffer", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&deleteRenderbuffer_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("deleteShader", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&deleteShader_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("deleteTexture", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&deleteTexture_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("depthFunc", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&depthFunc_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("depthMask", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&depthMask_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("depthRange", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&depthRange_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("detachShader", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&detachShader_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("disable", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&disable_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("disableVertexAttribArray", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&disableVertexAttribArray_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("drawArrays", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&drawArrays_methodinfo), 3, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("drawElements", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&drawElements_methodinfo), 4, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("enable", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&enable_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("enableVertexAttribArray", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&enableVertexAttribArray_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("finish", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&finish_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("flush", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&flush_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("framebufferRenderbuffer", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&framebufferRenderbuffer_methodinfo), 4, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("framebufferTexture2D", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&framebufferTexture2D_methodinfo), 5, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("frontFace", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&frontFace_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("generateMipmap", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&generateMipmap_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getActiveAttrib", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getActiveAttrib_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getActiveUniform", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getActiveUniform_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getAttachedShaders", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getAttachedShaders_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getAttribLocation", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getAttribLocation_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getBufferParameter", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getBufferParameter_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getParameter", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getParameter_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getError", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getError_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getFramebufferAttachmentParameter", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getFramebufferAttachmentParameter_methodinfo), 3, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getProgramParameter", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getProgramParameter_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getProgramInfoLog", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getProgramInfoLog_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getRenderbufferParameter", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getRenderbufferParameter_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getShaderParameter", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getShaderParameter_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getShaderPrecisionFormat", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getShaderPrecisionFormat_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getShaderInfoLog", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getShaderInfoLog_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getShaderSource", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getShaderSource_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getTexParameter", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getTexParameter_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getUniform", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getUniform_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getUniformLocation", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getUniformLocation_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getVertexAttrib", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getVertexAttrib_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getVertexAttribOffset", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getVertexAttribOffset_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("hint", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&hint_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("isBuffer", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&isBuffer_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("isEnabled", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&isEnabled_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("isFramebuffer", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&isFramebuffer_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("isProgram", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&isProgram_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("isRenderbuffer", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&isRenderbuffer_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("isShader", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&isShader_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("isTexture", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&isTexture_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("lineWidth", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&lineWidth_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("linkProgram", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&linkProgram_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("pixelStorei", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&pixelStorei_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("polygonOffset", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&polygonOffset_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("renderbufferStorage", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&renderbufferStorage_methodinfo), 4, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("sampleCoverage", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&sampleCoverage_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("scissor", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&scissor_methodinfo), 4, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("shaderSource", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&shaderSource_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("stencilFunc", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&stencilFunc_methodinfo), 3, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("stencilFuncSeparate", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&stencilFuncSeparate_methodinfo), 4, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("stencilMask", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&stencilMask_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("stencilMaskSeparate", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&stencilMaskSeparate_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("stencilOp", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&stencilOp_methodinfo), 3, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("stencilOpSeparate", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&stencilOpSeparate_methodinfo), 4, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("texParameterf", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&texParameterf_methodinfo), 3, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("texParameteri", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&texParameteri_methodinfo), 3, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("uniform1f", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&uniform1f_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("uniform2f", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&uniform2f_methodinfo), 3, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("uniform3f", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&uniform3f_methodinfo), 4, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("uniform4f", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&uniform4f_methodinfo), 5, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("uniform1i", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&uniform1i_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("uniform2i", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&uniform2i_methodinfo), 3, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("uniform3i", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&uniform3i_methodinfo), 4, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("uniform4i", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&uniform4i_methodinfo), 5, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("useProgram", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&useProgram_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("validateProgram", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&validateProgram_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("vertexAttrib1f", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&vertexAttrib1f_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("vertexAttrib1fv", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&vertexAttrib1fv_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("vertexAttrib2f", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&vertexAttrib2f_methodinfo), 3, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("vertexAttrib2fv", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&vertexAttrib2fv_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("vertexAttrib3f", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&vertexAttrib3f_methodinfo), 4, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("vertexAttrib3fv", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&vertexAttrib3fv_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("vertexAttrib4f", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&vertexAttrib4f_methodinfo), 5, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("vertexAttrib4fv", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&vertexAttrib4fv_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("vertexAttribPointer", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&vertexAttribPointer_methodinfo), 6, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("viewport", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&viewport_methodinfo), 4, JSPROP_ENUMERATE, nullptr),
  JS_FS_END,
  JS_FNSPEC("makeXRCompatible", (GenericMethod<NormalThisPolicy, ConvertExceptionsToPromises>), reinterpret_cast<const JSJitInfo*>(&makeXRCompatible_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FS_END
};

static const PrefableDisablers sMethods_disablers225 = {
  WebIDLPrefIndex::dom_vr_webxr_enabled, 0, false, OriginTrial(0), nullptr
};

static const Prefable<const JSFunctionSpec> sMethods[] = {
  { nullptr, &sMethods_specs[0] },
  { &sMethods_disablers225, &sMethods_specs[225] },
  { nullptr, nullptr }
};

static_assert(2 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(224 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");

MOZ_GLOBINIT static const JSPropertySpec sAttributes_specs[] = {
  JSPropertySpec::nativeAccessors("canvas", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &canvas_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("drawingBufferWidth", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &drawingBufferWidth_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("drawingBufferHeight", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &drawingBufferHeight_getterinfo, nullptr, nullptr),
  JS_PS_END,
  JSPropertySpec::nativeAccessors("drawingBufferColorSpace", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &drawingBufferColorSpace_getterinfo, GenericSetter<NormalThisPolicy>, &drawingBufferColorSpace_setterinfo),
  JS_PS_END,
  JSPropertySpec::nativeAccessors("unpackColorSpace", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &unpackColorSpace_getterinfo, GenericSetter<NormalThisPolicy>, &unpackColorSpace_setterinfo),
  JS_PS_END
};

static const PrefableDisablers sAttributes_disablers4 = {
  WebIDLPrefIndex::webgl_drawing_buffer_color_space, 0, false, OriginTrial(0), nullptr
};

static const Prefable<const JSPropertySpec> sAttributes[] = {
  { nullptr, &sAttributes_specs[0] },
  { &sAttributes_disablers4, &sAttributes_specs[4] },
  { nullptr, &sAttributes_specs[6] },
  { nullptr, nullptr }
};

static_assert(3 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(3 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");

MOZ_GLOBINIT static const ConstantSpec sConstants_specs[] = {
  { "READ_BUFFER", JS::NumberValue(3074U) },
  { "UNPACK_ROW_LENGTH", JS::NumberValue(3314U) },
  { "UNPACK_SKIP_ROWS", JS::NumberValue(3315U) },
  { "UNPACK_SKIP_PIXELS", JS::NumberValue(3316U) },
  { "PACK_ROW_LENGTH", JS::NumberValue(3330U) },
  { "PACK_SKIP_ROWS", JS::NumberValue(3331U) },
  { "PACK_SKIP_PIXELS", JS::NumberValue(3332U) },
  { "COLOR", JS::NumberValue(6144U) },
  { "DEPTH", JS::NumberValue(6145U) },
  { "STENCIL", JS::NumberValue(6146U) },
  { "RED", JS::NumberValue(6403U) },
  { "RGB8", JS::NumberValue(32849U) },
  { "RGBA8", JS::NumberValue(32856U) },
  { "RGB10_A2", JS::NumberValue(32857U) },
  { "TEXTURE_BINDING_3D", JS::NumberValue(32874U) },
  { "UNPACK_SKIP_IMAGES", JS::NumberValue(32877U) },
  { "UNPACK_IMAGE_HEIGHT", JS::NumberValue(32878U) },
  { "TEXTURE_3D", JS::NumberValue(32879U) },
  { "TEXTURE_WRAP_R", JS::NumberValue(32882U) },
  { "MAX_3D_TEXTURE_SIZE", JS::NumberValue(32883U) },
  { "UNSIGNED_INT_2_10_10_10_REV", JS::NumberValue(33640U) },
  { "MAX_ELEMENTS_VERTICES", JS::NumberValue(33000U) },
  { "MAX_ELEMENTS_INDICES", JS::NumberValue(33001U) },
  { "TEXTURE_MIN_LOD", JS::NumberValue(33082U) },
  { "TEXTURE_MAX_LOD", JS::NumberValue(33083U) },
  { "TEXTURE_BASE_LEVEL", JS::NumberValue(33084U) },
  { "TEXTURE_MAX_LEVEL", JS::NumberValue(33085U) },
  { "MIN", JS::NumberValue(32775U) },
  { "MAX", JS::NumberValue(32776U) },
  { "DEPTH_COMPONENT24", JS::NumberValue(33190U) },
  { "MAX_TEXTURE_LOD_BIAS", JS::NumberValue(34045U) },
  { "TEXTURE_COMPARE_MODE", JS::NumberValue(34892U) },
  { "TEXTURE_COMPARE_FUNC", JS::NumberValue(34893U) },
  { "CURRENT_QUERY", JS::NumberValue(34917U) },
  { "QUERY_RESULT", JS::NumberValue(34918U) },
  { "QUERY_RESULT_AVAILABLE", JS::NumberValue(34919U) },
  { "STREAM_READ", JS::NumberValue(35041U) },
  { "STREAM_COPY", JS::NumberValue(35042U) },
  { "STATIC_READ", JS::NumberValue(35045U) },
  { "STATIC_COPY", JS::NumberValue(35046U) },
  { "DYNAMIC_READ", JS::NumberValue(35049U) },
  { "DYNAMIC_COPY", JS::NumberValue(35050U) },
  { "MAX_DRAW_BUFFERS", JS::NumberValue(34852U) },
  { "DRAW_BUFFER0", JS::NumberValue(34853U) },
  { "DRAW_BUFFER1", JS::NumberValue(34854U) },
  { "DRAW_BUFFER2", JS::NumberValue(34855U) },
  { "DRAW_BUFFER3", JS::NumberValue(34856U) },
  { "DRAW_BUFFER4", JS::NumberValue(34857U) },
  { "DRAW_BUFFER5", JS::NumberValue(34858U) },
  { "DRAW_BUFFER6", JS::NumberValue(34859U) },
  { "DRAW_BUFFER7", JS::NumberValue(34860U) },
  { "DRAW_BUFFER8", JS::NumberValue(34861U) },
  { "DRAW_BUFFER9", JS::NumberValue(34862U) },
  { "DRAW_BUFFER10", JS::NumberValue(34863U) },
  { "DRAW_BUFFER11", JS::NumberValue(34864U) },
  { "DRAW_BUFFER12", JS::NumberValue(34865U) },
  { "DRAW_BUFFER13", JS::NumberValue(34866U) },
  { "DRAW_BUFFER14", JS::NumberValue(34867U) },
  { "DRAW_BUFFER15", JS::NumberValue(34868U) },
  { "MAX_FRAGMENT_UNIFORM_COMPONENTS", JS::NumberValue(35657U) },
  { "MAX_VERTEX_UNIFORM_COMPONENTS", JS::NumberValue(35658U) },
  { "SAMPLER_3D", JS::NumberValue(35679U) },
  { "SAMPLER_2D_SHADOW", JS::NumberValue(35682U) },
  { "FRAGMENT_SHADER_DERIVATIVE_HINT", JS::NumberValue(35723U) },
  { "PIXEL_PACK_BUFFER", JS::NumberValue(35051U) },
  { "PIXEL_UNPACK_BUFFER", JS::NumberValue(35052U) },
  { "PIXEL_PACK_BUFFER_BINDING", JS::NumberValue(35053U) },
  { "PIXEL_UNPACK_BUFFER_BINDING", JS::NumberValue(35055U) },
  { "FLOAT_MAT2x3", JS::NumberValue(35685U) },
  { "FLOAT_MAT2x4", JS::NumberValue(35686U) },
  { "FLOAT_MAT3x2", JS::NumberValue(35687U) },
  { "FLOAT_MAT3x4", JS::NumberValue(35688U) },
  { "FLOAT_MAT4x2", JS::NumberValue(35689U) },
  { "FLOAT_MAT4x3", JS::NumberValue(35690U) },
  { "SRGB", JS::NumberValue(35904U) },
  { "SRGB8", JS::NumberValue(35905U) },
  { "SRGB8_ALPHA8", JS::NumberValue(35907U) },
  { "COMPARE_REF_TO_TEXTURE", JS::NumberValue(34894U) },
  { "RGBA32F", JS::NumberValue(34836U) },
  { "RGB32F", JS::NumberValue(34837U) },
  { "RGBA16F", JS::NumberValue(34842U) },
  { "RGB16F", JS::NumberValue(34843U) },
  { "VERTEX_ATTRIB_ARRAY_INTEGER", JS::NumberValue(35069U) },
  { "MAX_ARRAY_TEXTURE_LAYERS", JS::NumberValue(35071U) },
  { "MIN_PROGRAM_TEXEL_OFFSET", JS::NumberValue(35076U) },
  { "MAX_PROGRAM_TEXEL_OFFSET", JS::NumberValue(35077U) },
  { "MAX_VARYING_COMPONENTS", JS::NumberValue(35659U) },
  { "TEXTURE_2D_ARRAY", JS::NumberValue(35866U) },
  { "TEXTURE_BINDING_2D_ARRAY", JS::NumberValue(35869U) },
  { "R11F_G11F_B10F", JS::NumberValue(35898U) },
  { "UNSIGNED_INT_10F_11F_11F_REV", JS::NumberValue(35899U) },
  { "RGB9_E5", JS::NumberValue(35901U) },
  { "UNSIGNED_INT_5_9_9_9_REV", JS::NumberValue(35902U) },
  { "TRANSFORM_FEEDBACK_BUFFER_MODE", JS::NumberValue(35967U) },
  { "MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS", JS::NumberValue(35968U) },
  { "TRANSFORM_FEEDBACK_VARYINGS", JS::NumberValue(35971U) },
  { "TRANSFORM_FEEDBACK_BUFFER_START", JS::NumberValue(35972U) },
  { "TRANSFORM_FEEDBACK_BUFFER_SIZE", JS::NumberValue(35973U) },
  { "TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN", JS::NumberValue(35976U) },
  { "RASTERIZER_DISCARD", JS::NumberValue(35977U) },
  { "MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS", JS::NumberValue(35978U) },
  { "MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS", JS::NumberValue(35979U) },
  { "INTERLEAVED_ATTRIBS", JS::NumberValue(35980U) },
  { "SEPARATE_ATTRIBS", JS::NumberValue(35981U) },
  { "TRANSFORM_FEEDBACK_BUFFER", JS::NumberValue(35982U) },
  { "TRANSFORM_FEEDBACK_BUFFER_BINDING", JS::NumberValue(35983U) },
  { "RGBA32UI", JS::NumberValue(36208U) },
  { "RGB32UI", JS::NumberValue(36209U) },
  { "RGBA16UI", JS::NumberValue(36214U) },
  { "RGB16UI", JS::NumberValue(36215U) },
  { "RGBA8UI", JS::NumberValue(36220U) },
  { "RGB8UI", JS::NumberValue(36221U) },
  { "RGBA32I", JS::NumberValue(36226U) },
  { "RGB32I", JS::NumberValue(36227U) },
  { "RGBA16I", JS::NumberValue(36232U) },
  { "RGB16I", JS::NumberValue(36233U) },
  { "RGBA8I", JS::NumberValue(36238U) },
  { "RGB8I", JS::NumberValue(36239U) },
  { "RED_INTEGER", JS::NumberValue(36244U) },
  { "RGB_INTEGER", JS::NumberValue(36248U) },
  { "RGBA_INTEGER", JS::NumberValue(36249U) },
  { "SAMPLER_2D_ARRAY", JS::NumberValue(36289U) },
  { "SAMPLER_2D_ARRAY_SHADOW", JS::NumberValue(36292U) },
  { "SAMPLER_CUBE_SHADOW", JS::NumberValue(36293U) },
  { "UNSIGNED_INT_VEC2", JS::NumberValue(36294U) },
  { "UNSIGNED_INT_VEC3", JS::NumberValue(36295U) },
  { "UNSIGNED_INT_VEC4", JS::NumberValue(36296U) },
  { "INT_SAMPLER_2D", JS::NumberValue(36298U) },
  { "INT_SAMPLER_3D", JS::NumberValue(36299U) },
  { "INT_SAMPLER_CUBE", JS::NumberValue(36300U) },
  { "INT_SAMPLER_2D_ARRAY", JS::NumberValue(36303U) },
  { "UNSIGNED_INT_SAMPLER_2D", JS::NumberValue(36306U) },
  { "UNSIGNED_INT_SAMPLER_3D", JS::NumberValue(36307U) },
  { "UNSIGNED_INT_SAMPLER_CUBE", JS::NumberValue(36308U) },
  { "UNSIGNED_INT_SAMPLER_2D_ARRAY", JS::NumberValue(36311U) },
  { "DEPTH_COMPONENT32F", JS::NumberValue(36012U) },
  { "DEPTH32F_STENCIL8", JS::NumberValue(36013U) },
  { "FLOAT_32_UNSIGNED_INT_24_8_REV", JS::NumberValue(36269U) },
  { "FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING", JS::NumberValue(33296U) },
  { "FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE", JS::NumberValue(33297U) },
  { "FRAMEBUFFER_ATTACHMENT_RED_SIZE", JS::NumberValue(33298U) },
  { "FRAMEBUFFER_ATTACHMENT_GREEN_SIZE", JS::NumberValue(33299U) },
  { "FRAMEBUFFER_ATTACHMENT_BLUE_SIZE", JS::NumberValue(33300U) },
  { "FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE", JS::NumberValue(33301U) },
  { "FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE", JS::NumberValue(33302U) },
  { "FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE", JS::NumberValue(33303U) },
  { "FRAMEBUFFER_DEFAULT", JS::NumberValue(33304U) },
  { "UNSIGNED_INT_24_8", JS::NumberValue(34042U) },
  { "DEPTH24_STENCIL8", JS::NumberValue(35056U) },
  { "UNSIGNED_NORMALIZED", JS::NumberValue(35863U) },
  { "DRAW_FRAMEBUFFER_BINDING", JS::NumberValue(36006U) },
  { "READ_FRAMEBUFFER", JS::NumberValue(36008U) },
  { "DRAW_FRAMEBUFFER", JS::NumberValue(36009U) },
  { "READ_FRAMEBUFFER_BINDING", JS::NumberValue(36010U) },
  { "RENDERBUFFER_SAMPLES", JS::NumberValue(36011U) },
  { "FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER", JS::NumberValue(36052U) },
  { "MAX_COLOR_ATTACHMENTS", JS::NumberValue(36063U) },
  { "COLOR_ATTACHMENT1", JS::NumberValue(36065U) },
  { "COLOR_ATTACHMENT2", JS::NumberValue(36066U) },
  { "COLOR_ATTACHMENT3", JS::NumberValue(36067U) },
  { "COLOR_ATTACHMENT4", JS::NumberValue(36068U) },
  { "COLOR_ATTACHMENT5", JS::NumberValue(36069U) },
  { "COLOR_ATTACHMENT6", JS::NumberValue(36070U) },
  { "COLOR_ATTACHMENT7", JS::NumberValue(36071U) },
  { "COLOR_ATTACHMENT8", JS::NumberValue(36072U) },
  { "COLOR_ATTACHMENT9", JS::NumberValue(36073U) },
  { "COLOR_ATTACHMENT10", JS::NumberValue(36074U) },
  { "COLOR_ATTACHMENT11", JS::NumberValue(36075U) },
  { "COLOR_ATTACHMENT12", JS::NumberValue(36076U) },
  { "COLOR_ATTACHMENT13", JS::NumberValue(36077U) },
  { "COLOR_ATTACHMENT14", JS::NumberValue(36078U) },
  { "COLOR_ATTACHMENT15", JS::NumberValue(36079U) },
  { "FRAMEBUFFER_INCOMPLETE_MULTISAMPLE", JS::NumberValue(36182U) },
  { "MAX_SAMPLES", JS::NumberValue(36183U) },
  { "HALF_FLOAT", JS::NumberValue(5131U) },
  { "RG", JS::NumberValue(33319U) },
  { "RG_INTEGER", JS::NumberValue(33320U) },
  { "R8", JS::NumberValue(33321U) },
  { "RG8", JS::NumberValue(33323U) },
  { "R16F", JS::NumberValue(33325U) },
  { "R32F", JS::NumberValue(33326U) },
  { "RG16F", JS::NumberValue(33327U) },
  { "RG32F", JS::NumberValue(33328U) },
  { "R8I", JS::NumberValue(33329U) },
  { "R8UI", JS::NumberValue(33330U) },
  { "R16I", JS::NumberValue(33331U) },
  { "R16UI", JS::NumberValue(33332U) },
  { "R32I", JS::NumberValue(33333U) },
  { "R32UI", JS::NumberValue(33334U) },
  { "RG8I", JS::NumberValue(33335U) },
  { "RG8UI", JS::NumberValue(33336U) },
  { "RG16I", JS::NumberValue(33337U) },
  { "RG16UI", JS::NumberValue(33338U) },
  { "RG32I", JS::NumberValue(33339U) },
  { "RG32UI", JS::NumberValue(33340U) },
  { "VERTEX_ARRAY_BINDING", JS::NumberValue(34229U) },
  { "R8_SNORM", JS::NumberValue(36756U) },
  { "RG8_SNORM", JS::NumberValue(36757U) },
  { "RGB8_SNORM", JS::NumberValue(36758U) },
  { "RGBA8_SNORM", JS::NumberValue(36759U) },
  { "SIGNED_NORMALIZED", JS::NumberValue(36764U) },
  { "COPY_READ_BUFFER", JS::NumberValue(36662U) },
  { "COPY_WRITE_BUFFER", JS::NumberValue(36663U) },
  { "COPY_READ_BUFFER_BINDING", JS::NumberValue(36662U) },
  { "COPY_WRITE_BUFFER_BINDING", JS::NumberValue(36663U) },
  { "UNIFORM_BUFFER", JS::NumberValue(35345U) },
  { "UNIFORM_BUFFER_BINDING", JS::NumberValue(35368U) },
  { "UNIFORM_BUFFER_START", JS::NumberValue(35369U) },
  { "UNIFORM_BUFFER_SIZE", JS::NumberValue(35370U) },
  { "MAX_VERTEX_UNIFORM_BLOCKS", JS::NumberValue(35371U) },
  { "MAX_FRAGMENT_UNIFORM_BLOCKS", JS::NumberValue(35373U) },
  { "MAX_COMBINED_UNIFORM_BLOCKS", JS::NumberValue(35374U) },
  { "MAX_UNIFORM_BUFFER_BINDINGS", JS::NumberValue(35375U) },
  { "MAX_UNIFORM_BLOCK_SIZE", JS::NumberValue(35376U) },
  { "MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS", JS::NumberValue(35377U) },
  { "MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS", JS::NumberValue(35379U) },
  { "UNIFORM_BUFFER_OFFSET_ALIGNMENT", JS::NumberValue(35380U) },
  { "ACTIVE_UNIFORM_BLOCKS", JS::NumberValue(35382U) },
  { "UNIFORM_TYPE", JS::NumberValue(35383U) },
  { "UNIFORM_SIZE", JS::NumberValue(35384U) },
  { "UNIFORM_BLOCK_INDEX", JS::NumberValue(35386U) },
  { "UNIFORM_OFFSET", JS::NumberValue(35387U) },
  { "UNIFORM_ARRAY_STRIDE", JS::NumberValue(35388U) },
  { "UNIFORM_MATRIX_STRIDE", JS::NumberValue(35389U) },
  { "UNIFORM_IS_ROW_MAJOR", JS::NumberValue(35390U) },
  { "UNIFORM_BLOCK_BINDING", JS::NumberValue(35391U) },
  { "UNIFORM_BLOCK_DATA_SIZE", JS::NumberValue(35392U) },
  { "UNIFORM_BLOCK_ACTIVE_UNIFORMS", JS::NumberValue(35394U) },
  { "UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES", JS::NumberValue(35395U) },
  { "UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER", JS::NumberValue(35396U) },
  { "UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER", JS::NumberValue(35398U) },
  { "INVALID_INDEX", JS::NumberValue(4294967295U) },
  { "MAX_VERTEX_OUTPUT_COMPONENTS", JS::NumberValue(37154U) },
  { "MAX_FRAGMENT_INPUT_COMPONENTS", JS::NumberValue(37157U) },
  { "MAX_SERVER_WAIT_TIMEOUT", JS::NumberValue(37137U) },
  { "OBJECT_TYPE", JS::NumberValue(37138U) },
  { "SYNC_CONDITION", JS::NumberValue(37139U) },
  { "SYNC_STATUS", JS::NumberValue(37140U) },
  { "SYNC_FLAGS", JS::NumberValue(37141U) },
  { "SYNC_FENCE", JS::NumberValue(37142U) },
  { "SYNC_GPU_COMMANDS_COMPLETE", JS::NumberValue(37143U) },
  { "UNSIGNALED", JS::NumberValue(37144U) },
  { "SIGNALED", JS::NumberValue(37145U) },
  { "ALREADY_SIGNALED", JS::NumberValue(37146U) },
  { "TIMEOUT_EXPIRED", JS::NumberValue(37147U) },
  { "CONDITION_SATISFIED", JS::NumberValue(37148U) },
  { "WAIT_FAILED", JS::NumberValue(37149U) },
  { "SYNC_FLUSH_COMMANDS_BIT", JS::NumberValue(1U) },
  { "VERTEX_ATTRIB_ARRAY_DIVISOR", JS::NumberValue(35070U) },
  { "ANY_SAMPLES_PASSED", JS::NumberValue(35887U) },
  { "ANY_SAMPLES_PASSED_CONSERVATIVE", JS::NumberValue(36202U) },
  { "SAMPLER_BINDING", JS::NumberValue(35097U) },
  { "RGB10_A2UI", JS::NumberValue(36975U) },
  { "INT_2_10_10_10_REV", JS::NumberValue(36255U) },
  { "TRANSFORM_FEEDBACK", JS::NumberValue(36386U) },
  { "TRANSFORM_FEEDBACK_PAUSED", JS::NumberValue(36387U) },
  { "TRANSFORM_FEEDBACK_ACTIVE", JS::NumberValue(36388U) },
  { "TRANSFORM_FEEDBACK_BINDING", JS::NumberValue(36389U) },
  { "TEXTURE_IMMUTABLE_FORMAT", JS::NumberValue(37167U) },
  { "MAX_ELEMENT_INDEX", JS::NumberValue(36203U) },
  { "TEXTURE_IMMUTABLE_LEVELS", JS::NumberValue(33503U) },
  { "TIMEOUT_IGNORED", JS::CanonicalizedDoubleValue(-1LL) },
  { "MAX_CLIENT_WAIT_TIMEOUT_WEBGL", JS::NumberValue(37447U) },
  { "DEPTH_BUFFER_BIT", JS::NumberValue(256U) },
  { "STENCIL_BUFFER_BIT", JS::NumberValue(1024U) },
  { "COLOR_BUFFER_BIT", JS::NumberValue(16384U) },
  { "POINTS", JS::NumberValue(0U) },
  { "LINES", JS::NumberValue(1U) },
  { "LINE_LOOP", JS::NumberValue(2U) },
  { "LINE_STRIP", JS::NumberValue(3U) },
  { "TRIANGLES", JS::NumberValue(4U) },
  { "TRIANGLE_STRIP", JS::NumberValue(5U) },
  { "TRIANGLE_FAN", JS::NumberValue(6U) },
  { "ZERO", JS::NumberValue(0U) },
  { "ONE", JS::NumberValue(1U) },
  { "SRC_COLOR", JS::NumberValue(768U) },
  { "ONE_MINUS_SRC_COLOR", JS::NumberValue(769U) },
  { "SRC_ALPHA", JS::NumberValue(770U) },
  { "ONE_MINUS_SRC_ALPHA", JS::NumberValue(771U) },
  { "DST_ALPHA", JS::NumberValue(772U) },
  { "ONE_MINUS_DST_ALPHA", JS::NumberValue(773U) },
  { "DST_COLOR", JS::NumberValue(774U) },
  { "ONE_MINUS_DST_COLOR", JS::NumberValue(775U) },
  { "SRC_ALPHA_SATURATE", JS::NumberValue(776U) },
  { "FUNC_ADD", JS::NumberValue(32774U) },
  { "BLEND_EQUATION", JS::NumberValue(32777U) },
  { "BLEND_EQUATION_RGB", JS::NumberValue(32777U) },
  { "BLEND_EQUATION_ALPHA", JS::NumberValue(34877U) },
  { "FUNC_SUBTRACT", JS::NumberValue(32778U) },
  { "FUNC_REVERSE_SUBTRACT", JS::NumberValue(32779U) },
  { "BLEND_DST_RGB", JS::NumberValue(32968U) },
  { "BLEND_SRC_RGB", JS::NumberValue(32969U) },
  { "BLEND_DST_ALPHA", JS::NumberValue(32970U) },
  { "BLEND_SRC_ALPHA", JS::NumberValue(32971U) },
  { "CONSTANT_COLOR", JS::NumberValue(32769U) },
  { "ONE_MINUS_CONSTANT_COLOR", JS::NumberValue(32770U) },
  { "CONSTANT_ALPHA", JS::NumberValue(32771U) },
  { "ONE_MINUS_CONSTANT_ALPHA", JS::NumberValue(32772U) },
  { "BLEND_COLOR", JS::NumberValue(32773U) },
  { "ARRAY_BUFFER", JS::NumberValue(34962U) },
  { "ELEMENT_ARRAY_BUFFER", JS::NumberValue(34963U) },
  { "ARRAY_BUFFER_BINDING", JS::NumberValue(34964U) },
  { "ELEMENT_ARRAY_BUFFER_BINDING", JS::NumberValue(34965U) },
  { "STREAM_DRAW", JS::NumberValue(35040U) },
  { "STATIC_DRAW", JS::NumberValue(35044U) },
  { "DYNAMIC_DRAW", JS::NumberValue(35048U) },
  { "BUFFER_SIZE", JS::NumberValue(34660U) },
  { "BUFFER_USAGE", JS::NumberValue(34661U) },
  { "CURRENT_VERTEX_ATTRIB", JS::NumberValue(34342U) },
  { "FRONT", JS::NumberValue(1028U) },
  { "BACK", JS::NumberValue(1029U) },
  { "FRONT_AND_BACK", JS::NumberValue(1032U) },
  { "CULL_FACE", JS::NumberValue(2884U) },
  { "BLEND", JS::NumberValue(3042U) },
  { "DITHER", JS::NumberValue(3024U) },
  { "STENCIL_TEST", JS::NumberValue(2960U) },
  { "DEPTH_TEST", JS::NumberValue(2929U) },
  { "SCISSOR_TEST", JS::NumberValue(3089U) },
  { "POLYGON_OFFSET_FILL", JS::NumberValue(32823U) },
  { "SAMPLE_ALPHA_TO_COVERAGE", JS::NumberValue(32926U) },
  { "SAMPLE_COVERAGE", JS::NumberValue(32928U) },
  { "NO_ERROR", JS::NumberValue(0U) },
  { "INVALID_ENUM", JS::NumberValue(1280U) },
  { "INVALID_VALUE", JS::NumberValue(1281U) },
  { "INVALID_OPERATION", JS::NumberValue(1282U) },
  { "OUT_OF_MEMORY", JS::NumberValue(1285U) },
  { "CW", JS::NumberValue(2304U) },
  { "CCW", JS::NumberValue(2305U) },
  { "LINE_WIDTH", JS::NumberValue(2849U) },
  { "ALIASED_POINT_SIZE_RANGE", JS::NumberValue(33901U) },
  { "ALIASED_LINE_WIDTH_RANGE", JS::NumberValue(33902U) },
  { "CULL_FACE_MODE", JS::NumberValue(2885U) },
  { "FRONT_FACE", JS::NumberValue(2886U) },
  { "DEPTH_RANGE", JS::NumberValue(2928U) },
  { "DEPTH_WRITEMASK", JS::NumberValue(2930U) },
  { "DEPTH_CLEAR_VALUE", JS::NumberValue(2931U) },
  { "DEPTH_FUNC", JS::NumberValue(2932U) },
  { "STENCIL_CLEAR_VALUE", JS::NumberValue(2961U) },
  { "STENCIL_FUNC", JS::NumberValue(2962U) },
  { "STENCIL_FAIL", JS::NumberValue(2964U) },
  { "STENCIL_PASS_DEPTH_FAIL", JS::NumberValue(2965U) },
  { "STENCIL_PASS_DEPTH_PASS", JS::NumberValue(2966U) },
  { "STENCIL_REF", JS::NumberValue(2967U) },
  { "STENCIL_VALUE_MASK", JS::NumberValue(2963U) },
  { "STENCIL_WRITEMASK", JS::NumberValue(2968U) },
  { "STENCIL_BACK_FUNC", JS::NumberValue(34816U) },
  { "STENCIL_BACK_FAIL", JS::NumberValue(34817U) },
  { "STENCIL_BACK_PASS_DEPTH_FAIL", JS::NumberValue(34818U) },
  { "STENCIL_BACK_PASS_DEPTH_PASS", JS::NumberValue(34819U) },
  { "STENCIL_BACK_REF", JS::NumberValue(36003U) },
  { "STENCIL_BACK_VALUE_MASK", JS::NumberValue(36004U) },
  { "STENCIL_BACK_WRITEMASK", JS::NumberValue(36005U) },
  { "VIEWPORT", JS::NumberValue(2978U) },
  { "SCISSOR_BOX", JS::NumberValue(3088U) },
  { "COLOR_CLEAR_VALUE", JS::NumberValue(3106U) },
  { "COLOR_WRITEMASK", JS::NumberValue(3107U) },
  { "UNPACK_ALIGNMENT", JS::NumberValue(3317U) },
  { "PACK_ALIGNMENT", JS::NumberValue(3333U) },
  { "MAX_TEXTURE_SIZE", JS::NumberValue(3379U) },
  { "MAX_VIEWPORT_DIMS", JS::NumberValue(3386U) },
  { "SUBPIXEL_BITS", JS::NumberValue(3408U) },
  { "RED_BITS", JS::NumberValue(3410U) },
  { "GREEN_BITS", JS::NumberValue(3411U) },
  { "BLUE_BITS", JS::NumberValue(3412U) },
  { "ALPHA_BITS", JS::NumberValue(3413U) },
  { "DEPTH_BITS", JS::NumberValue(3414U) },
  { "STENCIL_BITS", JS::NumberValue(3415U) },
  { "POLYGON_OFFSET_UNITS", JS::NumberValue(10752U) },
  { "POLYGON_OFFSET_FACTOR", JS::NumberValue(32824U) },
  { "TEXTURE_BINDING_2D", JS::NumberValue(32873U) },
  { "SAMPLE_BUFFERS", JS::NumberValue(32936U) },
  { "SAMPLES", JS::NumberValue(32937U) },
  { "SAMPLE_COVERAGE_VALUE", JS::NumberValue(32938U) },
  { "SAMPLE_COVERAGE_INVERT", JS::NumberValue(32939U) },
  { "COMPRESSED_TEXTURE_FORMATS", JS::NumberValue(34467U) },
  { "DONT_CARE", JS::NumberValue(4352U) },
  { "FASTEST", JS::NumberValue(4353U) },
  { "NICEST", JS::NumberValue(4354U) },
  { "GENERATE_MIPMAP_HINT", JS::NumberValue(33170U) },
  { "BYTE", JS::NumberValue(5120U) },
  { "UNSIGNED_BYTE", JS::NumberValue(5121U) },
  { "SHORT", JS::NumberValue(5122U) },
  { "UNSIGNED_SHORT", JS::NumberValue(5123U) },
  { "INT", JS::NumberValue(5124U) },
  { "UNSIGNED_INT", JS::NumberValue(5125U) },
  { "FLOAT", JS::NumberValue(5126U) },
  { "DEPTH_COMPONENT", JS::NumberValue(6402U) },
  { "ALPHA", JS::NumberValue(6406U) },
  { "RGB", JS::NumberValue(6407U) },
  { "RGBA", JS::NumberValue(6408U) },
  { "LUMINANCE", JS::NumberValue(6409U) },
  { "LUMINANCE_ALPHA", JS::NumberValue(6410U) },
  { "UNSIGNED_SHORT_4_4_4_4", JS::NumberValue(32819U) },
  { "UNSIGNED_SHORT_5_5_5_1", JS::NumberValue(32820U) },
  { "UNSIGNED_SHORT_5_6_5", JS::NumberValue(33635U) },
  { "FRAGMENT_SHADER", JS::NumberValue(35632U) },
  { "VERTEX_SHADER", JS::NumberValue(35633U) },
  { "MAX_VERTEX_ATTRIBS", JS::NumberValue(34921U) },
  { "MAX_VERTEX_UNIFORM_VECTORS", JS::NumberValue(36347U) },
  { "MAX_VARYING_VECTORS", JS::NumberValue(36348U) },
  { "MAX_COMBINED_TEXTURE_IMAGE_UNITS", JS::NumberValue(35661U) },
  { "MAX_VERTEX_TEXTURE_IMAGE_UNITS", JS::NumberValue(35660U) },
  { "MAX_TEXTURE_IMAGE_UNITS", JS::NumberValue(34930U) },
  { "MAX_FRAGMENT_UNIFORM_VECTORS", JS::NumberValue(36349U) },
  { "SHADER_TYPE", JS::NumberValue(35663U) },
  { "DELETE_STATUS", JS::NumberValue(35712U) },
  { "LINK_STATUS", JS::NumberValue(35714U) },
  { "VALIDATE_STATUS", JS::NumberValue(35715U) },
  { "ATTACHED_SHADERS", JS::NumberValue(35717U) },
  { "ACTIVE_UNIFORMS", JS::NumberValue(35718U) },
  { "ACTIVE_ATTRIBUTES", JS::NumberValue(35721U) },
  { "SHADING_LANGUAGE_VERSION", JS::NumberValue(35724U) },
  { "CURRENT_PROGRAM", JS::NumberValue(35725U) },
  { "NEVER", JS::NumberValue(512U) },
  { "LESS", JS::NumberValue(513U) },
  { "EQUAL", JS::NumberValue(514U) },
  { "LEQUAL", JS::NumberValue(515U) },
  { "GREATER", JS::NumberValue(516U) },
  { "NOTEQUAL", JS::NumberValue(517U) },
  { "GEQUAL", JS::NumberValue(518U) },
  { "ALWAYS", JS::NumberValue(519U) },
  { "KEEP", JS::NumberValue(7680U) },
  { "REPLACE", JS::NumberValue(7681U) },
  { "INCR", JS::NumberValue(7682U) },
  { "DECR", JS::NumberValue(7683U) },
  { "INVERT", JS::NumberValue(5386U) },
  { "INCR_WRAP", JS::NumberValue(34055U) },
  { "DECR_WRAP", JS::NumberValue(34056U) },
  { "VENDOR", JS::NumberValue(7936U) },
  { "RENDERER", JS::NumberValue(7937U) },
  { "VERSION", JS::NumberValue(7938U) },
  { "NEAREST", JS::NumberValue(9728U) },
  { "LINEAR", JS::NumberValue(9729U) },
  { "NEAREST_MIPMAP_NEAREST", JS::NumberValue(9984U) },
  { "LINEAR_MIPMAP_NEAREST", JS::NumberValue(9985U) },
  { "NEAREST_MIPMAP_LINEAR", JS::NumberValue(9986U) },
  { "LINEAR_MIPMAP_LINEAR", JS::NumberValue(9987U) },
  { "TEXTURE_MAG_FILTER", JS::NumberValue(10240U) },
  { "TEXTURE_MIN_FILTER", JS::NumberValue(10241U) },
  { "TEXTURE_WRAP_S", JS::NumberValue(10242U) },
  { "TEXTURE_WRAP_T", JS::NumberValue(10243U) },
  { "TEXTURE_2D", JS::NumberValue(3553U) },
  { "TEXTURE", JS::NumberValue(5890U) },
  { "TEXTURE_CUBE_MAP", JS::NumberValue(34067U) },
  { "TEXTURE_BINDING_CUBE_MAP", JS::NumberValue(34068U) },
  { "TEXTURE_CUBE_MAP_POSITIVE_X", JS::NumberValue(34069U) },
  { "TEXTURE_CUBE_MAP_NEGATIVE_X", JS::NumberValue(34070U) },
  { "TEXTURE_CUBE_MAP_POSITIVE_Y", JS::NumberValue(34071U) },
  { "TEXTURE_CUBE_MAP_NEGATIVE_Y", JS::NumberValue(34072U) },
  { "TEXTURE_CUBE_MAP_POSITIVE_Z", JS::NumberValue(34073U) },
  { "TEXTURE_CUBE_MAP_NEGATIVE_Z", JS::NumberValue(34074U) },
  { "MAX_CUBE_MAP_TEXTURE_SIZE", JS::NumberValue(34076U) },
  { "TEXTURE0", JS::NumberValue(33984U) },
  { "TEXTURE1", JS::NumberValue(33985U) },
  { "TEXTURE2", JS::NumberValue(33986U) },
  { "TEXTURE3", JS::NumberValue(33987U) },
  { "TEXTURE4", JS::NumberValue(33988U) },
  { "TEXTURE5", JS::NumberValue(33989U) },
  { "TEXTURE6", JS::NumberValue(33990U) },
  { "TEXTURE7", JS::NumberValue(33991U) },
  { "TEXTURE8", JS::NumberValue(33992U) },
  { "TEXTURE9", JS::NumberValue(33993U) },
  { "TEXTURE10", JS::NumberValue(33994U) },
  { "TEXTURE11", JS::NumberValue(33995U) },
  { "TEXTURE12", JS::NumberValue(33996U) },
  { "TEXTURE13", JS::NumberValue(33997U) },
  { "TEXTURE14", JS::NumberValue(33998U) },
  { "TEXTURE15", JS::NumberValue(33999U) },
  { "TEXTURE16", JS::NumberValue(34000U) },
  { "TEXTURE17", JS::NumberValue(34001U) },
  { "TEXTURE18", JS::NumberValue(34002U) },
  { "TEXTURE19", JS::NumberValue(34003U) },
  { "TEXTURE20", JS::NumberValue(34004U) },
  { "TEXTURE21", JS::NumberValue(34005U) },
  { "TEXTURE22", JS::NumberValue(34006U) },
  { "TEXTURE23", JS::NumberValue(34007U) },
  { "TEXTURE24", JS::NumberValue(34008U) },
  { "TEXTURE25", JS::NumberValue(34009U) },
  { "TEXTURE26", JS::NumberValue(34010U) },
  { "TEXTURE27", JS::NumberValue(34011U) },
  { "TEXTURE28", JS::NumberValue(34012U) },
  { "TEXTURE29", JS::NumberValue(34013U) },
  { "TEXTURE30", JS::NumberValue(34014U) },
  { "TEXTURE31", JS::NumberValue(34015U) },
  { "ACTIVE_TEXTURE", JS::NumberValue(34016U) },
  { "REPEAT", JS::NumberValue(10497U) },
  { "CLAMP_TO_EDGE", JS::NumberValue(33071U) },
  { "MIRRORED_REPEAT", JS::NumberValue(33648U) },
  { "FLOAT_VEC2", JS::NumberValue(35664U) },
  { "FLOAT_VEC3", JS::NumberValue(35665U) },
  { "FLOAT_VEC4", JS::NumberValue(35666U) },
  { "INT_VEC2", JS::NumberValue(35667U) },
  { "INT_VEC3", JS::NumberValue(35668U) },
  { "INT_VEC4", JS::NumberValue(35669U) },
  { "BOOL", JS::NumberValue(35670U) },
  { "BOOL_VEC2", JS::NumberValue(35671U) },
  { "BOOL_VEC3", JS::NumberValue(35672U) },
  { "BOOL_VEC4", JS::NumberValue(35673U) },
  { "FLOAT_MAT2", JS::NumberValue(35674U) },
  { "FLOAT_MAT3", JS::NumberValue(35675U) },
  { "FLOAT_MAT4", JS::NumberValue(35676U) },
  { "SAMPLER_2D", JS::NumberValue(35678U) },
  { "SAMPLER_CUBE", JS::NumberValue(35680U) },
  { "VERTEX_ATTRIB_ARRAY_ENABLED", JS::NumberValue(34338U) },
  { "VERTEX_ATTRIB_ARRAY_SIZE", JS::NumberValue(34339U) },
  { "VERTEX_ATTRIB_ARRAY_STRIDE", JS::NumberValue(34340U) },
  { "VERTEX_ATTRIB_ARRAY_TYPE", JS::NumberValue(34341U) },
  { "VERTEX_ATTRIB_ARRAY_NORMALIZED", JS::NumberValue(34922U) },
  { "VERTEX_ATTRIB_ARRAY_POINTER", JS::NumberValue(34373U) },
  { "VERTEX_ATTRIB_ARRAY_BUFFER_BINDING", JS::NumberValue(34975U) },
  { "IMPLEMENTATION_COLOR_READ_TYPE", JS::NumberValue(35738U) },
  { "IMPLEMENTATION_COLOR_READ_FORMAT", JS::NumberValue(35739U) },
  { "COMPILE_STATUS", JS::NumberValue(35713U) },
  { "LOW_FLOAT", JS::NumberValue(36336U) },
  { "MEDIUM_FLOAT", JS::NumberValue(36337U) },
  { "HIGH_FLOAT", JS::NumberValue(36338U) },
  { "LOW_INT", JS::NumberValue(36339U) },
  { "MEDIUM_INT", JS::NumberValue(36340U) },
  { "HIGH_INT", JS::NumberValue(36341U) },
  { "FRAMEBUFFER", JS::NumberValue(36160U) },
  { "RENDERBUFFER", JS::NumberValue(36161U) },
  { "RGBA4", JS::NumberValue(32854U) },
  { "RGB5_A1", JS::NumberValue(32855U) },
  { "RGB565", JS::NumberValue(36194U) },
  { "DEPTH_COMPONENT16", JS::NumberValue(33189U) },
  { "STENCIL_INDEX8", JS::NumberValue(36168U) },
  { "DEPTH_STENCIL", JS::NumberValue(34041U) },
  { "RENDERBUFFER_WIDTH", JS::NumberValue(36162U) },
  { "RENDERBUFFER_HEIGHT", JS::NumberValue(36163U) },
  { "RENDERBUFFER_INTERNAL_FORMAT", JS::NumberValue(36164U) },
  { "RENDERBUFFER_RED_SIZE", JS::NumberValue(36176U) },
  { "RENDERBUFFER_GREEN_SIZE", JS::NumberValue(36177U) },
  { "RENDERBUFFER_BLUE_SIZE", JS::NumberValue(36178U) },
  { "RENDERBUFFER_ALPHA_SIZE", JS::NumberValue(36179U) },
  { "RENDERBUFFER_DEPTH_SIZE", JS::NumberValue(36180U) },
  { "RENDERBUFFER_STENCIL_SIZE", JS::NumberValue(36181U) },
  { "FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE", JS::NumberValue(36048U) },
  { "FRAMEBUFFER_ATTACHMENT_OBJECT_NAME", JS::NumberValue(36049U) },
  { "FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL", JS::NumberValue(36050U) },
  { "FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE", JS::NumberValue(36051U) },
  { "COLOR_ATTACHMENT0", JS::NumberValue(36064U) },
  { "DEPTH_ATTACHMENT", JS::NumberValue(36096U) },
  { "STENCIL_ATTACHMENT", JS::NumberValue(36128U) },
  { "DEPTH_STENCIL_ATTACHMENT", JS::NumberValue(33306U) },
  { "NONE", JS::NumberValue(0U) },
  { "FRAMEBUFFER_COMPLETE", JS::NumberValue(36053U) },
  { "FRAMEBUFFER_INCOMPLETE_ATTACHMENT", JS::NumberValue(36054U) },
  { "FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT", JS::NumberValue(36055U) },
  { "FRAMEBUFFER_INCOMPLETE_DIMENSIONS", JS::NumberValue(36057U) },
  { "FRAMEBUFFER_UNSUPPORTED", JS::NumberValue(36061U) },
  { "FRAMEBUFFER_BINDING", JS::NumberValue(36006U) },
  { "RENDERBUFFER_BINDING", JS::NumberValue(36007U) },
  { "MAX_RENDERBUFFER_SIZE", JS::NumberValue(34024U) },
  { "INVALID_FRAMEBUFFER_OPERATION", JS::NumberValue(1286U) },
  { "UNPACK_FLIP_Y_WEBGL", JS::NumberValue(37440U) },
  { "UNPACK_PREMULTIPLY_ALPHA_WEBGL", JS::NumberValue(37441U) },
  { "CONTEXT_LOST_WEBGL", JS::NumberValue(37442U) },
  { "UNPACK_COLORSPACE_CONVERSION_WEBGL", JS::NumberValue(37443U) },
  { "BROWSER_DEFAULT_WEBGL", JS::NumberValue(37444U) },
  { 0, JS::UndefinedValue() }
};


static const Prefable<const ConstantSpec> sConstants[] = {
  { nullptr, &sConstants_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(559 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");


static uint16_t sNativeProperties_sortedPropertyIndices[789];
static PropertyInfo sNativeProperties_propertyInfos[789];

static const NativePropertiesN<3> sNativeProperties = {
  false, 0,
  false, 0,
  true,  0 /* sMethods */,
  true,  1 /* sAttributes */,
  false, 0,
  false, 0,
  true,  2 /* sConstants */,
  -1,
  789,
  sNativeProperties_sortedPropertyIndices,
  {
    { sMethods, &sNativeProperties_propertyInfos[0] },
    { sAttributes, &sNativeProperties_propertyInfos[225] },
    { sConstants, &sNativeProperties_propertyInfos[230] }
  }
};
static_assert(789 < 1ull << (CHAR_BIT * sizeof(sNativeProperties.propertyInfoCount)),
    "We have a property info count that is oversized");

bool sNativePropertiesInited = false;
const NativePropertyHooks sNativePropertyHooks = {
  nullptr,
  { sNativeProperties.Upcast(), nullptr, &sNativePropertiesInited },
  prototypes::id::WebGL2RenderingContext,
  constructors::id::WebGL2RenderingContext,
  &DefaultXrayExpandoObjectClass
};

static const DOMInterfaceInfo sInterfaceObjectInfo = {
  { ThrowingConstructor, &sNativePropertyHooks },
  JS::GetRealmFunctionPrototypeHandle,
  PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth,
  prototypes::id::WebGL2RenderingContext,
  true,
  0,
  "WebGL2RenderingContext",
};

static const DOMIfaceAndProtoJSClass sPrototypeClass = {
  {
    "WebGL2RenderingContextPrototype",
    JSCLASS_IS_DOMIFACEANDPROTOJSCLASS | JSCLASS_HAS_RESERVED_SLOTS(DOM_INTERFACE_PROTO_SLOTS_BASE),
    JS_NULL_CLASS_OPS,
    JS_NULL_CLASS_SPEC,
    JS_NULL_CLASS_EXT,
    JS_NULL_OBJECT_OPS
  },
  eInterfacePrototype,
  prototypes::id::WebGL2RenderingContext,
  PrototypeTraits<prototypes::id::WebGL2RenderingContext>::Depth,
  &sNativePropertyHooks,
  JS::GetRealmObjectPrototype
};

bool
ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj)
{
  return StaticPrefs::webgl_enable_webgl2();
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx);

static const JSClassOps sClassOps = {
  nullptr,               /* addProperty */
  nullptr,               /* delProperty */
  nullptr,               /* enumerate */
  nullptr, /* newEnumerate */
  nullptr, /* resolve */
  nullptr, /* mayResolve */
  _finalize, /* finalize */
  nullptr, /* call */
  nullptr,               /* construct */
  nullptr, /* trace */
};

static const DOMJSClass sClass = {
  { "WebGL2RenderingContext",
    JSCLASS_IS_DOMJSCLASS | JSCLASS_FOREGROUND_FINALIZE | JSCLASS_HAS_RESERVED_SLOTS(1) | JSCLASS_PRESERVES_WRAPPER,
    &sClassOps,
    JS_NULL_CLASS_SPEC,
    &NativeTypeHelpers<mozilla::ClientWebGLContext>::sClassExtension,
    JS_NULL_OBJECT_OPS
  },
  { prototypes::id::WebGL2RenderingContext, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count },
  std::is_base_of_v<nsISupports, mozilla::ClientWebGLContext>,
  &sNativePropertyHooks,
  FindAssociatedGlobalForNative<mozilla::ClientWebGLContext>::Get,
  GetProtoObjectHandle,
  GetCCParticipant<mozilla::ClientWebGLContext>::Get(),
  nullptr,
  NativeTypeHelpers<mozilla::ClientWebGLContext>::GetWrapperCache
};
static_assert(1 == DOM_INSTANCE_RESERVED_SLOTS,
              "Must have the right minimal number of reserved slots.");
static_assert(1 >= 1,
              "Must have enough reserved slots.");

bool
Wrap(JSContext* aCx, mozilla::ClientWebGLContext* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector)
{
  static_assert(!std::is_base_of_v<NonRefcountedDOMObject, mozilla::ClientWebGLContext>,
                "Shouldn't have wrappercached things that are not refcounted.");
  static_assert(std::is_same_v<decltype(aObject), mozilla::ClientWebGLContext*>);
  MOZ_ASSERT(ToSupportsIsCorrect(aObject));
  MOZ_ASSERT_IF(aGivenProto, js::IsObjectInContextCompartment(aGivenProto, aCx));
  MOZ_ASSERT(!aCache->GetWrapper(),
             "You should probably not be using Wrap() directly; use "
             "GetOrCreateDOMReflector instead");

  MOZ_ASSERT(ToSupportsIsOnPrimaryInheritanceChain(aObject, aCache),
             "nsISupports must be on our primary inheritance chain");

  // If the wrapper cache contains a dead reflector then finalize that
  // now, ensuring that the finalizer for the old reflector always
  // runs before the new reflector is created and attached. This
  // avoids the awkward situation where there are multiple reflector
  // objects that contain pointers to the same native.

  if (JSObject* oldReflector = aCache->GetWrapperMaybeDead()) {
    _finalize(nullptr /* unused */, oldReflector);
    MOZ_ASSERT(!aCache->GetWrapperMaybeDead());
  }

  JS::Rooted<JSObject*> global(aCx, FindAssociatedGlobal(aCx, aObject->GetParentObject()));
  if (!global) {
    return false;
  }
  MOZ_ASSERT(JS_IsGlobalObject(global));
  JS::AssertObjectIsNotGray(global);

  // That might have ended up wrapping us already, due to the wonders
  // of XBL.  Check for that, and bail out as needed.
  aReflector.set(aCache->GetWrapper());
  if (aReflector) {
#ifdef DEBUG
    AssertReflectorHasGivenProto(aCx, aReflector, aGivenProto);
#endif // DEBUG
    return true;
  }

  JSAutoRealm ar(aCx, global);
  JS::Handle<JSObject*> canonicalProto = GetProtoObjectHandle(aCx);
  if (!canonicalProto) {
    return false;
  }
  JS::Rooted<JSObject*> proto(aCx);
  if (aGivenProto) {
    proto = aGivenProto;
    // Unfortunately, while aGivenProto was in the compartment of aCx
    // coming in, we changed compartments to that of "parent" so may need
    // to wrap the proto here.
    if (js::GetContextCompartment(aCx) != JS::GetCompartment(proto)) {
      if (!JS_WrapObject(aCx, &proto)) {
        return false;
      }
    }
  } else {
    proto = canonicalProto;
  }

  BindingJSObjectCreator<mozilla::ClientWebGLContext> creator(aCx);
  creator.CreateObject(aCx, sClass.ToJSClass(), proto, aObject, aReflector);
  if (!aReflector) {
    return false;
  }

  aCache->SetWrapper(aReflector);
  creator.InitializationSucceeded();

  MOZ_ASSERT(aCache->GetWrapperPreserveColor() &&
             aCache->GetWrapperPreserveColor() == aReflector);
  // If proto != canonicalProto, we have to preserve our wrapper;
  // otherwise we won't be able to properly recreate it later, since
  // we won't know what proto to use.  Note that we don't check
  // aGivenProto here, since it's entirely possible (and even
  // somewhat common) to have a non-null aGivenProto which is the
  // same as canonicalProto.
  if (proto != canonicalProto) {
    PreserveWrapper(aObject);
  }

  return true;
}

void
CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal)
{
  JS::Heap<JSObject*>* protoCache = &aProtoAndIfaceCache.EntrySlotOrCreate(prototypes::id::WebGL2RenderingContext);
  JS::Heap<JSObject*>* interfaceCache = &aProtoAndIfaceCache.EntrySlotOrCreate(constructors::id::WebGL2RenderingContext);

  JS::Handle<JSObject*> parentProto(JS::GetRealmObjectPrototypeHandle(aCx));
  if (!parentProto) {
    return;
  }

  JS::Handle<JSObject*> constructorProto(JS::GetRealmFunctionPrototypeHandle(aCx));
  if (!constructorProto) {
    return;
  }

  dom::CreateInterfaceObjects(aCx, aGlobal, parentProto,
                              &sPrototypeClass, protoCache,
                              constructorProto, &sInterfaceObjectInfo, 0, false, Span<const LegacyFactoryFunction, 0>{},
                              interfaceCache,
                              sNativeProperties.Upcast(),
                              nullptr,
                              "WebGL2RenderingContext",
                              ShouldExpose<WebGL2RenderingContext_Binding::ConstructorEnabled>(aCx, aGlobal, aDefineOnGlobal),
                              nullptr,
                              false,
                              nullptr);
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx)
{
  /* Get the interface prototype object for this class.  This will create the
     object as needed. */
  return GetPerInterfaceObjectHandle(aCx, prototypes::id::WebGL2RenderingContext,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);

}

JS::Handle<JSObject*>
GetConstructorObjectHandle(JSContext* aCx)
{
  /* Get the interface object for this class.  This will create the object as
     needed. */

  return GetPerInterfaceObjectHandle(aCx, constructors::id::WebGL2RenderingContext,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);
}

} // namespace WebGL2RenderingContext_Binding



namespace WebGLSampler_Binding {

static void
_finalize(JS::GCContext* gcx, JSObject* obj)
{
  mozilla::WebGLSamplerJS* self = UnwrapPossiblyNotInitializedDOMObject<mozilla::WebGLSamplerJS>(obj);
  if (self) {
    JS::SetReservedSlot(obj, DOM_OBJECT_SLOT, JS::UndefinedValue());
    ClearWrapper(self, self, obj);
    if (size_t mallocBytes = BindingJSObjectMallocBytes(self)) {
      JS::RemoveAssociatedMemory(obj, mallocBytes,
                                 JS::MemoryUse::DOMBinding);
    }
    AddForDeferredFinalization<mozilla::WebGLSamplerJS>(self);
  }
}

bool sNativePropertiesInited = false;
const NativePropertyHooks sNativePropertyHooks = {
  nullptr,
  { nullptr, nullptr, &sNativePropertiesInited },
  prototypes::id::WebGLSampler,
  constructors::id::WebGLSampler,
  &DefaultXrayExpandoObjectClass
};

static const DOMInterfaceInfo sInterfaceObjectInfo = {
  { ThrowingConstructor, &sNativePropertyHooks },
  JS::GetRealmFunctionPrototypeHandle,
  PrototypeTraits<prototypes::id::WebGLSampler>::Depth,
  prototypes::id::WebGLSampler,
  true,
  0,
  "WebGLSampler",
};

static const DOMIfaceAndProtoJSClass sPrototypeClass = {
  {
    "WebGLSamplerPrototype",
    JSCLASS_IS_DOMIFACEANDPROTOJSCLASS | JSCLASS_HAS_RESERVED_SLOTS(DOM_INTERFACE_PROTO_SLOTS_BASE),
    JS_NULL_CLASS_OPS,
    JS_NULL_CLASS_SPEC,
    JS_NULL_CLASS_EXT,
    JS_NULL_OBJECT_OPS
  },
  eInterfacePrototype,
  prototypes::id::WebGLSampler,
  PrototypeTraits<prototypes::id::WebGLSampler>::Depth,
  &sNativePropertyHooks,
  JS::GetRealmObjectPrototype
};

bool
ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj)
{
  return StaticPrefs::webgl_enable_webgl2();
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx);

static const JSClassOps sClassOps = {
  nullptr,               /* addProperty */
  nullptr,               /* delProperty */
  nullptr,               /* enumerate */
  nullptr, /* newEnumerate */
  nullptr, /* resolve */
  nullptr, /* mayResolve */
  _finalize, /* finalize */
  nullptr, /* call */
  nullptr,               /* construct */
  nullptr, /* trace */
};

static const DOMJSClass sClass = {
  { "WebGLSampler",
    JSCLASS_IS_DOMJSCLASS | JSCLASS_FOREGROUND_FINALIZE | JSCLASS_HAS_RESERVED_SLOTS(1) | JSCLASS_PRESERVES_WRAPPER,
    &sClassOps,
    JS_NULL_CLASS_SPEC,
    &NativeTypeHelpers<mozilla::WebGLSamplerJS>::sClassExtension,
    JS_NULL_OBJECT_OPS
  },
  { prototypes::id::WebGLSampler, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count },
  std::is_base_of_v<nsISupports, mozilla::WebGLSamplerJS>,
  &sNativePropertyHooks,
  FindAssociatedGlobalForNative<mozilla::WebGLSamplerJS>::Get,
  GetProtoObjectHandle,
  GetCCParticipant<mozilla::WebGLSamplerJS>::Get(),
  nullptr,
  NativeTypeHelpers<mozilla::WebGLSamplerJS>::GetWrapperCache
};
static_assert(1 == DOM_INSTANCE_RESERVED_SLOTS,
              "Must have the right minimal number of reserved slots.");
static_assert(1 >= 1,
              "Must have enough reserved slots.");

bool
Wrap(JSContext* aCx, mozilla::WebGLSamplerJS* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector)
{
  static_assert(!std::is_base_of_v<NonRefcountedDOMObject, mozilla::WebGLSamplerJS>,
                "Shouldn't have wrappercached things that are not refcounted.");
  static_assert(std::is_same_v<decltype(aObject), mozilla::WebGLSamplerJS*>);
  MOZ_ASSERT(ToSupportsIsCorrect(aObject));
  MOZ_ASSERT_IF(aGivenProto, js::IsObjectInContextCompartment(aGivenProto, aCx));
  MOZ_ASSERT(!aCache->GetWrapper(),
             "You should probably not be using Wrap() directly; use "
             "GetOrCreateDOMReflector instead");

  MOZ_ASSERT(ToSupportsIsOnPrimaryInheritanceChain(aObject, aCache),
             "nsISupports must be on our primary inheritance chain");

  // If the wrapper cache contains a dead reflector then finalize that
  // now, ensuring that the finalizer for the old reflector always
  // runs before the new reflector is created and attached. This
  // avoids the awkward situation where there are multiple reflector
  // objects that contain pointers to the same native.

  if (JSObject* oldReflector = aCache->GetWrapperMaybeDead()) {
    _finalize(nullptr /* unused */, oldReflector);
    MOZ_ASSERT(!aCache->GetWrapperMaybeDead());
  }

  JS::Rooted<JSObject*> global(aCx, FindAssociatedGlobal(aCx, aObject->GetParentObject()));
  if (!global) {
    return false;
  }
  MOZ_ASSERT(JS_IsGlobalObject(global));
  JS::AssertObjectIsNotGray(global);

  // That might have ended up wrapping us already, due to the wonders
  // of XBL.  Check for that, and bail out as needed.
  aReflector.set(aCache->GetWrapper());
  if (aReflector) {
#ifdef DEBUG
    AssertReflectorHasGivenProto(aCx, aReflector, aGivenProto);
#endif // DEBUG
    return true;
  }

  JSAutoRealm ar(aCx, global);
  JS::Handle<JSObject*> canonicalProto = GetProtoObjectHandle(aCx);
  if (!canonicalProto) {
    return false;
  }
  JS::Rooted<JSObject*> proto(aCx);
  if (aGivenProto) {
    proto = aGivenProto;
    // Unfortunately, while aGivenProto was in the compartment of aCx
    // coming in, we changed compartments to that of "parent" so may need
    // to wrap the proto here.
    if (js::GetContextCompartment(aCx) != JS::GetCompartment(proto)) {
      if (!JS_WrapObject(aCx, &proto)) {
        return false;
      }
    }
  } else {
    proto = canonicalProto;
  }

  BindingJSObjectCreator<mozilla::WebGLSamplerJS> creator(aCx);
  creator.CreateObject(aCx, sClass.ToJSClass(), proto, aObject, aReflector);
  if (!aReflector) {
    return false;
  }

  aCache->SetWrapper(aReflector);
  creator.InitializationSucceeded();

  MOZ_ASSERT(aCache->GetWrapperPreserveColor() &&
             aCache->GetWrapperPreserveColor() == aReflector);
  // If proto != canonicalProto, we have to preserve our wrapper;
  // otherwise we won't be able to properly recreate it later, since
  // we won't know what proto to use.  Note that we don't check
  // aGivenProto here, since it's entirely possible (and even
  // somewhat common) to have a non-null aGivenProto which is the
  // same as canonicalProto.
  if (proto != canonicalProto) {
    PreserveWrapper(aObject);
  }

  return true;
}

void
CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal)
{
  JS::Heap<JSObject*>* protoCache = &aProtoAndIfaceCache.EntrySlotOrCreate(prototypes::id::WebGLSampler);
  JS::Heap<JSObject*>* interfaceCache = &aProtoAndIfaceCache.EntrySlotOrCreate(constructors::id::WebGLSampler);

  JS::Handle<JSObject*> parentProto(JS::GetRealmObjectPrototypeHandle(aCx));
  if (!parentProto) {
    return;
  }

  JS::Handle<JSObject*> constructorProto(JS::GetRealmFunctionPrototypeHandle(aCx));
  if (!constructorProto) {
    return;
  }

  dom::CreateInterfaceObjects(aCx, aGlobal, parentProto,
                              &sPrototypeClass, protoCache,
                              constructorProto, &sInterfaceObjectInfo, 0, false, Span<const LegacyFactoryFunction, 0>{},
                              interfaceCache,
                              nullptr,
                              nullptr,
                              "WebGLSampler",
                              ShouldExpose<WebGLSampler_Binding::ConstructorEnabled>(aCx, aGlobal, aDefineOnGlobal),
                              nullptr,
                              false,
                              nullptr);
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx)
{
  /* Get the interface prototype object for this class.  This will create the
     object as needed. */
  return GetPerInterfaceObjectHandle(aCx, prototypes::id::WebGLSampler,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);

}

JS::Handle<JSObject*>
GetConstructorObjectHandle(JSContext* aCx)
{
  /* Get the interface object for this class.  This will create the object as
     needed. */

  return GetPerInterfaceObjectHandle(aCx, constructors::id::WebGLSampler,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);
}

} // namespace WebGLSampler_Binding



namespace WebGLSync_Binding {

static void
_finalize(JS::GCContext* gcx, JSObject* obj)
{
  mozilla::WebGLSyncJS* self = UnwrapPossiblyNotInitializedDOMObject<mozilla::WebGLSyncJS>(obj);
  if (self) {
    JS::SetReservedSlot(obj, DOM_OBJECT_SLOT, JS::UndefinedValue());
    ClearWrapper(self, self, obj);
    if (size_t mallocBytes = BindingJSObjectMallocBytes(self)) {
      JS::RemoveAssociatedMemory(obj, mallocBytes,
                                 JS::MemoryUse::DOMBinding);
    }
    AddForDeferredFinalization<mozilla::WebGLSyncJS>(self);
  }
}

bool sNativePropertiesInited = false;
const NativePropertyHooks sNativePropertyHooks = {
  nullptr,
  { nullptr, nullptr, &sNativePropertiesInited },
  prototypes::id::WebGLSync,
  constructors::id::WebGLSync,
  &DefaultXrayExpandoObjectClass
};

static const DOMInterfaceInfo sInterfaceObjectInfo = {
  { ThrowingConstructor, &sNativePropertyHooks },
  JS::GetRealmFunctionPrototypeHandle,
  PrototypeTraits<prototypes::id::WebGLSync>::Depth,
  prototypes::id::WebGLSync,
  true,
  0,
  "WebGLSync",
};

static const DOMIfaceAndProtoJSClass sPrototypeClass = {
  {
    "WebGLSyncPrototype",
    JSCLASS_IS_DOMIFACEANDPROTOJSCLASS | JSCLASS_HAS_RESERVED_SLOTS(DOM_INTERFACE_PROTO_SLOTS_BASE),
    JS_NULL_CLASS_OPS,
    JS_NULL_CLASS_SPEC,
    JS_NULL_CLASS_EXT,
    JS_NULL_OBJECT_OPS
  },
  eInterfacePrototype,
  prototypes::id::WebGLSync,
  PrototypeTraits<prototypes::id::WebGLSync>::Depth,
  &sNativePropertyHooks,
  JS::GetRealmObjectPrototype
};

bool
ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj)
{
  return StaticPrefs::webgl_enable_webgl2();
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx);

static const JSClassOps sClassOps = {
  nullptr,               /* addProperty */
  nullptr,               /* delProperty */
  nullptr,               /* enumerate */
  nullptr, /* newEnumerate */
  nullptr, /* resolve */
  nullptr, /* mayResolve */
  _finalize, /* finalize */
  nullptr, /* call */
  nullptr,               /* construct */
  nullptr, /* trace */
};

static const DOMJSClass sClass = {
  { "WebGLSync",
    JSCLASS_IS_DOMJSCLASS | JSCLASS_FOREGROUND_FINALIZE | JSCLASS_HAS_RESERVED_SLOTS(1) | JSCLASS_PRESERVES_WRAPPER,
    &sClassOps,
    JS_NULL_CLASS_SPEC,
    &NativeTypeHelpers<mozilla::WebGLSyncJS>::sClassExtension,
    JS_NULL_OBJECT_OPS
  },
  { prototypes::id::WebGLSync, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count },
  std::is_base_of_v<nsISupports, mozilla::WebGLSyncJS>,
  &sNativePropertyHooks,
  FindAssociatedGlobalForNative<mozilla::WebGLSyncJS>::Get,
  GetProtoObjectHandle,
  GetCCParticipant<mozilla::WebGLSyncJS>::Get(),
  nullptr,
  NativeTypeHelpers<mozilla::WebGLSyncJS>::GetWrapperCache
};
static_assert(1 == DOM_INSTANCE_RESERVED_SLOTS,
              "Must have the right minimal number of reserved slots.");
static_assert(1 >= 1,
              "Must have enough reserved slots.");

bool
Wrap(JSContext* aCx, mozilla::WebGLSyncJS* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector)
{
  static_assert(!std::is_base_of_v<NonRefcountedDOMObject, mozilla::WebGLSyncJS>,
                "Shouldn't have wrappercached things that are not refcounted.");
  static_assert(std::is_same_v<decltype(aObject), mozilla::WebGLSyncJS*>);
  MOZ_ASSERT(ToSupportsIsCorrect(aObject));
  MOZ_ASSERT_IF(aGivenProto, js::IsObjectInContextCompartment(aGivenProto, aCx));
  MOZ_ASSERT(!aCache->GetWrapper(),
             "You should probably not be using Wrap() directly; use "
             "GetOrCreateDOMReflector instead");

  MOZ_ASSERT(ToSupportsIsOnPrimaryInheritanceChain(aObject, aCache),
             "nsISupports must be on our primary inheritance chain");

  // If the wrapper cache contains a dead reflector then finalize that
  // now, ensuring that the finalizer for the old reflector always
  // runs before the new reflector is created and attached. This
  // avoids the awkward situation where there are multiple reflector
  // objects that contain pointers to the same native.

  if (JSObject* oldReflector = aCache->GetWrapperMaybeDead()) {
    _finalize(nullptr /* unused */, oldReflector);
    MOZ_ASSERT(!aCache->GetWrapperMaybeDead());
  }

  JS::Rooted<JSObject*> global(aCx, FindAssociatedGlobal(aCx, aObject->GetParentObject()));
  if (!global) {
    return false;
  }
  MOZ_ASSERT(JS_IsGlobalObject(global));
  JS::AssertObjectIsNotGray(global);

  // That might have ended up wrapping us already, due to the wonders
  // of XBL.  Check for that, and bail out as needed.
  aReflector.set(aCache->GetWrapper());
  if (aReflector) {
#ifdef DEBUG
    AssertReflectorHasGivenProto(aCx, aReflector, aGivenProto);
#endif // DEBUG
    return true;
  }

  JSAutoRealm ar(aCx, global);
  JS::Handle<JSObject*> canonicalProto = GetProtoObjectHandle(aCx);
  if (!canonicalProto) {
    return false;
  }
  JS::Rooted<JSObject*> proto(aCx);
  if (aGivenProto) {
    proto = aGivenProto;
    // Unfortunately, while aGivenProto was in the compartment of aCx
    // coming in, we changed compartments to that of "parent" so may need
    // to wrap the proto here.
    if (js::GetContextCompartment(aCx) != JS::GetCompartment(proto)) {
      if (!JS_WrapObject(aCx, &proto)) {
        return false;
      }
    }
  } else {
    proto = canonicalProto;
  }

  BindingJSObjectCreator<mozilla::WebGLSyncJS> creator(aCx);
  creator.CreateObject(aCx, sClass.ToJSClass(), proto, aObject, aReflector);
  if (!aReflector) {
    return false;
  }

  aCache->SetWrapper(aReflector);
  creator.InitializationSucceeded();

  MOZ_ASSERT(aCache->GetWrapperPreserveColor() &&
             aCache->GetWrapperPreserveColor() == aReflector);
  // If proto != canonicalProto, we have to preserve our wrapper;
  // otherwise we won't be able to properly recreate it later, since
  // we won't know what proto to use.  Note that we don't check
  // aGivenProto here, since it's entirely possible (and even
  // somewhat common) to have a non-null aGivenProto which is the
  // same as canonicalProto.
  if (proto != canonicalProto) {
    PreserveWrapper(aObject);
  }

  return true;
}

void
CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal)
{
  JS::Heap<JSObject*>* protoCache = &aProtoAndIfaceCache.EntrySlotOrCreate(prototypes::id::WebGLSync);
  JS::Heap<JSObject*>* interfaceCache = &aProtoAndIfaceCache.EntrySlotOrCreate(constructors::id::WebGLSync);

  JS::Handle<JSObject*> parentProto(JS::GetRealmObjectPrototypeHandle(aCx));
  if (!parentProto) {
    return;
  }

  JS::Handle<JSObject*> constructorProto(JS::GetRealmFunctionPrototypeHandle(aCx));
  if (!constructorProto) {
    return;
  }

  dom::CreateInterfaceObjects(aCx, aGlobal, parentProto,
                              &sPrototypeClass, protoCache,
                              constructorProto, &sInterfaceObjectInfo, 0, false, Span<const LegacyFactoryFunction, 0>{},
                              interfaceCache,
                              nullptr,
                              nullptr,
                              "WebGLSync",
                              ShouldExpose<WebGLSync_Binding::ConstructorEnabled>(aCx, aGlobal, aDefineOnGlobal),
                              nullptr,
                              false,
                              nullptr);
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx)
{
  /* Get the interface prototype object for this class.  This will create the
     object as needed. */
  return GetPerInterfaceObjectHandle(aCx, prototypes::id::WebGLSync,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);

}

JS::Handle<JSObject*>
GetConstructorObjectHandle(JSContext* aCx)
{
  /* Get the interface object for this class.  This will create the object as
     needed. */

  return GetPerInterfaceObjectHandle(aCx, constructors::id::WebGLSync,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);
}

} // namespace WebGLSync_Binding



namespace WebGLTransformFeedback_Binding {

static void
_finalize(JS::GCContext* gcx, JSObject* obj)
{
  mozilla::WebGLTransformFeedbackJS* self = UnwrapPossiblyNotInitializedDOMObject<mozilla::WebGLTransformFeedbackJS>(obj);
  if (self) {
    JS::SetReservedSlot(obj, DOM_OBJECT_SLOT, JS::UndefinedValue());
    ClearWrapper(self, self, obj);
    if (size_t mallocBytes = BindingJSObjectMallocBytes(self)) {
      JS::RemoveAssociatedMemory(obj, mallocBytes,
                                 JS::MemoryUse::DOMBinding);
    }
    AddForDeferredFinalization<mozilla::WebGLTransformFeedbackJS>(self);
  }
}

bool sNativePropertiesInited = false;
const NativePropertyHooks sNativePropertyHooks = {
  nullptr,
  { nullptr, nullptr, &sNativePropertiesInited },
  prototypes::id::WebGLTransformFeedback,
  constructors::id::WebGLTransformFeedback,
  &DefaultXrayExpandoObjectClass
};

static const DOMInterfaceInfo sInterfaceObjectInfo = {
  { ThrowingConstructor, &sNativePropertyHooks },
  JS::GetRealmFunctionPrototypeHandle,
  PrototypeTraits<prototypes::id::WebGLTransformFeedback>::Depth,
  prototypes::id::WebGLTransformFeedback,
  true,
  0,
  "WebGLTransformFeedback",
};

static const DOMIfaceAndProtoJSClass sPrototypeClass = {
  {
    "WebGLTransformFeedbackPrototype",
    JSCLASS_IS_DOMIFACEANDPROTOJSCLASS | JSCLASS_HAS_RESERVED_SLOTS(DOM_INTERFACE_PROTO_SLOTS_BASE),
    JS_NULL_CLASS_OPS,
    JS_NULL_CLASS_SPEC,
    JS_NULL_CLASS_EXT,
    JS_NULL_OBJECT_OPS
  },
  eInterfacePrototype,
  prototypes::id::WebGLTransformFeedback,
  PrototypeTraits<prototypes::id::WebGLTransformFeedback>::Depth,
  &sNativePropertyHooks,
  JS::GetRealmObjectPrototype
};

bool
ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj)
{
  return StaticPrefs::webgl_enable_webgl2();
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx);

static const JSClassOps sClassOps = {
  nullptr,               /* addProperty */
  nullptr,               /* delProperty */
  nullptr,               /* enumerate */
  nullptr, /* newEnumerate */
  nullptr, /* resolve */
  nullptr, /* mayResolve */
  _finalize, /* finalize */
  nullptr, /* call */
  nullptr,               /* construct */
  nullptr, /* trace */
};

static const DOMJSClass sClass = {
  { "WebGLTransformFeedback",
    JSCLASS_IS_DOMJSCLASS | JSCLASS_FOREGROUND_FINALIZE | JSCLASS_HAS_RESERVED_SLOTS(1) | JSCLASS_PRESERVES_WRAPPER,
    &sClassOps,
    JS_NULL_CLASS_SPEC,
    &NativeTypeHelpers<mozilla::WebGLTransformFeedbackJS>::sClassExtension,
    JS_NULL_OBJECT_OPS
  },
  { prototypes::id::WebGLTransformFeedback, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count },
  std::is_base_of_v<nsISupports, mozilla::WebGLTransformFeedbackJS>,
  &sNativePropertyHooks,
  FindAssociatedGlobalForNative<mozilla::WebGLTransformFeedbackJS>::Get,
  GetProtoObjectHandle,
  GetCCParticipant<mozilla::WebGLTransformFeedbackJS>::Get(),
  nullptr,
  NativeTypeHelpers<mozilla::WebGLTransformFeedbackJS>::GetWrapperCache
};
static_assert(1 == DOM_INSTANCE_RESERVED_SLOTS,
              "Must have the right minimal number of reserved slots.");
static_assert(1 >= 1,
              "Must have enough reserved slots.");

bool
Wrap(JSContext* aCx, mozilla::WebGLTransformFeedbackJS* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector)
{
  static_assert(!std::is_base_of_v<NonRefcountedDOMObject, mozilla::WebGLTransformFeedbackJS>,
                "Shouldn't have wrappercached things that are not refcounted.");
  static_assert(std::is_same_v<decltype(aObject), mozilla::WebGLTransformFeedbackJS*>);
  MOZ_ASSERT(ToSupportsIsCorrect(aObject));
  MOZ_ASSERT_IF(aGivenProto, js::IsObjectInContextCompartment(aGivenProto, aCx));
  MOZ_ASSERT(!aCache->GetWrapper(),
             "You should probably not be using Wrap() directly; use "
             "GetOrCreateDOMReflector instead");

  MOZ_ASSERT(ToSupportsIsOnPrimaryInheritanceChain(aObject, aCache),
             "nsISupports must be on our primary inheritance chain");

  // If the wrapper cache contains a dead reflector then finalize that
  // now, ensuring that the finalizer for the old reflector always
  // runs before the new reflector is created and attached. This
  // avoids the awkward situation where there are multiple reflector
  // objects that contain pointers to the same native.

  if (JSObject* oldReflector = aCache->GetWrapperMaybeDead()) {
    _finalize(nullptr /* unused */, oldReflector);
    MOZ_ASSERT(!aCache->GetWrapperMaybeDead());
  }

  JS::Rooted<JSObject*> global(aCx, FindAssociatedGlobal(aCx, aObject->GetParentObject()));
  if (!global) {
    return false;
  }
  MOZ_ASSERT(JS_IsGlobalObject(global));
  JS::AssertObjectIsNotGray(global);

  // That might have ended up wrapping us already, due to the wonders
  // of XBL.  Check for that, and bail out as needed.
  aReflector.set(aCache->GetWrapper());
  if (aReflector) {
#ifdef DEBUG
    AssertReflectorHasGivenProto(aCx, aReflector, aGivenProto);
#endif // DEBUG
    return true;
  }

  JSAutoRealm ar(aCx, global);
  JS::Handle<JSObject*> canonicalProto = GetProtoObjectHandle(aCx);
  if (!canonicalProto) {
    return false;
  }
  JS::Rooted<JSObject*> proto(aCx);
  if (aGivenProto) {
    proto = aGivenProto;
    // Unfortunately, while aGivenProto was in the compartment of aCx
    // coming in, we changed compartments to that of "parent" so may need
    // to wrap the proto here.
    if (js::GetContextCompartment(aCx) != JS::GetCompartment(proto)) {
      if (!JS_WrapObject(aCx, &proto)) {
        return false;
      }
    }
  } else {
    proto = canonicalProto;
  }

  BindingJSObjectCreator<mozilla::WebGLTransformFeedbackJS> creator(aCx);
  creator.CreateObject(aCx, sClass.ToJSClass(), proto, aObject, aReflector);
  if (!aReflector) {
    return false;
  }

  aCache->SetWrapper(aReflector);
  creator.InitializationSucceeded();

  MOZ_ASSERT(aCache->GetWrapperPreserveColor() &&
             aCache->GetWrapperPreserveColor() == aReflector);
  // If proto != canonicalProto, we have to preserve our wrapper;
  // otherwise we won't be able to properly recreate it later, since
  // we won't know what proto to use.  Note that we don't check
  // aGivenProto here, since it's entirely possible (and even
  // somewhat common) to have a non-null aGivenProto which is the
  // same as canonicalProto.
  if (proto != canonicalProto) {
    PreserveWrapper(aObject);
  }

  return true;
}

void
CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal)
{
  JS::Heap<JSObject*>* protoCache = &aProtoAndIfaceCache.EntrySlotOrCreate(prototypes::id::WebGLTransformFeedback);
  JS::Heap<JSObject*>* interfaceCache = &aProtoAndIfaceCache.EntrySlotOrCreate(constructors::id::WebGLTransformFeedback);

  JS::Handle<JSObject*> parentProto(JS::GetRealmObjectPrototypeHandle(aCx));
  if (!parentProto) {
    return;
  }

  JS::Handle<JSObject*> constructorProto(JS::GetRealmFunctionPrototypeHandle(aCx));
  if (!constructorProto) {
    return;
  }

  dom::CreateInterfaceObjects(aCx, aGlobal, parentProto,
                              &sPrototypeClass, protoCache,
                              constructorProto, &sInterfaceObjectInfo, 0, false, Span<const LegacyFactoryFunction, 0>{},
                              interfaceCache,
                              nullptr,
                              nullptr,
                              "WebGLTransformFeedback",
                              ShouldExpose<WebGLTransformFeedback_Binding::ConstructorEnabled>(aCx, aGlobal, aDefineOnGlobal),
                              nullptr,
                              false,
                              nullptr);
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx)
{
  /* Get the interface prototype object for this class.  This will create the
     object as needed. */
  return GetPerInterfaceObjectHandle(aCx, prototypes::id::WebGLTransformFeedback,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);

}

JS::Handle<JSObject*>
GetConstructorObjectHandle(JSContext* aCx)
{
  /* Get the interface object for this class.  This will create the object as
     needed. */

  return GetPerInterfaceObjectHandle(aCx, constructors::id::WebGLTransformFeedback,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);
}

} // namespace WebGLTransformFeedback_Binding



} // namespace mozilla::dom
