/* auto-generated, do not modify */
#include "config.h"

#include <glib.h>

#include "fu-steelseries-sonic-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"


/**
 * fu_steelseries_sonic_wireless_status_to_string:
 * @val: value, e.g. %FU_STEELSERIES_SONIC_WIRELESS_STATUS_IDLE
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
const gchar *
fu_steelseries_sonic_wireless_status_to_string(FuSteelseriesSonicWirelessStatus val)
{
    if (val == FU_STEELSERIES_SONIC_WIRELESS_STATUS_OFF)
        return "off";
    if (val == FU_STEELSERIES_SONIC_WIRELESS_STATUS_IDLE)
        return "idle";
    if (val == FU_STEELSERIES_SONIC_WIRELESS_STATUS_SEARCH)
        return "search";
    if (val == FU_STEELSERIES_SONIC_WIRELESS_STATUS_LOCKED)
        return "locked";
    if (val == FU_STEELSERIES_SONIC_WIRELESS_STATUS_CONNECTED)
        return "connected";
    if (val == FU_STEELSERIES_SONIC_WIRELESS_STATUS_TERMINATED)
        return "terminated";
    return NULL;
}

/**
 * fu_struct_steelseries_sonic_wireless_status_req_ref: (skip):
 **/
FuStructSteelseriesSonicWirelessStatusReq *
fu_struct_steelseries_sonic_wireless_status_req_ref(FuStructSteelseriesSonicWirelessStatusReq *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_steelseries_sonic_wireless_status_req_unref: (skip):
 **/
void
fu_struct_steelseries_sonic_wireless_status_req_unref(FuStructSteelseriesSonicWirelessStatusReq *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructSteelseriesSonicWirelessStatusReq refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_steelseries_sonic_wireless_status_req_new_internal: (skip):
 **/
static FuStructSteelseriesSonicWirelessStatusReq *
fu_struct_steelseries_sonic_wireless_status_req_new_internal(void)
{
    FuStructSteelseriesSonicWirelessStatusReq *st = g_new0(FuStructSteelseriesSonicWirelessStatusReq, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_steelseries_sonic_wireless_status_req_set_opcode: (skip):
 **/
static void
fu_struct_steelseries_sonic_wireless_status_req_set_opcode(FuStructSteelseriesSonicWirelessStatusReq *st, FuSteelseriesSonicOpcode8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_steelseries_sonic_wireless_status_req_new: (skip):
 **/
FuStructSteelseriesSonicWirelessStatusReq *
fu_struct_steelseries_sonic_wireless_status_req_new(void)
{
    FuStructSteelseriesSonicWirelessStatusReq *st = fu_struct_steelseries_sonic_wireless_status_req_new_internal();
    st->buf = g_byte_array_sized_new(1);
    fu_byte_array_set_size(st->buf, 1, 0x0);
    fu_struct_steelseries_sonic_wireless_status_req_set_opcode(st, FU_STEELSERIES_SONIC_OPCODE8_WIRELESS_STATUS);
    return st;
}
/**
 * fu_struct_steelseries_sonic_wireless_status_res_ref: (skip):
 **/
FuStructSteelseriesSonicWirelessStatusRes *
fu_struct_steelseries_sonic_wireless_status_res_ref(FuStructSteelseriesSonicWirelessStatusRes *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_steelseries_sonic_wireless_status_res_unref: (skip):
 **/
void
fu_struct_steelseries_sonic_wireless_status_res_unref(FuStructSteelseriesSonicWirelessStatusRes *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructSteelseriesSonicWirelessStatusRes refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_steelseries_sonic_wireless_status_res_new_internal: (skip):
 **/
static FuStructSteelseriesSonicWirelessStatusRes *
fu_struct_steelseries_sonic_wireless_status_res_new_internal(void)
{
    FuStructSteelseriesSonicWirelessStatusRes *st = g_new0(FuStructSteelseriesSonicWirelessStatusRes, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_steelseries_sonic_wireless_status_res_get_status: (skip):
 **/
FuSteelseriesSonicWirelessStatus
fu_struct_steelseries_sonic_wireless_status_res_get_status(const FuStructSteelseriesSonicWirelessStatusRes *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}

/* setters */
/**
 * fu_struct_steelseries_sonic_wireless_status_res_to_string: (skip):
 **/
static gchar *
fu_struct_steelseries_sonic_wireless_status_res_to_string(const FuStructSteelseriesSonicWirelessStatusRes *st)
{
    g_autoptr(GString) str = g_string_new("FuStructSteelseriesSonicWirelessStatusRes:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        const gchar *tmp = fu_steelseries_sonic_wireless_status_to_string(fu_struct_steelseries_sonic_wireless_status_res_get_status(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  status: 0x%x [%s]\n", (guint) fu_struct_steelseries_sonic_wireless_status_res_get_status(st), tmp);
        } else {
            g_string_append_printf(str, "  status: 0x%x\n", (guint) fu_struct_steelseries_sonic_wireless_status_res_get_status(st));
        }
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_steelseries_sonic_wireless_status_res_validate_internal(FuStructSteelseriesSonicWirelessStatusRes *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_steelseries_sonic_wireless_status_res_parse_internal(FuStructSteelseriesSonicWirelessStatusRes *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_steelseries_sonic_wireless_status_res_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_steelseries_sonic_wireless_status_res_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_steelseries_sonic_wireless_status_res_parse: (skip):
 **/
FuStructSteelseriesSonicWirelessStatusRes *
fu_struct_steelseries_sonic_wireless_status_res_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructSteelseriesSonicWirelessStatusRes) st = fu_struct_steelseries_sonic_wireless_status_res_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 1, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructSteelseriesSonicWirelessStatusRes: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 1);
    if (!fu_struct_steelseries_sonic_wireless_status_res_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_steelseries_sonic_battery_req_ref: (skip):
 **/
FuStructSteelseriesSonicBatteryReq *
fu_struct_steelseries_sonic_battery_req_ref(FuStructSteelseriesSonicBatteryReq *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_steelseries_sonic_battery_req_unref: (skip):
 **/
void
fu_struct_steelseries_sonic_battery_req_unref(FuStructSteelseriesSonicBatteryReq *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructSteelseriesSonicBatteryReq refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_steelseries_sonic_battery_req_new_internal: (skip):
 **/
static FuStructSteelseriesSonicBatteryReq *
fu_struct_steelseries_sonic_battery_req_new_internal(void)
{
    FuStructSteelseriesSonicBatteryReq *st = g_new0(FuStructSteelseriesSonicBatteryReq, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_steelseries_sonic_battery_req_set_opcode: (skip):
 **/
static void
fu_struct_steelseries_sonic_battery_req_set_opcode(FuStructSteelseriesSonicBatteryReq *st, FuSteelseriesSonicOpcode8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_steelseries_sonic_battery_req_set_bat_mode: (skip):
 **/
static void
fu_struct_steelseries_sonic_battery_req_set_bat_mode(FuStructSteelseriesSonicBatteryReq *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_steelseries_sonic_battery_req_new: (skip):
 **/
FuStructSteelseriesSonicBatteryReq *
fu_struct_steelseries_sonic_battery_req_new(void)
{
    FuStructSteelseriesSonicBatteryReq *st = fu_struct_steelseries_sonic_battery_req_new_internal();
    st->buf = g_byte_array_sized_new(2);
    fu_byte_array_set_size(st->buf, 2, 0x0);
    fu_struct_steelseries_sonic_battery_req_set_opcode(st, FU_STEELSERIES_SONIC_OPCODE8_BATTERY);
    fu_struct_steelseries_sonic_battery_req_set_bat_mode(st, 0x01);
    return st;
}
/**
 * fu_struct_steelseries_sonic_battery_res_ref: (skip):
 **/
FuStructSteelseriesSonicBatteryRes *
fu_struct_steelseries_sonic_battery_res_ref(FuStructSteelseriesSonicBatteryRes *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_steelseries_sonic_battery_res_unref: (skip):
 **/
void
fu_struct_steelseries_sonic_battery_res_unref(FuStructSteelseriesSonicBatteryRes *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructSteelseriesSonicBatteryRes refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_steelseries_sonic_battery_res_new_internal: (skip):
 **/
static FuStructSteelseriesSonicBatteryRes *
fu_struct_steelseries_sonic_battery_res_new_internal(void)
{
    FuStructSteelseriesSonicBatteryRes *st = g_new0(FuStructSteelseriesSonicBatteryRes, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_steelseries_sonic_battery_res_get_value: (skip):
 **/
guint16
fu_struct_steelseries_sonic_battery_res_get_value(const FuStructSteelseriesSonicBatteryRes *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 0, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_steelseries_sonic_battery_res_to_string: (skip):
 **/
static gchar *
fu_struct_steelseries_sonic_battery_res_to_string(const FuStructSteelseriesSonicBatteryRes *st)
{
    g_autoptr(GString) str = g_string_new("FuStructSteelseriesSonicBatteryRes:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  value: 0x%x\n",
                           (guint) fu_struct_steelseries_sonic_battery_res_get_value(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_steelseries_sonic_battery_res_validate_internal(FuStructSteelseriesSonicBatteryRes *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_steelseries_sonic_battery_res_parse_internal(FuStructSteelseriesSonicBatteryRes *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_steelseries_sonic_battery_res_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_steelseries_sonic_battery_res_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_steelseries_sonic_battery_res_parse: (skip):
 **/
FuStructSteelseriesSonicBatteryRes *
fu_struct_steelseries_sonic_battery_res_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructSteelseriesSonicBatteryRes) st = fu_struct_steelseries_sonic_battery_res_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 2, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructSteelseriesSonicBatteryRes: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 2);
    if (!fu_struct_steelseries_sonic_battery_res_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_steelseries_sonic_restart_req_ref: (skip):
 **/
FuStructSteelseriesSonicRestartReq *
fu_struct_steelseries_sonic_restart_req_ref(FuStructSteelseriesSonicRestartReq *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_steelseries_sonic_restart_req_unref: (skip):
 **/
void
fu_struct_steelseries_sonic_restart_req_unref(FuStructSteelseriesSonicRestartReq *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructSteelseriesSonicRestartReq refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_steelseries_sonic_restart_req_new_internal: (skip):
 **/
static FuStructSteelseriesSonicRestartReq *
fu_struct_steelseries_sonic_restart_req_new_internal(void)
{
    FuStructSteelseriesSonicRestartReq *st = g_new0(FuStructSteelseriesSonicRestartReq, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_steelseries_sonic_restart_req_set_opcode: (skip):
 **/
void
fu_struct_steelseries_sonic_restart_req_set_opcode(FuStructSteelseriesSonicRestartReq *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_steelseries_sonic_restart_req_new: (skip):
 **/
FuStructSteelseriesSonicRestartReq *
fu_struct_steelseries_sonic_restart_req_new(void)
{
    FuStructSteelseriesSonicRestartReq *st = fu_struct_steelseries_sonic_restart_req_new_internal();
    st->buf = g_byte_array_sized_new(2);
    fu_byte_array_set_size(st->buf, 2, 0x0);
    return st;
}
/**
 * fu_struct_steelseries_sonic_erase_req_ref: (skip):
 **/
FuStructSteelseriesSonicEraseReq *
fu_struct_steelseries_sonic_erase_req_ref(FuStructSteelseriesSonicEraseReq *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_steelseries_sonic_erase_req_unref: (skip):
 **/
void
fu_struct_steelseries_sonic_erase_req_unref(FuStructSteelseriesSonicEraseReq *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructSteelseriesSonicEraseReq refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_steelseries_sonic_erase_req_new_internal: (skip):
 **/
static FuStructSteelseriesSonicEraseReq *
fu_struct_steelseries_sonic_erase_req_new_internal(void)
{
    FuStructSteelseriesSonicEraseReq *st = g_new0(FuStructSteelseriesSonicEraseReq, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_steelseries_sonic_erase_req_set_opcode: (skip):
 **/
void
fu_struct_steelseries_sonic_erase_req_set_opcode(FuStructSteelseriesSonicEraseReq *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_steelseries_sonic_erase_req_set_chipid: (skip):
 **/
void
fu_struct_steelseries_sonic_erase_req_set_chipid(FuStructSteelseriesSonicEraseReq *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 2, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_steelseries_sonic_erase_req_new: (skip):
 **/
FuStructSteelseriesSonicEraseReq *
fu_struct_steelseries_sonic_erase_req_new(void)
{
    FuStructSteelseriesSonicEraseReq *st = fu_struct_steelseries_sonic_erase_req_new_internal();
    st->buf = g_byte_array_sized_new(4);
    fu_byte_array_set_size(st->buf, 4, 0x0);
    return st;
}
/**
 * fu_struct_steelseries_sonic_read_from_ram_req_ref: (skip):
 **/
FuStructSteelseriesSonicReadFromRamReq *
fu_struct_steelseries_sonic_read_from_ram_req_ref(FuStructSteelseriesSonicReadFromRamReq *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_steelseries_sonic_read_from_ram_req_unref: (skip):
 **/
void
fu_struct_steelseries_sonic_read_from_ram_req_unref(FuStructSteelseriesSonicReadFromRamReq *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructSteelseriesSonicReadFromRamReq refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_steelseries_sonic_read_from_ram_req_new_internal: (skip):
 **/
static FuStructSteelseriesSonicReadFromRamReq *
fu_struct_steelseries_sonic_read_from_ram_req_new_internal(void)
{
    FuStructSteelseriesSonicReadFromRamReq *st = g_new0(FuStructSteelseriesSonicReadFromRamReq, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_steelseries_sonic_read_from_ram_req_set_opcode: (skip):
 **/
void
fu_struct_steelseries_sonic_read_from_ram_req_set_opcode(FuStructSteelseriesSonicReadFromRamReq *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_steelseries_sonic_read_from_ram_req_set_offset: (skip):
 **/
void
fu_struct_steelseries_sonic_read_from_ram_req_set_offset(FuStructSteelseriesSonicReadFromRamReq *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 2, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_steelseries_sonic_read_from_ram_req_set_size: (skip):
 **/
void
fu_struct_steelseries_sonic_read_from_ram_req_set_size(FuStructSteelseriesSonicReadFromRamReq *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_steelseries_sonic_read_from_ram_req_new: (skip):
 **/
FuStructSteelseriesSonicReadFromRamReq *
fu_struct_steelseries_sonic_read_from_ram_req_new(void)
{
    FuStructSteelseriesSonicReadFromRamReq *st = fu_struct_steelseries_sonic_read_from_ram_req_new_internal();
    st->buf = g_byte_array_sized_new(6);
    fu_byte_array_set_size(st->buf, 6, 0x0);
    return st;
}
/**
 * fu_struct_steelseries_sonic_read_from_ram_res_ref: (skip):
 **/
FuStructSteelseriesSonicReadFromRamRes *
fu_struct_steelseries_sonic_read_from_ram_res_ref(FuStructSteelseriesSonicReadFromRamRes *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_steelseries_sonic_read_from_ram_res_unref: (skip):
 **/
void
fu_struct_steelseries_sonic_read_from_ram_res_unref(FuStructSteelseriesSonicReadFromRamRes *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructSteelseriesSonicReadFromRamRes refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_steelseries_sonic_read_from_ram_res_new_internal: (skip):
 **/
static FuStructSteelseriesSonicReadFromRamRes *
fu_struct_steelseries_sonic_read_from_ram_res_new_internal(void)
{
    FuStructSteelseriesSonicReadFromRamRes *st = g_new0(FuStructSteelseriesSonicReadFromRamRes, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_steelseries_sonic_read_from_ram_res_get_data: (skip):
 **/
const guint8 *
fu_struct_steelseries_sonic_read_from_ram_res_get_data(const FuStructSteelseriesSonicReadFromRamRes *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 48;
    return st->buf->data + 0;
}

/* setters */
/**
 * fu_struct_steelseries_sonic_read_from_ram_res_to_string: (skip):
 **/
static gchar *
fu_struct_steelseries_sonic_read_from_ram_res_to_string(const FuStructSteelseriesSonicReadFromRamRes *st)
{
    g_autoptr(GString) str = g_string_new("FuStructSteelseriesSonicReadFromRamRes:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        gsize bufsz = 0;
        const guint8 *buf = fu_struct_steelseries_sonic_read_from_ram_res_get_data(st, &bufsz);
        g_autoptr(GString) tmp = g_string_new(NULL);
        for (gsize i = 0; i < bufsz; i++)
            g_string_append_printf(tmp, "%02X", buf[i]);
        g_string_append_printf(str, "  data: 0x%s\n", tmp->str);
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_steelseries_sonic_read_from_ram_res_validate_internal(FuStructSteelseriesSonicReadFromRamRes *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_steelseries_sonic_read_from_ram_res_parse_internal(FuStructSteelseriesSonicReadFromRamRes *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_steelseries_sonic_read_from_ram_res_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_steelseries_sonic_read_from_ram_res_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_steelseries_sonic_read_from_ram_res_parse: (skip):
 **/
FuStructSteelseriesSonicReadFromRamRes *
fu_struct_steelseries_sonic_read_from_ram_res_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructSteelseriesSonicReadFromRamRes) st = fu_struct_steelseries_sonic_read_from_ram_res_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 48, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructSteelseriesSonicReadFromRamRes: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 48);
    if (!fu_struct_steelseries_sonic_read_from_ram_res_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_steelseries_sonic_read_from_flash_req_ref: (skip):
 **/
FuStructSteelseriesSonicReadFromFlashReq *
fu_struct_steelseries_sonic_read_from_flash_req_ref(FuStructSteelseriesSonicReadFromFlashReq *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_steelseries_sonic_read_from_flash_req_unref: (skip):
 **/
void
fu_struct_steelseries_sonic_read_from_flash_req_unref(FuStructSteelseriesSonicReadFromFlashReq *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructSteelseriesSonicReadFromFlashReq refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_steelseries_sonic_read_from_flash_req_new_internal: (skip):
 **/
static FuStructSteelseriesSonicReadFromFlashReq *
fu_struct_steelseries_sonic_read_from_flash_req_new_internal(void)
{
    FuStructSteelseriesSonicReadFromFlashReq *st = g_new0(FuStructSteelseriesSonicReadFromFlashReq, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_steelseries_sonic_read_from_flash_req_set_opcode: (skip):
 **/
void
fu_struct_steelseries_sonic_read_from_flash_req_set_opcode(FuStructSteelseriesSonicReadFromFlashReq *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_steelseries_sonic_read_from_flash_req_set_chipid: (skip):
 **/
void
fu_struct_steelseries_sonic_read_from_flash_req_set_chipid(FuStructSteelseriesSonicReadFromFlashReq *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 2, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_steelseries_sonic_read_from_flash_req_set_offset: (skip):
 **/
void
fu_struct_steelseries_sonic_read_from_flash_req_set_offset(FuStructSteelseriesSonicReadFromFlashReq *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_steelseries_sonic_read_from_flash_req_set_size: (skip):
 **/
void
fu_struct_steelseries_sonic_read_from_flash_req_set_size(FuStructSteelseriesSonicReadFromFlashReq *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 8, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_steelseries_sonic_read_from_flash_req_new: (skip):
 **/
FuStructSteelseriesSonicReadFromFlashReq *
fu_struct_steelseries_sonic_read_from_flash_req_new(void)
{
    FuStructSteelseriesSonicReadFromFlashReq *st = fu_struct_steelseries_sonic_read_from_flash_req_new_internal();
    st->buf = g_byte_array_sized_new(10);
    fu_byte_array_set_size(st->buf, 10, 0x0);
    return st;
}
/**
 * fu_struct_steelseries_sonic_write_to_ram_req_ref: (skip):
 **/
FuStructSteelseriesSonicWriteToRamReq *
fu_struct_steelseries_sonic_write_to_ram_req_ref(FuStructSteelseriesSonicWriteToRamReq *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_steelseries_sonic_write_to_ram_req_unref: (skip):
 **/
void
fu_struct_steelseries_sonic_write_to_ram_req_unref(FuStructSteelseriesSonicWriteToRamReq *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructSteelseriesSonicWriteToRamReq refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_steelseries_sonic_write_to_ram_req_new_internal: (skip):
 **/
static FuStructSteelseriesSonicWriteToRamReq *
fu_struct_steelseries_sonic_write_to_ram_req_new_internal(void)
{
    FuStructSteelseriesSonicWriteToRamReq *st = g_new0(FuStructSteelseriesSonicWriteToRamReq, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_steelseries_sonic_write_to_ram_req_set_opcode: (skip):
 **/
void
fu_struct_steelseries_sonic_write_to_ram_req_set_opcode(FuStructSteelseriesSonicWriteToRamReq *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_steelseries_sonic_write_to_ram_req_set_offset: (skip):
 **/
void
fu_struct_steelseries_sonic_write_to_ram_req_set_offset(FuStructSteelseriesSonicWriteToRamReq *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 2, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_steelseries_sonic_write_to_ram_req_set_size: (skip):
 **/
void
fu_struct_steelseries_sonic_write_to_ram_req_set_size(FuStructSteelseriesSonicWriteToRamReq *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_steelseries_sonic_write_to_ram_req_set_data: (skip):
 **/
gboolean
fu_struct_steelseries_sonic_write_to_ram_req_set_data(FuStructSteelseriesSonicWriteToRamReq *st, const guint8 *buf, gsize bufsz, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    return fu_memcpy_safe(st->buf->data, st->buf->len, 6, buf, bufsz, 0x0, bufsz, error);
}
/**
 * fu_struct_steelseries_sonic_write_to_ram_req_new: (skip):
 **/
FuStructSteelseriesSonicWriteToRamReq *
fu_struct_steelseries_sonic_write_to_ram_req_new(void)
{
    FuStructSteelseriesSonicWriteToRamReq *st = fu_struct_steelseries_sonic_write_to_ram_req_new_internal();
    st->buf = g_byte_array_sized_new(54);
    fu_byte_array_set_size(st->buf, 54, 0x0);
    return st;
}
/**
 * fu_struct_steelseries_sonic_write_to_flash_req_ref: (skip):
 **/
FuStructSteelseriesSonicWriteToFlashReq *
fu_struct_steelseries_sonic_write_to_flash_req_ref(FuStructSteelseriesSonicWriteToFlashReq *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_steelseries_sonic_write_to_flash_req_unref: (skip):
 **/
void
fu_struct_steelseries_sonic_write_to_flash_req_unref(FuStructSteelseriesSonicWriteToFlashReq *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructSteelseriesSonicWriteToFlashReq refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_steelseries_sonic_write_to_flash_req_new_internal: (skip):
 **/
static FuStructSteelseriesSonicWriteToFlashReq *
fu_struct_steelseries_sonic_write_to_flash_req_new_internal(void)
{
    FuStructSteelseriesSonicWriteToFlashReq *st = g_new0(FuStructSteelseriesSonicWriteToFlashReq, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_steelseries_sonic_write_to_flash_req_set_opcode: (skip):
 **/
void
fu_struct_steelseries_sonic_write_to_flash_req_set_opcode(FuStructSteelseriesSonicWriteToFlashReq *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_steelseries_sonic_write_to_flash_req_set_chipid: (skip):
 **/
void
fu_struct_steelseries_sonic_write_to_flash_req_set_chipid(FuStructSteelseriesSonicWriteToFlashReq *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 2, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_steelseries_sonic_write_to_flash_req_set_offset: (skip):
 **/
void
fu_struct_steelseries_sonic_write_to_flash_req_set_offset(FuStructSteelseriesSonicWriteToFlashReq *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_steelseries_sonic_write_to_flash_req_set_size: (skip):
 **/
void
fu_struct_steelseries_sonic_write_to_flash_req_set_size(FuStructSteelseriesSonicWriteToFlashReq *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 8, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_steelseries_sonic_write_to_flash_req_new: (skip):
 **/
FuStructSteelseriesSonicWriteToFlashReq *
fu_struct_steelseries_sonic_write_to_flash_req_new(void)
{
    FuStructSteelseriesSonicWriteToFlashReq *st = fu_struct_steelseries_sonic_write_to_flash_req_new_internal();
    st->buf = g_byte_array_sized_new(10);
    fu_byte_array_set_size(st->buf, 10, 0x0);
    return st;
}
