static const char* threshold_cl_source =
"__kernel void gegl_threshold (__global const float2     *in,                  \n"
"                              __global const float      *aux,                 \n"
"                              __global       float2     *out,                 \n"
"                                       const float       value,               \n"
"                                       const float       high)                \n"
"{                                                                             \n"
"  int gid = get_global_id(0);                                                 \n"
"  float2 in_v  = in [gid];                                                    \n"
"  float2 out_v;                                                               \n"
"                                                                              \n"
"  if (! aux)                                                                  \n"
"    {                                                                         \n"
"      out_v.x  = (in_v.x >= value && in_v.x <= high)? 1.0 : 0.0;              \n"
"      out_v.y  = in_v.y;                                                      \n"
"      out[gid] = out_v;                                                       \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      float level_low  = aux[gid];                                            \n"
"      float level_high = level_low;                                           \n"
"                                                                              \n"
"      if (value <= 0.5)                                                       \n"
"        {                                                                     \n"
"          float t = 1.0-((value)/0.5);                                        \n"
"          level_low = 0.0 * t + level_low * (1.0-t);                          \n"
"        }                                                                     \n"
"      else                                                                    \n"
"        {                                                                     \n"
"          float t = 1.0-((1.0-value)/0.5);                                    \n"
"          level_low = 1.0* t + level_low * (1.0-t);                           \n"
"        }                                                                     \n"
"      if (high <= 0.5)                                                        \n"
"        {                                                                     \n"
"          float t = 1.0-((high)/0.5);                                         \n"
"          level_high = 0.0 * t + level_high * (1.0-t);                        \n"
"        }                                                                     \n"
"      else                                                                    \n"
"        {                                                                     \n"
"          float t = 1.0-((1.0-high)/0.5);                                     \n"
"          level_high = 1.0* t + level_high * (1.0-t);                         \n"
"        }                                                                     \n"
"                                                                              \n"
"      out_v.x = (in_v.x >= level_low && in_v.x <= level_high)? 1.0 : 0.0;     \n"
"      out_v.y  = in_v.y;                                                      \n"
"      out[gid] = out_v;                                                       \n"
"    }                                                                         \n"
"}                                                                             \n"
;
