/* gitg-ref-action-push.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from gitg-ref-action-push.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2017 - Ignazio Sgalmuzzo
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include "libgitg-ext.h"
#include "libgitg.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "config.h"
#include <libgit2-glib/ggit.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <gtk/gtk.h>
#include <stdio.h>

#define GITG_REF_ACTION_PUSH_version VERSION
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GITG_TYPE_REF_ACTION_PUSH (gitg_ref_action_push_get_type ())
#define GITG_REF_ACTION_PUSH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_REF_ACTION_PUSH, GitgRefActionPush))
#define GITG_REF_ACTION_PUSH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_REF_ACTION_PUSH, GitgRefActionPushClass))
#define GITG_IS_REF_ACTION_PUSH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_REF_ACTION_PUSH))
#define GITG_IS_REF_ACTION_PUSH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_REF_ACTION_PUSH))
#define GITG_REF_ACTION_PUSH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_REF_ACTION_PUSH, GitgRefActionPushClass))

typedef struct _GitgRefActionPush GitgRefActionPush;
typedef struct _GitgRefActionPushClass GitgRefActionPushClass;
typedef struct _GitgRefActionPushPrivate GitgRefActionPushPrivate;
enum  {
	GITG_REF_ACTION_PUSH_0_PROPERTY,
	GITG_REF_ACTION_PUSH_APPLICATION_PROPERTY,
	GITG_REF_ACTION_PUSH_ACTION_INTERFACE_PROPERTY,
	GITG_REF_ACTION_PUSH_REFERENCE_PROPERTY,
	GITG_REF_ACTION_PUSH_ID_PROPERTY,
	GITG_REF_ACTION_PUSH_DISPLAY_NAME_PROPERTY,
	GITG_REF_ACTION_PUSH_DESCRIPTION_PROPERTY,
	GITG_REF_ACTION_PUSH_AVAILABLE_PROPERTY,
	GITG_REF_ACTION_PUSH_NUM_PROPERTIES
};
static GParamSpec* gitg_ref_action_push_properties[GITG_REF_ACTION_PUSH_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define GITG_TYPE_REMOTE_NOTIFICATION (gitg_remote_notification_get_type ())
#define GITG_REMOTE_NOTIFICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_REMOTE_NOTIFICATION, GitgRemoteNotification))
#define GITG_REMOTE_NOTIFICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_REMOTE_NOTIFICATION, GitgRemoteNotificationClass))
#define GITG_IS_REMOTE_NOTIFICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_REMOTE_NOTIFICATION))
#define GITG_IS_REMOTE_NOTIFICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_REMOTE_NOTIFICATION))
#define GITG_REMOTE_NOTIFICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_REMOTE_NOTIFICATION, GitgRemoteNotificationClass))

typedef struct _GitgRemoteNotification GitgRemoteNotification;
typedef struct _GitgRemoteNotificationClass GitgRemoteNotificationClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GitgRefActionPushPushData GitgRefActionPushPushData;

struct _GitgRefActionPush {
	GObject parent_instance;
	GitgRefActionPushPrivate * priv;
};

struct _GitgRefActionPushClass {
	GObjectClass parent_class;
};

struct _GitgRefActionPushPrivate {
	GitgExtApplication* _application;
	GitgExtRefActionInterface* _action_interface;
	GitgRef* _reference;
	GitgRef* d_remote_ref;
	GitgRemote* d_remote;
};

struct _GitgRefActionPushPushData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GitgRefActionPush* self;
	gchar* branch;
	gboolean result;
	GitgRemoteNotification* notification;
	GitgRemote* _tmp0_;
	GitgRemoteNotification* _tmp1_;
	GitgExtApplication* _tmp2_;
	GitgExtApplication* _tmp3_;
	GitgExtApplication* _tmp4_;
	GitgExtNotifications* _tmp5_;
	GitgExtNotifications* _tmp6_;
	GitgExtNotifications* _tmp7_;
	GitgRemoteNotification* _tmp8_;
	GitgRemoteNotification* _tmp9_;
	GitgRemote* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	GitgRemote* _tmp14_;
	GitgExtApplication* _tmp15_;
	GitgExtApplication* _tmp16_;
	GtkApplicationWindow* _tmp17_;
	GError* e;
	GitgRemoteNotification* _tmp18_;
	GitgRemote* _tmp19_;
	const gchar* _tmp20_;
	GError* _tmp21_;
	const gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	FILE* _tmp25_;
	GError* _tmp26_;
	const gchar* _tmp27_;
	GitgRemoteNotification* _tmp28_;
	GitgRemote* _tmp29_;
	const gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	GError* _inner_error0_;
};

static gint GitgRefActionPush_private_offset;
static gpointer gitg_ref_action_push_parent_class = NULL;
static GitgExtUIElementIface * gitg_ref_action_push_gitg_ext_ui_element_parent_iface = NULL;
static GitgExtActionIface * gitg_ref_action_push_gitg_ext_action_parent_iface = NULL;
static GitgExtRefActionIface * gitg_ref_action_push_gitg_ext_ref_action_parent_iface = NULL;

VALA_EXTERN GType gitg_ref_action_push_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GitgRefActionPush, g_object_unref)
VALA_EXTERN GitgRefActionPush* gitg_ref_action_push_new (GitgExtApplication* application,
                                             GitgExtRefActionInterface* action_interface,
                                             GitgRef* reference);
VALA_EXTERN GitgRefActionPush* gitg_ref_action_push_construct (GType object_type,
                                                   GitgExtApplication* application,
                                                   GitgExtRefActionInterface* action_interface,
                                                   GitgRef* reference);
static void gitg_ref_action_push_push_data_free (gpointer _data);
VALA_EXTERN void gitg_ref_action_push_push (GitgRefActionPush* self,
                                const gchar* branch,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_);
VALA_EXTERN gboolean gitg_ref_action_push_push_finish (GitgRefActionPush* self,
                                           GAsyncResult* _res_);
static gboolean gitg_ref_action_push_push_co (GitgRefActionPushPushData* _data_);
VALA_EXTERN GType gitg_remote_notification_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GitgRemoteNotification, g_object_unref)
VALA_EXTERN GitgRemoteNotification* gitg_remote_notification_new (GitgRemote* remote);
VALA_EXTERN GitgRemoteNotification* gitg_remote_notification_construct (GType object_type,
                                                            GitgRemote* remote);
VALA_EXTERN void gitg_remote_notification_set_text (GitgRemoteNotification* self,
                                        const gchar* value);
static void gitg_ref_action_push_push_ready (GObject* source_object,
                                      GAsyncResult* _res_,
                                      gpointer _user_data_);
VALA_EXTERN void gitg_remote_notification_error (GitgRemoteNotification* self,
                                     const gchar* text);
VALA_EXTERN void gitg_remote_notification_success (GitgRemoteNotification* self,
                                       const gchar* text);
static void gitg_ref_action_push_real_activate (GitgExtUIElement* base);
static gboolean gitg_ref_action_push_on_response (GitgRefActionPush* self,
                                           GtkResponseType response);
static gboolean _gitg_ref_action_push_on_response_gitg_ext_user_query_response (GitgExtUserQuery* _sender,
                                                                         GtkResponseType response_type,
                                                                         gpointer self);
static void __lambda124_ (GitgRefActionPush* self,
                   GObject* obj,
                   GAsyncResult* res);
static void ___lambda124__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static void gitg_ref_action_push_finalize (GObject * obj);
static GType gitg_ref_action_push_get_type_once (void);
static void _vala_gitg_ref_action_push_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_gitg_ref_action_push_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
gitg_ref_action_push_get_instance_private (GitgRefActionPush* self)
{
	return G_STRUCT_MEMBER_P (self, GitgRefActionPush_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GitgRefActionPush*
gitg_ref_action_push_construct (GType object_type,
                                GitgExtApplication* application,
                                GitgExtRefActionInterface* action_interface,
                                GitgRef* reference)
{
	GitgRefActionPush * self = NULL;
	GgitBranch* branch = NULL;
	GgitBranch* _tmp0_;
	GgitBranch* _tmp1_;
	GitgRef* _tmp14_;
	GitgRemote* _tmp26_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (application != NULL, NULL);
	g_return_val_if_fail (action_interface != NULL, NULL);
	g_return_val_if_fail (reference != NULL, NULL);
	self = (GitgRefActionPush*) g_object_new (object_type, "application", application, "action-interface", action_interface, "reference", reference, NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (reference, ggit_branch_get_type ()) ? ((GgitBranch*) reference) : NULL);
	branch = _tmp0_;
	_tmp1_ = branch;
	if (_tmp1_ != NULL) {
		{
			GgitRef* _tmp2_ = NULL;
			GgitBranch* _tmp3_;
			GgitRef* _tmp4_;
			GitgRef* _tmp5_;
			_tmp3_ = branch;
			_tmp4_ = ggit_branch_get_upstream (_tmp3_, &_inner_error0_);
			_tmp2_ = _tmp4_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, GITG_TYPE_REF) ? ((GitgRef*) _tmp2_) : NULL);
			_g_object_unref0 (self->priv->d_remote_ref);
			self->priv->d_remote_ref = _tmp5_;
			_g_object_unref0 (_tmp2_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			g_clear_error (&_inner_error0_);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (branch);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	} else {
		GitgParsedRefName* _tmp6_;
		GitgParsedRefName* _tmp7_;
		GitgParsedRefName* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gboolean _tmp12_;
		_tmp6_ = gitg_ref_get_parsed_name (reference);
		_tmp7_ = _tmp6_;
		_tmp8_ = _tmp7_;
		_tmp9_ = gitg_parsed_ref_name_get_remote_name (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = _tmp10_;
		_tmp12_ = _tmp11_ != NULL;
		_g_free0 (_tmp11_);
		_g_object_unref0 (_tmp8_);
		if (_tmp12_) {
			GitgRef* _tmp13_;
			_tmp13_ = _g_object_ref0 (reference);
			_g_object_unref0 (self->priv->d_remote_ref);
			self->priv->d_remote_ref = _tmp13_;
		}
	}
	_tmp14_ = self->priv->d_remote_ref;
	if (_tmp14_ != NULL) {
		GitgExtRemoteLookup* _tmp15_;
		GitgExtRemoteLookup* _tmp16_;
		GitgExtRemoteLookup* _tmp17_;
		GitgRef* _tmp18_;
		GitgParsedRefName* _tmp19_;
		GitgParsedRefName* _tmp20_;
		GitgParsedRefName* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		GitgRemote* _tmp25_;
		_tmp15_ = gitg_ext_application_get_remote_lookup (application);
		_tmp16_ = _tmp15_;
		_tmp17_ = _tmp16_;
		_tmp18_ = self->priv->d_remote_ref;
		_tmp19_ = gitg_ref_get_parsed_name (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = _tmp20_;
		_tmp22_ = gitg_parsed_ref_name_get_remote_name (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = _tmp23_;
		_tmp25_ = gitg_ext_remote_lookup_lookup (_tmp17_, _tmp24_);
		_g_object_unref0 (self->priv->d_remote);
		self->priv->d_remote = _tmp25_;
		_g_free0 (_tmp24_);
		_g_object_unref0 (_tmp21_);
		_g_object_unref0 (_tmp17_);
	}
	_tmp26_ = self->priv->d_remote;
	if (_tmp26_ == NULL) {
		GitgExtRemoteLookup* _tmp27_;
		GitgExtRemoteLookup* _tmp28_;
		GitgExtRemoteLookup* _tmp29_;
		GitgRemote* _tmp30_;
		_tmp27_ = gitg_ext_application_get_remote_lookup (application);
		_tmp28_ = _tmp27_;
		_tmp29_ = _tmp28_;
		_tmp30_ = gitg_ext_remote_lookup_lookup (_tmp29_, "origin");
		_g_object_unref0 (self->priv->d_remote);
		self->priv->d_remote = _tmp30_;
		_g_object_unref0 (_tmp29_);
	}
	_g_object_unref0 (branch);
	return self;
}

GitgRefActionPush*
gitg_ref_action_push_new (GitgExtApplication* application,
                          GitgExtRefActionInterface* action_interface,
                          GitgRef* reference)
{
	return gitg_ref_action_push_construct (GITG_TYPE_REF_ACTION_PUSH, application, action_interface, reference);
}

static void
gitg_ref_action_push_push_data_free (gpointer _data)
{
	GitgRefActionPushPushData* _data_;
	_data_ = _data;
	_g_free0 (_data_->branch);
	_g_object_unref0 (_data_->self);
	g_slice_free (GitgRefActionPushPushData, _data_);
}

void
gitg_ref_action_push_push (GitgRefActionPush* self,
                           const gchar* branch,
                           GAsyncReadyCallback _callback_,
                           gpointer _user_data_)
{
	GitgRefActionPushPushData* _data_;
	GitgRefActionPush* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (branch != NULL);
	_data_ = g_slice_new0 (GitgRefActionPushPushData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gitg_ref_action_push_push_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (branch);
	_g_free0 (_data_->branch);
	_data_->branch = _tmp1_;
	gitg_ref_action_push_push_co (_data_);
}

gboolean
gitg_ref_action_push_push_finish (GitgRefActionPush* self,
                                  GAsyncResult* _res_)
{
	gboolean result;
	GitgRefActionPushPushData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

static void
gitg_ref_action_push_push_ready (GObject* source_object,
                                 GAsyncResult* _res_,
                                 gpointer _user_data_)
{
	GitgRefActionPushPushData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gitg_ref_action_push_push_co (_data_);
}

static gboolean
gitg_ref_action_push_push_co (GitgRefActionPushPushData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->d_remote;
	_data_->_tmp1_ = gitg_remote_notification_new (_data_->_tmp0_);
	g_object_ref_sink (_data_->_tmp1_);
	_data_->notification = _data_->_tmp1_;
	_data_->_tmp2_ = gitg_ext_ui_element_get_application ((GitgExtUIElement*) _data_->self);
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_tmp5_ = gitg_ext_application_get_notifications (_data_->_tmp4_);
	_data_->_tmp6_ = _data_->_tmp5_;
	_data_->_tmp7_ = _data_->_tmp6_;
	_data_->_tmp8_ = _data_->notification;
	gitg_ext_notifications_add (_data_->_tmp7_, (GitgExtNotification*) _data_->_tmp8_);
	_g_object_unref0 (_data_->_tmp7_);
	_g_object_unref0 (_data_->_tmp4_);
	_data_->_tmp9_ = _data_->notification;
	_data_->_tmp10_ = _data_->self->priv->d_remote;
	_data_->_tmp11_ = ggit_remote_get_url ((GgitRemote*) _data_->_tmp10_);
	_data_->_tmp12_ = g_strdup_printf (_ ("Pushing to %s"), _data_->_tmp11_);
	_data_->_tmp13_ = _data_->_tmp12_;
	gitg_remote_notification_set_text (_data_->_tmp9_, _data_->_tmp13_);
	_g_free0 (_data_->_tmp13_);
	{
		_data_->_tmp14_ = _data_->self->priv->d_remote;
		_data_->_state_ = 1;
		gitg_remote_push (_data_->_tmp14_, _data_->branch, NULL, gitg_ref_action_push_push_ready, _data_);
		return FALSE;
		_state_1:
		gitg_remote_push_finish (_data_->_tmp14_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp15_ = gitg_ext_ui_element_get_application ((GitgExtUIElement*) _data_->self);
		_data_->_tmp16_ = _data_->_tmp15_;
		_data_->_tmp17_ = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp16_, gtk_application_window_get_type (), GtkApplicationWindow);
		g_action_group_activate_action ((GActionGroup*) _data_->_tmp17_, "reload", NULL);
		_g_object_unref0 (_data_->_tmp17_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp18_ = _data_->notification;
		_data_->_tmp19_ = _data_->self->priv->d_remote;
		_data_->_tmp20_ = ggit_remote_get_url ((GgitRemote*) _data_->_tmp19_);
		_data_->_tmp21_ = _data_->e;
		_data_->_tmp22_ = _data_->_tmp21_->message;
		_data_->_tmp23_ = g_strdup_printf (_ ("Failed to push to %s: %s"), _data_->_tmp20_, _data_->_tmp22_);
		_data_->_tmp24_ = _data_->_tmp23_;
		gitg_remote_notification_error (_data_->_tmp18_, _data_->_tmp24_);
		_g_free0 (_data_->_tmp24_);
		_data_->_tmp25_ = stderr;
		_data_->_tmp26_ = _data_->e;
		_data_->_tmp27_ = _data_->_tmp26_->message;
		fprintf (_data_->_tmp25_, "Failed to push: %s\n", _data_->_tmp27_);
		_data_->result = FALSE;
		_g_error_free0 (_data_->e);
		_g_object_unref0 (_data_->notification);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->notification);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp28_ = _data_->notification;
	_data_->_tmp29_ = _data_->self->priv->d_remote;
	_data_->_tmp30_ = ggit_remote_get_url ((GgitRemote*) _data_->_tmp29_);
	_data_->_tmp31_ = g_strdup_printf (_ ("Pushed to %s"), _data_->_tmp30_);
	_data_->_tmp32_ = _data_->_tmp31_;
	gitg_remote_notification_success (_data_->_tmp28_, _data_->_tmp32_);
	_g_free0 (_data_->_tmp32_);
	_data_->result = TRUE;
	_g_object_unref0 (_data_->notification);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gboolean
_gitg_ref_action_push_on_response_gitg_ext_user_query_response (GitgExtUserQuery* _sender,
                                                                GtkResponseType response_type,
                                                                gpointer self)
{
	gboolean result;
	result = gitg_ref_action_push_on_response ((GitgRefActionPush*) self, response_type);
	return result;
}

static void
gitg_ref_action_push_real_activate (GitgExtUIElement* base)
{
	GitgRefActionPush * self;
	GitgExtUserQuery* query = NULL;
	GitgExtUserQuery* _tmp0_;
	gchar* branch_name = NULL;
	GitgRef* _tmp1_;
	GitgRef* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GitgExtUserQueryResponse* _tmp9_;
	GitgExtUserQueryResponse* _tmp10_;
	GitgExtUserQueryResponse** _tmp11_;
	GitgExtUserQueryResponse** _tmp12_;
	gint _tmp12__length1;
	GitgExtRefActionInterface* _tmp13_;
	GitgExtRefActionInterface* _tmp14_;
	GitgExtApplication* _tmp15_;
	GitgExtApplication* _tmp16_;
	GitgExtApplication* _tmp17_;
	self = (GitgRefActionPush*) base;
	_tmp0_ = gitg_ext_user_query_new ();
	query = _tmp0_;
	_tmp1_ = gitg_ext_ref_action_get_reference ((GitgExtRefAction*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = ggit_ref_get_shorthand ((GgitRef*) _tmp2_);
	_tmp4_ = g_strdup (_tmp3_);
	branch_name = _tmp4_;
	_tmp5_ = g_strdup_printf (_ ("Push branch %s"), branch_name);
	_tmp6_ = _tmp5_;
	gitg_ext_user_query_set_title (query, _tmp6_);
	_g_free0 (_tmp6_);
	_tmp7_ = g_strdup_printf (_ ("Are you sure that you want to push the branch %s?"), branch_name);
	_tmp8_ = _tmp7_;
	gitg_ext_user_query_set_message (query, _tmp8_);
	_g_free0 (_tmp8_);
	_tmp9_ = gitg_ext_user_query_response_new (_ ("Cancel"), GTK_RESPONSE_CANCEL);
	_tmp10_ = gitg_ext_user_query_response_new (_ ("Push"), GTK_RESPONSE_OK);
	_tmp11_ = g_new0 (GitgExtUserQueryResponse*, 2 + 1);
	_tmp11_[0] = _tmp9_;
	_tmp11_[1] = _tmp10_;
	_tmp12_ = _tmp11_;
	_tmp12__length1 = 2;
	gitg_ext_user_query_set_responses (query, _tmp12_, (gint) 2);
	_tmp12_ = (_vala_array_free (_tmp12_, _tmp12__length1, (GDestroyNotify) g_object_unref), NULL);
	gitg_ext_user_query_set_default_response (query, GTK_RESPONSE_OK);
	g_signal_connect_object (query, "response", (GCallback) _gitg_ref_action_push_on_response_gitg_ext_user_query_response, self, 0);
	_tmp13_ = gitg_ext_ref_action_get_action_interface ((GitgExtRefAction*) self);
	_tmp14_ = _tmp13_;
	_tmp15_ = gitg_ext_ref_action_interface_get_application (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = _tmp16_;
	gitg_ext_application_user_query (_tmp17_, query);
	_g_object_unref0 (_tmp17_);
	_g_free0 (branch_name);
	_g_object_unref0 (query);
}

static void
__lambda124_ (GitgRefActionPush* self,
              GObject* obj,
              GAsyncResult* res)
{
	g_return_if_fail (res != NULL);
	gitg_ref_action_push_push_finish (self, res);
}

static void
___lambda124__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	__lambda124_ ((GitgRefActionPush*) self, source_object, res);
	g_object_unref (self);
}

static gboolean
gitg_ref_action_push_on_response (GitgRefActionPush* self,
                                  GtkResponseType response)
{
	gchar* branch_name = NULL;
	GitgRef* _tmp0_;
	GitgRef* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	GitgBranch* branch = NULL;
	GitgRef* _tmp4_;
	GitgRef* _tmp5_;
	GitgBranch* _tmp6_;
	const gchar* _tmp13_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (response != GTK_RESPONSE_OK) {
		result = TRUE;
		return result;
	}
	_tmp0_ = gitg_ext_ref_action_get_reference ((GitgExtRefAction*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = ggit_ref_get_shorthand ((GgitRef*) _tmp1_);
	_tmp3_ = g_strdup (_tmp2_);
	branch_name = _tmp3_;
	_tmp4_ = gitg_ext_ref_action_get_reference ((GitgExtRefAction*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, GITG_TYPE_BRANCH) ? ((GitgBranch*) _tmp5_) : NULL);
	branch = _tmp6_;
	{
		GitgRef* _tmp7_ = NULL;
		GitgBranch* _tmp8_;
		GitgRef* _tmp9_;
		_tmp8_ = branch;
		_tmp9_ = gitg_branch_get_upstream (_tmp8_, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		if (_tmp7_ == NULL) {
			GitgBranch* _tmp10_;
			const gchar* _tmp11_;
			_tmp10_ = branch;
			_tmp11_ = branch_name;
			ggit_branch_set_upstream ((GgitBranch*) _tmp10_, _tmp11_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (_tmp7_);
				goto __catch0_g_error;
			}
		}
		_g_object_unref0 (_tmp7_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp12_ = FALSE;
		_g_object_unref0 (branch);
		_g_free0 (branch_name);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp12_;
	}
	_tmp13_ = branch_name;
	gitg_ref_action_push_push (self, _tmp13_, ___lambda124__gasync_ready_callback, g_object_ref (self));
	result = TRUE;
	_g_object_unref0 (branch);
	_g_free0 (branch_name);
	return result;
}

static GitgExtApplication*
gitg_ref_action_push_real_get_application (GitgExtUIElement* base)
{
	GitgExtApplication* result;
	GitgRefActionPush* self;
	GitgExtApplication* _tmp0_;
	GitgExtApplication* _tmp1_;
	self = (GitgRefActionPush*) base;
	_tmp0_ = self->priv->_application;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
gitg_ref_action_push_real_set_application (GitgExtUIElement* base,
                                           GitgExtApplication* value)
{
	GitgRefActionPush* self;
	GitgExtApplication* old_value;
	self = (GitgRefActionPush*) base;
	old_value = gitg_ref_action_push_real_get_application (base);
	if (old_value != value) {
		GitgExtApplication* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_application);
		self->priv->_application = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gitg_ref_action_push_properties[GITG_REF_ACTION_PUSH_APPLICATION_PROPERTY]);
	}
	_g_object_unref0 (old_value);
}

static GitgExtRefActionInterface*
gitg_ref_action_push_real_get_action_interface (GitgExtRefAction* base)
{
	GitgExtRefActionInterface* result;
	GitgRefActionPush* self;
	GitgExtRefActionInterface* _tmp0_;
	self = (GitgRefActionPush*) base;
	_tmp0_ = self->priv->_action_interface;
	result = _tmp0_;
	return result;
}

static void
gitg_ref_action_push_real_set_action_interface (GitgExtRefAction* base,
                                                GitgExtRefActionInterface* value)
{
	GitgRefActionPush* self;
	GitgExtRefActionInterface* old_value;
	self = (GitgRefActionPush*) base;
	old_value = gitg_ref_action_push_real_get_action_interface (base);
	if (old_value != value) {
		GitgExtRefActionInterface* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_action_interface);
		self->priv->_action_interface = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gitg_ref_action_push_properties[GITG_REF_ACTION_PUSH_ACTION_INTERFACE_PROPERTY]);
	}
}

static GitgRef*
gitg_ref_action_push_real_get_reference (GitgExtRefAction* base)
{
	GitgRef* result;
	GitgRefActionPush* self;
	GitgRef* _tmp0_;
	self = (GitgRefActionPush*) base;
	_tmp0_ = self->priv->_reference;
	result = _tmp0_;
	return result;
}

static void
gitg_ref_action_push_real_set_reference (GitgExtRefAction* base,
                                         GitgRef* value)
{
	GitgRefActionPush* self;
	GitgRef* old_value;
	self = (GitgRefActionPush*) base;
	old_value = gitg_ref_action_push_real_get_reference (base);
	if (old_value != value) {
		GitgRef* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_reference);
		self->priv->_reference = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gitg_ref_action_push_properties[GITG_REF_ACTION_PUSH_REFERENCE_PROPERTY]);
	}
}

static gchar*
gitg_ref_action_push_real_get_id (GitgExtUIElement* base)
{
	gchar* result;
	GitgRefActionPush* self;
	gchar* _tmp0_;
	self = (GitgRefActionPush*) base;
	_tmp0_ = g_strdup ("/org/gnome/gitg/ref-actions/push");
	result = _tmp0_;
	return result;
}

static gchar*
gitg_ref_action_push_real_get_display_name (GitgExtUIElement* base)
{
	gchar* result;
	GitgRefActionPush* self;
	GitgRemote* _tmp0_;
	self = (GitgRefActionPush*) base;
	_tmp0_ = self->priv->d_remote;
	if (_tmp0_ != NULL) {
		GitgRemote* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp1_ = self->priv->d_remote;
		_tmp2_ = ggit_remote_get_name ((GgitRemote*) _tmp1_);
		_tmp3_ = g_strdup_printf (_ ("Push to %s"), _tmp2_);
		result = _tmp3_;
		return result;
	} else {
		gchar* _tmp4_;
		_tmp4_ = g_strdup ("");
		result = _tmp4_;
		return result;
	}
}

static gchar*
gitg_ref_action_push_real_get_description (GitgExtUIElement* base)
{
	gchar* result;
	GitgRefActionPush* self;
	GitgRemote* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	self = (GitgRefActionPush*) base;
	_tmp0_ = self->priv->d_remote;
	_tmp1_ = ggit_remote_get_name ((GgitRemote*) _tmp0_);
	_tmp2_ = g_strdup_printf (_ ("Push branch to %s"), _tmp1_);
	result = _tmp2_;
	return result;
}

static gboolean
gitg_ref_action_push_real_get_available (GitgExtUIElement* base)
{
	gboolean result;
	GitgRefActionPush* self;
	gboolean _tmp0_ = FALSE;
	GitgRemote* _tmp1_;
	self = (GitgRefActionPush*) base;
	_tmp1_ = self->priv->d_remote;
	if (_tmp1_ != NULL) {
		GitgRef* _tmp2_;
		GitgRef* _tmp3_;
		_tmp2_ = gitg_ext_ref_action_get_reference ((GitgExtRefAction*) self);
		_tmp3_ = _tmp2_;
		_tmp0_ = ggit_ref_is_branch ((GgitRef*) _tmp3_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
gitg_ref_action_push_class_init (GitgRefActionPushClass * klass,
                                 gpointer klass_data)
{
	gitg_ref_action_push_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GitgRefActionPush_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_ref_action_push_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gitg_ref_action_push_set_property;
	G_OBJECT_CLASS (klass)->finalize = gitg_ref_action_push_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REF_ACTION_PUSH_APPLICATION_PROPERTY, gitg_ref_action_push_properties[GITG_REF_ACTION_PUSH_APPLICATION_PROPERTY] = g_param_spec_object ("application", "application", "application", GITG_EXT_TYPE_APPLICATION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REF_ACTION_PUSH_ACTION_INTERFACE_PROPERTY, gitg_ref_action_push_properties[GITG_REF_ACTION_PUSH_ACTION_INTERFACE_PROPERTY] = g_param_spec_object ("action-interface", "action-interface", "action-interface", GITG_EXT_TYPE_REF_ACTION_INTERFACE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REF_ACTION_PUSH_REFERENCE_PROPERTY, gitg_ref_action_push_properties[GITG_REF_ACTION_PUSH_REFERENCE_PROPERTY] = g_param_spec_object ("reference", "reference", "reference", GITG_TYPE_REF, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REF_ACTION_PUSH_ID_PROPERTY, gitg_ref_action_push_properties[GITG_REF_ACTION_PUSH_ID_PROPERTY] = g_param_spec_string ("id", "id", "id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REF_ACTION_PUSH_DISPLAY_NAME_PROPERTY, gitg_ref_action_push_properties[GITG_REF_ACTION_PUSH_DISPLAY_NAME_PROPERTY] = g_param_spec_string ("display-name", "display-name", "display-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REF_ACTION_PUSH_DESCRIPTION_PROPERTY, gitg_ref_action_push_properties[GITG_REF_ACTION_PUSH_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REF_ACTION_PUSH_AVAILABLE_PROPERTY, gitg_ref_action_push_properties[GITG_REF_ACTION_PUSH_AVAILABLE_PROPERTY] = g_param_spec_boolean ("available", "available", "available", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
gitg_ref_action_push_gitg_ext_ui_element_interface_init (GitgExtUIElementIface * iface,
                                                         gpointer iface_data)
{
	gitg_ref_action_push_gitg_ext_ui_element_parent_iface = g_type_interface_peek_parent (iface);
	iface->activate = (void (*) (GitgExtUIElement*)) gitg_ref_action_push_real_activate;
	iface->get_application = gitg_ref_action_push_real_get_application;
	iface->set_application = gitg_ref_action_push_real_set_application;
	iface->get_id = gitg_ref_action_push_real_get_id;
	iface->get_display_name = gitg_ref_action_push_real_get_display_name;
	iface->get_description = gitg_ref_action_push_real_get_description;
	iface->get_available = gitg_ref_action_push_real_get_available;
}

static void
gitg_ref_action_push_gitg_ext_action_interface_init (GitgExtActionIface * iface,
                                                     gpointer iface_data)
{
	gitg_ref_action_push_gitg_ext_action_parent_iface = g_type_interface_peek_parent (iface);
}

static void
gitg_ref_action_push_gitg_ext_ref_action_interface_init (GitgExtRefActionIface * iface,
                                                         gpointer iface_data)
{
	gitg_ref_action_push_gitg_ext_ref_action_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_action_interface = gitg_ref_action_push_real_get_action_interface;
	iface->set_action_interface = gitg_ref_action_push_real_set_action_interface;
	iface->get_reference = gitg_ref_action_push_real_get_reference;
	iface->set_reference = gitg_ref_action_push_real_set_reference;
}

static void
gitg_ref_action_push_instance_init (GitgRefActionPush * self,
                                    gpointer klass)
{
	self->priv = gitg_ref_action_push_get_instance_private (self);
}

static void
gitg_ref_action_push_finalize (GObject * obj)
{
	GitgRefActionPush * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_REF_ACTION_PUSH, GitgRefActionPush);
	_g_object_unref0 (self->priv->_application);
	_g_object_unref0 (self->priv->_action_interface);
	_g_object_unref0 (self->priv->_reference);
	_g_object_unref0 (self->priv->d_remote_ref);
	_g_object_unref0 (self->priv->d_remote);
	G_OBJECT_CLASS (gitg_ref_action_push_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gitg_ref_action_push_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GitgRefActionPushClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_ref_action_push_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgRefActionPush), 0, (GInstanceInitFunc) gitg_ref_action_push_instance_init, NULL };
	static const GInterfaceInfo gitg_ext_ui_element_info = { (GInterfaceInitFunc) gitg_ref_action_push_gitg_ext_ui_element_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo gitg_ext_action_info = { (GInterfaceInitFunc) gitg_ref_action_push_gitg_ext_action_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo gitg_ext_ref_action_info = { (GInterfaceInitFunc) gitg_ref_action_push_gitg_ext_ref_action_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType gitg_ref_action_push_type_id;
	gitg_ref_action_push_type_id = g_type_register_static (G_TYPE_OBJECT, "GitgRefActionPush", &g_define_type_info, 0);
	g_type_add_interface_static (gitg_ref_action_push_type_id, GITG_EXT_TYPE_UI_ELEMENT, &gitg_ext_ui_element_info);
	g_type_add_interface_static (gitg_ref_action_push_type_id, GITG_EXT_TYPE_ACTION, &gitg_ext_action_info);
	g_type_add_interface_static (gitg_ref_action_push_type_id, GITG_EXT_TYPE_REF_ACTION, &gitg_ext_ref_action_info);
	GitgRefActionPush_private_offset = g_type_add_instance_private (gitg_ref_action_push_type_id, sizeof (GitgRefActionPushPrivate));
	return gitg_ref_action_push_type_id;
}

GType
gitg_ref_action_push_get_type (void)
{
	static gsize gitg_ref_action_push_type_id__once = 0;
	if (g_once_init_enter (&gitg_ref_action_push_type_id__once)) {
		GType gitg_ref_action_push_type_id;
		gitg_ref_action_push_type_id = gitg_ref_action_push_get_type_once ();
		g_once_init_leave (&gitg_ref_action_push_type_id__once, gitg_ref_action_push_type_id);
	}
	return gitg_ref_action_push_type_id__once;
}

static void
_vala_gitg_ref_action_push_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	GitgRefActionPush * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_REF_ACTION_PUSH, GitgRefActionPush);
	switch (property_id) {
		case GITG_REF_ACTION_PUSH_APPLICATION_PROPERTY:
		g_value_take_object (value, gitg_ext_ui_element_get_application ((GitgExtUIElement*) self));
		break;
		case GITG_REF_ACTION_PUSH_ACTION_INTERFACE_PROPERTY:
		g_value_set_object (value, gitg_ext_ref_action_get_action_interface ((GitgExtRefAction*) self));
		break;
		case GITG_REF_ACTION_PUSH_REFERENCE_PROPERTY:
		g_value_set_object (value, gitg_ext_ref_action_get_reference ((GitgExtRefAction*) self));
		break;
		case GITG_REF_ACTION_PUSH_ID_PROPERTY:
		g_value_take_string (value, gitg_ext_ui_element_get_id ((GitgExtUIElement*) self));
		break;
		case GITG_REF_ACTION_PUSH_DISPLAY_NAME_PROPERTY:
		g_value_take_string (value, gitg_ext_ui_element_get_display_name ((GitgExtUIElement*) self));
		break;
		case GITG_REF_ACTION_PUSH_DESCRIPTION_PROPERTY:
		g_value_take_string (value, gitg_ext_ui_element_get_description ((GitgExtUIElement*) self));
		break;
		case GITG_REF_ACTION_PUSH_AVAILABLE_PROPERTY:
		g_value_set_boolean (value, gitg_ext_ui_element_get_available ((GitgExtUIElement*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gitg_ref_action_push_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	GitgRefActionPush * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_REF_ACTION_PUSH, GitgRefActionPush);
	switch (property_id) {
		case GITG_REF_ACTION_PUSH_APPLICATION_PROPERTY:
		gitg_ext_ui_element_set_application ((GitgExtUIElement*) self, g_value_get_object (value));
		break;
		case GITG_REF_ACTION_PUSH_ACTION_INTERFACE_PROPERTY:
		gitg_ext_ref_action_set_action_interface ((GitgExtRefAction*) self, g_value_get_object (value));
		break;
		case GITG_REF_ACTION_PUSH_REFERENCE_PROPERTY:
		gitg_ext_ref_action_set_reference ((GitgExtRefAction*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

