/* imf-provider.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from imf-provider.vala, do not modify */

#include "calculator.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <glib/gstdio.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	IMF_CURRENCY_PROVIDER_0_PROPERTY,
	IMF_CURRENCY_PROVIDER_RATE_FILEPATH_PROPERTY,
	IMF_CURRENCY_PROVIDER_RATE_SOURCE_URL_PROPERTY,
	IMF_CURRENCY_PROVIDER_ATTRIBUTION_LINK_PROPERTY,
	IMF_CURRENCY_PROVIDER_PROVIDER_NAME_PROPERTY,
	IMF_CURRENCY_PROVIDER_SOURCE_NAME_PROPERTY,
	IMF_CURRENCY_PROVIDER_NUM_PROPERTIES
};
static GParamSpec* imf_currency_provider_properties[IMF_CURRENCY_PROVIDER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_time_zone_unref0(var) ((var == NULL) ? NULL : (var = (g_time_zone_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	OFFLINE_IMF_CURRENCY_PROVIDER_0_PROPERTY,
	OFFLINE_IMF_CURRENCY_PROVIDER_NUM_PROPERTIES
};
static GParamSpec* offline_imf_currency_provider_properties[OFFLINE_IMF_CURRENCY_PROVIDER_NUM_PROPERTIES];
typedef struct _OfflineImfCurrencyProviderDownloadFileAsyncData OfflineImfCurrencyProviderDownloadFileAsyncData;

struct _OfflineImfCurrencyProviderPrivate {
	gchar* source_file;
};

struct _OfflineImfCurrencyProviderDownloadFileAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	OfflineImfCurrencyProvider* self;
	gchar* uri;
	gchar* filename;
	gchar* source;
	gchar* directory;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	GFile* dest;
	GFile* _tmp2_;
	GFile* source_file;
	const gchar* _tmp3_;
	GFile* _tmp4_;
	GFileInputStream* bodyinput;
	GFile* _tmp5_;
	GFileInputStream* _tmp6_;
	GFileOutputStream* output;
	GFile* _tmp7_;
	GFileOutputStream* _tmp8_;
	GFileOutputStream* _tmp9_;
	GFileInputStream* _tmp10_;
	GError* e;
	GError* _tmp11_;
	const gchar* _tmp12_;
	GError* _inner_error0_;
};

static gpointer imf_currency_provider_parent_class = NULL;
static gint OfflineImfCurrencyProvider_private_offset;
static gpointer offline_imf_currency_provider_parent_class = NULL;

static GHashTable* imf_currency_provider_get_name_map (ImfCurrencyProvider* self);
static void _g_free0_ (gpointer var);
static GDateTime* imf_currency_provider_real_parse_date (AbstractCurrencyProvider* base,
                                                  const gchar* date);
static gboolean imf_currency_provider_real_do_load_rates (AbstractCurrencyProvider* base);
static gchar** _vala_array_dup13 (gchar** self,
                           gssize length);
static GType imf_currency_provider_get_type_once (void);
static void _vala_imf_currency_provider_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void offline_imf_currency_provider_real_download_file_sync (AbstractCurrencyProvider* base,
                                                            const gchar* uri,
                                                            const gchar* filename,
                                                            const gchar* source);
static void offline_imf_currency_provider_real_download_file_async_data_free (gpointer _data);
static void offline_imf_currency_provider_real_download_file_async (AbstractCurrencyProvider* base,
                                                             const gchar* uri,
                                                             const gchar* filename,
                                                             const gchar* source,
                                                             GAsyncReadyCallback _callback_,
                                                             gpointer _user_data_);
static gboolean offline_imf_currency_provider_real_download_file_async_co (OfflineImfCurrencyProviderDownloadFileAsyncData* _data_);
static void offline_imf_currency_provider_download_file_async_ready (GObject* source_object,
                                                              GAsyncResult* _res_,
                                                              gpointer _user_data_);
static void offline_imf_currency_provider_finalize (GObject * obj);
static GType offline_imf_currency_provider_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static GHashTable*
imf_currency_provider_get_name_map (ImfCurrencyProvider* self)
{
	GHashTable* name_map = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_;
	gchar* _tmp50_;
	gchar* _tmp51_;
	gchar* _tmp52_;
	gchar* _tmp53_;
	gchar* _tmp54_;
	gchar* _tmp55_;
	gchar* _tmp56_;
	gchar* _tmp57_;
	gchar* _tmp58_;
	gchar* _tmp59_;
	gchar* _tmp60_;
	gchar* _tmp61_;
	gchar* _tmp62_;
	gchar* _tmp63_;
	gchar* _tmp64_;
	gchar* _tmp65_;
	gchar* _tmp66_;
	gchar* _tmp67_;
	gchar* _tmp68_;
	gchar* _tmp69_;
	gchar* _tmp70_;
	gchar* _tmp71_;
	gchar* _tmp72_;
	gchar* _tmp73_;
	gchar* _tmp74_;
	gchar* _tmp75_;
	gchar* _tmp76_;
	gchar* _tmp77_;
	gchar* _tmp78_;
	gchar* _tmp79_;
	gchar* _tmp80_;
	gchar* _tmp81_;
	gchar* _tmp82_;
	gchar* _tmp83_;
	gchar* _tmp84_;
	gchar* _tmp85_;
	gchar* _tmp86_;
	gchar* _tmp87_;
	gchar* _tmp88_;
	gchar* _tmp89_;
	gchar* _tmp90_;
	gchar* _tmp91_;
	gchar* _tmp92_;
	gchar* _tmp93_;
	gchar* _tmp94_;
	gchar* _tmp95_;
	gchar* _tmp96_;
	gchar* _tmp97_;
	gchar* _tmp98_;
	gchar* _tmp99_;
	gchar* _tmp100_;
	gchar* _tmp101_;
	gchar* _tmp102_;
	gchar* _tmp103_;
	gchar* _tmp104_;
	GHashTable* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_free0_);
	name_map = _tmp2_;
	_tmp3_ = g_strdup ("Euro");
	_tmp4_ = g_strdup ("EUR");
	g_hash_table_insert (name_map, _tmp3_, _tmp4_);
	_tmp5_ = g_strdup ("Japanese yen");
	_tmp6_ = g_strdup ("JPY");
	g_hash_table_insert (name_map, _tmp5_, _tmp6_);
	_tmp7_ = g_strdup ("U.K. pound");
	_tmp8_ = g_strdup ("GBP");
	g_hash_table_insert (name_map, _tmp7_, _tmp8_);
	_tmp9_ = g_strdup ("U.S. dollar");
	_tmp10_ = g_strdup ("USD");
	g_hash_table_insert (name_map, _tmp9_, _tmp10_);
	_tmp11_ = g_strdup ("Algerian dinar");
	_tmp12_ = g_strdup ("DZD");
	g_hash_table_insert (name_map, _tmp11_, _tmp12_);
	_tmp13_ = g_strdup ("Australian dollar");
	_tmp14_ = g_strdup ("AUD");
	g_hash_table_insert (name_map, _tmp13_, _tmp14_);
	_tmp15_ = g_strdup ("Bahrain dinar");
	_tmp16_ = g_strdup ("BHD");
	g_hash_table_insert (name_map, _tmp15_, _tmp16_);
	_tmp17_ = g_strdup ("Bangladeshi taka");
	_tmp18_ = g_strdup ("BDT");
	g_hash_table_insert (name_map, _tmp17_, _tmp18_);
	_tmp19_ = g_strdup ("Botswana pula");
	_tmp20_ = g_strdup ("BWP");
	g_hash_table_insert (name_map, _tmp19_, _tmp20_);
	_tmp21_ = g_strdup ("Brazilian real");
	_tmp22_ = g_strdup ("BRL");
	g_hash_table_insert (name_map, _tmp21_, _tmp22_);
	_tmp23_ = g_strdup ("Brunei dollar");
	_tmp24_ = g_strdup ("BND");
	g_hash_table_insert (name_map, _tmp23_, _tmp24_);
	_tmp25_ = g_strdup ("Canadian dollar");
	_tmp26_ = g_strdup ("CAD");
	g_hash_table_insert (name_map, _tmp25_, _tmp26_);
	_tmp27_ = g_strdup ("Chilean peso");
	_tmp28_ = g_strdup ("CLP");
	g_hash_table_insert (name_map, _tmp27_, _tmp28_);
	_tmp29_ = g_strdup ("Chinese yuan");
	_tmp30_ = g_strdup ("CNY");
	g_hash_table_insert (name_map, _tmp29_, _tmp30_);
	_tmp31_ = g_strdup ("Colombian peso");
	_tmp32_ = g_strdup ("COP");
	g_hash_table_insert (name_map, _tmp31_, _tmp32_);
	_tmp33_ = g_strdup ("Czech koruna");
	_tmp34_ = g_strdup ("CZK");
	g_hash_table_insert (name_map, _tmp33_, _tmp34_);
	_tmp35_ = g_strdup ("Danish krone");
	_tmp36_ = g_strdup ("DKK");
	g_hash_table_insert (name_map, _tmp35_, _tmp36_);
	_tmp37_ = g_strdup ("Hungarian forint");
	_tmp38_ = g_strdup ("HUF");
	g_hash_table_insert (name_map, _tmp37_, _tmp38_);
	_tmp39_ = g_strdup ("Icelandic krona");
	_tmp40_ = g_strdup ("ISK");
	g_hash_table_insert (name_map, _tmp39_, _tmp40_);
	_tmp41_ = g_strdup ("Indian rupee");
	_tmp42_ = g_strdup ("INR");
	g_hash_table_insert (name_map, _tmp41_, _tmp42_);
	_tmp43_ = g_strdup ("Indonesian rupiah");
	_tmp44_ = g_strdup ("IDR");
	g_hash_table_insert (name_map, _tmp43_, _tmp44_);
	_tmp45_ = g_strdup ("Iranian rial");
	_tmp46_ = g_strdup ("IRR");
	g_hash_table_insert (name_map, _tmp45_, _tmp46_);
	_tmp47_ = g_strdup ("Israeli New Shekel");
	_tmp48_ = g_strdup ("ILS");
	g_hash_table_insert (name_map, _tmp47_, _tmp48_);
	_tmp49_ = g_strdup ("Kazakhstani tenge");
	_tmp50_ = g_strdup ("KZT");
	g_hash_table_insert (name_map, _tmp49_, _tmp50_);
	_tmp51_ = g_strdup ("Korean won");
	_tmp52_ = g_strdup ("KRW");
	g_hash_table_insert (name_map, _tmp51_, _tmp52_);
	_tmp53_ = g_strdup ("Kuwaiti dinar");
	_tmp54_ = g_strdup ("KWD");
	g_hash_table_insert (name_map, _tmp53_, _tmp54_);
	_tmp55_ = g_strdup ("Libyan dinar");
	_tmp56_ = g_strdup ("LYD");
	g_hash_table_insert (name_map, _tmp55_, _tmp56_);
	_tmp57_ = g_strdup ("Malaysian ringgit");
	_tmp58_ = g_strdup ("MYR");
	g_hash_table_insert (name_map, _tmp57_, _tmp58_);
	_tmp59_ = g_strdup ("Mauritian rupee");
	_tmp60_ = g_strdup ("MUR");
	g_hash_table_insert (name_map, _tmp59_, _tmp60_);
	_tmp61_ = g_strdup ("Mexican peso");
	_tmp62_ = g_strdup ("MXN");
	g_hash_table_insert (name_map, _tmp61_, _tmp62_);
	_tmp63_ = g_strdup ("Nepalese rupee");
	_tmp64_ = g_strdup ("NPR");
	g_hash_table_insert (name_map, _tmp63_, _tmp64_);
	_tmp65_ = g_strdup ("New Zealand dollar");
	_tmp66_ = g_strdup ("NZD");
	g_hash_table_insert (name_map, _tmp65_, _tmp66_);
	_tmp67_ = g_strdup ("Norwegian krone");
	_tmp68_ = g_strdup ("NOK");
	g_hash_table_insert (name_map, _tmp67_, _tmp68_);
	_tmp69_ = g_strdup ("Omani rial");
	_tmp70_ = g_strdup ("OMR");
	g_hash_table_insert (name_map, _tmp69_, _tmp70_);
	_tmp71_ = g_strdup ("Pakistani rupee");
	_tmp72_ = g_strdup ("PKR");
	g_hash_table_insert (name_map, _tmp71_, _tmp72_);
	_tmp73_ = g_strdup ("Peruvian sol");
	_tmp74_ = g_strdup ("PEN");
	g_hash_table_insert (name_map, _tmp73_, _tmp74_);
	_tmp75_ = g_strdup ("Philippine peso");
	_tmp76_ = g_strdup ("PHP");
	g_hash_table_insert (name_map, _tmp75_, _tmp76_);
	_tmp77_ = g_strdup ("Polish zloty");
	_tmp78_ = g_strdup ("PLN");
	g_hash_table_insert (name_map, _tmp77_, _tmp78_);
	_tmp79_ = g_strdup ("Qatari riyal");
	_tmp80_ = g_strdup ("QAR");
	g_hash_table_insert (name_map, _tmp79_, _tmp80_);
	_tmp81_ = g_strdup ("Russian ruble");
	_tmp82_ = g_strdup ("RUB");
	g_hash_table_insert (name_map, _tmp81_, _tmp82_);
	_tmp83_ = g_strdup ("Saudi Arabian riyal");
	_tmp84_ = g_strdup ("SAR");
	g_hash_table_insert (name_map, _tmp83_, _tmp84_);
	_tmp85_ = g_strdup ("Singapore dollar");
	_tmp86_ = g_strdup ("SGD");
	g_hash_table_insert (name_map, _tmp85_, _tmp86_);
	_tmp87_ = g_strdup ("South African rand");
	_tmp88_ = g_strdup ("ZAR");
	g_hash_table_insert (name_map, _tmp87_, _tmp88_);
	_tmp89_ = g_strdup ("Sri Lankan rupee");
	_tmp90_ = g_strdup ("LKR");
	g_hash_table_insert (name_map, _tmp89_, _tmp90_);
	_tmp91_ = g_strdup ("Swedish krona");
	_tmp92_ = g_strdup ("SEK");
	g_hash_table_insert (name_map, _tmp91_, _tmp92_);
	_tmp93_ = g_strdup ("Swiss franc");
	_tmp94_ = g_strdup ("CHF");
	g_hash_table_insert (name_map, _tmp93_, _tmp94_);
	_tmp95_ = g_strdup ("Thai baht");
	_tmp96_ = g_strdup ("THB");
	g_hash_table_insert (name_map, _tmp95_, _tmp96_);
	_tmp97_ = g_strdup ("Trinidadian dollar");
	_tmp98_ = g_strdup ("TTD");
	g_hash_table_insert (name_map, _tmp97_, _tmp98_);
	_tmp99_ = g_strdup ("Tunisian dinar");
	_tmp100_ = g_strdup ("TND");
	g_hash_table_insert (name_map, _tmp99_, _tmp100_);
	_tmp101_ = g_strdup ("U.A.E. dirham");
	_tmp102_ = g_strdup ("AED");
	g_hash_table_insert (name_map, _tmp101_, _tmp102_);
	_tmp103_ = g_strdup ("Uruguayan peso");
	_tmp104_ = g_strdup ("UYU");
	g_hash_table_insert (name_map, _tmp103_, _tmp104_);
	result = name_map;
	return result;
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static GDateTime*
imf_currency_provider_real_parse_date (AbstractCurrencyProvider* base,
                                       const gchar* date)
{
	ImfCurrencyProvider * self;
	gchar** array = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint array_length1;
	gint _array_size_;
	gint year = 0;
	gchar** _tmp2_;
	gint _tmp2__length1;
	const gchar* _tmp3_;
	gint month = 0;
	gint day = 0;
	gchar** _tmp10_;
	gint _tmp10__length1;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gint _tmp14_;
	GTimeZone* _tmp15_;
	GTimeZone* _tmp16_;
	GDateTime* _tmp17_;
	GDateTime* _tmp18_;
	GDateTime* result;
	self = (ImfCurrencyProvider*) base;
	if (date == NULL) {
		result = NULL;
		return result;
	}
	_tmp1_ = _tmp0_ = g_strsplit (date, " ", 0);
	array = _tmp1_;
	array_length1 = _vala_array_length (_tmp0_);
	_array_size_ = array_length1;
	_tmp2_ = array;
	_tmp2__length1 = array_length1;
	_tmp3_ = _tmp2_[2];
	year = atoi (_tmp3_);
	month = 0;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				gchar** _tmp6_;
				gint _tmp6__length1;
				const gchar* _tmp7_;
				gchar** _tmp8_;
				gint _tmp8__length1;
				const gchar* _tmp9_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (!(i < 12)) {
					break;
				}
				_tmp6_ = ((AbstractCurrencyProvider*) self)->MONTHS_FULL;
				_tmp6__length1 = ((AbstractCurrencyProvider*) self)->MONTHS_FULL_length1;
				_tmp7_ = _tmp6_[i];
				_tmp8_ = array;
				_tmp8__length1 = array_length1;
				_tmp9_ = _tmp8_[0];
				if (g_strcmp0 (_tmp7_, _tmp9_) == 0) {
					month = i + 1;
					break;
				}
			}
		}
	}
	_tmp10_ = array;
	_tmp10__length1 = array_length1;
	_tmp11_ = _tmp10_[1];
	_tmp12_ = string_slice (_tmp11_, (glong) 0, (glong) -1);
	_tmp13_ = _tmp12_;
	_tmp14_ = atoi (_tmp13_);
	_g_free0 (_tmp13_);
	day = _tmp14_;
	_tmp15_ = g_time_zone_new_local ();
	_tmp16_ = _tmp15_;
	_tmp17_ = g_date_time_new (_tmp16_, year, month, day, 0, 0, (gdouble) 0);
	_tmp18_ = _tmp17_;
	_g_time_zone_unref0 (_tmp16_);
	result = _tmp18_;
	array = (_vala_array_free (array, array_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static gchar*
string_chug (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strchug (_result_);
	result = _result_;
	return result;
}

static gchar**
_vala_array_dup13 (gchar** self,
                   gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gboolean
imf_currency_provider_real_do_load_rates (AbstractCurrencyProvider* base)
{
	ImfCurrencyProvider * self;
	GHashTable* name_map = NULL;
	GHashTable* _tmp0_;
	gchar* data = NULL;
	gchar** lines = NULL;
	const gchar* _tmp8_;
	gchar** _tmp9_;
	gchar** _tmp10_;
	gint lines_length1;
	gint _lines_size_;
	gboolean in_data = FALSE;
	gchar** headers = NULL;
	gint headers_length1;
	gint _headers_size_;
	gchar** _tmp11_;
	gint _tmp11__length1;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (ImfCurrencyProvider*) base;
	_tmp0_ = imf_currency_provider_get_name_map (self);
	name_map = _tmp0_;
	{
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_ = NULL;
		_tmp1_ = abstract_currency_provider_get_rate_filepath ((AbstractCurrencyProvider*) self);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		g_file_get_contents (_tmp3_, &_tmp4_, NULL, &_inner_error0_);
		_g_free0 (data);
		data = _tmp4_;
		_g_free0 (_tmp3_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_warning ("imf-provider.vala:100: Failed to read exchange rates: %s", _tmp6_);
		result = FALSE;
		_g_error_free0 (e);
		_g_free0 (data);
		_g_hash_table_unref0 (name_map);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp7_ = FALSE;
		_g_free0 (data);
		_g_hash_table_unref0 (name_map);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp7_;
	}
	_tmp8_ = data;
	_tmp10_ = _tmp9_ = g_strsplit (_tmp8_, "\n", 0);
	lines = _tmp10_;
	lines_length1 = _vala_array_length (_tmp9_);
	_lines_size_ = lines_length1;
	in_data = FALSE;
	headers = NULL;
	headers_length1 = 0;
	_headers_size_ = headers_length1;
	_tmp11_ = lines;
	_tmp11__length1 = lines_length1;
	{
		gchar** line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
		line_collection = _tmp11_;
		line_collection_length1 = _tmp11__length1;
		for (line_it = 0; line_it < line_collection_length1; line_it = line_it + 1) {
			gchar* _tmp12_;
			gchar* line = NULL;
			_tmp12_ = g_strdup (line_collection[line_it]);
			line = _tmp12_;
			{
				const gchar* _tmp13_;
				gchar* _tmp14_;
				const gchar* _tmp15_;
				gchar** tokens = NULL;
				const gchar* _tmp16_;
				gchar** _tmp17_;
				gchar** _tmp18_;
				gint tokens_length1;
				gint _tokens_size_;
				gboolean _tmp19_ = FALSE;
				gchar** _tmp20_;
				gint _tmp20__length1;
				const gchar* _tmp21_;
				_tmp13_ = line;
				_tmp14_ = string_chug (_tmp13_);
				_g_free0 (line);
				line = _tmp14_;
				_tmp15_ = line;
				if (g_strcmp0 (_tmp15_, "") == 0) {
					if (!in_data) {
						in_data = TRUE;
						_g_free0 (line);
						continue;
					} else {
						_g_free0 (line);
						break;
					}
				}
				if (!in_data) {
					_g_free0 (line);
					continue;
				}
				_tmp16_ = line;
				_tmp18_ = _tmp17_ = g_strsplit (_tmp16_, "\t", 0);
				tokens = _tmp18_;
				tokens_length1 = _vala_array_length (_tmp17_);
				_tokens_size_ = tokens_length1;
				_tmp20_ = tokens;
				_tmp20__length1 = tokens_length1;
				_tmp21_ = _tmp20_[0];
				if (g_strcmp0 (_tmp21_, "Currency") != 0) {
					gchar** _tmp22_;
					gint _tmp22__length1;
					_tmp22_ = headers;
					_tmp22__length1 = headers_length1;
					_tmp19_ = _tmp22_ != NULL;
				} else {
					_tmp19_ = FALSE;
				}
				if (_tmp19_) {
					gint value_index = 0;
					gchar** _tmp30_;
					gint _tmp30__length1;
					{
						gboolean _tmp23_ = FALSE;
						value_index = 1;
						_tmp23_ = TRUE;
						while (TRUE) {
							gchar** _tmp25_;
							gint _tmp25__length1;
							gchar* value = NULL;
							gchar** _tmp26_;
							gint _tmp26__length1;
							const gchar* _tmp27_;
							gchar* _tmp28_;
							const gchar* _tmp29_;
							if (!_tmp23_) {
								gint _tmp24_;
								_tmp24_ = value_index;
								value_index = _tmp24_ + 1;
							}
							_tmp23_ = FALSE;
							_tmp25_ = tokens;
							_tmp25__length1 = tokens_length1;
							if (!(value_index < _tmp25__length1)) {
								break;
							}
							_tmp26_ = tokens;
							_tmp26__length1 = tokens_length1;
							_tmp27_ = _tmp26_[value_index];
							_tmp28_ = string_chug (_tmp27_);
							value = _tmp28_;
							_tmp29_ = value;
							if (g_strcmp0 (_tmp29_, "") != 0) {
								_g_free0 (value);
								break;
							}
							_g_free0 (value);
						}
					}
					_tmp30_ = tokens;
					_tmp30__length1 = tokens_length1;
					if (value_index < _tmp30__length1) {
						gchar* symbol = NULL;
						GHashTable* _tmp31_;
						gchar** _tmp32_;
						gint _tmp32__length1;
						const gchar* _tmp33_;
						gconstpointer _tmp34_;
						gchar* _tmp35_;
						const gchar* _tmp36_;
						_tmp31_ = name_map;
						_tmp32_ = tokens;
						_tmp32__length1 = tokens_length1;
						_tmp33_ = _tmp32_[0];
						_tmp34_ = g_hash_table_lookup (_tmp31_, _tmp33_);
						_tmp35_ = g_strdup ((const gchar*) _tmp34_);
						symbol = _tmp35_;
						_tmp36_ = symbol;
						if (_tmp36_ != NULL) {
							Currency* c = NULL;
							const gchar* _tmp37_;
							Currency* _tmp38_;
							Number* value = NULL;
							gchar** _tmp39_;
							gint _tmp39__length1;
							const gchar* _tmp40_;
							Number* _tmp41_;
							gboolean _tmp42_ = FALSE;
							Currency* _tmp43_;
							_tmp37_ = symbol;
							_tmp38_ = abstract_currency_provider_get_currency ((AbstractCurrencyProvider*) self, _tmp37_);
							c = _tmp38_;
							_tmp39_ = tokens;
							_tmp39__length1 = tokens_length1;
							_tmp40_ = _tmp39_[value_index];
							_tmp41_ = mp_set_from_string (_tmp40_, 10, TRUE);
							value = _tmp41_;
							_tmp43_ = c;
							if (_tmp43_ == NULL) {
								Number* _tmp44_;
								_tmp44_ = value;
								_tmp42_ = _tmp44_ != NULL;
							} else {
								_tmp42_ = FALSE;
							}
							if (_tmp42_) {
								gchar** _tmp45_;
								gint _tmp45__length1;
								const gchar* _tmp46_;
								const gchar* _tmp47_;
								const gchar* _tmp48_ = NULL;
								gchar** _tmp49_;
								gint _tmp49__length1;
								const gchar* _tmp52_;
								gchar* _tmp53_;
								gchar* _tmp54_;
								gchar* _tmp55_;
								Number* _tmp56_;
								Number* _tmp57_;
								Number* _tmp58_;
								Currency* _tmp59_;
								_tmp45_ = tokens;
								_tmp45__length1 = tokens_length1;
								_tmp46_ = _tmp45_[value_index];
								_tmp47_ = symbol;
								g_debug ("imf-provider.vala:147: Using IMF rate of %s for %s", _tmp46_, _tmp47_);
								_tmp49_ = headers;
								_tmp49__length1 = headers_length1;
								if (_tmp49_ != NULL) {
									gchar** _tmp50_;
									gint _tmp50__length1;
									const gchar* _tmp51_;
									_tmp50_ = headers;
									_tmp50__length1 = headers_length1;
									_tmp51_ = _tmp50_[value_index];
									_tmp48_ = _tmp51_;
								} else {
									_tmp48_ = NULL;
								}
								_tmp52_ = symbol;
								_tmp53_ = abstract_currency_provider_get_source_name ((AbstractCurrencyProvider*) self);
								_tmp54_ = _tmp53_;
								_tmp55_ = _tmp54_;
								_tmp56_ = value;
								_tmp57_ = number_reciprocal (_tmp56_);
								_tmp58_ = _tmp57_;
								_tmp59_ = abstract_currency_provider_register_currency ((AbstractCurrencyProvider*) self, _tmp52_, _tmp55_, _tmp58_, _tmp48_);
								_g_object_unref0 (c);
								c = _tmp59_;
								_g_object_unref0 (_tmp58_);
								_g_free0 (_tmp55_);
							}
							_g_object_unref0 (value);
							_g_object_unref0 (c);
						} else {
							gchar** _tmp60_;
							gint _tmp60__length1;
							const gchar* _tmp61_;
							_tmp60_ = tokens;
							_tmp60__length1 = tokens_length1;
							_tmp61_ = _tmp60_[0];
							g_warning ("imf-provider.vala:152: Unknown currency '%s'", _tmp61_);
						}
						_g_free0 (symbol);
					}
				} else {
					gchar** _tmp62_;
					gint _tmp62__length1;
					gchar** _tmp63_;
					gint _tmp63__length1;
					_tmp62_ = tokens;
					_tmp62__length1 = tokens_length1;
					_tmp63_ = (_tmp62_ != NULL) ? _vala_array_dup13 (_tmp62_, _tmp62__length1) : _tmp62_;
					_tmp63__length1 = _tmp62__length1;
					headers = (_vala_array_free (headers, headers_length1, (GDestroyNotify) g_free), NULL);
					headers = _tmp63_;
					headers_length1 = _tmp63__length1;
					_headers_size_ = headers_length1;
				}
				tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (line);
			}
		}
	}
	result = ABSTRACT_CURRENCY_PROVIDER_CLASS (imf_currency_provider_parent_class)->do_load_rates (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ABSTRACT_CURRENCY_PROVIDER, AbstractCurrencyProvider));
	headers = (_vala_array_free (headers, headers_length1, (GDestroyNotify) g_free), NULL);
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (data);
	_g_hash_table_unref0 (name_map);
	return result;
}

ImfCurrencyProvider*
imf_currency_provider_construct (GType object_type,
                                 CurrencyManager* _currency_manager)
{
	ImfCurrencyProvider * self = NULL;
	g_return_val_if_fail (_currency_manager != NULL, NULL);
	self = (ImfCurrencyProvider*) g_object_new (object_type, "currency-manager", _currency_manager, NULL);
	currency_manager_add_provider (_currency_manager, (CurrencyProvider*) self);
	return self;
}

ImfCurrencyProvider*
imf_currency_provider_new (CurrencyManager* _currency_manager)
{
	return imf_currency_provider_construct (TYPE_IMF_CURRENCY_PROVIDER, _currency_manager);
}

static gchar*
imf_currency_provider_real_get_rate_filepath (AbstractCurrencyProvider* base)
{
	gchar* result;
	ImfCurrencyProvider* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (ImfCurrencyProvider*) base;
	_tmp0_ = g_get_user_cache_dir ();
	_tmp1_ = g_build_filename (_tmp0_, "gnome-calculator", "rms_five.xls", NULL);
	result = _tmp1_;
	return result;
}

static gchar*
imf_currency_provider_real_get_rate_source_url (AbstractCurrencyProvider* base)
{
	gchar* result;
	ImfCurrencyProvider* self;
	gchar* _tmp0_;
	self = (ImfCurrencyProvider*) base;
	_tmp0_ = g_strdup ("https://exchange-api.gnome.org/imf/rms_five.xls");
	result = _tmp0_;
	return result;
}

static gchar*
imf_currency_provider_real_get_attribution_link (AbstractCurrencyProvider* base)
{
	gchar* result;
	ImfCurrencyProvider* self;
	gchar* _tmp0_;
	self = (ImfCurrencyProvider*) base;
	_tmp0_ = g_strdup ("https://www.imf.org/external/np/fin/data/rms_five.aspx");
	result = _tmp0_;
	return result;
}

static const gchar*
imf_currency_provider_real_get_provider_name (AbstractCurrencyProvider* base)
{
	const gchar* result;
	ImfCurrencyProvider* self;
	self = (ImfCurrencyProvider*) base;
	result = _ ("International Monetary Fund");
	return result;
}

static gchar*
imf_currency_provider_real_get_source_name (AbstractCurrencyProvider* base)
{
	gchar* result;
	ImfCurrencyProvider* self;
	gchar* _tmp0_;
	self = (ImfCurrencyProvider*) base;
	_tmp0_ = g_strdup ("IMF");
	result = _tmp0_;
	return result;
}

static void
imf_currency_provider_class_init (ImfCurrencyProviderClass * klass,
                                  gpointer klass_data)
{
	imf_currency_provider_parent_class = g_type_class_peek_parent (klass);
	((AbstractCurrencyProviderClass *) klass)->parse_date = (GDateTime* (*) (AbstractCurrencyProvider*, const gchar*)) imf_currency_provider_real_parse_date;
	((AbstractCurrencyProviderClass *) klass)->do_load_rates = (gboolean (*) (AbstractCurrencyProvider*)) imf_currency_provider_real_do_load_rates;
	ABSTRACT_CURRENCY_PROVIDER_CLASS (klass)->get_rate_filepath = (gchar* (*) (AbstractCurrencyProvider*)) imf_currency_provider_real_get_rate_filepath;
	ABSTRACT_CURRENCY_PROVIDER_CLASS (klass)->get_rate_source_url = (gchar* (*) (AbstractCurrencyProvider*)) imf_currency_provider_real_get_rate_source_url;
	ABSTRACT_CURRENCY_PROVIDER_CLASS (klass)->get_attribution_link = (gchar* (*) (AbstractCurrencyProvider*)) imf_currency_provider_real_get_attribution_link;
	ABSTRACT_CURRENCY_PROVIDER_CLASS (klass)->get_provider_name = (const gchar* (*) (AbstractCurrencyProvider*)) imf_currency_provider_real_get_provider_name;
	ABSTRACT_CURRENCY_PROVIDER_CLASS (klass)->get_source_name = (gchar* (*) (AbstractCurrencyProvider*)) imf_currency_provider_real_get_source_name;
	G_OBJECT_CLASS (klass)->get_property = _vala_imf_currency_provider_get_property;
	g_object_class_install_property (G_OBJECT_CLASS (klass), IMF_CURRENCY_PROVIDER_RATE_FILEPATH_PROPERTY, imf_currency_provider_properties[IMF_CURRENCY_PROVIDER_RATE_FILEPATH_PROPERTY] = g_param_spec_string ("rate-filepath", "rate-filepath", "rate-filepath", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), IMF_CURRENCY_PROVIDER_RATE_SOURCE_URL_PROPERTY, imf_currency_provider_properties[IMF_CURRENCY_PROVIDER_RATE_SOURCE_URL_PROPERTY] = g_param_spec_string ("rate-source-url", "rate-source-url", "rate-source-url", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), IMF_CURRENCY_PROVIDER_ATTRIBUTION_LINK_PROPERTY, imf_currency_provider_properties[IMF_CURRENCY_PROVIDER_ATTRIBUTION_LINK_PROPERTY] = g_param_spec_string ("attribution-link", "attribution-link", "attribution-link", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), IMF_CURRENCY_PROVIDER_PROVIDER_NAME_PROPERTY, imf_currency_provider_properties[IMF_CURRENCY_PROVIDER_PROVIDER_NAME_PROPERTY] = g_param_spec_string ("provider-name", "provider-name", "provider-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), IMF_CURRENCY_PROVIDER_SOURCE_NAME_PROPERTY, imf_currency_provider_properties[IMF_CURRENCY_PROVIDER_SOURCE_NAME_PROPERTY] = g_param_spec_string ("source-name", "source-name", "source-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
imf_currency_provider_instance_init (ImfCurrencyProvider * self,
                                     gpointer klass)
{
}

static GType
imf_currency_provider_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ImfCurrencyProviderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) imf_currency_provider_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ImfCurrencyProvider), 0, (GInstanceInitFunc) imf_currency_provider_instance_init, NULL };
	GType imf_currency_provider_type_id;
	imf_currency_provider_type_id = g_type_register_static (TYPE_ABSTRACT_CURRENCY_PROVIDER, "ImfCurrencyProvider", &g_define_type_info, 0);
	return imf_currency_provider_type_id;
}

GType
imf_currency_provider_get_type (void)
{
	static volatile gsize imf_currency_provider_type_id__once = 0;
	if (g_once_init_enter (&imf_currency_provider_type_id__once)) {
		GType imf_currency_provider_type_id;
		imf_currency_provider_type_id = imf_currency_provider_get_type_once ();
		g_once_init_leave (&imf_currency_provider_type_id__once, imf_currency_provider_type_id);
	}
	return imf_currency_provider_type_id__once;
}

static void
_vala_imf_currency_provider_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	ImfCurrencyProvider * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_IMF_CURRENCY_PROVIDER, ImfCurrencyProvider);
	switch (property_id) {
		case IMF_CURRENCY_PROVIDER_RATE_FILEPATH_PROPERTY:
		g_value_take_string (value, abstract_currency_provider_get_rate_filepath ((AbstractCurrencyProvider*) self));
		break;
		case IMF_CURRENCY_PROVIDER_RATE_SOURCE_URL_PROPERTY:
		g_value_take_string (value, abstract_currency_provider_get_rate_source_url ((AbstractCurrencyProvider*) self));
		break;
		case IMF_CURRENCY_PROVIDER_ATTRIBUTION_LINK_PROPERTY:
		g_value_take_string (value, abstract_currency_provider_get_attribution_link ((AbstractCurrencyProvider*) self));
		break;
		case IMF_CURRENCY_PROVIDER_PROVIDER_NAME_PROPERTY:
		g_value_set_string (value, abstract_currency_provider_get_provider_name ((AbstractCurrencyProvider*) self));
		break;
		case IMF_CURRENCY_PROVIDER_SOURCE_NAME_PROPERTY:
		g_value_take_string (value, abstract_currency_provider_get_source_name ((AbstractCurrencyProvider*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
offline_imf_currency_provider_get_instance_private (OfflineImfCurrencyProvider* self)
{
	return G_STRUCT_MEMBER_P (self, OfflineImfCurrencyProvider_private_offset);
}

OfflineImfCurrencyProvider*
offline_imf_currency_provider_construct (GType object_type,
                                         CurrencyManager* _currency_manager,
                                         const gchar* source_file)
{
	OfflineImfCurrencyProvider * self = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (_currency_manager != NULL, NULL);
	g_return_val_if_fail (source_file != NULL, NULL);
	self = (OfflineImfCurrencyProvider*) imf_currency_provider_construct (object_type, _currency_manager);
	_tmp0_ = g_strdup (source_file);
	_g_free0 (self->priv->source_file);
	self->priv->source_file = _tmp0_;
	return self;
}

OfflineImfCurrencyProvider*
offline_imf_currency_provider_new (CurrencyManager* _currency_manager,
                                   const gchar* source_file)
{
	return offline_imf_currency_provider_construct (TYPE_OFFLINE_IMF_CURRENCY_PROVIDER, _currency_manager, source_file);
}

static void
offline_imf_currency_provider_real_download_file_sync (AbstractCurrencyProvider* base,
                                                       const gchar* uri,
                                                       const gchar* filename,
                                                       const gchar* source)
{
	OfflineImfCurrencyProvider * self;
	gchar* directory = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	GFile* dest = NULL;
	GFile* _tmp2_;
	GFile* source_file = NULL;
	const gchar* _tmp3_;
	GFile* _tmp4_;
	GError* _inner_error0_ = NULL;
	self = (OfflineImfCurrencyProvider*) base;
	g_return_if_fail (uri != NULL);
	g_return_if_fail (filename != NULL);
	g_return_if_fail (source != NULL);
	_tmp0_ = g_path_get_dirname (filename);
	directory = _tmp0_;
	_tmp1_ = directory;
	g_mkdir_with_parents (_tmp1_, 0755);
	_tmp2_ = g_file_new_for_path (filename);
	dest = _tmp2_;
	_tmp3_ = self->priv->source_file;
	_tmp4_ = g_file_new_for_path (_tmp3_);
	source_file = _tmp4_;
	{
		GFileInputStream* bodyinput = NULL;
		GFile* _tmp5_;
		GFileInputStream* _tmp6_;
		GFileOutputStream* output = NULL;
		GFile* _tmp7_;
		GFileOutputStream* _tmp8_;
		GFileOutputStream* _tmp9_;
		GFileInputStream* _tmp10_;
		_tmp5_ = source_file;
		_tmp6_ = g_file_read (_tmp5_, NULL, &_inner_error0_);
		bodyinput = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp7_ = dest;
		_tmp8_ = g_file_replace (_tmp7_, NULL, FALSE, G_FILE_CREATE_REPLACE_DESTINATION, NULL, &_inner_error0_);
		output = _tmp8_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (bodyinput);
			goto __catch0_g_error;
		}
		_tmp9_ = output;
		_tmp10_ = bodyinput;
		g_output_stream_splice ((GOutputStream*) _tmp9_, (GInputStream*) _tmp10_, G_OUTPUT_STREAM_SPLICE_CLOSE_SOURCE | G_OUTPUT_STREAM_SPLICE_CLOSE_TARGET, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (output);
			_g_object_unref0 (bodyinput);
			goto __catch0_g_error;
		}
		((AbstractCurrencyProvider*) self)->loading = FALSE;
		abstract_currency_provider_do_load_rates ((AbstractCurrencyProvider*) self);
		g_debug ("imf-provider.vala:193: %s rates updated", source);
		_g_object_unref0 (output);
		_g_object_unref0 (bodyinput);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp11_;
		const gchar* _tmp12_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		g_warning ("imf-provider.vala:197: Couldn't download %s currency rate file: %s", source, _tmp12_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (source_file);
		_g_object_unref0 (dest);
		_g_free0 (directory);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (source_file);
	_g_object_unref0 (dest);
	_g_free0 (directory);
}

static void
offline_imf_currency_provider_real_download_file_async_data_free (gpointer _data)
{
	OfflineImfCurrencyProviderDownloadFileAsyncData* _data_;
	_data_ = _data;
	_g_free0 (_data_->uri);
	_g_free0 (_data_->filename);
	_g_free0 (_data_->source);
	_g_object_unref0 (_data_->self);
	g_slice_free (OfflineImfCurrencyProviderDownloadFileAsyncData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
offline_imf_currency_provider_real_download_file_async (AbstractCurrencyProvider* base,
                                                        const gchar* uri,
                                                        const gchar* filename,
                                                        const gchar* source,
                                                        GAsyncReadyCallback _callback_,
                                                        gpointer _user_data_)
{
	OfflineImfCurrencyProvider * self;
	OfflineImfCurrencyProviderDownloadFileAsyncData* _data_;
	OfflineImfCurrencyProvider* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (uri != NULL);
	g_return_if_fail (filename != NULL);
	g_return_if_fail (source != NULL);
	self = (OfflineImfCurrencyProvider*) base;
	_data_ = g_slice_new0 (OfflineImfCurrencyProviderDownloadFileAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, offline_imf_currency_provider_real_download_file_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (uri);
	_g_free0 (_data_->uri);
	_data_->uri = _tmp1_;
	_tmp2_ = g_strdup (filename);
	_g_free0 (_data_->filename);
	_data_->filename = _tmp2_;
	_tmp3_ = g_strdup (source);
	_g_free0 (_data_->source);
	_data_->source = _tmp3_;
	offline_imf_currency_provider_real_download_file_async_co (_data_);
}

static void
offline_imf_currency_provider_download_file_finish (AbstractCurrencyProvider* base,
                                                    GAsyncResult* _res_)
{
	OfflineImfCurrencyProviderDownloadFileAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
offline_imf_currency_provider_download_file_async_ready (GObject* source_object,
                                                         GAsyncResult* _res_,
                                                         gpointer _user_data_)
{
	OfflineImfCurrencyProviderDownloadFileAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	offline_imf_currency_provider_real_download_file_async_co (_data_);
}

static gboolean
offline_imf_currency_provider_real_download_file_async_co (OfflineImfCurrencyProviderDownloadFileAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_path_get_dirname (_data_->filename);
	_data_->directory = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->directory;
	g_mkdir_with_parents (_data_->_tmp1_, 0755);
	_data_->_tmp2_ = g_file_new_for_path (_data_->filename);
	_data_->dest = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->self->priv->source_file;
	_data_->_tmp4_ = g_file_new_for_path (_data_->_tmp3_);
	_data_->source_file = _data_->_tmp4_;
	{
		_data_->_tmp5_ = _data_->source_file;
		_data_->_state_ = 1;
		g_file_read_async (_data_->_tmp5_, G_PRIORITY_DEFAULT, NULL, offline_imf_currency_provider_download_file_async_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp6_ = g_file_read_finish (_data_->_tmp5_, _data_->_res_, &_data_->_inner_error0_);
		_data_->bodyinput = _data_->_tmp6_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp7_ = _data_->dest;
		_data_->_state_ = 2;
		g_file_replace_async (_data_->_tmp7_, NULL, FALSE, G_FILE_CREATE_REPLACE_DESTINATION, G_PRIORITY_DEFAULT, NULL, offline_imf_currency_provider_download_file_async_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp8_ = g_file_replace_finish (_data_->_tmp7_, _data_->_res_, &_data_->_inner_error0_);
		_data_->output = _data_->_tmp8_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->bodyinput);
			goto __catch0_g_error;
		}
		_data_->_tmp9_ = _data_->output;
		_data_->_tmp10_ = _data_->bodyinput;
		_data_->_state_ = 3;
		g_output_stream_splice_async ((GOutputStream*) _data_->_tmp9_, (GInputStream*) _data_->_tmp10_, G_OUTPUT_STREAM_SPLICE_CLOSE_SOURCE | G_OUTPUT_STREAM_SPLICE_CLOSE_TARGET, G_PRIORITY_DEFAULT, NULL, offline_imf_currency_provider_download_file_async_ready, _data_);
		return FALSE;
		_state_3:
		g_output_stream_splice_finish ((GOutputStream*) _data_->_tmp9_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->output);
			_g_object_unref0 (_data_->bodyinput);
			goto __catch0_g_error;
		}
		((AbstractCurrencyProvider*) _data_->self)->loading = FALSE;
		abstract_currency_provider_do_load_rates ((AbstractCurrencyProvider*) _data_->self);
		g_debug ("imf-provider.vala:218: %s rates updated", _data_->source);
		_g_object_unref0 (_data_->output);
		_g_object_unref0 (_data_->bodyinput);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp11_ = _data_->e;
		_data_->_tmp12_ = _data_->_tmp11_->message;
		g_warning ("imf-provider.vala:222: Couldn't download %s currency rate file: %s", _data_->source, _data_->_tmp12_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->source_file);
		_g_object_unref0 (_data_->dest);
		_g_free0 (_data_->directory);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->source_file);
	_g_object_unref0 (_data_->dest);
	_g_free0 (_data_->directory);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
offline_imf_currency_provider_class_init (OfflineImfCurrencyProviderClass * klass,
                                          gpointer klass_data)
{
	offline_imf_currency_provider_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &OfflineImfCurrencyProvider_private_offset);
	((AbstractCurrencyProviderClass *) klass)->download_file_sync = (void (*) (AbstractCurrencyProvider*, const gchar*, const gchar*, const gchar*)) offline_imf_currency_provider_real_download_file_sync;
	((AbstractCurrencyProviderClass *) klass)->download_file_async = (void (*) (AbstractCurrencyProvider*, const gchar*, const gchar*, const gchar*, GAsyncReadyCallback, gpointer)) offline_imf_currency_provider_real_download_file_async;
	((AbstractCurrencyProviderClass *) klass)->download_file_finish = (void (*) (AbstractCurrencyProvider*, GAsyncResult*)) offline_imf_currency_provider_download_file_finish;
	G_OBJECT_CLASS (klass)->finalize = offline_imf_currency_provider_finalize;
}

static void
offline_imf_currency_provider_instance_init (OfflineImfCurrencyProvider * self,
                                             gpointer klass)
{
	self->priv = offline_imf_currency_provider_get_instance_private (self);
}

static void
offline_imf_currency_provider_finalize (GObject * obj)
{
	OfflineImfCurrencyProvider * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_OFFLINE_IMF_CURRENCY_PROVIDER, OfflineImfCurrencyProvider);
	_g_free0 (self->priv->source_file);
	G_OBJECT_CLASS (offline_imf_currency_provider_parent_class)->finalize (obj);
}

static GType
offline_imf_currency_provider_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (OfflineImfCurrencyProviderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) offline_imf_currency_provider_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (OfflineImfCurrencyProvider), 0, (GInstanceInitFunc) offline_imf_currency_provider_instance_init, NULL };
	GType offline_imf_currency_provider_type_id;
	offline_imf_currency_provider_type_id = g_type_register_static (TYPE_IMF_CURRENCY_PROVIDER, "OfflineImfCurrencyProvider", &g_define_type_info, 0);
	OfflineImfCurrencyProvider_private_offset = g_type_add_instance_private (offline_imf_currency_provider_type_id, sizeof (OfflineImfCurrencyProviderPrivate));
	return offline_imf_currency_provider_type_id;
}

GType
offline_imf_currency_provider_get_type (void)
{
	static volatile gsize offline_imf_currency_provider_type_id__once = 0;
	if (g_once_init_enter (&offline_imf_currency_provider_type_id__once)) {
		GType offline_imf_currency_provider_type_id;
		offline_imf_currency_provider_type_id = offline_imf_currency_provider_get_type_once ();
		g_once_init_leave (&offline_imf_currency_provider_type_id__once, offline_imf_currency_provider_type_id);
	}
	return offline_imf_currency_provider_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

