/* vnstat.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from vnstat.vala, do not modify */

/* network-view.vala
 *
 * Copyright (C) 2023–2025 Markus Göllnitz
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Markus Göllnitz <camelcasenick@bewares.it>
 */

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <json-glib/json-glib.h>
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	VNSTAT_MODE_HOURLY = 'h',
	VNSTAT_MODE_DAILY = 'd',
	VNSTAT_MODE_MONTHLY = 'm',
	VNSTAT_MODE_TOP = 't'
} VnstatMode;

#define VNSTAT_TYPE_MODE (vnstat_mode_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define VNSTAT_TYPE_INTERFACE (vnstat_interface_get_type ())
#define VNSTAT_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VNSTAT_TYPE_INTERFACE, VnstatInterface))
#define VNSTAT_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VNSTAT_TYPE_INTERFACE, VnstatInterfaceClass))
#define VNSTAT_IS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VNSTAT_TYPE_INTERFACE))
#define VNSTAT_IS_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VNSTAT_TYPE_INTERFACE))
#define VNSTAT_INTERFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VNSTAT_TYPE_INTERFACE, VnstatInterfaceClass))

typedef struct _VnstatInterface VnstatInterface;
typedef struct _VnstatInterfaceClass VnstatInterfaceClass;

#define VNSTAT_TYPE_TRAFFIC_DATA_POINT (vnstat_traffic_data_point_get_type ())
typedef struct _VnstatTrafficDataPoint VnstatTrafficDataPoint;
typedef struct _VnstatInterfacePrivate VnstatInterfacePrivate;
typedef struct _Block5Data Block5Data;
#define _vnstat_interface_unref0(var) ((var == NULL) ? NULL : (var = (vnstat_interface_unref (var), NULL)))
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))
typedef struct _VnstatParamSpecInterface VnstatParamSpecInterface;

struct _VnstatTrafficDataPoint {
	gint64 timestamp;
	gdouble download;
	gdouble upload;
};

struct _VnstatInterface {
	GTypeInstance parent_instance;
	volatile int ref_count;
	VnstatInterfacePrivate * priv;
};

struct _VnstatInterfaceClass {
	GTypeClass parent_class;
	void (*finalize) (VnstatInterface *self);
};

struct _VnstatInterfacePrivate {
	gchar* _name;
	gboolean _recently_used;
};

struct _Block5Data {
	int _ref_count_;
	VnstatInterface* self;
	GList* traffic;
};

struct _VnstatParamSpecInterface {
	GParamSpec parent_instance;
};

static gint VnstatInterface_private_offset;
static gpointer vnstat_interface_parent_class = NULL;

VALA_EXTERN GType vnstat_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gboolean vnstat_test_exists (void);
static void _vala_JsonNode_free (JsonNode* self);
VALA_EXTERN gpointer vnstat_interface_ref (gpointer instance);
VALA_EXTERN void vnstat_interface_unref (gpointer instance);
VALA_EXTERN GParamSpec* vnstat_param_spec_interface (const gchar* name,
                                         const gchar* nick,
                                         const gchar* blurb,
                                         GType object_type,
                                         GParamFlags flags);
VALA_EXTERN void vnstat_value_set_interface (GValue* value,
                                 gpointer v_object);
VALA_EXTERN void vnstat_value_take_interface (GValue* value,
                                  gpointer v_object);
VALA_EXTERN gpointer vnstat_value_get_interface (const GValue* value);
VALA_EXTERN GType vnstat_interface_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (VnstatInterface, vnstat_interface_unref)
VALA_EXTERN VnstatInterface** vnstat_list_interfaces (gint* result_length1);
static JsonNode* _vala_JsonNode_copy (JsonNode* self);
VALA_EXTERN VnstatInterface* vnstat_interface_new (const gchar* name);
VALA_EXTERN VnstatInterface* vnstat_interface_construct (GType object_type,
                                             const gchar* name);
static void _vala_array_add2 (VnstatInterface** * array,
                       gint* length,
                       gint* size,
                       VnstatInterface* value);
VALA_EXTERN GType vnstat_traffic_data_point_get_type (void) G_GNUC_CONST ;
VALA_EXTERN VnstatTrafficDataPoint* vnstat_traffic_data_point_dup (const VnstatTrafficDataPoint* self);
VALA_EXTERN void vnstat_traffic_data_point_free (VnstatTrafficDataPoint* self);
static void vnstat_interface_set_name (VnstatInterface* self,
                                const gchar* value);
VALA_EXTERN GList* vnstat_interface_get_traffic (VnstatInterface* self,
                                     VnstatMode mode);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void _vnstat_traffic_data_point_free0_ (gpointer var);
static inline void _g_list_free__vnstat_traffic_data_point_free0_ (GList* self);
static void block5_data_unref (void * _userdata_);
VALA_EXTERN const gchar* vnstat_interface_get_name (VnstatInterface* self);
static void ________lambda30_ (Block5Data* _data5_,
                        JsonArray* data_point_array,
                        guint data_point_index,
                        JsonNode* data_point_element);
static void _________lambda30__json_array_foreach (JsonArray* array,
                                            guint index_,
                                            JsonNode* element_node,
                                            gpointer self);
static guint* _uint_dup (guint* self);
static gboolean _uint_equal (const guint * s1,
                      const guint * s2);
static void vnstat_interface_set_recently_used (VnstatInterface* self,
                                         gboolean value);
VALA_EXTERN gboolean vnstat_interface_get_recently_used (VnstatInterface* self);
static void vnstat_interface_finalize (VnstatInterface * obj);
static GType vnstat_interface_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static GType
vnstat_mode_get_type_once (void)
{
	static const GEnumValue values[] = {{VNSTAT_MODE_HOURLY, "VNSTAT_MODE_HOURLY", "hourly"}, {VNSTAT_MODE_DAILY, "VNSTAT_MODE_DAILY", "daily"}, {VNSTAT_MODE_MONTHLY, "VNSTAT_MODE_MONTHLY", "monthly"}, {VNSTAT_MODE_TOP, "VNSTAT_MODE_TOP", "top"}, {0, NULL, NULL}};
	GType vnstat_mode_type_id;
	vnstat_mode_type_id = g_enum_register_static ("VnstatMode", values);
	return vnstat_mode_type_id;
}

GType
vnstat_mode_get_type (void)
{
	static volatile gsize vnstat_mode_type_id__once = 0;
	if (g_once_init_enter (&vnstat_mode_type_id__once)) {
		GType vnstat_mode_type_id;
		vnstat_mode_type_id = vnstat_mode_get_type_once ();
		g_once_init_leave (&vnstat_mode_type_id__once, vnstat_mode_type_id);
	}
	return vnstat_mode_type_id__once;
}

static gpointer
_json_object_ref0 (gpointer self)
{
	return self ? json_object_ref (self) : NULL;
}

static void
_vala_JsonNode_free (JsonNode* self)
{
	g_boxed_free (json_node_get_type (), self);
}

gboolean
vnstat_test_exists (void)
{
	gboolean exists = FALSE;
	gchar* vnstat_stdout = NULL;
	gchar* vnstat_stderr = NULL;
	gint vnstat_status = 0;
	GError* _inner_error0_ = NULL;
	gboolean result;
	exists = FALSE;
	{
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		JsonNode* _tmp3_ = NULL;
		const gchar* _tmp4_;
		JsonNode* _tmp5_;
		JsonNode* _tmp6_ = NULL;
		JsonObject* _tmp7_ = NULL;
		JsonObject* vnstat_json = NULL;
		JsonObject* _tmp9_;
		JsonObject* _tmp10_ = NULL;
		JsonObject* _tmp11_;
		const gchar* _tmp12_ = NULL;
		g_spawn_command_line_sync ("vnstat --json", &_tmp0_, &_tmp1_, &_tmp2_, &_inner_error0_);
		_g_free0 (vnstat_stdout);
		vnstat_stdout = _tmp0_;
		_g_free0 (vnstat_stderr);
		vnstat_stderr = _tmp1_;
		vnstat_status = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_SPAWN_ERROR) {
				goto __catch0_g_spawn_error;
			}
			if (_inner_error0_->domain == JSON_PARSER_ERROR) {
				goto __catch0_json_parser_error;
			}
			goto __catch0_g_error;
		}
		_tmp4_ = vnstat_stdout;
		_tmp5_ = json_from_string (_tmp4_, &_inner_error0_);
		_tmp3_ = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_SPAWN_ERROR) {
				goto __catch0_g_spawn_error;
			}
			if (_inner_error0_->domain == JSON_PARSER_ERROR) {
				goto __catch0_json_parser_error;
			}
			goto __catch0_g_error;
		}
		_tmp6_ = _tmp3_;
		_tmp7_ = NULL;
		if (_tmp6_ != NULL) {
			JsonObject* _tmp8_;
			_tmp8_ = json_node_get_object (_tmp6_);
			_tmp7_ = _tmp8_;
		}
		_tmp9_ = _json_object_ref0 (_tmp7_);
		vnstat_json = _tmp9_;
		_tmp11_ = vnstat_json;
		_tmp10_ = _tmp11_;
		_tmp12_ = NULL;
		if (_tmp10_ != NULL) {
			const gchar* _tmp13_;
			_tmp13_ = json_object_get_string_member (_tmp10_, "jsonversion");
			_tmp12_ = _tmp13_;
		}
		exists = g_strcmp0 (_tmp12_, "2") == 0;
		_json_object_unref0 (vnstat_json);
		__vala_JsonNode_free0 (_tmp3_);
	}
	goto __finally0;
	__catch0_g_spawn_error:
	{
		GError* _error_ = NULL;
		GError* _tmp14_;
		const gchar* _tmp15_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp14_ = _error_;
		_tmp15_ = _tmp14_->message;
		g_info ("vnstat.vala:47: Error connecting to vnstat: %s\n", _tmp15_);
		_g_error_free0 (_error_);
	}
	goto __finally0;
	__catch0_json_parser_error:
	{
		GError* _error_ = NULL;
		GError* _tmp16_;
		const gchar* _tmp17_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp16_ = _error_;
		_tmp17_ = _tmp16_->message;
		g_info ("vnstat.vala:49: Error parsing vnstat's result: %s\n", _tmp17_);
		_g_error_free0 (_error_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp18_;
		const gchar* _tmp19_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp18_ = _error_;
		_tmp19_ = _tmp18_->message;
		g_info ("vnstat.vala:51: Error with vnstat: %s\n", _tmp19_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp20_ = FALSE;
		_g_free0 (vnstat_stderr);
		_g_free0 (vnstat_stdout);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp20_;
	}
	result = exists;
	_g_free0 (vnstat_stderr);
	_g_free0 (vnstat_stdout);
	return result;
}

static JsonNode*
_vala_JsonNode_copy (JsonNode* self)
{
	return g_boxed_copy (json_node_get_type (), self);
}

static gpointer
__vala_JsonNode_copy0 (gpointer self)
{
	return self ? _vala_JsonNode_copy (self) : NULL;
}

static void
_vala_array_add2 (VnstatInterface** * array,
                  gint* length,
                  gint* size,
                  VnstatInterface* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (VnstatInterface*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

VnstatInterface**
vnstat_list_interfaces (gint* result_length1)
{
	VnstatInterface** interfaces = NULL;
	VnstatInterface** _tmp0_;
	gint interfaces_length1;
	gint _interfaces_size_;
	gchar* vnstat_stdout = NULL;
	gchar* vnstat_stderr = NULL;
	gint vnstat_status = 0;
	VnstatInterface** _tmp36_;
	gint _tmp36__length1;
	GError* _inner_error0_ = NULL;
	VnstatInterface** result;
	_tmp0_ = g_new0 (VnstatInterface*, 0 + 1);
	interfaces = _tmp0_;
	interfaces_length1 = 0;
	_interfaces_size_ = interfaces_length1;
	{
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		JsonNode* _tmp4_ = NULL;
		const gchar* _tmp5_;
		JsonNode* _tmp6_;
		JsonNode* _tmp7_ = NULL;
		JsonObject* _tmp8_ = NULL;
		JsonObject* vnstat_json = NULL;
		JsonObject* _tmp10_;
		JsonObject* _tmp11_ = NULL;
		JsonObject* _tmp12_;
		JsonArray* _tmp13_ = NULL;
		JsonArray* _tmp15_ = NULL;
		GList* _tmp16_ = NULL;
		GList* interface_list = NULL;
		GList* _tmp18_;
		GList* _tmp19_;
		g_spawn_command_line_sync ("vnstat --json", &_tmp1_, &_tmp2_, &_tmp3_, &_inner_error0_);
		_g_free0 (vnstat_stdout);
		vnstat_stdout = _tmp1_;
		_g_free0 (vnstat_stderr);
		vnstat_stderr = _tmp2_;
		vnstat_status = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_SPAWN_ERROR) {
				goto __catch0_g_spawn_error;
			}
			if (_inner_error0_->domain == JSON_PARSER_ERROR) {
				goto __catch0_json_parser_error;
			}
			goto __catch0_g_error;
		}
		_tmp5_ = vnstat_stdout;
		_tmp6_ = json_from_string (_tmp5_, &_inner_error0_);
		_tmp4_ = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_SPAWN_ERROR) {
				goto __catch0_g_spawn_error;
			}
			if (_inner_error0_->domain == JSON_PARSER_ERROR) {
				goto __catch0_json_parser_error;
			}
			goto __catch0_g_error;
		}
		_tmp7_ = _tmp4_;
		_tmp8_ = NULL;
		if (_tmp7_ != NULL) {
			JsonObject* _tmp9_;
			_tmp9_ = json_node_get_object (_tmp7_);
			_tmp8_ = _tmp9_;
		}
		_tmp10_ = _json_object_ref0 (_tmp8_);
		vnstat_json = _tmp10_;
		_tmp12_ = vnstat_json;
		_tmp11_ = _tmp12_;
		_tmp13_ = NULL;
		if (_tmp11_ != NULL) {
			JsonArray* _tmp14_;
			_tmp14_ = json_object_get_array_member (_tmp11_, "interfaces");
			_tmp13_ = _tmp14_;
		}
		_tmp15_ = _tmp13_;
		_tmp16_ = NULL;
		if (_tmp15_ != NULL) {
			GList* _tmp17_;
			_tmp17_ = json_array_get_elements (_tmp15_);
			(_tmp16_ == NULL) ? NULL : (_tmp16_ = (g_list_free (_tmp16_), NULL));
			_tmp16_ = _tmp17_;
		}
		_tmp18_ = _tmp16_;
		_tmp16_ = NULL;
		interface_list = _tmp18_;
		_tmp19_ = interface_list;
		if (_tmp19_ != NULL) {
			GList* _tmp20_;
			_tmp20_ = interface_list;
			{
				GList* interface_element_collection = NULL;
				GList* interface_element_it = NULL;
				interface_element_collection = (GList*) _tmp20_;
				for (interface_element_it = interface_element_collection; interface_element_it != NULL; interface_element_it = interface_element_it->next) {
					JsonNode* _tmp21_;
					JsonNode* interface_element = NULL;
					_tmp21_ = __vala_JsonNode_copy0 ((JsonNode*) interface_element_it->data);
					interface_element = _tmp21_;
					{
						JsonObject* interface_json = NULL;
						JsonNode* _tmp22_;
						JsonObject* _tmp23_;
						JsonObject* _tmp24_;
						gchar* interface_name = NULL;
						JsonObject* _tmp25_;
						const gchar* _tmp26_;
						gchar* _tmp27_;
						const gchar* _tmp28_;
						VnstatInterface* _tmp29_;
						_tmp22_ = interface_element;
						_tmp23_ = json_node_get_object (_tmp22_);
						_tmp24_ = _json_object_ref0 ((JsonObject*) _tmp23_);
						interface_json = _tmp24_;
						_tmp25_ = interface_json;
						_tmp26_ = json_object_get_string_member_with_default (_tmp25_, "name", "");
						_tmp27_ = g_strdup (_tmp26_);
						interface_name = _tmp27_;
						_tmp28_ = interface_name;
						_tmp29_ = vnstat_interface_new (_tmp28_);
						_vala_array_add2 (&interfaces, &interfaces_length1, &_interfaces_size_, _tmp29_);
						_g_free0 (interface_name);
						_json_object_unref0 (interface_json);
						__vala_JsonNode_free0 (interface_element);
					}
				}
			}
		}
		(interface_list == NULL) ? NULL : (interface_list = (g_list_free (interface_list), NULL));
		(_tmp16_ == NULL) ? NULL : (_tmp16_ = (g_list_free (_tmp16_), NULL));
		_json_object_unref0 (vnstat_json);
		__vala_JsonNode_free0 (_tmp4_);
	}
	goto __finally0;
	__catch0_g_spawn_error:
	{
		GError* _error_ = NULL;
		GError* _tmp30_;
		const gchar* _tmp31_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp30_ = _error_;
		_tmp31_ = _tmp30_->message;
		g_info ("vnstat.vala:81: Error connecting to vnstat: %s\n", _tmp31_);
		_g_error_free0 (_error_);
	}
	goto __finally0;
	__catch0_json_parser_error:
	{
		GError* _error_ = NULL;
		GError* _tmp32_;
		const gchar* _tmp33_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp32_ = _error_;
		_tmp33_ = _tmp32_->message;
		g_info ("vnstat.vala:83: Error parsing vnstat's result: %s\n", _tmp33_);
		_g_error_free0 (_error_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp34_;
		const gchar* _tmp35_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp34_ = _error_;
		_tmp35_ = _tmp34_->message;
		g_info ("vnstat.vala:85: Error with vnstat: %s\n", _tmp35_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (vnstat_stderr);
		_g_free0 (vnstat_stdout);
		interfaces = (_vala_array_free (interfaces, interfaces_length1, (GDestroyNotify) vnstat_interface_unref), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp36_ = interfaces;
	_tmp36__length1 = interfaces_length1;
	if (result_length1) {
		*result_length1 = _tmp36__length1;
	}
	result = _tmp36_;
	_g_free0 (vnstat_stderr);
	_g_free0 (vnstat_stdout);
	return result;
}

VnstatTrafficDataPoint*
vnstat_traffic_data_point_dup (const VnstatTrafficDataPoint* self)
{
	VnstatTrafficDataPoint* dup;
	dup = g_new0 (VnstatTrafficDataPoint, 1);
	memcpy (dup, self, sizeof (VnstatTrafficDataPoint));
	return dup;
}

void
vnstat_traffic_data_point_free (VnstatTrafficDataPoint* self)
{
	g_free (self);
}

static GType
vnstat_traffic_data_point_get_type_once (void)
{
	GType vnstat_traffic_data_point_type_id;
	vnstat_traffic_data_point_type_id = g_boxed_type_register_static ("VnstatTrafficDataPoint", (GBoxedCopyFunc) vnstat_traffic_data_point_dup, (GBoxedFreeFunc) vnstat_traffic_data_point_free);
	return vnstat_traffic_data_point_type_id;
}

GType
vnstat_traffic_data_point_get_type (void)
{
	static volatile gsize vnstat_traffic_data_point_type_id__once = 0;
	if (g_once_init_enter (&vnstat_traffic_data_point_type_id__once)) {
		GType vnstat_traffic_data_point_type_id;
		vnstat_traffic_data_point_type_id = vnstat_traffic_data_point_get_type_once ();
		g_once_init_leave (&vnstat_traffic_data_point_type_id__once, vnstat_traffic_data_point_type_id);
	}
	return vnstat_traffic_data_point_type_id__once;
}

static inline gpointer
vnstat_interface_get_instance_private (VnstatInterface* self)
{
	return G_STRUCT_MEMBER_P (self, VnstatInterface_private_offset);
}

VnstatInterface*
vnstat_interface_construct (GType object_type,
                            const gchar* name)
{
	VnstatInterface* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (VnstatInterface*) g_type_create_instance (object_type);
	vnstat_interface_set_name (self, name);
	return self;
}

VnstatInterface*
vnstat_interface_new (const gchar* name)
{
	return vnstat_interface_construct (VNSTAT_TYPE_INTERFACE, name);
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
_vnstat_traffic_data_point_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (vnstat_traffic_data_point_free (var), NULL));
}

static inline void
_g_list_free__vnstat_traffic_data_point_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _vnstat_traffic_data_point_free0_);
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		VnstatInterface* self;
		self = _data5_->self;
		(_data5_->traffic == NULL) ? NULL : (_data5_->traffic = (_g_list_free__vnstat_traffic_data_point_free0_ (_data5_->traffic), NULL));
		_vnstat_interface_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static gpointer
_json_array_ref0 (gpointer self)
{
	return self ? json_array_ref (self) : NULL;
}

static gpointer
_vnstat_traffic_data_point_dup0 (gpointer self)
{
	return self ? vnstat_traffic_data_point_dup (self) : NULL;
}

static void
________lambda30_ (Block5Data* _data5_,
                   JsonArray* data_point_array,
                   guint data_point_index,
                   JsonNode* data_point_element)
{
	VnstatInterface* self;
	JsonObject* data_point_json = NULL;
	JsonObject* _tmp0_;
	JsonObject* _tmp1_;
	VnstatTrafficDataPoint _tmp2_ = {0};
	VnstatTrafficDataPoint* _tmp3_;
	self = _data5_->self;
	g_return_if_fail (data_point_array != NULL);
	g_return_if_fail (data_point_element != NULL);
	_tmp0_ = json_node_get_object (data_point_element);
	_tmp1_ = _json_object_ref0 ((JsonObject*) _tmp0_);
	data_point_json = _tmp1_;
	memset (&_tmp2_, 0, sizeof (VnstatTrafficDataPoint));
	_tmp2_.timestamp = json_object_get_int_member (data_point_json, "timestamp");
	_tmp2_.download = (gdouble) json_object_get_int_member (data_point_json, "rx");
	_tmp2_.upload = (gdouble) json_object_get_int_member (data_point_json, "tx");
	_tmp3_ = _vnstat_traffic_data_point_dup0 (&_tmp2_);
	_data5_->traffic = g_list_append (_data5_->traffic, _tmp3_);
	_json_object_unref0 (data_point_json);
}

static void
_________lambda30__json_array_foreach (JsonArray* array,
                                       guint index_,
                                       JsonNode* element_node,
                                       gpointer self)
{
	________lambda30_ (self, array, index_, element_node);
}

static guint*
_uint_dup (guint* self)
{
	guint* dup;
	dup = g_new0 (guint, 1);
	memcpy (dup, self, sizeof (guint));
	return dup;
}

static gpointer
__uint_dup0 (gpointer self)
{
	return self ? _uint_dup (self) : NULL;
}

static gboolean
_uint_equal (const guint * s1,
             const guint * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	return (*s1) == (*s2);
}

GList*
vnstat_interface_get_traffic (VnstatInterface* self,
                              VnstatMode mode)
{
	Block5Data* _data5_;
	gchar* vnstat_stdout = NULL;
	gchar* vnstat_stderr = NULL;
	gint vnstat_status = 0;
	GList* _tmp57_;
	GError* _inner_error0_ = NULL;
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = vnstat_interface_ref (self);
	_data5_->traffic = NULL;
	{
		GEnumValue* _tmp0_;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		_tmp0_ = g_enum_get_value (g_type_class_ref (VNSTAT_TYPE_MODE), mode);
		_tmp1_ = self->priv->_name;
		_tmp2_ = string_to_string (_tmp1_);
		_tmp3_ = g_strconcat ("vnstat --json ", (_tmp0_ != NULL) ? _tmp0_->value_name : NULL, " -i ", _tmp2_, NULL);
		_tmp4_ = _tmp3_;
		g_spawn_command_line_sync (_tmp4_, &_tmp5_, &_tmp6_, &_tmp7_, &_inner_error0_);
		_g_free0 (vnstat_stdout);
		vnstat_stdout = _tmp5_;
		_g_free0 (vnstat_stderr);
		vnstat_stderr = _tmp6_;
		vnstat_status = _tmp7_;
		_g_free0 (_tmp4_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_SPAWN_ERROR) {
				goto __catch0_g_spawn_error;
			}
			if (_inner_error0_->domain == JSON_PARSER_ERROR) {
				goto __catch0_json_parser_error;
			}
			goto __catch0_g_error;
		}
		if (vnstat_status == 0) {
			JsonNode* _tmp8_ = NULL;
			const gchar* _tmp9_;
			JsonNode* _tmp10_;
			JsonNode* _tmp11_ = NULL;
			JsonObject* _tmp12_ = NULL;
			JsonObject* vnstat_json = NULL;
			JsonObject* _tmp14_;
			JsonObject* _tmp15_ = NULL;
			JsonObject* _tmp16_;
			JsonArray* _tmp17_ = NULL;
			JsonArray* _tmp19_ = NULL;
			GList* _tmp20_ = NULL;
			GList* interface_list = NULL;
			GList* _tmp22_;
			GList* _tmp23_;
			_tmp9_ = vnstat_stdout;
			_tmp10_ = json_from_string (_tmp9_, &_inner_error0_);
			_tmp8_ = _tmp10_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_SPAWN_ERROR) {
					goto __catch0_g_spawn_error;
				}
				if (_inner_error0_->domain == JSON_PARSER_ERROR) {
					goto __catch0_json_parser_error;
				}
				goto __catch0_g_error;
			}
			_tmp11_ = _tmp8_;
			_tmp12_ = NULL;
			if (_tmp11_ != NULL) {
				JsonObject* _tmp13_;
				_tmp13_ = json_node_get_object (_tmp11_);
				_tmp12_ = _tmp13_;
			}
			_tmp14_ = _json_object_ref0 (_tmp12_);
			vnstat_json = _tmp14_;
			_tmp16_ = vnstat_json;
			_tmp15_ = _tmp16_;
			_tmp17_ = NULL;
			if (_tmp15_ != NULL) {
				JsonArray* _tmp18_;
				_tmp18_ = json_object_get_array_member (_tmp15_, "interfaces");
				_tmp17_ = _tmp18_;
			}
			_tmp19_ = _tmp17_;
			_tmp20_ = NULL;
			if (_tmp19_ != NULL) {
				GList* _tmp21_;
				_tmp21_ = json_array_get_elements (_tmp19_);
				(_tmp20_ == NULL) ? NULL : (_tmp20_ = (g_list_free (_tmp20_), NULL));
				_tmp20_ = _tmp21_;
			}
			_tmp22_ = _tmp20_;
			_tmp20_ = NULL;
			interface_list = _tmp22_;
			_tmp23_ = interface_list;
			if (_tmp23_ != NULL) {
				GList* _tmp24_;
				_tmp24_ = interface_list;
				{
					GList* interface_element_collection = NULL;
					GList* interface_element_it = NULL;
					interface_element_collection = (GList*) _tmp24_;
					for (interface_element_it = interface_element_collection; interface_element_it != NULL; interface_element_it = interface_element_it->next) {
						JsonNode* _tmp25_;
						JsonNode* interface_element = NULL;
						_tmp25_ = __vala_JsonNode_copy0 ((JsonNode*) interface_element_it->data);
						interface_element = _tmp25_;
						{
							JsonObject* interface_json = NULL;
							JsonNode* _tmp26_;
							JsonObject* _tmp27_;
							JsonObject* _tmp28_;
							gchar* member_name = NULL;
							gchar* _tmp29_;
							JsonObject* _tmp34_ = NULL;
							JsonObject* _tmp35_;
							JsonObject* _tmp36_ = NULL;
							JsonObject* _tmp38_ = NULL;
							JsonArray* _tmp39_ = NULL;
							JsonArray* traffic_json = NULL;
							JsonArray* _tmp42_;
							JsonArray* _tmp43_ = NULL;
							JsonArray* _tmp44_;
							JsonArray* _tmp45_ = NULL;
							JsonArray* _tmp46_;
							guint* _tmp47_ = NULL;
							guint _tmp50_;
							_tmp26_ = interface_element;
							_tmp27_ = json_node_get_object (_tmp26_);
							_tmp28_ = _json_object_ref0 (_tmp27_);
							interface_json = _tmp28_;
							_tmp29_ = g_strdup ("");
							member_name = _tmp29_;
							switch (mode) {
								case VNSTAT_MODE_HOURLY:
								{
									gchar* _tmp30_;
									_tmp30_ = g_strdup ("hour");
									_g_free0 (member_name);
									member_name = _tmp30_;
									break;
								}
								case VNSTAT_MODE_DAILY:
								{
									gchar* _tmp31_;
									_tmp31_ = g_strdup ("day");
									_g_free0 (member_name);
									member_name = _tmp31_;
									break;
								}
								case VNSTAT_MODE_MONTHLY:
								{
									gchar* _tmp32_;
									_tmp32_ = g_strdup ("month");
									_g_free0 (member_name);
									member_name = _tmp32_;
									break;
								}
								case VNSTAT_MODE_TOP:
								{
									gchar* _tmp33_;
									_tmp33_ = g_strdup ("top");
									_g_free0 (member_name);
									member_name = _tmp33_;
									break;
								}
								default:
								break;
							}
							_tmp35_ = interface_json;
							_tmp34_ = _tmp35_;
							_tmp36_ = NULL;
							if (_tmp34_ != NULL) {
								JsonObject* _tmp37_;
								_tmp37_ = json_object_get_object_member (_tmp34_, "traffic");
								_tmp36_ = _tmp37_;
							}
							_tmp38_ = _tmp36_;
							_tmp39_ = NULL;
							if (_tmp38_ != NULL) {
								const gchar* _tmp40_;
								JsonArray* _tmp41_;
								_tmp40_ = member_name;
								_tmp41_ = json_object_get_array_member (_tmp38_, _tmp40_);
								_tmp39_ = _tmp41_;
							}
							_tmp42_ = _json_array_ref0 (_tmp39_);
							traffic_json = _tmp42_;
							_tmp44_ = traffic_json;
							_tmp43_ = _tmp44_;
							if (_tmp43_ != NULL) {
								json_array_foreach_element (_tmp43_, _________lambda30__json_array_foreach, _data5_);
							}
							_tmp46_ = traffic_json;
							_tmp45_ = _tmp46_;
							_tmp47_ = NULL;
							if (_tmp45_ != NULL) {
								guint _tmp48_;
								guint* _tmp49_;
								_tmp48_ = json_array_get_length (_tmp45_);
								_tmp49_ = __uint_dup0 (&_tmp48_);
								_g_free0 (_tmp47_);
								_tmp47_ = _tmp49_;
							}
							_tmp50_ = (guint) 0;
							vnstat_interface_set_recently_used (self, _uint_equal (_tmp47_, &_tmp50_) != TRUE);
							_g_free0 (_tmp47_);
							_json_array_unref0 (traffic_json);
							_g_free0 (member_name);
							_json_object_unref0 (interface_json);
							__vala_JsonNode_free0 (interface_element);
						}
					}
				}
			}
			(interface_list == NULL) ? NULL : (interface_list = (g_list_free (interface_list), NULL));
			(_tmp20_ == NULL) ? NULL : (_tmp20_ = (g_list_free (_tmp20_), NULL));
			_json_object_unref0 (vnstat_json);
			__vala_JsonNode_free0 (_tmp8_);
		}
	}
	goto __finally0;
	__catch0_g_spawn_error:
	{
		GError* _error_ = NULL;
		GError* _tmp51_;
		const gchar* _tmp52_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp51_ = _error_;
		_tmp52_ = _tmp51_->message;
		g_info ("vnstat.vala:159: Error connecting to vnstat: %s\n", _tmp52_);
		_g_error_free0 (_error_);
	}
	goto __finally0;
	__catch0_json_parser_error:
	{
		GError* _error_ = NULL;
		GError* _tmp53_;
		const gchar* _tmp54_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp53_ = _error_;
		_tmp54_ = _tmp53_->message;
		g_info ("vnstat.vala:161: Error parsing vnstat's result: %s\n", _tmp54_);
		_g_error_free0 (_error_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp55_;
		const gchar* _tmp56_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp55_ = _error_;
		_tmp56_ = _tmp55_->message;
		g_info ("vnstat.vala:163: Error with vnstat: %s\n", _tmp56_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (vnstat_stderr);
		_g_free0 (vnstat_stdout);
		block5_data_unref (_data5_);
		_data5_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp57_ = _data5_->traffic;
	_data5_->traffic = NULL;
	result = _tmp57_;
	_g_free0 (vnstat_stderr);
	_g_free0 (vnstat_stdout);
	block5_data_unref (_data5_);
	_data5_ = NULL;
	return result;
}

const gchar*
vnstat_interface_get_name (VnstatInterface* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

static void
vnstat_interface_set_name (VnstatInterface* self,
                           const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp0_;
}

gboolean
vnstat_interface_get_recently_used (VnstatInterface* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_recently_used;
	return result;
}

static void
vnstat_interface_set_recently_used (VnstatInterface* self,
                                    gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_recently_used = value;
}

static void
vnstat_value_interface_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
vnstat_value_interface_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vnstat_interface_unref (value->data[0].v_pointer);
	}
}

static void
vnstat_value_interface_copy_value (const GValue* src_value,
                                   GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vnstat_interface_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
vnstat_value_interface_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
vnstat_value_interface_collect_value (GValue* value,
                                      guint n_collect_values,
                                      GTypeCValue* collect_values,
                                      guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		VnstatInterface * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vnstat_interface_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
vnstat_value_interface_lcopy_value (const GValue* value,
                                    guint n_collect_values,
                                    GTypeCValue* collect_values,
                                    guint collect_flags)
{
	VnstatInterface ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vnstat_interface_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
vnstat_param_spec_interface (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags)
{
	VnstatParamSpecInterface* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VNSTAT_TYPE_INTERFACE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
vnstat_value_get_interface (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VNSTAT_TYPE_INTERFACE), NULL);
	return value->data[0].v_pointer;
}

void
vnstat_value_set_interface (GValue* value,
                            gpointer v_object)
{
	VnstatInterface * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VNSTAT_TYPE_INTERFACE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VNSTAT_TYPE_INTERFACE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vnstat_interface_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vnstat_interface_unref (old);
	}
}

void
vnstat_value_take_interface (GValue* value,
                             gpointer v_object)
{
	VnstatInterface * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VNSTAT_TYPE_INTERFACE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VNSTAT_TYPE_INTERFACE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vnstat_interface_unref (old);
	}
}

static void
vnstat_interface_class_init (VnstatInterfaceClass * klass,
                             gpointer klass_data)
{
	vnstat_interface_parent_class = g_type_class_peek_parent (klass);
	((VnstatInterfaceClass *) klass)->finalize = vnstat_interface_finalize;
	g_type_class_adjust_private_offset (klass, &VnstatInterface_private_offset);
}

static void
vnstat_interface_instance_init (VnstatInterface * self,
                                gpointer klass)
{
	self->priv = vnstat_interface_get_instance_private (self);
	self->ref_count = 1;
}

static void
vnstat_interface_finalize (VnstatInterface * obj)
{
	VnstatInterface * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VNSTAT_TYPE_INTERFACE, VnstatInterface);
	g_signal_handlers_destroy (self);
	_g_free0 (self->priv->_name);
}

static GType
vnstat_interface_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { vnstat_value_interface_init, vnstat_value_interface_free_value, vnstat_value_interface_copy_value, vnstat_value_interface_peek_pointer, "p", vnstat_value_interface_collect_value, "p", vnstat_value_interface_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (VnstatInterfaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vnstat_interface_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VnstatInterface), 0, (GInstanceInitFunc) vnstat_interface_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType vnstat_interface_type_id;
	vnstat_interface_type_id = g_type_register_fundamental (g_type_fundamental_next (), "VnstatInterface", &g_define_type_info, &g_define_type_fundamental_info, 0);
	VnstatInterface_private_offset = g_type_add_instance_private (vnstat_interface_type_id, sizeof (VnstatInterfacePrivate));
	return vnstat_interface_type_id;
}

GType
vnstat_interface_get_type (void)
{
	static volatile gsize vnstat_interface_type_id__once = 0;
	if (g_once_init_enter (&vnstat_interface_type_id__once)) {
		GType vnstat_interface_type_id;
		vnstat_interface_type_id = vnstat_interface_get_type_once ();
		g_once_init_leave (&vnstat_interface_type_id__once, vnstat_interface_type_id);
	}
	return vnstat_interface_type_id__once;
}

gpointer
vnstat_interface_ref (gpointer instance)
{
	VnstatInterface * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
vnstat_interface_unref (gpointer instance)
{
	VnstatInterface * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VNSTAT_INTERFACE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

