/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, digital, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_digital_map_bb = R"doc(output[i] = map[input[i]]

This block maps an incoming signal to the value in the map. The block expects that the incoming signal has a maximum value of len(map)-1.


-> output[i] = map[input[i]]

Constructor Specific Documentation:

Make a map block.

Args:
    map : a vector of integers that maps x to map[x].)doc";


static const char* __doc_gr_digital_map_bb_map_bb_0 = R"doc()doc";


static const char* __doc_gr_digital_map_bb_map_bb_1 = R"doc()doc";


static const char* __doc_gr_digital_map_bb_make = R"doc(output[i] = map[input[i]]

This block maps an incoming signal to the value in the map. The block expects that the incoming signal has a maximum value of len(map)-1.


-> output[i] = map[input[i]]

Constructor Specific Documentation:

Make a map block.

Args:
    map : a vector of integers that maps x to map[x].)doc";


static const char* __doc_gr_digital_map_bb_set_map = R"doc()doc";


static const char* __doc_gr_digital_map_bb_map = R"doc()doc";
