/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, digital, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_digital_packet_headerparser_b = R"doc(Post header metadata as a PMT.

In a sense, this is the inverse block to packet_headergenerator_bb. The difference is, the parsed header is not output as a stream, but as a PMT dictionary, which is published to message port with the id \"header_data\".


The dictionary consists of the tags created by the header formatter object. You should be able to use the exact same formatter object as used on the Tx side in the packet_headergenerator_bb.


If only a header length is given, this block uses the default header format.

Constructor Specific Documentation:



Args:
    header_formatter : Header object. This should be the same as used for packet_headergenerator_bb.)doc";


static const char* __doc_gr_digital_packet_headerparser_b_packet_headerparser_b =
    R"doc()doc";


static const char* __doc_gr_digital_packet_headerparser_b_make_0 = R"doc()doc";


static const char* __doc_gr_digital_packet_headerparser_b_make_1 = R"doc()doc";
