// Code generated by astool. DO NOT EDIT.

package typeendpoints

import vocab "code.superseriousbusiness.org/activity/streams/vocab"

// A json object which maps additional (typically server/domain-wide) endpoints
// which may be useful either for this actor or someone referencing this
// actor. This mapping may be nested inside the actor document as the value or
// may be a link to a JSON-LD document with these properties.
type ActivityStreamsEndpoints struct {
	JSONLDId                   vocab.JSONLDIdProperty
	ActivityStreamsSharedInbox vocab.ActivityStreamsSharedInboxProperty
	alias                      string
	unknown                    map[string]interface{}
}

// ActivityStreamsEndpointsExtends returns true if the Endpoints type extends from
// the other type.
func ActivityStreamsEndpointsExtends(other vocab.Type) bool {
	// Shortcut implementation: this does not extend anything.
	return false
}

// DeserializeEndpoints creates a Endpoints from a map representation that has
// been unmarshalled from a text or binary format.
func DeserializeEndpoints(m map[string]interface{}, aliasMap map[string]string) (*ActivityStreamsEndpoints, error) {
	alias := ""
	if a, ok := aliasMap["https://www.w3.org/ns/activitystreams"]; ok {
		alias = a
	}
	this := &ActivityStreamsEndpoints{
		alias:   alias,
		unknown: make(map[string]interface{}),
	}

	// Begin: Known property deserialization
	if p, err := mgr.DeserializeIdPropertyJSONLD()(m, aliasMap); err != nil {
		return nil, err
	} else if p != nil {
		this.JSONLDId = p
	}
	if p, err := mgr.DeserializeSharedInboxPropertyActivityStreams()(m, aliasMap); err != nil {
		return nil, err
	} else if p != nil {
		this.ActivityStreamsSharedInbox = p
	}
	// End: Known property deserialization

	// Begin: Unknown deserialization
	for k, v := range m {
		// Begin: Code that ensures a property name is unknown
		if k == "id" {
			continue
		} else if k == "sharedInbox" {
			continue
		} // End: Code that ensures a property name is unknown

		this.unknown[k] = v
	}
	// End: Unknown deserialization

	return this, nil
}

// EndpointsIsDisjointWith returns true if the other provided type is disjoint
// with the Endpoints type.
func EndpointsIsDisjointWith(other vocab.Type) bool {
	// Shortcut implementation: is not disjoint with anything.
	return false
}

// EndpointsIsExtendedBy returns true if the other provided type extends from the
// Endpoints type. Note that it returns false if the types are the same; see
// the "IsOrExtendsEndpoints" variant instead.
func EndpointsIsExtendedBy(other vocab.Type) bool {
	// Shortcut implementation: is not extended by anything.
	return false
}

// IsOrExtendsEndpoints returns true if the other provided type is the Endpoints
// type or extends from the Endpoints type.
func IsOrExtendsEndpoints(other vocab.Type) bool {
	if other.GetTypeName() == "Endpoints" {
		return true
	}
	return EndpointsIsExtendedBy(other)
}

// NewActivityStreamsEndpoints creates a new Endpoints type
func NewActivityStreamsEndpoints() *ActivityStreamsEndpoints {
	return &ActivityStreamsEndpoints{
		alias:   "",
		unknown: make(map[string]interface{}),
	}
}

// GetActivityStreamsSharedInbox returns the "sharedInbox" property if it exists,
// and nil otherwise.
func (this ActivityStreamsEndpoints) GetActivityStreamsSharedInbox() vocab.ActivityStreamsSharedInboxProperty {
	return this.ActivityStreamsSharedInbox
}

// GetJSONLDId returns the "id" property if it exists, and nil otherwise.
func (this ActivityStreamsEndpoints) GetJSONLDId() vocab.JSONLDIdProperty {
	return this.JSONLDId
}

// GetTypeName returns the name of this type.
func (this ActivityStreamsEndpoints) GetTypeName() string {
	return "Endpoints"
}

// GetUnknownProperties returns the unknown properties for the Endpoints type.
// Note that this should not be used by app developers. It is only used to
// help determine which implementation is LessThan the other. Developers who
// are creating a different implementation of this type's interface can use
// this method in their LessThan implementation, but routine ActivityPub
// applications should not use this to bypass the code generation tool.
func (this ActivityStreamsEndpoints) GetUnknownProperties() map[string]interface{} {
	return this.unknown
}

// IsExtending returns true if the Endpoints type extends from the other type.
func (this ActivityStreamsEndpoints) IsExtending(other vocab.Type) bool {
	return ActivityStreamsEndpointsExtends(other)
}

// JSONLDContext returns the JSONLD URIs required in the context string for this
// type and the specific properties that are set. The value in the map is the
// alias used to import the type and its properties.
func (this ActivityStreamsEndpoints) JSONLDContext() map[string]string {
	m := map[string]string{"https://www.w3.org/ns/activitystreams": this.alias}
	m = this.helperJSONLDContext(this.JSONLDId, m)
	m = this.helperJSONLDContext(this.ActivityStreamsSharedInbox, m)

	return m
}

// LessThan computes if this Endpoints is lesser, with an arbitrary but stable
// determination.
func (this ActivityStreamsEndpoints) LessThan(o vocab.ActivityStreamsEndpoints) bool {
	// Begin: Compare known properties
	// Compare property "id"
	if lhs, rhs := this.JSONLDId, o.GetJSONLDId(); lhs != nil && rhs != nil {
		if lhs.LessThan(rhs) {
			return true
		} else if rhs.LessThan(lhs) {
			return false
		}
	} else if lhs == nil && rhs != nil {
		// Nil is less than anything else
		return true
	} else if rhs != nil && rhs == nil {
		// Anything else is greater than nil
		return false
	} // Else: Both are nil
	// Compare property "sharedInbox"
	if lhs, rhs := this.ActivityStreamsSharedInbox, o.GetActivityStreamsSharedInbox(); lhs != nil && rhs != nil {
		if lhs.LessThan(rhs) {
			return true
		} else if rhs.LessThan(lhs) {
			return false
		}
	} else if lhs == nil && rhs != nil {
		// Nil is less than anything else
		return true
	} else if rhs != nil && rhs == nil {
		// Anything else is greater than nil
		return false
	} // Else: Both are nil
	// End: Compare known properties

	// Begin: Compare unknown properties (only by number of them)
	if len(this.unknown) < len(o.GetUnknownProperties()) {
		return true
	} else if len(o.GetUnknownProperties()) < len(this.unknown) {
		return false
	} // End: Compare unknown properties (only by number of them)

	// All properties are the same.
	return false
}

// Serialize converts this into an interface representation suitable for
// marshalling into a text or binary format.
func (this ActivityStreamsEndpoints) Serialize() (map[string]interface{}, error) {
	m := make(map[string]interface{})
	// Begin: Serialize known properties
	// Maybe serialize property "id"
	if this.JSONLDId != nil {
		if i, err := this.JSONLDId.Serialize(); err != nil {
			return nil, err
		} else if i != nil {
			m[this.JSONLDId.Name()] = i
		}
	}
	// Maybe serialize property "sharedInbox"
	if this.ActivityStreamsSharedInbox != nil {
		if i, err := this.ActivityStreamsSharedInbox.Serialize(); err != nil {
			return nil, err
		} else if i != nil {
			m[this.ActivityStreamsSharedInbox.Name()] = i
		}
	}
	// End: Serialize known properties

	// Begin: Serialize unknown properties
	for k, v := range this.unknown {
		// To be safe, ensure we aren't overwriting a known property
		if _, has := m[k]; !has {
			m[k] = v
		}
	}
	// End: Serialize unknown properties

	return m, nil
}

// SetActivityStreamsSharedInbox sets the "sharedInbox" property.
func (this *ActivityStreamsEndpoints) SetActivityStreamsSharedInbox(i vocab.ActivityStreamsSharedInboxProperty) {
	this.ActivityStreamsSharedInbox = i
}

// SetJSONLDId sets the "id" property.
func (this *ActivityStreamsEndpoints) SetJSONLDId(i vocab.JSONLDIdProperty) {
	this.JSONLDId = i
}

// VocabularyURI returns the vocabulary's URI as a string.
func (this ActivityStreamsEndpoints) VocabularyURI() string {
	return "https://www.w3.org/ns/activitystreams"
}

// helperJSONLDContext obtains the context uris and their aliases from a property,
// if it is not nil.
func (this ActivityStreamsEndpoints) helperJSONLDContext(i jsonldContexter, toMerge map[string]string) map[string]string {
	if i == nil {
		return toMerge
	}
	for k, v := range i.JSONLDContext() {
		/*
		   Since the literal maps in this function are determined at
		   code-generation time, this loop should not overwrite an existing key with a
		   new value.
		*/
		toMerge[k] = v
	}
	return toMerge
}
