{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Note: /@oldValue@/ field of t'GI.Atk.Structs.PropertyValues.PropertyValues' will not contain a
-- valid value. This is a field defined with the purpose of contain
-- the previous value of the property, but is not used anymore.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Atk.Structs.PropertyValues
    ( 

-- * Exported types
    PropertyValues(..)                      ,
    newZeroPropertyValues                   ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolvePropertyValuesMethod             ,
#endif



 -- * Properties


-- ** newValue #attr:newValue#
-- | The new value of the named property.

    clearPropertyValuesNewValue             ,
    getPropertyValuesNewValue               ,
#if defined(ENABLE_OVERLOADING)
    propertyValues_newValue                 ,
#endif
    setPropertyValuesNewValue               ,


-- ** oldValue #attr:oldValue#
-- | NULL. This field is not used anymore.

    clearPropertyValuesOldValue             ,
    getPropertyValuesOldValue               ,
#if defined(ENABLE_OVERLOADING)
    propertyValues_oldValue                 ,
#endif
    setPropertyValuesOldValue               ,


-- ** propertyName #attr:propertyName#
-- | The name of the ATK property which has changed.

    clearPropertyValuesPropertyName         ,
    getPropertyValuesPropertyName           ,
#if defined(ENABLE_OVERLOADING)
    propertyValues_propertyName             ,
#endif
    setPropertyValuesPropertyName           ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- | Memory-managed wrapper type.
newtype PropertyValues = PropertyValues (SP.ManagedPtr PropertyValues)
    deriving (Eq)

instance SP.ManagedPtrNewtype PropertyValues where
    toManagedPtr (PropertyValues p) = p

instance BoxedPtr PropertyValues where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 56 >=> B.ManagedPtr.wrapPtr PropertyValues)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr PropertyValues where
    boxedPtrCalloc = callocBytes 56


-- | Construct a t'PropertyValues' struct initialized to zero.
newZeroPropertyValues :: MonadIO m => m PropertyValues
newZeroPropertyValues = liftIO $ boxedPtrCalloc >>= wrapPtr PropertyValues

instance tag ~ 'AttrSet => Constructible PropertyValues tag where
    new _ attrs = do
        o <- newZeroPropertyValues
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@property_name@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' propertyValues #propertyName
-- @
getPropertyValuesPropertyName :: MonadIO m => PropertyValues -> m (Maybe T.Text)
getPropertyValuesPropertyName s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO CString
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- cstringToText val'
        return val''
    return result

-- | Set the value of the “@property_name@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' propertyValues [ #propertyName 'Data.GI.Base.Attributes.:=' value ]
-- @
setPropertyValuesPropertyName :: MonadIO m => PropertyValues -> CString -> m ()
setPropertyValuesPropertyName s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: CString)

-- | Set the value of the “@property_name@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #propertyName
-- @
clearPropertyValuesPropertyName :: MonadIO m => PropertyValues -> m ()
clearPropertyValuesPropertyName s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (FP.nullPtr :: CString)

#if defined(ENABLE_OVERLOADING)
data PropertyValuesPropertyNameFieldInfo
instance AttrInfo PropertyValuesPropertyNameFieldInfo where
    type AttrBaseTypeConstraint PropertyValuesPropertyNameFieldInfo = (~) PropertyValues
    type AttrAllowedOps PropertyValuesPropertyNameFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint PropertyValuesPropertyNameFieldInfo = (~) CString
    type AttrTransferTypeConstraint PropertyValuesPropertyNameFieldInfo = (~)CString
    type AttrTransferType PropertyValuesPropertyNameFieldInfo = CString
    type AttrGetType PropertyValuesPropertyNameFieldInfo = Maybe T.Text
    type AttrLabel PropertyValuesPropertyNameFieldInfo = "property_name"
    type AttrOrigin PropertyValuesPropertyNameFieldInfo = PropertyValues
    attrGet = getPropertyValuesPropertyName
    attrSet = setPropertyValuesPropertyName
    attrConstruct = undefined
    attrClear = clearPropertyValuesPropertyName
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Structs.PropertyValues.propertyName"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Structs-PropertyValues.html#g:attr:propertyName"
        })

propertyValues_propertyName :: AttrLabelProxy "propertyName"
propertyValues_propertyName = AttrLabelProxy

#endif


-- | Get the value of the “@old_value@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' propertyValues #oldValue
-- @
getPropertyValuesOldValue :: MonadIO m => PropertyValues -> m (Maybe GValue)
getPropertyValuesOldValue s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO (Ptr GValue)
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- B.GValue.newGValueFromPtr val'
        return val''
    return result

-- | Set the value of the “@old_value@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' propertyValues [ #oldValue 'Data.GI.Base.Attributes.:=' value ]
-- @
setPropertyValuesOldValue :: MonadIO m => PropertyValues -> Ptr GValue -> m ()
setPropertyValuesOldValue s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: Ptr GValue)

-- | Set the value of the “@old_value@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #oldValue
-- @
clearPropertyValuesOldValue :: MonadIO m => PropertyValues -> m ()
clearPropertyValuesOldValue s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (FP.nullPtr :: Ptr GValue)

#if defined(ENABLE_OVERLOADING)
data PropertyValuesOldValueFieldInfo
instance AttrInfo PropertyValuesOldValueFieldInfo where
    type AttrBaseTypeConstraint PropertyValuesOldValueFieldInfo = (~) PropertyValues
    type AttrAllowedOps PropertyValuesOldValueFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint PropertyValuesOldValueFieldInfo = (~) (Ptr GValue)
    type AttrTransferTypeConstraint PropertyValuesOldValueFieldInfo = (~)(Ptr GValue)
    type AttrTransferType PropertyValuesOldValueFieldInfo = (Ptr GValue)
    type AttrGetType PropertyValuesOldValueFieldInfo = Maybe GValue
    type AttrLabel PropertyValuesOldValueFieldInfo = "old_value"
    type AttrOrigin PropertyValuesOldValueFieldInfo = PropertyValues
    attrGet = getPropertyValuesOldValue
    attrSet = setPropertyValuesOldValue
    attrConstruct = undefined
    attrClear = clearPropertyValuesOldValue
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Structs.PropertyValues.oldValue"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Structs-PropertyValues.html#g:attr:oldValue"
        })

propertyValues_oldValue :: AttrLabelProxy "oldValue"
propertyValues_oldValue = AttrLabelProxy

#endif


-- | Get the value of the “@new_value@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' propertyValues #newValue
-- @
getPropertyValuesNewValue :: MonadIO m => PropertyValues -> m (Maybe GValue)
getPropertyValuesNewValue s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 32) :: IO (Ptr GValue)
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- B.GValue.newGValueFromPtr val'
        return val''
    return result

-- | Set the value of the “@new_value@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' propertyValues [ #newValue 'Data.GI.Base.Attributes.:=' value ]
-- @
setPropertyValuesNewValue :: MonadIO m => PropertyValues -> Ptr GValue -> m ()
setPropertyValuesNewValue s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 32) (val :: Ptr GValue)

-- | Set the value of the “@new_value@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #newValue
-- @
clearPropertyValuesNewValue :: MonadIO m => PropertyValues -> m ()
clearPropertyValuesNewValue s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 32) (FP.nullPtr :: Ptr GValue)

#if defined(ENABLE_OVERLOADING)
data PropertyValuesNewValueFieldInfo
instance AttrInfo PropertyValuesNewValueFieldInfo where
    type AttrBaseTypeConstraint PropertyValuesNewValueFieldInfo = (~) PropertyValues
    type AttrAllowedOps PropertyValuesNewValueFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint PropertyValuesNewValueFieldInfo = (~) (Ptr GValue)
    type AttrTransferTypeConstraint PropertyValuesNewValueFieldInfo = (~)(Ptr GValue)
    type AttrTransferType PropertyValuesNewValueFieldInfo = (Ptr GValue)
    type AttrGetType PropertyValuesNewValueFieldInfo = Maybe GValue
    type AttrLabel PropertyValuesNewValueFieldInfo = "new_value"
    type AttrOrigin PropertyValuesNewValueFieldInfo = PropertyValues
    attrGet = getPropertyValuesNewValue
    attrSet = setPropertyValuesNewValue
    attrConstruct = undefined
    attrClear = clearPropertyValuesNewValue
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Structs.PropertyValues.newValue"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Structs-PropertyValues.html#g:attr:newValue"
        })

propertyValues_newValue :: AttrLabelProxy "newValue"
propertyValues_newValue = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList PropertyValues
type instance O.AttributeList PropertyValues = PropertyValuesAttributeList
type PropertyValuesAttributeList = ('[ '("propertyName", PropertyValuesPropertyNameFieldInfo), '("oldValue", PropertyValuesOldValueFieldInfo), '("newValue", PropertyValuesNewValueFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolvePropertyValuesMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolvePropertyValuesMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolvePropertyValuesMethod t PropertyValues, O.OverloadedMethod info PropertyValues p) => OL.IsLabel t (PropertyValues -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolvePropertyValuesMethod t PropertyValues, O.OverloadedMethod info PropertyValues p, R.HasField t PropertyValues p) => R.HasField t PropertyValues p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolvePropertyValuesMethod t PropertyValues, O.OverloadedMethodInfo info PropertyValues) => OL.IsLabel t (O.MethodProxy info PropertyValues) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


