{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A @GdkPixbufFormat@ contains information about the image format accepted
-- by a module.
-- 
-- Only modules should access the fields directly, applications should
-- use the @gdk_pixbuf_format_*@ family of functions.
-- 
-- /Since: 2.2/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GdkPixbuf.Structs.PixbufFormat
    ( 

-- * Exported types
    PixbufFormat(..)                        ,
    newZeroPixbufFormat                     ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [copy]("GI.GdkPixbuf.Structs.PixbufFormat#g:method:copy"), [free]("GI.GdkPixbuf.Structs.PixbufFormat#g:method:free"), [isDisabled]("GI.GdkPixbuf.Structs.PixbufFormat#g:method:isDisabled"), [isSaveOptionSupported]("GI.GdkPixbuf.Structs.PixbufFormat#g:method:isSaveOptionSupported"), [isScalable]("GI.GdkPixbuf.Structs.PixbufFormat#g:method:isScalable"), [isWritable]("GI.GdkPixbuf.Structs.PixbufFormat#g:method:isWritable").
-- 
-- ==== Getters
-- [getDescription]("GI.GdkPixbuf.Structs.PixbufFormat#g:method:getDescription"), [getExtensions]("GI.GdkPixbuf.Structs.PixbufFormat#g:method:getExtensions"), [getLicense]("GI.GdkPixbuf.Structs.PixbufFormat#g:method:getLicense"), [getMimeTypes]("GI.GdkPixbuf.Structs.PixbufFormat#g:method:getMimeTypes"), [getName]("GI.GdkPixbuf.Structs.PixbufFormat#g:method:getName").
-- 
-- ==== Setters
-- [setDisabled]("GI.GdkPixbuf.Structs.PixbufFormat#g:method:setDisabled").

#if defined(ENABLE_OVERLOADING)
    ResolvePixbufFormatMethod               ,
#endif

-- ** copy #method:copy#

#if defined(ENABLE_OVERLOADING)
    PixbufFormatCopyMethodInfo              ,
#endif
    pixbufFormatCopy                        ,


-- ** free #method:free#

#if defined(ENABLE_OVERLOADING)
    PixbufFormatFreeMethodInfo              ,
#endif
    pixbufFormatFree                        ,


-- ** getDescription #method:getDescription#

#if defined(ENABLE_OVERLOADING)
    PixbufFormatGetDescriptionMethodInfo    ,
#endif
    pixbufFormatGetDescription              ,


-- ** getExtensions #method:getExtensions#

#if defined(ENABLE_OVERLOADING)
    PixbufFormatGetExtensionsMethodInfo     ,
#endif
    pixbufFormatGetExtensions               ,


-- ** getLicense #method:getLicense#

#if defined(ENABLE_OVERLOADING)
    PixbufFormatGetLicenseMethodInfo        ,
#endif
    pixbufFormatGetLicense                  ,


-- ** getMimeTypes #method:getMimeTypes#

#if defined(ENABLE_OVERLOADING)
    PixbufFormatGetMimeTypesMethodInfo      ,
#endif
    pixbufFormatGetMimeTypes                ,


-- ** getName #method:getName#

#if defined(ENABLE_OVERLOADING)
    PixbufFormatGetNameMethodInfo           ,
#endif
    pixbufFormatGetName                     ,


-- ** isDisabled #method:isDisabled#

#if defined(ENABLE_OVERLOADING)
    PixbufFormatIsDisabledMethodInfo        ,
#endif
    pixbufFormatIsDisabled                  ,


-- ** isSaveOptionSupported #method:isSaveOptionSupported#

#if defined(ENABLE_OVERLOADING)
    PixbufFormatIsSaveOptionSupportedMethodInfo,
#endif
    pixbufFormatIsSaveOptionSupported       ,


-- ** isScalable #method:isScalable#

#if defined(ENABLE_OVERLOADING)
    PixbufFormatIsScalableMethodInfo        ,
#endif
    pixbufFormatIsScalable                  ,


-- ** isWritable #method:isWritable#

#if defined(ENABLE_OVERLOADING)
    PixbufFormatIsWritableMethodInfo        ,
#endif
    pixbufFormatIsWritable                  ,


-- ** setDisabled #method:setDisabled#

#if defined(ENABLE_OVERLOADING)
    PixbufFormatSetDisabledMethodInfo       ,
#endif
    pixbufFormatSetDisabled                 ,




 -- * Properties


-- ** description #attr:description#
-- | a description of the image format

    clearPixbufFormatDescription            ,
    getPixbufFormatDescription              ,
#if defined(ENABLE_OVERLOADING)
    pixbufFormat_description                ,
#endif
    setPixbufFormatDescription              ,


-- ** disabled #attr:disabled#
-- | a boolean determining whether the loader is disabled\`

    getPixbufFormatDisabled                 ,
#if defined(ENABLE_OVERLOADING)
    pixbufFormat_disabled                   ,
#endif
    setPixbufFormatDisabled                 ,


-- ** domain #attr:domain#
-- | the message domain for the @description@

    clearPixbufFormatDomain                 ,
    getPixbufFormatDomain                   ,
#if defined(ENABLE_OVERLOADING)
    pixbufFormat_domain                     ,
#endif
    setPixbufFormatDomain                   ,


-- ** extensions #attr:extensions#
-- | typical filename extensions for the
--   image format

    clearPixbufFormatExtensions             ,
    getPixbufFormatExtensions               ,
#if defined(ENABLE_OVERLOADING)
    pixbufFormat_extensions                 ,
#endif
    setPixbufFormatExtensions               ,


-- ** flags #attr:flags#
-- | a combination of @GdkPixbufFormatFlags@

    getPixbufFormatFlags                    ,
#if defined(ENABLE_OVERLOADING)
    pixbufFormat_flags                      ,
#endif
    setPixbufFormatFlags                    ,


-- ** license #attr:license#
-- | a string containing license information, typically set to
--   shorthands like \"GPL\", \"LGPL\", etc.

    clearPixbufFormatLicense                ,
    getPixbufFormatLicense                  ,
#if defined(ENABLE_OVERLOADING)
    pixbufFormat_license                    ,
#endif
    setPixbufFormatLicense                  ,


-- ** mimeTypes #attr:mimeTypes#
-- | the MIME types for the image format

    clearPixbufFormatMimeTypes              ,
    getPixbufFormatMimeTypes                ,
#if defined(ENABLE_OVERLOADING)
    pixbufFormat_mimeTypes                  ,
#endif
    setPixbufFormatMimeTypes                ,


-- ** name #attr:name#
-- | the name of the image format

    clearPixbufFormatName                   ,
    getPixbufFormatName                     ,
#if defined(ENABLE_OVERLOADING)
    pixbufFormat_name                       ,
#endif
    setPixbufFormatName                     ,


-- ** signature #attr:signature#
-- | the signature of the module

    clearPixbufFormatSignature              ,
    getPixbufFormatSignature                ,
#if defined(ENABLE_OVERLOADING)
    pixbufFormat_signature                  ,
#endif
    setPixbufFormatSignature                ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import {-# SOURCE #-} qualified GI.GdkPixbuf.Structs.PixbufModulePattern as GdkPixbuf.PixbufModulePattern

#else
import {-# SOURCE #-} qualified GI.GdkPixbuf.Structs.PixbufModulePattern as GdkPixbuf.PixbufModulePattern

#endif

-- | Memory-managed wrapper type.
newtype PixbufFormat = PixbufFormat (SP.ManagedPtr PixbufFormat)
    deriving (Eq)

instance SP.ManagedPtrNewtype PixbufFormat where
    toManagedPtr (PixbufFormat p) = p

foreign import ccall "gdk_pixbuf_format_get_type" c_gdk_pixbuf_format_get_type :: 
    IO GType

type instance O.ParentTypes PixbufFormat = '[]
instance O.HasParentTypes PixbufFormat

instance B.Types.TypedObject PixbufFormat where
    glibType = c_gdk_pixbuf_format_get_type

instance B.Types.GBoxed PixbufFormat

-- | Convert t'PixbufFormat' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe PixbufFormat) where
    gvalueGType_ = c_gdk_pixbuf_format_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_boxed gv (FP.nullPtr :: FP.Ptr PixbufFormat)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_boxed gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_boxed gv :: IO (Ptr PixbufFormat)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newBoxed PixbufFormat ptr
        else return P.Nothing
        
    

-- | Construct a t'PixbufFormat' struct initialized to zero.
newZeroPixbufFormat :: MonadIO m => m PixbufFormat
newZeroPixbufFormat = liftIO $ callocBoxedBytes 64 >>= wrapBoxed PixbufFormat

instance tag ~ 'AttrSet => Constructible PixbufFormat tag where
    new _ attrs = do
        o <- newZeroPixbufFormat
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@name@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' pixbufFormat #name
-- @
getPixbufFormatName :: MonadIO m => PixbufFormat -> m (Maybe T.Text)
getPixbufFormatName s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO CString
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- cstringToText val'
        return val''
    return result

-- | Set the value of the “@name@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' pixbufFormat [ #name 'Data.GI.Base.Attributes.:=' value ]
-- @
setPixbufFormatName :: MonadIO m => PixbufFormat -> CString -> m ()
setPixbufFormatName s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: CString)

-- | Set the value of the “@name@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #name
-- @
clearPixbufFormatName :: MonadIO m => PixbufFormat -> m ()
clearPixbufFormatName s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (FP.nullPtr :: CString)

#if defined(ENABLE_OVERLOADING)
data PixbufFormatNameFieldInfo
instance AttrInfo PixbufFormatNameFieldInfo where
    type AttrBaseTypeConstraint PixbufFormatNameFieldInfo = (~) PixbufFormat
    type AttrAllowedOps PixbufFormatNameFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint PixbufFormatNameFieldInfo = (~) CString
    type AttrTransferTypeConstraint PixbufFormatNameFieldInfo = (~)CString
    type AttrTransferType PixbufFormatNameFieldInfo = CString
    type AttrGetType PixbufFormatNameFieldInfo = Maybe T.Text
    type AttrLabel PixbufFormatNameFieldInfo = "name"
    type AttrOrigin PixbufFormatNameFieldInfo = PixbufFormat
    attrGet = getPixbufFormatName
    attrSet = setPixbufFormatName
    attrConstruct = undefined
    attrClear = clearPixbufFormatName
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkPixbuf.Structs.PixbufFormat.name"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkpixbuf-2.0.32/docs/GI-GdkPixbuf-Structs-PixbufFormat.html#g:attr:name"
        })

pixbufFormat_name :: AttrLabelProxy "name"
pixbufFormat_name = AttrLabelProxy

#endif


-- | Get the value of the “@signature@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' pixbufFormat #signature
-- @
getPixbufFormatSignature :: MonadIO m => PixbufFormat -> m (Maybe GdkPixbuf.PixbufModulePattern.PixbufModulePattern)
getPixbufFormatSignature s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO (Ptr GdkPixbuf.PixbufModulePattern.PixbufModulePattern)
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- (newPtr GdkPixbuf.PixbufModulePattern.PixbufModulePattern) val'
        return val''
    return result

-- | Set the value of the “@signature@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' pixbufFormat [ #signature 'Data.GI.Base.Attributes.:=' value ]
-- @
setPixbufFormatSignature :: MonadIO m => PixbufFormat -> Ptr GdkPixbuf.PixbufModulePattern.PixbufModulePattern -> m ()
setPixbufFormatSignature s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: Ptr GdkPixbuf.PixbufModulePattern.PixbufModulePattern)

-- | Set the value of the “@signature@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #signature
-- @
clearPixbufFormatSignature :: MonadIO m => PixbufFormat -> m ()
clearPixbufFormatSignature s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (FP.nullPtr :: Ptr GdkPixbuf.PixbufModulePattern.PixbufModulePattern)

#if defined(ENABLE_OVERLOADING)
data PixbufFormatSignatureFieldInfo
instance AttrInfo PixbufFormatSignatureFieldInfo where
    type AttrBaseTypeConstraint PixbufFormatSignatureFieldInfo = (~) PixbufFormat
    type AttrAllowedOps PixbufFormatSignatureFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint PixbufFormatSignatureFieldInfo = (~) (Ptr GdkPixbuf.PixbufModulePattern.PixbufModulePattern)
    type AttrTransferTypeConstraint PixbufFormatSignatureFieldInfo = (~)(Ptr GdkPixbuf.PixbufModulePattern.PixbufModulePattern)
    type AttrTransferType PixbufFormatSignatureFieldInfo = (Ptr GdkPixbuf.PixbufModulePattern.PixbufModulePattern)
    type AttrGetType PixbufFormatSignatureFieldInfo = Maybe GdkPixbuf.PixbufModulePattern.PixbufModulePattern
    type AttrLabel PixbufFormatSignatureFieldInfo = "signature"
    type AttrOrigin PixbufFormatSignatureFieldInfo = PixbufFormat
    attrGet = getPixbufFormatSignature
    attrSet = setPixbufFormatSignature
    attrConstruct = undefined
    attrClear = clearPixbufFormatSignature
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkPixbuf.Structs.PixbufFormat.signature"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkpixbuf-2.0.32/docs/GI-GdkPixbuf-Structs-PixbufFormat.html#g:attr:signature"
        })

pixbufFormat_signature :: AttrLabelProxy "signature"
pixbufFormat_signature = AttrLabelProxy

#endif


-- | Get the value of the “@domain@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' pixbufFormat #domain
-- @
getPixbufFormatDomain :: MonadIO m => PixbufFormat -> m (Maybe T.Text)
getPixbufFormatDomain s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO CString
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- cstringToText val'
        return val''
    return result

-- | Set the value of the “@domain@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' pixbufFormat [ #domain 'Data.GI.Base.Attributes.:=' value ]
-- @
setPixbufFormatDomain :: MonadIO m => PixbufFormat -> CString -> m ()
setPixbufFormatDomain s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (val :: CString)

-- | Set the value of the “@domain@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #domain
-- @
clearPixbufFormatDomain :: MonadIO m => PixbufFormat -> m ()
clearPixbufFormatDomain s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (FP.nullPtr :: CString)

#if defined(ENABLE_OVERLOADING)
data PixbufFormatDomainFieldInfo
instance AttrInfo PixbufFormatDomainFieldInfo where
    type AttrBaseTypeConstraint PixbufFormatDomainFieldInfo = (~) PixbufFormat
    type AttrAllowedOps PixbufFormatDomainFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint PixbufFormatDomainFieldInfo = (~) CString
    type AttrTransferTypeConstraint PixbufFormatDomainFieldInfo = (~)CString
    type AttrTransferType PixbufFormatDomainFieldInfo = CString
    type AttrGetType PixbufFormatDomainFieldInfo = Maybe T.Text
    type AttrLabel PixbufFormatDomainFieldInfo = "domain"
    type AttrOrigin PixbufFormatDomainFieldInfo = PixbufFormat
    attrGet = getPixbufFormatDomain
    attrSet = setPixbufFormatDomain
    attrConstruct = undefined
    attrClear = clearPixbufFormatDomain
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkPixbuf.Structs.PixbufFormat.domain"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkpixbuf-2.0.32/docs/GI-GdkPixbuf-Structs-PixbufFormat.html#g:attr:domain"
        })

pixbufFormat_domain :: AttrLabelProxy "domain"
pixbufFormat_domain = AttrLabelProxy

#endif


-- | Get the value of the “@description@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' pixbufFormat #description
-- @
getPixbufFormatDescription :: MonadIO m => PixbufFormat -> m (Maybe T.Text)
getPixbufFormatDescription s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 24) :: IO CString
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- cstringToText val'
        return val''
    return result

-- | Set the value of the “@description@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' pixbufFormat [ #description 'Data.GI.Base.Attributes.:=' value ]
-- @
setPixbufFormatDescription :: MonadIO m => PixbufFormat -> CString -> m ()
setPixbufFormatDescription s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 24) (val :: CString)

-- | Set the value of the “@description@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #description
-- @
clearPixbufFormatDescription :: MonadIO m => PixbufFormat -> m ()
clearPixbufFormatDescription s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 24) (FP.nullPtr :: CString)

#if defined(ENABLE_OVERLOADING)
data PixbufFormatDescriptionFieldInfo
instance AttrInfo PixbufFormatDescriptionFieldInfo where
    type AttrBaseTypeConstraint PixbufFormatDescriptionFieldInfo = (~) PixbufFormat
    type AttrAllowedOps PixbufFormatDescriptionFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint PixbufFormatDescriptionFieldInfo = (~) CString
    type AttrTransferTypeConstraint PixbufFormatDescriptionFieldInfo = (~)CString
    type AttrTransferType PixbufFormatDescriptionFieldInfo = CString
    type AttrGetType PixbufFormatDescriptionFieldInfo = Maybe T.Text
    type AttrLabel PixbufFormatDescriptionFieldInfo = "description"
    type AttrOrigin PixbufFormatDescriptionFieldInfo = PixbufFormat
    attrGet = getPixbufFormatDescription
    attrSet = setPixbufFormatDescription
    attrConstruct = undefined
    attrClear = clearPixbufFormatDescription
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkPixbuf.Structs.PixbufFormat.description"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkpixbuf-2.0.32/docs/GI-GdkPixbuf-Structs-PixbufFormat.html#g:attr:description"
        })

pixbufFormat_description :: AttrLabelProxy "description"
pixbufFormat_description = AttrLabelProxy

#endif


-- | Get the value of the “@mime_types@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' pixbufFormat #mimeTypes
-- @
getPixbufFormatMimeTypes :: MonadIO m => PixbufFormat -> m (Maybe [T.Text])
getPixbufFormatMimeTypes s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 32) :: IO (Ptr CString)
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- unpackZeroTerminatedUTF8CArray val'
        return val''
    return result

-- | Set the value of the “@mime_types@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' pixbufFormat [ #mimeTypes 'Data.GI.Base.Attributes.:=' value ]
-- @
setPixbufFormatMimeTypes :: MonadIO m => PixbufFormat -> Ptr CString -> m ()
setPixbufFormatMimeTypes s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 32) (val :: Ptr CString)

-- | Set the value of the “@mime_types@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #mimeTypes
-- @
clearPixbufFormatMimeTypes :: MonadIO m => PixbufFormat -> m ()
clearPixbufFormatMimeTypes s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 32) (FP.nullPtr :: Ptr CString)

#if defined(ENABLE_OVERLOADING)
data PixbufFormatMimeTypesFieldInfo
instance AttrInfo PixbufFormatMimeTypesFieldInfo where
    type AttrBaseTypeConstraint PixbufFormatMimeTypesFieldInfo = (~) PixbufFormat
    type AttrAllowedOps PixbufFormatMimeTypesFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint PixbufFormatMimeTypesFieldInfo = (~) (Ptr CString)
    type AttrTransferTypeConstraint PixbufFormatMimeTypesFieldInfo = (~)(Ptr CString)
    type AttrTransferType PixbufFormatMimeTypesFieldInfo = (Ptr CString)
    type AttrGetType PixbufFormatMimeTypesFieldInfo = Maybe [T.Text]
    type AttrLabel PixbufFormatMimeTypesFieldInfo = "mime_types"
    type AttrOrigin PixbufFormatMimeTypesFieldInfo = PixbufFormat
    attrGet = getPixbufFormatMimeTypes
    attrSet = setPixbufFormatMimeTypes
    attrConstruct = undefined
    attrClear = clearPixbufFormatMimeTypes
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkPixbuf.Structs.PixbufFormat.mimeTypes"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkpixbuf-2.0.32/docs/GI-GdkPixbuf-Structs-PixbufFormat.html#g:attr:mimeTypes"
        })

pixbufFormat_mimeTypes :: AttrLabelProxy "mimeTypes"
pixbufFormat_mimeTypes = AttrLabelProxy

#endif


-- | Get the value of the “@extensions@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' pixbufFormat #extensions
-- @
getPixbufFormatExtensions :: MonadIO m => PixbufFormat -> m (Maybe [T.Text])
getPixbufFormatExtensions s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 40) :: IO (Ptr CString)
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- unpackZeroTerminatedUTF8CArray val'
        return val''
    return result

-- | Set the value of the “@extensions@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' pixbufFormat [ #extensions 'Data.GI.Base.Attributes.:=' value ]
-- @
setPixbufFormatExtensions :: MonadIO m => PixbufFormat -> Ptr CString -> m ()
setPixbufFormatExtensions s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 40) (val :: Ptr CString)

-- | Set the value of the “@extensions@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #extensions
-- @
clearPixbufFormatExtensions :: MonadIO m => PixbufFormat -> m ()
clearPixbufFormatExtensions s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 40) (FP.nullPtr :: Ptr CString)

#if defined(ENABLE_OVERLOADING)
data PixbufFormatExtensionsFieldInfo
instance AttrInfo PixbufFormatExtensionsFieldInfo where
    type AttrBaseTypeConstraint PixbufFormatExtensionsFieldInfo = (~) PixbufFormat
    type AttrAllowedOps PixbufFormatExtensionsFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint PixbufFormatExtensionsFieldInfo = (~) (Ptr CString)
    type AttrTransferTypeConstraint PixbufFormatExtensionsFieldInfo = (~)(Ptr CString)
    type AttrTransferType PixbufFormatExtensionsFieldInfo = (Ptr CString)
    type AttrGetType PixbufFormatExtensionsFieldInfo = Maybe [T.Text]
    type AttrLabel PixbufFormatExtensionsFieldInfo = "extensions"
    type AttrOrigin PixbufFormatExtensionsFieldInfo = PixbufFormat
    attrGet = getPixbufFormatExtensions
    attrSet = setPixbufFormatExtensions
    attrConstruct = undefined
    attrClear = clearPixbufFormatExtensions
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkPixbuf.Structs.PixbufFormat.extensions"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkpixbuf-2.0.32/docs/GI-GdkPixbuf-Structs-PixbufFormat.html#g:attr:extensions"
        })

pixbufFormat_extensions :: AttrLabelProxy "extensions"
pixbufFormat_extensions = AttrLabelProxy

#endif


-- | Get the value of the “@flags@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' pixbufFormat #flags
-- @
getPixbufFormatFlags :: MonadIO m => PixbufFormat -> m Word32
getPixbufFormatFlags s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 48) :: IO Word32
    return val

-- | Set the value of the “@flags@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' pixbufFormat [ #flags 'Data.GI.Base.Attributes.:=' value ]
-- @
setPixbufFormatFlags :: MonadIO m => PixbufFormat -> Word32 -> m ()
setPixbufFormatFlags s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 48) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data PixbufFormatFlagsFieldInfo
instance AttrInfo PixbufFormatFlagsFieldInfo where
    type AttrBaseTypeConstraint PixbufFormatFlagsFieldInfo = (~) PixbufFormat
    type AttrAllowedOps PixbufFormatFlagsFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint PixbufFormatFlagsFieldInfo = (~) Word32
    type AttrTransferTypeConstraint PixbufFormatFlagsFieldInfo = (~)Word32
    type AttrTransferType PixbufFormatFlagsFieldInfo = Word32
    type AttrGetType PixbufFormatFlagsFieldInfo = Word32
    type AttrLabel PixbufFormatFlagsFieldInfo = "flags"
    type AttrOrigin PixbufFormatFlagsFieldInfo = PixbufFormat
    attrGet = getPixbufFormatFlags
    attrSet = setPixbufFormatFlags
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkPixbuf.Structs.PixbufFormat.flags"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkpixbuf-2.0.32/docs/GI-GdkPixbuf-Structs-PixbufFormat.html#g:attr:flags"
        })

pixbufFormat_flags :: AttrLabelProxy "flags"
pixbufFormat_flags = AttrLabelProxy

#endif


-- | Get the value of the “@disabled@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' pixbufFormat #disabled
-- @
getPixbufFormatDisabled :: MonadIO m => PixbufFormat -> m Bool
getPixbufFormatDisabled s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 52) :: IO CInt
    let val' = (/= 0) val
    return val'

-- | Set the value of the “@disabled@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' pixbufFormat [ #disabled 'Data.GI.Base.Attributes.:=' value ]
-- @
setPixbufFormatDisabled :: MonadIO m => PixbufFormat -> Bool -> m ()
setPixbufFormatDisabled s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = (P.fromIntegral . P.fromEnum) val
    poke (ptr `plusPtr` 52) (val' :: CInt)

#if defined(ENABLE_OVERLOADING)
data PixbufFormatDisabledFieldInfo
instance AttrInfo PixbufFormatDisabledFieldInfo where
    type AttrBaseTypeConstraint PixbufFormatDisabledFieldInfo = (~) PixbufFormat
    type AttrAllowedOps PixbufFormatDisabledFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint PixbufFormatDisabledFieldInfo = (~) Bool
    type AttrTransferTypeConstraint PixbufFormatDisabledFieldInfo = (~)Bool
    type AttrTransferType PixbufFormatDisabledFieldInfo = Bool
    type AttrGetType PixbufFormatDisabledFieldInfo = Bool
    type AttrLabel PixbufFormatDisabledFieldInfo = "disabled"
    type AttrOrigin PixbufFormatDisabledFieldInfo = PixbufFormat
    attrGet = getPixbufFormatDisabled
    attrSet = setPixbufFormatDisabled
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkPixbuf.Structs.PixbufFormat.disabled"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkpixbuf-2.0.32/docs/GI-GdkPixbuf-Structs-PixbufFormat.html#g:attr:disabled"
        })

pixbufFormat_disabled :: AttrLabelProxy "disabled"
pixbufFormat_disabled = AttrLabelProxy

#endif


-- | Get the value of the “@license@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' pixbufFormat #license
-- @
getPixbufFormatLicense :: MonadIO m => PixbufFormat -> m (Maybe T.Text)
getPixbufFormatLicense s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 56) :: IO CString
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- cstringToText val'
        return val''
    return result

-- | Set the value of the “@license@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' pixbufFormat [ #license 'Data.GI.Base.Attributes.:=' value ]
-- @
setPixbufFormatLicense :: MonadIO m => PixbufFormat -> CString -> m ()
setPixbufFormatLicense s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 56) (val :: CString)

-- | Set the value of the “@license@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #license
-- @
clearPixbufFormatLicense :: MonadIO m => PixbufFormat -> m ()
clearPixbufFormatLicense s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 56) (FP.nullPtr :: CString)

#if defined(ENABLE_OVERLOADING)
data PixbufFormatLicenseFieldInfo
instance AttrInfo PixbufFormatLicenseFieldInfo where
    type AttrBaseTypeConstraint PixbufFormatLicenseFieldInfo = (~) PixbufFormat
    type AttrAllowedOps PixbufFormatLicenseFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint PixbufFormatLicenseFieldInfo = (~) CString
    type AttrTransferTypeConstraint PixbufFormatLicenseFieldInfo = (~)CString
    type AttrTransferType PixbufFormatLicenseFieldInfo = CString
    type AttrGetType PixbufFormatLicenseFieldInfo = Maybe T.Text
    type AttrLabel PixbufFormatLicenseFieldInfo = "license"
    type AttrOrigin PixbufFormatLicenseFieldInfo = PixbufFormat
    attrGet = getPixbufFormatLicense
    attrSet = setPixbufFormatLicense
    attrConstruct = undefined
    attrClear = clearPixbufFormatLicense
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkPixbuf.Structs.PixbufFormat.license"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkpixbuf-2.0.32/docs/GI-GdkPixbuf-Structs-PixbufFormat.html#g:attr:license"
        })

pixbufFormat_license :: AttrLabelProxy "license"
pixbufFormat_license = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList PixbufFormat
type instance O.AttributeList PixbufFormat = PixbufFormatAttributeList
type PixbufFormatAttributeList = ('[ '("name", PixbufFormatNameFieldInfo), '("signature", PixbufFormatSignatureFieldInfo), '("domain", PixbufFormatDomainFieldInfo), '("description", PixbufFormatDescriptionFieldInfo), '("mimeTypes", PixbufFormatMimeTypesFieldInfo), '("extensions", PixbufFormatExtensionsFieldInfo), '("flags", PixbufFormatFlagsFieldInfo), '("disabled", PixbufFormatDisabledFieldInfo), '("license", PixbufFormatLicenseFieldInfo)] :: [(Symbol, DK.Type)])
#endif

-- method PixbufFormat::copy
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "format"
--           , argType =
--               TInterface Name { namespace = "GdkPixbuf" , name = "PixbufFormat" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a pixbuf format" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "GdkPixbuf" , name = "PixbufFormat" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_pixbuf_format_copy" gdk_pixbuf_format_copy :: 
    Ptr PixbufFormat ->                     -- format : TInterface (Name {namespace = "GdkPixbuf", name = "PixbufFormat"})
    IO (Ptr PixbufFormat)

-- | Creates a copy of @format@.
-- 
-- /Since: 2.22/
pixbufFormatCopy ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    PixbufFormat
    -- ^ /@format@/: a pixbuf format
    -> m (Maybe PixbufFormat)
    -- ^ __Returns:__ the newly allocated copy of a @GdkPixbufFormat@. Use
    --   'GI.GdkPixbuf.Structs.PixbufFormat.pixbufFormatFree' to free the resources when done
pixbufFormatCopy format = liftIO $ do
    format' <- unsafeManagedPtrGetPtr format
    result <- gdk_pixbuf_format_copy format'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapBoxed PixbufFormat) result'
        return result''
    touchManagedPtr format
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data PixbufFormatCopyMethodInfo
instance (signature ~ (m (Maybe PixbufFormat)), MonadIO m) => O.OverloadedMethod PixbufFormatCopyMethodInfo PixbufFormat signature where
    overloadedMethod = pixbufFormatCopy

instance O.OverloadedMethodInfo PixbufFormatCopyMethodInfo PixbufFormat where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkPixbuf.Structs.PixbufFormat.pixbufFormatCopy",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkpixbuf-2.0.32/docs/GI-GdkPixbuf-Structs-PixbufFormat.html#v:pixbufFormatCopy"
        })


#endif

-- method PixbufFormat::free
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "format"
--           , argType =
--               TInterface Name { namespace = "GdkPixbuf" , name = "PixbufFormat" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a pixbuf format" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_pixbuf_format_free" gdk_pixbuf_format_free :: 
    Ptr PixbufFormat ->                     -- format : TInterface (Name {namespace = "GdkPixbuf", name = "PixbufFormat"})
    IO ()

-- | Frees the resources allocated when copying a @GdkPixbufFormat@
-- using 'GI.GdkPixbuf.Structs.PixbufFormat.pixbufFormatCopy'
-- 
-- /Since: 2.22/
pixbufFormatFree ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    PixbufFormat
    -- ^ /@format@/: a pixbuf format
    -> m ()
pixbufFormatFree format = liftIO $ do
    format' <- unsafeManagedPtrGetPtr format
    gdk_pixbuf_format_free format'
    touchManagedPtr format
    return ()

#if defined(ENABLE_OVERLOADING)
data PixbufFormatFreeMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod PixbufFormatFreeMethodInfo PixbufFormat signature where
    overloadedMethod = pixbufFormatFree

instance O.OverloadedMethodInfo PixbufFormatFreeMethodInfo PixbufFormat where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkPixbuf.Structs.PixbufFormat.pixbufFormatFree",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkpixbuf-2.0.32/docs/GI-GdkPixbuf-Structs-PixbufFormat.html#v:pixbufFormatFree"
        })


#endif

-- method PixbufFormat::get_description
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "format"
--           , argType =
--               TInterface Name { namespace = "GdkPixbuf" , name = "PixbufFormat" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkPixbufFormat`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_pixbuf_format_get_description" gdk_pixbuf_format_get_description :: 
    Ptr PixbufFormat ->                     -- format : TInterface (Name {namespace = "GdkPixbuf", name = "PixbufFormat"})
    IO CString

-- | Returns a description of the format.
-- 
-- /Since: 2.2/
pixbufFormatGetDescription ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    PixbufFormat
    -- ^ /@format@/: a @GdkPixbufFormat@
    -> m (Maybe T.Text)
    -- ^ __Returns:__ a description of the format.
pixbufFormatGetDescription format = liftIO $ do
    format' <- unsafeManagedPtrGetPtr format
    result <- gdk_pixbuf_format_get_description format'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        freeMem result'
        return result''
    touchManagedPtr format
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data PixbufFormatGetDescriptionMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m) => O.OverloadedMethod PixbufFormatGetDescriptionMethodInfo PixbufFormat signature where
    overloadedMethod = pixbufFormatGetDescription

instance O.OverloadedMethodInfo PixbufFormatGetDescriptionMethodInfo PixbufFormat where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkPixbuf.Structs.PixbufFormat.pixbufFormatGetDescription",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkpixbuf-2.0.32/docs/GI-GdkPixbuf-Structs-PixbufFormat.html#v:pixbufFormatGetDescription"
        })


#endif

-- method PixbufFormat::get_extensions
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "format"
--           , argType =
--               TInterface Name { namespace = "GdkPixbuf" , name = "PixbufFormat" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkPixbufFormat`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TCArray True (-1) (-1) (TBasicType TUTF8))
-- throws : False
-- Skip return : False

foreign import ccall "gdk_pixbuf_format_get_extensions" gdk_pixbuf_format_get_extensions :: 
    Ptr PixbufFormat ->                     -- format : TInterface (Name {namespace = "GdkPixbuf", name = "PixbufFormat"})
    IO (Ptr CString)

-- | Returns the filename extensions typically used for files in the
-- given format.
-- 
-- /Since: 2.2/
pixbufFormatGetExtensions ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    PixbufFormat
    -- ^ /@format@/: a @GdkPixbufFormat@
    -> m (Maybe [T.Text])
    -- ^ __Returns:__ an array of
    --   filename extensions
pixbufFormatGetExtensions format = liftIO $ do
    format' <- unsafeManagedPtrGetPtr format
    result <- gdk_pixbuf_format_get_extensions format'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- unpackZeroTerminatedUTF8CArray result'
        mapZeroTerminatedCArray freeMem result'
        freeMem result'
        return result''
    touchManagedPtr format
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data PixbufFormatGetExtensionsMethodInfo
instance (signature ~ (m (Maybe [T.Text])), MonadIO m) => O.OverloadedMethod PixbufFormatGetExtensionsMethodInfo PixbufFormat signature where
    overloadedMethod = pixbufFormatGetExtensions

instance O.OverloadedMethodInfo PixbufFormatGetExtensionsMethodInfo PixbufFormat where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkPixbuf.Structs.PixbufFormat.pixbufFormatGetExtensions",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkpixbuf-2.0.32/docs/GI-GdkPixbuf-Structs-PixbufFormat.html#v:pixbufFormatGetExtensions"
        })


#endif

-- method PixbufFormat::get_license
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "format"
--           , argType =
--               TInterface Name { namespace = "GdkPixbuf" , name = "PixbufFormat" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a pixbuf format" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_pixbuf_format_get_license" gdk_pixbuf_format_get_license :: 
    Ptr PixbufFormat ->                     -- format : TInterface (Name {namespace = "GdkPixbuf", name = "PixbufFormat"})
    IO CString

-- | Returns information about the license of the image loader for the format.
-- 
-- The returned string should be a shorthand for a well known license, e.g.
-- \"LGPL\", \"GPL\", \"QPL\", \"GPL\/QPL\", or \"other\" to indicate some other license.
-- 
-- /Since: 2.6/
pixbufFormatGetLicense ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    PixbufFormat
    -- ^ /@format@/: a pixbuf format
    -> m (Maybe T.Text)
    -- ^ __Returns:__ a string describing the license of the pixbuf format
pixbufFormatGetLicense format = liftIO $ do
    format' <- unsafeManagedPtrGetPtr format
    result <- gdk_pixbuf_format_get_license format'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        freeMem result'
        return result''
    touchManagedPtr format
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data PixbufFormatGetLicenseMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m) => O.OverloadedMethod PixbufFormatGetLicenseMethodInfo PixbufFormat signature where
    overloadedMethod = pixbufFormatGetLicense

instance O.OverloadedMethodInfo PixbufFormatGetLicenseMethodInfo PixbufFormat where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkPixbuf.Structs.PixbufFormat.pixbufFormatGetLicense",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkpixbuf-2.0.32/docs/GI-GdkPixbuf-Structs-PixbufFormat.html#v:pixbufFormatGetLicense"
        })


#endif

-- method PixbufFormat::get_mime_types
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "format"
--           , argType =
--               TInterface Name { namespace = "GdkPixbuf" , name = "PixbufFormat" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkPixbufFormat`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TCArray True (-1) (-1) (TBasicType TUTF8))
-- throws : False
-- Skip return : False

foreign import ccall "gdk_pixbuf_format_get_mime_types" gdk_pixbuf_format_get_mime_types :: 
    Ptr PixbufFormat ->                     -- format : TInterface (Name {namespace = "GdkPixbuf", name = "PixbufFormat"})
    IO (Ptr CString)

-- | Returns the mime types supported by the format.
-- 
-- /Since: 2.2/
pixbufFormatGetMimeTypes ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    PixbufFormat
    -- ^ /@format@/: a @GdkPixbufFormat@
    -> m (Maybe [T.Text])
    -- ^ __Returns:__ an array of mime types
pixbufFormatGetMimeTypes format = liftIO $ do
    format' <- unsafeManagedPtrGetPtr format
    result <- gdk_pixbuf_format_get_mime_types format'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- unpackZeroTerminatedUTF8CArray result'
        mapZeroTerminatedCArray freeMem result'
        freeMem result'
        return result''
    touchManagedPtr format
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data PixbufFormatGetMimeTypesMethodInfo
instance (signature ~ (m (Maybe [T.Text])), MonadIO m) => O.OverloadedMethod PixbufFormatGetMimeTypesMethodInfo PixbufFormat signature where
    overloadedMethod = pixbufFormatGetMimeTypes

instance O.OverloadedMethodInfo PixbufFormatGetMimeTypesMethodInfo PixbufFormat where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkPixbuf.Structs.PixbufFormat.pixbufFormatGetMimeTypes",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkpixbuf-2.0.32/docs/GI-GdkPixbuf-Structs-PixbufFormat.html#v:pixbufFormatGetMimeTypes"
        })


#endif

-- method PixbufFormat::get_name
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "format"
--           , argType =
--               TInterface Name { namespace = "GdkPixbuf" , name = "PixbufFormat" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkPixbufFormat`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_pixbuf_format_get_name" gdk_pixbuf_format_get_name :: 
    Ptr PixbufFormat ->                     -- format : TInterface (Name {namespace = "GdkPixbuf", name = "PixbufFormat"})
    IO CString

-- | Returns the name of the format.
-- 
-- /Since: 2.2/
pixbufFormatGetName ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    PixbufFormat
    -- ^ /@format@/: a @GdkPixbufFormat@
    -> m (Maybe T.Text)
    -- ^ __Returns:__ the name of the format.
pixbufFormatGetName format = liftIO $ do
    format' <- unsafeManagedPtrGetPtr format
    result <- gdk_pixbuf_format_get_name format'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        freeMem result'
        return result''
    touchManagedPtr format
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data PixbufFormatGetNameMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m) => O.OverloadedMethod PixbufFormatGetNameMethodInfo PixbufFormat signature where
    overloadedMethod = pixbufFormatGetName

instance O.OverloadedMethodInfo PixbufFormatGetNameMethodInfo PixbufFormat where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkPixbuf.Structs.PixbufFormat.pixbufFormatGetName",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkpixbuf-2.0.32/docs/GI-GdkPixbuf-Structs-PixbufFormat.html#v:pixbufFormatGetName"
        })


#endif

-- method PixbufFormat::is_disabled
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "format"
--           , argType =
--               TInterface Name { namespace = "GdkPixbuf" , name = "PixbufFormat" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkPixbufFormat`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_pixbuf_format_is_disabled" gdk_pixbuf_format_is_disabled :: 
    Ptr PixbufFormat ->                     -- format : TInterface (Name {namespace = "GdkPixbuf", name = "PixbufFormat"})
    IO CInt

-- | Returns whether this image format is disabled.
-- 
-- See 'GI.GdkPixbuf.Structs.PixbufFormat.pixbufFormatSetDisabled'.
-- 
-- /Since: 2.6/
pixbufFormatIsDisabled ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    PixbufFormat
    -- ^ /@format@/: a @GdkPixbufFormat@
    -> m Bool
    -- ^ __Returns:__ whether this image format is disabled.
pixbufFormatIsDisabled format = liftIO $ do
    format' <- unsafeManagedPtrGetPtr format
    result <- gdk_pixbuf_format_is_disabled format'
    let result' = (/= 0) result
    touchManagedPtr format
    return result'

#if defined(ENABLE_OVERLOADING)
data PixbufFormatIsDisabledMethodInfo
instance (signature ~ (m Bool), MonadIO m) => O.OverloadedMethod PixbufFormatIsDisabledMethodInfo PixbufFormat signature where
    overloadedMethod = pixbufFormatIsDisabled

instance O.OverloadedMethodInfo PixbufFormatIsDisabledMethodInfo PixbufFormat where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkPixbuf.Structs.PixbufFormat.pixbufFormatIsDisabled",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkpixbuf-2.0.32/docs/GI-GdkPixbuf-Structs-PixbufFormat.html#v:pixbufFormatIsDisabled"
        })


#endif

-- method PixbufFormat::is_save_option_supported
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "format"
--           , argType =
--               TInterface Name { namespace = "GdkPixbuf" , name = "PixbufFormat" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a pixbuf format" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "option_key"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the name of an option"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_pixbuf_format_is_save_option_supported" gdk_pixbuf_format_is_save_option_supported :: 
    Ptr PixbufFormat ->                     -- format : TInterface (Name {namespace = "GdkPixbuf", name = "PixbufFormat"})
    CString ->                              -- option_key : TBasicType TUTF8
    IO CInt

-- | Returns @TRUE@ if the save option specified by /@optionKey@/ is supported when
-- saving a pixbuf using the module implementing /@format@/.
-- 
-- See @/gdk_pixbuf_save()/@ for more information about option keys.
-- 
-- /Since: 2.36/
pixbufFormatIsSaveOptionSupported ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    PixbufFormat
    -- ^ /@format@/: a pixbuf format
    -> T.Text
    -- ^ /@optionKey@/: the name of an option
    -> m Bool
    -- ^ __Returns:__ @TRUE@ if the specified option is supported
pixbufFormatIsSaveOptionSupported format optionKey = liftIO $ do
    format' <- unsafeManagedPtrGetPtr format
    optionKey' <- textToCString optionKey
    result <- gdk_pixbuf_format_is_save_option_supported format' optionKey'
    let result' = (/= 0) result
    touchManagedPtr format
    freeMem optionKey'
    return result'

#if defined(ENABLE_OVERLOADING)
data PixbufFormatIsSaveOptionSupportedMethodInfo
instance (signature ~ (T.Text -> m Bool), MonadIO m) => O.OverloadedMethod PixbufFormatIsSaveOptionSupportedMethodInfo PixbufFormat signature where
    overloadedMethod = pixbufFormatIsSaveOptionSupported

instance O.OverloadedMethodInfo PixbufFormatIsSaveOptionSupportedMethodInfo PixbufFormat where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkPixbuf.Structs.PixbufFormat.pixbufFormatIsSaveOptionSupported",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkpixbuf-2.0.32/docs/GI-GdkPixbuf-Structs-PixbufFormat.html#v:pixbufFormatIsSaveOptionSupported"
        })


#endif

-- method PixbufFormat::is_scalable
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "format"
--           , argType =
--               TInterface Name { namespace = "GdkPixbuf" , name = "PixbufFormat" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkPixbufFormat`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_pixbuf_format_is_scalable" gdk_pixbuf_format_is_scalable :: 
    Ptr PixbufFormat ->                     -- format : TInterface (Name {namespace = "GdkPixbuf", name = "PixbufFormat"})
    IO CInt

-- | Returns whether this image format is scalable.
-- 
-- If a file is in a scalable format, it is preferable to load it at
-- the desired size, rather than loading it at the default size and
-- scaling the resulting pixbuf to the desired size.
-- 
-- /Since: 2.6/
pixbufFormatIsScalable ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    PixbufFormat
    -- ^ /@format@/: a @GdkPixbufFormat@
    -> m Bool
    -- ^ __Returns:__ whether this image format is scalable.
pixbufFormatIsScalable format = liftIO $ do
    format' <- unsafeManagedPtrGetPtr format
    result <- gdk_pixbuf_format_is_scalable format'
    let result' = (/= 0) result
    touchManagedPtr format
    return result'

#if defined(ENABLE_OVERLOADING)
data PixbufFormatIsScalableMethodInfo
instance (signature ~ (m Bool), MonadIO m) => O.OverloadedMethod PixbufFormatIsScalableMethodInfo PixbufFormat signature where
    overloadedMethod = pixbufFormatIsScalable

instance O.OverloadedMethodInfo PixbufFormatIsScalableMethodInfo PixbufFormat where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkPixbuf.Structs.PixbufFormat.pixbufFormatIsScalable",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkpixbuf-2.0.32/docs/GI-GdkPixbuf-Structs-PixbufFormat.html#v:pixbufFormatIsScalable"
        })


#endif

-- method PixbufFormat::is_writable
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "format"
--           , argType =
--               TInterface Name { namespace = "GdkPixbuf" , name = "PixbufFormat" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkPixbufFormat`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_pixbuf_format_is_writable" gdk_pixbuf_format_is_writable :: 
    Ptr PixbufFormat ->                     -- format : TInterface (Name {namespace = "GdkPixbuf", name = "PixbufFormat"})
    IO CInt

-- | Returns whether pixbufs can be saved in the given format.
-- 
-- /Since: 2.2/
pixbufFormatIsWritable ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    PixbufFormat
    -- ^ /@format@/: a @GdkPixbufFormat@
    -> m Bool
    -- ^ __Returns:__ whether pixbufs can be saved in the given format.
pixbufFormatIsWritable format = liftIO $ do
    format' <- unsafeManagedPtrGetPtr format
    result <- gdk_pixbuf_format_is_writable format'
    let result' = (/= 0) result
    touchManagedPtr format
    return result'

#if defined(ENABLE_OVERLOADING)
data PixbufFormatIsWritableMethodInfo
instance (signature ~ (m Bool), MonadIO m) => O.OverloadedMethod PixbufFormatIsWritableMethodInfo PixbufFormat signature where
    overloadedMethod = pixbufFormatIsWritable

instance O.OverloadedMethodInfo PixbufFormatIsWritableMethodInfo PixbufFormat where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkPixbuf.Structs.PixbufFormat.pixbufFormatIsWritable",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkpixbuf-2.0.32/docs/GI-GdkPixbuf-Structs-PixbufFormat.html#v:pixbufFormatIsWritable"
        })


#endif

-- method PixbufFormat::set_disabled
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "format"
--           , argType =
--               TInterface Name { namespace = "GdkPixbuf" , name = "PixbufFormat" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkPixbufFormat`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "disabled"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "`TRUE` to disable the format @format"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_pixbuf_format_set_disabled" gdk_pixbuf_format_set_disabled :: 
    Ptr PixbufFormat ->                     -- format : TInterface (Name {namespace = "GdkPixbuf", name = "PixbufFormat"})
    CInt ->                                 -- disabled : TBasicType TBoolean
    IO ()

-- | Disables or enables an image format.
-- 
-- If a format is disabled, GdkPixbuf won\'t use the image loader for
-- this format to load images.
-- 
-- Applications can use this to avoid using image loaders with an
-- inappropriate license, see 'GI.GdkPixbuf.Structs.PixbufFormat.pixbufFormatGetLicense'.
-- 
-- /Since: 2.6/
pixbufFormatSetDisabled ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    PixbufFormat
    -- ^ /@format@/: a @GdkPixbufFormat@
    -> Bool
    -- ^ /@disabled@/: @TRUE@ to disable the format /@format@/
    -> m ()
pixbufFormatSetDisabled format disabled = liftIO $ do
    format' <- unsafeManagedPtrGetPtr format
    let disabled' = (P.fromIntegral . P.fromEnum) disabled
    gdk_pixbuf_format_set_disabled format' disabled'
    touchManagedPtr format
    return ()

#if defined(ENABLE_OVERLOADING)
data PixbufFormatSetDisabledMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m) => O.OverloadedMethod PixbufFormatSetDisabledMethodInfo PixbufFormat signature where
    overloadedMethod = pixbufFormatSetDisabled

instance O.OverloadedMethodInfo PixbufFormatSetDisabledMethodInfo PixbufFormat where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkPixbuf.Structs.PixbufFormat.pixbufFormatSetDisabled",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkpixbuf-2.0.32/docs/GI-GdkPixbuf-Structs-PixbufFormat.html#v:pixbufFormatSetDisabled"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type family ResolvePixbufFormatMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolvePixbufFormatMethod "copy" o = PixbufFormatCopyMethodInfo
    ResolvePixbufFormatMethod "free" o = PixbufFormatFreeMethodInfo
    ResolvePixbufFormatMethod "isDisabled" o = PixbufFormatIsDisabledMethodInfo
    ResolvePixbufFormatMethod "isSaveOptionSupported" o = PixbufFormatIsSaveOptionSupportedMethodInfo
    ResolvePixbufFormatMethod "isScalable" o = PixbufFormatIsScalableMethodInfo
    ResolvePixbufFormatMethod "isWritable" o = PixbufFormatIsWritableMethodInfo
    ResolvePixbufFormatMethod "getDescription" o = PixbufFormatGetDescriptionMethodInfo
    ResolvePixbufFormatMethod "getExtensions" o = PixbufFormatGetExtensionsMethodInfo
    ResolvePixbufFormatMethod "getLicense" o = PixbufFormatGetLicenseMethodInfo
    ResolvePixbufFormatMethod "getMimeTypes" o = PixbufFormatGetMimeTypesMethodInfo
    ResolvePixbufFormatMethod "getName" o = PixbufFormatGetNameMethodInfo
    ResolvePixbufFormatMethod "setDisabled" o = PixbufFormatSetDisabledMethodInfo
    ResolvePixbufFormatMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolvePixbufFormatMethod t PixbufFormat, O.OverloadedMethod info PixbufFormat p) => OL.IsLabel t (PixbufFormat -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolvePixbufFormatMethod t PixbufFormat, O.OverloadedMethod info PixbufFormat p, R.HasField t PixbufFormat p) => R.HasField t PixbufFormat p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolvePixbufFormatMethod t PixbufFormat, O.OverloadedMethodInfo info PixbufFormat) => OL.IsLabel t (O.MethodProxy info PixbufFormat) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


