{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Base type for D-Bus interfaces.
-- 
-- The @GDBusInterface@ type is the base type for D-Bus interfaces both
-- on the service side (see t'GI.Gio.Objects.DBusInterfaceSkeleton.DBusInterfaceSkeleton') and client side
-- (see t'GI.Gio.Objects.DBusProxy.DBusProxy').
-- 
-- /Since: 2.30/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Interfaces.DBusInterface
    ( 

-- * Exported types
    DBusInterface(..)                       ,
    IsDBusInterface                         ,
    toDBusInterface                         ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getInfo]("GI.Gio.Interfaces.DBusInterface#g:method:getInfo"), [getObject]("GI.Gio.Interfaces.DBusInterface#g:method:getObject"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setObject]("GI.Gio.Interfaces.DBusInterface#g:method:setObject"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveDBusInterfaceMethod              ,
#endif

-- ** getInfo #method:getInfo#

#if defined(ENABLE_OVERLOADING)
    DBusInterfaceGetInfoMethodInfo          ,
#endif
    dBusInterfaceGetInfo                    ,


-- ** getObject #method:getObject#

#if defined(ENABLE_OVERLOADING)
    DBusInterfaceGetObjectMethodInfo        ,
#endif
    dBusInterfaceGetObject                  ,


-- ** setObject #method:setObject#

#if defined(ENABLE_OVERLOADING)
    DBusInterfaceSetObjectMethodInfo        ,
#endif
    dBusInterfaceSetObject                  ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Structs.String as GLib.String
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gio.Flags as Gio.Flags
import {-# SOURCE #-} qualified GI.Gio.Interfaces.DBusObject as Gio.DBusObject
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusAnnotationInfo as Gio.DBusAnnotationInfo
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusArgInfo as Gio.DBusArgInfo
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusInterfaceInfo as Gio.DBusInterfaceInfo
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusMethodInfo as Gio.DBusMethodInfo
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusPropertyInfo as Gio.DBusPropertyInfo
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusSignalInfo as Gio.DBusSignalInfo

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gio.Interfaces.DBusObject as Gio.DBusObject
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusInterfaceInfo as Gio.DBusInterfaceInfo

#endif

-- interface DBusInterface 
-- | Memory-managed wrapper type.
newtype DBusInterface = DBusInterface (SP.ManagedPtr DBusInterface)
    deriving (Eq)

instance SP.ManagedPtrNewtype DBusInterface where
    toManagedPtr (DBusInterface p) = p

foreign import ccall "g_dbus_interface_get_type"
    c_g_dbus_interface_get_type :: IO B.Types.GType

instance B.Types.TypedObject DBusInterface where
    glibType = c_g_dbus_interface_get_type

instance B.Types.GObject DBusInterface

-- | Type class for types which can be safely cast to t'DBusInterface', for instance with `toDBusInterface`.
class (SP.GObject o, O.IsDescendantOf DBusInterface o) => IsDBusInterface o
instance (SP.GObject o, O.IsDescendantOf DBusInterface o) => IsDBusInterface o

instance O.HasParentTypes DBusInterface
type instance O.ParentTypes DBusInterface = '[GObject.Object.Object]

-- | Cast to t'DBusInterface', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toDBusInterface :: (MIO.MonadIO m, IsDBusInterface o) => o -> m DBusInterface
toDBusInterface = MIO.liftIO . B.ManagedPtr.unsafeCastTo DBusInterface

-- | Convert t'DBusInterface' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe DBusInterface) where
    gvalueGType_ = c_g_dbus_interface_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr DBusInterface)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr DBusInterface)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject DBusInterface ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList DBusInterface
type instance O.AttributeList DBusInterface = DBusInterfaceAttributeList
type DBusInterfaceAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveDBusInterfaceMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveDBusInterfaceMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveDBusInterfaceMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveDBusInterfaceMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveDBusInterfaceMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveDBusInterfaceMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveDBusInterfaceMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveDBusInterfaceMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveDBusInterfaceMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveDBusInterfaceMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveDBusInterfaceMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveDBusInterfaceMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveDBusInterfaceMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveDBusInterfaceMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveDBusInterfaceMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveDBusInterfaceMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveDBusInterfaceMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveDBusInterfaceMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveDBusInterfaceMethod "getInfo" o = DBusInterfaceGetInfoMethodInfo
    ResolveDBusInterfaceMethod "getObject" o = DBusInterfaceGetObjectMethodInfo
    ResolveDBusInterfaceMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveDBusInterfaceMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveDBusInterfaceMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveDBusInterfaceMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveDBusInterfaceMethod "setObject" o = DBusInterfaceSetObjectMethodInfo
    ResolveDBusInterfaceMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveDBusInterfaceMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveDBusInterfaceMethod t DBusInterface, O.OverloadedMethod info DBusInterface p) => OL.IsLabel t (DBusInterface -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveDBusInterfaceMethod t DBusInterface, O.OverloadedMethod info DBusInterface p, R.HasField t DBusInterface p) => R.HasField t DBusInterface p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveDBusInterfaceMethod t DBusInterface, O.OverloadedMethodInfo info DBusInterface) => OL.IsLabel t (O.MethodProxy info DBusInterface) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- method DBusInterface::get_object
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "interface_"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "DBusInterface" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "An exported D-Bus interface."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "DBusObject" })
-- throws : False
-- Skip return : False

foreign import ccall "g_dbus_interface_dup_object" g_dbus_interface_dup_object :: 
    Ptr DBusInterface ->                    -- interface_ : TInterface (Name {namespace = "Gio", name = "DBusInterface"})
    IO (Ptr Gio.DBusObject.DBusObject)

-- | Gets the t'GI.Gio.Interfaces.DBusObject.DBusObject' that /@interface_@/ belongs to, if any.
-- 
-- /Since: 2.32/
dBusInterfaceGetObject ::
    (B.CallStack.HasCallStack, MonadIO m, IsDBusInterface a) =>
    a
    -- ^ /@interface_@/: An exported D-Bus interface.
    -> m (Maybe Gio.DBusObject.DBusObject)
    -- ^ __Returns:__ A t'GI.Gio.Interfaces.DBusObject.DBusObject' or 'P.Nothing'. The returned
    -- reference should be freed with 'GI.GObject.Objects.Object.objectUnref'.
dBusInterfaceGetObject interface_ = liftIO $ do
    interface_' <- unsafeManagedPtrCastPtr interface_
    result <- g_dbus_interface_dup_object interface_'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapObject Gio.DBusObject.DBusObject) result'
        return result''
    touchManagedPtr interface_
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data DBusInterfaceGetObjectMethodInfo
instance (signature ~ (m (Maybe Gio.DBusObject.DBusObject)), MonadIO m, IsDBusInterface a) => O.OverloadedMethod DBusInterfaceGetObjectMethodInfo a signature where
    overloadedMethod = dBusInterfaceGetObject

instance O.OverloadedMethodInfo DBusInterfaceGetObjectMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.DBusInterface.dBusInterfaceGetObject",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Interfaces-DBusInterface.html#v:dBusInterfaceGetObject"
        })


#endif

-- method DBusInterface::get_info
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "interface_"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "DBusInterface" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "An exported D-Bus interface."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gio" , name = "DBusInterfaceInfo" })
-- throws : False
-- Skip return : False

foreign import ccall "g_dbus_interface_get_info" g_dbus_interface_get_info :: 
    Ptr DBusInterface ->                    -- interface_ : TInterface (Name {namespace = "Gio", name = "DBusInterface"})
    IO (Ptr Gio.DBusInterfaceInfo.DBusInterfaceInfo)

-- | Gets D-Bus introspection information for the D-Bus interface
-- implemented by /@interface_@/.
-- 
-- /Since: 2.30/
dBusInterfaceGetInfo ::
    (B.CallStack.HasCallStack, MonadIO m, IsDBusInterface a) =>
    a
    -- ^ /@interface_@/: An exported D-Bus interface.
    -> m Gio.DBusInterfaceInfo.DBusInterfaceInfo
    -- ^ __Returns:__ A t'GI.Gio.Structs.DBusInterfaceInfo.DBusInterfaceInfo'. Do not free.
dBusInterfaceGetInfo interface_ = liftIO $ do
    interface_' <- unsafeManagedPtrCastPtr interface_
    result <- g_dbus_interface_get_info interface_'
    checkUnexpectedReturnNULL "dBusInterfaceGetInfo" result
    result' <- (newBoxed Gio.DBusInterfaceInfo.DBusInterfaceInfo) result
    touchManagedPtr interface_
    return result'

#if defined(ENABLE_OVERLOADING)
data DBusInterfaceGetInfoMethodInfo
instance (signature ~ (m Gio.DBusInterfaceInfo.DBusInterfaceInfo), MonadIO m, IsDBusInterface a) => O.OverloadedMethod DBusInterfaceGetInfoMethodInfo a signature where
    overloadedMethod = dBusInterfaceGetInfo

instance O.OverloadedMethodInfo DBusInterfaceGetInfoMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.DBusInterface.dBusInterfaceGetInfo",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Interfaces-DBusInterface.html#v:dBusInterfaceGetInfo"
        })


#endif

-- method DBusInterface::set_object
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "interface_"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "DBusInterface" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "An exported D-Bus interface."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "object"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "DBusObject" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GDBusObject or %NULL."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_dbus_interface_set_object" g_dbus_interface_set_object :: 
    Ptr DBusInterface ->                    -- interface_ : TInterface (Name {namespace = "Gio", name = "DBusInterface"})
    Ptr Gio.DBusObject.DBusObject ->        -- object : TInterface (Name {namespace = "Gio", name = "DBusObject"})
    IO ()

-- | Sets the t'GI.Gio.Interfaces.DBusObject.DBusObject' for /@interface_@/ to /@object@/.
-- 
-- Note that /@interface_@/ will hold a weak reference to /@object@/.
-- 
-- /Since: 2.30/
dBusInterfaceSetObject ::
    (B.CallStack.HasCallStack, MonadIO m, IsDBusInterface a, Gio.DBusObject.IsDBusObject b) =>
    a
    -- ^ /@interface_@/: An exported D-Bus interface.
    -> Maybe (b)
    -- ^ /@object@/: A t'GI.Gio.Interfaces.DBusObject.DBusObject' or 'P.Nothing'.
    -> m ()
dBusInterfaceSetObject interface_ object = liftIO $ do
    interface_' <- unsafeManagedPtrCastPtr interface_
    maybeObject <- case object of
        Nothing -> return FP.nullPtr
        Just jObject -> do
            jObject' <- unsafeManagedPtrCastPtr jObject
            return jObject'
    g_dbus_interface_set_object interface_' maybeObject
    touchManagedPtr interface_
    whenJust object touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data DBusInterfaceSetObjectMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsDBusInterface a, Gio.DBusObject.IsDBusObject b) => O.OverloadedMethod DBusInterfaceSetObjectMethodInfo a signature where
    overloadedMethod = dBusInterfaceSetObject

instance O.OverloadedMethodInfo DBusInterfaceSetObjectMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.DBusInterface.dBusInterfaceSetObject",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Interfaces-DBusInterface.html#v:dBusInterfaceSetObject"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList DBusInterface = DBusInterfaceSignalList
type DBusInterfaceSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif


