{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A structure which contains a single enum value, its name, and its
-- nickname.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GObject.Structs.EnumValue
    ( 

-- * Exported types
    EnumValue(..)                           ,
    newZeroEnumValue                        ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveEnumValueMethod                  ,
#endif



 -- * Properties


-- ** value #attr:value#
-- | the enum value

#if defined(ENABLE_OVERLOADING)
    enumValue_value                         ,
#endif
    getEnumValueValue                       ,
    setEnumValueValue                       ,


-- ** valueName #attr:valueName#
-- | the name of the value

    clearEnumValueValueName                 ,
#if defined(ENABLE_OVERLOADING)
    enumValue_valueName                     ,
#endif
    getEnumValueValueName                   ,
    setEnumValueValueName                   ,


-- ** valueNick #attr:valueNick#
-- | the nickname of the value

    clearEnumValueValueNick                 ,
#if defined(ENABLE_OVERLOADING)
    enumValue_valueNick                     ,
#endif
    getEnumValueValueNick                   ,
    setEnumValueValueNick                   ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- | Memory-managed wrapper type.
newtype EnumValue = EnumValue (SP.ManagedPtr EnumValue)
    deriving (Eq)

instance SP.ManagedPtrNewtype EnumValue where
    toManagedPtr (EnumValue p) = p

instance BoxedPtr EnumValue where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 24 >=> B.ManagedPtr.wrapPtr EnumValue)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr EnumValue where
    boxedPtrCalloc = callocBytes 24


-- | Construct a t'EnumValue' struct initialized to zero.
newZeroEnumValue :: MonadIO m => m EnumValue
newZeroEnumValue = liftIO $ boxedPtrCalloc >>= wrapPtr EnumValue

instance tag ~ 'AttrSet => Constructible EnumValue tag where
    new _ attrs = do
        o <- newZeroEnumValue
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@value@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' enumValue #value
-- @
getEnumValueValue :: MonadIO m => EnumValue -> m Int32
getEnumValueValue s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO Int32
    return val

-- | Set the value of the “@value@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' enumValue [ #value 'Data.GI.Base.Attributes.:=' value ]
-- @
setEnumValueValue :: MonadIO m => EnumValue -> Int32 -> m ()
setEnumValueValue s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data EnumValueValueFieldInfo
instance AttrInfo EnumValueValueFieldInfo where
    type AttrBaseTypeConstraint EnumValueValueFieldInfo = (~) EnumValue
    type AttrAllowedOps EnumValueValueFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EnumValueValueFieldInfo = (~) Int32
    type AttrTransferTypeConstraint EnumValueValueFieldInfo = (~)Int32
    type AttrTransferType EnumValueValueFieldInfo = Int32
    type AttrGetType EnumValueValueFieldInfo = Int32
    type AttrLabel EnumValueValueFieldInfo = "value"
    type AttrOrigin EnumValueValueFieldInfo = EnumValue
    attrGet = getEnumValueValue
    attrSet = setEnumValueValue
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.EnumValue.value"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Structs-EnumValue.html#g:attr:value"
        })

enumValue_value :: AttrLabelProxy "value"
enumValue_value = AttrLabelProxy

#endif


-- | Get the value of the “@value_name@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' enumValue #valueName
-- @
getEnumValueValueName :: MonadIO m => EnumValue -> m (Maybe T.Text)
getEnumValueValueName s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO CString
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- cstringToText val'
        return val''
    return result

-- | Set the value of the “@value_name@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' enumValue [ #valueName 'Data.GI.Base.Attributes.:=' value ]
-- @
setEnumValueValueName :: MonadIO m => EnumValue -> CString -> m ()
setEnumValueValueName s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: CString)

-- | Set the value of the “@value_name@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #valueName
-- @
clearEnumValueValueName :: MonadIO m => EnumValue -> m ()
clearEnumValueValueName s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (FP.nullPtr :: CString)

#if defined(ENABLE_OVERLOADING)
data EnumValueValueNameFieldInfo
instance AttrInfo EnumValueValueNameFieldInfo where
    type AttrBaseTypeConstraint EnumValueValueNameFieldInfo = (~) EnumValue
    type AttrAllowedOps EnumValueValueNameFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint EnumValueValueNameFieldInfo = (~) CString
    type AttrTransferTypeConstraint EnumValueValueNameFieldInfo = (~)CString
    type AttrTransferType EnumValueValueNameFieldInfo = CString
    type AttrGetType EnumValueValueNameFieldInfo = Maybe T.Text
    type AttrLabel EnumValueValueNameFieldInfo = "value_name"
    type AttrOrigin EnumValueValueNameFieldInfo = EnumValue
    attrGet = getEnumValueValueName
    attrSet = setEnumValueValueName
    attrConstruct = undefined
    attrClear = clearEnumValueValueName
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.EnumValue.valueName"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Structs-EnumValue.html#g:attr:valueName"
        })

enumValue_valueName :: AttrLabelProxy "valueName"
enumValue_valueName = AttrLabelProxy

#endif


-- | Get the value of the “@value_nick@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' enumValue #valueNick
-- @
getEnumValueValueNick :: MonadIO m => EnumValue -> m (Maybe T.Text)
getEnumValueValueNick s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO CString
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- cstringToText val'
        return val''
    return result

-- | Set the value of the “@value_nick@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' enumValue [ #valueNick 'Data.GI.Base.Attributes.:=' value ]
-- @
setEnumValueValueNick :: MonadIO m => EnumValue -> CString -> m ()
setEnumValueValueNick s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (val :: CString)

-- | Set the value of the “@value_nick@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #valueNick
-- @
clearEnumValueValueNick :: MonadIO m => EnumValue -> m ()
clearEnumValueValueNick s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (FP.nullPtr :: CString)

#if defined(ENABLE_OVERLOADING)
data EnumValueValueNickFieldInfo
instance AttrInfo EnumValueValueNickFieldInfo where
    type AttrBaseTypeConstraint EnumValueValueNickFieldInfo = (~) EnumValue
    type AttrAllowedOps EnumValueValueNickFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint EnumValueValueNickFieldInfo = (~) CString
    type AttrTransferTypeConstraint EnumValueValueNickFieldInfo = (~)CString
    type AttrTransferType EnumValueValueNickFieldInfo = CString
    type AttrGetType EnumValueValueNickFieldInfo = Maybe T.Text
    type AttrLabel EnumValueValueNickFieldInfo = "value_nick"
    type AttrOrigin EnumValueValueNickFieldInfo = EnumValue
    attrGet = getEnumValueValueNick
    attrSet = setEnumValueValueNick
    attrConstruct = undefined
    attrClear = clearEnumValueValueNick
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.EnumValue.valueNick"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Structs-EnumValue.html#g:attr:valueNick"
        })

enumValue_valueNick :: AttrLabelProxy "valueNick"
enumValue_valueNick = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList EnumValue
type instance O.AttributeList EnumValue = EnumValueAttributeList
type EnumValueAttributeList = ('[ '("value", EnumValueValueFieldInfo), '("valueName", EnumValueValueNameFieldInfo), '("valueNick", EnumValueValueNickFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveEnumValueMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveEnumValueMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveEnumValueMethod t EnumValue, O.OverloadedMethod info EnumValue p) => OL.IsLabel t (EnumValue -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveEnumValueMethod t EnumValue, O.OverloadedMethod info EnumValue p, R.HasField t EnumValue p) => R.HasField t EnumValue p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveEnumValueMethod t EnumValue, O.OverloadedMethodInfo info EnumValue) => OL.IsLabel t (O.MethodProxy info EnumValue) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


