{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A render node applying a rectangular clip to its single child node.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gsk.Objects.ClipNode
    ( 

-- * Exported types
    ClipNode(..)                            ,
    IsClipNode                              ,
    toClipNode                              ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [draw]("GI.Gsk.Objects.RenderNode#g:method:draw"), [ref]("GI.Gsk.Objects.RenderNode#g:method:ref"), [serialize]("GI.Gsk.Objects.RenderNode#g:method:serialize"), [unref]("GI.Gsk.Objects.RenderNode#g:method:unref"), [writeToFile]("GI.Gsk.Objects.RenderNode#g:method:writeToFile").
-- 
-- ==== Getters
-- [getBounds]("GI.Gsk.Objects.RenderNode#g:method:getBounds"), [getChild]("GI.Gsk.Objects.ClipNode#g:method:getChild"), [getClip]("GI.Gsk.Objects.ClipNode#g:method:getClip"), [getNodeType]("GI.Gsk.Objects.RenderNode#g:method:getNodeType"), [getOpaqueRect]("GI.Gsk.Objects.RenderNode#g:method:getOpaqueRect").
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveClipNodeMethod                   ,
#endif

-- ** getChild #method:getChild#

#if defined(ENABLE_OVERLOADING)
    ClipNodeGetChildMethodInfo              ,
#endif
    clipNodeGetChild                        ,


-- ** getClip #method:getClip#

#if defined(ENABLE_OVERLOADING)
    ClipNodeGetClipMethodInfo               ,
#endif
    clipNodeGetClip                         ,


-- ** new #method:new#

    clipNodeNew                             ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Gsk.Callbacks as Gsk.Callbacks
import {-# SOURCE #-} qualified GI.Gsk.Enums as Gsk.Enums
import {-# SOURCE #-} qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode

#else
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import {-# SOURCE #-} qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode

#endif

-- | Memory-managed wrapper type.
newtype ClipNode = ClipNode (SP.ManagedPtr ClipNode)
    deriving (Eq)

instance SP.ManagedPtrNewtype ClipNode where
    toManagedPtr (ClipNode p) = p

foreign import ccall "gsk_clip_node_get_type"
    c_gsk_clip_node_get_type :: IO B.Types.GType

instance B.Types.TypedObject ClipNode where
    glibType = c_gsk_clip_node_get_type

-- | Type class for types which can be safely cast to t'ClipNode', for instance with `toClipNode`.
class (SP.BoxedPtr o, SP.TypedObject o, O.IsDescendantOf ClipNode o) => IsClipNode o
instance (SP.BoxedPtr o, SP.TypedObject o, O.IsDescendantOf ClipNode o) => IsClipNode o

instance O.HasParentTypes ClipNode
type instance O.ParentTypes ClipNode = '[Gsk.RenderNode.RenderNode]

-- | Cast to t'ClipNode', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toClipNode :: (MIO.MonadIO m, IsClipNode o) => o -> m ClipNode
toClipNode = MIO.liftIO . B.ManagedPtr.unsafeCastTo ClipNode

--- XXX Missing getter and/or setter, so no GValue instance could be generated.
#if defined(ENABLE_OVERLOADING)
type family ResolveClipNodeMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveClipNodeMethod "draw" o = Gsk.RenderNode.RenderNodeDrawMethodInfo
    ResolveClipNodeMethod "ref" o = Gsk.RenderNode.RenderNodeRefMethodInfo
    ResolveClipNodeMethod "serialize" o = Gsk.RenderNode.RenderNodeSerializeMethodInfo
    ResolveClipNodeMethod "unref" o = Gsk.RenderNode.RenderNodeUnrefMethodInfo
    ResolveClipNodeMethod "writeToFile" o = Gsk.RenderNode.RenderNodeWriteToFileMethodInfo
    ResolveClipNodeMethod "getBounds" o = Gsk.RenderNode.RenderNodeGetBoundsMethodInfo
    ResolveClipNodeMethod "getChild" o = ClipNodeGetChildMethodInfo
    ResolveClipNodeMethod "getClip" o = ClipNodeGetClipMethodInfo
    ResolveClipNodeMethod "getNodeType" o = Gsk.RenderNode.RenderNodeGetNodeTypeMethodInfo
    ResolveClipNodeMethod "getOpaqueRect" o = Gsk.RenderNode.RenderNodeGetOpaqueRectMethodInfo
    ResolveClipNodeMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveClipNodeMethod t ClipNode, O.OverloadedMethod info ClipNode p) => OL.IsLabel t (ClipNode -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveClipNodeMethod t ClipNode, O.OverloadedMethod info ClipNode p, R.HasField t ClipNode p) => R.HasField t ClipNode p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveClipNodeMethod t ClipNode, O.OverloadedMethodInfo info ClipNode) => OL.IsLabel t (O.MethodProxy info ClipNode) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- XXX Wrapping a foreign struct/union with no known destructor or size, leak?
instance BoxedPtr ClipNode where
    boxedPtrCopy = return
    boxedPtrFree = \_x -> return ()


-- method ClipNode::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "child"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "RenderNode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The node to draw" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "clip"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Rect" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The clip to apply" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gsk" , name = "ClipNode" })
-- throws : False
-- Skip return : False

foreign import ccall "gsk_clip_node_new" gsk_clip_node_new :: 
    Ptr Gsk.RenderNode.RenderNode ->        -- child : TInterface (Name {namespace = "Gsk", name = "RenderNode"})
    Ptr Graphene.Rect.Rect ->               -- clip : TInterface (Name {namespace = "Graphene", name = "Rect"})
    IO (Ptr ClipNode)

-- | Creates a @GskRenderNode@ that will clip the /@child@/ to the area
-- given by /@clip@/.
clipNodeNew ::
    (B.CallStack.HasCallStack, MonadIO m, Gsk.RenderNode.IsRenderNode a) =>
    a
    -- ^ /@child@/: The node to draw
    -> Graphene.Rect.Rect
    -- ^ /@clip@/: The clip to apply
    -> m ClipNode
    -- ^ __Returns:__ A new @GskRenderNode@
clipNodeNew child clip = liftIO $ do
    child' <- unsafeManagedPtrCastPtr child
    clip' <- unsafeManagedPtrGetPtr clip
    result <- gsk_clip_node_new child' clip'
    checkUnexpectedReturnNULL "clipNodeNew" result
    result' <- (wrapPtr ClipNode) result
    touchManagedPtr child
    touchManagedPtr clip
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method ClipNode::get_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "node"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "ClipNode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a clip @GskRenderNode"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gsk" , name = "RenderNode" })
-- throws : False
-- Skip return : False

foreign import ccall "gsk_clip_node_get_child" gsk_clip_node_get_child :: 
    Ptr ClipNode ->                         -- node : TInterface (Name {namespace = "Gsk", name = "ClipNode"})
    IO (Ptr Gsk.RenderNode.RenderNode)

-- | Gets the child node that is getting clipped by the given /@node@/.
clipNodeGetChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsClipNode a) =>
    a
    -- ^ /@node@/: a clip /@gskRenderNode@/
    -> m Gsk.RenderNode.RenderNode
    -- ^ __Returns:__ The child that is getting clipped
clipNodeGetChild node = liftIO $ do
    node' <- unsafeManagedPtrCastPtr node
    result <- gsk_clip_node_get_child node'
    checkUnexpectedReturnNULL "clipNodeGetChild" result
    result' <- (newPtr Gsk.RenderNode.RenderNode) result
    touchManagedPtr node
    return result'

#if defined(ENABLE_OVERLOADING)
data ClipNodeGetChildMethodInfo
instance (signature ~ (m Gsk.RenderNode.RenderNode), MonadIO m, IsClipNode a) => O.OverloadedMethod ClipNodeGetChildMethodInfo a signature where
    overloadedMethod = clipNodeGetChild

instance O.OverloadedMethodInfo ClipNodeGetChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Objects.ClipNode.clipNodeGetChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Objects-ClipNode.html#v:clipNodeGetChild"
        })


#endif

-- method ClipNode::get_clip
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "node"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "ClipNode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GskClipNode`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Graphene" , name = "Rect" })
-- throws : False
-- Skip return : False

foreign import ccall "gsk_clip_node_get_clip" gsk_clip_node_get_clip :: 
    Ptr ClipNode ->                         -- node : TInterface (Name {namespace = "Gsk", name = "ClipNode"})
    IO (Ptr Graphene.Rect.Rect)

-- | Retrieves the clip rectangle for /@node@/.
clipNodeGetClip ::
    (B.CallStack.HasCallStack, MonadIO m, IsClipNode a) =>
    a
    -- ^ /@node@/: a @GskClipNode@
    -> m Graphene.Rect.Rect
    -- ^ __Returns:__ a clip rectangle
clipNodeGetClip node = liftIO $ do
    node' <- unsafeManagedPtrCastPtr node
    result <- gsk_clip_node_get_clip node'
    checkUnexpectedReturnNULL "clipNodeGetClip" result
    result' <- (newBoxed Graphene.Rect.Rect) result
    touchManagedPtr node
    return result'

#if defined(ENABLE_OVERLOADING)
data ClipNodeGetClipMethodInfo
instance (signature ~ (m Graphene.Rect.Rect), MonadIO m, IsClipNode a) => O.OverloadedMethod ClipNodeGetClipMethodInfo a signature where
    overloadedMethod = clipNodeGetClip

instance O.OverloadedMethodInfo ClipNodeGetClipMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Objects.ClipNode.clipNodeGetClip",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Objects-ClipNode.html#v:clipNodeGetClip"
        })


#endif


