{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Creates widgets by instantiating @GtkBuilder@ UI templates.
-- 
-- The templates must extend the class that the parent widget expects.
-- For example, a factory provided to [ListView:factory]("GI.Gtk.Objects.ListView#g:attr:factory") must have
-- a template that extends t'GI.Gtk.Objects.ListItem.ListItem'.
-- 
-- Templates typically use t'GI.Gtk.Objects.Expression.Expression' to obtain data from the items
-- in the model.
-- 
-- Example:
-- 
-- === /xml code/
-- >  <interface>
-- >    <template class="GtkListItem">
-- >      <property name="child">
-- >        <object class="GtkLabel">
-- >          <property name="xalign">0</property>
-- >          <binding name="label">
-- >            <lookup name="name" type="SettingsKey">
-- >              <lookup name="item">GtkListItem</lookup>
-- >            </lookup>
-- >          </binding>
-- >        </object>
-- >      </property>
-- >    </template>
-- >  </interface>
-- 
-- 
-- A common approach is to embed such templates as CDATA marked sections into
-- a surrounding UI file. Note that if you use this approach, extracting
-- translatable strings with xgettext will not work for strings inside the
-- marked section.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.BuilderListItemFactory
    ( 

-- * Exported types
    BuilderListItemFactory(..)              ,
    IsBuilderListItemFactory                ,
    toBuilderListItemFactory                ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getBytes]("GI.Gtk.Objects.BuilderListItemFactory#g:method:getBytes"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getResource]("GI.Gtk.Objects.BuilderListItemFactory#g:method:getResource"), [getScope]("GI.Gtk.Objects.BuilderListItemFactory#g:method:getScope").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveBuilderListItemFactoryMethod     ,
#endif

-- ** getBytes #method:getBytes#

#if defined(ENABLE_OVERLOADING)
    BuilderListItemFactoryGetBytesMethodInfo,
#endif
    builderListItemFactoryGetBytes          ,


-- ** getResource #method:getResource#

#if defined(ENABLE_OVERLOADING)
    BuilderListItemFactoryGetResourceMethodInfo,
#endif
    builderListItemFactoryGetResource       ,


-- ** getScope #method:getScope#

#if defined(ENABLE_OVERLOADING)
    BuilderListItemFactoryGetScopeMethodInfo,
#endif
    builderListItemFactoryGetScope          ,


-- ** newFromBytes #method:newFromBytes#

    builderListItemFactoryNewFromBytes      ,


-- ** newFromResource #method:newFromResource#

    builderListItemFactoryNewFromResource   ,




 -- * Properties


-- ** bytes #attr:bytes#
-- | @GBytes@ containing the UI definition.

#if defined(ENABLE_OVERLOADING)
    BuilderListItemFactoryBytesPropertyInfo ,
#endif
#if defined(ENABLE_OVERLOADING)
    builderListItemFactoryBytes             ,
#endif
    constructBuilderListItemFactoryBytes    ,
    getBuilderListItemFactoryBytes          ,


-- ** resource #attr:resource#
-- | Path of the resource containing the UI definition.

#if defined(ENABLE_OVERLOADING)
    BuilderListItemFactoryResourcePropertyInfo,
#endif
#if defined(ENABLE_OVERLOADING)
    builderListItemFactoryResource          ,
#endif
    constructBuilderListItemFactoryResource ,
    getBuilderListItemFactoryResource       ,


-- ** scope #attr:scope#
-- | @GtkBuilderScope@ to use when instantiating listitems

#if defined(ENABLE_OVERLOADING)
    BuilderListItemFactoryScopePropertyInfo ,
#endif
#if defined(ENABLE_OVERLOADING)
    builderListItemFactoryScope             ,
#endif
    constructBuilderListItemFactoryScope    ,
    getBuilderListItemFactoryScope          ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.BuilderScope as Gtk.BuilderScope
import {-# SOURCE #-} qualified GI.Gtk.Objects.ListItemFactory as Gtk.ListItemFactory

#else
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.BuilderScope as Gtk.BuilderScope
import {-# SOURCE #-} qualified GI.Gtk.Objects.ListItemFactory as Gtk.ListItemFactory

#endif

-- | Memory-managed wrapper type.
newtype BuilderListItemFactory = BuilderListItemFactory (SP.ManagedPtr BuilderListItemFactory)
    deriving (Eq)

instance SP.ManagedPtrNewtype BuilderListItemFactory where
    toManagedPtr (BuilderListItemFactory p) = p

foreign import ccall "gtk_builder_list_item_factory_get_type"
    c_gtk_builder_list_item_factory_get_type :: IO B.Types.GType

instance B.Types.TypedObject BuilderListItemFactory where
    glibType = c_gtk_builder_list_item_factory_get_type

instance B.Types.GObject BuilderListItemFactory

-- | Type class for types which can be safely cast to t'BuilderListItemFactory', for instance with `toBuilderListItemFactory`.
class (SP.GObject o, O.IsDescendantOf BuilderListItemFactory o) => IsBuilderListItemFactory o
instance (SP.GObject o, O.IsDescendantOf BuilderListItemFactory o) => IsBuilderListItemFactory o

instance O.HasParentTypes BuilderListItemFactory
type instance O.ParentTypes BuilderListItemFactory = '[Gtk.ListItemFactory.ListItemFactory, GObject.Object.Object]

-- | Cast to t'BuilderListItemFactory', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toBuilderListItemFactory :: (MIO.MonadIO m, IsBuilderListItemFactory o) => o -> m BuilderListItemFactory
toBuilderListItemFactory = MIO.liftIO . B.ManagedPtr.unsafeCastTo BuilderListItemFactory

-- | Convert t'BuilderListItemFactory' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe BuilderListItemFactory) where
    gvalueGType_ = c_gtk_builder_list_item_factory_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr BuilderListItemFactory)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr BuilderListItemFactory)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject BuilderListItemFactory ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveBuilderListItemFactoryMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveBuilderListItemFactoryMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveBuilderListItemFactoryMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveBuilderListItemFactoryMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveBuilderListItemFactoryMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveBuilderListItemFactoryMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveBuilderListItemFactoryMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveBuilderListItemFactoryMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveBuilderListItemFactoryMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveBuilderListItemFactoryMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveBuilderListItemFactoryMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveBuilderListItemFactoryMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveBuilderListItemFactoryMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveBuilderListItemFactoryMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveBuilderListItemFactoryMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveBuilderListItemFactoryMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveBuilderListItemFactoryMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveBuilderListItemFactoryMethod "getBytes" o = BuilderListItemFactoryGetBytesMethodInfo
    ResolveBuilderListItemFactoryMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveBuilderListItemFactoryMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveBuilderListItemFactoryMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveBuilderListItemFactoryMethod "getResource" o = BuilderListItemFactoryGetResourceMethodInfo
    ResolveBuilderListItemFactoryMethod "getScope" o = BuilderListItemFactoryGetScopeMethodInfo
    ResolveBuilderListItemFactoryMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveBuilderListItemFactoryMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveBuilderListItemFactoryMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveBuilderListItemFactoryMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveBuilderListItemFactoryMethod t BuilderListItemFactory, O.OverloadedMethod info BuilderListItemFactory p) => OL.IsLabel t (BuilderListItemFactory -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveBuilderListItemFactoryMethod t BuilderListItemFactory, O.OverloadedMethod info BuilderListItemFactory p, R.HasField t BuilderListItemFactory p) => R.HasField t BuilderListItemFactory p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveBuilderListItemFactoryMethod t BuilderListItemFactory, O.OverloadedMethodInfo info BuilderListItemFactory) => OL.IsLabel t (O.MethodProxy info BuilderListItemFactory) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "bytes"
   -- Type: TInterface (Name {namespace = "GLib", name = "Bytes"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@bytes@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' builderListItemFactory #bytes
-- @
getBuilderListItemFactoryBytes :: (MonadIO m, IsBuilderListItemFactory o) => o -> m GLib.Bytes.Bytes
getBuilderListItemFactoryBytes obj = MIO.liftIO $ checkUnexpectedNothing "getBuilderListItemFactoryBytes" $ B.Properties.getObjectPropertyBoxed obj "bytes" GLib.Bytes.Bytes

-- | Construct a t'GValueConstruct' with valid value for the “@bytes@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructBuilderListItemFactoryBytes :: (IsBuilderListItemFactory o, MIO.MonadIO m) => GLib.Bytes.Bytes -> m (GValueConstruct o)
constructBuilderListItemFactoryBytes val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBoxed "bytes" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data BuilderListItemFactoryBytesPropertyInfo
instance AttrInfo BuilderListItemFactoryBytesPropertyInfo where
    type AttrAllowedOps BuilderListItemFactoryBytesPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint BuilderListItemFactoryBytesPropertyInfo = IsBuilderListItemFactory
    type AttrSetTypeConstraint BuilderListItemFactoryBytesPropertyInfo = (~) GLib.Bytes.Bytes
    type AttrTransferTypeConstraint BuilderListItemFactoryBytesPropertyInfo = (~) GLib.Bytes.Bytes
    type AttrTransferType BuilderListItemFactoryBytesPropertyInfo = GLib.Bytes.Bytes
    type AttrGetType BuilderListItemFactoryBytesPropertyInfo = GLib.Bytes.Bytes
    type AttrLabel BuilderListItemFactoryBytesPropertyInfo = "bytes"
    type AttrOrigin BuilderListItemFactoryBytesPropertyInfo = BuilderListItemFactory
    attrGet = getBuilderListItemFactoryBytes
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructBuilderListItemFactoryBytes
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.BuilderListItemFactory.bytes"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-BuilderListItemFactory.html#g:attr:bytes"
        })
#endif

-- VVV Prop "resource"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just True,Nothing)

-- | Get the value of the “@resource@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' builderListItemFactory #resource
-- @
getBuilderListItemFactoryResource :: (MonadIO m, IsBuilderListItemFactory o) => o -> m (Maybe T.Text)
getBuilderListItemFactoryResource obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "resource"

-- | Construct a t'GValueConstruct' with valid value for the “@resource@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructBuilderListItemFactoryResource :: (IsBuilderListItemFactory o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructBuilderListItemFactoryResource val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "resource" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data BuilderListItemFactoryResourcePropertyInfo
instance AttrInfo BuilderListItemFactoryResourcePropertyInfo where
    type AttrAllowedOps BuilderListItemFactoryResourcePropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint BuilderListItemFactoryResourcePropertyInfo = IsBuilderListItemFactory
    type AttrSetTypeConstraint BuilderListItemFactoryResourcePropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint BuilderListItemFactoryResourcePropertyInfo = (~) T.Text
    type AttrTransferType BuilderListItemFactoryResourcePropertyInfo = T.Text
    type AttrGetType BuilderListItemFactoryResourcePropertyInfo = (Maybe T.Text)
    type AttrLabel BuilderListItemFactoryResourcePropertyInfo = "resource"
    type AttrOrigin BuilderListItemFactoryResourcePropertyInfo = BuilderListItemFactory
    attrGet = getBuilderListItemFactoryResource
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructBuilderListItemFactoryResource
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.BuilderListItemFactory.resource"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-BuilderListItemFactory.html#g:attr:resource"
        })
#endif

-- VVV Prop "scope"
   -- Type: TInterface (Name {namespace = "Gtk", name = "BuilderScope"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just True,Nothing)

-- | Get the value of the “@scope@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' builderListItemFactory #scope
-- @
getBuilderListItemFactoryScope :: (MonadIO m, IsBuilderListItemFactory o) => o -> m (Maybe Gtk.BuilderScope.BuilderScope)
getBuilderListItemFactoryScope obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "scope" Gtk.BuilderScope.BuilderScope

-- | Construct a t'GValueConstruct' with valid value for the “@scope@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructBuilderListItemFactoryScope :: (IsBuilderListItemFactory o, MIO.MonadIO m, Gtk.BuilderScope.IsBuilderScope a) => a -> m (GValueConstruct o)
constructBuilderListItemFactoryScope val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "scope" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data BuilderListItemFactoryScopePropertyInfo
instance AttrInfo BuilderListItemFactoryScopePropertyInfo where
    type AttrAllowedOps BuilderListItemFactoryScopePropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint BuilderListItemFactoryScopePropertyInfo = IsBuilderListItemFactory
    type AttrSetTypeConstraint BuilderListItemFactoryScopePropertyInfo = Gtk.BuilderScope.IsBuilderScope
    type AttrTransferTypeConstraint BuilderListItemFactoryScopePropertyInfo = Gtk.BuilderScope.IsBuilderScope
    type AttrTransferType BuilderListItemFactoryScopePropertyInfo = Gtk.BuilderScope.BuilderScope
    type AttrGetType BuilderListItemFactoryScopePropertyInfo = (Maybe Gtk.BuilderScope.BuilderScope)
    type AttrLabel BuilderListItemFactoryScopePropertyInfo = "scope"
    type AttrOrigin BuilderListItemFactoryScopePropertyInfo = BuilderListItemFactory
    attrGet = getBuilderListItemFactoryScope
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ v = do
        unsafeCastTo Gtk.BuilderScope.BuilderScope v
    attrConstruct = constructBuilderListItemFactoryScope
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.BuilderListItemFactory.scope"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-BuilderListItemFactory.html#g:attr:scope"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList BuilderListItemFactory
type instance O.AttributeList BuilderListItemFactory = BuilderListItemFactoryAttributeList
type BuilderListItemFactoryAttributeList = ('[ '("bytes", BuilderListItemFactoryBytesPropertyInfo), '("resource", BuilderListItemFactoryResourcePropertyInfo), '("scope", BuilderListItemFactoryScopePropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
builderListItemFactoryBytes :: AttrLabelProxy "bytes"
builderListItemFactoryBytes = AttrLabelProxy

builderListItemFactoryResource :: AttrLabelProxy "resource"
builderListItemFactoryResource = AttrLabelProxy

builderListItemFactoryScope :: AttrLabelProxy "scope"
builderListItemFactoryScope = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList BuilderListItemFactory = BuilderListItemFactorySignalList
type BuilderListItemFactorySignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method BuilderListItemFactory::new_from_bytes
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "scope"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "BuilderScope" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A scope to use when instantiating"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "bytes"
--           , argType = TInterface Name { namespace = "GLib" , name = "Bytes" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the `GBytes` containing the UI definition to instantiate"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gtk" , name = "BuilderListItemFactory" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_builder_list_item_factory_new_from_bytes" gtk_builder_list_item_factory_new_from_bytes :: 
    Ptr Gtk.BuilderScope.BuilderScope ->    -- scope : TInterface (Name {namespace = "Gtk", name = "BuilderScope"})
    Ptr GLib.Bytes.Bytes ->                 -- bytes : TInterface (Name {namespace = "GLib", name = "Bytes"})
    IO (Ptr BuilderListItemFactory)

-- | Creates a new @GtkBuilderListItemFactory@ that instantiates widgets
-- using /@bytes@/ as the data to pass to @GtkBuilder@.
builderListItemFactoryNewFromBytes ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.BuilderScope.IsBuilderScope a) =>
    Maybe (a)
    -- ^ /@scope@/: A scope to use when instantiating
    -> GLib.Bytes.Bytes
    -- ^ /@bytes@/: the @GBytes@ containing the UI definition to instantiate
    -> m BuilderListItemFactory
    -- ^ __Returns:__ a new @GtkBuilderListItemFactory@
builderListItemFactoryNewFromBytes scope bytes = liftIO $ do
    maybeScope <- case scope of
        Nothing -> return FP.nullPtr
        Just jScope -> do
            jScope' <- unsafeManagedPtrCastPtr jScope
            return jScope'
    bytes' <- unsafeManagedPtrGetPtr bytes
    result <- gtk_builder_list_item_factory_new_from_bytes maybeScope bytes'
    checkUnexpectedReturnNULL "builderListItemFactoryNewFromBytes" result
    result' <- (wrapObject BuilderListItemFactory) result
    whenJust scope touchManagedPtr
    touchManagedPtr bytes
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method BuilderListItemFactory::new_from_resource
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "scope"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "BuilderScope" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A scope to use when instantiating"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "resource_path"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "valid path to a resource that contains the UI definition"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gtk" , name = "BuilderListItemFactory" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_builder_list_item_factory_new_from_resource" gtk_builder_list_item_factory_new_from_resource :: 
    Ptr Gtk.BuilderScope.BuilderScope ->    -- scope : TInterface (Name {namespace = "Gtk", name = "BuilderScope"})
    CString ->                              -- resource_path : TBasicType TUTF8
    IO (Ptr BuilderListItemFactory)

-- | Creates a new @GtkBuilderListItemFactory@ that instantiates widgets
-- using data read from the given /@resourcePath@/ to pass to @GtkBuilder@.
builderListItemFactoryNewFromResource ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.BuilderScope.IsBuilderScope a) =>
    Maybe (a)
    -- ^ /@scope@/: A scope to use when instantiating
    -> T.Text
    -- ^ /@resourcePath@/: valid path to a resource that contains the UI definition
    -> m BuilderListItemFactory
    -- ^ __Returns:__ a new @GtkBuilderListItemFactory@
builderListItemFactoryNewFromResource scope resourcePath = liftIO $ do
    maybeScope <- case scope of
        Nothing -> return FP.nullPtr
        Just jScope -> do
            jScope' <- unsafeManagedPtrCastPtr jScope
            return jScope'
    resourcePath' <- textToCString resourcePath
    result <- gtk_builder_list_item_factory_new_from_resource maybeScope resourcePath'
    checkUnexpectedReturnNULL "builderListItemFactoryNewFromResource" result
    result' <- (wrapObject BuilderListItemFactory) result
    whenJust scope touchManagedPtr
    freeMem resourcePath'
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method BuilderListItemFactory::get_bytes
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface
--                 Name { namespace = "Gtk" , name = "BuilderListItemFactory" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkBuilderListItemFactory`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "GLib" , name = "Bytes" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_builder_list_item_factory_get_bytes" gtk_builder_list_item_factory_get_bytes :: 
    Ptr BuilderListItemFactory ->           -- self : TInterface (Name {namespace = "Gtk", name = "BuilderListItemFactory"})
    IO (Ptr GLib.Bytes.Bytes)

-- | Gets the data used as the @GtkBuilder@ UI template for constructing
-- listitems.
builderListItemFactoryGetBytes ::
    (B.CallStack.HasCallStack, MonadIO m, IsBuilderListItemFactory a) =>
    a
    -- ^ /@self@/: a @GtkBuilderListItemFactory@
    -> m GLib.Bytes.Bytes
    -- ^ __Returns:__ The @GtkBuilder@ data
builderListItemFactoryGetBytes self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_builder_list_item_factory_get_bytes self'
    checkUnexpectedReturnNULL "builderListItemFactoryGetBytes" result
    result' <- (newBoxed GLib.Bytes.Bytes) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data BuilderListItemFactoryGetBytesMethodInfo
instance (signature ~ (m GLib.Bytes.Bytes), MonadIO m, IsBuilderListItemFactory a) => O.OverloadedMethod BuilderListItemFactoryGetBytesMethodInfo a signature where
    overloadedMethod = builderListItemFactoryGetBytes

instance O.OverloadedMethodInfo BuilderListItemFactoryGetBytesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.BuilderListItemFactory.builderListItemFactoryGetBytes",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-BuilderListItemFactory.html#v:builderListItemFactoryGetBytes"
        })


#endif

-- method BuilderListItemFactory::get_resource
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface
--                 Name { namespace = "Gtk" , name = "BuilderListItemFactory" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkBuilderListItemFactory`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_builder_list_item_factory_get_resource" gtk_builder_list_item_factory_get_resource :: 
    Ptr BuilderListItemFactory ->           -- self : TInterface (Name {namespace = "Gtk", name = "BuilderListItemFactory"})
    IO CString

-- | If the data references a resource, gets the path of that resource.
builderListItemFactoryGetResource ::
    (B.CallStack.HasCallStack, MonadIO m, IsBuilderListItemFactory a) =>
    a
    -- ^ /@self@/: a @GtkBuilderListItemFactory@
    -> m (Maybe T.Text)
    -- ^ __Returns:__ The path to the resource
builderListItemFactoryGetResource self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_builder_list_item_factory_get_resource self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data BuilderListItemFactoryGetResourceMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m, IsBuilderListItemFactory a) => O.OverloadedMethod BuilderListItemFactoryGetResourceMethodInfo a signature where
    overloadedMethod = builderListItemFactoryGetResource

instance O.OverloadedMethodInfo BuilderListItemFactoryGetResourceMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.BuilderListItemFactory.builderListItemFactoryGetResource",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-BuilderListItemFactory.html#v:builderListItemFactoryGetResource"
        })


#endif

-- method BuilderListItemFactory::get_scope
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface
--                 Name { namespace = "Gtk" , name = "BuilderListItemFactory" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkBuilderListItemFactory`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "BuilderScope" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_builder_list_item_factory_get_scope" gtk_builder_list_item_factory_get_scope :: 
    Ptr BuilderListItemFactory ->           -- self : TInterface (Name {namespace = "Gtk", name = "BuilderListItemFactory"})
    IO (Ptr Gtk.BuilderScope.BuilderScope)

-- | Gets the scope used when constructing listitems.
builderListItemFactoryGetScope ::
    (B.CallStack.HasCallStack, MonadIO m, IsBuilderListItemFactory a) =>
    a
    -- ^ /@self@/: a @GtkBuilderListItemFactory@
    -> m (Maybe Gtk.BuilderScope.BuilderScope)
    -- ^ __Returns:__ The scope used when constructing listitems
builderListItemFactoryGetScope self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_builder_list_item_factory_get_scope self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.BuilderScope.BuilderScope) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data BuilderListItemFactoryGetScopeMethodInfo
instance (signature ~ (m (Maybe Gtk.BuilderScope.BuilderScope)), MonadIO m, IsBuilderListItemFactory a) => O.OverloadedMethod BuilderListItemFactoryGetScopeMethodInfo a signature where
    overloadedMethod = builderListItemFactoryGetScope

instance O.OverloadedMethodInfo BuilderListItemFactoryGetScopeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.BuilderListItemFactory.builderListItemFactoryGetScope",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-BuilderListItemFactory.html#v:builderListItemFactoryGetScope"
        })


#endif


