{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- @GtkLayoutChild@ subclass for children in a @GtkFixedLayout@.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.FixedLayoutChild
    ( 

-- * Exported types
    FixedLayoutChild(..)                    ,
    IsFixedLayoutChild                      ,
    toFixedLayoutChild                      ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getChildWidget]("GI.Gtk.Objects.LayoutChild#g:method:getChildWidget"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getLayoutManager]("GI.Gtk.Objects.LayoutChild#g:method:getLayoutManager"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getTransform]("GI.Gtk.Objects.FixedLayoutChild#g:method:getTransform").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setTransform]("GI.Gtk.Objects.FixedLayoutChild#g:method:setTransform").

#if defined(ENABLE_OVERLOADING)
    ResolveFixedLayoutChildMethod           ,
#endif

-- ** getTransform #method:getTransform#

#if defined(ENABLE_OVERLOADING)
    FixedLayoutChildGetTransformMethodInfo  ,
#endif
    fixedLayoutChildGetTransform            ,


-- ** setTransform #method:setTransform#

#if defined(ENABLE_OVERLOADING)
    FixedLayoutChildSetTransformMethodInfo  ,
#endif
    fixedLayoutChildSetTransform            ,




 -- * Properties


-- ** transform #attr:transform#
-- | The transform of the child.

#if defined(ENABLE_OVERLOADING)
    FixedLayoutChildTransformPropertyInfo   ,
#endif
    constructFixedLayoutChildTransform      ,
#if defined(ENABLE_OVERLOADING)
    fixedLayoutChildTransform               ,
#endif
    getFixedLayoutChildTransform            ,
    setFixedLayoutChildTransform            ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.ComponentTransfer as Gsk.ComponentTransfer
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild

#endif

-- | Memory-managed wrapper type.
newtype FixedLayoutChild = FixedLayoutChild (SP.ManagedPtr FixedLayoutChild)
    deriving (Eq)

instance SP.ManagedPtrNewtype FixedLayoutChild where
    toManagedPtr (FixedLayoutChild p) = p

foreign import ccall "gtk_fixed_layout_child_get_type"
    c_gtk_fixed_layout_child_get_type :: IO B.Types.GType

instance B.Types.TypedObject FixedLayoutChild where
    glibType = c_gtk_fixed_layout_child_get_type

instance B.Types.GObject FixedLayoutChild

-- | Type class for types which can be safely cast to t'FixedLayoutChild', for instance with `toFixedLayoutChild`.
class (SP.GObject o, O.IsDescendantOf FixedLayoutChild o) => IsFixedLayoutChild o
instance (SP.GObject o, O.IsDescendantOf FixedLayoutChild o) => IsFixedLayoutChild o

instance O.HasParentTypes FixedLayoutChild
type instance O.ParentTypes FixedLayoutChild = '[Gtk.LayoutChild.LayoutChild, GObject.Object.Object]

-- | Cast to t'FixedLayoutChild', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toFixedLayoutChild :: (MIO.MonadIO m, IsFixedLayoutChild o) => o -> m FixedLayoutChild
toFixedLayoutChild = MIO.liftIO . B.ManagedPtr.unsafeCastTo FixedLayoutChild

-- | Convert t'FixedLayoutChild' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe FixedLayoutChild) where
    gvalueGType_ = c_gtk_fixed_layout_child_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr FixedLayoutChild)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr FixedLayoutChild)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject FixedLayoutChild ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveFixedLayoutChildMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveFixedLayoutChildMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveFixedLayoutChildMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveFixedLayoutChildMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveFixedLayoutChildMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveFixedLayoutChildMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveFixedLayoutChildMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveFixedLayoutChildMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveFixedLayoutChildMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveFixedLayoutChildMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveFixedLayoutChildMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveFixedLayoutChildMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveFixedLayoutChildMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveFixedLayoutChildMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveFixedLayoutChildMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveFixedLayoutChildMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveFixedLayoutChildMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveFixedLayoutChildMethod "getChildWidget" o = Gtk.LayoutChild.LayoutChildGetChildWidgetMethodInfo
    ResolveFixedLayoutChildMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveFixedLayoutChildMethod "getLayoutManager" o = Gtk.LayoutChild.LayoutChildGetLayoutManagerMethodInfo
    ResolveFixedLayoutChildMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveFixedLayoutChildMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveFixedLayoutChildMethod "getTransform" o = FixedLayoutChildGetTransformMethodInfo
    ResolveFixedLayoutChildMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveFixedLayoutChildMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveFixedLayoutChildMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveFixedLayoutChildMethod "setTransform" o = FixedLayoutChildSetTransformMethodInfo
    ResolveFixedLayoutChildMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveFixedLayoutChildMethod t FixedLayoutChild, O.OverloadedMethod info FixedLayoutChild p) => OL.IsLabel t (FixedLayoutChild -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveFixedLayoutChildMethod t FixedLayoutChild, O.OverloadedMethod info FixedLayoutChild p, R.HasField t FixedLayoutChild p) => R.HasField t FixedLayoutChild p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveFixedLayoutChildMethod t FixedLayoutChild, O.OverloadedMethodInfo info FixedLayoutChild) => OL.IsLabel t (O.MethodProxy info FixedLayoutChild) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "transform"
   -- Type: TInterface (Name {namespace = "Gsk", name = "Transform"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just False)

-- | Get the value of the “@transform@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' fixedLayoutChild #transform
-- @
getFixedLayoutChildTransform :: (MonadIO m, IsFixedLayoutChild o) => o -> m (Maybe Gsk.Transform.Transform)
getFixedLayoutChildTransform obj = MIO.liftIO $ B.Properties.getObjectPropertyBoxed obj "transform" Gsk.Transform.Transform

-- | Set the value of the “@transform@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' fixedLayoutChild [ #transform 'Data.GI.Base.Attributes.:=' value ]
-- @
setFixedLayoutChildTransform :: (MonadIO m, IsFixedLayoutChild o) => o -> Gsk.Transform.Transform -> m ()
setFixedLayoutChildTransform obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBoxed obj "transform" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@transform@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructFixedLayoutChildTransform :: (IsFixedLayoutChild o, MIO.MonadIO m) => Gsk.Transform.Transform -> m (GValueConstruct o)
constructFixedLayoutChildTransform val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBoxed "transform" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data FixedLayoutChildTransformPropertyInfo
instance AttrInfo FixedLayoutChildTransformPropertyInfo where
    type AttrAllowedOps FixedLayoutChildTransformPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint FixedLayoutChildTransformPropertyInfo = IsFixedLayoutChild
    type AttrSetTypeConstraint FixedLayoutChildTransformPropertyInfo = (~) Gsk.Transform.Transform
    type AttrTransferTypeConstraint FixedLayoutChildTransformPropertyInfo = (~) Gsk.Transform.Transform
    type AttrTransferType FixedLayoutChildTransformPropertyInfo = Gsk.Transform.Transform
    type AttrGetType FixedLayoutChildTransformPropertyInfo = (Maybe Gsk.Transform.Transform)
    type AttrLabel FixedLayoutChildTransformPropertyInfo = "transform"
    type AttrOrigin FixedLayoutChildTransformPropertyInfo = FixedLayoutChild
    attrGet = getFixedLayoutChildTransform
    attrSet = setFixedLayoutChildTransform
    attrPut = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructFixedLayoutChildTransform
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.FixedLayoutChild.transform"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-FixedLayoutChild.html#g:attr:transform"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList FixedLayoutChild
type instance O.AttributeList FixedLayoutChild = FixedLayoutChildAttributeList
type FixedLayoutChildAttributeList = ('[ '("childWidget", Gtk.LayoutChild.LayoutChildChildWidgetPropertyInfo), '("layoutManager", Gtk.LayoutChild.LayoutChildLayoutManagerPropertyInfo), '("transform", FixedLayoutChildTransformPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
fixedLayoutChildTransform :: AttrLabelProxy "transform"
fixedLayoutChildTransform = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList FixedLayoutChild = FixedLayoutChildSignalList
type FixedLayoutChildSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method FixedLayoutChild::get_transform
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "child"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "FixedLayoutChild" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkFixedLayoutChild`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gsk" , name = "Transform" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_fixed_layout_child_get_transform" gtk_fixed_layout_child_get_transform :: 
    Ptr FixedLayoutChild ->                 -- child : TInterface (Name {namespace = "Gtk", name = "FixedLayoutChild"})
    IO (Ptr Gsk.Transform.Transform)

-- | Retrieves the transformation of the child.
fixedLayoutChildGetTransform ::
    (B.CallStack.HasCallStack, MonadIO m, IsFixedLayoutChild a) =>
    a
    -- ^ /@child@/: a @GtkFixedLayoutChild@
    -> m (Maybe Gsk.Transform.Transform)
    -- ^ __Returns:__ a @GskTransform@
fixedLayoutChildGetTransform child = liftIO $ do
    child' <- unsafeManagedPtrCastPtr child
    result <- gtk_fixed_layout_child_get_transform child'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newBoxed Gsk.Transform.Transform) result'
        return result''
    touchManagedPtr child
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data FixedLayoutChildGetTransformMethodInfo
instance (signature ~ (m (Maybe Gsk.Transform.Transform)), MonadIO m, IsFixedLayoutChild a) => O.OverloadedMethod FixedLayoutChildGetTransformMethodInfo a signature where
    overloadedMethod = fixedLayoutChildGetTransform

instance O.OverloadedMethodInfo FixedLayoutChildGetTransformMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.FixedLayoutChild.fixedLayoutChildGetTransform",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-FixedLayoutChild.html#v:fixedLayoutChildGetTransform"
        })


#endif

-- method FixedLayoutChild::set_transform
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "child"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "FixedLayoutChild" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkFixedLayoutChild`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "transform"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "Transform" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GskTransform`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_fixed_layout_child_set_transform" gtk_fixed_layout_child_set_transform :: 
    Ptr FixedLayoutChild ->                 -- child : TInterface (Name {namespace = "Gtk", name = "FixedLayoutChild"})
    Ptr Gsk.Transform.Transform ->          -- transform : TInterface (Name {namespace = "Gsk", name = "Transform"})
    IO ()

-- | Sets the transformation of the child of a @GtkFixedLayout@.
fixedLayoutChildSetTransform ::
    (B.CallStack.HasCallStack, MonadIO m, IsFixedLayoutChild a) =>
    a
    -- ^ /@child@/: a @GtkFixedLayoutChild@
    -> Gsk.Transform.Transform
    -- ^ /@transform@/: a @GskTransform@
    -> m ()
fixedLayoutChildSetTransform child transform = liftIO $ do
    child' <- unsafeManagedPtrCastPtr child
    transform' <- unsafeManagedPtrGetPtr transform
    gtk_fixed_layout_child_set_transform child' transform'
    touchManagedPtr child
    touchManagedPtr transform
    return ()

#if defined(ENABLE_OVERLOADING)
data FixedLayoutChildSetTransformMethodInfo
instance (signature ~ (Gsk.Transform.Transform -> m ()), MonadIO m, IsFixedLayoutChild a) => O.OverloadedMethod FixedLayoutChildSetTransformMethodInfo a signature where
    overloadedMethod = fixedLayoutChildSetTransform

instance O.OverloadedMethodInfo FixedLayoutChildSetTransformMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.FixedLayoutChild.fixedLayoutChildSetTransform",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-FixedLayoutChild.html#v:fixedLayoutChildSetTransform"
        })


#endif


