{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Recognizes click gestures.
-- 
-- It is able to recognize multiple clicks on a nearby zone, which
-- can be listened for through the [GestureClick::pressed]("GI.Gtk.Objects.GestureClick#g:signal:pressed")
-- signal. Whenever time or distance between clicks exceed the GTK
-- defaults, [GestureClick::stopped]("GI.Gtk.Objects.GestureClick#g:signal:stopped") is emitted, and the
-- click counter is reset.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.GestureClick
    ( 

-- * Exported types
    GestureClick(..)                        ,
    IsGestureClick                          ,
    toGestureClick                          ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [group]("GI.Gtk.Objects.Gesture#g:method:group"), [handlesSequence]("GI.Gtk.Objects.Gesture#g:method:handlesSequence"), [isActive]("GI.Gtk.Objects.Gesture#g:method:isActive"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isGroupedWith]("GI.Gtk.Objects.Gesture#g:method:isGroupedWith"), [isRecognized]("GI.Gtk.Objects.Gesture#g:method:isRecognized"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [reset]("GI.Gtk.Objects.EventController#g:method:reset"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [ungroup]("GI.Gtk.Objects.Gesture#g:method:ungroup"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getBoundingBox]("GI.Gtk.Objects.Gesture#g:method:getBoundingBox"), [getBoundingBoxCenter]("GI.Gtk.Objects.Gesture#g:method:getBoundingBoxCenter"), [getButton]("GI.Gtk.Objects.GestureSingle#g:method:getButton"), [getCurrentButton]("GI.Gtk.Objects.GestureSingle#g:method:getCurrentButton"), [getCurrentEvent]("GI.Gtk.Objects.EventController#g:method:getCurrentEvent"), [getCurrentEventDevice]("GI.Gtk.Objects.EventController#g:method:getCurrentEventDevice"), [getCurrentEventState]("GI.Gtk.Objects.EventController#g:method:getCurrentEventState"), [getCurrentEventTime]("GI.Gtk.Objects.EventController#g:method:getCurrentEventTime"), [getCurrentSequence]("GI.Gtk.Objects.GestureSingle#g:method:getCurrentSequence"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDevice]("GI.Gtk.Objects.Gesture#g:method:getDevice"), [getExclusive]("GI.Gtk.Objects.GestureSingle#g:method:getExclusive"), [getGroup]("GI.Gtk.Objects.Gesture#g:method:getGroup"), [getLastEvent]("GI.Gtk.Objects.Gesture#g:method:getLastEvent"), [getLastUpdatedSequence]("GI.Gtk.Objects.Gesture#g:method:getLastUpdatedSequence"), [getName]("GI.Gtk.Objects.EventController#g:method:getName"), [getPoint]("GI.Gtk.Objects.Gesture#g:method:getPoint"), [getPropagationLimit]("GI.Gtk.Objects.EventController#g:method:getPropagationLimit"), [getPropagationPhase]("GI.Gtk.Objects.EventController#g:method:getPropagationPhase"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getSequenceState]("GI.Gtk.Objects.Gesture#g:method:getSequenceState"), [getSequences]("GI.Gtk.Objects.Gesture#g:method:getSequences"), [getTouchOnly]("GI.Gtk.Objects.GestureSingle#g:method:getTouchOnly"), [getWidget]("GI.Gtk.Objects.EventController#g:method:getWidget").
-- 
-- ==== Setters
-- [setButton]("GI.Gtk.Objects.GestureSingle#g:method:setButton"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setExclusive]("GI.Gtk.Objects.GestureSingle#g:method:setExclusive"), [setName]("GI.Gtk.Objects.EventController#g:method:setName"), [setPropagationLimit]("GI.Gtk.Objects.EventController#g:method:setPropagationLimit"), [setPropagationPhase]("GI.Gtk.Objects.EventController#g:method:setPropagationPhase"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setSequenceState]("GI.Gtk.Objects.Gesture#g:method:setSequenceState"), [setState]("GI.Gtk.Objects.Gesture#g:method:setState"), [setStaticName]("GI.Gtk.Objects.EventController#g:method:setStaticName"), [setTouchOnly]("GI.Gtk.Objects.GestureSingle#g:method:setTouchOnly").

#if defined(ENABLE_OVERLOADING)
    ResolveGestureClickMethod               ,
#endif

-- ** new #method:new#

    gestureClickNew                         ,




 -- * Signals


-- ** pressed #signal:pressed#

    GestureClickPressedCallback             ,
#if defined(ENABLE_OVERLOADING)
    GestureClickPressedSignalInfo           ,
#endif
    afterGestureClickPressed                ,
    onGestureClickPressed                   ,


-- ** released #signal:released#

    GestureClickReleasedCallback            ,
#if defined(ENABLE_OVERLOADING)
    GestureClickReleasedSignalInfo          ,
#endif
    afterGestureClickReleased               ,
    onGestureClickReleased                  ,


-- ** stopped #signal:stopped#

    GestureClickStoppedCallback             ,
#if defined(ENABLE_OVERLOADING)
    GestureClickStoppedSignalInfo           ,
#endif
    afterGestureClickStopped                ,
    onGestureClickStopped                   ,


-- ** unpairedRelease #signal:unpairedRelease#

    GestureClickUnpairedReleaseCallback     ,
#if defined(ENABLE_OVERLOADING)
    GestureClickUnpairedReleaseSignalInfo   ,
#endif
    afterGestureClickUnpairedRelease        ,
    onGestureClickUnpairedRelease           ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.EventSequence as Gdk.EventSequence
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.ComponentTransfer as Gsk.ComponentTransfer
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.Gesture as Gtk.Gesture
import {-# SOURCE #-} qualified GI.Gtk.Objects.GestureSingle as Gtk.GestureSingle
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Structs.EventSequence as Gdk.EventSequence
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.Gesture as Gtk.Gesture
import {-# SOURCE #-} qualified GI.Gtk.Objects.GestureSingle as Gtk.GestureSingle

#endif

-- | Memory-managed wrapper type.
newtype GestureClick = GestureClick (SP.ManagedPtr GestureClick)
    deriving (Eq)

instance SP.ManagedPtrNewtype GestureClick where
    toManagedPtr (GestureClick p) = p

foreign import ccall "gtk_gesture_click_get_type"
    c_gtk_gesture_click_get_type :: IO B.Types.GType

instance B.Types.TypedObject GestureClick where
    glibType = c_gtk_gesture_click_get_type

instance B.Types.GObject GestureClick

-- | Type class for types which can be safely cast to t'GestureClick', for instance with `toGestureClick`.
class (SP.GObject o, O.IsDescendantOf GestureClick o) => IsGestureClick o
instance (SP.GObject o, O.IsDescendantOf GestureClick o) => IsGestureClick o

instance O.HasParentTypes GestureClick
type instance O.ParentTypes GestureClick = '[Gtk.GestureSingle.GestureSingle, Gtk.Gesture.Gesture, Gtk.EventController.EventController, GObject.Object.Object]

-- | Cast to t'GestureClick', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toGestureClick :: (MIO.MonadIO m, IsGestureClick o) => o -> m GestureClick
toGestureClick = MIO.liftIO . B.ManagedPtr.unsafeCastTo GestureClick

-- | Convert t'GestureClick' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe GestureClick) where
    gvalueGType_ = c_gtk_gesture_click_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr GestureClick)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr GestureClick)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject GestureClick ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveGestureClickMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveGestureClickMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveGestureClickMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveGestureClickMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveGestureClickMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveGestureClickMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveGestureClickMethod "group" o = Gtk.Gesture.GestureGroupMethodInfo
    ResolveGestureClickMethod "handlesSequence" o = Gtk.Gesture.GestureHandlesSequenceMethodInfo
    ResolveGestureClickMethod "isActive" o = Gtk.Gesture.GestureIsActiveMethodInfo
    ResolveGestureClickMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveGestureClickMethod "isGroupedWith" o = Gtk.Gesture.GestureIsGroupedWithMethodInfo
    ResolveGestureClickMethod "isRecognized" o = Gtk.Gesture.GestureIsRecognizedMethodInfo
    ResolveGestureClickMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveGestureClickMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveGestureClickMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveGestureClickMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveGestureClickMethod "reset" o = Gtk.EventController.EventControllerResetMethodInfo
    ResolveGestureClickMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveGestureClickMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveGestureClickMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveGestureClickMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveGestureClickMethod "ungroup" o = Gtk.Gesture.GestureUngroupMethodInfo
    ResolveGestureClickMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveGestureClickMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveGestureClickMethod "getBoundingBox" o = Gtk.Gesture.GestureGetBoundingBoxMethodInfo
    ResolveGestureClickMethod "getBoundingBoxCenter" o = Gtk.Gesture.GestureGetBoundingBoxCenterMethodInfo
    ResolveGestureClickMethod "getButton" o = Gtk.GestureSingle.GestureSingleGetButtonMethodInfo
    ResolveGestureClickMethod "getCurrentButton" o = Gtk.GestureSingle.GestureSingleGetCurrentButtonMethodInfo
    ResolveGestureClickMethod "getCurrentEvent" o = Gtk.EventController.EventControllerGetCurrentEventMethodInfo
    ResolveGestureClickMethod "getCurrentEventDevice" o = Gtk.EventController.EventControllerGetCurrentEventDeviceMethodInfo
    ResolveGestureClickMethod "getCurrentEventState" o = Gtk.EventController.EventControllerGetCurrentEventStateMethodInfo
    ResolveGestureClickMethod "getCurrentEventTime" o = Gtk.EventController.EventControllerGetCurrentEventTimeMethodInfo
    ResolveGestureClickMethod "getCurrentSequence" o = Gtk.GestureSingle.GestureSingleGetCurrentSequenceMethodInfo
    ResolveGestureClickMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveGestureClickMethod "getDevice" o = Gtk.Gesture.GestureGetDeviceMethodInfo
    ResolveGestureClickMethod "getExclusive" o = Gtk.GestureSingle.GestureSingleGetExclusiveMethodInfo
    ResolveGestureClickMethod "getGroup" o = Gtk.Gesture.GestureGetGroupMethodInfo
    ResolveGestureClickMethod "getLastEvent" o = Gtk.Gesture.GestureGetLastEventMethodInfo
    ResolveGestureClickMethod "getLastUpdatedSequence" o = Gtk.Gesture.GestureGetLastUpdatedSequenceMethodInfo
    ResolveGestureClickMethod "getName" o = Gtk.EventController.EventControllerGetNameMethodInfo
    ResolveGestureClickMethod "getPoint" o = Gtk.Gesture.GestureGetPointMethodInfo
    ResolveGestureClickMethod "getPropagationLimit" o = Gtk.EventController.EventControllerGetPropagationLimitMethodInfo
    ResolveGestureClickMethod "getPropagationPhase" o = Gtk.EventController.EventControllerGetPropagationPhaseMethodInfo
    ResolveGestureClickMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveGestureClickMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveGestureClickMethod "getSequenceState" o = Gtk.Gesture.GestureGetSequenceStateMethodInfo
    ResolveGestureClickMethod "getSequences" o = Gtk.Gesture.GestureGetSequencesMethodInfo
    ResolveGestureClickMethod "getTouchOnly" o = Gtk.GestureSingle.GestureSingleGetTouchOnlyMethodInfo
    ResolveGestureClickMethod "getWidget" o = Gtk.EventController.EventControllerGetWidgetMethodInfo
    ResolveGestureClickMethod "setButton" o = Gtk.GestureSingle.GestureSingleSetButtonMethodInfo
    ResolveGestureClickMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveGestureClickMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveGestureClickMethod "setExclusive" o = Gtk.GestureSingle.GestureSingleSetExclusiveMethodInfo
    ResolveGestureClickMethod "setName" o = Gtk.EventController.EventControllerSetNameMethodInfo
    ResolveGestureClickMethod "setPropagationLimit" o = Gtk.EventController.EventControllerSetPropagationLimitMethodInfo
    ResolveGestureClickMethod "setPropagationPhase" o = Gtk.EventController.EventControllerSetPropagationPhaseMethodInfo
    ResolveGestureClickMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveGestureClickMethod "setSequenceState" o = Gtk.Gesture.GestureSetSequenceStateMethodInfo
    ResolveGestureClickMethod "setState" o = Gtk.Gesture.GestureSetStateMethodInfo
    ResolveGestureClickMethod "setStaticName" o = Gtk.EventController.EventControllerSetStaticNameMethodInfo
    ResolveGestureClickMethod "setTouchOnly" o = Gtk.GestureSingle.GestureSingleSetTouchOnlyMethodInfo
    ResolveGestureClickMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveGestureClickMethod t GestureClick, O.OverloadedMethod info GestureClick p) => OL.IsLabel t (GestureClick -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveGestureClickMethod t GestureClick, O.OverloadedMethod info GestureClick p, R.HasField t GestureClick p) => R.HasField t GestureClick p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveGestureClickMethod t GestureClick, O.OverloadedMethodInfo info GestureClick) => OL.IsLabel t (O.MethodProxy info GestureClick) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal GestureClick::pressed
-- | Emitted whenever a button or touch press happens.
type GestureClickPressedCallback =
    Int32
    -- ^ /@nPress@/: how many touch\/button presses happened with this one
    -> Double
    -- ^ /@x@/: The X coordinate, in widget allocation coordinates
    -> Double
    -- ^ /@y@/: The Y coordinate, in widget allocation coordinates
    -> IO ()

type C_GestureClickPressedCallback =
    Ptr GestureClick ->                     -- object
    Int32 ->
    CDouble ->
    CDouble ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_GestureClickPressedCallback`.
foreign import ccall "wrapper"
    mk_GestureClickPressedCallback :: C_GestureClickPressedCallback -> IO (FunPtr C_GestureClickPressedCallback)

wrap_GestureClickPressedCallback :: 
    GObject a => (a -> GestureClickPressedCallback) ->
    C_GestureClickPressedCallback
wrap_GestureClickPressedCallback gi'cb gi'selfPtr nPress x y _ = do
    let x' = realToFrac x
    let y' = realToFrac y
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  nPress x' y'


-- | Connect a signal handler for the [pressed](#signal:pressed) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' gestureClick #pressed callback
-- @
-- 
-- 
onGestureClickPressed :: (IsGestureClick a, MonadIO m) => a -> ((?self :: a) => GestureClickPressedCallback) -> m SignalHandlerId
onGestureClickPressed obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_GestureClickPressedCallback wrapped
    wrapped'' <- mk_GestureClickPressedCallback wrapped'
    connectSignalFunPtr obj "pressed" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [pressed](#signal:pressed) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' gestureClick #pressed callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterGestureClickPressed :: (IsGestureClick a, MonadIO m) => a -> ((?self :: a) => GestureClickPressedCallback) -> m SignalHandlerId
afterGestureClickPressed obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_GestureClickPressedCallback wrapped
    wrapped'' <- mk_GestureClickPressedCallback wrapped'
    connectSignalFunPtr obj "pressed" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data GestureClickPressedSignalInfo
instance SignalInfo GestureClickPressedSignalInfo where
    type HaskellCallbackType GestureClickPressedSignalInfo = GestureClickPressedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_GestureClickPressedCallback cb
        cb'' <- mk_GestureClickPressedCallback cb'
        connectSignalFunPtr obj "pressed" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.GestureClick::pressed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-GestureClick.html#g:signal:pressed"})

#endif

-- signal GestureClick::released
-- | Emitted when a button or touch is released.
-- 
-- /@nPress@/ will report the number of press that is paired to
-- this event, note that [GestureClick::stopped]("GI.Gtk.Objects.GestureClick#g:signal:stopped") may
-- have been emitted between the press and its release, /@nPress@/
-- will only start over at the next press.
type GestureClickReleasedCallback =
    Int32
    -- ^ /@nPress@/: number of press that is paired with this release
    -> Double
    -- ^ /@x@/: The X coordinate, in widget allocation coordinates
    -> Double
    -- ^ /@y@/: The Y coordinate, in widget allocation coordinates
    -> IO ()

type C_GestureClickReleasedCallback =
    Ptr GestureClick ->                     -- object
    Int32 ->
    CDouble ->
    CDouble ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_GestureClickReleasedCallback`.
foreign import ccall "wrapper"
    mk_GestureClickReleasedCallback :: C_GestureClickReleasedCallback -> IO (FunPtr C_GestureClickReleasedCallback)

wrap_GestureClickReleasedCallback :: 
    GObject a => (a -> GestureClickReleasedCallback) ->
    C_GestureClickReleasedCallback
wrap_GestureClickReleasedCallback gi'cb gi'selfPtr nPress x y _ = do
    let x' = realToFrac x
    let y' = realToFrac y
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  nPress x' y'


-- | Connect a signal handler for the [released](#signal:released) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' gestureClick #released callback
-- @
-- 
-- 
onGestureClickReleased :: (IsGestureClick a, MonadIO m) => a -> ((?self :: a) => GestureClickReleasedCallback) -> m SignalHandlerId
onGestureClickReleased obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_GestureClickReleasedCallback wrapped
    wrapped'' <- mk_GestureClickReleasedCallback wrapped'
    connectSignalFunPtr obj "released" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [released](#signal:released) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' gestureClick #released callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterGestureClickReleased :: (IsGestureClick a, MonadIO m) => a -> ((?self :: a) => GestureClickReleasedCallback) -> m SignalHandlerId
afterGestureClickReleased obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_GestureClickReleasedCallback wrapped
    wrapped'' <- mk_GestureClickReleasedCallback wrapped'
    connectSignalFunPtr obj "released" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data GestureClickReleasedSignalInfo
instance SignalInfo GestureClickReleasedSignalInfo where
    type HaskellCallbackType GestureClickReleasedSignalInfo = GestureClickReleasedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_GestureClickReleasedCallback cb
        cb'' <- mk_GestureClickReleasedCallback cb'
        connectSignalFunPtr obj "released" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.GestureClick::released"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-GestureClick.html#g:signal:released"})

#endif

-- signal GestureClick::stopped
-- | Emitted whenever any time\/distance threshold has been exceeded.
type GestureClickStoppedCallback =
    IO ()

type C_GestureClickStoppedCallback =
    Ptr GestureClick ->                     -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_GestureClickStoppedCallback`.
foreign import ccall "wrapper"
    mk_GestureClickStoppedCallback :: C_GestureClickStoppedCallback -> IO (FunPtr C_GestureClickStoppedCallback)

wrap_GestureClickStoppedCallback :: 
    GObject a => (a -> GestureClickStoppedCallback) ->
    C_GestureClickStoppedCallback
wrap_GestureClickStoppedCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [stopped](#signal:stopped) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' gestureClick #stopped callback
-- @
-- 
-- 
onGestureClickStopped :: (IsGestureClick a, MonadIO m) => a -> ((?self :: a) => GestureClickStoppedCallback) -> m SignalHandlerId
onGestureClickStopped obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_GestureClickStoppedCallback wrapped
    wrapped'' <- mk_GestureClickStoppedCallback wrapped'
    connectSignalFunPtr obj "stopped" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [stopped](#signal:stopped) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' gestureClick #stopped callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterGestureClickStopped :: (IsGestureClick a, MonadIO m) => a -> ((?self :: a) => GestureClickStoppedCallback) -> m SignalHandlerId
afterGestureClickStopped obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_GestureClickStoppedCallback wrapped
    wrapped'' <- mk_GestureClickStoppedCallback wrapped'
    connectSignalFunPtr obj "stopped" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data GestureClickStoppedSignalInfo
instance SignalInfo GestureClickStoppedSignalInfo where
    type HaskellCallbackType GestureClickStoppedSignalInfo = GestureClickStoppedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_GestureClickStoppedCallback cb
        cb'' <- mk_GestureClickStoppedCallback cb'
        connectSignalFunPtr obj "stopped" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.GestureClick::stopped"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-GestureClick.html#g:signal:stopped"})

#endif

-- signal GestureClick::unpaired-release
-- | Emitted whenever the gesture receives a release
-- event that had no previous corresponding press.
-- 
-- Due to implicit grabs, this can only happen on situations
-- where input is grabbed elsewhere mid-press or the pressed
-- widget voluntarily relinquishes its implicit grab.
type GestureClickUnpairedReleaseCallback =
    Double
    -- ^ /@x@/: X coordinate of the event
    -> Double
    -- ^ /@y@/: Y coordinate of the event
    -> Word32
    -- ^ /@button@/: Button being released
    -> Maybe Gdk.EventSequence.EventSequence
    -- ^ /@sequence@/: Sequence being released
    -> IO ()

type C_GestureClickUnpairedReleaseCallback =
    Ptr GestureClick ->                     -- object
    CDouble ->
    CDouble ->
    Word32 ->
    Ptr Gdk.EventSequence.EventSequence ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_GestureClickUnpairedReleaseCallback`.
foreign import ccall "wrapper"
    mk_GestureClickUnpairedReleaseCallback :: C_GestureClickUnpairedReleaseCallback -> IO (FunPtr C_GestureClickUnpairedReleaseCallback)

wrap_GestureClickUnpairedReleaseCallback :: 
    GObject a => (a -> GestureClickUnpairedReleaseCallback) ->
    C_GestureClickUnpairedReleaseCallback
wrap_GestureClickUnpairedReleaseCallback gi'cb gi'selfPtr x y button sequence _ = do
    let x' = realToFrac x
    let y' = realToFrac y
    maybeSequence <-
        if sequence == FP.nullPtr
        then return Nothing
        else do
            B.ManagedPtr.withTransient  sequence $ \sequence' -> do
                return $ Just sequence'
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  x' y' button maybeSequence


-- | Connect a signal handler for the [unpairedRelease](#signal:unpairedRelease) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' gestureClick #unpairedRelease callback
-- @
-- 
-- 
onGestureClickUnpairedRelease :: (IsGestureClick a, MonadIO m) => a -> ((?self :: a) => GestureClickUnpairedReleaseCallback) -> m SignalHandlerId
onGestureClickUnpairedRelease obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_GestureClickUnpairedReleaseCallback wrapped
    wrapped'' <- mk_GestureClickUnpairedReleaseCallback wrapped'
    connectSignalFunPtr obj "unpaired-release" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [unpairedRelease](#signal:unpairedRelease) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' gestureClick #unpairedRelease callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterGestureClickUnpairedRelease :: (IsGestureClick a, MonadIO m) => a -> ((?self :: a) => GestureClickUnpairedReleaseCallback) -> m SignalHandlerId
afterGestureClickUnpairedRelease obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_GestureClickUnpairedReleaseCallback wrapped
    wrapped'' <- mk_GestureClickUnpairedReleaseCallback wrapped'
    connectSignalFunPtr obj "unpaired-release" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data GestureClickUnpairedReleaseSignalInfo
instance SignalInfo GestureClickUnpairedReleaseSignalInfo where
    type HaskellCallbackType GestureClickUnpairedReleaseSignalInfo = GestureClickUnpairedReleaseCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_GestureClickUnpairedReleaseCallback cb
        cb'' <- mk_GestureClickUnpairedReleaseCallback cb'
        connectSignalFunPtr obj "unpaired-release" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.GestureClick::unpaired-release"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-GestureClick.html#g:signal:unpairedRelease"})

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList GestureClick
type instance O.AttributeList GestureClick = GestureClickAttributeList
type GestureClickAttributeList = ('[ '("button", Gtk.GestureSingle.GestureSingleButtonPropertyInfo), '("exclusive", Gtk.GestureSingle.GestureSingleExclusivePropertyInfo), '("nPoints", Gtk.Gesture.GestureNPointsPropertyInfo), '("name", Gtk.EventController.EventControllerNamePropertyInfo), '("propagationLimit", Gtk.EventController.EventControllerPropagationLimitPropertyInfo), '("propagationPhase", Gtk.EventController.EventControllerPropagationPhasePropertyInfo), '("touchOnly", Gtk.GestureSingle.GestureSingleTouchOnlyPropertyInfo), '("widget", Gtk.EventController.EventControllerWidgetPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList GestureClick = GestureClickSignalList
type GestureClickSignalList = ('[ '("begin", Gtk.Gesture.GestureBeginSignalInfo), '("cancel", Gtk.Gesture.GestureCancelSignalInfo), '("end", Gtk.Gesture.GestureEndSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("pressed", GestureClickPressedSignalInfo), '("released", GestureClickReleasedSignalInfo), '("sequenceStateChanged", Gtk.Gesture.GestureSequenceStateChangedSignalInfo), '("stopped", GestureClickStoppedSignalInfo), '("unpairedRelease", GestureClickUnpairedReleaseSignalInfo), '("update", Gtk.Gesture.GestureUpdateSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method GestureClick::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "GestureClick" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_gesture_click_new" gtk_gesture_click_new :: 
    IO (Ptr GestureClick)

-- | Returns a newly created @GtkGesture@ that recognizes
-- single and multiple presses.
gestureClickNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m GestureClick
    -- ^ __Returns:__ a newly created @GtkGestureClick@
gestureClickNew  = liftIO $ do
    result <- gtk_gesture_click_new
    checkUnexpectedReturnNULL "gestureClickNew" result
    result' <- (wrapObject GestureClick) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif


