{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- The t'GI.HarfBuzz.Structs.GlyphPositionT.GlyphPositionT' is the structure that holds the positions of the
-- glyph in both horizontal and vertical directions. All positions in
-- t'GI.HarfBuzz.Structs.GlyphPositionT.GlyphPositionT' are relative to the current point.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.HarfBuzz.Structs.GlyphPositionT
    ( 

-- * Exported types
    GlyphPositionT(..)                      ,
    newZeroGlyphPositionT                   ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveGlyphPositionTMethod             ,
#endif



 -- * Properties


-- ** xAdvance #attr:xAdvance#
-- | how much the line advances after drawing this glyph when setting
--             text in horizontal direction.

    getGlyphPositionTXAdvance               ,
#if defined(ENABLE_OVERLOADING)
    glyphPositionT_xAdvance                 ,
#endif
    setGlyphPositionTXAdvance               ,


-- ** xOffset #attr:xOffset#
-- | how much the glyph moves on the X-axis before drawing it, this
--            should not affect how much the line advances.

    getGlyphPositionTXOffset                ,
#if defined(ENABLE_OVERLOADING)
    glyphPositionT_xOffset                  ,
#endif
    setGlyphPositionTXOffset                ,


-- ** yAdvance #attr:yAdvance#
-- | how much the line advances after drawing this glyph when setting
--             text in vertical direction.

    getGlyphPositionTYAdvance               ,
#if defined(ENABLE_OVERLOADING)
    glyphPositionT_yAdvance                 ,
#endif
    setGlyphPositionTYAdvance               ,


-- ** yOffset #attr:yOffset#
-- | how much the glyph moves on the Y-axis before drawing it, this
--            should not affect how much the line advances.

    getGlyphPositionTYOffset                ,
#if defined(ENABLE_OVERLOADING)
    glyphPositionT_yOffset                  ,
#endif
    setGlyphPositionTYOffset                ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- | Memory-managed wrapper type.
newtype GlyphPositionT = GlyphPositionT (SP.ManagedPtr GlyphPositionT)
    deriving (Eq)

instance SP.ManagedPtrNewtype GlyphPositionT where
    toManagedPtr (GlyphPositionT p) = p

foreign import ccall "hb_gobject_glyph_position_get_type" c_hb_gobject_glyph_position_get_type :: 
    IO GType

type instance O.ParentTypes GlyphPositionT = '[]
instance O.HasParentTypes GlyphPositionT

instance B.Types.TypedObject GlyphPositionT where
    glibType = c_hb_gobject_glyph_position_get_type

instance B.Types.GBoxed GlyphPositionT

-- | Convert t'GlyphPositionT' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe GlyphPositionT) where
    gvalueGType_ = c_hb_gobject_glyph_position_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_boxed gv (FP.nullPtr :: FP.Ptr GlyphPositionT)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_boxed gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_boxed gv :: IO (Ptr GlyphPositionT)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newBoxed GlyphPositionT ptr
        else return P.Nothing
        
    

-- | Construct a t'GlyphPositionT' struct initialized to zero.
newZeroGlyphPositionT :: MonadIO m => m GlyphPositionT
newZeroGlyphPositionT = liftIO $ callocBoxedBytes 20 >>= wrapBoxed GlyphPositionT

instance tag ~ 'AttrSet => Constructible GlyphPositionT tag where
    new _ attrs = do
        o <- newZeroGlyphPositionT
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@x_advance@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' glyphPositionT #xAdvance
-- @
getGlyphPositionTXAdvance :: MonadIO m => GlyphPositionT -> m Int32
getGlyphPositionTXAdvance s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO Int32
    return val

-- | Set the value of the “@x_advance@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' glyphPositionT [ #xAdvance 'Data.GI.Base.Attributes.:=' value ]
-- @
setGlyphPositionTXAdvance :: MonadIO m => GlyphPositionT -> Int32 -> m ()
setGlyphPositionTXAdvance s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data GlyphPositionTXAdvanceFieldInfo
instance AttrInfo GlyphPositionTXAdvanceFieldInfo where
    type AttrBaseTypeConstraint GlyphPositionTXAdvanceFieldInfo = (~) GlyphPositionT
    type AttrAllowedOps GlyphPositionTXAdvanceFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint GlyphPositionTXAdvanceFieldInfo = (~) Int32
    type AttrTransferTypeConstraint GlyphPositionTXAdvanceFieldInfo = (~)Int32
    type AttrTransferType GlyphPositionTXAdvanceFieldInfo = Int32
    type AttrGetType GlyphPositionTXAdvanceFieldInfo = Int32
    type AttrLabel GlyphPositionTXAdvanceFieldInfo = "x_advance"
    type AttrOrigin GlyphPositionTXAdvanceFieldInfo = GlyphPositionT
    attrGet = getGlyphPositionTXAdvance
    attrSet = setGlyphPositionTXAdvance
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.HarfBuzz.Structs.GlyphPositionT.xAdvance"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-harfbuzz-0.0.10/docs/GI-HarfBuzz-Structs-GlyphPositionT.html#g:attr:xAdvance"
        })

glyphPositionT_xAdvance :: AttrLabelProxy "xAdvance"
glyphPositionT_xAdvance = AttrLabelProxy

#endif


-- | Get the value of the “@y_advance@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' glyphPositionT #yAdvance
-- @
getGlyphPositionTYAdvance :: MonadIO m => GlyphPositionT -> m Int32
getGlyphPositionTYAdvance s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 4) :: IO Int32
    return val

-- | Set the value of the “@y_advance@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' glyphPositionT [ #yAdvance 'Data.GI.Base.Attributes.:=' value ]
-- @
setGlyphPositionTYAdvance :: MonadIO m => GlyphPositionT -> Int32 -> m ()
setGlyphPositionTYAdvance s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 4) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data GlyphPositionTYAdvanceFieldInfo
instance AttrInfo GlyphPositionTYAdvanceFieldInfo where
    type AttrBaseTypeConstraint GlyphPositionTYAdvanceFieldInfo = (~) GlyphPositionT
    type AttrAllowedOps GlyphPositionTYAdvanceFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint GlyphPositionTYAdvanceFieldInfo = (~) Int32
    type AttrTransferTypeConstraint GlyphPositionTYAdvanceFieldInfo = (~)Int32
    type AttrTransferType GlyphPositionTYAdvanceFieldInfo = Int32
    type AttrGetType GlyphPositionTYAdvanceFieldInfo = Int32
    type AttrLabel GlyphPositionTYAdvanceFieldInfo = "y_advance"
    type AttrOrigin GlyphPositionTYAdvanceFieldInfo = GlyphPositionT
    attrGet = getGlyphPositionTYAdvance
    attrSet = setGlyphPositionTYAdvance
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.HarfBuzz.Structs.GlyphPositionT.yAdvance"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-harfbuzz-0.0.10/docs/GI-HarfBuzz-Structs-GlyphPositionT.html#g:attr:yAdvance"
        })

glyphPositionT_yAdvance :: AttrLabelProxy "yAdvance"
glyphPositionT_yAdvance = AttrLabelProxy

#endif


-- | Get the value of the “@x_offset@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' glyphPositionT #xOffset
-- @
getGlyphPositionTXOffset :: MonadIO m => GlyphPositionT -> m Int32
getGlyphPositionTXOffset s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO Int32
    return val

-- | Set the value of the “@x_offset@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' glyphPositionT [ #xOffset 'Data.GI.Base.Attributes.:=' value ]
-- @
setGlyphPositionTXOffset :: MonadIO m => GlyphPositionT -> Int32 -> m ()
setGlyphPositionTXOffset s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data GlyphPositionTXOffsetFieldInfo
instance AttrInfo GlyphPositionTXOffsetFieldInfo where
    type AttrBaseTypeConstraint GlyphPositionTXOffsetFieldInfo = (~) GlyphPositionT
    type AttrAllowedOps GlyphPositionTXOffsetFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint GlyphPositionTXOffsetFieldInfo = (~) Int32
    type AttrTransferTypeConstraint GlyphPositionTXOffsetFieldInfo = (~)Int32
    type AttrTransferType GlyphPositionTXOffsetFieldInfo = Int32
    type AttrGetType GlyphPositionTXOffsetFieldInfo = Int32
    type AttrLabel GlyphPositionTXOffsetFieldInfo = "x_offset"
    type AttrOrigin GlyphPositionTXOffsetFieldInfo = GlyphPositionT
    attrGet = getGlyphPositionTXOffset
    attrSet = setGlyphPositionTXOffset
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.HarfBuzz.Structs.GlyphPositionT.xOffset"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-harfbuzz-0.0.10/docs/GI-HarfBuzz-Structs-GlyphPositionT.html#g:attr:xOffset"
        })

glyphPositionT_xOffset :: AttrLabelProxy "xOffset"
glyphPositionT_xOffset = AttrLabelProxy

#endif


-- | Get the value of the “@y_offset@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' glyphPositionT #yOffset
-- @
getGlyphPositionTYOffset :: MonadIO m => GlyphPositionT -> m Int32
getGlyphPositionTYOffset s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 12) :: IO Int32
    return val

-- | Set the value of the “@y_offset@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' glyphPositionT [ #yOffset 'Data.GI.Base.Attributes.:=' value ]
-- @
setGlyphPositionTYOffset :: MonadIO m => GlyphPositionT -> Int32 -> m ()
setGlyphPositionTYOffset s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 12) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data GlyphPositionTYOffsetFieldInfo
instance AttrInfo GlyphPositionTYOffsetFieldInfo where
    type AttrBaseTypeConstraint GlyphPositionTYOffsetFieldInfo = (~) GlyphPositionT
    type AttrAllowedOps GlyphPositionTYOffsetFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint GlyphPositionTYOffsetFieldInfo = (~) Int32
    type AttrTransferTypeConstraint GlyphPositionTYOffsetFieldInfo = (~)Int32
    type AttrTransferType GlyphPositionTYOffsetFieldInfo = Int32
    type AttrGetType GlyphPositionTYOffsetFieldInfo = Int32
    type AttrLabel GlyphPositionTYOffsetFieldInfo = "y_offset"
    type AttrOrigin GlyphPositionTYOffsetFieldInfo = GlyphPositionT
    attrGet = getGlyphPositionTYOffset
    attrSet = setGlyphPositionTYOffset
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.HarfBuzz.Structs.GlyphPositionT.yOffset"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-harfbuzz-0.0.10/docs/GI-HarfBuzz-Structs-GlyphPositionT.html#g:attr:yOffset"
        })

glyphPositionT_yOffset :: AttrLabelProxy "yOffset"
glyphPositionT_yOffset = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList GlyphPositionT
type instance O.AttributeList GlyphPositionT = GlyphPositionTAttributeList
type GlyphPositionTAttributeList = ('[ '("xAdvance", GlyphPositionTXAdvanceFieldInfo), '("yAdvance", GlyphPositionTYAdvanceFieldInfo), '("xOffset", GlyphPositionTXOffsetFieldInfo), '("yOffset", GlyphPositionTYOffsetFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveGlyphPositionTMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveGlyphPositionTMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveGlyphPositionTMethod t GlyphPositionT, O.OverloadedMethod info GlyphPositionT p) => OL.IsLabel t (GlyphPositionT -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveGlyphPositionTMethod t GlyphPositionT, O.OverloadedMethod info GlyphPositionT p, R.HasField t GlyphPositionT p) => R.HasField t GlyphPositionT p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveGlyphPositionTMethod t GlyphPositionT, O.OverloadedMethodInfo info GlyphPositionT) => OL.IsLabel t (O.MethodProxy info GlyphPositionT) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


