{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A @PangoContext@ stores global information used to control the
-- itemization process.
-- 
-- The information stored by @PangoContext@ includes the fontmap used
-- to look up fonts, and default values such as the default language,
-- default gravity, or default font.
-- 
-- To obtain a @PangoContext@, use 'GI.Pango.Objects.FontMap.fontMapCreateContext'.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Pango.Objects.Context
    ( 

-- * Exported types
    Context(..)                             ,
    IsContext                               ,
    toContext                               ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [changed]("GI.Pango.Objects.Context#g:method:changed"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [listFamilies]("GI.Pango.Objects.Context#g:method:listFamilies"), [loadFont]("GI.Pango.Objects.Context#g:method:loadFont"), [loadFontset]("GI.Pango.Objects.Context#g:method:loadFontset"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getBaseDir]("GI.Pango.Objects.Context#g:method:getBaseDir"), [getBaseGravity]("GI.Pango.Objects.Context#g:method:getBaseGravity"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getFontDescription]("GI.Pango.Objects.Context#g:method:getFontDescription"), [getFontMap]("GI.Pango.Objects.Context#g:method:getFontMap"), [getGravity]("GI.Pango.Objects.Context#g:method:getGravity"), [getGravityHint]("GI.Pango.Objects.Context#g:method:getGravityHint"), [getLanguage]("GI.Pango.Objects.Context#g:method:getLanguage"), [getMatrix]("GI.Pango.Objects.Context#g:method:getMatrix"), [getMetrics]("GI.Pango.Objects.Context#g:method:getMetrics"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRoundGlyphPositions]("GI.Pango.Objects.Context#g:method:getRoundGlyphPositions"), [getSerial]("GI.Pango.Objects.Context#g:method:getSerial").
-- 
-- ==== Setters
-- [setBaseDir]("GI.Pango.Objects.Context#g:method:setBaseDir"), [setBaseGravity]("GI.Pango.Objects.Context#g:method:setBaseGravity"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setFontDescription]("GI.Pango.Objects.Context#g:method:setFontDescription"), [setFontMap]("GI.Pango.Objects.Context#g:method:setFontMap"), [setGravityHint]("GI.Pango.Objects.Context#g:method:setGravityHint"), [setLanguage]("GI.Pango.Objects.Context#g:method:setLanguage"), [setMatrix]("GI.Pango.Objects.Context#g:method:setMatrix"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setRoundGlyphPositions]("GI.Pango.Objects.Context#g:method:setRoundGlyphPositions").

#if defined(ENABLE_OVERLOADING)
    ResolveContextMethod                    ,
#endif

-- ** changed #method:changed#

#if defined(ENABLE_OVERLOADING)
    ContextChangedMethodInfo                ,
#endif
    contextChanged                          ,


-- ** getBaseDir #method:getBaseDir#

#if defined(ENABLE_OVERLOADING)
    ContextGetBaseDirMethodInfo             ,
#endif
    contextGetBaseDir                       ,


-- ** getBaseGravity #method:getBaseGravity#

#if defined(ENABLE_OVERLOADING)
    ContextGetBaseGravityMethodInfo         ,
#endif
    contextGetBaseGravity                   ,


-- ** getFontDescription #method:getFontDescription#

#if defined(ENABLE_OVERLOADING)
    ContextGetFontDescriptionMethodInfo     ,
#endif
    contextGetFontDescription               ,


-- ** getFontMap #method:getFontMap#

#if defined(ENABLE_OVERLOADING)
    ContextGetFontMapMethodInfo             ,
#endif
    contextGetFontMap                       ,


-- ** getGravity #method:getGravity#

#if defined(ENABLE_OVERLOADING)
    ContextGetGravityMethodInfo             ,
#endif
    contextGetGravity                       ,


-- ** getGravityHint #method:getGravityHint#

#if defined(ENABLE_OVERLOADING)
    ContextGetGravityHintMethodInfo         ,
#endif
    contextGetGravityHint                   ,


-- ** getLanguage #method:getLanguage#

#if defined(ENABLE_OVERLOADING)
    ContextGetLanguageMethodInfo            ,
#endif
    contextGetLanguage                      ,


-- ** getMatrix #method:getMatrix#

#if defined(ENABLE_OVERLOADING)
    ContextGetMatrixMethodInfo              ,
#endif
    contextGetMatrix                        ,


-- ** getMetrics #method:getMetrics#

#if defined(ENABLE_OVERLOADING)
    ContextGetMetricsMethodInfo             ,
#endif
    contextGetMetrics                       ,


-- ** getRoundGlyphPositions #method:getRoundGlyphPositions#

#if defined(ENABLE_OVERLOADING)
    ContextGetRoundGlyphPositionsMethodInfo ,
#endif
    contextGetRoundGlyphPositions           ,


-- ** getSerial #method:getSerial#

#if defined(ENABLE_OVERLOADING)
    ContextGetSerialMethodInfo              ,
#endif
    contextGetSerial                        ,


-- ** listFamilies #method:listFamilies#

#if defined(ENABLE_OVERLOADING)
    ContextListFamiliesMethodInfo           ,
#endif
    contextListFamilies                     ,


-- ** loadFont #method:loadFont#

#if defined(ENABLE_OVERLOADING)
    ContextLoadFontMethodInfo               ,
#endif
    contextLoadFont                         ,


-- ** loadFontset #method:loadFontset#

#if defined(ENABLE_OVERLOADING)
    ContextLoadFontsetMethodInfo            ,
#endif
    contextLoadFontset                      ,


-- ** new #method:new#

    contextNew                              ,


-- ** setBaseDir #method:setBaseDir#

#if defined(ENABLE_OVERLOADING)
    ContextSetBaseDirMethodInfo             ,
#endif
    contextSetBaseDir                       ,


-- ** setBaseGravity #method:setBaseGravity#

#if defined(ENABLE_OVERLOADING)
    ContextSetBaseGravityMethodInfo         ,
#endif
    contextSetBaseGravity                   ,


-- ** setFontDescription #method:setFontDescription#

#if defined(ENABLE_OVERLOADING)
    ContextSetFontDescriptionMethodInfo     ,
#endif
    contextSetFontDescription               ,


-- ** setFontMap #method:setFontMap#

#if defined(ENABLE_OVERLOADING)
    ContextSetFontMapMethodInfo             ,
#endif
    contextSetFontMap                       ,


-- ** setGravityHint #method:setGravityHint#

#if defined(ENABLE_OVERLOADING)
    ContextSetGravityHintMethodInfo         ,
#endif
    contextSetGravityHint                   ,


-- ** setLanguage #method:setLanguage#

#if defined(ENABLE_OVERLOADING)
    ContextSetLanguageMethodInfo            ,
#endif
    contextSetLanguage                      ,


-- ** setMatrix #method:setMatrix#

#if defined(ENABLE_OVERLOADING)
    ContextSetMatrixMethodInfo              ,
#endif
    contextSetMatrix                        ,


-- ** setRoundGlyphPositions #method:setRoundGlyphPositions#

#if defined(ENABLE_OVERLOADING)
    ContextSetRoundGlyphPositionsMethodInfo ,
#endif
    contextSetRoundGlyphPositions           ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.HarfBuzz.Structs.FeatureT as HarfBuzz.FeatureT
import qualified GI.Pango.Callbacks as Pango.Callbacks
import {-# SOURCE #-} qualified GI.Pango.Enums as Pango.Enums
import {-# SOURCE #-} qualified GI.Pango.Flags as Pango.Flags
import {-# SOURCE #-} qualified GI.Pango.Objects.Coverage as Pango.Coverage
import {-# SOURCE #-} qualified GI.Pango.Objects.Font as Pango.Font
import {-# SOURCE #-} qualified GI.Pango.Objects.FontFace as Pango.FontFace
import {-# SOURCE #-} qualified GI.Pango.Objects.FontFamily as Pango.FontFamily
import {-# SOURCE #-} qualified GI.Pango.Objects.FontMap as Pango.FontMap
import {-# SOURCE #-} qualified GI.Pango.Objects.Fontset as Pango.Fontset
import {-# SOURCE #-} qualified GI.Pango.Structs.FontDescription as Pango.FontDescription
import {-# SOURCE #-} qualified GI.Pango.Structs.FontMetrics as Pango.FontMetrics
import {-# SOURCE #-} qualified GI.Pango.Structs.Language as Pango.Language
import {-# SOURCE #-} qualified GI.Pango.Structs.Matrix as Pango.Matrix
import {-# SOURCE #-} qualified GI.Pango.Structs.Rectangle as Pango.Rectangle

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Pango.Enums as Pango.Enums
import {-# SOURCE #-} qualified GI.Pango.Objects.Font as Pango.Font
import {-# SOURCE #-} qualified GI.Pango.Objects.FontFamily as Pango.FontFamily
import {-# SOURCE #-} qualified GI.Pango.Objects.FontMap as Pango.FontMap
import {-# SOURCE #-} qualified GI.Pango.Objects.Fontset as Pango.Fontset
import {-# SOURCE #-} qualified GI.Pango.Structs.FontDescription as Pango.FontDescription
import {-# SOURCE #-} qualified GI.Pango.Structs.FontMetrics as Pango.FontMetrics
import {-# SOURCE #-} qualified GI.Pango.Structs.Language as Pango.Language
import {-# SOURCE #-} qualified GI.Pango.Structs.Matrix as Pango.Matrix

#endif

-- | Memory-managed wrapper type.
newtype Context = Context (SP.ManagedPtr Context)
    deriving (Eq)

instance SP.ManagedPtrNewtype Context where
    toManagedPtr (Context p) = p

foreign import ccall "pango_context_get_type"
    c_pango_context_get_type :: IO B.Types.GType

instance B.Types.TypedObject Context where
    glibType = c_pango_context_get_type

instance B.Types.GObject Context

-- | Type class for types which can be safely cast to t'Context', for instance with `toContext`.
class (SP.GObject o, O.IsDescendantOf Context o) => IsContext o
instance (SP.GObject o, O.IsDescendantOf Context o) => IsContext o

instance O.HasParentTypes Context
type instance O.ParentTypes Context = '[GObject.Object.Object]

-- | Cast to t'Context', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toContext :: (MIO.MonadIO m, IsContext o) => o -> m Context
toContext = MIO.liftIO . B.ManagedPtr.unsafeCastTo Context

-- | Convert t'Context' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Context) where
    gvalueGType_ = c_pango_context_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr Context)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr Context)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject Context ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveContextMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveContextMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveContextMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveContextMethod "changed" o = ContextChangedMethodInfo
    ResolveContextMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveContextMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveContextMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveContextMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveContextMethod "listFamilies" o = ContextListFamiliesMethodInfo
    ResolveContextMethod "loadFont" o = ContextLoadFontMethodInfo
    ResolveContextMethod "loadFontset" o = ContextLoadFontsetMethodInfo
    ResolveContextMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveContextMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveContextMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveContextMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveContextMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveContextMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveContextMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveContextMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveContextMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveContextMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveContextMethod "getBaseDir" o = ContextGetBaseDirMethodInfo
    ResolveContextMethod "getBaseGravity" o = ContextGetBaseGravityMethodInfo
    ResolveContextMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveContextMethod "getFontDescription" o = ContextGetFontDescriptionMethodInfo
    ResolveContextMethod "getFontMap" o = ContextGetFontMapMethodInfo
    ResolveContextMethod "getGravity" o = ContextGetGravityMethodInfo
    ResolveContextMethod "getGravityHint" o = ContextGetGravityHintMethodInfo
    ResolveContextMethod "getLanguage" o = ContextGetLanguageMethodInfo
    ResolveContextMethod "getMatrix" o = ContextGetMatrixMethodInfo
    ResolveContextMethod "getMetrics" o = ContextGetMetricsMethodInfo
    ResolveContextMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveContextMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveContextMethod "getRoundGlyphPositions" o = ContextGetRoundGlyphPositionsMethodInfo
    ResolveContextMethod "getSerial" o = ContextGetSerialMethodInfo
    ResolveContextMethod "setBaseDir" o = ContextSetBaseDirMethodInfo
    ResolveContextMethod "setBaseGravity" o = ContextSetBaseGravityMethodInfo
    ResolveContextMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveContextMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveContextMethod "setFontDescription" o = ContextSetFontDescriptionMethodInfo
    ResolveContextMethod "setFontMap" o = ContextSetFontMapMethodInfo
    ResolveContextMethod "setGravityHint" o = ContextSetGravityHintMethodInfo
    ResolveContextMethod "setLanguage" o = ContextSetLanguageMethodInfo
    ResolveContextMethod "setMatrix" o = ContextSetMatrixMethodInfo
    ResolveContextMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveContextMethod "setRoundGlyphPositions" o = ContextSetRoundGlyphPositionsMethodInfo
    ResolveContextMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveContextMethod t Context, O.OverloadedMethod info Context p) => OL.IsLabel t (Context -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveContextMethod t Context, O.OverloadedMethod info Context p, R.HasField t Context p) => R.HasField t Context p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveContextMethod t Context, O.OverloadedMethodInfo info Context) => OL.IsLabel t (O.MethodProxy info Context) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Context
type instance O.AttributeList Context = ContextAttributeList
type ContextAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList Context = ContextSignalList
type ContextSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method Context::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Pango" , name = "Context" })
-- throws : False
-- Skip return : False

foreign import ccall "pango_context_new" pango_context_new :: 
    IO (Ptr Context)

-- | Creates a new @PangoContext@ initialized to default values.
-- 
-- This function is not particularly useful as it should always
-- be followed by a 'GI.Pango.Objects.Context.contextSetFontMap' call, and the
-- function 'GI.Pango.Objects.FontMap.fontMapCreateContext' does these two steps
-- together and hence users are recommended to use that.
-- 
-- If you are using Pango as part of a higher-level system,
-- that system may have it\'s own way of create a @PangoContext@.
-- For instance, the GTK toolkit has, among others,
-- @gtk_widget_get_pango_context()@. Use those instead.
contextNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Context
    -- ^ __Returns:__ the newly allocated @PangoContext@, which should
    --   be freed with 'GI.GObject.Objects.Object.objectUnref'.
contextNew  = liftIO $ do
    result <- pango_context_new
    checkUnexpectedReturnNULL "contextNew" result
    result' <- (wrapObject Context) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Context::changed
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Context" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoContext`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_context_changed" pango_context_changed :: 
    Ptr Context ->                          -- context : TInterface (Name {namespace = "Pango", name = "Context"})
    IO ()

-- | Forces a change in the context, which will cause any @PangoLayout@
-- using this context to re-layout.
-- 
-- This function is only useful when implementing a new backend
-- for Pango, something applications won\'t do. Backends should
-- call this function if they have attached extra data to the context
-- and such data is changed.
-- 
-- /Since: 1.32.4/
contextChanged ::
    (B.CallStack.HasCallStack, MonadIO m, IsContext a) =>
    a
    -- ^ /@context@/: a @PangoContext@
    -> m ()
contextChanged context = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    pango_context_changed context'
    touchManagedPtr context
    return ()

#if defined(ENABLE_OVERLOADING)
data ContextChangedMethodInfo
instance (signature ~ (m ()), MonadIO m, IsContext a) => O.OverloadedMethod ContextChangedMethodInfo a signature where
    overloadedMethod = contextChanged

instance O.OverloadedMethodInfo ContextChangedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Objects.Context.contextChanged",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Objects-Context.html#v:contextChanged"
        })


#endif

-- method Context::get_base_dir
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Context" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoContext`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Pango" , name = "Direction" })
-- throws : False
-- Skip return : False

foreign import ccall "pango_context_get_base_dir" pango_context_get_base_dir :: 
    Ptr Context ->                          -- context : TInterface (Name {namespace = "Pango", name = "Context"})
    IO CUInt

-- | Retrieves the base direction for the context.
-- 
-- See 'GI.Pango.Objects.Context.contextSetBaseDir'.
contextGetBaseDir ::
    (B.CallStack.HasCallStack, MonadIO m, IsContext a) =>
    a
    -- ^ /@context@/: a @PangoContext@
    -> m Pango.Enums.Direction
    -- ^ __Returns:__ the base direction for the context.
contextGetBaseDir context = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    result <- pango_context_get_base_dir context'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr context
    return result'

#if defined(ENABLE_OVERLOADING)
data ContextGetBaseDirMethodInfo
instance (signature ~ (m Pango.Enums.Direction), MonadIO m, IsContext a) => O.OverloadedMethod ContextGetBaseDirMethodInfo a signature where
    overloadedMethod = contextGetBaseDir

instance O.OverloadedMethodInfo ContextGetBaseDirMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Objects.Context.contextGetBaseDir",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Objects-Context.html#v:contextGetBaseDir"
        })


#endif

-- method Context::get_base_gravity
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Context" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoContext`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Pango" , name = "Gravity" })
-- throws : False
-- Skip return : False

foreign import ccall "pango_context_get_base_gravity" pango_context_get_base_gravity :: 
    Ptr Context ->                          -- context : TInterface (Name {namespace = "Pango", name = "Context"})
    IO CUInt

-- | Retrieves the base gravity for the context.
-- 
-- See 'GI.Pango.Objects.Context.contextSetBaseGravity'.
-- 
-- /Since: 1.16/
contextGetBaseGravity ::
    (B.CallStack.HasCallStack, MonadIO m, IsContext a) =>
    a
    -- ^ /@context@/: a @PangoContext@
    -> m Pango.Enums.Gravity
    -- ^ __Returns:__ the base gravity for the context.
contextGetBaseGravity context = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    result <- pango_context_get_base_gravity context'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr context
    return result'

#if defined(ENABLE_OVERLOADING)
data ContextGetBaseGravityMethodInfo
instance (signature ~ (m Pango.Enums.Gravity), MonadIO m, IsContext a) => O.OverloadedMethod ContextGetBaseGravityMethodInfo a signature where
    overloadedMethod = contextGetBaseGravity

instance O.OverloadedMethodInfo ContextGetBaseGravityMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Objects.Context.contextGetBaseGravity",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Objects-Context.html#v:contextGetBaseGravity"
        })


#endif

-- method Context::get_font_description
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Context" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoContext`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Pango" , name = "FontDescription" })
-- throws : False
-- Skip return : False

foreign import ccall "pango_context_get_font_description" pango_context_get_font_description :: 
    Ptr Context ->                          -- context : TInterface (Name {namespace = "Pango", name = "Context"})
    IO (Ptr Pango.FontDescription.FontDescription)

-- | Retrieve the default font description for the context.
contextGetFontDescription ::
    (B.CallStack.HasCallStack, MonadIO m, IsContext a) =>
    a
    -- ^ /@context@/: a @PangoContext@
    -> m (Maybe Pango.FontDescription.FontDescription)
    -- ^ __Returns:__ a pointer to the context\'s default font
    --   description. This value must not be modified or freed.
contextGetFontDescription context = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    result <- pango_context_get_font_description context'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newBoxed Pango.FontDescription.FontDescription) result'
        return result''
    touchManagedPtr context
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data ContextGetFontDescriptionMethodInfo
instance (signature ~ (m (Maybe Pango.FontDescription.FontDescription)), MonadIO m, IsContext a) => O.OverloadedMethod ContextGetFontDescriptionMethodInfo a signature where
    overloadedMethod = contextGetFontDescription

instance O.OverloadedMethodInfo ContextGetFontDescriptionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Objects.Context.contextGetFontDescription",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Objects-Context.html#v:contextGetFontDescription"
        })


#endif

-- method Context::get_font_map
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Context" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoContext`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Pango" , name = "FontMap" })
-- throws : False
-- Skip return : False

foreign import ccall "pango_context_get_font_map" pango_context_get_font_map :: 
    Ptr Context ->                          -- context : TInterface (Name {namespace = "Pango", name = "Context"})
    IO (Ptr Pango.FontMap.FontMap)

-- | Gets the @PangoFontMap@ used to look up fonts for this context.
-- 
-- /Since: 1.6/
contextGetFontMap ::
    (B.CallStack.HasCallStack, MonadIO m, IsContext a) =>
    a
    -- ^ /@context@/: a @PangoContext@
    -> m (Maybe Pango.FontMap.FontMap)
    -- ^ __Returns:__ the font map for the.
    --   @PangoContext@ This value is owned by Pango and should not be
    --   unreferenced.
contextGetFontMap context = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    result <- pango_context_get_font_map context'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Pango.FontMap.FontMap) result'
        return result''
    touchManagedPtr context
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data ContextGetFontMapMethodInfo
instance (signature ~ (m (Maybe Pango.FontMap.FontMap)), MonadIO m, IsContext a) => O.OverloadedMethod ContextGetFontMapMethodInfo a signature where
    overloadedMethod = contextGetFontMap

instance O.OverloadedMethodInfo ContextGetFontMapMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Objects.Context.contextGetFontMap",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Objects-Context.html#v:contextGetFontMap"
        })


#endif

-- method Context::get_gravity
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Context" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoContext`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Pango" , name = "Gravity" })
-- throws : False
-- Skip return : False

foreign import ccall "pango_context_get_gravity" pango_context_get_gravity :: 
    Ptr Context ->                          -- context : TInterface (Name {namespace = "Pango", name = "Context"})
    IO CUInt

-- | Retrieves the gravity for the context.
-- 
-- This is similar to 'GI.Pango.Objects.Context.contextGetBaseGravity',
-- except for when the base gravity is 'GI.Pango.Enums.GravityAuto' for
-- which t'GI.Pango.Enums.Gravity'.@/get_for_matrix/@() is used to return the
-- gravity from the current context matrix.
-- 
-- /Since: 1.16/
contextGetGravity ::
    (B.CallStack.HasCallStack, MonadIO m, IsContext a) =>
    a
    -- ^ /@context@/: a @PangoContext@
    -> m Pango.Enums.Gravity
    -- ^ __Returns:__ the resolved gravity for the context.
contextGetGravity context = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    result <- pango_context_get_gravity context'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr context
    return result'

#if defined(ENABLE_OVERLOADING)
data ContextGetGravityMethodInfo
instance (signature ~ (m Pango.Enums.Gravity), MonadIO m, IsContext a) => O.OverloadedMethod ContextGetGravityMethodInfo a signature where
    overloadedMethod = contextGetGravity

instance O.OverloadedMethodInfo ContextGetGravityMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Objects.Context.contextGetGravity",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Objects-Context.html#v:contextGetGravity"
        })


#endif

-- method Context::get_gravity_hint
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Context" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoContext`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Pango" , name = "GravityHint" })
-- throws : False
-- Skip return : False

foreign import ccall "pango_context_get_gravity_hint" pango_context_get_gravity_hint :: 
    Ptr Context ->                          -- context : TInterface (Name {namespace = "Pango", name = "Context"})
    IO CUInt

-- | Retrieves the gravity hint for the context.
-- 
-- See 'GI.Pango.Objects.Context.contextSetGravityHint' for details.
-- 
-- /Since: 1.16/
contextGetGravityHint ::
    (B.CallStack.HasCallStack, MonadIO m, IsContext a) =>
    a
    -- ^ /@context@/: a @PangoContext@
    -> m Pango.Enums.GravityHint
    -- ^ __Returns:__ the gravity hint for the context.
contextGetGravityHint context = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    result <- pango_context_get_gravity_hint context'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr context
    return result'

#if defined(ENABLE_OVERLOADING)
data ContextGetGravityHintMethodInfo
instance (signature ~ (m Pango.Enums.GravityHint), MonadIO m, IsContext a) => O.OverloadedMethod ContextGetGravityHintMethodInfo a signature where
    overloadedMethod = contextGetGravityHint

instance O.OverloadedMethodInfo ContextGetGravityHintMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Objects.Context.contextGetGravityHint",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Objects-Context.html#v:contextGetGravityHint"
        })


#endif

-- method Context::get_language
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Context" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoContext`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Pango" , name = "Language" })
-- throws : False
-- Skip return : False

foreign import ccall "pango_context_get_language" pango_context_get_language :: 
    Ptr Context ->                          -- context : TInterface (Name {namespace = "Pango", name = "Context"})
    IO (Ptr Pango.Language.Language)

-- | Retrieves the global language tag for the context.
contextGetLanguage ::
    (B.CallStack.HasCallStack, MonadIO m, IsContext a) =>
    a
    -- ^ /@context@/: a @PangoContext@
    -> m Pango.Language.Language
    -- ^ __Returns:__ the global language tag.
contextGetLanguage context = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    result <- pango_context_get_language context'
    checkUnexpectedReturnNULL "contextGetLanguage" result
    result' <- (newBoxed Pango.Language.Language) result
    touchManagedPtr context
    return result'

#if defined(ENABLE_OVERLOADING)
data ContextGetLanguageMethodInfo
instance (signature ~ (m Pango.Language.Language), MonadIO m, IsContext a) => O.OverloadedMethod ContextGetLanguageMethodInfo a signature where
    overloadedMethod = contextGetLanguage

instance O.OverloadedMethodInfo ContextGetLanguageMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Objects.Context.contextGetLanguage",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Objects-Context.html#v:contextGetLanguage"
        })


#endif

-- method Context::get_matrix
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Context" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoContext`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Pango" , name = "Matrix" })
-- throws : False
-- Skip return : False

foreign import ccall "pango_context_get_matrix" pango_context_get_matrix :: 
    Ptr Context ->                          -- context : TInterface (Name {namespace = "Pango", name = "Context"})
    IO (Ptr Pango.Matrix.Matrix)

-- | Gets the transformation matrix that will be applied when
-- rendering with this context.
-- 
-- See 'GI.Pango.Objects.Context.contextSetMatrix'.
-- 
-- /Since: 1.6/
contextGetMatrix ::
    (B.CallStack.HasCallStack, MonadIO m, IsContext a) =>
    a
    -- ^ /@context@/: a @PangoContext@
    -> m (Maybe Pango.Matrix.Matrix)
    -- ^ __Returns:__ the matrix, or 'P.Nothing' if no
    --   matrix has been set (which is the same as the identity matrix).
    --   The returned matrix is owned by Pango and must not be modified
    --   or freed.
contextGetMatrix context = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    result <- pango_context_get_matrix context'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newBoxed Pango.Matrix.Matrix) result'
        return result''
    touchManagedPtr context
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data ContextGetMatrixMethodInfo
instance (signature ~ (m (Maybe Pango.Matrix.Matrix)), MonadIO m, IsContext a) => O.OverloadedMethod ContextGetMatrixMethodInfo a signature where
    overloadedMethod = contextGetMatrix

instance O.OverloadedMethodInfo ContextGetMatrixMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Objects.Context.contextGetMatrix",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Objects-Context.html#v:contextGetMatrix"
        })


#endif

-- method Context::get_metrics
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Context" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoContext`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "desc"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "FontDescription" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a `PangoFontDescription` structure. %NULL means that the\n  font description from the context will be used."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "language"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Language" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "language tag used to determine which script to get\n  the metrics for. %NULL means that the language tag from the context\n  will be used. If no language tag is set on the context, metrics\n  for the default language (as determined by [func@Pango.Language.get_default]\n  will be returned."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Pango" , name = "FontMetrics" })
-- throws : False
-- Skip return : False

foreign import ccall "pango_context_get_metrics" pango_context_get_metrics :: 
    Ptr Context ->                          -- context : TInterface (Name {namespace = "Pango", name = "Context"})
    Ptr Pango.FontDescription.FontDescription -> -- desc : TInterface (Name {namespace = "Pango", name = "FontDescription"})
    Ptr Pango.Language.Language ->          -- language : TInterface (Name {namespace = "Pango", name = "Language"})
    IO (Ptr Pango.FontMetrics.FontMetrics)

-- | Get overall metric information for a particular font description.
-- 
-- Since the metrics may be substantially different for different scripts,
-- a language tag can be provided to indicate that the metrics should be
-- retrieved that correspond to the script(s) used by that language.
-- 
-- The @PangoFontDescription@ is interpreted in the same way as by [func/@itemize@/],
-- and the family name may be a comma separated list of names. If characters
-- from multiple of these families would be used to render the string, then
-- the returned fonts would be a composite of the metrics for the fonts loaded
-- for the individual families.
contextGetMetrics ::
    (B.CallStack.HasCallStack, MonadIO m, IsContext a) =>
    a
    -- ^ /@context@/: a @PangoContext@
    -> Maybe (Pango.FontDescription.FontDescription)
    -- ^ /@desc@/: a @PangoFontDescription@ structure. 'P.Nothing' means that the
    --   font description from the context will be used.
    -> Maybe (Pango.Language.Language)
    -- ^ /@language@/: language tag used to determine which script to get
    --   the metrics for. 'P.Nothing' means that the language tag from the context
    --   will be used. If no language tag is set on the context, metrics
    --   for the default language (as determined by 'GI.Pango.Structs.Language.languageGetDefault'
    --   will be returned.
    -> m Pango.FontMetrics.FontMetrics
    -- ^ __Returns:__ a @PangoFontMetrics@ object. The caller must call
    --   'GI.Pango.Structs.FontMetrics.fontMetricsUnref' when finished using the object.
contextGetMetrics context desc language = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    maybeDesc <- case desc of
        Nothing -> return FP.nullPtr
        Just jDesc -> do
            jDesc' <- unsafeManagedPtrGetPtr jDesc
            return jDesc'
    maybeLanguage <- case language of
        Nothing -> return FP.nullPtr
        Just jLanguage -> do
            jLanguage' <- unsafeManagedPtrGetPtr jLanguage
            return jLanguage'
    result <- pango_context_get_metrics context' maybeDesc maybeLanguage
    checkUnexpectedReturnNULL "contextGetMetrics" result
    result' <- (wrapBoxed Pango.FontMetrics.FontMetrics) result
    touchManagedPtr context
    whenJust desc touchManagedPtr
    whenJust language touchManagedPtr
    return result'

#if defined(ENABLE_OVERLOADING)
data ContextGetMetricsMethodInfo
instance (signature ~ (Maybe (Pango.FontDescription.FontDescription) -> Maybe (Pango.Language.Language) -> m Pango.FontMetrics.FontMetrics), MonadIO m, IsContext a) => O.OverloadedMethod ContextGetMetricsMethodInfo a signature where
    overloadedMethod = contextGetMetrics

instance O.OverloadedMethodInfo ContextGetMetricsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Objects.Context.contextGetMetrics",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Objects-Context.html#v:contextGetMetrics"
        })


#endif

-- method Context::get_round_glyph_positions
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Context" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoContext`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "pango_context_get_round_glyph_positions" pango_context_get_round_glyph_positions :: 
    Ptr Context ->                          -- context : TInterface (Name {namespace = "Pango", name = "Context"})
    IO CInt

-- | Returns whether font rendering with this context should
-- round glyph positions and widths.
-- 
-- /Since: 1.44/
contextGetRoundGlyphPositions ::
    (B.CallStack.HasCallStack, MonadIO m, IsContext a) =>
    a
    -- ^ /@context@/: a @PangoContext@
    -> m Bool
contextGetRoundGlyphPositions context = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    result <- pango_context_get_round_glyph_positions context'
    let result' = (/= 0) result
    touchManagedPtr context
    return result'

#if defined(ENABLE_OVERLOADING)
data ContextGetRoundGlyphPositionsMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsContext a) => O.OverloadedMethod ContextGetRoundGlyphPositionsMethodInfo a signature where
    overloadedMethod = contextGetRoundGlyphPositions

instance O.OverloadedMethodInfo ContextGetRoundGlyphPositionsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Objects.Context.contextGetRoundGlyphPositions",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Objects-Context.html#v:contextGetRoundGlyphPositions"
        })


#endif

-- method Context::get_serial
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Context" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoContext`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "pango_context_get_serial" pango_context_get_serial :: 
    Ptr Context ->                          -- context : TInterface (Name {namespace = "Pango", name = "Context"})
    IO Word32

-- | Returns the current serial number of /@context@/.
-- 
-- The serial number is initialized to an small number larger than zero
-- when a new context is created and is increased whenever the context
-- is changed using any of the setter functions, or the @PangoFontMap@ it
-- uses to find fonts has changed. The serial may wrap, but will never
-- have the value 0. Since it can wrap, never compare it with \"less than\",
-- always use \"not equals\".
-- 
-- This can be used to automatically detect changes to a @PangoContext@,
-- and is only useful when implementing objects that need update when their
-- @PangoContext@ changes, like @PangoLayout@.
-- 
-- /Since: 1.32.4/
contextGetSerial ::
    (B.CallStack.HasCallStack, MonadIO m, IsContext a) =>
    a
    -- ^ /@context@/: a @PangoContext@
    -> m Word32
    -- ^ __Returns:__ The current serial number of /@context@/.
contextGetSerial context = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    result <- pango_context_get_serial context'
    touchManagedPtr context
    return result

#if defined(ENABLE_OVERLOADING)
data ContextGetSerialMethodInfo
instance (signature ~ (m Word32), MonadIO m, IsContext a) => O.OverloadedMethod ContextGetSerialMethodInfo a signature where
    overloadedMethod = contextGetSerial

instance O.OverloadedMethodInfo ContextGetSerialMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Objects.Context.contextGetSerial",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Objects-Context.html#v:contextGetSerial"
        })


#endif

-- method Context::list_families
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Context" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoContext`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "families"
--           , argType =
--               TCArray
--                 False
--                 (-1)
--                 2
--                 (TInterface Name { namespace = "Pango" , name = "FontFamily" })
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "location\n  to store a pointer to an array of `PangoFontFamily`. This array should\n  be freed with g_free()."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferContainer
--           }
--       , Arg
--           { argCName = "n_families"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "location to store the number of elements in @descs"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "n_families"
--              , argType = TBasicType TInt
--              , direction = DirectionOut
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText =
--                        Just "location to store the number of elements in @descs"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferEverything
--              }
--          ]
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_context_list_families" pango_context_list_families :: 
    Ptr Context ->                          -- context : TInterface (Name {namespace = "Pango", name = "Context"})
    Ptr (Ptr (Ptr Pango.FontFamily.FontFamily)) -> -- families : TCArray False (-1) 2 (TInterface (Name {namespace = "Pango", name = "FontFamily"}))
    Ptr Int32 ->                            -- n_families : TBasicType TInt
    IO ()

-- | List all families for a context.
contextListFamilies ::
    (B.CallStack.HasCallStack, MonadIO m, IsContext a) =>
    a
    -- ^ /@context@/: a @PangoContext@
    -> m ([Pango.FontFamily.FontFamily])
contextListFamilies context = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    families <- callocMem :: IO (Ptr (Ptr (Ptr Pango.FontFamily.FontFamily)))
    nFamilies <- allocMem :: IO (Ptr Int32)
    pango_context_list_families context' families nFamilies
    nFamilies' <- peek nFamilies
    families' <- peek families
    families'' <- (unpackPtrArrayWithLength nFamilies') families'
    families''' <- mapM (newObject Pango.FontFamily.FontFamily) families''
    freeMem families'
    touchManagedPtr context
    freeMem families
    freeMem nFamilies
    return families'''

#if defined(ENABLE_OVERLOADING)
data ContextListFamiliesMethodInfo
instance (signature ~ (m ([Pango.FontFamily.FontFamily])), MonadIO m, IsContext a) => O.OverloadedMethod ContextListFamiliesMethodInfo a signature where
    overloadedMethod = contextListFamilies

instance O.OverloadedMethodInfo ContextListFamiliesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Objects.Context.contextListFamilies",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Objects-Context.html#v:contextListFamilies"
        })


#endif

-- method Context::load_font
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Context" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoContext`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "desc"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "FontDescription" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a `PangoFontDescription` describing the font to load"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Pango" , name = "Font" })
-- throws : False
-- Skip return : False

foreign import ccall "pango_context_load_font" pango_context_load_font :: 
    Ptr Context ->                          -- context : TInterface (Name {namespace = "Pango", name = "Context"})
    Ptr Pango.FontDescription.FontDescription -> -- desc : TInterface (Name {namespace = "Pango", name = "FontDescription"})
    IO (Ptr Pango.Font.Font)

-- | Loads the font in one of the fontmaps in the context
-- that is the closest match for /@desc@/.
contextLoadFont ::
    (B.CallStack.HasCallStack, MonadIO m, IsContext a) =>
    a
    -- ^ /@context@/: a @PangoContext@
    -> Pango.FontDescription.FontDescription
    -- ^ /@desc@/: a @PangoFontDescription@ describing the font to load
    -> m (Maybe Pango.Font.Font)
    -- ^ __Returns:__ the newly allocated @PangoFont@
    --   that was loaded, or 'P.Nothing' if no font matched.
contextLoadFont context desc = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    desc' <- unsafeManagedPtrGetPtr desc
    result <- pango_context_load_font context' desc'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapObject Pango.Font.Font) result'
        return result''
    touchManagedPtr context
    touchManagedPtr desc
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data ContextLoadFontMethodInfo
instance (signature ~ (Pango.FontDescription.FontDescription -> m (Maybe Pango.Font.Font)), MonadIO m, IsContext a) => O.OverloadedMethod ContextLoadFontMethodInfo a signature where
    overloadedMethod = contextLoadFont

instance O.OverloadedMethodInfo ContextLoadFontMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Objects.Context.contextLoadFont",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Objects-Context.html#v:contextLoadFont"
        })


#endif

-- method Context::load_fontset
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Context" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoContext`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "desc"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "FontDescription" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a `PangoFontDescription` describing the fonts to load"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "language"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Language" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoLanguage` the fonts will be used for"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Pango" , name = "Fontset" })
-- throws : False
-- Skip return : False

foreign import ccall "pango_context_load_fontset" pango_context_load_fontset :: 
    Ptr Context ->                          -- context : TInterface (Name {namespace = "Pango", name = "Context"})
    Ptr Pango.FontDescription.FontDescription -> -- desc : TInterface (Name {namespace = "Pango", name = "FontDescription"})
    Ptr Pango.Language.Language ->          -- language : TInterface (Name {namespace = "Pango", name = "Language"})
    IO (Ptr Pango.Fontset.Fontset)

-- | Load a set of fonts in the context that can be used to render
-- a font matching /@desc@/.
contextLoadFontset ::
    (B.CallStack.HasCallStack, MonadIO m, IsContext a) =>
    a
    -- ^ /@context@/: a @PangoContext@
    -> Pango.FontDescription.FontDescription
    -- ^ /@desc@/: a @PangoFontDescription@ describing the fonts to load
    -> Pango.Language.Language
    -- ^ /@language@/: a @PangoLanguage@ the fonts will be used for
    -> m (Maybe Pango.Fontset.Fontset)
    -- ^ __Returns:__ the newly allocated
    --   @PangoFontset@ loaded, or 'P.Nothing' if no font matched.
contextLoadFontset context desc language = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    desc' <- unsafeManagedPtrGetPtr desc
    language' <- unsafeManagedPtrGetPtr language
    result <- pango_context_load_fontset context' desc' language'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapObject Pango.Fontset.Fontset) result'
        return result''
    touchManagedPtr context
    touchManagedPtr desc
    touchManagedPtr language
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data ContextLoadFontsetMethodInfo
instance (signature ~ (Pango.FontDescription.FontDescription -> Pango.Language.Language -> m (Maybe Pango.Fontset.Fontset)), MonadIO m, IsContext a) => O.OverloadedMethod ContextLoadFontsetMethodInfo a signature where
    overloadedMethod = contextLoadFontset

instance O.OverloadedMethodInfo ContextLoadFontsetMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Objects.Context.contextLoadFontset",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Objects-Context.html#v:contextLoadFontset"
        })


#endif

-- method Context::set_base_dir
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Context" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoContext`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "direction"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Direction" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new base direction"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_context_set_base_dir" pango_context_set_base_dir :: 
    Ptr Context ->                          -- context : TInterface (Name {namespace = "Pango", name = "Context"})
    CUInt ->                                -- direction : TInterface (Name {namespace = "Pango", name = "Direction"})
    IO ()

-- | Sets the base direction for the context.
-- 
-- The base direction is used in applying the Unicode bidirectional
-- algorithm; if the /@direction@/ is 'GI.Pango.Enums.DirectionLtr' or
-- 'GI.Pango.Enums.DirectionRtl', then the value will be used as the paragraph
-- direction in the Unicode bidirectional algorithm. A value of
-- 'GI.Pango.Enums.DirectionWeakLtr' or 'GI.Pango.Enums.DirectionWeakRtl' is used only
-- for paragraphs that do not contain any strong characters themselves.
contextSetBaseDir ::
    (B.CallStack.HasCallStack, MonadIO m, IsContext a) =>
    a
    -- ^ /@context@/: a @PangoContext@
    -> Pango.Enums.Direction
    -- ^ /@direction@/: the new base direction
    -> m ()
contextSetBaseDir context direction = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    let direction' = (fromIntegral . fromEnum) direction
    pango_context_set_base_dir context' direction'
    touchManagedPtr context
    return ()

#if defined(ENABLE_OVERLOADING)
data ContextSetBaseDirMethodInfo
instance (signature ~ (Pango.Enums.Direction -> m ()), MonadIO m, IsContext a) => O.OverloadedMethod ContextSetBaseDirMethodInfo a signature where
    overloadedMethod = contextSetBaseDir

instance O.OverloadedMethodInfo ContextSetBaseDirMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Objects.Context.contextSetBaseDir",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Objects-Context.html#v:contextSetBaseDir"
        })


#endif

-- method Context::set_base_gravity
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Context" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoContext`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "gravity"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Gravity" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new base gravity"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_context_set_base_gravity" pango_context_set_base_gravity :: 
    Ptr Context ->                          -- context : TInterface (Name {namespace = "Pango", name = "Context"})
    CUInt ->                                -- gravity : TInterface (Name {namespace = "Pango", name = "Gravity"})
    IO ()

-- | Sets the base gravity for the context.
-- 
-- The base gravity is used in laying vertical text out.
-- 
-- /Since: 1.16/
contextSetBaseGravity ::
    (B.CallStack.HasCallStack, MonadIO m, IsContext a) =>
    a
    -- ^ /@context@/: a @PangoContext@
    -> Pango.Enums.Gravity
    -- ^ /@gravity@/: the new base gravity
    -> m ()
contextSetBaseGravity context gravity = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    let gravity' = (fromIntegral . fromEnum) gravity
    pango_context_set_base_gravity context' gravity'
    touchManagedPtr context
    return ()

#if defined(ENABLE_OVERLOADING)
data ContextSetBaseGravityMethodInfo
instance (signature ~ (Pango.Enums.Gravity -> m ()), MonadIO m, IsContext a) => O.OverloadedMethod ContextSetBaseGravityMethodInfo a signature where
    overloadedMethod = contextSetBaseGravity

instance O.OverloadedMethodInfo ContextSetBaseGravityMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Objects.Context.contextSetBaseGravity",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Objects-Context.html#v:contextSetBaseGravity"
        })


#endif

-- method Context::set_font_description
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Context" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoContext`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "desc"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "FontDescription" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new pango font description"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_context_set_font_description" pango_context_set_font_description :: 
    Ptr Context ->                          -- context : TInterface (Name {namespace = "Pango", name = "Context"})
    Ptr Pango.FontDescription.FontDescription -> -- desc : TInterface (Name {namespace = "Pango", name = "FontDescription"})
    IO ()

-- | Set the default font description for the context
contextSetFontDescription ::
    (B.CallStack.HasCallStack, MonadIO m, IsContext a) =>
    a
    -- ^ /@context@/: a @PangoContext@
    -> Maybe (Pango.FontDescription.FontDescription)
    -- ^ /@desc@/: the new pango font description
    -> m ()
contextSetFontDescription context desc = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    maybeDesc <- case desc of
        Nothing -> return FP.nullPtr
        Just jDesc -> do
            jDesc' <- unsafeManagedPtrGetPtr jDesc
            return jDesc'
    pango_context_set_font_description context' maybeDesc
    touchManagedPtr context
    whenJust desc touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data ContextSetFontDescriptionMethodInfo
instance (signature ~ (Maybe (Pango.FontDescription.FontDescription) -> m ()), MonadIO m, IsContext a) => O.OverloadedMethod ContextSetFontDescriptionMethodInfo a signature where
    overloadedMethod = contextSetFontDescription

instance O.OverloadedMethodInfo ContextSetFontDescriptionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Objects.Context.contextSetFontDescription",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Objects-Context.html#v:contextSetFontDescription"
        })


#endif

-- method Context::set_font_map
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Context" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoContext`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "font_map"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "FontMap" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the `PangoFontMap` to set."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_context_set_font_map" pango_context_set_font_map :: 
    Ptr Context ->                          -- context : TInterface (Name {namespace = "Pango", name = "Context"})
    Ptr Pango.FontMap.FontMap ->            -- font_map : TInterface (Name {namespace = "Pango", name = "FontMap"})
    IO ()

-- | Sets the font map to be searched when fonts are looked-up
-- in this context.
-- 
-- This is only for internal use by Pango backends, a @PangoContext@
-- obtained via one of the recommended methods should already have a
-- suitable font map.
contextSetFontMap ::
    (B.CallStack.HasCallStack, MonadIO m, IsContext a, Pango.FontMap.IsFontMap b) =>
    a
    -- ^ /@context@/: a @PangoContext@
    -> Maybe (b)
    -- ^ /@fontMap@/: the @PangoFontMap@ to set.
    -> m ()
contextSetFontMap context fontMap = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    maybeFontMap <- case fontMap of
        Nothing -> return FP.nullPtr
        Just jFontMap -> do
            jFontMap' <- unsafeManagedPtrCastPtr jFontMap
            return jFontMap'
    pango_context_set_font_map context' maybeFontMap
    touchManagedPtr context
    whenJust fontMap touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data ContextSetFontMapMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsContext a, Pango.FontMap.IsFontMap b) => O.OverloadedMethod ContextSetFontMapMethodInfo a signature where
    overloadedMethod = contextSetFontMap

instance O.OverloadedMethodInfo ContextSetFontMapMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Objects.Context.contextSetFontMap",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Objects-Context.html#v:contextSetFontMap"
        })


#endif

-- method Context::set_gravity_hint
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Context" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoContext`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "hint"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "GravityHint" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new gravity hint"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_context_set_gravity_hint" pango_context_set_gravity_hint :: 
    Ptr Context ->                          -- context : TInterface (Name {namespace = "Pango", name = "Context"})
    CUInt ->                                -- hint : TInterface (Name {namespace = "Pango", name = "GravityHint"})
    IO ()

-- | Sets the gravity hint for the context.
-- 
-- The gravity hint is used in laying vertical text out, and
-- is only relevant if gravity of the context as returned by
-- 'GI.Pango.Objects.Context.contextGetGravity' is set to 'GI.Pango.Enums.GravityEast'
-- or 'GI.Pango.Enums.GravityWest'.
-- 
-- /Since: 1.16/
contextSetGravityHint ::
    (B.CallStack.HasCallStack, MonadIO m, IsContext a) =>
    a
    -- ^ /@context@/: a @PangoContext@
    -> Pango.Enums.GravityHint
    -- ^ /@hint@/: the new gravity hint
    -> m ()
contextSetGravityHint context hint = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    let hint' = (fromIntegral . fromEnum) hint
    pango_context_set_gravity_hint context' hint'
    touchManagedPtr context
    return ()

#if defined(ENABLE_OVERLOADING)
data ContextSetGravityHintMethodInfo
instance (signature ~ (Pango.Enums.GravityHint -> m ()), MonadIO m, IsContext a) => O.OverloadedMethod ContextSetGravityHintMethodInfo a signature where
    overloadedMethod = contextSetGravityHint

instance O.OverloadedMethodInfo ContextSetGravityHintMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Objects.Context.contextSetGravityHint",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Objects-Context.html#v:contextSetGravityHint"
        })


#endif

-- method Context::set_language
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Context" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoContext`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "language"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Language" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new language tag."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_context_set_language" pango_context_set_language :: 
    Ptr Context ->                          -- context : TInterface (Name {namespace = "Pango", name = "Context"})
    Ptr Pango.Language.Language ->          -- language : TInterface (Name {namespace = "Pango", name = "Language"})
    IO ()

-- | Sets the global language tag for the context.
-- 
-- The default language for the locale of the running process
-- can be found using 'GI.Pango.Structs.Language.languageGetDefault'.
contextSetLanguage ::
    (B.CallStack.HasCallStack, MonadIO m, IsContext a) =>
    a
    -- ^ /@context@/: a @PangoContext@
    -> Maybe (Pango.Language.Language)
    -- ^ /@language@/: the new language tag.
    -> m ()
contextSetLanguage context language = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    maybeLanguage <- case language of
        Nothing -> return FP.nullPtr
        Just jLanguage -> do
            jLanguage' <- unsafeManagedPtrGetPtr jLanguage
            return jLanguage'
    pango_context_set_language context' maybeLanguage
    touchManagedPtr context
    whenJust language touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data ContextSetLanguageMethodInfo
instance (signature ~ (Maybe (Pango.Language.Language) -> m ()), MonadIO m, IsContext a) => O.OverloadedMethod ContextSetLanguageMethodInfo a signature where
    overloadedMethod = contextSetLanguage

instance O.OverloadedMethodInfo ContextSetLanguageMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Objects.Context.contextSetLanguage",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Objects-Context.html#v:contextSetLanguage"
        })


#endif

-- method Context::set_matrix
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Context" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoContext`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "matrix"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Matrix" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a `PangoMatrix`, or %NULL to unset any existing\nmatrix. (No matrix set is the same as setting the identity matrix.)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_context_set_matrix" pango_context_set_matrix :: 
    Ptr Context ->                          -- context : TInterface (Name {namespace = "Pango", name = "Context"})
    Ptr Pango.Matrix.Matrix ->              -- matrix : TInterface (Name {namespace = "Pango", name = "Matrix"})
    IO ()

-- | Sets the transformation matrix that will be applied when rendering
-- with this context.
-- 
-- Note that reported metrics are in the user space coordinates before
-- the application of the matrix, not device-space coordinates after the
-- application of the matrix. So, they don\'t scale with the matrix, though
-- they may change slightly for different matrices, depending on how the
-- text is fit to the pixel grid.
-- 
-- /Since: 1.6/
contextSetMatrix ::
    (B.CallStack.HasCallStack, MonadIO m, IsContext a) =>
    a
    -- ^ /@context@/: a @PangoContext@
    -> Maybe (Pango.Matrix.Matrix)
    -- ^ /@matrix@/: a @PangoMatrix@, or 'P.Nothing' to unset any existing
    -- matrix. (No matrix set is the same as setting the identity matrix.)
    -> m ()
contextSetMatrix context matrix = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    maybeMatrix <- case matrix of
        Nothing -> return FP.nullPtr
        Just jMatrix -> do
            jMatrix' <- unsafeManagedPtrGetPtr jMatrix
            return jMatrix'
    pango_context_set_matrix context' maybeMatrix
    touchManagedPtr context
    whenJust matrix touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data ContextSetMatrixMethodInfo
instance (signature ~ (Maybe (Pango.Matrix.Matrix) -> m ()), MonadIO m, IsContext a) => O.OverloadedMethod ContextSetMatrixMethodInfo a signature where
    overloadedMethod = contextSetMatrix

instance O.OverloadedMethodInfo ContextSetMatrixMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Objects.Context.contextSetMatrix",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Objects-Context.html#v:contextSetMatrix"
        })


#endif

-- method Context::set_round_glyph_positions
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Context" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoContext`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "round_positions"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "whether to round glyph positions"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_context_set_round_glyph_positions" pango_context_set_round_glyph_positions :: 
    Ptr Context ->                          -- context : TInterface (Name {namespace = "Pango", name = "Context"})
    CInt ->                                 -- round_positions : TBasicType TBoolean
    IO ()

-- | Sets whether font rendering with this context should
-- round glyph positions and widths to integral positions,
-- in device units.
-- 
-- This is useful when the renderer can\'t handle subpixel
-- positioning of glyphs.
-- 
-- The default value is to round glyph positions, to remain
-- compatible with previous Pango behavior.
-- 
-- /Since: 1.44/
contextSetRoundGlyphPositions ::
    (B.CallStack.HasCallStack, MonadIO m, IsContext a) =>
    a
    -- ^ /@context@/: a @PangoContext@
    -> Bool
    -- ^ /@roundPositions@/: whether to round glyph positions
    -> m ()
contextSetRoundGlyphPositions context roundPositions = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    let roundPositions' = (P.fromIntegral . P.fromEnum) roundPositions
    pango_context_set_round_glyph_positions context' roundPositions'
    touchManagedPtr context
    return ()

#if defined(ENABLE_OVERLOADING)
data ContextSetRoundGlyphPositionsMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsContext a) => O.OverloadedMethod ContextSetRoundGlyphPositionsMethodInfo a signature where
    overloadedMethod = contextSetRoundGlyphPositions

instance O.OverloadedMethodInfo ContextSetRoundGlyphPositionsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Objects.Context.contextSetRoundGlyphPositions",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Objects-Context.html#v:contextSetRoundGlyphPositions"
        })


#endif


