{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- The @PangoColor@ structure is used to
-- represent a color in an uncalibrated RGB color-space.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Pango.Structs.Color
    ( 

-- * Exported types
    Color(..)                               ,
    newZeroColor                            ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [copy]("GI.Pango.Structs.Color#g:method:copy"), [free]("GI.Pango.Structs.Color#g:method:free"), [parse]("GI.Pango.Structs.Color#g:method:parse"), [parseWithAlpha]("GI.Pango.Structs.Color#g:method:parseWithAlpha"), [toString]("GI.Pango.Structs.Color#g:method:toString").
-- 
-- ==== Getters
-- /None/.
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveColorMethod                      ,
#endif

-- ** copy #method:copy#

#if defined(ENABLE_OVERLOADING)
    ColorCopyMethodInfo                     ,
#endif
    colorCopy                               ,


-- ** free #method:free#

#if defined(ENABLE_OVERLOADING)
    ColorFreeMethodInfo                     ,
#endif
    colorFree                               ,


-- ** parse #method:parse#

#if defined(ENABLE_OVERLOADING)
    ColorParseMethodInfo                    ,
#endif
    colorParse                              ,


-- ** parseWithAlpha #method:parseWithAlpha#

#if defined(ENABLE_OVERLOADING)
    ColorParseWithAlphaMethodInfo           ,
#endif
    colorParseWithAlpha                     ,


-- ** toString #method:toString#

#if defined(ENABLE_OVERLOADING)
    ColorToStringMethodInfo                 ,
#endif
    colorToString                           ,




 -- * Properties


-- ** blue #attr:blue#
-- | value of blue component

#if defined(ENABLE_OVERLOADING)
    color_blue                              ,
#endif
    getColorBlue                            ,
    setColorBlue                            ,


-- ** green #attr:green#
-- | value of green component

#if defined(ENABLE_OVERLOADING)
    color_green                             ,
#endif
    getColorGreen                           ,
    setColorGreen                           ,


-- ** red #attr:red#
-- | value of red component

#if defined(ENABLE_OVERLOADING)
    color_red                               ,
#endif
    getColorRed                             ,
    setColorRed                             ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- | Memory-managed wrapper type.
newtype Color = Color (SP.ManagedPtr Color)
    deriving (Eq)

instance SP.ManagedPtrNewtype Color where
    toManagedPtr (Color p) = p

foreign import ccall "pango_color_get_type" c_pango_color_get_type :: 
    IO GType

type instance O.ParentTypes Color = '[]
instance O.HasParentTypes Color

instance B.Types.TypedObject Color where
    glibType = c_pango_color_get_type

instance B.Types.GBoxed Color

-- | Convert t'Color' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Color) where
    gvalueGType_ = c_pango_color_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_boxed gv (FP.nullPtr :: FP.Ptr Color)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_boxed gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_boxed gv :: IO (Ptr Color)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newBoxed Color ptr
        else return P.Nothing
        
    

-- | Construct a t'Color' struct initialized to zero.
newZeroColor :: MonadIO m => m Color
newZeroColor = liftIO $ callocBoxedBytes 6 >>= wrapBoxed Color

instance tag ~ 'AttrSet => Constructible Color tag where
    new _ attrs = do
        o <- newZeroColor
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@red@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' color #red
-- @
getColorRed :: MonadIO m => Color -> m Word16
getColorRed s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO Word16
    return val

-- | Set the value of the “@red@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' color [ #red 'Data.GI.Base.Attributes.:=' value ]
-- @
setColorRed :: MonadIO m => Color -> Word16 -> m ()
setColorRed s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: Word16)

#if defined(ENABLE_OVERLOADING)
data ColorRedFieldInfo
instance AttrInfo ColorRedFieldInfo where
    type AttrBaseTypeConstraint ColorRedFieldInfo = (~) Color
    type AttrAllowedOps ColorRedFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint ColorRedFieldInfo = (~) Word16
    type AttrTransferTypeConstraint ColorRedFieldInfo = (~)Word16
    type AttrTransferType ColorRedFieldInfo = Word16
    type AttrGetType ColorRedFieldInfo = Word16
    type AttrLabel ColorRedFieldInfo = "red"
    type AttrOrigin ColorRedFieldInfo = Color
    attrGet = getColorRed
    attrSet = setColorRed
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.Color.red"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-Color.html#g:attr:red"
        })

color_red :: AttrLabelProxy "red"
color_red = AttrLabelProxy

#endif


-- | Get the value of the “@green@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' color #green
-- @
getColorGreen :: MonadIO m => Color -> m Word16
getColorGreen s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 2) :: IO Word16
    return val

-- | Set the value of the “@green@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' color [ #green 'Data.GI.Base.Attributes.:=' value ]
-- @
setColorGreen :: MonadIO m => Color -> Word16 -> m ()
setColorGreen s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 2) (val :: Word16)

#if defined(ENABLE_OVERLOADING)
data ColorGreenFieldInfo
instance AttrInfo ColorGreenFieldInfo where
    type AttrBaseTypeConstraint ColorGreenFieldInfo = (~) Color
    type AttrAllowedOps ColorGreenFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint ColorGreenFieldInfo = (~) Word16
    type AttrTransferTypeConstraint ColorGreenFieldInfo = (~)Word16
    type AttrTransferType ColorGreenFieldInfo = Word16
    type AttrGetType ColorGreenFieldInfo = Word16
    type AttrLabel ColorGreenFieldInfo = "green"
    type AttrOrigin ColorGreenFieldInfo = Color
    attrGet = getColorGreen
    attrSet = setColorGreen
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.Color.green"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-Color.html#g:attr:green"
        })

color_green :: AttrLabelProxy "green"
color_green = AttrLabelProxy

#endif


-- | Get the value of the “@blue@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' color #blue
-- @
getColorBlue :: MonadIO m => Color -> m Word16
getColorBlue s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 4) :: IO Word16
    return val

-- | Set the value of the “@blue@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' color [ #blue 'Data.GI.Base.Attributes.:=' value ]
-- @
setColorBlue :: MonadIO m => Color -> Word16 -> m ()
setColorBlue s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 4) (val :: Word16)

#if defined(ENABLE_OVERLOADING)
data ColorBlueFieldInfo
instance AttrInfo ColorBlueFieldInfo where
    type AttrBaseTypeConstraint ColorBlueFieldInfo = (~) Color
    type AttrAllowedOps ColorBlueFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint ColorBlueFieldInfo = (~) Word16
    type AttrTransferTypeConstraint ColorBlueFieldInfo = (~)Word16
    type AttrTransferType ColorBlueFieldInfo = Word16
    type AttrGetType ColorBlueFieldInfo = Word16
    type AttrLabel ColorBlueFieldInfo = "blue"
    type AttrOrigin ColorBlueFieldInfo = Color
    attrGet = getColorBlue
    attrSet = setColorBlue
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.Color.blue"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-Color.html#g:attr:blue"
        })

color_blue :: AttrLabelProxy "blue"
color_blue = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Color
type instance O.AttributeList Color = ColorAttributeList
type ColorAttributeList = ('[ '("red", ColorRedFieldInfo), '("green", ColorGreenFieldInfo), '("blue", ColorBlueFieldInfo)] :: [(Symbol, DK.Type)])
#endif

-- method Color::copy
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "src"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Color" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "color to copy" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Pango" , name = "Color" })
-- throws : False
-- Skip return : False

foreign import ccall "pango_color_copy" pango_color_copy :: 
    Ptr Color ->                            -- src : TInterface (Name {namespace = "Pango", name = "Color"})
    IO (Ptr Color)

-- | Creates a copy of /@src@/.
-- 
-- The copy should be freed with 'GI.Pango.Structs.Color.colorFree'.
-- Primarily used by language bindings, not that useful
-- otherwise (since colors can just be copied by assignment
-- in C).
colorCopy ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (Color)
    -- ^ /@src@/: color to copy
    -> m (Maybe Color)
    -- ^ __Returns:__ the newly allocated @PangoColor@,
    --   which should be freed with 'GI.Pango.Structs.Color.colorFree'
colorCopy src = liftIO $ do
    maybeSrc <- case src of
        Nothing -> return FP.nullPtr
        Just jSrc -> do
            jSrc' <- unsafeManagedPtrGetPtr jSrc
            return jSrc'
    result <- pango_color_copy maybeSrc
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapBoxed Color) result'
        return result''
    whenJust src touchManagedPtr
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data ColorCopyMethodInfo
instance (signature ~ (m (Maybe Color)), MonadIO m) => O.OverloadedMethod ColorCopyMethodInfo Color signature where
    overloadedMethod i = colorCopy (Just i)

instance O.OverloadedMethodInfo ColorCopyMethodInfo Color where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.Color.colorCopy",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-Color.html#v:colorCopy"
        })


#endif

-- method Color::free
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "color"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Color" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an allocated `PangoColor`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_color_free" pango_color_free :: 
    Ptr Color ->                            -- color : TInterface (Name {namespace = "Pango", name = "Color"})
    IO ()

-- | Frees a color allocated by 'GI.Pango.Structs.Color.colorCopy'.
colorFree ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (Color)
    -- ^ /@color@/: an allocated @PangoColor@
    -> m ()
colorFree color = liftIO $ do
    maybeColor <- case color of
        Nothing -> return FP.nullPtr
        Just jColor -> do
            jColor' <- unsafeManagedPtrGetPtr jColor
            return jColor'
    pango_color_free maybeColor
    whenJust color touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data ColorFreeMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod ColorFreeMethodInfo Color signature where
    overloadedMethod i = colorFree (Just i)

instance O.OverloadedMethodInfo ColorFreeMethodInfo Color where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.Color.colorFree",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-Color.html#v:colorFree"
        })


#endif

-- method Color::parse
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "color"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Color" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a `PangoColor` structure in which\n  to store the result"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "spec"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a string specifying the new color"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "pango_color_parse" pango_color_parse :: 
    Ptr Color ->                            -- color : TInterface (Name {namespace = "Pango", name = "Color"})
    CString ->                              -- spec : TBasicType TUTF8
    IO CInt

-- | Fill in the fields of a color from a string specification.
-- 
-- The string can either one of a large set of standard names.
-- (Taken from the CSS Color <https://www.w3.org/TR/css-color-4/#named-colors specification>,
-- or it can be a value in the form @#rgb@, @#rrggbb@,
-- @#rrrgggbbb@ or @#rrrrggggbbbb@, where @r@, @g@ and @b@
-- are hex digits of the red, green, and blue components
-- of the color, respectively. (White in the four forms is
-- @#fff@, @#ffffff@, @#fffffffff@ and @#ffffffffffff@.)
colorParse ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (Color)
    -- ^ /@color@/: a @PangoColor@ structure in which
    --   to store the result
    -> T.Text
    -- ^ /@spec@/: a string specifying the new color
    -> m Bool
    -- ^ __Returns:__ 'P.True' if parsing of the specifier succeeded,
    --   otherwise 'P.False'
colorParse color spec = liftIO $ do
    maybeColor <- case color of
        Nothing -> return FP.nullPtr
        Just jColor -> do
            jColor' <- unsafeManagedPtrGetPtr jColor
            return jColor'
    spec' <- textToCString spec
    result <- pango_color_parse maybeColor spec'
    let result' = (/= 0) result
    whenJust color touchManagedPtr
    freeMem spec'
    return result'

#if defined(ENABLE_OVERLOADING)
data ColorParseMethodInfo
instance (signature ~ (T.Text -> m Bool), MonadIO m) => O.OverloadedMethod ColorParseMethodInfo Color signature where
    overloadedMethod i = colorParse (Just i)

instance O.OverloadedMethodInfo ColorParseMethodInfo Color where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.Color.colorParse",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-Color.html#v:colorParse"
        })


#endif

-- method Color::parse_with_alpha
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "color"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Color" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a `PangoColor` structure in which\n  to store the result"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "alpha"
--           , argType = TBasicType TUInt16
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for alpha"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "spec"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a string specifying the new color"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "pango_color_parse_with_alpha" pango_color_parse_with_alpha :: 
    Ptr Color ->                            -- color : TInterface (Name {namespace = "Pango", name = "Color"})
    Ptr Word16 ->                           -- alpha : TBasicType TUInt16
    CString ->                              -- spec : TBasicType TUTF8
    IO CInt

-- | Fill in the fields of a color from a string specification.
-- 
-- The string can either one of a large set of standard names.
-- (Taken from the CSS Color <https://www.w3.org/TR/css-color-4/#named-colors specification>,
-- or it can be a hexadecimal value in the form @#rgb@,
-- @#rrggbb@, @#rrrgggbbb@ or @#rrrrggggbbbb@ where @r@, @g@
-- and @b@ are hex digits of the red, green, and blue components
-- of the color, respectively. (White in the four forms is
-- @#fff@, @#ffffff@, @#fffffffff@ and @#ffffffffffff@.)
-- 
-- Additionally, parse strings of the form @#rgba@, @#rrggbbaa@,
-- @#rrrrggggbbbbaaaa@, if /@alpha@/ is not 'P.Nothing', and set /@alpha@/
-- to the value specified by the hex digits for @a@. If no alpha
-- component is found in /@spec@/, /@alpha@/ is set to 0xffff (for a
-- solid color).
-- 
-- /Since: 1.46/
colorParseWithAlpha ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (Color)
    -- ^ /@color@/: a @PangoColor@ structure in which
    --   to store the result
    -> T.Text
    -- ^ /@spec@/: a string specifying the new color
    -> m ((Bool, Word16))
    -- ^ __Returns:__ 'P.True' if parsing of the specifier succeeded,
    --   otherwise 'P.False'
colorParseWithAlpha color spec = liftIO $ do
    maybeColor <- case color of
        Nothing -> return FP.nullPtr
        Just jColor -> do
            jColor' <- unsafeManagedPtrGetPtr jColor
            return jColor'
    alpha <- allocMem :: IO (Ptr Word16)
    spec' <- textToCString spec
    result <- pango_color_parse_with_alpha maybeColor alpha spec'
    let result' = (/= 0) result
    alpha' <- peek alpha
    whenJust color touchManagedPtr
    freeMem alpha
    freeMem spec'
    return (result', alpha')

#if defined(ENABLE_OVERLOADING)
data ColorParseWithAlphaMethodInfo
instance (signature ~ (T.Text -> m ((Bool, Word16))), MonadIO m) => O.OverloadedMethod ColorParseWithAlphaMethodInfo Color signature where
    overloadedMethod i = colorParseWithAlpha (Just i)

instance O.OverloadedMethodInfo ColorParseWithAlphaMethodInfo Color where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.Color.colorParseWithAlpha",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-Color.html#v:colorParseWithAlpha"
        })


#endif

-- method Color::to_string
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "color"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Color" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoColor`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "pango_color_to_string" pango_color_to_string :: 
    Ptr Color ->                            -- color : TInterface (Name {namespace = "Pango", name = "Color"})
    IO CString

-- | Returns a textual specification of /@color@/.
-- 
-- The string is in the hexadecimal form @#rrrrggggbbbb@,
-- where @r@, @g@ and @b@ are hex digits representing the
-- red, green, and blue components respectively.
-- 
-- /Since: 1.16/
colorToString ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Color
    -- ^ /@color@/: a @PangoColor@
    -> m T.Text
    -- ^ __Returns:__ a newly-allocated text string that must
    --   be freed with 'GI.GLib.Functions.free'.
colorToString color = liftIO $ do
    color' <- unsafeManagedPtrGetPtr color
    result <- pango_color_to_string color'
    checkUnexpectedReturnNULL "colorToString" result
    result' <- cstringToText result
    freeMem result
    touchManagedPtr color
    return result'

#if defined(ENABLE_OVERLOADING)
data ColorToStringMethodInfo
instance (signature ~ (m T.Text), MonadIO m) => O.OverloadedMethod ColorToStringMethodInfo Color signature where
    overloadedMethod = colorToString

instance O.OverloadedMethodInfo ColorToStringMethodInfo Color where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.Color.colorToString",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-Color.html#v:colorToString"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveColorMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveColorMethod "copy" o = ColorCopyMethodInfo
    ResolveColorMethod "free" o = ColorFreeMethodInfo
    ResolveColorMethod "parse" o = ColorParseMethodInfo
    ResolveColorMethod "parseWithAlpha" o = ColorParseWithAlphaMethodInfo
    ResolveColorMethod "toString" o = ColorToStringMethodInfo
    ResolveColorMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveColorMethod t Color, O.OverloadedMethod info Color p) => OL.IsLabel t (Color -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveColorMethod t Color, O.OverloadedMethod info Color p, R.HasField t Color p) => R.HasField t Color p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveColorMethod t Color, O.OverloadedMethodInfo info Color) => OL.IsLabel t (O.MethodProxy info Color) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


