/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	context "context"

	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
	apisv1 "sigs.k8s.io/gateway-api/apis/v1"
	applyconfigurationapisv1 "sigs.k8s.io/gateway-api/applyconfiguration/apis/v1"
	scheme "sigs.k8s.io/gateway-api/pkg/client/clientset/versioned/scheme"
)

// BackendTLSPoliciesGetter has a method to return a BackendTLSPolicyInterface.
// A group's client should implement this interface.
type BackendTLSPoliciesGetter interface {
	BackendTLSPolicies(namespace string) BackendTLSPolicyInterface
}

// BackendTLSPolicyInterface has methods to work with BackendTLSPolicy resources.
type BackendTLSPolicyInterface interface {
	Create(ctx context.Context, backendTLSPolicy *apisv1.BackendTLSPolicy, opts metav1.CreateOptions) (*apisv1.BackendTLSPolicy, error)
	Update(ctx context.Context, backendTLSPolicy *apisv1.BackendTLSPolicy, opts metav1.UpdateOptions) (*apisv1.BackendTLSPolicy, error)
	// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
	UpdateStatus(ctx context.Context, backendTLSPolicy *apisv1.BackendTLSPolicy, opts metav1.UpdateOptions) (*apisv1.BackendTLSPolicy, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*apisv1.BackendTLSPolicy, error)
	List(ctx context.Context, opts metav1.ListOptions) (*apisv1.BackendTLSPolicyList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apisv1.BackendTLSPolicy, err error)
	Apply(ctx context.Context, backendTLSPolicy *applyconfigurationapisv1.BackendTLSPolicyApplyConfiguration, opts metav1.ApplyOptions) (result *apisv1.BackendTLSPolicy, err error)
	// Add a +genclient:noStatus comment above the type to avoid generating ApplyStatus().
	ApplyStatus(ctx context.Context, backendTLSPolicy *applyconfigurationapisv1.BackendTLSPolicyApplyConfiguration, opts metav1.ApplyOptions) (result *apisv1.BackendTLSPolicy, err error)
	BackendTLSPolicyExpansion
}

// backendTLSPolicies implements BackendTLSPolicyInterface
type backendTLSPolicies struct {
	*gentype.ClientWithListAndApply[*apisv1.BackendTLSPolicy, *apisv1.BackendTLSPolicyList, *applyconfigurationapisv1.BackendTLSPolicyApplyConfiguration]
}

// newBackendTLSPolicies returns a BackendTLSPolicies
func newBackendTLSPolicies(c *GatewayV1Client, namespace string) *backendTLSPolicies {
	return &backendTLSPolicies{
		gentype.NewClientWithListAndApply[*apisv1.BackendTLSPolicy, *apisv1.BackendTLSPolicyList, *applyconfigurationapisv1.BackendTLSPolicyApplyConfiguration](
			"backendtlspolicies",
			c.RESTClient(),
			scheme.ParameterCodec,
			namespace,
			func() *apisv1.BackendTLSPolicy { return &apisv1.BackendTLSPolicy{} },
			func() *apisv1.BackendTLSPolicyList { return &apisv1.BackendTLSPolicyList{} },
		),
	}
}
