/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	context "context"

	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
	apiv1 "sigs.k8s.io/gateway-api-inference-extension/api/v1"
	applyconfigurationapiv1 "sigs.k8s.io/gateway-api-inference-extension/client-go/applyconfiguration/api/v1"
	scheme "sigs.k8s.io/gateway-api-inference-extension/client-go/clientset/versioned/scheme"
)

// InferencePoolsGetter has a method to return a InferencePoolInterface.
// A group's client should implement this interface.
type InferencePoolsGetter interface {
	InferencePools(namespace string) InferencePoolInterface
}

// InferencePoolInterface has methods to work with InferencePool resources.
type InferencePoolInterface interface {
	Create(ctx context.Context, inferencePool *apiv1.InferencePool, opts metav1.CreateOptions) (*apiv1.InferencePool, error)
	Update(ctx context.Context, inferencePool *apiv1.InferencePool, opts metav1.UpdateOptions) (*apiv1.InferencePool, error)
	// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
	UpdateStatus(ctx context.Context, inferencePool *apiv1.InferencePool, opts metav1.UpdateOptions) (*apiv1.InferencePool, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*apiv1.InferencePool, error)
	List(ctx context.Context, opts metav1.ListOptions) (*apiv1.InferencePoolList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *apiv1.InferencePool, err error)
	Apply(ctx context.Context, inferencePool *applyconfigurationapiv1.InferencePoolApplyConfiguration, opts metav1.ApplyOptions) (result *apiv1.InferencePool, err error)
	// Add a +genclient:noStatus comment above the type to avoid generating ApplyStatus().
	ApplyStatus(ctx context.Context, inferencePool *applyconfigurationapiv1.InferencePoolApplyConfiguration, opts metav1.ApplyOptions) (result *apiv1.InferencePool, err error)
	InferencePoolExpansion
}

// inferencePools implements InferencePoolInterface
type inferencePools struct {
	*gentype.ClientWithListAndApply[*apiv1.InferencePool, *apiv1.InferencePoolList, *applyconfigurationapiv1.InferencePoolApplyConfiguration]
}

// newInferencePools returns a InferencePools
func newInferencePools(c *InferenceV1Client, namespace string) *inferencePools {
	return &inferencePools{
		gentype.NewClientWithListAndApply[*apiv1.InferencePool, *apiv1.InferencePoolList, *applyconfigurationapiv1.InferencePoolApplyConfiguration](
			"inferencepools",
			c.RESTClient(),
			scheme.ParameterCodec,
			namespace,
			func() *apiv1.InferencePool { return &apiv1.InferencePool{} },
			func() *apiv1.InferencePoolList { return &apiv1.InferencePoolList{} },
		),
	}
}
