#ifndef itkKdTreeSwigInterface_h
#define itkKdTreeSwigInterface_h
#include "itkCommand.h"
#include "itkOffset.h"
#include "itkVector.h"
#include "itkCovariantVector.h"
#include "itkContinuousIndex.h"
#include "itkArray.h"
#include "itkFixedArray.h"
#include "itkRGBPixel.h"
#include "itkRGBAPixel.h"
#include "complex"
#include "itkSymmetricSecondRankTensor.h"
#include "itkImage.h"
#include "itkVectorImage.h"
#include "itkVariableLengthVector.h"
#include "itkPoint.h"
#include "itkListSample.h"
#include "itkKdTree.h"

using itkKdTreeLSVF2 = itk::Statistics::KdTree< itk::Statistics::ListSample< itk::Vector< float,2 > > >;
using itkKdTreeLSVF2_Pointer = itk::Statistics::KdTree< itk::Statistics::ListSample< itk::Vector< float,2 > > >::Pointer;
using itkKdTreeLSVF3 = itk::Statistics::KdTree< itk::Statistics::ListSample< itk::Vector< float,3 > > >;
using itkKdTreeLSVF3_Pointer = itk::Statistics::KdTree< itk::Statistics::ListSample< itk::Vector< float,3 > > >::Pointer;
using itkKdTreeLSVF4 = itk::Statistics::KdTree< itk::Statistics::ListSample< itk::Vector< float,4 > > >;
using itkKdTreeLSVF4_Pointer = itk::Statistics::KdTree< itk::Statistics::ListSample< itk::Vector< float,4 > > >::Pointer;
using itkKdTreeNodeLSVF2 = itk::Statistics::KdTreeNode< itk::Statistics::ListSample< itk::Vector< float,2 > > >;
using itkKdTreeNodeLSVF3 = itk::Statistics::KdTreeNode< itk::Statistics::ListSample< itk::Vector< float,3 > > >;
using itkKdTreeNodeLSVF4 = itk::Statistics::KdTreeNode< itk::Statistics::ListSample< itk::Vector< float,4 > > >;


#include "itkKdTreeSwigInterface.h"
#include "itkListSampleSwigInterface.h"
#include "itkArraySwigInterface.h"
#include "ITKCommonBaseSwigInterface.h"
#include "itkVectorSwigInterface.h"
#include "itkEuclideanDistanceMetricSwigInterface.h"
#endif
