
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kwidgetsaddons_python.h"

// main header
#include "kfontchooser_wrapper.h"

// Wrappers providing overrides
#include "kxyselector_wrapper.h"

// Argument includes
#include <QString>
#include <QStringList>
#include <qbytearray.h>
#include <qcolor.h>
#include <qcoreevent.h>
#include <qevent.h>
#include <qfont.h>
#include <qmetaobject.h>
#include <qnamespace.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintdevice.h>
#include <qpoint.h>
#include <qsize.h>
#include <qvariant.h>
#include <qwidget.h>

#include <algorithm>
#include <cctype>
#include <cstring>
#include <iterator>
#include <set>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KFontChooser_Type = nullptr;
static PyTypeObject *Sbk_KFontChooser_TypeF(void)
{
    return _Sbk_KFontChooser_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KFontChooserWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KFontChooserWrapper::KFontChooserWrapper(::QFlags<KFontChooser::DisplayFlag> flags, ::QWidget * parent) : KFontChooser(flags, parent)
{
}

KFontChooserWrapper::KFontChooserWrapper(::QWidget * parent) : KFontChooser(parent)
{
}

void KFontChooserWrapper::actionEvent(::QActionEvent * event)
{
    static const char *funcName = "actionEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KFontChooser_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::actionEvent(event);
    }
    KXYSelectorWrapper::sbk_o_actionEvent("KFontChooser", funcName, gil, pyOverride, event);
}

void KFontChooserWrapper::changeEvent(::QEvent * event)
{
    static const char *funcName = "changeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KFontChooser_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::changeEvent(event);
    }
    KXYSelectorWrapper::sbk_o_changeEvent("KFontChooser", funcName, gil, pyOverride, event);
}

void KFontChooserWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KFontChooser_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KXYSelectorWrapper::sbk_o_childEvent("KFontChooser", funcName, gil, pyOverride, event);
}

void KFontChooserWrapper::closeEvent(::QCloseEvent * event)
{
    static const char *funcName = "closeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KFontChooser_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::closeEvent(event);
    }
    KXYSelectorWrapper::sbk_o_closeEvent("KFontChooser", funcName, gil, pyOverride, event);
}

void KFontChooserWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KFontChooser_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KFontChooser", funcName, gil, pyOverride, signal);
}

void KFontChooserWrapper::contextMenuEvent(::QContextMenuEvent * event)
{
    static const char *funcName = "contextMenuEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KFontChooser_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::contextMenuEvent(event);
    }
    KXYSelectorWrapper::sbk_o_contextMenuEvent("KFontChooser", funcName, gil, pyOverride, event);
}

void KFontChooserWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KFontChooser_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KXYSelectorWrapper::sbk_o_customEvent("KFontChooser", funcName, gil, pyOverride, event);
}

int KFontChooserWrapper::devType() const
{
    static const char *funcName = "devType";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KFontChooser_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::devType();
    }
    return KXYSelectorWrapper::sbk_o_devType("KFontChooser", funcName, gil, pyOverride);
}

void KFontChooserWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KFontChooser_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KFontChooser", funcName, gil, pyOverride, signal);
}

void KFontChooserWrapper::dragEnterEvent(::QDragEnterEvent * event)
{
    static const char *funcName = "dragEnterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KFontChooser_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragEnterEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragEnterEvent("KFontChooser", funcName, gil, pyOverride, event);
}

void KFontChooserWrapper::dragLeaveEvent(::QDragLeaveEvent * event)
{
    static const char *funcName = "dragLeaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KFontChooser_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragLeaveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragLeaveEvent("KFontChooser", funcName, gil, pyOverride, event);
}

void KFontChooserWrapper::dragMoveEvent(::QDragMoveEvent * event)
{
    static const char *funcName = "dragMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KFontChooser_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragMoveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragMoveEvent("KFontChooser", funcName, gil, pyOverride, event);
}

void KFontChooserWrapper::dropEvent(::QDropEvent * event)
{
    static const char *funcName = "dropEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KFontChooser_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dropEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dropEvent("KFontChooser", funcName, gil, pyOverride, event);
}

void KFontChooserWrapper::enterEvent(::QEnterEvent * event)
{
    static const char *funcName = "enterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KFontChooser_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::enterEvent(event);
    }
    KXYSelectorWrapper::sbk_o_enterEvent("KFontChooser", funcName, gil, pyOverride, event);
}

bool KFontChooserWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KFontChooser_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::event(event);
    }
    return KXYSelectorWrapper::sbk_o_event("KFontChooser", funcName, gil, pyOverride, event);
}

bool KFontChooserWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KFontChooser_TypeF(), gil, funcName, m_PyMethodCache[15], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return KXYSelectorWrapper::sbk_o_eventFilter("KFontChooser", funcName, gil, pyOverride, watched, event);
}

void KFontChooserWrapper::focusInEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusInEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KFontChooser_TypeF(), gil, funcName, m_PyMethodCache[16], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusInEvent(event);
    }
    KXYSelectorWrapper::sbk_o_focusInEvent("KFontChooser", funcName, gil, pyOverride, event);
}

bool KFontChooserWrapper::focusNextPrevChild(bool next)
{
    static const char *funcName = "focusNextPrevChild";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KFontChooser_TypeF(), gil, funcName, m_PyMethodCache[17], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusNextPrevChild(next);
    }
    return KXYSelectorWrapper::sbk_o_focusNextPrevChild("KFontChooser", funcName, gil, pyOverride, next);
}

void KFontChooserWrapper::focusOutEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusOutEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KFontChooser_TypeF(), gil, funcName, m_PyMethodCache[18], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusOutEvent(event);
    }
    KXYSelectorWrapper::sbk_o_focusOutEvent("KFontChooser", funcName, gil, pyOverride, event);
}

bool KFontChooserWrapper::hasHeightForWidth() const
{
    static const char *funcName = "hasHeightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KFontChooser_TypeF(), gil, funcName, m_PyMethodCache[19], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hasHeightForWidth();
    }
    return KXYSelectorWrapper::sbk_o_hasHeightForWidth("KFontChooser", funcName, gil, pyOverride);
}

int KFontChooserWrapper::heightForWidth(int arg__1) const
{
    static const char *funcName = "heightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KFontChooser_TypeF(), gil, funcName, m_PyMethodCache[20], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::heightForWidth(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_heightForWidth("KFontChooser", funcName, gil, pyOverride, arg__1);
}

void KFontChooserWrapper::hideEvent(::QHideEvent * event)
{
    static const char *funcName = "hideEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KFontChooser_TypeF(), gil, funcName, m_PyMethodCache[21], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hideEvent(event);
    }
    KXYSelectorWrapper::sbk_o_hideEvent("KFontChooser", funcName, gil, pyOverride, event);
}

void KFontChooserWrapper::initPainter(::QPainter * painter) const
{
    static const char *funcName = "initPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KFontChooser_TypeF(), gil, funcName, m_PyMethodCache[22], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::initPainter(painter);
    }
    KXYSelectorWrapper::sbk_o_drawContents("KFontChooser", funcName, gil, pyOverride, painter);
}

void KFontChooserWrapper::inputMethodEvent(::QInputMethodEvent * event)
{
    static const char *funcName = "inputMethodEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KFontChooser_TypeF(), gil, funcName, m_PyMethodCache[23], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodEvent(event);
    }
    KXYSelectorWrapper::sbk_o_inputMethodEvent("KFontChooser", funcName, gil, pyOverride, event);
}

::QVariant KFontChooserWrapper::inputMethodQuery(::Qt::InputMethodQuery arg__1) const
{
    static const char *funcName = "inputMethodQuery";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KFontChooser_TypeF(), gil, funcName, m_PyMethodCache[24], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodQuery(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_inputMethodQuery("KFontChooser", funcName, gil, pyOverride, arg__1);
}

void KFontChooserWrapper::keyPressEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyPressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KFontChooser_TypeF(), gil, funcName, m_PyMethodCache[25], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::keyPressEvent(event);
    }
    KXYSelectorWrapper::sbk_o_keyPressEvent("KFontChooser", funcName, gil, pyOverride, event);
}

void KFontChooserWrapper::keyReleaseEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KFontChooser_TypeF(), gil, funcName, m_PyMethodCache[26], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::keyReleaseEvent(event);
    }
    KXYSelectorWrapper::sbk_o_keyReleaseEvent("KFontChooser", funcName, gil, pyOverride, event);
}

void KFontChooserWrapper::leaveEvent(::QEvent * event)
{
    static const char *funcName = "leaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KFontChooser_TypeF(), gil, funcName, m_PyMethodCache[27], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::leaveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_leaveEvent("KFontChooser", funcName, gil, pyOverride, event);
}

int KFontChooserWrapper::metric(::QPaintDevice::PaintDeviceMetric arg__1) const
{
    static const char *funcName = "metric";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KFontChooser_TypeF(), gil, funcName, m_PyMethodCache[28], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::metric(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_metric("KFontChooser", funcName, gil, pyOverride, arg__1);
}

::QSize KFontChooserWrapper::minimumSizeHint() const
{
    // This method belongs to a property.
    static const char *funcName = "1:minimumSizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KFontChooser_TypeF(), gil, funcName, m_PyMethodCache[29], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::minimumSizeHint();
    }
    return KXYSelectorWrapper::sbk_o_minimumSizeHint("KFontChooser", funcName, gil, pyOverride);
}

void KFontChooserWrapper::mouseDoubleClickEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseDoubleClickEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KFontChooser_TypeF(), gil, funcName, m_PyMethodCache[30], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseDoubleClickEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseDoubleClickEvent("KFontChooser", funcName, gil, pyOverride, event);
}

void KFontChooserWrapper::mouseMoveEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KFontChooser_TypeF(), gil, funcName, m_PyMethodCache[31], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseMoveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseMoveEvent("KFontChooser", funcName, gil, pyOverride, event);
}

void KFontChooserWrapper::mousePressEvent(::QMouseEvent * event)
{
    static const char *funcName = "mousePressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KFontChooser_TypeF(), gil, funcName, m_PyMethodCache[32], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mousePressEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mousePressEvent("KFontChooser", funcName, gil, pyOverride, event);
}

void KFontChooserWrapper::mouseReleaseEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KFontChooser_TypeF(), gil, funcName, m_PyMethodCache[33], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseReleaseEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseReleaseEvent("KFontChooser", funcName, gil, pyOverride, event);
}

void KFontChooserWrapper::moveEvent(::QMoveEvent * event)
{
    static const char *funcName = "moveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KFontChooser_TypeF(), gil, funcName, m_PyMethodCache[34], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::moveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_moveEvent("KFontChooser", funcName, gil, pyOverride, event);
}

bool KFontChooserWrapper::nativeEvent(const ::QByteArray & eventType, void * message, ::qintptr * result)
{
    static const char *funcName = "nativeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KFontChooser_TypeF(), gil, funcName, m_PyMethodCache[35], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::nativeEvent(eventType, message, result);
    }
    return KXYSelectorWrapper::sbk_o_nativeEvent("KFontChooser", funcName, gil, pyOverride, eventType, message, result);
}

::QPaintEngine * KFontChooserWrapper::paintEngine() const
{
    static const char *funcName = "paintEngine";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KFontChooser_TypeF(), gil, funcName, m_PyMethodCache[36], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEngine();
    }
    return KXYSelectorWrapper::sbk_o_paintEngine("KFontChooser", funcName, gil, pyOverride);
}

void KFontChooserWrapper::paintEvent(::QPaintEvent * event)
{
    static const char *funcName = "paintEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KFontChooser_TypeF(), gil, funcName, m_PyMethodCache[37], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEvent(event);
    }
    KXYSelectorWrapper::sbk_o_paintEvent("KFontChooser", funcName, gil, pyOverride, event);
}

::QPaintDevice * KFontChooserWrapper::redirected(::QPoint * offset) const
{
    static const char *funcName = "redirected";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KFontChooser_TypeF(), gil, funcName, m_PyMethodCache[38], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::redirected(offset);
    }
    return KXYSelectorWrapper::sbk_o_redirected("KFontChooser", funcName, gil, pyOverride, offset);
}

void KFontChooserWrapper::resizeEvent(::QResizeEvent * event)
{
    static const char *funcName = "resizeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KFontChooser_TypeF(), gil, funcName, m_PyMethodCache[39], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::resizeEvent(event);
    }
    KXYSelectorWrapper::sbk_o_resizeEvent("KFontChooser", funcName, gil, pyOverride, event);
}

void KFontChooserWrapper::setVisible(bool visible)
{
    // This method belongs to a property.
    static const char *funcName = "2:setVisible";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KFontChooser_TypeF(), gil, funcName, m_PyMethodCache[40], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::setVisible(visible);
    }
    KXYSelectorWrapper::sbk_o_setVisible("KFontChooser", funcName, gil, pyOverride, visible);
}

::QPainter * KFontChooserWrapper::sharedPainter() const
{
    static const char *funcName = "sharedPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KFontChooser_TypeF(), gil, funcName, m_PyMethodCache[41], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sharedPainter();
    }
    return KXYSelectorWrapper::sbk_o_sharedPainter("KFontChooser", funcName, gil, pyOverride);
}

void KFontChooserWrapper::showEvent(::QShowEvent * event)
{
    static const char *funcName = "showEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KFontChooser_TypeF(), gil, funcName, m_PyMethodCache[42], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::showEvent(event);
    }
    KXYSelectorWrapper::sbk_o_showEvent("KFontChooser", funcName, gil, pyOverride, event);
}

::QSize KFontChooserWrapper::sizeHint() const
{
    static const char *funcName = "sizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KFontChooser_TypeF(), gil, funcName, m_PyMethodCache[43], nameCache));
    if (pyOverride.isNull()) {
        return this->::KFontChooser::sizeHint();
    }
    return KXYSelectorWrapper::sbk_o_minimumSizeHint("KFontChooser", funcName, gil, pyOverride);
}

void KFontChooserWrapper::tabletEvent(::QTabletEvent * event)
{
    static const char *funcName = "tabletEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KFontChooser_TypeF(), gil, funcName, m_PyMethodCache[44], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::tabletEvent(event);
    }
    KXYSelectorWrapper::sbk_o_tabletEvent("KFontChooser", funcName, gil, pyOverride, event);
}

void KFontChooserWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KFontChooser_TypeF(), gil, funcName, m_PyMethodCache[45], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KXYSelectorWrapper::sbk_o_timerEvent("KFontChooser", funcName, gil, pyOverride, event);
}

void KFontChooserWrapper::wheelEvent(::QWheelEvent * event)
{
    static const char *funcName = "wheelEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KFontChooser_TypeF(), gil, funcName, m_PyMethodCache[46], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::wheelEvent(event);
    }
    KXYSelectorWrapper::sbk_o_wheelEvent("KFontChooser", funcName, gil, pyOverride, event);
}

const QMetaObject *KFontChooserWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KFontChooser::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KFontChooserWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KFontChooser::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KFontChooserWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KFontChooserWrapper *>(this));
    }
    return KFontChooser::qt_metacast(_clname);
}

KFontChooserWrapper::~KFontChooserWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KFontChooser_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KFontChooser_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KFontChooser >()))
        return -1;

    KFontChooserWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|OO:KFontChooser", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KFontChooser::KFontChooser(QFlags<KFontChooser::DisplayFlag>,QWidget*=)
    // 1: KFontChooser::KFontChooser(QWidget*=)
    if (numArgs == 0) {
        overloadId = 1; // KFontChooser(QWidget*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))) {
        overloadId = 1; // KFontChooser(QWidget*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KFontChooser_DisplayFlag_IDX])))->flagsConverter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // KFontChooser(QFlags<KFontChooser::DisplayFlag>,QWidget*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[1])))) {
            overloadId = 0; // KFontChooser(QFlags<KFontChooser::DisplayFlag>,QWidget*)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KFontChooser_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKWidgetsAddonsTypeStructs[SBK_KFontChooser_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    switch (overloadId) {
        case 0: // KFontChooser(QFlags<KFontChooser::DisplayFlag> flags, QWidget *parent)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 1}};
                if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[1]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KFontChooser_IDX]);
                }
            }
            ::QFlags<KFontChooser::DisplayFlag> cppArg0 = QFlags<KFontChooser::DisplayFlag>(0);
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QWidget *cppArg1 = nullptr;
            if (pythonToCpp[1])
                pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KFontChooser(QFlags<KFontChooser::DisplayFlag>,QWidget*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) KFontChooserWrapper(cppArg0, cppArg1);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new KFontChooserWrapper(cppArg0, cppArg1);
                }

            }
            break;
        }
        case 1: // KFontChooser(QWidget *parent)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
                if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KFontChooser_IDX]);
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QWidget *cppArg0 = nullptr;
            if (pythonToCpp[0])
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KFontChooser(QWidget*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) KFontChooserWrapper(cppArg0);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new KFontChooserWrapper(cppArg0);
                }

            }
            break;
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KFontChooser >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KFontChooser_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KFontChooser_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KFontChooserFunc_backgroundColor(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KFontChooser *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KFontChooser_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // backgroundColor()const
        QColor cppResult = const_cast<const ::KFontChooser *>(cppSelf)->backgroundColor();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QColor_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KFontChooserFunc_color(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KFontChooser *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KFontChooser_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // color()const
        QColor cppResult = const_cast<const ::KFontChooser *>(cppSelf)->color();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QColor_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KFontChooserFunc_createFontList(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static KFontChooser::createFontList(uint)->QStringList
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArg)))) {
        overloadId = 0; // createFontList(uint)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "createFontList", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KFontChooser_IDX]);

    // Call function/method
    {
        uint cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // createFontList(uint)
            QStringList cppResult = ::KFontChooser::createFontList(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KFontChooserFunc_enableColumn(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KFontChooser *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KFontChooser_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "enableColumn", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KFontChooser::enableColumn(int,bool)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
        overloadId = 0; // enableColumn(int,bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "enableColumn", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KFontChooser_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        bool cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // enableColumn(int,bool)
            cppSelf->enableColumn(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KFontChooserFunc_font(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KFontChooser *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KFontChooser_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // font()const
        QFont cppResult = const_cast<const ::KFontChooser *>(cppSelf)->font();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QFont_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KFontChooserFunc_fontDiffFlags(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KFontChooser *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KFontChooser_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // fontDiffFlags()const
        QFlags<KFontChooser::FontDiff> cppResult = const_cast<const ::KFontChooser *>(cppSelf)->fontDiffFlags();
        pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KFontChooser_FontDiff_IDX])))->flagsConverter, &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KFontChooserFunc_sampleText(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KFontChooser *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KFontChooser_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // sampleText()const
        QString cppResult = const_cast<const ::KFontChooser *>(cppSelf)->sampleText();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KFontChooserFunc_setBackgroundColor(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KFontChooser *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KFontChooser_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KFontChooser::setBackgroundColor(QColor)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QColor_IDX]), (pyArg)))) {
        overloadId = 0; // setBackgroundColor(QColor)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setBackgroundColor", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KFontChooser_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QColor cppArg0_local;
        ::QColor *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // setBackgroundColor(QColor)
            cppSelf->setBackgroundColor(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KFontChooserFunc_setColor(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KFontChooser *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KFontChooser_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KFontChooser::setColor(QColor)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QColor_IDX]), (pyArg)))) {
        overloadId = 0; // setColor(QColor)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setColor", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KFontChooser_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QColor cppArg0_local;
        ::QColor *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // setColor(QColor)
            cppSelf->setColor(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KFontChooserFunc_setFont(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KFontChooser *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KFontChooser_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 2));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "setFont", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KFontChooser_IDX]);

    if (PyArg_ParseTuple(args, "|OO:setFont", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KFontChooser::setFont(QFont,bool=)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QFont_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setFont(QFont,bool)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
            overloadId = 0; // setFont(QFont,bool)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setFont", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KFontChooser_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"onlyFixed", 1}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "setFont", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KFontChooser_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QFont cppArg0_local;
        ::QFont *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0].isValue())
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        bool cppArg1 = false;
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setFont(QFont,bool)
            cppSelf->setFont(*cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KFontChooserFunc_setFontListItems(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KFontChooser *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KFontChooser_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KFontChooser::setFontListItems(QStringList)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], (pyArg)))) {
        overloadId = 0; // setFontListItems(QStringList)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setFontListItems", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KFontChooser_IDX]);

    // Call function/method
    {
        ::QStringList cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setFontListItems(QStringList)
            cppSelf->setFontListItems(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KFontChooserFunc_setMinVisibleItems(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KFontChooser *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KFontChooser_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KFontChooser::setMinVisibleItems(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setMinVisibleItems(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setMinVisibleItems", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KFontChooser_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setMinVisibleItems(int)
            cppSelf->setMinVisibleItems(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KFontChooserFunc_setSampleBoxVisible(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KFontChooser *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KFontChooser_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KFontChooser::setSampleBoxVisible(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setSampleBoxVisible(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setSampleBoxVisible", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KFontChooser_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setSampleBoxVisible(bool)
            cppSelf->setSampleBoxVisible(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KFontChooserFunc_setSampleText(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KFontChooser *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KFontChooser_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KFontChooser::setSampleText(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setSampleText(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setSampleText", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KFontChooser_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setSampleText(QString)
            cppSelf->setSampleText(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KFontChooserFunc_sizeHint(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KFontChooser *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KFontChooser_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // sizeHint()const
        QSize cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
            ? const_cast<const ::KFontChooser *>(cppSelf)->::KFontChooser::sizeHint()
            : const_cast<const ::KFontChooser *>(cppSelf)->sizeHint();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QSize_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KFontChooser_PropertyStrings[] = {
    "backgroundColor::",
    "color::",
    "font::",
    "sampleText::",
    nullptr // Sentinel
};

static const char *Sbk_KFontChooser_EnumFlagInfo[] = {
    "DisplayFlag:IntFlag:DisplayFlags",
    "FontColumn:IntEnum",
    "FontDiff:IntFlag:FontDiffFlags",
    "FontListCriteria:IntEnum",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KFontChooser_methods[] = {
    {"backgroundColor", reinterpret_cast<PyCFunction>(Sbk_KFontChooserFunc_backgroundColor), METH_NOARGS, nullptr},
    {"color", reinterpret_cast<PyCFunction>(Sbk_KFontChooserFunc_color), METH_NOARGS, nullptr},
    {"createFontList", reinterpret_cast<PyCFunction>(Sbk_KFontChooserFunc_createFontList), METH_O|METH_STATIC, nullptr},
    {"enableColumn", reinterpret_cast<PyCFunction>(Sbk_KFontChooserFunc_enableColumn), METH_VARARGS, nullptr},
    {"font", reinterpret_cast<PyCFunction>(Sbk_KFontChooserFunc_font), METH_NOARGS, nullptr},
    {"fontDiffFlags", reinterpret_cast<PyCFunction>(Sbk_KFontChooserFunc_fontDiffFlags), METH_NOARGS, nullptr},
    {"sampleText", reinterpret_cast<PyCFunction>(Sbk_KFontChooserFunc_sampleText), METH_NOARGS, nullptr},
    {"setBackgroundColor", reinterpret_cast<PyCFunction>(Sbk_KFontChooserFunc_setBackgroundColor), METH_O, nullptr},
    {"setColor", reinterpret_cast<PyCFunction>(Sbk_KFontChooserFunc_setColor), METH_O, nullptr},
    {"setFont", reinterpret_cast<PyCFunction>(Sbk_KFontChooserFunc_setFont), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"setFontListItems", reinterpret_cast<PyCFunction>(Sbk_KFontChooserFunc_setFontListItems), METH_O, nullptr},
    {"setMinVisibleItems", reinterpret_cast<PyCFunction>(Sbk_KFontChooserFunc_setMinVisibleItems), METH_O, nullptr},
    {"setSampleBoxVisible", reinterpret_cast<PyCFunction>(Sbk_KFontChooserFunc_setSampleBoxVisible), METH_O, nullptr},
    {"setSampleText", reinterpret_cast<PyCFunction>(Sbk_KFontChooserFunc_setSampleText), METH_O, nullptr},
    {"sizeHint", reinterpret_cast<PyCFunction>(Sbk_KFontChooserFunc_sizeHint), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KFontChooser_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KFontChooser *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KFontChooser_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KFontChooserWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KFontChooser_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KFontChooser_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}
static void * Sbk_KFontChooserSpecialCastFunction(void *obj, PyTypeObject *desiredType)
{
    auto me = reinterpret_cast< ::KFontChooser *>(obj);
    if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))
        return static_cast< ::QWidget *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintDevice_IDX]))
        return static_cast< ::QPaintDevice *>(me);
    return me;
}



// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KFontChooser_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KFontChooser_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KFontChooser_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KFontChooser_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KFontChooser_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KFontChooser_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KFontChooser_spec = {
    "1:KWidgetsAddons.KFontChooser",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KFontChooser_slots
};

} //extern "C"

static void *Sbk_KFontChooser_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QWidget >())
        return dynamic_cast< ::KFontChooser *>(reinterpret_cast< ::QWidget *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KFontChooser *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QPaintDevice >())
        return dynamic_cast< ::KFontChooser *>(reinterpret_cast< ::QPaintDevice *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void Enum_PythonToCpp_KFontChooser_FontColumn(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KFontChooser::FontColumn>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KFontChooser::FontColumn *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KFontChooser_FontColumn_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KFontChooser_FontColumn_IDX])))
        return Enum_PythonToCpp_KFontChooser_FontColumn;
    return {};
}

static PyObject *KFontChooser_FontColumn_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KFontChooser::FontColumn>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KFontChooser::FontColumn *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

static void Enum_PythonToCpp_KFontChooser_FontDiff(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KFontChooser::FontDiff>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KFontChooser::FontDiff *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KFontChooser_FontDiff_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KFontChooser_FontDiff_IDX])))
        return Enum_PythonToCpp_KFontChooser_FontDiff;
    return {};
}

static PyObject *KFontChooser_FontDiff_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KFontChooser::FontDiff>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KFontChooser::FontDiff *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

static void Flag_PythonToCpp_KFontChooser_FontDiff(PyObject *pyIn, void *cppOut)
{
    const auto value = QFlags<::KFontChooser::FontDiff>::fromInt(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<QFlags<::KFontChooser::FontDiff> *>(cppOut) = value;

}

static PyObject *KFontChooser_FontDiff_CppToPython_Flag(const void *cppIn)
{
    const auto flags = *reinterpret_cast<const QFlags<::KFontChooser::FontDiff> *>(cppIn);
    return Shiboken::Enum::newItem(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KFontChooser_FontDiff_IDX]), flags.toInt());

}

static void Enum_PythonToCpp_KFontChooser_DisplayFlag(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KFontChooser::DisplayFlag>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KFontChooser::DisplayFlag *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KFontChooser_DisplayFlag_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KFontChooser_DisplayFlag_IDX])))
        return Enum_PythonToCpp_KFontChooser_DisplayFlag;
    return {};
}

static PyObject *KFontChooser_DisplayFlag_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KFontChooser::DisplayFlag>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KFontChooser::DisplayFlag *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

static void Flag_PythonToCpp_KFontChooser_DisplayFlag(PyObject *pyIn, void *cppOut)
{
    const auto value = QFlags<::KFontChooser::DisplayFlag>::fromInt(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<QFlags<::KFontChooser::DisplayFlag> *>(cppOut) = value;

}

static PyObject *KFontChooser_DisplayFlag_CppToPython_Flag(const void *cppIn)
{
    const auto flags = *reinterpret_cast<const QFlags<::KFontChooser::DisplayFlag> *>(cppIn);
    return Shiboken::Enum::newItem(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KFontChooser_DisplayFlag_IDX]), flags.toInt());

}

static void Enum_PythonToCpp_KFontChooser_FontListCriteria(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KFontChooser::FontListCriteria>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KFontChooser::FontListCriteria *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KFontChooser_FontListCriteria_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KFontChooser_FontListCriteria_IDX])))
        return Enum_PythonToCpp_KFontChooser_FontListCriteria;
    return {};
}

static PyObject *KFontChooser_FontListCriteria_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KFontChooser::FontListCriteria>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KFontChooser::FontListCriteria *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KFontChooser_PythonToCpp_KFontChooser_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KFontChooser_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KFontChooser_PythonToCpp_KFontChooser_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KFontChooser_TypeF()))
        return KFontChooser_PythonToCpp_KFontChooser_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KFontChooser_PTR_CppToPython_KFontChooser(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KFontChooser *>(const_cast<void *>(cppIn)), Sbk_KFontChooser_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KFontChooser_SignatureStrings[] = {
    "1:KWidgetsAddons.KFontChooser(self,flags:KWidgetsAddons.KFontChooser.DisplayFlag,parent:PySide6.QtWidgets.QWidget=nullptr,*:KeywordOnly=None,font:QFont=None,color:QColor=None,backgroundColor:QColor=None,sampleText:QString=None)",
    "0:KWidgetsAddons.KFontChooser(self,parent:PySide6.QtWidgets.QWidget=nullptr,*:KeywordOnly=None,font:QFont=None,color:QColor=None,backgroundColor:QColor=None,sampleText:QString=None)",
    "KWidgetsAddons.KFontChooser.backgroundColor(self)->PySide6.QtGui.QColor",
    "KWidgetsAddons.KFontChooser.color(self)->PySide6.QtGui.QColor",
    "KWidgetsAddons.KFontChooser.createFontList(fontListCriteria:uint)->QStringList",
    "KWidgetsAddons.KFontChooser.enableColumn(self,column:int,state:bool)",
    "KWidgetsAddons.KFontChooser.font(self)->PySide6.QtGui.QFont",
    "KWidgetsAddons.KFontChooser.fontDiffFlags(self)->KWidgetsAddons.KFontChooser.FontDiff",
    "KWidgetsAddons.KFontChooser.sampleText(self)->QString",
    "KWidgetsAddons.KFontChooser.setBackgroundColor(self,col:typing.Union[PySide6.QtGui.QColor, QLatin1String, PySide6.QtGui.QRgba64, QVariant, PySide6.QtCore.Qt.GlobalColor, QString, unsigned int])",
    "KWidgetsAddons.KFontChooser.setColor(self,col:typing.Union[PySide6.QtGui.QColor, QLatin1String, PySide6.QtGui.QRgba64, QVariant, PySide6.QtCore.Qt.GlobalColor, QString, unsigned int])",
    "KWidgetsAddons.KFontChooser.setFont(self,font:typing.Union[PySide6.QtGui.QFont, QString, QStringList],onlyFixed:bool=false)",
    "KWidgetsAddons.KFontChooser.setFontListItems(self,fontList:QStringList)",
    "KWidgetsAddons.KFontChooser.setMinVisibleItems(self,visibleItems:int)",
    "KWidgetsAddons.KFontChooser.setSampleBoxVisible(self,visible:bool)",
    "KWidgetsAddons.KFontChooser.setSampleText(self,text:QString)",
    "KWidgetsAddons.KFontChooser.sizeHint(self)->PySide6.QtCore.QSize",
    nullptr}; // Sentinel
#else
static constexpr size_t KFontChooser_SignatureByteSize = 454;
static constexpr uint8_t KFontChooser_SignatureBytes[454] = {
    0x78, 0xda, 0xd5, 0x94, 0x4b, 0x4f, 0xdc, 0x30, 0x10, 0x80, 0xef, 0xfc, 0x8a, 0x3d, 0xb2, 0x95,
    0x89, 0x8a, 0x54, 0x71, 0xb0, 0xb4, 0x48, 0x25, 0x28, 0xb4, 0x5a, 0xda, 0x12, 0x96, 0xd2, 0x43,
    0xc5, 0xc1, 0xd9, 0x4c, 0xd2, 0x51, 0xbd, 0xe3, 0xc8, 0x76, 0x60, 0xc3, 0xaf, 0xc7, 0xce, 0x83,
    0x4d, 0xe9, 0xd6, 0x41, 0xea, 0xa5, 0x3d, 0xc5, 0x19, 0xcf, 0x7c, 0xf3, 0xf6, 0x31, 0x5f, 0x7e,
    0xc3, 0xbc, 0x04, 0x6b, 0xde, 0xe7, 0xb9, 0x22, 0x13, 0x2d, 0x13, 0x45, 0x36, 0xfe, 0xa1, 0x94,
    0x01, 0x7d, 0x68, 0x40, 0x16, 0xac, 0x90, 0xa2, 0x34, 0x21, 0xb5, 0xe8, 0x1c, 0x4d, 0x25, 0x45,
    0x93, 0x38, 0x45, 0x56, 0x09, 0x0d, 0x64, 0xf9, 0x55, 0xb3, 0xc2, 0x1c, 0x4e, 0xa2, 0xd4, 0xf6,
    0x76, 0x51, 0xda, 0x1d, 0x16, 0x54, 0x4b, 0x59, 0x59, 0xcd, 0xde, 0xf0, 0x25, 0x34, 0x0f, 0x4a,
    0xe7, 0x5f, 0x48, 0x36, 0x8b, 0xcf, 0x8a, 0x80, 0x15, 0x8e, 0xc9, 0x53, 0x4f, 0xee, 0xfe, 0xd7,
    0x4a, 0x2a, 0xcd, 0xd3, 0xd8, 0x7f, 0x3a, 0x49, 0x26, 0xd6, 0x3f, 0x4b, 0xad, 0x6a, 0xca, 0xe3,
    0xdf, 0xee, 0x8c, 0xd8, 0x54, 0x12, 0x6e, 0x60, 0xeb, 0x18, 0x2b, 0xab, 0x91, 0xca, 0x56, 0x3e,
    0x3f, 0x78, 0x3b, 0x9d, 0xe3, 0x3f, 0x18, 0x75, 0xa8, 0xe0, 0x2f, 0x80, 0x6d, 0x0e, 0xf3, 0xa3,
    0xd3, 0x5d, 0xf8, 0x17, 0x35, 0x46, 0x9d, 0x97, 0x20, 0x67, 0xfd, 0x77, 0xd6, 0x1a, 0x84, 0x05,
    0x2f, 0xb9, 0x44, 0x63, 0x0f, 0x8b, 0xfe, 0x10, 0x6b, 0xb4, 0xa0, 0x51, 0xf0, 0x1a, 0xc9, 0x3a,
    0x6e, 0x9f, 0x96, 0xbf, 0x0a, 0xe2, 0x80, 0x44, 0x26, 0xc1, 0xb9, 0xad, 0x37, 0xd4, 0x75, 0x65,
    0xdd, 0x9e, 0xb9, 0xc3, 0x30, 0x63, 0x9d, 0x2b, 0x9e, 0x29, 0x25, 0xc3, 0x95, 0xf1, 0x41, 0xfc,
    0x21, 0x21, 0xaf, 0x36, 0x69, 0x7b, 0x8e, 0x45, 0xe1, 0xe7, 0xd8, 0x0c, 0x90, 0x90, 0x41, 0xd2,
    0x1b, 0x04, 0xa9, 0xbb, 0x06, 0x0f, 0xc8, 0xbe, 0x20, 0x61, 0x2b, 0xb0, 0x67, 0x7b, 0x9a, 0xec,
    0x4b, 0xc2, 0x6d, 0x53, 0x39, 0xf3, 0xe8, 0x2b, 0xa1, 0xa2, 0xef, 0xfb, 0xba, 0xc6, 0x66, 0xe9,
    0xa5, 0xb0, 0x48, 0xc7, 0x9d, 0x23, 0x36, 0x7b, 0xa1, 0x74, 0x5d, 0x66, 0xe2, 0xe4, 0x9d, 0xd3,
    0xba, 0x15, 0xae, 0x4f, 0xae, 0xba, 0x23, 0x85, 0x58, 0x69, 0x70, 0x9f, 0xe8, 0x42, 0xaa, 0x4c,
    0xc8, 0x01, 0x37, 0x80, 0x6a, 0x32, 0x58, 0x12, 0xe4, 0x33, 0xd7, 0x93, 0xbb, 0xf9, 0x54, 0x06,
    0xff, 0x6b, 0xdc, 0xc9, 0x30, 0x44, 0xdd, 0x6e, 0x87, 0xe2, 0xf6, 0xaa, 0x23, 0x3f, 0xa3, 0x59,
    0xbf, 0x63, 0xca, 0x3d, 0x11, 0x09, 0x6e, 0x21, 0x6f, 0xe7, 0x76, 0x51, 0x08, 0x69, 0xe0, 0x55,
    0xbe, 0xbd, 0xf9, 0x47, 0x0b, 0x1b, 0xb3, 0x0b, 0xc2, 0x8b, 0xf8, 0x88, 0x3e, 0xc9, 0xf9, 0x84,
    0x74, 0x8b, 0x06, 0xdd, 0x46, 0x8d, 0x48, 0xf7, 0x23, 0x89, 0x5f, 0xab, 0x49, 0xca, 0xaa, 0x1d,
    0xde, 0x33, 0xb5, 0xed, 0x59, 0xbf, 0x60, 0x5e, 0xb1, 0x8e, 0xcf, 0x88, 0xe7, 0xf9, 0x67, 0x76,
    0xf4, 0xd4, 0x4d, 0x18, 0xe3, 0x23, 0x7c, 0xc0, 0x7d, 0xfb, 0xdc, 0x35, 0x7b, 0xe5, 0xee, 0x0f,
    0x9e, 0x00, 0x5e, 0x7b, 0x79, 0xfc
};
#endif

PyTypeObject *init_KFontChooser(PyObject *module)
{
    if (SbkKWidgetsAddonsTypeStructs[SBK_KFontChooser_IDX].type != nullptr)
        return SbkKWidgetsAddonsTypeStructs[SBK_KFontChooser_IDX].type;

    Shiboken::AutoDecRef Sbk_KFontChooser_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))));

    _Sbk_KFontChooser_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KFontChooser",
        "KFontChooser*",
        &Sbk_KFontChooser_spec,
        &Shiboken::callCppDestructor< KFontChooser >,
        Sbk_KFontChooser_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::DeleteInMainThread);
    auto *pyType = Sbk_KFontChooser_TypeF(); // references _Sbk_KFontChooser_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KFontChooser_SignatureStrings);
#else
    InitSignatureBytes(pyType, KFontChooser_SignatureBytes, KFontChooser_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KFontChooser_PropertyStrings);
    SbkKWidgetsAddonsTypeStructs[SBK_KFontChooser_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KFontChooser_PythonToCpp_KFontChooser_PTR,
        is_KFontChooser_PythonToCpp_KFontChooser_PTR_Convertible,
        KFontChooser_PTR_CppToPython_KFontChooser);

    Shiboken::Conversions::registerConverterName(converter, "KFontChooser");
    Shiboken::Conversions::registerConverterName(converter, "KFontChooser*");
    Shiboken::Conversions::registerConverterName(converter, "KFontChooser&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KFontChooser).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KFontChooserWrapper).name());

    MultipleInheritanceInitFunction func = Shiboken::ObjectType::getMultipleInheritanceFunction(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]));
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_KFontChooser_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_KFontChooser_TypeF(), &Sbk_KFontChooserSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KFontChooser_TypeF(), &Sbk_KFontChooser_typeDiscovery);

    // Pass the ..._EnumFlagInfo to the class.
    SbkObjectType_SetEnumFlagInfo(pyType, Sbk_KFontChooser_EnumFlagInfo);

    // Initialization of enums.
    Shiboken::AutoDecRef tpDict{};
    PyTypeObject *EType{};

    // Initialization of enum 'FontColumn'.
    const char *FontColumn_Initializer[] = {
        "FamilyList",
        "StyleList",
        "SizeList",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t FontColumn_InitializerValues[] = {
        uint8_t(KFontChooser::FontColumn::FamilyList), //  0x01  1
        uint8_t(KFontChooser::FontColumn::StyleList),  //  0x02  2
        uint8_t(KFontChooser::FontColumn::SizeList)    //  0x04  4
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KFontChooser_TypeF(),
        "1:KWidgetsAddons.KFontChooser.FontColumn",
        FontColumn_Initializer, FontColumn_InitializerValues);
    SbkKWidgetsAddonsTypeStructs[SBK_KFontChooser_FontColumn_IDX].type = EType;
    // Register converter for enum 'KFontChooser::FontColumn'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KFontChooser_FontColumn_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KFontChooser_FontColumn,
            is_Enum_PythonToCpp_KFontChooser_FontColumn_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KFontChooser::FontColumn");
        Shiboken::Conversions::registerConverterAlias(converter, "FontColumn");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'FontColumn' enum.

    // Initialization of enum 'FontDiff'.
    const char *FontDiff_Initializer[] = {
        "NoFontDiffFlags",
        "FontDiffFamily",
        "FontDiffStyle",
        "FontDiffSize",
        "AllFontDiffs",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t FontDiff_InitializerValues[] = {
        uint8_t(KFontChooser::FontDiff::NoFontDiffFlags), //  0x00  0
        uint8_t(KFontChooser::FontDiff::FontDiffFamily),  //  0x01  1
        uint8_t(KFontChooser::FontDiff::FontDiffStyle),   //  0x02  2
        uint8_t(KFontChooser::FontDiff::FontDiffSize),    //  0x04  4
        uint8_t(KFontChooser::FontDiff::AllFontDiffs)     //  0x07  7
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KFontChooser_TypeF(),
        "1:KWidgetsAddons.KFontChooser.FontDiff",
        FontDiff_Initializer, FontDiff_InitializerValues);
    SbkKWidgetsAddonsTypeStructs[SBK_KFontChooser_FontDiff_IDX].type = EType;
    // PYSIDE-1735: Mapping the flags class to the same enum class.
    SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KFontChooser_FontDiff_IDX].type =
        EType;
    // Register converter for enum 'KFontChooser::FontDiff'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KFontChooser_FontDiff_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KFontChooser_FontDiff,
            is_Enum_PythonToCpp_KFontChooser_FontDiff_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KFontChooser::FontDiff");
        Shiboken::Conversions::registerConverterAlias(converter, "FontDiff");
        SbkConverter *flagsConverter = Shiboken::Conversions::createConverter(EType,
            KFontChooser_FontDiff_CppToPython_Flag);
        Shiboken::Conversions::addPythonToCppValueConversion(flagsConverter,
            Flag_PythonToCpp_KFontChooser_FontDiff,
            is_Enum_PythonToCpp_KFontChooser_FontDiff_Convertible);
        // Register converter for flag 'QFlags<KFontChooser::FontDiff>'.
        Shiboken::Conversions::registerConverterName(flagsConverter, "QFlags<KFontChooser::FontDiff>");
        Shiboken::Conversions::registerConverterName(flagsConverter, "KFontChooser::FontDiffFlags");
        Shiboken::Enum::setTypeConverter(EType, converter, flagsConverter);
    }
    // End of 'FontDiff' enum/flags.

    // Initialization of enum 'DisplayFlag'.
    const char *DisplayFlag_Initializer[] = {
        "NoDisplayFlags",
        "FixedFontsOnly",
        "DisplayFrame",
        "ShowDifferences",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t DisplayFlag_InitializerValues[] = {
        uint8_t(KFontChooser::DisplayFlag::NoDisplayFlags), //  0x00  0
        uint8_t(KFontChooser::DisplayFlag::FixedFontsOnly), //  0x01  1
        uint8_t(KFontChooser::DisplayFlag::DisplayFrame),   //  0x02  2
        uint8_t(KFontChooser::DisplayFlag::ShowDifferences) //  0x04  4
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KFontChooser_TypeF(),
        "1:KWidgetsAddons.KFontChooser.DisplayFlag",
        DisplayFlag_Initializer, DisplayFlag_InitializerValues);
    SbkKWidgetsAddonsTypeStructs[SBK_KFontChooser_DisplayFlag_IDX].type = EType;
    // PYSIDE-1735: Mapping the flags class to the same enum class.
    SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KFontChooser_DisplayFlag_IDX].type =
        EType;
    // Register converter for enum 'KFontChooser::DisplayFlag'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KFontChooser_DisplayFlag_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KFontChooser_DisplayFlag,
            is_Enum_PythonToCpp_KFontChooser_DisplayFlag_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KFontChooser::DisplayFlag");
        Shiboken::Conversions::registerConverterAlias(converter, "DisplayFlag");
        SbkConverter *flagsConverter = Shiboken::Conversions::createConverter(EType,
            KFontChooser_DisplayFlag_CppToPython_Flag);
        Shiboken::Conversions::addPythonToCppValueConversion(flagsConverter,
            Flag_PythonToCpp_KFontChooser_DisplayFlag,
            is_Enum_PythonToCpp_KFontChooser_DisplayFlag_Convertible);
        // Register converter for flag 'QFlags<KFontChooser::DisplayFlag>'.
        Shiboken::Conversions::registerConverterName(flagsConverter, "QFlags<KFontChooser::DisplayFlag>");
        Shiboken::Conversions::registerConverterName(flagsConverter, "KFontChooser::DisplayFlags");
        Shiboken::Enum::setTypeConverter(EType, converter, flagsConverter);
    }
    // End of 'DisplayFlag' enum/flags.

    // Initialization of enum 'FontListCriteria'.
    const char *FontListCriteria_Initializer[] = {
        "FixedWidthFonts",
        "ScalableFonts",
        "SmoothScalableFonts",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t FontListCriteria_InitializerValues[] = {
        uint8_t(KFontChooser::FontListCriteria::FixedWidthFonts),    //  0x01  1
        uint8_t(KFontChooser::FontListCriteria::ScalableFonts),      //  0x02  2
        uint8_t(KFontChooser::FontListCriteria::SmoothScalableFonts) //  0x04  4
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KFontChooser_TypeF(),
        "1:KWidgetsAddons.KFontChooser.FontListCriteria",
        FontListCriteria_Initializer, FontListCriteria_InitializerValues);
    SbkKWidgetsAddonsTypeStructs[SBK_KFontChooser_FontListCriteria_IDX].type = EType;
    // Register converter for enum 'KFontChooser::FontListCriteria'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KFontChooser_FontListCriteria_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KFontChooser_FontListCriteria,
            is_Enum_PythonToCpp_KFontChooser_FontListCriteria_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KFontChooser::FontListCriteria");
        Shiboken::Conversions::registerConverterAlias(converter, "FontListCriteria");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'FontListCriteria' enum.

    PySide::Signal::registerSignals(pyType, &::KFontChooser::staticMetaObject);
    qRegisterMetaType< ::KFontChooser::FontColumn >("KFontChooser::FontColumn");
    qRegisterMetaType< ::KFontChooser::FontDiff >("KFontChooser::FontDiff");
    qRegisterMetaType< ::KFontChooser::DisplayFlag >("KFontChooser::DisplayFlag");
    qRegisterMetaType< ::KFontChooser::FontListCriteria >("KFontChooser::FontListCriteria");
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KFontChooser::staticMetaObject, sizeof(KFontChooserWrapper));

    return pyType;
}
