/* dialog.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from dialog.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright © 2014 Nikhar Agrawal
 *
 * This file is part of libgnome-games-support.
 *
 * libgnome-games-support is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * libgnome-games-support is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with libgnome-games-support.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include "libgnome-games-support.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <pango/pango.h>
#include <glib/gi18n-lib.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define GAMES_SCORES_TYPE_DIALOG (games_scores_dialog_get_type ())
#define GAMES_SCORES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_SCORES_TYPE_DIALOG, GamesScoresDialog))
#define GAMES_SCORES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_SCORES_TYPE_DIALOG, GamesScoresDialogClass))
#define GAMES_SCORES_IS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_SCORES_TYPE_DIALOG))
#define GAMES_SCORES_IS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_SCORES_TYPE_DIALOG))
#define GAMES_SCORES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_SCORES_TYPE_DIALOG, GamesScoresDialogClass))

typedef struct _GamesScoresDialog GamesScoresDialog;
typedef struct _GamesScoresDialogClass GamesScoresDialogClass;
typedef struct _GamesScoresDialogPrivate GamesScoresDialogPrivate;
enum  {
	GAMES_SCORES_DIALOG_0_PROPERTY,
	GAMES_SCORES_DIALOG_NUM_PROPERTIES
};
static GParamSpec* games_scores_dialog_properties[GAMES_SCORES_DIALOG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block5Data Block5Data;
typedef struct _Block6Data Block6Data;

struct _GamesScoresDialog {
	GtkDialog parent_instance;
	GamesScoresDialogPrivate * priv;
};

struct _GamesScoresDialogClass {
	GtkDialogClass parent_class;
};

struct _GamesScoresDialogPrivate {
	GamesScoresContext* context;
	GamesScoresCategory* active_category;
	gint rows_to_display;
	GtkComboBoxText* combo;
	GtkLabel* category_label;
	GtkHeaderBar* headerbar;
	GtkGrid* grid;
	GtkLabel* window_title;
	GtkLabel* window_subtitle;
	GamesScoresStyle scores_style;
	GamesScoresScore* new_high_score;
	GamesScoresCategory* scores_active_category;
};

struct _Block5Data {
	int _ref_count_;
	GamesScoresDialog* self;
	GamesScoresScore* score;
};

struct _Block6Data {
	int _ref_count_;
	Block5Data * _data5_;
	GtkEntry* entry;
};

static gint GamesScoresDialog_private_offset;
static gpointer games_scores_dialog_parent_class = NULL;

VALA_EXTERN GType games_scores_dialog_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GamesScoresDialog* games_scores_dialog_new (GamesScoresContext* context,
                                            const gchar* category_type,
                                            GamesScoresStyle style,
                                            GamesScoresScore* new_high_score,
                                            GamesScoresCategory* current_cat,
                                            GtkWindow* window,
                                            const gchar* icon_name);
VALA_EXTERN GamesScoresDialog* games_scores_dialog_construct (GType object_type,
                                                  GamesScoresContext* context,
                                                  const gchar* category_type,
                                                  GamesScoresStyle style,
                                                  GamesScoresScore* new_high_score,
                                                  GamesScoresCategory* current_cat,
                                                  GtkWindow* window,
                                                  const gchar* icon_name);
VALA_EXTERN GList* games_scores_context_get_categories (GamesScoresContext* self);
static void games_scores_dialog_load_scores (GamesScoresDialog* self);
static void _games_scores_dialog_load_scores_gtk_combo_box_changed (GtkComboBox* _sender,
                                                             gpointer self);
static void games_scores_dialog_fill_grid_with_labels (GamesScoresDialog* self);
static void games_scores_dialog_load_categories (GamesScoresDialog* self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void __lambda10_ (GamesScoresDialog* self,
                  GamesScoresCategory* x);
static void ___lambda10__gfunc (gconstpointer data,
                         gpointer self);
static void games_scores_dialog_display_single_score (GamesScoresDialog* self,
                                               GamesScoresScore* score,
                                               gint row_count,
                                               guint no_scores);
static void games_scores_dialog_make_remaining_labels_empty (GamesScoresDialog* self,
                                                      gint row_count);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void ___lambda9_ (Block6Data* _data6_);
VALA_EXTERN void games_scores_context_update_score_name (GamesScoresContext* self,
                                             GamesScoresScore* old_score,
                                             GamesScoresCategory* category,
                                             const gchar* new_name);
static void ____lambda9__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void games_scores_dialog_finalize (GObject * obj);
static GType games_scores_dialog_get_type_once (void);

static inline gpointer
games_scores_dialog_get_instance_private (GamesScoresDialog* self)
{
	return G_STRUCT_MEMBER_P (self, GamesScoresDialog_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_games_scores_dialog_load_scores_gtk_combo_box_changed (GtkComboBox* _sender,
                                                        gpointer self)
{
	games_scores_dialog_load_scores ((GamesScoresDialog*) self);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

GamesScoresDialog*
games_scores_dialog_construct (GType object_type,
                               GamesScoresContext* context,
                               const gchar* category_type,
                               GamesScoresStyle style,
                               GamesScoresScore* new_high_score,
                               GamesScoresCategory* current_cat,
                               GtkWindow* window,
                               const gchar* icon_name)
{
	GamesScoresDialog * self = NULL;
	GamesScoresContext* _tmp0_;
	GamesScoresScore* _tmp1_;
	GamesScoresCategory* _tmp2_;
	GtkLabel* _tmp3_;
	GtkLabel* _tmp4_;
	GtkLabel* _tmp5_;
	GtkLabel* _tmp6_;
	GtkLabel* _tmp7_;
	GtkLabel* _tmp8_;
	GtkLabel* _tmp9_;
	GtkLabel* _tmp10_;
	GtkLabel* _tmp11_;
	GtkLabel* _tmp12_;
	GtkLabel* _tmp13_;
	GtkLabel* _tmp14_;
	GtkBox* title_widget = NULL;
	GtkBox* _tmp15_;
	GtkBox* _tmp16_;
	GtkBox* _tmp17_;
	GtkLabel* _tmp18_;
	GtkBox* _tmp19_;
	GtkLabel* _tmp20_;
	GtkHeaderBar* _tmp21_;
	GtkHeaderBar* _tmp22_;
	GtkHeaderBar* _tmp23_;
	GtkBox* _tmp24_;
	GtkHeaderBar* _tmp25_;
	GtkBox* vbox = NULL;
	GtkBox* _tmp30_;
	GtkBox* _tmp31_;
	GtkBox* _tmp32_;
	gboolean _tmp33_ = FALSE;
	GtkBox* _tmp60_;
	GtkBox* catbar = NULL;
	GtkBox* _tmp61_;
	GtkBox* _tmp62_;
	GtkBox* _tmp63_;
	GtkBox* _tmp64_;
	GtkBox* _tmp65_;
	GtkBox* _tmp66_;
	GtkBox* _tmp67_;
	GtkSeparator* hdiv = NULL;
	GtkSeparator* _tmp68_;
	GtkBox* _tmp69_;
	GtkSeparator* _tmp70_;
	GtkLabel* label = NULL;
	GtkLabel* _tmp71_;
	GtkLabel* _tmp72_;
	GtkLabel* _tmp73_;
	GtkBox* _tmp74_;
	GtkLabel* _tmp75_;
	GList* categories = NULL;
	GList* _tmp76_;
	gboolean _tmp77_ = FALSE;
	GtkGrid* _tmp97_;
	GtkBox* _tmp98_;
	GtkGrid* _tmp99_;
	GtkGrid* _tmp100_;
	GtkGrid* _tmp101_;
	GtkGrid* _tmp102_;
	GtkGrid* _tmp103_;
	GtkGrid* _tmp104_;
	GtkGrid* _tmp105_;
	gchar* string_rank = NULL;
	gchar* _tmp106_;
	GtkLabel* label_column_1 = NULL;
	const gchar* _tmp107_;
	gchar* _tmp108_;
	gchar* _tmp109_;
	gchar* _tmp110_;
	gchar* _tmp111_;
	GtkLabel* _tmp112_;
	GtkLabel* _tmp113_;
	GtkLabel* _tmp114_;
	GtkGrid* _tmp115_;
	GtkLabel* _tmp116_;
	gchar* score_or_time = NULL;
	gchar* _tmp117_;
	gboolean _tmp118_ = FALSE;
	GtkLabel* label_column_2 = NULL;
	const gchar* _tmp121_;
	gchar* _tmp122_;
	gchar* _tmp123_;
	gchar* _tmp124_;
	gchar* _tmp125_;
	GtkLabel* _tmp126_;
	GtkLabel* _tmp127_;
	GtkLabel* _tmp128_;
	GtkGrid* _tmp129_;
	GtkLabel* _tmp130_;
	gchar* string_player = NULL;
	gchar* _tmp131_;
	GtkLabel* label_column_3 = NULL;
	const gchar* _tmp132_;
	gchar* _tmp133_;
	gchar* _tmp134_;
	gchar* _tmp135_;
	gchar* _tmp136_;
	GtkLabel* _tmp137_;
	GtkLabel* _tmp138_;
	GtkLabel* _tmp139_;
	GtkGrid* _tmp140_;
	GtkLabel* _tmp141_;
	GtkGrid* _tmp142_;
	g_return_val_if_fail (context != NULL, NULL);
	g_return_val_if_fail (category_type != NULL, NULL);
	g_return_val_if_fail (window != NULL, NULL);
	g_return_val_if_fail (icon_name != NULL, NULL);
	self = (GamesScoresDialog*) g_object_new (object_type, "use-header-bar", 1, NULL);
	gtk_window_set_resizable ((GtkWindow*) self, FALSE);
	_tmp0_ = _g_object_ref0 (context);
	_g_object_unref0 (self->priv->context);
	self->priv->context = _tmp0_;
	gtk_window_set_modal ((GtkWindow*) self, TRUE);
	gtk_window_set_transient_for ((GtkWindow*) self, window);
	_tmp1_ = _g_object_ref0 (new_high_score);
	_g_object_unref0 (self->priv->new_high_score);
	self->priv->new_high_score = _tmp1_;
	self->priv->scores_style = style;
	_tmp2_ = _g_object_ref0 (current_cat);
	_g_object_unref0 (self->priv->scores_active_category);
	self->priv->scores_active_category = _tmp2_;
	_tmp3_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->window_title);
	self->priv->window_title = _tmp3_;
	_tmp4_ = self->priv->window_title;
	gtk_label_set_ellipsize (_tmp4_, PANGO_ELLIPSIZE_END);
	_tmp5_ = self->priv->window_title;
	gtk_label_set_wrap (_tmp5_, FALSE);
	_tmp6_ = self->priv->window_title;
	gtk_label_set_single_line_mode (_tmp6_, TRUE);
	_tmp7_ = self->priv->window_title;
	gtk_label_set_width_chars (_tmp7_, 5);
	_tmp8_ = self->priv->window_title;
	gtk_widget_add_css_class ((GtkWidget*) _tmp8_, "title");
	_tmp9_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->window_subtitle);
	self->priv->window_subtitle = _tmp9_;
	_tmp10_ = self->priv->window_subtitle;
	gtk_label_set_ellipsize (_tmp10_, PANGO_ELLIPSIZE_END);
	_tmp11_ = self->priv->window_subtitle;
	gtk_label_set_wrap (_tmp11_, FALSE);
	_tmp12_ = self->priv->window_subtitle;
	gtk_label_set_single_line_mode (_tmp12_, TRUE);
	_tmp13_ = self->priv->window_subtitle;
	gtk_widget_set_visible ((GtkWidget*) _tmp13_, FALSE);
	_tmp14_ = self->priv->window_subtitle;
	gtk_widget_add_css_class ((GtkWidget*) _tmp14_, "subtitle");
	_tmp15_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp15_);
	title_widget = _tmp15_;
	_tmp16_ = title_widget;
	gtk_widget_set_valign ((GtkWidget*) _tmp16_, GTK_ALIGN_CENTER);
	_tmp17_ = title_widget;
	_tmp18_ = self->priv->window_title;
	gtk_box_append (_tmp17_, (GtkWidget*) _tmp18_);
	_tmp19_ = title_widget;
	_tmp20_ = self->priv->window_subtitle;
	gtk_box_append (_tmp19_, (GtkWidget*) _tmp20_);
	_tmp21_ = gtk_dialog_get_header_bar ((GtkDialog*) self);
	_tmp22_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, gtk_header_bar_get_type (), GtkHeaderBar));
	_g_object_unref0 (self->priv->headerbar);
	self->priv->headerbar = _tmp22_;
	_tmp23_ = self->priv->headerbar;
	_tmp24_ = title_widget;
	gtk_header_bar_set_title_widget (_tmp23_, (GtkWidget*) _tmp24_);
	_tmp25_ = self->priv->headerbar;
	gtk_header_bar_set_show_title_buttons (_tmp25_, new_high_score == NULL);
	if (new_high_score != NULL) {
		GtkLabel* _tmp26_;
		_tmp26_ = self->priv->window_title;
		gtk_label_set_label (_tmp26_, _ ("Congratulations!"));
	} else {
		gboolean _tmp27_ = FALSE;
		if (self->priv->scores_style == GAMES_SCORES_STYLE_POINTS_GREATER_IS_BETTER) {
			_tmp27_ = TRUE;
		} else {
			_tmp27_ = self->priv->scores_style == GAMES_SCORES_STYLE_POINTS_LESS_IS_BETTER;
		}
		if (_tmp27_) {
			GtkLabel* _tmp28_;
			_tmp28_ = self->priv->window_title;
			gtk_label_set_label (_tmp28_, _ ("High Scores"));
		} else {
			GtkLabel* _tmp29_;
			_tmp29_ = self->priv->window_title;
			gtk_label_set_label (_tmp29_, _ ("Best Times"));
		}
	}
	_tmp30_ = gtk_dialog_get_content_area ((GtkDialog*) self);
	_tmp31_ = _g_object_ref0 (_tmp30_);
	vbox = _tmp31_;
	_tmp32_ = vbox;
	gtk_orientable_set_orientation ((GtkOrientable*) _tmp32_, GTK_ORIENTATION_VERTICAL);
	if (!games_scores_context_has_scores (context)) {
		_tmp33_ = new_high_score == NULL;
	} else {
		_tmp33_ = FALSE;
	}
	if (_tmp33_) {
		GtkBox* _tmp34_;
		GtkBox* _tmp35_;
		GtkBox* _tmp36_;
		GtkBox* _tmp37_;
		GtkBox* _tmp38_;
		GtkStyleContext* _tmp39_;
		GtkImage* image = NULL;
		GtkImage* _tmp40_;
		GtkImage* _tmp41_;
		gchar* _tmp42_;
		gchar* _tmp43_;
		GtkImage* _tmp44_;
		GtkImage* _tmp45_;
		GtkBox* _tmp46_;
		GtkImage* _tmp47_;
		GtkLabel* title_label = NULL;
		gchar* _tmp48_;
		gchar* _tmp49_;
		gchar* _tmp50_;
		gchar* _tmp51_;
		GtkLabel* _tmp52_;
		GtkLabel* _tmp53_;
		GtkLabel* _tmp54_;
		GtkBox* _tmp55_;
		GtkLabel* _tmp56_;
		GtkLabel* description_label = NULL;
		GtkLabel* _tmp57_;
		GtkBox* _tmp58_;
		GtkLabel* _tmp59_;
		_tmp34_ = vbox;
		gtk_box_set_spacing (_tmp34_, 4);
		_tmp35_ = vbox;
		gtk_widget_set_hexpand ((GtkWidget*) _tmp35_, TRUE);
		_tmp36_ = vbox;
		gtk_widget_set_vexpand ((GtkWidget*) _tmp36_, TRUE);
		_tmp37_ = vbox;
		gtk_widget_set_valign ((GtkWidget*) _tmp37_, GTK_ALIGN_CENTER);
		_tmp38_ = vbox;
		_tmp39_ = gtk_widget_get_style_context ((GtkWidget*) _tmp38_);
		gtk_style_context_add_class (_tmp39_, "dim-label");
		_tmp40_ = (GtkImage*) gtk_image_new ();
		g_object_ref_sink (_tmp40_);
		image = _tmp40_;
		_tmp41_ = image;
		_tmp42_ = g_strconcat (icon_name, "-symbolic", NULL);
		_tmp43_ = _tmp42_;
		g_object_set (_tmp41_, "icon-name", _tmp43_, NULL);
		_g_free0 (_tmp43_);
		_tmp44_ = image;
		gtk_image_set_pixel_size (_tmp44_, 64);
		_tmp45_ = image;
		gtk_widget_set_opacity ((GtkWidget*) _tmp45_, 0.2);
		_tmp46_ = vbox;
		_tmp47_ = image;
		gtk_box_append (_tmp46_, (GtkWidget*) _tmp47_);
		_tmp48_ = g_strconcat ("<b><span size=\"large\">", _ ("No scores yet"), NULL);
		_tmp49_ = _tmp48_;
		_tmp50_ = g_strconcat (_tmp49_, "</span></b>", NULL);
		_tmp51_ = _tmp50_;
		_tmp52_ = (GtkLabel*) gtk_label_new (_tmp51_);
		g_object_ref_sink (_tmp52_);
		_tmp53_ = _tmp52_;
		_g_free0 (_tmp51_);
		_g_free0 (_tmp49_);
		title_label = _tmp53_;
		_tmp54_ = title_label;
		gtk_label_set_use_markup (_tmp54_, TRUE);
		_tmp55_ = vbox;
		_tmp56_ = title_label;
		gtk_box_append (_tmp55_, (GtkWidget*) _tmp56_);
		_tmp57_ = (GtkLabel*) gtk_label_new (_ ("Play some games and your scores will show up here."));
		g_object_ref_sink (_tmp57_);
		description_label = _tmp57_;
		_tmp58_ = vbox;
		_tmp59_ = description_label;
		gtk_box_append (_tmp58_, (GtkWidget*) _tmp59_);
		g_object_set ((GtkWidget*) self, "width-request", 450, NULL);
		g_object_set ((GtkWidget*) self, "height-request", 500, NULL);
		_g_object_unref0 (description_label);
		_g_object_unref0 (title_label);
		_g_object_unref0 (image);
		_g_object_unref0 (vbox);
		_g_object_unref0 (title_widget);
		return self;
	}
	_tmp60_ = vbox;
	gtk_box_set_spacing (_tmp60_, 20);
	_tmp61_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 12);
	g_object_ref_sink (_tmp61_);
	catbar = _tmp61_;
	_tmp62_ = catbar;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp62_, 20);
	_tmp63_ = catbar;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp63_, 20);
	_tmp64_ = catbar;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp64_, 20);
	_tmp65_ = catbar;
	gtk_widget_set_halign ((GtkWidget*) _tmp65_, GTK_ALIGN_CENTER);
	_tmp66_ = vbox;
	_tmp67_ = catbar;
	gtk_box_append (_tmp66_, (GtkWidget*) _tmp67_);
	_tmp68_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
	g_object_ref_sink (_tmp68_);
	hdiv = _tmp68_;
	_tmp69_ = vbox;
	_tmp70_ = hdiv;
	gtk_box_append (_tmp69_, (GtkWidget*) _tmp70_);
	_tmp71_ = (GtkLabel*) gtk_label_new (category_type);
	g_object_ref_sink (_tmp71_);
	label = _tmp71_;
	_tmp72_ = label;
	gtk_label_set_use_markup (_tmp72_, TRUE);
	_tmp73_ = label;
	gtk_widget_set_halign ((GtkWidget*) _tmp73_, GTK_ALIGN_CENTER);
	_tmp74_ = catbar;
	_tmp75_ = label;
	gtk_box_append (_tmp74_, (GtkWidget*) _tmp75_);
	_tmp76_ = games_scores_context_get_categories (context);
	categories = _tmp76_;
	if (new_high_score != NULL) {
		_tmp77_ = TRUE;
	} else {
		GList* _tmp78_;
		_tmp78_ = categories;
		_tmp77_ = g_list_length (_tmp78_) == ((guint) 1);
	}
	if (_tmp77_) {
		GamesScoresCategory* _tmp83_;
		const gchar* _tmp84_;
		const gchar* _tmp85_;
		GtkLabel* _tmp86_;
		GtkLabel* _tmp87_;
		GtkLabel* _tmp88_;
		GtkLabel* _tmp89_;
		GtkBox* _tmp90_;
		GtkLabel* _tmp91_;
		if (new_high_score == NULL) {
			GList* _tmp79_;
			GList* _tmp80_;
			gconstpointer _tmp81_;
			GamesScoresCategory* _tmp82_;
			_tmp79_ = categories;
			_tmp80_ = g_list_first (_tmp79_);
			_tmp81_ = ((GList*) _tmp80_)->data;
			_tmp82_ = _g_object_ref0 ((GamesScoresCategory*) _tmp81_);
			_g_object_unref0 (self->priv->scores_active_category);
			self->priv->scores_active_category = _tmp82_;
		}
		_tmp83_ = self->priv->scores_active_category;
		_tmp84_ = games_scores_category_get_name (_tmp83_);
		_tmp85_ = _tmp84_;
		_tmp86_ = (GtkLabel*) gtk_label_new (_tmp85_);
		g_object_ref_sink (_tmp86_);
		_g_object_unref0 (self->priv->category_label);
		self->priv->category_label = _tmp86_;
		_tmp87_ = self->priv->category_label;
		gtk_label_set_use_markup (_tmp87_, TRUE);
		_tmp88_ = self->priv->category_label;
		gtk_widget_set_halign ((GtkWidget*) _tmp88_, GTK_ALIGN_CENTER);
		_tmp89_ = self->priv->category_label;
		gtk_widget_set_valign ((GtkWidget*) _tmp89_, GTK_ALIGN_CENTER);
		_tmp90_ = catbar;
		_tmp91_ = self->priv->category_label;
		gtk_box_append (_tmp90_, (GtkWidget*) _tmp91_);
	} else {
		GtkComboBoxText* _tmp92_;
		GtkComboBoxText* _tmp93_;
		GtkBox* _tmp94_;
		GtkComboBoxText* _tmp95_;
		GtkComboBoxText* _tmp96_;
		_tmp92_ = (GtkComboBoxText*) gtk_combo_box_text_new ();
		g_object_ref_sink (_tmp92_);
		_g_object_unref0 (self->priv->combo);
		self->priv->combo = _tmp92_;
		_tmp93_ = self->priv->combo;
		gtk_widget_set_focus_on_click ((GtkWidget*) _tmp93_, FALSE);
		_tmp94_ = catbar;
		_tmp95_ = self->priv->combo;
		gtk_box_append (_tmp94_, (GtkWidget*) _tmp95_);
		_tmp96_ = self->priv->combo;
		g_signal_connect_object ((GtkComboBox*) _tmp96_, "changed", (GCallback) _games_scores_dialog_load_scores_gtk_combo_box_changed, self, 0);
	}
	_tmp97_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp97_);
	_g_object_unref0 (self->priv->grid);
	self->priv->grid = _tmp97_;
	_tmp98_ = vbox;
	_tmp99_ = self->priv->grid;
	gtk_box_append (_tmp98_, (GtkWidget*) _tmp99_);
	_tmp100_ = self->priv->grid;
	gtk_grid_set_row_homogeneous (_tmp100_, TRUE);
	_tmp101_ = self->priv->grid;
	gtk_grid_set_column_spacing (_tmp101_, 40);
	_tmp102_ = self->priv->grid;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp102_, 30);
	_tmp103_ = self->priv->grid;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp103_, 30);
	_tmp104_ = self->priv->grid;
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp104_, 20);
	_tmp105_ = self->priv->grid;
	gtk_widget_set_halign ((GtkWidget*) _tmp105_, GTK_ALIGN_CENTER);
	_tmp106_ = g_strdup (_ ("Rank"));
	string_rank = _tmp106_;
	_tmp107_ = string_rank;
	_tmp108_ = g_strconcat ("<span weight='bold'>", _tmp107_, NULL);
	_tmp109_ = _tmp108_;
	_tmp110_ = g_strconcat (_tmp109_, "</span>", NULL);
	_tmp111_ = _tmp110_;
	_tmp112_ = (GtkLabel*) gtk_label_new (_tmp111_);
	g_object_ref_sink (_tmp112_);
	_tmp113_ = _tmp112_;
	_g_free0 (_tmp111_);
	_g_free0 (_tmp109_);
	label_column_1 = _tmp113_;
	_tmp114_ = label_column_1;
	gtk_label_set_use_markup (_tmp114_, TRUE);
	_tmp115_ = self->priv->grid;
	_tmp116_ = label_column_1;
	gtk_grid_attach (_tmp115_, (GtkWidget*) _tmp116_, 0, 0, 1, 1);
	_tmp117_ = g_strdup ("");
	score_or_time = _tmp117_;
	if (self->priv->scores_style == GAMES_SCORES_STYLE_POINTS_GREATER_IS_BETTER) {
		_tmp118_ = TRUE;
	} else {
		_tmp118_ = self->priv->scores_style == GAMES_SCORES_STYLE_POINTS_LESS_IS_BETTER;
	}
	if (_tmp118_) {
		gchar* _tmp119_;
		_tmp119_ = g_strdup (_ ("Score"));
		_g_free0 (score_or_time);
		score_or_time = _tmp119_;
	} else {
		gchar* _tmp120_;
		_tmp120_ = g_strdup (_ ("Time"));
		_g_free0 (score_or_time);
		score_or_time = _tmp120_;
	}
	_tmp121_ = score_or_time;
	_tmp122_ = g_strconcat ("<span weight='bold'>", _tmp121_, NULL);
	_tmp123_ = _tmp122_;
	_tmp124_ = g_strconcat (_tmp123_, "</span>", NULL);
	_tmp125_ = _tmp124_;
	_tmp126_ = (GtkLabel*) gtk_label_new (_tmp125_);
	g_object_ref_sink (_tmp126_);
	_tmp127_ = _tmp126_;
	_g_free0 (_tmp125_);
	_g_free0 (_tmp123_);
	label_column_2 = _tmp127_;
	_tmp128_ = label_column_2;
	gtk_label_set_use_markup (_tmp128_, TRUE);
	_tmp129_ = self->priv->grid;
	_tmp130_ = label_column_2;
	gtk_grid_attach (_tmp129_, (GtkWidget*) _tmp130_, 1, 0, 1, 1);
	_tmp131_ = g_strdup (_ ("Player"));
	string_player = _tmp131_;
	_tmp132_ = string_player;
	_tmp133_ = g_strconcat ("<span weight='bold'>", _tmp132_, NULL);
	_tmp134_ = _tmp133_;
	_tmp135_ = g_strconcat (_tmp134_, "</span>", NULL);
	_tmp136_ = _tmp135_;
	_tmp137_ = (GtkLabel*) gtk_label_new (_tmp136_);
	g_object_ref_sink (_tmp137_);
	_tmp138_ = _tmp137_;
	_g_free0 (_tmp136_);
	_g_free0 (_tmp134_);
	label_column_3 = _tmp138_;
	_tmp139_ = label_column_3;
	gtk_label_set_use_markup (_tmp139_, TRUE);
	_tmp140_ = self->priv->grid;
	_tmp141_ = label_column_3;
	gtk_grid_attach (_tmp140_, (GtkWidget*) _tmp141_, 2, 0, 1, 1);
	_tmp142_ = self->priv->grid;
	gtk_grid_set_baseline_row (_tmp142_, 0);
	games_scores_dialog_fill_grid_with_labels (self);
	if (new_high_score != NULL) {
		GtkWidget* _tmp143_;
		GtkStyleContext* _tmp144_;
		_tmp143_ = gtk_dialog_add_button ((GtkDialog*) self, _ ("_Done"), (gint) GTK_RESPONSE_OK);
		_tmp144_ = gtk_widget_get_style_context (_tmp143_);
		gtk_style_context_add_class (_tmp144_, "suggested-action");
	}
	games_scores_dialog_load_categories (self);
	_g_object_unref0 (label_column_3);
	_g_free0 (string_player);
	_g_object_unref0 (label_column_2);
	_g_free0 (score_or_time);
	_g_object_unref0 (label_column_1);
	_g_free0 (string_rank);
	(categories == NULL) ? NULL : (categories = (_g_list_free__g_object_unref0_ (categories), NULL));
	_g_object_unref0 (label);
	_g_object_unref0 (hdiv);
	_g_object_unref0 (catbar);
	_g_object_unref0 (vbox);
	_g_object_unref0 (title_widget);
	return self;
}

GamesScoresDialog*
games_scores_dialog_new (GamesScoresContext* context,
                         const gchar* category_type,
                         GamesScoresStyle style,
                         GamesScoresScore* new_high_score,
                         GamesScoresCategory* current_cat,
                         GtkWindow* window,
                         const gchar* icon_name)
{
	return games_scores_dialog_construct (GAMES_SCORES_TYPE_DIALOG, context, category_type, style, new_high_score, current_cat, window, icon_name);
}

static void
games_scores_dialog_fill_grid_with_labels (GamesScoresDialog* self)
{
	g_return_if_fail (self != NULL);
	{
		gint row = 0;
		row = 1;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GtkStack* stack = NULL;
				GtkStack* _tmp10_;
				GtkStack* _tmp11_;
				GtkStack* _tmp12_;
				GtkStack* _tmp13_;
				GtkStack* _tmp14_;
				GtkLabel* label = NULL;
				GtkLabel* _tmp15_;
				GtkLabel* _tmp16_;
				GtkLabel* _tmp17_;
				GtkLabel* _tmp18_;
				GtkStack* _tmp19_;
				GtkLabel* _tmp20_;
				GtkEntry* entry = NULL;
				GtkEntry* _tmp21_;
				GtkEntry* _tmp22_;
				GtkEntry* _tmp23_;
				GtkEntry* _tmp24_;
				GtkEntry* _tmp25_;
				GtkStack* _tmp26_;
				GtkEntry* _tmp27_;
				GtkStack* _tmp28_;
				GtkGrid* _tmp29_;
				GtkStack* _tmp30_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = row;
					row = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(row <= self->priv->rows_to_display)) {
					break;
				}
				{
					gint column = 0;
					column = 0;
					{
						gboolean _tmp2_ = FALSE;
						_tmp2_ = TRUE;
						while (TRUE) {
							GtkLabel* label = NULL;
							GtkLabel* _tmp4_;
							GtkLabel* _tmp5_;
							GtkLabel* _tmp6_;
							GtkLabel* _tmp7_;
							GtkGrid* _tmp8_;
							GtkLabel* _tmp9_;
							if (!_tmp2_) {
								gint _tmp3_;
								_tmp3_ = column;
								column = _tmp3_ + 1;
							}
							_tmp2_ = FALSE;
							if (!(column <= 1)) {
								break;
							}
							_tmp4_ = (GtkLabel*) gtk_label_new ("");
							g_object_ref_sink (_tmp4_);
							label = _tmp4_;
							_tmp5_ = label;
							gtk_widget_set_visible ((GtkWidget*) _tmp5_, TRUE);
							_tmp6_ = label;
							gtk_widget_set_halign ((GtkWidget*) _tmp6_, GTK_ALIGN_CENTER);
							_tmp7_ = label;
							gtk_widget_set_valign ((GtkWidget*) _tmp7_, GTK_ALIGN_CENTER);
							_tmp8_ = self->priv->grid;
							_tmp9_ = label;
							gtk_grid_attach (_tmp8_, (GtkWidget*) _tmp9_, column, row, 1, 1);
							_g_object_unref0 (label);
						}
					}
				}
				_tmp10_ = (GtkStack*) gtk_stack_new ();
				g_object_ref_sink (_tmp10_);
				stack = _tmp10_;
				_tmp11_ = stack;
				gtk_widget_set_visible ((GtkWidget*) _tmp11_, TRUE);
				_tmp12_ = stack;
				gtk_stack_set_hhomogeneous (_tmp12_, FALSE);
				_tmp13_ = stack;
				gtk_stack_set_vhomogeneous (_tmp13_, TRUE);
				_tmp14_ = stack;
				gtk_stack_set_transition_type (_tmp14_, GTK_STACK_TRANSITION_TYPE_NONE);
				_tmp15_ = (GtkLabel*) gtk_label_new ("");
				g_object_ref_sink (_tmp15_);
				label = _tmp15_;
				_tmp16_ = label;
				gtk_widget_set_visible ((GtkWidget*) _tmp16_, TRUE);
				_tmp17_ = label;
				gtk_label_set_justify (_tmp17_, GTK_JUSTIFY_CENTER);
				_tmp18_ = label;
				gtk_widget_set_valign ((GtkWidget*) _tmp18_, GTK_ALIGN_CENTER);
				_tmp19_ = stack;
				_tmp20_ = label;
				gtk_stack_add_named (_tmp19_, (GtkWidget*) _tmp20_, "label");
				_tmp21_ = (GtkEntry*) gtk_entry_new ();
				g_object_ref_sink (_tmp21_);
				entry = _tmp21_;
				_tmp22_ = entry;
				gtk_widget_set_visible ((GtkWidget*) _tmp22_, TRUE);
				_tmp23_ = entry;
				gtk_widget_set_size_request ((GtkWidget*) _tmp23_, 20, 20);
				_tmp24_ = entry;
				gtk_widget_set_hexpand ((GtkWidget*) _tmp24_, FALSE);
				_tmp25_ = entry;
				gtk_widget_set_vexpand ((GtkWidget*) _tmp25_, FALSE);
				_tmp26_ = stack;
				_tmp27_ = entry;
				gtk_stack_add_named (_tmp26_, (GtkWidget*) _tmp27_, "entry");
				_tmp28_ = stack;
				gtk_stack_set_visible_child_name (_tmp28_, "label");
				_tmp29_ = self->priv->grid;
				_tmp30_ = stack;
				gtk_grid_attach (_tmp29_, (GtkWidget*) _tmp30_, 2, row, 1, 1);
				_g_object_unref0 (entry);
				_g_object_unref0 (label);
				_g_object_unref0 (stack);
			}
		}
	}
}

static void
__lambda10_ (GamesScoresDialog* self,
             GamesScoresCategory* x)
{
	GtkComboBoxText* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	_tmp0_ = self->priv->combo;
	_tmp1_ = games_scores_category_get_key (x);
	_tmp2_ = _tmp1_;
	_tmp3_ = games_scores_category_get_name (x);
	_tmp4_ = _tmp3_;
	gtk_combo_box_text_append (_tmp0_, _tmp2_, _tmp4_);
}

static void
___lambda10__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda10_ ((GamesScoresDialog*) self, (GamesScoresCategory*) data);
}

static void
games_scores_dialog_load_categories (GamesScoresDialog* self)
{
	gboolean _tmp0_ = FALSE;
	GamesScoresScore* _tmp1_;
	GtkComboBoxText* _tmp3_;
	GList* categories = NULL;
	GamesScoresContext* _tmp4_;
	GList* _tmp5_;
	GList* _tmp6_;
	GamesScoresCategory* _tmp7_;
	GamesScoresCategory* _tmp17_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->new_high_score;
	if (_tmp1_ != NULL) {
		_tmp0_ = TRUE;
	} else {
		GtkComboBoxText* _tmp2_;
		_tmp2_ = self->priv->combo;
		_tmp0_ = _tmp2_ == NULL;
	}
	if (_tmp0_) {
		games_scores_dialog_load_scores (self);
	}
	_tmp3_ = self->priv->combo;
	if (_tmp3_ == NULL) {
		return;
	}
	_tmp4_ = self->priv->context;
	_tmp5_ = games_scores_context_get_categories (_tmp4_);
	categories = _tmp5_;
	_tmp6_ = categories;
	g_list_foreach (_tmp6_, ___lambda10__gfunc, self);
	_tmp7_ = self->priv->scores_active_category;
	if (_tmp7_ == NULL) {
		GtkComboBoxText* _tmp8_;
		GList* _tmp9_;
		gconstpointer _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		_tmp8_ = self->priv->combo;
		_tmp9_ = categories;
		_tmp10_ = g_list_nth_data (_tmp9_, (guint) 0);
		_tmp11_ = games_scores_category_get_key ((GamesScoresCategory*) _tmp10_);
		_tmp12_ = _tmp11_;
		gtk_combo_box_set_active_id ((GtkComboBox*) _tmp8_, _tmp12_);
	} else {
		GtkComboBoxText* _tmp13_;
		GamesScoresCategory* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		_tmp13_ = self->priv->combo;
		_tmp14_ = self->priv->scores_active_category;
		_tmp15_ = games_scores_category_get_key (_tmp14_);
		_tmp16_ = _tmp15_;
		gtk_combo_box_set_active_id ((GtkComboBox*) _tmp13_, _tmp16_);
	}
	_tmp17_ = self->priv->active_category;
	if (_tmp17_ == NULL) {
		GList* _tmp18_;
		gconstpointer _tmp19_;
		const gchar* _tmp20_;
		const gchar* _tmp21_;
		GList* _tmp22_;
		gconstpointer _tmp23_;
		const gchar* _tmp24_;
		const gchar* _tmp25_;
		GamesScoresCategory* _tmp26_;
		_tmp18_ = categories;
		_tmp19_ = g_list_nth_data (_tmp18_, (guint) 0);
		_tmp20_ = games_scores_category_get_key ((GamesScoresCategory*) _tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = categories;
		_tmp23_ = g_list_nth_data (_tmp22_, (guint) 0);
		_tmp24_ = games_scores_category_get_name ((GamesScoresCategory*) _tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = games_scores_category_new (_tmp21_, _tmp25_);
		_g_object_unref0 (self->priv->active_category);
		self->priv->active_category = _tmp26_;
	} else {
		GamesScoresCategory* _tmp27_;
		GList* _tmp28_;
		gconstpointer _tmp29_;
		const gchar* _tmp30_;
		const gchar* _tmp31_;
		GamesScoresCategory* _tmp32_;
		GList* _tmp33_;
		gconstpointer _tmp34_;
		const gchar* _tmp35_;
		const gchar* _tmp36_;
		_tmp27_ = self->priv->active_category;
		_tmp28_ = categories;
		_tmp29_ = g_list_nth_data (_tmp28_, (guint) 0);
		_tmp30_ = games_scores_category_get_key ((GamesScoresCategory*) _tmp29_);
		_tmp31_ = _tmp30_;
		games_scores_category_set_key (_tmp27_, _tmp31_);
		_tmp32_ = self->priv->active_category;
		_tmp33_ = categories;
		_tmp34_ = g_list_nth_data (_tmp33_, (guint) 0);
		_tmp35_ = games_scores_category_get_name ((GamesScoresCategory*) _tmp34_);
		_tmp36_ = _tmp35_;
		games_scores_category_set_name (_tmp32_, _tmp36_);
	}
	(categories == NULL) ? NULL : (categories = (_g_list_free__g_object_unref0_ (categories), NULL));
}

static void
games_scores_dialog_load_scores (GamesScoresDialog* self)
{
	gboolean _tmp0_ = FALSE;
	GamesScoresScore* _tmp1_;
	GeeList* best_n_scores = NULL;
	GamesScoresContext* _tmp16_;
	GamesScoresCategory* _tmp17_;
	GeeList* _tmp18_;
	gint row_count = 0;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->new_high_score;
	if (_tmp1_ != NULL) {
		_tmp0_ = TRUE;
	} else {
		GtkComboBoxText* _tmp2_;
		_tmp2_ = self->priv->combo;
		_tmp0_ = _tmp2_ == NULL;
	}
	if (_tmp0_) {
		GamesScoresCategory* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		GamesScoresCategory* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		GamesScoresCategory* _tmp9_;
		_tmp3_ = self->priv->scores_active_category;
		_tmp4_ = games_scores_category_get_key (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = self->priv->scores_active_category;
		_tmp7_ = games_scores_category_get_name (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = games_scores_category_new (_tmp5_, _tmp8_);
		_g_object_unref0 (self->priv->active_category);
		self->priv->active_category = _tmp9_;
	} else {
		GtkComboBoxText* _tmp10_;
		const gchar* _tmp11_;
		GtkComboBoxText* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		GamesScoresCategory* _tmp15_;
		_tmp10_ = self->priv->combo;
		_tmp11_ = gtk_combo_box_get_active_id ((GtkComboBox*) _tmp10_);
		_tmp12_ = self->priv->combo;
		_tmp13_ = gtk_combo_box_text_get_active_text (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = games_scores_category_new (_tmp11_, _tmp14_);
		_g_object_unref0 (self->priv->active_category);
		self->priv->active_category = _tmp15_;
		_g_free0 (_tmp14_);
	}
	_tmp16_ = self->priv->context;
	_tmp17_ = self->priv->active_category;
	_tmp18_ = games_scores_context_get_high_scores (_tmp16_, _tmp17_, self->priv->rows_to_display);
	best_n_scores = _tmp18_;
	row_count = 1;
	{
		GeeList* _score_list = NULL;
		GeeList* _tmp19_;
		gint _score_size = 0;
		GeeList* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		gint _score_index = 0;
		_tmp19_ = best_n_scores;
		_score_list = _tmp19_;
		_tmp20_ = _score_list;
		_tmp21_ = gee_collection_get_size ((GeeCollection*) _tmp20_);
		_tmp22_ = _tmp21_;
		_score_size = _tmp22_;
		_score_index = -1;
		while (TRUE) {
			gint _tmp23_;
			gint _tmp24_;
			GamesScoresScore* score = NULL;
			GeeList* _tmp25_;
			gpointer _tmp26_;
			GamesScoresScore* _tmp27_;
			GeeList* _tmp28_;
			gint _tmp29_;
			gint _tmp30_;
			gint _tmp31_;
			_score_index = _score_index + 1;
			_tmp23_ = _score_index;
			_tmp24_ = _score_size;
			if (!(_tmp23_ < _tmp24_)) {
				break;
			}
			_tmp25_ = _score_list;
			_tmp26_ = gee_list_get (_tmp25_, _score_index);
			score = (GamesScoresScore*) _tmp26_;
			_tmp27_ = score;
			_tmp28_ = best_n_scores;
			_tmp29_ = gee_collection_get_size ((GeeCollection*) _tmp28_);
			_tmp30_ = _tmp29_;
			games_scores_dialog_display_single_score (self, _tmp27_, row_count, (guint) _tmp30_);
			_tmp31_ = row_count;
			row_count = _tmp31_ + 1;
			_g_object_unref0 (score);
		}
	}
	if (row_count < (self->priv->rows_to_display + 1)) {
		games_scores_dialog_make_remaining_labels_empty (self, row_count);
	}
	_g_object_unref0 (best_n_scores);
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		GamesScoresDialog* self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->score);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		GamesScoresDialog* self;
		self = _data6_->_data5_->self;
		_g_object_unref0 (_data6_->entry);
		block5_data_unref (_data6_->_data5_);
		_data6_->_data5_ = NULL;
		g_slice_free (Block6Data, _data6_);
	}
}

static void
___lambda9_ (Block6Data* _data6_)
{
	Block5Data* _data5_;
	GamesScoresDialog* self;
	GamesScoresContext* _tmp0_;
	GamesScoresCategory* _tmp1_;
	GtkEntry* _tmp2_;
	const gchar* _tmp3_;
	GtkEntry* _tmp4_;
	const gchar* _tmp5_;
	_data5_ = _data6_->_data5_;
	self = _data5_->self;
	_tmp0_ = self->priv->context;
	_tmp1_ = self->priv->active_category;
	_tmp2_ = _data6_->entry;
	_tmp3_ = gtk_editable_get_text ((GtkEditable*) _tmp2_);
	games_scores_context_update_score_name (_tmp0_, _data5_->score, _tmp1_, _tmp3_);
	_tmp4_ = _data6_->entry;
	_tmp5_ = gtk_editable_get_text ((GtkEditable*) _tmp4_);
	games_scores_score_set_user (_data5_->score, _tmp5_);
}

static void
____lambda9__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	___lambda9_ (self);
}

static void
games_scores_dialog_display_single_score (GamesScoresDialog* self,
                                          GamesScoresScore* score,
                                          gint row_count,
                                          guint no_scores)
{
	Block5Data* _data5_;
	GamesScoresScore* _tmp0_;
	GtkLabel* rank_label = NULL;
	GtkGrid* _tmp1_;
	GtkWidget* _tmp2_;
	GtkLabel* _tmp3_;
	GtkLabel* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GtkLabel* score_label = NULL;
	GtkGrid* _tmp7_;
	GtkWidget* _tmp8_;
	GtkLabel* _tmp9_;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp27_ = FALSE;
	GamesScoresScore* _tmp28_;
	GtkStack* name_stack = NULL;
	GtkGrid* _tmp45_;
	GtkWidget* _tmp46_;
	GtkStack* _tmp47_;
	GtkWidget* widget = NULL;
	GtkStack* _tmp48_;
	GtkWidget* _tmp49_;
	GtkWidget* _tmp50_;
	GtkStack* _tmp51_;
	const gchar* _tmp52_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (score != NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (score);
	_g_object_unref0 (_data5_->score);
	_data5_->score = _tmp0_;
	_tmp1_ = self->priv->grid;
	_tmp2_ = gtk_grid_get_child_at (_tmp1_, 0, row_count);
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_label_get_type (), GtkLabel));
	rank_label = _tmp3_;
	_tmp4_ = rank_label;
	_tmp5_ = g_strdup_printf ("%i", row_count);
	_tmp6_ = _tmp5_;
	gtk_label_set_text (_tmp4_, _tmp6_);
	_g_free0 (_tmp6_);
	_tmp7_ = self->priv->grid;
	_tmp8_ = gtk_grid_get_child_at (_tmp7_, 1, row_count);
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_label_get_type (), GtkLabel));
	score_label = _tmp9_;
	if (self->priv->scores_style == GAMES_SCORES_STYLE_POINTS_GREATER_IS_BETTER) {
		_tmp10_ = TRUE;
	} else {
		_tmp10_ = self->priv->scores_style == GAMES_SCORES_STYLE_POINTS_LESS_IS_BETTER;
	}
	if (_tmp10_) {
		GtkLabel* _tmp11_;
		glong _tmp12_;
		glong _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp11_ = score_label;
		_tmp12_ = games_scores_score_get_score (_data5_->score);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_strdup_printf ("%li", _tmp13_);
		_tmp15_ = _tmp14_;
		gtk_label_set_text (_tmp11_, _tmp15_);
		_g_free0 (_tmp15_);
	} else {
		glong minutes = 0L;
		glong _tmp16_;
		glong _tmp17_;
		glong seconds = 0L;
		glong _tmp18_;
		glong _tmp19_;
		GtkLabel* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		_tmp16_ = games_scores_score_get_score (_data5_->score);
		_tmp17_ = _tmp16_;
		minutes = _tmp17_ / 60;
		_tmp18_ = games_scores_score_get_score (_data5_->score);
		_tmp19_ = _tmp18_;
		seconds = _tmp19_ % 60;
		_tmp20_ = score_label;
		_tmp21_ = g_strdup_printf (g_dngettext (GETTEXT_PACKAGE, "%ld minute", "%ld minutes", (gulong) minutes), minutes);
		_tmp22_ = _tmp21_;
		_tmp23_ = g_strdup_printf (g_dngettext (GETTEXT_PACKAGE, "%ld second", "%ld seconds", (gulong) seconds), seconds);
		_tmp24_ = _tmp23_;
		_tmp25_ = g_strdup_printf ("%s %s", _tmp22_, _tmp24_);
		_tmp26_ = _tmp25_;
		gtk_label_set_text (_tmp20_, _tmp26_);
		_g_free0 (_tmp26_);
		_g_free0 (_tmp24_);
		_g_free0 (_tmp22_);
	}
	_tmp28_ = self->priv->new_high_score;
	if (_tmp28_ != NULL) {
		GamesScoresScore* _tmp29_;
		_tmp29_ = self->priv->new_high_score;
		_tmp27_ = games_scores_score_equals (_data5_->score, _tmp29_);
	} else {
		_tmp27_ = FALSE;
	}
	if (_tmp27_) {
		Block6Data* _data6_;
		GtkLabel* _tmp30_;
		gboolean _tmp31_ = FALSE;
		GtkStack* temp_stack = NULL;
		GtkGrid* _tmp34_;
		GtkWidget* _tmp35_;
		GtkStack* _tmp36_;
		GtkStack* _tmp37_;
		GtkStack* _tmp38_;
		GtkWidget* _tmp39_;
		GtkEntry* _tmp40_;
		GtkEntry* _tmp41_;
		const gchar* _tmp42_;
		const gchar* _tmp43_;
		GtkEntry* _tmp44_;
		_data6_ = g_slice_new0 (Block6Data);
		_data6_->_ref_count_ = 1;
		_data6_->_data5_ = block5_data_ref (_data5_);
		_tmp30_ = self->priv->window_subtitle;
		gtk_widget_set_visible ((GtkWidget*) _tmp30_, TRUE);
		if (no_scores > ((guint) 1)) {
			_tmp31_ = row_count == 1;
		} else {
			_tmp31_ = FALSE;
		}
		if (_tmp31_) {
			GtkLabel* _tmp32_;
			_tmp32_ = self->priv->window_subtitle;
			gtk_label_set_label (_tmp32_, _ ("Your score is the best!"));
		} else {
			GtkLabel* _tmp33_;
			_tmp33_ = self->priv->window_subtitle;
			gtk_label_set_label (_tmp33_, _ ("Your score has made the top ten."));
		}
		_tmp34_ = self->priv->grid;
		_tmp35_ = gtk_grid_get_child_at (_tmp34_, 2, row_count);
		_tmp36_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, gtk_stack_get_type (), GtkStack));
		temp_stack = _tmp36_;
		_tmp37_ = temp_stack;
		gtk_stack_set_visible_child_name (_tmp37_, "entry");
		_tmp38_ = temp_stack;
		_tmp39_ = gtk_stack_get_visible_child (_tmp38_);
		_tmp40_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, gtk_entry_get_type (), GtkEntry));
		_data6_->entry = _tmp40_;
		_tmp41_ = _data6_->entry;
		_tmp42_ = games_scores_score_get_user (_data5_->score);
		_tmp43_ = _tmp42_;
		gtk_editable_set_text ((GtkEditable*) _tmp41_, _tmp43_);
		_tmp44_ = _data6_->entry;
		g_signal_connect_data ((GObject*) _tmp44_, "notify::text", (GCallback) ____lambda9__g_object_notify, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
		_g_object_unref0 (temp_stack);
		block6_data_unref (_data6_);
		_data6_ = NULL;
	}
	_tmp45_ = self->priv->grid;
	_tmp46_ = gtk_grid_get_child_at (_tmp45_, 2, row_count);
	_tmp47_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, gtk_stack_get_type (), GtkStack));
	name_stack = _tmp47_;
	_tmp48_ = name_stack;
	_tmp49_ = gtk_stack_get_visible_child (_tmp48_);
	_tmp50_ = _g_object_ref0 (_tmp49_);
	widget = _tmp50_;
	_tmp51_ = name_stack;
	_tmp52_ = gtk_stack_get_visible_child_name (_tmp51_);
	if (g_strcmp0 (_tmp52_, "label") == 0) {
		GtkLabel* user_label = NULL;
		GtkWidget* _tmp53_;
		GtkLabel* _tmp54_;
		GtkLabel* _tmp55_;
		const gchar* _tmp56_;
		const gchar* _tmp57_;
		_tmp53_ = widget;
		_tmp54_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp53_, gtk_label_get_type (), GtkLabel));
		user_label = _tmp54_;
		_tmp55_ = user_label;
		_tmp56_ = games_scores_score_get_user (_data5_->score);
		_tmp57_ = _tmp56_;
		gtk_label_set_text (_tmp55_, _tmp57_);
		_g_object_unref0 (user_label);
	} else {
		GtkEntry* entry = NULL;
		GtkWidget* _tmp58_;
		GtkEntry* _tmp59_;
		GtkEntry* _tmp60_;
		const gchar* _tmp61_;
		const gchar* _tmp62_;
		_tmp58_ = widget;
		_tmp59_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, gtk_entry_get_type (), GtkEntry));
		entry = _tmp59_;
		_tmp60_ = entry;
		_tmp61_ = games_scores_score_get_user (_data5_->score);
		_tmp62_ = _tmp61_;
		gtk_editable_set_text ((GtkEditable*) _tmp60_, _tmp62_);
		_g_object_unref0 (entry);
	}
	_g_object_unref0 (widget);
	_g_object_unref0 (name_stack);
	_g_object_unref0 (score_label);
	_g_object_unref0 (rank_label);
	block5_data_unref (_data5_);
	_data5_ = NULL;
}

static void
games_scores_dialog_make_remaining_labels_empty (GamesScoresDialog* self,
                                                 gint row_count)
{
	g_return_if_fail (self != NULL);
	{
		gint i = 0;
		i = row_count;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GtkStack* stack = NULL;
				GtkGrid* _tmp8_;
				GtkWidget* _tmp9_;
				GtkStack* _tmp10_;
				GtkLabel* label = NULL;
				GtkStack* _tmp11_;
				GtkWidget* _tmp12_;
				GtkLabel* _tmp13_;
				GtkLabel* _tmp14_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(i <= self->priv->rows_to_display)) {
					break;
				}
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp2_ = FALSE;
						_tmp2_ = TRUE;
						while (TRUE) {
							GtkLabel* label = NULL;
							GtkGrid* _tmp4_;
							GtkWidget* _tmp5_;
							GtkLabel* _tmp6_;
							GtkLabel* _tmp7_;
							if (!_tmp2_) {
								gint _tmp3_;
								_tmp3_ = j;
								j = _tmp3_ + 1;
							}
							_tmp2_ = FALSE;
							if (!(j <= 1)) {
								break;
							}
							_tmp4_ = self->priv->grid;
							_tmp5_ = gtk_grid_get_child_at (_tmp4_, j, i);
							_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_label_get_type (), GtkLabel));
							label = _tmp6_;
							_tmp7_ = label;
							gtk_label_set_text (_tmp7_, "");
							_g_object_unref0 (label);
						}
					}
				}
				_tmp8_ = self->priv->grid;
				_tmp9_ = gtk_grid_get_child_at (_tmp8_, 2, i);
				_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_stack_get_type (), GtkStack));
				stack = _tmp10_;
				_tmp11_ = stack;
				_tmp12_ = gtk_stack_get_visible_child (_tmp11_);
				_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_label_get_type (), GtkLabel));
				label = _tmp13_;
				_tmp14_ = label;
				gtk_label_set_text (_tmp14_, "");
				_g_object_unref0 (label);
				_g_object_unref0 (stack);
			}
		}
	}
}

static void
games_scores_dialog_class_init (GamesScoresDialogClass * klass,
                                gpointer klass_data)
{
	games_scores_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GamesScoresDialog_private_offset);
	G_OBJECT_CLASS (klass)->finalize = games_scores_dialog_finalize;
}

static void
games_scores_dialog_instance_init (GamesScoresDialog * self,
                                   gpointer klass)
{
	self->priv = games_scores_dialog_get_instance_private (self);
	self->priv->active_category = NULL;
	self->priv->rows_to_display = 10;
	self->priv->combo = NULL;
	self->priv->category_label = NULL;
	self->priv->headerbar = NULL;
}

static void
games_scores_dialog_finalize (GObject * obj)
{
	GamesScoresDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_SCORES_TYPE_DIALOG, GamesScoresDialog);
	_g_object_unref0 (self->priv->context);
	_g_object_unref0 (self->priv->active_category);
	_g_object_unref0 (self->priv->combo);
	_g_object_unref0 (self->priv->category_label);
	_g_object_unref0 (self->priv->headerbar);
	_g_object_unref0 (self->priv->grid);
	_g_object_unref0 (self->priv->window_title);
	_g_object_unref0 (self->priv->window_subtitle);
	_g_object_unref0 (self->priv->new_high_score);
	_g_object_unref0 (self->priv->scores_active_category);
	G_OBJECT_CLASS (games_scores_dialog_parent_class)->finalize (obj);
}

static GType
games_scores_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GamesScoresDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_scores_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesScoresDialog), 0, (GInstanceInitFunc) games_scores_dialog_instance_init, NULL };
	GType games_scores_dialog_type_id;
	games_scores_dialog_type_id = g_type_register_static (gtk_dialog_get_type (), "GamesScoresDialog", &g_define_type_info, 0);
	GamesScoresDialog_private_offset = g_type_add_instance_private (games_scores_dialog_type_id, sizeof (GamesScoresDialogPrivate));
	return games_scores_dialog_type_id;
}

GType
games_scores_dialog_get_type (void)
{
	static volatile gsize games_scores_dialog_type_id__once = 0;
	if (g_once_init_enter (&games_scores_dialog_type_id__once)) {
		GType games_scores_dialog_type_id;
		games_scores_dialog_type_id = games_scores_dialog_get_type_once ();
		g_once_init_leave (&games_scores_dialog_type_id__once, games_scores_dialog_type_id);
	}
	return games_scores_dialog_type_id__once;
}

