// Copyright (c) 2005-2023 Code Synthesis.
//
// This program was generated by CodeSynthesis XSD, an XML Schema to
// C++ data binding compiler.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
//
// In addition, as a special exception, Code Synthesis gives permission
// to link this program with the Xerces-C++ library (or with modified
// versions of Xerces-C++ that use the same license as Xerces-C++), and
// distribute linked combinations including the two. You must obey the GNU
// General Public License version 2 in all respects for all of the code
// used other than Xerces-C++. If you modify this copy of the program, you
// may extend this exception to your version of the program, but you are
// not obligated to do so. If you do not wish to do so, delete this
// exception statement from your version.
//
// Furthermore, Code Synthesis makes a special exception for the Free/Libre
// and Open Source Software (FLOSS) which is described in the accompanying
// FLOSSE file.
//

#ifndef CXX_BUILD_LIBKOLABXML_SRC_LKX_SCHEMAS_KOLABFORMAT_XCARD_HXX
#define CXX_BUILD_LIBKOLABXML_SRC_LKX_SCHEMAS_KOLABFORMAT_XCARD_HXX

#ifndef XSD_CXX11
#define XSD_CXX11
#endif

#ifndef XSD_USE_CHAR
#define XSD_USE_CHAR
#endif

#ifndef XSD_CXX_TREE_USE_CHAR
#define XSD_CXX_TREE_USE_CHAR
#endif

// Begin prologue.
//
//
// End prologue.

#include <xsd/cxx/config.hxx>

#if (LIBXSD_VERSION != 400002000000000L)
#error XSD runtime version mismatch
#endif

#include <xsd/cxx/pre.hxx>

#include <xsd/cxx/xml/char-utf8.hxx>

#include <xsd/cxx/tree/exceptions.hxx>
#include <xsd/cxx/tree/elements.hxx>
#include <xsd/cxx/tree/types.hxx>

#include <xsd/cxx/xml/error-handler.hxx>

#include <xsd/cxx/xml/dom/auto-ptr.hxx>

#include <xsd/cxx/tree/parsing.hxx>
#include <xsd/cxx/tree/parsing/byte.hxx>
#include <xsd/cxx/tree/parsing/unsigned-byte.hxx>
#include <xsd/cxx/tree/parsing/short.hxx>
#include <xsd/cxx/tree/parsing/unsigned-short.hxx>
#include <xsd/cxx/tree/parsing/int.hxx>
#include <xsd/cxx/tree/parsing/unsigned-int.hxx>
#include <xsd/cxx/tree/parsing/long.hxx>
#include <xsd/cxx/tree/parsing/unsigned-long.hxx>
#include <xsd/cxx/tree/parsing/boolean.hxx>
#include <xsd/cxx/tree/parsing/float.hxx>
#include <xsd/cxx/tree/parsing/double.hxx>
#include <xsd/cxx/tree/parsing/decimal.hxx>

#include <xsd/cxx/xml/dom/serialization-header.hxx>
#include <xsd/cxx/tree/serialization.hxx>
#include <xsd/cxx/tree/serialization/byte.hxx>
#include <xsd/cxx/tree/serialization/unsigned-byte.hxx>
#include <xsd/cxx/tree/serialization/short.hxx>
#include <xsd/cxx/tree/serialization/unsigned-short.hxx>
#include <xsd/cxx/tree/serialization/int.hxx>
#include <xsd/cxx/tree/serialization/unsigned-int.hxx>
#include <xsd/cxx/tree/serialization/long.hxx>
#include <xsd/cxx/tree/serialization/unsigned-long.hxx>
#include <xsd/cxx/tree/serialization/boolean.hxx>
#include <xsd/cxx/tree/serialization/float.hxx>
#include <xsd/cxx/tree/serialization/double.hxx>
#include <xsd/cxx/tree/serialization/decimal.hxx>

namespace xml_schema
{
  // anyType and anySimpleType.
  //
  typedef ::xsd::cxx::tree::type type;
  typedef ::xsd::cxx::tree::simple_type< char, type > simple_type;
  typedef ::xsd::cxx::tree::type container;

  // 8-bit
  //
  typedef signed char byte;
  typedef unsigned char unsigned_byte;

  // 16-bit
  //
  typedef short short_;
  typedef unsigned short unsigned_short;

  // 32-bit
  //
  typedef int int_;
  typedef unsigned int unsigned_int;

  // 64-bit
  //
  typedef long long long_;
  typedef unsigned long long unsigned_long;

  // Supposed to be arbitrary-length integral types.
  //
  typedef long long integer;
  typedef long long non_positive_integer;
  typedef unsigned long long non_negative_integer;
  typedef unsigned long long positive_integer;
  typedef long long negative_integer;

  // Boolean.
  //
  typedef bool boolean;

  // Floating-point types.
  //
  typedef float float_;
  typedef double double_;
  typedef double decimal;

  // String types.
  //
  typedef ::xsd::cxx::tree::string< char, simple_type > string;
  typedef ::xsd::cxx::tree::normalized_string< char, string > normalized_string;
  typedef ::xsd::cxx::tree::token< char, normalized_string > token;
  typedef ::xsd::cxx::tree::name< char, token > name;
  typedef ::xsd::cxx::tree::nmtoken< char, token > nmtoken;
  typedef ::xsd::cxx::tree::nmtokens< char, simple_type, nmtoken > nmtokens;
  typedef ::xsd::cxx::tree::ncname< char, name > ncname;
  typedef ::xsd::cxx::tree::language< char, token > language;

  // ID/IDREF.
  //
  typedef ::xsd::cxx::tree::id< char, ncname > id;
  typedef ::xsd::cxx::tree::idref< char, ncname, type > idref;
  typedef ::xsd::cxx::tree::idrefs< char, simple_type, idref > idrefs;

  // URI.
  //
  typedef ::xsd::cxx::tree::uri< char, simple_type > uri;

  // Qualified name.
  //
  typedef ::xsd::cxx::tree::qname< char, simple_type, uri, ncname > qname;

  // Binary.
  //
  typedef ::xsd::cxx::tree::buffer< char > buffer;
  typedef ::xsd::cxx::tree::base64_binary< char, simple_type > base64_binary;
  typedef ::xsd::cxx::tree::hex_binary< char, simple_type > hex_binary;

  // Date/time.
  //
  typedef ::xsd::cxx::tree::time_zone time_zone;
  typedef ::xsd::cxx::tree::date< char, simple_type > date;
  typedef ::xsd::cxx::tree::date_time< char, simple_type > date_time;
  typedef ::xsd::cxx::tree::duration< char, simple_type > duration;
  typedef ::xsd::cxx::tree::gday< char, simple_type > gday;
  typedef ::xsd::cxx::tree::gmonth< char, simple_type > gmonth;
  typedef ::xsd::cxx::tree::gmonth_day< char, simple_type > gmonth_day;
  typedef ::xsd::cxx::tree::gyear< char, simple_type > gyear;
  typedef ::xsd::cxx::tree::gyear_month< char, simple_type > gyear_month;
  typedef ::xsd::cxx::tree::time< char, simple_type > time;

  // Entity.
  //
  typedef ::xsd::cxx::tree::entity< char, ncname > entity;
  typedef ::xsd::cxx::tree::entities< char, simple_type, entity > entities;

  typedef ::xsd::cxx::tree::content_order content_order;
  // Namespace information and list stream. Used in
  // serialization functions.
  //
  typedef ::xsd::cxx::xml::dom::namespace_info< char > namespace_info;
  typedef ::xsd::cxx::xml::dom::namespace_infomap< char > namespace_infomap;
  typedef ::xsd::cxx::tree::list_stream< char > list_stream;
  typedef ::xsd::cxx::tree::as_double< double_ > as_double;
  typedef ::xsd::cxx::tree::as_decimal< decimal > as_decimal;
  typedef ::xsd::cxx::tree::facet facet;

  // Flags and properties.
  //
  typedef ::xsd::cxx::tree::flags flags;
  typedef ::xsd::cxx::tree::properties< char > properties;

  // Parsing/serialization diagnostics.
  //
  typedef ::xsd::cxx::tree::severity severity;
  typedef ::xsd::cxx::tree::error< char > error;
  typedef ::xsd::cxx::tree::diagnostics< char > diagnostics;

  // Exceptions.
  //
  typedef ::xsd::cxx::tree::exception< char > exception;
  typedef ::xsd::cxx::tree::bounds< char > bounds;
  typedef ::xsd::cxx::tree::duplicate_id< char > duplicate_id;
  typedef ::xsd::cxx::tree::parsing< char > parsing;
  typedef ::xsd::cxx::tree::expected_element< char > expected_element;
  typedef ::xsd::cxx::tree::unexpected_element< char > unexpected_element;
  typedef ::xsd::cxx::tree::expected_attribute< char > expected_attribute;
  typedef ::xsd::cxx::tree::unexpected_enumerator< char > unexpected_enumerator;
  typedef ::xsd::cxx::tree::expected_text_content< char > expected_text_content;
  typedef ::xsd::cxx::tree::no_prefix_mapping< char > no_prefix_mapping;
  typedef ::xsd::cxx::tree::no_type_info< char > no_type_info;
  typedef ::xsd::cxx::tree::not_derived< char > not_derived;
  typedef ::xsd::cxx::tree::serialization< char > serialization;

  // Error handler callback interface.
  //
  typedef ::xsd::cxx::xml::error_handler< char > error_handler;

  // DOM interaction.
  //
  namespace dom
  {
    // Automatic pointer for DOMDocument.
    //
    using ::xsd::cxx::xml::dom::unique_ptr;

#ifndef XSD_CXX_TREE_TREE_NODE_KEY__XML_SCHEMA
#define XSD_CXX_TREE_TREE_NODE_KEY__XML_SCHEMA
    // DOM user data key for back pointers to tree nodes.
    //
    const XMLCh* const tree_node_key = ::xsd::cxx::tree::user_data_keys::node;
#endif
  }
}

// Forward declarations.
//
namespace vcard_4_0
{
  class KolabVersion;
  class CustomType;
  class CryptoTypeValueType;
  class PrefTypeValueType;
  class CryptoType;
  class VcardsType;
  class allowed;
  class signpref;
  class encryptpref;
  class vcard;
}


#include <memory>    // ::std::unique_ptr
#include <limits>    // std::numeric_limits
#include <algorithm> // std::binary_search
#include <utility>   // std::move

#include <xsd/cxx/xml/char-utf8.hxx>

#include <xsd/cxx/tree/exceptions.hxx>
#include <xsd/cxx/tree/elements.hxx>
#include <xsd/cxx/tree/containers.hxx>
#include <xsd/cxx/tree/list.hxx>

#include <xsd/cxx/xml/dom/parsing-header.hxx>

#include "xCard.hxx"

namespace vcard_4_0
{
  class KolabVersion: public ::vcard_4_0::BasePropertyType
  {
    public:
    // text
    //
    typedef ::xml_schema::string text_type;
    typedef ::xsd::cxx::tree::traits< text_type, char > text_traits;

    const text_type&
    text () const;

    text_type&
    text ();

    void
    text (const text_type& x);

    void
    text (::std::unique_ptr< text_type > p);

    static const text_type&
    text_default_value ();

    // Constructors.
    //
    KolabVersion (const text_type&);

    KolabVersion (const ::xercesc::DOMElement& e,
                  ::xml_schema::flags f = 0,
                  ::xml_schema::container* c = 0);

    KolabVersion (const KolabVersion& x,
                  ::xml_schema::flags f = 0,
                  ::xml_schema::container* c = 0);

    virtual KolabVersion*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    KolabVersion&
    operator= (const KolabVersion& x);

    virtual 
    ~KolabVersion ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< text_type > text_;
    static const text_type text_default_value_;
  };

  class CustomType: public ::vcard_4_0::BasePropertyType
  {
    public:
    // identifier
    //
    typedef ::xml_schema::string identifier_type;
    typedef ::xsd::cxx::tree::traits< identifier_type, char > identifier_traits;

    const identifier_type&
    identifier () const;

    identifier_type&
    identifier ();

    void
    identifier (const identifier_type& x);

    void
    identifier (::std::unique_ptr< identifier_type > p);

    // value
    //
    typedef ::xml_schema::string value_type;
    typedef ::xsd::cxx::tree::traits< value_type, char > value_traits;

    const value_type&
    value () const;

    value_type&
    value ();

    void
    value (const value_type& x);

    void
    value (::std::unique_ptr< value_type > p);

    // Constructors.
    //
    CustomType (const identifier_type&,
                const value_type&);

    CustomType (const ::xercesc::DOMElement& e,
                ::xml_schema::flags f = 0,
                ::xml_schema::container* c = 0);

    CustomType (const CustomType& x,
                ::xml_schema::flags f = 0,
                ::xml_schema::container* c = 0);

    virtual CustomType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    CustomType&
    operator= (const CustomType& x);

    virtual 
    ~CustomType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< identifier_type > identifier_;
    ::xsd::cxx::tree::one< value_type > value_;
  };

  class CryptoTypeValueType: public ::xml_schema::token
  {
    public:
    enum value
    {
      PGP_INLINE,
      PGP_MIME,
      S_MIME,
      S_MIMEOpaque
    };

    CryptoTypeValueType (value v);

    CryptoTypeValueType (const char* v);

    CryptoTypeValueType (const ::std::string& v);

    CryptoTypeValueType (const ::xml_schema::token& v);

    CryptoTypeValueType (const ::xercesc::DOMElement& e,
                         ::xml_schema::flags f = 0,
                         ::xml_schema::container* c = 0);

    CryptoTypeValueType (const ::xercesc::DOMAttr& a,
                         ::xml_schema::flags f = 0,
                         ::xml_schema::container* c = 0);

    CryptoTypeValueType (const ::std::string& s,
                         const ::xercesc::DOMElement* e,
                         ::xml_schema::flags f = 0,
                         ::xml_schema::container* c = 0);

    CryptoTypeValueType (const CryptoTypeValueType& x,
                         ::xml_schema::flags f = 0,
                         ::xml_schema::container* c = 0);

#ifdef XSD_CXX11
    CryptoTypeValueType&
    operator= (const CryptoTypeValueType&) = default;
#endif

    virtual CryptoTypeValueType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    CryptoTypeValueType&
    operator= (value v);

    virtual
    operator value () const
    {
      return _xsd_CryptoTypeValueType_convert ();
    }

    protected:
    value
    _xsd_CryptoTypeValueType_convert () const;

    public:
    static const char* const _xsd_CryptoTypeValueType_literals_[4];
    static const value _xsd_CryptoTypeValueType_indexes_[4];
  };

  class PrefTypeValueType: public ::xml_schema::token
  {
    public:
    enum value
    {
      Never,
      Always,
      IfPossible,
      Ask
    };

    PrefTypeValueType (value v);

    PrefTypeValueType (const char* v);

    PrefTypeValueType (const ::std::string& v);

    PrefTypeValueType (const ::xml_schema::token& v);

    PrefTypeValueType (const ::xercesc::DOMElement& e,
                       ::xml_schema::flags f = 0,
                       ::xml_schema::container* c = 0);

    PrefTypeValueType (const ::xercesc::DOMAttr& a,
                       ::xml_schema::flags f = 0,
                       ::xml_schema::container* c = 0);

    PrefTypeValueType (const ::std::string& s,
                       const ::xercesc::DOMElement* e,
                       ::xml_schema::flags f = 0,
                       ::xml_schema::container* c = 0);

    PrefTypeValueType (const PrefTypeValueType& x,
                       ::xml_schema::flags f = 0,
                       ::xml_schema::container* c = 0);

#ifdef XSD_CXX11
    PrefTypeValueType&
    operator= (const PrefTypeValueType&) = default;
#endif

    virtual PrefTypeValueType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    PrefTypeValueType&
    operator= (value v);

    virtual
    operator value () const
    {
      return _xsd_PrefTypeValueType_convert ();
    }

    protected:
    value
    _xsd_PrefTypeValueType_convert () const;

    public:
    static const char* const _xsd_PrefTypeValueType_literals_[4];
    static const value _xsd_PrefTypeValueType_indexes_[4];
  };

  class CryptoType: public ::vcard_4_0::BasePropertyType
  {
    public:
    // allowed
    //
    typedef ::vcard_4_0::allowed allowed_type;
    typedef ::xsd::cxx::tree::optional< allowed_type > allowed_optional;
    typedef ::xsd::cxx::tree::traits< allowed_type, char > allowed_traits;

    const allowed_optional&
    allowed () const;

    allowed_optional&
    allowed ();

    void
    allowed (const allowed_type& x);

    void
    allowed (const allowed_optional& x);

    void
    allowed (::std::unique_ptr< allowed_type > p);

    // signpref
    //
    typedef ::vcard_4_0::signpref signpref_type;
    typedef ::xsd::cxx::tree::optional< signpref_type > signpref_optional;
    typedef ::xsd::cxx::tree::traits< signpref_type, char > signpref_traits;

    const signpref_optional&
    signpref () const;

    signpref_optional&
    signpref ();

    void
    signpref (const signpref_type& x);

    void
    signpref (const signpref_optional& x);

    void
    signpref (::std::unique_ptr< signpref_type > p);

    // encryptpref
    //
    typedef ::vcard_4_0::encryptpref encryptpref_type;
    typedef ::xsd::cxx::tree::optional< encryptpref_type > encryptpref_optional;
    typedef ::xsd::cxx::tree::traits< encryptpref_type, char > encryptpref_traits;

    const encryptpref_optional&
    encryptpref () const;

    encryptpref_optional&
    encryptpref ();

    void
    encryptpref (const encryptpref_type& x);

    void
    encryptpref (const encryptpref_optional& x);

    void
    encryptpref (::std::unique_ptr< encryptpref_type > p);

    // Constructors.
    //
    CryptoType ();

    CryptoType (const ::xercesc::DOMElement& e,
                ::xml_schema::flags f = 0,
                ::xml_schema::container* c = 0);

    CryptoType (const CryptoType& x,
                ::xml_schema::flags f = 0,
                ::xml_schema::container* c = 0);

    virtual CryptoType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    CryptoType&
    operator= (const CryptoType& x);

    virtual 
    ~CryptoType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    allowed_optional allowed_;
    signpref_optional signpref_;
    encryptpref_optional encryptpref_;
  };

  class VcardsType: public ::xml_schema::type
  {
    public:
    // vcard
    //
    typedef ::vcard_4_0::vcard vcard_type;
    typedef ::xsd::cxx::tree::traits< vcard_type, char > vcard_traits;

    const vcard_type&
    vcard () const;

    vcard_type&
    vcard ();

    void
    vcard (const vcard_type& x);

    void
    vcard (::std::unique_ptr< vcard_type > p);

    // Constructors.
    //
    VcardsType (const vcard_type&);

    VcardsType (::std::unique_ptr< vcard_type >);

    VcardsType (const ::xercesc::DOMElement& e,
                ::xml_schema::flags f = 0,
                ::xml_schema::container* c = 0);

    VcardsType (const VcardsType& x,
                ::xml_schema::flags f = 0,
                ::xml_schema::container* c = 0);

    virtual VcardsType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    VcardsType&
    operator= (const VcardsType& x);

    virtual 
    ~VcardsType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< vcard_type > vcard_;
  };

  class allowed: public ::xml_schema::type
  {
    public:
    // text
    //
    typedef ::vcard_4_0::CryptoTypeValueType text_type;
    typedef ::xsd::cxx::tree::sequence< text_type > text_sequence;
    typedef text_sequence::iterator text_iterator;
    typedef text_sequence::const_iterator text_const_iterator;
    typedef ::xsd::cxx::tree::traits< text_type, char > text_traits;

    const text_sequence&
    text () const;

    text_sequence&
    text ();

    void
    text (const text_sequence& s);

    // Constructors.
    //
    allowed ();

    allowed (const ::xercesc::DOMElement& e,
             ::xml_schema::flags f = 0,
             ::xml_schema::container* c = 0);

    allowed (const allowed& x,
             ::xml_schema::flags f = 0,
             ::xml_schema::container* c = 0);

    virtual allowed*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    allowed&
    operator= (const allowed& x);

    virtual 
    ~allowed ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    text_sequence text_;
  };

  class signpref: public ::xml_schema::type
  {
    public:
    // text
    //
    typedef ::vcard_4_0::PrefTypeValueType text_type;
    typedef ::xsd::cxx::tree::traits< text_type, char > text_traits;

    const text_type&
    text () const;

    text_type&
    text ();

    void
    text (const text_type& x);

    void
    text (::std::unique_ptr< text_type > p);

    // Constructors.
    //
    signpref (const text_type&);

    signpref (const ::xercesc::DOMElement& e,
              ::xml_schema::flags f = 0,
              ::xml_schema::container* c = 0);

    signpref (const signpref& x,
              ::xml_schema::flags f = 0,
              ::xml_schema::container* c = 0);

    virtual signpref*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    signpref&
    operator= (const signpref& x);

    virtual 
    ~signpref ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< text_type > text_;
  };

  class encryptpref: public ::xml_schema::type
  {
    public:
    // text
    //
    typedef ::vcard_4_0::PrefTypeValueType text_type;
    typedef ::xsd::cxx::tree::traits< text_type, char > text_traits;

    const text_type&
    text () const;

    text_type&
    text ();

    void
    text (const text_type& x);

    void
    text (::std::unique_ptr< text_type > p);

    // Constructors.
    //
    encryptpref (const text_type&);

    encryptpref (const ::xercesc::DOMElement& e,
                 ::xml_schema::flags f = 0,
                 ::xml_schema::container* c = 0);

    encryptpref (const encryptpref& x,
                 ::xml_schema::flags f = 0,
                 ::xml_schema::container* c = 0);

    virtual encryptpref*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    encryptpref&
    operator= (const encryptpref& x);

    virtual 
    ~encryptpref ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< text_type > text_;
  };

  class vcard: public ::xml_schema::type
  {
    public:
    // uid
    //
    typedef ::vcard_4_0::uidPropType uid_type;
    typedef ::xsd::cxx::tree::traits< uid_type, char > uid_traits;

    const uid_type&
    uid () const;

    uid_type&
    uid ();

    void
    uid (const uid_type& x);

    void
    uid (::std::unique_ptr< uid_type > p);

    // x-kolab-version
    //
    typedef ::vcard_4_0::KolabVersion x_kolab_version_type;
    typedef ::xsd::cxx::tree::traits< x_kolab_version_type, char > x_kolab_version_traits;

    const x_kolab_version_type&
    x_kolab_version () const;

    x_kolab_version_type&
    x_kolab_version ();

    void
    x_kolab_version (const x_kolab_version_type& x);

    void
    x_kolab_version (::std::unique_ptr< x_kolab_version_type > p);

    // prodid
    //
    typedef ::vcard_4_0::prodidPropType prodid_type;
    typedef ::xsd::cxx::tree::traits< prodid_type, char > prodid_traits;

    const prodid_type&
    prodid () const;

    prodid_type&
    prodid ();

    void
    prodid (const prodid_type& x);

    void
    prodid (::std::unique_ptr< prodid_type > p);

    // rev
    //
    typedef ::vcard_4_0::revPropType rev_type;
    typedef ::xsd::cxx::tree::traits< rev_type, char > rev_traits;

    const rev_type&
    rev () const;

    rev_type&
    rev ();

    void
    rev (const rev_type& x);

    void
    rev (::std::unique_ptr< rev_type > p);

    // categories
    //
    typedef ::vcard_4_0::categoriesPropType categories_type;
    typedef ::xsd::cxx::tree::optional< categories_type > categories_optional;
    typedef ::xsd::cxx::tree::traits< categories_type, char > categories_traits;

    const categories_optional&
    categories () const;

    categories_optional&
    categories ();

    void
    categories (const categories_type& x);

    void
    categories (const categories_optional& x);

    void
    categories (::std::unique_ptr< categories_type > p);

    // kind
    //
    typedef ::vcard_4_0::kindPropType kind_type;
    typedef ::xsd::cxx::tree::traits< kind_type, char > kind_traits;

    const kind_type&
    kind () const;

    kind_type&
    kind ();

    void
    kind (const kind_type& x);

    void
    kind (::std::unique_ptr< kind_type > p);

    // fn
    //
    typedef ::vcard_4_0::fnPropType fn_type;
    typedef ::xsd::cxx::tree::traits< fn_type, char > fn_traits;

    const fn_type&
    fn () const;

    fn_type&
    fn ();

    void
    fn (const fn_type& x);

    void
    fn (::std::unique_ptr< fn_type > p);

    // n
    //
    typedef ::vcard_4_0::nPropType n_type;
    typedef ::xsd::cxx::tree::optional< n_type > n_optional;
    typedef ::xsd::cxx::tree::traits< n_type, char > n_traits;

    const n_optional&
    n () const;

    n_optional&
    n ();

    void
    n (const n_type& x);

    void
    n (const n_optional& x);

    void
    n (::std::unique_ptr< n_type > p);

    // note
    //
    typedef ::vcard_4_0::notePropType note_type;
    typedef ::xsd::cxx::tree::optional< note_type > note_optional;
    typedef ::xsd::cxx::tree::traits< note_type, char > note_traits;

    const note_optional&
    note () const;

    note_optional&
    note ();

    void
    note (const note_type& x);

    void
    note (const note_optional& x);

    void
    note (::std::unique_ptr< note_type > p);

    // fburl
    //
    typedef ::vcard_4_0::fburlPropType fburl_type;
    typedef ::xsd::cxx::tree::optional< fburl_type > fburl_optional;
    typedef ::xsd::cxx::tree::traits< fburl_type, char > fburl_traits;

    const fburl_optional&
    fburl () const;

    fburl_optional&
    fburl ();

    void
    fburl (const fburl_type& x);

    void
    fburl (const fburl_optional& x);

    void
    fburl (::std::unique_ptr< fburl_type > p);

    // title
    //
    typedef ::vcard_4_0::titlePropType title_type;
    typedef ::xsd::cxx::tree::sequence< title_type > title_sequence;
    typedef title_sequence::iterator title_iterator;
    typedef title_sequence::const_iterator title_const_iterator;
    typedef ::xsd::cxx::tree::traits< title_type, char > title_traits;

    const title_sequence&
    title () const;

    title_sequence&
    title ();

    void
    title (const title_sequence& s);

    // group
    //
    typedef ::vcard_4_0::affiliationPropType group_type;
    typedef ::xsd::cxx::tree::sequence< group_type > group_sequence;
    typedef group_sequence::iterator group_iterator;
    typedef group_sequence::const_iterator group_const_iterator;
    typedef ::xsd::cxx::tree::traits< group_type, char > group_traits;

    const group_sequence&
    group () const;

    group_sequence&
    group ();

    void
    group (const group_sequence& s);

    // url
    //
    typedef ::vcard_4_0::urlPropType url_type;
    typedef ::xsd::cxx::tree::sequence< url_type > url_sequence;
    typedef url_sequence::iterator url_iterator;
    typedef url_sequence::const_iterator url_const_iterator;
    typedef ::xsd::cxx::tree::traits< url_type, char > url_traits;

    const url_sequence&
    url () const;

    url_sequence&
    url ();

    void
    url (const url_sequence& s);

    // adr
    //
    typedef ::vcard_4_0::adrPropType adr_type;
    typedef ::xsd::cxx::tree::sequence< adr_type > adr_sequence;
    typedef adr_sequence::iterator adr_iterator;
    typedef adr_sequence::const_iterator adr_const_iterator;
    typedef ::xsd::cxx::tree::traits< adr_type, char > adr_traits;

    const adr_sequence&
    adr () const;

    adr_sequence&
    adr ();

    void
    adr (const adr_sequence& s);

    // nickname
    //
    typedef ::vcard_4_0::nicknamePropType nickname_type;
    typedef ::xsd::cxx::tree::optional< nickname_type > nickname_optional;
    typedef ::xsd::cxx::tree::traits< nickname_type, char > nickname_traits;

    const nickname_optional&
    nickname () const;

    nickname_optional&
    nickname ();

    void
    nickname (const nickname_type& x);

    void
    nickname (const nickname_optional& x);

    void
    nickname (::std::unique_ptr< nickname_type > p);

    // related
    //
    typedef ::vcard_4_0::relatedPropType related_type;
    typedef ::xsd::cxx::tree::sequence< related_type > related_sequence;
    typedef related_sequence::iterator related_iterator;
    typedef related_sequence::const_iterator related_const_iterator;
    typedef ::xsd::cxx::tree::traits< related_type, char > related_traits;

    const related_sequence&
    related () const;

    related_sequence&
    related ();

    void
    related (const related_sequence& s);

    // bday
    //
    typedef ::vcard_4_0::bdayPropType bday_type;
    typedef ::xsd::cxx::tree::optional< bday_type > bday_optional;
    typedef ::xsd::cxx::tree::traits< bday_type, char > bday_traits;

    const bday_optional&
    bday () const;

    bday_optional&
    bday ();

    void
    bday (const bday_type& x);

    void
    bday (const bday_optional& x);

    void
    bday (::std::unique_ptr< bday_type > p);

    // anniversary
    //
    typedef ::vcard_4_0::anniversaryPropType anniversary_type;
    typedef ::xsd::cxx::tree::optional< anniversary_type > anniversary_optional;
    typedef ::xsd::cxx::tree::traits< anniversary_type, char > anniversary_traits;

    const anniversary_optional&
    anniversary () const;

    anniversary_optional&
    anniversary ();

    void
    anniversary (const anniversary_type& x);

    void
    anniversary (const anniversary_optional& x);

    void
    anniversary (::std::unique_ptr< anniversary_type > p);

    // photo
    //
    typedef ::vcard_4_0::photoPropType photo_type;
    typedef ::xsd::cxx::tree::optional< photo_type > photo_optional;
    typedef ::xsd::cxx::tree::traits< photo_type, char > photo_traits;

    const photo_optional&
    photo () const;

    photo_optional&
    photo ();

    void
    photo (const photo_type& x);

    void
    photo (const photo_optional& x);

    void
    photo (::std::unique_ptr< photo_type > p);

    // gender
    //
    typedef ::vcard_4_0::genderPropType gender_type;
    typedef ::xsd::cxx::tree::optional< gender_type > gender_optional;
    typedef ::xsd::cxx::tree::traits< gender_type, char > gender_traits;

    const gender_optional&
    gender () const;

    gender_optional&
    gender ();

    void
    gender (const gender_type& x);

    void
    gender (const gender_optional& x);

    void
    gender (::std::unique_ptr< gender_type > p);

    // lang
    //
    typedef ::vcard_4_0::langPropType lang_type;
    typedef ::xsd::cxx::tree::sequence< lang_type > lang_sequence;
    typedef lang_sequence::iterator lang_iterator;
    typedef lang_sequence::const_iterator lang_const_iterator;
    typedef ::xsd::cxx::tree::traits< lang_type, char > lang_traits;

    const lang_sequence&
    lang () const;

    lang_sequence&
    lang ();

    void
    lang (const lang_sequence& s);

    // tel
    //
    typedef ::vcard_4_0::telPropType tel_type;
    typedef ::xsd::cxx::tree::sequence< tel_type > tel_sequence;
    typedef tel_sequence::iterator tel_iterator;
    typedef tel_sequence::const_iterator tel_const_iterator;
    typedef ::xsd::cxx::tree::traits< tel_type, char > tel_traits;

    const tel_sequence&
    tel () const;

    tel_sequence&
    tel ();

    void
    tel (const tel_sequence& s);

    // impp
    //
    typedef ::vcard_4_0::imppPropType impp_type;
    typedef ::xsd::cxx::tree::sequence< impp_type > impp_sequence;
    typedef impp_sequence::iterator impp_iterator;
    typedef impp_sequence::const_iterator impp_const_iterator;
    typedef ::xsd::cxx::tree::traits< impp_type, char > impp_traits;

    const impp_sequence&
    impp () const;

    impp_sequence&
    impp ();

    void
    impp (const impp_sequence& s);

    // email
    //
    typedef ::vcard_4_0::emailPropType email_type;
    typedef ::xsd::cxx::tree::sequence< email_type > email_sequence;
    typedef email_sequence::iterator email_iterator;
    typedef email_sequence::const_iterator email_const_iterator;
    typedef ::xsd::cxx::tree::traits< email_type, char > email_traits;

    const email_sequence&
    email () const;

    email_sequence&
    email ();

    void
    email (const email_sequence& s);

    // geo
    //
    typedef ::vcard_4_0::geoPropType geo_type;
    typedef ::xsd::cxx::tree::sequence< geo_type > geo_sequence;
    typedef geo_sequence::iterator geo_iterator;
    typedef geo_sequence::const_iterator geo_const_iterator;
    typedef ::xsd::cxx::tree::traits< geo_type, char > geo_traits;

    const geo_sequence&
    geo () const;

    geo_sequence&
    geo ();

    void
    geo (const geo_sequence& s);

    // key
    //
    typedef ::vcard_4_0::keyPropType key_type;
    typedef ::xsd::cxx::tree::sequence< key_type > key_sequence;
    typedef key_sequence::iterator key_iterator;
    typedef key_sequence::const_iterator key_const_iterator;
    typedef ::xsd::cxx::tree::traits< key_type, char > key_traits;

    const key_sequence&
    key () const;

    key_sequence&
    key ();

    void
    key (const key_sequence& s);

    // x-crypto
    //
    typedef ::vcard_4_0::CryptoType x_crypto_type;
    typedef ::xsd::cxx::tree::optional< x_crypto_type > x_crypto_optional;
    typedef ::xsd::cxx::tree::traits< x_crypto_type, char > x_crypto_traits;

    const x_crypto_optional&
    x_crypto () const;

    x_crypto_optional&
    x_crypto ();

    void
    x_crypto (const x_crypto_type& x);

    void
    x_crypto (const x_crypto_optional& x);

    void
    x_crypto (::std::unique_ptr< x_crypto_type > p);

    // member
    //
    typedef ::vcard_4_0::memberPropType member_type;
    typedef ::xsd::cxx::tree::sequence< member_type > member_sequence;
    typedef member_sequence::iterator member_iterator;
    typedef member_sequence::const_iterator member_const_iterator;
    typedef ::xsd::cxx::tree::traits< member_type, char > member_traits;

    const member_sequence&
    member () const;

    member_sequence&
    member ();

    void
    member (const member_sequence& s);

    // x-custom
    //
    typedef ::vcard_4_0::CustomType x_custom_type;
    typedef ::xsd::cxx::tree::sequence< x_custom_type > x_custom_sequence;
    typedef x_custom_sequence::iterator x_custom_iterator;
    typedef x_custom_sequence::const_iterator x_custom_const_iterator;
    typedef ::xsd::cxx::tree::traits< x_custom_type, char > x_custom_traits;

    const x_custom_sequence&
    x_custom () const;

    x_custom_sequence&
    x_custom ();

    void
    x_custom (const x_custom_sequence& s);

    // Constructors.
    //
    vcard (const uid_type&,
           const x_kolab_version_type&,
           const prodid_type&,
           const rev_type&,
           const kind_type&,
           const fn_type&);

    vcard (::std::unique_ptr< uid_type >,
           ::std::unique_ptr< x_kolab_version_type >,
           ::std::unique_ptr< prodid_type >,
           ::std::unique_ptr< rev_type >,
           ::std::unique_ptr< kind_type >,
           ::std::unique_ptr< fn_type >);

    vcard (const ::xercesc::DOMElement& e,
           ::xml_schema::flags f = 0,
           ::xml_schema::container* c = 0);

    vcard (const vcard& x,
           ::xml_schema::flags f = 0,
           ::xml_schema::container* c = 0);

    virtual vcard*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    vcard&
    operator= (const vcard& x);

    virtual 
    ~vcard ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< uid_type > uid_;
    ::xsd::cxx::tree::one< x_kolab_version_type > x_kolab_version_;
    ::xsd::cxx::tree::one< prodid_type > prodid_;
    ::xsd::cxx::tree::one< rev_type > rev_;
    categories_optional categories_;
    ::xsd::cxx::tree::one< kind_type > kind_;
    ::xsd::cxx::tree::one< fn_type > fn_;
    n_optional n_;
    note_optional note_;
    fburl_optional fburl_;
    title_sequence title_;
    group_sequence group_;
    url_sequence url_;
    adr_sequence adr_;
    nickname_optional nickname_;
    related_sequence related_;
    bday_optional bday_;
    anniversary_optional anniversary_;
    photo_optional photo_;
    gender_optional gender_;
    lang_sequence lang_;
    tel_sequence tel_;
    impp_sequence impp_;
    email_sequence email_;
    geo_sequence geo_;
    key_sequence key_;
    x_crypto_optional x_crypto_;
    member_sequence member_;
    x_custom_sequence x_custom_;
  };
}

#include <iosfwd>

#include <xercesc/sax/InputSource.hpp>
#include <xercesc/dom/DOMDocument.hpp>
#include <xercesc/dom/DOMErrorHandler.hpp>

namespace vcard_4_0
{
  // Parse a URI or a local file.
  //

  ::std::unique_ptr< ::vcard_4_0::VcardsType >
  vcards (const ::std::string& uri,
          ::xml_schema::flags f = 0,
          const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::vcard_4_0::VcardsType >
  vcards (const ::std::string& uri,
          ::xml_schema::error_handler& eh,
          ::xml_schema::flags f = 0,
          const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::vcard_4_0::VcardsType >
  vcards (const ::std::string& uri,
          ::xercesc::DOMErrorHandler& eh,
          ::xml_schema::flags f = 0,
          const ::xml_schema::properties& p = ::xml_schema::properties ());

  // Parse std::istream.
  //

  ::std::unique_ptr< ::vcard_4_0::VcardsType >
  vcards (::std::istream& is,
          ::xml_schema::flags f = 0,
          const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::vcard_4_0::VcardsType >
  vcards (::std::istream& is,
          ::xml_schema::error_handler& eh,
          ::xml_schema::flags f = 0,
          const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::vcard_4_0::VcardsType >
  vcards (::std::istream& is,
          ::xercesc::DOMErrorHandler& eh,
          ::xml_schema::flags f = 0,
          const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::vcard_4_0::VcardsType >
  vcards (::std::istream& is,
          const ::std::string& id,
          ::xml_schema::flags f = 0,
          const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::vcard_4_0::VcardsType >
  vcards (::std::istream& is,
          const ::std::string& id,
          ::xml_schema::error_handler& eh,
          ::xml_schema::flags f = 0,
          const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::vcard_4_0::VcardsType >
  vcards (::std::istream& is,
          const ::std::string& id,
          ::xercesc::DOMErrorHandler& eh,
          ::xml_schema::flags f = 0,
          const ::xml_schema::properties& p = ::xml_schema::properties ());

  // Parse xercesc::InputSource.
  //

  ::std::unique_ptr< ::vcard_4_0::VcardsType >
  vcards (::xercesc::InputSource& is,
          ::xml_schema::flags f = 0,
          const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::vcard_4_0::VcardsType >
  vcards (::xercesc::InputSource& is,
          ::xml_schema::error_handler& eh,
          ::xml_schema::flags f = 0,
          const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::vcard_4_0::VcardsType >
  vcards (::xercesc::InputSource& is,
          ::xercesc::DOMErrorHandler& eh,
          ::xml_schema::flags f = 0,
          const ::xml_schema::properties& p = ::xml_schema::properties ());

  // Parse xercesc::DOMDocument.
  //

  ::std::unique_ptr< ::vcard_4_0::VcardsType >
  vcards (const ::xercesc::DOMDocument& d,
          ::xml_schema::flags f = 0,
          const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::vcard_4_0::VcardsType >
  vcards (::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d,
          ::xml_schema::flags f = 0,
          const ::xml_schema::properties& p = ::xml_schema::properties ());
}

#include <iosfwd>

#include <xercesc/dom/DOMDocument.hpp>
#include <xercesc/dom/DOMErrorHandler.hpp>
#include <xercesc/framework/XMLFormatter.hpp>

#include <xsd/cxx/xml/dom/auto-ptr.hxx>

namespace vcard_4_0
{
  void
  operator<< (::xercesc::DOMElement&, const KolabVersion&);

  void
  operator<< (::xercesc::DOMElement&, const CustomType&);

  void
  operator<< (::xercesc::DOMElement&, const CryptoTypeValueType&);

  void
  operator<< (::xercesc::DOMAttr&, const CryptoTypeValueType&);

  void
  operator<< (::xml_schema::list_stream&,
              const CryptoTypeValueType&);

  void
  operator<< (::xercesc::DOMElement&, const PrefTypeValueType&);

  void
  operator<< (::xercesc::DOMAttr&, const PrefTypeValueType&);

  void
  operator<< (::xml_schema::list_stream&,
              const PrefTypeValueType&);

  void
  operator<< (::xercesc::DOMElement&, const CryptoType&);

  void
  operator<< (::xercesc::DOMElement&, const VcardsType&);

  // Serialize to std::ostream.
  //

  void
  vcards (::std::ostream& os,
          const ::vcard_4_0::VcardsType& x, 
          const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
          const ::std::string& e = "UTF-8",
          ::xml_schema::flags f = 0);

  void
  vcards (::std::ostream& os,
          const ::vcard_4_0::VcardsType& x, 
          ::xml_schema::error_handler& eh,
          const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
          const ::std::string& e = "UTF-8",
          ::xml_schema::flags f = 0);

  void
  vcards (::std::ostream& os,
          const ::vcard_4_0::VcardsType& x, 
          ::xercesc::DOMErrorHandler& eh,
          const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
          const ::std::string& e = "UTF-8",
          ::xml_schema::flags f = 0);

  // Serialize to xercesc::XMLFormatTarget.
  //

  void
  vcards (::xercesc::XMLFormatTarget& ft,
          const ::vcard_4_0::VcardsType& x, 
          const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
          const ::std::string& e = "UTF-8",
          ::xml_schema::flags f = 0);

  void
  vcards (::xercesc::XMLFormatTarget& ft,
          const ::vcard_4_0::VcardsType& x, 
          ::xml_schema::error_handler& eh,
          const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
          const ::std::string& e = "UTF-8",
          ::xml_schema::flags f = 0);

  void
  vcards (::xercesc::XMLFormatTarget& ft,
          const ::vcard_4_0::VcardsType& x, 
          ::xercesc::DOMErrorHandler& eh,
          const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
          const ::std::string& e = "UTF-8",
          ::xml_schema::flags f = 0);

  // Serialize to an existing xercesc::DOMDocument.
  //

  void
  vcards (::xercesc::DOMDocument& d,
          const ::vcard_4_0::VcardsType& x,
          ::xml_schema::flags f = 0);

  // Serialize to a new xercesc::DOMDocument.
  //

  ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument >
  vcards (const ::vcard_4_0::VcardsType& x, 
          const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
          ::xml_schema::flags f = 0);

  void
  operator<< (::xercesc::DOMElement&, const allowed&);

  void
  operator<< (::xercesc::DOMElement&, const signpref&);

  void
  operator<< (::xercesc::DOMElement&, const encryptpref&);

  void
  operator<< (::xercesc::DOMElement&, const vcard&);
}

#include <xsd/cxx/post.hxx>

// Begin epilogue.
//
//
// End epilogue.

#endif // CXX_BUILD_LIBKOLABXML_SRC_LKX_SCHEMAS_KOLABFORMAT_XCARD_HXX
