
#include "ooxml/resourceids.hxx"
#include "OOXMLFactory_dml-baseTypes.hxx"
#include "ooxml/OOXMLFastHelper.hxx"
#include "oox/token/tokens.hxx"

#ifdef _MSC_VER
#pragma warning(disable:4060) // switch statement contains no 'case' or 'default' labels
#pragma warning(disable:4065) // switch statement contains 'default' but no 'case' labels
#pragma warning(disable:4702) // unreachable code
#endif

namespace writerfilter {
namespace ooxml {

using namespace com::sun::star;

/// @cond GENERATED

OOXMLFactory_dml_baseTypes::OOXMLFactory_dml_baseTypes()
{
}

OOXMLFactory_dml_baseTypes::~OOXMLFactory_dml_baseTypes()
{
}

OOXMLFactory_ns::Pointer_t OOXMLFactory_dml_baseTypes::m_pInstance;

OOXMLFactory_ns::Pointer_t OOXMLFactory_dml_baseTypes::getInstance()
{
    if (!m_pInstance)
        m_pInstance = new OOXMLFactory_dml_baseTypes();

    return m_pInstance;
}

const AttributeInfo* OOXMLFactory_dml_baseTypes::getAttributeInfoArray(Id nId)
{
    switch (nId)
    {
    case NN_dml_baseTypes|DEFINE_adec_decorative_val:
        {
            const static AttributeInfo info[] = {
                { oox::XML_val, ResourceType::Boolean, 0 },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    case NN_dml_baseTypes|DEFINE_CT_Angle:
        {
            const static AttributeInfo info[] = {
                { oox::XML_val, ResourceType::Integer, NN_dml_baseTypes|DEFINE_ST_Angle },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    case NN_dml_baseTypes|DEFINE_CT_Percentage:
        {
            const static AttributeInfo info[] = {
                { oox::XML_val, ResourceType::Integer, NN_dml_baseTypes|DEFINE_ST_Percentage },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    case NN_dml_baseTypes|DEFINE_CT_PositivePercentage:
        {
            const static AttributeInfo info[] = {
                { oox::XML_val, ResourceType::Value, NN_dml_baseTypes|DEFINE_ST_PositivePercentage },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    case NN_dml_baseTypes|DEFINE_CT_Point2D:
        {
            const static AttributeInfo info[] = {
                { oox::XML_x, ResourceType::EmuMeasure, NN_dml_baseTypes|DEFINE_ST_Coordinate },
                { oox::XML_y, ResourceType::EmuMeasure, NN_dml_baseTypes|DEFINE_ST_Coordinate },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    case NN_dml_baseTypes|DEFINE_CT_PositiveSize2D:
        {
            const static AttributeInfo info[] = {
                { oox::XML_cx, ResourceType::Integer, NN_dml_baseTypes|DEFINE_ST_PositiveCoordinate },
                { oox::XML_cy, ResourceType::Integer, NN_dml_baseTypes|DEFINE_ST_PositiveCoordinate },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    case NN_dml_baseTypes|DEFINE_CT_ScRgbColor:
        {
            const static AttributeInfo info[] = {
                { oox::XML_r, ResourceType::Integer, NN_dml_baseTypes|DEFINE_ST_Percentage },
                { oox::XML_g, ResourceType::Integer, NN_dml_baseTypes|DEFINE_ST_Percentage },
                { oox::XML_b, ResourceType::Integer, NN_dml_baseTypes|DEFINE_ST_Percentage },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    case NN_dml_baseTypes|DEFINE_CT_SRgbColor:
        {
            const static AttributeInfo info[] = {
                { oox::XML_val, ResourceType::Hex, NN_dml_baseTypes|DEFINE_ST_HexBinary3 },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    case NN_dml_baseTypes|DEFINE_CT_HslColor:
        {
            const static AttributeInfo info[] = {
                { oox::XML_sat, ResourceType::Integer, NN_dml_baseTypes|DEFINE_ST_Percentage },
                { oox::XML_lum, ResourceType::Integer, NN_dml_baseTypes|DEFINE_ST_Percentage },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    case NN_dml_baseTypes|DEFINE_CT_SystemColor:
        {
            const static AttributeInfo info[] = {
                { oox::XML_val, ResourceType::List, NN_dml_baseTypes|DEFINE_ST_SystemColorVal },
                { oox::XML_lastClr, ResourceType::Hex, NN_dml_baseTypes|DEFINE_ST_HexBinary3 },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    case NN_dml_baseTypes|DEFINE_CT_SchemeColor:
        {
            const static AttributeInfo info[] = {
                { oox::XML_val, ResourceType::List, NN_dml_baseTypes|DEFINE_ST_SchemeColorVal },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    case NN_dml_baseTypes|DEFINE_CT_PresetColor:
        {
            const static AttributeInfo info[] = {
                { oox::XML_val, ResourceType::List, NN_dml_baseTypes|DEFINE_ST_PresetColorVal },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    case NN_dml_baseTypes|DEFINE_CT_Transform2D:
        {
            const static AttributeInfo info[] = {
                { oox::XML_rot, ResourceType::Integer, NN_dml_baseTypes|DEFINE_ST_Angle },
                { oox::XML_flipH, ResourceType::Boolean, 0 },
                { oox::XML_flipV, ResourceType::Boolean, 0 },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    case NN_dml_baseTypes|DEFINE_CT_GroupTransform2D:
        {
            const static AttributeInfo info[] = {
                { oox::XML_rot, ResourceType::Integer, NN_dml_baseTypes|DEFINE_ST_Angle },
                { oox::XML_flipH, ResourceType::Boolean, 0 },
                { oox::XML_flipV, ResourceType::Boolean, 0 },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    case NN_dml_baseTypes|DEFINE_CT_Point3D:
        {
            const static AttributeInfo info[] = {
                { oox::XML_x, ResourceType::EmuMeasure, NN_dml_baseTypes|DEFINE_ST_Coordinate },
                { oox::XML_y, ResourceType::EmuMeasure, NN_dml_baseTypes|DEFINE_ST_Coordinate },
                { oox::XML_z, ResourceType::EmuMeasure, NN_dml_baseTypes|DEFINE_ST_Coordinate },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    case NN_dml_baseTypes|DEFINE_CT_Vector3D:
        {
            const static AttributeInfo info[] = {
                { oox::XML_dx, ResourceType::EmuMeasure, NN_dml_baseTypes|DEFINE_ST_Coordinate },
                { oox::XML_dy, ResourceType::EmuMeasure, NN_dml_baseTypes|DEFINE_ST_Coordinate },
                { oox::XML_dz, ResourceType::EmuMeasure, NN_dml_baseTypes|DEFINE_ST_Coordinate },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    case NN_dml_baseTypes|DEFINE_CT_RelativeRect:
        {
            const static AttributeInfo info[] = {
                { oox::XML_l, ResourceType::Integer, NN_dml_baseTypes|DEFINE_ST_Percentage },
                { oox::XML_t, ResourceType::Integer, NN_dml_baseTypes|DEFINE_ST_Percentage },
                { oox::XML_r, ResourceType::Integer, NN_dml_baseTypes|DEFINE_ST_Percentage },
                { oox::XML_b, ResourceType::Integer, NN_dml_baseTypes|DEFINE_ST_Percentage },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    case NN_dml_baseTypes|DEFINE_AG_Blob:
        {
            const static AttributeInfo info[] = {
                { oox::NMSP_officeRel|oox::XML_embed, ResourceType::String, 0 },
                { oox::NMSP_officeRel|oox::XML_link, ResourceType::String, 0 },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    case NN_dml_baseTypes|DEFINE_CT_EmbeddedWAVAudioFile:
        {
            const static AttributeInfo info[] = {
                { oox::XML_name, ResourceType::String, 0 },
                { oox::XML_builtIn, ResourceType::Boolean, 0 },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    case NN_dml_baseTypes|DEFINE_CT_Hyperlink:
        {
            const static AttributeInfo info[] = {
                { oox::XML_invalidUrl, ResourceType::String, 0 },
                { oox::XML_action, ResourceType::String, 0 },
                { oox::XML_tgtFrame, ResourceType::String, 0 },
                { oox::XML_tooltip, ResourceType::String, 0 },
                { oox::XML_history, ResourceType::Boolean, 0 },
                { oox::XML_highlightClick, ResourceType::Boolean, 0 },
                { oox::XML_endSnd, ResourceType::Boolean, 0 },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    default:
        break;
    }

    return NULL;
}

bool OOXMLFactory_dml_baseTypes::getListValue(Id nId, std::string_view aValue, sal_uInt32& rOutValue)
{
    (void) aValue;
    (void) rOutValue;

    switch (nId)
    {
    case NN_dml_baseTypes|DEFINE_ST_SystemColorVal:
        if (aValue.empty())
            return false;
        switch (aValue[0])
        {
        case '3':
            if (aValue == "3dDkShadow") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_SystemColorVal_3dDkShadow; }
            else if (aValue == "3dLight") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_SystemColorVal_3dLight; }
            else { return false; }
            return true;
        case 'a':
            if (aValue == "activeCaption") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_SystemColorVal_activeCaption; }
            else if (aValue == "activeBorder") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_SystemColorVal_activeBorder; }
            else if (aValue == "appWorkspace") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_SystemColorVal_appWorkspace; }
            else { return false; }
            return true;
        case 'b':
            if (aValue == "background") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_SystemColorVal_background; }
            else if (aValue == "btnFace") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_SystemColorVal_btnFace; }
            else if (aValue == "btnShadow") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_SystemColorVal_btnShadow; }
            else if (aValue == "btnText") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_SystemColorVal_btnText; }
            else if (aValue == "btnHighlight") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_SystemColorVal_btnHighlight; }
            else { return false; }
            return true;
        case 'c':
            if (aValue == "captionText") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_SystemColorVal_captionText; }
            else { return false; }
            return true;
        case 'g':
            if (aValue == "grayText") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_SystemColorVal_grayText; }
            else if (aValue == "gradientActiveCaption") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_SystemColorVal_gradientActiveCaption; }
            else if (aValue == "gradientInactiveCaption") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_SystemColorVal_gradientInactiveCaption; }
            else { return false; }
            return true;
        case 'h':
            if (aValue == "highlight") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_SystemColorVal_highlight; }
            else if (aValue == "highlightText") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_SystemColorVal_highlightText; }
            else if (aValue == "hotLight") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_SystemColorVal_hotLight; }
            else { return false; }
            return true;
        case 'i':
            if (aValue == "inactiveCaption") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_SystemColorVal_inactiveCaption; }
            else if (aValue == "inactiveBorder") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_SystemColorVal_inactiveBorder; }
            else if (aValue == "inactiveCaptionText") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_SystemColorVal_inactiveCaptionText; }
            else if (aValue == "infoText") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_SystemColorVal_infoText; }
            else if (aValue == "infoBk") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_SystemColorVal_infoBk; }
            else { return false; }
            return true;
        case 'm':
            if (aValue == "menu") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_SystemColorVal_menu; }
            else if (aValue == "menuText") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_SystemColorVal_menuText; }
            else if (aValue == "menuHighlight") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_SystemColorVal_menuHighlight; }
            else if (aValue == "menuBar") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_SystemColorVal_menuBar; }
            else { return false; }
            return true;
        case 's':
            if (aValue == "scrollBar") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_SystemColorVal_scrollBar; }
            else { return false; }
            return true;
        case 'w':
            if (aValue == "window") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_SystemColorVal_window; }
            else if (aValue == "windowFrame") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_SystemColorVal_windowFrame; }
            else if (aValue == "windowText") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_SystemColorVal_windowText; }
            else { return false; }
            return true;
        }
        return false;
    case NN_dml_baseTypes|DEFINE_ST_SchemeColorVal:
        if (aValue.empty())
            return false;
        switch (aValue[0])
        {
        case 'a':
            if (aValue == "accent1") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_SchemeColorVal_accent1; }
            else if (aValue == "accent2") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_SchemeColorVal_accent2; }
            else if (aValue == "accent3") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_SchemeColorVal_accent3; }
            else if (aValue == "accent4") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_SchemeColorVal_accent4; }
            else if (aValue == "accent5") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_SchemeColorVal_accent5; }
            else if (aValue == "accent6") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_SchemeColorVal_accent6; }
            else { return false; }
            return true;
        case 'b':
            if (aValue == "bg1") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_SchemeColorVal_bg1; }
            else if (aValue == "bg2") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_SchemeColorVal_bg2; }
            else { return false; }
            return true;
        case 'd':
            if (aValue == "dk1") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_SchemeColorVal_dk1; }
            else if (aValue == "dk2") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_SchemeColorVal_dk2; }
            else { return false; }
            return true;
        case 'f':
            if (aValue == "folHlink") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_SchemeColorVal_folHlink; }
            else { return false; }
            return true;
        case 'h':
            if (aValue == "hlink") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_SchemeColorVal_hlink; }
            else { return false; }
            return true;
        case 'l':
            if (aValue == "lt1") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_SchemeColorVal_lt1; }
            else if (aValue == "lt2") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_SchemeColorVal_lt2; }
            else { return false; }
            return true;
        case 'p':
            if (aValue == "phClr") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_SchemeColorVal_phClr; }
            else { return false; }
            return true;
        case 't':
            if (aValue == "tx1") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_SchemeColorVal_tx1; }
            else if (aValue == "tx2") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_SchemeColorVal_tx2; }
            else { return false; }
            return true;
        }
        return false;
    case NN_dml_baseTypes|DEFINE_ST_PresetColorVal:
        if (aValue.empty())
            return false;
        switch (aValue[0])
        {
        case 'a':
            if (aValue == "aliceBlue") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_aliceBlue; }
            else if (aValue == "antiqueWhite") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_antiqueWhite; }
            else if (aValue == "aqua") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_aqua; }
            else if (aValue == "aquamarine") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_aquamarine; }
            else if (aValue == "azure") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_azure; }
            else { return false; }
            return true;
        case 'b':
            if (aValue == "beige") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_beige; }
            else if (aValue == "bisque") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_bisque; }
            else if (aValue == "black") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_black; }
            else if (aValue == "blanchedAlmond") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_blanchedAlmond; }
            else if (aValue == "blue") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_blue; }
            else if (aValue == "blueViolet") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_blueViolet; }
            else if (aValue == "brown") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_brown; }
            else if (aValue == "burlyWood") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_burlyWood; }
            else { return false; }
            return true;
        case 'c':
            if (aValue == "cadetBlue") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_cadetBlue; }
            else if (aValue == "chartreuse") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_chartreuse; }
            else if (aValue == "chocolate") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_chocolate; }
            else if (aValue == "coral") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_coral; }
            else if (aValue == "cornflowerBlue") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_cornflowerBlue; }
            else if (aValue == "cornsilk") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_cornsilk; }
            else if (aValue == "crimson") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_crimson; }
            else if (aValue == "cyan") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_cyan; }
            else { return false; }
            return true;
        case 'd':
            if (aValue == "deepPink") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_deepPink; }
            else if (aValue == "deepSkyBlue") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_deepSkyBlue; }
            else if (aValue == "dimGray") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_dimGray; }
            else if (aValue == "dkBlue") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_dkBlue; }
            else if (aValue == "dkCyan") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_dkCyan; }
            else if (aValue == "dkGoldenrod") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_dkGoldenrod; }
            else if (aValue == "dkGray") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_dkGray; }
            else if (aValue == "dkGreen") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_dkGreen; }
            else if (aValue == "dkKhaki") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_dkKhaki; }
            else if (aValue == "dkMagenta") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_dkMagenta; }
            else if (aValue == "dkOliveGreen") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_dkOliveGreen; }
            else if (aValue == "dkOrange") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_dkOrange; }
            else if (aValue == "dkOrchid") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_dkOrchid; }
            else if (aValue == "dkRed") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_dkRed; }
            else if (aValue == "dkSalmon") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_dkSalmon; }
            else if (aValue == "dkSeaGreen") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_dkSeaGreen; }
            else if (aValue == "dkSlateBlue") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_dkSlateBlue; }
            else if (aValue == "dkSlateGray") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_dkSlateGray; }
            else if (aValue == "dkTurquoise") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_dkTurquoise; }
            else if (aValue == "dkViolet") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_dkViolet; }
            else if (aValue == "dodgerBlue") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_dodgerBlue; }
            else { return false; }
            return true;
        case 'f':
            if (aValue == "firebrick") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_firebrick; }
            else if (aValue == "floralWhite") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_floralWhite; }
            else if (aValue == "forestGreen") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_forestGreen; }
            else if (aValue == "fuchsia") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_fuchsia; }
            else { return false; }
            return true;
        case 'g':
            if (aValue == "gainsboro") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_gainsboro; }
            else if (aValue == "ghostWhite") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_ghostWhite; }
            else if (aValue == "gold") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_gold; }
            else if (aValue == "goldenrod") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_goldenrod; }
            else if (aValue == "gray") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_gray; }
            else if (aValue == "green") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_green; }
            else if (aValue == "greenYellow") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_greenYellow; }
            else { return false; }
            return true;
        case 'h':
            if (aValue == "honeydew") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_honeydew; }
            else if (aValue == "hotPink") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_hotPink; }
            else { return false; }
            return true;
        case 'i':
            if (aValue == "indianRed") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_indianRed; }
            else if (aValue == "indigo") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_indigo; }
            else if (aValue == "ivory") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_ivory; }
            else { return false; }
            return true;
        case 'k':
            if (aValue == "khaki") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_khaki; }
            else { return false; }
            return true;
        case 'l':
            if (aValue == "lavender") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_lavender; }
            else if (aValue == "lavenderBlush") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_lavenderBlush; }
            else if (aValue == "lawnGreen") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_lawnGreen; }
            else if (aValue == "lemonChiffon") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_lemonChiffon; }
            else if (aValue == "lime") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_lime; }
            else if (aValue == "limeGreen") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_limeGreen; }
            else if (aValue == "linen") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_linen; }
            else if (aValue == "ltBlue") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_ltBlue; }
            else if (aValue == "ltCoral") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_ltCoral; }
            else if (aValue == "ltCyan") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_ltCyan; }
            else if (aValue == "ltGoldenrodYellow") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_ltGoldenrodYellow; }
            else if (aValue == "ltGray") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_ltGray; }
            else if (aValue == "ltGreen") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_ltGreen; }
            else if (aValue == "ltPink") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_ltPink; }
            else if (aValue == "ltSalmon") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_ltSalmon; }
            else if (aValue == "ltSeaGreen") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_ltSeaGreen; }
            else if (aValue == "ltSkyBlue") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_ltSkyBlue; }
            else if (aValue == "ltSlateGray") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_ltSlateGray; }
            else if (aValue == "ltSteelBlue") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_ltSteelBlue; }
            else if (aValue == "ltYellow") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_ltYellow; }
            else { return false; }
            return true;
        case 'm':
            if (aValue == "magenta") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_magenta; }
            else if (aValue == "maroon") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_maroon; }
            else if (aValue == "medAquamarine") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_medAquamarine; }
            else if (aValue == "medBlue") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_medBlue; }
            else if (aValue == "medOrchid") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_medOrchid; }
            else if (aValue == "medPurple") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_medPurple; }
            else if (aValue == "medSeaGreen") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_medSeaGreen; }
            else if (aValue == "medSlateBlue") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_medSlateBlue; }
            else if (aValue == "medSpringGreen") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_medSpringGreen; }
            else if (aValue == "medTurquoise") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_medTurquoise; }
            else if (aValue == "medVioletRed") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_medVioletRed; }
            else if (aValue == "midnightBlue") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_midnightBlue; }
            else if (aValue == "mintCream") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_mintCream; }
            else if (aValue == "mistyRose") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_mistyRose; }
            else if (aValue == "moccasin") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_moccasin; }
            else { return false; }
            return true;
        case 'n':
            if (aValue == "navajoWhite") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_navajoWhite; }
            else if (aValue == "navy") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_navy; }
            else { return false; }
            return true;
        case 'o':
            if (aValue == "oldLace") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_oldLace; }
            else if (aValue == "olive") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_olive; }
            else if (aValue == "oliveDrab") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_oliveDrab; }
            else if (aValue == "orange") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_orange; }
            else if (aValue == "orangeRed") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_orangeRed; }
            else if (aValue == "orchid") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_orchid; }
            else { return false; }
            return true;
        case 'p':
            if (aValue == "paleGoldenrod") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_paleGoldenrod; }
            else if (aValue == "paleGreen") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_paleGreen; }
            else if (aValue == "paleTurquoise") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_paleTurquoise; }
            else if (aValue == "paleVioletRed") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_paleVioletRed; }
            else if (aValue == "papayaWhip") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_papayaWhip; }
            else if (aValue == "peachPuff") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_peachPuff; }
            else if (aValue == "peru") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_peru; }
            else if (aValue == "pink") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_pink; }
            else if (aValue == "plum") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_plum; }
            else if (aValue == "powderBlue") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_powderBlue; }
            else if (aValue == "purple") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_purple; }
            else { return false; }
            return true;
        case 'r':
            if (aValue == "red") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_red; }
            else if (aValue == "rosyBrown") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_rosyBrown; }
            else if (aValue == "royalBlue") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_royalBlue; }
            else { return false; }
            return true;
        case 's':
            if (aValue == "saddleBrown") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_saddleBrown; }
            else if (aValue == "salmon") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_salmon; }
            else if (aValue == "sandyBrown") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_sandyBrown; }
            else if (aValue == "seaGreen") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_seaGreen; }
            else if (aValue == "seaShell") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_seaShell; }
            else if (aValue == "sienna") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_sienna; }
            else if (aValue == "silver") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_silver; }
            else if (aValue == "skyBlue") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_skyBlue; }
            else if (aValue == "slateBlue") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_slateBlue; }
            else if (aValue == "slateGray") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_slateGray; }
            else if (aValue == "snow") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_snow; }
            else if (aValue == "springGreen") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_springGreen; }
            else if (aValue == "steelBlue") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_steelBlue; }
            else { return false; }
            return true;
        case 't':
            if (aValue == "tan") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_tan; }
            else if (aValue == "teal") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_teal; }
            else if (aValue == "thistle") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_thistle; }
            else if (aValue == "tomato") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_tomato; }
            else if (aValue == "turquoise") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_turquoise; }
            else { return false; }
            return true;
        case 'v':
            if (aValue == "violet") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_violet; }
            else { return false; }
            return true;
        case 'w':
            if (aValue == "wheat") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_wheat; }
            else if (aValue == "white") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_white; }
            else if (aValue == "whiteSmoke") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_whiteSmoke; }
            else { return false; }
            return true;
        case 'y':
            if (aValue == "yellow") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_yellow; }
            else if (aValue == "yellowGreen") { rOutValue = NS_ooxml::LN_Value_ST_PresetColorVal_yellowGreen; }
            else { return false; }
            return true;
        }
        return false;
    case NN_dml_baseTypes|DEFINE_ST_RectAlignment:
        if (aValue.empty())
            return false;
        switch (aValue[0])
        {
        case 'b':
            if (aValue == "bl") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_RectAlignment_bl; }
            else if (aValue == "b") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_RectAlignment_b; }
            else if (aValue == "br") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_RectAlignment_br; }
            else { return false; }
            return true;
        case 'c':
            if (aValue == "ctr") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_RectAlignment_ctr; }
            else { return false; }
            return true;
        case 'l':
            if (aValue == "l") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_RectAlignment_l; }
            else { return false; }
            return true;
        case 'r':
            if (aValue == "r") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_RectAlignment_r; }
            else { return false; }
            return true;
        case 't':
            if (aValue == "tl") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_RectAlignment_tl; }
            else if (aValue == "t") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_RectAlignment_t; }
            else if (aValue == "tr") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_RectAlignment_tr; }
            else { return false; }
            return true;
        }
        return false;
    case NN_dml_baseTypes|DEFINE_ST_BlackWhiteMode:
        if (aValue.empty())
            return false;
        switch (aValue[0])
        {
        case 'a':
            if (aValue == "auto") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_BlackWhiteMode_auto; }
            else { return false; }
            return true;
        case 'b':
            if (aValue == "blackGray") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_BlackWhiteMode_blackGray; }
            else if (aValue == "blackWhite") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_BlackWhiteMode_blackWhite; }
            else if (aValue == "black") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_BlackWhiteMode_black; }
            else { return false; }
            return true;
        case 'c':
            if (aValue == "clr") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_BlackWhiteMode_clr; }
            else { return false; }
            return true;
        case 'g':
            if (aValue == "gray") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_BlackWhiteMode_gray; }
            else if (aValue == "grayWhite") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_BlackWhiteMode_grayWhite; }
            else { return false; }
            return true;
        case 'h':
            if (aValue == "hidden") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_BlackWhiteMode_hidden; }
            else { return false; }
            return true;
        case 'i':
            if (aValue == "invGray") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_BlackWhiteMode_invGray; }
            else { return false; }
            return true;
        case 'l':
            if (aValue == "ltGray") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_BlackWhiteMode_ltGray; }
            else { return false; }
            return true;
        case 'w':
            if (aValue == "white") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_BlackWhiteMode_white; }
            else { return false; }
            return true;
        }
        return false;
    default:
        break;
    }

    return false;
}

bool OOXMLFactory_dml_baseTypes::getElementId(Id nDefine, Id nId, ResourceType& rOutResource, Id& rOutElement)
{
    (void) rOutResource;
    (void) rOutElement;

    switch (nDefine)
    {
    case NN_dml_baseTypes|DEFINE_adec_decorative:
        switch (nId)
        {
        case oox::NMSP_adec|oox::XML_decorative: rOutResource = ResourceType::Properties; rOutElement = NN_dml_baseTypes|DEFINE_adec_decorative_val; break;
        default: return false;
        }
        return true;
    case NN_dml_baseTypes|DEFINE_CT_OfficeArtExtension:
        switch (nId)
        {
        case oox::NMSP_adec|oox::XML_decorative: rOutResource = ResourceType::Properties; rOutElement = NN_dml_baseTypes|DEFINE_adec_decorative_val; break;
        case oox::NMSP_dml|oox::XML_TOKEN_COUNT: rOutResource = ResourceType::Any; rOutElement = 0; break;
        default: return false;
        }
        return true;
    case NN_dml_baseTypes|DEFINE_EG_ColorTransform:
        switch (nId)
        {
        case oox::NMSP_dml|oox::XML_alpha: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_PositiveFixedPercentage; break;
        case oox::NMSP_dml|oox::XML_alphaMod: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_PositivePercentage; break;
        case oox::NMSP_dml|oox::XML_alphaOff: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_FixedPercentage; break;
        case oox::NMSP_dml|oox::XML_blue: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_blueMod: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_blueOff: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_green: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_greenMod: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_greenOff: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_hue: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_PositiveFixedAngle; break;
        case oox::NMSP_dml|oox::XML_hueMod: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_PositivePercentage; break;
        case oox::NMSP_dml|oox::XML_hueOff: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Angle; break;
        case oox::NMSP_dml|oox::XML_lum: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_lumMod: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_lumOff: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_red: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_redMod: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_redOff: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_sat: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_satMod: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_satOff: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_shade: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_PositiveFixedPercentage; break;
        case oox::NMSP_dml|oox::XML_tint: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_PositiveFixedPercentage; break;
        default: return false;
        }
        return true;
    case NN_dml_baseTypes|DEFINE_CT_ScRgbColor:
        switch (nId)
        {
        case oox::NMSP_dml|oox::XML_alpha: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_PositiveFixedPercentage; break;
        case oox::NMSP_dml|oox::XML_alphaMod: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_PositivePercentage; break;
        case oox::NMSP_dml|oox::XML_alphaOff: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_FixedPercentage; break;
        case oox::NMSP_dml|oox::XML_blue: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_blueMod: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_blueOff: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_green: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_greenMod: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_greenOff: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_hue: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_PositiveFixedAngle; break;
        case oox::NMSP_dml|oox::XML_hueMod: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_PositivePercentage; break;
        case oox::NMSP_dml|oox::XML_hueOff: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Angle; break;
        case oox::NMSP_dml|oox::XML_lum: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_lumMod: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_lumOff: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_red: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_redMod: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_redOff: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_sat: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_satMod: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_satOff: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_shade: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_PositiveFixedPercentage; break;
        case oox::NMSP_dml|oox::XML_tint: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_PositiveFixedPercentage; break;
        default: return false;
        }
        return true;
    case NN_dml_baseTypes|DEFINE_CT_SRgbColor:
        switch (nId)
        {
        case oox::NMSP_dml|oox::XML_alpha: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_PositiveFixedPercentage; break;
        case oox::NMSP_dml|oox::XML_alphaMod: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_PositivePercentage; break;
        case oox::NMSP_dml|oox::XML_alphaOff: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_FixedPercentage; break;
        case oox::NMSP_dml|oox::XML_blue: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_blueMod: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_blueOff: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_green: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_greenMod: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_greenOff: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_hue: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_PositiveFixedAngle; break;
        case oox::NMSP_dml|oox::XML_hueMod: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_PositivePercentage; break;
        case oox::NMSP_dml|oox::XML_hueOff: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Angle; break;
        case oox::NMSP_dml|oox::XML_lum: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_lumMod: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_lumOff: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_red: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_redMod: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_redOff: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_sat: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_satMod: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_satOff: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_shade: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_PositiveFixedPercentage; break;
        case oox::NMSP_dml|oox::XML_tint: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_PositiveFixedPercentage; break;
        default: return false;
        }
        return true;
    case NN_dml_baseTypes|DEFINE_CT_HslColor:
        switch (nId)
        {
        case oox::NMSP_dml|oox::XML_alpha: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_PositiveFixedPercentage; break;
        case oox::NMSP_dml|oox::XML_alphaMod: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_PositivePercentage; break;
        case oox::NMSP_dml|oox::XML_alphaOff: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_FixedPercentage; break;
        case oox::NMSP_dml|oox::XML_blue: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_blueMod: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_blueOff: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_green: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_greenMod: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_greenOff: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_hue: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_PositiveFixedAngle; break;
        case oox::NMSP_dml|oox::XML_hueMod: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_PositivePercentage; break;
        case oox::NMSP_dml|oox::XML_hueOff: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Angle; break;
        case oox::NMSP_dml|oox::XML_lum: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_lumMod: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_lumOff: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_red: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_redMod: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_redOff: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_sat: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_satMod: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_satOff: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_shade: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_PositiveFixedPercentage; break;
        case oox::NMSP_dml|oox::XML_tint: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_PositiveFixedPercentage; break;
        default: return false;
        }
        return true;
    case NN_dml_baseTypes|DEFINE_CT_SystemColor:
        switch (nId)
        {
        case oox::NMSP_dml|oox::XML_alpha: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_PositiveFixedPercentage; break;
        case oox::NMSP_dml|oox::XML_alphaMod: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_PositivePercentage; break;
        case oox::NMSP_dml|oox::XML_alphaOff: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_FixedPercentage; break;
        case oox::NMSP_dml|oox::XML_blue: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_blueMod: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_blueOff: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_green: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_greenMod: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_greenOff: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_hue: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_PositiveFixedAngle; break;
        case oox::NMSP_dml|oox::XML_hueMod: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_PositivePercentage; break;
        case oox::NMSP_dml|oox::XML_hueOff: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Angle; break;
        case oox::NMSP_dml|oox::XML_lum: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_lumMod: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_lumOff: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_red: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_redMod: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_redOff: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_sat: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_satMod: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_satOff: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_shade: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_PositiveFixedPercentage; break;
        case oox::NMSP_dml|oox::XML_tint: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_PositiveFixedPercentage; break;
        default: return false;
        }
        return true;
    case NN_dml_baseTypes|DEFINE_CT_SchemeColor:
        switch (nId)
        {
        case oox::NMSP_dml|oox::XML_alpha: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_PositiveFixedPercentage; break;
        case oox::NMSP_dml|oox::XML_alphaMod: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_PositivePercentage; break;
        case oox::NMSP_dml|oox::XML_alphaOff: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_FixedPercentage; break;
        case oox::NMSP_dml|oox::XML_blue: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_blueMod: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_blueOff: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_green: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_greenMod: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_greenOff: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_hue: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_PositiveFixedAngle; break;
        case oox::NMSP_dml|oox::XML_hueMod: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_PositivePercentage; break;
        case oox::NMSP_dml|oox::XML_hueOff: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Angle; break;
        case oox::NMSP_dml|oox::XML_lum: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_lumMod: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_lumOff: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_red: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_redMod: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_redOff: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_sat: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_satMod: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_satOff: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_shade: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_PositiveFixedPercentage; break;
        case oox::NMSP_dml|oox::XML_tint: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_PositiveFixedPercentage; break;
        default: return false;
        }
        return true;
    case NN_dml_baseTypes|DEFINE_CT_PresetColor:
        switch (nId)
        {
        case oox::NMSP_dml|oox::XML_alpha: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_PositiveFixedPercentage; break;
        case oox::NMSP_dml|oox::XML_alphaMod: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_PositivePercentage; break;
        case oox::NMSP_dml|oox::XML_alphaOff: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_FixedPercentage; break;
        case oox::NMSP_dml|oox::XML_blue: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_blueMod: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_blueOff: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_green: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_greenMod: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_greenOff: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_hue: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_PositiveFixedAngle; break;
        case oox::NMSP_dml|oox::XML_hueMod: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_PositivePercentage; break;
        case oox::NMSP_dml|oox::XML_hueOff: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Angle; break;
        case oox::NMSP_dml|oox::XML_lum: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_lumMod: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_lumOff: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_red: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_redMod: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_redOff: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_sat: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_satMod: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_satOff: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_Percentage; break;
        case oox::NMSP_dml|oox::XML_shade: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_PositiveFixedPercentage; break;
        case oox::NMSP_dml|oox::XML_tint: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_CT_PositiveFixedPercentage; break;
        default: return false;
        }
        return true;
    case NN_dml_baseTypes|DEFINE_EG_OfficeArtExtensionList:
        switch (nId)
        {
        case oox::NMSP_dml|oox::XML_ext: rOutResource = ResourceType::Stream; rOutElement = NN_dml_baseTypes|DEFINE_CT_OfficeArtExtension; break;
        default: return false;
        }
        return true;
    case NN_dml_baseTypes|DEFINE_CT_OfficeArtExtensionList:
        switch (nId)
        {
        case oox::NMSP_dml|oox::XML_ext: rOutResource = ResourceType::Stream; rOutElement = NN_dml_baseTypes|DEFINE_CT_OfficeArtExtension; break;
        default: return false;
        }
        return true;
    case NN_dml_baseTypes|DEFINE_CT_Transform2D:
        switch (nId)
        {
        case oox::NMSP_dml|oox::XML_ext: rOutResource = ResourceType::Properties; rOutElement = NN_dml_baseTypes|DEFINE_CT_PositiveSize2D; break;
        case oox::NMSP_dml|oox::XML_off: rOutResource = ResourceType::Properties; rOutElement = NN_dml_baseTypes|DEFINE_CT_Point2D; break;
        default: return false;
        }
        return true;
    case NN_dml_baseTypes|DEFINE_CT_GroupTransform2D:
        switch (nId)
        {
        case oox::NMSP_dml|oox::XML_chExt: rOutResource = ResourceType::Properties; rOutElement = NN_dml_baseTypes|DEFINE_CT_PositiveSize2D; break;
        case oox::NMSP_dml|oox::XML_chOff: rOutResource = ResourceType::Properties; rOutElement = NN_dml_baseTypes|DEFINE_CT_Point2D; break;
        case oox::NMSP_dml|oox::XML_ext: rOutResource = ResourceType::Properties; rOutElement = NN_dml_baseTypes|DEFINE_CT_PositiveSize2D; break;
        case oox::NMSP_dml|oox::XML_off: rOutResource = ResourceType::Properties; rOutElement = NN_dml_baseTypes|DEFINE_CT_Point2D; break;
        default: return false;
        }
        return true;
    case NN_dml_baseTypes|DEFINE_EG_ColorChoice:
        switch (nId)
        {
        case oox::NMSP_dml|oox::XML_hslClr: rOutResource = ResourceType::Properties; rOutElement = NN_dml_baseTypes|DEFINE_CT_HslColor; break;
        case oox::NMSP_dml|oox::XML_prstClr: rOutResource = ResourceType::Properties; rOutElement = NN_dml_baseTypes|DEFINE_CT_PresetColor; break;
        case oox::NMSP_dml|oox::XML_schemeClr: rOutResource = ResourceType::Properties; rOutElement = NN_dml_baseTypes|DEFINE_CT_SchemeColor; break;
        case oox::NMSP_dml|oox::XML_scrgbClr: rOutResource = ResourceType::Properties; rOutElement = NN_dml_baseTypes|DEFINE_CT_ScRgbColor; break;
        case oox::NMSP_dml|oox::XML_srgbClr: rOutResource = ResourceType::Properties; rOutElement = NN_dml_baseTypes|DEFINE_CT_SRgbColor; break;
        case oox::NMSP_dml|oox::XML_sysClr: rOutResource = ResourceType::Properties; rOutElement = NN_dml_baseTypes|DEFINE_CT_SystemColor; break;
        default: return false;
        }
        return true;
    case NN_dml_baseTypes|DEFINE_CT_Color:
        switch (nId)
        {
        case oox::NMSP_dml|oox::XML_hslClr: rOutResource = ResourceType::Properties; rOutElement = NN_dml_baseTypes|DEFINE_CT_HslColor; break;
        case oox::NMSP_dml|oox::XML_prstClr: rOutResource = ResourceType::Properties; rOutElement = NN_dml_baseTypes|DEFINE_CT_PresetColor; break;
        case oox::NMSP_dml|oox::XML_schemeClr: rOutResource = ResourceType::Properties; rOutElement = NN_dml_baseTypes|DEFINE_CT_SchemeColor; break;
        case oox::NMSP_dml|oox::XML_scrgbClr: rOutResource = ResourceType::Properties; rOutElement = NN_dml_baseTypes|DEFINE_CT_ScRgbColor; break;
        case oox::NMSP_dml|oox::XML_srgbClr: rOutResource = ResourceType::Properties; rOutElement = NN_dml_baseTypes|DEFINE_CT_SRgbColor; break;
        case oox::NMSP_dml|oox::XML_sysClr: rOutResource = ResourceType::Properties; rOutElement = NN_dml_baseTypes|DEFINE_CT_SystemColor; break;
        default: return false;
        }
        return true;
    case NN_dml_baseTypes|DEFINE_CT_ColorMRU:
        switch (nId)
        {
        case oox::NMSP_dml|oox::XML_hslClr: rOutResource = ResourceType::Properties; rOutElement = NN_dml_baseTypes|DEFINE_CT_HslColor; break;
        case oox::NMSP_dml|oox::XML_prstClr: rOutResource = ResourceType::Properties; rOutElement = NN_dml_baseTypes|DEFINE_CT_PresetColor; break;
        case oox::NMSP_dml|oox::XML_schemeClr: rOutResource = ResourceType::Properties; rOutElement = NN_dml_baseTypes|DEFINE_CT_SchemeColor; break;
        case oox::NMSP_dml|oox::XML_scrgbClr: rOutResource = ResourceType::Properties; rOutElement = NN_dml_baseTypes|DEFINE_CT_ScRgbColor; break;
        case oox::NMSP_dml|oox::XML_srgbClr: rOutResource = ResourceType::Properties; rOutElement = NN_dml_baseTypes|DEFINE_CT_SRgbColor; break;
        case oox::NMSP_dml|oox::XML_sysClr: rOutResource = ResourceType::Properties; rOutElement = NN_dml_baseTypes|DEFINE_CT_SystemColor; break;
        default: return false;
        }
        return true;
    case NN_dml_baseTypes|DEFINE_CT_Hyperlink:
        switch (nId)
        {
        case oox::NMSP_dml|oox::XML_extLst: rOutResource = ResourceType::Properties; rOutElement = NN_dml_baseTypes|DEFINE_CT_OfficeArtExtensionList; break;
        default: return false;
        }
        return true;
    default:
        switch (nId)
        {
        default: return false;
        }
        return true;
    }
}

void OOXMLFactory_dml_baseTypes::startAction(OOXMLFastContextHandler* pHandler)
{
    sal_uInt32 nDefine = pHandler->getDefine();
    switch (nDefine)
    {
    case NN_dml_baseTypes|DEFINE_CT_Angle:
        pHandler->setDefaultIntegerValue();
        break;
    
    case NN_dml_baseTypes|DEFINE_CT_Percentage:
        pHandler->setDefaultIntegerValue();
        break;

    default:
        break;
    }
}

void OOXMLFactory_dml_baseTypes::charactersAction(OOXMLFastContextHandler* pHandler, const OUString& sText)
{
    sal_uInt32 nDefine = pHandler->getDefine();
    switch (nDefine)
    {
    case NN_dml_baseTypes|DEFINE_ST_PositivePercentage:
        pHandler->positivePercentage(sText);
        break;

    default:
        break;
    }
    switch (nDefine)
    {
case NN_dml_baseTypes|DEFINE_ST_PositivePercentage:
        break;

    default:
        break;
    }
}

Id OOXMLFactory_dml_baseTypes::getResourceId(Id nDefine, sal_Int32 nToken)
{
    (void) nDefine;
    (void) nToken;

    switch (nDefine)
    {
    case NN_dml_baseTypes|DEFINE_adec_decorative_val:
        switch (nToken)
        {
        case oox::XML_val: return NS_ooxml::LN_OfficeArtExtension_Decorative_val;
        }
        break;
    case NN_dml_baseTypes|DEFINE_CT_OfficeArtExtension:
        switch (nToken)
        {
        case oox::NMSP_adec|oox::XML_decorative: return NS_ooxml::LN_CT_OfficeArtExtension_Decorative;
        }
        break;
    case NN_dml_baseTypes|DEFINE_CT_Angle:
        switch (nToken)
        {
        case oox::XML_val: return NS_ooxml::LN_CT_Angle_val;
        }
        break;
    case NN_dml_baseTypes|DEFINE_CT_PositiveFixedAngle:
        switch (nToken)
        {
        case oox::XML_val: return NS_ooxml::LN_CT_PositiveFixedAngle_val;
        }
        break;
    case NN_dml_baseTypes|DEFINE_CT_Percentage:
        switch (nToken)
        {
        case oox::XML_val: return NS_ooxml::LN_CT_Percentage_val;
        }
        break;
    case NN_dml_baseTypes|DEFINE_CT_PositivePercentage:
        switch (nToken)
        {
        case oox::XML_val: return NS_ooxml::LN_CT_PositivePercentage_val;
        }
        break;
    case NN_dml_baseTypes|DEFINE_CT_FixedPercentage:
        switch (nToken)
        {
        case oox::XML_val: return NS_ooxml::LN_CT_FixedPercentage_val;
        }
        break;
    case NN_dml_baseTypes|DEFINE_CT_PositiveFixedPercentage:
        switch (nToken)
        {
        case oox::XML_val: return NS_ooxml::LN_CT_PositiveFixedPercentage_val;
        }
        break;
    case NN_dml_baseTypes|DEFINE_CT_Point2D:
        switch (nToken)
        {
        case oox::XML_x: return NS_ooxml::LN_CT_Point2D_x;
        case oox::XML_y: return NS_ooxml::LN_CT_Point2D_y;
        }
        break;
    case NN_dml_baseTypes|DEFINE_CT_PositiveSize2D:
        switch (nToken)
        {
        case oox::XML_cx: return NS_ooxml::LN_CT_PositiveSize2D_cx;
        case oox::XML_cy: return NS_ooxml::LN_CT_PositiveSize2D_cy;
        }
        break;
    case NN_dml_baseTypes|DEFINE_CT_ScRgbColor:
        switch (nToken)
        {
        case oox::NMSP_w14|oox::XML_alpha: return NS_ooxml::LN_EG_ColorTransform_alpha;
        case oox::NMSP_w14|oox::XML_hueMod: return NS_ooxml::LN_EG_ColorTransform_hueMod;
        case oox::NMSP_w14|oox::XML_lum: return NS_ooxml::LN_EG_ColorTransform_lum;
        case oox::NMSP_w14|oox::XML_lumMod: return NS_ooxml::LN_EG_ColorTransform_lumMod;
        case oox::NMSP_w14|oox::XML_lumOff: return NS_ooxml::LN_EG_ColorTransform_lumOff;
        case oox::NMSP_w14|oox::XML_sat: return NS_ooxml::LN_EG_ColorTransform_sat;
        case oox::NMSP_w14|oox::XML_satMod: return NS_ooxml::LN_EG_ColorTransform_satMod;
        case oox::NMSP_w14|oox::XML_satOff: return NS_ooxml::LN_EG_ColorTransform_satOff;
        case oox::NMSP_w14|oox::XML_shade: return NS_ooxml::LN_EG_ColorTransform_shade;
        case oox::NMSP_w14|oox::XML_tint: return NS_ooxml::LN_EG_ColorTransform_tint;
        case oox::XML_b: return NS_ooxml::LN_CT_ScRgbColor_b;
        case oox::XML_g: return NS_ooxml::LN_CT_ScRgbColor_g;
        case oox::XML_r: return NS_ooxml::LN_CT_ScRgbColor_r;
        }
        break;
    case NN_dml_baseTypes|DEFINE_CT_SRgbColor:
        switch (nToken)
        {
        case oox::NMSP_w14|oox::XML_alpha: return NS_ooxml::LN_EG_ColorTransform_alpha;
        case oox::NMSP_w14|oox::XML_hueMod: return NS_ooxml::LN_EG_ColorTransform_hueMod;
        case oox::NMSP_w14|oox::XML_lum: return NS_ooxml::LN_EG_ColorTransform_lum;
        case oox::NMSP_w14|oox::XML_lumMod: return NS_ooxml::LN_EG_ColorTransform_lumMod;
        case oox::NMSP_w14|oox::XML_lumOff: return NS_ooxml::LN_EG_ColorTransform_lumOff;
        case oox::NMSP_w14|oox::XML_sat: return NS_ooxml::LN_EG_ColorTransform_sat;
        case oox::NMSP_w14|oox::XML_satMod: return NS_ooxml::LN_EG_ColorTransform_satMod;
        case oox::NMSP_w14|oox::XML_satOff: return NS_ooxml::LN_EG_ColorTransform_satOff;
        case oox::NMSP_w14|oox::XML_shade: return NS_ooxml::LN_EG_ColorTransform_shade;
        case oox::NMSP_w14|oox::XML_tint: return NS_ooxml::LN_EG_ColorTransform_tint;
        case oox::XML_val: return NS_ooxml::LN_CT_SRgbColor_val;
        }
        break;
    case NN_dml_baseTypes|DEFINE_CT_HslColor:
        switch (nToken)
        {
        case oox::NMSP_w14|oox::XML_alpha: return NS_ooxml::LN_EG_ColorTransform_alpha;
        case oox::NMSP_w14|oox::XML_hueMod: return NS_ooxml::LN_EG_ColorTransform_hueMod;
        case oox::NMSP_w14|oox::XML_lum: return NS_ooxml::LN_EG_ColorTransform_lum;
        case oox::NMSP_w14|oox::XML_lumMod: return NS_ooxml::LN_EG_ColorTransform_lumMod;
        case oox::NMSP_w14|oox::XML_lumOff: return NS_ooxml::LN_EG_ColorTransform_lumOff;
        case oox::NMSP_w14|oox::XML_sat: return NS_ooxml::LN_EG_ColorTransform_sat;
        case oox::NMSP_w14|oox::XML_satMod: return NS_ooxml::LN_EG_ColorTransform_satMod;
        case oox::NMSP_w14|oox::XML_satOff: return NS_ooxml::LN_EG_ColorTransform_satOff;
        case oox::NMSP_w14|oox::XML_shade: return NS_ooxml::LN_EG_ColorTransform_shade;
        case oox::NMSP_w14|oox::XML_tint: return NS_ooxml::LN_EG_ColorTransform_tint;
        case oox::XML_hue: return NS_ooxml::LN_CT_HslColor_hue;
        case oox::XML_lum: return NS_ooxml::LN_CT_HslColor_lum;
        case oox::XML_sat: return NS_ooxml::LN_CT_HslColor_sat;
        }
        break;
    case NN_dml_baseTypes|DEFINE_CT_SystemColor:
        switch (nToken)
        {
        case oox::NMSP_w14|oox::XML_alpha: return NS_ooxml::LN_EG_ColorTransform_alpha;
        case oox::NMSP_w14|oox::XML_hueMod: return NS_ooxml::LN_EG_ColorTransform_hueMod;
        case oox::NMSP_w14|oox::XML_lum: return NS_ooxml::LN_EG_ColorTransform_lum;
        case oox::NMSP_w14|oox::XML_lumMod: return NS_ooxml::LN_EG_ColorTransform_lumMod;
        case oox::NMSP_w14|oox::XML_lumOff: return NS_ooxml::LN_EG_ColorTransform_lumOff;
        case oox::NMSP_w14|oox::XML_sat: return NS_ooxml::LN_EG_ColorTransform_sat;
        case oox::NMSP_w14|oox::XML_satMod: return NS_ooxml::LN_EG_ColorTransform_satMod;
        case oox::NMSP_w14|oox::XML_satOff: return NS_ooxml::LN_EG_ColorTransform_satOff;
        case oox::NMSP_w14|oox::XML_shade: return NS_ooxml::LN_EG_ColorTransform_shade;
        case oox::NMSP_w14|oox::XML_tint: return NS_ooxml::LN_EG_ColorTransform_tint;
        case oox::XML_lastClr: return NS_ooxml::LN_CT_SystemColor_lastClr;
        case oox::XML_val: return NS_ooxml::LN_CT_SystemColor_val;
        }
        break;
    case NN_dml_baseTypes|DEFINE_CT_SchemeColor:
        switch (nToken)
        {
        case oox::NMSP_w14|oox::XML_alpha: return NS_ooxml::LN_EG_ColorTransform_alpha;
        case oox::NMSP_w14|oox::XML_hueMod: return NS_ooxml::LN_EG_ColorTransform_hueMod;
        case oox::NMSP_w14|oox::XML_lum: return NS_ooxml::LN_EG_ColorTransform_lum;
        case oox::NMSP_w14|oox::XML_lumMod: return NS_ooxml::LN_EG_ColorTransform_lumMod;
        case oox::NMSP_w14|oox::XML_lumOff: return NS_ooxml::LN_EG_ColorTransform_lumOff;
        case oox::NMSP_w14|oox::XML_sat: return NS_ooxml::LN_EG_ColorTransform_sat;
        case oox::NMSP_w14|oox::XML_satMod: return NS_ooxml::LN_EG_ColorTransform_satMod;
        case oox::NMSP_w14|oox::XML_satOff: return NS_ooxml::LN_EG_ColorTransform_satOff;
        case oox::NMSP_w14|oox::XML_shade: return NS_ooxml::LN_EG_ColorTransform_shade;
        case oox::NMSP_w14|oox::XML_tint: return NS_ooxml::LN_EG_ColorTransform_tint;
        case oox::XML_val: return NS_ooxml::LN_CT_SchemeColor_val;
        }
        break;
    case NN_dml_baseTypes|DEFINE_CT_PresetColor:
        switch (nToken)
        {
        case oox::NMSP_w14|oox::XML_alpha: return NS_ooxml::LN_EG_ColorTransform_alpha;
        case oox::NMSP_w14|oox::XML_hueMod: return NS_ooxml::LN_EG_ColorTransform_hueMod;
        case oox::NMSP_w14|oox::XML_lum: return NS_ooxml::LN_EG_ColorTransform_lum;
        case oox::NMSP_w14|oox::XML_lumMod: return NS_ooxml::LN_EG_ColorTransform_lumMod;
        case oox::NMSP_w14|oox::XML_lumOff: return NS_ooxml::LN_EG_ColorTransform_lumOff;
        case oox::NMSP_w14|oox::XML_sat: return NS_ooxml::LN_EG_ColorTransform_sat;
        case oox::NMSP_w14|oox::XML_satMod: return NS_ooxml::LN_EG_ColorTransform_satMod;
        case oox::NMSP_w14|oox::XML_satOff: return NS_ooxml::LN_EG_ColorTransform_satOff;
        case oox::NMSP_w14|oox::XML_shade: return NS_ooxml::LN_EG_ColorTransform_shade;
        case oox::NMSP_w14|oox::XML_tint: return NS_ooxml::LN_EG_ColorTransform_tint;
        case oox::XML_val: return NS_ooxml::LN_CT_PresetColor_val;
        }
        break;
    case NN_dml_baseTypes|DEFINE_CT_Transform2D:
        switch (nToken)
        {
        case oox::NMSP_dml|oox::XML_ext: return NS_ooxml::LN_CT_Transform2D_ext;
        case oox::NMSP_dml|oox::XML_off: return NS_ooxml::LN_CT_Transform2D_off;
        case oox::XML_flipH: return NS_ooxml::LN_CT_Transform2D_flipH;
        case oox::XML_flipV: return NS_ooxml::LN_CT_Transform2D_flipV;
        case oox::XML_rot: return NS_ooxml::LN_CT_Transform2D_rot;
        }
        break;
    case NN_dml_baseTypes|DEFINE_EG_ColorChoice:
        switch (nToken)
        {
        case oox::NMSP_dml|oox::XML_hslClr: return NS_ooxml::LN_EG_ColorChoice_hslClr;
        case oox::NMSP_dml|oox::XML_prstClr: return NS_ooxml::LN_EG_ColorChoice_prstClr;
        case oox::NMSP_dml|oox::XML_schemeClr: return NS_ooxml::LN_EG_ColorChoice_schemeClr;
        case oox::NMSP_dml|oox::XML_scrgbClr: return NS_ooxml::LN_EG_ColorChoice_scrgbClr;
        case oox::NMSP_dml|oox::XML_srgbClr: return NS_ooxml::LN_EG_ColorChoice_srgbClr;
        case oox::NMSP_dml|oox::XML_sysClr: return NS_ooxml::LN_EG_ColorChoice_sysClr;
        }
        break;
    case NN_dml_baseTypes|DEFINE_CT_Color:
        switch (nToken)
        {
        case oox::NMSP_dml|oox::XML_hslClr: return NS_ooxml::LN_EG_ColorChoice_hslClr;
        case oox::NMSP_dml|oox::XML_prstClr: return NS_ooxml::LN_EG_ColorChoice_prstClr;
        case oox::NMSP_dml|oox::XML_schemeClr: return NS_ooxml::LN_EG_ColorChoice_schemeClr;
        case oox::NMSP_dml|oox::XML_scrgbClr: return NS_ooxml::LN_EG_ColorChoice_scrgbClr;
        case oox::NMSP_dml|oox::XML_srgbClr: return NS_ooxml::LN_EG_ColorChoice_srgbClr;
        case oox::NMSP_dml|oox::XML_sysClr: return NS_ooxml::LN_EG_ColorChoice_sysClr;
        }
        break;
    case NN_dml_baseTypes|DEFINE_CT_ColorMRU:
        switch (nToken)
        {
        case oox::NMSP_dml|oox::XML_hslClr: return NS_ooxml::LN_EG_ColorChoice_hslClr;
        case oox::NMSP_dml|oox::XML_prstClr: return NS_ooxml::LN_EG_ColorChoice_prstClr;
        case oox::NMSP_dml|oox::XML_schemeClr: return NS_ooxml::LN_EG_ColorChoice_schemeClr;
        case oox::NMSP_dml|oox::XML_scrgbClr: return NS_ooxml::LN_EG_ColorChoice_scrgbClr;
        case oox::NMSP_dml|oox::XML_srgbClr: return NS_ooxml::LN_EG_ColorChoice_srgbClr;
        case oox::NMSP_dml|oox::XML_sysClr: return NS_ooxml::LN_EG_ColorChoice_sysClr;
        }
        break;
    case NN_dml_baseTypes|DEFINE_AG_Blob:
        switch (nToken)
        {
        case oox::NMSP_officeRel|oox::XML_embed: return NS_ooxml::LN_AG_Blob_r_embed;
        case oox::NMSP_officeRel|oox::XML_link: return NS_ooxml::LN_AG_Blob_r_link;
        }
        break;
    default:
        switch (nToken)
        {
        }
        break;
    }
    return 0;
}

void OOXMLFactory_dml_baseTypes::attributeAction(OOXMLFastContextHandler* _pHandler, Token_t nToken, const OOXMLValue& pValue)
{
    switch (_pHandler->getDefine())
    {
    case NN_dml_baseTypes|DEFINE_CT_Angle:
        if (OOXMLFastContextHandlerValue* pHandler = dynamic_cast<OOXMLFastContextHandlerValue*>(_pHandler))
        {
            if (nToken == static_cast<Token_t>(oox::XML_val))
                pHandler->setValue(pValue);
        }
        break;
    case NN_dml_baseTypes|DEFINE_CT_PositiveFixedAngle:
        if (OOXMLFastContextHandlerValue* pHandler = dynamic_cast<OOXMLFastContextHandlerValue*>(_pHandler))
        {
            if (nToken == static_cast<Token_t>(oox::XML_val))
                pHandler->setValue(pValue);
        }
        break;
    case NN_dml_baseTypes|DEFINE_CT_Percentage:
        if (OOXMLFastContextHandlerValue* pHandler = dynamic_cast<OOXMLFastContextHandlerValue*>(_pHandler))
        {
            if (nToken == static_cast<Token_t>(oox::XML_val))
                pHandler->setValue(pValue);
        }
        break;
    case NN_dml_baseTypes|DEFINE_CT_PositivePercentage:
        if (OOXMLFastContextHandlerValue* pHandler = dynamic_cast<OOXMLFastContextHandlerValue*>(_pHandler))
        {
            if (nToken == static_cast<Token_t>(oox::XML_val))
                pHandler->setValue(pValue);
        }
        break;
    case NN_dml_baseTypes|DEFINE_CT_FixedPercentage:
        if (OOXMLFastContextHandlerValue* pHandler = dynamic_cast<OOXMLFastContextHandlerValue*>(_pHandler))
        {
            if (nToken == static_cast<Token_t>(oox::XML_val))
                pHandler->setValue(pValue);
        }
        break;
    case NN_dml_baseTypes|DEFINE_CT_PositiveFixedPercentage:
        if (OOXMLFastContextHandlerValue* pHandler = dynamic_cast<OOXMLFastContextHandlerValue*>(_pHandler))
        {
            if (nToken == static_cast<Token_t>(oox::XML_val))
                pHandler->setValue(pValue);
        }
        break;
    default:
        break;
    }
}

/// @endcond
}}
