#ifndef INCLUDED_OFFICECFG_OFFICE_RECOVERY_HXX
#define INCLUDED_OFFICECFG_OFFICE_RECOVERY_HXX

#include "sal/config.h"

#include "rtl/ustring.h"
#include "rtl/ustring.hxx"
#include "sal/types.h"
#include "comphelper/configuration.hxx"

namespace officecfg { namespace Office { namespace Recovery {

struct RecoveryList: public comphelper::ConfigurationSet< RecoveryList> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Recovery/RecoveryList"_ustr); return PATH; }
private:
    RecoveryList(); // not defined
    ~RecoveryList(); // not defined
};

struct SessionShutdown: public comphelper::ConfigurationGroup< SessionShutdown> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Recovery/SessionShutdown"_ustr); return PATH; }

struct DocumentStoreUIEnabled: public comphelper::ConfigurationProperty<DocumentStoreUIEnabled, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Recovery/SessionShutdown/DocumentStoreUIEnabled"_ustr); return PATH; }
private:
    DocumentStoreUIEnabled(); // not defined
    ~DocumentStoreUIEnabled(); // not defined
};

private:
    SessionShutdown(); // not defined
    ~SessionShutdown(); // not defined
};

struct RecoveryInfo: public comphelper::ConfigurationGroup< RecoveryInfo> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Recovery/RecoveryInfo"_ustr); return PATH; }

struct Enabled: public comphelper::ConfigurationProperty<Enabled, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Recovery/RecoveryInfo/Enabled"_ustr); return PATH; }
private:
    Enabled(); // not defined
    ~Enabled(); // not defined
};

struct Crashed: public comphelper::ConfigurationProperty<Crashed, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Recovery/RecoveryInfo/Crashed"_ustr); return PATH; }
private:
    Crashed(); // not defined
    ~Crashed(); // not defined
};

struct SessionData: public comphelper::ConfigurationProperty<SessionData, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Recovery/RecoveryInfo/SessionData"_ustr); return PATH; }
private:
    SessionData(); // not defined
    ~SessionData(); // not defined
};

private:
    RecoveryInfo(); // not defined
    ~RecoveryInfo(); // not defined
};

struct AutoSave: public comphelper::ConfigurationGroup< AutoSave> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Recovery/AutoSave"_ustr); return PATH; }

struct Enabled: public comphelper::ConfigurationProperty<Enabled, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Recovery/AutoSave/Enabled"_ustr); return PATH; }
private:
    Enabled(); // not defined
    ~Enabled(); // not defined
};

struct UserAutoSaveEnabled: public comphelper::ConfigurationProperty<UserAutoSaveEnabled, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Recovery/AutoSave/UserAutoSaveEnabled"_ustr); return PATH; }
private:
    UserAutoSaveEnabled(); // not defined
    ~UserAutoSaveEnabled(); // not defined
};

struct TimeIntervall: public comphelper::ConfigurationProperty<TimeIntervall, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Recovery/AutoSave/TimeIntervall"_ustr); return PATH; }
private:
    TimeIntervall(); // not defined
    ~TimeIntervall(); // not defined
};

struct MinSpaceDocSave: public comphelper::ConfigurationProperty<MinSpaceDocSave, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Recovery/AutoSave/MinSpaceDocSave"_ustr); return PATH; }
private:
    MinSpaceDocSave(); // not defined
    ~MinSpaceDocSave(); // not defined
};

struct MinSpaceConfigSave: public comphelper::ConfigurationProperty<MinSpaceConfigSave, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Recovery/AutoSave/MinSpaceConfigSave"_ustr); return PATH; }
private:
    MinSpaceConfigSave(); // not defined
    ~MinSpaceConfigSave(); // not defined
};

private:
    AutoSave(); // not defined
    ~AutoSave(); // not defined
};

} } }

#endif
