/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Global Instruction Selector for the AMDGPU target                          *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_GLOBALISEL_PREDICATE_BITSET
const unsigned MAX_SUBTARGET_PREDICATES = 128;
using PredicateBitset = llvm::Bitset<MAX_SUBTARGET_PREDICATES>;
#endif // ifdef GET_GLOBALISEL_PREDICATE_BITSET

#ifdef GET_GLOBALISEL_TEMPORARIES_DECL
  mutable MatcherState State;
  typedef ComplexRendererFns(AMDGPUInstructionSelector::*ComplexMatcherMemFn)(MachineOperand &) const;
  typedef void(AMDGPUInstructionSelector::*CustomRendererFn)(MachineInstrBuilder &, const MachineInstr &, int) const;
  const ExecInfoTy<PredicateBitset, ComplexMatcherMemFn, CustomRendererFn> ExecInfo;
  static AMDGPUInstructionSelector::ComplexMatcherMemFn ComplexPredicateFns[];
  static AMDGPUInstructionSelector::CustomRendererFn CustomRenderers[];
  bool testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const override;
  bool testImmPredicate_APInt(unsigned PredicateID, const APInt &Imm) const override;
  bool testImmPredicate_APFloat(unsigned PredicateID, const APFloat &Imm) const override;
  const uint8_t *getMatchTable() const override;
  bool testMIPredicate_MI(unsigned PredicateID, const MachineInstr &MI, const MatcherState &State) const override;
  bool testSimplePredicate(unsigned PredicateID) const override;
  bool runCustomAction(unsigned FnID, const MatcherState &State, NewMIVector &OutMIs) const override;
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_DECL

#ifdef GET_GLOBALISEL_TEMPORARIES_INIT
, State(6),
ExecInfo(TypeObjects, NumTypeObjects, FeatureBitsets, ComplexPredicateFns, CustomRenderers)
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_INIT

#ifdef GET_GLOBALISEL_IMPL
// LLT Objects.
enum {
  GILLT_p0s64,
  GILLT_p1s64,
  GILLT_p2s32,
  GILLT_p3s32,
  GILLT_p4s64,
  GILLT_p5s32,
  GILLT_p6s32,
  GILLT_s1,
  GILLT_s16,
  GILLT_s32,
  GILLT_s64,
  GILLT_v2s16,
  GILLT_v2s32,
  GILLT_v2s64,
  GILLT_v3s32,
  GILLT_v3s64,
  GILLT_v4s16,
  GILLT_v4s32,
  GILLT_v4s64,
  GILLT_v5s32,
  GILLT_v6s32,
  GILLT_v7s32,
  GILLT_v8s16,
  GILLT_v8s32,
  GILLT_v8s64,
  GILLT_v9s32,
  GILLT_v10s32,
  GILLT_v11s32,
  GILLT_v12s32,
  GILLT_v16s16,
  GILLT_v16s32,
  GILLT_v16s64,
  GILLT_v32s16,
  GILLT_v32s32,
};
const static size_t NumTypeObjects = 34;
const static LLT TypeObjects[] = {
  LLT::pointer(0, 64),
  LLT::pointer(1, 64),
  LLT::pointer(2, 32),
  LLT::pointer(3, 32),
  LLT::pointer(4, 64),
  LLT::pointer(5, 32),
  LLT::pointer(6, 32),
  LLT::scalar(1),
  LLT::scalar(16),
  LLT::scalar(32),
  LLT::scalar(64),
  LLT::vector(ElementCount::getFixed(2), 16),
  LLT::vector(ElementCount::getFixed(2), 32),
  LLT::vector(ElementCount::getFixed(2), 64),
  LLT::vector(ElementCount::getFixed(3), 32),
  LLT::vector(ElementCount::getFixed(3), 64),
  LLT::vector(ElementCount::getFixed(4), 16),
  LLT::vector(ElementCount::getFixed(4), 32),
  LLT::vector(ElementCount::getFixed(4), 64),
  LLT::vector(ElementCount::getFixed(5), 32),
  LLT::vector(ElementCount::getFixed(6), 32),
  LLT::vector(ElementCount::getFixed(7), 32),
  LLT::vector(ElementCount::getFixed(8), 16),
  LLT::vector(ElementCount::getFixed(8), 32),
  LLT::vector(ElementCount::getFixed(8), 64),
  LLT::vector(ElementCount::getFixed(9), 32),
  LLT::vector(ElementCount::getFixed(10), 32),
  LLT::vector(ElementCount::getFixed(11), 32),
  LLT::vector(ElementCount::getFixed(12), 32),
  LLT::vector(ElementCount::getFixed(16), 16),
  LLT::vector(ElementCount::getFixed(16), 32),
  LLT::vector(ElementCount::getFixed(16), 64),
  LLT::vector(ElementCount::getFixed(32), 16),
  LLT::vector(ElementCount::getFixed(32), 32),
};

// Bits for subtarget features that participate in instruction matching.
enum SubtargetFeatureBits : uint8_t {
  Feature_FalsePredicateBit = 113,
  Feature_isGFX6Bit = 49,
  Feature_isGFX6GFX7Bit = 8,
  Feature_isGFX6GFX7GFX10Bit = 110,
  Feature_isGFX7OnlyBit = 84,
  Feature_isGFX7GFX8GFX9Bit = 44,
  Feature_isGFX6GFX7GFX8GFX9Bit = 65,
  Feature_isGFX6GFX7GFX8GFX9GFX10Bit = 124,
  Feature_isNotGFX12PlusBit = 19,
  Feature_isGFX8GFX9GFX10GFX11Bit = 21,
  Feature_isGFX7PlusBit = 13,
  Feature_isGFX8PlusBit = 4,
  Feature_isGFX8OnlyBit = 22,
  Feature_isGFX9PlusBit = 0,
  Feature_isNotGFX9PlusBit = 55,
  Feature_isGFX90APlusBit = 37,
  Feature_isNotGFX90APlusBit = 23,
  Feature_isGFX908orGFX90ABit = 38,
  Feature_isGFX940PlusBit = 39,
  Feature_isNotGFX940PlusBit = 50,
  Feature_HasGFX950InstsBit = 28,
  Feature_isGFX8GFX9Bit = 15,
  Feature_isGFX10OnlyBit = 61,
  Feature_isGFX10PlusBit = 5,
  Feature_isGFX9GFX10Bit = 56,
  Feature_isGFX11OnlyBit = 62,
  Feature_isGFX11PlusBit = 1,
  Feature_isGFX12OnlyBit = 63,
  Feature_isGFX12PlusBit = 3,
  Feature_HasMinimum3Maximum3F32Bit = 20,
  Feature_HasMinimum3Maximum3F16Bit = 25,
  Feature_HasMinimum3Maximum3PKF16Bit = 79,
  Feature_HasFlatAddressSpaceBit = 86,
  Feature_HasFlatBufferGlobalAtomicFaddF64InstBit = 102,
  Feature_HasAtomicFMinFMaxF32GlobalInstsBit = 96,
  Feature_HasAtomicFMinFMaxF64GlobalInstsBit = 101,
  Feature_HasAtomicFMinFMaxF32FlatInstsBit = 92,
  Feature_HasAtomicFMinFMaxF64FlatInstsBit = 93,
  Feature_HasLdsAtomicAddF64Bit = 127,
  Feature_HasFlatGlobalInstsBit = 87,
  Feature_HasFlatScratchInstsBit = 90,
  Feature_HasD16LoadStoreBit = 95,
  Feature_HasFlatScratchSVSModeBit = 91,
  Feature_HasGFX10_BEncodingBit = 48,
  Feature_HasUnpackedD16VMemBit = 106,
  Feature_HasPackedD16VMemBit = 107,
  Feature_HasUnrestrictedSOffsetBit = 105,
  Feature_D16PreservesUnusedBitsBit = 88,
  Feature_LDSRequiresM0InitBit = 120,
  Feature_NotLDSRequiresM0InitBit = 121,
  Feature_HasExportInstsBit = 7,
  Feature_HasLDSFPAtomicAddF32Bit = 126,
  Feature_HasAddNoCarryInstsBit = 64,
  Feature_NotHasAddNoCarryInstsBit = 118,
  Feature_HasXNACKEnabledBit = 83,
  Feature_Has16BitInstsBit = 9,
  Feature_HasTrue16BitInstsBit = 111,
  Feature_NotHasTrue16BitInstsBit = 10,
  Feature_UseRealTrue16InstsBit = 11,
  Feature_UseFakeTrue16InstsBit = 12,
  Feature_HasVOP3PInstsBit = 76,
  Feature_HasMed3_16Bit = 119,
  Feature_HasMinMaxDenormModesBit = 112,
  Feature_NotHasMinMaxDenormModesBit = 114,
  Feature_HasSDWABit = 60,
  Feature_HasPackedFP32OpsBit = 42,
  Feature_HasImageInstsBit = 6,
  Feature_HasIntClampBit = 70,
  Feature_HasMadMixInstsBit = 77,
  Feature_HasScalarStoresBit = 45,
  Feature_has16BankLDSBit = 51,
  Feature_has32BankLDSBit = 24,
  Feature_HasFmaMixInstsBit = 80,
  Feature_HasDLInstsBit = 16,
  Feature_HasFmacF64InstBit = 117,
  Feature_HasDot1InstsBit = 35,
  Feature_HasDot2InstsBit = 32,
  Feature_HasDot3InstsBit = 69,
  Feature_HasDot4InstsBit = 68,
  Feature_HasDot5InstsBit = 66,
  Feature_HasDot6InstsBit = 67,
  Feature_HasDot7InstsBit = 34,
  Feature_HasDot8InstsBit = 81,
  Feature_HasDot9InstsBit = 29,
  Feature_HasDot10InstsBit = 33,
  Feature_HasDot11InstsBit = 82,
  Feature_HasGetWaveIdInstBit = 47,
  Feature_HasMAIInstsBit = 36,
  Feature_HasSMemRealTimeBit = 46,
  Feature_HasSMemTimeInstBit = 43,
  Feature_HasShaderCyclesRegisterBit = 85,
  Feature_HasShaderCyclesHiLoRegistersBit = 54,
  Feature_HasFP8InstsBit = 41,
  Feature_HasFP8ConversionInstsBit = 58,
  Feature_HasMadMacF32InstsBit = 17,
  Feature_HasFmaLegacy32Bit = 18,
  Feature_HasAtomicDsPkAdd16InstsBit = 125,
  Feature_HasAtomicFlatPkAdd16InstsBit = 104,
  Feature_HasAtomicFaddRtnInstsBit = 99,
  Feature_HasAtomicFaddNoRtnInstsBit = 97,
  Feature_HasAtomicBufferGlobalPkAddF16NoRtnInstsBit = 98,
  Feature_HasAtomicBufferGlobalPkAddF16InstsBit = 100,
  Feature_HasFlatAtomicFaddF32InstBit = 103,
  Feature_EnableFlatScratchBit = 89,
  Feature_DisableFlatScratchBit = 108,
  Feature_HasUnalignedAccessModeBit = 122,
  Feature_HasMADIntraFwdBugBit = 72,
  Feature_HasNotMADIntraFwdBugBit = 71,
  Feature_HasSALUFloatInstsBit = 2,
  Feature_NotHasSALUFloatInstsBit = 109,
  Feature_HasPseudoScalarTransBit = 30,
  Feature_HasBitOp3InstsBit = 74,
  Feature_HasPrngInstBit = 14,
  Feature_HasFP6BF6ConversionScaleInstsBit = 26,
  Feature_HasF16BF16ToFP6BF6ConversionScaleInstsBit = 27,
  Feature_HasCvtPkF16F32InstBit = 73,
  Feature_HasF32ToF16BF16ConversionSRInstsBit = 75,
  Feature_HasGDSBit = 123,
  Feature_HasCvtFP8VOP1BugBit = 57,
  Feature_HasNoCvtFP8VOP1BugBit = 59,
  Feature_HasAtomicCSubNoRtnInstsBit = 94,
  Feature_HasXF32InstsBit = 40,
  Feature_HasAshrPkInstsBit = 31,
  Feature_FP16DenormalsBit = 116,
  Feature_FP64DenormalsBit = 115,
  Feature_NoFP32DenormalsBit = 78,
  Feature_isWave32Bit = 52,
  Feature_isWave64Bit = 53,
};

PredicateBitset AMDGPUInstructionSelector::
computeAvailableModuleFeatures(const AMDGPUSubtarget *Subtarget) const {
  PredicateBitset Features{};
  if (false)
    Features.set(Feature_FalsePredicateBit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::SOUTHERN_ISLANDS)
    Features.set(Feature_isGFX6Bit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::SOUTHERN_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS)
    Features.set(Feature_isGFX6GFX7Bit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::SOUTHERN_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX10)
    Features.set(Feature_isGFX6GFX7GFX10Bit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS)
    Features.set(Feature_isGFX7OnlyBit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::VOLCANIC_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX9)
    Features.set(Feature_isGFX7GFX8GFX9Bit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::SOUTHERN_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::VOLCANIC_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX9)
    Features.set(Feature_isGFX6GFX7GFX8GFX9Bit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::SOUTHERN_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::VOLCANIC_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX9 ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX10)
    Features.set(Feature_isGFX6GFX7GFX8GFX9GFX10Bit);
  if (Subtarget->getGeneration() <= AMDGPUSubtarget::GFX11)
    Features.set(Feature_isNotGFX12PlusBit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::VOLCANIC_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX9 ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX10 ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX11)
    Features.set(Feature_isGFX8GFX9GFX10GFX11Bit);
  if (Subtarget->getGeneration() >= AMDGPUSubtarget::SEA_ISLANDS)
    Features.set(Feature_isGFX7PlusBit);
  if (Subtarget->getGeneration() >= AMDGPUSubtarget::VOLCANIC_ISLANDS)
    Features.set(Feature_isGFX8PlusBit);
  if (Subtarget->getGeneration() ==AMDGPUSubtarget::VOLCANIC_ISLANDS)
    Features.set(Feature_isGFX8OnlyBit);
  if (Subtarget->getGeneration() >= AMDGPUSubtarget::GFX9)
    Features.set(Feature_isGFX9PlusBit);
  if (Subtarget->getGeneration() < AMDGPUSubtarget::GFX9)
    Features.set(Feature_isNotGFX9PlusBit);
  if (Subtarget->hasGFX90AInsts())
    Features.set(Feature_isGFX90APlusBit);
  if (!Subtarget->hasGFX90AInsts())
    Features.set(Feature_isNotGFX90APlusBit);
  if (Subtarget->hasMAIInsts() && !Subtarget->hasGFX940Insts())
    Features.set(Feature_isGFX908orGFX90ABit);
  if (Subtarget->hasGFX940Insts())
    Features.set(Feature_isGFX940PlusBit);
  if (!Subtarget->hasGFX940Insts())
    Features.set(Feature_isNotGFX940PlusBit);
  if (Subtarget->hasGFX950Insts())
    Features.set(Feature_HasGFX950InstsBit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::VOLCANIC_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX9)
    Features.set(Feature_isGFX8GFX9Bit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::GFX10)
    Features.set(Feature_isGFX10OnlyBit);
  if (Subtarget->getGeneration() >= AMDGPUSubtarget::GFX10)
    Features.set(Feature_isGFX10PlusBit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::GFX9 ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX10)
    Features.set(Feature_isGFX9GFX10Bit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::GFX11)
    Features.set(Feature_isGFX11OnlyBit);
  if (Subtarget->getGeneration() >= AMDGPUSubtarget::GFX11)
    Features.set(Feature_isGFX11PlusBit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::GFX12)
    Features.set(Feature_isGFX12OnlyBit);
  if (Subtarget->getGeneration() >= AMDGPUSubtarget::GFX12)
    Features.set(Feature_isGFX12PlusBit);
  if (Subtarget->hasMinimum3Maximum3F32())
    Features.set(Feature_HasMinimum3Maximum3F32Bit);
  if (Subtarget->hasMinimum3Maximum3F16())
    Features.set(Feature_HasMinimum3Maximum3F16Bit);
  if (Subtarget->hasMinimum3Maximum3PKF16())
    Features.set(Feature_HasMinimum3Maximum3PKF16Bit);
  if (Subtarget->hasFlatAddressSpace())
    Features.set(Feature_HasFlatAddressSpaceBit);
  if (Subtarget->hasFlatBufferGlobalAtomicFaddF64Inst())
    Features.set(Feature_HasFlatBufferGlobalAtomicFaddF64InstBit);
  if (Subtarget->hasAtomicFMinFMaxF32GlobalInsts())
    Features.set(Feature_HasAtomicFMinFMaxF32GlobalInstsBit);
  if (Subtarget->hasAtomicFMinFMaxF64GlobalInsts())
    Features.set(Feature_HasAtomicFMinFMaxF64GlobalInstsBit);
  if (Subtarget->hasAtomicFMinFMaxF32FlatInsts())
    Features.set(Feature_HasAtomicFMinFMaxF32FlatInstsBit);
  if (Subtarget->hasAtomicFMinFMaxF64FlatInsts())
    Features.set(Feature_HasAtomicFMinFMaxF64FlatInstsBit);
  if (Subtarget->hasLdsAtomicAddF64())
    Features.set(Feature_HasLdsAtomicAddF64Bit);
  if (Subtarget->hasFlatGlobalInsts())
    Features.set(Feature_HasFlatGlobalInstsBit);
  if (Subtarget->hasFlatScratchInsts())
    Features.set(Feature_HasFlatScratchInstsBit);
  if (Subtarget->hasD16LoadStore())
    Features.set(Feature_HasD16LoadStoreBit);
  if (Subtarget->hasFlatScratchSVSMode())
    Features.set(Feature_HasFlatScratchSVSModeBit);
  if (Subtarget->hasGFX10_BEncoding())
    Features.set(Feature_HasGFX10_BEncodingBit);
  if (Subtarget->hasUnpackedD16VMem())
    Features.set(Feature_HasUnpackedD16VMemBit);
  if (!Subtarget->hasUnpackedD16VMem())
    Features.set(Feature_HasPackedD16VMemBit);
  if (!Subtarget->hasRestrictedSOffset())
    Features.set(Feature_HasUnrestrictedSOffsetBit);
  if (Subtarget->d16PreservesUnusedBits())
    Features.set(Feature_D16PreservesUnusedBitsBit);
  if (Subtarget->ldsRequiresM0Init())
    Features.set(Feature_LDSRequiresM0InitBit);
  if (!Subtarget->ldsRequiresM0Init())
    Features.set(Feature_NotLDSRequiresM0InitBit);
  if (Subtarget->hasExportInsts())
    Features.set(Feature_HasExportInstsBit);
  if (Subtarget->hasLDSFPAtomicAddF32())
    Features.set(Feature_HasLDSFPAtomicAddF32Bit);
  if (Subtarget->hasAddNoCarry())
    Features.set(Feature_HasAddNoCarryInstsBit);
  if (!Subtarget->hasAddNoCarry())
    Features.set(Feature_NotHasAddNoCarryInstsBit);
  if (Subtarget->isXNACKEnabled())
    Features.set(Feature_HasXNACKEnabledBit);
  if (Subtarget->has16BitInsts())
    Features.set(Feature_Has16BitInstsBit);
  if (Subtarget->hasTrue16BitInsts())
    Features.set(Feature_HasTrue16BitInstsBit);
  if (!Subtarget->hasTrue16BitInsts())
    Features.set(Feature_NotHasTrue16BitInstsBit);
  if (Subtarget->useRealTrue16Insts())
    Features.set(Feature_UseRealTrue16InstsBit);
  if (Subtarget->hasTrue16BitInsts() && !Subtarget->useRealTrue16Insts())
    Features.set(Feature_UseFakeTrue16InstsBit);
  if (Subtarget->hasVOP3PInsts())
    Features.set(Feature_HasVOP3PInstsBit);
  if (Subtarget->hasMed3_16())
    Features.set(Feature_HasMed3_16Bit);
  if (Subtarget->supportsMinMaxDenormModes())
    Features.set(Feature_HasMinMaxDenormModesBit);
  if (!Subtarget->supportsMinMaxDenormModes())
    Features.set(Feature_NotHasMinMaxDenormModesBit);
  if (Subtarget->hasSDWA())
    Features.set(Feature_HasSDWABit);
  if (Subtarget->hasPackedFP32Ops())
    Features.set(Feature_HasPackedFP32OpsBit);
  if (Subtarget->hasImageInsts())
    Features.set(Feature_HasImageInstsBit);
  if (Subtarget->hasIntClamp())
    Features.set(Feature_HasIntClampBit);
  if (Subtarget->hasMadMixInsts())
    Features.set(Feature_HasMadMixInstsBit);
  if (Subtarget->hasScalarStores())
    Features.set(Feature_HasScalarStoresBit);
  if (Subtarget->getLDSBankCount() == 16)
    Features.set(Feature_has16BankLDSBit);
  if (Subtarget->getLDSBankCount() == 32)
    Features.set(Feature_has32BankLDSBit);
  if (Subtarget->hasFmaMixInsts())
    Features.set(Feature_HasFmaMixInstsBit);
  if (Subtarget->hasDLInsts())
    Features.set(Feature_HasDLInstsBit);
  if (Subtarget->hasFmacF64Inst())
    Features.set(Feature_HasFmacF64InstBit);
  if (Subtarget->hasDot1Insts())
    Features.set(Feature_HasDot1InstsBit);
  if (Subtarget->hasDot2Insts())
    Features.set(Feature_HasDot2InstsBit);
  if (Subtarget->hasDot3Insts())
    Features.set(Feature_HasDot3InstsBit);
  if (Subtarget->hasDot4Insts())
    Features.set(Feature_HasDot4InstsBit);
  if (Subtarget->hasDot5Insts())
    Features.set(Feature_HasDot5InstsBit);
  if (Subtarget->hasDot6Insts())
    Features.set(Feature_HasDot6InstsBit);
  if (Subtarget->hasDot7Insts())
    Features.set(Feature_HasDot7InstsBit);
  if (Subtarget->hasDot8Insts())
    Features.set(Feature_HasDot8InstsBit);
  if (Subtarget->hasDot9Insts())
    Features.set(Feature_HasDot9InstsBit);
  if (Subtarget->hasDot10Insts())
    Features.set(Feature_HasDot10InstsBit);
  if (Subtarget->hasDot11Insts())
    Features.set(Feature_HasDot11InstsBit);
  if (Subtarget->hasGetWaveIdInst())
    Features.set(Feature_HasGetWaveIdInstBit);
  if (Subtarget->hasMAIInsts())
    Features.set(Feature_HasMAIInstsBit);
  if (Subtarget->hasSMemRealTime())
    Features.set(Feature_HasSMemRealTimeBit);
  if (Subtarget->hasSMemTimeInst())
    Features.set(Feature_HasSMemTimeInstBit);
  if (Subtarget->hasShaderCyclesRegister())
    Features.set(Feature_HasShaderCyclesRegisterBit);
  if (Subtarget->hasShaderCyclesHiLoRegisters())
    Features.set(Feature_HasShaderCyclesHiLoRegistersBit);
  if (Subtarget->hasFP8Insts())
    Features.set(Feature_HasFP8InstsBit);
  if (Subtarget->hasFP8ConversionInsts())
    Features.set(Feature_HasFP8ConversionInstsBit);
  if (Subtarget->hasMadMacF32Insts())
    Features.set(Feature_HasMadMacF32InstsBit);
  if (Subtarget->hasGFX10_3Insts())
    Features.set(Feature_HasFmaLegacy32Bit);
  if (Subtarget->hasAtomicDsPkAdd16Insts())
    Features.set(Feature_HasAtomicDsPkAdd16InstsBit);
  if (Subtarget->hasAtomicFlatPkAdd16Insts())
    Features.set(Feature_HasAtomicFlatPkAdd16InstsBit);
  if (Subtarget->hasAtomicFaddRtnInsts())
    Features.set(Feature_HasAtomicFaddRtnInstsBit);
  if (Subtarget->hasAtomicFaddNoRtnInsts())
    Features.set(Feature_HasAtomicFaddNoRtnInstsBit);
  if (Subtarget->hasAtomicBufferGlobalPkAddF16NoRtnInsts() || Subtarget->hasAtomicBufferGlobalPkAddF16Insts())
    Features.set(Feature_HasAtomicBufferGlobalPkAddF16NoRtnInstsBit);
  if (Subtarget->hasAtomicBufferGlobalPkAddF16Insts())
    Features.set(Feature_HasAtomicBufferGlobalPkAddF16InstsBit);
  if (Subtarget->hasFlatAtomicFaddF32Inst())
    Features.set(Feature_HasFlatAtomicFaddF32InstBit);
  if (Subtarget->enableFlatScratch())
    Features.set(Feature_EnableFlatScratchBit);
  if (!Subtarget->enableFlatScratch())
    Features.set(Feature_DisableFlatScratchBit);
  if (Subtarget->hasUnalignedAccessMode())
    Features.set(Feature_HasUnalignedAccessModeBit);
  if (Subtarget->hasMADIntraFwdBug())
    Features.set(Feature_HasMADIntraFwdBugBit);
  if (!Subtarget->hasMADIntraFwdBug())
    Features.set(Feature_HasNotMADIntraFwdBugBit);
  if (Subtarget->hasSALUFloatInsts())
    Features.set(Feature_HasSALUFloatInstsBit);
  if (!Subtarget->hasSALUFloatInsts())
    Features.set(Feature_NotHasSALUFloatInstsBit);
  if (Subtarget->hasPseudoScalarTrans())
    Features.set(Feature_HasPseudoScalarTransBit);
  if (Subtarget->hasBitOp3Insts())
    Features.set(Feature_HasBitOp3InstsBit);
  if (Subtarget->hasPrngInst())
    Features.set(Feature_HasPrngInstBit);
  if (Subtarget->hasFP6BF6ConversionScaleInsts())
    Features.set(Feature_HasFP6BF6ConversionScaleInstsBit);
  if (Subtarget->hasF16BF16ToFP6BF6ConversionScaleInsts())
    Features.set(Feature_HasF16BF16ToFP6BF6ConversionScaleInstsBit);
  if (Subtarget->hasCvtPkF16F32Inst())
    Features.set(Feature_HasCvtPkF16F32InstBit);
  if (Subtarget->hasF32ToF16BF16ConversionSRInsts())
    Features.set(Feature_HasF32ToF16BF16ConversionSRInstsBit);
  if (Subtarget->hasGDS())
    Features.set(Feature_HasGDSBit);
  if (Subtarget->hasCvtFP8VOP1Bug())
    Features.set(Feature_HasCvtFP8VOP1BugBit);
  if (!Subtarget->hasCvtFP8VOP1Bug())
    Features.set(Feature_HasNoCvtFP8VOP1BugBit);
  if (Subtarget->hasAtomicCSubNoRtnInsts())
    Features.set(Feature_HasAtomicCSubNoRtnInstsBit);
  if (Subtarget->hasXF32Insts())
    Features.set(Feature_HasXF32InstsBit);
  if (Subtarget->hasAshrPkInsts())
    Features.set(Feature_HasAshrPkInstsBit);
  if (Subtarget->isWave32())
    Features.set(Feature_isWave32Bit);
  if (Subtarget->isWave64())
    Features.set(Feature_isWave64Bit);
  return Features;
}

void AMDGPUInstructionSelector::setupGeneratedPerFunctionState(MachineFunction &MF) {
  AvailableFunctionFeatures = computeAvailableFunctionFeatures((const AMDGPUSubtarget *)&MF.getSubtarget(), &MF);
}
PredicateBitset AMDGPUInstructionSelector::
computeAvailableFunctionFeatures(const AMDGPUSubtarget *Subtarget, const MachineFunction *MF) const {
  PredicateBitset Features{};
  if (MF->getInfo<SIMachineFunctionInfo>()->getMode().FP64FP16Denormals != DenormalMode::getPreserveSign())
    Features.set(Feature_FP16DenormalsBit);
  if (MF->getInfo<SIMachineFunctionInfo>()->getMode().FP64FP16Denormals != DenormalMode::getPreserveSign())
    Features.set(Feature_FP64DenormalsBit);
  if (MF->getInfo<SIMachineFunctionInfo>()->getMode().FP32Denormals == DenormalMode::getPreserveSign())
    Features.set(Feature_NoFP32DenormalsBit);
  return Features;
}

// Feature bitsets.
enum {
  GIFBS_Invalid,
  GIFBS_DisableFlatScratch,
  GIFBS_Has16BitInsts,
  GIFBS_HasAddNoCarryInsts,
  GIFBS_HasAshrPkInsts,
  GIFBS_HasAtomicBufferGlobalPkAddF16Insts,
  GIFBS_HasAtomicBufferGlobalPkAddF16NoRtnInsts,
  GIFBS_HasAtomicCSubNoRtnInsts,
  GIFBS_HasAtomicFMinFMaxF32GlobalInsts,
  GIFBS_HasAtomicFMinFMaxF64GlobalInsts,
  GIFBS_HasAtomicFaddNoRtnInsts,
  GIFBS_HasAtomicFaddRtnInsts,
  GIFBS_HasAtomicFlatPkAdd16Insts,
  GIFBS_HasBitOp3Insts,
  GIFBS_HasCvtPkF16F32Inst,
  GIFBS_HasD16LoadStore,
  GIFBS_HasDLInsts,
  GIFBS_HasDot10Insts,
  GIFBS_HasDot1Insts,
  GIFBS_HasDot2Insts,
  GIFBS_HasDot3Insts,
  GIFBS_HasDot4Insts,
  GIFBS_HasDot5Insts,
  GIFBS_HasDot6Insts,
  GIFBS_HasDot7Insts,
  GIFBS_HasDot8Insts,
  GIFBS_HasF16BF16ToFP6BF6ConversionScaleInsts,
  GIFBS_HasF32ToF16BF16ConversionSRInsts,
  GIFBS_HasFP6BF6ConversionScaleInsts,
  GIFBS_HasFP8Insts,
  GIFBS_HasFlatAddressSpace,
  GIFBS_HasFlatAtomicFaddF32Inst,
  GIFBS_HasFlatBufferGlobalAtomicFaddF64Inst,
  GIFBS_HasFlatGlobalInsts,
  GIFBS_HasFmaLegacy32,
  GIFBS_HasFmaMixInsts,
  GIFBS_HasFmacF64Inst,
  GIFBS_HasGDS,
  GIFBS_HasGFX10_BEncoding,
  GIFBS_HasGFX950Insts,
  GIFBS_HasGetWaveIdInst,
  GIFBS_HasIntClamp,
  GIFBS_HasLdsAtomicAddF64,
  GIFBS_HasMAIInsts,
  GIFBS_HasMadMacF32Insts,
  GIFBS_HasMinMaxDenormModes,
  GIFBS_HasMinimum3Maximum3F32,
  GIFBS_HasMinimum3Maximum3PKF16,
  GIFBS_HasPackedD16VMem,
  GIFBS_HasPackedFP32Ops,
  GIFBS_HasPrngInst,
  GIFBS_HasPseudoScalarTrans,
  GIFBS_HasSALUFloatInsts,
  GIFBS_HasSMemRealTime,
  GIFBS_HasSMemTimeInst,
  GIFBS_HasShaderCyclesHiLoRegisters,
  GIFBS_HasShaderCyclesRegister,
  GIFBS_HasTrue16BitInsts,
  GIFBS_HasUnpackedD16VMem,
  GIFBS_HasUnrestrictedSOffset,
  GIFBS_HasVOP3PInsts,
  GIFBS_HasXF32Insts,
  GIFBS_HasXNACKEnabled,
  GIFBS_LDSRequiresM0Init,
  GIFBS_NotHasAddNoCarryInsts,
  GIFBS_NotHasTrue16BitInsts,
  GIFBS_NotLDSRequiresM0Init,
  GIFBS_UseFakeTrue16Insts,
  GIFBS_UseRealTrue16Insts,
  GIFBS_isGFX10Only,
  GIFBS_isGFX10Plus,
  GIFBS_isGFX11Only,
  GIFBS_isGFX11Plus,
  GIFBS_isGFX12Only,
  GIFBS_isGFX12Plus,
  GIFBS_isGFX6,
  GIFBS_isGFX6GFX7,
  GIFBS_isGFX6GFX7GFX8GFX9,
  GIFBS_isGFX7GFX8GFX9,
  GIFBS_isGFX7Only,
  GIFBS_isGFX7Plus,
  GIFBS_isGFX8GFX9,
  GIFBS_isGFX8GFX9GFX10GFX11,
  GIFBS_isGFX8Plus,
  GIFBS_isGFX908orGFX90A,
  GIFBS_isGFX90APlus,
  GIFBS_isGFX940Plus,
  GIFBS_isGFX9GFX10,
  GIFBS_isGFX9Plus,
  GIFBS_isNotGFX12Plus,
  GIFBS_isNotGFX90APlus,
  GIFBS_isNotGFX940Plus,
  GIFBS_isNotGFX9Plus,
  GIFBS_isWave32,
  GIFBS_isWave64,
  GIFBS_DisableFlatScratch_HasD16LoadStore,
  GIFBS_DisableFlatScratch_HasUnrestrictedSOffset,
  GIFBS_EnableFlatScratch_HasFlatScratchInsts,
  GIFBS_FP16Denormals_NotHasMinMaxDenormModes,
  GIFBS_FalsePredicate_NotHasMinMaxDenormModes,
  GIFBS_Has16BitInsts_HasIntClamp,
  GIFBS_Has16BitInsts_NotHasTrue16BitInsts,
  GIFBS_Has16BitInsts_UseFakeTrue16Insts,
  GIFBS_Has16BitInsts_UseRealTrue16Insts,
  GIFBS_Has16BitInsts_isGFX6GFX7GFX8GFX9,
  GIFBS_Has16BitInsts_isGFX8GFX9,
  GIFBS_Has16BitInsts_isGFX8Only,
  GIFBS_Has16BitInsts_isNotGFX90APlus,
  GIFBS_HasAddNoCarryInsts_HasIntClamp,
  GIFBS_HasAtomicBufferGlobalPkAddF16Insts_HasUnrestrictedSOffset,
  GIFBS_HasAtomicBufferGlobalPkAddF16NoRtnInsts_HasUnrestrictedSOffset,
  GIFBS_HasAtomicCSubNoRtnInsts_isGFX12Plus,
  GIFBS_HasAtomicDsPkAdd16Insts_HasGDS,
  GIFBS_HasAtomicDsPkAdd16Insts_LDSRequiresM0Init,
  GIFBS_HasAtomicDsPkAdd16Insts_NotLDSRequiresM0Init,
  GIFBS_HasAtomicFMinFMaxF32FlatInsts_HasFlatAddressSpace,
  GIFBS_HasAtomicFMinFMaxF32FlatInsts_HasFlatGlobalInsts,
  GIFBS_HasAtomicFMinFMaxF32GlobalInsts_HasFlatGlobalInsts,
  GIFBS_HasAtomicFMinFMaxF32GlobalInsts_HasUnrestrictedSOffset,
  GIFBS_HasAtomicFMinFMaxF64FlatInsts_HasFlatAddressSpace,
  GIFBS_HasAtomicFMinFMaxF64GlobalInsts_HasFlatGlobalInsts,
  GIFBS_HasAtomicFMinFMaxF64GlobalInsts_HasUnrestrictedSOffset,
  GIFBS_HasAtomicFaddNoRtnInsts_HasUnrestrictedSOffset,
  GIFBS_HasAtomicFaddRtnInsts_HasUnrestrictedSOffset,
  GIFBS_HasCvtFP8VOP1Bug_HasFP8ConversionInsts,
  GIFBS_HasDot11Insts_isGFX12Plus,
  GIFBS_HasDot9Insts_NotHasTrue16BitInsts,
  GIFBS_HasDot9Insts_UseFakeTrue16Insts,
  GIFBS_HasDot9Insts_UseRealTrue16Insts,
  GIFBS_HasExportInsts_isGFX12Plus,
  GIFBS_HasFP8ConversionInsts_HasSDWA,
  GIFBS_HasFP8ConversionInsts_isGFX12Plus,
  GIFBS_HasFP8ConversionInsts_isGFX940Plus,
  GIFBS_HasFP8ConversionInsts_isGFX9Plus,
  GIFBS_HasFP8Insts_isGFX90APlus,
  GIFBS_HasFlatAddressSpace_isGFX12Plus,
  GIFBS_HasFlatBufferGlobalAtomicFaddF64Inst_HasUnrestrictedSOffset,
  GIFBS_HasFlatGlobalInsts_isGFX12Plus,
  GIFBS_HasGDS_HasLDSFPAtomicAddF32,
  GIFBS_HasGDS_isGFX11Plus,
  GIFBS_HasGDS_isGFX6GFX7GFX8GFX9GFX10,
  GIFBS_HasGFX950Insts_isGFX90APlus,
  GIFBS_HasImageInsts_isGFX12Plus,
  GIFBS_HasLDSFPAtomicAddF32_LDSRequiresM0Init,
  GIFBS_HasLDSFPAtomicAddF32_NotLDSRequiresM0Init,
  GIFBS_HasMADIntraFwdBug_isGFX11Only,
  GIFBS_HasMAIInsts_isGFX90APlus,
  GIFBS_HasMadMacF32Insts_NoFP32Denormals,
  GIFBS_HasMadMixInsts_NoFP32Denormals,
  GIFBS_HasMed3_16_NotHasTrue16BitInsts,
  GIFBS_HasMed3_16_UseFakeTrue16Insts,
  GIFBS_HasMed3_16_UseRealTrue16Insts,
  GIFBS_HasMinMaxDenormModes_isGFX12Plus,
  GIFBS_HasMinMaxDenormModes_isNotGFX12Plus,
  GIFBS_HasNotMADIntraFwdBug_isGFX9Plus,
  GIFBS_HasPackedD16VMem_HasUnrestrictedSOffset,
  GIFBS_HasScalarStores_isGFX8Plus,
  GIFBS_HasUnalignedAccessMode_LDSRequiresM0Init,
  GIFBS_HasUnalignedAccessMode_NotLDSRequiresM0Init,
  GIFBS_HasXF32Insts_isGFX90APlus,
  GIFBS_HasXNACKEnabled_isGFX7Only,
  GIFBS_HasXNACKEnabled_isGFX9Plus,
  GIFBS_HasXNACKEnabled_isNotGFX9Plus,
  GIFBS_LDSRequiresM0Init_isGFX6GFX7GFX8GFX9GFX10,
  GIFBS_LDSRequiresM0Init_isGFX7Plus,
  GIFBS_NotHasTrue16BitInsts_isGFX10Plus,
  GIFBS_NotHasTrue16BitInsts_isGFX12Plus,
  GIFBS_NotHasTrue16BitInsts_isGFX8Plus,
  GIFBS_NotHasTrue16BitInsts_isGFX9Plus,
  GIFBS_NotLDSRequiresM0Init_isGFX6GFX7GFX8GFX9GFX10,
  GIFBS_NotLDSRequiresM0Init_isGFX7Plus,
  GIFBS_UseFakeTrue16Insts_isGFX10Plus,
  GIFBS_UseFakeTrue16Insts_isGFX12Plus,
  GIFBS_UseFakeTrue16Insts_isGFX8Plus,
  GIFBS_UseFakeTrue16Insts_isGFX9Plus,
  GIFBS_UseRealTrue16Insts_isGFX10Plus,
  GIFBS_UseRealTrue16Insts_isGFX12Plus,
  GIFBS_UseRealTrue16Insts_isGFX8Plus,
  GIFBS_UseRealTrue16Insts_isGFX9Plus,
  GIFBS_has16BankLDS_isNotGFX90APlus,
  GIFBS_has32BankLDS_isNotGFX90APlus,
  GIFBS_isGFX11Only_isWave32,
  GIFBS_isGFX11Only_isWave64,
  GIFBS_isGFX12Plus_isWave32,
  GIFBS_isGFX12Plus_isWave64,
  GIFBS_isGFX90APlus_isGFX908orGFX90A,
  GIFBS_isGFX90APlus_isGFX940Plus,
  GIFBS_DisableFlatScratch_HasD16LoadStore_HasUnrestrictedSOffset,
  GIFBS_EnableFlatScratch_HasD16LoadStore_HasFlatScratchInsts,
  GIFBS_EnableFlatScratch_HasFlatScratchInsts_HasFlatScratchSVSMode,
  GIFBS_FP64Denormals_NotHasMinMaxDenormModes_isGFX12Plus,
  GIFBS_FP64Denormals_NotHasMinMaxDenormModes_isNotGFX12Plus,
  GIFBS_Has16BitInsts_HasMinMaxDenormModes_NotHasTrue16BitInsts,
  GIFBS_Has16BitInsts_HasMinMaxDenormModes_UseFakeTrue16Insts,
  GIFBS_Has16BitInsts_HasMinMaxDenormModes_UseRealTrue16Insts,
  GIFBS_Has16BitInsts_NotHasTrue16BitInsts_isGFX10Plus,
  GIFBS_Has16BitInsts_has32BankLDS_isNotGFX90APlus,
  GIFBS_HasFP8ConversionInsts_HasNoCvtFP8VOP1Bug_HasSDWA,
  GIFBS_HasMadMacF32Insts_NoFP32Denormals_isGFX6GFX7GFX10,
  GIFBS_EnableFlatScratch_HasD16LoadStore_HasFlatScratchInsts_HasFlatScratchSVSMode,
  GIFBS_FP16Denormals_Has16BitInsts_NotHasMinMaxDenormModes_NotHasTrue16BitInsts,
  GIFBS_FP16Denormals_Has16BitInsts_NotHasMinMaxDenormModes_UseFakeTrue16Insts,
  GIFBS_FP16Denormals_Has16BitInsts_NotHasMinMaxDenormModes_UseRealTrue16Insts,
};
constexpr static PredicateBitset FeatureBitsets[] {
  {}, // GIFBS_Invalid
  {Feature_DisableFlatScratchBit, },
  {Feature_Has16BitInstsBit, },
  {Feature_HasAddNoCarryInstsBit, },
  {Feature_HasAshrPkInstsBit, },
  {Feature_HasAtomicBufferGlobalPkAddF16InstsBit, },
  {Feature_HasAtomicBufferGlobalPkAddF16NoRtnInstsBit, },
  {Feature_HasAtomicCSubNoRtnInstsBit, },
  {Feature_HasAtomicFMinFMaxF32GlobalInstsBit, },
  {Feature_HasAtomicFMinFMaxF64GlobalInstsBit, },
  {Feature_HasAtomicFaddNoRtnInstsBit, },
  {Feature_HasAtomicFaddRtnInstsBit, },
  {Feature_HasAtomicFlatPkAdd16InstsBit, },
  {Feature_HasBitOp3InstsBit, },
  {Feature_HasCvtPkF16F32InstBit, },
  {Feature_HasD16LoadStoreBit, },
  {Feature_HasDLInstsBit, },
  {Feature_HasDot10InstsBit, },
  {Feature_HasDot1InstsBit, },
  {Feature_HasDot2InstsBit, },
  {Feature_HasDot3InstsBit, },
  {Feature_HasDot4InstsBit, },
  {Feature_HasDot5InstsBit, },
  {Feature_HasDot6InstsBit, },
  {Feature_HasDot7InstsBit, },
  {Feature_HasDot8InstsBit, },
  {Feature_HasF16BF16ToFP6BF6ConversionScaleInstsBit, },
  {Feature_HasF32ToF16BF16ConversionSRInstsBit, },
  {Feature_HasFP6BF6ConversionScaleInstsBit, },
  {Feature_HasFP8InstsBit, },
  {Feature_HasFlatAddressSpaceBit, },
  {Feature_HasFlatAtomicFaddF32InstBit, },
  {Feature_HasFlatBufferGlobalAtomicFaddF64InstBit, },
  {Feature_HasFlatGlobalInstsBit, },
  {Feature_HasFmaLegacy32Bit, },
  {Feature_HasFmaMixInstsBit, },
  {Feature_HasFmacF64InstBit, },
  {Feature_HasGDSBit, },
  {Feature_HasGFX10_BEncodingBit, },
  {Feature_HasGFX950InstsBit, },
  {Feature_HasGetWaveIdInstBit, },
  {Feature_HasIntClampBit, },
  {Feature_HasLdsAtomicAddF64Bit, },
  {Feature_HasMAIInstsBit, },
  {Feature_HasMadMacF32InstsBit, },
  {Feature_HasMinMaxDenormModesBit, },
  {Feature_HasMinimum3Maximum3F32Bit, },
  {Feature_HasMinimum3Maximum3PKF16Bit, },
  {Feature_HasPackedD16VMemBit, },
  {Feature_HasPackedFP32OpsBit, },
  {Feature_HasPrngInstBit, },
  {Feature_HasPseudoScalarTransBit, },
  {Feature_HasSALUFloatInstsBit, },
  {Feature_HasSMemRealTimeBit, },
  {Feature_HasSMemTimeInstBit, },
  {Feature_HasShaderCyclesHiLoRegistersBit, },
  {Feature_HasShaderCyclesRegisterBit, },
  {Feature_HasTrue16BitInstsBit, },
  {Feature_HasUnpackedD16VMemBit, },
  {Feature_HasUnrestrictedSOffsetBit, },
  {Feature_HasVOP3PInstsBit, },
  {Feature_HasXF32InstsBit, },
  {Feature_HasXNACKEnabledBit, },
  {Feature_LDSRequiresM0InitBit, },
  {Feature_NotHasAddNoCarryInstsBit, },
  {Feature_NotHasTrue16BitInstsBit, },
  {Feature_NotLDSRequiresM0InitBit, },
  {Feature_UseFakeTrue16InstsBit, },
  {Feature_UseRealTrue16InstsBit, },
  {Feature_isGFX10OnlyBit, },
  {Feature_isGFX10PlusBit, },
  {Feature_isGFX11OnlyBit, },
  {Feature_isGFX11PlusBit, },
  {Feature_isGFX12OnlyBit, },
  {Feature_isGFX12PlusBit, },
  {Feature_isGFX6Bit, },
  {Feature_isGFX6GFX7Bit, },
  {Feature_isGFX6GFX7GFX8GFX9Bit, },
  {Feature_isGFX7GFX8GFX9Bit, },
  {Feature_isGFX7OnlyBit, },
  {Feature_isGFX7PlusBit, },
  {Feature_isGFX8GFX9Bit, },
  {Feature_isGFX8GFX9GFX10GFX11Bit, },
  {Feature_isGFX8PlusBit, },
  {Feature_isGFX908orGFX90ABit, },
  {Feature_isGFX90APlusBit, },
  {Feature_isGFX940PlusBit, },
  {Feature_isGFX9GFX10Bit, },
  {Feature_isGFX9PlusBit, },
  {Feature_isNotGFX12PlusBit, },
  {Feature_isNotGFX90APlusBit, },
  {Feature_isNotGFX940PlusBit, },
  {Feature_isNotGFX9PlusBit, },
  {Feature_isWave32Bit, },
  {Feature_isWave64Bit, },
  {Feature_DisableFlatScratchBit, Feature_HasD16LoadStoreBit, },
  {Feature_DisableFlatScratchBit, Feature_HasUnrestrictedSOffsetBit, },
  {Feature_EnableFlatScratchBit, Feature_HasFlatScratchInstsBit, },
  {Feature_FP16DenormalsBit, Feature_NotHasMinMaxDenormModesBit, },
  {Feature_FalsePredicateBit, Feature_NotHasMinMaxDenormModesBit, },
  {Feature_Has16BitInstsBit, Feature_HasIntClampBit, },
  {Feature_Has16BitInstsBit, Feature_NotHasTrue16BitInstsBit, },
  {Feature_Has16BitInstsBit, Feature_UseFakeTrue16InstsBit, },
  {Feature_Has16BitInstsBit, Feature_UseRealTrue16InstsBit, },
  {Feature_Has16BitInstsBit, Feature_isGFX6GFX7GFX8GFX9Bit, },
  {Feature_Has16BitInstsBit, Feature_isGFX8GFX9Bit, },
  {Feature_Has16BitInstsBit, Feature_isGFX8OnlyBit, },
  {Feature_Has16BitInstsBit, Feature_isNotGFX90APlusBit, },
  {Feature_HasAddNoCarryInstsBit, Feature_HasIntClampBit, },
  {Feature_HasAtomicBufferGlobalPkAddF16InstsBit, Feature_HasUnrestrictedSOffsetBit, },
  {Feature_HasAtomicBufferGlobalPkAddF16NoRtnInstsBit, Feature_HasUnrestrictedSOffsetBit, },
  {Feature_HasAtomicCSubNoRtnInstsBit, Feature_isGFX12PlusBit, },
  {Feature_HasAtomicDsPkAdd16InstsBit, Feature_HasGDSBit, },
  {Feature_HasAtomicDsPkAdd16InstsBit, Feature_LDSRequiresM0InitBit, },
  {Feature_HasAtomicDsPkAdd16InstsBit, Feature_NotLDSRequiresM0InitBit, },
  {Feature_HasAtomicFMinFMaxF32FlatInstsBit, Feature_HasFlatAddressSpaceBit, },
  {Feature_HasAtomicFMinFMaxF32FlatInstsBit, Feature_HasFlatGlobalInstsBit, },
  {Feature_HasAtomicFMinFMaxF32GlobalInstsBit, Feature_HasFlatGlobalInstsBit, },
  {Feature_HasAtomicFMinFMaxF32GlobalInstsBit, Feature_HasUnrestrictedSOffsetBit, },
  {Feature_HasAtomicFMinFMaxF64FlatInstsBit, Feature_HasFlatAddressSpaceBit, },
  {Feature_HasAtomicFMinFMaxF64GlobalInstsBit, Feature_HasFlatGlobalInstsBit, },
  {Feature_HasAtomicFMinFMaxF64GlobalInstsBit, Feature_HasUnrestrictedSOffsetBit, },
  {Feature_HasAtomicFaddNoRtnInstsBit, Feature_HasUnrestrictedSOffsetBit, },
  {Feature_HasAtomicFaddRtnInstsBit, Feature_HasUnrestrictedSOffsetBit, },
  {Feature_HasCvtFP8VOP1BugBit, Feature_HasFP8ConversionInstsBit, },
  {Feature_HasDot11InstsBit, Feature_isGFX12PlusBit, },
  {Feature_HasDot9InstsBit, Feature_NotHasTrue16BitInstsBit, },
  {Feature_HasDot9InstsBit, Feature_UseFakeTrue16InstsBit, },
  {Feature_HasDot9InstsBit, Feature_UseRealTrue16InstsBit, },
  {Feature_HasExportInstsBit, Feature_isGFX12PlusBit, },
  {Feature_HasFP8ConversionInstsBit, Feature_HasSDWABit, },
  {Feature_HasFP8ConversionInstsBit, Feature_isGFX12PlusBit, },
  {Feature_HasFP8ConversionInstsBit, Feature_isGFX940PlusBit, },
  {Feature_HasFP8ConversionInstsBit, Feature_isGFX9PlusBit, },
  {Feature_HasFP8InstsBit, Feature_isGFX90APlusBit, },
  {Feature_HasFlatAddressSpaceBit, Feature_isGFX12PlusBit, },
  {Feature_HasFlatBufferGlobalAtomicFaddF64InstBit, Feature_HasUnrestrictedSOffsetBit, },
  {Feature_HasFlatGlobalInstsBit, Feature_isGFX12PlusBit, },
  {Feature_HasGDSBit, Feature_HasLDSFPAtomicAddF32Bit, },
  {Feature_HasGDSBit, Feature_isGFX11PlusBit, },
  {Feature_HasGDSBit, Feature_isGFX6GFX7GFX8GFX9GFX10Bit, },
  {Feature_HasGFX950InstsBit, Feature_isGFX90APlusBit, },
  {Feature_HasImageInstsBit, Feature_isGFX12PlusBit, },
  {Feature_HasLDSFPAtomicAddF32Bit, Feature_LDSRequiresM0InitBit, },
  {Feature_HasLDSFPAtomicAddF32Bit, Feature_NotLDSRequiresM0InitBit, },
  {Feature_HasMADIntraFwdBugBit, Feature_isGFX11OnlyBit, },
  {Feature_HasMAIInstsBit, Feature_isGFX90APlusBit, },
  {Feature_HasMadMacF32InstsBit, Feature_NoFP32DenormalsBit, },
  {Feature_HasMadMixInstsBit, Feature_NoFP32DenormalsBit, },
  {Feature_HasMed3_16Bit, Feature_NotHasTrue16BitInstsBit, },
  {Feature_HasMed3_16Bit, Feature_UseFakeTrue16InstsBit, },
  {Feature_HasMed3_16Bit, Feature_UseRealTrue16InstsBit, },
  {Feature_HasMinMaxDenormModesBit, Feature_isGFX12PlusBit, },
  {Feature_HasMinMaxDenormModesBit, Feature_isNotGFX12PlusBit, },
  {Feature_HasNotMADIntraFwdBugBit, Feature_isGFX9PlusBit, },
  {Feature_HasPackedD16VMemBit, Feature_HasUnrestrictedSOffsetBit, },
  {Feature_HasScalarStoresBit, Feature_isGFX8PlusBit, },
  {Feature_HasUnalignedAccessModeBit, Feature_LDSRequiresM0InitBit, },
  {Feature_HasUnalignedAccessModeBit, Feature_NotLDSRequiresM0InitBit, },
  {Feature_HasXF32InstsBit, Feature_isGFX90APlusBit, },
  {Feature_HasXNACKEnabledBit, Feature_isGFX7OnlyBit, },
  {Feature_HasXNACKEnabledBit, Feature_isGFX9PlusBit, },
  {Feature_HasXNACKEnabledBit, Feature_isNotGFX9PlusBit, },
  {Feature_LDSRequiresM0InitBit, Feature_isGFX6GFX7GFX8GFX9GFX10Bit, },
  {Feature_LDSRequiresM0InitBit, Feature_isGFX7PlusBit, },
  {Feature_NotHasTrue16BitInstsBit, Feature_isGFX10PlusBit, },
  {Feature_NotHasTrue16BitInstsBit, Feature_isGFX12PlusBit, },
  {Feature_NotHasTrue16BitInstsBit, Feature_isGFX8PlusBit, },
  {Feature_NotHasTrue16BitInstsBit, Feature_isGFX9PlusBit, },
  {Feature_NotLDSRequiresM0InitBit, Feature_isGFX6GFX7GFX8GFX9GFX10Bit, },
  {Feature_NotLDSRequiresM0InitBit, Feature_isGFX7PlusBit, },
  {Feature_UseFakeTrue16InstsBit, Feature_isGFX10PlusBit, },
  {Feature_UseFakeTrue16InstsBit, Feature_isGFX12PlusBit, },
  {Feature_UseFakeTrue16InstsBit, Feature_isGFX8PlusBit, },
  {Feature_UseFakeTrue16InstsBit, Feature_isGFX9PlusBit, },
  {Feature_UseRealTrue16InstsBit, Feature_isGFX10PlusBit, },
  {Feature_UseRealTrue16InstsBit, Feature_isGFX12PlusBit, },
  {Feature_UseRealTrue16InstsBit, Feature_isGFX8PlusBit, },
  {Feature_UseRealTrue16InstsBit, Feature_isGFX9PlusBit, },
  {Feature_has16BankLDSBit, Feature_isNotGFX90APlusBit, },
  {Feature_has32BankLDSBit, Feature_isNotGFX90APlusBit, },
  {Feature_isGFX11OnlyBit, Feature_isWave32Bit, },
  {Feature_isGFX11OnlyBit, Feature_isWave64Bit, },
  {Feature_isGFX12PlusBit, Feature_isWave32Bit, },
  {Feature_isGFX12PlusBit, Feature_isWave64Bit, },
  {Feature_isGFX90APlusBit, Feature_isGFX908orGFX90ABit, },
  {Feature_isGFX90APlusBit, Feature_isGFX940PlusBit, },
  {Feature_DisableFlatScratchBit, Feature_HasD16LoadStoreBit, Feature_HasUnrestrictedSOffsetBit, },
  {Feature_EnableFlatScratchBit, Feature_HasD16LoadStoreBit, Feature_HasFlatScratchInstsBit, },
  {Feature_EnableFlatScratchBit, Feature_HasFlatScratchInstsBit, Feature_HasFlatScratchSVSModeBit, },
  {Feature_FP64DenormalsBit, Feature_NotHasMinMaxDenormModesBit, Feature_isGFX12PlusBit, },
  {Feature_FP64DenormalsBit, Feature_NotHasMinMaxDenormModesBit, Feature_isNotGFX12PlusBit, },
  {Feature_Has16BitInstsBit, Feature_HasMinMaxDenormModesBit, Feature_NotHasTrue16BitInstsBit, },
  {Feature_Has16BitInstsBit, Feature_HasMinMaxDenormModesBit, Feature_UseFakeTrue16InstsBit, },
  {Feature_Has16BitInstsBit, Feature_HasMinMaxDenormModesBit, Feature_UseRealTrue16InstsBit, },
  {Feature_Has16BitInstsBit, Feature_NotHasTrue16BitInstsBit, Feature_isGFX10PlusBit, },
  {Feature_Has16BitInstsBit, Feature_has32BankLDSBit, Feature_isNotGFX90APlusBit, },
  {Feature_HasFP8ConversionInstsBit, Feature_HasNoCvtFP8VOP1BugBit, Feature_HasSDWABit, },
  {Feature_HasMadMacF32InstsBit, Feature_NoFP32DenormalsBit, Feature_isGFX6GFX7GFX10Bit, },
  {Feature_EnableFlatScratchBit, Feature_HasD16LoadStoreBit, Feature_HasFlatScratchInstsBit, Feature_HasFlatScratchSVSModeBit, },
  {Feature_FP16DenormalsBit, Feature_Has16BitInstsBit, Feature_NotHasMinMaxDenormModesBit, Feature_NotHasTrue16BitInstsBit, },
  {Feature_FP16DenormalsBit, Feature_Has16BitInstsBit, Feature_NotHasMinMaxDenormModesBit, Feature_UseFakeTrue16InstsBit, },
  {Feature_FP16DenormalsBit, Feature_Has16BitInstsBit, Feature_NotHasMinMaxDenormModesBit, Feature_UseRealTrue16InstsBit, },
};

// ComplexPattern predicates.
enum {
  GICP_Invalid,
  GICP_gi_buf_soffset,
  GICP_gi_ds_128bit_8byte_aligned,
  GICP_gi_ds_1addr_1offset,
  GICP_gi_ds_64bit_4byte_aligned,
  GICP_gi_flat_offset,
  GICP_gi_flat_scratch_offset,
  GICP_gi_flat_scratch_saddr,
  GICP_gi_flat_scratch_svaddr,
  GICP_gi_global_offset,
  GICP_gi_global_saddr,
  GICP_gi_mubuf_addr64,
  GICP_gi_mubuf_offset,
  GICP_gi_mubuf_scratch_offen,
  GICP_gi_mubuf_scratch_offset,
  GICP_gi_smrd_buffer_imm,
  GICP_gi_smrd_buffer_imm32,
  GICP_gi_smrd_buffer_sgpr_imm,
  GICP_gi_smrd_imm,
  GICP_gi_smrd_imm32,
  GICP_gi_smrd_sgpr,
  GICP_gi_smrd_sgpr_imm,
  GICP_gi_swmmacindex16,
  GICP_gi_swmmacindex8,
  GICP_gi_vcsrc,
  GICP_gi_vinterpmods,
  GICP_gi_vinterpmods_hi,
  GICP_gi_vop3_mad_mix_mods,
  GICP_gi_vop3_mad_mix_mods_ext,
  GICP_gi_vop3_no_mods,
  GICP_gi_vop3mods,
  GICP_gi_vop3mods0,
  GICP_gi_vop3modsnoncanonicalizing,
  GICP_gi_vop3omods,
  GICP_gi_vop3opsel,
  GICP_gi_vop3opselmods,
  GICP_gi_vop3pmods,
  GICP_gi_vop3pmodsdot,
  GICP_gi_vop3pmodsneg,
  GICP_gi_vsrc0,
  GICP_gi_wmmamods,
  GICP_gi_wmmamodsf16Neg,
  GICP_gi_wmmamodsf16NegAbs,
  GICP_gi_wmmaopselvop3pmods,
  GICP_gi_wmmavisrc,
};
// See constructor for table contents

AMDGPUInstructionSelector::ComplexMatcherMemFn
AMDGPUInstructionSelector::ComplexPredicateFns[] = {
  nullptr, // GICP_Invalid
  &AMDGPUInstructionSelector::selectBUFSOffset, // gi_buf_soffset
  &AMDGPUInstructionSelector::selectDS128Bit8ByteAligned, // gi_ds_128bit_8byte_aligned
  &AMDGPUInstructionSelector::selectDS1Addr1Offset, // gi_ds_1addr_1offset
  &AMDGPUInstructionSelector::selectDS64Bit4ByteAligned, // gi_ds_64bit_4byte_aligned
  &AMDGPUInstructionSelector::selectFlatOffset, // gi_flat_offset
  &AMDGPUInstructionSelector::selectScratchOffset, // gi_flat_scratch_offset
  &AMDGPUInstructionSelector::selectScratchSAddr, // gi_flat_scratch_saddr
  &AMDGPUInstructionSelector::selectScratchSVAddr, // gi_flat_scratch_svaddr
  &AMDGPUInstructionSelector::selectGlobalOffset, // gi_global_offset
  &AMDGPUInstructionSelector::selectGlobalSAddr, // gi_global_saddr
  &AMDGPUInstructionSelector::selectMUBUFAddr64, // gi_mubuf_addr64
  &AMDGPUInstructionSelector::selectMUBUFOffset, // gi_mubuf_offset
  &AMDGPUInstructionSelector::selectMUBUFScratchOffen, // gi_mubuf_scratch_offen
  &AMDGPUInstructionSelector::selectMUBUFScratchOffset, // gi_mubuf_scratch_offset
  &AMDGPUInstructionSelector::selectSMRDBufferImm, // gi_smrd_buffer_imm
  &AMDGPUInstructionSelector::selectSMRDBufferImm32, // gi_smrd_buffer_imm32
  &AMDGPUInstructionSelector::selectSMRDBufferSgprImm, // gi_smrd_buffer_sgpr_imm
  &AMDGPUInstructionSelector::selectSmrdImm, // gi_smrd_imm
  &AMDGPUInstructionSelector::selectSmrdImm32, // gi_smrd_imm32
  &AMDGPUInstructionSelector::selectSmrdSgpr, // gi_smrd_sgpr
  &AMDGPUInstructionSelector::selectSmrdSgprImm, // gi_smrd_sgpr_imm
  &AMDGPUInstructionSelector::selectSWMMACIndex16, // gi_swmmacindex16
  &AMDGPUInstructionSelector::selectSWMMACIndex8, // gi_swmmacindex8
  &AMDGPUInstructionSelector::selectVCSRC, // gi_vcsrc
  &AMDGPUInstructionSelector::selectVINTERPMods, // gi_vinterpmods
  &AMDGPUInstructionSelector::selectVINTERPModsHi, // gi_vinterpmods_hi
  &AMDGPUInstructionSelector::selectVOP3PMadMixMods, // gi_vop3_mad_mix_mods
  &AMDGPUInstructionSelector::selectVOP3PMadMixModsExt, // gi_vop3_mad_mix_mods_ext
  &AMDGPUInstructionSelector::selectVOP3NoMods, // gi_vop3_no_mods
  &AMDGPUInstructionSelector::selectVOP3Mods, // gi_vop3mods
  &AMDGPUInstructionSelector::selectVOP3Mods0, // gi_vop3mods0
  &AMDGPUInstructionSelector::selectVOP3ModsNonCanonicalizing, // gi_vop3modsnoncanonicalizing
  &AMDGPUInstructionSelector::selectVOP3OMods, // gi_vop3omods
  &AMDGPUInstructionSelector::selectVOP3OpSelMods, // gi_vop3opsel
  &AMDGPUInstructionSelector::selectVOP3OpSelMods, // gi_vop3opselmods
  &AMDGPUInstructionSelector::selectVOP3PMods, // gi_vop3pmods
  &AMDGPUInstructionSelector::selectVOP3PModsDOT, // gi_vop3pmodsdot
  &AMDGPUInstructionSelector::selectVOP3PModsNeg, // gi_vop3pmodsneg
  &AMDGPUInstructionSelector::selectVSRC0, // gi_vsrc0
  &AMDGPUInstructionSelector::selectWMMAModsF32NegAbs, // gi_wmmamods
  &AMDGPUInstructionSelector::selectWMMAModsF16Neg, // gi_wmmamodsf16Neg
  &AMDGPUInstructionSelector::selectWMMAModsF16NegAbs, // gi_wmmamodsf16NegAbs
  &AMDGPUInstructionSelector::selectWMMAOpSelVOP3PMods, // gi_wmmaopselvop3pmods
  &AMDGPUInstructionSelector::selectWMMAVISrc, // gi_wmmavisrc
};

// PatFrag predicates.
enum {
  GICXXPred_MI_Predicate_aligned_smrd_load = GICXXPred_Invalid + 1,
  GICXXPred_MI_Predicate_anonymous_13376,
  GICXXPred_MI_Predicate_anonymous_13379,
  GICXXPred_MI_Predicate_anonymous_13380,
  GICXXPred_MI_Predicate_anonymous_13381,
  GICXXPred_MI_Predicate_anonymous_13382,
  GICXXPred_MI_Predicate_anonymous_13383,
  GICXXPred_MI_Predicate_anonymous_13386,
  GICXXPred_MI_Predicate_anonymous_13387,
  GICXXPred_MI_Predicate_anonymous_13388,
  GICXXPred_MI_Predicate_anonymous_13389,
  GICXXPred_MI_Predicate_anonymous_13390,
  GICXXPred_MI_Predicate_anonymous_13391,
  GICXXPred_MI_Predicate_anonymous_13392,
  GICXXPred_MI_Predicate_anonymous_13393,
  GICXXPred_MI_Predicate_anonymous_13394,
  GICXXPred_MI_Predicate_anonymous_13395,
  GICXXPred_MI_Predicate_anonymous_13396,
  GICXXPred_MI_Predicate_anonymous_13397,
  GICXXPred_MI_Predicate_anonymous_13398,
  GICXXPred_MI_Predicate_anonymous_13399,
  GICXXPred_MI_Predicate_anonymous_13400,
  GICXXPred_MI_Predicate_anonymous_13401,
  GICXXPred_MI_Predicate_anonymous_13402,
  GICXXPred_MI_Predicate_anonymous_13403,
  GICXXPred_MI_Predicate_anonymous_13404,
  GICXXPred_MI_Predicate_anonymous_13405,
  GICXXPred_MI_Predicate_anonymous_13406,
  GICXXPred_MI_Predicate_anonymous_13407,
  GICXXPred_MI_Predicate_anonymous_13408,
  GICXXPred_MI_Predicate_anonymous_13409,
  GICXXPred_MI_Predicate_anonymous_13410,
  GICXXPred_MI_Predicate_anonymous_13411,
  GICXXPred_MI_Predicate_anonymous_13412,
  GICXXPred_MI_Predicate_anonymous_13413,
  GICXXPred_MI_Predicate_anonymous_13414,
  GICXXPred_MI_Predicate_anonymous_13415,
  GICXXPred_MI_Predicate_anonymous_13416,
  GICXXPred_MI_Predicate_anonymous_13417,
  GICXXPred_MI_Predicate_anonymous_13418,
  GICXXPred_MI_Predicate_anonymous_13419,
  GICXXPred_MI_Predicate_anonymous_13420,
  GICXXPred_MI_Predicate_anonymous_13421,
  GICXXPred_MI_Predicate_anonymous_13422,
  GICXXPred_MI_Predicate_anonymous_13423,
  GICXXPred_MI_Predicate_anonymous_13424,
  GICXXPred_MI_Predicate_anonymous_13425,
  GICXXPred_MI_Predicate_anonymous_13426,
  GICXXPred_MI_Predicate_anonymous_13427,
  GICXXPred_MI_Predicate_anonymous_13434,
  GICXXPred_MI_Predicate_anonymous_13446,
  GICXXPred_MI_Predicate_anonymous_17888,
  GICXXPred_MI_Predicate_anonymous_18806,
  GICXXPred_MI_Predicate_anonymous_18808,
  GICXXPred_MI_Predicate_anonymous_19201,
  GICXXPred_MI_Predicate_anonymous_19203,
  GICXXPred_MI_Predicate_anonymous_19205,
  GICXXPred_MI_Predicate_anonymous_19207,
  GICXXPred_MI_Predicate_anonymous_19209,
  GICXXPred_MI_Predicate_anonymous_19213,
  GICXXPred_MI_Predicate_anonymous_19215,
  GICXXPred_MI_Predicate_anonymous_19217,
  GICXXPred_MI_Predicate_anonymous_19219,
  GICXXPred_MI_Predicate_anonymous_19221,
  GICXXPred_MI_Predicate_anonymous_19456,
  GICXXPred_MI_Predicate_anonymous_19458,
  GICXXPred_MI_Predicate_anonymous_19699,
  GICXXPred_MI_Predicate_anonymous_19709,
  GICXXPred_MI_Predicate_anonymous_19712,
  GICXXPred_MI_Predicate_anonymous_19818,
  GICXXPred_MI_Predicate_anonymous_20243,
  GICXXPred_MI_Predicate_anonymous_20246,
  GICXXPred_MI_Predicate_anonymous_20249,
  GICXXPred_MI_Predicate_anonymous_20251,
  GICXXPred_MI_Predicate_anonymous_20254,
  GICXXPred_MI_Predicate_anonymous_20256,
  GICXXPred_MI_Predicate_anonymous_20259,
  GICXXPred_MI_Predicate_anonymous_20262,
  GICXXPred_MI_Predicate_anonymous_20266,
  GICXXPred_MI_Predicate_anonymous_20278,
  GICXXPred_MI_Predicate_anonymous_20709,
  GICXXPred_MI_Predicate_anonymous_20982,
  GICXXPred_MI_Predicate_anonymous_20985,
  GICXXPred_MI_Predicate_anonymous_20987,
  GICXXPred_MI_Predicate_anonymous_20989,
  GICXXPred_MI_Predicate_anonymous_20991,
  GICXXPred_MI_Predicate_anonymous_20993,
  GICXXPred_MI_Predicate_anonymous_20995,
  GICXXPred_MI_Predicate_anonymous_22685,
  GICXXPred_MI_Predicate_anonymous_22687,
  GICXXPred_MI_Predicate_anonymous_22691,
  GICXXPred_MI_Predicate_anonymous_22693,
  GICXXPred_MI_Predicate_anonymous_22695,
  GICXXPred_MI_Predicate_anonymous_22697,
  GICXXPred_MI_Predicate_anonymous_22701,
  GICXXPred_MI_Predicate_anonymous_22703,
  GICXXPred_MI_Predicate_anonymous_22705,
  GICXXPred_MI_Predicate_anonymous_22707,
  GICXXPred_MI_Predicate_anonymous_22709,
  GICXXPred_MI_Predicate_anonymous_22711,
  GICXXPred_MI_Predicate_anonymous_22713,
  GICXXPred_MI_Predicate_anonymous_22715,
  GICXXPred_MI_Predicate_anonymous_22719,
  GICXXPred_MI_Predicate_anonymous_22721,
  GICXXPred_MI_Predicate_anonymous_22723,
  GICXXPred_MI_Predicate_anonymous_22725,
  GICXXPred_MI_Predicate_anonymous_22729,
  GICXXPred_MI_Predicate_anonymous_22731,
  GICXXPred_MI_Predicate_anonymous_22735,
  GICXXPred_MI_Predicate_anonymous_22737,
  GICXXPred_MI_Predicate_anonymous_22739,
  GICXXPred_MI_Predicate_anonymous_22741,
  GICXXPred_MI_Predicate_anonymous_22745,
  GICXXPred_MI_Predicate_anonymous_22747,
  GICXXPred_MI_Predicate_anonymous_22749,
  GICXXPred_MI_Predicate_anonymous_22751,
  GICXXPred_MI_Predicate_anonymous_22753,
  GICXXPred_MI_Predicate_anonymous_22755,
  GICXXPred_MI_Predicate_anonymous_22757,
  GICXXPred_MI_Predicate_anonymous_22759,
  GICXXPred_MI_Predicate_anonymous_22763,
  GICXXPred_MI_Predicate_anonymous_22765,
  GICXXPred_MI_Predicate_anonymous_22767,
  GICXXPred_MI_Predicate_anonymous_22769,
  GICXXPred_MI_Predicate_anonymous_22773,
  GICXXPred_MI_Predicate_anonymous_22775,
  GICXXPred_MI_Predicate_anonymous_22777,
  GICXXPred_MI_Predicate_anonymous_22779,
  GICXXPred_MI_Predicate_anonymous_22781,
  GICXXPred_MI_Predicate_anonymous_22783,
  GICXXPred_MI_Predicate_anonymous_22787,
  GICXXPred_MI_Predicate_anonymous_22789,
  GICXXPred_MI_Predicate_anonymous_22791,
  GICXXPred_MI_Predicate_anonymous_22793,
  GICXXPred_MI_Predicate_anonymous_22795,
  GICXXPred_MI_Predicate_anonymous_22797,
  GICXXPred_MI_Predicate_anonymous_22801,
  GICXXPred_MI_Predicate_anonymous_22803,
  GICXXPred_MI_Predicate_anonymous_22807,
  GICXXPred_MI_Predicate_anonymous_22809,
  GICXXPred_MI_Predicate_anonymous_22811,
  GICXXPred_MI_Predicate_anonymous_22813,
  GICXXPred_MI_Predicate_anonymous_22833,
  GICXXPred_MI_Predicate_anonymous_22835,
  GICXXPred_MI_Predicate_anonymous_22869,
  GICXXPred_MI_Predicate_anonymous_22871,
  GICXXPred_MI_Predicate_anonymous_22891,
  GICXXPred_MI_Predicate_anonymous_22893,
  GICXXPred_MI_Predicate_anonymous_22931,
  GICXXPred_MI_Predicate_anonymous_22933,
  GICXXPred_MI_Predicate_anonymous_22937,
  GICXXPred_MI_Predicate_anonymous_22939,
  GICXXPred_MI_Predicate_anonymous_22941,
  GICXXPred_MI_Predicate_anonymous_22943,
  GICXXPred_MI_Predicate_anonymous_22945,
  GICXXPred_MI_Predicate_anonymous_22947,
  GICXXPred_MI_Predicate_anonymous_22949,
  GICXXPred_MI_Predicate_anonymous_22951,
  GICXXPred_MI_Predicate_anonymous_22955,
  GICXXPred_MI_Predicate_anonymous_22957,
  GICXXPred_MI_Predicate_anonymous_22959,
  GICXXPred_MI_Predicate_anonymous_22961,
  GICXXPred_MI_Predicate_anonymous_22965,
  GICXXPred_MI_Predicate_anonymous_22967,
  GICXXPred_MI_Predicate_anonymous_22969,
  GICXXPred_MI_Predicate_anonymous_22971,
  GICXXPred_MI_Predicate_anonymous_22973,
  GICXXPred_MI_Predicate_anonymous_22975,
  GICXXPred_MI_Predicate_anonymous_22979,
  GICXXPred_MI_Predicate_anonymous_22981,
  GICXXPred_MI_Predicate_anonymous_22983,
  GICXXPred_MI_Predicate_anonymous_22985,
  GICXXPred_MI_Predicate_anonymous_22987,
  GICXXPred_MI_Predicate_anonymous_22989,
  GICXXPred_MI_Predicate_anonymous_22991,
  GICXXPred_MI_Predicate_anonymous_22993,
  GICXXPred_MI_Predicate_anonymous_22995,
  GICXXPred_MI_Predicate_anonymous_22997,
  GICXXPred_MI_Predicate_anonymous_23001,
  GICXXPred_MI_Predicate_anonymous_23003,
  GICXXPred_MI_Predicate_anonymous_23005,
  GICXXPred_MI_Predicate_anonymous_23007,
  GICXXPred_MI_Predicate_anonymous_23009,
  GICXXPred_MI_Predicate_anonymous_23011,
  GICXXPred_MI_Predicate_anonymous_23013,
  GICXXPred_MI_Predicate_anonymous_23015,
  GICXXPred_MI_Predicate_anonymous_33573,
  GICXXPred_MI_Predicate_anonymous_33880,
  GICXXPred_MI_Predicate_anonymous_33882,
  GICXXPred_MI_Predicate_anonymous_33928,
  GICXXPred_MI_Predicate_anonymous_33941,
  GICXXPred_MI_Predicate_anonymous_33942,
  GICXXPred_MI_Predicate_anonymous_33945,
  GICXXPred_MI_Predicate_anonymous_33948,
  GICXXPred_MI_Predicate_anonymous_33951,
  GICXXPred_MI_Predicate_anonymous_33955,
  GICXXPred_MI_Predicate_anonymous_33958,
  GICXXPred_MI_Predicate_anonymous_33961,
  GICXXPred_MI_Predicate_anonymous_33963,
  GICXXPred_MI_Predicate_anonymous_33970,
  GICXXPred_MI_Predicate_anonymous_33973,
  GICXXPred_MI_Predicate_anonymous_33975,
  GICXXPred_MI_Predicate_anonymous_33983,
  GICXXPred_MI_Predicate_anonymous_33988,
  GICXXPred_MI_Predicate_anonymous_33992,
  GICXXPred_MI_Predicate_anonymous_33996,
  GICXXPred_MI_Predicate_anonymous_34144,
  GICXXPred_MI_Predicate_anonymous_34147,
  GICXXPred_MI_Predicate_anonymous_34152,
  GICXXPred_MI_Predicate_anonymous_34156,
  GICXXPred_MI_Predicate_anonymous_34210,
  GICXXPred_MI_Predicate_anonymous_34212,
  GICXXPred_MI_Predicate_anonymous_34250,
  GICXXPred_MI_Predicate_anonymous_34278,
  GICXXPred_MI_Predicate_anonymous_34280,
  GICXXPred_MI_Predicate_anonymous_34309,
  GICXXPred_MI_Predicate_anonymous_34311,
  GICXXPred_MI_Predicate_anonymous_34313,
  GICXXPred_MI_Predicate_anonymous_34315,
  GICXXPred_MI_Predicate_anonymous_34317,
  GICXXPred_MI_Predicate_bf16_fpround,
  GICXXPred_MI_Predicate_csh_mask_16,
  GICXXPred_MI_Predicate_csh_mask_32,
  GICXXPred_MI_Predicate_csh_mask_64,
  GICXXPred_MI_Predicate_fmaxnum_like_nnan,
  GICXXPred_MI_Predicate_fminnum_like_nnan,
  GICXXPred_MI_Predicate_is_canonicalized,
  GICXXPred_MI_Predicate_load_align_less_than_4_local,
  GICXXPred_MI_Predicate_load_align_less_than_4_local_m0,
  GICXXPred_MI_Predicate_shl1_add,
  GICXXPred_MI_Predicate_shl2_add,
  GICXXPred_MI_Predicate_shl3_add,
  GICXXPred_MI_Predicate_shl4_add,
  GICXXPred_MI_Predicate_shl_0_to_4,
  GICXXPred_MI_Predicate_smrd_extloadi8,
  GICXXPred_MI_Predicate_smrd_extloadi16,
  GICXXPred_MI_Predicate_smrd_load,
  GICXXPred_MI_Predicate_smrd_prefetch,
  GICXXPred_MI_Predicate_smrd_sextloadi8,
  GICXXPred_MI_Predicate_smrd_sextloadi16,
  GICXXPred_MI_Predicate_smrd_zextloadi8,
  GICXXPred_MI_Predicate_smrd_zextloadi16,
  GICXXPred_MI_Predicate_store_align_less_than_4_local,
  GICXXPred_MI_Predicate_store_align_less_than_4_local_m0,
};
bool AMDGPUInstructionSelector::testMIPredicate_MI(unsigned PredicateID, const MachineInstr & MI, const MatcherState &State) const {
  const MachineFunction &MF = *MI.getParent()->getParent();
  const MachineRegisterInfo &MRI = MF.getRegInfo();
  const auto &Operands = State.RecordedOperands;
  (void)Operands;
  (void)MRI;
  switch (PredicateID) {
  case GICXXPred_MI_Predicate_aligned_smrd_load: {
    
      auto &Ld = cast<GLoad>(MI);
      TypeSize Size = Ld.getMMO().getSize().getValue();
      return Size <= 4 || Ld.getMMO().getAlign().value() >= Size;
      
    llvm_unreachable("aligned_smrd_load should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_13376: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_13379: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_13380: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_13381: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_13382: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_13383: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_13386: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_13387: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_13388: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_13389: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_13390: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_13391: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_13392: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_13393: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_13394: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_13395: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_13396: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_13397: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_13398: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_13399: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_13400: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_13401: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_13402: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_13403: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_13404: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_13405: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_13406: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_13407: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_13408: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_13409: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_13410: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_13411: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_13412: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_13413: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_13414: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_13415: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_13416: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_13417: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_13418: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_13419: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_13420: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_13421: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_13422: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_13423: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_13424: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_13425: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_13426: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_13427: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_13434: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_13446: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_17888: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_18806: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_18808: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_19201: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_19203: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_19205: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_19207: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_19209: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_19213: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_19215: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_19217: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_19219: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_19221: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_19456: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_19458: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_19699: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_19709: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_19712: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_19818: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_20243: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_20243 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_20246: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_20246 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_20249: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_20249 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_20251: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_20251 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_20254: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_20254 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_20256: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_20256 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_20259: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_20259 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_20262: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_20262 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_20266: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_20266 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_20278: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_20278 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_20709: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_20709 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_20982: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_20985: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_20987: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_20989: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_20991: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_20993: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_20995: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_22685: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22687: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22691: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22693: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22695: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22697: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22701: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22703: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22705: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22707: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22709: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22711: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22713: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22715: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22719: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22721: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22723: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22725: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22729: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22731: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22735: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22737: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22739: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22741: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22745: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22747: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22749: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22751: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22753: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22755: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22757: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22759: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22763: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22765: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22767: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22769: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22773: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22775: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22777: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22779: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22781: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22783: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22787: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22789: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22791: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22793: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22795: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22797: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22801: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22803: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22807: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22809: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22811: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22813: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22833: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22835: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22869: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22871: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22891: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22893: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22931: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22933: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22937: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22939: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22941: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22943: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22945: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22947: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22949: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22951: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22955: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22957: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22959: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22961: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22965: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22967: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22969: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22971: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22973: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22975: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22979: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22981: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22983: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22985: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22987: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22989: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22991: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22993: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22995: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_22997: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_23001: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_23003: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_23005: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_23007: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_23009: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_23011: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_23013: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_23015: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_33573: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_33880: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_33882: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_33928: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_33941: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_33942: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_33945: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_33948: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_33951: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_33955: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_33958: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_33961: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_33963: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_33970: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_33973: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_33975: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_33983: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_33988: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_33992: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_33996: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_34144: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_34147: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_34152: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_34156: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_34210: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_34212: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_34250: {
    
        const SITargetLowering *TLI = static_cast<const SITargetLowering *>(
          MF.getSubtarget().getTargetLowering());
    
        return TLI->isCanonicalized(MI.getOperand(1).getReg(), MF) &&
          TLI->isCanonicalized(MI.getOperand(2).getReg(), MF);
      
    llvm_unreachable("anonymous_34250 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_34278: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_34280: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_34309: {
    
        const SITargetLowering *TLI = static_cast<const SITargetLowering *>(
          MF.getSubtarget().getTargetLowering());
    
        return TLI->isCanonicalized(MI.getOperand(1).getReg(), MF);
      
    llvm_unreachable("anonymous_34309 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_34311: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_34313: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_34315: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_34317: {
    return true;
  }
  case GICXXPred_MI_Predicate_bf16_fpround: {
    return false;
  }
  case GICXXPred_MI_Predicate_csh_mask_16: {
     return isUnneededShiftMask(MI, 4); 
  }
  case GICXXPred_MI_Predicate_csh_mask_32: {
     return isUnneededShiftMask(MI, 5); 
  }
  case GICXXPred_MI_Predicate_csh_mask_64: {
     return isUnneededShiftMask(MI, 6); 
  }
  case GICXXPred_MI_Predicate_fmaxnum_like_nnan: {
    
        return isKnownNeverNaN(MI.getOperand(0).getReg(), MRI);
      
  }
  case GICXXPred_MI_Predicate_fminnum_like_nnan: {
    
        return isKnownNeverNaN(MI.getOperand(0).getReg(), MRI);
      
  }
  case GICXXPred_MI_Predicate_is_canonicalized: {
    
        const SITargetLowering *TLI = static_cast<const SITargetLowering *>(
            MF.getSubtarget().getTargetLowering());
        const MachineOperand &Dst = MI.getOperand(0);
        assert(Dst.isDef());
        return TLI->isCanonicalized(Dst.getReg(), MF);
       
    llvm_unreachable("is_canonicalized should have returned");
  }
  case GICXXPred_MI_Predicate_load_align_less_than_4_local: {
    return (*MI.memoperands_begin())->getAlign() < 4;
  }
  case GICXXPred_MI_Predicate_load_align_less_than_4_local_m0: {
    return (*MI.memoperands_begin())->getAlign() < 4;
  }
  case GICXXPred_MI_Predicate_shl1_add: {
    return true;
  }
  case GICXXPred_MI_Predicate_shl2_add: {
    return true;
  }
  case GICXXPred_MI_Predicate_shl3_add: {
    return true;
  }
  case GICXXPred_MI_Predicate_shl4_add: {
    return true;
  }
  case GICXXPred_MI_Predicate_shl_0_to_4: {
    
        int64_t Imm = 0;
        if (!mi_match(MI.getOperand(2).getReg(), MRI, m_ICst(Imm)) &&
            !mi_match(MI.getOperand(2).getReg(), MRI, m_Copy(m_ICst(Imm))))
          return false;
        return (uint64_t)Imm <= 4;
      
    llvm_unreachable("shl_0_to_4 should have returned");
  }
  case GICXXPred_MI_Predicate_smrd_extloadi8: {
    
        if (!MI.hasOneMemOperand())
          return false;
        if (!isInstrUniform(MI))
          return false;
    
        // FIXME: We should probably be caching this.
        SmallVector<GEPInfo, 4> AddrInfo;
        getAddrModeInfo(MI, MRI, AddrInfo);
    
        if (hasVgprParts(AddrInfo))
          return false;
        return true;
      
    llvm_unreachable("smrd_extloadi8 should have returned");
  }
  case GICXXPred_MI_Predicate_smrd_extloadi16: {
    
        if (!MI.hasOneMemOperand())
          return false;
        if (!isInstrUniform(MI))
          return false;
    
        // FIXME: We should probably be caching this.
        SmallVector<GEPInfo, 4> AddrInfo;
        getAddrModeInfo(MI, MRI, AddrInfo);
    
        if (hasVgprParts(AddrInfo))
          return false;
        return true;
      
    llvm_unreachable("smrd_extloadi16 should have returned");
  }
  case GICXXPred_MI_Predicate_smrd_load: {
    
        if (!MI.hasOneMemOperand())
          return false;
        if (!isInstrUniform(MI))
          return false;
    
        // FIXME: We should probably be caching this.
        SmallVector<GEPInfo, 4> AddrInfo;
        getAddrModeInfo(MI, MRI, AddrInfo);
    
        if (hasVgprParts(AddrInfo))
          return false;
        return true;
      
    llvm_unreachable("smrd_load should have returned");
  }
  case GICXXPred_MI_Predicate_smrd_prefetch: {
    
        return isInstrUniform(MI);
      
  }
  case GICXXPred_MI_Predicate_smrd_sextloadi8: {
    
        if (!MI.hasOneMemOperand())
          return false;
        if (!isInstrUniform(MI))
          return false;
    
        // FIXME: We should probably be caching this.
        SmallVector<GEPInfo, 4> AddrInfo;
        getAddrModeInfo(MI, MRI, AddrInfo);
    
        if (hasVgprParts(AddrInfo))
          return false;
        return true;
      
    llvm_unreachable("smrd_sextloadi8 should have returned");
  }
  case GICXXPred_MI_Predicate_smrd_sextloadi16: {
    
        if (!MI.hasOneMemOperand())
          return false;
        if (!isInstrUniform(MI))
          return false;
    
        // FIXME: We should probably be caching this.
        SmallVector<GEPInfo, 4> AddrInfo;
        getAddrModeInfo(MI, MRI, AddrInfo);
    
        if (hasVgprParts(AddrInfo))
          return false;
        return true;
      
    llvm_unreachable("smrd_sextloadi16 should have returned");
  }
  case GICXXPred_MI_Predicate_smrd_zextloadi8: {
    
        if (!MI.hasOneMemOperand())
          return false;
        if (!isInstrUniform(MI))
          return false;
    
        // FIXME: We should probably be caching this.
        SmallVector<GEPInfo, 4> AddrInfo;
        getAddrModeInfo(MI, MRI, AddrInfo);
    
        if (hasVgprParts(AddrInfo))
          return false;
        return true;
      
    llvm_unreachable("smrd_zextloadi8 should have returned");
  }
  case GICXXPred_MI_Predicate_smrd_zextloadi16: {
    
        if (!MI.hasOneMemOperand())
          return false;
        if (!isInstrUniform(MI))
          return false;
    
        // FIXME: We should probably be caching this.
        SmallVector<GEPInfo, 4> AddrInfo;
        getAddrModeInfo(MI, MRI, AddrInfo);
    
        if (hasVgprParts(AddrInfo))
          return false;
        return true;
      
    llvm_unreachable("smrd_zextloadi16 should have returned");
  }
  case GICXXPred_MI_Predicate_store_align_less_than_4_local: {
    return (*MI.memoperands_begin())->getAlign() < 4;
  }
  case GICXXPred_MI_Predicate_store_align_less_than_4_local_m0: {
    return (*MI.memoperands_begin())->getAlign() < 4;
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GICXXPred_I64_Predicate_IMMZeroBasedBitfieldMask = GICXXPred_Invalid + 1,
  GICXXPred_I64_Predicate_MFMALdScaleModifierOp,
  GICXXPred_I64_Predicate_NegSubInlineConst32,
  GICXXPred_I64_Predicate_NegSubInlineIntConst16,
  GICXXPred_I64_Predicate_SIMM16bit,
  GICXXPred_I64_Predicate_ShiftAmt32Imm,
  GICXXPred_I64_Predicate_SupportedRoundMode,
  GICXXPred_I64_Predicate_i32imm_one,
  GICXXPred_I64_Predicate_i32imm_zero,
  GICXXPred_I64_Predicate_i64imm_32bit,
};
bool AMDGPUInstructionSelector::testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const {
  switch (PredicateID) {
  case GICXXPred_I64_Predicate_IMMZeroBasedBitfieldMask: {
    
      return isMask_32(Imm);
    
  }
  case GICXXPred_I64_Predicate_MFMALdScaleModifierOp: {
    
      return isUInt<2>(Imm);
    
  }
  case GICXXPred_I64_Predicate_NegSubInlineConst32: {
    
      return Imm < -16 && Imm >= -64;
    
  }
  case GICXXPred_I64_Predicate_NegSubInlineIntConst16: {
    
      return Imm < -16 && Imm >= -64;
    
  }
  case GICXXPred_I64_Predicate_SIMM16bit: {
    return isInt<16>(Imm) || isUInt<16>(Imm);
  }
  case GICXXPred_I64_Predicate_ShiftAmt32Imm: {
    
      return Imm < 32;
    
  }
  case GICXXPred_I64_Predicate_SupportedRoundMode: {
    
      return Imm == (int)RoundingMode::TowardZero ||
             Imm == (int)RoundingMode::NearestTiesToEven ||
             Imm == (int)RoundingMode::TowardPositive ||
             Imm == (int)RoundingMode::TowardNegative;
    
  }
  case GICXXPred_I64_Predicate_i32imm_one: {
    
      return Imm == 1;
    
  }
  case GICXXPred_I64_Predicate_i32imm_zero: {
    
      return Imm == 0;
    
  }
  case GICXXPred_I64_Predicate_i64imm_32bit: {
    
      return (Imm & 0xffffffffULL) == static_cast<uint64_t>(Imm);
    
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GICXXPred_APFloat_Predicate_InlineImmFP32 = GICXXPred_Invalid + 1,
  GICXXPred_APFloat_Predicate_InlineImmFP64,
  GICXXPred_APFloat_Predicate_fpimm_neg_pow2_prefer_ldexp_f64,
  GICXXPred_APFloat_Predicate_fpimm_pos_pow2_prefer_ldexp_f64,
};
bool AMDGPUInstructionSelector::testImmPredicate_APFloat(unsigned PredicateID, const APFloat & Imm) const {
  switch (PredicateID) {
  case GICXXPred_APFloat_Predicate_InlineImmFP32: {
    
      return isInlineImmediate(Imm);
    
  }
  case GICXXPred_APFloat_Predicate_InlineImmFP64: {
    
      return isInlineImmediate(Imm);
    
  }
  case GICXXPred_APFloat_Predicate_fpimm_neg_pow2_prefer_ldexp_f64: {
    
        if (!Imm.isNegative())
          return false;
        int Exp = Imm.getExactLog2Abs();
        // Prefer leaving the FP inline immediates as they are.
        // 0.5, 1.0, 2.0, 4.0
    
        // For f64 ldexp is always better than materializing a 64-bit
        // constant.
        return Exp != INT_MIN && (Exp < -1 || Exp > 2);
      
    llvm_unreachable("fpimm_neg_pow2_prefer_ldexp_f64 should have returned");
  }
  case GICXXPred_APFloat_Predicate_fpimm_pos_pow2_prefer_ldexp_f64: {
    
        if (Imm.isNegative())
          return false;
    
        int Exp = Imm.getExactLog2Abs();
        // Prefer leaving the FP inline immediates as they are.
        // 0.5, 1.0, 2.0, 4.0
    
        // For f64 ldexp is always better than materializing a 64-bit
        // constant.
        return Exp != INT_MIN && (Exp < -1 || Exp > 2);
      
    llvm_unreachable("fpimm_pos_pow2_prefer_ldexp_f64 should have returned");
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GICXXPred_APInt_Predicate_InlineImm64 = GICXXPred_Invalid + 1,
};
bool AMDGPUInstructionSelector::testImmPredicate_APInt(unsigned PredicateID, const APInt & Imm) const {
  switch (PredicateID) {
  case GICXXPred_APInt_Predicate_InlineImm64: {
    
      return isInlineImmediate(Imm);
    
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
bool AMDGPUInstructionSelector::testSimplePredicate(unsigned) const {
    llvm_unreachable("AMDGPUInstructionSelector does not support simple predicates!");
  return false;
}
// Custom renderers.
enum {
  GICR_Invalid,
  GICR_renderBitcastFPImm32,
  GICR_renderBitcastFPImm64,
  GICR_renderDstSelToOpSel3XFormXForm,
  GICR_renderDstSelToOpSelXForm,
  GICR_renderExtractCPol,
  GICR_renderExtractCpolSetGLC,
  GICR_renderExtractSWZ,
  GICR_renderFPPow2ToExponent,
  GICR_renderFrameIndex,
  GICR_renderNegateImm,
  GICR_renderOpSelTImm,
  GICR_renderPopcntImm,
  GICR_renderRoundMode,
  GICR_renderScaledMAIIntrinsicOperand,
  GICR_renderSrcAndDstSelToOpSelXForm_0_0,
  GICR_renderSrcAndDstSelToOpSelXForm_0_1,
  GICR_renderSrcAndDstSelToOpSelXForm_1_0,
  GICR_renderSrcAndDstSelToOpSelXForm_1_1,
  GICR_renderSrcAndDstSelToOpSelXForm_2_0,
  GICR_renderSrcSelToOpSelXForm,
  GICR_renderTruncTImm,
  GICR_renderZextBoolTImm,
};
AMDGPUInstructionSelector::CustomRendererFn
AMDGPUInstructionSelector::CustomRenderers[] = {
  nullptr, // GICR_Invalid
  &AMDGPUInstructionSelector::renderBitcastFPImm32,
  &AMDGPUInstructionSelector::renderBitcastFPImm64,
  &AMDGPUInstructionSelector::renderDstSelToOpSel3XFormXForm,
  &AMDGPUInstructionSelector::renderDstSelToOpSelXForm,
  &AMDGPUInstructionSelector::renderExtractCPol,
  &AMDGPUInstructionSelector::renderExtractCpolSetGLC,
  &AMDGPUInstructionSelector::renderExtractSWZ,
  &AMDGPUInstructionSelector::renderFPPow2ToExponent,
  &AMDGPUInstructionSelector::renderFrameIndex,
  &AMDGPUInstructionSelector::renderNegateImm,
  &AMDGPUInstructionSelector::renderOpSelTImm,
  &AMDGPUInstructionSelector::renderPopcntImm,
  &AMDGPUInstructionSelector::renderRoundMode,
  &AMDGPUInstructionSelector::renderScaledMAIIntrinsicOperand,
  &AMDGPUInstructionSelector::renderSrcAndDstSelToOpSelXForm_0_0,
  &AMDGPUInstructionSelector::renderSrcAndDstSelToOpSelXForm_0_1,
  &AMDGPUInstructionSelector::renderSrcAndDstSelToOpSelXForm_1_0,
  &AMDGPUInstructionSelector::renderSrcAndDstSelToOpSelXForm_1_1,
  &AMDGPUInstructionSelector::renderSrcAndDstSelToOpSelXForm_2_0,
  &AMDGPUInstructionSelector::renderSrcSelToOpSelXForm,
  &AMDGPUInstructionSelector::renderTruncTImm,
  &AMDGPUInstructionSelector::renderZextBoolTImm,
};

bool AMDGPUInstructionSelector::selectImpl(MachineInstr &I, CodeGenCoverage &CoverageInfo) const {
  const PredicateBitset AvailableFeatures = getAvailableFeatures();
  MachineIRBuilder B(I);
  State.MIs.clear();
  State.MIs.push_back(&I);

  if (executeMatchTable(*this, State, ExecInfo, B, getMatchTable(), TII, MF->getRegInfo(), TRI, RBI, AvailableFeatures, &CoverageInfo)) {
    return true;
  }

  return false;
}

bool AMDGPUInstructionSelector::runCustomAction(unsigned, const MatcherState&, NewMIVector &) const {
    llvm_unreachable("AMDGPUInstructionSelector does not support custom C++ actions!");
}
#if __BYTE_ORDER__ == __ORDER_LITTLE_ENDIAN__
#define GIMT_Encode2(Val) uint8_t(Val), uint8_t((uint16_t)Val >> 8)
#define GIMT_Encode4(Val) uint8_t(Val), uint8_t((uint32_t)Val >> 8), uint8_t((uint32_t)Val >> 16), uint8_t((uint32_t)Val >> 24)
#define GIMT_Encode8(Val) uint8_t(Val), uint8_t((uint64_t)Val >> 8), uint8_t((uint64_t)Val >> 16), uint8_t((uint64_t)Val >> 24),  uint8_t((uint64_t)Val >> 32), uint8_t((uint64_t)Val >> 40), uint8_t((uint64_t)Val >> 48), uint8_t((uint64_t)Val >> 56)
#else
#define GIMT_Encode2(Val) uint8_t((uint16_t)Val >> 8), uint8_t(Val)
#define GIMT_Encode4(Val) uint8_t((uint32_t)Val >> 24), uint8_t((uint32_t)Val >> 16), uint8_t((uint32_t)Val >> 8), uint8_t(Val)
#define GIMT_Encode8(Val) uint8_t((uint64_t)Val >> 56), uint8_t((uint64_t)Val >> 48), uint8_t((uint64_t)Val >> 40), uint8_t((uint64_t)Val >> 32),  uint8_t((uint64_t)Val >> 24), uint8_t((uint64_t)Val >> 16), uint8_t((uint64_t)Val >> 8), uint8_t(Val)
#endif
const uint8_t *AMDGPUInstructionSelector::getMatchTable() const {
  constexpr static uint8_t MatchTable0[] = {
    GIM_SwitchOpcode, /*MI*/0, /*[*/GIMT_Encode2(53), GIMT_Encode2(3713), /*)*//*default:*//*Label 167*/ GIMT_Encode4(759527),
    /*TargetOpcode::G_ADD*//*Label 0*/ GIMT_Encode4(14650),
    /*TargetOpcode::G_SUB*//*Label 1*/ GIMT_Encode4(37892),
    /*TargetOpcode::G_MUL*//*Label 2*/ GIMT_Encode4(38515), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_AND*//*Label 3*/ GIMT_Encode4(38861),
    /*TargetOpcode::G_OR*//*Label 4*/ GIMT_Encode4(40262),
    /*TargetOpcode::G_XOR*//*Label 5*/ GIMT_Encode4(55870), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FRAME_INDEX*//*Label 6*/ GIMT_Encode4(60562), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_BUILD_VECTOR*//*Label 7*/ GIMT_Encode4(60617), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_BITCAST*//*Label 8*/ GIMT_Encode4(63257), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_INTRINSIC_FPTRUNC_ROUND*//*Label 9*/ GIMT_Encode4(68854),
    /*TargetOpcode::G_INTRINSIC_TRUNC*//*Label 10*/ GIMT_Encode4(68946), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_INTRINSIC_ROUNDEVEN*//*Label 11*/ GIMT_Encode4(69274),
    /*TargetOpcode::G_READCYCLECOUNTER*//*Label 12*/ GIMT_Encode4(69602),
    /*TargetOpcode::G_READSTEADYCOUNTER*//*Label 13*/ GIMT_Encode4(69742),
    /*TargetOpcode::G_LOAD*//*Label 14*/ GIMT_Encode4(69800),
    /*TargetOpcode::G_SEXTLOAD*//*Label 15*/ GIMT_Encode4(135282),
    /*TargetOpcode::G_ZEXTLOAD*//*Label 16*/ GIMT_Encode4(141189), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_STORE*//*Label 17*/ GIMT_Encode4(147011), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_ATOMIC_CMPXCHG*//*Label 18*/ GIMT_Encode4(179058),
    /*TargetOpcode::G_ATOMICRMW_XCHG*//*Label 19*/ GIMT_Encode4(180184),
    /*TargetOpcode::G_ATOMICRMW_ADD*//*Label 20*/ GIMT_Encode4(182396),
    /*TargetOpcode::G_ATOMICRMW_SUB*//*Label 21*/ GIMT_Encode4(184908),
    /*TargetOpcode::G_ATOMICRMW_AND*//*Label 22*/ GIMT_Encode4(187420), GIMT_Encode4(0),
    /*TargetOpcode::G_ATOMICRMW_OR*//*Label 23*/ GIMT_Encode4(189932),
    /*TargetOpcode::G_ATOMICRMW_XOR*//*Label 24*/ GIMT_Encode4(192444),
    /*TargetOpcode::G_ATOMICRMW_MAX*//*Label 25*/ GIMT_Encode4(194956),
    /*TargetOpcode::G_ATOMICRMW_MIN*//*Label 26*/ GIMT_Encode4(197468),
    /*TargetOpcode::G_ATOMICRMW_UMAX*//*Label 27*/ GIMT_Encode4(199980),
    /*TargetOpcode::G_ATOMICRMW_UMIN*//*Label 28*/ GIMT_Encode4(202492),
    /*TargetOpcode::G_ATOMICRMW_FADD*//*Label 29*/ GIMT_Encode4(205004), GIMT_Encode4(0),
    /*TargetOpcode::G_ATOMICRMW_FMAX*//*Label 30*/ GIMT_Encode4(207215),
    /*TargetOpcode::G_ATOMICRMW_FMIN*//*Label 31*/ GIMT_Encode4(209861),
    /*TargetOpcode::G_ATOMICRMW_UINC_WRAP*//*Label 32*/ GIMT_Encode4(212507),
    /*TargetOpcode::G_ATOMICRMW_UDEC_WRAP*//*Label 33*/ GIMT_Encode4(215019), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FENCE*//*Label 34*/ GIMT_Encode4(217531),
    /*TargetOpcode::G_PREFETCH*//*Label 35*/ GIMT_Encode4(217550), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_INTRINSIC*//*Label 36*/ GIMT_Encode4(217986),
    /*TargetOpcode::G_INTRINSIC_W_SIDE_EFFECTS*//*Label 37*/ GIMT_Encode4(234893),
    /*TargetOpcode::G_INTRINSIC_CONVERGENT*//*Label 38*/ GIMT_Encode4(239604),
    /*TargetOpcode::G_INTRINSIC_CONVERGENT_W_SIDE_EFFECTS*//*Label 39*/ GIMT_Encode4(264572),
    /*TargetOpcode::G_ANYEXT*//*Label 40*/ GIMT_Encode4(265843),
    /*TargetOpcode::G_TRUNC*//*Label 41*/ GIMT_Encode4(266406),
    /*TargetOpcode::G_CONSTANT*//*Label 42*/ GIMT_Encode4(266646),
    /*TargetOpcode::G_FCONSTANT*//*Label 43*/ GIMT_Encode4(267372), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_SEXT*//*Label 44*/ GIMT_Encode4(267704), GIMT_Encode4(0),
    /*TargetOpcode::G_ZEXT*//*Label 45*/ GIMT_Encode4(268507),
    /*TargetOpcode::G_SHL*//*Label 46*/ GIMT_Encode4(271710),
    /*TargetOpcode::G_LSHR*//*Label 47*/ GIMT_Encode4(273246),
    /*TargetOpcode::G_ASHR*//*Label 48*/ GIMT_Encode4(274408), GIMT_Encode4(0),
    /*TargetOpcode::G_FSHR*//*Label 49*/ GIMT_Encode4(275570),
    /*TargetOpcode::G_ROTR*//*Label 50*/ GIMT_Encode4(275615), GIMT_Encode4(0),
    /*TargetOpcode::G_ICMP*//*Label 51*/ GIMT_Encode4(275647),
    /*TargetOpcode::G_FCMP*//*Label 52*/ GIMT_Encode4(277239), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_SELECT*//*Label 53*/ GIMT_Encode4(281402), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_UMULH*//*Label 54*/ GIMT_Encode4(281746),
    /*TargetOpcode::G_SMULH*//*Label 55*/ GIMT_Encode4(281855),
    /*TargetOpcode::G_UADDSAT*//*Label 56*/ GIMT_Encode4(281964),
    /*TargetOpcode::G_SADDSAT*//*Label 57*/ GIMT_Encode4(282352),
    /*TargetOpcode::G_USUBSAT*//*Label 58*/ GIMT_Encode4(282678),
    /*TargetOpcode::G_SSUBSAT*//*Label 59*/ GIMT_Encode4(283066), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FADD*//*Label 60*/ GIMT_Encode4(283392),
    /*TargetOpcode::G_FSUB*//*Label 61*/ GIMT_Encode4(284750),
    /*TargetOpcode::G_FMUL*//*Label 62*/ GIMT_Encode4(285114),
    /*TargetOpcode::G_FMA*//*Label 63*/ GIMT_Encode4(286500),
    /*TargetOpcode::G_FMAD*//*Label 64*/ GIMT_Encode4(288296), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FPOW*//*Label 65*/ GIMT_Encode4(289242), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FEXP2*//*Label 66*/ GIMT_Encode4(289360), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FLOG2*//*Label 67*/ GIMT_Encode4(289583), GIMT_Encode4(0),
    /*TargetOpcode::G_FLDEXP*//*Label 68*/ GIMT_Encode4(289806), GIMT_Encode4(0),
    /*TargetOpcode::G_FNEG*//*Label 69*/ GIMT_Encode4(290169),
    /*TargetOpcode::G_FPEXT*//*Label 70*/ GIMT_Encode4(292032),
    /*TargetOpcode::G_FPTRUNC*//*Label 71*/ GIMT_Encode4(292432),
    /*TargetOpcode::G_FPTOSI*//*Label 72*/ GIMT_Encode4(293368),
    /*TargetOpcode::G_FPTOUI*//*Label 73*/ GIMT_Encode4(294036),
    /*TargetOpcode::G_SITOFP*//*Label 74*/ GIMT_Encode4(294704),
    /*TargetOpcode::G_UITOFP*//*Label 75*/ GIMT_Encode4(295437), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FABS*//*Label 76*/ GIMT_Encode4(296170),
    /*TargetOpcode::G_FCOPYSIGN*//*Label 77*/ GIMT_Encode4(296971),
    /*TargetOpcode::G_IS_FPCLASS*//*Label 78*/ GIMT_Encode4(297334),
    /*TargetOpcode::G_FCANONICALIZE*//*Label 79*/ GIMT_Encode4(297606),
    /*TargetOpcode::G_FMINNUM*//*Label 80*/ GIMT_Encode4(299074),
    /*TargetOpcode::G_FMAXNUM*//*Label 81*/ GIMT_Encode4(369997),
    /*TargetOpcode::G_FMINNUM_IEEE*//*Label 82*/ GIMT_Encode4(440920),
    /*TargetOpcode::G_FMAXNUM_IEEE*//*Label 83*/ GIMT_Encode4(511843),
    /*TargetOpcode::G_FMINIMUM*//*Label 84*/ GIMT_Encode4(582766),
    /*TargetOpcode::G_FMAXIMUM*//*Label 85*/ GIMT_Encode4(584449), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_GET_FPMODE*//*Label 86*/ GIMT_Encode4(586132), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_PTR_ADD*//*Label 87*/ GIMT_Encode4(586256), GIMT_Encode4(0),
    /*TargetOpcode::G_SMIN*//*Label 88*/ GIMT_Encode4(586333),
    /*TargetOpcode::G_SMAX*//*Label 89*/ GIMT_Encode4(592697),
    /*TargetOpcode::G_UMIN*//*Label 90*/ GIMT_Encode4(599223),
    /*TargetOpcode::G_UMAX*//*Label 91*/ GIMT_Encode4(605587),
    /*TargetOpcode::G_ABS*//*Label 92*/ GIMT_Encode4(611951), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_BR*//*Label 93*/ GIMT_Encode4(612088), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_CTTZ_ZERO_UNDEF*//*Label 94*/ GIMT_Encode4(612122), GIMT_Encode4(0),
    /*TargetOpcode::G_CTLZ_ZERO_UNDEF*//*Label 95*/ GIMT_Encode4(612221),
    /*TargetOpcode::G_CTPOP*//*Label 96*/ GIMT_Encode4(612323),
    /*TargetOpcode::G_BSWAP*//*Label 97*/ GIMT_Encode4(612538),
    /*TargetOpcode::G_BITREVERSE*//*Label 98*/ GIMT_Encode4(613642),
    /*TargetOpcode::G_FCEIL*//*Label 99*/ GIMT_Encode4(613890), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FSQRT*//*Label 100*/ GIMT_Encode4(614218),
    /*TargetOpcode::G_FFLOOR*//*Label 101*/ GIMT_Encode4(614510), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_STRICT_FADD*//*Label 102*/ GIMT_Encode4(615024),
    /*TargetOpcode::G_STRICT_FSUB*//*Label 103*/ GIMT_Encode4(615986),
    /*TargetOpcode::G_STRICT_FMUL*//*Label 104*/ GIMT_Encode4(616350), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_STRICT_FMA*//*Label 105*/ GIMT_Encode4(617618), GIMT_Encode4(0),
    /*TargetOpcode::G_STRICT_FLDEXP*//*Label 106*/ GIMT_Encode4(618664), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*AMDGPU::G_AMDGPU_ATOMIC_CMPXCHG*//*Label 107*/ GIMT_Encode4(619027),
    /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_ADD*//*Label 108*/ GIMT_Encode4(621331),
    /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_AND*//*Label 109*/ GIMT_Encode4(623715),
    /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_CMPSWAP*//*Label 110*/ GIMT_Encode4(626099),
    /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_COND_SUB_U32*//*Label 111*/ GIMT_Encode4(630393),
    /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_DEC*//*Label 112*/ GIMT_Encode4(631010),
    /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_FADD*//*Label 113*/ GIMT_Encode4(633394),
    /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_FMAX*//*Label 114*/ GIMT_Encode4(637036),
    /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_FMIN*//*Label 115*/ GIMT_Encode4(640652),
    /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_INC*//*Label 116*/ GIMT_Encode4(644268),
    /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_OR*//*Label 117*/ GIMT_Encode4(646652),
    /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_SMAX*//*Label 118*/ GIMT_Encode4(649036),
    /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_SMIN*//*Label 119*/ GIMT_Encode4(651420),
    /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_SUB*//*Label 120*/ GIMT_Encode4(653804),
    /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_SWAP*//*Label 121*/ GIMT_Encode4(656188),
    /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_UMAX*//*Label 122*/ GIMT_Encode4(659732),
    /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_UMIN*//*Label 123*/ GIMT_Encode4(662116),
    /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_XOR*//*Label 124*/ GIMT_Encode4(664500),
    /*AMDGPU::G_AMDGPU_BUFFER_LOAD*//*Label 125*/ GIMT_Encode4(666884),
    /*AMDGPU::G_AMDGPU_BUFFER_LOAD_FORMAT*//*Label 126*/ GIMT_Encode4(682256),
    /*AMDGPU::G_AMDGPU_BUFFER_LOAD_FORMAT_D16*//*Label 127*/ GIMT_Encode4(687164),
    /*AMDGPU::G_AMDGPU_BUFFER_LOAD_FORMAT_TFE*//*Label 128*/ GIMT_Encode4(694909),
    /*AMDGPU::G_AMDGPU_BUFFER_LOAD_SBYTE*//*Label 129*/ GIMT_Encode4(697429),
    /*AMDGPU::G_AMDGPU_BUFFER_LOAD_SBYTE_TFE*//*Label 130*/ GIMT_Encode4(698035),
    /*AMDGPU::G_AMDGPU_BUFFER_LOAD_SSHORT*//*Label 131*/ GIMT_Encode4(698641),
    /*AMDGPU::G_AMDGPU_BUFFER_LOAD_SSHORT_TFE*//*Label 132*/ GIMT_Encode4(699247),
    /*AMDGPU::G_AMDGPU_BUFFER_LOAD_TFE*//*Label 133*/ GIMT_Encode4(699853),
    /*AMDGPU::G_AMDGPU_BUFFER_LOAD_UBYTE*//*Label 134*/ GIMT_Encode4(702373),
    /*AMDGPU::G_AMDGPU_BUFFER_LOAD_UBYTE_TFE*//*Label 135*/ GIMT_Encode4(702979),
    /*AMDGPU::G_AMDGPU_BUFFER_LOAD_USHORT*//*Label 136*/ GIMT_Encode4(703585),
    /*AMDGPU::G_AMDGPU_BUFFER_LOAD_USHORT_TFE*//*Label 137*/ GIMT_Encode4(704191),
    /*AMDGPU::G_AMDGPU_BUFFER_STORE*//*Label 138*/ GIMT_Encode4(704797),
    /*AMDGPU::G_AMDGPU_BUFFER_STORE_BYTE*//*Label 139*/ GIMT_Encode4(720105),
    /*AMDGPU::G_AMDGPU_BUFFER_STORE_FORMAT*//*Label 140*/ GIMT_Encode4(720707),
    /*AMDGPU::G_AMDGPU_BUFFER_STORE_FORMAT_D16*//*Label 141*/ GIMT_Encode4(726195),
    /*AMDGPU::G_AMDGPU_BUFFER_STORE_SHORT*//*Label 142*/ GIMT_Encode4(732460),
    /*AMDGPU::G_AMDGPU_CLAMP*//*Label 143*/ GIMT_Encode4(733062), GIMT_Encode4(0), GIMT_Encode4(0),
    /*AMDGPU::G_AMDGPU_CVT_F32_UBYTE0*//*Label 144*/ GIMT_Encode4(734001),
    /*AMDGPU::G_AMDGPU_CVT_F32_UBYTE1*//*Label 145*/ GIMT_Encode4(734046),
    /*AMDGPU::G_AMDGPU_CVT_F32_UBYTE2*//*Label 146*/ GIMT_Encode4(734091),
    /*AMDGPU::G_AMDGPU_CVT_F32_UBYTE3*//*Label 147*/ GIMT_Encode4(734136),
    /*AMDGPU::G_AMDGPU_CVT_PK_I16_I32*//*Label 148*/ GIMT_Encode4(734181),
    /*AMDGPU::G_AMDGPU_FFBH_U32*//*Label 149*/ GIMT_Encode4(734211),
    /*AMDGPU::G_AMDGPU_FFBL_B32*//*Label 150*/ GIMT_Encode4(734313),
    /*AMDGPU::G_AMDGPU_FMAX_LEGACY*//*Label 151*/ GIMT_Encode4(734412),
    /*AMDGPU::G_AMDGPU_FMED3*//*Label 152*/ GIMT_Encode4(734485),
    /*AMDGPU::G_AMDGPU_FMIN_LEGACY*//*Label 153*/ GIMT_Encode4(734845), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*AMDGPU::G_AMDGPU_RCP_IFLAG*//*Label 154*/ GIMT_Encode4(734918), GIMT_Encode4(0),
    /*AMDGPU::G_AMDGPU_SMED3*//*Label 155*/ GIMT_Encode4(734968),
    /*AMDGPU::G_AMDGPU_S_BUFFER_LOAD*//*Label 156*/ GIMT_Encode4(735274),
    /*AMDGPU::G_AMDGPU_S_BUFFER_LOAD_SBYTE*//*Label 157*/ GIMT_Encode4(737576),
    /*AMDGPU::G_AMDGPU_S_BUFFER_LOAD_SSHORT*//*Label 158*/ GIMT_Encode4(737714),
    /*AMDGPU::G_AMDGPU_S_BUFFER_LOAD_UBYTE*//*Label 159*/ GIMT_Encode4(737852),
    /*AMDGPU::G_AMDGPU_S_BUFFER_LOAD_USHORT*//*Label 160*/ GIMT_Encode4(737990),
    /*AMDGPU::G_AMDGPU_S_BUFFER_PREFETCH*//*Label 161*/ GIMT_Encode4(738128), GIMT_Encode4(0), GIMT_Encode4(0),
    /*AMDGPU::G_AMDGPU_TBUFFER_LOAD_FORMAT*//*Label 162*/ GIMT_Encode4(738235),
    /*AMDGPU::G_AMDGPU_TBUFFER_LOAD_FORMAT_D16*//*Label 163*/ GIMT_Encode4(743719),
    /*AMDGPU::G_AMDGPU_TBUFFER_STORE_FORMAT*//*Label 164*/ GIMT_Encode4(749148),
    /*AMDGPU::G_AMDGPU_TBUFFER_STORE_FORMAT_D16*//*Label 165*/ GIMT_Encode4(754616),
    /*AMDGPU::G_AMDGPU_UMED3*//*Label 166*/ GIMT_Encode4(759221),
    // Label 0: @14650
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(7), GIMT_Encode2(12), /*)*//*default:*//*Label 173*/ GIMT_Encode4(37891),
    /*GILLT_s1*//*Label 168*/ GIMT_Encode4(14681),
    /*GILLT_s16*//*Label 169*/ GIMT_Encode4(14800),
    /*GILLT_s32*//*Label 170*/ GIMT_Encode4(15791),
    /*GILLT_s64*//*Label 171*/ GIMT_Encode4(37150),
    /*GILLT_v2s16*//*Label 172*/ GIMT_Encode4(37621),
    // Label 168: @14681
    GIM_Try, /*On fail goto*//*Label 174*/ GIMT_Encode4(14799),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s1,
      GIM_Try, /*On fail goto*//*Label 175*/ GIMT_Encode4(14720), // Rule ID 7211 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isWave64),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (add:{ *:[i1] } i1:{ *:[i1] }:$src0, -1:{ *:[i1] })  =>  (S_NOT_B64:{ *:[i1] }:{ *:[i1] } ?:{ *:[i1] }:$src0)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_NOT_B64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 7211,
        GIR_EraseRootFromParent_Done,
      // Label 175: @14720
      GIM_Try, /*On fail goto*//*Label 176*/ GIMT_Encode4(14748), // Rule ID 7218 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isWave32),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (add:{ *:[i1] } i1:{ *:[i1] }:$src0, -1:{ *:[i1] })  =>  (S_NOT_B32:{ *:[i1] }:{ *:[i1] } ?:{ *:[i1] }:$src0)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_NOT_B32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 7218,
        GIR_EraseRootFromParent_Done,
      // Label 176: @14748
      GIM_Try, /*On fail goto*//*Label 177*/ GIMT_Encode4(14773), // Rule ID 7209 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isWave64),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
        // (add:{ *:[i1] } i1:{ *:[i1] }:$src0, i1:{ *:[i1] }:$src1)  =>  (S_XOR_B64:{ *:[i1] }:{ *:[i1] } ?:{ *:[i1] }:$src0, ?:{ *:[i1] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_XOR_B64),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 7209,
        GIR_Done,
      // Label 177: @14773
      GIM_Try, /*On fail goto*//*Label 178*/ GIMT_Encode4(14798), // Rule ID 7216 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isWave32),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        // (add:{ *:[i1] } i1:{ *:[i1] }:$src0, i1:{ *:[i1] }:$src1)  =>  (S_XOR_B32:{ *:[i1] }:{ *:[i1] } ?:{ *:[i1] }:$src0, ?:{ *:[i1] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_XOR_B32),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 7216,
        GIR_Done,
      // Label 178: @14798
      GIM_Reject,
    // Label 174: @14799
    GIM_Reject,
    // Label 169: @14800
    GIM_Try, /*On fail goto*//*Label 179*/ GIMT_Encode4(15790),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s16,
      GIM_Try, /*On fail goto*//*Label 180*/ GIMT_Encode4(14863), // Rule ID 6827 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_TRUNC),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CTPOP),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckCxxInsnPredicate, /*MI*/2, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_33573),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i16] } (trunc:{ *:[i16] } (ctpop:{ *:[i32] } i32:{ *:[i32] }:$popcnt)<<P:Predicate_anonymous_33573>>), i16:{ *:[i16] }:$val)  =>  (V_BCNT_U32_B32_e64:{ *:[i16] } ?:{ *:[i32] }:$popcnt, ?:{ *:[i16] }:$val)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BCNT_U32_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // popcnt
        GIR_RootToRootCopy, /*OpIdx*/2, // val
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 6827,
        GIR_EraseRootFromParent_Done,
      // Label 180: @14863
      GIM_Try, /*On fail goto*//*Label 181*/ GIMT_Encode4(14915), // Rule ID 10885 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_TRUNC),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CTPOP),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckCxxInsnPredicate, /*MI*/2, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_33573),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i16] } i16:{ *:[i16] }:$val, (trunc:{ *:[i16] } (ctpop:{ *:[i32] } i32:{ *:[i32] }:$popcnt)<<P:Predicate_anonymous_33573>>))  =>  (V_BCNT_U32_B32_e64:{ *:[i16] } ?:{ *:[i32] }:$popcnt, ?:{ *:[i16] }:$val)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BCNT_U32_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // popcnt
        GIR_RootToRootCopy, /*OpIdx*/1, // val
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 10885,
        GIR_EraseRootFromParent_Done,
      // Label 181: @14915
      GIM_Try, /*On fail goto*//*Label 182*/ GIMT_Encode4(14958), // Rule ID 2430 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_Has16BitInsts_isGFX8GFX9),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_NegSubInlineIntConst16),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i16] } i16:{ *:[i16] }:$src0, (imm:{ *:[i16] })<<P:Predicate_NegSubInlineIntConst16>><<X:NegateImm>>:$src1)  =>  (V_SUB_U16_e64:{ *:[i16] } VSrc_b16:{ *:[i16] }:$src0, (NegateImm:{ *:[i16 i32 bf16 f16 f32 v2i16 v2f16 v2bf16] } (imm:{ *:[i16] })<<P:Predicate_NegSubInlineIntConst16>>:$src1))
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SUB_U16_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderNegateImm), // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2430,
        GIR_EraseRootFromParent_Done,
      // Label 182: @14958
      GIM_Try, /*On fail goto*//*Label 183*/ GIMT_Encode4(15010), // Rule ID 2564 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotHasTrue16BitInsts_isGFX10Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_NegSubInlineIntConst16),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i16] } i16:{ *:[i16] }:$src0, (imm:{ *:[i16] })<<P:Predicate_NegSubInlineIntConst16>><<X:NegateImm>>:$src1)  =>  (V_SUB_NC_U16_e64:{ *:[i16] } 0:{ *:[i32] }, VSrc_b16:{ *:[i16] }:$src0, 0:{ *:[i32] }, (NegateImm:{ *:[i16 i32 bf16 f16 f32 v2i16 v2f16 v2bf16] } (imm:{ *:[i16] })<<P:Predicate_NegSubInlineIntConst16>>:$src1), 0:{ *:[i1] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SUB_NC_U16_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderNegateImm), // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2564,
        GIR_EraseRootFromParent_Done,
      // Label 183: @15010
      GIM_Try, /*On fail goto*//*Label 184*/ GIMT_Encode4(15062), // Rule ID 2567 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseRealTrue16Insts),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_16RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_NegSubInlineIntConst16),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i16] } i16:{ *:[i16] }:$src0, (imm:{ *:[i16] })<<P:Predicate_NegSubInlineIntConst16>><<X:NegateImm>>:$src1)  =>  (V_SUB_NC_U16_t16_e64:{ *:[i16] } 0:{ *:[i32] }, VSrc_b16:{ *:[i16] }:$src0, 0:{ *:[i32] }, (NegateImm:{ *:[i16 bf16 f16] } (imm:{ *:[i16] })<<P:Predicate_NegSubInlineIntConst16>>:$src1), 0:{ *:[i1] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SUB_NC_U16_t16_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderNegateImm), // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2567,
        GIR_EraseRootFromParent_Done,
      // Label 184: @15062
      GIM_Try, /*On fail goto*//*Label 185*/ GIMT_Encode4(15114), // Rule ID 2570 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseFakeTrue16Insts),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_NegSubInlineIntConst16),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i16] } i16:{ *:[i16] }:$src0, (imm:{ *:[i16] })<<P:Predicate_NegSubInlineIntConst16>><<X:NegateImm>>:$src1)  =>  (V_SUB_NC_U16_fake16_e64:{ *:[i16] } 0:{ *:[i32] }, VSrc_b16:{ *:[i16] }:$src0, 0:{ *:[i32] }, (NegateImm:{ *:[i16 i32 bf16 f16 f32 v2i16 v2f16 v2bf16] } (imm:{ *:[i16] })<<P:Predicate_NegSubInlineIntConst16>>:$src1), 0:{ *:[i1] }, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SUB_NC_U16_fake16_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderNegateImm), // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2570,
        GIR_EraseRootFromParent_Done,
      // Label 185: @15114
      GIM_Try, /*On fail goto*//*Label 186*/ GIMT_Encode4(15164), // Rule ID 2468 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_Has16BitInsts_isGFX6GFX7GFX8GFX9),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i16] } (mul:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1), i16:{ *:[i16] }:$src2)  =>  (V_MAD_U16_e64:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1, i16:{ *:[i16] }:$src2, 0:{ *:[i1] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U16_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2468,
        GIR_EraseRootFromParent_Done,
      // Label 186: @15164
      GIM_Try, /*On fail goto*//*Label 187*/ GIMT_Encode4(15226), // Rule ID 2469 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseRealTrue16Insts),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_16RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i16] } (mul:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1), i16:{ *:[i16] }:$src2)  =>  (V_MAD_U16_gfx9_t16_e64:{ *:[i16] } 0:{ *:[i32] }, ?:{ *:[i16] }:$src0, 0:{ *:[i32] }, ?:{ *:[i16] }:$src1, 0:{ *:[i32] }, ?:{ *:[i16] }:$src2, 0:{ *:[i1] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U16_gfx9_t16_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2469,
        GIR_EraseRootFromParent_Done,
      // Label 187: @15226
      GIM_Try, /*On fail goto*//*Label 188*/ GIMT_Encode4(15288), // Rule ID 2470 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseFakeTrue16Insts),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i16] } (mul:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1), i16:{ *:[i16] }:$src2)  =>  (V_MAD_U16_gfx9_fake16_e64:{ *:[i16] } 0:{ *:[i32] }, ?:{ *:[i16] }:$src0, 0:{ *:[i32] }, ?:{ *:[i16] }:$src1, 0:{ *:[i32] }, ?:{ *:[i16] }:$src2, 0:{ *:[i1] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U16_gfx9_fake16_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2470,
        GIR_EraseRootFromParent_Done,
      // Label 188: @15288
      GIM_Try, /*On fail goto*//*Label 189*/ GIMT_Encode4(15350), // Rule ID 2471 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_Has16BitInsts_NotHasTrue16BitInsts_isGFX10Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i16] } (mul:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1), i16:{ *:[i16] }:$src2)  =>  (V_MAD_U16_gfx9_e64:{ *:[i16] } 0:{ *:[i32] }, ?:{ *:[i16] }:$src0, 0:{ *:[i32] }, ?:{ *:[i16] }:$src1, 0:{ *:[i32] }, ?:{ *:[i16] }:$src2, 0:{ *:[i1] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U16_gfx9_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2471,
        GIR_EraseRootFromParent_Done,
      // Label 189: @15350
      GIM_Try, /*On fail goto*//*Label 190*/ GIMT_Encode4(15400), // Rule ID 8221 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_Has16BitInsts_isGFX6GFX7GFX8GFX9),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i16] } i16:{ *:[i16] }:$src2, (mul:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1))  =>  (V_MAD_U16_e64:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1, i16:{ *:[i16] }:$src2, 0:{ *:[i1] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U16_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/1, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8221,
        GIR_EraseRootFromParent_Done,
      // Label 190: @15400
      GIM_Try, /*On fail goto*//*Label 191*/ GIMT_Encode4(15462), // Rule ID 8222 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseRealTrue16Insts),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_16RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i16] } i16:{ *:[i16] }:$src2, (mul:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1))  =>  (V_MAD_U16_gfx9_t16_e64:{ *:[i16] } 0:{ *:[i32] }, ?:{ *:[i16] }:$src0, 0:{ *:[i32] }, ?:{ *:[i16] }:$src1, 0:{ *:[i32] }, ?:{ *:[i16] }:$src2, 0:{ *:[i1] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U16_gfx9_t16_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8222,
        GIR_EraseRootFromParent_Done,
      // Label 191: @15462
      GIM_Try, /*On fail goto*//*Label 192*/ GIMT_Encode4(15524), // Rule ID 8223 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseFakeTrue16Insts),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i16] } i16:{ *:[i16] }:$src2, (mul:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1))  =>  (V_MAD_U16_gfx9_fake16_e64:{ *:[i16] } 0:{ *:[i32] }, ?:{ *:[i16] }:$src0, 0:{ *:[i32] }, ?:{ *:[i16] }:$src1, 0:{ *:[i32] }, ?:{ *:[i16] }:$src2, 0:{ *:[i1] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U16_gfx9_fake16_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8223,
        GIR_EraseRootFromParent_Done,
      // Label 192: @15524
      GIM_Try, /*On fail goto*//*Label 193*/ GIMT_Encode4(15586), // Rule ID 8224 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_Has16BitInsts_NotHasTrue16BitInsts_isGFX10Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i16] } i16:{ *:[i16] }:$src2, (mul:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1))  =>  (V_MAD_U16_gfx9_e64:{ *:[i16] } 0:{ *:[i32] }, ?:{ *:[i16] }:$src0, 0:{ *:[i32] }, ?:{ *:[i16] }:$src1, 0:{ *:[i32] }, ?:{ *:[i16] }:$src2, 0:{ *:[i1] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U16_gfx9_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootToRootCopy, /*OpIdx*/1, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8224,
        GIR_EraseRootFromParent_Done,
      // Label 193: @15586
      GIM_Try, /*On fail goto*//*Label 194*/ GIMT_Encode4(15645), // Rule ID 1066 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotHasTrue16BitInsts_isGFX10Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3opselmods),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3opselmods),
        // (add:{ *:[i16] } (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers))  =>  (V_ADD_NC_U16_e64:{ *:[i16] } i32:{ *:[i32] }:$src0_modifiers, i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, i16:{ *:[i16] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_ADD_NC_U16_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1066,
        GIR_EraseRootFromParent_Done,
      // Label 194: @15645
      GIM_Try, /*On fail goto*//*Label 195*/ GIMT_Encode4(15704), // Rule ID 1067 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseRealTrue16Insts_isGFX10Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_16RegClassID),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3opselmods),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3opselmods),
        // (add:{ *:[i16] } (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers))  =>  (V_ADD_NC_U16_t16_e64:{ *:[i16] } i32:{ *:[i32] }:$src0_modifiers, i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, i16:{ *:[i16] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_ADD_NC_U16_t16_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1067,
        GIR_EraseRootFromParent_Done,
      // Label 195: @15704
      GIM_Try, /*On fail goto*//*Label 196*/ GIMT_Encode4(15763), // Rule ID 1068 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseFakeTrue16Insts_isGFX10Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3opselmods),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3opselmods),
        // (add:{ *:[i16] } (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers))  =>  (V_ADD_NC_U16_fake16_e64:{ *:[i16] } i32:{ *:[i32] }:$src0_modifiers, i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, i16:{ *:[i16] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_ADD_NC_U16_fake16_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1068,
        GIR_EraseRootFromParent_Done,
      // Label 196: @15763
      GIM_Try, /*On fail goto*//*Label 197*/ GIMT_Encode4(15789), // Rule ID 910 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX8GFX9),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // (add:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_ADD_U16_e64:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_ADD_U16_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 910,
        GIR_EraseRootFromParent_Done,
      // Label 197: @15789
      GIM_Reject,
    // Label 179: @15790
    GIM_Reject,
    // Label 170: @15791
    GIM_Try, /*On fail goto*//*Label 198*/ GIMT_Encode4(37149),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 199*/ GIMT_Encode4(16301), // Rule ID 8330 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
        GIM_CheckHasOneUse, /*MI*/0,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/5,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/1, // MIs[7]
        GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[7] src0
        GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 16,
        GIM_CheckConstantInt, /*MI*/6, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/8, /*MI*/5, /*OpIdx*/3, // MIs[8]
        GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
        GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[9] src1
        GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/9, /*Op*/2, 16,
        GIM_CheckConstantInt, /*MI*/8, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/10, /*MI*/4, /*OpIdx*/2, // MIs[10]
        GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/10, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/10,
        GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/1, // MIs[11]
        GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/11, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/11, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/11, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/11,
        GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/2, // MIs[12]
        GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/12, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/1, // MIs[13]
        GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[13] src0
        GIM_CheckIsSameOperand, /*MI*/13, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/13, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/12, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/14, /*MI*/11, /*OpIdx*/3, // MIs[14]
        GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/14, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/15, /*MI*/14, /*OpIdx*/1, // MIs[15]
        GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[15] src1
        GIM_CheckIsSameOperand, /*MI*/15, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/15, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/14, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/16, /*MI*/10, /*OpIdx*/2, // MIs[16]
        GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/16,
        GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/1, // MIs[17]
        GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/17,
        GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
        GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[18] src0
        GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckConstantInt, /*MI*/18, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
        GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[19] src1
        GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckConstantInt, /*MI*/19, /*Op*/2, GIMT_Encode8(255),
        GIM_CheckIsSafeToFold, /*NumInsns*/19,
        // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3059:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3059:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3059:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3059:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/16, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8330,
        GIR_EraseRootFromParent_Done,
      // Label 199: @16301
      GIM_Try, /*On fail goto*//*Label 200*/ GIMT_Encode4(16800), // Rule ID 8329 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
        GIM_CheckHasOneUse, /*MI*/0,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/5,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/1, // MIs[7]
        GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[7] src0
        GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 16,
        GIM_CheckConstantInt, /*MI*/6, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/8, /*MI*/5, /*OpIdx*/3, // MIs[8]
        GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
        GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[9] src1
        GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/9, /*Op*/2, 16,
        GIM_CheckConstantInt, /*MI*/8, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/10, /*MI*/4, /*OpIdx*/2, // MIs[10]
        GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/10, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/10,
        GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/1, // MIs[11]
        GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/11, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/11, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/11, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/11,
        GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/2, // MIs[12]
        GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/12, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/1, // MIs[13]
        GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[13] src0
        GIM_CheckIsSameOperand, /*MI*/13, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/13, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/12, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/14, /*MI*/11, /*OpIdx*/3, // MIs[14]
        GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/14, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/15, /*MI*/14, /*OpIdx*/1, // MIs[15]
        GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[15] src1
        GIM_CheckIsSameOperand, /*MI*/15, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/15, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/14, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/16, /*MI*/10, /*OpIdx*/2, // MIs[16]
        GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/16,
        GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/2, // MIs[17]
        GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/17,
        GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
        GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[18] src0
        GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckConstantInt, /*MI*/18, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
        GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[19] src1
        GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckConstantInt, /*MI*/19, /*Op*/2, GIMT_Encode8(255),
        GIM_CheckIsSafeToFold, /*NumInsns*/19,
        // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3059:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3059:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3059:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3059:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/16, /*OpIdx*/1, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8329,
        GIR_EraseRootFromParent_Done,
      // Label 200: @16800
      GIM_Try, /*On fail goto*//*Label 201*/ GIMT_Encode4(17299), // Rule ID 8328 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
        GIM_CheckHasOneUse, /*MI*/0,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/5,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/1, // MIs[7]
        GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[7] src0
        GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 16,
        GIM_CheckConstantInt, /*MI*/6, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/8, /*MI*/5, /*OpIdx*/3, // MIs[8]
        GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
        GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[9] src1
        GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/9, /*Op*/2, 16,
        GIM_CheckConstantInt, /*MI*/8, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/10, /*MI*/4, /*OpIdx*/2, // MIs[10]
        GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/10, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/10,
        GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/1, // MIs[11]
        GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/11,
        GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/1, // MIs[12]
        GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/12,
        GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
        GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[13] src0
        GIM_CheckIsSameOperand, /*MI*/13, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckConstantInt, /*MI*/13, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/14, /*MI*/12, /*OpIdx*/3, // MIs[14]
        GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[14] src1
        GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckConstantInt, /*MI*/14, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/15, /*MI*/10, /*OpIdx*/2, // MIs[15]
        GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/15, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/15, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/15, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/15,
        GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/2, // MIs[16]
        GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/1, // MIs[17]
        GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[17] src0
        GIM_CheckIsSameOperand, /*MI*/17, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/17, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/16, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/18, /*MI*/15, /*OpIdx*/3, // MIs[18]
        GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/18, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/19, /*MI*/18, /*OpIdx*/1, // MIs[19]
        GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[19] src1
        GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/18, /*Op*/2, GIMT_Encode8(255),
        GIM_CheckIsSafeToFold, /*NumInsns*/19,
        // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3059:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3059:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3059:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3059:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/11, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8328,
        GIR_EraseRootFromParent_Done,
      // Label 201: @17299
      GIM_Try, /*On fail goto*//*Label 202*/ GIMT_Encode4(17798), // Rule ID 8327 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
        GIM_CheckHasOneUse, /*MI*/0,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/5,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/1, // MIs[7]
        GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[7] src0
        GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 16,
        GIM_CheckConstantInt, /*MI*/6, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/8, /*MI*/5, /*OpIdx*/3, // MIs[8]
        GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
        GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[9] src1
        GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/9, /*Op*/2, 16,
        GIM_CheckConstantInt, /*MI*/8, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/10, /*MI*/4, /*OpIdx*/2, // MIs[10]
        GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/10, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/10,
        GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/1, // MIs[11]
        GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/11,
        GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/2, // MIs[12]
        GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/12,
        GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
        GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[13] src0
        GIM_CheckIsSameOperand, /*MI*/13, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckConstantInt, /*MI*/13, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/14, /*MI*/12, /*OpIdx*/3, // MIs[14]
        GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[14] src1
        GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckConstantInt, /*MI*/14, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/15, /*MI*/10, /*OpIdx*/2, // MIs[15]
        GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/15, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/15, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/15, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/15,
        GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/2, // MIs[16]
        GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/1, // MIs[17]
        GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[17] src0
        GIM_CheckIsSameOperand, /*MI*/17, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/17, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/16, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/18, /*MI*/15, /*OpIdx*/3, // MIs[18]
        GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/18, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/19, /*MI*/18, /*OpIdx*/1, // MIs[19]
        GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[19] src1
        GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/18, /*Op*/2, GIMT_Encode8(255),
        GIM_CheckIsSafeToFold, /*NumInsns*/19,
        // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3059:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3059:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3059:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3059:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/11, /*OpIdx*/1, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8327,
        GIR_EraseRootFromParent_Done,
      // Label 202: @17798
      GIM_Try, /*On fail goto*//*Label 203*/ GIMT_Encode4(18297), // Rule ID 8326 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
        GIM_CheckHasOneUse, /*MI*/0,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/5,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/6, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/6, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/6, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/6,
        GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/2, // MIs[7]
        GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/1, // MIs[8]
        GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[8] src0
        GIM_CheckIsSameOperand, /*MI*/8, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/8, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/7, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/9, /*MI*/6, /*OpIdx*/3, // MIs[9]
        GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/9, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/1, // MIs[10]
        GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[10] src1
        GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/10, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/9, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/11, /*MI*/5, /*OpIdx*/2, // MIs[11]
        GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/11,
        GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/1, // MIs[12]
        GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/12,
        GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
        GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[13] src0
        GIM_CheckIsSameOperand, /*MI*/13, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckConstantInt, /*MI*/13, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/14, /*MI*/12, /*OpIdx*/3, // MIs[14]
        GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[14] src1
        GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckConstantInt, /*MI*/14, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/15, /*MI*/4, /*OpIdx*/2, // MIs[15]
        GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/15, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/15, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/15, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/15,
        GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/2, // MIs[16]
        GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/1, // MIs[17]
        GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[17] src0
        GIM_CheckIsSameOperand, /*MI*/17, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/17, /*Op*/2, 16,
        GIM_CheckConstantInt, /*MI*/16, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/18, /*MI*/15, /*OpIdx*/3, // MIs[18]
        GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/18, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/19, /*MI*/18, /*OpIdx*/1, // MIs[19]
        GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[19] src1
        GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 16,
        GIM_CheckConstantInt, /*MI*/18, /*Op*/2, GIMT_Encode8(255),
        GIM_CheckIsSafeToFold, /*NumInsns*/19,
        // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3059:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3059:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3059:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3059:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/11, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8326,
        GIR_EraseRootFromParent_Done,
      // Label 203: @18297
      GIM_Try, /*On fail goto*//*Label 204*/ GIMT_Encode4(18796), // Rule ID 8325 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
        GIM_CheckHasOneUse, /*MI*/0,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/5,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/6, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/6, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/6, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/6,
        GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/2, // MIs[7]
        GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/1, // MIs[8]
        GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[8] src0
        GIM_CheckIsSameOperand, /*MI*/8, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/8, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/7, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/9, /*MI*/6, /*OpIdx*/3, // MIs[9]
        GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/9, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/1, // MIs[10]
        GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[10] src1
        GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/10, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/9, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/11, /*MI*/5, /*OpIdx*/2, // MIs[11]
        GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/11,
        GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/2, // MIs[12]
        GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/12,
        GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
        GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[13] src0
        GIM_CheckIsSameOperand, /*MI*/13, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckConstantInt, /*MI*/13, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/14, /*MI*/12, /*OpIdx*/3, // MIs[14]
        GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[14] src1
        GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckConstantInt, /*MI*/14, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/15, /*MI*/4, /*OpIdx*/2, // MIs[15]
        GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/15, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/15, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/15, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/15,
        GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/2, // MIs[16]
        GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/1, // MIs[17]
        GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[17] src0
        GIM_CheckIsSameOperand, /*MI*/17, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/17, /*Op*/2, 16,
        GIM_CheckConstantInt, /*MI*/16, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/18, /*MI*/15, /*OpIdx*/3, // MIs[18]
        GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/18, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/19, /*MI*/18, /*OpIdx*/1, // MIs[19]
        GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[19] src1
        GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 16,
        GIM_CheckConstantInt, /*MI*/18, /*Op*/2, GIMT_Encode8(255),
        GIM_CheckIsSafeToFold, /*NumInsns*/19,
        // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3059:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3059:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3059:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3059:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/11, /*OpIdx*/1, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8325,
        GIR_EraseRootFromParent_Done,
      // Label 204: @18796
      GIM_Try, /*On fail goto*//*Label 205*/ GIMT_Encode4(19295), // Rule ID 8324 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
        GIM_CheckHasOneUse, /*MI*/0,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/5,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/6,
        GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/1, // MIs[7]
        GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/7, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/7, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/7, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/7,
        GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/2, // MIs[8]
        GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[8] src0
        GIM_CheckIsSameOperand, /*MI*/8, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckConstantInt, /*MI*/8, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/9, /*MI*/7, /*OpIdx*/3, // MIs[9]
        GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[9] src1
        GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckConstantInt, /*MI*/9, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/10, /*MI*/5, /*OpIdx*/2, // MIs[10]
        GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/10, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/10, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/10, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/10,
        GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/2, // MIs[11]
        GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/1, // MIs[12]
        GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[12] src0
        GIM_CheckIsSameOperand, /*MI*/12, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/12, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/11, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/13, /*MI*/10, /*OpIdx*/3, // MIs[13]
        GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
        GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[14] src1
        GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/13, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/15, /*MI*/4, /*OpIdx*/2, // MIs[15]
        GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/15, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/15, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/15, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/15,
        GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/2, // MIs[16]
        GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/1, // MIs[17]
        GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[17] src0
        GIM_CheckIsSameOperand, /*MI*/17, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/17, /*Op*/2, 16,
        GIM_CheckConstantInt, /*MI*/16, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/18, /*MI*/15, /*OpIdx*/3, // MIs[18]
        GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/18, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/19, /*MI*/18, /*OpIdx*/1, // MIs[19]
        GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[19] src1
        GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 16,
        GIM_CheckConstantInt, /*MI*/18, /*Op*/2, GIMT_Encode8(255),
        GIM_CheckIsSafeToFold, /*NumInsns*/19,
        // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3059:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3059:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3059:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3059:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8324,
        GIR_EraseRootFromParent_Done,
      // Label 205: @19295
      GIM_Try, /*On fail goto*//*Label 206*/ GIMT_Encode4(19794), // Rule ID 8323 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
        GIM_CheckHasOneUse, /*MI*/0,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/5,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/6,
        GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/2, // MIs[7]
        GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/7, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/7, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/7, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/7,
        GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/2, // MIs[8]
        GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[8] src0
        GIM_CheckIsSameOperand, /*MI*/8, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckConstantInt, /*MI*/8, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/9, /*MI*/7, /*OpIdx*/3, // MIs[9]
        GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[9] src1
        GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckConstantInt, /*MI*/9, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/10, /*MI*/5, /*OpIdx*/2, // MIs[10]
        GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/10, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/10, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/10, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/10,
        GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/2, // MIs[11]
        GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/1, // MIs[12]
        GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[12] src0
        GIM_CheckIsSameOperand, /*MI*/12, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/12, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/11, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/13, /*MI*/10, /*OpIdx*/3, // MIs[13]
        GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
        GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[14] src1
        GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/13, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/15, /*MI*/4, /*OpIdx*/2, // MIs[15]
        GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/15, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/15, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/15, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/15,
        GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/2, // MIs[16]
        GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/1, // MIs[17]
        GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[17] src0
        GIM_CheckIsSameOperand, /*MI*/17, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/17, /*Op*/2, 16,
        GIM_CheckConstantInt, /*MI*/16, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/18, /*MI*/15, /*OpIdx*/3, // MIs[18]
        GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/18, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/19, /*MI*/18, /*OpIdx*/1, // MIs[19]
        GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[19] src1
        GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 16,
        GIM_CheckConstantInt, /*MI*/18, /*Op*/2, GIMT_Encode8(255),
        GIM_CheckIsSafeToFold, /*NumInsns*/19,
        // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3059:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3059:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3059:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3059:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8323,
        GIR_EraseRootFromParent_Done,
      // Label 206: @19794
      GIM_Try, /*On fail goto*//*Label 207*/ GIMT_Encode4(20293), // Rule ID 8322 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
        GIM_CheckHasOneUse, /*MI*/0,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/2,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 16,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/2, /*OpIdx*/3, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/6, /*Op*/2, 16,
        GIM_CheckConstantInt, /*MI*/5, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/7, /*MI*/1, /*OpIdx*/2, // MIs[7]
        GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/7,
        GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/1, // MIs[8]
        GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/8, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/8, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/8, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/8,
        GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/2, // MIs[9]
        GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/9, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/1, // MIs[10]
        GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[10] src0
        GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/10, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/9, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/11, /*MI*/8, /*OpIdx*/3, // MIs[11]
        GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/1, // MIs[12]
        GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[12] src1
        GIM_CheckIsSameOperand, /*MI*/12, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/12, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/11, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/13, /*MI*/7, /*OpIdx*/2, // MIs[13]
        GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/13,
        GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
        GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/14, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/14, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/14, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/14,
        GIM_RecordInsn, /*DefineMI*/15, /*MI*/14, /*OpIdx*/2, // MIs[15]
        GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[15] src0
        GIM_CheckIsSameOperand, /*MI*/15, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
        GIM_CheckConstantInt, /*MI*/15, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/16, /*MI*/14, /*OpIdx*/3, // MIs[16]
        GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[16] src1
        GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
        GIM_CheckConstantInt, /*MI*/16, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
        GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/17,
        GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
        GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[18] src0
        GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
        GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
        GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[19] src1
        GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
        GIM_CheckIsSafeToFold, /*NumInsns*/19,
        // (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3059:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3059:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3059:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3059:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src0
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/13, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8322,
        GIR_EraseRootFromParent_Done,
      // Label 207: @20293
      GIM_Try, /*On fail goto*//*Label 208*/ GIMT_Encode4(20792), // Rule ID 8321 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
        GIM_CheckHasOneUse, /*MI*/0,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/2,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 16,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/2, /*OpIdx*/3, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/6, /*Op*/2, 16,
        GIM_CheckConstantInt, /*MI*/5, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/7, /*MI*/1, /*OpIdx*/2, // MIs[7]
        GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/7,
        GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/1, // MIs[8]
        GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/8, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/8, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/8, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/8,
        GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/2, // MIs[9]
        GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/9, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/1, // MIs[10]
        GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[10] src0
        GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/10, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/9, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/11, /*MI*/8, /*OpIdx*/3, // MIs[11]
        GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/1, // MIs[12]
        GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[12] src1
        GIM_CheckIsSameOperand, /*MI*/12, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/12, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/11, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/13, /*MI*/7, /*OpIdx*/2, // MIs[13]
        GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/13,
        GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/2, // MIs[14]
        GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/14, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/14, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/14, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/14,
        GIM_RecordInsn, /*DefineMI*/15, /*MI*/14, /*OpIdx*/2, // MIs[15]
        GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[15] src0
        GIM_CheckIsSameOperand, /*MI*/15, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
        GIM_CheckConstantInt, /*MI*/15, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/16, /*MI*/14, /*OpIdx*/3, // MIs[16]
        GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[16] src1
        GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
        GIM_CheckConstantInt, /*MI*/16, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
        GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/17,
        GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
        GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[18] src0
        GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
        GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
        GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[19] src1
        GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
        GIM_CheckIsSafeToFold, /*NumInsns*/19,
        // (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3059:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3059:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3059:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3059:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src0
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/13, /*OpIdx*/1, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8321,
        GIR_EraseRootFromParent_Done,
      // Label 208: @20792
      GIM_Try, /*On fail goto*//*Label 209*/ GIMT_Encode4(21291), // Rule ID 8320 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
        GIM_CheckHasOneUse, /*MI*/0,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/2,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 16,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/2, /*OpIdx*/3, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/6, /*Op*/2, 16,
        GIM_CheckConstantInt, /*MI*/5, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/7, /*MI*/1, /*OpIdx*/2, // MIs[7]
        GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/7,
        GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/1, // MIs[8]
        GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/8,
        GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
        GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/9, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/9, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/9, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/9,
        GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/2, // MIs[10]
        GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[10] src0
        GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
        GIM_CheckConstantInt, /*MI*/10, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/11, /*MI*/9, /*OpIdx*/3, // MIs[11]
        GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[11] src1
        GIM_CheckIsSameOperand, /*MI*/11, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
        GIM_CheckConstantInt, /*MI*/11, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/12, /*MI*/7, /*OpIdx*/2, // MIs[12]
        GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/12,
        GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
        GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
        GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[14] src0
        GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/13, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/15, /*MI*/12, /*OpIdx*/3, // MIs[15]
        GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/15, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/1, // MIs[16]
        GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[16] src1
        GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/16, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/15, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
        GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/17,
        GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
        GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[18] src0
        GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
        GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
        GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[19] src1
        GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
        GIM_CheckIsSafeToFold, /*NumInsns*/19,
        // (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3059:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3059:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3059:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3059:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src0
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/8, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8320,
        GIR_EraseRootFromParent_Done,
      // Label 209: @21291
      GIM_Try, /*On fail goto*//*Label 210*/ GIMT_Encode4(21790), // Rule ID 8319 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
        GIM_CheckHasOneUse, /*MI*/0,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/2,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 16,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/2, /*OpIdx*/3, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/6, /*Op*/2, 16,
        GIM_CheckConstantInt, /*MI*/5, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/7, /*MI*/1, /*OpIdx*/2, // MIs[7]
        GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/7,
        GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/1, // MIs[8]
        GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/8,
        GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/2, // MIs[9]
        GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/9, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/9, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/9, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/9,
        GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/2, // MIs[10]
        GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[10] src0
        GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
        GIM_CheckConstantInt, /*MI*/10, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/11, /*MI*/9, /*OpIdx*/3, // MIs[11]
        GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[11] src1
        GIM_CheckIsSameOperand, /*MI*/11, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
        GIM_CheckConstantInt, /*MI*/11, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/12, /*MI*/7, /*OpIdx*/2, // MIs[12]
        GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/12,
        GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
        GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
        GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[14] src0
        GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/13, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/15, /*MI*/12, /*OpIdx*/3, // MIs[15]
        GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/15, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/1, // MIs[16]
        GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[16] src1
        GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/16, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/15, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
        GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/17,
        GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
        GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[18] src0
        GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
        GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
        GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[19] src1
        GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
        GIM_CheckIsSafeToFold, /*NumInsns*/19,
        // (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3059:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3059:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3059:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3059:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src0
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/8, /*OpIdx*/1, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8319,
        GIR_EraseRootFromParent_Done,
      // Label 210: @21790
      GIM_Try, /*On fail goto*//*Label 211*/ GIMT_Encode4(22289), // Rule ID 8318 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
        GIM_CheckHasOneUse, /*MI*/0,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/2,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/3, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/3, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/3,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/5, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/4, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/3, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/1, // MIs[7]
        GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/6, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/8, /*MI*/2, /*OpIdx*/2, // MIs[8]
        GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/8,
        GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
        GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/9, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/9, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/9, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/9,
        GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/2, // MIs[10]
        GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[10] src0
        GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
        GIM_CheckConstantInt, /*MI*/10, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/11, /*MI*/9, /*OpIdx*/3, // MIs[11]
        GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[11] src1
        GIM_CheckIsSameOperand, /*MI*/11, /*OpIdx*/1, /*OtherMI*/7, /*OtherOpIdx*/1,
        GIM_CheckConstantInt, /*MI*/11, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/12, /*MI*/1, /*OpIdx*/2, // MIs[12]
        GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/12,
        GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
        GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
        GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[14] src0
        GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 16,
        GIM_CheckConstantInt, /*MI*/13, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/15, /*MI*/12, /*OpIdx*/3, // MIs[15]
        GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/15, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/1, // MIs[16]
        GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[16] src1
        GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/7, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/16, /*Op*/2, 16,
        GIM_CheckConstantInt, /*MI*/15, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
        GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/17,
        GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
        GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[18] src0
        GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
        GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
        GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[19] src1
        GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/7, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
        GIM_CheckIsSafeToFold, /*NumInsns*/19,
        // (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3059:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3059:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3059:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3059:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/5, /*OpIdx*/1, // src0
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/7, /*OpIdx*/1, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/8, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8318,
        GIR_EraseRootFromParent_Done,
      // Label 211: @22289
      GIM_Try, /*On fail goto*//*Label 212*/ GIMT_Encode4(22788), // Rule ID 8317 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
        GIM_CheckHasOneUse, /*MI*/0,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/2,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/3, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/3, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/3,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/5, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/4, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/3, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/1, // MIs[7]
        GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/6, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/8, /*MI*/2, /*OpIdx*/2, // MIs[8]
        GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/8,
        GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/2, // MIs[9]
        GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/9, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/9, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/9, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/9,
        GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/2, // MIs[10]
        GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[10] src0
        GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
        GIM_CheckConstantInt, /*MI*/10, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/11, /*MI*/9, /*OpIdx*/3, // MIs[11]
        GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[11] src1
        GIM_CheckIsSameOperand, /*MI*/11, /*OpIdx*/1, /*OtherMI*/7, /*OtherOpIdx*/1,
        GIM_CheckConstantInt, /*MI*/11, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/12, /*MI*/1, /*OpIdx*/2, // MIs[12]
        GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/12,
        GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
        GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
        GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[14] src0
        GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 16,
        GIM_CheckConstantInt, /*MI*/13, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/15, /*MI*/12, /*OpIdx*/3, // MIs[15]
        GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/15, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/1, // MIs[16]
        GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[16] src1
        GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/7, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/16, /*Op*/2, 16,
        GIM_CheckConstantInt, /*MI*/15, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
        GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/17,
        GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
        GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[18] src0
        GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
        GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
        GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[19] src1
        GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/7, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
        GIM_CheckIsSafeToFold, /*NumInsns*/19,
        // (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3059:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3059:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3059:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3059:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/5, /*OpIdx*/1, // src0
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/7, /*OpIdx*/1, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/8, /*OpIdx*/1, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8317,
        GIR_EraseRootFromParent_Done,
      // Label 212: @22788
      GIM_Try, /*On fail goto*//*Label 213*/ GIMT_Encode4(23287), // Rule ID 8316 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
        GIM_CheckHasOneUse, /*MI*/0,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/2,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/3,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/4, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/4, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/5, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/4, /*OpIdx*/3, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/6, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/7, /*MI*/2, /*OpIdx*/2, // MIs[7]
        GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/7, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/7, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/7, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/7,
        GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/2, // MIs[8]
        GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
        GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[9] src0
        GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/9, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/8, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/10, /*MI*/7, /*OpIdx*/3, // MIs[10]
        GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/10, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/1, // MIs[11]
        GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[11] src1
        GIM_CheckIsSameOperand, /*MI*/11, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/11, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/10, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/12, /*MI*/1, /*OpIdx*/2, // MIs[12]
        GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/12,
        GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
        GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
        GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[14] src0
        GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 16,
        GIM_CheckConstantInt, /*MI*/13, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/15, /*MI*/12, /*OpIdx*/3, // MIs[15]
        GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/15, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/1, // MIs[16]
        GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[16] src1
        GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/16, /*Op*/2, 16,
        GIM_CheckConstantInt, /*MI*/15, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
        GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/17,
        GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
        GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[18] src0
        GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
        GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
        GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[19] src1
        GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
        GIM_CheckIsSafeToFold, /*NumInsns*/19,
        // (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3059:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3059:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3059:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3059:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/5, /*OpIdx*/1, // src0
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8316,
        GIR_EraseRootFromParent_Done,
      // Label 213: @23287
      GIM_Try, /*On fail goto*//*Label 214*/ GIMT_Encode4(23786), // Rule ID 2649 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
        GIM_CheckHasOneUse, /*MI*/0,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/2,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/3,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/4, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/4, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/5, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/4, /*OpIdx*/3, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/6, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/7, /*MI*/2, /*OpIdx*/2, // MIs[7]
        GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/7, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/7, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/7, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/7,
        GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/2, // MIs[8]
        GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
        GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[9] src0
        GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/9, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/8, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/10, /*MI*/7, /*OpIdx*/3, // MIs[10]
        GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/10, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/1, // MIs[11]
        GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[11] src1
        GIM_CheckIsSameOperand, /*MI*/11, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/11, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/10, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/12, /*MI*/1, /*OpIdx*/2, // MIs[12]
        GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/12,
        GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
        GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
        GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[14] src0
        GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 16,
        GIM_CheckConstantInt, /*MI*/13, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/15, /*MI*/12, /*OpIdx*/3, // MIs[15]
        GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/15, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/1, // MIs[16]
        GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[16] src1
        GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/16, /*Op*/2, 16,
        GIM_CheckConstantInt, /*MI*/15, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
        GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/17,
        GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
        GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[18] src0
        GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
        GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
        GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[19] src1
        GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
        GIM_CheckIsSafeToFold, /*NumInsns*/19,
        // (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3059:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3059:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3059:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3059:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/5, /*OpIdx*/1, // src0
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2649,
        GIR_EraseRootFromParent_Done,
      // Label 214: @23786
      GIM_Try, /*On fail goto*//*Label 215*/ GIMT_Encode4(24261), // Rule ID 9610 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
        GIM_CheckHasOneUse, /*MI*/0,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/5,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/1, // MIs[7]
        GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[7] src0
        GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 16,
        // MIs[6] Operand 2
        GIM_CheckLiteralInt, /*MI*/6, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/8, /*MI*/5, /*OpIdx*/3, // MIs[8]
        GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
        GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[9] src1
        GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/9, /*Op*/2, 16,
        // MIs[8] Operand 2
        GIM_CheckLiteralInt, /*MI*/8, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/10, /*MI*/4, /*OpIdx*/2, // MIs[10]
        GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/10, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/10,
        GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/1, // MIs[11]
        GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/11, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/11, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
        GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/11, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/11,
        GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/2, // MIs[12]
        GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/12, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/1, // MIs[13]
        GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[13] src0
        GIM_CheckIsSameOperand, /*MI*/13, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/13, /*Op*/2, 8,
        // MIs[12] Operand 2
        GIM_CheckLiteralInt, /*MI*/12, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/14, /*MI*/11, /*OpIdx*/3, // MIs[14]
        GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/14, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/15, /*MI*/14, /*OpIdx*/1, // MIs[15]
        GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[15] src1
        GIM_CheckIsSameOperand, /*MI*/15, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/15, /*Op*/2, 8,
        // MIs[14] Operand 2
        GIM_CheckLiteralInt, /*MI*/14, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/16, /*MI*/10, /*OpIdx*/2, // MIs[16]
        GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/16,
        GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/1, // MIs[17]
        GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
        GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/17,
        GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
        GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        // MIs[18] src0
        GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[18] Operand 2
        GIM_CheckLiteralInt, /*MI*/18, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
        GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        // MIs[19] src1
        GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[19] Operand 2
        GIM_CheckLiteralInt, /*MI*/19, /*Op*/2, GIMT_Encode8(8),
        GIM_CheckIsSafeToFold, /*NumInsns*/19,
        // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3058:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3058:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3058:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3058:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/16, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 9610,
        GIR_EraseRootFromParent_Done,
      // Label 215: @24261
      GIM_Try, /*On fail goto*//*Label 216*/ GIMT_Encode4(24736), // Rule ID 9609 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
        GIM_CheckHasOneUse, /*MI*/0,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/5,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/1, // MIs[7]
        GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[7] src0
        GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 16,
        // MIs[6] Operand 2
        GIM_CheckLiteralInt, /*MI*/6, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/8, /*MI*/5, /*OpIdx*/3, // MIs[8]
        GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
        GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[9] src1
        GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/9, /*Op*/2, 16,
        // MIs[8] Operand 2
        GIM_CheckLiteralInt, /*MI*/8, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/10, /*MI*/4, /*OpIdx*/2, // MIs[10]
        GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/10, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/10,
        GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/1, // MIs[11]
        GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/11, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/11, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
        GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/11, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/11,
        GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/2, // MIs[12]
        GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/12, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/1, // MIs[13]
        GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[13] src0
        GIM_CheckIsSameOperand, /*MI*/13, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/13, /*Op*/2, 8,
        // MIs[12] Operand 2
        GIM_CheckLiteralInt, /*MI*/12, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/14, /*MI*/11, /*OpIdx*/3, // MIs[14]
        GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/14, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/15, /*MI*/14, /*OpIdx*/1, // MIs[15]
        GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[15] src1
        GIM_CheckIsSameOperand, /*MI*/15, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/15, /*Op*/2, 8,
        // MIs[14] Operand 2
        GIM_CheckLiteralInt, /*MI*/14, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/16, /*MI*/10, /*OpIdx*/2, // MIs[16]
        GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/16,
        GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/2, // MIs[17]
        GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
        GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/17,
        GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
        GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        // MIs[18] src0
        GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[18] Operand 2
        GIM_CheckLiteralInt, /*MI*/18, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
        GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        // MIs[19] src1
        GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[19] Operand 2
        GIM_CheckLiteralInt, /*MI*/19, /*Op*/2, GIMT_Encode8(8),
        GIM_CheckIsSafeToFold, /*NumInsns*/19,
        // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3058:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3058:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3058:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3058:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/16, /*OpIdx*/1, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 9609,
        GIR_EraseRootFromParent_Done,
      // Label 216: @24736
      GIM_Try, /*On fail goto*//*Label 217*/ GIMT_Encode4(25211), // Rule ID 9608 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
        GIM_CheckHasOneUse, /*MI*/0,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/5,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/1, // MIs[7]
        GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[7] src0
        GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 16,
        // MIs[6] Operand 2
        GIM_CheckLiteralInt, /*MI*/6, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/8, /*MI*/5, /*OpIdx*/3, // MIs[8]
        GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
        GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[9] src1
        GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/9, /*Op*/2, 16,
        // MIs[8] Operand 2
        GIM_CheckLiteralInt, /*MI*/8, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/10, /*MI*/4, /*OpIdx*/2, // MIs[10]
        GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/10, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/10,
        GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/1, // MIs[11]
        GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/11,
        GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/1, // MIs[12]
        GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
        GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/12,
        GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
        GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        // MIs[13] src0
        GIM_CheckIsSameOperand, /*MI*/13, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[13] Operand 2
        GIM_CheckLiteralInt, /*MI*/13, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/14, /*MI*/12, /*OpIdx*/3, // MIs[14]
        GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        // MIs[14] src1
        GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[14] Operand 2
        GIM_CheckLiteralInt, /*MI*/14, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/15, /*MI*/10, /*OpIdx*/2, // MIs[15]
        GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/15, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/15, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
        GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/15, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/15,
        GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/2, // MIs[16]
        GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/1, // MIs[17]
        GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[17] src0
        GIM_CheckIsSameOperand, /*MI*/17, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/17, /*Op*/2, 8,
        // MIs[16] Operand 2
        GIM_CheckLiteralInt, /*MI*/16, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/18, /*MI*/15, /*OpIdx*/3, // MIs[18]
        GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/18, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/19, /*MI*/18, /*OpIdx*/1, // MIs[19]
        GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[19] src1
        GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 8,
        // MIs[18] Operand 2
        GIM_CheckLiteralInt, /*MI*/18, /*Op*/2, GIMT_Encode8(8),
        GIM_CheckIsSafeToFold, /*NumInsns*/19,
        // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3058:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3058:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3058:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3058:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/11, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 9608,
        GIR_EraseRootFromParent_Done,
      // Label 217: @25211
      GIM_Try, /*On fail goto*//*Label 218*/ GIMT_Encode4(25686), // Rule ID 9607 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
        GIM_CheckHasOneUse, /*MI*/0,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/5,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/1, // MIs[7]
        GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[7] src0
        GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 16,
        // MIs[6] Operand 2
        GIM_CheckLiteralInt, /*MI*/6, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/8, /*MI*/5, /*OpIdx*/3, // MIs[8]
        GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
        GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[9] src1
        GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/9, /*Op*/2, 16,
        // MIs[8] Operand 2
        GIM_CheckLiteralInt, /*MI*/8, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/10, /*MI*/4, /*OpIdx*/2, // MIs[10]
        GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/10, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/10,
        GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/1, // MIs[11]
        GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/11,
        GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/2, // MIs[12]
        GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
        GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/12,
        GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
        GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        // MIs[13] src0
        GIM_CheckIsSameOperand, /*MI*/13, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[13] Operand 2
        GIM_CheckLiteralInt, /*MI*/13, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/14, /*MI*/12, /*OpIdx*/3, // MIs[14]
        GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        // MIs[14] src1
        GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[14] Operand 2
        GIM_CheckLiteralInt, /*MI*/14, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/15, /*MI*/10, /*OpIdx*/2, // MIs[15]
        GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/15, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/15, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
        GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/15, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/15,
        GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/2, // MIs[16]
        GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/1, // MIs[17]
        GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[17] src0
        GIM_CheckIsSameOperand, /*MI*/17, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/17, /*Op*/2, 8,
        // MIs[16] Operand 2
        GIM_CheckLiteralInt, /*MI*/16, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/18, /*MI*/15, /*OpIdx*/3, // MIs[18]
        GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/18, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/19, /*MI*/18, /*OpIdx*/1, // MIs[19]
        GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[19] src1
        GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 8,
        // MIs[18] Operand 2
        GIM_CheckLiteralInt, /*MI*/18, /*Op*/2, GIMT_Encode8(8),
        GIM_CheckIsSafeToFold, /*NumInsns*/19,
        // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3058:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3058:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3058:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3058:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/11, /*OpIdx*/1, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 9607,
        GIR_EraseRootFromParent_Done,
      // Label 218: @25686
      GIM_Try, /*On fail goto*//*Label 219*/ GIMT_Encode4(26161), // Rule ID 9606 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
        GIM_CheckHasOneUse, /*MI*/0,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/5,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/6, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/6, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
        GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/6, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/6,
        GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/2, // MIs[7]
        GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/1, // MIs[8]
        GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[8] src0
        GIM_CheckIsSameOperand, /*MI*/8, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/8, /*Op*/2, 8,
        // MIs[7] Operand 2
        GIM_CheckLiteralInt, /*MI*/7, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/9, /*MI*/6, /*OpIdx*/3, // MIs[9]
        GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/9, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/1, // MIs[10]
        GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[10] src1
        GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/10, /*Op*/2, 8,
        // MIs[9] Operand 2
        GIM_CheckLiteralInt, /*MI*/9, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/11, /*MI*/5, /*OpIdx*/2, // MIs[11]
        GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/11,
        GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/1, // MIs[12]
        GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
        GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/12,
        GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
        GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        // MIs[13] src0
        GIM_CheckIsSameOperand, /*MI*/13, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[13] Operand 2
        GIM_CheckLiteralInt, /*MI*/13, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/14, /*MI*/12, /*OpIdx*/3, // MIs[14]
        GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        // MIs[14] src1
        GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[14] Operand 2
        GIM_CheckLiteralInt, /*MI*/14, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/15, /*MI*/4, /*OpIdx*/2, // MIs[15]
        GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/15, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/15, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
        GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/15, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/15,
        GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/2, // MIs[16]
        GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/1, // MIs[17]
        GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[17] src0
        GIM_CheckIsSameOperand, /*MI*/17, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/17, /*Op*/2, 16,
        // MIs[16] Operand 2
        GIM_CheckLiteralInt, /*MI*/16, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/18, /*MI*/15, /*OpIdx*/3, // MIs[18]
        GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/18, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/19, /*MI*/18, /*OpIdx*/1, // MIs[19]
        GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[19] src1
        GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 16,
        // MIs[18] Operand 2
        GIM_CheckLiteralInt, /*MI*/18, /*Op*/2, GIMT_Encode8(8),
        GIM_CheckIsSafeToFold, /*NumInsns*/19,
        // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3058:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3058:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3058:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3058:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/11, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 9606,
        GIR_EraseRootFromParent_Done,
      // Label 219: @26161
      GIM_Try, /*On fail goto*//*Label 220*/ GIMT_Encode4(26636), // Rule ID 9605 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
        GIM_CheckHasOneUse, /*MI*/0,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/5,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/6, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/6, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
        GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/6, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/6,
        GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/2, // MIs[7]
        GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/1, // MIs[8]
        GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[8] src0
        GIM_CheckIsSameOperand, /*MI*/8, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/8, /*Op*/2, 8,
        // MIs[7] Operand 2
        GIM_CheckLiteralInt, /*MI*/7, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/9, /*MI*/6, /*OpIdx*/3, // MIs[9]
        GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/9, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/1, // MIs[10]
        GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[10] src1
        GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/10, /*Op*/2, 8,
        // MIs[9] Operand 2
        GIM_CheckLiteralInt, /*MI*/9, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/11, /*MI*/5, /*OpIdx*/2, // MIs[11]
        GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/11,
        GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/2, // MIs[12]
        GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
        GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/12,
        GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
        GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        // MIs[13] src0
        GIM_CheckIsSameOperand, /*MI*/13, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[13] Operand 2
        GIM_CheckLiteralInt, /*MI*/13, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/14, /*MI*/12, /*OpIdx*/3, // MIs[14]
        GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        // MIs[14] src1
        GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[14] Operand 2
        GIM_CheckLiteralInt, /*MI*/14, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/15, /*MI*/4, /*OpIdx*/2, // MIs[15]
        GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/15, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/15, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
        GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/15, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/15,
        GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/2, // MIs[16]
        GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/1, // MIs[17]
        GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[17] src0
        GIM_CheckIsSameOperand, /*MI*/17, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/17, /*Op*/2, 16,
        // MIs[16] Operand 2
        GIM_CheckLiteralInt, /*MI*/16, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/18, /*MI*/15, /*OpIdx*/3, // MIs[18]
        GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/18, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/19, /*MI*/18, /*OpIdx*/1, // MIs[19]
        GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[19] src1
        GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 16,
        // MIs[18] Operand 2
        GIM_CheckLiteralInt, /*MI*/18, /*Op*/2, GIMT_Encode8(8),
        GIM_CheckIsSafeToFold, /*NumInsns*/19,
        // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3058:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3058:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3058:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3058:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/11, /*OpIdx*/1, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 9605,
        GIR_EraseRootFromParent_Done,
      // Label 220: @26636
      GIM_Try, /*On fail goto*//*Label 221*/ GIMT_Encode4(27111), // Rule ID 9604 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
        GIM_CheckHasOneUse, /*MI*/0,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/5,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/6,
        GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/1, // MIs[7]
        GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/7, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/7, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
        GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/7, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/7,
        GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/2, // MIs[8]
        GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        // MIs[8] src0
        GIM_CheckIsSameOperand, /*MI*/8, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[8] Operand 2
        GIM_CheckLiteralInt, /*MI*/8, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/9, /*MI*/7, /*OpIdx*/3, // MIs[9]
        GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        // MIs[9] src1
        GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[9] Operand 2
        GIM_CheckLiteralInt, /*MI*/9, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/10, /*MI*/5, /*OpIdx*/2, // MIs[10]
        GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/10, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/10, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
        GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/10, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/10,
        GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/2, // MIs[11]
        GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/1, // MIs[12]
        GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[12] src0
        GIM_CheckIsSameOperand, /*MI*/12, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/12, /*Op*/2, 8,
        // MIs[11] Operand 2
        GIM_CheckLiteralInt, /*MI*/11, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/13, /*MI*/10, /*OpIdx*/3, // MIs[13]
        GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
        GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[14] src1
        GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 8,
        // MIs[13] Operand 2
        GIM_CheckLiteralInt, /*MI*/13, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/15, /*MI*/4, /*OpIdx*/2, // MIs[15]
        GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/15, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/15, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
        GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/15, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/15,
        GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/2, // MIs[16]
        GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/1, // MIs[17]
        GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[17] src0
        GIM_CheckIsSameOperand, /*MI*/17, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/17, /*Op*/2, 16,
        // MIs[16] Operand 2
        GIM_CheckLiteralInt, /*MI*/16, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/18, /*MI*/15, /*OpIdx*/3, // MIs[18]
        GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/18, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/19, /*MI*/18, /*OpIdx*/1, // MIs[19]
        GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[19] src1
        GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 16,
        // MIs[18] Operand 2
        GIM_CheckLiteralInt, /*MI*/18, /*Op*/2, GIMT_Encode8(8),
        GIM_CheckIsSafeToFold, /*NumInsns*/19,
        // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3058:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3058:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3058:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3058:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 9604,
        GIR_EraseRootFromParent_Done,
      // Label 221: @27111
      GIM_Try, /*On fail goto*//*Label 222*/ GIMT_Encode4(27586), // Rule ID 9603 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
        GIM_CheckHasOneUse, /*MI*/0,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/5,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/6,
        GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/2, // MIs[7]
        GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/7, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/7, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
        GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/7, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/7,
        GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/2, // MIs[8]
        GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        // MIs[8] src0
        GIM_CheckIsSameOperand, /*MI*/8, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[8] Operand 2
        GIM_CheckLiteralInt, /*MI*/8, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/9, /*MI*/7, /*OpIdx*/3, // MIs[9]
        GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        // MIs[9] src1
        GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[9] Operand 2
        GIM_CheckLiteralInt, /*MI*/9, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/10, /*MI*/5, /*OpIdx*/2, // MIs[10]
        GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/10, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/10, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
        GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/10, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/10,
        GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/2, // MIs[11]
        GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/1, // MIs[12]
        GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[12] src0
        GIM_CheckIsSameOperand, /*MI*/12, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/12, /*Op*/2, 8,
        // MIs[11] Operand 2
        GIM_CheckLiteralInt, /*MI*/11, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/13, /*MI*/10, /*OpIdx*/3, // MIs[13]
        GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
        GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[14] src1
        GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 8,
        // MIs[13] Operand 2
        GIM_CheckLiteralInt, /*MI*/13, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/15, /*MI*/4, /*OpIdx*/2, // MIs[15]
        GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/15, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/15, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
        GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/15, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/15,
        GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/2, // MIs[16]
        GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/1, // MIs[17]
        GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[17] src0
        GIM_CheckIsSameOperand, /*MI*/17, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/17, /*Op*/2, 16,
        // MIs[16] Operand 2
        GIM_CheckLiteralInt, /*MI*/16, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/18, /*MI*/15, /*OpIdx*/3, // MIs[18]
        GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/18, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/19, /*MI*/18, /*OpIdx*/1, // MIs[19]
        GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[19] src1
        GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 16,
        // MIs[18] Operand 2
        GIM_CheckLiteralInt, /*MI*/18, /*Op*/2, GIMT_Encode8(8),
        GIM_CheckIsSafeToFold, /*NumInsns*/19,
        // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3058:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3058:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3058:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3058:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 9603,
        GIR_EraseRootFromParent_Done,
      // Label 222: @27586
      GIM_Try, /*On fail goto*//*Label 223*/ GIMT_Encode4(28061), // Rule ID 9602 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
        GIM_CheckHasOneUse, /*MI*/0,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/2,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 16,
        // MIs[3] Operand 2
        GIM_CheckLiteralInt, /*MI*/3, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/2, /*OpIdx*/3, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/6, /*Op*/2, 16,
        // MIs[5] Operand 2
        GIM_CheckLiteralInt, /*MI*/5, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/7, /*MI*/1, /*OpIdx*/2, // MIs[7]
        GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/7,
        GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/1, // MIs[8]
        GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/8, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/8, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
        GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/8, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/8,
        GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/2, // MIs[9]
        GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/9, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/1, // MIs[10]
        GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[10] src0
        GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/10, /*Op*/2, 8,
        // MIs[9] Operand 2
        GIM_CheckLiteralInt, /*MI*/9, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/11, /*MI*/8, /*OpIdx*/3, // MIs[11]
        GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/1, // MIs[12]
        GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[12] src1
        GIM_CheckIsSameOperand, /*MI*/12, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/12, /*Op*/2, 8,
        // MIs[11] Operand 2
        GIM_CheckLiteralInt, /*MI*/11, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/13, /*MI*/7, /*OpIdx*/2, // MIs[13]
        GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/13,
        GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
        GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/14, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/14, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
        GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/14, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/14,
        GIM_RecordInsn, /*DefineMI*/15, /*MI*/14, /*OpIdx*/2, // MIs[15]
        GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        // MIs[15] src0
        GIM_CheckIsSameOperand, /*MI*/15, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
        // MIs[15] Operand 2
        GIM_CheckLiteralInt, /*MI*/15, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/16, /*MI*/14, /*OpIdx*/3, // MIs[16]
        GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        // MIs[16] src1
        GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
        // MIs[16] Operand 2
        GIM_CheckLiteralInt, /*MI*/16, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
        GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
        GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/17,
        GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
        GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[18] src0
        GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
        GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
        GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[19] src1
        GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
        GIM_CheckIsSafeToFold, /*NumInsns*/19,
        // (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3058:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3058:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3058:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3058:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src0
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/13, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 9602,
        GIR_EraseRootFromParent_Done,
      // Label 223: @28061
      GIM_Try, /*On fail goto*//*Label 224*/ GIMT_Encode4(28536), // Rule ID 9601 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
        GIM_CheckHasOneUse, /*MI*/0,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/2,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 16,
        // MIs[3] Operand 2
        GIM_CheckLiteralInt, /*MI*/3, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/2, /*OpIdx*/3, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/6, /*Op*/2, 16,
        // MIs[5] Operand 2
        GIM_CheckLiteralInt, /*MI*/5, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/7, /*MI*/1, /*OpIdx*/2, // MIs[7]
        GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/7,
        GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/1, // MIs[8]
        GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/8, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/8, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
        GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/8, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/8,
        GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/2, // MIs[9]
        GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/9, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/1, // MIs[10]
        GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[10] src0
        GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/10, /*Op*/2, 8,
        // MIs[9] Operand 2
        GIM_CheckLiteralInt, /*MI*/9, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/11, /*MI*/8, /*OpIdx*/3, // MIs[11]
        GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/1, // MIs[12]
        GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[12] src1
        GIM_CheckIsSameOperand, /*MI*/12, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/12, /*Op*/2, 8,
        // MIs[11] Operand 2
        GIM_CheckLiteralInt, /*MI*/11, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/13, /*MI*/7, /*OpIdx*/2, // MIs[13]
        GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/13,
        GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/2, // MIs[14]
        GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/14, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/14, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
        GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/14, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/14,
        GIM_RecordInsn, /*DefineMI*/15, /*MI*/14, /*OpIdx*/2, // MIs[15]
        GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        // MIs[15] src0
        GIM_CheckIsSameOperand, /*MI*/15, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
        // MIs[15] Operand 2
        GIM_CheckLiteralInt, /*MI*/15, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/16, /*MI*/14, /*OpIdx*/3, // MIs[16]
        GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        // MIs[16] src1
        GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
        // MIs[16] Operand 2
        GIM_CheckLiteralInt, /*MI*/16, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
        GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
        GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/17,
        GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
        GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[18] src0
        GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
        GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
        GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[19] src1
        GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
        GIM_CheckIsSafeToFold, /*NumInsns*/19,
        // (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3058:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3058:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3058:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3058:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src0
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/13, /*OpIdx*/1, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 9601,
        GIR_EraseRootFromParent_Done,
      // Label 224: @28536
      GIM_Try, /*On fail goto*//*Label 225*/ GIMT_Encode4(29011), // Rule ID 9600 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
        GIM_CheckHasOneUse, /*MI*/0,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/2,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 16,
        // MIs[3] Operand 2
        GIM_CheckLiteralInt, /*MI*/3, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/2, /*OpIdx*/3, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/6, /*Op*/2, 16,
        // MIs[5] Operand 2
        GIM_CheckLiteralInt, /*MI*/5, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/7, /*MI*/1, /*OpIdx*/2, // MIs[7]
        GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/7,
        GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/1, // MIs[8]
        GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/8,
        GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
        GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/9, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/9, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
        GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/9, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/9,
        GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/2, // MIs[10]
        GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        // MIs[10] src0
        GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
        // MIs[10] Operand 2
        GIM_CheckLiteralInt, /*MI*/10, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/11, /*MI*/9, /*OpIdx*/3, // MIs[11]
        GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        // MIs[11] src1
        GIM_CheckIsSameOperand, /*MI*/11, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
        // MIs[11] Operand 2
        GIM_CheckLiteralInt, /*MI*/11, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/12, /*MI*/7, /*OpIdx*/2, // MIs[12]
        GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
        GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/12,
        GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
        GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
        GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[14] src0
        GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 8,
        // MIs[13] Operand 2
        GIM_CheckLiteralInt, /*MI*/13, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/15, /*MI*/12, /*OpIdx*/3, // MIs[15]
        GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/15, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/1, // MIs[16]
        GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[16] src1
        GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/16, /*Op*/2, 8,
        // MIs[15] Operand 2
        GIM_CheckLiteralInt, /*MI*/15, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
        GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
        GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/17,
        GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
        GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[18] src0
        GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
        GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
        GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[19] src1
        GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
        GIM_CheckIsSafeToFold, /*NumInsns*/19,
        // (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3058:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3058:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3058:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3058:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src0
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/8, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 9600,
        GIR_EraseRootFromParent_Done,
      // Label 225: @29011
      GIM_Try, /*On fail goto*//*Label 226*/ GIMT_Encode4(29486), // Rule ID 9599 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
        GIM_CheckHasOneUse, /*MI*/0,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/2,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 16,
        // MIs[3] Operand 2
        GIM_CheckLiteralInt, /*MI*/3, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/2, /*OpIdx*/3, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/6, /*Op*/2, 16,
        // MIs[5] Operand 2
        GIM_CheckLiteralInt, /*MI*/5, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/7, /*MI*/1, /*OpIdx*/2, // MIs[7]
        GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/7,
        GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/1, // MIs[8]
        GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/8,
        GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/2, // MIs[9]
        GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/9, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/9, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
        GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/9, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/9,
        GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/2, // MIs[10]
        GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        // MIs[10] src0
        GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
        // MIs[10] Operand 2
        GIM_CheckLiteralInt, /*MI*/10, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/11, /*MI*/9, /*OpIdx*/3, // MIs[11]
        GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        // MIs[11] src1
        GIM_CheckIsSameOperand, /*MI*/11, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
        // MIs[11] Operand 2
        GIM_CheckLiteralInt, /*MI*/11, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/12, /*MI*/7, /*OpIdx*/2, // MIs[12]
        GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
        GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/12,
        GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
        GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
        GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[14] src0
        GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 8,
        // MIs[13] Operand 2
        GIM_CheckLiteralInt, /*MI*/13, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/15, /*MI*/12, /*OpIdx*/3, // MIs[15]
        GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/15, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/1, // MIs[16]
        GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[16] src1
        GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/16, /*Op*/2, 8,
        // MIs[15] Operand 2
        GIM_CheckLiteralInt, /*MI*/15, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
        GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
        GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/17,
        GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
        GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[18] src0
        GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
        GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
        GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[19] src1
        GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
        GIM_CheckIsSafeToFold, /*NumInsns*/19,
        // (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3058:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3058:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3058:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3058:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src0
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/8, /*OpIdx*/1, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 9599,
        GIR_EraseRootFromParent_Done,
      // Label 226: @29486
      GIM_Try, /*On fail goto*//*Label 227*/ GIMT_Encode4(29961), // Rule ID 9598 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
        GIM_CheckHasOneUse, /*MI*/0,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/2,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/3, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/3, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/3,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/5, /*Op*/2, 8,
        // MIs[4] Operand 2
        GIM_CheckLiteralInt, /*MI*/4, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/3, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/1, // MIs[7]
        GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 8,
        // MIs[6] Operand 2
        GIM_CheckLiteralInt, /*MI*/6, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/8, /*MI*/2, /*OpIdx*/2, // MIs[8]
        GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/8,
        GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
        GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/9, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/9, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
        GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/9, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/9,
        GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/2, // MIs[10]
        GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        // MIs[10] src0
        GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
        // MIs[10] Operand 2
        GIM_CheckLiteralInt, /*MI*/10, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/11, /*MI*/9, /*OpIdx*/3, // MIs[11]
        GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        // MIs[11] src1
        GIM_CheckIsSameOperand, /*MI*/11, /*OpIdx*/1, /*OtherMI*/7, /*OtherOpIdx*/1,
        // MIs[11] Operand 2
        GIM_CheckLiteralInt, /*MI*/11, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/12, /*MI*/1, /*OpIdx*/2, // MIs[12]
        GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
        GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/12,
        GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
        GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
        GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[14] src0
        GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 16,
        // MIs[13] Operand 2
        GIM_CheckLiteralInt, /*MI*/13, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/15, /*MI*/12, /*OpIdx*/3, // MIs[15]
        GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/15, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/1, // MIs[16]
        GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[16] src1
        GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/7, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/16, /*Op*/2, 16,
        // MIs[15] Operand 2
        GIM_CheckLiteralInt, /*MI*/15, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
        GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
        GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/17,
        GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
        GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[18] src0
        GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
        GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
        GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[19] src1
        GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/7, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
        GIM_CheckIsSafeToFold, /*NumInsns*/19,
        // (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3058:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3058:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3058:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3058:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/5, /*OpIdx*/1, // src0
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/7, /*OpIdx*/1, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/8, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 9598,
        GIR_EraseRootFromParent_Done,
      // Label 227: @29961
      GIM_Try, /*On fail goto*//*Label 228*/ GIMT_Encode4(30436), // Rule ID 9597 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
        GIM_CheckHasOneUse, /*MI*/0,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/2,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/3, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/3, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/3,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/5, /*Op*/2, 8,
        // MIs[4] Operand 2
        GIM_CheckLiteralInt, /*MI*/4, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/3, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/1, // MIs[7]
        GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 8,
        // MIs[6] Operand 2
        GIM_CheckLiteralInt, /*MI*/6, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/8, /*MI*/2, /*OpIdx*/2, // MIs[8]
        GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/8,
        GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/2, // MIs[9]
        GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/9, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/9, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
        GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/9, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/9,
        GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/2, // MIs[10]
        GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        // MIs[10] src0
        GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
        // MIs[10] Operand 2
        GIM_CheckLiteralInt, /*MI*/10, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/11, /*MI*/9, /*OpIdx*/3, // MIs[11]
        GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        // MIs[11] src1
        GIM_CheckIsSameOperand, /*MI*/11, /*OpIdx*/1, /*OtherMI*/7, /*OtherOpIdx*/1,
        // MIs[11] Operand 2
        GIM_CheckLiteralInt, /*MI*/11, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/12, /*MI*/1, /*OpIdx*/2, // MIs[12]
        GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
        GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/12,
        GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
        GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
        GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[14] src0
        GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 16,
        // MIs[13] Operand 2
        GIM_CheckLiteralInt, /*MI*/13, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/15, /*MI*/12, /*OpIdx*/3, // MIs[15]
        GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/15, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/1, // MIs[16]
        GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[16] src1
        GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/7, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/16, /*Op*/2, 16,
        // MIs[15] Operand 2
        GIM_CheckLiteralInt, /*MI*/15, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
        GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
        GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/17,
        GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
        GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[18] src0
        GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
        GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
        GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[19] src1
        GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/7, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
        GIM_CheckIsSafeToFold, /*NumInsns*/19,
        // (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3058:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3058:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3058:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3058:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/5, /*OpIdx*/1, // src0
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/7, /*OpIdx*/1, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/8, /*OpIdx*/1, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 9597,
        GIR_EraseRootFromParent_Done,
      // Label 228: @30436
      GIM_Try, /*On fail goto*//*Label 229*/ GIMT_Encode4(30911), // Rule ID 9596 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
        GIM_CheckHasOneUse, /*MI*/0,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/2,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/3,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/4, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/4, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
        // MIs[5] Operand 2
        GIM_CheckLiteralInt, /*MI*/5, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/4, /*OpIdx*/3, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
        // MIs[6] Operand 2
        GIM_CheckLiteralInt, /*MI*/6, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/7, /*MI*/2, /*OpIdx*/2, // MIs[7]
        GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/7, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/7, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
        GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/7, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/7,
        GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/2, // MIs[8]
        GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
        GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[9] src0
        GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/9, /*Op*/2, 8,
        // MIs[8] Operand 2
        GIM_CheckLiteralInt, /*MI*/8, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/10, /*MI*/7, /*OpIdx*/3, // MIs[10]
        GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/10, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/1, // MIs[11]
        GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[11] src1
        GIM_CheckIsSameOperand, /*MI*/11, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/11, /*Op*/2, 8,
        // MIs[10] Operand 2
        GIM_CheckLiteralInt, /*MI*/10, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/12, /*MI*/1, /*OpIdx*/2, // MIs[12]
        GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
        GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/12,
        GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
        GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
        GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[14] src0
        GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 16,
        // MIs[13] Operand 2
        GIM_CheckLiteralInt, /*MI*/13, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/15, /*MI*/12, /*OpIdx*/3, // MIs[15]
        GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/15, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/1, // MIs[16]
        GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[16] src1
        GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/16, /*Op*/2, 16,
        // MIs[15] Operand 2
        GIM_CheckLiteralInt, /*MI*/15, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
        GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
        GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/17,
        GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
        GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[18] src0
        GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
        GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
        GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[19] src1
        GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
        GIM_CheckIsSafeToFold, /*NumInsns*/19,
        // (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3058:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3058:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3058:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3058:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/5, /*OpIdx*/1, // src0
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 9596,
        GIR_EraseRootFromParent_Done,
      // Label 229: @30911
      GIM_Try, /*On fail goto*//*Label 230*/ GIMT_Encode4(31386), // Rule ID 2665 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
        GIM_CheckHasOneUse, /*MI*/0,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/2,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/3,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/4, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/4, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
        // MIs[5] Operand 2
        GIM_CheckLiteralInt, /*MI*/5, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/4, /*OpIdx*/3, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
        // MIs[6] Operand 2
        GIM_CheckLiteralInt, /*MI*/6, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/7, /*MI*/2, /*OpIdx*/2, // MIs[7]
        GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/7, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/7, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
        GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/7, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/7,
        GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/2, // MIs[8]
        GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
        GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[9] src0
        GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/9, /*Op*/2, 8,
        // MIs[8] Operand 2
        GIM_CheckLiteralInt, /*MI*/8, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/10, /*MI*/7, /*OpIdx*/3, // MIs[10]
        GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/10, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/1, // MIs[11]
        GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[11] src1
        GIM_CheckIsSameOperand, /*MI*/11, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/11, /*Op*/2, 8,
        // MIs[10] Operand 2
        GIM_CheckLiteralInt, /*MI*/10, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/12, /*MI*/1, /*OpIdx*/2, // MIs[12]
        GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
        GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/12,
        GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
        GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
        GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[14] src0
        GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 16,
        // MIs[13] Operand 2
        GIM_CheckLiteralInt, /*MI*/13, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/15, /*MI*/12, /*OpIdx*/3, // MIs[15]
        GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/15, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/1, // MIs[16]
        GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[16] src1
        GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/16, /*Op*/2, 16,
        // MIs[15] Operand 2
        GIM_CheckLiteralInt, /*MI*/15, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
        GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
        GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/17,
        GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
        GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[18] src0
        GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
        GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
        GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[19] src1
        GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
        GIM_CheckIsSafeToFold, /*NumInsns*/19,
        // (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3058:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3058:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3058:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3058:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/5, /*OpIdx*/1, // src0
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2665,
        GIR_EraseRootFromParent_Done,
      // Label 230: @31386
      GIM_Try, /*On fail goto*//*Label 231*/ GIMT_Encode4(31609), // Rule ID 8253 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot2Insts),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(65535),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, GIMT_Encode8(65535),
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/5,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[6] src0
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/6, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/7, /*MI*/5, /*OpIdx*/3, // MIs[7]
        GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[7] src1
        GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 16,
        GIM_CheckIsSafeToFold, /*NumInsns*/7,
        // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3059:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 65535:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 65535:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3059:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>)  =>  (V_DOT2_U32_U16:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT2_U32_U16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8253,
        GIR_EraseRootFromParent_Done,
      // Label 231: @31609
      GIM_Try, /*On fail goto*//*Label 232*/ GIMT_Encode4(31832), // Rule ID 8254 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot2Insts),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(65535),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, GIMT_Encode8(65535),
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/5,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[6] src0
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/6, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/7, /*MI*/5, /*OpIdx*/3, // MIs[7]
        GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[7] src1
        GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 16,
        GIM_CheckIsSafeToFold, /*NumInsns*/7,
        // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3059:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 65535:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 65535:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3059:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>)  =>  (V_DOT2_U32_U16:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT2_U32_U16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8254,
        GIR_EraseRootFromParent_Done,
      // Label 232: @31832
      GIM_Try, /*On fail goto*//*Label 233*/ GIMT_Encode4(32055), // Rule ID 2641 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot2Insts),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/2,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/2, /*OpIdx*/3, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/5,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[6] src0
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckConstantInt, /*MI*/6, /*Op*/2, GIMT_Encode8(65535),
        GIM_RecordInsn, /*DefineMI*/7, /*MI*/5, /*OpIdx*/3, // MIs[7]
        GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[7] src1
        GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
        GIM_CheckConstantInt, /*MI*/7, /*Op*/2, GIMT_Encode8(65535),
        GIM_CheckIsSafeToFold, /*NumInsns*/7,
        // (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3059:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3059:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 65535:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 65535:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)  =>  (V_DOT2_U32_U16:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT2_U32_U16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src0
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2641,
        GIR_EraseRootFromParent_Done,
      // Label 233: @32055
      GIM_Try, /*On fail goto*//*Label 234*/ GIMT_Encode4(32278), // Rule ID 8252 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot2Insts),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/2,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/2, /*OpIdx*/3, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/5,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[6] src0
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckConstantInt, /*MI*/6, /*Op*/2, GIMT_Encode8(65535),
        GIM_RecordInsn, /*DefineMI*/7, /*MI*/5, /*OpIdx*/3, // MIs[7]
        GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[7] src1
        GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
        GIM_CheckConstantInt, /*MI*/7, /*Op*/2, GIMT_Encode8(65535),
        GIM_CheckIsSafeToFold, /*NumInsns*/7,
        // (add:{ *:[i32] } (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3059:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3059:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 65535:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 65535:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)  =>  (V_DOT2_U32_U16:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT2_U32_U16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src0
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8252,
        GIR_EraseRootFromParent_Done,
      // Label 234: @32278
      GIM_Try, /*On fail goto*//*Label 235*/ GIMT_Encode4(32493), // Rule ID 8285 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot2Insts),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        // MIs[2] Operand 2
        GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, GIMT_Encode8(16),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        // MIs[3] Operand 2
        GIM_CheckLiteralInt, /*MI*/3, /*Op*/2, GIMT_Encode8(16),
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/5,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[6] src0
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/6, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/7, /*MI*/5, /*OpIdx*/3, // MIs[7]
        GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[7] src1
        GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 16,
        GIM_CheckIsSafeToFold, /*NumInsns*/7,
        // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3058:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i16:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i16:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3058:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>)  =>  (V_DOT2_I32_I16:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT2_I32_I16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8285,
        GIR_EraseRootFromParent_Done,
      // Label 235: @32493
      GIM_Try, /*On fail goto*//*Label 236*/ GIMT_Encode4(32708), // Rule ID 8286 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot2Insts),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        // MIs[2] Operand 2
        GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, GIMT_Encode8(16),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        // MIs[3] Operand 2
        GIM_CheckLiteralInt, /*MI*/3, /*Op*/2, GIMT_Encode8(16),
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/5,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[6] src0
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/6, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/7, /*MI*/5, /*OpIdx*/3, // MIs[7]
        GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[7] src1
        GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 16,
        GIM_CheckIsSafeToFold, /*NumInsns*/7,
        // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3058:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i16:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i16:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3058:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>)  =>  (V_DOT2_I32_I16:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT2_I32_I16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8286,
        GIR_EraseRootFromParent_Done,
      // Label 236: @32708
      GIM_Try, /*On fail goto*//*Label 237*/ GIMT_Encode4(32923), // Rule ID 2645 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot2Insts),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/2,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/2, /*OpIdx*/3, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/5,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        // MIs[6] src0
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[6] Operand 2
        GIM_CheckLiteralInt, /*MI*/6, /*Op*/2, GIMT_Encode8(16),
        GIM_RecordInsn, /*DefineMI*/7, /*MI*/5, /*OpIdx*/3, // MIs[7]
        GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        // MIs[7] src1
        GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
        // MIs[7] Operand 2
        GIM_CheckLiteralInt, /*MI*/7, /*Op*/2, GIMT_Encode8(16),
        GIM_CheckIsSafeToFold, /*NumInsns*/7,
        // (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3058:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3058:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i16:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i16:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)  =>  (V_DOT2_I32_I16:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT2_I32_I16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src0
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2645,
        GIR_EraseRootFromParent_Done,
      // Label 237: @32923
      GIM_Try, /*On fail goto*//*Label 238*/ GIMT_Encode4(33138), // Rule ID 8284 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot2Insts),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/2,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/2, /*OpIdx*/3, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/5,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        // MIs[6] src0
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[6] Operand 2
        GIM_CheckLiteralInt, /*MI*/6, /*Op*/2, GIMT_Encode8(16),
        GIM_RecordInsn, /*DefineMI*/7, /*MI*/5, /*OpIdx*/3, // MIs[7]
        GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        // MIs[7] src1
        GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
        // MIs[7] Operand 2
        GIM_CheckLiteralInt, /*MI*/7, /*Op*/2, GIMT_Encode8(16),
        GIM_CheckIsSafeToFold, /*NumInsns*/7,
        // (add:{ *:[i32] } (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3058:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3058:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i16:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i16:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)  =>  (V_DOT2_I32_I16:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT2_I32_I16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src0
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8284,
        GIR_EraseRootFromParent_Done,
      // Label 238: @33138
      GIM_Try, /*On fail goto*//*Label 239*/ GIMT_Encode4(33191), // Rule ID 7345 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 1,
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_13397),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (shl:{ *:[i32] } 1:{ *:[i32] }, i32:{ *:[i32] }:$a), -1:{ *:[i32] })<<P:Predicate_anonymous_13397>>  =>  (S_BFM_B32:{ *:[i32] } ?:{ *:[i32] }:$a, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_BFM_B32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // a
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 7345,
        GIR_EraseRootFromParent_Done,
      // Label 239: @33191
      GIM_Try, /*On fail goto*//*Label 240*/ GIMT_Encode4(33244), // Rule ID 7347 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 1,
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_19207),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (shl:{ *:[i32] } 1:{ *:[i32] }, i32:{ *:[i32] }:$a), -1:{ *:[i32] })<<P:Predicate_anonymous_19207>>  =>  (V_BFM_B32_e64:{ *:[i32] } ?:{ *:[i32] }:$a, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFM_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // a
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 7347,
        GIR_EraseRootFromParent_Done,
      // Label 240: @33244
      GIM_Try, /*On fail goto*//*Label 241*/ GIMT_Encode4(33354), // Rule ID 7174 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SELECT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ICMP),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
        // MIs[2] Operand 1
        GIM_CheckCmpPredicate, /*MI*/2, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_UGT),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SUB),
        // MIs[3] src0
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[3] src1
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/3,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/3, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_SUB),
        // MIs[4] src1
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/3,
        // MIs[4] src0
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (add:{ *:[i32] } (select:{ *:[i32] } (setcc:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, SETUGT:{ *:[Other] }), (sub:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1), (sub:{ *:[i32] } i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src0))<<P:Predicate_select_oneuse>>, i32:{ *:[i32] }:$src2)  =>  (V_SAD_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SAD_U32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 7174,
        GIR_EraseRootFromParent_Done,
      // Label 241: @33354
      GIM_Try, /*On fail goto*//*Label 242*/ GIMT_Encode4(33464), // Rule ID 10926 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SELECT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ICMP),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
        // MIs[2] Operand 1
        GIM_CheckCmpPredicate, /*MI*/2, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_UGT),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SUB),
        // MIs[3] src0
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[3] src1
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/3,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/3, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_SUB),
        // MIs[4] src1
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/3,
        // MIs[4] src0
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (select:{ *:[i32] } (setcc:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, SETUGT:{ *:[Other] }), (sub:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1), (sub:{ *:[i32] } i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src0))<<P:Predicate_select_oneuse>>)  =>  (V_SAD_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SAD_U32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // src1
        GIR_RootToRootCopy, /*OpIdx*/1, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 10926,
        GIR_EraseRootFromParent_Done,
      // Label 242: @33464
      GIM_Try, /*On fail goto*//*Label 243*/ GIMT_Encode4(33557), // Rule ID 2487 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:1:x
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordNamedOperand, /*MI*/2, /*Op*/1, /*StoreIdx*/1, // Name : pred:1:y
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/2, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_csh_mask_32),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:1:z
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_20243),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (add:{ *:[i32] } (shl:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:1:x, (and:{ *:[i32] } i32:{ *:[i32] }:$src1:$pred:1:y, (imm:{ *:[i32] }))<<P:Predicate_csh_mask_32>>)<<P:Predicate_anonymous_20244>>, i32:{ *:[i32] }:$src2:$pred:1:z)<<P:1:Predicate_anonymous_20243>>  =>  (V_LSHL_ADD_U32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_LSHL_ADD_U32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2487,
        GIR_EraseRootFromParent_Done,
      // Label 243: @33557
      GIM_Try, /*On fail goto*//*Label 244*/ GIMT_Encode4(33650), // Rule ID 8226 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:1:z
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:1:x
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordNamedOperand, /*MI*/2, /*Op*/1, /*StoreIdx*/1, // Name : pred:1:y
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/2, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_csh_mask_32),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_20243),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (add:{ *:[i32] } i32:{ *:[i32] }:$src2:$pred:1:z, (shl:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:1:x, (and:{ *:[i32] } i32:{ *:[i32] }:$src1:$pred:1:y, (imm:{ *:[i32] }))<<P:Predicate_csh_mask_32>>)<<P:Predicate_anonymous_20244>>)<<P:1:Predicate_anonymous_20243>>  =>  (V_LSHL_ADD_U32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_LSHL_ADD_U32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/1, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8226,
        GIR_EraseRootFromParent_Done,
      // Label 244: @33650
      GIM_Try, /*On fail goto*//*Label 245*/ GIMT_Encode4(33705), // Rule ID 7121 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3058:{ *:[iPTR] }, i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1), i32:{ *:[i32] }:$src2)  =>  (V_MAD_I32_I24_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_I32_I24_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 7121,
        GIR_EraseRootFromParent_Done,
      // Label 245: @33705
      GIM_Try, /*On fail goto*//*Label 246*/ GIMT_Encode4(33760), // Rule ID 7123 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3059:{ *:[iPTR] }, i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1), i32:{ *:[i32] }:$src2)  =>  (V_MAD_U32_U24_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U32_U24_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 7123,
        GIR_EraseRootFromParent_Done,
      // Label 246: @33760
      GIM_Try, /*On fail goto*//*Label 247*/ GIMT_Encode4(33825), // Rule ID 82 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_shl1_add),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (shl:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, 1:{ *:[i32] })<<P:Predicate_shl_oneuse>>, SSrc_b32:{ *:[i32] }:$src1)<<P:Predicate_shl1_add>>  =>  (S_LSHL1_ADD_U32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_LSHL1_ADD_U32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 82,
        GIR_EraseRootFromParent_Done,
      // Label 247: @33825
      GIM_Try, /*On fail goto*//*Label 248*/ GIMT_Encode4(33890), // Rule ID 83 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 2,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_shl2_add),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (shl:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, 2:{ *:[i32] })<<P:Predicate_shl_oneuse>>, SSrc_b32:{ *:[i32] }:$src1)<<P:Predicate_shl2_add>>  =>  (S_LSHL2_ADD_U32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_LSHL2_ADD_U32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 83,
        GIR_EraseRootFromParent_Done,
      // Label 248: @33890
      GIM_Try, /*On fail goto*//*Label 249*/ GIMT_Encode4(33955), // Rule ID 84 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 3,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_shl3_add),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (shl:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, 3:{ *:[i32] })<<P:Predicate_shl_oneuse>>, SSrc_b32:{ *:[i32] }:$src1)<<P:Predicate_shl3_add>>  =>  (S_LSHL3_ADD_U32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_LSHL3_ADD_U32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 84,
        GIR_EraseRootFromParent_Done,
      // Label 249: @33955
      GIM_Try, /*On fail goto*//*Label 250*/ GIMT_Encode4(34020), // Rule ID 85 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 4,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_shl4_add),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (shl:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, 4:{ *:[i32] })<<P:Predicate_shl_oneuse>>, SSrc_b32:{ *:[i32] }:$src1)<<P:Predicate_shl4_add>>  =>  (S_LSHL4_ADD_U32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_LSHL4_ADD_U32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 85,
        GIR_EraseRootFromParent_Done,
      // Label 250: @34020
      GIM_Try, /*On fail goto*//*Label 251*/ GIMT_Encode4(34103), // Rule ID 7173 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_UMAX),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_UMIN),
        // MIs[3] src0
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[3] src1
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (add:{ *:[i32] } (sub:{ *:[i32] } (umax:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1), (umin:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1))<<P:Predicate_sub_oneuse>>, i32:{ *:[i32] }:$src2)  =>  (V_SAD_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SAD_U32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 7173,
        GIR_EraseRootFromParent_Done,
      // Label 251: @34103
      GIM_Try, /*On fail goto*//*Label 252*/ GIMT_Encode4(34186), // Rule ID 10919 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_UMAX),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_UMIN),
        // MIs[3] src1
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[3] src0
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (add:{ *:[i32] } (sub:{ *:[i32] } (umax:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1), (umin:{ *:[i32] } i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src0))<<P:Predicate_sub_oneuse>>, i32:{ *:[i32] }:$src2)  =>  (V_SAD_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SAD_U32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 10919,
        GIR_EraseRootFromParent_Done,
      // Label 252: @34186
      GIM_Try, /*On fail goto*//*Label 253*/ GIMT_Encode4(34269), // Rule ID 10920 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_UMAX),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_UMIN),
        // MIs[3] src0
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[3] src1
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (add:{ *:[i32] } (sub:{ *:[i32] } (umax:{ *:[i32] } i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src0), (umin:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1))<<P:Predicate_sub_oneuse>>, i32:{ *:[i32] }:$src2)  =>  (V_SAD_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SAD_U32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 10920,
        GIR_EraseRootFromParent_Done,
      // Label 253: @34269
      GIM_Try, /*On fail goto*//*Label 254*/ GIMT_Encode4(34352), // Rule ID 10921 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_UMAX),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_UMIN),
        // MIs[3] src1
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[3] src0
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (add:{ *:[i32] } (sub:{ *:[i32] } (umax:{ *:[i32] } i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src0), (umin:{ *:[i32] } i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src0))<<P:Predicate_sub_oneuse>>, i32:{ *:[i32] }:$src2)  =>  (V_SAD_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SAD_U32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 10921,
        GIR_EraseRootFromParent_Done,
      // Label 254: @34352
      GIM_Try, /*On fail goto*//*Label 255*/ GIMT_Encode4(34417), // Rule ID 8143 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_shl1_add),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src1, (shl:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, 1:{ *:[i32] })<<P:Predicate_shl_oneuse>>)<<P:Predicate_shl1_add>>  =>  (S_LSHL1_ADD_U32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_LSHL1_ADD_U32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8143,
        GIR_EraseRootFromParent_Done,
      // Label 255: @34417
      GIM_Try, /*On fail goto*//*Label 256*/ GIMT_Encode4(34482), // Rule ID 8144 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_shl2_add),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src1, (shl:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, 2:{ *:[i32] })<<P:Predicate_shl_oneuse>>)<<P:Predicate_shl2_add>>  =>  (S_LSHL2_ADD_U32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_LSHL2_ADD_U32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8144,
        GIR_EraseRootFromParent_Done,
      // Label 256: @34482
      GIM_Try, /*On fail goto*//*Label 257*/ GIMT_Encode4(34547), // Rule ID 8145 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 3,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_shl3_add),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src1, (shl:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, 3:{ *:[i32] })<<P:Predicate_shl_oneuse>>)<<P:Predicate_shl3_add>>  =>  (S_LSHL3_ADD_U32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_LSHL3_ADD_U32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8145,
        GIR_EraseRootFromParent_Done,
      // Label 257: @34547
      GIM_Try, /*On fail goto*//*Label 258*/ GIMT_Encode4(34612), // Rule ID 8146 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 4,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_shl4_add),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src1, (shl:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, 4:{ *:[i32] })<<P:Predicate_shl_oneuse>>)<<P:Predicate_shl4_add>>  =>  (S_LSHL4_ADD_U32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_LSHL4_ADD_U32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8146,
        GIR_EraseRootFromParent_Done,
      // Label 258: @34612
      GIM_Try, /*On fail goto*//*Label 259*/ GIMT_Encode4(34667), // Rule ID 10886 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3058:{ *:[iPTR] }, i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1))  =>  (V_MAD_I32_I24_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_I32_I24_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // src1
        GIR_RootToRootCopy, /*OpIdx*/1, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 10886,
        GIR_EraseRootFromParent_Done,
      // Label 259: @34667
      GIM_Try, /*On fail goto*//*Label 260*/ GIMT_Encode4(34722), // Rule ID 10888 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3059:{ *:[iPTR] }, i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1))  =>  (V_MAD_U32_U24_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U32_U24_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // src1
        GIR_RootToRootCopy, /*OpIdx*/1, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 10888,
        GIR_EraseRootFromParent_Done,
      // Label 260: @34722
      GIM_Try, /*On fail goto*//*Label 261*/ GIMT_Encode4(34805), // Rule ID 10922 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_UMAX),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_UMIN),
        // MIs[3] src0
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[3] src1
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (sub:{ *:[i32] } (umax:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1), (umin:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1))<<P:Predicate_sub_oneuse>>)  =>  (V_SAD_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SAD_U32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/1, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 10922,
        GIR_EraseRootFromParent_Done,
      // Label 261: @34805
      GIM_Try, /*On fail goto*//*Label 262*/ GIMT_Encode4(34888), // Rule ID 10923 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_UMAX),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_UMIN),
        // MIs[3] src1
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[3] src0
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (sub:{ *:[i32] } (umax:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1), (umin:{ *:[i32] } i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src0))<<P:Predicate_sub_oneuse>>)  =>  (V_SAD_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SAD_U32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/1, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 10923,
        GIR_EraseRootFromParent_Done,
      // Label 262: @34888
      GIM_Try, /*On fail goto*//*Label 263*/ GIMT_Encode4(34971), // Rule ID 10924 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_UMAX),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_UMIN),
        // MIs[3] src0
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[3] src1
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (sub:{ *:[i32] } (umax:{ *:[i32] } i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src0), (umin:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1))<<P:Predicate_sub_oneuse>>)  =>  (V_SAD_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SAD_U32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/1, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 10924,
        GIR_EraseRootFromParent_Done,
      // Label 263: @34971
      GIM_Try, /*On fail goto*//*Label 264*/ GIMT_Encode4(35054), // Rule ID 10925 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_UMAX),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_UMIN),
        // MIs[3] src1
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[3] src0
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (sub:{ *:[i32] } (umax:{ *:[i32] } i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src0), (umin:{ *:[i32] } i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src0))<<P:Predicate_sub_oneuse>>)  =>  (V_SAD_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SAD_U32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/1, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 10925,
        GIR_EraseRootFromParent_Done,
      // Label 264: @35054
      GIM_Try, /*On fail goto*//*Label 265*/ GIMT_Encode4(35219), // Rule ID 8236 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNotMADIntraFwdBug_isGFX9Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:11:z
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:11:x
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:11:y
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_20278),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } VGPR_32:{ *:[i32] }:$src2:$pred:11:z, (mul:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:11:x, i32:{ *:[i32] }:$src1:$pred:11:y)<<P:Predicate_anonymous_20279>>)<<P:11:Predicate_anonymous_20278>>  =>  (EXTRACT_SUBREG:{ *:[i32] } (V_MAD_U64_U32_e64:{ *:[i64] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, ?:{ *:[i32] }:$src2, sub0:{ *:[i32] }, (IMPLICIT_DEF:{ *:[i32] }), sub1:{ *:[i32] }), 0:{ *:[i1] }), sub0:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src2
        GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/3,
        GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/11,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U64_U32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_AddImm8, /*InsnID*/1, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AMDGPU::sub0),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        // GIR_Coverage, 8236,
        GIR_EraseRootFromParent_Done,
      // Label 265: @35219
      GIM_Try, /*On fail goto*//*Label 266*/ GIMT_Encode4(35384), // Rule ID 8240 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMADIntraFwdBug_isGFX11Only),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:14:z
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:14:x
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:14:y
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_20278),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } VGPR_32:{ *:[i32] }:$src2:$pred:14:z, (mul:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:14:x, i32:{ *:[i32] }:$src1:$pred:14:y)<<P:Predicate_anonymous_20279>>)<<P:14:Predicate_anonymous_20278>>  =>  (EXTRACT_SUBREG:{ *:[i32] } (V_MAD_U64_U32_gfx11_e64:{ *:[i64] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, ?:{ *:[i32] }:$src2, sub0:{ *:[i32] }, (IMPLICIT_DEF:{ *:[i32] }), sub1:{ *:[i32] }), 0:{ *:[i1] }), sub0:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src2
        GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/3,
        GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/11,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U64_U32_gfx11_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_AddImm8, /*InsnID*/1, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AMDGPU::sub0),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        // GIR_Coverage, 8240,
        GIR_EraseRootFromParent_Done,
      // Label 266: @35384
      GIM_Try, /*On fail goto*//*Label 267*/ GIMT_Encode4(35449), // Rule ID 2490 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:3:x
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:3:y
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:3:z
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_20249),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (add:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:3:x, i32:{ *:[i32] }:$src1:$pred:3:y)<<P:Predicate_anonymous_20247>>, i32:{ *:[i32] }:$src2:$pred:3:z)<<P:3:Predicate_anonymous_20249>>  =>  (V_ADD3_U32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_ADD3_U32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2490,
        GIR_EraseRootFromParent_Done,
      // Label 267: @35449
      GIM_Try, /*On fail goto*//*Label 268*/ GIMT_Encode4(35614), // Rule ID 2509 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNotMADIntraFwdBug_isGFX9Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:11:x
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:11:y
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:11:z
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_20278),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (mul:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:11:x, i32:{ *:[i32] }:$src1:$pred:11:y)<<P:Predicate_anonymous_20279>>, VGPR_32:{ *:[i32] }:$src2:$pred:11:z)<<P:11:Predicate_anonymous_20278>>  =>  (EXTRACT_SUBREG:{ *:[i32] } (V_MAD_U64_U32_e64:{ *:[i64] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, ?:{ *:[i32] }:$src2, sub0:{ *:[i32] }, (IMPLICIT_DEF:{ *:[i32] }), sub1:{ *:[i32] }), 0:{ *:[i1] }), sub0:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/3,
        GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/11,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U64_U32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_AddImm8, /*InsnID*/1, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AMDGPU::sub0),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        // GIR_Coverage, 2509,
        GIR_EraseRootFromParent_Done,
      // Label 268: @35614
      GIM_Try, /*On fail goto*//*Label 269*/ GIMT_Encode4(35779), // Rule ID 2514 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMADIntraFwdBug_isGFX11Only),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:14:x
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:14:y
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:14:z
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_20278),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (mul:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:14:x, i32:{ *:[i32] }:$src1:$pred:14:y)<<P:Predicate_anonymous_20279>>, VGPR_32:{ *:[i32] }:$src2:$pred:14:z)<<P:14:Predicate_anonymous_20278>>  =>  (EXTRACT_SUBREG:{ *:[i32] } (V_MAD_U64_U32_gfx11_e64:{ *:[i64] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, ?:{ *:[i32] }:$src2, sub0:{ *:[i32] }, (IMPLICIT_DEF:{ *:[i32] }), sub1:{ *:[i32] }), 0:{ *:[i1] }), sub0:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/3,
        GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/11,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U64_U32_gfx11_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_AddImm8, /*InsnID*/1, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AMDGPU::sub0),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        // GIR_Coverage, 2514,
        GIR_EraseRootFromParent_Done,
      // Label 269: @35779
      GIM_Try, /*On fail goto*//*Label 270*/ GIMT_Encode4(35940), // Rule ID 2508 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNotMADIntraFwdBug_isGFX9Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:10:x
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:10:y
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:10:z
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_20278),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (mul:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:10:x, i32:{ *:[i32] }:$src1:$pred:10:y)<<P:Predicate_anonymous_20279>>, i32:{ *:[i32] }:$src2:$pred:10:z)<<P:10:Predicate_anonymous_20278>>  =>  (EXTRACT_SUBREG:{ *:[i32] } (V_MAD_U64_U32_e64:{ *:[i64] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, (REG_SEQUENCE:{ *:[i64] } SReg_64:{ *:[i32] }, ?:{ *:[i32] }:$src2, sub0:{ *:[i32] }, (IMPLICIT_DEF:{ *:[i32] }), sub1:{ *:[i32] }), 0:{ *:[i1] }), sub0:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/3,
        GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/11,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AMDGPU::SReg_32_XEXEC_HI_and_SReg_32_XM0RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/3, GIMT_Encode2(AMDGPU::SReg_32_XM0RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U64_U32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_AddImm8, /*InsnID*/1, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AMDGPU::sub0),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        // GIR_Coverage, 2508,
        GIR_EraseRootFromParent_Done,
      // Label 270: @35940
      GIM_Try, /*On fail goto*//*Label 271*/ GIMT_Encode4(36101), // Rule ID 2513 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMADIntraFwdBug_isGFX11Only),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:13:x
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:13:y
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:13:z
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_20278),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (mul:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:13:x, i32:{ *:[i32] }:$src1:$pred:13:y)<<P:Predicate_anonymous_20279>>, i32:{ *:[i32] }:$src2:$pred:13:z)<<P:13:Predicate_anonymous_20278>>  =>  (EXTRACT_SUBREG:{ *:[i32] } (V_MAD_U64_U32_gfx11_e64:{ *:[i64] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, (REG_SEQUENCE:{ *:[i64] } SReg_64:{ *:[i32] }, ?:{ *:[i32] }:$src2, sub0:{ *:[i32] }, (IMPLICIT_DEF:{ *:[i32] }), sub1:{ *:[i32] }), 0:{ *:[i1] }), sub0:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/3,
        GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/11,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AMDGPU::SReg_32_XEXEC_HI_and_SReg_32_XM0RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/3, GIMT_Encode2(AMDGPU::SReg_32_XM0RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U64_U32_gfx11_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_AddImm8, /*InsnID*/1, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AMDGPU::sub0),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        // GIR_Coverage, 2513,
        GIR_EraseRootFromParent_Done,
      // Label 271: @36101
      GIM_Try, /*On fail goto*//*Label 272*/ GIMT_Encode4(36166), // Rule ID 2486 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:1:x
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:1:y
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:1:z
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_20243),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (shl:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:1:x, i32:{ *:[i32] }:$src1:$pred:1:y)<<P:Predicate_anonymous_20244>>, i32:{ *:[i32] }:$src2:$pred:1:z)<<P:1:Predicate_anonymous_20243>>  =>  (V_LSHL_ADD_U32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_LSHL_ADD_U32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2486,
        GIR_EraseRootFromParent_Done,
      // Label 272: @36166
      GIM_Try, /*On fail goto*//*Label 273*/ GIMT_Encode4(36231), // Rule ID 2496 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:8:x
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:8:y
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:8:z
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_20262),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:8:x, i32:{ *:[i32] }:$src1:$pred:8:y)<<P:Predicate_anonymous_20263>>, i32:{ *:[i32] }:$src2:$pred:8:z)<<P:8:Predicate_anonymous_20262>>  =>  (V_XAD_U32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_XAD_U32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2496,
        GIR_EraseRootFromParent_Done,
      // Label 273: @36231
      GIM_Try, /*On fail goto*//*Label 274*/ GIMT_Encode4(36271), // Rule ID 6825 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CTPOP),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_33573),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (ctpop:{ *:[i32] } i32:{ *:[i32] }:$popcnt)<<P:Predicate_anonymous_33573>>, i32:{ *:[i32] }:$val)  =>  (V_BCNT_U32_B32_e64:{ *:[i32] } ?:{ *:[i32] }:$popcnt, ?:{ *:[i32] }:$val)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BCNT_U32_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // popcnt
        GIR_RootToRootCopy, /*OpIdx*/2, // val
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 6825,
        GIR_EraseRootFromParent_Done,
      // Label 274: @36271
      GIM_Try, /*On fail goto*//*Label 275*/ GIMT_Encode4(36336), // Rule ID 8227 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:3:z
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:3:x
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:3:y
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_20249),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } i32:{ *:[i32] }:$src2:$pred:3:z, (add:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:3:x, i32:{ *:[i32] }:$src1:$pred:3:y)<<P:Predicate_anonymous_20247>>)<<P:3:Predicate_anonymous_20249>>  =>  (V_ADD3_U32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_ADD3_U32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/1, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8227,
        GIR_EraseRootFromParent_Done,
      // Label 275: @36336
      GIM_Try, /*On fail goto*//*Label 276*/ GIMT_Encode4(36497), // Rule ID 8235 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNotMADIntraFwdBug_isGFX9Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:10:z
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:10:x
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:10:y
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_20278),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } i32:{ *:[i32] }:$src2:$pred:10:z, (mul:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:10:x, i32:{ *:[i32] }:$src1:$pred:10:y)<<P:Predicate_anonymous_20279>>)<<P:10:Predicate_anonymous_20278>>  =>  (EXTRACT_SUBREG:{ *:[i32] } (V_MAD_U64_U32_e64:{ *:[i64] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, (REG_SEQUENCE:{ *:[i64] } SReg_64:{ *:[i32] }, ?:{ *:[i32] }:$src2, sub0:{ *:[i32] }, (IMPLICIT_DEF:{ *:[i32] }), sub1:{ *:[i32] }), 0:{ *:[i1] }), sub0:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src2
        GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/3,
        GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/11,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AMDGPU::SReg_32_XEXEC_HI_and_SReg_32_XM0RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/3, GIMT_Encode2(AMDGPU::SReg_32_XM0RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U64_U32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_AddImm8, /*InsnID*/1, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AMDGPU::sub0),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        // GIR_Coverage, 8235,
        GIR_EraseRootFromParent_Done,
      // Label 276: @36497
      GIM_Try, /*On fail goto*//*Label 277*/ GIMT_Encode4(36658), // Rule ID 8239 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMADIntraFwdBug_isGFX11Only),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:13:z
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:13:x
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:13:y
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_20278),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } i32:{ *:[i32] }:$src2:$pred:13:z, (mul:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:13:x, i32:{ *:[i32] }:$src1:$pred:13:y)<<P:Predicate_anonymous_20279>>)<<P:13:Predicate_anonymous_20278>>  =>  (EXTRACT_SUBREG:{ *:[i32] } (V_MAD_U64_U32_gfx11_e64:{ *:[i64] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, (REG_SEQUENCE:{ *:[i64] } SReg_64:{ *:[i32] }, ?:{ *:[i32] }:$src2, sub0:{ *:[i32] }, (IMPLICIT_DEF:{ *:[i32] }), sub1:{ *:[i32] }), 0:{ *:[i1] }), sub0:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src2
        GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/3,
        GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/11,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AMDGPU::SReg_32_XEXEC_HI_and_SReg_32_XM0RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/3, GIMT_Encode2(AMDGPU::SReg_32_XM0RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U64_U32_gfx11_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_AddImm8, /*InsnID*/1, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AMDGPU::sub0),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        // GIR_Coverage, 8239,
        GIR_EraseRootFromParent_Done,
      // Label 277: @36658
      GIM_Try, /*On fail goto*//*Label 278*/ GIMT_Encode4(36723), // Rule ID 8225 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:1:z
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:1:x
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:1:y
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_20243),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } i32:{ *:[i32] }:$src2:$pred:1:z, (shl:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:1:x, i32:{ *:[i32] }:$src1:$pred:1:y)<<P:Predicate_anonymous_20244>>)<<P:1:Predicate_anonymous_20243>>  =>  (V_LSHL_ADD_U32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_LSHL_ADD_U32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/1, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8225,
        GIR_EraseRootFromParent_Done,
      // Label 278: @36723
      GIM_Try, /*On fail goto*//*Label 279*/ GIMT_Encode4(36788), // Rule ID 8232 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:8:z
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:8:x
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:8:y
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_20262),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } i32:{ *:[i32] }:$src2:$pred:8:z, (xor:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:8:x, i32:{ *:[i32] }:$src1:$pred:8:y)<<P:Predicate_anonymous_20263>>)<<P:8:Predicate_anonymous_20262>>  =>  (V_XAD_U32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_XAD_U32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/1, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8232,
        GIR_EraseRootFromParent_Done,
      // Label 279: @36788
      GIM_Try, /*On fail goto*//*Label 280*/ GIMT_Encode4(36828), // Rule ID 10884 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CTPOP),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_33573),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } i32:{ *:[i32] }:$val, (ctpop:{ *:[i32] } i32:{ *:[i32] }:$popcnt)<<P:Predicate_anonymous_33573>>)  =>  (V_BCNT_U32_B32_e64:{ *:[i32] } ?:{ *:[i32] }:$popcnt, ?:{ *:[i32] }:$val)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BCNT_U32_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // popcnt
        GIR_RootToRootCopy, /*OpIdx*/1, // val
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 10884,
        GIR_EraseRootFromParent_Done,
      // Label 280: @36828
      GIM_Try, /*On fail goto*//*Label 281*/ GIMT_Encode4(36872), // Rule ID 7340 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_NegSubInlineConst32),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_13397),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } i32:{ *:[i32] }:$src0, (imm:{ *:[i32] })<<P:Predicate_NegSubInlineConst32>><<X:NegateImm>>:$src1)<<P:Predicate_anonymous_13397>>  =>  (S_SUB_I32:{ *:[i32] }:{ *:[i1] } SReg_32:{ *:[i32] }:$src0, (NegateImm:{ *:[i1 i16 i32 bf16 f16 f32 v2i16 v2f16 v2bf16] } (imm:{ *:[i32] })<<P:Predicate_NegSubInlineConst32>>:$src1))
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_SUB_I32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderNegateImm), // src1
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 7340,
        GIR_EraseRootFromParent_Done,
      // Label 281: @36872
      GIM_Try, /*On fail goto*//*Label 282*/ GIMT_Encode4(36919), // Rule ID 7341 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAddNoCarryInsts),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_NegSubInlineConst32),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_19207),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } i32:{ *:[i32] }:$src0, (imm:{ *:[i32] })<<P:Predicate_NegSubInlineConst32>><<X:NegateImm>>:$src1)<<P:Predicate_anonymous_19207>>  =>  (V_SUB_U32_e64:{ *:[i32] } VS_32:{ *:[i32] }:$src0, (NegateImm:{ *:[i16 i32 bf16 f16 f32 v2i16 v2f16 v2bf16] } (imm:{ *:[i32] })<<P:Predicate_NegSubInlineConst32>>:$src1))
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SUB_U32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderNegateImm), // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 7341,
        GIR_EraseRootFromParent_Done,
      // Label 282: @36919
      GIM_Try, /*On fail goto*//*Label 283*/ GIMT_Encode4(36974), // Rule ID 7342 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotHasAddNoCarryInsts),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_NegSubInlineConst32),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_19207),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } i32:{ *:[i32] }:$src0, (imm:{ *:[i32] })<<P:Predicate_NegSubInlineConst32>><<X:NegateImm>>:$src1)<<P:Predicate_anonymous_19207>>  =>  (V_SUB_CO_U32_e64:{ *:[i32] }:{ *:[i1] } VS_32:{ *:[i32] }:$src0, (NegateImm:{ *:[i16 i32 bf16 f16 f32 v2i16 v2f16 v2bf16] } (imm:{ *:[i32] })<<P:Predicate_NegSubInlineConst32>>:$src1))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SUB_CO_U32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderNegateImm), // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 7342,
        GIR_EraseRootFromParent_Done,
      // Label 283: @36974
      GIM_Try, /*On fail goto*//*Label 284*/ GIMT_Encode4(37008), // Rule ID 43 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_13397),
        // (add:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)<<P:Predicate_anonymous_13397>>  =>  (S_ADD_I32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_ADD_I32),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 43,
        GIR_Done,
      // Label 284: @37008
      GIM_Try, /*On fail goto*//*Label 285*/ GIMT_Encode4(37038), // Rule ID 2391 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAddNoCarryInsts),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_19207),
        // (add:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)<<P:Predicate_anonymous_19207>>  =>  (V_ADD_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, 0:{ *:[i1] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_ADD_U32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2391,
        GIR_EraseRootFromParent_Done,
      // Label 285: @37038
      GIM_Try, /*On fail goto*//*Label 286*/ GIMT_Encode4(37076), // Rule ID 2393 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX6GFX7GFX8GFX9),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_19207),
        // (add:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)<<P:Predicate_anonymous_19207>>  =>  (V_ADD_CO_U32_e64:{ *:[i32] }:{ *:[i1] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, 0:{ *:[i1] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_ADD_CO_U32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2393,
        GIR_EraseRootFromParent_Done,
      // Label 286: @37076
      GIM_Try, /*On fail goto*//*Label 287*/ GIMT_Encode4(37112), // Rule ID 818 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CTPOP),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (ctpop:{ *:[i32] } i32:{ *:[i32] }:$src0), i32:{ *:[i32] }:$src1)  =>  (V_BCNT_U32_B32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BCNT_U32_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 818,
        GIR_EraseRootFromParent_Done,
      // Label 287: @37112
      GIM_Try, /*On fail goto*//*Label 288*/ GIMT_Encode4(37148), // Rule ID 8158 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CTPOP),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } i32:{ *:[i32] }:$src1, (ctpop:{ *:[i32] } i32:{ *:[i32] }:$src0))  =>  (V_BCNT_U32_B32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BCNT_U32_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8158,
        GIR_EraseRootFromParent_Done,
      // Label 288: @37148
      GIM_Reject,
    // Label 198: @37149
    GIM_Reject,
    // Label 171: @37150
    GIM_Try, /*On fail goto*//*Label 289*/ GIMT_Encode4(37620),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 290*/ GIMT_Encode4(37227), // Rule ID 2511 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNotMADIntraFwdBug_isGFX9Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } (intrinsic_wo_chain:{ *:[i64] } 3059:{ *:[iPTR] }, i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1), i64:{ *:[i64] }:$src2)  =>  (V_MAD_U64_U32_e64:{ *:[i64] }:{ *:[i1] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i64] }:$src2, 0:{ *:[i1] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U64_U32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2511,
        GIR_EraseRootFromParent_Done,
      // Label 290: @37227
      GIM_Try, /*On fail goto*//*Label 291*/ GIMT_Encode4(37293), // Rule ID 2516 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMADIntraFwdBug_isGFX11Only),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } (intrinsic_wo_chain:{ *:[i64] } 3059:{ *:[iPTR] }, i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1), i64:{ *:[i64] }:$src2)  =>  (V_MAD_U64_U32_gfx11_e64:{ *:[i64] }:{ *:[i1] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i64] }:$src2, 0:{ *:[i1] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U64_U32_gfx11_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2516,
        GIR_EraseRootFromParent_Done,
      // Label 291: @37293
      GIM_Try, /*On fail goto*//*Label 292*/ GIMT_Encode4(37359), // Rule ID 8237 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNotMADIntraFwdBug_isGFX9Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } i64:{ *:[i64] }:$src2, (intrinsic_wo_chain:{ *:[i64] } 3059:{ *:[iPTR] }, i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1))  =>  (V_MAD_U64_U32_e64:{ *:[i64] }:{ *:[i1] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i64] }:$src2, 0:{ *:[i1] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U64_U32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // src1
        GIR_RootToRootCopy, /*OpIdx*/1, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8237,
        GIR_EraseRootFromParent_Done,
      // Label 292: @37359
      GIM_Try, /*On fail goto*//*Label 293*/ GIMT_Encode4(37425), // Rule ID 8241 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMADIntraFwdBug_isGFX11Only),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } i64:{ *:[i64] }:$src2, (intrinsic_wo_chain:{ *:[i64] } 3059:{ *:[iPTR] }, i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1))  =>  (V_MAD_U64_U32_gfx11_e64:{ *:[i64] }:{ *:[i1] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i64] }:$src2, 0:{ *:[i1] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U64_U32_gfx11_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // src1
        GIR_RootToRootCopy, /*OpIdx*/1, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8241,
        GIR_EraseRootFromParent_Done,
      // Label 293: @37425
      GIM_Try, /*On fail goto*//*Label 294*/ GIMT_Encode4(37494), // Rule ID 2498 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX940Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:9:x
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:9:y
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_shl_0_to_4),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:9:z
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_20266),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } (shl:{ *:[i64] } i64:{ *:[i64] }:$src0:$pred:9:x, i32:{ *:[i32] }:$src1:$pred:9:y)<<P:Predicate_shl_0_to_4>><<P:Predicate_anonymous_20267>>, i64:{ *:[i64] }:$src2:$pred:9:z)<<P:9:Predicate_anonymous_20266>>  =>  (V_LSHL_ADD_U64_e64:{ *:[i64] } VSrc_b64:{ *:[i64] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b64:{ *:[i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_LSHL_ADD_U64_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2498,
        GIR_EraseRootFromParent_Done,
      // Label 294: @37494
      GIM_Try, /*On fail goto*//*Label 295*/ GIMT_Encode4(37563), // Rule ID 8233 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX940Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:9:z
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:9:x
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:9:y
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_shl_0_to_4),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_20266),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } i64:{ *:[i64] }:$src2:$pred:9:z, (shl:{ *:[i64] } i64:{ *:[i64] }:$src0:$pred:9:x, i32:{ *:[i32] }:$src1:$pred:9:y)<<P:Predicate_shl_0_to_4>><<P:Predicate_anonymous_20267>>)<<P:9:Predicate_anonymous_20266>>  =>  (V_LSHL_ADD_U64_e64:{ *:[i64] } VSrc_b64:{ *:[i64] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b64:{ *:[i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_LSHL_ADD_U64_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/1, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8233,
        GIR_EraseRootFromParent_Done,
      // Label 295: @37563
      GIM_Try, /*On fail goto*//*Label 296*/ GIMT_Encode4(37593), // Rule ID 1336 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_19207),
        // (add:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)<<P:Predicate_anonymous_19207>>  =>  (V_ADD_U64_PSEUDO:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_ADD_U64_PSEUDO),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::VCC), GIMT_Encode2(RegState::Dead),
        GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1336,
        GIR_Done,
      // Label 296: @37593
      GIM_Try, /*On fail goto*//*Label 297*/ GIMT_Encode4(37619), // Rule ID 1338 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_13397),
        // (add:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)<<P:Predicate_anonymous_13397>>  =>  (S_ADD_U64_PSEUDO:{ *:[i64] }:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_ADD_U64_PSEUDO),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1338,
        GIR_Done,
      // Label 297: @37619
      GIM_Reject,
    // Label 289: @37620
    GIM_Reject,
    // Label 172: @37621
    GIM_Try, /*On fail goto*//*Label 298*/ GIMT_Encode4(37890),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
      GIM_Try, /*On fail goto*//*Label 299*/ GIMT_Encode4(37732), // Rule ID 8208 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3pmods),
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3pmods),
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(2), GIMT_Encode2(GICP_gi_vop3pmods),
        // (add:{ *:[v2i16] } (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src2, i32:{ *:[i32] }:$src2_modifiers), (mul:{ *:[v2i16] } (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers)))  =>  (V_PK_MAD_U16:{ *:[v2i16] } i32:{ *:[i32] }:$src0_modifiers, v2i16:{ *:[v2i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, v2i16:{ *:[v2i16] }:$src1, i32:{ *:[i32] }:$src2_modifiers, v2i16:{ *:[v2i16] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_PK_MAD_U16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src0_modifiers
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src0
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(2), /*SubOperand*/1, // src1_modifiers
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(2), /*SubOperand*/0, // src1
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src2_modifiers
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8208,
        GIR_EraseRootFromParent_Done,
      // Label 299: @37732
      GIM_Try, /*On fail goto*//*Label 300*/ GIMT_Encode4(37828), // Rule ID 1087 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(2), GIMT_Encode2(GICP_gi_vop3pmods),
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3pmods),
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3pmods),
        // (add:{ *:[v2i16] } (mul:{ *:[v2i16] } (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers)), (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src2, i32:{ *:[i32] }:$src2_modifiers))  =>  (V_PK_MAD_U16:{ *:[v2i16] } i32:{ *:[i32] }:$src0_modifiers, v2i16:{ *:[v2i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, v2i16:{ *:[v2i16] }:$src1, i32:{ *:[i32] }:$src2_modifiers, v2i16:{ *:[v2i16] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_PK_MAD_U16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(2), /*SubOperand*/1, // src2_modifiers
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(2), /*SubOperand*/0, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1087,
        GIR_EraseRootFromParent_Done,
      // Label 300: @37828
      GIM_Try, /*On fail goto*//*Label 301*/ GIMT_Encode4(37889), // Rule ID 1098 //
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3pmods),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3pmods),
        // (add:{ *:[v2i16] } (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers))  =>  (V_PK_ADD_U16:{ *:[v2i16] } i32:{ *:[i32] }:$src0_modifiers, v2i16:{ *:[v2i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, v2i16:{ *:[v2i16] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_PK_ADD_U16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1098,
        GIR_EraseRootFromParent_Done,
      // Label 301: @37889
      GIM_Reject,
    // Label 298: @37890
    GIM_Reject,
    // Label 173: @37891
    GIM_Reject,
    // Label 1: @37892
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(7), GIMT_Encode2(12), /*)*//*default:*//*Label 307*/ GIMT_Encode4(38514),
    /*GILLT_s1*//*Label 302*/ GIMT_Encode4(37923),
    /*GILLT_s16*//*Label 303*/ GIMT_Encode4(38042),
    /*GILLT_s32*//*Label 304*/ GIMT_Encode4(38258),
    /*GILLT_s64*//*Label 305*/ GIMT_Encode4(38373),
    /*GILLT_v2s16*//*Label 306*/ GIMT_Encode4(38442),
    // Label 302: @37923
    GIM_Try, /*On fail goto*//*Label 308*/ GIMT_Encode4(38041),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s1,
      GIM_Try, /*On fail goto*//*Label 309*/ GIMT_Encode4(37962), // Rule ID 7212 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isWave64),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (sub:{ *:[i1] } i1:{ *:[i1] }:$src0, -1:{ *:[i1] })  =>  (S_NOT_B64:{ *:[i1] }:{ *:[i1] } ?:{ *:[i1] }:$src0)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_NOT_B64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 7212,
        GIR_EraseRootFromParent_Done,
      // Label 309: @37962
      GIM_Try, /*On fail goto*//*Label 310*/ GIMT_Encode4(37990), // Rule ID 7219 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isWave32),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (sub:{ *:[i1] } i1:{ *:[i1] }:$src0, -1:{ *:[i1] })  =>  (S_NOT_B32:{ *:[i1] }:{ *:[i1] } ?:{ *:[i1] }:$src0)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_NOT_B32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 7219,
        GIR_EraseRootFromParent_Done,
      // Label 310: @37990
      GIM_Try, /*On fail goto*//*Label 311*/ GIMT_Encode4(38015), // Rule ID 7210 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isWave64),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
        // (sub:{ *:[i1] } i1:{ *:[i1] }:$src0, i1:{ *:[i1] }:$src1)  =>  (S_XOR_B64:{ *:[i1] }:{ *:[i1] } ?:{ *:[i1] }:$src0, ?:{ *:[i1] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_XOR_B64),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 7210,
        GIR_Done,
      // Label 311: @38015
      GIM_Try, /*On fail goto*//*Label 312*/ GIMT_Encode4(38040), // Rule ID 7217 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isWave32),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        // (sub:{ *:[i1] } i1:{ *:[i1] }:$src0, i1:{ *:[i1] }:$src1)  =>  (S_XOR_B32:{ *:[i1] }:{ *:[i1] } ?:{ *:[i1] }:$src0, ?:{ *:[i1] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_XOR_B32),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 7217,
        GIR_Done,
      // Label 312: @38040
      GIM_Reject,
    // Label 308: @38041
    GIM_Reject,
    // Label 303: @38042
    GIM_Try, /*On fail goto*//*Label 313*/ GIMT_Encode4(38257),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s16,
      GIM_Try, /*On fail goto*//*Label 314*/ GIMT_Encode4(38112), // Rule ID 1069 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotHasTrue16BitInsts_isGFX10Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3opselmods),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3opselmods),
        // (sub:{ *:[i16] } (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers))  =>  (V_SUB_NC_U16_e64:{ *:[i16] } i32:{ *:[i32] }:$src0_modifiers, i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, i16:{ *:[i16] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SUB_NC_U16_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1069,
        GIR_EraseRootFromParent_Done,
      // Label 314: @38112
      GIM_Try, /*On fail goto*//*Label 315*/ GIMT_Encode4(38171), // Rule ID 1070 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseRealTrue16Insts_isGFX10Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_16RegClassID),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3opselmods),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3opselmods),
        // (sub:{ *:[i16] } (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers))  =>  (V_SUB_NC_U16_t16_e64:{ *:[i16] } i32:{ *:[i32] }:$src0_modifiers, i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, i16:{ *:[i16] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SUB_NC_U16_t16_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1070,
        GIR_EraseRootFromParent_Done,
      // Label 315: @38171
      GIM_Try, /*On fail goto*//*Label 316*/ GIMT_Encode4(38230), // Rule ID 1071 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseFakeTrue16Insts_isGFX10Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3opselmods),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3opselmods),
        // (sub:{ *:[i16] } (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers))  =>  (V_SUB_NC_U16_fake16_e64:{ *:[i16] } i32:{ *:[i32] }:$src0_modifiers, i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, i16:{ *:[i16] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SUB_NC_U16_fake16_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1071,
        GIR_EraseRootFromParent_Done,
      // Label 316: @38230
      GIM_Try, /*On fail goto*//*Label 317*/ GIMT_Encode4(38256), // Rule ID 911 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX8GFX9),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // (sub:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_SUB_U16_e64:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SUB_U16_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 911,
        GIR_EraseRootFromParent_Done,
      // Label 317: @38256
      GIM_Reject,
    // Label 313: @38257
    GIM_Reject,
    // Label 304: @38258
    GIM_Try, /*On fail goto*//*Label 318*/ GIMT_Encode4(38372),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 319*/ GIMT_Encode4(38303), // Rule ID 44 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_13398),
        // (sub:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)<<P:Predicate_anonymous_13398>>  =>  (S_SUB_I32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_SUB_I32),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 44,
        GIR_Done,
      // Label 319: @38303
      GIM_Try, /*On fail goto*//*Label 320*/ GIMT_Encode4(38333), // Rule ID 2392 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAddNoCarryInsts),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_19209),
        // (sub:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)<<P:Predicate_anonymous_19209>>  =>  (V_SUB_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, 0:{ *:[i1] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SUB_U32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2392,
        GIR_EraseRootFromParent_Done,
      // Label 320: @38333
      GIM_Try, /*On fail goto*//*Label 321*/ GIMT_Encode4(38371), // Rule ID 2394 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX6GFX7GFX8GFX9),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_19209),
        // (sub:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)<<P:Predicate_anonymous_19209>>  =>  (V_SUB_CO_U32_e64:{ *:[i32] }:{ *:[i1] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, 0:{ *:[i1] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SUB_CO_U32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2394,
        GIR_EraseRootFromParent_Done,
      // Label 321: @38371
      GIM_Reject,
    // Label 318: @38372
    GIM_Reject,
    // Label 305: @38373
    GIM_Try, /*On fail goto*//*Label 322*/ GIMT_Encode4(38441),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 323*/ GIMT_Encode4(38414), // Rule ID 1337 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_19209),
        // (sub:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)<<P:Predicate_anonymous_19209>>  =>  (V_SUB_U64_PSEUDO:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_SUB_U64_PSEUDO),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::VCC), GIMT_Encode2(RegState::Dead),
        GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1337,
        GIR_Done,
      // Label 323: @38414
      GIM_Try, /*On fail goto*//*Label 324*/ GIMT_Encode4(38440), // Rule ID 1339 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_13398),
        // (sub:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)<<P:Predicate_anonymous_13398>>  =>  (S_SUB_U64_PSEUDO:{ *:[i64] }:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_SUB_U64_PSEUDO),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1339,
        GIR_Done,
      // Label 324: @38440
      GIM_Reject,
    // Label 322: @38441
    GIM_Reject,
    // Label 306: @38442
    GIM_Try, /*On fail goto*//*Label 325*/ GIMT_Encode4(38513), // Rule ID 1106 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3pmods),
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3pmods),
      // (sub:{ *:[v2i16] } (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers))  =>  (V_PK_SUB_I16:{ *:[v2i16] } i32:{ *:[i32] }:$src0_modifiers, v2i16:{ *:[v2i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, v2i16:{ *:[v2i16] }:$src1)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_PK_SUB_I16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1106,
      GIR_EraseRootFromParent_Done,
    // Label 325: @38513
    GIM_Reject,
    // Label 307: @38514
    GIM_Reject,
    // Label 2: @38515
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(8), GIMT_Encode2(12), /*)*//*default:*//*Label 330*/ GIMT_Encode4(38860),
    /*GILLT_s16*//*Label 326*/ GIMT_Encode4(38542),
    /*GILLT_s32*//*Label 327*/ GIMT_Encode4(38657),
    /*GILLT_s64*//*Label 328*/ GIMT_Encode4(38758),
    /*GILLT_v2s16*//*Label 329*/ GIMT_Encode4(38788),
    // Label 326: @38542
    GIM_Try, /*On fail goto*//*Label 331*/ GIMT_Encode4(38656),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s16,
      GIM_Try, /*On fail goto*//*Label 332*/ GIMT_Encode4(38609), // Rule ID 878 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseRealTrue16Insts),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_16RegClassID),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3opselmods),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3opselmods),
        // (mul:{ *:[i16] } (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers))  =>  (V_MUL_LO_U16_t16_e64:{ *:[i16] } i32:{ *:[i32] }:$src0_modifiers, i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, i16:{ *:[i16] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MUL_LO_U16_t16_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 878,
        GIR_EraseRootFromParent_Done,
      // Label 332: @38609
      GIM_Try, /*On fail goto*//*Label 333*/ GIMT_Encode4(38632), // Rule ID 877 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_Has16BitInsts_NotHasTrue16BitInsts),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // (mul:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_MUL_LO_U16_e64:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_MUL_LO_U16_e64),
        GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 877,
        GIR_Done,
      // Label 333: @38632
      GIM_Try, /*On fail goto*//*Label 334*/ GIMT_Encode4(38655), // Rule ID 879 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseFakeTrue16Insts),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // (mul:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_MUL_LO_U16_fake16_e64:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_MUL_LO_U16_fake16_e64),
        GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 879,
        GIR_Done,
      // Label 334: @38655
      GIM_Reject,
    // Label 331: @38656
    GIM_Reject,
    // Label 327: @38657
    GIM_Try, /*On fail goto*//*Label 335*/ GIMT_Encode4(38757),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 336*/ GIMT_Encode4(38688), // Rule ID 81 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_13405),
        // (mul:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)<<P:Predicate_anonymous_13405>>  =>  (S_MUL_I32:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_MUL_I32),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 81,
        GIR_Done,
      // Label 336: @38688
      GIM_Try, /*On fail goto*//*Label 337*/ GIMT_Encode4(38722), // Rule ID 939 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_19699),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3mods0),
        // (mul:{ *:[i32] } (VOP3Mods0:{ *:[i32] } i32:{ *:[i32] }:$src0), i32:{ *:[i32] }:$src1)<<P:Predicate_anonymous_19699>>  =>  (V_MUL_LO_U32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MUL_LO_U32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 939,
        GIR_EraseRootFromParent_Done,
      // Label 337: @38722
      GIM_Try, /*On fail goto*//*Label 338*/ GIMT_Encode4(38756), // Rule ID 8198 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_19699),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3mods0),
        // (mul:{ *:[i32] } i32:{ *:[i32] }:$src1, (VOP3Mods0:{ *:[i32] } i32:{ *:[i32] }:$src0))<<P:Predicate_anonymous_19699>>  =>  (V_MUL_LO_U32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MUL_LO_U32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8198,
        GIR_EraseRootFromParent_Done,
      // Label 338: @38756
      GIM_Reject,
    // Label 335: @38757
    GIM_Reject,
    // Label 328: @38758
    GIM_Try, /*On fail goto*//*Label 339*/ GIMT_Encode4(38787), // Rule ID 51 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX12Plus),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_13405),
      // (mul:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)<<P:Predicate_anonymous_13405>>  =>  (S_MUL_U64:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_MUL_U64),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 51,
      GIR_Done,
    // Label 339: @38787
    GIM_Reject,
    // Label 329: @38788
    GIM_Try, /*On fail goto*//*Label 340*/ GIMT_Encode4(38859), // Rule ID 1099 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3pmods),
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3pmods),
      // (mul:{ *:[v2i16] } (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers))  =>  (V_PK_MUL_LO_U16:{ *:[v2i16] } i32:{ *:[i32] }:$src0_modifiers, v2i16:{ *:[v2i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, v2i16:{ *:[v2i16] }:$src1)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_PK_MUL_LO_U16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1099,
      GIR_EraseRootFromParent_Done,
    // Label 340: @38859
    GIM_Reject,
    // Label 330: @38860
    GIM_Reject,
    // Label 3: @38861
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(7), GIMT_Encode2(17), /*)*//*default:*//*Label 348*/ GIMT_Encode4(40261),
    /*GILLT_s1*//*Label 341*/ GIMT_Encode4(38912),
    /*GILLT_s16*//*Label 342*/ GIMT_Encode4(38975),
    /*GILLT_s32*//*Label 343*/ GIMT_Encode4(39215),
    /*GILLT_s64*//*Label 344*/ GIMT_Encode4(39739),
    /*GILLT_v2s16*//*Label 345*/ GIMT_Encode4(39864),
    /*GILLT_v2s32*//*Label 346*/ GIMT_Encode4(40015), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v4s16*//*Label 347*/ GIMT_Encode4(40138),
    // Label 341: @38912
    GIM_Try, /*On fail goto*//*Label 349*/ GIMT_Encode4(38974),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s1,
      GIM_Try, /*On fail goto*//*Label 350*/ GIMT_Encode4(38948), // Rule ID 7206 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isWave64),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
        // (and:{ *:[i1] } i1:{ *:[i1] }:$src0, i1:{ *:[i1] }:$src1)  =>  (S_AND_B64:{ *:[i1] }:{ *:[i1] } ?:{ *:[i1] }:$src0, ?:{ *:[i1] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_AND_B64),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 7206,
        GIR_Done,
      // Label 350: @38948
      GIM_Try, /*On fail goto*//*Label 351*/ GIMT_Encode4(38973), // Rule ID 7213 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isWave32),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        // (and:{ *:[i1] } i1:{ *:[i1] }:$src0, i1:{ *:[i1] }:$src1)  =>  (S_AND_B32:{ *:[i1] }:{ *:[i1] } ?:{ *:[i1] }:$src0, ?:{ *:[i1] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_AND_B32),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 7213,
        GIR_Done,
      // Label 351: @38973
      GIM_Reject,
    // Label 349: @38974
    GIM_Reject,
    // Label 342: @38975
    GIM_Try, /*On fail goto*//*Label 352*/ GIMT_Encode4(39214),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s16,
      GIM_Try, /*On fail goto*//*Label 353*/ GIMT_Encode4(39037), // Rule ID 8210 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_13406),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i16] } (xor:{ *:[i16] } i16:{ *:[i16] }:$src1, -1:{ *:[i16] }), i16:{ *:[i16] }:$src0)<<P:Predicate_anonymous_13406>>  =>  (S_ANDN2_B32:{ *:[i16] }:{ *:[i1] } SSrc_b32:{ *:[i16] }:$src0, SSrc_b32:{ *:[i16] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ANDN2_B32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8210,
        GIR_EraseRootFromParent_Done,
      // Label 353: @39037
      GIM_Try, /*On fail goto*//*Label 354*/ GIMT_Encode4(39088), // Rule ID 1880 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_13406),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i16] } i16:{ *:[i16] }:$src0, (xor:{ *:[i16] } i16:{ *:[i16] }:$src1, -1:{ *:[i16] }))<<P:Predicate_anonymous_13406>>  =>  (S_ANDN2_B32:{ *:[i16] }:{ *:[i1] } SSrc_b32:{ *:[i16] }:$src0, SSrc_b32:{ *:[i16] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ANDN2_B32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1880,
        GIR_EraseRootFromParent_Done,
      // Label 354: @39088
      GIM_Try, /*On fail goto*//*Label 355*/ GIMT_Encode4(39111), // Rule ID 2421 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotHasTrue16BitInsts),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // (and:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_AND_B32_e64:{ *:[i16] } VSrc_b32:{ *:[i16] }:$src0, VSrc_b32:{ *:[i16] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_AND_B32_e64),
        GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2421,
        GIR_Done,
      // Label 355: @39111
      GIM_Try, /*On fail goto*//*Label 356*/ GIMT_Encode4(39134), // Rule ID 2424 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseFakeTrue16Insts),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // (and:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_AND_B32_e64:{ *:[i16] } VSrc_b32:{ *:[i16] }:$src0, VSrc_b32:{ *:[i16] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_AND_B32_e64),
        GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2424,
        GIR_Done,
      // Label 356: @39134
      GIM_Try, /*On fail goto*//*Label 357*/ GIMT_Encode4(39190), // Rule ID 904 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX11Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_16RegClassID),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3opselmods),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3opselmods),
        // (and:{ *:[i16] } (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers))  =>  (V_AND_B16_t16_e64:{ *:[i16] } i32:{ *:[i32] }:$src0_modifiers, i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, i16:{ *:[i16] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_AND_B16_t16_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 904,
        GIR_EraseRootFromParent_Done,
      // Label 357: @39190
      GIM_Try, /*On fail goto*//*Label 358*/ GIMT_Encode4(39213), // Rule ID 905 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX11Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // (and:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_AND_B16_fake16_e64:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_AND_B16_fake16_e64),
        GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 905,
        GIR_Done,
      // Label 358: @39213
      GIM_Reject,
    // Label 352: @39214
    GIM_Reject,
    // Label 343: @39215
    GIM_Try, /*On fail goto*//*Label 359*/ GIMT_Encode4(39738),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 360*/ GIMT_Encode4(39301), // Rule ID 10927 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/2,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/1, 1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_19217),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[i32] } (add:{ *:[i32] } (shl:{ *:[i32] } 1:{ *:[i32] }, i32:{ *:[i32] }:$width)<<P:Predicate_shl_oneuse>>, -1:{ *:[i32] })<<P:Predicate_add_oneuse>>, i32:{ *:[i32] }:$src)<<P:Predicate_anonymous_19217>>  =>  (V_BFE_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src, 0:{ *:[i32] }, ?:{ *:[i32] }:$width)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFE_U32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // width
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 10927,
        GIR_EraseRootFromParent_Done,
      // Label 360: @39301
      GIM_Try, /*On fail goto*//*Label 361*/ GIMT_Encode4(39376), // Rule ID 10928 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/2,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/1, uint8_t(-1),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_19217),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[i32] } (xor:{ *:[i32] } (shl:{ *:[i32] } -1:{ *:[i32] }, i32:{ *:[i32] }:$width)<<P:Predicate_shl_oneuse>>, -1:{ *:[i32] })<<P:Predicate_xor_oneuse>>, i32:{ *:[i32] }:$src)<<P:Predicate_anonymous_19217>>  =>  (V_BFE_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src, 0:{ *:[i32] }, ?:{ *:[i32] }:$width)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFE_U32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // width
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 10928,
        GIR_EraseRootFromParent_Done,
      // Label 361: @39376
      GIM_Try, /*On fail goto*//*Label 362*/ GIMT_Encode4(39451), // Rule ID 7349 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/2,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/1, 1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_19217),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[i32] } i32:{ *:[i32] }:$src, (add:{ *:[i32] } (shl:{ *:[i32] } 1:{ *:[i32] }, i32:{ *:[i32] }:$width)<<P:Predicate_shl_oneuse>>, -1:{ *:[i32] })<<P:Predicate_add_oneuse>>)<<P:Predicate_anonymous_19217>>  =>  (V_BFE_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src, 0:{ *:[i32] }, ?:{ *:[i32] }:$width)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFE_U32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // width
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 7349,
        GIR_EraseRootFromParent_Done,
      // Label 362: @39451
      GIM_Try, /*On fail goto*//*Label 363*/ GIMT_Encode4(39526), // Rule ID 7350 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/2,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/1, uint8_t(-1),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_19217),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[i32] } i32:{ *:[i32] }:$src, (xor:{ *:[i32] } (shl:{ *:[i32] } -1:{ *:[i32] }, i32:{ *:[i32] }:$width)<<P:Predicate_shl_oneuse>>, -1:{ *:[i32] })<<P:Predicate_xor_oneuse>>)<<P:Predicate_anonymous_19217>>  =>  (V_BFE_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src, 0:{ *:[i32] }, ?:{ *:[i32] }:$width)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFE_U32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // width
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 7350,
        GIR_EraseRootFromParent_Done,
      // Label 363: @39526
      GIM_Try, /*On fail goto*//*Label 364*/ GIMT_Encode4(39577), // Rule ID 8139 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_13406),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$src1, -1:{ *:[i32] }), i32:{ *:[i32] }:$src0)<<P:Predicate_anonymous_13406>>  =>  (S_ANDN2_B32:{ *:[i32] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ANDN2_B32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8139,
        GIR_EraseRootFromParent_Done,
      // Label 364: @39577
      GIM_Try, /*On fail goto*//*Label 365*/ GIMT_Encode4(39628), // Rule ID 64 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_13406),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } i32:{ *:[i32] }:$src0, (xor:{ *:[i32] } i32:{ *:[i32] }:$src1, -1:{ *:[i32] }))<<P:Predicate_anonymous_13406>>  =>  (S_ANDN2_B32:{ *:[i32] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ANDN2_B32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 64,
        GIR_EraseRootFromParent_Done,
      // Label 365: @39628
      GIM_Try, /*On fail goto*//*Label 366*/ GIMT_Encode4(39691), // Rule ID 7348 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_IMMZeroBasedBitfieldMask),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_19217),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src, i32:{ *:[i32] }:$rshift), (imm:{ *:[i32] })<<P:Predicate_IMMZeroBasedBitfieldMask>>:$mask)<<P:Predicate_anonymous_19217>>  =>  (V_BFE_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src, ?:{ *:[i32] }:$rshift, (IMMPopCount:{ *:[i32] } ?:{ *:[i32] }:$mask))
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFE_U32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rshift
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/2, /*Renderer*/GIMT_Encode2(GICR_renderPopcntImm), // mask
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 7348,
        GIR_EraseRootFromParent_Done,
      // Label 366: @39691
      GIM_Try, /*On fail goto*//*Label 367*/ GIMT_Encode4(39717), // Rule ID 52 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_13406),
        // (and:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)<<P:Predicate_anonymous_13406>>  =>  (S_AND_B32:{ *:[i32] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_AND_B32),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 52,
        GIR_Done,
      // Label 367: @39717
      GIM_Try, /*On fail goto*//*Label 368*/ GIMT_Encode4(39737), // Rule ID 815 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // (and:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)  =>  (V_AND_B32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_AND_B32_e64),
        GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 815,
        GIR_Done,
      // Label 368: @39737
      GIM_Reject,
    // Label 359: @39738
    GIM_Reject,
    // Label 344: @39739
    GIM_Try, /*On fail goto*//*Label 369*/ GIMT_Encode4(39863),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_13406),
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
      GIM_Try, /*On fail goto*//*Label 370*/ GIMT_Encode4(39801), // Rule ID 8140 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i64] } (xor:{ *:[i64] } i64:{ *:[i64] }:$src1, -1:{ *:[i64] }), i64:{ *:[i64] }:$src0)<<P:Predicate_anonymous_13406>>  =>  (S_ANDN2_B64:{ *:[i64] }:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ANDN2_B64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8140,
        GIR_EraseRootFromParent_Done,
      // Label 370: @39801
      GIM_Try, /*On fail goto*//*Label 371*/ GIMT_Encode4(39844), // Rule ID 65 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i64] } i64:{ *:[i64] }:$src0, (xor:{ *:[i64] } i64:{ *:[i64] }:$src1, -1:{ *:[i64] }))<<P:Predicate_anonymous_13406>>  =>  (S_ANDN2_B64:{ *:[i64] }:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ANDN2_B64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 65,
        GIR_EraseRootFromParent_Done,
      // Label 371: @39844
      GIM_Try, /*On fail goto*//*Label 372*/ GIMT_Encode4(39862), // Rule ID 53 //
        // (and:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)<<P:Predicate_anonymous_13406>>  =>  (S_AND_B64:{ *:[i64] }:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_AND_B64),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 53,
        GIR_Done,
      // Label 372: @39862
      GIM_Reject,
    // Label 369: @39863
    GIM_Reject,
    // Label 345: @39864
    GIM_Try, /*On fail goto*//*Label 373*/ GIMT_Encode4(40014),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
      GIM_Try, /*On fail goto*//*Label 374*/ GIMT_Encode4(39934), // Rule ID 8211 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_13406),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v2i16] } (xor:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src1, immAllOnesV:{ *:[v2i16] }), v2i16:{ *:[v2i16] }:$src0)<<P:Predicate_anonymous_13406>>  =>  (S_ANDN2_B32:{ *:[v2i16] }:{ *:[i1] } SSrc_b32:{ *:[v2i16] }:$src0, SSrc_b32:{ *:[v2i16] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ANDN2_B32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8211,
        GIR_EraseRootFromParent_Done,
      // Label 374: @39934
      GIM_Try, /*On fail goto*//*Label 375*/ GIMT_Encode4(39993), // Rule ID 1881 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_13406),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src0, (xor:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src1, immAllOnesV:{ *:[v2i16] }))<<P:Predicate_anonymous_13406>>  =>  (S_ANDN2_B32:{ *:[v2i16] }:{ *:[i1] } SSrc_b32:{ *:[v2i16] }:$src0, SSrc_b32:{ *:[v2i16] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ANDN2_B32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1881,
        GIR_EraseRootFromParent_Done,
      // Label 375: @39993
      GIM_Try, /*On fail goto*//*Label 376*/ GIMT_Encode4(40013), // Rule ID 2427 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // (and:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src0, v2i16:{ *:[v2i16] }:$src1)  =>  (V_AND_B32_e64:{ *:[v2i16] } VSrc_b32:{ *:[v2i16] }:$src0, VSrc_b32:{ *:[v2i16] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_AND_B32_e64),
        GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2427,
        GIR_Done,
      // Label 376: @40013
      GIM_Reject,
    // Label 373: @40014
    GIM_Reject,
    // Label 346: @40015
    GIM_Try, /*On fail goto*//*Label 377*/ GIMT_Encode4(40137),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_13406),
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
      GIM_Try, /*On fail goto*//*Label 378*/ GIMT_Encode4(40085), // Rule ID 8213 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v2i32] } (xor:{ *:[v2i32] } v2i32:{ *:[v2i32] }:$src1, immAllOnesV:{ *:[v2i32] }), v2i32:{ *:[v2i32] }:$src0)<<P:Predicate_anonymous_13406>>  =>  (S_ANDN2_B64:{ *:[v2i32] }:{ *:[i1] } SSrc_b64:{ *:[v2i32] }:$src0, SSrc_b64:{ *:[v2i32] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ANDN2_B64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8213,
        GIR_EraseRootFromParent_Done,
      // Label 378: @40085
      GIM_Try, /*On fail goto*//*Label 379*/ GIMT_Encode4(40136), // Rule ID 1883 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v2i32] } v2i32:{ *:[v2i32] }:$src0, (xor:{ *:[v2i32] } v2i32:{ *:[v2i32] }:$src1, immAllOnesV:{ *:[v2i32] }))<<P:Predicate_anonymous_13406>>  =>  (S_ANDN2_B64:{ *:[v2i32] }:{ *:[i1] } SSrc_b64:{ *:[v2i32] }:$src0, SSrc_b64:{ *:[v2i32] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ANDN2_B64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1883,
        GIR_EraseRootFromParent_Done,
      // Label 379: @40136
      GIM_Reject,
    // Label 377: @40137
    GIM_Reject,
    // Label 347: @40138
    GIM_Try, /*On fail goto*//*Label 380*/ GIMT_Encode4(40260),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_13406),
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
      GIM_Try, /*On fail goto*//*Label 381*/ GIMT_Encode4(40208), // Rule ID 8212 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v4i16] } (xor:{ *:[v4i16] } v4i16:{ *:[v4i16] }:$src1, immAllOnesV:{ *:[v4i16] }), v4i16:{ *:[v4i16] }:$src0)<<P:Predicate_anonymous_13406>>  =>  (S_ANDN2_B64:{ *:[v4i16] }:{ *:[i1] } SSrc_b64:{ *:[v4i16] }:$src0, SSrc_b64:{ *:[v4i16] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ANDN2_B64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8212,
        GIR_EraseRootFromParent_Done,
      // Label 381: @40208
      GIM_Try, /*On fail goto*//*Label 382*/ GIMT_Encode4(40259), // Rule ID 1882 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v4i16] } v4i16:{ *:[v4i16] }:$src0, (xor:{ *:[v4i16] } v4i16:{ *:[v4i16] }:$src1, immAllOnesV:{ *:[v4i16] }))<<P:Predicate_anonymous_13406>>  =>  (S_ANDN2_B64:{ *:[v4i16] }:{ *:[i1] } SSrc_b64:{ *:[v4i16] }:$src0, SSrc_b64:{ *:[v4i16] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ANDN2_B64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1882,
        GIR_EraseRootFromParent_Done,
      // Label 382: @40259
      GIM_Reject,
    // Label 380: @40260
    GIM_Reject,
    // Label 348: @40261
    GIM_Reject,
    // Label 4: @40262
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(7), GIMT_Encode2(17), /*)*//*default:*//*Label 390*/ GIMT_Encode4(55869),
    /*GILLT_s1*//*Label 383*/ GIMT_Encode4(40313),
    /*GILLT_s16*//*Label 384*/ GIMT_Encode4(40376),
    /*GILLT_s32*//*Label 385*/ GIMT_Encode4(41410),
    /*GILLT_s64*//*Label 386*/ GIMT_Encode4(46283),
    /*GILLT_v2s16*//*Label 387*/ GIMT_Encode4(55472),
    /*GILLT_v2s32*//*Label 388*/ GIMT_Encode4(55623), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v4s16*//*Label 389*/ GIMT_Encode4(55746),
    // Label 383: @40313
    GIM_Try, /*On fail goto*//*Label 391*/ GIMT_Encode4(40375),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s1,
      GIM_Try, /*On fail goto*//*Label 392*/ GIMT_Encode4(40349), // Rule ID 7207 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isWave64),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
        // (or:{ *:[i1] } i1:{ *:[i1] }:$src0, i1:{ *:[i1] }:$src1)  =>  (S_OR_B64:{ *:[i1] }:{ *:[i1] } ?:{ *:[i1] }:$src0, ?:{ *:[i1] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_OR_B64),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 7207,
        GIR_Done,
      // Label 392: @40349
      GIM_Try, /*On fail goto*//*Label 393*/ GIMT_Encode4(40374), // Rule ID 7214 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isWave32),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        // (or:{ *:[i1] } i1:{ *:[i1] }:$src0, i1:{ *:[i1] }:$src1)  =>  (S_OR_B32:{ *:[i1] }:{ *:[i1] } ?:{ *:[i1] }:$src0, ?:{ *:[i1] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_OR_B32),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 7214,
        GIR_Done,
      // Label 393: @40374
      GIM_Reject,
    // Label 391: @40375
    GIM_Reject,
    // Label 384: @40376
    GIM_Try, /*On fail goto*//*Label 394*/ GIMT_Encode4(41409),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s16,
      GIM_Try, /*On fail goto*//*Label 395*/ GIMT_Encode4(40592), // Rule ID 8244 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAshrPkInsts),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_TRUNC),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(AMDGPU::G_AMDGPU_SMED3),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, uint8_t(-128),
        GIM_CheckConstantInt8, /*MI*/3, /*Op*/3, 127,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s16,
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s16,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_TRUNC),
        GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/1, // MIs[7]
        GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(AMDGPU::G_AMDGPU_SMED3),
        GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/7, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/1, // MIs[8]
        GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
        // MIs[8] src2
        GIM_CheckIsSameOperand, /*MI*/8, /*OpIdx*/2, /*OtherMI*/4, /*OtherOpIdx*/2,
        GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, uint8_t(-128),
        GIM_CheckConstantInt8, /*MI*/7, /*Op*/3, 127,
        GIM_CheckConstantInt8, /*MI*/5, /*Op*/2, 8,
        GIM_CheckIsSafeToFold, /*NumInsns*/8,
        // (or:{ *:[i16] } (and:{ *:[i16] } (trunc:{ *:[i16] } (AMDGPUsmed3:{ *:[i32] } (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src2), -128:{ *:[i32] }, 127:{ *:[i32] })), 255:{ *:[i16] }), (shl:{ *:[i16] } (trunc:{ *:[i16] } (AMDGPUsmed3:{ *:[i32] } (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src2), -128:{ *:[i32] }, 127:{ *:[i32] })), 8:{ *:[i16] }))  =>  (V_ASHR_PK_I8_I32_e64:{ *:[i16] } 0:{ *:[i32] }, VSrc_b32:{ *:[i32] }:$src0, 0:{ *:[i32] }, VSrc_b32:{ *:[i32] }:$src1, 0:{ *:[i32] }, VSrc_b32:{ *:[i32] }:$src2, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_ASHR_PK_I8_I32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src0
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/8, /*OpIdx*/1, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8244,
        GIR_EraseRootFromParent_Done,
      // Label 395: @40592
      GIM_Try, /*On fail goto*//*Label 396*/ GIMT_Encode4(40797), // Rule ID 2596 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAshrPkInsts),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_TRUNC),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(AMDGPU::G_AMDGPU_SMED3),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, uint8_t(-128),
        GIM_CheckConstantInt8, /*MI*/3, /*Op*/3, 127,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 8,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s16,
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s16,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_TRUNC),
        GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/1, // MIs[7]
        GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(AMDGPU::G_AMDGPU_SMED3),
        GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/7, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/1, // MIs[8]
        GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
        // MIs[8] src2
        GIM_CheckIsSameOperand, /*MI*/8, /*OpIdx*/2, /*OtherMI*/4, /*OtherOpIdx*/2,
        GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, uint8_t(-128),
        GIM_CheckConstantInt8, /*MI*/7, /*Op*/3, 127,
        GIM_CheckConstantInt, /*MI*/5, /*Op*/2, GIMT_Encode8(255),
        GIM_CheckIsSafeToFold, /*NumInsns*/8,
        // (or:{ *:[i16] } (shl:{ *:[i16] } (trunc:{ *:[i16] } (AMDGPUsmed3:{ *:[i32] } (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src2), -128:{ *:[i32] }, 127:{ *:[i32] })), 8:{ *:[i16] }), (and:{ *:[i16] } (trunc:{ *:[i16] } (AMDGPUsmed3:{ *:[i32] } (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src2), -128:{ *:[i32] }, 127:{ *:[i32] })), 255:{ *:[i16] }))  =>  (V_ASHR_PK_I8_I32_e64:{ *:[i16] } 0:{ *:[i32] }, VSrc_b32:{ *:[i32] }:$src0, 0:{ *:[i32] }, VSrc_b32:{ *:[i32] }:$src1, 0:{ *:[i32] }, VSrc_b32:{ *:[i32] }:$src2, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_ASHR_PK_I8_I32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/8, /*OpIdx*/1, // src0
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2596,
        GIR_EraseRootFromParent_Done,
      // Label 396: @40797
      GIM_Try, /*On fail goto*//*Label 397*/ GIMT_Encode4(40989), // Rule ID 2597 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAshrPkInsts),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_TRUNC),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(AMDGPU::G_AMDGPU_SMED3),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 0,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/3, GIMT_Encode8(255),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 8,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_TRUNC),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(AMDGPU::G_AMDGPU_SMED3),
        GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/6, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/1, // MIs[7]
        GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
        // MIs[7] src2
        GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/2, /*OtherMI*/4, /*OtherOpIdx*/2,
        GIM_CheckConstantInt8, /*MI*/6, /*Op*/2, 0,
        GIM_CheckConstantInt, /*MI*/6, /*Op*/3, GIMT_Encode8(255),
        GIM_CheckIsSafeToFold, /*NumInsns*/7,
        // (or:{ *:[i16] } (shl:{ *:[i16] } (trunc:{ *:[i16] } (AMDGPUsmed3:{ *:[i32] } (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src2), 0:{ *:[i32] }, 255:{ *:[i32] })), 8:{ *:[i16] }), (trunc:{ *:[i16] } (AMDGPUsmed3:{ *:[i32] } (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src2), 0:{ *:[i32] }, 255:{ *:[i32] })))  =>  (V_ASHR_PK_U8_I32_e64:{ *:[i16] } 0:{ *:[i32] }, VSrc_b32:{ *:[i32] }:$src0, 0:{ *:[i32] }, VSrc_b32:{ *:[i32] }:$src1, 0:{ *:[i32] }, VSrc_b32:{ *:[i32] }:$src2, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_ASHR_PK_U8_I32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/7, /*OpIdx*/1, // src0
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2597,
        GIR_EraseRootFromParent_Done,
      // Label 397: @40989
      GIM_Try, /*On fail goto*//*Label 398*/ GIMT_Encode4(41181), // Rule ID 8245 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAshrPkInsts),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_TRUNC),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(AMDGPU::G_AMDGPU_SMED3),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 0,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/3, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s16,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s16,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_TRUNC),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(AMDGPU::G_AMDGPU_SMED3),
        GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/6, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/1, // MIs[7]
        GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
        // MIs[7] src2
        GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
        GIM_CheckConstantInt8, /*MI*/6, /*Op*/2, 0,
        GIM_CheckConstantInt, /*MI*/6, /*Op*/3, GIMT_Encode8(255),
        GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 8,
        GIM_CheckIsSafeToFold, /*NumInsns*/7,
        // (or:{ *:[i16] } (trunc:{ *:[i16] } (AMDGPUsmed3:{ *:[i32] } (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src2), 0:{ *:[i32] }, 255:{ *:[i32] })), (shl:{ *:[i16] } (trunc:{ *:[i16] } (AMDGPUsmed3:{ *:[i32] } (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src2), 0:{ *:[i32] }, 255:{ *:[i32] })), 8:{ *:[i16] }))  =>  (V_ASHR_PK_U8_I32_e64:{ *:[i16] } 0:{ *:[i32] }, VSrc_b32:{ *:[i32] }:$src0, 0:{ *:[i32] }, VSrc_b32:{ *:[i32] }:$src1, 0:{ *:[i32] }, VSrc_b32:{ *:[i32] }:$src2, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_ASHR_PK_U8_I32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src0
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/7, /*OpIdx*/1, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8245,
        GIR_EraseRootFromParent_Done,
      // Label 398: @41181
      GIM_Try, /*On fail goto*//*Label 399*/ GIMT_Encode4(41232), // Rule ID 8214 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_13407),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i16] } (xor:{ *:[i16] } i16:{ *:[i16] }:$src1, -1:{ *:[i16] }), i16:{ *:[i16] }:$src0)<<P:Predicate_anonymous_13407>>  =>  (S_ORN2_B32:{ *:[i16] }:{ *:[i1] } SSrc_b32:{ *:[i16] }:$src0, SSrc_b32:{ *:[i16] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ORN2_B32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8214,
        GIR_EraseRootFromParent_Done,
      // Label 399: @41232
      GIM_Try, /*On fail goto*//*Label 400*/ GIMT_Encode4(41283), // Rule ID 1884 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_13407),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i16] } i16:{ *:[i16] }:$src0, (xor:{ *:[i16] } i16:{ *:[i16] }:$src1, -1:{ *:[i16] }))<<P:Predicate_anonymous_13407>>  =>  (S_ORN2_B32:{ *:[i16] }:{ *:[i1] } SSrc_b32:{ *:[i16] }:$src0, SSrc_b32:{ *:[i16] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ORN2_B32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1884,
        GIR_EraseRootFromParent_Done,
      // Label 400: @41283
      GIM_Try, /*On fail goto*//*Label 401*/ GIMT_Encode4(41306), // Rule ID 2422 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotHasTrue16BitInsts),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // (or:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_OR_B32_e64:{ *:[i16] } VSrc_b32:{ *:[i16] }:$src0, VSrc_b32:{ *:[i16] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_OR_B32_e64),
        GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2422,
        GIR_Done,
      // Label 401: @41306
      GIM_Try, /*On fail goto*//*Label 402*/ GIMT_Encode4(41329), // Rule ID 2425 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseFakeTrue16Insts),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // (or:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_OR_B32_e64:{ *:[i16] } VSrc_b32:{ *:[i16] }:$src0, VSrc_b32:{ *:[i16] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_OR_B32_e64),
        GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2425,
        GIR_Done,
      // Label 402: @41329
      GIM_Try, /*On fail goto*//*Label 403*/ GIMT_Encode4(41385), // Rule ID 906 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX11Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_16RegClassID),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3opselmods),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3opselmods),
        // (or:{ *:[i16] } (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers))  =>  (V_OR_B16_t16_e64:{ *:[i16] } i32:{ *:[i32] }:$src0_modifiers, i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, i16:{ *:[i16] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_OR_B16_t16_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 906,
        GIR_EraseRootFromParent_Done,
      // Label 403: @41385
      GIM_Try, /*On fail goto*//*Label 404*/ GIMT_Encode4(41408), // Rule ID 907 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX11Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // (or:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_OR_B16_fake16_e64:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_OR_B16_fake16_e64),
        GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 907,
        GIR_Done,
      // Label 404: @41408
      GIM_Reject,
    // Label 394: @41409
    GIM_Reject,
    // Label 385: @41410
    GIM_Try, /*On fail goto*//*Label 405*/ GIMT_Encode4(46282),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 406*/ GIMT_Encode4(41568), // Rule ID 10896 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, uint8_t(-1),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_19219),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$x, -1:{ *:[i32] }), i32:{ *:[i32] }:$z), (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$y))<<P:Predicate_anonymous_19219>>  =>  (V_BFI_B32_e64:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/2, // z
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/3, /*OpIdx*/2, // y
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // x
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/2,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 10896,
        GIR_EraseRootFromParent_Done,
      // Label 406: @41568
      GIM_Try, /*On fail goto*//*Label 407*/ GIMT_Encode4(41715), // Rule ID 10895 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, uint8_t(-1),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_19219),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$x, -1:{ *:[i32] }), i32:{ *:[i32] }:$z), (and:{ *:[i32] } i32:{ *:[i32] }:$y, i32:{ *:[i32] }:$x))<<P:Predicate_anonymous_19219>>  =>  (V_BFI_B32_e64:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/2, // z
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/3, /*OpIdx*/1, // y
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // x
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/2,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 10895,
        GIR_EraseRootFromParent_Done,
      // Label 407: @41715
      GIM_Try, /*On fail goto*//*Label 408*/ GIMT_Encode4(41862), // Rule ID 10894 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, uint8_t(-1),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_19219),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$z, (xor:{ *:[i32] } i32:{ *:[i32] }:$x, -1:{ *:[i32] })), (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$y))<<P:Predicate_anonymous_19219>>  =>  (V_BFI_B32_e64:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/1, // z
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/3, /*OpIdx*/2, // y
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // x
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/2,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 10894,
        GIR_EraseRootFromParent_Done,
      // Label 408: @41862
      GIM_Try, /*On fail goto*//*Label 409*/ GIMT_Encode4(42009), // Rule ID 10893 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, uint8_t(-1),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_19219),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$z, (xor:{ *:[i32] } i32:{ *:[i32] }:$x, -1:{ *:[i32] })), (and:{ *:[i32] } i32:{ *:[i32] }:$y, i32:{ *:[i32] }:$x))<<P:Predicate_anonymous_19219>>  =>  (V_BFI_B32_e64:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/1, // z
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/3, /*OpIdx*/1, // y
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // x
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/2,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 10893,
        GIR_EraseRootFromParent_Done,
      // Label 409: @42009
      GIM_Try, /*On fail goto*//*Label 410*/ GIMT_Encode4(42156), // Rule ID 10890 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, uint8_t(-1),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_19219),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$y, i32:{ *:[i32] }:$x), (and:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$x, -1:{ *:[i32] }), i32:{ *:[i32] }:$z))<<P:Predicate_anonymous_19219>>  =>  (V_BFI_B32_e64:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/2, // z
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // y
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // x
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/2,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 10890,
        GIR_EraseRootFromParent_Done,
      // Label 410: @42156
      GIM_Try, /*On fail goto*//*Label 411*/ GIMT_Encode4(42303), // Rule ID 10892 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, uint8_t(-1),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_19219),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$y), (and:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$x, -1:{ *:[i32] }), i32:{ *:[i32] }:$z))<<P:Predicate_anonymous_19219>>  =>  (V_BFI_B32_e64:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/2, // z
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // y
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // x
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/2,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 10892,
        GIR_EraseRootFromParent_Done,
      // Label 411: @42303
      GIM_Try, /*On fail goto*//*Label 412*/ GIMT_Encode4(42450), // Rule ID 7125 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, uint8_t(-1),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_19219),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$y, i32:{ *:[i32] }:$x), (and:{ *:[i32] } i32:{ *:[i32] }:$z, (xor:{ *:[i32] } i32:{ *:[i32] }:$x, -1:{ *:[i32] })))<<P:Predicate_anonymous_19219>>  =>  (V_BFI_B32_e64:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/1, // z
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // y
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // x
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/2,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 7125,
        GIR_EraseRootFromParent_Done,
      // Label 412: @42450
      GIM_Try, /*On fail goto*//*Label 413*/ GIMT_Encode4(42597), // Rule ID 10891 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, uint8_t(-1),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_19219),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$y), (and:{ *:[i32] } i32:{ *:[i32] }:$z, (xor:{ *:[i32] } i32:{ *:[i32] }:$x, -1:{ *:[i32] })))<<P:Predicate_anonymous_19219>>  =>  (V_BFI_B32_e64:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/1, // z
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // y
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // x
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/2,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 10891,
        GIR_EraseRootFromParent_Done,
      // Label 413: @42597
      GIM_Try, /*On fail goto*//*Label 414*/ GIMT_Encode4(42690), // Rule ID 2493 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:5:x
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordNamedOperand, /*MI*/2, /*Op*/1, /*StoreIdx*/1, // Name : pred:5:y
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/2, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_csh_mask_32),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:5:z
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_20254),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i32] } (shl:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:5:x, (and:{ *:[i32] } i32:{ *:[i32] }:$src1:$pred:5:y, (imm:{ *:[i32] }))<<P:Predicate_csh_mask_32>>)<<P:Predicate_anonymous_20244>>, i32:{ *:[i32] }:$src2:$pred:5:z)<<P:5:Predicate_anonymous_20254>>  =>  (V_LSHL_OR_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_LSHL_OR_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2493,
        GIR_EraseRootFromParent_Done,
      // Label 414: @42690
      GIM_Try, /*On fail goto*//*Label 415*/ GIMT_Encode4(42783), // Rule ID 8229 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:5:z
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:5:x
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordNamedOperand, /*MI*/2, /*Op*/1, /*StoreIdx*/1, // Name : pred:5:y
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/2, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_csh_mask_32),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_20254),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i32] } i32:{ *:[i32] }:$src2:$pred:5:z, (shl:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:5:x, (and:{ *:[i32] } i32:{ *:[i32] }:$src1:$pred:5:y, (imm:{ *:[i32] }))<<P:Predicate_csh_mask_32>>)<<P:Predicate_anonymous_20244>>)<<P:5:Predicate_anonymous_20254>>  =>  (V_LSHL_OR_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_LSHL_OR_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/1, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8229,
        GIR_EraseRootFromParent_Done,
      // Label 415: @42783
      GIM_Try, /*On fail goto*//*Label 416*/ GIMT_Encode4(42968), // Rule ID 10941 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[3] z
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_19219),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z), i32:{ *:[i32] }:$y), (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z))<<P:Predicate_anonymous_19219>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/2, // y
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/2, // z
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/2, // y
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/1, // x
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 10941,
        GIR_EraseRootFromParent_Done,
      // Label 416: @42968
      GIM_Try, /*On fail goto*//*Label 417*/ GIMT_Encode4(43153), // Rule ID 10942 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[3] z
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_19219),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z), i32:{ *:[i32] }:$y), (and:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x))<<P:Predicate_anonymous_19219>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/2, // y
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/2, // z
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/2, // y
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/1, // x
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 10942,
        GIR_EraseRootFromParent_Done,
      // Label 417: @43153
      GIM_Try, /*On fail goto*//*Label 418*/ GIMT_Encode4(43338), // Rule ID 10943 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[3] z
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_19219),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x), i32:{ *:[i32] }:$y), (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z))<<P:Predicate_anonymous_19219>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/2, // y
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/1, // z
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/2, // y
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/2, // x
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 10943,
        GIR_EraseRootFromParent_Done,
      // Label 418: @43338
      GIM_Try, /*On fail goto*//*Label 419*/ GIMT_Encode4(43523), // Rule ID 10944 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[3] z
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_19219),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x), i32:{ *:[i32] }:$y), (and:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x))<<P:Predicate_anonymous_19219>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/2, // y
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/1, // z
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/2, // y
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/2, // x
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 10944,
        GIR_EraseRootFromParent_Done,
      // Label 419: @43523
      GIM_Try, /*On fail goto*//*Label 420*/ GIMT_Encode4(43708), // Rule ID 10937 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[3] z
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_19219),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$y, (or:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z)), (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z))<<P:Predicate_anonymous_19219>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/1, // y
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/2, // z
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/1, // y
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/1, // x
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 10937,
        GIR_EraseRootFromParent_Done,
      // Label 420: @43708
      GIM_Try, /*On fail goto*//*Label 421*/ GIMT_Encode4(43893), // Rule ID 10938 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[3] z
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_19219),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$y, (or:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z)), (and:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x))<<P:Predicate_anonymous_19219>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/1, // y
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/2, // z
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/1, // y
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/1, // x
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 10938,
        GIR_EraseRootFromParent_Done,
      // Label 421: @43893
      GIM_Try, /*On fail goto*//*Label 422*/ GIMT_Encode4(44078), // Rule ID 10939 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[3] z
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_19219),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$y, (or:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x)), (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z))<<P:Predicate_anonymous_19219>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/1, // y
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/1, // z
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/1, // y
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/2, // x
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 10939,
        GIR_EraseRootFromParent_Done,
      // Label 422: @44078
      GIM_Try, /*On fail goto*//*Label 423*/ GIMT_Encode4(44263), // Rule ID 10940 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[3] z
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_19219),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$y, (or:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x)), (and:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x))<<P:Predicate_anonymous_19219>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/1, // y
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/1, // z
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/1, // y
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/2, // x
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 10940,
        GIR_EraseRootFromParent_Done,
      // Label 423: @44263
      GIM_Try, /*On fail goto*//*Label 424*/ GIMT_Encode4(44448), // Rule ID 10931 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        // MIs[3] z
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_19219),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z), (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z), i32:{ *:[i32] }:$y))<<P:Predicate_anonymous_19219>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/2, /*OpIdx*/2, // y
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/2, // z
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/2, // y
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // x
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 10931,
        GIR_EraseRootFromParent_Done,
      // Label 424: @44448
      GIM_Try, /*On fail goto*//*Label 425*/ GIMT_Encode4(44633), // Rule ID 10932 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[3] z
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_19219),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z), (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x), i32:{ *:[i32] }:$y))<<P:Predicate_anonymous_19219>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/2, /*OpIdx*/2, // y
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/2, // z
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/2, // y
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // x
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 10932,
        GIR_EraseRootFromParent_Done,
      // Label 425: @44633
      GIM_Try, /*On fail goto*//*Label 426*/ GIMT_Encode4(44818), // Rule ID 10935 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        // MIs[3] z
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_19219),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x), (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z), i32:{ *:[i32] }:$y))<<P:Predicate_anonymous_19219>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/2, /*OpIdx*/2, // y
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/1, // z
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/2, // y
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // x
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 10935,
        GIR_EraseRootFromParent_Done,
      // Label 426: @44818
      GIM_Try, /*On fail goto*//*Label 427*/ GIMT_Encode4(45003), // Rule ID 10936 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[3] z
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_19219),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x), (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x), i32:{ *:[i32] }:$y))<<P:Predicate_anonymous_19219>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/2, /*OpIdx*/2, // y
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/1, // z
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/2, // y
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // x
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 10936,
        GIR_EraseRootFromParent_Done,
      // Label 427: @45003
      GIM_Try, /*On fail goto*//*Label 428*/ GIMT_Encode4(45188), // Rule ID 7352 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        // MIs[3] z
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_19219),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z), (and:{ *:[i32] } i32:{ *:[i32] }:$y, (or:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z)))<<P:Predicate_anonymous_19219>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/2, /*OpIdx*/1, // y
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/2, // z
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/1, // y
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // x
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 7352,
        GIR_EraseRootFromParent_Done,
      // Label 428: @45188
      GIM_Try, /*On fail goto*//*Label 429*/ GIMT_Encode4(45373), // Rule ID 10930 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[3] z
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_19219),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z), (and:{ *:[i32] } i32:{ *:[i32] }:$y, (or:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x)))<<P:Predicate_anonymous_19219>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/2, /*OpIdx*/1, // y
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/2, // z
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/1, // y
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // x
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 10930,
        GIR_EraseRootFromParent_Done,
      // Label 429: @45373
      GIM_Try, /*On fail goto*//*Label 430*/ GIMT_Encode4(45558), // Rule ID 10933 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        // MIs[3] z
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_19219),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x), (and:{ *:[i32] } i32:{ *:[i32] }:$y, (or:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z)))<<P:Predicate_anonymous_19219>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/2, /*OpIdx*/1, // y
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/1, // z
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/1, // y
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // x
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 10933,
        GIR_EraseRootFromParent_Done,
      // Label 430: @45558
      GIM_Try, /*On fail goto*//*Label 431*/ GIMT_Encode4(45743), // Rule ID 10934 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[3] z
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_19219),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x), (and:{ *:[i32] } i32:{ *:[i32] }:$y, (or:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x)))<<P:Predicate_anonymous_19219>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/2, /*OpIdx*/1, // y
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/1, // z
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/1, // y
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // x
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 10934,
        GIR_EraseRootFromParent_Done,
      // Label 431: @45743
      GIM_Try, /*On fail goto*//*Label 432*/ GIMT_Encode4(45794), // Rule ID 8141 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_13407),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$src1, -1:{ *:[i32] }), i32:{ *:[i32] }:$src0)<<P:Predicate_anonymous_13407>>  =>  (S_ORN2_B32:{ *:[i32] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ORN2_B32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8141,
        GIR_EraseRootFromParent_Done,
      // Label 432: @45794
      GIM_Try, /*On fail goto*//*Label 433*/ GIMT_Encode4(45845), // Rule ID 66 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_13407),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i32] } i32:{ *:[i32] }:$src0, (xor:{ *:[i32] } i32:{ *:[i32] }:$src1, -1:{ *:[i32] }))<<P:Predicate_anonymous_13407>>  =>  (S_ORN2_B32:{ *:[i32] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ORN2_B32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 66,
        GIR_EraseRootFromParent_Done,
      // Label 433: @45845
      GIM_Try, /*On fail goto*//*Label 434*/ GIMT_Encode4(45910), // Rule ID 2494 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:6:x
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:6:y
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:6:z
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_20256),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:6:x, i32:{ *:[i32] }:$src1:$pred:6:y)<<P:Predicate_anonymous_20257>>, i32:{ *:[i32] }:$src2:$pred:6:z)<<P:6:Predicate_anonymous_20256>>  =>  (V_AND_OR_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_AND_OR_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2494,
        GIR_EraseRootFromParent_Done,
      // Label 434: @45910
      GIM_Try, /*On fail goto*//*Label 435*/ GIMT_Encode4(45975), // Rule ID 2495 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:7:x
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:7:y
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:7:z
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_20259),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:7:x, i32:{ *:[i32] }:$src1:$pred:7:y)<<P:Predicate_anonymous_20260>>, i32:{ *:[i32] }:$src2:$pred:7:z)<<P:7:Predicate_anonymous_20259>>  =>  (V_OR3_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_OR3_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2495,
        GIR_EraseRootFromParent_Done,
      // Label 435: @45975
      GIM_Try, /*On fail goto*//*Label 436*/ GIMT_Encode4(46040), // Rule ID 2492 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:5:x
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:5:y
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:5:z
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_20254),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i32] } (shl:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:5:x, i32:{ *:[i32] }:$src1:$pred:5:y)<<P:Predicate_anonymous_20244>>, i32:{ *:[i32] }:$src2:$pred:5:z)<<P:5:Predicate_anonymous_20254>>  =>  (V_LSHL_OR_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_LSHL_OR_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2492,
        GIR_EraseRootFromParent_Done,
      // Label 436: @46040
      GIM_Try, /*On fail goto*//*Label 437*/ GIMT_Encode4(46105), // Rule ID 8230 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:6:z
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:6:x
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:6:y
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_20256),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i32] } i32:{ *:[i32] }:$src2:$pred:6:z, (and:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:6:x, i32:{ *:[i32] }:$src1:$pred:6:y)<<P:Predicate_anonymous_20257>>)<<P:6:Predicate_anonymous_20256>>  =>  (V_AND_OR_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_AND_OR_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/1, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8230,
        GIR_EraseRootFromParent_Done,
      // Label 437: @46105
      GIM_Try, /*On fail goto*//*Label 438*/ GIMT_Encode4(46170), // Rule ID 8231 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:7:z
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:7:x
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:7:y
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_20259),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i32] } i32:{ *:[i32] }:$src2:$pred:7:z, (or:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:7:x, i32:{ *:[i32] }:$src1:$pred:7:y)<<P:Predicate_anonymous_20260>>)<<P:7:Predicate_anonymous_20259>>  =>  (V_OR3_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_OR3_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/1, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8231,
        GIR_EraseRootFromParent_Done,
      // Label 438: @46170
      GIM_Try, /*On fail goto*//*Label 439*/ GIMT_Encode4(46235), // Rule ID 8228 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:5:z
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckHasOneUse, /*MI*/1,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:5:x
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:5:y
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_20254),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i32] } i32:{ *:[i32] }:$src2:$pred:5:z, (shl:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:5:x, i32:{ *:[i32] }:$src1:$pred:5:y)<<P:Predicate_anonymous_20244>>)<<P:5:Predicate_anonymous_20254>>  =>  (V_LSHL_OR_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_LSHL_OR_B32_e64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/1, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 8228,
        GIR_EraseRootFromParent_Done,
      // Label 439: @46235
      GIM_Try, /*On fail goto*//*Label 440*/ GIMT_Encode4(46261), // Rule ID 54 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_13407),
        // (or:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)<<P:Predicate_anonymous_13407>>  =>  (S_OR_B32:{ *:[i32] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_OR_B32),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 54,
        GIR_Done,
      // Label 440: @46261
      GIM_Try, /*On fail goto*//*Label 441*/ GIMT_Encode4(46281), // Rule ID 816 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // (or:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)  =>  (V_OR_B32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_OR_B32_e64),
        GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 816,
        GIR_Done,
      // Label 441: @46281
      GIM_Reject,
    // Label 405: @46282
    GIM_Reject,
    // Label 386: @46283
    GIM_Try, /*On fail goto*//*Label 442*/ GIMT_Encode4(55471),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 443*/ GIMT_Encode4(46609), // Rule ID 10904 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, uint8_t(-1),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_19219),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } (xor:{ *:[i64] } i64:{ *:[i64] }:$x, -1:{ *:[i64] }), i64:{ *:[i64] }:$z), (and:{ *:[i64] } i64:{ *:[i64] }:$x, i64:{ *:[i64] }:$y))<<P:Predicate_anonymous_19219>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/8, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // z
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/7, /*OldInsnID*/3, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // y
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // x
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/5, /*TempRegID*/5,
        GIR_AddSimpleTempRegister, /*InsnID*/5, /*TempRegID*/6,
        GIR_AddSimpleTempRegister, /*InsnID*/5, /*TempRegID*/7,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // z
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/3, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // y
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // x
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // GIR_Coverage, 10904,
        GIR_EraseRootFromParent_Done,
      // Label 443: @46609
      GIM_Try, /*On fail goto*//*Label 444*/ GIMT_Encode4(46924), // Rule ID 10903 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, uint8_t(-1),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s64,
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_19219),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } (xor:{ *:[i64] } i64:{ *:[i64] }:$x, -1:{ *:[i64] }), i64:{ *:[i64] }:$z), (and:{ *:[i64] } i64:{ *:[i64] }:$y, i64:{ *:[i64] }:$x))<<P:Predicate_anonymous_19219>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/8, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // z
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/7, /*OldInsnID*/3, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // y
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // x
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/5, /*TempRegID*/5,
        GIR_AddSimpleTempRegister, /*InsnID*/5, /*TempRegID*/6,
        GIR_AddSimpleTempRegister, /*InsnID*/5, /*TempRegID*/7,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // z
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/3, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // y
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // x
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // GIR_Coverage, 10903,
        GIR_EraseRootFromParent_Done,
      // Label 444: @46924
      GIM_Try, /*On fail goto*//*Label 445*/ GIMT_Encode4(47239), // Rule ID 10902 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, uint8_t(-1),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_19219),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$z, (xor:{ *:[i64] } i64:{ *:[i64] }:$x, -1:{ *:[i64] })), (and:{ *:[i64] } i64:{ *:[i64] }:$x, i64:{ *:[i64] }:$y))<<P:Predicate_anonymous_19219>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/8, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // z
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/7, /*OldInsnID*/3, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // y
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // x
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/5, /*TempRegID*/5,
        GIR_AddSimpleTempRegister, /*InsnID*/5, /*TempRegID*/6,
        GIR_AddSimpleTempRegister, /*InsnID*/5, /*TempRegID*/7,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // z
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/3, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // y
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // x
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // GIR_Coverage, 10902,
        GIR_EraseRootFromParent_Done,
      // Label 445: @47239
      GIM_Try, /*On fail goto*//*Label 446*/ GIMT_Encode4(47554), // Rule ID 10901 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, uint8_t(-1),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s64,
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_19219),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$z, (xor:{ *:[i64] } i64:{ *:[i64] }:$x, -1:{ *:[i64] })), (and:{ *:[i64] } i64:{ *:[i64] }:$y, i64:{ *:[i64] }:$x))<<P:Predicate_anonymous_19219>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/8, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // z
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/7, /*OldInsnID*/3, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // y
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // x
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/5, /*TempRegID*/5,
        GIR_AddSimpleTempRegister, /*InsnID*/5, /*TempRegID*/6,
        GIR_AddSimpleTempRegister, /*InsnID*/5, /*TempRegID*/7,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // z
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/3, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // y
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // x
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // GIR_Coverage, 10901,
        GIR_EraseRootFromParent_Done,
      // Label 446: @47554
      GIM_Try, /*On fail goto*//*Label 447*/ GIMT_Encode4(47869), // Rule ID 10898 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, uint8_t(-1),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_19219),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$y, i64:{ *:[i64] }:$x), (and:{ *:[i64] } (xor:{ *:[i64] } i64:{ *:[i64] }:$x, -1:{ *:[i64] }), i64:{ *:[i64] }:$z))<<P:Predicate_anonymous_19219>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/8, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // z
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/7, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // y
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // x
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/5, /*TempRegID*/5,
        GIR_AddSimpleTempRegister, /*InsnID*/5, /*TempRegID*/6,
        GIR_AddSimpleTempRegister, /*InsnID*/5, /*TempRegID*/7,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // z
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // y
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // x
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // GIR_Coverage, 10898,
        GIR_EraseRootFromParent_Done,
      // Label 447: @47869
      GIM_Try, /*On fail goto*//*Label 448*/ GIMT_Encode4(48184), // Rule ID 10900 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, uint8_t(-1),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_19219),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$x, i64:{ *:[i64] }:$y), (and:{ *:[i64] } (xor:{ *:[i64] } i64:{ *:[i64] }:$x, -1:{ *:[i64] }), i64:{ *:[i64] }:$z))<<P:Predicate_anonymous_19219>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/8, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // z
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/7, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // y
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // x
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/5, /*TempRegID*/5,
        GIR_AddSimpleTempRegister, /*InsnID*/5, /*TempRegID*/6,
        GIR_AddSimpleTempRegister, /*InsnID*/5, /*TempRegID*/7,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // z
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // y
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // x
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // GIR_Coverage, 10900,
        GIR_EraseRootFromParent_Done,
      // Label 448: @48184
      GIM_Try, /*On fail goto*//*Label 449*/ GIMT_Encode4(48499), // Rule ID 7127 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, uint8_t(-1),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_19219),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$y, i64:{ *:[i64] }:$x), (and:{ *:[i64] } i64:{ *:[i64] }:$z, (xor:{ *:[i64] } i64:{ *:[i64] }:$x, -1:{ *:[i64] })))<<P:Predicate_anonymous_19219>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/8, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // z
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/7, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // y
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // x
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/5, /*TempRegID*/5,
        GIR_AddSimpleTempRegister, /*InsnID*/5, /*TempRegID*/6,
        GIR_AddSimpleTempRegister, /*InsnID*/5, /*TempRegID*/7,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // z
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // y
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // x
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // GIR_Coverage, 7127,
        GIR_EraseRootFromParent_Done,
      // Label 449: @48499
      GIM_Try, /*On fail goto*//*Label 450*/ GIMT_Encode4(48814), // Rule ID 10899 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, uint8_t(-1),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_19219),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$x, i64:{ *:[i64] }:$y), (and:{ *:[i64] } i64:{ *:[i64] }:$z, (xor:{ *:[i64] } i64:{ *:[i64] }:$x, -1:{ *:[i64] })))<<P:Predicate_anonymous_19219>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/8, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // z
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/7, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // y
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // x
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/5, /*TempRegID*/5,
        GIR_AddSimpleTempRegister, /*InsnID*/5, /*TempRegID*/6,
        GIR_AddSimpleTempRegister, /*InsnID*/5, /*TempRegID*/7,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // z
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // y
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // x
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // GIR_Coverage, 10899,
        GIR_EraseRootFromParent_Done,
      // Label 450: @48814
      GIM_Try, /*On fail goto*//*Label 451*/ GIMT_Encode4(49222), // Rule ID 10956 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[3] z
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_19219),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } (or:{ *:[i64] } i64:{ *:[i64] }:$x, i64:{ *:[i64] }:$z), i64:{ *:[i64] }:$y), (and:{ *:[i64] } i64:{ *:[i64] }:$x, i64:{ *:[i64] }:$z))<<P:Predicate_anonymous_19219>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/11, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/12, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/12, /*TempRegID*/11, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/12, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // y
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/10, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/11, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/11, /*TempRegID*/10, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/11, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // z
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/9, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/10, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/10, /*TempRegID*/9, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/10, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // y
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/8, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/9, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/9, /*TempRegID*/8, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/9, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // x
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/8, /*TempRegID*/8,
        GIR_AddSimpleTempRegister, /*InsnID*/8, /*TempRegID*/9,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/8,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/7,
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/10,
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/11,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // y
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/5, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // z
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // y
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // x
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/4,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/5,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/6,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // GIR_Coverage, 10956,
        GIR_EraseRootFromParent_Done,
      // Label 451: @49222
      GIM_Try, /*On fail goto*//*Label 452*/ GIMT_Encode4(49630), // Rule ID 10957 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[3] z
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_19219),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } (or:{ *:[i64] } i64:{ *:[i64] }:$x, i64:{ *:[i64] }:$z), i64:{ *:[i64] }:$y), (and:{ *:[i64] } i64:{ *:[i64] }:$z, i64:{ *:[i64] }:$x))<<P:Predicate_anonymous_19219>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/11, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/12, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/12, /*TempRegID*/11, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/12, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // y
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/10, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/11, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/11, /*TempRegID*/10, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/11, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // z
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/9, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/10, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/10, /*TempRegID*/9, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/10, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // y
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/8, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/9, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/9, /*TempRegID*/8, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/9, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // x
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/8, /*TempRegID*/8,
        GIR_AddSimpleTempRegister, /*InsnID*/8, /*TempRegID*/9,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/8,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/7,
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/10,
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/11,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // y
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/5, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // z
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // y
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // x
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/4,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/5,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/6,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // GIR_Coverage, 10957,
        GIR_EraseRootFromParent_Done,
      // Label 452: @49630
      GIM_Try, /*On fail goto*//*Label 453*/ GIMT_Encode4(50038), // Rule ID 10958 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[3] z
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_19219),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } (or:{ *:[i64] } i64:{ *:[i64] }:$z, i64:{ *:[i64] }:$x), i64:{ *:[i64] }:$y), (and:{ *:[i64] } i64:{ *:[i64] }:$x, i64:{ *:[i64] }:$z))<<P:Predicate_anonymous_19219>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/11, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/12, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/12, /*TempRegID*/11, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/12, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // y
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/10, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/11, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/11, /*TempRegID*/10, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/11, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // z
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/9, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/10, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/10, /*TempRegID*/9, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/10, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // y
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/8, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/9, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/9, /*TempRegID*/8, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/9, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // x
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/8, /*TempRegID*/8,
        GIR_AddSimpleTempRegister, /*InsnID*/8, /*TempRegID*/9,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/8,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/7,
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/10,
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/11,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // y
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/5, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // z
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // y
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // x
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/4,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/5,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/6,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // GIR_Coverage, 10958,
        GIR_EraseRootFromParent_Done,
      // Label 453: @50038
      GIM_Try, /*On fail goto*//*Label 454*/ GIMT_Encode4(50446), // Rule ID 10959 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[3] z
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_19219),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } (or:{ *:[i64] } i64:{ *:[i64] }:$z, i64:{ *:[i64] }:$x), i64:{ *:[i64] }:$y), (and:{ *:[i64] } i64:{ *:[i64] }:$z, i64:{ *:[i64] }:$x))<<P:Predicate_anonymous_19219>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/11, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/12, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/12, /*TempRegID*/11, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/12, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // y
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/10, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/11, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/11, /*TempRegID*/10, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/11, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // z
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/9, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/10, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/10, /*TempRegID*/9, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/10, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // y
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/8, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/9, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/9, /*TempRegID*/8, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/9, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // x
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/8, /*TempRegID*/8,
        GIR_AddSimpleTempRegister, /*InsnID*/8, /*TempRegID*/9,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/8,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/7,
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/10,
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/11,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // y
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/5, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // z
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // y
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // x
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/4,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/5,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/6,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // GIR_Coverage, 10959,
        GIR_EraseRootFromParent_Done,
      // Label 454: @50446
      GIM_Try, /*On fail goto*//*Label 455*/ GIMT_Encode4(50854), // Rule ID 10952 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[3] z
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_19219),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$y, (or:{ *:[i64] } i64:{ *:[i64] }:$x, i64:{ *:[i64] }:$z)), (and:{ *:[i64] } i64:{ *:[i64] }:$x, i64:{ *:[i64] }:$z))<<P:Predicate_anonymous_19219>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/11, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/12, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/12, /*TempRegID*/11, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/12, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // y
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/10, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/11, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/11, /*TempRegID*/10, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/11, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // z
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/9, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/10, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/10, /*TempRegID*/9, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/10, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // y
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/8, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/9, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/9, /*TempRegID*/8, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/9, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // x
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/8, /*TempRegID*/8,
        GIR_AddSimpleTempRegister, /*InsnID*/8, /*TempRegID*/9,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/8,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/7,
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/10,
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/11,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // y
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/5, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // z
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // y
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // x
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/4,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/5,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/6,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // GIR_Coverage, 10952,
        GIR_EraseRootFromParent_Done,
      // Label 455: @50854
      GIM_Try, /*On fail goto*//*Label 456*/ GIMT_Encode4(51262), // Rule ID 10953 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[3] z
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_19219),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$y, (or:{ *:[i64] } i64:{ *:[i64] }:$x, i64:{ *:[i64] }:$z)), (and:{ *:[i64] } i64:{ *:[i64] }:$z, i64:{ *:[i64] }:$x))<<P:Predicate_anonymous_19219>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/11, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/12, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/12, /*TempRegID*/11, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/12, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // y
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/10, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/11, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/11, /*TempRegID*/10, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/11, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // z
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/9, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/10, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/10, /*TempRegID*/9, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/10, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // y
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/8, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/9, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/9, /*TempRegID*/8, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/9, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // x
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/8, /*TempRegID*/8,
        GIR_AddSimpleTempRegister, /*InsnID*/8, /*TempRegID*/9,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/8,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/7,
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/10,
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/11,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // y
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/5, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // z
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // y
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // x
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/4,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/5,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/6,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // GIR_Coverage, 10953,
        GIR_EraseRootFromParent_Done,
      // Label 456: @51262
      GIM_Try, /*On fail goto*//*Label 457*/ GIMT_Encode4(51670), // Rule ID 10954 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[3] z
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_19219),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$y, (or:{ *:[i64] } i64:{ *:[i64] }:$z, i64:{ *:[i64] }:$x)), (and:{ *:[i64] } i64:{ *:[i64] }:$x, i64:{ *:[i64] }:$z))<<P:Predicate_anonymous_19219>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/11, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/12, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/12, /*TempRegID*/11, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/12, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // y
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/10, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/11, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/11, /*TempRegID*/10, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/11, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // z
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/9, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/10, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/10, /*TempRegID*/9, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/10, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // y
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/8, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/9, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/9, /*TempRegID*/8, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/9, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // x
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/8, /*TempRegID*/8,
        GIR_AddSimpleTempRegister, /*InsnID*/8, /*TempRegID*/9,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/8,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/7,
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/10,
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/11,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // y
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/5, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // z
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // y
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // x
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/4,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/5,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/6,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // GIR_Coverage, 10954,
        GIR_EraseRootFromParent_Done,
      // Label 457: @51670
      GIM_Try, /*On fail goto*//*Label 458*/ GIMT_Encode4(52078), // Rule ID 10955 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[3] z
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_19219),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$y, (or:{ *:[i64] } i64:{ *:[i64] }:$z, i64:{ *:[i64] }:$x)), (and:{ *:[i64] } i64:{ *:[i64] }:$z, i64:{ *:[i64] }:$x))<<P:Predicate_anonymous_19219>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/11, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/12, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/12, /*TempRegID*/11, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/12, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // y
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/10, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/11, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/11, /*TempRegID*/10, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/11, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // z
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/9, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/10, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/10, /*TempRegID*/9, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/10, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // y
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/8, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/9, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/9, /*TempRegID*/8, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/9, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // x
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/8, /*TempRegID*/8,
        GIR_AddSimpleTempRegister, /*InsnID*/8, /*TempRegID*/9,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/8,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/7,
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/10,
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/11,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // y
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/5, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // z
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // y
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // x
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/4,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/5,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/6,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // GIR_Coverage, 10955,
        GIR_EraseRootFromParent_Done,
      // Label 458: @52078
      GIM_Try, /*On fail goto*//*Label 459*/ GIMT_Encode4(52486), // Rule ID 10946 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        // MIs[3] z
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_19219),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$x, i64:{ *:[i64] }:$z), (and:{ *:[i64] } (or:{ *:[i64] } i64:{ *:[i64] }:$x, i64:{ *:[i64] }:$z), i64:{ *:[i64] }:$y))<<P:Predicate_anonymous_19219>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/11, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/12, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/12, /*TempRegID*/11, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/12, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // y
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/10, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/11, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/11, /*TempRegID*/10, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/11, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // z
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/9, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/10, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/10, /*TempRegID*/9, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/10, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // y
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/8, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/9, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/9, /*TempRegID*/8, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/9, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // x
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/8, /*TempRegID*/8,
        GIR_AddSimpleTempRegister, /*InsnID*/8, /*TempRegID*/9,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/8,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/7,
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/10,
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/11,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // y
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // z
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // y
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // x
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/4,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/5,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/6,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // GIR_Coverage, 10946,
        GIR_EraseRootFromParent_Done,
      // Label 459: @52486
      GIM_Try, /*On fail goto*//*Label 460*/ GIMT_Encode4(52894), // Rule ID 10947 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[3] z
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_19219),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$x, i64:{ *:[i64] }:$z), (and:{ *:[i64] } (or:{ *:[i64] } i64:{ *:[i64] }:$z, i64:{ *:[i64] }:$x), i64:{ *:[i64] }:$y))<<P:Predicate_anonymous_19219>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/11, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/12, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/12, /*TempRegID*/11, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/12, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // y
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/10, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/11, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/11, /*TempRegID*/10, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/11, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // z
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/9, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/10, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/10, /*TempRegID*/9, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/10, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // y
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/8, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/9, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/9, /*TempRegID*/8, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/9, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // x
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/8, /*TempRegID*/8,
        GIR_AddSimpleTempRegister, /*InsnID*/8, /*TempRegID*/9,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/8,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/7,
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/10,
        GIR_AddSimpleTempRegister, /*InsnID*/7, /*TempRegID*/11,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // y
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // z
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // y
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(3), // x
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/4,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/5,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/6,
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
        // GIR_Coverage, 10947,
        GIR_EraseRootFromParent_Done,
      // Label 460: @52894
      GIM_Try, /*On fail goto*//*Label 461*/ GIMT_Encode4(53302), // Rule ID 10950 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[3] x
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        // MIs[3] z
        GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_19219),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$z, i64:{ *:[i64] }:$x), (and:{ *:[i64] } (or:{ *:[i64] } i64:{ *:[i64] }:$x, i64:{ *:[i64] }:$z), i64:{ *:[i64] }:$y))<<P:Predicate_anonymous_19219>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16