/*
 * Copyright (c) 2018, 2020, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License, version 2.0,
 * as published by the Free Software Foundation.
 *
 * This program is designed to work with certain software (including
 * but not limited to OpenSSL) that is licensed under separate terms, as
 * designated in a particular file or component or in included license
 * documentation. The authors of MySQL hereby grant you an additional
 * permission to link the program and your derivative works with the
 * separately licensed software that they have either included with
 * the program or referenced in the documentation.
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See
 * the GNU General Public License, version 2.0, for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */


// Generated from /build/mysql-workbench/src/mysql-workbench-community-8.0.43-src/library/parsers/grammars/MySQLParser.g4 by ANTLR 4.13.2


#include "MySQLParserListener.h"
#include "MySQLParserVisitor.h"

#include "MySQLParser.h"


#include "MySQLBaseRecognizer.h"


using namespace antlrcpp;
using namespace parsers;

using namespace antlr4;

namespace {

struct MySQLParserStaticData final {
  MySQLParserStaticData(std::vector<std::string> ruleNames,
                        std::vector<std::string> literalNames,
                        std::vector<std::string> symbolicNames)
      : ruleNames(std::move(ruleNames)), literalNames(std::move(literalNames)),
        symbolicNames(std::move(symbolicNames)),
        vocabulary(this->literalNames, this->symbolicNames) {}

  MySQLParserStaticData(const MySQLParserStaticData&) = delete;
  MySQLParserStaticData(MySQLParserStaticData&&) = delete;
  MySQLParserStaticData& operator=(const MySQLParserStaticData&) = delete;
  MySQLParserStaticData& operator=(MySQLParserStaticData&&) = delete;

  std::vector<antlr4::dfa::DFA> decisionToDFA;
  antlr4::atn::PredictionContextCache sharedContextCache;
  const std::vector<std::string> ruleNames;
  const std::vector<std::string> literalNames;
  const std::vector<std::string> symbolicNames;
  const antlr4::dfa::Vocabulary vocabulary;
  antlr4::atn::SerializedATNView serializedATN;
  std::unique_ptr<antlr4::atn::ATN> atn;
};

::antlr4::internal::OnceFlag mysqlparserParserOnceFlag;
#if ANTLR4_USE_THREAD_LOCAL_CACHE
static thread_local
#endif
std::unique_ptr<MySQLParserStaticData> mysqlparserParserStaticData = nullptr;

void mysqlparserParserInitialize() {
#if ANTLR4_USE_THREAD_LOCAL_CACHE
  if (mysqlparserParserStaticData != nullptr) {
    return;
  }
#else
  assert(mysqlparserParserStaticData == nullptr);
#endif
  auto staticData = std::make_unique<MySQLParserStaticData>(
    std::vector<std::string>{
      "query", "simpleStatement", "alterStatement", "alterDatabase", "alterEvent", 
      "alterLogfileGroup", "alterLogfileGroupOptions", "alterLogfileGroupOption", 
      "alterServer", "alterTable", "alterTableActions", "alterCommandList", 
      "alterCommandsModifierList", "standaloneAlterCommands", "alterPartition", 
      "alterList", "alterCommandsModifier", "alterListItem", "place", "restrict", 
      "alterOrderList", "alterAlgorithmOption", "alterLockOption", "indexLockAndAlgorithm", 
      "withValidation", "removePartitioning", "allOrPartitionNameList", 
      "alterTablespace", "alterUndoTablespace", "undoTableSpaceOptions", 
      "undoTableSpaceOption", "alterTablespaceOptions", "alterTablespaceOption", 
      "changeTablespaceOption", "alterView", "viewTail", "viewSelect", "viewCheckOption", 
      "createStatement", "createDatabase", "createDatabaseOption", "createTable", 
      "tableElementList", "tableElement", "duplicateAsQueryExpression", 
      "queryExpressionOrParens", "createRoutine", "createProcedure", "createFunction", 
      "createUdf", "routineCreateOption", "routineAlterOptions", "routineOption", 
      "createIndex", "indexNameAndType", "createIndexTarget", "createLogfileGroup", 
      "logfileGroupOptions", "logfileGroupOption", "createServer", "serverOptions", 
      "serverOption", "createTablespace", "createUndoTablespace", "tsDataFileName", 
      "tsDataFile", "tablespaceOptions", "tablespaceOption", "tsOptionInitialSize", 
      "tsOptionUndoRedoBufferSize", "tsOptionAutoextendSize", "tsOptionMaxSize", 
      "tsOptionExtentSize", "tsOptionNodegroup", "tsOptionEngine", "tsOptionWait", 
      "tsOptionComment", "tsOptionFileblockSize", "tsOptionEncryption", 
      "createView", "viewReplaceOrAlgorithm", "viewAlgorithm", "viewSuid", 
      "createTrigger", "triggerFollowsPrecedesClause", "createEvent", "createRole", 
      "createSpatialReference", "srsAttribute", "dropStatement", "dropDatabase", 
      "dropEvent", "dropFunction", "dropProcedure", "dropIndex", "dropLogfileGroup", 
      "dropLogfileGroupOption", "dropServer", "dropTable", "dropTableSpace", 
      "dropTrigger", "dropView", "dropRole", "dropSpatialReference", "dropUndoTablespace", 
      "renameTableStatement", "renamePair", "truncateTableStatement", "importStatement", 
      "callStatement", "deleteStatement", "partitionDelete", "deleteStatementOption", 
      "doStatement", "handlerStatement", "handlerReadOrScan", "insertStatement", 
      "insertLockOption", "insertFromConstructor", "fields", "insertValues", 
      "insertQueryExpression", "valueList", "values", "valuesReference", 
      "insertUpdateList", "loadStatement", "dataOrXml", "xmlRowsIdentifiedBy", 
      "loadDataFileTail", "loadDataFileTargetList", "fieldOrVariableList", 
      "replaceStatement", "selectStatement", "selectStatementWithInto", 
      "queryExpression", "queryExpressionBody", "queryExpressionParens", 
      "queryPrimary", "querySpecification", "subquery", "querySpecOption", 
      "limitClause", "simpleLimitClause", "limitOptions", "limitOption", 
      "intoClause", "procedureAnalyseClause", "havingClause", "windowClause", 
      "windowDefinition", "windowSpec", "windowSpecDetails", "windowFrameClause", 
      "windowFrameUnits", "windowFrameExtent", "windowFrameStart", "windowFrameBetween", 
      "windowFrameBound", "windowFrameExclusion", "withClause", "commonTableExpression", 
      "groupByClause", "olapOption", "orderClause", "direction", "fromClause", 
      "tableReferenceList", "tableValueConstructor", "explicitTable", "rowValueExplicit", 
      "selectOption", "lockingClauseList", "lockingClause", "lockStrengh", 
      "lockedRowAction", "selectItemList", "selectItem", "selectAlias", 
      "whereClause", "tableReference", "escapedTableReference", "joinedTable", 
      "naturalJoinType", "innerJoinType", "outerJoinType", "tableFactor", 
      "singleTable", "singleTableParens", "derivedTable", "tableReferenceListParens", 
      "tableFunction", "columnsClause", "jtColumn", "onEmptyOrError", "onEmpty", 
      "onError", "jtOnResponse", "unionOption", "tableAlias", "indexHintList", 
      "indexHint", "indexHintType", "keyOrIndex", "constraintKeyType", "indexHintClause", 
      "indexList", "indexListElement", "updateStatement", "transactionOrLockingStatement", 
      "transactionStatement", "beginWork", "transactionCharacteristic", 
      "savepointStatement", "lockStatement", "lockItem", "lockOption", "xaStatement", 
      "xaConvert", "xid", "replicationStatement", "resetOption", "masterResetOptions", 
      "replicationLoad", "changeMaster", "changeMasterOptions", "masterOption", 
      "privilegeCheckDef", "tablePrimaryKeyCheckDef", "masterTlsCiphersuitesDef", 
      "masterFileDef", "serverIdList", "changeReplication", "filterDefinition", 
      "filterDbList", "filterTableList", "filterStringList", "filterWildDbTableString", 
      "filterDbPairList", "slave", "slaveUntilOptions", "slaveConnectionOptions", 
      "slaveThreadOptions", "slaveThreadOption", "groupReplication", "preparedStatement", 
      "executeStatement", "executeVarList", "cloneStatement", "dataDirSSL", 
      "ssl", "accountManagementStatement", "alterUser", "alterUserTail", 
      "userFunction", "createUser", "createUserTail", "defaultRoleClause", 
      "requireClause", "connectOptions", "accountLockPasswordExpireOptions", 
      "dropUser", "grant", "grantTargetList", "grantOptions", "exceptRoleList", 
      "withRoles", "grantAs", "versionedRequireClause", "renameUser", "revoke", 
      "onTypeTo", "aclType", "roleOrPrivilegesList", "roleOrPrivilege", 
      "grantIdentifier", "requireList", "requireListElement", "grantOption", 
      "setRole", "roleList", "role", "tableAdministrationStatement", "histogram", 
      "checkOption", "repairType", "installUninstallStatment", "setStatement", 
      "startOptionValueList", "transactionCharacteristics", "transactionAccessMode", 
      "isolationLevel", "optionValueListContinued", "optionValueNoOptionType", 
      "optionValue", "setSystemVariable", "startOptionValueListFollowingOptionType", 
      "optionValueFollowingOptionType", "setExprOrDefault", "showStatement", 
      "showCommandType", "nonBlocking", "fromOrIn", "inDb", "profileType", 
      "otherAdministrativeStatement", "keyCacheListOrParts", "keyCacheList", 
      "assignToKeycache", "assignToKeycachePartition", "cacheKeyList", "keyUsageElement", 
      "keyUsageList", "flushOption", "logType", "flushTables", "flushTablesOptions", 
      "preloadTail", "preloadList", "preloadKeys", "adminPartition", "resourceGroupManagement", 
      "createResourceGroup", "resourceGroupVcpuList", "vcpuNumOrRange", 
      "resourceGroupPriority", "resourceGroupEnableDisable", "alterResourceGroup", 
      "setResourceGroup", "threadIdList", "dropResourceGroup", "utilityStatement", 
      "describeStatement", "explainStatement", "explainableStatement", "helpCommand", 
      "useCommand", "restartServer", "expr", "boolPri", "compOp", "predicate", 
      "predicateOperations", "bitExpr", "simpleExpr", "arrayCast", "jsonOperator", 
      "sumExpr", "groupingOperation", "windowFunctionCall", "windowingClause", 
      "leadLagInfo", "nullTreatment", "jsonFunction", "inSumExpr", "identListArg", 
      "identList", "fulltextOptions", "runtimeFunctionCall", "geometryFunction", 
      "timeFunctionParameters", "fractionalPrecision", "weightStringLevels", 
      "weightStringLevelListItem", "dateTimeTtype", "trimFunction", "substringFunction", 
      "functionCall", "udfExprList", "udfExpr", "variable", "userVariable", 
      "systemVariable", "internalVariableName", "whenExpression", "thenExpression", 
      "elseExpression", "castType", "exprList", "charset", "notRule", "not2Rule", 
      "interval", "intervalTimeStamp", "exprListWithParentheses", "exprWithParentheses", 
      "simpleExprWithParentheses", "orderList", "orderExpression", "groupList", 
      "groupingExpression", "channel", "compoundStatement", "returnStatement", 
      "ifStatement", "ifBody", "thenStatement", "compoundStatementList", 
      "caseStatement", "elseStatement", "labeledBlock", "unlabeledBlock", 
      "label", "beginEndBlock", "labeledControl", "unlabeledControl", "loopBlock", 
      "whileDoBlock", "repeatUntilBlock", "spDeclarations", "spDeclaration", 
      "variableDeclaration", "conditionDeclaration", "spCondition", "sqlstate", 
      "handlerDeclaration", "handlerCondition", "cursorDeclaration", "iterateStatement", 
      "leaveStatement", "getDiagnostics", "signalAllowedExpr", "statementInformationItem", 
      "conditionInformationItem", "signalInformationItemName", "signalStatement", 
      "resignalStatement", "signalInformationItem", "cursorOpen", "cursorClose", 
      "cursorFetch", "schedule", "columnDefinition", "checkOrReferences", 
      "checkConstraint", "constraintEnforcement", "tableConstraintDef", 
      "constraintName", "fieldDefinition", "columnAttribute", "columnFormat", 
      "storageMedia", "gcolAttribute", "references", "deleteOption", "keyList", 
      "keyPart", "keyListWithExpression", "keyPartOrExpression", "keyListVariants", 
      "indexType", "indexOption", "commonIndexOption", "visibility", "indexTypeClause", 
      "fulltextIndexOption", "spatialIndexOption", "dataTypeDefinition", 
      "dataType", "nchar", "realType", "fieldLength", "fieldOptions", "charsetWithOptBinary", 
      "ascii", "unicode", "wsNumCodepoints", "typeDatetimePrecision", "charsetName", 
      "collationName", "createTableOptions", "createTableOptionsSpaceSeparated", 
      "createTableOption", "ternaryOption", "defaultCollation", "defaultEncryption", 
      "defaultCharset", "partitionClause", "partitionTypeDef", "subPartitions", 
      "partitionKeyAlgorithm", "partitionDefinitions", "partitionDefinition", 
      "partitionValuesIn", "partitionOption", "subpartitionDefinition", 
      "partitionValueItemListParen", "partitionValueItem", "definerClause", 
      "ifExists", "ifNotExists", "procedureParameter", "functionParameter", 
      "collate", "typeWithOptCollate", "schemaIdentifierPair", "viewRefList", 
      "updateList", "updateElement", "charsetClause", "fieldsClause", "fieldTerm", 
      "linesClause", "lineTerm", "userList", "createUserList", "alterUserList", 
      "createUserEntry", "alterUserEntry", "retainCurrentPassword", "discardOldPassword", 
      "replacePassword", "userIdentifierOrText", "user", "likeClause", "likeOrWhere", 
      "onlineOption", "noWriteToBinLog", "usePartition", "fieldIdentifier", 
      "columnName", "columnInternalRef", "columnInternalRefList", "columnRef", 
      "insertIdentifier", "indexName", "indexRef", "tableWild", "schemaName", 
      "schemaRef", "procedureName", "procedureRef", "functionName", "functionRef", 
      "triggerName", "triggerRef", "viewName", "viewRef", "tablespaceName", 
      "tablespaceRef", "logfileGroupName", "logfileGroupRef", "eventName", 
      "eventRef", "udfName", "serverName", "serverRef", "engineRef", "tableName", 
      "filterTableRef", "tableRefWithWildcard", "tableRef", "tableRefList", 
      "tableAliasRefList", "parameterName", "labelIdentifier", "labelRef", 
      "roleIdentifier", "roleRef", "pluginRef", "componentRef", "resourceGroupRef", 
      "windowName", "pureIdentifier", "identifier", "identifierList", "identifierListWithParentheses", 
      "qualifiedIdentifier", "simpleIdentifier", "dotIdentifier", "ulong_number", 
      "real_ulong_number", "ulonglong_number", "real_ulonglong_number", 
      "literal", "signedLiteral", "stringList", "textStringLiteral", "textString", 
      "textStringHash", "textLiteral", "textStringNoLinebreak", "textStringLiteralList", 
      "numLiteral", "boolLiteral", "nullLiteral", "temporalLiteral", "floatOptions", 
      "standardFloatOptions", "precision", "textOrIdentifier", "lValueIdentifier", 
      "roleIdentifierOrText", "sizeNumber", "parentheses", "equal", "optionType", 
      "varIdentType", "setVarIdentType", "identifierKeyword", "identifierKeywordsAmbiguous1RolesAndLabels", 
      "identifierKeywordsAmbiguous2Labels", "labelKeyword", "identifierKeywordsAmbiguous3Roles", 
      "identifierKeywordsUnambiguous", "roleKeyword", "lValueKeyword", "identifierKeywordsAmbiguous4SystemVariables", 
      "roleOrIdentifierKeyword", "roleOrLabelKeyword"
    },
    std::vector<std::string>{
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "'='", "':='", "'<=>'", "'>='", "'>'", "'<='", "'<'", "'!='", 
      "'+'", "'-'", "'*'", "'/'", "'%'", "'!'", "'~'", "'<<'", "'>>'", "'&&'", 
      "'&'", "'^'", "'||'", "'|'", "'.'", "','", "';'", "':'", "'('", "')'", 
      "'{'", "'}'", "'_'", "'->'", "'->>'", "'@'", "", "'@@'", "'\\N'", 
      "'\\u003F'", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
      "", "", "", "", "'<>'"
    },
    std::vector<std::string>{
      "", "ACCESSIBLE_SYMBOL", "ACCOUNT_SYMBOL", "ACTION_SYMBOL", "ADD_SYMBOL", 
      "ADDDATE_SYMBOL", "AFTER_SYMBOL", "AGAINST_SYMBOL", "AGGREGATE_SYMBOL", 
      "ALGORITHM_SYMBOL", "ALL_SYMBOL", "ALTER_SYMBOL", "ALWAYS_SYMBOL", 
      "ANALYSE_SYMBOL", "ANALYZE_SYMBOL", "AND_SYMBOL", "ANY_SYMBOL", "AS_SYMBOL", 
      "ASC_SYMBOL", "ASCII_SYMBOL", "ASENSITIVE_SYMBOL", "AT_SYMBOL", "AUTHORS_SYMBOL", 
      "AUTOEXTEND_SIZE_SYMBOL", "AUTO_INCREMENT_SYMBOL", "AVG_ROW_LENGTH_SYMBOL", 
      "AVG_SYMBOL", "BACKUP_SYMBOL", "BEFORE_SYMBOL", "BEGIN_SYMBOL", "BETWEEN_SYMBOL", 
      "BIGINT_SYMBOL", "BINARY_SYMBOL", "BINLOG_SYMBOL", "BIN_NUM_SYMBOL", 
      "BIT_AND_SYMBOL", "BIT_OR_SYMBOL", "BIT_SYMBOL", "BIT_XOR_SYMBOL", 
      "BLOB_SYMBOL", "BLOCK_SYMBOL", "BOOLEAN_SYMBOL", "BOOL_SYMBOL", "BOTH_SYMBOL", 
      "BTREE_SYMBOL", "BY_SYMBOL", "BYTE_SYMBOL", "CACHE_SYMBOL", "CALL_SYMBOL", 
      "CASCADE_SYMBOL", "CASCADED_SYMBOL", "CASE_SYMBOL", "CAST_SYMBOL", 
      "CATALOG_NAME_SYMBOL", "CHAIN_SYMBOL", "CHANGE_SYMBOL", "CHANGED_SYMBOL", 
      "CHANNEL_SYMBOL", "CHARSET_SYMBOL", "CHARACTER_SYMBOL", "CHAR_SYMBOL", 
      "CHECKSUM_SYMBOL", "CHECK_SYMBOL", "CIPHER_SYMBOL", "CLASS_ORIGIN_SYMBOL", 
      "CLIENT_SYMBOL", "CLOSE_SYMBOL", "COALESCE_SYMBOL", "CODE_SYMBOL", 
      "COLLATE_SYMBOL", "COLLATION_SYMBOL", "COLUMNS_SYMBOL", "COLUMN_SYMBOL", 
      "COLUMN_NAME_SYMBOL", "COLUMN_FORMAT_SYMBOL", "COMMENT_SYMBOL", "COMMITTED_SYMBOL", 
      "COMMIT_SYMBOL", "COMPACT_SYMBOL", "COMPLETION_SYMBOL", "COMPRESSED_SYMBOL", 
      "COMPRESSION_SYMBOL", "CONCURRENT_SYMBOL", "CONDITION_SYMBOL", "CONNECTION_SYMBOL", 
      "CONSISTENT_SYMBOL", "CONSTRAINT_SYMBOL", "CONSTRAINT_CATALOG_SYMBOL", 
      "CONSTRAINT_NAME_SYMBOL", "CONSTRAINT_SCHEMA_SYMBOL", "CONTAINS_SYMBOL", 
      "CONTEXT_SYMBOL", "CONTINUE_SYMBOL", "CONTRIBUTORS_SYMBOL", "CONVERT_SYMBOL", 
      "COUNT_SYMBOL", "CPU_SYMBOL", "CREATE_SYMBOL", "CROSS_SYMBOL", "CUBE_SYMBOL", 
      "CURDATE_SYMBOL", "CURRENT_SYMBOL", "CURRENT_DATE_SYMBOL", "CURRENT_TIME_SYMBOL", 
      "CURRENT_TIMESTAMP_SYMBOL", "CURRENT_USER_SYMBOL", "CURSOR_SYMBOL", 
      "CURSOR_NAME_SYMBOL", "CURTIME_SYMBOL", "DATABASE_SYMBOL", "DATABASES_SYMBOL", 
      "DATAFILE_SYMBOL", "DATA_SYMBOL", "DATETIME_SYMBOL", "DATE_ADD_SYMBOL", 
      "DATE_SUB_SYMBOL", "DATE_SYMBOL", "DAYOFMONTH_SYMBOL", "DAY_HOUR_SYMBOL", 
      "DAY_MICROSECOND_SYMBOL", "DAY_MINUTE_SYMBOL", "DAY_SECOND_SYMBOL", 
      "DAY_SYMBOL", "DEALLOCATE_SYMBOL", "DEC_SYMBOL", "DECIMAL_NUM_SYMBOL", 
      "DECIMAL_SYMBOL", "DECLARE_SYMBOL", "DEFAULT_SYMBOL", "DEFAULT_AUTH_SYMBOL", 
      "DEFINER_SYMBOL", "DELAYED_SYMBOL", "DELAY_KEY_WRITE_SYMBOL", "DELETE_SYMBOL", 
      "DESC_SYMBOL", "DESCRIBE_SYMBOL", "DES_KEY_FILE_SYMBOL", "DETERMINISTIC_SYMBOL", 
      "DIAGNOSTICS_SYMBOL", "DIRECTORY_SYMBOL", "DISABLE_SYMBOL", "DISCARD_SYMBOL", 
      "DISK_SYMBOL", "DISTINCT_SYMBOL", "DISTINCTROW_SYMBOL", "DIV_SYMBOL", 
      "DOUBLE_SYMBOL", "DO_SYMBOL", "DROP_SYMBOL", "DUAL_SYMBOL", "DUMPFILE_SYMBOL", 
      "DUPLICATE_SYMBOL", "DYNAMIC_SYMBOL", "EACH_SYMBOL", "ELSE_SYMBOL", 
      "ELSEIF_SYMBOL", "ENABLE_SYMBOL", "ENCLOSED_SYMBOL", "ENCRYPTION_SYMBOL", 
      "END_SYMBOL", "ENDS_SYMBOL", "END_OF_INPUT_SYMBOL", "ENGINES_SYMBOL", 
      "ENGINE_SYMBOL", "ENUM_SYMBOL", "ERROR_SYMBOL", "ERRORS_SYMBOL", "ESCAPED_SYMBOL", 
      "ESCAPE_SYMBOL", "EVENTS_SYMBOL", "EVENT_SYMBOL", "EVERY_SYMBOL", 
      "EXCHANGE_SYMBOL", "EXECUTE_SYMBOL", "EXISTS_SYMBOL", "EXIT_SYMBOL", 
      "EXPANSION_SYMBOL", "EXPIRE_SYMBOL", "EXPLAIN_SYMBOL", "EXPORT_SYMBOL", 
      "EXTENDED_SYMBOL", "EXTENT_SIZE_SYMBOL", "EXTRACT_SYMBOL", "FALSE_SYMBOL", 
      "FAST_SYMBOL", "FAULTS_SYMBOL", "FETCH_SYMBOL", "FIELDS_SYMBOL", "FILE_SYMBOL", 
      "FILE_BLOCK_SIZE_SYMBOL", "FILTER_SYMBOL", "FIRST_SYMBOL", "FIXED_SYMBOL", 
      "FLOAT4_SYMBOL", "FLOAT8_SYMBOL", "FLOAT_SYMBOL", "FLUSH_SYMBOL", 
      "FOLLOWS_SYMBOL", "FORCE_SYMBOL", "FOREIGN_SYMBOL", "FOR_SYMBOL", 
      "FORMAT_SYMBOL", "FOUND_SYMBOL", "FROM_SYMBOL", "FULL_SYMBOL", "FULLTEXT_SYMBOL", 
      "FUNCTION_SYMBOL", "GET_SYMBOL", "GENERAL_SYMBOL", "GENERATED_SYMBOL", 
      "GROUP_REPLICATION_SYMBOL", "GEOMETRYCOLLECTION_SYMBOL", "GEOMETRY_SYMBOL", 
      "GET_FORMAT_SYMBOL", "GLOBAL_SYMBOL", "GRANT_SYMBOL", "GRANTS_SYMBOL", 
      "GROUP_SYMBOL", "GROUP_CONCAT_SYMBOL", "HANDLER_SYMBOL", "HASH_SYMBOL", 
      "HAVING_SYMBOL", "HELP_SYMBOL", "HIGH_PRIORITY_SYMBOL", "HOST_SYMBOL", 
      "HOSTS_SYMBOL", "HOUR_MICROSECOND_SYMBOL", "HOUR_MINUTE_SYMBOL", "HOUR_SECOND_SYMBOL", 
      "HOUR_SYMBOL", "IDENTIFIED_SYMBOL", "IF_SYMBOL", "IGNORE_SYMBOL", 
      "IGNORE_SERVER_IDS_SYMBOL", "IMPORT_SYMBOL", "INDEXES_SYMBOL", "INDEX_SYMBOL", 
      "INFILE_SYMBOL", "INITIAL_SIZE_SYMBOL", "INNER_SYMBOL", "INOUT_SYMBOL", 
      "INSENSITIVE_SYMBOL", "INSERT_SYMBOL", "INSERT_METHOD_SYMBOL", "INSTANCE_SYMBOL", 
      "INSTALL_SYMBOL", "INTEGER_SYMBOL", "INTERVAL_SYMBOL", "INTO_SYMBOL", 
      "INT_SYMBOL", "INVOKER_SYMBOL", "IN_SYMBOL", "IO_AFTER_GTIDS_SYMBOL", 
      "IO_BEFORE_GTIDS_SYMBOL", "IO_THREAD_SYMBOL", "IO_SYMBOL", "IPC_SYMBOL", 
      "IS_SYMBOL", "ISOLATION_SYMBOL", "ISSUER_SYMBOL", "ITERATE_SYMBOL", 
      "JOIN_SYMBOL", "JSON_SYMBOL", "KEYS_SYMBOL", "KEY_BLOCK_SIZE_SYMBOL", 
      "KEY_SYMBOL", "KILL_SYMBOL", "LANGUAGE_SYMBOL", "LAST_SYMBOL", "LEADING_SYMBOL", 
      "LEAVES_SYMBOL", "LEAVE_SYMBOL", "LEFT_SYMBOL", "LESS_SYMBOL", "LEVEL_SYMBOL", 
      "LIKE_SYMBOL", "LIMIT_SYMBOL", "LINEAR_SYMBOL", "LINES_SYMBOL", "LINESTRING_SYMBOL", 
      "LIST_SYMBOL", "LOAD_SYMBOL", "LOCALTIME_SYMBOL", "LOCALTIMESTAMP_SYMBOL", 
      "LOCAL_SYMBOL", "LOCATOR_SYMBOL", "LOCKS_SYMBOL", "LOCK_SYMBOL", "LOGFILE_SYMBOL", 
      "LOGS_SYMBOL", "LONGBLOB_SYMBOL", "LONGTEXT_SYMBOL", "LONG_NUM_SYMBOL", 
      "LONG_SYMBOL", "LOOP_SYMBOL", "LOW_PRIORITY_SYMBOL", "MASTER_AUTO_POSITION_SYMBOL", 
      "MASTER_BIND_SYMBOL", "MASTER_CONNECT_RETRY_SYMBOL", "MASTER_DELAY_SYMBOL", 
      "MASTER_HOST_SYMBOL", "MASTER_LOG_FILE_SYMBOL", "MASTER_LOG_POS_SYMBOL", 
      "MASTER_PASSWORD_SYMBOL", "MASTER_PORT_SYMBOL", "MASTER_RETRY_COUNT_SYMBOL", 
      "MASTER_SERVER_ID_SYMBOL", "MASTER_SSL_CAPATH_SYMBOL", "MASTER_SSL_CA_SYMBOL", 
      "MASTER_SSL_CERT_SYMBOL", "MASTER_SSL_CIPHER_SYMBOL", "MASTER_SSL_CRL_SYMBOL", 
      "MASTER_SSL_CRLPATH_SYMBOL", "MASTER_SSL_KEY_SYMBOL", "MASTER_SSL_SYMBOL", 
      "MASTER_SSL_VERIFY_SERVER_CERT_SYMBOL", "MASTER_SYMBOL", "MASTER_TLS_VERSION_SYMBOL", 
      "MASTER_USER_SYMBOL", "MASTER_HEARTBEAT_PERIOD_SYMBOL", "MATCH_SYMBOL", 
      "MAX_CONNECTIONS_PER_HOUR_SYMBOL", "MAX_QUERIES_PER_HOUR_SYMBOL", 
      "MAX_ROWS_SYMBOL", "MAX_SIZE_SYMBOL", "MAX_STATEMENT_TIME_SYMBOL", 
      "MAX_SYMBOL", "MAX_UPDATES_PER_HOUR_SYMBOL", "MAX_USER_CONNECTIONS_SYMBOL", 
      "MAXVALUE_SYMBOL", "MEDIUMBLOB_SYMBOL", "MEDIUMINT_SYMBOL", "MEDIUMTEXT_SYMBOL", 
      "MEDIUM_SYMBOL", "MEMORY_SYMBOL", "MERGE_SYMBOL", "MESSAGE_TEXT_SYMBOL", 
      "MICROSECOND_SYMBOL", "MID_SYMBOL", "MIDDLEINT_SYMBOL", "MIGRATE_SYMBOL", 
      "MINUTE_MICROSECOND_SYMBOL", "MINUTE_SECOND_SYMBOL", "MINUTE_SYMBOL", 
      "MIN_ROWS_SYMBOL", "MIN_SYMBOL", "MODE_SYMBOL", "MODIFIES_SYMBOL", 
      "MODIFY_SYMBOL", "MOD_SYMBOL", "MONTH_SYMBOL", "MULTILINESTRING_SYMBOL", 
      "MULTIPOINT_SYMBOL", "MULTIPOLYGON_SYMBOL", "MUTEX_SYMBOL", "MYSQL_ERRNO_SYMBOL", 
      "NAMES_SYMBOL", "NAME_SYMBOL", "NATIONAL_SYMBOL", "NATURAL_SYMBOL", 
      "NCHAR_STRING_SYMBOL", "NCHAR_SYMBOL", "NDB_SYMBOL", "NDBCLUSTER_SYMBOL", 
      "NEG_SYMBOL", "NEVER_SYMBOL", "NEW_SYMBOL", "NEXT_SYMBOL", "NODEGROUP_SYMBOL", 
      "NONE_SYMBOL", "NONBLOCKING_SYMBOL", "NOT_SYMBOL", "NOW_SYMBOL", "NO_SYMBOL", 
      "NO_WAIT_SYMBOL", "NO_WRITE_TO_BINLOG_SYMBOL", "NULL_SYMBOL", "NUMBER_SYMBOL", 
      "NUMERIC_SYMBOL", "NVARCHAR_SYMBOL", "OFFLINE_SYMBOL", "OFFSET_SYMBOL", 
      "OLD_PASSWORD_SYMBOL", "ON_SYMBOL", "ONE_SYMBOL", "ONLINE_SYMBOL", 
      "ONLY_SYMBOL", "OPEN_SYMBOL", "OPTIMIZE_SYMBOL", "OPTIMIZER_COSTS_SYMBOL", 
      "OPTIONS_SYMBOL", "OPTION_SYMBOL", "OPTIONALLY_SYMBOL", "ORDER_SYMBOL", 
      "OR_SYMBOL", "OUTER_SYMBOL", "OUTFILE_SYMBOL", "OUT_SYMBOL", "OWNER_SYMBOL", 
      "PACK_KEYS_SYMBOL", "PAGE_SYMBOL", "PARSER_SYMBOL", "PARTIAL_SYMBOL", 
      "PARTITIONING_SYMBOL", "PARTITIONS_SYMBOL", "PARTITION_SYMBOL", "PASSWORD_SYMBOL", 
      "PHASE_SYMBOL", "PLUGINS_SYMBOL", "PLUGIN_DIR_SYMBOL", "PLUGIN_SYMBOL", 
      "POINT_SYMBOL", "POLYGON_SYMBOL", "PORT_SYMBOL", "POSITION_SYMBOL", 
      "PRECEDES_SYMBOL", "PRECISION_SYMBOL", "PREPARE_SYMBOL", "PRESERVE_SYMBOL", 
      "PREV_SYMBOL", "PRIMARY_SYMBOL", "PRIVILEGES_SYMBOL", "PROCEDURE_SYMBOL", 
      "PROCESS_SYMBOL", "PROCESSLIST_SYMBOL", "PROFILE_SYMBOL", "PROFILES_SYMBOL", 
      "PROXY_SYMBOL", "PURGE_SYMBOL", "QUARTER_SYMBOL", "QUERY_SYMBOL", 
      "QUICK_SYMBOL", "RANGE_SYMBOL", "READS_SYMBOL", "READ_ONLY_SYMBOL", 
      "READ_SYMBOL", "READ_WRITE_SYMBOL", "REAL_SYMBOL", "REBUILD_SYMBOL", 
      "RECOVER_SYMBOL", "REDOFILE_SYMBOL", "REDO_BUFFER_SIZE_SYMBOL", "REDUNDANT_SYMBOL", 
      "REFERENCES_SYMBOL", "REGEXP_SYMBOL", "RELAY_SYMBOL", "RELAYLOG_SYMBOL", 
      "RELAY_LOG_FILE_SYMBOL", "RELAY_LOG_POS_SYMBOL", "RELAY_THREAD_SYMBOL", 
      "RELEASE_SYMBOL", "RELOAD_SYMBOL", "REMOVE_SYMBOL", "RENAME_SYMBOL", 
      "REORGANIZE_SYMBOL", "REPAIR_SYMBOL", "REPEATABLE_SYMBOL", "REPEAT_SYMBOL", 
      "REPLACE_SYMBOL", "REPLICATION_SYMBOL", "REPLICATE_DO_DB_SYMBOL", 
      "REPLICATE_IGNORE_DB_SYMBOL", "REPLICATE_DO_TABLE_SYMBOL", "REPLICATE_IGNORE_TABLE_SYMBOL", 
      "REPLICATE_WILD_DO_TABLE_SYMBOL", "REPLICATE_WILD_IGNORE_TABLE_SYMBOL", 
      "REPLICATE_REWRITE_DB_SYMBOL", "REQUIRE_SYMBOL", "RESET_SYMBOL", "RESIGNAL_SYMBOL", 
      "RESTORE_SYMBOL", "RESTRICT_SYMBOL", "RESUME_SYMBOL", "RETURNED_SQLSTATE_SYMBOL", 
      "RETURNS_SYMBOL", "RETURN_SYMBOL", "REVERSE_SYMBOL", "REVOKE_SYMBOL", 
      "RIGHT_SYMBOL", "RLIKE_SYMBOL", "ROLLBACK_SYMBOL", "ROLLUP_SYMBOL", 
      "ROTATE_SYMBOL", "ROUTINE_SYMBOL", "ROWS_SYMBOL", "ROW_COUNT_SYMBOL", 
      "ROW_FORMAT_SYMBOL", "ROW_SYMBOL", "RTREE_SYMBOL", "SAVEPOINT_SYMBOL", 
      "SCHEDULE_SYMBOL", "SCHEMA_SYMBOL", "SCHEMA_NAME_SYMBOL", "SCHEMAS_SYMBOL", 
      "SECOND_MICROSECOND_SYMBOL", "SECOND_SYMBOL", "SECURITY_SYMBOL", "SELECT_SYMBOL", 
      "SENSITIVE_SYMBOL", "SEPARATOR_SYMBOL", "SERIALIZABLE_SYMBOL", "SERIAL_SYMBOL", 
      "SESSION_SYMBOL", "SERVER_SYMBOL", "SERVER_OPTIONS_SYMBOL", "SESSION_USER_SYMBOL", 
      "SET_SYMBOL", "SET_VAR_SYMBOL", "SHARE_SYMBOL", "SHOW_SYMBOL", "SHUTDOWN_SYMBOL", 
      "SIGNAL_SYMBOL", "SIGNED_SYMBOL", "SIMPLE_SYMBOL", "SLAVE_SYMBOL", 
      "SLOW_SYMBOL", "SMALLINT_SYMBOL", "SNAPSHOT_SYMBOL", "SOME_SYMBOL", 
      "SOCKET_SYMBOL", "SONAME_SYMBOL", "SOUNDS_SYMBOL", "SOURCE_SYMBOL", 
      "SPATIAL_SYMBOL", "SPECIFIC_SYMBOL", "SQLEXCEPTION_SYMBOL", "SQLSTATE_SYMBOL", 
      "SQLWARNING_SYMBOL", "SQL_AFTER_GTIDS_SYMBOL", "SQL_AFTER_MTS_GAPS_SYMBOL", 
      "SQL_BEFORE_GTIDS_SYMBOL", "SQL_BIG_RESULT_SYMBOL", "SQL_BUFFER_RESULT_SYMBOL", 
      "SQL_CACHE_SYMBOL", "SQL_CALC_FOUND_ROWS_SYMBOL", "SQL_NO_CACHE_SYMBOL", 
      "SQL_SMALL_RESULT_SYMBOL", "SQL_SYMBOL", "SQL_THREAD_SYMBOL", "SSL_SYMBOL", 
      "STACKED_SYMBOL", "STARTING_SYMBOL", "STARTS_SYMBOL", "START_SYMBOL", 
      "STATS_AUTO_RECALC_SYMBOL", "STATS_PERSISTENT_SYMBOL", "STATS_SAMPLE_PAGES_SYMBOL", 
      "STATUS_SYMBOL", "STDDEV_SAMP_SYMBOL", "STDDEV_SYMBOL", "STDDEV_POP_SYMBOL", 
      "STD_SYMBOL", "STOP_SYMBOL", "STORAGE_SYMBOL", "STORED_SYMBOL", "STRAIGHT_JOIN_SYMBOL", 
      "STRING_SYMBOL", "SUBCLASS_ORIGIN_SYMBOL", "SUBDATE_SYMBOL", "SUBJECT_SYMBOL", 
      "SUBPARTITIONS_SYMBOL", "SUBPARTITION_SYMBOL", "SUBSTR_SYMBOL", "SUBSTRING_SYMBOL", 
      "SUM_SYMBOL", "SUPER_SYMBOL", "SUSPEND_SYMBOL", "SWAPS_SYMBOL", "SWITCHES_SYMBOL", 
      "SYSDATE_SYMBOL", "SYSTEM_USER_SYMBOL", "TABLES_SYMBOL", "TABLESPACE_SYMBOL", 
      "TABLE_REF_PRIORITY_SYMBOL", "TABLE_SYMBOL", "TABLE_CHECKSUM_SYMBOL", 
      "TABLE_NAME_SYMBOL", "TEMPORARY_SYMBOL", "TEMPTABLE_SYMBOL", "TERMINATED_SYMBOL", 
      "TEXT_SYMBOL", "THAN_SYMBOL", "THEN_SYMBOL", "TIMESTAMP_SYMBOL", "TIMESTAMP_ADD_SYMBOL", 
      "TIMESTAMP_DIFF_SYMBOL", "TIME_SYMBOL", "TINYBLOB_SYMBOL", "TINYINT_SYMBOL", 
      "TINYTEXT_SYMBOL", "TO_SYMBOL", "TRAILING_SYMBOL", "TRANSACTION_SYMBOL", 
      "TRIGGERS_SYMBOL", "TRIGGER_SYMBOL", "TRIM_SYMBOL", "TRUE_SYMBOL", 
      "TRUNCATE_SYMBOL", "TYPES_SYMBOL", "TYPE_SYMBOL", "UDF_RETURNS_SYMBOL", 
      "UNCOMMITTED_SYMBOL", "UNDEFINED_SYMBOL", "UNDOFILE_SYMBOL", "UNDO_BUFFER_SIZE_SYMBOL", 
      "UNDO_SYMBOL", "UNICODE_SYMBOL", "UNINSTALL_SYMBOL", "UNION_SYMBOL", 
      "UNIQUE_SYMBOL", "UNKNOWN_SYMBOL", "UNLOCK_SYMBOL", "UNSIGNED_SYMBOL", 
      "UNTIL_SYMBOL", "UPDATE_SYMBOL", "UPGRADE_SYMBOL", "USAGE_SYMBOL", 
      "USER_RESOURCES_SYMBOL", "USER_SYMBOL", "USE_FRM_SYMBOL", "USE_SYMBOL", 
      "USING_SYMBOL", "UTC_DATE_SYMBOL", "UTC_TIMESTAMP_SYMBOL", "UTC_TIME_SYMBOL", 
      "VALIDATION_SYMBOL", "VALUES_SYMBOL", "VALUE_SYMBOL", "VARBINARY_SYMBOL", 
      "VARCHAR_SYMBOL", "VARCHARACTER_SYMBOL", "VARIABLES_SYMBOL", "VARIANCE_SYMBOL", 
      "VARYING_SYMBOL", "VAR_POP_SYMBOL", "VAR_SAMP_SYMBOL", "VIEW_SYMBOL", 
      "VIRTUAL_SYMBOL", "WAIT_SYMBOL", "WARNINGS_SYMBOL", "WEEK_SYMBOL", 
      "WEIGHT_STRING_SYMBOL", "WHEN_SYMBOL", "WHERE_SYMBOL", "WHILE_SYMBOL", 
      "WITH_SYMBOL", "WITHOUT_SYMBOL", "WORK_SYMBOL", "WRAPPER_SYMBOL", 
      "WRITE_SYMBOL", "X509_SYMBOL", "XA_SYMBOL", "XID_SYMBOL", "XML_SYMBOL", 
      "XOR_SYMBOL", "YEAR_MONTH_SYMBOL", "YEAR_SYMBOL", "ZEROFILL_SYMBOL", 
      "PERSIST_SYMBOL", "ROLE_SYMBOL", "ADMIN_SYMBOL", "INVISIBLE_SYMBOL", 
      "VISIBLE_SYMBOL", "EXCEPT_SYMBOL", "COMPONENT_SYMBOL", "RECURSIVE_SYMBOL", 
      "JSON_OBJECTAGG_SYMBOL", "JSON_ARRAYAGG_SYMBOL", "OF_SYMBOL", "SKIP_SYMBOL", 
      "LOCKED_SYMBOL", "NOWAIT_SYMBOL", "GROUPING_SYMBOL", "PERSIST_ONLY_SYMBOL", 
      "HISTOGRAM_SYMBOL", "BUCKETS_SYMBOL", "REMOTE_SYMBOL", "CLONE_SYMBOL", 
      "CUME_DIST_SYMBOL", "DENSE_RANK_SYMBOL", "EXCLUDE_SYMBOL", "FIRST_VALUE_SYMBOL", 
      "FOLLOWING_SYMBOL", "GROUPS_SYMBOL", "LAG_SYMBOL", "LAST_VALUE_SYMBOL", 
      "LEAD_SYMBOL", "NTH_VALUE_SYMBOL", "NTILE_SYMBOL", "NULLS_SYMBOL", 
      "OTHERS_SYMBOL", "OVER_SYMBOL", "PERCENT_RANK_SYMBOL", "PRECEDING_SYMBOL", 
      "RANK_SYMBOL", "RESPECT_SYMBOL", "ROW_NUMBER_SYMBOL", "TIES_SYMBOL", 
      "UNBOUNDED_SYMBOL", "WINDOW_SYMBOL", "EMPTY_SYMBOL", "JSON_TABLE_SYMBOL", 
      "NESTED_SYMBOL", "ORDINALITY_SYMBOL", "PATH_SYMBOL", "HISTORY_SYMBOL", 
      "REUSE_SYMBOL", "SRID_SYMBOL", "THREAD_PRIORITY_SYMBOL", "RESOURCE_SYMBOL", 
      "SYSTEM_SYMBOL", "VCPU_SYMBOL", "MASTER_PUBLIC_KEY_PATH_SYMBOL", "GET_MASTER_PUBLIC_KEY_SYMBOL", 
      "RESTART_SYMBOL", "DEFINITION_SYMBOL", "DESCRIPTION_SYMBOL", "ORGANIZATION_SYMBOL", 
      "REFERENCE_SYMBOL", "OPTIONAL_SYMBOL", "SECONDARY_SYMBOL", "SECONDARY_ENGINE_SYMBOL", 
      "SECONDARY_LOAD_SYMBOL", "SECONDARY_UNLOAD_SYMBOL", "ACTIVE_SYMBOL", 
      "INACTIVE_SYMBOL", "LATERAL_SYMBOL", "RETAIN_SYMBOL", "OLD_SYMBOL", 
      "NETWORK_NAMESPACE_SYMBOL", "ENFORCED_SYMBOL", "ARRAY_SYMBOL", "OJ_SYMBOL", 
      "MEMBER_SYMBOL", "RANDOM_SYMBOL", "MASTER_COMPRESSION_ALGORITHM_SYMBOL", 
      "MASTER_ZSTD_COMPRESSION_LEVEL_SYMBOL", "PRIVILEGE_CHECKS_USER_SYMBOL", 
      "MASTER_TLS_CIPHERSUITES_SYMBOL", "REQUIRE_ROW_FORMAT_SYMBOL", "PASSWORD_LOCK_TIME_SYMBOL", 
      "FAILED_LOGIN_ATTEMPTS_SYMBOL", "REQUIRE_TABLE_PRIMARY_KEY_CHECK_SYMBOL", 
      "STREAM_SYMBOL", "OFF_SYMBOL", "NOT2_SYMBOL", "CONCAT_PIPES_SYMBOL", 
      "INT_NUMBER", "LONG_NUMBER", "ULONGLONG_NUMBER", "EQUAL_OPERATOR", 
      "ASSIGN_OPERATOR", "NULL_SAFE_EQUAL_OPERATOR", "GREATER_OR_EQUAL_OPERATOR", 
      "GREATER_THAN_OPERATOR", "LESS_OR_EQUAL_OPERATOR", "LESS_THAN_OPERATOR", 
      "NOT_EQUAL_OPERATOR", "PLUS_OPERATOR", "MINUS_OPERATOR", "MULT_OPERATOR", 
      "DIV_OPERATOR", "MOD_OPERATOR", "LOGICAL_NOT_OPERATOR", "BITWISE_NOT_OPERATOR", 
      "SHIFT_LEFT_OPERATOR", "SHIFT_RIGHT_OPERATOR", "LOGICAL_AND_OPERATOR", 
      "BITWISE_AND_OPERATOR", "BITWISE_XOR_OPERATOR", "LOGICAL_OR_OPERATOR", 
      "BITWISE_OR_OPERATOR", "DOT_SYMBOL", "COMMA_SYMBOL", "SEMICOLON_SYMBOL", 
      "COLON_SYMBOL", "OPEN_PAR_SYMBOL", "CLOSE_PAR_SYMBOL", "OPEN_CURLY_SYMBOL", 
      "CLOSE_CURLY_SYMBOL", "UNDERLINE_SYMBOL", "JSON_SEPARATOR_SYMBOL", 
      "JSON_UNQUOTED_SEPARATOR_SYMBOL", "AT_SIGN_SYMBOL", "AT_TEXT_SUFFIX", 
      "AT_AT_SIGN_SYMBOL", "NULL2_SYMBOL", "PARAM_MARKER", "HEX_NUMBER", 
      "BIN_NUMBER", "DECIMAL_NUMBER", "FLOAT_NUMBER", "WHITESPACE", "INVALID_INPUT", 
      "UNDERSCORE_CHARSET", "IDENTIFIER", "NCHAR_TEXT", "BACK_TICK_QUOTED_ID", 
      "DOUBLE_QUOTED_TEXT", "SINGLE_QUOTED_TEXT", "VERSION_COMMENT_START", 
      "MYSQL_COMMENT_START", "VERSION_COMMENT_END", "BLOCK_COMMENT", "POUND_COMMENT", 
      "DASHDASH_COMMENT", "NOT_EQUAL2_OPERATOR"
    }
  );
  static const int32_t serializedATNSegment[] = {
  	4,1,806,8417,2,0,7,0,2,1,7,1,2,2,7,2,2,3,7,3,2,4,7,4,2,5,7,5,2,6,7,6,
  	2,7,7,7,2,8,7,8,2,9,7,9,2,10,7,10,2,11,7,11,2,12,7,12,2,13,7,13,2,14,
  	7,14,2,15,7,15,2,16,7,16,2,17,7,17,2,18,7,18,2,19,7,19,2,20,7,20,2,21,
  	7,21,2,22,7,22,2,23,7,23,2,24,7,24,2,25,7,25,2,26,7,26,2,27,7,27,2,28,
  	7,28,2,29,7,29,2,30,7,30,2,31,7,31,2,32,7,32,2,33,7,33,2,34,7,34,2,35,
  	7,35,2,36,7,36,2,37,7,37,2,38,7,38,2,39,7,39,2,40,7,40,2,41,7,41,2,42,
  	7,42,2,43,7,43,2,44,7,44,2,45,7,45,2,46,7,46,2,47,7,47,2,48,7,48,2,49,
  	7,49,2,50,7,50,2,51,7,51,2,52,7,52,2,53,7,53,2,54,7,54,2,55,7,55,2,56,
  	7,56,2,57,7,57,2,58,7,58,2,59,7,59,2,60,7,60,2,61,7,61,2,62,7,62,2,63,
  	7,63,2,64,7,64,2,65,7,65,2,66,7,66,2,67,7,67,2,68,7,68,2,69,7,69,2,70,
  	7,70,2,71,7,71,2,72,7,72,2,73,7,73,2,74,7,74,2,75,7,75,2,76,7,76,2,77,
  	7,77,2,78,7,78,2,79,7,79,2,80,7,80,2,81,7,81,2,82,7,82,2,83,7,83,2,84,
  	7,84,2,85,7,85,2,86,7,86,2,87,7,87,2,88,7,88,2,89,7,89,2,90,7,90,2,91,
  	7,91,2,92,7,92,2,93,7,93,2,94,7,94,2,95,7,95,2,96,7,96,2,97,7,97,2,98,
  	7,98,2,99,7,99,2,100,7,100,2,101,7,101,2,102,7,102,2,103,7,103,2,104,
  	7,104,2,105,7,105,2,106,7,106,2,107,7,107,2,108,7,108,2,109,7,109,2,110,
  	7,110,2,111,7,111,2,112,7,112,2,113,7,113,2,114,7,114,2,115,7,115,2,116,
  	7,116,2,117,7,117,2,118,7,118,2,119,7,119,2,120,7,120,2,121,7,121,2,122,
  	7,122,2,123,7,123,2,124,7,124,2,125,7,125,2,126,7,126,2,127,7,127,2,128,
  	7,128,2,129,7,129,2,130,7,130,2,131,7,131,2,132,7,132,2,133,7,133,2,134,
  	7,134,2,135,7,135,2,136,7,136,2,137,7,137,2,138,7,138,2,139,7,139,2,140,
  	7,140,2,141,7,141,2,142,7,142,2,143,7,143,2,144,7,144,2,145,7,145,2,146,
  	7,146,2,147,7,147,2,148,7,148,2,149,7,149,2,150,7,150,2,151,7,151,2,152,
  	7,152,2,153,7,153,2,154,7,154,2,155,7,155,2,156,7,156,2,157,7,157,2,158,
  	7,158,2,159,7,159,2,160,7,160,2,161,7,161,2,162,7,162,2,163,7,163,2,164,
  	7,164,2,165,7,165,2,166,7,166,2,167,7,167,2,168,7,168,2,169,7,169,2,170,
  	7,170,2,171,7,171,2,172,7,172,2,173,7,173,2,174,7,174,2,175,7,175,2,176,
  	7,176,2,177,7,177,2,178,7,178,2,179,7,179,2,180,7,180,2,181,7,181,2,182,
  	7,182,2,183,7,183,2,184,7,184,2,185,7,185,2,186,7,186,2,187,7,187,2,188,
  	7,188,2,189,7,189,2,190,7,190,2,191,7,191,2,192,7,192,2,193,7,193,2,194,
  	7,194,2,195,7,195,2,196,7,196,2,197,7,197,2,198,7,198,2,199,7,199,2,200,
  	7,200,2,201,7,201,2,202,7,202,2,203,7,203,2,204,7,204,2,205,7,205,2,206,
  	7,206,2,207,7,207,2,208,7,208,2,209,7,209,2,210,7,210,2,211,7,211,2,212,
  	7,212,2,213,7,213,2,214,7,214,2,215,7,215,2,216,7,216,2,217,7,217,2,218,
  	7,218,2,219,7,219,2,220,7,220,2,221,7,221,2,222,7,222,2,223,7,223,2,224,
  	7,224,2,225,7,225,2,226,7,226,2,227,7,227,2,228,7,228,2,229,7,229,2,230,
  	7,230,2,231,7,231,2,232,7,232,2,233,7,233,2,234,7,234,2,235,7,235,2,236,
  	7,236,2,237,7,237,2,238,7,238,2,239,7,239,2,240,7,240,2,241,7,241,2,242,
  	7,242,2,243,7,243,2,244,7,244,2,245,7,245,2,246,7,246,2,247,7,247,2,248,
  	7,248,2,249,7,249,2,250,7,250,2,251,7,251,2,252,7,252,2,253,7,253,2,254,
  	7,254,2,255,7,255,2,256,7,256,2,257,7,257,2,258,7,258,2,259,7,259,2,260,
  	7,260,2,261,7,261,2,262,7,262,2,263,7,263,2,264,7,264,2,265,7,265,2,266,
  	7,266,2,267,7,267,2,268,7,268,2,269,7,269,2,270,7,270,2,271,7,271,2,272,
  	7,272,2,273,7,273,2,274,7,274,2,275,7,275,2,276,7,276,2,277,7,277,2,278,
  	7,278,2,279,7,279,2,280,7,280,2,281,7,281,2,282,7,282,2,283,7,283,2,284,
  	7,284,2,285,7,285,2,286,7,286,2,287,7,287,2,288,7,288,2,289,7,289,2,290,
  	7,290,2,291,7,291,2,292,7,292,2,293,7,293,2,294,7,294,2,295,7,295,2,296,
  	7,296,2,297,7,297,2,298,7,298,2,299,7,299,2,300,7,300,2,301,7,301,2,302,
  	7,302,2,303,7,303,2,304,7,304,2,305,7,305,2,306,7,306,2,307,7,307,2,308,
  	7,308,2,309,7,309,2,310,7,310,2,311,7,311,2,312,7,312,2,313,7,313,2,314,
  	7,314,2,315,7,315,2,316,7,316,2,317,7,317,2,318,7,318,2,319,7,319,2,320,
  	7,320,2,321,7,321,2,322,7,322,2,323,7,323,2,324,7,324,2,325,7,325,2,326,
  	7,326,2,327,7,327,2,328,7,328,2,329,7,329,2,330,7,330,2,331,7,331,2,332,
  	7,332,2,333,7,333,2,334,7,334,2,335,7,335,2,336,7,336,2,337,7,337,2,338,
  	7,338,2,339,7,339,2,340,7,340,2,341,7,341,2,342,7,342,2,343,7,343,2,344,
  	7,344,2,345,7,345,2,346,7,346,2,347,7,347,2,348,7,348,2,349,7,349,2,350,
  	7,350,2,351,7,351,2,352,7,352,2,353,7,353,2,354,7,354,2,355,7,355,2,356,
  	7,356,2,357,7,357,2,358,7,358,2,359,7,359,2,360,7,360,2,361,7,361,2,362,
  	7,362,2,363,7,363,2,364,7,364,2,365,7,365,2,366,7,366,2,367,7,367,2,368,
  	7,368,2,369,7,369,2,370,7,370,2,371,7,371,2,372,7,372,2,373,7,373,2,374,
  	7,374,2,375,7,375,2,376,7,376,2,377,7,377,2,378,7,378,2,379,7,379,2,380,
  	7,380,2,381,7,381,2,382,7,382,2,383,7,383,2,384,7,384,2,385,7,385,2,386,
  	7,386,2,387,7,387,2,388,7,388,2,389,7,389,2,390,7,390,2,391,7,391,2,392,
  	7,392,2,393,7,393,2,394,7,394,2,395,7,395,2,396,7,396,2,397,7,397,2,398,
  	7,398,2,399,7,399,2,400,7,400,2,401,7,401,2,402,7,402,2,403,7,403,2,404,
  	7,404,2,405,7,405,2,406,7,406,2,407,7,407,2,408,7,408,2,409,7,409,2,410,
  	7,410,2,411,7,411,2,412,7,412,2,413,7,413,2,414,7,414,2,415,7,415,2,416,
  	7,416,2,417,7,417,2,418,7,418,2,419,7,419,2,420,7,420,2,421,7,421,2,422,
  	7,422,2,423,7,423,2,424,7,424,2,425,7,425,2,426,7,426,2,427,7,427,2,428,
  	7,428,2,429,7,429,2,430,7,430,2,431,7,431,2,432,7,432,2,433,7,433,2,434,
  	7,434,2,435,7,435,2,436,7,436,2,437,7,437,2,438,7,438,2,439,7,439,2,440,
  	7,440,2,441,7,441,2,442,7,442,2,443,7,443,2,444,7,444,2,445,7,445,2,446,
  	7,446,2,447,7,447,2,448,7,448,2,449,7,449,2,450,7,450,2,451,7,451,2,452,
  	7,452,2,453,7,453,2,454,7,454,2,455,7,455,2,456,7,456,2,457,7,457,2,458,
  	7,458,2,459,7,459,2,460,7,460,2,461,7,461,2,462,7,462,2,463,7,463,2,464,
  	7,464,2,465,7,465,2,466,7,466,2,467,7,467,2,468,7,468,2,469,7,469,2,470,
  	7,470,2,471,7,471,2,472,7,472,2,473,7,473,2,474,7,474,2,475,7,475,2,476,
  	7,476,2,477,7,477,2,478,7,478,2,479,7,479,2,480,7,480,2,481,7,481,2,482,
  	7,482,2,483,7,483,2,484,7,484,2,485,7,485,2,486,7,486,2,487,7,487,2,488,
  	7,488,2,489,7,489,2,490,7,490,2,491,7,491,2,492,7,492,2,493,7,493,2,494,
  	7,494,2,495,7,495,2,496,7,496,2,497,7,497,2,498,7,498,2,499,7,499,2,500,
  	7,500,2,501,7,501,2,502,7,502,2,503,7,503,2,504,7,504,2,505,7,505,2,506,
  	7,506,2,507,7,507,2,508,7,508,2,509,7,509,2,510,7,510,2,511,7,511,2,512,
  	7,512,2,513,7,513,2,514,7,514,2,515,7,515,2,516,7,516,2,517,7,517,2,518,
  	7,518,2,519,7,519,2,520,7,520,2,521,7,521,2,522,7,522,2,523,7,523,2,524,
  	7,524,2,525,7,525,2,526,7,526,2,527,7,527,2,528,7,528,2,529,7,529,2,530,
  	7,530,2,531,7,531,2,532,7,532,2,533,7,533,2,534,7,534,2,535,7,535,2,536,
  	7,536,2,537,7,537,2,538,7,538,2,539,7,539,2,540,7,540,2,541,7,541,2,542,
  	7,542,2,543,7,543,2,544,7,544,2,545,7,545,2,546,7,546,2,547,7,547,2,548,
  	7,548,2,549,7,549,2,550,7,550,2,551,7,551,2,552,7,552,2,553,7,553,2,554,
  	7,554,2,555,7,555,2,556,7,556,2,557,7,557,2,558,7,558,2,559,7,559,2,560,
  	7,560,2,561,7,561,2,562,7,562,2,563,7,563,2,564,7,564,2,565,7,565,2,566,
  	7,566,2,567,7,567,2,568,7,568,2,569,7,569,2,570,7,570,2,571,7,571,2,572,
  	7,572,2,573,7,573,2,574,7,574,2,575,7,575,2,576,7,576,2,577,7,577,2,578,
  	7,578,2,579,7,579,2,580,7,580,2,581,7,581,2,582,7,582,2,583,7,583,2,584,
  	7,584,2,585,7,585,2,586,7,586,2,587,7,587,2,588,7,588,2,589,7,589,2,590,
  	7,590,2,591,7,591,2,592,7,592,2,593,7,593,2,594,7,594,2,595,7,595,2,596,
  	7,596,2,597,7,597,2,598,7,598,2,599,7,599,2,600,7,600,2,601,7,601,2,602,
  	7,602,2,603,7,603,2,604,7,604,2,605,7,605,2,606,7,606,2,607,7,607,2,608,
  	7,608,2,609,7,609,1,0,1,0,1,0,3,0,1224,8,0,1,0,1,0,3,0,1228,8,0,1,0,3,
  	0,1231,8,0,3,0,1233,8,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  	1,1,1,1,1,1,1,1,1,1,3,1,1269,8,1,1,2,1,2,1,2,1,2,1,2,1,2,3,2,1277,8,2,
  	1,2,1,2,1,2,3,2,1282,8,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,
  	1,2,1,2,1,2,3,2,1298,8,2,1,3,1,3,1,3,4,3,1303,8,3,11,3,12,3,1304,1,3,
  	1,3,1,3,1,3,1,3,3,3,1312,8,3,1,4,3,4,1315,8,4,1,4,1,4,1,4,1,4,1,4,3,4,
  	1322,8,4,1,4,1,4,1,4,3,4,1327,8,4,1,4,3,4,1330,8,4,1,4,1,4,1,4,3,4,1335,
  	8,4,1,4,1,4,1,4,1,4,3,4,1341,8,4,3,4,1343,8,4,1,4,1,4,3,4,1347,8,4,1,
  	4,1,4,3,4,1351,8,4,1,5,1,5,1,5,1,5,1,5,1,5,1,5,3,5,1360,8,5,1,6,1,6,3,
  	6,1364,8,6,1,6,5,6,1367,8,6,10,6,12,6,1370,9,6,1,7,1,7,1,7,3,7,1375,8,
  	7,1,8,1,8,1,8,1,8,1,9,3,9,1382,8,9,1,9,1,9,3,9,1386,8,9,1,9,1,9,1,9,3,
  	9,1391,8,9,1,10,1,10,1,10,3,10,1396,8,10,1,10,1,10,1,10,1,10,1,10,3,10,
  	1403,8,10,1,10,3,10,1406,8,10,1,11,1,11,1,11,1,11,3,11,1412,8,11,1,11,
  	3,11,1415,8,11,1,12,1,12,1,12,5,12,1420,8,12,10,12,12,12,1423,9,12,1,
  	13,1,13,1,13,1,13,1,13,1,13,1,13,3,13,1432,8,13,1,14,1,14,1,14,3,14,1437,
  	8,14,1,14,1,14,1,14,3,14,1442,8,14,1,14,1,14,1,14,1,14,1,14,1,14,3,14,
  	1450,8,14,1,14,1,14,1,14,1,14,3,14,1456,8,14,1,14,1,14,3,14,1460,8,14,
  	1,14,1,14,1,14,3,14,1465,8,14,1,14,1,14,1,14,1,14,1,14,5,14,1472,8,14,
  	10,14,12,14,1475,9,14,1,14,1,14,1,14,3,14,1480,8,14,1,14,1,14,5,14,1484,
  	8,14,10,14,12,14,1487,9,14,1,14,1,14,1,14,3,14,1492,8,14,1,14,1,14,1,
  	14,1,14,1,14,1,14,1,14,3,14,1501,8,14,1,14,1,14,1,14,1,14,3,14,1507,8,
  	14,1,14,1,14,1,14,1,14,1,14,1,14,1,14,3,14,1516,8,14,1,14,1,14,1,14,1,
  	14,1,14,1,14,1,14,1,14,1,14,1,14,1,14,1,14,3,14,1530,8,14,1,15,1,15,3,
  	15,1534,8,15,1,15,1,15,1,15,1,15,3,15,1540,8,15,5,15,1542,8,15,10,15,
  	12,15,1545,9,15,1,16,1,16,1,16,3,16,1550,8,16,1,17,1,17,3,17,1554,8,17,
  	1,17,1,17,1,17,3,17,1559,8,17,1,17,3,17,1562,8,17,1,17,1,17,1,17,1,17,
  	3,17,1568,8,17,1,17,1,17,1,17,1,17,3,17,1574,8,17,1,17,1,17,1,17,1,17,
  	3,17,1580,8,17,1,17,1,17,3,17,1584,8,17,1,17,1,17,1,17,3,17,1589,8,17,
  	1,17,1,17,3,17,1593,8,17,1,17,1,17,3,17,1597,8,17,1,17,1,17,1,17,1,17,
  	1,17,1,17,3,17,1605,8,17,3,17,1607,8,17,1,17,1,17,1,17,1,17,1,17,1,17,
  	1,17,1,17,1,17,1,17,1,17,3,17,1620,8,17,1,17,1,17,1,17,1,17,1,17,1,17,
  	3,17,1628,8,17,1,17,1,17,1,17,1,17,1,17,1,17,3,17,1636,8,17,1,17,1,17,
  	3,17,1640,8,17,1,17,1,17,1,17,1,17,1,17,1,17,1,17,1,17,1,17,1,17,1,17,
  	1,17,1,17,1,17,1,17,1,17,1,17,1,17,1,17,1,17,1,17,1,17,1,17,1,17,1,17,
  	1,17,1,17,3,17,1669,8,17,1,17,1,17,1,17,1,17,1,17,1,17,1,17,1,17,1,17,
  	1,17,1,17,1,17,1,17,1,17,3,17,1685,8,17,1,17,3,17,1688,8,17,1,17,1,17,
  	1,17,1,17,1,17,1,17,1,17,3,17,1697,8,17,1,18,1,18,1,18,3,18,1702,8,18,
  	1,19,1,19,1,20,1,20,3,20,1708,8,20,1,20,1,20,1,20,3,20,1713,8,20,5,20,
  	1715,8,20,10,20,12,20,1718,9,20,1,21,1,21,3,21,1722,8,21,1,21,1,21,3,
  	21,1726,8,21,1,22,1,22,3,22,1730,8,22,1,22,1,22,3,22,1734,8,22,1,23,1,
  	23,3,23,1738,8,23,1,23,1,23,3,23,1742,8,23,3,23,1744,8,23,1,24,1,24,1,
  	24,1,24,1,25,1,25,1,25,1,26,1,26,3,26,1755,8,26,1,27,1,27,1,27,1,27,1,
  	27,1,27,3,27,1763,8,27,1,27,1,27,1,27,1,27,1,27,1,27,1,27,3,27,1772,8,
  	27,1,27,5,27,1775,8,27,10,27,12,27,1778,9,27,3,27,1780,8,27,1,27,1,27,
  	1,27,3,27,1785,8,27,1,27,1,27,1,27,1,27,1,27,3,27,1792,8,27,1,28,1,28,
  	1,28,1,28,1,28,1,28,3,28,1800,8,28,1,29,1,29,3,29,1804,8,29,1,29,5,29,
  	1807,8,29,10,29,12,29,1810,9,29,1,30,1,30,1,31,1,31,3,31,1816,8,31,1,
  	31,5,31,1819,8,31,10,31,12,31,1822,9,31,1,32,1,32,3,32,1826,8,32,1,32,
  	1,32,1,32,1,32,1,32,1,32,3,32,1834,8,32,1,33,1,33,3,33,1838,8,33,1,33,
  	1,33,1,33,3,33,1843,8,33,1,34,3,34,1846,8,34,1,34,3,34,1849,8,34,1,34,
  	3,34,1852,8,34,1,34,1,34,1,34,1,34,1,35,3,35,1859,8,35,1,35,1,35,1,35,
  	1,36,1,36,3,36,1866,8,36,1,37,1,37,3,37,1870,8,37,1,37,1,37,1,37,1,38,
  	1,38,1,38,1,38,1,38,1,38,1,38,1,38,1,38,1,38,1,38,1,38,1,38,1,38,1,38,
  	1,38,1,38,1,38,1,38,3,38,1894,8,38,1,39,1,39,3,39,1898,8,39,1,39,1,39,
  	5,39,1902,8,39,10,39,12,39,1905,9,39,1,40,1,40,1,40,1,40,3,40,1911,8,
  	40,1,41,3,41,1914,8,41,1,41,1,41,3,41,1918,8,41,1,41,1,41,1,41,1,41,1,
  	41,3,41,1925,8,41,1,41,3,41,1928,8,41,1,41,3,41,1931,8,41,1,41,3,41,1934,
  	8,41,1,41,1,41,1,41,1,41,1,41,1,41,1,41,3,41,1943,8,41,1,42,1,42,1,42,
  	5,42,1948,8,42,10,42,12,42,1951,9,42,1,43,1,43,3,43,1955,8,43,1,44,3,
  	44,1958,8,44,1,44,3,44,1961,8,44,1,44,1,44,1,45,1,45,3,45,1967,8,45,1,
  	46,1,46,1,46,1,46,3,46,1973,8,46,1,46,3,46,1976,8,46,1,46,1,46,1,47,3,
  	47,1981,8,47,1,47,1,47,1,47,1,47,1,47,1,47,5,47,1989,8,47,10,47,12,47,
  	1992,9,47,3,47,1994,8,47,1,47,1,47,5,47,1998,8,47,10,47,12,47,2001,9,
  	47,1,47,1,47,1,48,3,48,2006,8,48,1,48,1,48,1,48,1,48,1,48,1,48,5,48,2014,
  	8,48,10,48,12,48,2017,9,48,3,48,2019,8,48,1,48,1,48,1,48,1,48,5,48,2025,
  	8,48,10,48,12,48,2028,9,48,1,48,1,48,1,49,3,49,2033,8,49,1,49,1,49,1,
  	49,1,49,1,49,1,49,1,49,1,50,1,50,3,50,2044,8,50,1,50,3,50,2047,8,50,1,
  	51,4,51,2050,8,51,11,51,12,51,2051,1,52,1,52,1,52,1,52,1,52,1,52,1,52,
  	1,52,1,52,1,52,1,52,1,52,1,52,1,52,1,52,1,52,1,52,3,52,2071,8,52,1,53,
  	3,53,2074,8,53,1,53,3,53,2077,8,53,1,53,1,53,1,53,1,53,3,53,2083,8,53,
  	1,53,3,53,2086,8,53,3,53,2088,8,53,1,53,1,53,5,53,2092,8,53,10,53,12,
  	53,2095,9,53,1,53,1,53,1,53,1,53,1,53,5,53,2102,8,53,10,53,12,53,2105,
  	9,53,1,53,1,53,1,53,1,53,1,53,5,53,2112,8,53,10,53,12,53,2115,9,53,3,
  	53,2117,8,53,1,53,3,53,2120,8,53,1,54,1,54,1,54,3,54,2125,8,54,1,54,1,
  	54,1,54,1,54,3,54,2131,8,54,1,55,1,55,1,55,1,55,1,56,1,56,1,56,1,56,1,
  	56,1,56,1,56,3,56,2144,8,56,1,57,1,57,3,57,2148,8,57,1,57,5,57,2151,8,
  	57,10,57,12,57,2154,9,57,1,58,1,58,1,58,1,58,1,58,1,58,3,58,2162,8,58,
  	1,59,1,59,1,59,1,59,1,59,1,59,1,59,1,59,1,60,1,60,1,60,1,60,1,60,5,60,
  	2177,8,60,10,60,12,60,2180,9,60,1,60,1,60,1,61,1,61,1,61,1,61,1,61,1,
  	61,1,61,1,61,1,61,1,61,1,61,1,61,1,61,1,61,3,61,2198,8,61,1,62,1,62,1,
  	62,1,62,1,62,1,62,1,62,3,62,2207,8,62,1,62,3,62,2210,8,62,1,63,1,63,1,
  	63,1,63,1,63,1,63,3,63,2218,8,63,1,64,1,64,1,64,3,64,2223,8,64,1,64,1,
  	64,3,64,2227,8,64,1,65,1,65,1,65,1,66,1,66,3,66,2234,8,66,1,66,5,66,2237,
  	8,66,10,66,12,66,2240,9,66,1,67,1,67,1,67,1,67,1,67,1,67,1,67,1,67,1,
  	67,1,67,1,67,1,67,3,67,2254,8,67,1,68,1,68,3,68,2258,8,68,1,68,1,68,1,
  	69,1,69,3,69,2264,8,69,1,69,1,69,1,70,1,70,3,70,2270,8,70,1,70,1,70,1,
  	71,1,71,3,71,2276,8,71,1,71,1,71,1,72,1,72,3,72,2282,8,72,1,72,1,72,1,
  	73,1,73,3,73,2288,8,73,1,73,1,73,1,74,3,74,2293,8,74,1,74,1,74,3,74,2297,
  	8,74,1,74,1,74,1,75,1,75,1,76,1,76,3,76,2305,8,76,1,76,1,76,1,77,1,77,
  	3,77,2311,8,77,1,77,1,77,1,78,1,78,3,78,2317,8,78,1,78,1,78,1,79,3,79,
  	2322,8,79,1,79,3,79,2325,8,79,1,79,3,79,2328,8,79,1,79,1,79,1,79,1,79,
  	1,80,1,80,1,80,3,80,2337,8,80,1,80,3,80,2340,8,80,1,81,1,81,1,81,1,81,
  	1,82,1,82,1,82,1,82,1,83,3,83,2351,8,83,1,83,1,83,1,83,1,83,1,83,1,83,
  	1,83,1,83,1,83,1,83,3,83,2363,8,83,1,83,1,83,1,84,1,84,1,84,1,84,1,85,
  	3,85,2372,8,85,1,85,1,85,3,85,2376,8,85,1,85,1,85,1,85,1,85,1,85,1,85,
  	1,85,3,85,2385,8,85,1,85,3,85,2388,8,85,1,85,1,85,1,85,1,85,3,85,2394,
  	8,85,3,85,2396,8,85,1,85,1,85,3,85,2400,8,85,1,85,1,85,1,85,1,86,1,86,
  	3,86,2407,8,86,1,86,1,86,1,87,1,87,1,87,1,87,1,87,1,87,1,87,5,87,2418,
  	8,87,10,87,12,87,2421,9,87,1,87,1,87,1,87,1,87,3,87,2427,8,87,1,87,1,
  	87,5,87,2431,8,87,10,87,12,87,2434,9,87,3,87,2436,8,87,1,88,1,88,1,88,
  	1,88,1,88,1,88,1,88,1,88,1,88,1,88,1,88,1,88,1,88,1,88,1,88,3,88,2453,
  	8,88,1,89,1,89,1,89,1,89,1,89,1,89,1,89,1,89,1,89,1,89,1,89,1,89,1,89,
  	1,89,1,89,1,89,1,89,1,89,3,89,2473,8,89,1,90,1,90,3,90,2477,8,90,1,90,
  	1,90,1,91,1,91,3,91,2483,8,91,1,91,1,91,1,92,1,92,3,92,2489,8,92,1,92,
  	1,92,1,93,1,93,3,93,2495,8,93,1,93,1,93,1,94,3,94,2500,8,94,1,94,1,94,
  	1,94,1,94,1,94,3,94,2507,8,94,1,95,1,95,1,95,1,95,1,95,3,95,2514,8,95,
  	1,95,5,95,2517,8,95,10,95,12,95,2520,9,95,3,95,2522,8,95,1,96,1,96,3,
  	96,2526,8,96,1,97,1,97,3,97,2530,8,97,1,97,1,97,1,98,3,98,2535,8,98,1,
  	98,1,98,3,98,2539,8,98,1,98,1,98,3,98,2543,8,98,1,99,1,99,1,99,1,99,3,
  	99,2549,8,99,1,99,5,99,2552,8,99,10,99,12,99,2555,9,99,3,99,2557,8,99,
  	1,100,1,100,3,100,2561,8,100,1,100,1,100,1,101,1,101,3,101,2567,8,101,
  	1,101,1,101,3,101,2571,8,101,1,102,1,102,3,102,2575,8,102,1,102,1,102,
  	1,103,1,103,1,103,1,103,3,103,2583,8,103,1,103,1,103,1,104,1,104,1,104,
  	1,104,3,104,2591,8,104,1,105,1,105,1,105,1,105,1,105,5,105,2598,8,105,
  	10,105,12,105,2601,9,105,1,106,1,106,1,106,1,106,1,107,1,107,3,107,2609,
  	8,107,1,107,1,107,1,108,1,108,1,108,1,108,1,108,1,109,1,109,1,109,1,109,
  	3,109,2622,8,109,1,109,3,109,2625,8,109,1,110,1,110,3,110,2629,8,110,
  	1,110,1,110,5,110,2633,8,110,10,110,12,110,2636,9,110,1,110,1,110,1,110,
  	1,110,1,110,3,110,2643,8,110,1,110,1,110,1,110,3,110,2648,8,110,1,110,
  	3,110,2651,8,110,1,110,3,110,2654,8,110,1,110,3,110,2657,8,110,1,110,
  	3,110,2660,8,110,3,110,2662,8,110,1,110,1,110,1,110,1,110,3,110,2668,
  	8,110,3,110,2670,8,110,1,111,1,111,1,111,1,111,1,111,1,111,1,112,1,112,
  	1,113,1,113,1,113,1,113,1,113,3,113,2685,8,113,1,114,1,114,1,114,1,114,
  	3,114,2691,8,114,1,114,1,114,1,114,1,114,1,114,3,114,2698,8,114,1,114,
  	3,114,2701,8,114,3,114,2703,8,114,3,114,2705,8,114,1,115,1,115,1,115,
  	1,115,1,115,1,115,1,115,1,115,3,115,2715,8,115,3,115,2717,8,115,1,116,
  	1,116,3,116,2721,8,116,1,116,3,116,2724,8,116,1,116,3,116,2727,8,116,
  	1,116,1,116,3,116,2731,8,116,1,116,1,116,1,116,3,116,2736,8,116,1,116,
  	1,116,1,116,1,116,3,116,2742,8,116,1,116,3,116,2745,8,116,1,116,3,116,
  	2748,8,116,1,117,1,117,1,118,1,118,3,118,2754,8,118,1,118,3,118,2757,
  	8,118,1,118,1,118,1,119,1,119,1,119,5,119,2764,8,119,10,119,12,119,2767,
  	9,119,1,120,1,120,1,120,1,121,1,121,1,121,3,121,2775,8,121,1,121,1,121,
  	3,121,2779,8,121,1,122,1,122,3,122,2783,8,122,1,122,1,122,1,122,1,122,
  	3,122,2789,8,122,1,122,5,122,2792,8,122,10,122,12,122,2795,9,122,1,123,
  	1,123,3,123,2799,8,123,1,123,1,123,1,123,3,123,2804,8,123,5,123,2806,
  	8,123,10,123,12,123,2809,9,123,1,124,1,124,1,124,3,124,2814,8,124,1,125,
  	1,125,1,125,1,125,1,125,1,125,1,126,1,126,1,126,3,126,2825,8,126,1,126,
  	3,126,2828,8,126,1,126,1,126,1,126,3,126,2833,8,126,1,126,1,126,1,126,
  	1,126,3,126,2839,8,126,1,126,3,126,2842,8,126,1,126,3,126,2845,8,126,
  	1,126,3,126,2848,8,126,1,126,3,126,2851,8,126,1,126,1,126,1,127,1,127,
  	1,128,1,128,1,128,1,128,1,128,1,129,1,129,1,129,3,129,2865,8,129,1,129,
  	3,129,2868,8,129,1,129,1,129,3,129,2872,8,129,1,130,1,130,3,130,2876,
  	8,130,1,130,1,130,1,131,1,131,3,131,2882,8,131,1,131,1,131,1,131,3,131,
  	2887,8,131,5,131,2889,8,131,10,131,12,131,2892,9,131,1,132,1,132,3,132,
  	2896,8,132,1,132,3,132,2899,8,132,1,132,1,132,3,132,2903,8,132,1,132,
  	1,132,1,132,1,132,3,132,2909,8,132,1,133,1,133,3,133,2913,8,133,1,133,
  	1,133,3,133,2917,8,133,1,134,1,134,1,134,1,134,1,134,1,134,1,134,3,134,
  	2926,8,134,1,134,1,134,1,134,3,134,2931,8,134,1,135,1,135,3,135,2935,
  	8,135,1,135,1,135,3,135,2939,8,135,1,135,3,135,2942,8,135,1,135,1,135,
  	3,135,2946,8,135,1,135,3,135,2949,8,135,3,135,2951,8,135,1,135,1,135,
  	3,135,2955,8,135,1,136,1,136,1,136,1,136,3,136,2961,8,136,1,136,1,136,
  	3,136,2965,8,136,3,136,2967,8,136,1,136,1,136,3,136,2971,8,136,1,136,
  	1,136,3,136,2975,8,136,5,136,2977,8,136,10,136,12,136,2980,9,136,1,137,
  	1,137,1,137,1,137,3,137,2986,8,137,3,137,2988,8,137,1,137,1,137,1,138,
  	1,138,1,138,1,138,1,138,3,138,2997,8,138,1,139,1,139,5,139,3001,8,139,
  	10,139,12,139,3004,9,139,1,139,1,139,3,139,3008,8,139,1,139,3,139,3011,
  	8,139,1,139,3,139,3014,8,139,1,139,3,139,3017,8,139,1,139,3,139,3020,
  	8,139,1,139,1,139,3,139,3024,8,139,1,140,1,140,1,141,1,141,1,142,1,142,
  	1,142,1,143,1,143,1,143,1,144,1,144,1,144,3,144,3039,8,144,1,145,1,145,
  	3,145,3043,8,145,1,146,1,146,1,146,1,146,3,146,3049,8,146,1,146,3,146,
  	3052,8,146,1,146,3,146,3055,8,146,1,146,1,146,1,146,1,146,3,146,3061,
  	8,146,1,146,1,146,1,146,3,146,3066,8,146,5,146,3068,8,146,10,146,12,146,
  	3071,9,146,3,146,3073,8,146,1,147,1,147,1,147,1,147,1,147,1,147,3,147,
  	3081,8,147,3,147,3083,8,147,1,147,1,147,1,148,1,148,1,148,1,149,1,149,
  	1,149,1,149,5,149,3094,8,149,10,149,12,149,3097,9,149,1,150,1,150,1,150,
  	1,150,1,151,1,151,1,151,1,151,1,152,3,152,3108,8,152,1,152,1,152,1,152,
  	3,152,3113,8,152,1,152,3,152,3116,8,152,1,152,3,152,3119,8,152,1,153,
  	1,153,1,153,3,153,3124,8,153,1,154,1,154,1,155,1,155,3,155,3130,8,155,
  	1,156,1,156,1,156,1,156,1,156,1,156,1,156,1,156,1,156,1,156,1,156,1,156,
  	1,156,1,156,3,156,3146,8,156,1,157,1,157,1,157,1,157,1,157,1,158,1,158,
  	1,158,1,158,1,158,1,158,1,158,1,158,1,158,1,158,1,158,1,158,1,158,3,158,
  	3166,8,158,1,159,1,159,1,159,1,159,1,159,1,159,1,159,3,159,3175,8,159,
  	1,160,1,160,3,160,3179,8,160,1,160,1,160,1,160,5,160,3184,8,160,10,160,
  	12,160,3187,9,160,1,161,1,161,3,161,3191,8,161,1,161,1,161,1,161,1,162,
  	1,162,1,162,1,162,3,162,3200,8,162,1,163,1,163,1,163,1,163,1,163,3,163,
  	3207,8,163,1,164,1,164,1,164,1,164,1,165,1,165,1,166,1,166,1,166,3,166,
  	3218,8,166,1,167,1,167,1,167,5,167,3223,8,167,10,167,12,167,3226,9,167,
  	1,168,1,168,1,168,1,168,5,168,3232,8,168,10,168,12,168,3235,9,168,1,169,
  	1,169,1,169,1,170,1,170,1,170,3,170,3243,8,170,1,170,1,170,1,171,1,171,
  	1,171,1,171,1,171,1,171,1,171,1,171,3,171,3255,8,171,1,172,4,172,3258,
  	8,172,11,172,12,172,3259,1,173,1,173,1,173,1,173,1,173,3,173,3267,8,173,
  	1,173,1,173,3,173,3271,8,173,1,173,1,173,1,173,1,173,3,173,3277,8,173,
  	1,174,1,174,1,174,3,174,3282,8,174,1,175,1,175,1,175,3,175,3287,8,175,
  	1,176,1,176,3,176,3291,8,176,1,176,1,176,5,176,3295,8,176,10,176,12,176,
  	3298,9,176,1,177,1,177,1,177,3,177,3303,8,177,3,177,3305,8,177,1,178,
  	3,178,3308,8,178,1,178,1,178,3,178,3312,8,178,1,179,1,179,1,179,1,180,
  	1,180,1,180,1,180,1,180,3,180,3322,8,180,1,180,1,180,1,180,3,180,3327,
  	8,180,1,180,5,180,3330,8,180,10,180,12,180,3333,9,180,1,181,1,181,5,181,
  	3337,8,181,10,181,12,181,3340,9,181,1,182,1,182,1,182,1,182,1,182,1,182,
  	3,182,3348,8,182,1,182,1,182,1,182,1,182,1,182,1,182,3,182,3356,8,182,
  	1,182,1,182,1,182,3,182,3361,8,182,1,183,1,183,3,183,3365,8,183,1,183,
  	1,183,1,183,1,183,3,183,3371,8,183,1,183,3,183,3374,8,183,1,184,3,184,
  	3377,8,184,1,184,1,184,3,184,3381,8,184,1,185,1,185,3,185,3385,8,185,
  	1,185,1,185,1,186,1,186,1,186,1,186,1,186,1,186,3,186,3395,8,186,1,187,
  	1,187,3,187,3399,8,187,1,187,3,187,3402,8,187,1,187,3,187,3405,8,187,
  	1,188,1,188,1,188,3,188,3410,8,188,1,188,1,188,1,189,1,189,3,189,3416,
  	8,189,1,189,1,189,3,189,3420,8,189,1,189,1,189,1,189,1,189,3,189,3426,
  	8,189,1,189,3,189,3429,8,189,3,189,3431,8,189,1,190,1,190,1,190,3,190,
  	3436,8,190,1,190,1,190,1,191,1,191,1,191,1,191,1,191,1,191,1,191,1,191,
  	3,191,3448,8,191,1,192,1,192,1,192,1,192,1,192,5,192,3455,8,192,10,192,
  	12,192,3458,9,192,1,192,1,192,1,193,1,193,1,193,1,193,1,193,1,193,1,193,
  	1,193,3,193,3470,8,193,1,193,3,193,3473,8,193,1,193,1,193,1,193,3,193,
  	3478,8,193,1,193,1,193,1,193,1,193,1,193,3,193,3485,8,193,1,194,1,194,
  	3,194,3489,8,194,1,194,1,194,3,194,3493,8,194,3,194,3495,8,194,1,195,
  	1,195,1,195,1,195,1,196,1,196,1,196,1,196,1,197,1,197,1,197,1,197,3,197,
  	3509,8,197,1,198,1,198,1,199,1,199,1,199,3,199,3516,8,199,1,199,1,199,
  	1,200,1,200,1,200,5,200,3523,8,200,10,200,12,200,3526,9,200,1,201,1,201,
  	1,201,3,201,3531,8,201,1,201,1,201,1,201,1,201,1,201,1,201,1,201,3,201,
  	3540,8,201,1,201,1,201,3,201,3544,8,201,1,201,1,201,3,201,3548,8,201,
  	1,202,1,202,1,203,1,203,1,204,1,204,1,204,1,204,3,204,3558,8,204,3,204,
  	3560,8,204,1,205,1,205,1,205,1,205,1,205,1,205,3,205,3568,8,205,1,206,
  	1,206,1,206,5,206,3573,8,206,10,206,12,206,3576,9,206,1,207,1,207,3,207,
  	3580,8,207,1,208,1,208,3,208,3584,8,208,1,208,1,208,3,208,3588,8,208,
  	1,208,3,208,3591,8,208,1,208,1,208,1,208,1,208,3,208,3597,8,208,1,208,
  	3,208,3600,8,208,1,208,3,208,3603,8,208,1,209,1,209,1,209,1,209,3,209,
  	3609,8,209,1,210,1,210,1,210,5,210,3614,8,210,10,210,12,210,3617,9,210,
  	1,210,1,210,3,210,3621,8,210,1,210,1,210,3,210,3625,8,210,1,210,3,210,
  	3628,8,210,1,210,3,210,3631,8,210,1,210,3,210,3634,8,210,3,210,3636,8,
  	210,1,211,1,211,3,211,3640,8,211,1,212,1,212,1,212,1,212,1,212,1,212,
  	3,212,3648,8,212,1,213,1,213,1,213,1,213,3,213,3654,8,213,1,213,1,213,
  	3,213,3658,8,213,1,213,1,213,1,213,3,213,3663,8,213,1,213,3,213,3666,
  	8,213,1,213,3,213,3669,8,213,1,213,3,213,3672,8,213,3,213,3674,8,213,
  	1,213,1,213,1,213,3,213,3679,8,213,1,214,1,214,1,214,1,214,1,214,5,214,
  	3686,8,214,10,214,12,214,3689,9,214,1,214,1,214,1,214,1,214,1,214,1,214,
  	1,214,1,214,1,214,1,214,3,214,3701,8,214,3,214,3703,8,214,1,215,1,215,
  	3,215,3707,8,215,1,215,1,215,1,216,1,216,3,216,3713,8,216,1,216,3,216,
  	3716,8,216,1,216,3,216,3719,8,216,1,217,1,217,1,217,1,217,3,217,3725,
  	8,217,1,217,1,217,1,217,1,217,1,217,3,217,3732,8,217,3,217,3734,8,217,
  	1,217,1,217,1,217,1,217,1,217,1,217,3,217,3742,8,217,1,217,1,217,1,217,
  	1,217,3,217,3748,8,217,1,218,1,218,1,218,3,218,3753,8,218,1,218,3,218,
  	3756,8,218,1,219,1,219,1,219,1,219,1,219,3,219,3763,8,219,3,219,3765,
  	8,219,1,220,1,220,1,220,1,220,1,220,1,220,1,220,3,220,3774,8,220,1,220,
  	1,220,1,220,1,220,1,220,5,220,3781,8,220,10,220,12,220,3784,9,220,1,220,
  	1,220,1,220,1,220,1,220,1,220,3,220,3792,8,220,1,220,1,220,1,220,1,220,
  	1,220,1,220,3,220,3800,8,220,1,221,1,221,3,221,3804,8,221,1,221,1,221,
  	1,221,1,221,1,221,3,221,3811,8,221,1,221,3,221,3814,8,221,3,221,3816,
  	8,221,1,222,1,222,1,222,1,222,1,222,1,222,3,222,3824,8,222,1,223,1,223,
  	1,223,1,223,3,223,3830,8,223,1,223,1,223,1,223,1,224,1,224,1,224,1,224,
  	1,224,3,224,3840,8,224,1,225,1,225,1,225,5,225,3845,8,225,10,225,12,225,
  	3848,9,225,1,226,1,226,1,226,1,226,1,226,1,226,1,226,1,226,1,226,1,226,
  	1,226,1,226,1,226,1,226,1,226,1,226,1,226,1,226,1,226,1,226,1,226,1,226,
  	1,226,1,226,1,226,1,226,1,226,1,226,1,226,1,226,1,226,1,226,1,226,1,226,
  	1,226,1,226,1,226,1,226,1,226,1,226,1,226,1,226,1,226,1,226,1,226,1,226,
  	1,226,1,226,1,226,1,226,1,226,1,226,1,226,1,226,1,226,1,226,1,226,1,226,
  	1,226,1,226,1,226,1,226,1,226,1,226,1,226,1,226,1,226,1,226,1,226,1,226,
  	1,226,1,226,1,226,1,226,1,226,1,226,1,226,1,226,1,226,1,226,1,226,1,226,
  	1,226,1,226,1,226,1,226,1,226,1,226,1,226,1,226,1,226,3,226,3941,8,226,
  	1,227,1,227,3,227,3945,8,227,1,228,1,228,1,229,1,229,3,229,3951,8,229,
  	1,230,1,230,1,230,1,230,1,230,1,230,1,230,1,230,1,230,1,230,1,230,1,230,
  	3,230,3965,8,230,1,231,1,231,1,231,1,231,5,231,3971,8,231,10,231,12,231,
  	3974,9,231,3,231,3976,8,231,1,231,1,231,1,232,1,232,1,232,1,232,1,232,
  	1,232,5,232,3986,8,232,10,232,12,232,3989,9,232,1,232,1,232,3,232,3993,
  	8,232,1,233,1,233,1,233,1,233,3,233,3999,8,233,1,233,1,233,1,233,1,233,
  	1,233,3,233,4006,8,233,1,233,1,233,1,233,1,233,1,233,3,233,4013,8,233,
  	1,233,1,233,1,233,1,233,1,233,3,233,4020,8,233,1,233,1,233,1,233,1,233,
  	1,233,3,233,4027,8,233,1,233,1,233,1,233,1,233,1,233,3,233,4034,8,233,
  	1,233,1,233,1,233,1,233,1,233,3,233,4041,8,233,1,233,3,233,4044,8,233,
  	1,234,1,234,1,234,5,234,4049,8,234,10,234,12,234,4052,9,234,1,235,1,235,
  	1,235,5,235,4057,8,235,10,235,12,235,4060,9,235,1,236,1,236,1,236,5,236,
  	4065,8,236,10,236,12,236,4068,9,236,1,237,1,237,1,238,1,238,1,238,5,238,
  	4075,8,238,10,238,12,238,4078,9,238,1,239,1,239,1,239,3,239,4083,8,239,
  	1,239,1,239,3,239,4087,8,239,1,239,1,239,3,239,4091,8,239,1,239,1,239,
  	1,239,3,239,4096,8,239,1,239,3,239,4099,8,239,3,239,4101,8,239,1,240,
  	1,240,1,240,1,240,1,240,1,240,1,240,3,240,4110,8,240,1,240,1,240,5,240,
  	4114,8,240,10,240,12,240,4117,9,240,1,241,1,241,1,241,1,241,3,241,4123,
  	8,241,1,241,1,241,1,241,3,241,4128,8,241,1,241,1,241,1,241,3,241,4133,
  	8,241,1,241,1,241,1,241,3,241,4138,8,241,1,241,3,241,4141,8,241,1,242,
  	1,242,1,242,5,242,4146,8,242,10,242,12,242,4149,9,242,1,243,1,243,1,244,
  	1,244,1,244,1,245,1,245,1,245,1,245,1,245,3,245,4161,8,245,1,245,1,245,
  	1,245,1,245,3,245,4167,8,245,1,246,1,246,1,246,1,246,3,246,4173,8,246,
  	1,247,1,247,1,247,5,247,4178,8,247,10,247,12,247,4181,9,247,1,248,1,248,
  	1,248,1,248,1,248,3,248,4188,8,248,1,248,1,248,1,248,1,248,3,248,4194,
  	8,248,1,248,1,248,1,248,1,248,1,248,1,248,1,248,1,248,1,248,1,248,3,248,
  	4206,8,248,3,248,4208,8,248,1,249,1,249,1,249,1,249,3,249,4214,8,249,
  	1,249,1,249,3,249,4218,8,249,3,249,4220,8,249,1,250,1,250,3,250,4224,
  	8,250,1,250,1,250,1,251,1,251,1,251,1,251,1,251,1,251,1,251,1,251,1,251,
  	3,251,4237,8,251,1,252,1,252,1,252,1,252,3,252,4243,8,252,1,252,1,252,
  	1,253,1,253,1,253,1,253,3,253,4251,8,253,1,253,1,253,1,253,1,253,1,253,
  	1,253,1,253,1,253,1,253,3,253,4262,8,253,1,253,1,253,3,253,4266,8,253,
  	1,253,1,253,1,253,1,253,1,253,1,253,1,253,1,253,1,253,1,253,1,253,3,253,
  	4279,8,253,1,253,1,253,1,253,1,253,1,253,3,253,4286,8,253,1,253,1,253,
  	1,253,1,253,3,253,4292,8,253,1,253,1,253,1,253,1,253,1,253,3,253,4299,
  	8,253,3,253,4301,8,253,1,254,1,254,1,254,1,255,1,255,1,255,1,255,1,255,
  	3,255,4311,8,255,1,255,1,255,1,255,1,255,1,256,1,256,3,256,4319,8,256,
  	1,256,3,256,4322,8,256,1,256,5,256,4325,8,256,10,256,12,256,4328,9,256,
  	1,256,3,256,4331,8,256,1,257,1,257,1,257,1,257,3,257,4337,8,257,1,257,
  	3,257,4340,8,257,1,258,1,258,1,258,3,258,4345,8,258,1,259,1,259,1,259,
  	1,259,1,259,1,259,1,259,1,259,1,259,4,259,4356,8,259,11,259,12,259,4357,
  	1,260,1,260,1,260,1,260,1,260,1,260,1,260,1,260,1,260,1,260,3,260,4370,
  	8,260,1,260,1,260,1,260,3,260,4375,8,260,1,260,1,260,1,260,1,260,1,260,
  	1,260,3,260,4383,8,260,1,260,1,260,1,260,1,260,3,260,4389,8,260,3,260,
  	4391,8,260,3,260,4393,8,260,1,261,1,261,1,261,1,261,3,261,4399,8,261,
  	1,261,1,261,1,262,1,262,1,262,1,262,1,262,1,262,1,262,1,262,3,262,4411,
  	8,262,1,262,1,262,1,262,3,262,4416,8,262,3,262,4418,8,262,1,262,1,262,
  	3,262,4422,8,262,1,262,1,262,1,262,1,262,3,262,4428,8,262,1,262,3,262,
  	4431,8,262,1,262,3,262,4434,8,262,1,262,1,262,1,262,1,262,1,262,1,262,
  	1,262,1,262,3,262,4444,8,262,3,262,4446,8,262,1,263,1,263,1,263,1,263,
  	3,263,4452,8,263,1,264,1,264,1,264,4,264,4457,8,264,11,264,12,264,4458,
  	1,264,1,264,1,264,1,264,3,264,4465,8,264,1,265,1,265,1,265,1,266,1,266,
  	1,266,1,266,1,266,3,266,4475,8,266,1,266,1,266,3,266,4479,8,266,1,267,
  	1,267,1,267,3,267,4484,8,267,1,268,1,268,1,268,1,269,1,269,1,269,1,269,
  	1,269,1,269,1,269,1,269,1,269,1,269,5,269,4499,8,269,10,269,12,269,4502,
  	9,269,1,270,1,270,1,270,1,270,1,270,1,270,1,270,1,270,1,270,1,270,1,270,
  	1,270,1,270,3,270,4517,8,270,1,270,1,270,1,270,3,270,4522,8,270,1,270,
  	1,270,1,270,1,270,1,270,1,270,3,270,4530,8,270,1,270,1,270,1,270,1,270,
  	1,270,1,270,3,270,4538,8,270,1,271,1,271,1,271,3,271,4543,8,271,1,271,
  	1,271,1,271,1,271,3,271,4549,8,271,1,271,3,271,4552,8,271,3,271,4554,
  	8,271,1,272,1,272,1,273,1,273,1,273,5,273,4561,8,273,10,273,12,273,4564,
  	9,273,1,274,1,274,1,274,3,274,4569,8,274,1,274,1,274,1,274,1,274,3,274,
  	4575,8,274,3,274,4577,8,274,1,274,1,274,3,274,4581,8,274,1,274,1,274,
  	1,274,1,274,1,274,1,274,1,274,1,274,1,274,3,274,4592,8,274,1,274,1,274,
  	1,274,1,274,1,274,1,274,1,274,1,274,3,274,4602,8,274,1,274,1,274,1,274,
  	3,274,4607,8,274,1,275,1,275,1,275,3,275,4612,8,275,1,275,1,275,1,275,
  	3,275,4617,8,275,1,275,1,275,1,275,1,275,1,275,1,275,3,275,4625,8,275,
  	1,276,1,276,3,276,4629,8,276,1,276,5,276,4632,8,276,10,276,12,276,4635,
  	9,276,1,277,1,277,1,277,1,277,1,277,1,277,3,277,4643,8,277,1,278,1,278,
  	1,278,1,278,1,278,1,278,1,278,1,278,1,278,1,278,3,278,4655,8,278,1,279,
  	1,279,1,279,1,279,1,279,1,279,1,279,1,279,1,279,1,279,1,279,1,279,3,279,
  	4669,8,279,1,279,1,279,1,279,1,279,1,279,1,279,1,279,3,279,4678,8,279,
  	3,279,4680,8,279,1,280,1,280,1,280,5,280,4685,8,280,10,280,12,280,4688,
  	9,280,1,281,1,281,1,281,1,281,3,281,4694,8,281,1,282,1,282,3,282,4698,
  	8,282,1,282,1,282,1,282,1,282,3,282,4704,8,282,1,282,1,282,1,282,1,282,
  	5,282,4710,8,282,10,282,12,282,4713,9,282,1,282,1,282,1,282,1,282,3,282,
  	4719,8,282,1,282,1,282,3,282,4723,8,282,1,282,1,282,1,282,1,282,3,282,
  	4729,8,282,1,282,1,282,1,282,5,282,4734,8,282,10,282,12,282,4737,9,282,
  	3,282,4739,8,282,1,283,1,283,1,283,1,283,1,283,1,283,1,283,3,283,4748,
  	8,283,1,283,1,283,1,283,1,283,3,283,4754,8,283,1,284,1,284,1,284,3,284,
  	4759,8,284,1,285,1,285,1,286,1,286,1,286,1,286,1,286,1,286,1,286,1,286,
  	1,286,1,286,1,286,1,286,1,286,1,286,1,286,1,286,1,286,5,286,4780,8,286,
  	10,286,12,286,4783,9,286,3,286,4785,8,286,1,287,1,287,1,287,1,288,1,288,
  	1,288,1,288,1,288,1,288,1,288,1,288,1,288,1,288,1,288,3,288,4801,8,288,
  	1,288,1,288,1,288,3,288,4806,8,288,1,288,3,288,4809,8,288,1,288,1,288,
  	3,288,4813,8,288,1,288,3,288,4816,8,288,1,288,1,288,1,288,1,288,1,288,
  	1,288,1,288,1,288,1,288,1,288,1,288,1,288,3,288,4830,8,288,1,288,1,288,
  	1,288,1,288,3,288,4836,8,288,1,288,1,288,1,288,3,288,4841,8,288,1,288,
  	3,288,4844,8,288,3,288,4846,8,288,1,289,1,289,3,289,4850,8,289,1,289,
  	1,289,1,289,3,289,4855,8,289,3,289,4857,8,289,1,290,1,290,1,290,1,291,
  	1,291,1,291,1,291,1,291,1,291,1,291,3,291,4869,8,291,1,292,1,292,5,292,
  	4873,8,292,10,292,12,292,4876,9,292,1,293,1,293,1,293,1,293,1,293,1,293,
  	1,293,1,293,1,293,1,293,1,293,1,293,1,293,1,293,1,293,1,293,1,293,1,293,
  	1,293,3,293,4897,8,293,1,293,1,293,3,293,4901,8,293,3,293,4903,8,293,
  	1,294,1,294,1,294,1,294,1,294,1,294,3,294,4911,8,294,1,295,1,295,3,295,
  	4915,8,295,1,295,1,295,1,296,1,296,1,296,1,296,1,296,3,296,4924,8,296,
  	1,297,1,297,1,297,1,297,1,298,1,298,1,298,1,298,3,298,4934,8,298,1,299,
  	1,299,1,299,1,299,1,299,3,299,4941,8,299,1,299,3,299,4944,8,299,1,299,
  	1,299,3,299,4948,8,299,1,299,3,299,4951,8,299,1,299,3,299,4954,8,299,
  	1,299,1,299,3,299,4958,8,299,1,299,3,299,4961,8,299,1,299,1,299,3,299,
  	4965,8,299,1,299,3,299,4968,8,299,1,299,1,299,1,299,3,299,4973,8,299,
  	1,299,3,299,4976,8,299,1,299,1,299,1,299,3,299,4981,8,299,1,299,3,299,
  	4984,8,299,1,299,1,299,1,299,1,299,3,299,4990,8,299,1,299,1,299,3,299,
  	4994,8,299,1,299,1,299,1,299,1,299,3,299,5000,8,299,1,299,3,299,5003,
  	8,299,1,299,1,299,1,299,1,299,1,299,1,299,1,299,3,299,5012,8,299,3,299,
  	5014,8,299,1,299,1,299,1,299,1,299,3,299,5020,8,299,1,299,1,299,3,299,
  	5024,8,299,1,299,3,299,5027,8,299,1,299,3,299,5030,8,299,1,299,1,299,
  	3,299,5034,8,299,1,299,1,299,1,299,1,299,3,299,5040,8,299,1,299,3,299,
  	5043,8,299,1,299,3,299,5046,8,299,1,299,1,299,1,299,1,299,1,299,1,299,
  	1,299,1,299,3,299,5056,8,299,1,299,1,299,3,299,5060,8,299,1,299,1,299,
  	1,299,1,299,1,299,5,299,5067,8,299,10,299,12,299,5070,9,299,3,299,5072,
  	8,299,1,299,1,299,1,299,3,299,5077,8,299,1,299,3,299,5080,8,299,1,299,
  	3,299,5083,8,299,1,299,1,299,3,299,5087,8,299,1,299,3,299,5090,8,299,
  	1,299,1,299,1,299,3,299,5095,8,299,1,299,1,299,3,299,5099,8,299,1,299,
  	1,299,1,299,1,299,1,299,1,299,3,299,5107,8,299,1,299,1,299,1,299,1,299,
  	1,299,1,299,1,299,1,299,1,299,1,299,1,299,3,299,5120,8,299,1,299,1,299,
  	1,299,1,299,1,299,1,299,1,299,1,299,1,299,1,299,1,299,1,299,1,299,1,299,
  	1,299,1,299,3,299,5138,8,299,1,299,1,299,1,299,3,299,5143,8,299,1,299,
  	1,299,1,299,3,299,5148,8,299,1,299,1,299,1,299,1,299,1,299,1,299,3,299,
  	5156,8,299,1,300,1,300,1,300,1,300,3,300,5162,8,300,3,300,5164,8,300,
  	1,301,1,301,3,301,5168,8,301,1,301,3,301,5171,8,301,1,302,1,302,1,303,
  	1,303,1,303,1,304,1,304,1,304,1,304,1,304,1,304,1,304,3,304,5185,8,304,
  	1,305,1,305,1,305,1,305,1,305,1,305,1,305,1,305,3,305,5195,8,305,1,305,
  	1,305,3,305,5199,8,305,1,305,1,305,1,305,1,305,5,305,5205,8,305,10,305,
  	12,305,5208,9,305,3,305,5210,8,305,1,305,1,305,3,305,5214,8,305,1,305,
  	1,305,1,305,1,305,1,305,1,305,1,305,1,305,3,305,5224,8,305,1,306,1,306,
  	3,306,5228,8,306,1,307,1,307,1,307,5,307,5233,8,307,10,307,12,307,5236,
  	9,307,1,308,1,308,3,308,5240,8,308,1,309,1,309,1,309,1,309,1,309,1,309,
  	3,309,5248,8,309,1,310,1,310,1,310,3,310,5253,8,310,1,310,1,310,1,311,
  	1,311,3,311,5259,8,311,1,312,1,312,1,312,5,312,5264,8,312,10,312,12,312,
  	5267,9,312,1,313,1,313,3,313,5271,8,313,1,313,1,313,1,313,1,313,3,313,
  	5277,8,313,1,313,1,313,1,313,1,313,1,313,3,313,5284,8,313,1,314,1,314,
  	1,315,1,315,1,315,1,315,1,315,1,315,3,315,5294,8,315,3,315,5296,8,315,
  	1,316,1,316,1,316,1,316,1,316,1,316,3,316,5304,8,316,1,317,1,317,1,317,
  	3,317,5309,8,317,1,317,1,317,3,317,5313,8,317,1,317,3,317,5316,8,317,
  	1,318,1,318,1,318,5,318,5321,8,318,10,318,12,318,5324,9,318,1,319,1,319,
  	3,319,5328,8,319,1,319,1,319,3,319,5332,8,319,1,320,1,320,1,320,1,320,
  	1,320,1,321,1,321,1,321,1,321,3,321,5343,8,321,1,322,1,322,1,322,1,322,
  	1,322,1,322,3,322,5351,8,322,1,322,1,322,3,322,5355,8,322,1,322,3,322,
  	5358,8,322,1,322,3,322,5361,8,322,1,323,1,323,3,323,5365,8,323,1,323,
  	1,323,3,323,5369,8,323,1,323,5,323,5372,8,323,10,323,12,323,5375,9,323,
  	1,324,1,324,1,324,3,324,5380,8,324,1,325,1,325,3,325,5384,8,325,1,325,
  	1,325,1,326,1,326,1,327,1,327,1,327,1,327,1,327,3,327,5395,8,327,1,327,
  	3,327,5398,8,327,1,327,3,327,5401,8,327,1,327,3,327,5404,8,327,1,328,
  	1,328,1,328,1,328,1,328,1,328,3,328,5412,8,328,1,329,1,329,3,329,5416,
  	8,329,1,329,5,329,5419,8,329,10,329,12,329,5422,9,329,1,330,1,330,1,330,
  	1,330,1,330,3,330,5429,8,330,1,331,1,331,1,331,1,331,1,331,1,331,3,331,
  	5437,8,331,1,332,1,332,1,332,1,332,3,332,5443,8,332,1,333,1,333,1,333,
  	1,333,1,333,1,333,1,333,1,333,1,333,1,333,1,333,1,333,1,333,1,333,1,333,
  	1,333,3,333,5461,8,333,1,333,1,333,1,334,1,334,1,334,1,334,1,334,1,334,
  	3,334,5471,8,334,1,334,1,334,1,334,1,334,3,334,5477,8,334,1,335,1,335,
  	1,335,1,336,1,336,1,336,1,337,1,337,1,338,1,338,1,338,1,338,3,338,5491,
  	8,338,1,338,3,338,5494,8,338,1,338,1,338,3,338,5498,8,338,1,338,1,338,
  	1,338,1,338,1,338,1,338,1,338,1,338,1,338,5,338,5509,8,338,10,338,12,
  	338,5512,9,338,1,339,1,339,1,339,1,339,1,339,1,339,3,339,5520,8,339,1,
  	339,1,339,1,339,1,339,1,339,1,339,1,339,1,339,1,339,1,339,5,339,5532,
  	8,339,10,339,12,339,5535,9,339,1,340,1,340,1,341,1,341,3,341,5541,8,341,
  	1,341,1,341,1,341,1,341,3,341,5547,8,341,1,341,1,341,1,341,1,341,3,341,
  	5553,8,341,1,342,1,342,1,342,1,342,1,342,1,342,3,342,5561,8,342,1,342,
  	1,342,1,342,1,342,1,342,1,342,1,342,1,342,1,342,3,342,5572,8,342,1,342,
  	1,342,3,342,5576,8,342,1,343,1,343,1,343,1,343,1,343,1,343,1,343,1,343,
  	1,343,1,343,1,343,1,343,1,343,1,343,1,343,1,343,1,343,1,343,1,343,1,343,
  	1,343,1,343,1,343,1,343,1,343,1,343,1,343,5,343,5605,8,343,10,343,12,
  	343,5608,9,343,1,344,1,344,1,344,1,344,1,344,3,344,5615,8,344,1,344,1,
  	344,3,344,5619,8,344,1,344,1,344,1,344,1,344,1,344,1,344,1,344,1,344,
  	1,344,1,344,1,344,1,344,1,344,1,344,1,344,3,344,5636,8,344,1,344,1,344,
  	1,344,1,344,1,344,3,344,5643,8,344,1,344,1,344,1,344,1,344,1,344,1,344,
  	1,344,1,344,1,344,1,344,1,344,1,344,3,344,5657,8,344,1,344,1,344,1,344,
  	1,344,1,344,1,344,1,344,1,344,1,344,1,344,3,344,5669,8,344,1,344,1,344,
  	1,344,1,344,3,344,5675,8,344,1,344,1,344,1,344,4,344,5680,8,344,11,344,
  	12,344,5681,1,344,3,344,5685,8,344,1,344,1,344,1,344,1,344,1,344,1,344,
  	1,344,1,344,1,344,1,344,1,344,1,344,1,344,1,344,1,344,1,344,1,344,1,344,
  	1,344,1,344,1,344,1,344,1,344,1,344,1,344,1,344,1,344,1,344,1,344,1,344,
  	1,344,1,344,3,344,5719,8,344,1,344,1,344,1,344,1,344,1,344,1,344,5,344,
  	5727,8,344,10,344,12,344,5730,9,344,1,345,1,345,1,345,1,346,1,346,1,346,
  	1,346,1,346,1,346,3,346,5741,8,346,1,347,1,347,1,347,3,347,5746,8,347,
  	1,347,1,347,1,347,1,347,3,347,5752,8,347,1,347,1,347,1,347,1,347,1,347,
  	1,347,3,347,5760,8,347,1,347,1,347,1,347,1,347,1,347,3,347,5767,8,347,
  	1,347,1,347,1,347,1,347,3,347,5773,8,347,1,347,1,347,1,347,3,347,5778,
  	8,347,1,347,1,347,1,347,1,347,3,347,5784,8,347,1,347,1,347,1,347,3,347,
  	5789,8,347,1,347,1,347,1,347,3,347,5794,8,347,1,347,1,347,1,347,1,347,
  	3,347,5800,8,347,1,347,1,347,1,347,3,347,5805,8,347,1,347,1,347,1,347,
  	1,347,3,347,5811,8,347,1,347,1,347,1,347,1,347,1,347,1,347,3,347,5819,
  	8,347,1,347,1,347,1,347,1,347,1,347,1,347,3,347,5827,8,347,1,347,1,347,
  	1,347,1,347,1,347,1,347,3,347,5835,8,347,1,347,1,347,1,347,1,347,1,347,
  	1,347,3,347,5843,8,347,1,347,1,347,1,347,3,347,5848,8,347,1,347,1,347,
  	1,347,1,347,3,347,5854,8,347,1,347,1,347,1,347,3,347,5859,8,347,1,347,
  	1,347,3,347,5863,8,347,1,347,1,347,3,347,5867,8,347,1,347,1,347,1,347,
  	3,347,5872,8,347,3,347,5874,8,347,1,348,1,348,1,348,1,348,1,348,1,349,
  	1,349,1,349,1,349,1,349,1,349,1,349,1,349,1,349,1,349,1,349,1,349,3,349,
  	5893,8,349,1,349,1,349,3,349,5897,8,349,1,349,1,349,1,349,1,349,1,349,
  	3,349,5904,8,349,1,349,1,349,1,349,1,349,1,349,1,349,1,349,1,349,1,349,
  	1,349,3,349,5916,8,349,1,349,3,349,5919,8,349,1,349,1,349,3,349,5923,
  	8,349,1,350,1,350,1,350,3,350,5928,8,350,1,351,1,351,1,351,3,351,5933,
  	8,351,1,351,1,351,3,351,5937,8,351,1,352,1,352,1,352,1,353,1,353,1,353,
  	1,353,1,353,3,353,5947,8,353,1,353,1,353,1,353,1,353,1,353,1,353,1,353,
  	3,353,5956,8,353,3,353,5958,8,353,1,354,3,354,5961,8,354,1,354,1,354,
  	1,355,1,355,1,355,1,355,1,355,3,355,5970,8,355,1,356,1,356,1,356,5,356,
  	5975,8,356,10,356,12,356,5978,9,356,1,357,1,357,1,357,1,357,1,357,1,357,
  	1,357,1,357,1,357,1,357,3,357,5990,8,357,1,357,1,357,1,357,3,357,5995,
  	8,357,1,358,1,358,1,358,1,358,1,358,3,358,6002,8,358,1,358,1,358,1,358,
  	1,358,3,358,6008,8,358,1,358,1,358,1,358,1,358,1,358,1,358,1,358,1,358,
  	1,358,1,358,1,358,1,358,1,358,1,358,1,358,1,358,1,358,1,358,1,358,1,358,
  	1,358,1,358,4,358,6032,8,358,11,358,12,358,6033,1,358,1,358,1,358,1,358,
  	1,358,1,358,1,358,1,358,1,358,1,358,1,358,1,358,1,358,1,358,1,358,1,358,
  	1,358,1,358,1,358,1,358,1,358,1,358,1,358,1,358,1,358,1,358,1,358,1,358,
  	1,358,3,358,6065,8,358,1,358,1,358,1,358,1,358,1,358,1,358,1,358,1,358,
  	1,358,1,358,1,358,1,358,1,358,1,358,1,358,1,358,1,358,1,358,3,358,6085,
  	8,358,1,358,1,358,1,358,1,358,3,358,6091,8,358,1,358,1,358,3,358,6095,
  	8,358,1,358,1,358,1,358,1,358,1,358,1,358,1,358,1,358,1,358,1,358,1,358,
  	1,358,1,358,1,358,1,358,1,358,1,358,1,358,1,358,1,358,1,358,1,358,1,358,
  	1,358,1,358,3,358,6122,8,358,1,358,1,358,1,358,1,358,1,358,1,358,1,358,
  	1,358,1,358,1,358,3,358,6134,8,358,1,358,1,358,1,358,1,358,1,358,1,358,
  	1,358,1,358,1,358,1,358,1,358,3,358,6147,8,358,1,358,1,358,3,358,6151,
  	8,358,1,358,1,358,3,358,6155,8,358,1,358,1,358,1,358,1,358,1,358,1,358,
  	1,358,1,358,1,358,1,358,1,358,1,358,1,358,1,358,1,358,1,358,1,358,1,358,
  	1,358,1,358,1,358,1,358,1,358,1,358,1,358,1,358,3,358,6183,8,358,1,358,
  	1,358,1,358,1,358,1,358,1,358,1,358,1,358,1,358,1,358,1,358,1,358,1,358,
  	1,358,1,358,1,358,1,358,1,358,1,358,1,358,1,358,1,358,1,358,1,358,1,358,
  	1,358,1,358,1,358,1,358,1,358,1,358,1,358,1,358,1,358,1,358,1,358,1,358,
  	1,358,1,358,1,358,1,358,1,358,1,358,1,358,1,358,1,358,1,358,1,358,1,358,
  	1,358,1,358,1,358,1,358,1,358,3,358,6239,8,358,1,358,1,358,1,358,1,358,
  	1,358,1,358,1,358,1,358,3,358,6249,8,358,1,358,1,358,3,358,6253,8,358,
  	1,358,1,358,1,358,1,358,1,358,1,358,1,358,1,358,1,358,1,358,3,358,6265,
  	8,358,1,358,1,358,1,358,3,358,6270,8,358,1,359,1,359,1,359,1,359,1,359,
  	1,359,1,359,1,359,1,359,1,359,1,359,3,359,6283,8,359,1,359,1,359,1,359,
  	1,359,1,359,1,359,1,359,1,359,1,359,1,359,1,359,1,359,1,359,1,359,1,359,
  	1,359,1,359,1,359,3,359,6303,8,359,1,360,1,360,3,360,6307,8,360,1,360,
  	1,360,1,361,1,361,1,361,1,362,1,362,1,362,1,362,1,362,1,362,1,362,1,362,
  	5,362,6322,8,362,10,362,12,362,6325,9,362,3,362,6327,8,362,1,363,1,363,
  	1,363,3,363,6332,8,363,1,363,3,363,6335,8,363,1,364,1,364,1,365,1,365,
  	1,365,1,365,1,365,3,365,6344,8,365,1,365,1,365,3,365,6348,8,365,1,365,
  	1,365,1,365,1,365,3,365,6354,8,365,1,365,1,365,1,365,1,365,3,365,6360,
  	8,365,1,365,1,365,3,365,6364,8,365,1,365,1,365,1,366,1,366,1,366,1,366,
  	1,366,1,366,1,366,3,366,6375,8,366,1,366,1,366,1,366,1,366,3,366,6381,
  	8,366,3,366,6383,8,366,1,366,1,366,1,367,1,367,1,367,3,367,6390,8,367,
  	1,367,1,367,1,367,1,367,1,367,3,367,6397,8,367,1,367,1,367,3,367,6401,
  	8,367,1,368,1,368,1,368,5,368,6406,8,368,10,368,12,368,6409,9,368,1,369,
  	1,369,3,369,6413,8,369,1,370,1,370,3,370,6417,8,370,1,371,1,371,1,371,
  	3,371,6422,8,371,1,372,1,372,3,372,6426,8,372,1,372,1,372,3,372,6430,
  	8,372,1,373,1,373,1,373,3,373,6435,8,373,1,373,1,373,1,373,3,373,6440,
  	8,373,3,373,6442,8,373,1,373,1,373,3,373,6446,8,373,1,374,1,374,1,374,
  	1,375,1,375,1,375,1,376,1,376,1,376,1,377,1,377,3,377,6459,8,377,1,377,
  	1,377,3,377,6463,8,377,1,377,3,377,6466,8,377,1,377,1,377,3,377,6470,
  	8,377,1,377,1,377,3,377,6474,8,377,1,377,1,377,3,377,6478,8,377,1,377,
  	1,377,1,377,3,377,6483,8,377,1,377,1,377,3,377,6487,8,377,1,377,1,377,
  	3,377,6491,8,377,1,377,1,377,1,377,1,377,1,377,1,377,1,377,3,377,6500,
  	8,377,3,377,6502,8,377,1,378,1,378,1,378,5,378,6507,8,378,10,378,12,378,
  	6510,9,378,1,379,1,379,1,379,3,379,6515,8,379,1,380,1,380,1,381,1,381,
  	1,382,1,382,3,382,6523,8,382,1,383,1,383,1,384,1,384,1,384,1,384,1,385,
  	1,385,1,385,1,385,1,386,1,386,1,386,1,386,1,387,1,387,1,387,5,387,6542,
  	8,387,10,387,12,387,6545,9,387,1,388,1,388,3,388,6549,8,388,1,389,1,389,
  	1,389,5,389,6554,8,389,10,389,12,389,6557,9,389,1,390,1,390,1,391,1,391,
  	1,391,1,391,1,391,1,392,1,392,1,392,1,392,1,392,1,392,1,392,1,392,1,392,
  	1,392,1,392,1,392,1,392,3,392,6579,8,392,1,393,1,393,1,393,1,394,1,394,
  	1,394,1,394,1,394,1,395,1,395,1,395,1,395,1,395,1,395,3,395,6595,8,395,
  	1,396,1,396,1,396,1,397,1,397,1,397,4,397,6603,8,397,11,397,12,397,6604,
  	1,398,1,398,3,398,6609,8,398,1,398,1,398,1,398,4,398,6614,8,398,11,398,
  	12,398,6615,1,398,3,398,6619,8,398,1,398,1,398,1,398,1,399,1,399,1,399,
  	1,400,1,400,1,400,3,400,6630,8,400,1,401,1,401,1,402,1,402,1,402,1,403,
  	1,403,3,403,6639,8,403,1,403,3,403,6642,8,403,1,403,1,403,1,404,1,404,
  	1,404,3,404,6649,8,404,1,405,1,405,1,405,3,405,6654,8,405,1,406,1,406,
  	1,406,1,406,1,406,1,407,1,407,1,407,1,407,1,407,1,407,1,407,1,408,1,408,
  	1,408,1,408,1,408,1,408,1,408,1,409,1,409,1,409,4,409,6678,8,409,11,409,
  	12,409,6679,1,410,1,410,1,410,1,410,3,410,6686,8,410,1,411,1,411,1,411,
  	1,411,3,411,6692,8,411,1,411,1,411,3,411,6696,8,411,1,412,1,412,1,412,
  	1,412,1,412,1,412,1,413,1,413,3,413,6706,8,413,1,414,1,414,3,414,6710,
  	8,414,1,414,1,414,1,415,1,415,1,415,1,415,1,415,1,415,1,415,5,415,6721,
  	8,415,10,415,12,415,6724,9,415,1,415,1,415,1,416,1,416,1,416,1,416,1,
  	416,1,416,1,416,3,416,6735,8,416,1,417,1,417,1,417,1,417,1,417,1,417,
  	1,418,1,418,1,418,1,419,1,419,1,419,1,420,1,420,1,420,1,420,3,420,6753,
  	8,420,1,420,1,420,1,420,1,420,5,420,6759,8,420,10,420,12,420,6762,9,420,
  	1,420,1,420,1,420,1,420,1,420,5,420,6769,8,420,10,420,12,420,6772,9,420,
  	3,420,6774,8,420,1,421,1,421,1,421,3,421,6779,8,421,1,422,1,422,3,422,
  	6783,8,422,1,422,1,422,1,422,1,423,1,423,3,423,6790,8,423,1,423,1,423,
  	1,423,3,423,6795,8,423,1,424,1,424,1,425,1,425,1,425,3,425,6802,8,425,
  	1,425,1,425,1,425,1,425,5,425,6808,8,425,10,425,12,425,6811,9,425,3,425,
  	6813,8,425,1,426,1,426,1,426,3,426,6818,8,426,1,426,1,426,1,426,1,426,
  	5,426,6824,8,426,10,426,12,426,6827,9,426,3,426,6829,8,426,1,427,1,427,
  	1,427,1,427,1,428,1,428,1,428,1,429,1,429,1,429,1,430,1,430,3,430,6843,
  	8,430,1,430,3,430,6846,8,430,1,430,1,430,1,430,1,430,1,431,1,431,1,431,
  	1,431,1,431,1,431,1,431,3,431,6859,8,431,1,431,1,431,3,431,6863,8,431,
  	3,431,6865,8,431,1,432,1,432,1,432,3,432,6870,8,432,1,433,1,433,1,433,
  	3,433,6875,8,433,1,434,1,434,1,434,1,435,3,435,6881,8,435,1,435,1,435,
  	1,436,1,436,3,436,6887,8,436,1,436,1,436,5,436,6891,8,436,10,436,12,436,
  	6894,9,436,1,436,1,436,3,436,6898,8,436,1,436,3,436,6901,8,436,1,436,
  	1,436,5,436,6905,8,436,10,436,12,436,6908,9,436,1,436,1,436,3,436,6912,
  	8,436,1,436,3,436,6915,8,436,1,436,1,436,5,436,6919,8,436,10,436,12,436,
  	6922,9,436,1,436,3,436,6925,8,436,1,436,1,436,1,436,1,436,3,436,6931,
  	8,436,3,436,6933,8,436,1,436,3,436,6936,8,436,1,436,1,436,5,436,6940,
  	8,436,10,436,12,436,6943,9,436,1,436,1,436,1,436,3,436,6948,8,436,1,436,
  	1,436,1,436,1,436,1,436,1,436,3,436,6956,8,436,3,436,6958,8,436,3,436,
  	6960,8,436,1,437,1,437,3,437,6964,8,437,1,438,1,438,5,438,6968,8,438,
  	10,438,12,438,6971,9,438,1,438,1,438,3,438,6975,8,438,1,438,1,438,3,438,
  	6979,8,438,1,438,1,438,1,438,3,438,6984,8,438,1,438,1,438,5,438,6988,
  	8,438,10,438,12,438,6991,9,438,1,438,1,438,5,438,6995,8,438,10,438,12,
  	438,6998,9,438,3,438,7000,8,438,3,438,7002,8,438,1,439,3,439,7005,8,439,
  	1,439,1,439,1,439,1,439,1,439,1,439,1,439,1,439,3,439,7015,8,439,1,439,
  	1,439,3,439,7019,8,439,1,439,1,439,1,439,1,439,3,439,7025,8,439,1,439,
  	1,439,1,439,1,439,1,439,3,439,7032,8,439,1,439,1,439,1,439,3,439,7037,
  	8,439,1,439,1,439,1,439,1,439,1,439,1,439,1,439,1,439,1,439,1,439,1,439,
  	1,439,3,439,7051,8,439,1,439,1,439,1,439,3,439,7056,8,439,1,440,1,440,
  	1,441,1,441,1,442,1,442,3,442,7064,8,442,1,442,1,442,1,442,3,442,7069,
  	8,442,1,442,1,442,3,442,7073,8,442,1,442,3,442,7076,8,442,1,443,1,443,
  	1,443,3,443,7081,8,443,1,443,1,443,3,443,7085,8,443,1,443,1,443,1,443,
  	1,443,1,443,1,443,3,443,7093,8,443,1,443,1,443,1,443,1,443,1,443,1,443,
  	3,443,7101,8,443,3,443,7103,8,443,1,444,1,444,1,444,1,444,1,444,3,444,
  	7110,8,444,1,445,1,445,1,445,1,445,5,445,7116,8,445,10,445,12,445,7119,
  	9,445,1,445,1,445,1,446,1,446,3,446,7125,8,446,1,446,3,446,7128,8,446,
  	1,447,1,447,1,447,1,447,5,447,7134,8,447,10,447,12,447,7137,9,447,1,447,
  	1,447,1,448,1,448,1,448,3,448,7144,8,448,3,448,7146,8,448,1,449,1,449,
  	1,449,1,449,3,449,7152,8,449,1,450,1,450,1,451,1,451,3,451,7158,8,451,
  	1,452,1,452,3,452,7162,8,452,1,452,1,452,1,452,1,452,1,452,3,452,7169,
  	8,452,1,453,1,453,1,454,1,454,1,454,1,455,1,455,1,455,1,455,3,455,7180,
  	8,455,1,456,1,456,1,457,1,457,1,457,1,458,1,458,3,458,7189,8,458,1,458,
  	3,458,7192,8,458,1,458,1,458,1,458,3,458,7197,8,458,3,458,7199,8,458,
  	1,458,3,458,7202,8,458,1,458,3,458,7205,8,458,1,458,1,458,3,458,7209,
  	8,458,1,458,3,458,7212,8,458,1,458,1,458,3,458,7216,8,458,1,458,1,458,
  	1,458,3,458,7221,8,458,1,458,3,458,7224,8,458,1,458,1,458,3,458,7228,
  	8,458,1,458,3,458,7231,8,458,1,458,1,458,3,458,7235,8,458,1,458,1,458,
  	1,458,3,458,7240,8,458,1,458,1,458,3,458,7244,8,458,1,458,1,458,1,458,
  	1,458,1,458,1,458,1,458,1,458,1,458,1,458,3,458,7256,8,458,1,458,1,458,
  	3,458,7260,8,458,1,458,1,458,1,458,1,458,3,458,7266,8,458,1,458,3,458,
  	7269,8,458,1,458,1,458,1,458,3,458,7274,8,458,1,458,1,458,3,458,7278,
  	8,458,1,458,1,458,3,458,7282,8,458,1,458,1,458,1,458,3,458,7287,8,458,
  	1,458,1,458,1,458,1,458,1,458,1,458,1,458,3,458,7296,8,458,1,458,3,458,
  	7299,8,458,1,458,1,458,3,458,7303,8,458,1,458,1,458,3,458,7307,8,458,
  	1,458,3,458,7310,8,458,1,458,1,458,3,458,7314,8,458,1,458,1,458,3,458,
  	7318,8,458,1,458,1,458,1,458,3,458,7323,8,458,1,458,1,458,1,458,3,458,
  	7328,8,458,1,458,1,458,1,458,1,458,3,458,7334,8,458,1,459,1,459,1,459,
  	3,459,7339,8,459,1,460,1,460,1,460,3,460,7344,8,460,3,460,7346,8,460,
  	1,461,1,461,1,461,3,461,7351,8,461,1,461,1,461,1,462,4,462,7356,8,462,
  	11,462,12,462,7357,1,463,1,463,1,463,1,463,1,463,1,463,3,463,7366,8,463,
  	1,463,1,463,1,463,1,463,3,463,7372,8,463,3,463,7374,8,463,1,464,1,464,
  	3,464,7378,8,464,1,464,1,464,3,464,7382,8,464,1,465,1,465,3,465,7386,
  	8,465,1,465,1,465,3,465,7390,8,465,1,466,1,466,1,466,1,466,1,467,1,467,
  	1,467,1,467,1,468,1,468,1,468,1,468,3,468,7404,8,468,1,469,1,469,1,469,
  	1,469,1,469,3,469,7411,8,469,1,470,1,470,3,470,7415,8,470,1,470,5,470,
  	7418,8,470,10,470,12,470,7421,9,470,1,471,4,471,7424,8,471,11,471,12,
  	471,7425,1,472,1,472,3,472,7430,8,472,1,472,1,472,1,472,1,472,3,472,7436,
  	8,472,1,472,1,472,3,472,7440,8,472,1,472,1,472,3,472,7444,8,472,1,472,
  	1,472,1,472,3,472,7449,8,472,1,472,1,472,1,472,3,472,7454,8,472,1,472,
  	1,472,1,472,3,472,7459,8,472,1,472,1,472,1,472,3,472,7464,8,472,1,472,
  	1,472,1,472,1,472,3,472,7470,8,472,1,472,1,472,1,472,1,472,3,472,7476,
  	8,472,1,472,1,472,1,472,3,472,7481,8,472,1,472,1,472,1,472,3,472,7486,
  	8,472,1,472,1,472,1,472,3,472,7491,8,472,1,472,1,472,1,472,3,472,7496,
  	8,472,1,472,1,472,1,472,3,472,7501,8,472,1,472,1,472,1,472,3,472,7506,
  	8,472,1,472,1,472,1,472,3,472,7511,8,472,1,472,1,472,1,472,1,472,1,472,
  	1,472,1,472,1,472,3,472,7521,8,472,1,472,1,472,1,472,1,472,3,472,7527,
  	8,472,1,472,1,472,1,472,1,472,3,472,7533,8,472,1,472,1,472,1,472,1,472,
  	3,472,7539,8,472,1,472,3,472,7542,8,472,1,472,1,472,1,472,1,472,1,472,
  	3,472,7549,8,472,1,472,1,472,1,472,3,472,7554,8,472,1,472,3,472,7557,
  	8,472,1,473,1,473,3,473,7561,8,473,1,474,3,474,7564,8,474,1,474,1,474,
  	3,474,7568,8,474,1,474,1,474,1,475,3,475,7573,8,475,1,475,1,475,3,475,
  	7577,8,475,1,475,1,475,1,476,3,476,7582,8,476,1,476,1,476,3,476,7586,
  	8,476,1,476,1,476,1,477,1,477,1,477,1,477,1,477,3,477,7595,8,477,1,477,
  	3,477,7598,8,477,1,477,3,477,7601,8,477,1,478,3,478,7604,8,478,1,478,
  	1,478,3,478,7608,8,478,1,478,1,478,3,478,7612,8,478,1,478,1,478,3,478,
  	7616,8,478,1,478,1,478,1,478,1,478,1,478,1,478,1,478,1,478,1,478,1,478,
  	1,478,1,478,1,478,3,478,7631,8,478,1,478,3,478,7634,8,478,3,478,7636,
  	8,478,1,479,1,479,1,479,3,479,7641,8,479,1,479,1,479,1,479,1,479,1,479,
  	1,479,1,479,3,479,7650,8,479,1,479,3,479,7653,8,479,1,479,1,479,3,479,
  	7657,8,479,1,480,1,480,1,480,1,480,1,480,1,481,1,481,1,481,1,481,5,481,
  	7668,8,481,10,481,12,481,7671,9,481,1,481,1,481,1,482,1,482,1,482,1,482,
  	1,482,1,482,1,482,3,482,7682,8,482,1,482,1,482,1,482,3,482,7687,8,482,
  	1,482,5,482,7690,8,482,10,482,12,482,7693,9,482,1,482,1,482,1,482,1,482,
  	5,482,7699,8,482,10,482,12,482,7702,9,482,1,482,1,482,3,482,7706,8,482,
  	1,483,1,483,1,483,1,483,1,483,5,483,7713,8,483,10,483,12,483,7716,9,483,
  	1,483,1,483,3,483,7720,8,483,1,484,1,484,3,484,7724,8,484,1,484,1,484,
  	3,484,7728,8,484,1,484,1,484,3,484,7732,8,484,1,484,1,484,1,484,3,484,
  	7737,8,484,1,484,1,484,1,484,3,484,7742,8,484,1,484,1,484,1,484,1,484,
  	3,484,7748,8,484,1,484,1,484,1,484,3,484,7753,8,484,1,484,3,484,7756,
  	8,484,1,485,1,485,1,485,5,485,7761,8,485,10,485,12,485,7764,9,485,1,486,
  	1,486,1,486,1,486,5,486,7770,8,486,10,486,12,486,7773,9,486,1,486,1,486,
  	1,487,1,487,3,487,7779,8,487,1,488,1,488,1,488,1,488,1,489,1,489,1,489,
  	1,490,1,490,1,490,1,490,1,491,3,491,7793,8,491,1,491,1,491,1,492,1,492,
  	1,492,1,493,1,493,1,493,1,494,1,494,3,494,7805,8,494,1,495,1,495,1,495,
  	1,495,1,495,1,495,1,496,1,496,1,496,5,496,7816,8,496,10,496,12,496,7819,
  	9,496,1,497,1,497,1,497,5,497,7824,8,497,10,497,12,497,7827,9,497,1,498,
  	1,498,1,498,1,498,3,498,7833,8,498,1,499,1,499,1,499,1,500,1,500,4,500,
  	7840,8,500,11,500,12,500,7841,1,501,1,501,1,501,1,501,3,501,7848,8,501,
  	1,501,1,501,1,501,1,501,1,501,1,501,3,501,7856,8,501,1,502,1,502,4,502,
  	7860,8,502,11,502,12,502,7861,1,503,1,503,1,503,1,503,1,504,1,504,1,504,
  	5,504,7871,8,504,10,504,12,504,7874,9,504,1,505,1,505,1,505,5,505,7879,
  	8,505,10,505,12,505,7882,9,505,1,506,1,506,1,506,5,506,7887,8,506,10,
  	506,12,506,7890,9,506,1,507,1,507,1,507,1,507,1,507,3,507,7897,8,507,
  	1,507,1,507,1,507,1,507,1,507,1,507,1,507,1,507,3,507,7907,8,507,1,507,
  	1,507,1,507,3,507,7912,8,507,1,507,1,507,1,507,3,507,7917,8,507,3,507,
  	7919,8,507,1,508,1,508,1,508,1,508,3,508,7925,8,508,1,508,1,508,1,508,
  	1,508,3,508,7931,8,508,1,508,3,508,7934,8,508,1,508,1,508,1,508,1,508,
  	1,508,3,508,7941,8,508,3,508,7943,8,508,3,508,7945,8,508,1,508,3,508,
  	7948,8,508,3,508,7950,8,508,1,509,1,509,1,509,1,509,1,510,1,510,1,510,
  	1,510,1,511,1,511,1,511,1,512,1,512,1,512,1,512,3,512,7967,8,512,1,513,
  	1,513,1,513,3,513,7972,8,513,3,513,7974,8,513,1,514,1,514,1,514,1,515,
  	1,515,3,515,7981,8,515,1,516,1,516,1,517,1,517,1,518,1,518,1,518,1,518,
  	1,519,1,519,1,519,3,519,7994,8,519,3,519,7996,8,519,1,520,1,520,1,520,
  	1,520,3,520,8002,8,520,1,521,1,521,1,522,1,522,1,522,1,522,5,522,8010,
  	8,522,10,522,12,522,8013,9,522,1,522,1,522,1,523,1,523,1,524,1,524,3,
  	524,8021,8,524,1,525,1,525,1,526,1,526,1,527,1,527,1,527,1,527,1,527,
  	3,527,8032,8,527,1,527,1,527,1,528,1,528,1,529,1,529,1,530,1,530,1,531,
  	1,531,1,532,1,532,1,533,1,533,1,534,1,534,1,535,1,535,1,536,1,536,3,536,
  	8054,8,536,1,537,1,537,3,537,8058,8,537,1,538,1,538,1,539,1,539,1,540,
  	1,540,1,541,1,541,1,542,1,542,1,543,1,543,1,544,1,544,1,545,1,545,1,546,
  	1,546,1,547,1,547,1,548,1,548,3,548,8082,8,548,1,549,1,549,1,549,1,550,
  	1,550,1,550,1,550,1,550,1,550,3,550,8093,8,550,3,550,8095,8,550,1,551,
  	1,551,3,551,8099,8,551,1,552,1,552,1,552,5,552,8104,8,552,10,552,12,552,
  	8107,9,552,1,553,1,553,1,553,5,553,8112,8,553,10,553,12,553,8115,9,553,
  	1,554,1,554,1,555,1,555,3,555,8121,8,555,1,556,1,556,1,557,1,557,3,557,
  	8127,8,557,1,558,1,558,1,559,1,559,1,560,1,560,1,561,1,561,1,562,1,562,
  	1,563,1,563,1,563,3,563,8142,8,563,1,564,1,564,3,564,8146,8,564,1,565,
  	1,565,1,565,5,565,8151,8,565,10,565,12,565,8154,9,565,1,566,1,566,1,566,
  	1,566,1,567,1,567,3,567,8162,8,567,1,568,1,568,1,568,3,568,8167,8,568,
  	3,568,8169,8,568,1,568,1,568,1,568,1,568,3,568,8175,8,568,1,569,1,569,
  	1,569,1,570,1,570,1,571,1,571,1,572,1,572,1,573,1,573,1,573,1,573,1,573,
  	3,573,8191,8,573,1,574,1,574,1,574,1,574,1,574,1,574,3,574,8199,8,574,
  	1,574,3,574,8202,8,574,1,575,1,575,1,575,1,575,1,575,3,575,8209,8,575,
  	1,576,1,576,1,576,1,576,5,576,8215,8,576,10,576,12,576,8218,9,576,1,576,
  	1,576,1,577,1,577,1,577,3,577,8225,8,577,1,578,1,578,1,578,3,578,8230,
  	8,578,1,579,1,579,1,579,3,579,8235,8,579,1,580,3,580,8238,8,580,1,580,
  	1,580,3,580,8242,8,580,1,580,5,580,8245,8,580,10,580,12,580,8248,9,580,
  	1,581,1,581,1,582,1,582,1,582,5,582,8255,8,582,10,582,12,582,8258,9,582,
  	1,583,1,583,1,584,1,584,1,585,1,585,1,586,1,586,1,586,1,586,1,586,1,586,
  	3,586,8272,8,586,1,587,1,587,3,587,8276,8,587,1,588,1,588,1,589,1,589,
  	1,589,1,589,1,589,1,589,1,590,1,590,3,590,8288,8,590,1,591,1,591,3,591,
  	8292,8,591,1,592,1,592,3,592,8296,8,592,1,593,1,593,3,593,8300,8,593,
  	1,594,1,594,1,594,1,595,1,595,1,596,1,596,1,597,1,597,1,597,1,597,1,597,
  	1,597,3,597,8315,8,597,1,598,1,598,1,598,1,598,1,598,1,598,1,598,1,598,
  	1,598,1,598,3,598,8327,8,598,1,599,1,599,1,599,1,599,1,599,1,599,1,599,
  	1,599,3,599,8337,8,599,1,599,1,599,1,599,1,599,1,599,3,599,8344,8,599,
  	3,599,8346,8,599,1,600,1,600,1,601,1,601,1,602,1,602,1,602,1,602,1,602,
  	1,602,1,602,1,602,1,602,1,602,1,602,3,602,8363,8,602,1,602,1,602,1,602,
  	3,602,8368,8,602,3,602,8370,8,602,1,603,1,603,1,604,1,604,1,604,3,604,
  	8377,8,604,1,605,1,605,1,605,3,605,8382,8,605,1,605,1,605,1,605,3,605,
  	8387,8,605,3,605,8389,8,605,1,606,1,606,1,606,1,606,3,606,8395,8,606,
  	1,607,1,607,1,608,1,608,1,608,1,608,1,608,3,608,8404,8,608,1,609,1,609,
  	1,609,1,609,1,609,1,609,1,609,1,609,1,609,3,609,8415,8,609,1,609,0,4,
  	676,678,686,688,610,0,2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,
  	36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,
  	82,84,86,88,90,92,94,96,98,100,102,104,106,108,110,112,114,116,118,120,
  	122,124,126,128,130,132,134,136,138,140,142,144,146,148,150,152,154,156,
  	158,160,162,164,166,168,170,172,174,176,178,180,182,184,186,188,190,192,
  	194,196,198,200,202,204,206,208,210,212,214,216,218,220,222,224,226,228,
  	230,232,234,236,238,240,242,244,246,248,250,252,254,256,258,260,262,264,
  	266,268,270,272,274,276,278,280,282,284,286,288,290,292,294,296,298,300,
  	302,304,306,308,310,312,314,316,318,320,322,324,326,328,330,332,334,336,
  	338,340,342,344,346,348,350,352,354,356,358,360,362,364,366,368,370,372,
  	374,376,378,380,382,384,386,388,390,392,394,396,398,400,402,404,406,408,
  	410,412,414,416,418,420,422,424,426,428,430,432,434,436,438,440,442,444,
  	446,448,450,452,454,456,458,460,462,464,466,468,470,472,474,476,478,480,
  	482,484,486,488,490,492,494,496,498,500,502,504,506,508,510,512,514,516,
  	518,520,522,524,526,528,530,532,534,536,538,540,542,544,546,548,550,552,
  	554,556,558,560,562,564,566,568,570,572,574,576,578,580,582,584,586,588,
  	590,592,594,596,598,600,602,604,606,608,610,612,614,616,618,620,622,624,
  	626,628,630,632,634,636,638,640,642,644,646,648,650,652,654,656,658,660,
  	662,664,666,668,670,672,674,676,678,680,682,684,686,688,690,692,694,696,
  	698,700,702,704,706,708,710,712,714,716,718,720,722,724,726,728,730,732,
  	734,736,738,740,742,744,746,748,750,752,754,756,758,760,762,764,766,768,
  	770,772,774,776,778,780,782,784,786,788,790,792,794,796,798,800,802,804,
  	806,808,810,812,814,816,818,820,822,824,826,828,830,832,834,836,838,840,
  	842,844,846,848,850,852,854,856,858,860,862,864,866,868,870,872,874,876,
  	878,880,882,884,886,888,890,892,894,896,898,900,902,904,906,908,910,912,
  	914,916,918,920,922,924,926,928,930,932,934,936,938,940,942,944,946,948,
  	950,952,954,956,958,960,962,964,966,968,970,972,974,976,978,980,982,984,
  	986,988,990,992,994,996,998,1000,1002,1004,1006,1008,1010,1012,1014,1016,
  	1018,1020,1022,1024,1026,1028,1030,1032,1034,1036,1038,1040,1042,1044,
  	1046,1048,1050,1052,1054,1056,1058,1060,1062,1064,1066,1068,1070,1072,
  	1074,1076,1078,1080,1082,1084,1086,1088,1090,1092,1094,1096,1098,1100,
  	1102,1104,1106,1108,1110,1112,1114,1116,1118,1120,1122,1124,1126,1128,
  	1130,1132,1134,1136,1138,1140,1142,1144,1146,1148,1150,1152,1154,1156,
  	1158,1160,1162,1164,1166,1168,1170,1172,1174,1176,1178,1180,1182,1184,
  	1186,1188,1190,1192,1194,1196,1198,1200,1202,1204,1206,1208,1210,1212,
  	1214,1216,1218,0,146,1,0,722,723,2,0,17,17,590,590,2,0,49,49,471,471,
  	1,0,645,646,2,0,4,4,148,148,2,0,434,434,436,436,1,0,724,725,2,0,50,50,
  	284,284,2,0,232,232,458,458,4,0,126,126,249,249,437,437,556,556,2,0,130,
  	130,250,250,2,0,440,440,603,603,2,0,441,441,604,604,2,0,374,374,638,638,
  	3,0,335,335,578,578,602,602,2,0,6,6,28,28,3,0,133,133,242,242,614,614,
  	2,0,197,197,415,415,2,0,571,571,574,574,3,0,232,232,295,295,431,431,2,
  	0,191,191,367,367,4,0,191,191,268,268,367,367,419,419,2,0,750,750,753,
  	756,3,0,131,131,223,223,295,295,1,0,626,627,2,0,82,82,295,295,2,0,112,
  	112,653,653,2,0,278,278,484,484,2,0,131,131,295,295,7,0,10,10,143,143,
  	223,223,531,532,534,534,536,536,555,555,2,0,381,381,773,773,2,0,747,749,
  	787,787,3,0,432,432,484,484,683,683,2,0,18,18,134,134,2,0,272,272,478,
  	478,2,0,98,98,239,239,2,0,10,10,143,143,2,0,198,198,232,232,2,0,236,236,
  	265,265,2,0,386,386,649,649,2,0,29,29,543,543,2,0,261,261,472,472,2,0,
  	32,32,316,316,2,0,383,383,743,744,2,0,528,528,530,530,2,0,449,449,538,
  	538,2,0,543,543,552,552,2,0,123,123,148,148,3,0,369,369,539,539,650,650,
  	2,0,287,287,611,611,2,0,128,128,719,719,3,0,206,206,422,422,574,574,4,
  	0,242,242,443,443,497,497,614,614,13,0,133,133,148,148,170,170,173,173,
  	188,188,236,236,423,423,427,427,451,451,510,510,565,565,594,594,616,616,
  	4,0,483,483,572,572,618,618,636,636,2,0,65,65,514,514,2,0,97,97,148,148,
  	2,0,128,128,369,369,2,0,180,180,431,431,5,0,56,56,180,180,184,184,333,
  	333,431,431,3,0,180,180,431,431,619,619,2,0,76,76,601,601,4,0,10,10,32,
  	32,128,128,383,383,2,0,487,487,710,710,3,0,289,289,354,354,547,547,2,
  	0,203,203,251,251,2,0,33,33,446,446,2,0,235,236,263,263,2,0,166,166,639,
  	639,2,0,547,547,631,631,6,0,10,10,96,96,256,256,334,334,522,522,567,567,
  	2,0,84,84,430,430,5,0,136,136,225,225,421,421,547,547,617,617,5,0,32,
  	32,163,163,165,165,208,208,515,515,2,0,618,618,710,710,2,0,140,140,156,
  	156,2,0,134,135,178,178,3,0,183,183,596,596,610,610,2,0,15,15,767,767,
  	2,0,394,394,770,770,2,0,10,10,16,16,2,0,750,750,752,757,3,0,145,145,349,
  	349,760,762,1,0,758,759,1,0,765,766,2,0,758,759,764,764,2,0,35,36,38,
  	38,4,0,678,679,692,692,694,694,696,696,2,0,684,684,686,686,2,0,681,681,
  	685,685,2,0,191,191,268,268,2,0,232,232,695,695,2,0,5,5,558,558,1,0,114,
  	115,1,0,584,585,4,0,113,113,116,116,583,583,586,586,2,0,371,371,745,745,
  	2,0,745,745,763,763,5,0,118,121,226,228,341,342,494,494,655,655,9,0,122,
  	122,229,229,337,337,343,343,350,350,429,429,495,495,640,640,656,656,3,
  	0,92,92,175,175,605,605,2,0,377,377,485,485,10,0,53,53,64,64,73,73,87,
  	89,107,107,336,336,355,355,492,492,557,557,576,576,2,0,554,554,637,637,
  	3,0,128,128,152,152,192,192,3,0,128,128,142,142,334,334,3,0,204,204,402,
  	402,513,513,3,0,44,44,220,220,488,488,1,0,661,662,2,0,599,599,621,621,
  	5,0,31,31,249,249,331,331,516,516,588,588,4,0,126,126,192,192,195,195,
  	378,378,1,0,41,42,2,0,290,290,330,330,4,0,211,212,279,279,351,353,411,
  	412,3,0,512,512,612,612,657,657,1,0,544,546,2,0,61,61,575,575,6,0,78,
  	78,80,80,128,128,152,152,192,192,442,442,3,0,191,191,268,268,373,373,
  	2,0,142,142,334,334,2,0,280,280,432,432,2,0,323,323,344,344,2,0,112,112,
  	236,236,3,0,240,240,251,251,397,397,2,0,541,541,579,579,2,0,380,380,385,
  	385,2,0,284,284,375,375,2,0,795,795,797,797,3,0,747,749,788,788,790,791,
  	2,0,747,749,788,788,2,0,747,749,790,791,1,0,788,789,2,0,183,183,596,596,
  	2,0,376,376,786,786,1,0,750,751,5,0,214,214,284,284,502,502,658,658,673,
  	673,3,0,173,173,510,510,714,714,32,0,19,19,29,29,46,47,58,58,61,61,75,
  	75,77,77,90,90,123,123,147,147,159,159,196,197,219,219,222,222,234,234,
  	245,245,267,267,373,373,415,415,417,417,455,455,468,468,480,480,489,489,
  	512,512,514,514,543,543,552,552,597,597,606,607,651,651,677,677,9,0,170,
  	170,188,188,369,369,423,423,427,427,451,451,459,459,565,565,709,709,161,
  	0,2,3,5,9,12,12,16,16,21,21,23,27,33,33,37,37,40,42,44,44,50,50,53,54,
  	56,57,63,68,70,71,73,74,76,76,78,82,84,85,87,89,91,91,96,96,101,101,107,
  	107,111,113,116,116,122,122,129,130,132,132,138,142,150,152,156,156,158,
  	158,160,160,162,166,168,169,171,172,176,177,179,181,184,185,189,192,201,
  	202,204,204,208,208,210,213,216,216,220,220,224,225,229,230,233,233,235,
  	235,238,238,243,244,250,250,255,256,258,259,262,262,264,264,268,268,270,
  	270,273,274,279,280,286,286,288,289,296,296,298,314,316,319,321,324,327,
  	328,333,337,340,340,343,344,346,346,348,348,350,358,361,361,363,363,365,
  	368,374,374,377,377,379,379,381,381,384,384,386,387,390,390,398,404,406,
  	413,418,419,421,421,424,426,429,431,434,434,438,439,441,442,445,449,452,
  	452,454,454,456,456,460,466,470,470,472,474,476,476,481,483,485,486,488,
  	488,490,490,492,492,495,496,500,501,503,503,508,508,513,513,515,515,517,
  	517,519,522,528,530,532,532,535,535,538,538,540,540,542,542,544,547,553,
  	553,556,561,566,568,571,572,575,578,580,581,583,586,592,593,598,599,601,
  	604,610,610,613,613,615,615,617,619,625,625,627,627,631,631,636,636,638,
  	641,646,648,650,650,652,653,656,656,659,662,664,664,669,671,674,675,680,
  	680,682,682,689,690,693,693,695,695,697,698,702,708,711,713,715,725,727,
  	730,732,732,735,738,4,0,583,583,586,586,731,731,733,744,54,0,2,2,12,12,
  	19,19,27,27,29,29,46,47,58,58,61,61,66,66,75,75,77,77,90,90,123,123,147,
  	147,159,159,196,197,201,201,210,210,219,219,222,222,224,224,245,245,267,
  	267,373,373,387,387,390,390,398,398,401,401,405,405,413,413,415,415,417,
  	417,452,452,455,455,468,468,470,470,480,480,489,489,496,496,503,503,512,
  	512,514,514,519,520,543,543,552,552,597,597,606,607,615,615,648,648,651,
  	651,659,659,661,662,677,677,720,723,155,0,3,3,5,9,13,13,16,16,21,26,33,
  	33,37,37,40,42,44,44,50,50,53,54,56,57,63,65,67,68,70,71,73,74,76,76,
  	78,82,84,85,87,89,91,91,93,93,96,96,101,101,107,107,111,113,116,116,122,
  	122,129,130,132,132,136,136,138,142,150,152,156,156,158,158,160,160,162,
  	166,168,169,171,171,176,176,179,181,184,185,189,192,202,202,204,204,208,
  	208,211,214,216,216,220,220,225,225,229,230,233,233,235,235,238,238,243,
  	244,250,250,255,256,258,259,262,262,264,264,268,268,270,270,273,274,279,
  	280,284,284,286,286,288,289,296,296,298,314,316,319,321,325,327,328,333,
  	337,340,340,343,344,346,346,348,348,350,358,361,361,363,363,365,368,374,
  	374,377,377,379,379,381,382,384,384,399,400,402,404,406,412,418,419,421,
  	421,424,426,429,431,434,434,438,442,445,449,454,454,456,456,460,466,472,
  	474,476,476,481,483,485,486,488,488,490,490,492,492,495,495,500,502,508,
  	508,513,513,515,515,517,517,521,522,528,530,532,533,535,535,538,538,540,
  	540,542,542,544,547,553,553,556,561,565,568,571,572,575,578,580,581,583,
  	586,592,593,598,604,610,610,613,613,617,619,627,627,631,631,636,636,638,
  	641,647,647,650,650,652,653,656,656,664,664,669,671,674,676,680,680,682,
  	682,689,690,693,693,695,695,697,698,702,708,711,712,716,717,719,719,724,
  	725,727,728,5,0,99,99,206,206,234,234,484,484,487,487,6,0,172,172,177,
  	177,386,386,565,565,625,625,646,646,9536,0,1232,1,0,0,0,2,1268,1,0,0,
  	0,4,1270,1,0,0,0,6,1299,1,0,0,0,8,1314,1,0,0,0,10,1352,1,0,0,0,12,1361,
  	1,0,0,0,14,1374,1,0,0,0,16,1376,1,0,0,0,18,1381,1,0,0,0,20,1405,1,0,0,
  	0,22,1414,1,0,0,0,24,1416,1,0,0,0,26,1431,1,0,0,0,28,1529,1,0,0,0,30,
  	1533,1,0,0,0,32,1549,1,0,0,0,34,1696,1,0,0,0,36,1701,1,0,0,0,38,1703,
  	1,0,0,0,40,1705,1,0,0,0,42,1719,1,0,0,0,44,1727,1,0,0,0,46,1743,1,0,0,
  	0,48,1745,1,0,0,0,50,1749,1,0,0,0,52,1754,1,0,0,0,54,1756,1,0,0,0,56,
  	1793,1,0,0,0,58,1801,1,0,0,0,60,1811,1,0,0,0,62,1813,1,0,0,0,64,1833,
  	1,0,0,0,66,1842,1,0,0,0,68,1845,1,0,0,0,70,1858,1,0,0,0,72,1863,1,0,0,
  	0,74,1867,1,0,0,0,76,1874,1,0,0,0,78,1895,1,0,0,0,80,1910,1,0,0,0,82,
  	1913,1,0,0,0,84,1944,1,0,0,0,86,1954,1,0,0,0,88,1957,1,0,0,0,90,1966,
  	1,0,0,0,92,1968,1,0,0,0,94,1980,1,0,0,0,96,2005,1,0,0,0,98,2032,1,0,0,
  	0,100,2046,1,0,0,0,102,2049,1,0,0,0,104,2070,1,0,0,0,106,2073,1,0,0,0,
  	108,2130,1,0,0,0,110,2132,1,0,0,0,112,2136,1,0,0,0,114,2145,1,0,0,0,116,
  	2161,1,0,0,0,118,2163,1,0,0,0,120,2171,1,0,0,0,122,2197,1,0,0,0,124,2199,
  	1,0,0,0,126,2211,1,0,0,0,128,2226,1,0,0,0,130,2228,1,0,0,0,132,2231,1,
  	0,0,0,134,2253,1,0,0,0,136,2255,1,0,0,0,138,2261,1,0,0,0,140,2267,1,0,
  	0,0,142,2273,1,0,0,0,144,2279,1,0,0,0,146,2285,1,0,0,0,148,2292,1,0,0,
  	0,150,2300,1,0,0,0,152,2302,1,0,0,0,154,2308,1,0,0,0,156,2314,1,0,0,0,
  	158,2321,1,0,0,0,160,2339,1,0,0,0,162,2341,1,0,0,0,164,2345,1,0,0,0,166,
  	2350,1,0,0,0,168,2366,1,0,0,0,170,2371,1,0,0,0,172,2404,1,0,0,0,174,2435,
  	1,0,0,0,176,2452,1,0,0,0,178,2454,1,0,0,0,180,2474,1,0,0,0,182,2480,1,
  	0,0,0,184,2486,1,0,0,0,186,2492,1,0,0,0,188,2499,1,0,0,0,190,2508,1,0,
  	0,0,192,2525,1,0,0,0,194,2527,1,0,0,0,196,2534,1,0,0,0,198,2544,1,0,0,
  	0,200,2558,1,0,0,0,202,2564,1,0,0,0,204,2572,1,0,0,0,206,2578,1,0,0,0,
  	208,2586,1,0,0,0,210,2592,1,0,0,0,212,2602,1,0,0,0,214,2606,1,0,0,0,216,
  	2612,1,0,0,0,218,2617,1,0,0,0,220,2628,1,0,0,0,222,2671,1,0,0,0,224,2677,
  	1,0,0,0,226,2679,1,0,0,0,228,2686,1,0,0,0,230,2716,1,0,0,0,232,2718,1,
  	0,0,0,234,2749,1,0,0,0,236,2756,1,0,0,0,238,2760,1,0,0,0,240,2768,1,0,
  	0,0,242,2778,1,0,0,0,244,2780,1,0,0,0,246,2798,1,0,0,0,248,2810,1,0,0,
  	0,250,2815,1,0,0,0,252,2821,1,0,0,0,254,2854,1,0,0,0,256,2856,1,0,0,0,
  	258,2864,1,0,0,0,260,2873,1,0,0,0,262,2881,1,0,0,0,264,2893,1,0,0,0,266,
  	2916,1,0,0,0,268,2930,1,0,0,0,270,2934,1,0,0,0,272,2966,1,0,0,0,274,2981,
  	1,0,0,0,276,2996,1,0,0,0,278,2998,1,0,0,0,280,3025,1,0,0,0,282,3027,1,
  	0,0,0,284,3029,1,0,0,0,286,3032,1,0,0,0,288,3035,1,0,0,0,290,3042,1,0,
  	0,0,292,3044,1,0,0,0,294,3074,1,0,0,0,296,3086,1,0,0,0,298,3089,1,0,0,
  	0,300,3098,1,0,0,0,302,3102,1,0,0,0,304,3107,1,0,0,0,306,3120,1,0,0,0,
  	308,3125,1,0,0,0,310,3129,1,0,0,0,312,3145,1,0,0,0,314,3147,1,0,0,0,316,
  	3165,1,0,0,0,318,3167,1,0,0,0,320,3176,1,0,0,0,322,3188,1,0,0,0,324,3195,
  	1,0,0,0,326,3206,1,0,0,0,328,3208,1,0,0,0,330,3212,1,0,0,0,332,3214,1,
  	0,0,0,334,3219,1,0,0,0,336,3227,1,0,0,0,338,3236,1,0,0,0,340,3239,1,0,
  	0,0,342,3254,1,0,0,0,344,3257,1,0,0,0,346,3276,1,0,0,0,348,3281,1,0,0,
  	0,350,3286,1,0,0,0,352,3290,1,0,0,0,354,3304,1,0,0,0,356,3307,1,0,0,0,
  	358,3313,1,0,0,0,360,3326,1,0,0,0,362,3334,1,0,0,0,364,3360,1,0,0,0,366,
  	3373,1,0,0,0,368,3380,1,0,0,0,370,3382,1,0,0,0,372,3394,1,0,0,0,374,3396,
  	1,0,0,0,376,3406,1,0,0,0,378,3430,1,0,0,0,380,3432,1,0,0,0,382,3439,1,
  	0,0,0,384,3449,1,0,0,0,386,3484,1,0,0,0,388,3494,1,0,0,0,390,3496,1,0,
  	0,0,392,3500,1,0,0,0,394,3508,1,0,0,0,396,3510,1,0,0,0,398,3515,1,0,0,
  	0,400,3519,1,0,0,0,402,3547,1,0,0,0,404,3549,1,0,0,0,406,3551,1,0,0,0,
  	408,3559,1,0,0,0,410,3561,1,0,0,0,412,3569,1,0,0,0,414,3579,1,0,0,0,416,
  	3583,1,0,0,0,418,3608,1,0,0,0,420,3635,1,0,0,0,422,3637,1,0,0,0,424,3647,
  	1,0,0,0,426,3678,1,0,0,0,428,3702,1,0,0,0,430,3704,1,0,0,0,432,3718,1,
  	0,0,0,434,3720,1,0,0,0,436,3755,1,0,0,0,438,3757,1,0,0,0,440,3799,1,0,
  	0,0,442,3815,1,0,0,0,444,3817,1,0,0,0,446,3825,1,0,0,0,448,3834,1,0,0,
  	0,450,3841,1,0,0,0,452,3940,1,0,0,0,454,3944,1,0,0,0,456,3946,1,0,0,0,
  	458,3950,1,0,0,0,460,3964,1,0,0,0,462,3966,1,0,0,0,464,3979,1,0,0,0,466,
  	4043,1,0,0,0,468,4045,1,0,0,0,470,4053,1,0,0,0,472,4061,1,0,0,0,474,4069,
  	1,0,0,0,476,4071,1,0,0,0,478,4100,1,0,0,0,480,4109,1,0,0,0,482,4140,1,
  	0,0,0,484,4142,1,0,0,0,486,4150,1,0,0,0,488,4152,1,0,0,0,490,4166,1,0,
  	0,0,492,4168,1,0,0,0,494,4174,1,0,0,0,496,4182,1,0,0,0,498,4219,1,0,0,
  	0,500,4221,1,0,0,0,502,4236,1,0,0,0,504,4238,1,0,0,0,506,4300,1,0,0,0,
  	508,4302,1,0,0,0,510,4305,1,0,0,0,512,4330,1,0,0,0,514,4339,1,0,0,0,516,
  	4341,1,0,0,0,518,4346,1,0,0,0,520,4392,1,0,0,0,522,4394,1,0,0,0,524,4402,
  	1,0,0,0,526,4451,1,0,0,0,528,4464,1,0,0,0,530,4466,1,0,0,0,532,4469,1,
  	0,0,0,534,4480,1,0,0,0,536,4485,1,0,0,0,538,4488,1,0,0,0,540,4503,1,0,
  	0,0,542,4553,1,0,0,0,544,4555,1,0,0,0,546,4557,1,0,0,0,548,4606,1,0,0,
  	0,550,4624,1,0,0,0,552,4626,1,0,0,0,554,4642,1,0,0,0,556,4654,1,0,0,0,
  	558,4679,1,0,0,0,560,4681,1,0,0,0,562,4689,1,0,0,0,564,4738,1,0,0,0,566,
  	4753,1,0,0,0,568,4758,1,0,0,0,570,4760,1,0,0,0,572,4784,1,0,0,0,574,4786,
  	1,0,0,0,576,4845,1,0,0,0,578,4856,1,0,0,0,580,4858,1,0,0,0,582,4861,1,
  	0,0,0,584,4874,1,0,0,0,586,4902,1,0,0,0,588,4910,1,0,0,0,590,4912,1,0,
  	0,0,592,4923,1,0,0,0,594,4925,1,0,0,0,596,4933,1,0,0,0,598,4935,1,0,0,
  	0,600,5163,1,0,0,0,602,5170,1,0,0,0,604,5172,1,0,0,0,606,5174,1,0,0,0,
  	608,5184,1,0,0,0,610,5223,1,0,0,0,612,5227,1,0,0,0,614,5229,1,0,0,0,616,
  	5237,1,0,0,0,618,5241,1,0,0,0,620,5249,1,0,0,0,622,5258,1,0,0,0,624,5260,
  	1,0,0,0,626,5283,1,0,0,0,628,5285,1,0,0,0,630,5287,1,0,0,0,632,5303,1,
  	0,0,0,634,5315,1,0,0,0,636,5317,1,0,0,0,638,5325,1,0,0,0,640,5333,1,0,
  	0,0,642,5342,1,0,0,0,644,5344,1,0,0,0,646,5362,1,0,0,0,648,5376,1,0,0,
  	0,650,5381,1,0,0,0,652,5387,1,0,0,0,654,5389,1,0,0,0,656,5405,1,0,0,0,
  	658,5413,1,0,0,0,660,5423,1,0,0,0,662,5436,1,0,0,0,664,5438,1,0,0,0,666,
  	5444,1,0,0,0,668,5476,1,0,0,0,670,5478,1,0,0,0,672,5481,1,0,0,0,674,5484,
  	1,0,0,0,676,5497,1,0,0,0,678,5513,1,0,0,0,680,5536,1,0,0,0,682,5538,1,
  	0,0,0,684,5575,1,0,0,0,686,5577,1,0,0,0,688,5718,1,0,0,0,690,5731,1,0,
  	0,0,692,5740,1,0,0,0,694,5873,1,0,0,0,696,5875,1,0,0,0,698,5922,1,0,0,
  	0,700,5924,1,0,0,0,702,5929,1,0,0,0,704,5938,1,0,0,0,706,5957,1,0,0,0,
  	708,5960,1,0,0,0,710,5969,1,0,0,0,712,5971,1,0,0,0,714,5994,1,0,0,0,716,
  	6269,1,0,0,0,718,6302,1,0,0,0,720,6304,1,0,0,0,722,6310,1,0,0,0,724,6313,
  	1,0,0,0,726,6328,1,0,0,0,728,6336,1,0,0,0,730,6338,1,0,0,0,732,6367,1,
  	0,0,0,734,6400,1,0,0,0,736,6402,1,0,0,0,738,6410,1,0,0,0,740,6416,1,0,
  	0,0,742,6421,1,0,0,0,744,6423,1,0,0,0,746,6445,1,0,0,0,748,6447,1,0,0,
  	0,750,6450,1,0,0,0,752,6453,1,0,0,0,754,6501,1,0,0,0,756,6503,1,0,0,0,
  	758,6514,1,0,0,0,760,6516,1,0,0,0,762,6518,1,0,0,0,764,6522,1,0,0,0,766,
  	6524,1,0,0,0,768,6526,1,0,0,0,770,6530,1,0,0,0,772,6534,1,0,0,0,774,6538,
  	1,0,0,0,776,6546,1,0,0,0,778,6550,1,0,0,0,780,6558,1,0,0,0,782,6560,1,
  	0,0,0,784,6578,1,0,0,0,786,6580,1,0,0,0,788,6583,1,0,0,0,790,6588,1,0,
  	0,0,792,6596,1,0,0,0,794,6602,1,0,0,0,796,6606,1,0,0,0,798,6623,1,0,0,
  	0,800,6626,1,0,0,0,802,6631,1,0,0,0,804,6633,1,0,0,0,806,6636,1,0,0,0,
  	808,6645,1,0,0,0,810,6653,1,0,0,0,812,6655,1,0,0,0,814,6660,1,0,0,0,816,
  	6667,1,0,0,0,818,6677,1,0,0,0,820,6685,1,0,0,0,822,6687,1,0,0,0,824,6697,
  	1,0,0,0,826,6705,1,0,0,0,828,6707,1,0,0,0,830,6713,1,0,0,0,832,6734,1,
  	0,0,0,834,6736,1,0,0,0,836,6742,1,0,0,0,838,6745,1,0,0,0,840,6748,1,0,
  	0,0,842,6778,1,0,0,0,844,6782,1,0,0,0,846,6789,1,0,0,0,848,6796,1,0,0,
  	0,850,6798,1,0,0,0,852,6814,1,0,0,0,854,6830,1,0,0,0,856,6834,1,0,0,0,
  	858,6837,1,0,0,0,860,6840,1,0,0,0,862,6864,1,0,0,0,864,6866,1,0,0,0,866,
  	6874,1,0,0,0,868,6876,1,0,0,0,870,6880,1,0,0,0,872,6959,1,0,0,0,874,6961,
  	1,0,0,0,876,6965,1,0,0,0,878,7055,1,0,0,0,880,7057,1,0,0,0,882,7059,1,
  	0,0,0,884,7075,1,0,0,0,886,7077,1,0,0,0,888,7109,1,0,0,0,890,7111,1,0,
  	0,0,892,7122,1,0,0,0,894,7129,1,0,0,0,896,7145,1,0,0,0,898,7151,1,0,0,
  	0,900,7153,1,0,0,0,902,7157,1,0,0,0,904,7168,1,0,0,0,906,7170,1,0,0,0,
  	908,7172,1,0,0,0,910,7179,1,0,0,0,912,7181,1,0,0,0,914,7183,1,0,0,0,916,
  	7333,1,0,0,0,918,7338,1,0,0,0,920,7345,1,0,0,0,922,7347,1,0,0,0,924,7355,
  	1,0,0,0,926,7373,1,0,0,0,928,7381,1,0,0,0,930,7389,1,0,0,0,932,7391,1,
  	0,0,0,934,7395,1,0,0,0,936,7403,1,0,0,0,938,7410,1,0,0,0,940,7412,1,0,
  	0,0,942,7423,1,0,0,0,944,7556,1,0,0,0,946,7560,1,0,0,0,948,7563,1,0,0,
  	0,950,7572,1,0,0,0,952,7581,1,0,0,0,954,7589,1,0,0,0,956,7635,1,0,0,0,
  	958,7637,1,0,0,0,960,7658,1,0,0,0,962,7663,1,0,0,0,964,7674,1,0,0,0,966,
  	7719,1,0,0,0,968,7755,1,0,0,0,970,7757,1,0,0,0,972,7765,1,0,0,0,974,7778,
  	1,0,0,0,976,7780,1,0,0,0,978,7784,1,0,0,0,980,7787,1,0,0,0,982,7792,1,
  	0,0,0,984,7796,1,0,0,0,986,7799,1,0,0,0,988,7802,1,0,0,0,990,7806,1,0,
  	0,0,992,7812,1,0,0,0,994,7820,1,0,0,0,996,7828,1,0,0,0,998,7834,1,0,0,
  	0,1000,7837,1,0,0,0,1002,7855,1,0,0,0,1004,7857,1,0,0,0,1006,7863,1,0,
  	0,0,1008,7867,1,0,0,0,1010,7875,1,0,0,0,1012,7883,1,0,0,0,1014,7891,1,
  	0,0,0,1016,7920,1,0,0,0,1018,7951,1,0,0,0,1020,7955,1,0,0,0,1022,7959,
  	1,0,0,0,1024,7962,1,0,0,0,1026,7973,1,0,0,0,1028,7975,1,0,0,0,1030,7980,
  	1,0,0,0,1032,7982,1,0,0,0,1034,7984,1,0,0,0,1036,7986,1,0,0,0,1038,7995,
  	1,0,0,0,1040,8001,1,0,0,0,1042,8003,1,0,0,0,1044,8005,1,0,0,0,1046,8016,
  	1,0,0,0,1048,8020,1,0,0,0,1050,8022,1,0,0,0,1052,8024,1,0,0,0,1054,8026,
  	1,0,0,0,1056,8035,1,0,0,0,1058,8037,1,0,0,0,1060,8039,1,0,0,0,1062,8041,
  	1,0,0,0,1064,8043,1,0,0,0,1066,8045,1,0,0,0,1068,8047,1,0,0,0,1070,8049,
  	1,0,0,0,1072,8053,1,0,0,0,1074,8057,1,0,0,0,1076,8059,1,0,0,0,1078,8061,
  	1,0,0,0,1080,8063,1,0,0,0,1082,8065,1,0,0,0,1084,8067,1,0,0,0,1086,8069,
  	1,0,0,0,1088,8071,1,0,0,0,1090,8073,1,0,0,0,1092,8075,1,0,0,0,1094,8077,
  	1,0,0,0,1096,8081,1,0,0,0,1098,8083,1,0,0,0,1100,8086,1,0,0,0,1102,8098,
  	1,0,0,0,1104,8100,1,0,0,0,1106,8108,1,0,0,0,1108,8116,1,0,0,0,1110,8120,
  	1,0,0,0,1112,8122,1,0,0,0,1114,8126,1,0,0,0,1116,8128,1,0,0,0,1118,8130,
  	1,0,0,0,1120,8132,1,0,0,0,1122,8134,1,0,0,0,1124,8136,1,0,0,0,1126,8141,
  	1,0,0,0,1128,8145,1,0,0,0,1130,8147,1,0,0,0,1132,8155,1,0,0,0,1134,8159,
  	1,0,0,0,1136,8174,1,0,0,0,1138,8176,1,0,0,0,1140,8179,1,0,0,0,1142,8181,
  	1,0,0,0,1144,8183,1,0,0,0,1146,8190,1,0,0,0,1148,8201,1,0,0,0,1150,8208,
  	1,0,0,0,1152,8210,1,0,0,0,1154,8224,1,0,0,0,1156,8229,1,0,0,0,1158,8234,
  	1,0,0,0,1160,8241,1,0,0,0,1162,8249,1,0,0,0,1164,8251,1,0,0,0,1166,8259,
  	1,0,0,0,1168,8261,1,0,0,0,1170,8263,1,0,0,0,1172,8271,1,0,0,0,1174,8275,
  	1,0,0,0,1176,8277,1,0,0,0,1178,8279,1,0,0,0,1180,8287,1,0,0,0,1182,8291,
  	1,0,0,0,1184,8295,1,0,0,0,1186,8299,1,0,0,0,1188,8301,1,0,0,0,1190,8304,
  	1,0,0,0,1192,8306,1,0,0,0,1194,8314,1,0,0,0,1196,8326,1,0,0,0,1198,8345,
  	1,0,0,0,1200,8347,1,0,0,0,1202,8349,1,0,0,0,1204,8369,1,0,0,0,1206,8371,
  	1,0,0,0,1208,8376,1,0,0,0,1210,8388,1,0,0,0,1212,8394,1,0,0,0,1214,8396,
  	1,0,0,0,1216,8403,1,0,0,0,1218,8414,1,0,0,0,1220,1233,5,0,0,1,1221,1224,
  	3,2,1,0,1222,1224,3,422,211,0,1223,1221,1,0,0,0,1223,1222,1,0,0,0,1224,
  	1230,1,0,0,0,1225,1227,5,774,0,0,1226,1228,5,0,0,1,1227,1226,1,0,0,0,
  	1227,1228,1,0,0,0,1228,1231,1,0,0,0,1229,1231,5,0,0,1,1230,1225,1,0,0,
  	0,1230,1229,1,0,0,0,1231,1233,1,0,0,0,1232,1220,1,0,0,0,1232,1223,1,0,
  	0,0,1233,1,1,0,0,0,1234,1269,3,4,2,0,1235,1269,3,76,38,0,1236,1269,3,
  	178,89,0,1237,1269,3,210,105,0,1238,1269,3,214,107,0,1239,1240,4,1,0,
  	0,1240,1269,3,216,108,0,1241,1269,3,218,109,0,1242,1269,3,220,110,0,1243,
  	1269,3,226,113,0,1244,1269,3,228,114,0,1245,1269,3,232,116,0,1246,1269,
  	3,252,126,0,1247,1269,3,264,132,0,1248,1269,3,266,133,0,1249,1269,3,416,
  	208,0,1250,1269,3,418,209,0,1251,1269,3,440,220,0,1252,1269,3,490,245,
  	0,1253,1254,4,1,1,0,1254,1269,3,496,248,0,1255,1269,3,502,251,0,1256,
  	1269,3,564,282,0,1257,1269,3,572,286,0,1258,1269,3,574,287,0,1259,1269,
  	3,598,299,0,1260,1261,4,1,2,0,1261,1269,3,642,321,0,1262,1269,3,610,305,
  	0,1263,1269,3,662,331,0,1264,1265,4,1,3,0,1265,1269,3,840,420,0,1266,
  	1269,3,850,425,0,1267,1269,3,852,426,0,1268,1234,1,0,0,0,1268,1235,1,
  	0,0,0,1268,1236,1,0,0,0,1268,1237,1,0,0,0,1268,1238,1,0,0,0,1268,1239,
  	1,0,0,0,1268,1241,1,0,0,0,1268,1242,1,0,0,0,1268,1243,1,0,0,0,1268,1244,
  	1,0,0,0,1268,1245,1,0,0,0,1268,1246,1,0,0,0,1268,1247,1,0,0,0,1268,1248,
  	1,0,0,0,1268,1249,1,0,0,0,1268,1250,1,0,0,0,1268,1251,1,0,0,0,1268,1252,
  	1,0,0,0,1268,1253,1,0,0,0,1268,1255,1,0,0,0,1268,1256,1,0,0,0,1268,1257,
  	1,0,0,0,1268,1258,1,0,0,0,1268,1259,1,0,0,0,1268,1260,1,0,0,0,1268,1262,
  	1,0,0,0,1268,1263,1,0,0,0,1268,1264,1,0,0,0,1268,1266,1,0,0,0,1268,1267,
  	1,0,0,0,1269,3,1,0,0,0,1270,1297,5,11,0,0,1271,1298,3,18,9,0,1272,1298,
  	3,6,3,0,1273,1274,5,422,0,0,1274,1276,3,1062,531,0,1275,1277,3,102,51,
  	0,1276,1275,1,0,0,0,1276,1277,1,0,0,0,1277,1298,1,0,0,0,1278,1279,5,206,
  	0,0,1279,1281,3,1066,533,0,1280,1282,3,102,51,0,1281,1280,1,0,0,0,1281,
  	1282,1,0,0,0,1282,1298,1,0,0,0,1283,1298,3,68,34,0,1284,1298,3,8,4,0,
  	1285,1298,3,54,27,0,1286,1287,4,2,4,0,1287,1298,3,56,28,0,1288,1298,3,
  	10,5,0,1289,1298,3,16,8,0,1290,1291,4,2,5,0,1291,1292,5,244,0,0,1292,
  	1293,5,482,0,0,1293,1294,3,1180,590,0,1294,1295,5,316,0,0,1295,1296,5,
  	265,0,0,1296,1298,1,0,0,0,1297,1271,1,0,0,0,1297,1272,1,0,0,0,1297,1273,
  	1,0,0,0,1297,1278,1,0,0,0,1297,1283,1,0,0,0,1297,1284,1,0,0,0,1297,1285,
  	1,0,0,0,1297,1286,1,0,0,0,1297,1288,1,0,0,0,1297,1289,1,0,0,0,1297,1290,
  	1,0,0,0,1298,5,1,0,0,0,1299,1300,5,109,0,0,1300,1311,3,1058,529,0,1301,
  	1303,3,80,40,0,1302,1301,1,0,0,0,1303,1304,1,0,0,0,1304,1302,1,0,0,0,
  	1304,1305,1,0,0,0,1305,1312,1,0,0,0,1306,1307,4,3,6,0,1307,1308,5,615,
  	0,0,1308,1309,5,112,0,0,1309,1310,5,139,0,0,1310,1312,5,357,0,0,1311,
  	1302,1,0,0,0,1311,1306,1,0,0,0,1312,7,1,0,0,0,1313,1315,3,976,488,0,1314,
  	1313,1,0,0,0,1314,1315,1,0,0,0,1315,1316,1,0,0,0,1316,1317,5,170,0,0,
  	1317,1321,3,1086,543,0,1318,1319,5,383,0,0,1319,1320,5,490,0,0,1320,1322,
  	3,862,431,0,1321,1318,1,0,0,0,1321,1322,1,0,0,0,1322,1329,1,0,0,0,1323,
  	1324,5,383,0,0,1324,1326,5,79,0,0,1325,1327,5,371,0,0,1326,1325,1,0,0,
  	0,1326,1327,1,0,0,0,1327,1328,1,0,0,0,1328,1330,5,418,0,0,1329,1323,1,
  	0,0,0,1329,1330,1,0,0,0,1330,1334,1,0,0,0,1331,1332,5,453,0,0,1332,1333,
  	5,590,0,0,1333,1335,3,1128,564,0,1334,1331,1,0,0,0,1334,1335,1,0,0,0,
  	1335,1342,1,0,0,0,1336,1343,5,156,0,0,1337,1340,5,140,0,0,1338,1339,5,
  	383,0,0,1339,1341,5,514,0,0,1340,1338,1,0,0,0,1340,1341,1,0,0,0,1341,
  	1343,1,0,0,0,1342,1336,1,0,0,0,1342,1337,1,0,0,0,1342,1343,1,0,0,0,1343,
  	1346,1,0,0,0,1344,1345,5,75,0,0,1345,1347,3,1160,580,0,1346,1344,1,0,
  	0,0,1346,1347,1,0,0,0,1347,1350,1,0,0,0,1348,1349,5,147,0,0,1349,1351,
  	3,784,392,0,1350,1348,1,0,0,0,1350,1351,1,0,0,0,1351,9,1,0,0,0,1352,1353,
  	5,288,0,0,1353,1354,5,217,0,0,1354,1355,3,1082,541,0,1355,1356,5,4,0,
  	0,1356,1357,5,603,0,0,1357,1359,3,1160,580,0,1358,1360,3,12,6,0,1359,
  	1358,1,0,0,0,1359,1360,1,0,0,0,1360,11,1,0,0,0,1361,1368,3,14,7,0,1362,
  	1364,5,773,0,0,1363,1362,1,0,0,0,1363,1364,1,0,0,0,1364,1365,1,0,0,0,
  	1365,1367,3,14,7,0,1366,1363,1,0,0,0,1367,1370,1,0,0,0,1368,1366,1,0,
  	0,0,1368,1369,1,0,0,0,1369,13,1,0,0,0,1370,1368,1,0,0,0,1371,1375,3,136,
  	68,0,1372,1375,3,148,74,0,1373,1375,3,150,75,0,1374,1371,1,0,0,0,1374,
  	1372,1,0,0,0,1374,1373,1,0,0,0,1375,15,1,0,0,0,1376,1377,5,503,0,0,1377,
  	1378,3,1092,546,0,1378,1379,3,120,60,0,1379,17,1,0,0,0,1380,1382,3,1032,
  	516,0,1381,1380,1,0,0,0,1381,1382,1,0,0,0,1382,1385,1,0,0,0,1383,1384,
  	4,9,7,0,1384,1386,5,232,0,0,1385,1383,1,0,0,0,1385,1386,1,0,0,0,1386,
  	1387,1,0,0,0,1387,1388,5,574,0,0,1388,1390,3,1102,551,0,1389,1391,3,20,
  	10,0,1390,1389,1,0,0,0,1390,1391,1,0,0,0,1391,19,1,0,0,0,1392,1395,3,
  	22,11,0,1393,1396,3,954,477,0,1394,1396,3,50,25,0,1395,1393,1,0,0,0,1395,
  	1394,1,0,0,0,1395,1396,1,0,0,0,1396,1406,1,0,0,0,1397,1406,3,954,477,
  	0,1398,1406,3,50,25,0,1399,1400,3,24,12,0,1400,1401,5,773,0,0,1401,1403,
  	1,0,0,0,1402,1399,1,0,0,0,1402,1403,1,0,0,0,1403,1404,1,0,0,0,1404,1406,
  	3,26,13,0,1405,1392,1,0,0,0,1405,1397,1,0,0,0,1405,1398,1,0,0,0,1405,
  	1402,1,0,0,0,1406,21,1,0,0,0,1407,1415,3,24,12,0,1408,1409,3,24,12,0,
  	1409,1410,5,773,0,0,1410,1412,1,0,0,0,1411,1408,1,0,0,0,1411,1412,1,0,
  	0,0,1412,1413,1,0,0,0,1413,1415,3,30,15,0,1414,1407,1,0,0,0,1414,1411,
  	1,0,0,0,1415,23,1,0,0,0,1416,1421,3,32,16,0,1417,1418,5,773,0,0,1418,
  	1420,3,32,16,0,1419,1417,1,0,0,0,1420,1423,1,0,0,0,1421,1419,1,0,0,0,
  	1421,1422,1,0,0,0,1422,25,1,0,0,0,1423,1421,1,0,0,0,1424,1425,5,141,0,
  	0,1425,1432,5,572,0,0,1426,1427,5,234,0,0,1427,1432,5,572,0,0,1428,1432,
  	3,28,14,0,1429,1430,4,13,8,0,1430,1432,7,0,0,0,1431,1424,1,0,0,0,1431,
  	1426,1,0,0,0,1431,1428,1,0,0,0,1431,1429,1,0,0,0,1432,27,1,0,0,0,1433,
  	1434,5,4,0,0,1434,1436,5,405,0,0,1435,1437,3,1034,517,0,1436,1435,1,0,
  	0,0,1436,1437,1,0,0,0,1437,1441,1,0,0,0,1438,1442,3,962,481,0,1439,1440,
  	5,404,0,0,1440,1442,3,1142,571,0,1441,1438,1,0,0,0,1441,1439,1,0,0,0,
  	1442,1530,1,0,0,0,1443,1444,5,148,0,0,1444,1445,5,405,0,0,1445,1530,3,
  	1130,565,0,1446,1447,5,438,0,0,1447,1449,5,405,0,0,1448,1450,3,1034,517,
  	0,1449,1448,1,0,0,0,1449,1450,1,0,0,0,1450,1451,1,0,0,0,1451,1530,3,52,
  	26,0,1452,1453,5,388,0,0,1453,1455,5,405,0,0,1454,1456,3,1034,517,0,1455,
  	1454,1,0,0,0,1455,1456,1,0,0,0,1456,1457,1,0,0,0,1457,1459,3,52,26,0,
  	1458,1460,3,1034,517,0,1459,1458,1,0,0,0,1459,1460,1,0,0,0,1460,1530,
  	1,0,0,0,1461,1462,5,14,0,0,1462,1464,5,405,0,0,1463,1465,3,1034,517,0,
  	1464,1463,1,0,0,0,1464,1465,1,0,0,0,1465,1466,1,0,0,0,1466,1530,3,52,
  	26,0,1467,1468,5,62,0,0,1468,1469,5,405,0,0,1469,1473,3,52,26,0,1470,
  	1472,3,568,284,0,1471,1470,1,0,0,0,1472,1475,1,0,0,0,1473,1471,1,0,0,
  	0,1473,1474,1,0,0,0,1474,1530,1,0,0,0,1475,1473,1,0,0,0,1476,1477,5,455,
  	0,0,1477,1479,5,405,0,0,1478,1480,3,1034,517,0,1479,1478,1,0,0,0,1479,
  	1480,1,0,0,0,1480,1481,1,0,0,0,1481,1485,3,52,26,0,1482,1484,3,570,285,
  	0,1483,1482,1,0,0,0,1484,1487,1,0,0,0,1485,1483,1,0,0,0,1485,1486,1,0,
  	0,0,1486,1530,1,0,0,0,1487,1485,1,0,0,0,1488,1489,5,67,0,0,1489,1491,
  	5,405,0,0,1490,1492,3,1034,517,0,1491,1490,1,0,0,0,1491,1492,1,0,0,0,
  	1492,1493,1,0,0,0,1493,1530,3,1142,571,0,1494,1495,5,597,0,0,1495,1496,
  	5,405,0,0,1496,1530,3,52,26,0,1497,1498,5,454,0,0,1498,1500,5,405,0,0,
  	1499,1501,3,1034,517,0,1500,1499,1,0,0,0,1500,1501,1,0,0,0,1501,1506,
  	1,0,0,0,1502,1503,3,1130,565,0,1503,1504,5,248,0,0,1504,1505,3,962,481,
  	0,1505,1507,1,0,0,0,1506,1502,1,0,0,0,1506,1507,1,0,0,0,1507,1530,1,0,
  	0,0,1508,1509,5,172,0,0,1509,1510,5,405,0,0,1510,1511,3,1128,564,0,1511,
  	1512,5,645,0,0,1512,1513,5,574,0,0,1513,1515,3,1102,551,0,1514,1516,3,
  	48,24,0,1515,1514,1,0,0,0,1515,1516,1,0,0,0,1516,1530,1,0,0,0,1517,1518,
  	4,14,9,0,1518,1519,5,141,0,0,1519,1520,5,405,0,0,1520,1521,3,52,26,0,
  	1521,1522,5,572,0,0,1522,1530,1,0,0,0,1523,1524,4,14,10,0,1524,1525,5,
  	234,0,0,1525,1526,5,405,0,0,1526,1527,3,52,26,0,1527,1528,5,572,0,0,1528,
  	1530,1,0,0,0,1529,1433,1,0,0,0,1529,1443,1,0,0,0,1529,1446,1,0,0,0,1529,
  	1452,1,0,0,0,1529,1461,1,0,0,0,1529,1467,1,0,0,0,1529,1476,1,0,0,0,1529,
  	1488,1,0,0,0,1529,1494,1,0,0,0,1529,1497,1,0,0,0,1529,1508,1,0,0,0,1529,
  	1517,1,0,0,0,1529,1523,1,0,0,0,1530,29,1,0,0,0,1531,1534,3,34,17,0,1532,
  	1534,3,942,471,0,1533,1531,1,0,0,0,1533,1532,1,0,0,0,1534,1543,1,0,0,
  	0,1535,1539,5,773,0,0,1536,1540,3,34,17,0,1537,1540,3,32,16,0,1538,1540,
  	3,942,471,0,1539,1536,1,0,0,0,1539,1537,1,0,0,0,1539,1538,1,0,0,0,1540,
  	1542,1,0,0,0,1541,1535,1,0,0,0,1542,1545,1,0,0,0,1543,1541,1,0,0,0,1543,
  	1544,1,0,0,0,1544,31,1,0,0,0,1545,1543,1,0,0,0,1546,1550,3,42,21,0,1547,
  	1550,3,44,22,0,1548,1550,3,48,24,0,1549,1546,1,0,0,0,1549,1547,1,0,0,
  	0,1549,1548,1,0,0,0,1550,33,1,0,0,0,1551,1553,5,4,0,0,1552,1554,5,72,
  	0,0,1553,1552,1,0,0,0,1553,1554,1,0,0,0,1554,1567,1,0,0,0,1555,1556,3,
  	1128,564,0,1556,1558,3,876,438,0,1557,1559,3,866,433,0,1558,1557,1,0,
  	0,0,1558,1559,1,0,0,0,1559,1561,1,0,0,0,1560,1562,3,36,18,0,1561,1560,
  	1,0,0,0,1561,1562,1,0,0,0,1562,1568,1,0,0,0,1563,1564,5,776,0,0,1564,
  	1565,3,84,42,0,1565,1566,5,777,0,0,1566,1568,1,0,0,0,1567,1555,1,0,0,
  	0,1567,1563,1,0,0,0,1568,1697,1,0,0,0,1569,1570,5,4,0,0,1570,1697,3,872,
  	436,0,1571,1573,5,55,0,0,1572,1574,5,72,0,0,1573,1572,1,0,0,0,1573,1574,
  	1,0,0,0,1574,1575,1,0,0,0,1575,1576,3,1042,521,0,1576,1577,3,1128,564,
  	0,1577,1579,3,876,438,0,1578,1580,3,36,18,0,1579,1578,1,0,0,0,1579,1580,
  	1,0,0,0,1580,1697,1,0,0,0,1581,1583,5,348,0,0,1582,1584,5,72,0,0,1583,
  	1582,1,0,0,0,1583,1584,1,0,0,0,1584,1585,1,0,0,0,1585,1586,3,1042,521,
  	0,1586,1588,3,876,438,0,1587,1589,3,36,18,0,1588,1587,1,0,0,0,1588,1589,
  	1,0,0,0,1589,1697,1,0,0,0,1590,1619,5,148,0,0,1591,1593,5,72,0,0,1592,
  	1591,1,0,0,0,1592,1593,1,0,0,0,1593,1594,1,0,0,0,1594,1596,3,1042,521,
  	0,1595,1597,3,38,19,0,1596,1595,1,0,0,0,1596,1597,1,0,0,0,1597,1620,1,
  	0,0,0,1598,1599,5,199,0,0,1599,1606,5,265,0,0,1600,1601,4,17,11,0,1601,
  	1607,3,1042,521,0,1602,1604,4,17,12,0,1603,1605,3,1042,521,0,1604,1603,
  	1,0,0,0,1604,1605,1,0,0,0,1605,1607,1,0,0,0,1606,1600,1,0,0,0,1606,1602,
  	1,0,0,0,1607,1620,1,0,0,0,1608,1609,5,420,0,0,1609,1620,5,265,0,0,1610,
  	1611,3,406,203,0,1611,1612,3,1052,526,0,1612,1620,1,0,0,0,1613,1614,4,
  	17,13,0,1614,1615,5,62,0,0,1615,1620,3,1128,564,0,1616,1617,4,17,14,0,
  	1617,1618,5,86,0,0,1618,1620,3,1128,564,0,1619,1592,1,0,0,0,1619,1598,
  	1,0,0,0,1619,1608,1,0,0,0,1619,1610,1,0,0,0,1619,1613,1,0,0,0,1619,1616,
  	1,0,0,0,1620,1697,1,0,0,0,1621,1622,5,140,0,0,1622,1697,5,263,0,0,1623,
  	1624,5,156,0,0,1624,1697,5,263,0,0,1625,1627,5,11,0,0,1626,1628,5,72,
  	0,0,1627,1626,1,0,0,0,1627,1628,1,0,0,0,1628,1629,1,0,0,0,1629,1639,3,
  	1042,521,0,1630,1631,5,506,0,0,1631,1635,5,128,0,0,1632,1633,4,17,15,
  	0,1633,1636,3,770,385,0,1634,1636,3,1150,575,0,1635,1632,1,0,0,0,1635,
  	1634,1,0,0,0,1636,1640,1,0,0,0,1637,1638,5,148,0,0,1638,1640,5,128,0,
  	0,1639,1630,1,0,0,0,1639,1637,1,0,0,0,1640,1697,1,0,0,0,1641,1642,4,17,
  	16,0,1642,1643,5,11,0,0,1643,1644,5,236,0,0,1644,1645,3,1052,526,0,1645,
  	1646,3,906,453,0,1646,1697,1,0,0,0,1647,1648,4,17,17,0,1648,1649,5,11,
  	0,0,1649,1650,5,62,0,0,1650,1651,3,1128,564,0,1651,1652,3,870,435,0,1652,
  	1697,1,0,0,0,1653,1654,4,17,18,0,1654,1655,5,11,0,0,1655,1656,5,86,0,
  	0,1656,1657,3,1128,564,0,1657,1658,3,870,435,0,1658,1697,1,0,0,0,1659,
  	1660,4,17,19,0,1660,1661,5,453,0,0,1661,1662,5,72,0,0,1662,1663,3,1042,
  	521,0,1663,1664,5,590,0,0,1664,1665,3,1128,564,0,1665,1697,1,0,0,0,1666,
  	1668,5,453,0,0,1667,1669,7,1,0,0,1668,1667,1,0,0,0,1668,1669,1,0,0,0,
  	1669,1670,1,0,0,0,1670,1697,3,1096,548,0,1671,1672,4,17,20,0,1672,1673,
  	5,453,0,0,1673,1674,3,406,203,0,1674,1675,3,1052,526,0,1675,1676,5,590,
  	0,0,1676,1677,3,1050,525,0,1677,1697,1,0,0,0,1678,1679,5,94,0,0,1679,
  	1680,5,590,0,0,1680,1684,3,758,379,0,1681,1682,4,17,21,0,1682,1685,5,
  	128,0,0,1683,1685,3,936,468,0,1684,1681,1,0,0,0,1684,1683,1,0,0,0,1685,
  	1687,1,0,0,0,1686,1688,3,986,493,0,1687,1686,1,0,0,0,1687,1688,1,0,0,
  	0,1688,1697,1,0,0,0,1689,1697,5,198,0,0,1690,1691,5,393,0,0,1691,1692,
  	5,45,0,0,1692,1697,3,40,20,0,1693,1694,4,17,22,0,1694,1695,5,615,0,0,
  	1695,1697,5,403,0,0,1696,1551,1,0,0,0,1696,1569,1,0,0,0,1696,1571,1,0,
  	0,0,1696,1581,1,0,0,0,1696,1590,1,0,0,0,1696,1621,1,0,0,0,1696,1623,1,
  	0,0,0,1696,1625,1,0,0,0,1696,1641,1,0,0,0,1696,1647,1,0,0,0,1696,1653,
  	1,0,0,0,1696,1659,1,0,0,0,1696,1666,1,0,0,0,1696,1671,1,0,0,0,1696,1678,
  	1,0,0,0,1696,1689,1,0,0,0,1696,1690,1,0,0,0,1696,1693,1,0,0,0,1697,35,
  	1,0,0,0,1698,1699,5,6,0,0,1699,1702,3,1128,564,0,1700,1702,5,191,0,0,
  	1701,1698,1,0,0,0,1701,1700,1,0,0,0,1702,37,1,0,0,0,1703,1704,7,2,0,0,
  	1704,39,1,0,0,0,1705,1707,3,1128,564,0,1706,1708,3,330,165,0,1707,1706,
  	1,0,0,0,1707,1708,1,0,0,0,1708,1716,1,0,0,0,1709,1710,5,773,0,0,1710,
  	1712,3,1128,564,0,1711,1713,3,330,165,0,1712,1711,1,0,0,0,1712,1713,1,
  	0,0,0,1713,1715,1,0,0,0,1714,1709,1,0,0,0,1715,1718,1,0,0,0,1716,1714,
  	1,0,0,0,1716,1717,1,0,0,0,1717,41,1,0,0,0,1718,1716,1,0,0,0,1719,1721,
  	5,9,0,0,1720,1722,5,750,0,0,1721,1720,1,0,0,0,1721,1722,1,0,0,0,1722,
  	1725,1,0,0,0,1723,1726,5,128,0,0,1724,1726,3,1128,564,0,1725,1723,1,0,
  	0,0,1725,1724,1,0,0,0,1726,43,1,0,0,0,1727,1729,5,287,0,0,1728,1730,5,
  	750,0,0,1729,1728,1,0,0,0,1729,1730,1,0,0,0,1730,1733,1,0,0,0,1731,1734,
  	5,128,0,0,1732,1734,3,1128,564,0,1733,1731,1,0,0,0,1733,1732,1,0,0,0,
  	1734,45,1,0,0,0,1735,1737,3,42,21,0,1736,1738,3,44,22,0,1737,1736,1,0,
  	0,0,1737,1738,1,0,0,0,1738,1744,1,0,0,0,1739,1741,3,44,22,0,1740,1742,
  	3,42,21,0,1741,1740,1,0,0,0,1741,1742,1,0,0,0,1742,1744,1,0,0,0,1743,
  	1735,1,0,0,0,1743,1739,1,0,0,0,1744,47,1,0,0,0,1745,1746,4,24,23,0,1746,
  	1747,7,3,0,0,1747,1748,5,625,0,0,1748,49,1,0,0,0,1749,1750,5,452,0,0,
  	1750,1751,5,403,0,0,1751,51,1,0,0,0,1752,1755,5,10,0,0,1753,1755,3,1130,
  	565,0,1754,1752,1,0,0,0,1754,1753,1,0,0,0,1755,53,1,0,0,0,1756,1757,5,
  	572,0,0,1757,1791,3,1078,539,0,1758,1759,7,4,0,0,1759,1760,5,111,0,0,
  	1760,1762,3,1160,580,0,1761,1763,3,62,31,0,1762,1761,1,0,0,0,1762,1763,
  	1,0,0,0,1763,1792,1,0,0,0,1764,1784,4,27,24,0,1765,1785,1,0,0,0,1766,
  	1767,5,55,0,0,1767,1768,5,111,0,0,1768,1779,3,1160,580,0,1769,1776,3,
  	66,33,0,1770,1772,5,773,0,0,1771,1770,1,0,0,0,1771,1772,1,0,0,0,1772,
  	1773,1,0,0,0,1773,1775,3,66,33,0,1774,1771,1,0,0,0,1775,1778,1,0,0,0,
  	1776,1774,1,0,0,0,1776,1777,1,0,0,0,1777,1780,1,0,0,0,1778,1776,1,0,0,
  	0,1779,1769,1,0,0,0,1779,1780,1,0,0,0,1780,1785,1,0,0,0,1781,1785,7,5,
  	0,0,1782,1783,5,371,0,0,1783,1785,5,1,0,0,1784,1765,1,0,0,0,1784,1766,
  	1,0,0,0,1784,1781,1,0,0,0,1784,1782,1,0,0,0,1785,1792,1,0,0,0,1786,1787,
  	5,453,0,0,1787,1788,5,590,0,0,1788,1792,3,1128,564,0,1789,1790,4,27,25,
  	0,1790,1792,3,62,31,0,1791,1758,1,0,0,0,1791,1764,1,0,0,0,1791,1786,1,
  	0,0,0,1791,1789,1,0,0,0,1792,55,1,0,0,0,1793,1794,5,605,0,0,1794,1795,
  	5,572,0,0,1795,1796,3,1078,539,0,1796,1797,5,506,0,0,1797,1799,7,6,0,
  	0,1798,1800,3,58,29,0,1799,1798,1,0,0,0,1799,1800,1,0,0,0,1800,57,1,0,
  	0,0,1801,1808,3,60,30,0,1802,1804,5,773,0,0,1803,1802,1,0,0,0,1803,1804,
  	1,0,0,0,1804,1805,1,0,0,0,1805,1807,3,60,30,0,1806,1803,1,0,0,0,1807,
  	1810,1,0,0,0,1808,1806,1,0,0,0,1808,1809,1,0,0,0,1809,59,1,0,0,0,1810,
  	1808,1,0,0,0,1811,1812,3,148,74,0,1812,61,1,0,0,0,1813,1820,3,64,32,0,
  	1814,1816,5,773,0,0,1815,1814,1,0,0,0,1815,1816,1,0,0,0,1816,1817,1,0,
  	0,0,1817,1819,3,64,32,0,1818,1815,1,0,0,0,1819,1822,1,0,0,0,1820,1818,
  	1,0,0,0,1820,1821,1,0,0,0,1821,63,1,0,0,0,1822,1820,1,0,0,0,1823,1825,
  	5,238,0,0,1824,1826,5,750,0,0,1825,1824,1,0,0,0,1825,1826,1,0,0,0,1826,
  	1827,1,0,0,0,1827,1834,3,1186,593,0,1828,1834,3,140,70,0,1829,1834,3,
  	142,71,0,1830,1834,3,148,74,0,1831,1834,3,150,75,0,1832,1834,3,156,78,
  	0,1833,1823,1,0,0,0,1833,1828,1,0,0,0,1833,1829,1,0,0,0,1833,1830,1,0,
  	0,0,1833,1831,1,0,0,0,1833,1832,1,0,0,0,1834,65,1,0,0,0,1835,1837,5,238,
  	0,0,1836,1838,5,750,0,0,1837,1836,1,0,0,0,1837,1838,1,0,0,0,1838,1839,
  	1,0,0,0,1839,1843,3,1186,593,0,1840,1843,3,140,70,0,1841,1843,3,142,71,
  	0,1842,1835,1,0,0,0,1842,1840,1,0,0,0,1842,1841,1,0,0,0,1843,67,1,0,0,
  	0,1844,1846,3,162,81,0,1845,1844,1,0,0,0,1845,1846,1,0,0,0,1846,1848,
  	1,0,0,0,1847,1849,3,976,488,0,1848,1847,1,0,0,0,1848,1849,1,0,0,0,1849,
  	1851,1,0,0,0,1850,1852,3,164,82,0,1851,1850,1,0,0,0,1851,1852,1,0,0,0,
  	1852,1853,1,0,0,0,1853,1854,5,636,0,0,1854,1855,3,1074,537,0,1855,1856,
  	3,70,35,0,1856,69,1,0,0,0,1857,1859,3,1044,522,0,1858,1857,1,0,0,0,1858,
  	1859,1,0,0,0,1859,1860,1,0,0,0,1860,1861,5,17,0,0,1861,1862,3,72,36,0,
  	1862,71,1,0,0,0,1863,1865,3,90,45,0,1864,1866,3,74,37,0,1865,1864,1,0,
  	0,0,1865,1866,1,0,0,0,1866,73,1,0,0,0,1867,1869,5,645,0,0,1868,1870,7,
  	7,0,0,1869,1868,1,0,0,0,1869,1870,1,0,0,0,1870,1871,1,0,0,0,1871,1872,
  	5,62,0,0,1872,1873,5,391,0,0,1873,75,1,0,0,0,1874,1893,5,97,0,0,1875,
  	1894,3,78,39,0,1876,1894,3,82,41,0,1877,1894,3,96,48,0,1878,1894,3,94,
  	47,0,1879,1894,3,98,49,0,1880,1894,3,112,56,0,1881,1894,3,158,79,0,1882,
  	1894,3,166,83,0,1883,1894,3,106,53,0,1884,1894,3,118,59,0,1885,1894,3,
  	124,62,0,1886,1894,3,170,85,0,1887,1888,4,38,26,0,1888,1894,3,172,86,
  	0,1889,1890,4,38,27,0,1890,1894,3,174,87,0,1891,1892,4,38,28,0,1892,1894,
  	3,126,63,0,1893,1875,1,0,0,0,1893,1876,1,0,0,0,1893,1877,1,0,0,0,1893,
  	1878,1,0,0,0,1893,1879,1,0,0,0,1893,1880,1,0,0,0,1893,1881,1,0,0,0,1893,
  	1882,1,0,0,0,1893,1883,1,0,0,0,1893,1884,1,0,0,0,1893,1885,1,0,0,0,1893,
  	1886,1,0,0,0,1893,1887,1,0,0,0,1893,1889,1,0,0,0,1893,1891,1,0,0,0,1894,
  	77,1,0,0,0,1895,1897,5,109,0,0,1896,1898,3,980,490,0,1897,1896,1,0,0,
  	0,1897,1898,1,0,0,0,1898,1899,1,0,0,0,1899,1903,3,1056,528,0,1900,1902,
  	3,80,40,0,1901,1900,1,0,0,0,1902,1905,1,0,0,0,1903,1901,1,0,0,0,1903,
  	1904,1,0,0,0,1904,79,1,0,0,0,1905,1903,1,0,0,0,1906,1911,3,952,476,0,
  	1907,1911,3,948,474,0,1908,1909,4,40,29,0,1909,1911,3,950,475,0,1910,
  	1906,1,0,0,0,1910,1907,1,0,0,0,1910,1908,1,0,0,0,1911,81,1,0,0,0,1912,
  	1914,5,577,0,0,1913,1912,1,0,0,0,1913,1914,1,0,0,0,1914,1915,1,0,0,0,
  	1915,1917,5,574,0,0,1916,1918,3,980,490,0,1917,1916,1,0,0,0,1917,1918,
  	1,0,0,0,1918,1919,1,0,0,0,1919,1942,3,1096,548,0,1920,1921,5,776,0,0,
  	1921,1922,3,84,42,0,1922,1923,5,777,0,0,1923,1925,1,0,0,0,1924,1920,1,
  	0,0,0,1924,1925,1,0,0,0,1925,1927,1,0,0,0,1926,1928,3,940,470,0,1927,
  	1926,1,0,0,0,1927,1928,1,0,0,0,1928,1930,1,0,0,0,1929,1931,3,954,477,
  	0,1930,1929,1,0,0,0,1930,1931,1,0,0,0,1931,1933,1,0,0,0,1932,1934,3,88,
  	44,0,1933,1932,1,0,0,0,1933,1934,1,0,0,0,1934,1943,1,0,0,0,1935,1936,
  	5,275,0,0,1936,1943,3,1102,551,0,1937,1938,5,776,0,0,1938,1939,5,275,
  	0,0,1939,1940,3,1102,551,0,1940,1941,5,777,0,0,1941,1943,1,0,0,0,1942,
  	1924,1,0,0,0,1942,1935,1,0,0,0,1942,1937,1,0,0,0,1943,83,1,0,0,0,1944,
  	1949,3,86,43,0,1945,1946,5,773,0,0,1946,1948,3,86,43,0,1947,1945,1,0,
  	0,0,1948,1951,1,0,0,0,1949,1947,1,0,0,0,1949,1950,1,0,0,0,1950,85,1,0,
  	0,0,1951,1949,1,0,0,0,1952,1955,3,864,432,0,1953,1955,3,872,436,0,1954,
  	1952,1,0,0,0,1954,1953,1,0,0,0,1955,87,1,0,0,0,1956,1958,7,8,0,0,1957,
  	1956,1,0,0,0,1957,1958,1,0,0,0,1958,1960,1,0,0,0,1959,1961,5,17,0,0,1960,
  	1959,1,0,0,0,1960,1961,1,0,0,0,1961,1962,1,0,0,0,1962,1963,3,90,45,0,
  	1963,89,1,0,0,0,1964,1967,3,270,135,0,1965,1967,3,274,137,0,1966,1964,
  	1,0,0,0,1966,1965,1,0,0,0,1967,91,1,0,0,0,1968,1972,5,97,0,0,1969,1973,
  	3,94,47,0,1970,1973,3,96,48,0,1971,1973,3,98,49,0,1972,1969,1,0,0,0,1972,
  	1970,1,0,0,0,1972,1971,1,0,0,0,1973,1975,1,0,0,0,1974,1976,5,774,0,0,
  	1975,1974,1,0,0,0,1975,1976,1,0,0,0,1976,1977,1,0,0,0,1977,1978,5,0,0,
  	1,1978,93,1,0,0,0,1979,1981,3,976,488,0,1980,1979,1,0,0,0,1980,1981,1,
  	0,0,0,1981,1982,1,0,0,0,1982,1983,5,422,0,0,1983,1984,3,1060,530,0,1984,
  	1993,5,776,0,0,1985,1990,3,982,491,0,1986,1987,5,773,0,0,1987,1989,3,
  	982,491,0,1988,1986,1,0,0,0,1989,1992,1,0,0,0,1990,1988,1,0,0,0,1990,
  	1991,1,0,0,0,1991,1994,1,0,0,0,1992,1990,1,0,0,0,1993,1985,1,0,0,0,1993,
  	1994,1,0,0,0,1994,1995,1,0,0,0,1995,1999,5,777,0,0,1996,1998,3,100,50,
  	0,1997,1996,1,0,0,0,1998,2001,1,0,0,0,1999,1997,1,0,0,0,1999,2000,1,0,
  	0,0,2000,2002,1,0,0,0,2001,1999,1,0,0,0,2002,2003,3,784,392,0,2003,95,
  	1,0,0,0,2004,2006,3,976,488,0,2005,2004,1,0,0,0,2005,2006,1,0,0,0,2006,
  	2007,1,0,0,0,2007,2008,5,206,0,0,2008,2009,3,1064,532,0,2009,2018,5,776,
  	0,0,2010,2015,3,984,492,0,2011,2012,5,773,0,0,2012,2014,3,984,492,0,2013,
  	2011,1,0,0,0,2014,2017,1,0,0,0,2015,2013,1,0,0,0,2015,2016,1,0,0,0,2016,
  	2019,1,0,0,0,2017,2015,1,0,0,0,2018,2010,1,0,0,0,2018,2019,1,0,0,0,2019,
  	2020,1,0,0,0,2020,2021,5,777,0,0,2021,2022,5,474,0,0,2022,2026,3,988,
  	494,0,2023,2025,3,100,50,0,2024,2023,1,0,0,0,2025,2028,1,0,0,0,2026,2024,
  	1,0,0,0,2026,2027,1,0,0,0,2027,2029,1,0,0,0,2028,2026,1,0,0,0,2029,2030,
  	3,784,392,0,2030,97,1,0,0,0,2031,2033,5,8,0,0,2032,2031,1,0,0,0,2032,
  	2033,1,0,0,0,2033,2034,1,0,0,0,2034,2035,5,206,0,0,2035,2036,3,1088,544,
  	0,2036,2037,5,474,0,0,2037,2038,7,9,0,0,2038,2039,5,520,0,0,2039,2040,
  	3,1160,580,0,2040,99,1,0,0,0,2041,2047,3,104,52,0,2042,2044,5,371,0,0,
  	2043,2042,1,0,0,0,2043,2044,1,0,0,0,2044,2045,1,0,0,0,2045,2047,5,137,
  	0,0,2046,2041,1,0,0,0,2046,2043,1,0,0,0,2047,101,1,0,0,0,2048,2050,3,
  	100,50,0,2049,2048,1,0,0,0,2050,2051,1,0,0,0,2051,2049,1,0,0,0,2051,2052,
  	1,0,0,0,2052,103,1,0,0,0,2053,2054,5,75,0,0,2054,2071,3,1160,580,0,2055,
  	2056,5,267,0,0,2056,2071,5,537,0,0,2057,2058,5,373,0,0,2058,2071,5,537,
  	0,0,2059,2060,5,90,0,0,2060,2071,5,537,0,0,2061,2062,5,433,0,0,2062,2063,
  	5,537,0,0,2063,2071,5,112,0,0,2064,2065,5,347,0,0,2065,2066,5,537,0,0,
  	2066,2071,5,112,0,0,2067,2068,5,537,0,0,2068,2069,5,496,0,0,2069,2071,
  	7,10,0,0,2070,2053,1,0,0,0,2070,2055,1,0,0,0,2070,2057,1,0,0,0,2070,2059,
  	1,0,0,0,2070,2061,1,0,0,0,2070,2064,1,0,0,0,2070,2067,1,0,0,0,2071,105,
  	1,0,0,0,2072,2074,3,1032,516,0,2073,2072,1,0,0,0,2073,2074,1,0,0,0,2074,
  	2116,1,0,0,0,2075,2077,5,609,0,0,2076,2075,1,0,0,0,2076,2077,1,0,0,0,
  	2077,2078,1,0,0,0,2078,2087,5,236,0,0,2079,2080,4,53,30,0,2080,2082,3,
  	1050,525,0,2081,2083,3,908,454,0,2082,2081,1,0,0,0,2082,2083,1,0,0,0,
  	2083,2088,1,0,0,0,2084,2086,3,108,54,0,2085,2084,1,0,0,0,2085,2086,1,
  	0,0,0,2086,2088,1,0,0,0,2087,2079,1,0,0,0,2087,2085,1,0,0,0,2088,2089,
  	1,0,0,0,2089,2093,3,110,55,0,2090,2092,3,902,451,0,2091,2090,1,0,0,0,
  	2092,2095,1,0,0,0,2093,2091,1,0,0,0,2093,2094,1,0,0,0,2094,2117,1,0,0,
  	0,2095,2093,1,0,0,0,2096,2097,5,205,0,0,2097,2098,5,236,0,0,2098,2099,
  	3,1050,525,0,2099,2103,3,110,55,0,2100,2102,3,910,455,0,2101,2100,1,0,
  	0,0,2102,2105,1,0,0,0,2103,2101,1,0,0,0,2103,2104,1,0,0,0,2104,2117,1,
  	0,0,0,2105,2103,1,0,0,0,2106,2107,5,523,0,0,2107,2108,5,236,0,0,2108,
  	2109,3,1050,525,0,2109,2113,3,110,55,0,2110,2112,3,912,456,0,2111,2110,
  	1,0,0,0,2112,2115,1,0,0,0,2113,2111,1,0,0,0,2113,2114,1,0,0,0,2114,2117,
  	1,0,0,0,2115,2113,1,0,0,0,2116,2076,1,0,0,0,2116,2096,1,0,0,0,2116,2106,
  	1,0,0,0,2117,2119,1,0,0,0,2118,2120,3,46,23,0,2119,2118,1,0,0,0,2119,
  	2120,1,0,0,0,2120,107,1,0,0,0,2121,2124,3,1050,525,0,2122,2123,5,621,
  	0,0,2123,2125,3,900,450,0,2124,2122,1,0,0,0,2124,2125,1,0,0,0,2125,2131,
  	1,0,0,0,2126,2127,3,1050,525,0,2127,2128,5,599,0,0,2128,2129,3,900,450,
  	0,2129,2131,1,0,0,0,2130,2121,1,0,0,0,2130,2126,1,0,0,0,2131,109,1,0,
  	0,0,2132,2133,5,383,0,0,2133,2134,3,1102,551,0,2134,2135,3,898,449,0,
  	2135,111,1,0,0,0,2136,2137,5,288,0,0,2137,2138,5,217,0,0,2138,2139,3,
  	1080,540,0,2139,2140,5,4,0,0,2140,2141,7,11,0,0,2141,2143,3,1160,580,
  	0,2142,2144,3,114,57,0,2143,2142,1,0,0,0,2143,2144,1,0,0,0,2144,113,1,
  	0,0,0,2145,2152,3,116,58,0,2146,2148,5,773,0,0,2147,2146,1,0,0,0,2147,
  	2148,1,0,0,0,2148,2149,1,0,0,0,2149,2151,3,116,58,0,2150,2147,1,0,0,0,
  	2151,2154,1,0,0,0,2152,2150,1,0,0,0,2152,2153,1,0,0,0,2153,115,1,0,0,
  	0,2154,2152,1,0,0,0,2155,2162,3,136,68,0,2156,2162,3,138,69,0,2157,2162,
  	3,146,73,0,2158,2162,3,148,74,0,2159,2162,3,150,75,0,2160,2162,3,152,
  	76,0,2161,2155,1,0,0,0,2161,2156,1,0,0,0,2161,2157,1,0,0,0,2161,2158,
  	1,0,0,0,2161,2159,1,0,0,0,2161,2160,1,0,0,0,2162,117,1,0,0,0,2163,2164,
  	5,503,0,0,2164,2165,3,1090,545,0,2165,2166,5,199,0,0,2166,2167,5,112,
  	0,0,2167,2168,5,648,0,0,2168,2169,3,1180,590,0,2169,2170,3,120,60,0,2170,
  	119,1,0,0,0,2171,2172,5,390,0,0,2172,2173,5,776,0,0,2173,2178,3,122,61,
  	0,2174,2175,5,773,0,0,2175,2177,3,122,61,0,2176,2174,1,0,0,0,2177,2180,
  	1,0,0,0,2178,2176,1,0,0,0,2178,2179,1,0,0,0,2179,2181,1,0,0,0,2180,2178,
  	1,0,0,0,2181,2182,5,777,0,0,2182,121,1,0,0,0,2183,2184,5,224,0,0,2184,
  	2198,3,1160,580,0,2185,2186,5,109,0,0,2186,2198,3,1160,580,0,2187,2188,
  	5,618,0,0,2188,2198,3,1160,580,0,2189,2190,5,406,0,0,2190,2198,3,1160,
  	580,0,2191,2192,5,519,0,0,2192,2198,3,1160,580,0,2193,2194,5,398,0,0,
  	2194,2198,3,1160,580,0,2195,2196,5,413,0,0,2196,2198,3,1140,570,0,2197,
  	2183,1,0,0,0,2197,2185,1,0,0,0,2197,2187,1,0,0,0,2197,2189,1,0,0,0,2197,
  	2191,1,0,0,0,2197,2193,1,0,0,0,2197,2195,1,0,0,0,2198,123,1,0,0,0,2199,
  	2200,5,572,0,0,2200,2201,3,1076,538,0,2201,2206,3,128,64,0,2202,2203,
  	5,620,0,0,2203,2204,5,288,0,0,2204,2205,5,217,0,0,2205,2207,3,1082,541,
  	0,2206,2202,1,0,0,0,2206,2207,1,0,0,0,2207,2209,1,0,0,0,2208,2210,3,132,
  	66,0,2209,2208,1,0,0,0,2209,2210,1,0,0,0,2210,125,1,0,0,0,2211,2212,5,
  	605,0,0,2212,2213,5,572,0,0,2213,2214,3,1076,538,0,2214,2215,5,4,0,0,
  	2215,2217,3,130,65,0,2216,2218,3,58,29,0,2217,2216,1,0,0,0,2217,2218,
  	1,0,0,0,2218,127,1,0,0,0,2219,2222,4,64,31,0,2220,2221,5,4,0,0,2221,2223,
  	3,130,65,0,2222,2220,1,0,0,0,2222,2223,1,0,0,0,2223,2227,1,0,0,0,2224,
  	2225,5,4,0,0,2225,2227,3,130,65,0,2226,2219,1,0,0,0,2226,2224,1,0,0,0,
  	2227,129,1,0,0,0,2228,2229,5,111,0,0,2229,2230,3,1160,580,0,2230,131,
  	1,0,0,0,2231,2238,3,134,67,0,2232,2234,5,773,0,0,2233,2232,1,0,0,0,2233,
  	2234,1,0,0,0,2234,2235,1,0,0,0,2235,2237,3,134,67,0,2236,2233,1,0,0,0,
  	2237,2240,1,0,0,0,2238,2236,1,0,0,0,2238,2239,1,0,0,0,2239,133,1,0,0,
  	0,2240,2238,1,0,0,0,2241,2254,3,136,68,0,2242,2254,3,140,70,0,2243,2254,
  	3,142,71,0,2244,2254,3,144,72,0,2245,2254,3,146,73,0,2246,2254,3,148,
  	74,0,2247,2254,3,150,75,0,2248,2254,3,152,76,0,2249,2250,4,67,32,0,2250,
  	2254,3,154,77,0,2251,2252,4,67,33,0,2252,2254,3,156,78,0,2253,2241,1,
  	0,0,0,2253,2242,1,0,0,0,2253,2243,1,0,0,0,2253,2244,1,0,0,0,2253,2245,
  	1,0,0,0,2253,2246,1,0,0,0,2253,2247,1,0,0,0,2253,2248,1,0,0,0,2253,2249,
  	1,0,0,0,2253,2251,1,0,0,0,2254,135,1,0,0,0,2255,2257,5,238,0,0,2256,2258,
  	5,750,0,0,2257,2256,1,0,0,0,2257,2258,1,0,0,0,2258,2259,1,0,0,0,2259,
  	2260,3,1186,593,0,2260,137,1,0,0,0,2261,2263,7,12,0,0,2262,2264,5,750,
  	0,0,2263,2262,1,0,0,0,2263,2264,1,0,0,0,2264,2265,1,0,0,0,2265,2266,3,
  	1186,593,0,2266,139,1,0,0,0,2267,2269,5,23,0,0,2268,2270,5,750,0,0,2269,
  	2268,1,0,0,0,2269,2270,1,0,0,0,2270,2271,1,0,0,0,2271,2272,3,1186,593,
  	0,2272,141,1,0,0,0,2273,2275,5,324,0,0,2274,2276,5,750,0,0,2275,2274,
  	1,0,0,0,2275,2276,1,0,0,0,2276,2277,1,0,0,0,2277,2278,3,1186,593,0,2278,
  	143,1,0,0,0,2279,2281,5,181,0,0,2280,2282,5,750,0,0,2281,2280,1,0,0,0,
  	2281,2282,1,0,0,0,2282,2283,1,0,0,0,2283,2284,3,1186,593,0,2284,145,1,
  	0,0,0,2285,2287,5,368,0,0,2286,2288,5,750,0,0,2287,2286,1,0,0,0,2287,
  	2288,1,0,0,0,2288,2289,1,0,0,0,2289,2290,3,1142,571,0,2290,147,1,0,0,
  	0,2291,2293,5,553,0,0,2292,2291,1,0,0,0,2292,2293,1,0,0,0,2293,2294,1,
  	0,0,0,2294,2296,5,163,0,0,2295,2297,5,750,0,0,2296,2295,1,0,0,0,2296,
  	2297,1,0,0,0,2297,2298,1,0,0,0,2298,2299,3,1094,547,0,2299,149,1,0,0,
  	0,2300,2301,7,13,0,0,2301,151,1,0,0,0,2302,2304,5,75,0,0,2303,2305,5,
  	750,0,0,2304,2303,1,0,0,0,2304,2305,1,0,0,0,2305,2306,1,0,0,0,2306,2307,
  	3,1160,580,0,2307,153,1,0,0,0,2308,2310,5,189,0,0,2309,2311,5,750,0,0,
  	2310,2309,1,0,0,0,2310,2311,1,0,0,0,2311,2312,1,0,0,0,2312,2313,3,1186,
  	593,0,2313,155,1,0,0,0,2314,2316,5,158,0,0,2315,2317,5,750,0,0,2316,2315,
  	1,0,0,0,2316,2317,1,0,0,0,2317,2318,1,0,0,0,2318,2319,3,1154,577,0,2319,
  	157,1,0,0,0,2320,2322,3,160,80,0,2321,2320,1,0,0,0,2321,2322,1,0,0,0,
  	2322,2324,1,0,0,0,2323,2325,3,976,488,0,2324,2323,1,0,0,0,2324,2325,1,
  	0,0,0,2325,2327,1,0,0,0,2326,2328,3,164,82,0,2327,2326,1,0,0,0,2327,2328,
  	1,0,0,0,2328,2329,1,0,0,0,2329,2330,5,636,0,0,2330,2331,3,1072,536,0,
  	2331,2332,3,70,35,0,2332,159,1,0,0,0,2333,2334,5,394,0,0,2334,2336,5,
  	458,0,0,2335,2337,3,162,81,0,2336,2335,1,0,0,0,2336,2337,1,0,0,0,2337,
  	2340,1,0,0,0,2338,2340,3,162,81,0,2339,2333,1,0,0,0,2339,2338,1,0,0,0,
  	2340,161,1,0,0,0,2341,2342,5,9,0,0,2342,2343,5,750,0,0,2343,2344,7,14,
  	0,0,2344,163,1,0,0,0,2345,2346,5,537,0,0,2346,2347,5,496,0,0,2347,2348,
  	7,10,0,0,2348,165,1,0,0,0,2349,2351,3,976,488,0,2350,2349,1,0,0,0,2350,
  	2351,1,0,0,0,2351,2352,1,0,0,0,2352,2353,5,594,0,0,2353,2354,3,1068,534,
  	0,2354,2355,7,15,0,0,2355,2356,7,16,0,0,2356,2357,5,383,0,0,2357,2358,
  	3,1102,551,0,2358,2359,5,200,0,0,2359,2360,5,153,0,0,2360,2362,5,487,
  	0,0,2361,2363,3,168,84,0,2362,2361,1,0,0,0,2362,2363,1,0,0,0,2363,2364,
  	1,0,0,0,2364,2365,3,784,392,0,2365,167,1,0,0,0,2366,2367,4,84,34,0,2367,
  	2368,7,17,0,0,2368,2369,3,1180,590,0,2369,169,1,0,0,0,2370,2372,3,976,
  	488,0,2371,2370,1,0,0,0,2371,2372,1,0,0,0,2372,2373,1,0,0,0,2373,2375,
  	5,170,0,0,2374,2376,3,980,490,0,2375,2374,1,0,0,0,2375,2376,1,0,0,0,2376,
  	2377,1,0,0,0,2377,2378,3,1084,542,0,2378,2379,5,383,0,0,2379,2380,5,490,
  	0,0,2380,2387,3,862,431,0,2381,2382,5,383,0,0,2382,2384,5,79,0,0,2383,
  	2385,5,371,0,0,2384,2383,1,0,0,0,2384,2385,1,0,0,0,2385,2386,1,0,0,0,
  	2386,2388,5,418,0,0,2387,2381,1,0,0,0,2387,2388,1,0,0,0,2388,2395,1,0,
  	0,0,2389,2396,5,156,0,0,2390,2393,5,140,0,0,2391,2392,5,383,0,0,2392,
  	2394,5,514,0,0,2393,2391,1,0,0,0,2393,2394,1,0,0,0,2394,2396,1,0,0,0,
  	2395,2389,1,0,0,0,2395,2390,1,0,0,0,2395,2396,1,0,0,0,2396,2399,1,0,0,
  	0,2397,2398,5,75,0,0,2398,2400,3,1160,580,0,2399,2397,1,0,0,0,2399,2400,
  	1,0,0,0,2400,2401,1,0,0,0,2401,2402,5,147,0,0,2402,2403,3,784,392,0,2403,
  	171,1,0,0,0,2404,2406,5,659,0,0,2405,2407,3,980,490,0,2406,2405,1,0,0,
  	0,2406,2407,1,0,0,0,2407,2408,1,0,0,0,2408,2409,3,560,280,0,2409,173,
  	1,0,0,0,2410,2411,5,394,0,0,2411,2412,5,458,0,0,2412,2413,5,523,0,0,2413,
  	2414,5,718,0,0,2414,2415,5,710,0,0,2415,2419,3,1146,573,0,2416,2418,3,
  	176,88,0,2417,2416,1,0,0,0,2418,2421,1,0,0,0,2419,2417,1,0,0,0,2419,2420,
  	1,0,0,0,2420,2436,1,0,0,0,2421,2419,1,0,0,0,2422,2423,5,523,0,0,2423,
  	2424,5,718,0,0,2424,2426,5,710,0,0,2425,2427,3,980,490,0,2426,2425,1,
  	0,0,0,2426,2427,1,0,0,0,2427,2428,1,0,0,0,2428,2432,3,1146,573,0,2429,
  	2431,3,176,88,0,2430,2429,1,0,0,0,2431,2434,1,0,0,0,2432,2430,1,0,0,0,
  	2432,2433,1,0,0,0,2433,2436,1,0,0,0,2434,2432,1,0,0,0,2435,2410,1,0,0,
  	0,2435,2422,1,0,0,0,2436,175,1,0,0,0,2437,2438,5,357,0,0,2438,2439,5,
  	580,0,0,2439,2453,3,1162,581,0,2440,2441,5,715,0,0,2441,2442,5,580,0,
  	0,2442,2453,3,1162,581,0,2443,2444,5,717,0,0,2444,2445,3,1162,581,0,2445,
  	2446,5,230,0,0,2446,2447,5,45,0,0,2447,2448,3,1146,573,0,2448,2453,1,
  	0,0,0,2449,2450,5,716,0,0,2450,2451,5,580,0,0,2451,2453,3,1162,581,0,
  	2452,2437,1,0,0,0,2452,2440,1,0,0,0,2452,2443,1,0,0,0,2452,2449,1,0,0,
  	0,2453,177,1,0,0,0,2454,2472,5,148,0,0,2455,2473,3,180,90,0,2456,2473,
  	3,182,91,0,2457,2473,3,184,92,0,2458,2473,3,186,93,0,2459,2473,3,188,
  	94,0,2460,2473,3,190,95,0,2461,2473,3,194,97,0,2462,2473,3,196,98,0,2463,
  	2473,3,198,99,0,2464,2473,3,200,100,0,2465,2473,3,202,101,0,2466,2467,
  	4,89,35,0,2467,2473,3,204,102,0,2468,2469,4,89,36,0,2469,2473,3,206,103,
  	0,2470,2471,4,89,37,0,2471,2473,3,208,104,0,2472,2455,1,0,0,0,2472,2456,
  	1,0,0,0,2472,2457,1,0,0,0,2472,2458,1,0,0,0,2472,2459,1,0,0,0,2472,2460,
  	1,0,0,0,2472,2461,1,0,0,0,2472,2462,1,0,0,0,2472,2463,1,0,0,0,2472,2464,
  	1,0,0,0,2472,2465,1,0,0,0,2472,2466,1,0,0,0,2472,2468,1,0,0,0,2472,2470,
  	1,0,0,0,2473,179,1,0,0,0,2474,2476,5,109,0,0,2475,2477,3,978,489,0,2476,
  	2475,1,0,0,0,2476,2477,1,0,0,0,2477,2478,1,0,0,0,2478,2479,3,1058,529,
  	0,2479,181,1,0,0,0,2480,2482,5,170,0,0,2481,2483,3,978,489,0,2482,2481,
  	1,0,0,0,2482,2483,1,0,0,0,2483,2484,1,0,0,0,2484,2485,3,1086,543,0,2485,
  	183,1,0,0,0,2486,2488,5,206,0,0,2487,2489,3,978,489,0,2488,2487,1,0,0,
  	0,2488,2489,1,0,0,0,2489,2490,1,0,0,0,2490,2491,3,1066,533,0,2491,185,
  	1,0,0,0,2492,2494,5,422,0,0,2493,2495,3,978,489,0,2494,2493,1,0,0,0,2494,
  	2495,1,0,0,0,2495,2496,1,0,0,0,2496,2497,3,1062,531,0,2497,187,1,0,0,
  	0,2498,2500,3,1032,516,0,2499,2498,1,0,0,0,2499,2500,1,0,0,0,2500,2501,
  	1,0,0,0,2501,2502,5,236,0,0,2502,2503,3,1052,526,0,2503,2504,5,383,0,
  	0,2504,2506,3,1102,551,0,2505,2507,3,46,23,0,2506,2505,1,0,0,0,2506,2507,
  	1,0,0,0,2507,189,1,0,0,0,2508,2509,5,288,0,0,2509,2510,5,217,0,0,2510,
  	2521,3,1082,541,0,2511,2518,3,192,96,0,2512,2514,5,773,0,0,2513,2512,
  	1,0,0,0,2513,2514,1,0,0,0,2514,2515,1,0,0,0,2515,2517,3,192,96,0,2516,
  	2513,1,0,0,0,2517,2520,1,0,0,0,2518,2516,1,0,0,0,2518,2519,1,0,0,0,2519,
  	2522,1,0,0,0,2520,2518,1,0,0,0,2521,2511,1,0,0,0,2521,2522,1,0,0,0,2522,
  	191,1,0,0,0,2523,2526,3,150,75,0,2524,2526,3,148,74,0,2525,2523,1,0,0,
  	0,2525,2524,1,0,0,0,2526,193,1,0,0,0,2527,2529,5,503,0,0,2528,2530,3,
  	978,489,0,2529,2528,1,0,0,0,2529,2530,1,0,0,0,2530,2531,1,0,0,0,2531,
  	2532,3,1092,546,0,2532,195,1,0,0,0,2533,2535,5,577,0,0,2534,2533,1,0,
  	0,0,2534,2535,1,0,0,0,2535,2536,1,0,0,0,2536,2538,7,18,0,0,2537,2539,
  	3,978,489,0,2538,2537,1,0,0,0,2538,2539,1,0,0,0,2539,2540,1,0,0,0,2540,
  	2542,3,1104,552,0,2541,2543,7,2,0,0,2542,2541,1,0,0,0,2542,2543,1,0,0,
  	0,2543,197,1,0,0,0,2544,2545,5,572,0,0,2545,2556,3,1078,539,0,2546,2553,
  	3,192,96,0,2547,2549,5,773,0,0,2548,2547,1,0,0,0,2548,2549,1,0,0,0,2549,
  	2550,1,0,0,0,2550,2552,3,192,96,0,2551,2548,1,0,0,0,2552,2555,1,0,0,0,
  	2553,2551,1,0,0,0,2553,2554,1,0,0,0,2554,2557,1,0,0,0,2555,2553,1,0,0,
  	0,2556,2546,1,0,0,0,2556,2557,1,0,0,0,2557,199,1,0,0,0,2558,2560,5,594,
  	0,0,2559,2561,3,978,489,0,2560,2559,1,0,0,0,2560,2561,1,0,0,0,2561,2562,
  	1,0,0,0,2562,2563,3,1070,535,0,2563,201,1,0,0,0,2564,2566,5,636,0,0,2565,
  	2567,3,978,489,0,2566,2565,1,0,0,0,2566,2567,1,0,0,0,2567,2568,1,0,0,
  	0,2568,2570,3,992,496,0,2569,2571,7,2,0,0,2570,2569,1,0,0,0,2570,2571,
  	1,0,0,0,2571,203,1,0,0,0,2572,2574,5,659,0,0,2573,2575,3,978,489,0,2574,
  	2573,1,0,0,0,2574,2575,1,0,0,0,2575,2576,1,0,0,0,2576,2577,3,560,280,
  	0,2577,205,1,0,0,0,2578,2579,5,523,0,0,2579,2580,5,718,0,0,2580,2582,
  	5,710,0,0,2581,2583,3,978,489,0,2582,2581,1,0,0,0,2582,2583,1,0,0,0,2583,
  	2584,1,0,0,0,2584,2585,3,1146,573,0,2585,207,1,0,0,0,2586,2587,5,605,
  	0,0,2587,2588,5,572,0,0,2588,2590,3,1078,539,0,2589,2591,3,58,29,0,2590,
  	2589,1,0,0,0,2590,2591,1,0,0,0,2591,209,1,0,0,0,2592,2593,5,453,0,0,2593,
  	2594,7,18,0,0,2594,2599,3,212,106,0,2595,2596,5,773,0,0,2596,2598,3,212,
  	106,0,2597,2595,1,0,0,0,2598,2601,1,0,0,0,2599,2597,1,0,0,0,2599,2600,
  	1,0,0,0,2600,211,1,0,0,0,2601,2599,1,0,0,0,2602,2603,3,1102,551,0,2603,
  	2604,5,590,0,0,2604,2605,3,1096,548,0,2605,213,1,0,0,0,2606,2608,5,597,
  	0,0,2607,2609,5,574,0,0,2608,2607,1,0,0,0,2608,2609,1,0,0,0,2609,2610,
  	1,0,0,0,2610,2611,3,1102,551,0,2611,215,1,0,0,0,2612,2613,5,234,0,0,2613,
  	2614,5,574,0,0,2614,2615,5,203,0,0,2615,2616,3,1164,582,0,2616,217,1,
  	0,0,0,2617,2618,5,48,0,0,2618,2624,3,1062,531,0,2619,2621,5,776,0,0,2620,
  	2622,3,756,378,0,2621,2620,1,0,0,0,2621,2622,1,0,0,0,2622,2623,1,0,0,
  	0,2623,2625,5,777,0,0,2624,2619,1,0,0,0,2624,2625,1,0,0,0,2625,219,1,
  	0,0,0,2626,2627,4,110,38,0,2627,2629,3,320,160,0,2628,2626,1,0,0,0,2628,
  	2629,1,0,0,0,2629,2630,1,0,0,0,2630,2634,5,133,0,0,2631,2633,3,224,112,
  	0,2632,2631,1,0,0,0,2633,2636,1,0,0,0,2634,2632,1,0,0,0,2634,2635,1,0,
  	0,0,2635,2669,1,0,0,0,2636,2634,1,0,0,0,2637,2661,5,203,0,0,2638,2639,
  	3,1106,553,0,2639,2640,5,621,0,0,2640,2642,3,334,167,0,2641,2643,3,358,
  	179,0,2642,2641,1,0,0,0,2642,2643,1,0,0,0,2643,2662,1,0,0,0,2644,2647,
  	3,1102,551,0,2645,2646,4,110,39,0,2646,2648,3,398,199,0,2647,2645,1,0,
  	0,0,2647,2648,1,0,0,0,2648,2650,1,0,0,0,2649,2651,3,222,111,0,2650,2649,
  	1,0,0,0,2650,2651,1,0,0,0,2651,2653,1,0,0,0,2652,2654,3,358,179,0,2653,
  	2652,1,0,0,0,2653,2654,1,0,0,0,2654,2656,1,0,0,0,2655,2657,3,328,164,
  	0,2656,2655,1,0,0,0,2656,2657,1,0,0,0,2657,2659,1,0,0,0,2658,2660,3,286,
  	143,0,2659,2658,1,0,0,0,2659,2660,1,0,0,0,2660,2662,1,0,0,0,2661,2638,
  	1,0,0,0,2661,2644,1,0,0,0,2662,2670,1,0,0,0,2663,2664,3,1106,553,0,2664,
  	2665,5,203,0,0,2665,2667,3,334,167,0,2666,2668,3,358,179,0,2667,2666,
  	1,0,0,0,2667,2668,1,0,0,0,2668,2670,1,0,0,0,2669,2637,1,0,0,0,2669,2663,
  	1,0,0,0,2670,221,1,0,0,0,2671,2672,4,111,40,0,2672,2673,5,405,0,0,2673,
  	2674,5,776,0,0,2674,2675,3,1130,565,0,2675,2676,5,777,0,0,2676,223,1,
  	0,0,0,2677,2678,7,19,0,0,2678,225,1,0,0,0,2679,2684,5,147,0,0,2680,2681,
  	4,113,41,0,2681,2685,3,756,378,0,2682,2683,4,113,42,0,2683,2685,3,352,
  	176,0,2684,2680,1,0,0,0,2684,2682,1,0,0,0,2685,227,1,0,0,0,2686,2704,
  	5,219,0,0,2687,2688,3,1102,551,0,2688,2690,5,387,0,0,2689,2691,3,398,
  	199,0,2690,2689,1,0,0,0,2690,2691,1,0,0,0,2691,2705,1,0,0,0,2692,2702,
  	3,1128,564,0,2693,2703,5,66,0,0,2694,2695,5,435,0,0,2695,2697,3,230,115,
  	0,2696,2698,3,358,179,0,2697,2696,1,0,0,0,2697,2698,1,0,0,0,2698,2700,
  	1,0,0,0,2699,2701,3,284,142,0,2700,2699,1,0,0,0,2700,2701,1,0,0,0,2701,
  	2703,1,0,0,0,2702,2693,1,0,0,0,2702,2694,1,0,0,0,2703,2705,1,0,0,0,2704,
  	2687,1,0,0,0,2704,2692,1,0,0,0,2705,229,1,0,0,0,2706,2717,7,20,0,0,2707,
  	2714,3,1128,564,0,2708,2715,7,21,0,0,2709,2710,7,22,0,0,2710,2711,5,776,
  	0,0,2711,2712,3,246,123,0,2712,2713,5,777,0,0,2713,2715,1,0,0,0,2714,
  	2708,1,0,0,0,2714,2709,1,0,0,0,2715,2717,1,0,0,0,2716,2706,1,0,0,0,2716,
  	2707,1,0,0,0,2717,231,1,0,0,0,2718,2720,5,242,0,0,2719,2721,3,234,117,
  	0,2720,2719,1,0,0,0,2720,2721,1,0,0,0,2721,2723,1,0,0,0,2722,2724,5,232,
  	0,0,2723,2722,1,0,0,0,2723,2724,1,0,0,0,2724,2726,1,0,0,0,2725,2727,5,
  	248,0,0,2726,2725,1,0,0,0,2726,2727,1,0,0,0,2727,2728,1,0,0,0,2728,2730,
  	3,1102,551,0,2729,2731,3,1036,518,0,2730,2729,1,0,0,0,2730,2731,1,0,0,
  	0,2731,2744,1,0,0,0,2732,2735,3,236,118,0,2733,2734,4,116,43,0,2734,2736,
  	3,248,124,0,2735,2733,1,0,0,0,2735,2736,1,0,0,0,2736,2745,1,0,0,0,2737,
  	2738,5,506,0,0,2738,2741,3,994,497,0,2739,2740,4,116,44,0,2740,2742,3,
  	248,124,0,2741,2739,1,0,0,0,2741,2742,1,0,0,0,2742,2745,1,0,0,0,2743,
  	2745,3,242,121,0,2744,2732,1,0,0,0,2744,2737,1,0,0,0,2744,2743,1,0,0,
  	0,2745,2747,1,0,0,0,2746,2748,3,250,125,0,2747,2746,1,0,0,0,2747,2748,
  	1,0,0,0,2748,233,1,0,0,0,2749,2750,7,23,0,0,2750,235,1,0,0,0,2751,2753,
  	5,776,0,0,2752,2754,3,238,119,0,2753,2752,1,0,0,0,2753,2754,1,0,0,0,2754,
  	2755,1,0,0,0,2755,2757,5,777,0,0,2756,2751,1,0,0,0,2756,2757,1,0,0,0,
  	2757,2758,1,0,0,0,2758,2759,3,240,120,0,2759,237,1,0,0,0,2760,2765,3,
  	1048,524,0,2761,2762,5,773,0,0,2762,2764,3,1048,524,0,2763,2761,1,0,0,
  	0,2764,2767,1,0,0,0,2765,2763,1,0,0,0,2765,2766,1,0,0,0,2766,239,1,0,
  	0,0,2767,2765,1,0,0,0,2768,2769,7,24,0,0,2769,2770,3,244,122,0,2770,241,
  	1,0,0,0,2771,2779,3,90,45,0,2772,2774,5,776,0,0,2773,2775,3,238,119,0,
  	2774,2773,1,0,0,0,2774,2775,1,0,0,0,2775,2776,1,0,0,0,2776,2777,5,777,
  	0,0,2777,2779,3,90,45,0,2778,2771,1,0,0,0,2778,2772,1,0,0,0,2779,243,
  	1,0,0,0,2780,2782,5,776,0,0,2781,2783,3,246,123,0,2782,2781,1,0,0,0,2782,
  	2783,1,0,0,0,2783,2784,1,0,0,0,2784,2793,5,777,0,0,2785,2786,5,773,0,
  	0,2786,2788,5,776,0,0,2787,2789,3,246,123,0,2788,2787,1,0,0,0,2788,2789,
  	1,0,0,0,2789,2790,1,0,0,0,2790,2792,5,777,0,0,2791,2785,1,0,0,0,2792,
  	2795,1,0,0,0,2793,2791,1,0,0,0,2793,2794,1,0,0,0,2794,245,1,0,0,0,2795,
  	2793,1,0,0,0,2796,2799,3,676,338,0,2797,2799,5,128,0,0,2798,2796,1,0,
  	0,0,2798,2797,1,0,0,0,2799,2807,1,0,0,0,2800,2803,5,773,0,0,2801,2804,
  	3,676,338,0,2802,2804,5,128,0,0,2803,2801,1,0,0,0,2803,2802,1,0,0,0,2804,
  	2806,1,0,0,0,2805,2800,1,0,0,0,2806,2809,1,0,0,0,2807,2805,1,0,0,0,2807,
  	2808,1,0,0,0,2808,247,1,0,0,0,2809,2807,1,0,0,0,2810,2811,5,17,0,0,2811,
  	2813,3,1128,564,0,2812,2814,3,1044,522,0,2813,2812,1,0,0,0,2813,2814,
  	1,0,0,0,2814,249,1,0,0,0,2815,2816,5,383,0,0,2816,2817,5,151,0,0,2817,
  	2818,5,265,0,0,2818,2819,5,614,0,0,2819,2820,3,994,497,0,2820,251,1,0,
  	0,0,2821,2822,5,281,0,0,2822,2824,3,254,127,0,2823,2825,7,25,0,0,2824,
  	2823,1,0,0,0,2824,2825,1,0,0,0,2825,2827,1,0,0,0,2826,2828,5,284,0,0,
  	2827,2826,1,0,0,0,2827,2828,1,0,0,0,2828,2829,1,0,0,0,2829,2830,5,237,
  	0,0,2830,2832,3,1160,580,0,2831,2833,7,8,0,0,2832,2831,1,0,0,0,2832,2833,
  	1,0,0,0,2833,2834,1,0,0,0,2834,2835,5,248,0,0,2835,2836,5,574,0,0,2836,
  	2838,3,1102,551,0,2837,2839,3,1036,518,0,2838,2837,1,0,0,0,2838,2839,
  	1,0,0,0,2839,2841,1,0,0,0,2840,2842,3,998,499,0,2841,2840,1,0,0,0,2841,
  	2842,1,0,0,0,2842,2844,1,0,0,0,2843,2845,3,256,128,0,2844,2843,1,0,0,
  	0,2844,2845,1,0,0,0,2845,2847,1,0,0,0,2846,2848,3,1000,500,0,2847,2846,
  	1,0,0,0,2847,2848,1,0,0,0,2848,2850,1,0,0,0,2849,2851,3,1004,502,0,2850,
  	2849,1,0,0,0,2850,2851,1,0,0,0,2851,2852,1,0,0,0,2852,2853,3,258,129,
  	0,2853,253,1,0,0,0,2854,2855,7,26,0,0,2855,255,1,0,0,0,2856,2857,5,484,
  	0,0,2857,2858,5,230,0,0,2858,2859,5,45,0,0,2859,2860,3,1156,578,0,2860,
  	257,1,0,0,0,2861,2862,5,232,0,0,2862,2863,5,747,0,0,2863,2865,7,27,0,
  	0,2864,2861,1,0,0,0,2864,2865,1,0,0,0,2865,2867,1,0,0,0,2866,2868,3,260,
  	130,0,2867,2866,1,0,0,0,2867,2868,1,0,0,0,2868,2871,1,0,0,0,2869,2870,
  	5,506,0,0,2870,2872,3,994,497,0,2871,2869,1,0,0,0,2871,2872,1,0,0,0,2872,
  	259,1,0,0,0,2873,2875,5,776,0,0,2874,2876,3,262,131,0,2875,2874,1,0,0,
  	0,2875,2876,1,0,0,0,2876,2877,1,0,0,0,2877,2878,5,777,0,0,2878,261,1,
  	0,0,0,2879,2882,3,1046,523,0,2880,2882,3,742,371,0,2881,2879,1,0,0,0,
  	2881,2880,1,0,0,0,2882,2890,1,0,0,0,2883,2886,5,773,0,0,2884,2887,3,1046,
  	523,0,2885,2887,3,742,371,0,2886,2884,1,0,0,0,2886,2885,1,0,0,0,2887,
  	2889,1,0,0,0,2888,2883,1,0,0,0,2889,2892,1,0,0,0,2890,2888,1,0,0,0,2890,
  	2891,1,0,0,0,2891,263,1,0,0,0,2892,2890,1,0,0,0,2893,2895,5,458,0,0,2894,
  	2896,7,28,0,0,2895,2894,1,0,0,0,2895,2896,1,0,0,0,2896,2898,1,0,0,0,2897,
  	2899,5,248,0,0,2898,2897,1,0,0,0,2898,2899,1,0,0,0,2899,2900,1,0,0,0,
  	2900,2902,3,1102,551,0,2901,2903,3,1036,518,0,2902,2901,1,0,0,0,2902,
  	2903,1,0,0,0,2903,2908,1,0,0,0,2904,2909,3,236,118,0,2905,2906,5,506,
  	0,0,2906,2909,3,994,497,0,2907,2909,3,242,121,0,2908,2904,1,0,0,0,2908,
  	2905,1,0,0,0,2908,2907,1,0,0,0,2909,265,1,0,0,0,2910,2912,3,270,135,0,
  	2911,2913,3,344,172,0,2912,2911,1,0,0,0,2912,2913,1,0,0,0,2913,2917,1,
  	0,0,0,2914,2917,3,274,137,0,2915,2917,3,268,134,0,2916,2910,1,0,0,0,2916,
  	2914,1,0,0,0,2916,2915,1,0,0,0,2917,267,1,0,0,0,2918,2919,5,776,0,0,2919,
  	2920,3,268,134,0,2920,2921,5,777,0,0,2921,2931,1,0,0,0,2922,2923,3,270,
  	135,0,2923,2925,3,292,146,0,2924,2926,3,344,172,0,2925,2924,1,0,0,0,2925,
  	2926,1,0,0,0,2926,2931,1,0,0,0,2927,2928,3,344,172,0,2928,2929,3,292,
  	146,0,2929,2931,1,0,0,0,2930,2918,1,0,0,0,2930,2922,1,0,0,0,2930,2927,
  	1,0,0,0,2931,269,1,0,0,0,2932,2933,4,135,45,0,2933,2935,3,320,160,0,2934,
  	2932,1,0,0,0,2934,2935,1,0,0,0,2935,2950,1,0,0,0,2936,2938,3,272,136,
  	0,2937,2939,3,328,164,0,2938,2937,1,0,0,0,2938,2939,1,0,0,0,2939,2941,
  	1,0,0,0,2940,2942,3,284,142,0,2941,2940,1,0,0,0,2941,2942,1,0,0,0,2942,
  	2951,1,0,0,0,2943,2945,3,274,137,0,2944,2946,3,328,164,0,2945,2944,1,
  	0,0,0,2945,2946,1,0,0,0,2946,2948,1,0,0,0,2947,2949,3,284,142,0,2948,
  	2947,1,0,0,0,2948,2949,1,0,0,0,2949,2951,1,0,0,0,2950,2936,1,0,0,0,2950,
  	2943,1,0,0,0,2951,2954,1,0,0,0,2952,2953,4,135,46,0,2953,2955,3,294,147,
  	0,2954,2952,1,0,0,0,2954,2955,1,0,0,0,2955,271,1,0,0,0,2956,2967,3,276,
  	138,0,2957,2958,3,274,137,0,2958,2960,5,608,0,0,2959,2961,3,396,198,0,
  	2960,2959,1,0,0,0,2960,2961,1,0,0,0,2961,2964,1,0,0,0,2962,2965,3,276,
  	138,0,2963,2965,3,274,137,0,2964,2962,1,0,0,0,2964,2963,1,0,0,0,2965,
  	2967,1,0,0,0,2966,2956,1,0,0,0,2966,2957,1,0,0,0,2967,2978,1,0,0,0,2968,
  	2970,5,608,0,0,2969,2971,3,396,198,0,2970,2969,1,0,0,0,2970,2971,1,0,
  	0,0,2971,2974,1,0,0,0,2972,2975,3,276,138,0,2973,2975,3,274,137,0,2974,
  	2972,1,0,0,0,2974,2973,1,0,0,0,2975,2977,1,0,0,0,2976,2968,1,0,0,0,2977,
  	2980,1,0,0,0,2978,2976,1,0,0,0,2978,2979,1,0,0,0,2979,273,1,0,0,0,2980,
  	2978,1,0,0,0,2981,2987,5,776,0,0,2982,2988,3,274,137,0,2983,2985,3,270,
  	135,0,2984,2986,3,344,172,0,2985,2984,1,0,0,0,2985,2986,1,0,0,0,2986,
  	2988,1,0,0,0,2987,2982,1,0,0,0,2987,2983,1,0,0,0,2988,2989,1,0,0,0,2989,
  	2990,5,777,0,0,2990,275,1,0,0,0,2991,2997,3,278,139,0,2992,2993,4,138,
  	47,0,2993,2997,3,336,168,0,2994,2995,4,138,48,0,2995,2997,3,338,169,0,
  	2996,2991,1,0,0,0,2996,2992,1,0,0,0,2996,2994,1,0,0,0,2997,277,1,0,0,
  	0,2998,3002,5,497,0,0,2999,3001,3,342,171,0,3000,2999,1,0,0,0,3001,3004,
  	1,0,0,0,3002,3000,1,0,0,0,3002,3003,1,0,0,0,3003,3005,1,0,0,0,3004,3002,
  	1,0,0,0,3005,3007,3,352,176,0,3006,3008,3,292,146,0,3007,3006,1,0,0,0,
  	3007,3008,1,0,0,0,3008,3010,1,0,0,0,3009,3011,3,332,166,0,3010,3009,1,
  	0,0,0,3010,3011,1,0,0,0,3011,3013,1,0,0,0,3012,3014,3,358,179,0,3013,
  	3012,1,0,0,0,3013,3014,1,0,0,0,3014,3016,1,0,0,0,3015,3017,3,324,162,
  	0,3016,3015,1,0,0,0,3016,3017,1,0,0,0,3017,3019,1,0,0,0,3018,3020,3,296,
  	148,0,3019,3018,1,0,0,0,3019,3020,1,0,0,0,3020,3023,1,0,0,0,3021,3022,
  	4,139,49,0,3022,3024,3,298,149,0,3023,3021,1,0,0,0,3023,3024,1,0,0,0,
  	3024,279,1,0,0,0,3025,3026,3,274,137,0,3026,281,1,0,0,0,3027,3028,7,29,
  	0,0,3028,283,1,0,0,0,3029,3030,5,276,0,0,3030,3031,3,288,144,0,3031,285,
  	1,0,0,0,3032,3033,5,276,0,0,3033,3034,3,290,145,0,3034,287,1,0,0,0,3035,
  	3038,3,290,145,0,3036,3037,7,30,0,0,3037,3039,3,290,145,0,3038,3036,1,
  	0,0,0,3038,3039,1,0,0,0,3039,289,1,0,0,0,3040,3043,3,1128,564,0,3041,
  	3043,7,31,0,0,3042,3040,1,0,0,0,3042,3041,1,0,0,0,3043,291,1,0,0,0,3044,
  	3072,5,248,0,0,3045,3046,5,396,0,0,3046,3048,3,1154,577,0,3047,3049,3,
  	998,499,0,3048,3047,1,0,0,0,3048,3049,1,0,0,0,3049,3051,1,0,0,0,3050,
  	3052,3,1000,500,0,3051,3050,1,0,0,0,3051,3052,1,0,0,0,3052,3054,1,0,0,
  	0,3053,3055,3,1004,502,0,3054,3053,1,0,0,0,3054,3055,1,0,0,0,3055,3073,
  	1,0,0,0,3056,3057,5,150,0,0,3057,3073,3,1154,577,0,3058,3061,3,1180,590,
  	0,3059,3061,3,742,371,0,3060,3058,1,0,0,0,3060,3059,1,0,0,0,3061,3069,
  	1,0,0,0,3062,3065,5,773,0,0,3063,3066,3,1180,590,0,3064,3066,3,742,371,
  	0,3065,3063,1,0,0,0,3065,3064,1,0,0,0,3066,3068,1,0,0,0,3067,3062,1,0,
  	0,0,3068,3071,1,0,0,0,3069,3067,1,0,0,0,3069,3070,1,0,0,0,3070,3073,1,
  	0,0,0,3071,3069,1,0,0,0,3072,3045,1,0,0,0,3072,3056,1,0,0,0,3072,3060,
  	1,0,0,0,3073,293,1,0,0,0,3074,3075,5,422,0,0,3075,3076,5,13,0,0,3076,
  	3082,5,776,0,0,3077,3080,5,747,0,0,3078,3079,5,773,0,0,3079,3081,5,747,
  	0,0,3080,3078,1,0,0,0,3080,3081,1,0,0,0,3081,3083,1,0,0,0,3082,3077,1,
  	0,0,0,3082,3083,1,0,0,0,3083,3084,1,0,0,0,3084,3085,5,777,0,0,3085,295,
  	1,0,0,0,3086,3087,5,221,0,0,3087,3088,3,676,338,0,3088,297,1,0,0,0,3089,
  	3090,5,699,0,0,3090,3095,3,300,150,0,3091,3092,5,773,0,0,3092,3094,3,
  	300,150,0,3093,3091,1,0,0,0,3094,3097,1,0,0,0,3095,3093,1,0,0,0,3095,
  	3096,1,0,0,0,3096,299,1,0,0,0,3097,3095,1,0,0,0,3098,3099,3,1124,562,
  	0,3099,3100,5,17,0,0,3100,3101,3,302,151,0,3101,301,1,0,0,0,3102,3103,
  	5,776,0,0,3103,3104,3,304,152,0,3104,3105,5,777,0,0,3105,303,1,0,0,0,
  	3106,3108,3,1124,562,0,3107,3106,1,0,0,0,3107,3108,1,0,0,0,3108,3112,
  	1,0,0,0,3109,3110,5,405,0,0,3110,3111,5,45,0,0,3111,3113,3,774,387,0,
  	3112,3109,1,0,0,0,3112,3113,1,0,0,0,3113,3115,1,0,0,0,3114,3116,3,328,
  	164,0,3115,3114,1,0,0,0,3115,3116,1,0,0,0,3116,3118,1,0,0,0,3117,3119,
  	3,306,153,0,3118,3117,1,0,0,0,3118,3119,1,0,0,0,3119,305,1,0,0,0,3120,
  	3121,3,308,154,0,3121,3123,3,310,155,0,3122,3124,3,318,159,0,3123,3122,
  	1,0,0,0,3123,3124,1,0,0,0,3124,307,1,0,0,0,3125,3126,7,32,0,0,3126,309,
  	1,0,0,0,3127,3130,3,312,156,0,3128,3130,3,314,157,0,3129,3127,1,0,0,0,
  	3129,3128,1,0,0,0,3130,311,1,0,0,0,3131,3132,5,698,0,0,3132,3146,5,693,
  	0,0,3133,3134,3,1144,572,0,3134,3135,5,693,0,0,3135,3146,1,0,0,0,3136,
  	3137,5,787,0,0,3137,3146,5,693,0,0,3138,3139,5,247,0,0,3139,3140,3,676,
  	338,0,3140,3141,3,764,382,0,3141,3142,5,693,0,0,3142,3146,1,0,0,0,3143,
  	3144,5,101,0,0,3144,3146,5,487,0,0,3145,3131,1,0,0,0,3145,3133,1,0,0,
  	0,3145,3136,1,0,0,0,3145,3138,1,0,0,0,3145,3143,1,0,0,0,3146,313,1,0,
  	0,0,3147,3148,5,30,0,0,3148,3149,3,316,158,0,3149,3150,5,15,0,0,3150,
  	3151,3,316,158,0,3151,315,1,0,0,0,3152,3166,3,312,156,0,3153,3154,5,698,
  	0,0,3154,3166,5,682,0,0,3155,3156,3,1144,572,0,3156,3157,5,682,0,0,3157,
  	3166,1,0,0,0,3158,3159,5,787,0,0,3159,3166,5,682,0,0,3160,3161,5,247,
  	0,0,3161,3162,3,676,338,0,3162,3163,3,764,382,0,3163,3164,5,682,0,0,3164,
  	3166,1,0,0,0,3165,3152,1,0,0,0,3165,3153,1,0,0,0,3165,3155,1,0,0,0,3165,
  	3158,1,0,0,0,3165,3160,1,0,0,0,3166,317,1,0,0,0,3167,3174,5,680,0,0,3168,
  	3169,5,101,0,0,3169,3175,5,487,0,0,3170,3175,5,217,0,0,3171,3175,5,697,
  	0,0,3172,3173,5,373,0,0,3173,3175,5,690,0,0,3174,3168,1,0,0,0,3174,3170,
  	1,0,0,0,3174,3171,1,0,0,0,3174,3172,1,0,0,0,3175,319,1,0,0,0,3176,3178,
  	5,645,0,0,3177,3179,5,665,0,0,3178,3177,1,0,0,0,3178,3179,1,0,0,0,3179,
  	3180,1,0,0,0,3180,3185,3,322,161,0,3181,3182,5,773,0,0,3182,3184,3,322,
  	161,0,3183,3181,1,0,0,0,3184,3187,1,0,0,0,3185,3183,1,0,0,0,3185,3186,
  	1,0,0,0,3186,321,1,0,0,0,3187,3185,1,0,0,0,3188,3190,3,1128,564,0,3189,
  	3191,3,1044,522,0,3190,3189,1,0,0,0,3190,3191,1,0,0,0,3191,3192,1,0,0,
  	0,3192,3193,5,17,0,0,3193,3194,3,280,140,0,3194,323,1,0,0,0,3195,3196,
  	5,217,0,0,3196,3197,5,45,0,0,3197,3199,3,774,387,0,3198,3200,3,326,163,
  	0,3199,3198,1,0,0,0,3199,3200,1,0,0,0,3200,325,1,0,0,0,3201,3202,5,645,
  	0,0,3202,3207,5,481,0,0,3203,3204,4,163,50,0,3204,3205,5,645,0,0,3205,
  	3207,5,99,0,0,3206,3201,1,0,0,0,3206,3203,1,0,0,0,3207,327,1,0,0,0,3208,
  	3209,5,393,0,0,3209,3210,5,45,0,0,3210,3211,3,774,387,0,3211,329,1,0,
  	0,0,3212,3213,7,33,0,0,3213,331,1,0,0,0,3214,3217,5,203,0,0,3215,3218,
  	5,149,0,0,3216,3218,3,334,167,0,3217,3215,1,0,0,0,3217,3216,1,0,0,0,3218,
  	333,1,0,0,0,3219,3224,3,360,180,0,3220,3221,5,773,0,0,3221,3223,3,360,
  	180,0,3222,3220,1,0,0,0,3223,3226,1,0,0,0,3224,3222,1,0,0,0,3224,3225,
  	1,0,0,0,3225,335,1,0,0,0,3226,3224,1,0,0,0,3227,3228,5,626,0,0,3228,3233,
  	3,340,170,0,3229,3230,5,773,0,0,3230,3232,3,340,170,0,3231,3229,1,0,0,
  	0,3232,3235,1,0,0,0,3233,3231,1,0,0,0,3233,3234,1,0,0,0,3234,337,1,0,
  	0,0,3235,3233,1,0,0,0,3236,3237,5,574,0,0,3237,3238,3,1102,551,0,3238,
  	339,1,0,0,0,3239,3240,5,487,0,0,3240,3242,5,776,0,0,3241,3243,3,246,123,
  	0,3242,3241,1,0,0,0,3242,3243,1,0,0,0,3243,3244,1,0,0,0,3244,3245,5,777,
  	0,0,3245,341,1,0,0,0,3246,3255,3,282,141,0,3247,3255,5,535,0,0,3248,3249,
  	4,171,51,0,3249,3255,5,533,0,0,3250,3251,4,171,52,0,3251,3252,5,325,0,
  	0,3252,3253,5,750,0,0,3253,3255,3,1142,571,0,3254,3246,1,0,0,0,3254,3247,
  	1,0,0,0,3254,3248,1,0,0,0,3254,3250,1,0,0,0,3255,343,1,0,0,0,3256,3258,
  	3,346,173,0,3257,3256,1,0,0,0,3258,3259,1,0,0,0,3259,3257,1,0,0,0,3259,
  	3260,1,0,0,0,3260,345,1,0,0,0,3261,3262,5,200,0,0,3262,3266,3,348,174,
  	0,3263,3264,4,173,53,0,3264,3265,5,668,0,0,3265,3267,3,1106,553,0,3266,
  	3263,1,0,0,0,3266,3267,1,0,0,0,3267,3270,1,0,0,0,3268,3269,4,173,54,0,
  	3269,3271,3,350,175,0,3270,3268,1,0,0,0,3270,3271,1,0,0,0,3271,3277,1,
  	0,0,0,3272,3273,5,287,0,0,3273,3274,5,251,0,0,3274,3275,5,508,0,0,3275,
  	3277,5,346,0,0,3276,3261,1,0,0,0,3276,3272,1,0,0,0,3277,347,1,0,0,0,3278,
  	3282,5,614,0,0,3279,3280,4,174,55,0,3280,3282,5,508,0,0,3281,3278,1,0,
  	0,0,3281,3279,1,0,0,0,3282,349,1,0,0,0,3283,3284,5,669,0,0,3284,3287,
  	5,670,0,0,3285,3287,5,671,0,0,3286,3283,1,0,0,0,3286,3285,1,0,0,0,3287,
  	351,1,0,0,0,3288,3291,3,354,177,0,3289,3291,5,760,0,0,3290,3288,1,0,0,
  	0,3290,3289,1,0,0,0,3291,3296,1,0,0,0,3292,3293,5,773,0,0,3293,3295,3,
  	354,177,0,3294,3292,1,0,0,0,3295,3298,1,0,0,0,3296,3294,1,0,0,0,3296,
  	3297,1,0,0,0,3297,353,1,0,0,0,3298,3296,1,0,0,0,3299,3305,3,1054,527,
  	0,3300,3302,3,676,338,0,3301,3303,3,356,178,0,3302,3301,1,0,0,0,3302,
  	3303,1,0,0,0,3303,3305,1,0,0,0,3304,3299,1,0,0,0,3304,3300,1,0,0,0,3305,
  	355,1,0,0,0,3306,3308,5,17,0,0,3307,3306,1,0,0,0,3307,3308,1,0,0,0,3308,
  	3311,1,0,0,0,3309,3312,3,1128,564,0,3310,3312,3,1154,577,0,3311,3309,
  	1,0,0,0,3311,3310,1,0,0,0,3312,357,1,0,0,0,3313,3314,5,643,0,0,3314,3315,
  	3,676,338,0,3315,359,1,0,0,0,3316,3327,3,372,186,0,3317,3321,5,778,0,
  	0,3318,3319,4,180,56,0,3319,3322,3,1128,564,0,3320,3322,5,732,0,0,3321,
  	3318,1,0,0,0,3321,3320,1,0,0,0,3322,3323,1,0,0,0,3323,3324,3,362,181,
  	0,3324,3325,5,779,0,0,3325,3327,1,0,0,0,3326,3316,1,0,0,0,3326,3317,1,
  	0,0,0,3327,3331,1,0,0,0,3328,3330,3,364,182,0,3329,3328,1,0,0,0,3330,
  	3333,1,0,0,0,3331,3329,1,0,0,0,3331,3332,1,0,0,0,3332,361,1,0,0,0,3333,
  	3331,1,0,0,0,3334,3338,3,372,186,0,3335,3337,3,364,182,0,3336,3335,1,
  	0,0,0,3337,3340,1,0,0,0,3338,3336,1,0,0,0,3338,3339,1,0,0,0,3339,363,
  	1,0,0,0,3340,3338,1,0,0,0,3341,3342,3,368,184,0,3342,3347,3,360,180,0,
  	3343,3344,5,383,0,0,3344,3348,3,676,338,0,3345,3346,5,621,0,0,3346,3348,
  	3,1132,566,0,3347,3343,1,0,0,0,3347,3345,1,0,0,0,3347,3348,1,0,0,0,3348,
  	3361,1,0,0,0,3349,3350,3,370,185,0,3350,3355,3,360,180,0,3351,3352,5,
  	383,0,0,3352,3356,3,676,338,0,3353,3354,5,621,0,0,3354,3356,3,1132,566,
  	0,3355,3351,1,0,0,0,3355,3353,1,0,0,0,3356,3361,1,0,0,0,3357,3358,3,366,
  	183,0,3358,3359,3,372,186,0,3359,3361,1,0,0,0,3360,3341,1,0,0,0,3360,
  	3349,1,0,0,0,3360,3357,1,0,0,0,3361,365,1,0,0,0,3362,3364,5,359,0,0,3363,
  	3365,5,239,0,0,3364,3363,1,0,0,0,3364,3365,1,0,0,0,3365,3366,1,0,0,0,
  	3366,3374,5,261,0,0,3367,3368,5,359,0,0,3368,3370,7,34,0,0,3369,3371,
  	5,395,0,0,3370,3369,1,0,0,0,3370,3371,1,0,0,0,3371,3372,1,0,0,0,3372,
  	3374,5,261,0,0,3373,3362,1,0,0,0,3373,3367,1,0,0,0,3374,367,1,0,0,0,3375,
  	3377,7,35,0,0,3376,3375,1,0,0,0,3376,3377,1,0,0,0,3377,3378,1,0,0,0,3378,
  	3381,5,261,0,0,3379,3381,5,555,0,0,3380,3376,1,0,0,0,3380,3379,1,0,0,
  	0,3381,369,1,0,0,0,3382,3384,7,34,0,0,3383,3385,5,395,0,0,3384,3383,1,
  	0,0,0,3384,3385,1,0,0,0,3385,3386,1,0,0,0,3386,3387,5,261,0,0,3387,371,
  	1,0,0,0,3388,3395,3,374,187,0,3389,3395,3,376,188,0,3390,3395,3,378,189,
  	0,3391,3395,3,380,190,0,3392,3393,4,186,57,0,3393,3395,3,382,191,0,3394,
  	3388,1,0,0,0,3394,3389,1,0,0,0,3394,3390,1,0,0,0,3394,3391,1,0,0,0,3394,
  	3392,1,0,0,0,3395,373,1,0,0,0,3396,3398,3,1102,551,0,3397,3399,3,1036,
  	518,0,3398,3397,1,0,0,0,3398,3399,1,0,0,0,3399,3401,1,0,0,0,3400,3402,
  	3,398,199,0,3401,3400,1,0,0,0,3401,3402,1,0,0,0,3402,3404,1,0,0,0,3403,
  	3405,3,400,200,0,3404,3403,1,0,0,0,3404,3405,1,0,0,0,3405,375,1,0,0,0,
  	3406,3409,5,776,0,0,3407,3410,3,374,187,0,3408,3410,3,376,188,0,3409,
  	3407,1,0,0,0,3409,3408,1,0,0,0,3410,3411,1,0,0,0,3411,3412,5,777,0,0,
  	3412,377,1,0,0,0,3413,3415,3,280,140,0,3414,3416,3,398,199,0,3415,3414,
  	1,0,0,0,3415,3416,1,0,0,0,3416,3419,1,0,0,0,3417,3418,4,189,58,0,3418,
  	3420,3,1044,522,0,3419,3417,1,0,0,0,3419,3420,1,0,0,0,3420,3431,1,0,0,
  	0,3421,3422,4,189,59,0,3422,3423,5,726,0,0,3423,3425,3,280,140,0,3424,
  	3426,3,398,199,0,3425,3424,1,0,0,0,3425,3426,1,0,0,0,3426,3428,1,0,0,
  	0,3427,3429,3,1044,522,0,3428,3427,1,0,0,0,3428,3429,1,0,0,0,3429,3431,
  	1,0,0,0,3430,3413,1,0,0,0,3430,3421,1,0,0,0,3431,379,1,0,0,0,3432,3435,
  	5,776,0,0,3433,3436,3,334,167,0,3434,3436,3,380,190,0,3435,3433,1,0,0,
  	0,3435,3434,1,0,0,0,3436,3437,1,0,0,0,3437,3438,5,777,0,0,3438,381,1,
  	0,0,0,3439,3440,5,701,0,0,3440,3441,5,776,0,0,3441,3442,3,676,338,0,3442,
  	3443,5,773,0,0,3443,3444,3,1154,577,0,3444,3445,3,384,192,0,3445,3447,
  	5,777,0,0,3446,3448,3,398,199,0,3447,3446,1,0,0,0,3447,3448,1,0,0,0,3448,
  	383,1,0,0,0,3449,3450,5,71,0,0,3450,3451,5,776,0,0,3451,3456,3,386,193,
  	0,3452,3453,5,773,0,0,3453,3455,3,386,193,0,3454,3452,1,0,0,0,3455,3458,
  	1,0,0,0,3456,3454,1,0,0,0,3456,3457,1,0,0,0,3457,3459,1,0,0,0,3458,3456,
  	1,0,0,0,3459,3460,5,777,0,0,3460,385,1,0,0,0,3461,3462,3,1128,564,0,3462,
  	3463,5,200,0,0,3463,3464,5,703,0,0,3464,3485,1,0,0,0,3465,3466,3,1128,
  	564,0,3466,3469,3,916,458,0,3467,3468,4,193,60,0,3468,3470,3,986,493,
  	0,3469,3467,1,0,0,0,3469,3470,1,0,0,0,3470,3472,1,0,0,0,3471,3473,5,174,
  	0,0,3472,3471,1,0,0,0,3472,3473,1,0,0,0,3473,3474,1,0,0,0,3474,3475,5,
  	704,0,0,3475,3477,3,1154,577,0,3476,3478,3,388,194,0,3477,3476,1,0,0,
  	0,3477,3478,1,0,0,0,3478,3485,1,0,0,0,3479,3480,5,702,0,0,3480,3481,5,
  	704,0,0,3481,3482,3,1154,577,0,3482,3483,3,384,192,0,3483,3485,1,0,0,
  	0,3484,3461,1,0,0,0,3484,3465,1,0,0,0,3484,3479,1,0,0,0,3485,387,1,0,
  	0,0,3486,3488,3,390,195,0,3487,3489,3,392,196,0,3488,3487,1,0,0,0,3488,
  	3489,1,0,0,0,3489,3495,1,0,0,0,3490,3492,3,392,196,0,3491,3493,3,390,
  	195,0,3492,3491,1,0,0,0,3492,3493,1,0,0,0,3493,3495,1,0,0,0,3494,3486,
  	1,0,0,0,3494,3490,1,0,0,0,3495,389,1,0,0,0,3496,3497,3,394,197,0,3497,
  	3498,5,383,0,0,3498,3499,5,700,0,0,3499,391,1,0,0,0,3500,3501,3,394,197,
  	0,3501,3502,5,383,0,0,3502,3503,5,165,0,0,3503,393,1,0,0,0,3504,3509,
  	5,165,0,0,3505,3509,5,376,0,0,3506,3507,5,128,0,0,3507,3509,3,1154,577,
  	0,3508,3504,1,0,0,0,3508,3505,1,0,0,0,3508,3506,1,0,0,0,3509,395,1,0,
  	0,0,3510,3511,7,36,0,0,3511,397,1,0,0,0,3512,3516,5,17,0,0,3513,3514,
  	4,199,61,0,3514,3516,5,750,0,0,3515,3512,1,0,0,0,3515,3513,1,0,0,0,3515,
  	3516,1,0,0,0,3516,3517,1,0,0,0,3517,3518,3,1128,564,0,3518,399,1,0,0,
  	0,3519,3524,3,402,201,0,3520,3521,5,773,0,0,3521,3523,3,402,201,0,3522,
  	3520,1,0,0,0,3523,3526,1,0,0,0,3524,3522,1,0,0,0,3524,3525,1,0,0,0,3525,
  	401,1,0,0,0,3526,3524,1,0,0,0,3527,3528,3,404,202,0,3528,3530,3,406,203,
  	0,3529,3531,3,410,205,0,3530,3529,1,0,0,0,3530,3531,1,0,0,0,3531,3532,
  	1,0,0,0,3532,3533,5,776,0,0,3533,3534,3,412,206,0,3534,3535,5,777,0,0,
  	3535,3548,1,0,0,0,3536,3537,5,620,0,0,3537,3539,3,406,203,0,3538,3540,
  	3,410,205,0,3539,3538,1,0,0,0,3539,3540,1,0,0,0,3540,3541,1,0,0,0,3541,
  	3543,5,776,0,0,3542,3544,3,412,206,0,3543,3542,1,0,0,0,3543,3544,1,0,
  	0,0,3544,3545,1,0,0,0,3545,3546,5,777,0,0,3546,3548,1,0,0,0,3547,3527,
  	1,0,0,0,3547,3536,1,0,0,0,3548,403,1,0,0,0,3549,3550,7,37,0,0,3550,405,
  	1,0,0,0,3551,3552,7,38,0,0,3552,407,1,0,0,0,3553,3554,5,420,0,0,3554,
  	3560,5,265,0,0,3555,3557,5,609,0,0,3556,3558,3,406,203,0,3557,3556,1,
  	0,0,0,3557,3558,1,0,0,0,3558,3560,1,0,0,0,3559,3553,1,0,0,0,3559,3555,
  	1,0,0,0,3560,409,1,0,0,0,3561,3567,5,200,0,0,3562,3568,5,261,0,0,3563,
  	3564,5,393,0,0,3564,3568,5,45,0,0,3565,3566,5,217,0,0,3566,3568,5,45,
  	0,0,3567,3562,1,0,0,0,3567,3563,1,0,0,0,3567,3565,1,0,0,0,3568,411,1,
  	0,0,0,3569,3574,3,414,207,0,3570,3571,5,773,0,0,3571,3573,3,414,207,0,
  	3572,3570,1,0,0,0,3573,3576,1,0,0,0,3574,3572,1,0,0,0,3574,3575,1,0,0,
  	0,3575,413,1,0,0,0,3576,3574,1,0,0,0,3577,3580,3,1128,564,0,3578,3580,
  	5,420,0,0,3579,3577,1,0,0,0,3579,3578,1,0,0,0,3580,415,1,0,0,0,3581,3582,
  	4,208,62,0,3582,3584,3,320,160,0,3583,3581,1,0,0,0,3583,3584,1,0,0,0,
  	3584,3585,1,0,0,0,3585,3587,5,614,0,0,3586,3588,5,295,0,0,3587,3586,1,
  	0,0,0,3587,3588,1,0,0,0,3588,3590,1,0,0,0,3589,3591,5,232,0,0,3590,3589,
  	1,0,0,0,3590,3591,1,0,0,0,3591,3592,1,0,0,0,3592,3593,3,334,167,0,3593,
  	3594,5,506,0,0,3594,3596,3,994,497,0,3595,3597,3,358,179,0,3596,3595,
  	1,0,0,0,3596,3597,1,0,0,0,3597,3599,1,0,0,0,3598,3600,3,328,164,0,3599,
  	3598,1,0,0,0,3599,3600,1,0,0,0,3600,3602,1,0,0,0,3601,3603,3,286,143,
  	0,3602,3601,1,0,0,0,3602,3603,1,0,0,0,3603,417,1,0,0,0,3604,3609,3,420,
  	210,0,3605,3609,3,426,213,0,3606,3609,3,428,214,0,3607,3609,3,434,217,
  	0,3608,3604,1,0,0,0,3608,3605,1,0,0,0,3608,3606,1,0,0,0,3608,3607,1,0,
  	0,0,3609,419,1,0,0,0,3610,3611,5,543,0,0,3611,3615,5,592,0,0,3612,3614,
  	3,424,212,0,3613,3612,1,0,0,0,3614,3617,1,0,0,0,3615,3613,1,0,0,0,3615,
  	3616,1,0,0,0,3616,3636,1,0,0,0,3617,3615,1,0,0,0,3618,3620,5,77,0,0,3619,
  	3621,5,647,0,0,3620,3619,1,0,0,0,3620,3621,1,0,0,0,3621,3627,1,0,0,0,
  	3622,3624,5,15,0,0,3623,3625,5,373,0,0,3624,3623,1,0,0,0,3624,3625,1,
  	0,0,0,3625,3626,1,0,0,0,3626,3628,5,54,0,0,3627,3622,1,0,0,0,3627,3628,
  	1,0,0,0,3628,3633,1,0,0,0,3629,3631,5,373,0,0,3630,3629,1,0,0,0,3630,
  	3631,1,0,0,0,3631,3632,1,0,0,0,3632,3634,5,450,0,0,3633,3630,1,0,0,0,
  	3633,3634,1,0,0,0,3634,3636,1,0,0,0,3635,3610,1,0,0,0,3635,3618,1,0,0,
  	0,3636,421,1,0,0,0,3637,3639,5,29,0,0,3638,3640,5,647,0,0,3639,3638,1,
  	0,0,0,3639,3640,1,0,0,0,3640,423,1,0,0,0,3641,3642,5,645,0,0,3642,3643,
  	5,85,0,0,3643,3648,5,517,0,0,3644,3645,4,212,63,0,3645,3646,5,435,0,0,
  	3646,3648,7,39,0,0,3647,3641,1,0,0,0,3647,3644,1,0,0,0,3648,425,1,0,0,
  	0,3649,3650,5,489,0,0,3650,3679,3,1128,564,0,3651,3653,5,480,0,0,3652,
  	3654,5,647,0,0,3653,3652,1,0,0,0,3653,3654,1,0,0,0,3654,3673,1,0,0,0,
  	3655,3657,5,590,0,0,3656,3658,5,489,0,0,3657,3656,1,0,0,0,3657,3658,1,
  	0,0,0,3658,3659,1,0,0,0,3659,3674,3,1128,564,0,3660,3662,5,15,0,0,3661,
  	3663,5,373,0,0,3662,3661,1,0,0,0,3662,3663,1,0,0,0,3663,3664,1,0,0,0,
  	3664,3666,5,54,0,0,3665,3660,1,0,0,0,3665,3666,1,0,0,0,3666,3671,1,0,
  	0,0,3667,3669,5,373,0,0,3668,3667,1,0,0,0,3668,3669,1,0,0,0,3669,3670,
  	1,0,0,0,3670,3672,5,450,0,0,3671,3668,1,0,0,0,3671,3672,1,0,0,0,3672,
  	3674,1,0,0,0,3673,3655,1,0,0,0,3673,3665,1,0,0,0,3674,3679,1,0,0,0,3675,
  	3676,5,450,0,0,3676,3677,5,489,0,0,3677,3679,3,1128,564,0,3678,3649,1,
  	0,0,0,3678,3651,1,0,0,0,3678,3675,1,0,0,0,3679,427,1,0,0,0,3680,3681,
  	5,287,0,0,3681,3682,7,18,0,0,3682,3687,3,430,215,0,3683,3684,5,773,0,
  	0,3684,3686,3,430,215,0,3685,3683,1,0,0,0,3686,3689,1,0,0,0,3687,3685,
  	1,0,0,0,3687,3688,1,0,0,0,3688,3703,1,0,0,0,3689,3687,1,0,0,0,3690,3691,
  	4,214,64,0,3691,3692,5,287,0,0,3692,3693,5,244,0,0,3693,3694,5,200,0,
  	0,3694,3703,5,27,0,0,3695,3700,5,611,0,0,3696,3701,5,571,0,0,3697,3701,
  	5,574,0,0,3698,3699,4,214,65,0,3699,3701,5,244,0,0,3700,3696,1,0,0,0,
  	3700,3697,1,0,0,0,3700,3698,1,0,0,0,3701,3703,1,0,0,0,3702,3680,1,0,0,
  	0,3702,3690,1,0,0,0,3702,3695,1,0,0,0,3703,429,1,0,0,0,3704,3706,3,1102,
  	551,0,3705,3707,3,398,199,0,3706,3705,1,0,0,0,3706,3707,1,0,0,0,3707,
  	3708,1,0,0,0,3708,3709,3,432,216,0,3709,431,1,0,0,0,3710,3712,5,435,0,
  	0,3711,3713,5,284,0,0,3712,3711,1,0,0,0,3712,3713,1,0,0,0,3713,3719,1,
  	0,0,0,3714,3716,5,295,0,0,3715,3714,1,0,0,0,3715,3716,1,0,0,0,3716,3717,
  	1,0,0,0,3717,3719,5,649,0,0,3718,3710,1,0,0,0,3718,3715,1,0,0,0,3719,
  	433,1,0,0,0,3720,3747,5,651,0,0,3721,3722,7,40,0,0,3722,3724,3,438,219,
  	0,3723,3725,7,41,0,0,3724,3723,1,0,0,0,3724,3725,1,0,0,0,3725,3748,1,
  	0,0,0,3726,3727,5,159,0,0,3727,3733,3,438,219,0,3728,3731,5,566,0,0,3729,
  	3730,5,200,0,0,3730,3732,5,340,0,0,3731,3729,1,0,0,0,3731,3732,1,0,0,
  	0,3732,3734,1,0,0,0,3733,3728,1,0,0,0,3733,3734,1,0,0,0,3734,3748,1,0,
  	0,0,3735,3736,5,417,0,0,3736,3748,3,438,219,0,3737,3738,5,77,0,0,3738,
  	3741,3,438,219,0,3739,3740,5,384,0,0,3740,3742,5,407,0,0,3741,3739,1,
  	0,0,0,3741,3742,1,0,0,0,3742,3748,1,0,0,0,3743,3744,5,480,0,0,3744,3748,
  	3,438,219,0,3745,3746,5,439,0,0,3746,3748,3,436,218,0,3747,3721,1,0,0,
  	0,3747,3726,1,0,0,0,3747,3735,1,0,0,0,3747,3737,1,0,0,0,3747,3743,1,0,
  	0,0,3747,3745,1,0,0,0,3748,435,1,0,0,0,3749,3752,4,218,66,0,3750,3751,
  	5,94,0,0,3751,3753,5,652,0,0,3752,3750,1,0,0,0,3752,3753,1,0,0,0,3753,
  	3756,1,0,0,0,3754,3756,1,0,0,0,3755,3749,1,0,0,0,3755,3754,1,0,0,0,3756,
  	437,1,0,0,0,3757,3764,3,1156,578,0,3758,3759,5,773,0,0,3759,3762,3,1156,
  	578,0,3760,3761,5,773,0,0,3761,3763,3,1140,570,0,3762,3760,1,0,0,0,3762,
  	3763,1,0,0,0,3763,3765,1,0,0,0,3764,3758,1,0,0,0,3764,3765,1,0,0,0,3765,
  	439,1,0,0,0,3766,3767,5,428,0,0,3767,3768,7,42,0,0,3768,3773,5,289,0,
  	0,3769,3770,5,590,0,0,3770,3774,3,1160,580,0,3771,3772,5,28,0,0,3772,
  	3774,3,676,338,0,3773,3769,1,0,0,0,3773,3771,1,0,0,0,3774,3800,1,0,0,
  	0,3775,3800,3,448,224,0,3776,3777,5,468,0,0,3777,3782,3,442,221,0,3778,
  	3779,5,773,0,0,3779,3781,3,442,221,0,3780,3778,1,0,0,0,3781,3784,1,0,
  	0,0,3782,3780,1,0,0,0,3782,3783,1,0,0,0,3783,3800,1,0,0,0,3784,3782,1,
  	0,0,0,3785,3786,4,220,67,0,3786,3787,5,468,0,0,3787,3791,5,658,0,0,3788,
  	3789,3,978,489,0,3789,3790,3,1128,564,0,3790,3792,1,0,0,0,3791,3788,1,
  	0,0,0,3791,3792,1,0,0,0,3792,3800,1,0,0,0,3793,3800,3,478,239,0,3794,
  	3795,4,220,68,0,3795,3800,3,464,232,0,3796,3800,3,446,223,0,3797,3798,
  	4,220,69,0,3798,3800,3,488,244,0,3799,3766,1,0,0,0,3799,3775,1,0,0,0,
  	3799,3776,1,0,0,0,3799,3785,1,0,0,0,3799,3793,1,0,0,0,3799,3794,1,0,0,
  	0,3799,3796,1,0,0,0,3799,3797,1,0,0,0,3800,441,1,0,0,0,3801,3803,5,316,
  	0,0,3802,3804,3,444,222,0,3803,3802,1,0,0,0,3803,3804,1,0,0,0,3804,3816,
  	1,0,0,0,3805,3806,4,221,70,0,3806,3807,5,430,0,0,3807,3816,5,47,0,0,3808,
  	3810,5,514,0,0,3809,3811,5,10,0,0,3810,3809,1,0,0,0,3810,3811,1,0,0,0,
  	3811,3813,1,0,0,0,3812,3814,3,782,391,0,3813,3812,1,0,0,0,3813,3814,1,
  	0,0,0,3814,3816,1,0,0,0,3815,3801,1,0,0,0,3815,3805,1,0,0,0,3815,3808,
  	1,0,0,0,3816,443,1,0,0,0,3817,3818,4,222,71,0,3818,3823,5,590,0,0,3819,
  	3820,4,222,72,0,3820,3824,3,1142,571,0,3821,3822,4,222,73,0,3822,3824,
  	3,1146,573,0,3823,3819,1,0,0,0,3823,3821,1,0,0,0,3824,445,1,0,0,0,3825,
  	3829,5,281,0,0,3826,3830,5,112,0,0,3827,3828,5,574,0,0,3828,3830,3,1102,
  	551,0,3829,3826,1,0,0,0,3829,3827,1,0,0,0,3830,3831,1,0,0,0,3831,3832,
  	5,203,0,0,3832,3833,5,316,0,0,3833,447,1,0,0,0,3834,3835,5,55,0,0,3835,
  	3836,5,316,0,0,3836,3837,5,590,0,0,3837,3839,3,450,225,0,3838,3840,3,
  	782,391,0,3839,3838,1,0,0,0,3839,3840,1,0,0,0,3840,449,1,0,0,0,3841,3846,
  	3,452,226,0,3842,3843,5,773,0,0,3843,3845,3,452,226,0,3844,3842,1,0,0,
  	0,3845,3848,1,0,0,0,3846,3844,1,0,0,0,3846,3847,1,0,0,0,3847,451,1,0,
  	0,0,3848,3846,1,0,0,0,3849,3850,5,300,0,0,3850,3851,5,750,0,0,3851,3941,
  	3,1162,581,0,3852,3853,5,729,0,0,3853,3854,5,750,0,0,3854,3941,3,1162,
  	581,0,3855,3856,5,297,0,0,3856,3857,5,750,0,0,3857,3941,3,1162,581,0,
  	3858,3859,5,318,0,0,3859,3860,5,750,0,0,3860,3941,3,1162,581,0,3861,3862,
  	5,303,0,0,3862,3863,5,750,0,0,3863,3941,3,1162,581,0,3864,3865,5,304,
  	0,0,3865,3866,5,750,0,0,3866,3941,3,1140,570,0,3867,3868,5,298,0,0,3868,
  	3869,5,750,0,0,3869,3941,3,1140,570,0,3870,3871,5,305,0,0,3871,3872,5,
  	750,0,0,3872,3941,3,1140,570,0,3873,3874,5,299,0,0,3874,3875,5,750,0,
  	0,3875,3941,3,1140,570,0,3876,3877,5,314,0,0,3877,3878,5,750,0,0,3878,
  	3941,3,1140,570,0,3879,3880,5,308,0,0,3880,3881,5,750,0,0,3881,3941,3,
  	1162,581,0,3882,3883,5,307,0,0,3883,3884,5,750,0,0,3884,3941,3,1162,581,
  	0,3885,3886,5,317,0,0,3886,3887,5,750,0,0,3887,3941,3,1162,581,0,3888,
  	3889,5,309,0,0,3889,3890,5,750,0,0,3890,3941,3,1162,581,0,3891,3892,5,
  	738,0,0,3892,3893,5,750,0,0,3893,3941,3,458,229,0,3894,3895,5,310,0,0,
  	3895,3896,5,750,0,0,3896,3941,3,1162,581,0,3897,3898,5,313,0,0,3898,3899,
  	5,750,0,0,3899,3941,3,1162,581,0,3900,3901,5,315,0,0,3901,3902,5,750,
  	0,0,3902,3941,3,1140,570,0,3903,3904,5,311,0,0,3904,3905,5,750,0,0,3905,
  	3941,3,1160,580,0,3906,3907,5,312,0,0,3907,3908,5,750,0,0,3908,3941,3,
  	1162,581,0,3909,3910,5,712,0,0,3910,3911,5,750,0,0,3911,3941,3,1162,581,
  	0,3912,3913,5,713,0,0,3913,3914,5,750,0,0,3914,3941,3,1140,570,0,3915,
  	3916,5,319,0,0,3916,3917,5,750,0,0,3917,3941,3,1140,570,0,3918,3919,5,
  	233,0,0,3919,3920,5,750,0,0,3920,3941,3,462,231,0,3921,3922,5,735,0,0,
  	3922,3923,5,750,0,0,3923,3941,3,1154,577,0,3924,3925,5,736,0,0,3925,3926,
  	5,750,0,0,3926,3941,3,1140,570,0,3927,3928,5,296,0,0,3928,3929,5,750,
  	0,0,3929,3941,3,1140,570,0,3930,3931,5,737,0,0,3931,3932,5,750,0,0,3932,
  	3941,3,454,227,0,3933,3934,5,739,0,0,3934,3935,5,750,0,0,3935,3941,3,
  	1140,570,0,3936,3937,5,742,0,0,3937,3938,5,750,0,0,3938,3941,3,456,228,
  	0,3939,3941,3,460,230,0,3940,3849,1,0,0,0,3940,3852,1,0,0,0,3940,3855,
  	1,0,0,0,3940,3858,1,0,0,0,3940,3861,1,0,0,0,3940,3864,1,0,0,0,3940,3867,
  	1,0,0,0,3940,3870,1,0,0,0,3940,3873,1,0,0,0,3940,3876,1,0,0,0,3940,3879,
  	1,0,0,0,3940,3882,1,0,0,0,3940,3885,1,0,0,0,3940,3888,1,0,0,0,3940,3891,
  	1,0,0,0,3940,3894,1,0,0,0,3940,3897,1,0,0,0,3940,3900,1,0,0,0,3940,3903,
  	1,0,0,0,3940,3906,1,0,0,0,3940,3909,1,0,0,0,3940,3912,1,0,0,0,3940,3915,
  	1,0,0,0,3940,3918,1,0,0,0,3940,3921,1,0,0,0,3940,3924,1,0,0,0,3940,3927,
  	1,0,0,0,3940,3930,1,0,0,0,3940,3933,1,0,0,0,3940,3936,1,0,0,0,3940,3939,
  	1,0,0,0,3941,453,1,0,0,0,3942,3945,3,1024,512,0,3943,3945,5,376,0,0,3944,
  	3942,1,0,0,0,3944,3943,1,0,0,0,3945,455,1,0,0,0,3946,3947,7,43,0,0,3947,
  	457,1,0,0,0,3948,3951,3,1162,581,0,3949,3951,5,376,0,0,3950,3948,1,0,
  	0,0,3950,3949,1,0,0,0,3951,459,1,0,0,0,3952,3953,5,301,0,0,3953,3954,
  	5,750,0,0,3954,3965,3,1162,581,0,3955,3956,5,302,0,0,3956,3957,5,750,
  	0,0,3957,3965,3,1144,572,0,3958,3959,5,447,0,0,3959,3960,5,750,0,0,3960,
  	3965,3,1162,581,0,3961,3962,5,448,0,0,3962,3963,5,750,0,0,3963,3965,3,
  	1140,570,0,3964,3952,1,0,0,0,3964,3955,1,0,0,0,3964,3958,1,0,0,0,3964,
  	3961,1,0,0,0,3965,461,1,0,0,0,3966,3975,5,776,0,0,3967,3972,3,1140,570,
  	0,3968,3969,5,773,0,0,3969,3971,3,1140,570,0,3970,3968,1,0,0,0,3971,3974,
  	1,0,0,0,3972,3970,1,0,0,0,3972,3973,1,0,0,0,3973,3976,1,0,0,0,3974,3972,
  	1,0,0,0,3975,3967,1,0,0,0,3975,3976,1,0,0,0,3976,3977,1,0,0,0,3977,3978,
  	5,777,0,0,3978,463,1,0,0,0,3979,3980,5,55,0,0,3980,3981,5,459,0,0,3981,
  	3982,5,190,0,0,3982,3987,3,466,233,0,3983,3984,5,773,0,0,3984,3986,3,
  	466,233,0,3985,3983,1,0,0,0,3986,3989,1,0,0,0,3987,3985,1,0,0,0,3987,
  	3988,1,0,0,0,3988,3992,1,0,0,0,3989,3987,1,0,0,0,3990,3991,4,232,74,0,
  	3991,3993,3,782,391,0,3992,3990,1,0,0,0,3992,3993,1,0,0,0,3993,465,1,
  	0,0,0,3994,3995,5,460,0,0,3995,3996,5,750,0,0,3996,3998,5,776,0,0,3997,
  	3999,3,468,234,0,3998,3997,1,0,0,0,3998,3999,1,0,0,0,3999,4000,1,0,0,
  	0,4000,4044,5,777,0,0,4001,4002,5,461,0,0,4002,4003,5,750,0,0,4003,4005,
  	5,776,0,0,4004,4006,3,468,234,0,4005,4004,1,0,0,0,4005,4006,1,0,0,0,4006,
  	4007,1,0,0,0,4007,4044,5,777,0,0,4008,4009,5,462,0,0,4009,4010,5,750,
  	0,0,4010,4012,5,776,0,0,4011,4013,3,470,235,0,4012,4011,1,0,0,0,4012,
  	4013,1,0,0,0,4013,4014,1,0,0,0,4014,4044,5,777,0,0,4015,4016,5,463,0,
  	0,4016,4017,5,750,0,0,4017,4019,5,776,0,0,4018,4020,3,470,235,0,4019,
  	4018,1,0,0,0,4019,4020,1,0,0,0,4020,4021,1,0,0,0,4021,4044,5,777,0,0,
  	4022,4023,5,464,0,0,4023,4024,5,750,0,0,4024,4026,5,776,0,0,4025,4027,
  	3,472,236,0,4026,4025,1,0,0,0,4026,4027,1,0,0,0,4027,4028,1,0,0,0,4028,
  	4044,5,777,0,0,4029,4030,5,465,0,0,4030,4031,5,750,0,0,4031,4033,5,776,
  	0,0,4032,4034,3,472,236,0,4033,4032,1,0,0,0,4033,4034,1,0,0,0,4034,4035,
  	1,0,0,0,4035,4044,5,777,0,0,4036,4037,5,466,0,0,4037,4038,5,750,0,0,4038,
  	4040,5,776,0,0,4039,4041,3,476,238,0,4040,4039,1,0,0,0,4040,4041,1,0,
  	0,0,4041,4042,1,0,0,0,4042,4044,5,777,0,0,4043,3994,1,0,0,0,4043,4001,
  	1,0,0,0,4043,4008,1,0,0,0,4043,4015,1,0,0,0,4043,4022,1,0,0,0,4043,4029,
  	1,0,0,0,4043,4036,1,0,0,0,4044,467,1,0,0,0,4045,4050,3,1058,529,0,4046,
  	4047,5,773,0,0,4047,4049,3,1058,529,0,4048,4046,1,0,0,0,4049,4052,1,0,
  	0,0,4050,4048,1,0,0,0,4050,4051,1,0,0,0,4051,469,1,0,0,0,4052,4050,1,
  	0,0,0,4053,4058,3,1098,549,0,4054,4055,5,773,0,0,4055,4057,3,1098,549,
  	0,4056,4054,1,0,0,0,4057,4060,1,0,0,0,4058,4056,1,0,0,0,4058,4059,1,0,
  	0,0,4059,471,1,0,0,0,4060,4058,1,0,0,0,4061,4066,3,474,237,0,4062,4063,
  	5,773,0,0,4063,4065,3,474,237,0,4064,4062,1,0,0,0,4065,4068,1,0,0,0,4066,
  	4064,1,0,0,0,4066,4067,1,0,0,0,4067,473,1,0,0,0,4068,4066,1,0,0,0,4069,
  	4070,3,1162,581,0,4070,475,1,0,0,0,4071,4076,3,990,495,0,4072,4073,5,
  	773,0,0,4073,4075,3,990,495,0,4074,4072,1,0,0,0,4075,4078,1,0,0,0,4076,
  	4074,1,0,0,0,4076,4077,1,0,0,0,4077,477,1,0,0,0,4078,4076,1,0,0,0,4079,
  	4080,5,543,0,0,4080,4082,5,514,0,0,4081,4083,3,484,242,0,4082,4081,1,
  	0,0,0,4082,4083,1,0,0,0,4083,4086,1,0,0,0,4084,4085,5,613,0,0,4085,4087,
  	3,480,240,0,4086,4084,1,0,0,0,4086,4087,1,0,0,0,4087,4088,1,0,0,0,4088,
  	4090,3,482,241,0,4089,4091,3,782,391,0,4090,4089,1,0,0,0,4090,4091,1,
  	0,0,0,4091,4101,1,0,0,0,4092,4093,5,552,0,0,4093,4095,5,514,0,0,4094,
  	4096,3,484,242,0,4095,4094,1,0,0,0,4095,4096,1,0,0,0,4096,4098,1,0,0,
  	0,4097,4099,3,782,391,0,4098,4097,1,0,0,0,4098,4099,1,0,0,0,4099,4101,
  	1,0,0,0,4100,4079,1,0,0,0,4100,4092,1,0,0,0,4101,479,1,0,0,0,4102,4110,
  	3,460,230,0,4103,4104,4,240,75,0,4104,4105,7,44,0,0,4105,4106,5,750,0,
  	0,4106,4110,3,1156,578,0,4107,4108,4,240,76,0,4108,4110,5,529,0,0,4109,
  	4102,1,0,0,0,4109,4103,1,0,0,0,4109,4107,1,0,0,0,4110,4115,1,0,0,0,4111,
  	4112,5,773,0,0,4112,4114,3,460,230,0,4113,4111,1,0,0,0,4114,4117,1,0,
  	0,0,4115,4113,1,0,0,0,4115,4116,1,0,0,0,4116,481,1,0,0,0,4117,4115,1,
  	0,0,0,4118,4122,4,241,77,0,4119,4120,5,618,0,0,4120,4121,5,750,0,0,4121,
  	4123,3,1156,578,0,4122,4119,1,0,0,0,4122,4123,1,0,0,0,4123,4127,1,0,0,
  	0,4124,4125,5,406,0,0,4125,4126,5,750,0,0,4126,4128,3,1156,578,0,4127,
  	4124,1,0,0,0,4127,4128,1,0,0,0,4128,4132,1,0,0,0,4129,4130,5,129,0,0,
  	4130,4131,5,750,0,0,4131,4133,3,1156,578,0,4132,4129,1,0,0,0,4132,4133,
  	1,0,0,0,4133,4137,1,0,0,0,4134,4135,5,409,0,0,4135,4136,5,750,0,0,4136,
  	4138,3,1156,578,0,4137,4134,1,0,0,0,4137,4138,1,0,0,0,4138,4141,1,0,0,
  	0,4139,4141,1,0,0,0,4140,4118,1,0,0,0,4140,4139,1,0,0,0,4141,483,1,0,
  	0,0,4142,4147,3,486,243,0,4143,4144,5,773,0,0,4144,4146,3,486,243,0,4145,
  	4143,1,0,0,0,4146,4149,1,0,0,0,4147,4145,1,0,0,0,4147,4148,1,0,0,0,4148,
  	485,1,0,0,0,4149,4147,1,0,0,0,4150,4151,7,45,0,0,4151,487,1,0,0,0,4152,
  	4153,7,46,0,0,4153,4154,5,210,0,0,4154,489,1,0,0,0,4155,4156,5,417,0,
  	0,4156,4157,3,1128,564,0,4157,4160,5,203,0,0,4158,4161,3,1160,580,0,4159,
  	4161,3,742,371,0,4160,4158,1,0,0,0,4160,4159,1,0,0,0,4161,4167,1,0,0,
  	0,4162,4167,3,492,246,0,4163,4164,7,47,0,0,4164,4165,5,417,0,0,4165,4167,
  	3,1128,564,0,4166,4155,1,0,0,0,4166,4162,1,0,0,0,4166,4163,1,0,0,0,4167,
  	491,1,0,0,0,4168,4169,5,173,0,0,4169,4172,3,1128,564,0,4170,4171,5,621,
  	0,0,4171,4173,3,494,247,0,4172,4170,1,0,0,0,4172,4173,1,0,0,0,4173,493,
  	1,0,0,0,4174,4179,3,742,371,0,4175,4176,5,773,0,0,4176,4178,3,742,371,
  	0,4177,4175,1,0,0,0,4178,4181,1,0,0,0,4179,4177,1,0,0,0,4179,4180,1,0,
  	0,0,4180,495,1,0,0,0,4181,4179,1,0,0,0,4182,4207,5,677,0,0,4183,4184,
  	5,284,0,0,4184,4185,5,112,0,0,4185,4187,5,139,0,0,4186,4188,3,1190,595,
  	0,4187,4186,1,0,0,0,4187,4188,1,0,0,0,4188,4189,1,0,0,0,4189,4208,3,1154,
  	577,0,4190,4193,5,676,0,0,4191,4192,5,200,0,0,4192,4194,5,459,0,0,4193,
  	4191,1,0,0,0,4193,4194,1,0,0,0,4194,4208,1,0,0,0,4195,4196,4,248,78,0,
  	4196,4197,5,244,0,0,4197,4198,5,203,0,0,4198,4199,3,1026,513,0,4199,4200,
  	5,775,0,0,4200,4201,3,1140,570,0,4201,4202,5,230,0,0,4202,4203,5,45,0,
  	0,4203,4205,3,1154,577,0,4204,4206,3,498,249,0,4205,4204,1,0,0,0,4205,
  	4206,1,0,0,0,4206,4208,1,0,0,0,4207,4183,1,0,0,0,4207,4190,1,0,0,0,4207,
  	4195,1,0,0,0,4208,497,1,0,0,0,4209,4220,3,500,250,0,4210,4211,5,112,0,
  	0,4211,4213,5,139,0,0,4212,4214,3,1190,595,0,4213,4212,1,0,0,0,4213,4214,
  	1,0,0,0,4214,4215,1,0,0,0,4215,4217,3,1154,577,0,4216,4218,3,500,250,
  	0,4217,4216,1,0,0,0,4217,4218,1,0,0,0,4218,4220,1,0,0,0,4219,4209,1,0,
  	0,0,4219,4210,1,0,0,0,4220,499,1,0,0,0,4221,4223,5,467,0,0,4222,4224,
  	5,373,0,0,4223,4222,1,0,0,0,4223,4224,1,0,0,0,4224,4225,1,0,0,0,4225,
  	4226,5,539,0,0,4226,501,1,0,0,0,4227,4228,4,251,79,0,4228,4237,3,504,
  	252,0,4229,4237,3,510,255,0,4230,4237,3,522,261,0,4231,4237,3,524,262,
  	0,4232,4237,3,538,269,0,4233,4237,3,540,270,0,4234,4235,4,251,80,0,4235,
  	4237,3,558,279,0,4236,4227,1,0,0,0,4236,4229,1,0,0,0,4236,4230,1,0,0,
  	0,4236,4231,1,0,0,0,4236,4232,1,0,0,0,4236,4233,1,0,0,0,4236,4234,1,0,
  	0,0,4237,503,1,0,0,0,4238,4239,5,11,0,0,4239,4242,5,618,0,0,4240,4241,
  	4,252,81,0,4241,4243,3,978,489,0,4242,4240,1,0,0,0,4242,4243,1,0,0,0,
  	4243,4244,1,0,0,0,4244,4245,3,506,253,0,4245,505,1,0,0,0,4246,4247,4,
  	253,82,0,4247,4251,3,1010,505,0,4248,4249,4,253,83,0,4249,4251,3,1012,
  	506,0,4250,4246,1,0,0,0,4250,4248,1,0,0,0,4251,4252,1,0,0,0,4252,4253,
  	3,512,256,0,4253,4301,1,0,0,0,4254,4255,4,253,84,0,4255,4256,3,1026,513,
  	0,4256,4257,5,230,0,0,4257,4258,5,45,0,0,4258,4261,3,1156,578,0,4259,
  	4260,4,253,85,0,4260,4262,3,1022,511,0,4261,4259,1,0,0,0,4261,4262,1,
  	0,0,0,4262,4265,1,0,0,0,4263,4264,4,253,86,0,4264,4266,3,1018,509,0,4265,
  	4263,1,0,0,0,4265,4266,1,0,0,0,4266,4301,1,0,0,0,4267,4268,4,253,87,0,
  	4268,4269,3,1026,513,0,4269,4270,3,1020,510,0,4270,4301,1,0,0,0,4271,
  	4272,4,253,88,0,4272,4273,3,1026,513,0,4273,4274,5,128,0,0,4274,4278,
  	5,659,0,0,4275,4279,5,10,0,0,4276,4279,5,369,0,0,4277,4279,3,560,280,
  	0,4278,4275,1,0,0,0,4278,4276,1,0,0,0,4278,4277,1,0,0,0,4279,4301,1,0,
  	0,0,4280,4281,4,253,89,0,4281,4282,3,1026,513,0,4282,4285,5,230,0,0,4283,
  	4284,5,645,0,0,4284,4286,3,1180,590,0,4285,4283,1,0,0,0,4285,4286,1,0,
  	0,0,4286,4287,1,0,0,0,4287,4288,5,45,0,0,4288,4289,5,734,0,0,4289,4291,
  	5,406,0,0,4290,4292,3,1018,509,0,4291,4290,1,0,0,0,4291,4292,1,0,0,0,
  	4292,4301,1,0,0,0,4293,4294,5,741,0,0,4294,4301,3,1142,571,0,4295,4298,
  	5,740,0,0,4296,4299,3,1142,571,0,4297,4299,5,698,0,0,4298,4296,1,0,0,
  	0,4298,4297,1,0,0,0,4299,4301,1,0,0,0,4300,4250,1,0,0,0,4300,4254,1,0,
  	0,0,4300,4267,1,0,0,0,4300,4271,1,0,0,0,4300,4280,1,0,0,0,4300,4293,1,
  	0,0,0,4300,4295,1,0,0,0,4301,507,1,0,0,0,4302,4303,5,618,0,0,4303,4304,
  	3,1188,594,0,4304,509,1,0,0,0,4305,4306,5,97,0,0,4306,4310,5,618,0,0,
  	4307,4308,4,255,90,0,4308,4311,3,980,490,0,4309,4311,1,0,0,0,4310,4307,
  	1,0,0,0,4310,4309,1,0,0,0,4311,4312,1,0,0,0,4312,4313,3,1010,505,0,4313,
  	4314,3,514,257,0,4314,4315,3,512,256,0,4315,511,1,0,0,0,4316,4318,4,256,
  	91,0,4317,4319,3,516,258,0,4318,4317,1,0,0,0,4318,4319,1,0,0,0,4319,4321,
  	1,0,0,0,4320,4322,3,518,259,0,4321,4320,1,0,0,0,4321,4322,1,0,0,0,4322,
  	4326,1,0,0,0,4323,4325,3,520,260,0,4324,4323,1,0,0,0,4325,4328,1,0,0,
  	0,4326,4324,1,0,0,0,4326,4327,1,0,0,0,4327,4331,1,0,0,0,4328,4326,1,0,
  	0,0,4329,4331,1,0,0,0,4330,4316,1,0,0,0,4330,4329,1,0,0,0,4331,513,1,
  	0,0,0,4332,4336,4,257,92,0,4333,4334,5,128,0,0,4334,4335,5,659,0,0,4335,
  	4337,3,560,280,0,4336,4333,1,0,0,0,4336,4337,1,0,0,0,4337,4340,1,0,0,
  	0,4338,4340,1,0,0,0,4339,4332,1,0,0,0,4339,4338,1,0,0,0,4340,515,1,0,
  	0,0,4341,4344,5,467,0,0,4342,4345,3,552,276,0,4343,4345,7,48,0,0,4344,
  	4342,1,0,0,0,4344,4343,1,0,0,0,4345,517,1,0,0,0,4346,4355,5,645,0,0,4347,
  	4348,5,322,0,0,4348,4356,3,1140,570,0,4349,4350,5,327,0,0,4350,4356,3,
  	1140,570,0,4351,4352,5,321,0,0,4352,4356,3,1140,570,0,4353,4354,5,328,
  	0,0,4354,4356,3,1140,570,0,4355,4347,1,0,0,0,4355,4349,1,0,0,0,4355,4351,
  	1,0,0,0,4355,4353,1,0,0,0,4356,4357,1,0,0,0,4357,4355,1,0,0,0,4357,4358,
  	1,0,0,0,4358,519,1,0,0,0,4359,4360,5,2,0,0,4360,4393,7,49,0,0,4361,4390,
  	5,406,0,0,4362,4369,5,177,0,0,4363,4364,5,247,0,0,4364,4365,3,1142,571,
  	0,4365,4366,5,122,0,0,4366,4370,1,0,0,0,4367,4370,5,365,0,0,4368,4370,
  	5,128,0,0,4369,4363,1,0,0,0,4369,4367,1,0,0,0,4369,4368,1,0,0,0,4369,
  	4370,1,0,0,0,4370,4391,1,0,0,0,4371,4374,5,705,0,0,4372,4375,3,1142,571,
  	0,4373,4375,5,128,0,0,4374,4372,1,0,0,0,4374,4373,1,0,0,0,4375,4391,1,
  	0,0,0,4376,4377,5,706,0,0,4377,4382,5,247,0,0,4378,4379,3,1142,571,0,
  	4379,4380,5,122,0,0,4380,4383,1,0,0,0,4381,4383,5,128,0,0,4382,4378,1,
  	0,0,0,4382,4381,1,0,0,0,4383,4391,1,0,0,0,4384,4385,4,260,93,0,4385,4386,
  	5,467,0,0,4386,4388,5,101,0,0,4387,4389,7,50,0,0,4388,4387,1,0,0,0,4388,
  	4389,1,0,0,0,4389,4391,1,0,0,0,4390,4362,1,0,0,0,4390,4371,1,0,0,0,4390,
  	4376,1,0,0,0,4390,4384,1,0,0,0,4391,4393,1,0,0,0,4392,4359,1,0,0,0,4392,
  	4361,1,0,0,0,4393,521,1,0,0,0,4394,4395,5,148,0,0,4395,4398,5,618,0,0,
  	4396,4397,4,261,94,0,4397,4399,3,978,489,0,4398,4396,1,0,0,0,4398,4399,
  	1,0,0,0,4399,4400,1,0,0,0,4400,4401,3,1008,504,0,4401,523,1,0,0,0,4402,
  	4445,5,215,0,0,4403,4404,4,262,95,0,4404,4405,3,546,273,0,4405,4406,5,
  	590,0,0,4406,4410,3,1008,504,0,4407,4408,5,645,0,0,4408,4409,5,660,0,
  	0,4409,4411,5,391,0,0,4410,4407,1,0,0,0,4410,4411,1,0,0,0,4411,4446,1,
  	0,0,0,4412,4418,3,546,273,0,4413,4415,5,10,0,0,4414,4416,5,421,0,0,4415,
  	4414,1,0,0,0,4415,4416,1,0,0,0,4416,4418,1,0,0,0,4417,4412,1,0,0,0,4417,
  	4413,1,0,0,0,4418,4419,1,0,0,0,4419,4421,5,383,0,0,4420,4422,3,544,272,
  	0,4421,4420,1,0,0,0,4421,4422,1,0,0,0,4422,4423,1,0,0,0,4423,4424,3,550,
  	275,0,4424,4425,5,590,0,0,4425,4427,3,526,263,0,4426,4428,3,536,268,0,
  	4427,4426,1,0,0,0,4427,4428,1,0,0,0,4428,4430,1,0,0,0,4429,4431,3,528,
  	264,0,4430,4429,1,0,0,0,4430,4431,1,0,0,0,4431,4433,1,0,0,0,4432,4434,
  	3,534,267,0,4433,4432,1,0,0,0,4433,4434,1,0,0,0,4434,4446,1,0,0,0,4435,
  	4436,5,427,0,0,4436,4437,5,383,0,0,4437,4438,3,1026,513,0,4438,4439,5,
  	590,0,0,4439,4443,3,526,263,0,4440,4441,5,645,0,0,4441,4442,5,215,0,0,
  	4442,4444,5,391,0,0,4443,4440,1,0,0,0,4443,4444,1,0,0,0,4444,4446,1,0,
  	0,0,4445,4403,1,0,0,0,4445,4417,1,0,0,0,4445,4435,1,0,0,0,4446,525,1,
  	0,0,0,4447,4448,4,263,96,0,4448,4452,3,1010,505,0,4449,4450,4,263,97,
  	0,4450,4452,3,1008,504,0,4451,4447,1,0,0,0,4451,4449,1,0,0,0,4452,527,
  	1,0,0,0,4453,4454,4,264,98,0,4454,4456,5,645,0,0,4455,4457,3,556,278,
  	0,4456,4455,1,0,0,0,4457,4458,1,0,0,0,4458,4456,1,0,0,0,4458,4459,1,0,
  	0,0,4459,4465,1,0,0,0,4460,4461,4,264,99,0,4461,4462,5,645,0,0,4462,4463,
  	5,215,0,0,4463,4465,5,391,0,0,4464,4453,1,0,0,0,4464,4460,1,0,0,0,4465,
  	529,1,0,0,0,4466,4467,5,663,0,0,4467,4468,3,560,280,0,4468,531,1,0,0,
  	0,4469,4470,5,645,0,0,4470,4478,5,659,0,0,4471,4479,3,560,280,0,4472,
  	4474,5,10,0,0,4473,4475,3,530,265,0,4474,4473,1,0,0,0,4474,4475,1,0,0,
  	0,4475,4479,1,0,0,0,4476,4479,5,369,0,0,4477,4479,5,128,0,0,4478,4471,
  	1,0,0,0,4478,4472,1,0,0,0,4478,4476,1,0,0,0,4478,4477,1,0,0,0,4479,533,
  	1,0,0,0,4480,4481,5,17,0,0,4481,4483,5,618,0,0,4482,4484,3,532,266,0,
  	4483,4482,1,0,0,0,4483,4484,1,0,0,0,4484,535,1,0,0,0,4485,4486,4,268,
  	100,0,4486,4487,3,516,258,0,4487,537,1,0,0,0,4488,4489,5,453,0,0,4489,
  	4490,5,618,0,0,4490,4491,3,1026,513,0,4491,4492,5,590,0,0,4492,4500,3,
  	1026,513,0,4493,4494,5,773,0,0,4494,4495,3,1026,513,0,4495,4496,5,590,
  	0,0,4496,4497,3,1026,513,0,4497,4499,1,0,0,0,4498,4493,1,0,0,0,4499,4502,
  	1,0,0,0,4500,4498,1,0,0,0,4500,4501,1,0,0,0,4501,539,1,0,0,0,4502,4500,
  	1,0,0,0,4503,4537,5,477,0,0,4504,4505,4,270,101,0,4505,4506,3,546,273,
  	0,4506,4507,5,203,0,0,4507,4508,3,1008,504,0,4508,4538,1,0,0,0,4509,4510,
  	3,546,273,0,4510,4511,3,542,271,0,4511,4512,5,203,0,0,4512,4513,3,1008,
  	504,0,4513,4538,1,0,0,0,4514,4516,5,10,0,0,4515,4517,5,421,0,0,4516,4515,
  	1,0,0,0,4516,4517,1,0,0,0,4517,4529,1,0,0,0,4518,4519,4,270,102,0,4519,
  	4521,5,383,0,0,4520,4522,3,544,272,0,4521,4520,1,0,0,0,4521,4522,1,0,
  	0,0,4522,4523,1,0,0,0,4523,4530,3,550,275,0,4524,4525,5,773,0,0,4525,
  	4526,5,215,0,0,4526,4527,5,391,0,0,4527,4528,5,203,0,0,4528,4530,3,1008,
  	504,0,4529,4518,1,0,0,0,4529,4524,1,0,0,0,4530,4538,1,0,0,0,4531,4532,
  	5,427,0,0,4532,4533,5,383,0,0,4533,4534,3,1026,513,0,4534,4535,5,203,
  	0,0,4535,4536,3,1008,504,0,4536,4538,1,0,0,0,4537,4504,1,0,0,0,4537,4509,
  	1,0,0,0,4537,4514,1,0,0,0,4537,4531,1,0,0,0,4538,541,1,0,0,0,4539,4540,
  	4,271,103,0,4540,4542,5,383,0,0,4541,4543,3,544,272,0,4542,4541,1,0,0,
  	0,4542,4543,1,0,0,0,4543,4544,1,0,0,0,4544,4554,3,550,275,0,4545,4551,
  	4,271,104,0,4546,4548,5,383,0,0,4547,4549,3,544,272,0,4548,4547,1,0,0,
  	0,4548,4549,1,0,0,0,4549,4550,1,0,0,0,4550,4552,3,550,275,0,4551,4546,
  	1,0,0,0,4551,4552,1,0,0,0,4552,4554,1,0,0,0,4553,4539,1,0,0,0,4553,4545,
  	1,0,0,0,4554,543,1,0,0,0,4555,4556,7,51,0,0,4556,545,1,0,0,0,4557,4562,
  	3,548,274,0,4558,4559,5,773,0,0,4559,4561,3,548,274,0,4560,4558,1,0,0,
  	0,4561,4564,1,0,0,0,4562,4560,1,0,0,0,4562,4563,1,0,0,0,4563,547,1,0,
  	0,0,4564,4562,1,0,0,0,4565,4576,4,274,105,0,4566,4568,3,1184,592,0,4567,
  	4569,3,1044,522,0,4568,4567,1,0,0,0,4568,4569,1,0,0,0,4569,4577,1,0,0,
  	0,4570,4574,3,1184,592,0,4571,4575,5,784,0,0,4572,4573,5,783,0,0,4573,
  	4575,3,1180,590,0,4574,4571,1,0,0,0,4574,4572,1,0,0,0,4575,4577,1,0,0,
  	0,4576,4566,1,0,0,0,4576,4570,1,0,0,0,4577,4607,1,0,0,0,4578,4580,7,52,
  	0,0,4579,4581,3,1044,522,0,4580,4579,1,0,0,0,4580,4581,1,0,0,0,4581,4607,
  	1,0,0,0,4582,4607,7,53,0,0,4583,4584,5,215,0,0,4584,4607,5,391,0,0,4585,
  	4586,5,509,0,0,4586,4607,5,110,0,0,4587,4591,5,97,0,0,4588,4589,5,577,
  	0,0,4589,4592,5,571,0,0,4590,4592,7,54,0,0,4591,4588,1,0,0,0,4591,4590,
  	1,0,0,0,4591,4592,1,0,0,0,4592,4607,1,0,0,0,4593,4594,5,287,0,0,4594,
  	4607,5,571,0,0,4595,4596,5,459,0,0,4596,4607,7,55,0,0,4597,4598,5,509,
  	0,0,4598,4607,5,636,0,0,4599,4601,5,11,0,0,4600,4602,5,483,0,0,4601,4600,
  	1,0,0,0,4601,4602,1,0,0,0,4602,4607,1,0,0,0,4603,4604,4,274,106,0,4604,
  	4605,7,56,0,0,4605,4607,5,659,0,0,4606,4565,1,0,0,0,4606,4578,1,0,0,0,
  	4606,4582,1,0,0,0,4606,4583,1,0,0,0,4606,4585,1,0,0,0,4606,4587,1,0,0,
  	0,4606,4593,1,0,0,0,4606,4595,1,0,0,0,4606,4597,1,0,0,0,4606,4599,1,0,
  	0,0,4606,4603,1,0,0,0,4607,549,1,0,0,0,4608,4611,5,760,0,0,4609,4610,
  	5,772,0,0,4610,4612,5,760,0,0,4611,4609,1,0,0,0,4611,4612,1,0,0,0,4612,
  	4625,1,0,0,0,4613,4616,3,1058,529,0,4614,4615,5,772,0,0,4615,4617,5,760,
  	0,0,4616,4614,1,0,0,0,4616,4617,1,0,0,0,4617,4625,1,0,0,0,4618,4625,3,
  	1102,551,0,4619,4620,4,275,107,0,4620,4621,3,1058,529,0,4621,4622,5,772,
  	0,0,4622,4623,3,1102,551,0,4623,4625,1,0,0,0,4624,4608,1,0,0,0,4624,4613,
  	1,0,0,0,4624,4618,1,0,0,0,4624,4619,1,0,0,0,4625,551,1,0,0,0,4626,4633,
  	3,554,277,0,4627,4629,5,15,0,0,4628,4627,1,0,0,0,4628,4629,1,0,0,0,4629,
  	4630,1,0,0,0,4630,4632,3,554,277,0,4631,4628,1,0,0,0,4632,4635,1,0,0,
  	0,4633,4631,1,0,0,0,4633,4634,1,0,0,0,4634,553,1,0,0,0,4635,4633,1,0,
  	0,0,4636,4637,5,63,0,0,4637,4643,3,1156,578,0,4638,4639,5,259,0,0,4639,
  	4643,3,1156,578,0,4640,4641,5,559,0,0,4641,4643,3,1156,578,0,4642,4636,
  	1,0,0,0,4642,4638,1,0,0,0,4642,4640,1,0,0,0,4643,555,1,0,0,0,4644,4645,
  	5,215,0,0,4645,4655,5,391,0,0,4646,4647,5,322,0,0,4647,4655,3,1140,570,
  	0,4648,4649,5,327,0,0,4649,4655,3,1140,570,0,4650,4651,5,321,0,0,4651,
  	4655,3,1140,570,0,4652,4653,5,328,0,0,4653,4655,3,1140,570,0,4654,4644,
  	1,0,0,0,4654,4646,1,0,0,0,4654,4648,1,0,0,0,4654,4650,1,0,0,0,4654,4652,
  	1,0,0,0,4655,557,1,0,0,0,4656,4657,5,506,0,0,4657,4658,5,659,0,0,4658,
  	4680,3,560,280,0,4659,4660,5,506,0,0,4660,4661,5,659,0,0,4661,4680,7,
  	57,0,0,4662,4663,5,506,0,0,4663,4664,5,128,0,0,4664,4668,5,659,0,0,4665,
  	4669,3,560,280,0,4666,4669,5,369,0,0,4667,4669,5,10,0,0,4668,4665,1,0,
  	0,0,4668,4666,1,0,0,0,4668,4667,1,0,0,0,4669,4670,1,0,0,0,4670,4671,5,
  	590,0,0,4671,4680,3,560,280,0,4672,4673,5,506,0,0,4673,4674,5,659,0,0,
  	4674,4677,5,10,0,0,4675,4676,5,663,0,0,4676,4678,3,560,280,0,4677,4675,
  	1,0,0,0,4677,4678,1,0,0,0,4678,4680,1,0,0,0,4679,4656,1,0,0,0,4679,4659,
  	1,0,0,0,4679,4662,1,0,0,0,4679,4672,1,0,0,0,4680,559,1,0,0,0,4681,4686,
  	3,562,281,0,4682,4683,5,773,0,0,4683,4685,3,562,281,0,4684,4682,1,0,0,
  	0,4685,4688,1,0,0,0,4686,4684,1,0,0,0,4686,4687,1,0,0,0,4687,561,1,0,
  	0,0,4688,4686,1,0,0,0,4689,4693,3,1184,592,0,4690,4691,5,783,0,0,4691,
  	4694,3,1180,590,0,4692,4694,5,784,0,0,4693,4690,1,0,0,0,4693,4692,1,0,
  	0,0,4693,4694,1,0,0,0,4694,563,1,0,0,0,4695,4697,5,14,0,0,4696,4698,3,
  	1034,517,0,4697,4696,1,0,0,0,4697,4698,1,0,0,0,4698,4699,1,0,0,0,4699,
  	4700,5,574,0,0,4700,4703,3,1104,552,0,4701,4702,4,282,108,0,4702,4704,
  	3,566,283,0,4703,4701,1,0,0,0,4703,4704,1,0,0,0,4704,4739,1,0,0,0,4705,
  	4706,5,62,0,0,4706,4707,5,574,0,0,4707,4711,3,1104,552,0,4708,4710,3,
  	568,284,0,4709,4708,1,0,0,0,4710,4713,1,0,0,0,4711,4709,1,0,0,0,4711,
  	4712,1,0,0,0,4712,4739,1,0,0,0,4713,4711,1,0,0,0,4714,4715,5,61,0,0,4715,
  	4716,5,574,0,0,4716,4718,3,1104,552,0,4717,4719,7,58,0,0,4718,4717,1,
  	0,0,0,4718,4719,1,0,0,0,4719,4739,1,0,0,0,4720,4722,5,388,0,0,4721,4723,
  	3,1034,517,0,4722,4721,1,0,0,0,4722,4723,1,0,0,0,4723,4724,1,0,0,0,4724,
  	4725,5,574,0,0,4725,4739,3,1104,552,0,4726,4728,5,455,0,0,4727,4729,3,
  	1034,517,0,4728,4727,1,0,0,0,4728,4729,1,0,0,0,4729,4730,1,0,0,0,4730,
  	4731,5,574,0,0,4731,4735,3,1104,552,0,4732,4734,3,570,285,0,4733,4732,
  	1,0,0,0,4734,4737,1,0,0,0,4735,4733,1,0,0,0,4735,4736,1,0,0,0,4736,4739,
  	1,0,0,0,4737,4735,1,0,0,0,4738,4695,1,0,0,0,4738,4705,1,0,0,0,4738,4714,
  	1,0,0,0,4738,4720,1,0,0,0,4738,4726,1,0,0,0,4739,565,1,0,0,0,4740,4741,
  	5,614,0,0,4741,4742,5,674,0,0,4742,4743,5,383,0,0,4743,4747,3,1130,565,
  	0,4744,4745,5,645,0,0,4745,4746,5,747,0,0,4746,4748,5,675,0,0,4747,4744,
  	1,0,0,0,4747,4748,1,0,0,0,4748,4754,1,0,0,0,4749,4750,5,148,0,0,4750,
  	4751,5,674,0,0,4751,4752,5,383,0,0,4752,4754,3,1130,565,0,4753,4740,1,
  	0,0,0,4753,4749,1,0,0,0,4754,567,1,0,0,0,4755,4756,5,200,0,0,4756,4759,
  	5,615,0,0,4757,4759,7,59,0,0,4758,4755,1,0,0,0,4758,4757,1,0,0,0,4759,
  	569,1,0,0,0,4760,4761,7,60,0,0,4761,571,1,0,0,0,4762,4763,5,245,0,0,4763,
  	4764,5,410,0,0,4764,4765,3,1128,564,0,4765,4766,5,520,0,0,4766,4767,3,
  	1154,577,0,4767,4785,1,0,0,0,4768,4769,5,245,0,0,4769,4770,5,664,0,0,
  	4770,4785,3,1164,582,0,4771,4772,5,607,0,0,4772,4773,5,410,0,0,4773,4785,
  	3,1118,559,0,4774,4775,5,607,0,0,4775,4776,5,664,0,0,4776,4781,3,1120,
  	560,0,4777,4778,5,773,0,0,4778,4780,3,1120,560,0,4779,4777,1,0,0,0,4780,
  	4783,1,0,0,0,4781,4779,1,0,0,0,4781,4782,1,0,0,0,4782,4785,1,0,0,0,4783,
  	4781,1,0,0,0,4784,4762,1,0,0,0,4784,4768,1,0,0,0,4784,4771,1,0,0,0,4784,
  	4774,1,0,0,0,4785,573,1,0,0,0,4786,4787,5,506,0,0,4787,4788,3,576,288,
  	0,4788,575,1,0,0,0,4789,4790,3,586,293,0,4790,4791,3,584,292,0,4791,4846,
  	1,0,0,0,4792,4793,5,592,0,0,4793,4846,3,578,289,0,4794,4795,3,1192,596,
  	0,4795,4796,3,592,296,0,4796,4846,1,0,0,0,4797,4800,5,406,0,0,4798,4799,
  	5,200,0,0,4799,4801,3,1026,513,0,4800,4798,1,0,0,0,4800,4801,1,0,0,0,
  	4801,4802,1,0,0,0,4802,4829,3,1190,595,0,4803,4805,3,1156,578,0,4804,
  	4806,3,1022,511,0,4805,4804,1,0,0,0,4805,4806,1,0,0,0,4806,4808,1,0,0,
  	0,4807,4809,3,1018,509,0,4808,4807,1,0,0,0,4808,4809,1,0,0,0,4809,4830,
  	1,0,0,0,4810,4812,3,1156,578,0,4811,4813,3,1022,511,0,4812,4811,1,0,0,
  	0,4812,4813,1,0,0,0,4813,4815,1,0,0,0,4814,4816,3,1018,509,0,4815,4814,
  	1,0,0,0,4815,4816,1,0,0,0,4816,4830,1,0,0,0,4817,4818,4,288,109,0,4818,
  	4819,5,382,0,0,4819,4820,5,776,0,0,4820,4821,3,1156,578,0,4821,4822,5,
  	777,0,0,4822,4830,1,0,0,0,4823,4824,4,288,110,0,4824,4825,5,406,0,0,4825,
  	4826,5,776,0,0,4826,4827,3,1156,578,0,4827,4828,5,777,0,0,4828,4830,1,
  	0,0,0,4829,4803,1,0,0,0,4829,4810,1,0,0,0,4829,4817,1,0,0,0,4829,4823,
  	1,0,0,0,4830,4846,1,0,0,0,4831,4832,4,288,111,0,4832,4835,5,406,0,0,4833,
  	4834,5,200,0,0,4834,4836,3,1026,513,0,4835,4833,1,0,0,0,4835,4836,1,0,
  	0,0,4836,4837,1,0,0,0,4837,4838,5,590,0,0,4838,4840,5,734,0,0,4839,4841,
  	3,1022,511,0,4840,4839,1,0,0,0,4840,4841,1,0,0,0,4841,4843,1,0,0,0,4842,
  	4844,3,1018,509,0,4843,4842,1,0,0,0,4843,4844,1,0,0,0,4844,4846,1,0,0,
  	0,4845,4789,1,0,0,0,4845,4792,1,0,0,0,4845,4794,1,0,0,0,4845,4797,1,0,
  	0,0,4845,4831,1,0,0,0,4846,577,1,0,0,0,4847,4849,3,580,290,0,4848,4850,
  	3,582,291,0,4849,4848,1,0,0,0,4849,4850,1,0,0,0,4850,4857,1,0,0,0,4851,
  	4854,3,582,291,0,4852,4853,5,773,0,0,4853,4855,3,580,290,0,4854,4852,
  	1,0,0,0,4854,4855,1,0,0,0,4855,4857,1,0,0,0,4856,4847,1,0,0,0,4856,4851,
  	1,0,0,0,4857,579,1,0,0,0,4858,4859,5,435,0,0,4859,4860,7,39,0,0,4860,
  	581,1,0,0,0,4861,4862,5,258,0,0,4862,4868,5,274,0,0,4863,4864,5,456,0,
  	0,4864,4869,5,435,0,0,4865,4866,5,435,0,0,4866,4869,7,61,0,0,4867,4869,
  	5,500,0,0,4868,4863,1,0,0,0,4868,4865,1,0,0,0,4868,4867,1,0,0,0,4869,
  	583,1,0,0,0,4870,4871,5,773,0,0,4871,4873,3,588,294,0,4872,4870,1,0,0,
  	0,4873,4876,1,0,0,0,4874,4872,1,0,0,0,4874,4875,1,0,0,0,4875,585,1,0,
  	0,0,4876,4874,1,0,0,0,4877,4878,3,746,373,0,4878,4879,3,1190,595,0,4879,
  	4880,3,596,298,0,4880,4903,1,0,0,0,4881,4903,3,998,499,0,4882,4883,3,
  	742,371,0,4883,4884,3,1190,595,0,4884,4885,3,676,338,0,4885,4903,1,0,
  	0,0,4886,4887,3,590,295,0,4887,4888,3,1190,595,0,4888,4889,3,596,298,
  	0,4889,4903,1,0,0,0,4890,4900,5,356,0,0,4891,4892,3,1190,595,0,4892,4893,
  	3,676,338,0,4893,4901,1,0,0,0,4894,4896,3,936,468,0,4895,4897,3,986,493,
  	0,4896,4895,1,0,0,0,4896,4897,1,0,0,0,4897,4901,1,0,0,0,4898,4899,4,293,
  	112,0,4899,4901,5,128,0,0,4900,4891,1,0,0,0,4900,4894,1,0,0,0,4900,4898,
  	1,0,0,0,4901,4903,1,0,0,0,4902,4877,1,0,0,0,4902,4881,1,0,0,0,4902,4882,
  	1,0,0,0,4902,4886,1,0,0,0,4902,4890,1,0,0,0,4903,587,1,0,0,0,4904,4905,
  	3,1192,596,0,4905,4906,3,746,373,0,4906,4907,3,1190,595,0,4907,4908,3,
  	596,298,0,4908,4911,1,0,0,0,4909,4911,3,586,293,0,4910,4904,1,0,0,0,4910,
  	4909,1,0,0,0,4911,589,1,0,0,0,4912,4914,5,785,0,0,4913,4915,3,1196,598,
  	0,4914,4913,1,0,0,0,4914,4915,1,0,0,0,4915,4916,1,0,0,0,4916,4917,3,746,
  	373,0,4917,591,1,0,0,0,4918,4919,3,594,297,0,4919,4920,3,584,292,0,4920,
  	4924,1,0,0,0,4921,4922,5,592,0,0,4922,4924,3,578,289,0,4923,4918,1,0,
  	0,0,4923,4921,1,0,0,0,4924,593,1,0,0,0,4925,4926,3,746,373,0,4926,4927,
  	3,1190,595,0,4927,4928,3,596,298,0,4928,595,1,0,0,0,4929,4934,3,676,338,
  	0,4930,4934,7,62,0,0,4931,4932,4,298,113,0,4932,4934,7,63,0,0,4933,4929,
  	1,0,0,0,4933,4930,1,0,0,0,4933,4931,1,0,0,0,4934,597,1,0,0,0,4935,5155,
  	5,509,0,0,4936,4937,4,299,114,0,4937,5156,5,22,0,0,4938,4940,5,110,0,
  	0,4939,4941,3,1030,515,0,4940,4939,1,0,0,0,4940,4941,1,0,0,0,4941,5156,
  	1,0,0,0,4942,4944,3,600,300,0,4943,4942,1,0,0,0,4943,4944,1,0,0,0,4944,
  	4945,1,0,0,0,4945,4947,5,571,0,0,4946,4948,3,606,303,0,4947,4946,1,0,
  	0,0,4947,4948,1,0,0,0,4948,4950,1,0,0,0,4949,4951,3,1030,515,0,4950,4949,
  	1,0,0,0,4950,4951,1,0,0,0,4951,5156,1,0,0,0,4952,4954,5,204,0,0,4953,
  	4952,1,0,0,0,4953,4954,1,0,0,0,4954,4955,1,0,0,0,4955,4957,5,593,0,0,
  	4956,4958,3,606,303,0,4957,4956,1,0,0,0,4957,4958,1,0,0,0,4958,4960,1,
  	0,0,0,4959,4961,3,1030,515,0,4960,4959,1,0,0,0,4960,4961,1,0,0,0,4961,
  	5156,1,0,0,0,4962,4964,5,169,0,0,4963,4965,3,606,303,0,4964,4963,1,0,
  	0,0,4964,4965,1,0,0,0,4965,4967,1,0,0,0,4966,4968,3,1030,515,0,4967,4966,
  	1,0,0,0,4967,4968,1,0,0,0,4968,5156,1,0,0,0,4969,4970,5,574,0,0,4970,
  	4972,5,547,0,0,4971,4973,3,606,303,0,4972,4971,1,0,0,0,4972,4973,1,0,
  	0,0,4973,4975,1,0,0,0,4974,4976,3,1030,515,0,4975,4974,1,0,0,0,4975,4976,
  	1,0,0,0,4976,5156,1,0,0,0,4977,4978,5,387,0,0,4978,4980,5,571,0,0,4979,
  	4981,3,606,303,0,4980,4979,1,0,0,0,4980,4981,1,0,0,0,4981,4983,1,0,0,
  	0,4982,4984,3,1030,515,0,4983,4982,1,0,0,0,4983,4984,1,0,0,0,4984,5156,
  	1,0,0,0,4985,5156,5,408,0,0,4986,4989,5,163,0,0,4987,4990,3,1094,547,
  	0,4988,4990,5,10,0,0,4989,4987,1,0,0,0,4989,4988,1,0,0,0,4990,4991,1,
  	0,0,0,4991,5156,7,64,0,0,4992,4994,3,600,300,0,4993,4992,1,0,0,0,4993,
  	4994,1,0,0,0,4994,4995,1,0,0,0,4995,4996,5,71,0,0,4996,4997,7,65,0,0,
  	4997,4999,3,1102,551,0,4998,5000,3,606,303,0,4999,4998,1,0,0,0,4999,5000,
  	1,0,0,0,5000,5002,1,0,0,0,5001,5003,3,1030,515,0,5002,5001,1,0,0,0,5002,
  	5003,1,0,0,0,5003,5156,1,0,0,0,5004,5005,7,42,0,0,5005,5156,5,289,0,0,
  	5006,5013,5,514,0,0,5007,5014,5,225,0,0,5008,5009,5,547,0,0,5009,5011,
  	3,602,301,0,5010,5012,3,782,391,0,5011,5010,1,0,0,0,5011,5012,1,0,0,0,
  	5012,5014,1,0,0,0,5013,5007,1,0,0,0,5013,5008,1,0,0,0,5014,5156,1,0,0,
  	0,5015,5016,7,66,0,0,5016,5019,5,169,0,0,5017,5018,5,251,0,0,5018,5020,
  	3,1156,578,0,5019,5017,1,0,0,0,5019,5020,1,0,0,0,5020,5023,1,0,0,0,5021,
  	5022,5,203,0,0,5022,5024,3,1144,572,0,5023,5021,1,0,0,0,5023,5024,1,0,
  	0,0,5024,5026,1,0,0,0,5025,5027,3,284,142,0,5026,5025,1,0,0,0,5026,5027,
  	1,0,0,0,5027,5029,1,0,0,0,5028,5030,3,782,391,0,5029,5028,1,0,0,0,5029,
  	5030,1,0,0,0,5030,5156,1,0,0,0,5031,5032,4,299,115,0,5032,5034,5,180,
  	0,0,5033,5031,1,0,0,0,5033,5034,1,0,0,0,5034,5035,1,0,0,0,5035,5036,7,
  	67,0,0,5036,5037,3,604,302,0,5037,5039,3,1102,551,0,5038,5040,3,606,303,
  	0,5039,5038,1,0,0,0,5039,5040,1,0,0,0,5040,5042,1,0,0,0,5041,5043,3,358,
  	179,0,5042,5041,1,0,0,0,5042,5043,1,0,0,0,5043,5156,1,0,0,0,5044,5046,
  	5,553,0,0,5045,5044,1,0,0,0,5045,5046,1,0,0,0,5046,5047,1,0,0,0,5047,
  	5156,5,162,0,0,5048,5049,5,95,0,0,5049,5050,5,776,0,0,5050,5051,5,760,
  	0,0,5051,5052,5,777,0,0,5052,5156,7,68,0,0,5053,5055,5,639,0,0,5054,5056,
  	3,284,142,0,5055,5054,1,0,0,0,5055,5056,1,0,0,0,5056,5156,1,0,0,0,5057,
  	5059,5,166,0,0,5058,5060,3,284,142,0,5059,5058,1,0,0,0,5059,5060,1,0,
  	0,0,5060,5156,1,0,0,0,5061,5156,5,426,0,0,5062,5071,5,425,0,0,5063,5068,
  	3,608,304,0,5064,5065,5,773,0,0,5065,5067,3,608,304,0,5066,5064,1,0,0,
  	0,5067,5070,1,0,0,0,5068,5066,1,0,0,0,5068,5069,1,0,0,0,5069,5072,1,0,
  	0,0,5070,5068,1,0,0,0,5071,5063,1,0,0,0,5071,5072,1,0,0,0,5072,5076,1,
  	0,0,0,5073,5074,5,200,0,0,5074,5075,5,430,0,0,5075,5077,5,747,0,0,5076,
  	5073,1,0,0,0,5076,5077,1,0,0,0,5077,5079,1,0,0,0,5078,5080,3,284,142,
  	0,5079,5078,1,0,0,0,5079,5080,1,0,0,0,5080,5156,1,0,0,0,5081,5083,3,1192,
  	596,0,5082,5081,1,0,0,0,5082,5083,1,0,0,0,5083,5084,1,0,0,0,5084,5086,
  	7,69,0,0,5085,5087,3,1030,515,0,5086,5085,1,0,0,0,5086,5087,1,0,0,0,5087,
  	5156,1,0,0,0,5088,5090,5,204,0,0,5089,5088,1,0,0,0,5089,5090,1,0,0,0,
  	5090,5091,1,0,0,0,5091,5156,5,424,0,0,5092,5094,3,758,379,0,5093,5095,
  	3,1030,515,0,5094,5093,1,0,0,0,5094,5095,1,0,0,0,5095,5156,1,0,0,0,5096,
  	5098,5,70,0,0,5097,5099,3,1030,515,0,5098,5097,1,0,0,0,5098,5099,1,0,
  	0,0,5099,5156,1,0,0,0,5100,5101,4,299,116,0,5101,5156,5,93,0,0,5102,5156,
  	5,421,0,0,5103,5106,5,216,0,0,5104,5105,5,200,0,0,5105,5107,3,1026,513,
  	0,5106,5104,1,0,0,0,5106,5107,1,0,0,0,5107,5156,1,0,0,0,5108,5109,5,216,
  	0,0,5109,5110,5,200,0,0,5110,5111,3,1026,513,0,5111,5112,5,621,0,0,5112,
  	5113,3,1008,504,0,5113,5156,1,0,0,0,5114,5115,5,316,0,0,5115,5156,5,547,
  	0,0,5116,5137,5,97,0,0,5117,5119,5,109,0,0,5118,5120,3,980,490,0,5119,
  	5118,1,0,0,0,5119,5120,1,0,0,0,5120,5121,1,0,0,0,5121,5138,3,1058,529,
  	0,5122,5123,5,170,0,0,5123,5138,3,1086,543,0,5124,5125,5,206,0,0,5125,
  	5138,3,1066,533,0,5126,5127,5,422,0,0,5127,5138,3,1062,531,0,5128,5129,
  	5,574,0,0,5129,5138,3,1102,551,0,5130,5131,5,594,0,0,5131,5138,3,1070,
  	535,0,5132,5133,5,636,0,0,5133,5138,3,1074,537,0,5134,5135,4,299,117,
  	0,5135,5136,5,618,0,0,5136,5138,3,1026,513,0,5137,5117,1,0,0,0,5137,5122,
  	1,0,0,0,5137,5124,1,0,0,0,5137,5126,1,0,0,0,5137,5128,1,0,0,0,5137,5130,
  	1,0,0,0,5137,5132,1,0,0,0,5137,5134,1,0,0,0,5138,5156,1,0,0,0,5139,5140,
  	5,422,0,0,5140,5142,5,547,0,0,5141,5143,3,1030,515,0,5142,5141,1,0,0,
  	0,5142,5143,1,0,0,0,5143,5156,1,0,0,0,5144,5145,5,206,0,0,5145,5147,5,
  	547,0,0,5146,5148,3,1030,515,0,5147,5146,1,0,0,0,5147,5148,1,0,0,0,5148,
  	5156,1,0,0,0,5149,5150,5,422,0,0,5150,5151,5,68,0,0,5151,5156,3,1062,
  	531,0,5152,5153,5,206,0,0,5153,5154,5,68,0,0,5154,5156,3,1066,533,0,5155,
  	4936,1,0,0,0,5155,4938,1,0,0,0,5155,4943,1,0,0,0,5155,4953,1,0,0,0,5155,
  	4962,1,0,0,0,5155,4969,1,0,0,0,5155,4977,1,0,0,0,5155,4985,1,0,0,0,5155,
  	4986,1,0,0,0,5155,4993,1,0,0,0,5155,5004,1,0,0,0,5155,5006,1,0,0,0,5155,
  	5015,1,0,0,0,5155,5033,1,0,0,0,5155,5045,1,0,0,0,5155,5048,1,0,0,0,5155,
  	5053,1,0,0,0,5155,5057,1,0,0,0,5155,5061,1,0,0,0,5155,5062,1,0,0,0,5155,
  	5082,1,0,0,0,5155,5089,1,0,0,0,5155,5092,1,0,0,0,5155,5096,1,0,0,0,5155,
  	5100,1,0,0,0,5155,5102,1,0,0,0,5155,5103,1,0,0,0,5155,5108,1,0,0,0,5155,
  	5114,1,0,0,0,5155,5116,1,0,0,0,5155,5139,1,0,0,0,5155,5144,1,0,0,0,5155,
  	5149,1,0,0,0,5155,5152,1,0,0,0,5156,599,1,0,0,0,5157,5164,5,204,0,0,5158,
  	5159,4,300,118,0,5159,5161,5,180,0,0,5160,5162,5,204,0,0,5161,5160,1,
  	0,0,0,5161,5162,1,0,0,0,5162,5164,1,0,0,0,5163,5157,1,0,0,0,5163,5158,
  	1,0,0,0,5164,601,1,0,0,0,5165,5167,4,301,119,0,5166,5168,5,370,0,0,5167,
  	5166,1,0,0,0,5167,5168,1,0,0,0,5168,5171,1,0,0,0,5169,5171,1,0,0,0,5170,
  	5165,1,0,0,0,5170,5169,1,0,0,0,5171,603,1,0,0,0,5172,5173,7,65,0,0,5173,
  	605,1,0,0,0,5174,5175,3,604,302,0,5175,5176,3,1128,564,0,5176,607,1,0,
  	0,0,5177,5178,5,40,0,0,5178,5185,5,255,0,0,5179,5180,5,91,0,0,5180,5185,
  	5,568,0,0,5181,5182,5,400,0,0,5182,5185,5,185,0,0,5183,5185,7,70,0,0,
  	5184,5177,1,0,0,0,5184,5179,1,0,0,0,5184,5181,1,0,0,0,5184,5183,1,0,0,
  	0,5185,609,1,0,0,0,5186,5187,5,33,0,0,5187,5224,3,1160,580,0,5188,5189,
  	5,47,0,0,5189,5190,5,236,0,0,5190,5191,3,612,306,0,5191,5194,5,251,0,
  	0,5192,5195,3,1128,564,0,5193,5195,5,128,0,0,5194,5192,1,0,0,0,5194,5193,
  	1,0,0,0,5195,5224,1,0,0,0,5196,5198,5,196,0,0,5197,5199,3,1034,517,0,
  	5198,5197,1,0,0,0,5198,5199,1,0,0,0,5199,5209,1,0,0,0,5200,5210,3,630,
  	315,0,5201,5206,3,626,313,0,5202,5203,5,773,0,0,5203,5205,3,626,313,0,
  	5204,5202,1,0,0,0,5205,5208,1,0,0,0,5206,5204,1,0,0,0,5206,5207,1,0,0,
  	0,5207,5210,1,0,0,0,5208,5206,1,0,0,0,5209,5200,1,0,0,0,5209,5201,1,0,
  	0,0,5210,5224,1,0,0,0,5211,5213,5,266,0,0,5212,5214,7,71,0,0,5213,5212,
  	1,0,0,0,5213,5214,1,0,0,0,5214,5215,1,0,0,0,5215,5224,3,676,338,0,5216,
  	5217,5,281,0,0,5217,5218,5,236,0,0,5218,5219,5,248,0,0,5219,5220,5,47,
  	0,0,5220,5224,3,634,317,0,5221,5222,4,305,120,0,5222,5224,5,510,0,0,5223,
  	5186,1,0,0,0,5223,5188,1,0,0,0,5223,5196,1,0,0,0,5223,5211,1,0,0,0,5223,
  	5216,1,0,0,0,5223,5221,1,0,0,0,5224,611,1,0,0,0,5225,5228,3,614,307,0,
  	5226,5228,3,618,309,0,5227,5225,1,0,0,0,5227,5226,1,0,0,0,5228,613,1,
  	0,0,0,5229,5234,3,616,308,0,5230,5231,5,773,0,0,5231,5233,3,616,308,0,
  	5232,5230,1,0,0,0,5233,5236,1,0,0,0,5234,5232,1,0,0,0,5234,5235,1,0,0,
  	0,5235,615,1,0,0,0,5236,5234,1,0,0,0,5237,5239,3,1102,551,0,5238,5240,
  	3,620,310,0,5239,5238,1,0,0,0,5239,5240,1,0,0,0,5240,617,1,0,0,0,5241,
  	5242,3,1102,551,0,5242,5243,5,405,0,0,5243,5244,5,776,0,0,5244,5245,3,
  	52,26,0,5245,5247,5,777,0,0,5246,5248,3,620,310,0,5247,5246,1,0,0,0,5247,
  	5248,1,0,0,0,5248,619,1,0,0,0,5249,5250,3,406,203,0,5250,5252,5,776,0,
  	0,5251,5253,3,624,312,0,5252,5251,1,0,0,0,5252,5253,1,0,0,0,5253,5254,
  	1,0,0,0,5254,5255,5,777,0,0,5255,621,1,0,0,0,5256,5259,3,1128,564,0,5257,
  	5259,5,420,0,0,5258,5256,1,0,0,0,5258,5257,1,0,0,0,5259,623,1,0,0,0,5260,
  	5265,3,622,311,0,5261,5262,5,773,0,0,5262,5264,3,622,311,0,5263,5261,
  	1,0,0,0,5264,5267,1,0,0,0,5265,5263,1,0,0,0,5265,5266,1,0,0,0,5266,625,
  	1,0,0,0,5267,5265,1,0,0,0,5268,5284,7,72,0,0,5269,5271,3,628,314,0,5270,
  	5269,1,0,0,0,5270,5271,1,0,0,0,5271,5272,1,0,0,0,5272,5284,5,289,0,0,
  	5273,5274,5,445,0,0,5274,5276,5,289,0,0,5275,5277,3,782,391,0,5276,5275,
  	1,0,0,0,5276,5277,1,0,0,0,5277,5284,1,0,0,0,5278,5279,4,313,121,0,5279,
  	5280,5,430,0,0,5280,5284,5,47,0,0,5281,5282,4,313,122,0,5282,5284,5,389,
  	0,0,5283,5268,1,0,0,0,5283,5270,1,0,0,0,5283,5273,1,0,0,0,5283,5278,1,
  	0,0,0,5283,5281,1,0,0,0,5284,627,1,0,0,0,5285,5286,7,73,0,0,5286,629,
  	1,0,0,0,5287,5295,7,18,0,0,5288,5289,5,645,0,0,5289,5290,5,435,0,0,5290,
  	5296,5,287,0,0,5291,5293,3,1130,565,0,5292,5294,3,632,316,0,5293,5292,
  	1,0,0,0,5293,5294,1,0,0,0,5294,5296,1,0,0,0,5295,5288,1,0,0,0,5295,5291,
  	1,0,0,0,5295,5296,1,0,0,0,5296,631,1,0,0,0,5297,5298,4,316,123,0,5298,
  	5299,5,200,0,0,5299,5304,5,179,0,0,5300,5301,5,645,0,0,5301,5302,5,435,
  	0,0,5302,5304,5,287,0,0,5303,5297,1,0,0,0,5303,5300,1,0,0,0,5304,633,
  	1,0,0,0,5305,5306,3,1102,551,0,5306,5308,3,640,320,0,5307,5309,3,620,
  	310,0,5308,5307,1,0,0,0,5308,5309,1,0,0,0,5309,5312,1,0,0,0,5310,5311,
  	5,232,0,0,5311,5313,5,270,0,0,5312,5310,1,0,0,0,5312,5313,1,0,0,0,5313,
  	5316,1,0,0,0,5314,5316,3,636,318,0,5315,5305,1,0,0,0,5315,5314,1,0,0,
  	0,5316,635,1,0,0,0,5317,5322,3,638,319,0,5318,5319,5,773,0,0,5319,5321,
  	3,638,319,0,5320,5318,1,0,0,0,5321,5324,1,0,0,0,5322,5320,1,0,0,0,5322,
  	5323,1,0,0,0,5323,637,1,0,0,0,5324,5322,1,0,0,0,5325,5327,3,1102,551,
  	0,5326,5328,3,620,310,0,5327,5326,1,0,0,0,5327,5328,1,0,0,0,5328,5331,
  	1,0,0,0,5329,5330,5,232,0,0,5330,5332,5,270,0,0,5331,5329,1,0,0,0,5331,
  	5332,1,0,0,0,5332,639,1,0,0,0,5333,5334,5,405,0,0,5334,5335,5,776,0,0,
  	5335,5336,3,52,26,0,5336,5337,5,777,0,0,5337,641,1,0,0,0,5338,5343,3,
  	644,322,0,5339,5343,3,654,327,0,5340,5343,3,656,328,0,5341,5343,3,660,
  	330,0,5342,5338,1,0,0,0,5342,5339,1,0,0,0,5342,5340,1,0,0,0,5342,5341,
  	1,0,0,0,5343,643,1,0,0,0,5344,5345,5,97,0,0,5345,5346,5,709,0,0,5346,
  	5347,5,217,0,0,5347,5348,3,1128,564,0,5348,5350,5,599,0,0,5349,5351,3,
  	1190,595,0,5350,5349,1,0,0,0,5350,5351,1,0,0,0,5351,5352,1,0,0,0,5352,
  	5354,7,74,0,0,5353,5355,3,646,323,0,5354,5353,1,0,0,0,5354,5355,1,0,0,
  	0,5355,5357,1,0,0,0,5356,5358,3,650,325,0,5357,5356,1,0,0,0,5357,5358,
  	1,0,0,0,5358,5360,1,0,0,0,5359,5361,3,652,326,0,5360,5359,1,0,0,0,5360,
  	5361,1,0,0,0,5361,645,1,0,0,0,5362,5364,5,711,0,0,5363,5365,3,1190,595,
  	0,5364,5363,1,0,0,0,5364,5365,1,0,0,0,5365,5366,1,0,0,0,5366,5373,3,648,
  	324,0,5367,5369,5,773,0,0,5368,5367,1,0,0,0,5368,5369,1,0,0,0,5369,5370,
  	1,0,0,0,5370,5372,3,648,324,0,5371,5368,1,0,0,0,5372,5375,1,0,0,0,5373,
  	5371,1,0,0,0,5373,5374,1,0,0,0,5374,647,1,0,0,0,5375,5373,1,0,0,0,5376,
  	5379,5,747,0,0,5377,5378,5,759,0,0,5378,5380,5,747,0,0,5379,5377,1,0,
  	0,0,5379,5380,1,0,0,0,5380,649,1,0,0,0,5381,5383,5,708,0,0,5382,5384,
  	3,1190,595,0,5383,5382,1,0,0,0,5383,5384,1,0,0,0,5384,5385,1,0,0,0,5385,
  	5386,5,747,0,0,5386,651,1,0,0,0,5387,5388,7,75,0,0,5388,653,1,0,0,0,5389,
  	5390,5,11,0,0,5390,5391,5,709,0,0,5391,5392,5,217,0,0,5392,5394,3,1122,
  	561,0,5393,5395,3,646,323,0,5394,5393,1,0,0,0,5394,5395,1,0,0,0,5395,
  	5397,1,0,0,0,5396,5398,3,650,325,0,5397,5396,1,0,0,0,5397,5398,1,0,0,
  	0,5398,5400,1,0,0,0,5399,5401,3,652,326,0,5400,5399,1,0,0,0,5400,5401,
  	1,0,0,0,5401,5403,1,0,0,0,5402,5404,5,198,0,0,5403,5402,1,0,0,0,5403,
  	5404,1,0,0,0,5404,655,1,0,0,0,5405,5406,5,506,0,0,5406,5407,5,709,0,0,
  	5407,5408,5,217,0,0,5408,5411,3,1128,564,0,5409,5410,5,200,0,0,5410,5412,
  	3,658,329,0,5411,5409,1,0,0,0,5411,5412,1,0,0,0,5412,657,1,0,0,0,5413,
  	5420,3,1142,571,0,5414,5416,5,773,0,0,5415,5414,1,0,0,0,5415,5416,1,0,
  	0,0,5416,5417,1,0,0,0,5417,5419,3,1142,571,0,5418,5415,1,0,0,0,5419,5422,
  	1,0,0,0,5420,5418,1,0,0,0,5420,5421,1,0,0,0,5421,659,1,0,0,0,5422,5420,
  	1,0,0,0,5423,5424,5,148,0,0,5424,5425,5,709,0,0,5425,5426,5,217,0,0,5426,
  	5428,3,1122,561,0,5427,5429,5,198,0,0,5428,5427,1,0,0,0,5428,5429,1,0,
  	0,0,5429,661,1,0,0,0,5430,5437,3,664,332,0,5431,5437,3,666,333,0,5432,
  	5437,3,670,335,0,5433,5437,3,672,336,0,5434,5435,4,331,124,0,5435,5437,
  	3,674,337,0,5436,5430,1,0,0,0,5436,5431,1,0,0,0,5436,5432,1,0,0,0,5436,
  	5433,1,0,0,0,5436,5434,1,0,0,0,5437,663,1,0,0,0,5438,5439,7,76,0,0,5439,
  	5442,3,1102,551,0,5440,5443,3,1156,578,0,5441,5443,3,1046,523,0,5442,
  	5440,1,0,0,0,5442,5441,1,0,0,0,5442,5443,1,0,0,0,5443,665,1,0,0,0,5444,
  	5460,7,76,0,0,5445,5446,4,333,125,0,5446,5461,5,180,0,0,5447,5448,4,333,
  	126,0,5448,5461,5,404,0,0,5449,5450,4,333,127,0,5450,5451,5,201,0,0,5451,
  	5452,5,750,0,0,5452,5461,3,1180,590,0,5453,5454,4,333,128,0,5454,5461,
  	5,14,0,0,5455,5456,4,333,129,0,5456,5457,5,14,0,0,5457,5458,5,201,0,0,
  	5458,5459,5,750,0,0,5459,5461,3,1180,590,0,5460,5445,1,0,0,0,5460,5447,
  	1,0,0,0,5460,5449,1,0,0,0,5460,5453,1,0,0,0,5460,5455,1,0,0,0,5460,5461,
  	1,0,0,0,5461,5462,1,0,0,0,5462,5463,3,668,334,0,5463,667,1,0,0,0,5464,
  	5477,3,266,133,0,5465,5470,4,334,130,0,5466,5471,3,220,110,0,5467,5471,
  	3,232,116,0,5468,5471,3,264,132,0,5469,5471,3,416,208,0,5470,5466,1,0,
  	0,0,5470,5467,1,0,0,0,5470,5468,1,0,0,0,5470,5469,1,0,0,0,5471,5477,1,
  	0,0,0,5472,5473,4,334,131,0,5473,5474,5,200,0,0,5474,5475,5,84,0,0,5475,
  	5477,3,1142,571,0,5476,5464,1,0,0,0,5476,5465,1,0,0,0,5476,5472,1,0,0,
  	0,5477,669,1,0,0,0,5478,5479,5,222,0,0,5479,5480,3,1180,590,0,5480,671,
  	1,0,0,0,5481,5482,5,620,0,0,5482,5483,3,1128,564,0,5483,673,1,0,0,0,5484,
  	5485,5,714,0,0,5485,675,1,0,0,0,5486,5487,6,338,-1,0,5487,5493,3,678,
  	339,0,5488,5490,5,257,0,0,5489,5491,3,760,380,0,5490,5489,1,0,0,0,5490,
  	5491,1,0,0,0,5491,5492,1,0,0,0,5492,5494,7,77,0,0,5493,5488,1,0,0,0,5493,
  	5494,1,0,0,0,5494,5498,1,0,0,0,5495,5496,5,371,0,0,5496,5498,3,676,338,
  	4,5497,5486,1,0,0,0,5497,5495,1,0,0,0,5498,5510,1,0,0,0,5499,5500,10,
  	3,0,0,5500,5501,7,78,0,0,5501,5509,3,676,338,4,5502,5503,10,2,0,0,5503,
  	5504,5,654,0,0,5504,5509,3,676,338,3,5505,5506,10,1,0,0,5506,5507,7,79,
  	0,0,5507,5509,3,676,338,2,5508,5499,1,0,0,0,5508,5502,1,0,0,0,5508,5505,
  	1,0,0,0,5509,5512,1,0,0,0,5510,5508,1,0,0,0,5510,5511,1,0,0,0,5511,677,
  	1,0,0,0,5512,5510,1,0,0,0,5513,5514,6,339,-1,0,5514,5515,3,682,341,0,
  	5515,5533,1,0,0,0,5516,5517,10,3,0,0,5517,5519,5,257,0,0,5518,5520,3,
  	760,380,0,5519,5518,1,0,0,0,5519,5520,1,0,0,0,5520,5521,1,0,0,0,5521,
  	5532,5,376,0,0,5522,5523,10,2,0,0,5523,5524,3,680,340,0,5524,5525,3,682,
  	341,0,5525,5532,1,0,0,0,5526,5527,10,1,0,0,5527,5528,3,680,340,0,5528,
  	5529,7,80,0,0,5529,5530,3,280,140,0,5530,5532,1,0,0,0,5531,5516,1,0,0,
  	0,5531,5522,1,0,0,0,5531,5526,1,0,0,0,5532,5535,1,0,0,0,5533,5531,1,0,
  	0,0,5533,5534,1,0,0,0,5534,679,1,0,0,0,5535,5533,1,0,0,0,5536,5537,7,
  	81,0,0,5537,681,1,0,0,0,5538,5552,3,686,343,0,5539,5541,3,760,380,0,5540,
  	5539,1,0,0,0,5540,5541,1,0,0,0,5541,5542,1,0,0,0,5542,5553,3,684,342,
  	0,5543,5544,4,341,138,0,5544,5546,5,733,0,0,5545,5547,5,668,0,0,5546,
  	5545,1,0,0,0,5546,5547,1,0,0,0,5547,5548,1,0,0,0,5548,5553,3,772,386,
  	0,5549,5550,5,521,0,0,5550,5551,5,275,0,0,5551,5553,3,686,343,0,5552,
  	5540,1,0,0,0,5552,5543,1,0,0,0,5552,5549,1,0,0,0,5552,5553,1,0,0,0,5553,
  	683,1,0,0,0,5554,5560,5,251,0,0,5555,5561,3,280,140,0,5556,5557,5,776,
  	0,0,5557,5558,3,756,378,0,5558,5559,5,777,0,0,5559,5561,1,0,0,0,5560,
  	5555,1,0,0,0,5560,5556,1,0,0,0,5561,5576,1,0,0,0,5562,5563,5,30,0,0,5563,
  	5564,3,686,343,0,5564,5565,5,15,0,0,5565,5566,3,682,341,0,5566,5576,1,
  	0,0,0,5567,5568,5,275,0,0,5568,5571,3,688,344,0,5569,5570,5,168,0,0,5570,
  	5572,3,688,344,0,5571,5569,1,0,0,0,5571,5572,1,0,0,0,5572,5576,1,0,0,
  	0,5573,5574,5,444,0,0,5574,5576,3,686,343,0,5575,5554,1,0,0,0,5575,5562,
  	1,0,0,0,5575,5567,1,0,0,0,5575,5573,1,0,0,0,5576,685,1,0,0,0,5577,5578,
  	6,343,-1,0,5578,5579,3,688,344,0,5579,5606,1,0,0,0,5580,5581,10,7,0,0,
  	5581,5582,5,769,0,0,5582,5605,3,686,343,8,5583,5584,10,6,0,0,5584,5585,
  	7,82,0,0,5585,5605,3,686,343,7,5586,5587,10,5,0,0,5587,5588,7,83,0,0,
  	5588,5605,3,686,343,6,5589,5590,10,3,0,0,5590,5591,7,84,0,0,5591,5605,
  	3,686,343,4,5592,5593,10,2,0,0,5593,5594,5,768,0,0,5594,5605,3,686,343,
  	3,5595,5596,10,1,0,0,5596,5597,5,771,0,0,5597,5605,3,686,343,2,5598,5599,
  	10,4,0,0,5599,5600,7,83,0,0,5600,5601,5,247,0,0,5601,5602,3,676,338,0,
  	5602,5603,3,764,382,0,5603,5605,1,0,0,0,5604,5580,1,0,0,0,5604,5583,1,
  	0,0,0,5604,5586,1,0,0,0,5604,5589,1,0,0,0,5604,5592,1,0,0,0,5604,5595,
  	1,0,0,0,5604,5598,1,0,0,0,5605,5608,1,0,0,0,5606,5604,1,0,0,0,5606,5607,
  	1,0,0,0,5607,687,1,0,0,0,5608,5606,1,0,0,0,5609,5610,6,344,-1,0,5610,
  	5614,3,740,370,0,5611,5612,3,1190,595,0,5612,5613,3,676,338,0,5613,5615,
  	1,0,0,0,5614,5611,1,0,0,0,5614,5615,1,0,0,0,5615,5719,1,0,0,0,5616,5618,
  	3,1046,523,0,5617,5619,3,692,346,0,5618,5617,1,0,0,0,5618,5619,1,0,0,
  	0,5619,5719,1,0,0,0,5620,5719,3,716,358,0,5621,5719,3,734,367,0,5622,
  	5719,3,1148,574,0,5623,5719,5,787,0,0,5624,5719,3,694,347,0,5625,5626,
  	4,344,146,0,5626,5719,3,696,348,0,5627,5628,4,344,147,0,5628,5719,3,698,
  	349,0,5629,5630,7,85,0,0,5630,5719,3,688,344,14,5631,5632,3,762,381,0,
  	5632,5633,3,688,344,13,5633,5719,1,0,0,0,5634,5636,5,487,0,0,5635,5634,
  	1,0,0,0,5635,5636,1,0,0,0,5636,5637,1,0,0,0,5637,5638,5,776,0,0,5638,
  	5639,3,756,378,0,5639,5640,5,777,0,0,5640,5719,1,0,0,0,5641,5643,5,174,
  	0,0,5642,5641,1,0,0,0,5642,5643,1,0,0,0,5643,5644,1,0,0,0,5644,5719,3,
  	280,140,0,5645,5646,5,778,0,0,5646,5647,3,1128,564,0,5647,5648,3,676,
  	338,0,5648,5649,5,779,0,0,5649,5719,1,0,0,0,5650,5651,5,320,0,0,5651,
  	5652,3,710,355,0,5652,5653,5,7,0,0,5653,5654,5,776,0,0,5654,5656,3,686,
  	343,0,5655,5657,3,714,357,0,5656,5655,1,0,0,0,5656,5657,1,0,0,0,5657,
  	5658,1,0,0,0,5658,5659,5,777,0,0,5659,5719,1,0,0,0,5660,5661,5,32,0,0,
  	5661,5719,3,688,344,8,5662,5663,5,52,0,0,5663,5664,5,776,0,0,5664,5665,
  	3,676,338,0,5665,5666,5,17,0,0,5666,5668,3,754,377,0,5667,5669,3,690,
  	345,0,5668,5667,1,0,0,0,5668,5669,1,0,0,0,5669,5670,1,0,0,0,5670,5671,
  	5,777,0,0,5671,5719,1,0,0,0,5672,5674,5,51,0,0,5673,5675,3,676,338,0,
  	5674,5673,1,0,0,0,5674,5675,1,0,0,0,5675,5679,1,0,0,0,5676,5677,3,748,
  	374,0,5677,5678,3,750,375,0,5678,5680,1,0,0,0,5679,5676,1,0,0,0,5680,
  	5681,1,0,0,0,5681,5679,1,0,0,0,5681,5682,1,0,0,0,5682,5684,1,0,0,0,5683,
  	5685,3,752,376,0,5684,5683,1,0,0,0,5684,5685,1,0,0,0,5685,5686,1,0,0,
  	0,5686,5687,5,159,0,0,5687,5719,1,0,0,0,5688,5689,5,94,0,0,5689,5690,
  	5,776,0,0,5690,5691,3,676,338,0,5691,5692,5,773,0,0,5692,5693,3,754,377,
  	0,5693,5694,5,777,0,0,5694,5719,1,0,0,0,5695,5696,5,94,0,0,5696,5697,
  	5,776,0,0,5697,5698,3,676,338,0,5698,5699,5,621,0,0,5699,5700,3,936,468,
  	0,5700,5701,5,777,0,0,5701,5719,1,0,0,0,5702,5703,5,128,0,0,5703,5704,
  	5,776,0,0,5704,5705,3,1136,568,0,5705,5706,5,777,0,0,5706,5719,1,0,0,
  	0,5707,5708,5,626,0,0,5708,5709,5,776,0,0,5709,5710,3,1136,568,0,5710,
  	5711,5,777,0,0,5711,5719,1,0,0,0,5712,5713,5,247,0,0,5713,5714,3,676,
  	338,0,5714,5715,3,764,382,0,5715,5716,5,758,0,0,5716,5717,3,676,338,0,
  	5717,5719,1,0,0,0,5718,5609,1,0,0,0,5718,5616,1,0,0,0,5718,5620,1,0,0,
  	0,5718,5621,1,0,0,0,5718,5622,1,0,0,0,5718,5623,1,0,0,0,5718,5624,1,0,
  	0,0,5718,5625,1,0,0,0,5718,5627,1,0,0,0,5718,5629,1,0,0,0,5718,5631,1,
  	0,0,0,5718,5635,1,0,0,0,5718,5642,1,0,0,0,5718,5645,1,0,0,0,5718,5650,
  	1,0,0,0,5718,5660,1,0,0,0,5718,5662,1,0,0,0,5718,5672,1,0,0,0,5718,5688,
  	1,0,0,0,5718,5695,1,0,0,0,5718,5702,1,0,0,0,5718,5707,1,0,0,0,5718,5712,
  	1,0,0,0,5719,5728,1,0,0,0,5720,5721,10,15,0,0,5721,5722,5,746,0,0,5722,
  	5727,3,688,344,16,5723,5724,10,21,0,0,5724,5725,5,69,0,0,5725,5727,3,
  	1180,590,0,5726,5720,1,0,0,0,5726,5723,1,0,0,0,5727,5730,1,0,0,0,5728,
  	5726,1,0,0,0,5728,5729,1,0,0,0,5729,689,1,0,0,0,5730,5728,1,0,0,0,5731,
  	5732,4,345,150,0,5732,5733,5,731,0,0,5733,691,1,0,0,0,5734,5735,4,346,
  	151,0,5735,5736,5,781,0,0,5736,5741,3,1154,577,0,5737,5738,4,346,152,
  	0,5738,5739,5,782,0,0,5739,5741,3,1154,577,0,5740,5734,1,0,0,0,5740,5737,
  	1,0,0,0,5741,693,1,0,0,0,5742,5743,5,26,0,0,5743,5745,5,776,0,0,5744,
  	5746,5,143,0,0,5745,5744,1,0,0,0,5745,5746,1,0,0,0,5746,5747,1,0,0,0,
  	5747,5748,3,708,354,0,5748,5751,5,777,0,0,5749,5750,4,347,153,0,5750,
  	5752,3,700,350,0,5751,5749,1,0,0,0,5751,5752,1,0,0,0,5752,5874,1,0,0,
  	0,5753,5754,7,86,0,0,5754,5755,5,776,0,0,5755,5756,3,708,354,0,5756,5759,
  	5,777,0,0,5757,5758,4,347,154,0,5758,5760,3,700,350,0,5759,5757,1,0,0,
  	0,5759,5760,1,0,0,0,5760,5874,1,0,0,0,5761,5762,4,347,155,0,5762,5874,
  	3,706,353,0,5763,5764,5,95,0,0,5764,5766,5,776,0,0,5765,5767,5,10,0,0,
  	5766,5765,1,0,0,0,5766,5767,1,0,0,0,5767,5768,1,0,0,0,5768,5769,5,760,
  	0,0,5769,5772,5,777,0,0,5770,5771,4,347,156,0,5771,5773,3,700,350,0,5772,
  	5770,1,0,0,0,5772,5773,1,0,0,0,5773,5874,1,0,0,0,5774,5775,5,95,0,0,5775,
  	5783,5,776,0,0,5776,5778,5,10,0,0,5777,5776,1,0,0,0,5777,5778,1,0,0,0,
  	5778,5779,1,0,0,0,5779,5784,5,760,0,0,5780,5784,3,708,354,0,5781,5782,
  	5,143,0,0,5782,5784,3,756,378,0,5783,5777,1,0,0,0,5783,5780,1,0,0,0,5783,
  	5781,1,0,0,0,5784,5785,1,0,0,0,5785,5788,5,777,0,0,5786,5787,4,347,157,
  	0,5787,5789,3,700,350,0,5788,5786,1,0,0,0,5788,5789,1,0,0,0,5789,5874,
  	1,0,0,0,5790,5791,5,345,0,0,5791,5793,5,776,0,0,5792,5794,5,143,0,0,5793,
  	5792,1,0,0,0,5793,5794,1,0,0,0,5794,5795,1,0,0,0,5795,5796,3,708,354,
  	0,5796,5799,5,777,0,0,5797,5798,4,347,158,0,5798,5800,3,700,350,0,5799,
  	5797,1,0,0,0,5799,5800,1,0,0,0,5800,5874,1,0,0,0,5801,5802,5,326,0,0,
  	5802,5804,5,776,0,0,5803,5805,5,143,0,0,5804,5803,1,0,0,0,5804,5805,1,
  	0,0,0,5805,5806,1,0,0,0,5806,5807,3,708,354,0,5807,5810,5,777,0,0,5808,
  	5809,4,347,159,0,5809,5811,3,700,350,0,5810,5808,1,0,0,0,5810,5811,1,
  	0,0,0,5811,5874,1,0,0,0,5812,5813,5,551,0,0,5813,5814,5,776,0,0,5814,
  	5815,3,708,354,0,5815,5818,5,777,0,0,5816,5817,4,347,160,0,5817,5819,
  	3,700,350,0,5818,5816,1,0,0,0,5818,5819,1,0,0,0,5819,5874,1,0,0,0,5820,
  	5821,5,632,0,0,5821,5822,5,776,0,0,5822,5823,3,708,354,0,5823,5826,5,
  	777,0,0,5824,5825,4,347,161,0,5825,5827,3,700,350,0,5826,5824,1,0,0,0,
  	5826,5827,1,0,0,0,5827,5874,1,0,0,0,5828,5829,5,548,0,0,5829,5830,5,776,
  	0,0,5830,5831,3,708,354,0,5831,5834,5,777,0,0,5832,5833,4,347,162,0,5833,
  	5835,3,700,350,0,5834,5832,1,0,0,0,5834,5835,1,0,0,0,5835,5874,1,0,0,
  	0,5836,5837,5,635,0,0,5837,5838,5,776,0,0,5838,5839,3,708,354,0,5839,
  	5842,5,777,0,0,5840,5841,4,347,163,0,5841,5843,3,700,350,0,5842,5840,
  	1,0,0,0,5842,5843,1,0,0,0,5843,5874,1,0,0,0,5844,5845,5,564,0,0,5845,
  	5847,5,776,0,0,5846,5848,5,143,0,0,5847,5846,1,0,0,0,5847,5848,1,0,0,
  	0,5848,5849,1,0,0,0,5849,5850,3,708,354,0,5850,5853,5,777,0,0,5851,5852,
  	4,347,164,0,5852,5854,3,700,350,0,5853,5851,1,0,0,0,5853,5854,1,0,0,0,
  	5854,5874,1,0,0,0,5855,5856,5,218,0,0,5856,5858,5,776,0,0,5857,5859,5,
  	143,0,0,5858,5857,1,0,0,0,5858,5859,1,0,0,0,5859,5860,1,0,0,0,5860,5862,
  	3,756,378,0,5861,5863,3,328,164,0,5862,5861,1,0,0,0,5862,5863,1,0,0,0,
  	5863,5866,1,0,0,0,5864,5865,5,499,0,0,5865,5867,3,1156,578,0,5866,5864,
  	1,0,0,0,5866,5867,1,0,0,0,5867,5868,1,0,0,0,5868,5871,5,777,0,0,5869,
  	5870,4,347,165,0,5870,5872,3,700,350,0,5871,5869,1,0,0,0,5871,5872,1,
  	0,0,0,5872,5874,1,0,0,0,5873,5742,1,0,0,0,5873,5753,1,0,0,0,5873,5761,
  	1,0,0,0,5873,5763,1,0,0,0,5873,5774,1,0,0,0,5873,5790,1,0,0,0,5873,5801,
  	1,0,0,0,5873,5812,1,0,0,0,5873,5820,1,0,0,0,5873,5828,1,0,0,0,5873,5836,
  	1,0,0,0,5873,5844,1,0,0,0,5873,5855,1,0,0,0,5874,695,1,0,0,0,5875,5876,
  	5,672,0,0,5876,5877,5,776,0,0,5877,5878,3,756,378,0,5878,5879,5,777,0,
  	0,5879,697,1,0,0,0,5880,5881,7,87,0,0,5881,5882,3,1188,594,0,5882,5883,
  	3,700,350,0,5883,5923,1,0,0,0,5884,5885,5,688,0,0,5885,5886,3,772,386,
  	0,5886,5887,3,700,350,0,5887,5923,1,0,0,0,5888,5889,7,88,0,0,5889,5890,
  	5,776,0,0,5890,5892,3,676,338,0,5891,5893,3,702,351,0,5892,5891,1,0,0,
  	0,5892,5893,1,0,0,0,5893,5894,1,0,0,0,5894,5896,5,777,0,0,5895,5897,3,
  	704,352,0,5896,5895,1,0,0,0,5896,5897,1,0,0,0,5897,5898,1,0,0,0,5898,
  	5899,3,700,350,0,5899,5923,1,0,0,0,5900,5901,7,89,0,0,5901,5903,3,770,
  	385,0,5902,5904,3,704,352,0,5903,5902,1,0,0,0,5903,5904,1,0,0,0,5904,
  	5905,1,0,0,0,5905,5906,3,700,350,0,5906,5923,1,0,0,0,5907,5908,5,687,
  	0,0,5908,5909,5,776,0,0,5909,5910,3,676,338,0,5910,5911,5,773,0,0,5911,
  	5912,3,688,344,0,5912,5915,5,777,0,0,5913,5914,5,203,0,0,5914,5916,7,
  	90,0,0,5915,5913,1,0,0,0,5915,5916,1,0,0,0,5916,5918,1,0,0,0,5917,5919,
  	3,704,352,0,5918,5917,1,0,0,0,5918,5919,1,0,0,0,5919,5920,1,0,0,0,5920,
  	5921,3,700,350,0,5921,5923,1,0,0,0,5922,5880,1,0,0,0,5922,5884,1,0,0,
  	0,5922,5888,1,0,0,0,5922,5900,1,0,0,0,5922,5907,1,0,0,0,5923,699,1,0,
  	0,0,5924,5927,5,691,0,0,5925,5928,3,1124,562,0,5926,5928,3,302,151,0,
  	5927,5925,1,0,0,0,5927,5926,1,0,0,0,5928,701,1,0,0,0,5929,5932,5,773,
  	0,0,5930,5933,3,1144,572,0,5931,5933,5,787,0,0,5932,5930,1,0,0,0,5932,
  	5931,1,0,0,0,5933,5936,1,0,0,0,5934,5935,5,773,0,0,5935,5937,3,676,338,
  	0,5936,5934,1,0,0,0,5936,5937,1,0,0,0,5937,703,1,0,0,0,5938,5939,7,91,
  	0,0,5939,5940,5,689,0,0,5940,705,1,0,0,0,5941,5942,5,667,0,0,5942,5943,
  	5,776,0,0,5943,5944,3,708,354,0,5944,5946,5,777,0,0,5945,5947,3,700,350,
  	0,5946,5945,1,0,0,0,5946,5947,1,0,0,0,5947,5958,1,0,0,0,5948,5949,5,666,
  	0,0,5949,5950,5,776,0,0,5950,5951,3,708,354,0,5951,5952,5,773,0,0,5952,
  	5953,3,708,354,0,5953,5955,5,777,0,0,5954,5956,3,700,350,0,5955,5954,
  	1,0,0,0,5955,5956,1,0,0,0,5956,5958,1,0,0,0,5957,5941,1,0,0,0,5957,5948,
  	1,0,0,0,5958,707,1,0,0,0,5959,5961,5,10,0,0,5960,5959,1,0,0,0,5960,5961,
  	1,0,0,0,5961,5962,1,0,0,0,5962,5963,3,676,338,0,5963,709,1,0,0,0,5964,
  	5970,3,712,356,0,5965,5966,5,776,0,0,5966,5967,3,712,356,0,5967,5968,
  	5,777,0,0,5968,5970,1,0,0,0,5969,5964,1,0,0,0,5969,5965,1,0,0,0,5970,
  	711,1,0,0,0,5971,5976,3,1136,568,0,5972,5973,5,773,0,0,5973,5975,3,1136,
  	568,0,5974,5972,1,0,0,0,5975,5978,1,0,0,0,5976,5974,1,0,0,0,5976,5977,
  	1,0,0,0,5977,713,1,0,0,0,5978,5976,1,0,0,0,5979,5980,5,251,0,0,5980,5981,
  	5,41,0,0,5981,5995,5,346,0,0,5982,5983,5,251,0,0,5983,5984,5,359,0,0,
  	5984,5985,5,267,0,0,5985,5989,5,346,0,0,5986,5987,5,645,0,0,5987,5988,
  	5,430,0,0,5988,5990,5,176,0,0,5989,5986,1,0,0,0,5989,5990,1,0,0,0,5990,
  	5995,1,0,0,0,5991,5992,5,645,0,0,5992,5993,5,430,0,0,5993,5995,5,176,
  	0,0,5994,5979,1,0,0,0,5994,5982,1,0,0,0,5994,5991,1,0,0,0,5995,715,1,
  	0,0,0,5996,5997,5,60,0,0,5997,5998,5,776,0,0,5998,6001,3,756,378,0,5999,
  	6000,5,621,0,0,6000,6002,3,936,468,0,6001,5999,1,0,0,0,6001,6002,1,0,
  	0,0,6002,6003,1,0,0,0,6003,6004,5,777,0,0,6004,6270,1,0,0,0,6005,6007,
  	5,105,0,0,6006,6008,3,1188,594,0,6007,6006,1,0,0,0,6007,6008,1,0,0,0,
  	6008,6270,1,0,0,0,6009,6010,5,116,0,0,6010,6270,3,770,385,0,6011,6012,
  	5,122,0,0,6012,6270,3,770,385,0,6013,6014,5,229,0,0,6014,6270,3,770,385,
  	0,6015,6016,5,242,0,0,6016,6017,5,776,0,0,6017,6018,3,676,338,0,6018,
  	6019,5,773,0,0,6019,6020,3,676,338,0,6020,6021,5,773,0,0,6021,6022,3,
  	676,338,0,6022,6023,5,773,0,0,6023,6024,3,676,338,0,6024,6025,5,777,0,
  	0,6025,6270,1,0,0,0,6026,6027,5,247,0,0,6027,6028,5,776,0,0,6028,6031,
  	3,676,338,0,6029,6030,5,773,0,0,6030,6032,3,676,338,0,6031,6029,1,0,0,
  	0,6032,6033,1,0,0,0,6033,6031,1,0,0,0,6033,6034,1,0,0,0,6034,6035,1,0,
  	0,0,6035,6036,5,777,0,0,6036,6270,1,0,0,0,6037,6038,5,272,0,0,6038,6039,
  	5,776,0,0,6039,6040,3,676,338,0,6040,6041,5,773,0,0,6041,6042,3,676,338,
  	0,6042,6043,5,777,0,0,6043,6270,1,0,0,0,6044,6045,5,343,0,0,6045,6270,
  	3,770,385,0,6046,6047,5,350,0,0,6047,6270,3,770,385,0,6048,6049,5,478,
  	0,0,6049,6050,5,776,0,0,6050,6051,3,676,338,0,6051,6052,5,773,0,0,6052,
  	6053,3,676,338,0,6053,6054,5,777,0,0,6054,6270,1,0,0,0,6055,6056,5,495,
  	0,0,6056,6270,3,770,385,0,6057,6058,5,586,0,0,6058,6270,3,770,385,0,6059,
  	6060,5,583,0,0,6060,6061,5,776,0,0,6061,6064,3,676,338,0,6062,6063,5,
  	773,0,0,6063,6065,3,676,338,0,6064,6062,1,0,0,0,6064,6065,1,0,0,0,6065,
  	6066,1,0,0,0,6066,6067,5,777,0,0,6067,6270,1,0,0,0,6068,6270,3,730,365,
  	0,6069,6070,5,618,0,0,6070,6270,3,1188,594,0,6071,6072,5,626,0,0,6072,
  	6270,3,770,385,0,6073,6074,5,656,0,0,6074,6270,3,770,385,0,6075,6076,
  	7,92,0,0,6076,6077,5,776,0,0,6077,6078,3,676,338,0,6078,6084,5,773,0,
  	0,6079,6085,3,676,338,0,6080,6081,5,247,0,0,6081,6082,3,676,338,0,6082,
  	6083,3,764,382,0,6083,6085,1,0,0,0,6084,6079,1,0,0,0,6084,6080,1,0,0,
  	0,6085,6086,1,0,0,0,6086,6087,5,777,0,0,6087,6270,1,0,0,0,6088,6090,5,
  	100,0,0,6089,6091,3,1188,594,0,6090,6089,1,0,0,0,6090,6091,1,0,0,0,6091,
  	6270,1,0,0,0,6092,6094,5,108,0,0,6093,6095,3,720,360,0,6094,6093,1,0,
  	0,0,6094,6095,1,0,0,0,6095,6270,1,0,0,0,6096,6097,7,93,0,0,6097,6098,
  	5,776,0,0,6098,6099,3,676,338,0,6099,6100,5,773,0,0,6100,6101,5,247,0,
  	0,6101,6102,3,676,338,0,6102,6103,3,764,382,0,6103,6104,5,777,0,0,6104,
  	6270,1,0,0,0,6105,6106,5,182,0,0,6106,6107,5,776,0,0,6107,6108,3,764,
  	382,0,6108,6109,5,203,0,0,6109,6110,3,676,338,0,6110,6111,5,777,0,0,6111,
  	6270,1,0,0,0,6112,6113,5,213,0,0,6113,6114,5,776,0,0,6114,6115,3,728,
  	364,0,6115,6116,5,773,0,0,6116,6117,3,676,338,0,6117,6118,5,777,0,0,6118,
  	6270,1,0,0,0,6119,6121,5,372,0,0,6120,6122,3,720,360,0,6121,6120,1,0,
  	0,0,6121,6122,1,0,0,0,6122,6270,1,0,0,0,6123,6124,5,414,0,0,6124,6125,
  	5,776,0,0,6125,6126,3,686,343,0,6126,6127,5,251,0,0,6127,6128,3,676,338,
  	0,6128,6129,5,777,0,0,6129,6270,1,0,0,0,6130,6270,3,732,366,0,6131,6133,
  	5,569,0,0,6132,6134,3,720,360,0,6133,6132,1,0,0,0,6133,6134,1,0,0,0,6134,
  	6270,1,0,0,0,6135,6136,7,94,0,0,6136,6137,5,776,0,0,6137,6138,3,766,383,
  	0,6138,6139,5,773,0,0,6139,6140,3,676,338,0,6140,6141,5,773,0,0,6141,
  	6142,3,676,338,0,6142,6143,5,777,0,0,6143,6270,1,0,0,0,6144,6146,5,622,
  	0,0,6145,6147,3,1188,594,0,6146,6145,1,0,0,0,6146,6147,1,0,0,0,6147,6270,
  	1,0,0,0,6148,6150,5,624,0,0,6149,6151,3,720,360,0,6150,6149,1,0,0,0,6150,
  	6151,1,0,0,0,6151,6270,1,0,0,0,6152,6154,5,623,0,0,6153,6155,3,720,360,
  	0,6154,6153,1,0,0,0,6154,6155,1,0,0,0,6155,6270,1,0,0,0,6156,6157,5,19,
  	0,0,6157,6270,3,770,385,0,6158,6159,5,58,0,0,6159,6270,3,770,385,0,6160,
  	6161,5,67,0,0,6161,6270,3,768,384,0,6162,6163,5,70,0,0,6163,6270,3,770,
  	385,0,6164,6165,5,109,0,0,6165,6270,3,1188,594,0,6166,6167,5,231,0,0,
  	6167,6168,5,776,0,0,6168,6169,3,676,338,0,6169,6170,5,773,0,0,6170,6171,
  	3,676,338,0,6171,6172,5,773,0,0,6172,6173,3,676,338,0,6173,6174,5,777,
  	0,0,6174,6270,1,0,0,0,6175,6176,5,201,0,0,6176,6177,5,776,0,0,6177,6178,
  	3,676,338,0,6178,6179,5,773,0,0,6179,6182,3,676,338,0,6180,6181,5,773,
  	0,0,6181,6183,3,676,338,0,6182,6180,1,0,0,0,6182,6183,1,0,0,0,6183,6184,
  	1,0,0,0,6184,6185,5,777,0,0,6185,6270,1,0,0,0,6186,6187,5,337,0,0,6187,
  	6270,3,770,385,0,6188,6189,5,349,0,0,6189,6190,5,776,0,0,6190,6191,3,
  	676,338,0,6191,6192,5,773,0,0,6192,6193,3,676,338,0,6193,6194,5,777,0,
  	0,6194,6270,1,0,0,0,6195,6196,4,358,166,0,6196,6197,5,382,0,0,6197,6198,
  	5,776,0,0,6198,6199,3,1160,580,0,6199,6200,5,777,0,0,6200,6270,1,0,0,
  	0,6201,6202,4,358,167,0,6202,6203,5,406,0,0,6203,6270,3,770,385,0,6204,
  	6205,5,429,0,0,6205,6270,3,770,385,0,6206,6207,5,457,0,0,6207,6208,5,
  	776,0,0,6208,6209,3,676,338,0,6209,6210,5,773,0,0,6210,6211,3,676,338,
  	0,6211,6212,5,777,0,0,6212,6270,1,0,0,0,6213,6214,5,458,0,0,6214,6215,
  	5,776,0,0,6215,6216,3,676,338,0,6216,6217,5,773,0,0,6217,6218,3,676,338,
  	0,6218,6219,5,773,0,0,6219,6220,3,676,338,0,6220,6221,5,777,0,0,6221,
  	6270,1,0,0,0,6222,6223,5,476,0,0,6223,6270,3,770,385,0,6224,6225,5,485,
  	0,0,6225,6270,3,1188,594,0,6226,6227,5,597,0,0,6227,6228,5,776,0,0,6228,
  	6229,3,676,338,0,6229,6230,5,773,0,0,6230,6231,3,676,338,0,6231,6232,
  	5,777,0,0,6232,6270,1,0,0,0,6233,6234,5,640,0,0,6234,6235,5,776,0,0,6235,
  	6238,3,676,338,0,6236,6237,5,773,0,0,6237,6239,3,676,338,0,6238,6236,
  	1,0,0,0,6238,6239,1,0,0,0,6239,6240,1,0,0,0,6240,6241,5,777,0,0,6241,
  	6270,1,0,0,0,6242,6243,5,641,0,0,6243,6244,5,776,0,0,6244,6264,3,676,
  	338,0,6245,6246,5,17,0,0,6246,6247,5,60,0,0,6247,6249,3,932,466,0,6248,
  	6245,1,0,0,0,6248,6249,1,0,0,0,6249,6252,1,0,0,0,6250,6251,4,358,168,
  	0,6251,6253,3,724,362,0,6252,6250,1,0,0,0,6252,6253,1,0,0,0,6253,6265,
  	1,0,0,0,6254,6255,5,17,0,0,6255,6256,5,32,0,0,6256,6265,3,932,466,0,6257,
  	6258,5,773,0,0,6258,6259,3,1140,570,0,6259,6260,5,773,0,0,6260,6261,3,
  	1140,570,0,6261,6262,5,773,0,0,6262,6263,3,1140,570,0,6263,6265,1,0,0,
  	0,6264,6248,1,0,0,0,6264,6254,1,0,0,0,6264,6257,1,0,0,0,6265,6266,1,0,
  	0,0,6266,6267,5,777,0,0,6267,6270,1,0,0,0,6268,6270,3,718,359,0,6269,
  	5996,1,0,0,0,6269,6005,1,0,0,0,6269,6009,1,0,0,0,6269,6011,1,0,0,0,6269,
  	6013,1,0,0,0,6269,6015,1,0,0,0,6269,6026,1,0,0,0,6269,6037,1,0,0,0,6269,
  	6044,1,0,0,0,6269,6046,1,0,0,0,6269,6048,1,0,0,0,6269,6055,1,0,0,0,6269,
  	6057,1,0,0,0,6269,6059,1,0,0,0,6269,6068,1,0,0,0,6269,6069,1,0,0,0,6269,
  	6071,1,0,0,0,6269,6073,1,0,0,0,6269,6075,1,0,0,0,6269,6088,1,0,0,0,6269,
  	6092,1,0,0,0,6269,6096,1,0,0,0,6269,6105,1,0,0,0,6269,6112,1,0,0,0,6269,
  	6119,1,0,0,0,6269,6123,1,0,0,0,6269,6130,1,0,0,0,6269,6131,1,0,0,0,6269,
  	6135,1,0,0,0,6269,6144,1,0,0,0,6269,6148,1,0,0,0,6269,6152,1,0,0,0,6269,
  	6156,1,0,0,0,6269,6158,1,0,0,0,6269,6160,1,0,0,0,6269,6162,1,0,0,0,6269,
  	6164,1,0,0,0,6269,6166,1,0,0,0,6269,6175,1,0,0,0,6269,6186,1,0,0,0,6269,
  	6188,1,0,0,0,6269,6195,1,0,0,0,6269,6201,1,0,0,0,6269,6204,1,0,0,0,6269,
  	6206,1,0,0,0,6269,6213,1,0,0,0,6269,6222,1,0,0,0,6269,6224,1,0,0,0,6269,
  	6226,1,0,0,0,6269,6233,1,0,0,0,6269,6242,1,0,0,0,6269,6268,1,0,0,0,6270,
  	717,1,0,0,0,6271,6272,4,359,169,0,6272,6273,5,90,0,0,6273,6274,5,776,
  	0,0,6274,6275,3,676,338,0,6275,6276,5,773,0,0,6276,6277,3,676,338,0,6277,
  	6278,5,777,0,0,6278,6303,1,0,0,0,6279,6280,5,211,0,0,6280,6282,5,776,
  	0,0,6281,6283,3,756,378,0,6282,6281,1,0,0,0,6282,6283,1,0,0,0,6283,6284,
  	1,0,0,0,6284,6303,5,777,0,0,6285,6286,5,279,0,0,6286,6303,3,768,384,0,
  	6287,6288,5,351,0,0,6288,6303,3,768,384,0,6289,6290,5,352,0,0,6290,6303,
  	3,768,384,0,6291,6292,5,353,0,0,6292,6303,3,768,384,0,6293,6294,5,411,
  	0,0,6294,6295,5,776,0,0,6295,6296,3,676,338,0,6296,6297,5,773,0,0,6297,
  	6298,3,676,338,0,6298,6299,5,777,0,0,6299,6303,1,0,0,0,6300,6301,5,412,
  	0,0,6301,6303,3,768,384,0,6302,6271,1,0,0,0,6302,6279,1,0,0,0,6302,6285,
  	1,0,0,0,6302,6287,1,0,0,0,6302,6289,1,0,0,0,6302,6291,1,0,0,0,6302,6293,
  	1,0,0,0,6302,6300,1,0,0,0,6303,719,1,0,0,0,6304,6306,5,776,0,0,6305,6307,
  	3,722,361,0,6306,6305,1,0,0,0,6306,6307,1,0,0,0,6307,6308,1,0,0,0,6308,
  	6309,5,777,0,0,6309,721,1,0,0,0,6310,6311,4,361,170,0,6311,6312,5,747,
  	0,0,6312,723,1,0,0,0,6313,6326,5,274,0,0,6314,6315,3,1142,571,0,6315,
  	6316,5,759,0,0,6316,6317,3,1142,571,0,6317,6327,1,0,0,0,6318,6323,3,726,
  	363,0,6319,6320,5,773,0,0,6320,6322,3,726,363,0,6321,6319,1,0,0,0,6322,
  	6325,1,0,0,0,6323,6321,1,0,0,0,6323,6324,1,0,0,0,6324,6327,1,0,0,0,6325,
  	6323,1,0,0,0,6326,6314,1,0,0,0,6326,6318,1,0,0,0,6327,725,1,0,0,0,6328,
  	6334,3,1142,571,0,6329,6331,7,33,0,0,6330,6332,5,476,0,0,6331,6330,1,
  	0,0,0,6331,6332,1,0,0,0,6332,6335,1,0,0,0,6333,6335,5,476,0,0,6334,6329,
  	1,0,0,0,6334,6333,1,0,0,0,6334,6335,1,0,0,0,6335,727,1,0,0,0,6336,6337,
  	7,95,0,0,6337,729,1,0,0,0,6338,6339,5,595,0,0,6339,6363,5,776,0,0,6340,
  	6343,3,676,338,0,6341,6342,5,203,0,0,6342,6344,3,676,338,0,6343,6341,
  	1,0,0,0,6343,6344,1,0,0,0,6344,6364,1,0,0,0,6345,6347,5,269,0,0,6346,
  	6348,3,676,338,0,6347,6346,1,0,0,0,6347,6348,1,0,0,0,6348,6349,1,0,0,
  	0,6349,6350,5,203,0,0,6350,6364,3,676,338,0,6351,6353,5,591,0,0,6352,
  	6354,3,676,338,0,6353,6352,1,0,0,0,6353,6354,1,0,0,0,6354,6355,1,0,0,
  	0,6355,6356,5,203,0,0,6356,6364,3,676,338,0,6357,6359,5,43,0,0,6358,6360,
  	3,676,338,0,6359,6358,1,0,0,0,6359,6360,1,0,0,0,6360,6361,1,0,0,0,6361,
  	6362,5,203,0,0,6362,6364,3,676,338,0,6363,6340,1,0,0,0,6363,6345,1,0,
  	0,0,6363,6351,1,0,0,0,6363,6357,1,0,0,0,6364,6365,1,0,0,0,6365,6366,5,
  	777,0,0,6366,731,1,0,0,0,6367,6368,5,563,0,0,6368,6369,5,776,0,0,6369,
  	6382,3,676,338,0,6370,6371,5,773,0,0,6371,6374,3,676,338,0,6372,6373,
  	5,773,0,0,6373,6375,3,676,338,0,6374,6372,1,0,0,0,6374,6375,1,0,0,0,6375,
  	6383,1,0,0,0,6376,6377,5,203,0,0,6377,6380,3,676,338,0,6378,6379,5,200,
  	0,0,6379,6381,3,676,338,0,6380,6378,1,0,0,0,6380,6381,1,0,0,0,6381,6383,
  	1,0,0,0,6382,6370,1,0,0,0,6382,6376,1,0,0,0,6383,6384,1,0,0,0,6384,6385,
  	5,777,0,0,6385,733,1,0,0,0,6386,6387,3,1126,563,0,6387,6389,5,776,0,0,
  	6388,6390,3,736,368,0,6389,6388,1,0,0,0,6389,6390,1,0,0,0,6390,6391,1,
  	0,0,0,6391,6392,5,777,0,0,6392,6401,1,0,0,0,6393,6394,3,1134,567,0,6394,
  	6396,5,776,0,0,6395,6397,3,756,378,0,6396,6395,1,0,0,0,6396,6397,1,0,
  	0,0,6397,6398,1,0,0,0,6398,6399,5,777,0,0,6399,6401,1,0,0,0,6400,6386,
  	1,0,0,0,6400,6393,1,0,0,0,6401,735,1,0,0,0,6402,6407,3,738,369,0,6403,
  	6404,5,773,0,0,6404,6406,3,738,369,0,6405,6403,1,0,0,0,6406,6409,1,0,
  	0,0,6407,6405,1,0,0,0,6407,6408,1,0,0,0,6408,737,1,0,0,0,6409,6407,1,
  	0,0,0,6410,6412,3,676,338,0,6411,6413,3,356,178,0,6412,6411,1,0,0,0,6412,
  	6413,1,0,0,0,6413,739,1,0,0,0,6414,6417,3,742,371,0,6415,6417,3,744,372,
  	0,6416,6414,1,0,0,0,6416,6415,1,0,0,0,6417,741,1,0,0,0,6418,6419,5,783,
  	0,0,6419,6422,3,1180,590,0,6420,6422,5,784,0,0,6421,6418,1,0,0,0,6421,
  	6420,1,0,0,0,6422,743,1,0,0,0,6423,6425,5,785,0,0,6424,6426,3,1194,597,
  	0,6425,6424,1,0,0,0,6425,6426,1,0,0,0,6426,6427,1,0,0,0,6427,6429,3,1180,
  	590,0,6428,6430,3,1138,569,0,6429,6428,1,0,0,0,6429,6430,1,0,0,0,6430,
  	745,1,0,0,0,6431,6432,4,373,171,0,6432,6434,3,1128,564,0,6433,6435,3,
  	1138,569,0,6434,6433,1,0,0,0,6434,6435,1,0,0,0,6435,6442,1,0,0,0,6436,
  	6437,4,373,172,0,6437,6439,3,1182,591,0,6438,6440,3,1138,569,0,6439,6438,
  	1,0,0,0,6439,6440,1,0,0,0,6440,6442,1,0,0,0,6441,6431,1,0,0,0,6441,6436,
  	1,0,0,0,6442,6446,1,0,0,0,6443,6444,5,128,0,0,6444,6446,3,1138,569,0,
  	6445,6441,1,0,0,0,6445,6443,1,0,0,0,6446,747,1,0,0,0,6447,6448,5,642,
  	0,0,6448,6449,3,676,338,0,6449,749,1,0,0,0,6450,6451,5,582,0,0,6451,6452,
  	3,676,338,0,6452,751,1,0,0,0,6453,6454,5,154,0,0,6454,6455,3,676,338,
  	0,6455,753,1,0,0,0,6456,6458,5,32,0,0,6457,6459,3,922,461,0,6458,6457,
  	1,0,0,0,6458,6459,1,0,0,0,6459,6502,1,0,0,0,6460,6462,5,60,0,0,6461,6463,
  	3,922,461,0,6462,6461,1,0,0,0,6462,6463,1,0,0,0,6463,6465,1,0,0,0,6464,
  	6466,3,926,463,0,6465,6464,1,0,0,0,6465,6466,1,0,0,0,6466,6502,1,0,0,
  	0,6467,6469,3,918,459,0,6468,6470,3,922,461,0,6469,6468,1,0,0,0,6469,
  	6470,1,0,0,0,6470,6502,1,0,0,0,6471,6473,5,512,0,0,6472,6474,5,249,0,
  	0,6473,6472,1,0,0,0,6473,6474,1,0,0,0,6474,6502,1,0,0,0,6475,6477,5,612,
  	0,0,6476,6478,5,249,0,0,6477,6476,1,0,0,0,6477,6478,1,0,0,0,6478,6502,
  	1,0,0,0,6479,6502,5,116,0,0,6480,6482,5,586,0,0,6481,6483,3,934,467,0,
  	6482,6481,1,0,0,0,6482,6483,1,0,0,0,6483,6502,1,0,0,0,6484,6486,5,113,
  	0,0,6485,6487,3,934,467,0,6486,6485,1,0,0,0,6486,6487,1,0,0,0,6487,6502,
  	1,0,0,0,6488,6490,5,126,0,0,6489,6491,3,1174,587,0,6490,6489,1,0,0,0,
  	6490,6491,1,0,0,0,6491,6502,1,0,0,0,6492,6493,4,377,173,0,6493,6502,5,
  	262,0,0,6494,6495,4,377,174,0,6495,6502,3,920,460,0,6496,6497,4,377,175,
  	0,6497,6499,5,195,0,0,6498,6500,3,1176,588,0,6499,6498,1,0,0,0,6499,6500,
  	1,0,0,0,6500,6502,1,0,0,0,6501,6456,1,0,0,0,6501,6460,1,0,0,0,6501,6467,
  	1,0,0,0,6501,6471,1,0,0,0,6501,6475,1,0,0,0,6501,6479,1,0,0,0,6501,6480,
  	1,0,0,0,6501,6484,1,0,0,0,6501,6488,1,0,0,0,6501,6492,1,0,0,0,6501,6494,
  	1,0,0,0,6501,6496,1,0,0,0,6502,755,1,0,0,0,6503,6508,3,676,338,0,6504,
  	6505,5,773,0,0,6505,6507,3,676,338,0,6506,6504,1,0,0,0,6507,6510,1,0,
  	0,0,6508,6506,1,0,0,0,6508,6509,1,0,0,0,6509,757,1,0,0,0,6510,6508,1,
  	0,0,0,6511,6512,5,60,0,0,6512,6515,5,506,0,0,6513,6515,5,58,0,0,6514,
  	6511,1,0,0,0,6514,6513,1,0,0,0,6515,759,1,0,0,0,6516,6517,7,96,0,0,6517,
  	761,1,0,0,0,6518,6519,7,97,0,0,6519,763,1,0,0,0,6520,6523,3,766,383,0,
  	6521,6523,7,98,0,0,6522,6520,1,0,0,0,6522,6521,1,0,0,0,6523,765,1,0,0,
  	0,6524,6525,7,99,0,0,6525,767,1,0,0,0,6526,6527,5,776,0,0,6527,6528,3,
  	756,378,0,6528,6529,5,777,0,0,6529,769,1,0,0,0,6530,6531,5,776,0,0,6531,
  	6532,3,676,338,0,6532,6533,5,777,0,0,6533,771,1,0,0,0,6534,6535,5,776,
  	0,0,6535,6536,3,688,344,0,6536,6537,5,777,0,0,6537,773,1,0,0,0,6538,6543,
  	3,776,388,0,6539,6540,5,773,0,0,6540,6542,3,776,388,0,6541,6539,1,0,0,
  	0,6542,6545,1,0,0,0,6543,6541,1,0,0,0,6543,6544,1,0,0,0,6544,775,1,0,
  	0,0,6545,6543,1,0,0,0,6546,6548,3,676,338,0,6547,6549,3,330,165,0,6548,
  	6547,1,0,0,0,6548,6549,1,0,0,0,6549,777,1,0,0,0,6550,6555,3,780,390,0,
  	6551,6552,5,773,0,0,6552,6554,3,780,390,0,6553,6551,1,0,0,0,6554,6557,
  	1,0,0,0,6555,6553,1,0,0,0,6555,6556,1,0,0,0,6556,779,1,0,0,0,6557,6555,
  	1,0,0,0,6558,6559,3,676,338,0,6559,781,1,0,0,0,6560,6561,4,391,176,0,
  	6561,6562,5,200,0,0,6562,6563,5,57,0,0,6563,6564,3,1162,581,0,6564,783,
  	1,0,0,0,6565,6579,3,2,1,0,6566,6579,3,786,393,0,6567,6579,3,788,394,0,
  	6568,6579,3,796,398,0,6569,6579,3,800,400,0,6570,6579,3,802,401,0,6571,
  	6579,3,808,404,0,6572,6579,3,810,405,0,6573,6579,3,838,419,0,6574,6579,
  	3,836,418,0,6575,6579,3,856,428,0,6576,6579,3,860,430,0,6577,6579,3,858,
  	429,0,6578,6565,1,0,0,0,6578,6566,1,0,0,0,6578,6567,1,0,0,0,6578,6568,
  	1,0,0,0,6578,6569,1,0,0,0,6578,6570,1,0,0,0,6578,6571,1,0,0,0,6578,6572,
  	1,0,0,0,6578,6573,1,0,0,0,6578,6574,1,0,0,0,6578,6575,1,0,0,0,6578,6576,
  	1,0,0,0,6578,6577,1,0,0,0,6579,785,1,0,0,0,6580,6581,5,475,0,0,6581,6582,
  	3,676,338,0,6582,787,1,0,0,0,6583,6584,5,231,0,0,6584,6585,3,790,395,
  	0,6585,6586,5,159,0,0,6586,6587,5,231,0,0,6587,789,1,0,0,0,6588,6589,
  	3,676,338,0,6589,6594,3,792,396,0,6590,6591,5,155,0,0,6591,6595,3,790,
  	395,0,6592,6593,5,154,0,0,6593,6595,3,794,397,0,6594,6590,1,0,0,0,6594,
  	6592,1,0,0,0,6594,6595,1,0,0,0,6595,791,1,0,0,0,6596,6597,5,582,0,0,6597,
  	6598,3,794,397,0,6598,793,1,0,0,0,6599,6600,3,784,392,0,6600,6601,5,774,
  	0,0,6601,6603,1,0,0,0,6602,6599,1,0,0,0,6603,6604,1,0,0,0,6604,6602,1,
  	0,0,0,6604,6605,1,0,0,0,6605,795,1,0,0,0,6606,6608,5,51,0,0,6607,6609,
  	3,676,338,0,6608,6607,1,0,0,0,6608,6609,1,0,0,0,6609,6613,1,0,0,0,6610,
  	6611,3,748,374,0,6611,6612,3,792,396,0,6612,6614,1,0,0,0,6613,6610,1,
  	0,0,0,6614,6615,1,0,0,0,6615,6613,1,0,0,0,6615,6616,1,0,0,0,6616,6618,
  	1,0,0,0,6617,6619,3,798,399,0,6618,6617,1,0,0,0,6618,6619,1,0,0,0,6619,
  	6620,1,0,0,0,6620,6621,5,159,0,0,6621,6622,5,51,0,0,6622,797,1,0,0,0,
  	6623,6624,5,154,0,0,6624,6625,3,794,397,0,6625,799,1,0,0,0,6626,6627,
  	3,804,402,0,6627,6629,3,806,403,0,6628,6630,3,1112,556,0,6629,6628,1,
  	0,0,0,6629,6630,1,0,0,0,6630,801,1,0,0,0,6631,6632,3,806,403,0,6632,803,
  	1,0,0,0,6633,6634,3,1110,555,0,6634,6635,5,775,0,0,6635,805,1,0,0,0,6636,
  	6638,5,29,0,0,6637,6639,3,818,409,0,6638,6637,1,0,0,0,6638,6639,1,0,0,
  	0,6639,6641,1,0,0,0,6640,6642,3,794,397,0,6641,6640,1,0,0,0,6641,6642,
  	1,0,0,0,6642,6643,1,0,0,0,6643,6644,5,159,0,0,6644,807,1,0,0,0,6645,6646,
  	3,804,402,0,6646,6648,3,810,405,0,6647,6649,3,1112,556,0,6648,6647,1,
  	0,0,0,6648,6649,1,0,0,0,6649,809,1,0,0,0,6650,6654,3,812,406,0,6651,6654,
  	3,814,407,0,6652,6654,3,816,408,0,6653,6650,1,0,0,0,6653,6651,1,0,0,0,
  	6653,6652,1,0,0,0,6654,811,1,0,0,0,6655,6656,5,294,0,0,6656,6657,3,794,
  	397,0,6657,6658,5,159,0,0,6658,6659,5,294,0,0,6659,813,1,0,0,0,6660,6661,
  	5,644,0,0,6661,6662,3,676,338,0,6662,6663,5,147,0,0,6663,6664,3,794,397,
  	0,6664,6665,5,159,0,0,6665,6666,5,644,0,0,6666,815,1,0,0,0,6667,6668,
  	5,457,0,0,6668,6669,3,794,397,0,6669,6670,5,613,0,0,6670,6671,3,676,338,
  	0,6671,6672,5,159,0,0,6672,6673,5,457,0,0,6673,817,1,0,0,0,6674,6675,
  	3,820,410,0,6675,6676,5,774,0,0,6676,6678,1,0,0,0,6677,6674,1,0,0,0,6678,
  	6679,1,0,0,0,6679,6677,1,0,0,0,6679,6680,1,0,0,0,6680,819,1,0,0,0,6681,
  	6686,3,822,411,0,6682,6686,3,824,412,0,6683,6686,3,830,415,0,6684,6686,
  	3,834,417,0,6685,6681,1,0,0,0,6685,6682,1,0,0,0,6685,6683,1,0,0,0,6685,
  	6684,1,0,0,0,6686,821,1,0,0,0,6687,6688,5,127,0,0,6688,6689,3,1130,565,
  	0,6689,6691,3,916,458,0,6690,6692,3,986,493,0,6691,6690,1,0,0,0,6691,
  	6692,1,0,0,0,6692,6695,1,0,0,0,6693,6694,5,128,0,0,6694,6696,3,676,338,
  	0,6695,6693,1,0,0,0,6695,6696,1,0,0,0,6696,823,1,0,0,0,6697,6698,5,127,
  	0,0,6698,6699,3,1128,564,0,6699,6700,5,83,0,0,6700,6701,5,200,0,0,6701,
  	6702,3,826,413,0,6702,825,1,0,0,0,6703,6706,3,1140,570,0,6704,6706,3,
  	828,414,0,6705,6703,1,0,0,0,6705,6704,1,0,0,0,6706,827,1,0,0,0,6707,6709,
  	5,526,0,0,6708,6710,5,627,0,0,6709,6708,1,0,0,0,6709,6710,1,0,0,0,6710,
  	6711,1,0,0,0,6711,6712,3,1160,580,0,6712,829,1,0,0,0,6713,6714,5,127,
  	0,0,6714,6715,7,100,0,0,6715,6716,5,219,0,0,6716,6717,5,200,0,0,6717,
  	6722,3,832,416,0,6718,6719,5,773,0,0,6719,6721,3,832,416,0,6720,6718,
  	1,0,0,0,6721,6724,1,0,0,0,6722,6720,1,0,0,0,6722,6723,1,0,0,0,6723,6725,
  	1,0,0,0,6724,6722,1,0,0,0,6725,6726,3,784,392,0,6726,831,1,0,0,0,6727,
  	6735,3,826,413,0,6728,6735,3,1128,564,0,6729,6735,5,527,0,0,6730,6731,
  	3,760,380,0,6731,6732,5,202,0,0,6732,6735,1,0,0,0,6733,6735,5,525,0,0,
  	6734,6727,1,0,0,0,6734,6728,1,0,0,0,6734,6729,1,0,0,0,6734,6730,1,0,0,
  	0,6734,6733,1,0,0,0,6735,833,1,0,0,0,6736,6737,5,127,0,0,6737,6738,3,
  	1128,564,0,6738,6739,5,106,0,0,6739,6740,5,200,0,0,6740,6741,3,266,133,
  	0,6741,835,1,0,0,0,6742,6743,5,260,0,0,6743,6744,3,1112,556,0,6744,837,
  	1,0,0,0,6745,6746,5,271,0,0,6746,6747,3,1112,556,0,6747,839,1,0,0,0,6748,
  	6752,5,207,0,0,6749,6753,5,101,0,0,6750,6751,4,420,177,0,6751,6753,5,
  	540,0,0,6752,6749,1,0,0,0,6752,6750,1,0,0,0,6752,6753,1,0,0,0,6753,6754,
  	1,0,0,0,6754,6773,5,138,0,0,6755,6760,3,844,422,0,6756,6757,5,773,0,0,
  	6757,6759,3,844,422,0,6758,6756,1,0,0,0,6759,6762,1,0,0,0,6760,6758,1,
  	0,0,0,6760,6761,1,0,0,0,6761,6774,1,0,0,0,6762,6760,1,0,0,0,6763,6764,
  	5,83,0,0,6764,6765,3,842,421,0,6765,6770,3,846,423,0,6766,6767,5,773,
  	0,0,6767,6769,3,846,423,0,6768,6766,1,0,0,0,6769,6772,1,0,0,0,6770,6768,
  	1,0,0,0,6770,6771,1,0,0,0,6771,6774,1,0,0,0,6772,6770,1,0,0,0,6773,6755,
  	1,0,0,0,6773,6763,1,0,0,0,6774,841,1,0,0,0,6775,6779,3,1148,574,0,6776,
  	6779,3,740,370,0,6777,6779,3,1134,567,0,6778,6775,1,0,0,0,6778,6776,1,
  	0,0,0,6778,6777,1,0,0,0,6779,843,1,0,0,0,6780,6783,3,740,370,0,6781,6783,
  	3,1128,564,0,6782,6780,1,0,0,0,6782,6781,1,0,0,0,6783,6784,1,0,0,0,6784,
  	6785,5,750,0,0,6785,6786,7,101,0,0,6786,845,1,0,0,0,6787,6790,3,740,370,
  	0,6788,6790,3,1128,564,0,6789,6787,1,0,0,0,6789,6788,1,0,0,0,6790,6791,
  	1,0,0,0,6791,6794,5,750,0,0,6792,6795,3,848,424,0,6793,6795,5,473,0,0,
  	6794,6792,1,0,0,0,6794,6793,1,0,0,0,6795,847,1,0,0,0,6796,6797,7,102,
  	0,0,6797,849,1,0,0,0,6798,6801,5,511,0,0,6799,6802,3,1128,564,0,6800,
  	6802,3,828,414,0,6801,6799,1,0,0,0,6801,6800,1,0,0,0,6802,6812,1,0,0,
  	0,6803,6804,5,506,0,0,6804,6809,3,854,427,0,6805,6806,5,773,0,0,6806,
  	6808,3,854,427,0,6807,6805,1,0,0,0,6808,6811,1,0,0,0,6809,6807,1,0,0,
  	0,6809,6810,1,0,0,0,6810,6813,1,0,0,0,6811,6809,1,0,0,0,6812,6803,1,0,
  	0,0,6812,6813,1,0,0,0,6813,851,1,0,0,0,6814,6817,5,469,0,0,6815,6818,
  	3,1128,564,0,6816,6818,3,828,414,0,6817,6815,1,0,0,0,6817,6816,1,0,0,
  	0,6817,6818,1,0,0,0,6818,6828,1,0,0,0,6819,6820,5,506,0,0,6820,6825,3,
  	854,427,0,6821,6822,5,773,0,0,6822,6824,3,854,427,0,6823,6821,1,0,0,0,
  	6824,6827,1,0,0,0,6825,6823,1,0,0,0,6825,6826,1,0,0,0,6826,6829,1,0,0,
  	0,6827,6825,1,0,0,0,6828,6819,1,0,0,0,6828,6829,1,0,0,0,6829,853,1,0,
  	0,0,6830,6831,3,848,424,0,6831,6832,5,750,0,0,6832,6833,3,842,421,0,6833,
  	855,1,0,0,0,6834,6835,5,387,0,0,6835,6836,3,1128,564,0,6836,857,1,0,0,
  	0,6837,6838,5,66,0,0,6838,6839,3,1128,564,0,6839,859,1,0,0,0,6840,6845,
  	5,186,0,0,6841,6843,5,367,0,0,6842,6841,1,0,0,0,6842,6843,1,0,0,0,6843,
  	6844,1,0,0,0,6844,6846,5,203,0,0,6845,6842,1,0,0,0,6845,6846,1,0,0,0,
  	6846,6847,1,0,0,0,6847,6848,3,1128,564,0,6848,6849,5,248,0,0,6849,6850,
  	3,1130,565,0,6850,861,1,0,0,0,6851,6852,5,21,0,0,6852,6865,3,676,338,
  	0,6853,6854,5,171,0,0,6854,6855,3,676,338,0,6855,6858,3,764,382,0,6856,
  	6857,5,542,0,0,6857,6859,3,676,338,0,6858,6856,1,0,0,0,6858,6859,1,0,
  	0,0,6859,6862,1,0,0,0,6860,6861,5,160,0,0,6861,6863,3,676,338,0,6862,
  	6860,1,0,0,0,6862,6863,1,0,0,0,6863,6865,1,0,0,0,6864,6851,1,0,0,0,6864,
  	6853,1,0,0,0,6865,863,1,0,0,0,6866,6867,3,1040,520,0,6867,6869,3,876,
  	438,0,6868,6870,3,866,433,0,6869,6868,1,0,0,0,6869,6870,1,0,0,0,6870,
  	865,1,0,0,0,6871,6872,4,433,178,0,6872,6875,3,868,434,0,6873,6875,3,886,
  	443,0,6874,6871,1,0,0,0,6874,6873,1,0,0,0,6875,867,1,0,0,0,6876,6877,
  	5,62,0,0,6877,6878,3,770,385,0,6878,869,1,0,0,0,6879,6881,5,371,0,0,6880,
  	6879,1,0,0,0,6880,6881,1,0,0,0,6881,6882,1,0,0,0,6882,6883,5,730,0,0,
  	6883,871,1,0,0,0,6884,6886,7,38,0,0,6885,6887,3,108,54,0,6886,6885,1,
  	0,0,0,6886,6887,1,0,0,0,6887,6888,1,0,0,0,6888,6892,3,898,449,0,6889,
  	6891,3,902,451,0,6890,6889,1,0,0,0,6891,6894,1,0,0,0,6892,6890,1,0,0,
  	0,6892,6893,1,0,0,0,6893,6960,1,0,0,0,6894,6892,1,0,0,0,6895,6897,5,205,
  	0,0,6896,6898,3,406,203,0,6897,6896,1,0,0,0,6897,6898,1,0,0,0,6898,6900,
  	1,0,0,0,6899,6901,3,1050,525,0,6900,6899,1,0,0,0,6900,6901,1,0,0,0,6901,
  	6902,1,0,0,0,6902,6906,3,898,449,0,6903,6905,3,910,455,0,6904,6903,1,
  	0,0,0,6905,6908,1,0,0,0,6906,6904,1,0,0,0,6906,6907,1,0,0,0,6907,6960,
  	1,0,0,0,6908,6906,1,0,0,0,6909,6911,5,523,0,0,6910,6912,3,406,203,0,6911,
  	6910,1,0,0,0,6911,6912,1,0,0,0,6912,6914,1,0,0,0,6913,6915,3,1050,525,
  	0,6914,6913,1,0,0,0,6914,6915,1,0,0,0,6915,6916,1,0,0,0,6916,6920,3,898,
  	449,0,6917,6919,3,912,456,0,6918,6917,1,0,0,0,6919,6922,1,0,0,0,6920,
  	6918,1,0,0,0,6920,6921,1,0,0,0,6921,6960,1,0,0,0,6922,6920,1,0,0,0,6923,
  	6925,3,874,437,0,6924,6923,1,0,0,0,6924,6925,1,0,0,0,6925,6957,1,0,0,
  	0,6926,6927,5,420,0,0,6927,6933,5,265,0,0,6928,6930,5,609,0,0,6929,6931,
  	3,406,203,0,6930,6929,1,0,0,0,6930,6931,1,0,0,0,6931,6933,1,0,0,0,6932,
  	6926,1,0,0,0,6932,6928,1,0,0,0,6933,6935,1,0,0,0,6934,6936,3,108,54,0,
  	6935,6934,1,0,0,0,6935,6936,1,0,0,0,6936,6937,1,0,0,0,6937,6941,3,898,
  	449,0,6938,6940,3,902,451,0,6939,6938,1,0,0,0,6940,6943,1,0,0,0,6941,
  	6939,1,0,0,0,6941,6942,1,0,0,0,6942,6958,1,0,0,0,6943,6941,1,0,0,0,6944,
  	6945,5,199,0,0,6945,6947,5,265,0,0,6946,6948,3,1050,525,0,6947,6946,1,
  	0,0,0,6947,6948,1,0,0,0,6948,6949,1,0,0,0,6949,6950,3,890,445,0,6950,
  	6951,3,886,443,0,6951,6958,1,0,0,0,6952,6955,3,868,434,0,6953,6954,4,
  	436,179,0,6954,6956,3,870,435,0,6955,6953,1,0,0,0,6955,6956,1,0,0,0,6956,
  	6958,1,0,0,0,6957,6932,1,0,0,0,6957,6944,1,0,0,0,6957,6952,1,0,0,0,6958,
  	6960,1,0,0,0,6959,6884,1,0,0,0,6959,6895,1,0,0,0,6959,6909,1,0,0,0,6959,
  	6924,1,0,0,0,6960,873,1,0,0,0,6961,6963,5,86,0,0,6962,6964,3,1128,564,
  	0,6963,6962,1,0,0,0,6963,6964,1,0,0,0,6964,875,1,0,0,0,6965,7001,3,916,
  	458,0,6966,6968,3,878,439,0,6967,6966,1,0,0,0,6968,6971,1,0,0,0,6969,
  	6967,1,0,0,0,6969,6970,1,0,0,0,6970,7002,1,0,0,0,6971,6969,1,0,0,0,6972,
  	6974,4,438,180,0,6973,6975,3,986,493,0,6974,6973,1,0,0,0,6974,6975,1,
  	0,0,0,6975,6978,1,0,0,0,6976,6977,5,209,0,0,6977,6979,5,12,0,0,6978,6976,
  	1,0,0,0,6978,6979,1,0,0,0,6979,6980,1,0,0,0,6980,6981,5,17,0,0,6981,6983,
  	3,770,385,0,6982,6984,7,103,0,0,6983,6982,1,0,0,0,6983,6984,1,0,0,0,6984,
  	6999,1,0,0,0,6985,6989,4,438,181,0,6986,6988,3,884,442,0,6987,6986,1,
  	0,0,0,6988,6991,1,0,0,0,6989,6987,1,0,0,0,6989,6990,1,0,0,0,6990,7000,
  	1,0,0,0,6991,6989,1,0,0,0,6992,6996,4,438,182,0,6993,6995,3,878,439,0,
  	6994,6993,1,0,0,0,6995,6998,1,0,0,0,6996,6994,1,0,0,0,6996,6997,1,0,0,
  	0,6997,7000,1,0,0,0,6998,6996,1,0,0,0,6999,6985,1,0,0,0,6999,6992,1,0,
  	0,0,7000,7002,1,0,0,0,7001,6969,1,0,0,0,7001,6972,1,0,0,0,7002,877,1,
  	0,0,0,7003,7005,5,371,0,0,7004,7003,1,0,0,0,7004,7005,1,0,0,0,7005,7006,
  	1,0,0,0,7006,7056,3,1170,585,0,7007,7008,4,439,183,0,7008,7009,5,371,
  	0,0,7009,7056,5,720,0,0,7010,7018,5,128,0,0,7011,7019,3,1150,575,0,7012,
  	7014,5,372,0,0,7013,7015,3,720,360,0,7014,7013,1,0,0,0,7014,7015,1,0,
  	0,0,7015,7019,1,0,0,0,7016,7017,4,439,184,0,7017,7019,3,770,385,0,7018,
  	7011,1,0,0,0,7018,7012,1,0,0,0,7018,7016,1,0,0,0,7019,7056,1,0,0,0,7020,
  	7021,5,383,0,0,7021,7022,5,614,0,0,7022,7024,5,372,0,0,7023,7025,3,720,
  	360,0,7024,7023,1,0,0,0,7024,7025,1,0,0,0,7025,7056,1,0,0,0,7026,7056,
  	5,24,0,0,7027,7028,5,501,0,0,7028,7029,5,128,0,0,7029,7056,5,627,0,0,
  	7030,7032,5,420,0,0,7031,7030,1,0,0,0,7031,7032,1,0,0,0,7032,7033,1,0,
  	0,0,7033,7056,5,265,0,0,7034,7036,5,609,0,0,7035,7037,5,265,0,0,7036,
  	7035,1,0,0,0,7036,7037,1,0,0,0,7037,7056,1,0,0,0,7038,7039,5,75,0,0,7039,
  	7056,3,1160,580,0,7040,7056,3,986,493,0,7041,7042,5,74,0,0,7042,7056,
  	3,880,440,0,7043,7044,5,553,0,0,7044,7056,3,882,441,0,7045,7046,4,439,
  	185,0,7046,7047,5,707,0,0,7047,7056,3,1146,573,0,7048,7050,4,439,186,
  	0,7049,7051,3,874,437,0,7050,7049,1,0,0,0,7050,7051,1,0,0,0,7051,7052,
  	1,0,0,0,7052,7056,3,868,434,0,7053,7054,4,439,187,0,7054,7056,3,870,435,
  	0,7055,7004,1,0,0,0,7055,7007,1,0,0,0,7055,7010,1,0,0,0,7055,7020,1,0,
  	0,0,7055,7026,1,0,0,0,7055,7027,1,0,0,0,7055,7031,1,0,0,0,7055,7034,1,
  	0,0,0,7055,7038,1,0,0,0,7055,7040,1,0,0,0,7055,7041,1,0,0,0,7055,7043,
  	1,0,0,0,7055,7045,1,0,0,0,7055,7048,1,0,0,0,7055,7053,1,0,0,0,7056,879,
  	1,0,0,0,7057,7058,7,104,0,0,7058,881,1,0,0,0,7059,7060,7,105,0,0,7060,
  	883,1,0,0,0,7061,7063,5,609,0,0,7062,7064,5,265,0,0,7063,7062,1,0,0,0,
  	7063,7064,1,0,0,0,7064,7076,1,0,0,0,7065,7066,5,75,0,0,7066,7076,3,1156,
  	578,0,7067,7069,3,760,380,0,7068,7067,1,0,0,0,7068,7069,1,0,0,0,7069,
  	7070,1,0,0,0,7070,7076,5,376,0,0,7071,7073,5,420,0,0,7072,7071,1,0,0,
  	0,7072,7073,1,0,0,0,7073,7074,1,0,0,0,7074,7076,5,265,0,0,7075,7061,1,
  	0,0,0,7075,7065,1,0,0,0,7075,7068,1,0,0,0,7075,7072,1,0,0,0,7076,885,
  	1,0,0,0,7077,7078,5,443,0,0,7078,7080,3,1102,551,0,7079,7081,3,1132,566,
  	0,7080,7079,1,0,0,0,7080,7081,1,0,0,0,7081,7084,1,0,0,0,7082,7083,5,320,
  	0,0,7083,7085,7,106,0,0,7084,7082,1,0,0,0,7084,7085,1,0,0,0,7085,7102,
  	1,0,0,0,7086,7087,5,383,0,0,7087,7088,5,614,0,0,7088,7092,3,888,444,0,
  	7089,7090,5,383,0,0,7090,7091,5,133,0,0,7091,7093,3,888,444,0,7092,7089,
  	1,0,0,0,7092,7093,1,0,0,0,7093,7103,1,0,0,0,7094,7095,5,383,0,0,7095,
  	7096,5,133,0,0,7096,7100,3,888,444,0,7097,7098,5,383,0,0,7098,7099,5,
  	614,0,0,7099,7101,3,888,444,0,7100,7097,1,0,0,0,7100,7101,1,0,0,0,7101,
  	7103,1,0,0,0,7102,7086,1,0,0,0,7102,7094,1,0,0,0,7102,7103,1,0,0,0,7103,
  	887,1,0,0,0,7104,7110,7,2,0,0,7105,7106,5,506,0,0,7106,7110,3,1170,585,
  	0,7107,7108,5,373,0,0,7108,7110,5,3,0,0,7109,7104,1,0,0,0,7109,7105,1,
  	0,0,0,7109,7107,1,0,0,0,7110,889,1,0,0,0,7111,7112,5,776,0,0,7112,7117,
  	3,892,446,0,7113,7114,5,773,0,0,7114,7116,3,892,446,0,7115,7113,1,0,0,
  	0,7116,7119,1,0,0,0,7117,7115,1,0,0,0,7117,7118,1,0,0,0,7118,7120,1,0,
  	0,0,7119,7117,1,0,0,0,7120,7121,5,777,0,0,7121,891,1,0,0,0,7122,7124,
  	3,1128,564,0,7123,7125,3,922,461,0,7124,7123,1,0,0,0,7124,7125,1,0,0,
  	0,7125,7127,1,0,0,0,7126,7128,3,330,165,0,7127,7126,1,0,0,0,7127,7128,
  	1,0,0,0,7128,893,1,0,0,0,7129,7130,5,776,0,0,7130,7135,3,896,448,0,7131,
  	7132,5,773,0,0,7132,7134,3,896,448,0,7133,7131,1,0,0,0,7134,7137,1,0,
  	0,0,7135,7133,1,0,0,0,7135,7136,1,0,0,0,7136,7138,1,0,0,0,7137,7135,1,
  	0,0,0,7138,7139,5,777,0,0,7139,895,1,0,0,0,7140,7146,3,892,446,0,7141,
  	7143,3,770,385,0,7142,7144,3,330,165,0,7143,7142,1,0,0,0,7143,7144,1,
  	0,0,0,7144,7146,1,0,0,0,7145,7140,1,0,0,0,7145,7141,1,0,0,0,7146,897,
  	1,0,0,0,7147,7148,4,449,188,0,7148,7152,3,894,447,0,7149,7150,4,449,189,
  	0,7150,7152,3,890,445,0,7151,7147,1,0,0,0,7151,7149,1,0,0,0,7152,899,
  	1,0,0,0,7153,7154,7,107,0,0,7154,901,1,0,0,0,7155,7158,3,904,452,0,7156,
  	7158,3,908,454,0,7157,7155,1,0,0,0,7157,7156,1,0,0,0,7158,903,1,0,0,0,
  	7159,7161,5,264,0,0,7160,7162,5,750,0,0,7161,7160,1,0,0,0,7161,7162,1,
  	0,0,0,7162,7163,1,0,0,0,7163,7169,3,1140,570,0,7164,7165,5,75,0,0,7165,
  	7169,3,1160,580,0,7166,7167,4,452,190,0,7167,7169,3,906,453,0,7168,7159,
  	1,0,0,0,7168,7164,1,0,0,0,7168,7166,1,0,0,0,7169,905,1,0,0,0,7170,7171,
  	7,108,0,0,7171,907,1,0,0,0,7172,7173,7,109,0,0,7173,7174,3,900,450,0,
  	7174,909,1,0,0,0,7175,7180,3,904,452,0,7176,7177,5,645,0,0,7177,7178,
  	5,401,0,0,7178,7180,3,1128,564,0,7179,7175,1,0,0,0,7179,7176,1,0,0,0,
  	7180,911,1,0,0,0,7181,7182,3,904,452,0,7182,913,1,0,0,0,7183,7184,3,916,
  	458,0,7184,7185,5,0,0,1,7185,915,1,0,0,0,7186,7188,7,110,0,0,7187,7189,
  	3,922,461,0,7188,7187,1,0,0,0,7188,7189,1,0,0,0,7189,7191,1,0,0,0,7190,
  	7192,3,924,462,0,7191,7190,1,0,0,0,7191,7192,1,0,0,0,7192,7334,1,0,0,
  	0,7193,7199,5,437,0,0,7194,7196,5,146,0,0,7195,7197,5,416,0,0,7196,7195,
  	1,0,0,0,7196,7197,1,0,0,0,7197,7199,1,0,0,0,7198,7193,1,0,0,0,7198,7194,
  	1,0,0,0,7199,7201,1,0,0,0,7200,7202,3,1178,589,0,7201,7200,1,0,0,0,7201,
  	7202,1,0,0,0,7202,7204,1,0,0,0,7203,7205,3,924,462,0,7204,7203,1,0,0,
  	0,7204,7205,1,0,0,0,7205,7334,1,0,0,0,7206,7208,7,111,0,0,7207,7209,3,
  	1174,587,0,7208,7207,1,0,0,0,7208,7209,1,0,0,0,7209,7211,1,0,0,0,7210,
  	7212,3,924,462,0,7211,7210,1,0,0,0,7211,7212,1,0,0,0,7212,7334,1,0,0,
  	0,7213,7215,5,37,0,0,7214,7216,3,922,461,0,7215,7214,1,0,0,0,7215,7216,
  	1,0,0,0,7216,7334,1,0,0,0,7217,7334,7,112,0,0,7218,7220,5,60,0,0,7219,
  	7221,3,922,461,0,7220,7219,1,0,0,0,7220,7221,1,0,0,0,7221,7223,1,0,0,
  	0,7222,7224,3,926,463,0,7223,7222,1,0,0,0,7223,7224,1,0,0,0,7224,7334,
  	1,0,0,0,7225,7227,3,918,459,0,7226,7228,3,922,461,0,7227,7226,1,0,0,0,
  	7227,7228,1,0,0,0,7228,7230,1,0,0,0,7229,7231,5,32,0,0,7230,7229,1,0,
  	0,0,7230,7231,1,0,0,0,7231,7334,1,0,0,0,7232,7234,5,32,0,0,7233,7235,
  	3,922,461,0,7234,7233,1,0,0,0,7234,7235,1,0,0,0,7235,7334,1,0,0,0,7236,
  	7237,5,60,0,0,7237,7240,5,633,0,0,7238,7240,5,629,0,0,7239,7236,1,0,0,
  	0,7239,7238,1,0,0,0,7240,7241,1,0,0,0,7241,7243,3,922,461,0,7242,7244,
  	3,926,463,0,7243,7242,1,0,0,0,7243,7244,1,0,0,0,7244,7334,1,0,0,0,7245,
  	7246,5,358,0,0,7246,7256,5,629,0,0,7247,7256,5,379,0,0,7248,7249,5,361,
  	0,0,7249,7256,5,629,0,0,7250,7251,5,358,0,0,7251,7252,5,60,0,0,7252,7256,
  	5,633,0,0,7253,7254,5,361,0,0,7254,7256,5,633,0,0,7255,7245,1,0,0,0,7255,
  	7247,1,0,0,0,7255,7248,1,0,0,0,7255,7250,1,0,0,0,7255,7253,1,0,0,0,7256,
  	7257,1,0,0,0,7257,7259,3,922,461,0,7258,7260,5,32,0,0,7259,7258,1,0,0,
  	0,7259,7260,1,0,0,0,7260,7334,1,0,0,0,7261,7262,5,628,0,0,7262,7334,3,
  	922,461,0,7263,7265,5,656,0,0,7264,7266,3,922,461,0,7265,7264,1,0,0,0,
  	7265,7266,1,0,0,0,7266,7268,1,0,0,0,7267,7269,3,924,462,0,7268,7267,1,
  	0,0,0,7268,7269,1,0,0,0,7269,7334,1,0,0,0,7270,7334,5,116,0,0,7271,7273,
  	5,586,0,0,7272,7274,3,934,467,0,7273,7272,1,0,0,0,7273,7274,1,0,0,0,7274,
  	7334,1,0,0,0,7275,7277,5,583,0,0,7276,7278,3,934,467,0,7277,7276,1,0,
  	0,0,7277,7278,1,0,0,0,7278,7334,1,0,0,0,7279,7281,5,113,0,0,7280,7282,
  	3,934,467,0,7281,7280,1,0,0,0,7281,7282,1,0,0,0,7282,7334,1,0,0,0,7283,
  	7334,5,587,0,0,7284,7286,5,39,0,0,7285,7287,3,922,461,0,7286,7285,1,0,
  	0,0,7286,7287,1,0,0,0,7287,7334,1,0,0,0,7288,7334,7,113,0,0,7289,7290,
  	5,293,0,0,7290,7334,5,628,0,0,7291,7295,5,293,0,0,7292,7293,5,60,0,0,
  	7293,7296,5,633,0,0,7294,7296,5,629,0,0,7295,7292,1,0,0,0,7295,7294,1,
  	0,0,0,7295,7296,1,0,0,0,7296,7298,1,0,0,0,7297,7299,3,926,463,0,7298,
  	7297,1,0,0,0,7298,7299,1,0,0,0,7299,7334,1,0,0,0,7300,7302,5,589,0,0,
  	7301,7303,3,926,463,0,7302,7301,1,0,0,0,7302,7303,1,0,0,0,7303,7334,1,
  	0,0,0,7304,7306,5,580,0,0,7305,7307,3,922,461,0,7306,7305,1,0,0,0,7306,
  	7307,1,0,0,0,7307,7309,1,0,0,0,7308,7310,3,926,463,0,7309,7308,1,0,0,
  	0,7309,7310,1,0,0,0,7310,7334,1,0,0,0,7311,7313,5,332,0,0,7312,7314,3,
  	926,463,0,7313,7312,1,0,0,0,7313,7314,1,0,0,0,7314,7334,1,0,0,0,7315,
  	7317,5,291,0,0,7316,7318,3,926,463,0,7317,7316,1,0,0,0,7317,7318,1,0,
  	0,0,7318,7334,1,0,0,0,7319,7320,5,164,0,0,7320,7322,3,1152,576,0,7321,
  	7323,3,926,463,0,7322,7321,1,0,0,0,7322,7323,1,0,0,0,7323,7334,1,0,0,
  	0,7324,7325,5,506,0,0,7325,7327,3,1152,576,0,7326,7328,3,926,463,0,7327,
  	7326,1,0,0,0,7327,7328,1,0,0,0,7328,7334,1,0,0,0,7329,7334,5,501,0,0,
  	7330,7331,4,458,191,0,7331,7334,5,262,0,0,7332,7334,7,114,0,0,7333,7186,
  	1,0,0,0,7333,7198,1,0,0,0,7333,7206,1,0,0,0,7333,7213,1,0,0,0,7333,7217,
  	1,0,0,0,7333,7218,1,0,0,0,7333,7225,1,0,0,0,7333,7232,1,0,0,0,7333,7239,
  	1,0,0,0,7333,7255,1,0,0,0,7333,7261,1,0,0,0,7333,7263,1,0,0,0,7333,7270,
  	1,0,0,0,7333,7271,1,0,0,0,7333,7275,1,0,0,0,7333,7279,1,0,0,0,7333,7283,
  	1,0,0,0,7333,7284,1,0,0,0,7333,7288,1,0,0,0,7333,7289,1,0,0,0,7333,7291,
  	1,0,0,0,7333,7300,1,0,0,0,7333,7304,1,0,0,0,7333,7311,1,0,0,0,7333,7315,
  	1,0,0,0,7333,7319,1,0,0,0,7333,7324,1,0,0,0,7333,7329,1,0,0,0,7333,7330,
  	1,0,0,0,7333,7332,1,0,0,0,7334,917,1,0,0,0,7335,7339,5,361,0,0,7336,7337,
  	5,358,0,0,7337,7339,5,60,0,0,7338,7335,1,0,0,0,7338,7336,1,0,0,0,7339,
  	919,1,0,0,0,7340,7346,5,437,0,0,7341,7343,5,146,0,0,7342,7344,5,416,0,
  	0,7343,7342,1,0,0,0,7343,7344,1,0,0,0,7344,7346,1,0,0,0,7345,7340,1,0,
  	0,0,7345,7341,1,0,0,0,7346,921,1,0,0,0,7347,7350,5,776,0,0,7348,7351,
  	3,1146,573,0,7349,7351,5,790,0,0,7350,7348,1,0,0,0,7350,7349,1,0,0,0,
  	7351,7352,1,0,0,0,7352,7353,5,777,0,0,7353,923,1,0,0,0,7354,7356,7,115,
  	0,0,7355,7354,1,0,0,0,7356,7357,1,0,0,0,7357,7355,1,0,0,0,7357,7358,1,
  	0,0,0,7358,925,1,0,0,0,7359,7374,3,928,464,0,7360,7374,3,930,465,0,7361,
  	7374,5,46,0,0,7362,7363,3,758,379,0,7363,7365,3,936,468,0,7364,7366,5,
  	32,0,0,7365,7364,1,0,0,0,7365,7366,1,0,0,0,7366,7374,1,0,0,0,7367,7371,
  	5,32,0,0,7368,7369,3,758,379,0,7369,7370,3,936,468,0,7370,7372,1,0,0,
  	0,7371,7368,1,0,0,0,7371,7372,1,0,0,0,7372,7374,1,0,0,0,7373,7359,1,0,
  	0,0,7373,7360,1,0,0,0,7373,7361,1,0,0,0,7373,7362,1,0,0,0,7373,7367,1,
  	0,0,0,7374,927,1,0,0,0,7375,7377,5,19,0,0,7376,7378,5,32,0,0,7377,7376,
  	1,0,0,0,7377,7378,1,0,0,0,7378,7382,1,0,0,0,7379,7380,5,32,0,0,7380,7382,
  	5,19,0,0,7381,7375,1,0,0,0,7381,7379,1,0,0,0,7382,929,1,0,0,0,7383,7385,
  	5,606,0,0,7384,7386,5,32,0,0,7385,7384,1,0,0,0,7385,7386,1,0,0,0,7386,
  	7390,1,0,0,0,7387,7388,5,32,0,0,7388,7390,5,606,0,0,7389,7383,1,0,0,0,
  	7389,7387,1,0,0,0,7390,931,1,0,0,0,7391,7392,5,776,0,0,7392,7393,3,1142,
  	571,0,7393,7394,5,777,0,0,7394,933,1,0,0,0,7395,7396,5,776,0,0,7396,7397,
  	5,747,0,0,7397,7398,5,777,0,0,7398,935,1,0,0,0,7399,7404,3,1180,590,0,
  	7400,7404,5,32,0,0,7401,7402,4,468,192,0,7402,7404,5,128,0,0,7403,7399,
  	1,0,0,0,7403,7400,1,0,0,0,7403,7401,1,0,0,0,7404,937,1,0,0,0,7405,7411,
  	3,1180,590,0,7406,7407,4,469,193,0,7407,7411,5,128,0,0,7408,7409,4,469,
  	194,0,7409,7411,5,32,0,0,7410,7405,1,0,0,0,7410,7406,1,0,0,0,7410,7408,
  	1,0,0,0,7411,939,1,0,0,0,7412,7419,3,944,472,0,7413,7415,5,773,0,0,7414,
  	7413,1,0,0,0,7414,7415,1,0,0,0,7415,7416,1,0,0,0,7416,7418,3,944,472,
  	0,7417,7414,1,0,0,0,7418,7421,1,0,0,0,7419,7417,1,0,0,0,7419,7420,1,0,
  	0,0,7420,941,1,0,0,0,7421,7419,1,0,0,0,7422,7424,3,944,472,0,7423,7422,
  	1,0,0,0,7424,7425,1,0,0,0,7425,7423,1,0,0,0,7425,7426,1,0,0,0,7426,943,
  	1,0,0,0,7427,7429,5,163,0,0,7428,7430,5,750,0,0,7429,7428,1,0,0,0,7429,
  	7430,1,0,0,0,7430,7431,1,0,0,0,7431,7557,3,1094,547,0,7432,7433,4,472,
  	195,0,7433,7435,5,721,0,0,7434,7436,3,1190,595,0,7435,7434,1,0,0,0,7435,
  	7436,1,0,0,0,7436,7439,1,0,0,0,7437,7440,5,376,0,0,7438,7440,3,1180,590,
  	0,7439,7437,1,0,0,0,7439,7438,1,0,0,0,7440,7557,1,0,0,0,7441,7443,5,323,
  	0,0,7442,7444,5,750,0,0,7443,7442,1,0,0,0,7443,7444,1,0,0,0,7444,7445,
  	1,0,0,0,7445,7557,3,1144,572,0,7446,7448,5,344,0,0,7447,7449,5,750,0,
  	0,7448,7447,1,0,0,0,7448,7449,1,0,0,0,7449,7450,1,0,0,0,7450,7557,3,1144,
  	572,0,7451,7453,5,25,0,0,7452,7454,5,750,0,0,7453,7452,1,0,0,0,7453,7454,
  	1,0,0,0,7454,7455,1,0,0,0,7455,7557,3,1140,570,0,7456,7458,5,406,0,0,
  	7457,7459,5,750,0,0,7458,7457,1,0,0,0,7458,7459,1,0,0,0,7459,7460,1,0,
  	0,0,7460,7557,3,1154,577,0,7461,7463,5,75,0,0,7462,7464,5,750,0,0,7463,
  	7462,1,0,0,0,7463,7464,1,0,0,0,7464,7465,1,0,0,0,7465,7557,3,1154,577,
  	0,7466,7467,4,472,196,0,7467,7469,5,81,0,0,7468,7470,5,750,0,0,7469,7468,
  	1,0,0,0,7469,7470,1,0,0,0,7470,7471,1,0,0,0,7471,7557,3,1156,578,0,7472,
  	7473,4,472,197,0,7473,7475,5,158,0,0,7474,7476,5,750,0,0,7475,7474,1,
  	0,0,0,7475,7476,1,0,0,0,7476,7477,1,0,0,0,7477,7557,3,1156,578,0,7478,
  	7480,5,24,0,0,7479,7481,5,750,0,0,7480,7479,1,0,0,0,7480,7481,1,0,0,0,
  	7481,7482,1,0,0,0,7482,7557,3,1144,572,0,7483,7485,5,399,0,0,7484,7486,
  	5,750,0,0,7485,7484,1,0,0,0,7485,7486,1,0,0,0,7486,7487,1,0,0,0,7487,
  	7557,3,946,473,0,7488,7490,7,116,0,0,7489,7491,5,750,0,0,7490,7489,1,
  	0,0,0,7490,7491,1,0,0,0,7491,7492,1,0,0,0,7492,7557,3,946,473,0,7493,
  	7495,7,117,0,0,7494,7496,5,750,0,0,7495,7494,1,0,0,0,7495,7496,1,0,0,
  	0,7496,7497,1,0,0,0,7497,7557,3,1140,570,0,7498,7500,5,132,0,0,7499,7501,
  	5,750,0,0,7500,7499,1,0,0,0,7500,7501,1,0,0,0,7501,7502,1,0,0,0,7502,
  	7557,3,1140,570,0,7503,7505,5,486,0,0,7504,7506,5,750,0,0,7505,7504,1,
  	0,0,0,7505,7506,1,0,0,0,7506,7507,1,0,0,0,7507,7557,7,118,0,0,7508,7510,
  	5,608,0,0,7509,7511,5,750,0,0,7510,7509,1,0,0,0,7510,7511,1,0,0,0,7511,
  	7512,1,0,0,0,7512,7513,5,776,0,0,7513,7514,3,1104,552,0,7514,7515,5,777,
  	0,0,7515,7557,1,0,0,0,7516,7557,3,952,476,0,7517,7557,3,948,474,0,7518,
  	7520,5,243,0,0,7519,7521,5,750,0,0,7520,7519,1,0,0,0,7520,7521,1,0,0,
  	0,7521,7522,1,0,0,0,7522,7557,7,119,0,0,7523,7524,5,112,0,0,7524,7526,
  	5,139,0,0,7525,7527,5,750,0,0,7526,7525,1,0,0,0,7526,7527,1,0,0,0,7527,
  	7528,1,0,0,0,7528,7557,3,1156,578,0,7529,7530,5,236,0,0,7530,7532,5,139,
  	0,0,7531,7533,5,750,0,0,7532,7531,1,0,0,0,7532,7533,1,0,0,0,7533,7534,
  	1,0,0,0,7534,7557,3,1156,578,0,7535,7541,5,572,0,0,7536,7538,4,472,198,
  	0,7537,7539,5,750,0,0,7538,7537,1,0,0,0,7538,7539,1,0,0,0,7539,7542,1,
  	0,0,0,7540,7542,1,0,0,0,7541,7536,1,0,0,0,7541,7540,1,0,0,0,7542,7543,
  	1,0,0,0,7543,7557,3,1128,564,0,7544,7545,5,553,0,0,7545,7557,7,120,0,
  	0,7546,7548,5,84,0,0,7547,7549,5,750,0,0,7548,7547,1,0,0,0,7548,7549,
  	1,0,0,0,7549,7550,1,0,0,0,7550,7557,3,1156,578,0,7551,7553,5,264,0,0,
  	7552,7554,5,750,0,0,7553,7552,1,0,0,0,7553,7554,1,0,0,0,7554,7555,1,0,
  	0,0,7555,7557,3,1140,570,0,7556,7427,1,0,0,0,7556,7432,1,0,0,0,7556,7441,
  	1,0,0,0,7556,7446,1,0,0,0,7556,7451,1,0,0,0,7556,7456,1,0,0,0,7556,7461,
  	1,0,0,0,7556,7466,1,0,0,0,7556,7472,1,0,0,0,7556,7478,1,0,0,0,7556,7483,
  	1,0,0,0,7556,7488,1,0,0,0,7556,7493,1,0,0,0,7556,7498,1,0,0,0,7556,7503,
  	1,0,0,0,7556,7508,1,0,0,0,7556,7516,1,0,0,0,7556,7517,1,0,0,0,7556,7518,
  	1,0,0,0,7556,7523,1,0,0,0,7556,7529,1,0,0,0,7556,7535,1,0,0,0,7556,7544,
  	1,0,0,0,7556,7546,1,0,0,0,7556,7551,1,0,0,0,7557,945,1,0,0,0,7558,7561,
  	3,1140,570,0,7559,7561,5,128,0,0,7560,7558,1,0,0,0,7560,7559,1,0,0,0,
  	7561,947,1,0,0,0,7562,7564,5,128,0,0,7563,7562,1,0,0,0,7563,7564,1,0,
  	0,0,7564,7565,1,0,0,0,7565,7567,5,69,0,0,7566,7568,5,750,0,0,7567,7566,
  	1,0,0,0,7567,7568,1,0,0,0,7568,7569,1,0,0,0,7569,7570,3,938,469,0,7570,
  	949,1,0,0,0,7571,7573,5,128,0,0,7572,7571,1,0,0,0,7572,7573,1,0,0,0,7573,
  	7574,1,0,0,0,7574,7576,5,158,0,0,7575,7577,5,750,0,0,7576,7575,1,0,0,
  	0,7576,7577,1,0,0,0,7577,7578,1,0,0,0,7578,7579,3,1154,577,0,7579,951,
  	1,0,0,0,7580,7582,5,128,0,0,7581,7580,1,0,0,0,7581,7582,1,0,0,0,7582,
  	7583,1,0,0,0,7583,7585,3,758,379,0,7584,7586,5,750,0,0,7585,7584,1,0,
  	0,0,7585,7586,1,0,0,0,7586,7587,1,0,0,0,7587,7588,3,936,468,0,7588,953,
  	1,0,0,0,7589,7590,5,405,0,0,7590,7591,5,45,0,0,7591,7594,3,956,478,0,
  	7592,7593,5,404,0,0,7593,7595,3,1142,571,0,7594,7592,1,0,0,0,7594,7595,
  	1,0,0,0,7595,7597,1,0,0,0,7596,7598,3,958,479,0,7597,7596,1,0,0,0,7597,
  	7598,1,0,0,0,7598,7600,1,0,0,0,7599,7601,3,962,481,0,7600,7599,1,0,0,
  	0,7600,7601,1,0,0,0,7601,955,1,0,0,0,7602,7604,5,277,0,0,7603,7602,1,
  	0,0,0,7603,7604,1,0,0,0,7604,7605,1,0,0,0,7605,7607,5,265,0,0,7606,7608,
  	3,960,480,0,7607,7606,1,0,0,0,7607,7608,1,0,0,0,7608,7609,1,0,0,0,7609,
  	7611,5,776,0,0,7610,7612,3,1130,565,0,7611,7610,1,0,0,0,7611,7612,1,0,
  	0,0,7612,7613,1,0,0,0,7613,7636,5,777,0,0,7614,7616,5,277,0,0,7615,7614,
  	1,0,0,0,7615,7616,1,0,0,0,7616,7617,1,0,0,0,7617,7618,5,220,0,0,7618,
  	7619,5,776,0,0,7619,7620,3,686,343,0,7620,7621,5,777,0,0,7621,7636,1,
  	0,0,0,7622,7633,7,121,0,0,7623,7624,5,776,0,0,7624,7625,3,686,343,0,7625,
  	7626,5,777,0,0,7626,7634,1,0,0,0,7627,7628,5,71,0,0,7628,7630,5,776,0,
  	0,7629,7631,3,1130,565,0,7630,7629,1,0,0,0,7630,7631,1,0,0,0,7631,7632,
  	1,0,0,0,7632,7634,5,777,0,0,7633,7623,1,0,0,0,7633,7627,1,0,0,0,7634,
  	7636,1,0,0,0,7635,7603,1,0,0,0,7635,7615,1,0,0,0,7635,7622,1,0,0,0,7636,
  	957,1,0,0,0,7637,7638,5,561,0,0,7638,7640,5,45,0,0,7639,7641,5,277,0,
  	0,7640,7639,1,0,0,0,7640,7641,1,0,0,0,7641,7652,1,0,0,0,7642,7643,5,220,
  	0,0,7643,7644,5,776,0,0,7644,7645,3,686,343,0,7645,7646,5,777,0,0,7646,
  	7653,1,0,0,0,7647,7649,5,265,0,0,7648,7650,3,960,480,0,7649,7648,1,0,
  	0,0,7649,7650,1,0,0,0,7650,7651,1,0,0,0,7651,7653,3,1132,566,0,7652,7642,
  	1,0,0,0,7652,7647,1,0,0,0,7653,7656,1,0,0,0,7654,7655,5,560,0,0,7655,
  	7657,3,1142,571,0,7656,7654,1,0,0,0,7656,7657,1,0,0,0,7657,959,1,0,0,
  	0,7658,7659,4,480,199,0,7659,7660,5,9,0,0,7660,7661,5,750,0,0,7661,7662,
  	3,1142,571,0,7662,961,1,0,0,0,7663,7664,5,776,0,0,7664,7669,3,964,482,
  	0,7665,7666,5,773,0,0,7666,7668,3,964,482,0,7667,7665,1,0,0,0,7668,7671,
  	1,0,0,0,7669,7667,1,0,0,0,7669,7670,1,0,0,0,7670,7672,1,0,0,0,7671,7669,
  	1,0,0,0,7672,7673,5,777,0,0,7673,963,1,0,0,0,7674,7675,5,405,0,0,7675,
  	7686,3,1128,564,0,7676,7677,5,626,0,0,7677,7678,5,273,0,0,7678,7681,5,
  	581,0,0,7679,7682,3,972,486,0,7680,7682,5,329,0,0,7681,7679,1,0,0,0,7681,
  	7680,1,0,0,0,7682,7687,1,0,0,0,7683,7684,5,626,0,0,7684,7685,5,251,0,
  	0,7685,7687,3,966,483,0,7686,7676,1,0,0,0,7686,7683,1,0,0,0,7686,7687,
  	1,0,0,0,7687,7691,1,0,0,0,7688,7690,3,968,484,0,7689,7688,1,0,0,0,7690,
  	7693,1,0,0,0,7691,7689,1,0,0,0,7691,7692,1,0,0,0,7692,7705,1,0,0,0,7693,
  	7691,1,0,0,0,7694,7695,5,776,0,0,7695,7700,3,970,485,0,7696,7697,5,773,
  	0,0,7697,7699,3,970,485,0,7698,7696,1,0,0,0,7699,7702,1,0,0,0,7700,7698,
  	1,0,0,0,7700,7701,1,0,0,0,7701,7703,1,0,0,0,7702,7700,1,0,0,0,7703,7704,
  	5,777,0,0,7704,7706,1,0,0,0,7705,7694,1,0,0,0,7705,7706,1,0,0,0,7706,
  	965,1,0,0,0,7707,7720,3,972,486,0,7708,7709,5,776,0,0,7709,7714,3,972,
  	486,0,7710,7711,5,773,0,0,7711,7713,3,972,486,0,7712,7710,1,0,0,0,7713,
  	7716,1,0,0,0,7714,7712,1,0,0,0,7714,7715,1,0,0,0,7715,7717,1,0,0,0,7716,
  	7714,1,0,0,0,7717,7718,5,777,0,0,7718,7720,1,0,0,0,7719,7707,1,0,0,0,
  	7719,7708,1,0,0,0,7720,967,1,0,0,0,7721,7723,5,572,0,0,7722,7724,5,750,
  	0,0,7723,7722,1,0,0,0,7723,7724,1,0,0,0,7724,7725,1,0,0,0,7725,7756,3,
  	1128,564,0,7726,7728,5,553,0,0,7727,7726,1,0,0,0,7727,7728,1,0,0,0,7728,
  	7729,1,0,0,0,7729,7731,5,163,0,0,7730,7732,5,750,0,0,7731,7730,1,0,0,
  	0,7731,7732,1,0,0,0,7732,7733,1,0,0,0,7733,7756,3,1094,547,0,7734,7736,
  	5,368,0,0,7735,7737,5,750,0,0,7736,7735,1,0,0,0,7736,7737,1,0,0,0,7737,
  	7738,1,0,0,0,7738,7756,3,1142,571,0,7739,7741,7,122,0,0,7740,7742,5,750,
  	0,0,7741,7740,1,0,0,0,7741,7742,1,0,0,0,7742,7743,1,0,0,0,7743,7756,3,
  	1142,571,0,7744,7745,7,123,0,0,7745,7747,5,139,0,0,7746,7748,5,750,0,
  	0,7747,7746,1,0,0,0,7747,7748,1,0,0,0,7748,7749,1,0,0,0,7749,7756,3,1160,
  	580,0,7750,7752,5,75,0,0,7751,7753,5,750,0,0,7752,7751,1,0,0,0,7752,7753,
  	1,0,0,0,7753,7754,1,0,0,0,7754,7756,3,1160,580,0,7755,7721,1,0,0,0,7755,
  	7727,1,0,0,0,7755,7734,1,0,0,0,7755,7739,1,0,0,0,7755,7744,1,0,0,0,7755,
  	7750,1,0,0,0,7756,969,1,0,0,0,7757,7758,5,561,0,0,7758,7762,3,1180,590,
  	0,7759,7761,3,968,484,0,7760,7759,1,0,0,0,7761,7764,1,0,0,0,7762,7760,
  	1,0,0,0,7762,7763,1,0,0,0,7763,971,1,0,0,0,7764,7762,1,0,0,0,7765,7766,
  	5,776,0,0,7766,7771,3,974,487,0,7767,7768,5,773,0,0,7768,7770,3,974,487,
  	0,7769,7767,1,0,0,0,7770,7773,1,0,0,0,7771,7769,1,0,0,0,7771,7772,1,0,
  	0,0,7772,7774,1,0,0,0,7773,7771,1,0,0,0,7774,7775,5,777,0,0,7775,973,
  	1,0,0,0,7776,7779,3,686,343,0,7777,7779,5,329,0,0,7778,7776,1,0,0,0,7778,
  	7777,1,0,0,0,7779,975,1,0,0,0,7780,7781,5,130,0,0,7781,7782,5,750,0,0,
  	7782,7783,3,1026,513,0,7783,977,1,0,0,0,7784,7785,5,231,0,0,7785,7786,
  	5,174,0,0,7786,979,1,0,0,0,7787,7788,5,231,0,0,7788,7789,3,760,380,0,
  	7789,7790,5,174,0,0,7790,981,1,0,0,0,7791,7793,7,124,0,0,7792,7791,1,
  	0,0,0,7792,7793,1,0,0,0,7793,7794,1,0,0,0,7794,7795,3,984,492,0,7795,
  	983,1,0,0,0,7796,7797,3,1108,554,0,7797,7798,3,988,494,0,7798,985,1,0,
  	0,0,7799,7800,5,69,0,0,7800,7801,3,938,469,0,7801,987,1,0,0,0,7802,7804,
  	3,916,458,0,7803,7805,3,986,493,0,7804,7803,1,0,0,0,7804,7805,1,0,0,0,
  	7805,989,1,0,0,0,7806,7807,5,776,0,0,7807,7808,3,1058,529,0,7808,7809,
  	5,773,0,0,7809,7810,3,1058,529,0,7810,7811,5,777,0,0,7811,991,1,0,0,0,
  	7812,7817,3,1074,537,0,7813,7814,5,773,0,0,7814,7816,3,1074,537,0,7815,
  	7813,1,0,0,0,7816,7819,1,0,0,0,7817,7815,1,0,0,0,7817,7818,1,0,0,0,7818,
  	993,1,0,0,0,7819,7817,1,0,0,0,7820,7825,3,996,498,0,7821,7822,5,773,0,
  	0,7822,7824,3,996,498,0,7823,7821,1,0,0,0,7824,7827,1,0,0,0,7825,7823,
  	1,0,0,0,7825,7826,1,0,0,0,7826,995,1,0,0,0,7827,7825,1,0,0,0,7828,7829,
  	3,1046,523,0,7829,7832,5,750,0,0,7830,7833,3,676,338,0,7831,7833,5,128,
  	0,0,7832,7830,1,0,0,0,7832,7831,1,0,0,0,7833,997,1,0,0,0,7834,7835,3,
  	758,379,0,7835,7836,3,936,468,0,7836,999,1,0,0,0,7837,7839,5,71,0,0,7838,
  	7840,3,1002,501,0,7839,7838,1,0,0,0,7840,7841,1,0,0,0,7841,7839,1,0,0,
  	0,7841,7842,1,0,0,0,7842,1001,1,0,0,0,7843,7844,5,579,0,0,7844,7845,5,
  	45,0,0,7845,7856,3,1156,578,0,7846,7848,5,392,0,0,7847,7846,1,0,0,0,7847,
  	7848,1,0,0,0,7848,7849,1,0,0,0,7849,7850,5,157,0,0,7850,7851,5,45,0,0,
  	7851,7856,3,1156,578,0,7852,7853,5,167,0,0,7853,7854,5,45,0,0,7854,7856,
  	3,1156,578,0,7855,7843,1,0,0,0,7855,7847,1,0,0,0,7855,7852,1,0,0,0,7856,
  	1003,1,0,0,0,7857,7859,5,278,0,0,7858,7860,3,1006,503,0,7859,7858,1,0,
  	0,0,7860,7861,1,0,0,0,7861,7859,1,0,0,0,7861,7862,1,0,0,0,7862,1005,1,
  	0,0,0,7863,7864,7,125,0,0,7864,7865,5,45,0,0,7865,7866,3,1156,578,0,7866,
  	1007,1,0,0,0,7867,7872,3,1026,513,0,7868,7869,5,773,0,0,7869,7871,3,1026,
  	513,0,7870,7868,1,0,0,0,7871,7874,1,0,0,0,7872,7870,1,0,0,0,7872,7873,
  	1,0,0,0,7873,1009,1,0,0,0,7874,7872,1,0,0,0,7875,7880,3,1014,507,0,7876,
  	7877,5,773,0,0,7877,7879,3,1014,507,0,7878,7876,1,0,0,0,7879,7882,1,0,
  	0,0,7880,7878,1,0,0,0,7880,7881,1,0,0,0,7881,1011,1,0,0,0,7882,7880,1,
  	0,0,0,7883,7888,3,1016,508,0,7884,7885,5,773,0,0,7885,7887,3,1016,508,
  	0,7886,7884,1,0,0,0,7887,7890,1,0,0,0,7888,7886,1,0,0,0,7888,7889,1,0,
  	0,0,7889,1013,1,0,0,0,7890,7888,1,0,0,0,7891,7918,3,1026,513,0,7892,7916,
  	5,230,0,0,7893,7896,5,45,0,0,7894,7895,4,507,200,0,7895,7897,5,406,0,
  	0,7896,7894,1,0,0,0,7896,7897,1,0,0,0,7897,7898,1,0,0,0,7898,7917,3,1156,
  	578,0,7899,7900,5,645,0,0,7900,7906,3,1180,590,0,7901,7902,5,17,0,0,7902,
  	7907,3,1158,579,0,7903,7904,4,507,201,0,7904,7905,5,45,0,0,7905,7907,
  	3,1156,578,0,7906,7901,1,0,0,0,7906,7903,1,0,0,0,7906,7907,1,0,0,0,7907,
  	7917,1,0,0,0,7908,7911,4,507,202,0,7909,7910,5,645,0,0,7910,7912,3,1180,
  	590,0,7911,7909,1,0,0,0,7911,7912,1,0,0,0,7912,7913,1,0,0,0,7913,7914,
  	5,45,0,0,7914,7915,5,734,0,0,7915,7917,5,406,0,0,7916,7893,1,0,0,0,7916,
  	7899,1,0,0,0,7916,7908,1,0,0,0,7917,7919,1,0,0,0,7918,7892,1,0,0,0,7918,
  	7919,1,0,0,0,7919,1015,1,0,0,0,7920,7949,3,1026,513,0,7921,7944,5,230,
  	0,0,7922,7923,5,645,0,0,7923,7925,3,1180,590,0,7924,7922,1,0,0,0,7924,
  	7925,1,0,0,0,7925,7926,1,0,0,0,7926,7927,5,45,0,0,7927,7930,3,1156,578,
  	0,7928,7929,5,458,0,0,7929,7931,3,1156,578,0,7930,7928,1,0,0,0,7930,7931,
  	1,0,0,0,7931,7933,1,0,0,0,7932,7934,3,1018,509,0,7933,7932,1,0,0,0,7933,
  	7934,1,0,0,0,7934,7945,1,0,0,0,7935,7936,5,645,0,0,7936,7942,3,1180,590,
  	0,7937,7938,5,17,0,0,7938,7940,3,1158,579,0,7939,7941,3,1018,509,0,7940,
  	7939,1,0,0,0,7940,7941,1,0,0,0,7941,7943,1,0,0,0,7942,7937,1,0,0,0,7942,
  	7943,1,0,0,0,7943,7945,1,0,0,0,7944,7924,1,0,0,0,7944,7935,1,0,0,0,7944,
  	7945,1,0,0,0,7945,7950,1,0,0,0,7946,7948,3,1020,510,0,7947,7946,1,0,0,
  	0,7947,7948,1,0,0,0,7948,7950,1,0,0,0,7949,7921,1,0,0,0,7949,7947,1,0,
  	0,0,7950,1017,1,0,0,0,7951,7952,5,727,0,0,7952,7953,5,101,0,0,7953,7954,
  	5,406,0,0,7954,1019,1,0,0,0,7955,7956,5,141,0,0,7956,7957,5,728,0,0,7957,
  	7958,5,406,0,0,7958,1021,1,0,0,0,7959,7960,5,458,0,0,7960,7961,3,1156,
  	578,0,7961,1023,1,0,0,0,7962,7966,3,1180,590,0,7963,7964,5,783,0,0,7964,
  	7967,3,1180,590,0,7965,7967,5,784,0,0,7966,7963,1,0,0,0,7966,7965,1,0,
  	0,0,7966,7967,1,0,0,0,7967,1025,1,0,0,0,7968,7974,3,1024,512,0,7969,7971,
  	5,105,0,0,7970,7972,3,1188,594,0,7971,7970,1,0,0,0,7971,7972,1,0,0,0,
  	7972,7974,1,0,0,0,7973,7968,1,0,0,0,7973,7969,1,0,0,0,7974,1027,1,0,0,
  	0,7975,7976,5,275,0,0,7976,7977,3,1154,577,0,7977,1029,1,0,0,0,7978,7981,
  	3,1028,514,0,7979,7981,3,358,179,0,7980,7978,1,0,0,0,7980,7979,1,0,0,
  	0,7981,1031,1,0,0,0,7982,7983,7,126,0,0,7983,1033,1,0,0,0,7984,7985,7,
  	127,0,0,7985,1035,1,0,0,0,7986,7987,4,518,203,0,7987,7988,5,405,0,0,7988,
  	7989,3,1132,566,0,7989,1037,1,0,0,0,7990,7996,3,1138,569,0,7991,7993,
  	3,1134,567,0,7992,7994,3,1138,569,0,7993,7992,1,0,0,0,7993,7994,1,0,0,
  	0,7994,7996,1,0,0,0,7995,7990,1,0,0,0,7995,7991,1,0,0,0,7996,1039,1,0,
  	0,0,7997,7998,4,520,204,0,7998,8002,3,1128,564,0,7999,8000,4,520,205,
  	0,8000,8002,3,1038,519,0,8001,7997,1,0,0,0,8001,7999,1,0,0,0,8002,1041,
  	1,0,0,0,8003,8004,3,1128,564,0,8004,1043,1,0,0,0,8005,8006,5,776,0,0,
  	8006,8011,3,1042,521,0,8007,8008,5,773,0,0,8008,8010,3,1042,521,0,8009,
  	8007,1,0,0,0,8010,8013,1,0,0,0,8011,8009,1,0,0,0,8011,8012,1,0,0,0,8012,
  	8014,1,0,0,0,8013,8011,1,0,0,0,8014,8015,5,777,0,0,8015,1045,1,0,0,0,
  	8016,8017,3,1038,519,0,8017,1047,1,0,0,0,8018,8021,3,1046,523,0,8019,
  	8021,3,1054,527,0,8020,8018,1,0,0,0,8020,8019,1,0,0,0,8021,1049,1,0,0,
  	0,8022,8023,3,1128,564,0,8023,1051,1,0,0,0,8024,8025,3,1038,519,0,8025,
  	1053,1,0,0,0,8026,8027,3,1128,564,0,8027,8031,5,772,0,0,8028,8029,3,1128,
  	564,0,8029,8030,5,772,0,0,8030,8032,1,0,0,0,8031,8028,1,0,0,0,8031,8032,
  	1,0,0,0,8032,8033,1,0,0,0,8033,8034,5,760,0,0,8034,1055,1,0,0,0,8035,
  	8036,3,1128,564,0,8036,1057,1,0,0,0,8037,8038,3,1128,564,0,8038,1059,
  	1,0,0,0,8039,8040,3,1134,567,0,8040,1061,1,0,0,0,8041,8042,3,1134,567,
  	0,8042,1063,1,0,0,0,8043,8044,3,1134,567,0,8044,1065,1,0,0,0,8045,8046,
  	3,1134,567,0,8046,1067,1,0,0,0,8047,8048,3,1134,567,0,8048,1069,1,0,0,
  	0,8049,8050,3,1134,567,0,8050,1071,1,0,0,0,8051,8054,3,1134,567,0,8052,
  	8054,3,1138,569,0,8053,8051,1,0,0,0,8053,8052,1,0,0,0,8054,1073,1,0,0,
  	0,8055,8058,3,1134,567,0,8056,8058,3,1138,569,0,8057,8055,1,0,0,0,8057,
  	8056,1,0,0,0,8058,1075,1,0,0,0,8059,8060,3,1128,564,0,8060,1077,1,0,0,
  	0,8061,8062,3,1128,564,0,8062,1079,1,0,0,0,8063,8064,3,1128,564,0,8064,
  	1081,1,0,0,0,8065,8066,3,1128,564,0,8066,1083,1,0,0,0,8067,8068,3,1134,
  	567,0,8068,1085,1,0,0,0,8069,8070,3,1134,567,0,8070,1087,1,0,0,0,8071,
  	8072,3,1128,564,0,8072,1089,1,0,0,0,8073,8074,3,1180,590,0,8074,1091,
  	1,0,0,0,8075,8076,3,1180,590,0,8076,1093,1,0,0,0,8077,8078,3,1180,590,
  	0,8078,1095,1,0,0,0,8079,8082,3,1134,567,0,8080,8082,3,1138,569,0,8081,
  	8079,1,0,0,0,8081,8080,1,0,0,0,8082,1097,1,0,0,0,8083,8084,3,1058,529,
  	0,8084,8085,3,1138,569,0,8085,1099,1,0,0,0,8086,8094,3,1128,564,0,8087,
  	8088,5,772,0,0,8088,8095,5,760,0,0,8089,8092,3,1138,569,0,8090,8091,5,
  	772,0,0,8091,8093,5,760,0,0,8092,8090,1,0,0,0,8092,8093,1,0,0,0,8093,
  	8095,1,0,0,0,8094,8087,1,0,0,0,8094,8089,1,0,0,0,8094,8095,1,0,0,0,8095,
  	1101,1,0,0,0,8096,8099,3,1134,567,0,8097,8099,3,1138,569,0,8098,8096,
  	1,0,0,0,8098,8097,1,0,0,0,8099,1103,1,0,0,0,8100,8105,3,1102,551,0,8101,
  	8102,5,773,0,0,8102,8104,3,1102,551,0,8103,8101,1,0,0,0,8104,8107,1,0,
  	0,0,8105,8103,1,0,0,0,8105,8106,1,0,0,0,8106,1105,1,0,0,0,8107,8105,1,
  	0,0,0,8108,8113,3,1100,550,0,8109,8110,5,773,0,0,8110,8112,3,1100,550,
  	0,8111,8109,1,0,0,0,8112,8115,1,0,0,0,8113,8111,1,0,0,0,8113,8114,1,0,
  	0,0,8114,1107,1,0,0,0,8115,8113,1,0,0,0,8116,8117,3,1128,564,0,8117,1109,
  	1,0,0,0,8118,8121,3,1126,563,0,8119,8121,3,1204,602,0,8120,8118,1,0,0,
  	0,8120,8119,1,0,0,0,8121,1111,1,0,0,0,8122,8123,3,1110,555,0,8123,1113,
  	1,0,0,0,8124,8127,3,1126,563,0,8125,8127,3,1210,605,0,8126,8124,1,0,0,
  	0,8126,8125,1,0,0,0,8127,1115,1,0,0,0,8128,8129,3,1114,557,0,8129,1117,
  	1,0,0,0,8130,8131,3,1128,564,0,8131,1119,1,0,0,0,8132,8133,3,1154,577,
  	0,8133,1121,1,0,0,0,8134,8135,3,1128,564,0,8135,1123,1,0,0,0,8136,8137,
  	3,1128,564,0,8137,1125,1,0,0,0,8138,8142,7,128,0,0,8139,8140,4,563,206,
  	0,8140,8142,5,798,0,0,8141,8138,1,0,0,0,8141,8139,1,0,0,0,8142,1127,1,
  	0,0,0,8143,8146,3,1126,563,0,8144,8146,3,1198,599,0,8145,8143,1,0,0,0,
  	8145,8144,1,0,0,0,8146,1129,1,0,0,0,8147,8152,3,1128,564,0,8148,8149,
  	5,773,0,0,8149,8151,3,1128,564,0,8150,8148,1,0,0,0,8151,8154,1,0,0,0,
  	8152,8150,1,0,0,0,8152,8153,1,0,0,0,8153,1131,1,0,0,0,8154,8152,1,0,0,
  	0,8155,8156,5,776,0,0,8156,8157,3,1130,565,0,8157,8158,5,777,0,0,8158,
  	1133,1,0,0,0,8159,8161,3,1128,564,0,8160,8162,3,1138,569,0,8161,8160,
  	1,0,0,0,8161,8162,1,0,0,0,8162,1135,1,0,0,0,8163,8168,3,1128,564,0,8164,
  	8166,3,1138,569,0,8165,8167,3,1138,569,0,8166,8165,1,0,0,0,8166,8167,
  	1,0,0,0,8167,8169,1,0,0,0,8168,8164,1,0,0,0,8168,8169,1,0,0,0,8169,8175,
  	1,0,0,0,8170,8171,4,568,207,0,8171,8172,3,1138,569,0,8172,8173,3,1138,
  	569,0,8173,8175,1,0,0,0,8174,8163,1,0,0,0,8174,8170,1,0,0,0,8175,1137,
  	1,0,0,0,8176,8177,5,772,0,0,8177,8178,3,1128,564,0,8178,1139,1,0,0,0,
  	8179,8180,7,129,0,0,8180,1141,1,0,0,0,8181,8182,7,130,0,0,8182,1143,1,
  	0,0,0,8183,8184,7,131,0,0,8184,1145,1,0,0,0,8185,8191,5,747,0,0,8186,
  	8187,4,573,208,0,8187,8191,5,788,0,0,8188,8191,5,749,0,0,8189,8191,5,
  	748,0,0,8190,8185,1,0,0,0,8190,8186,1,0,0,0,8190,8188,1,0,0,0,8190,8189,
  	1,0,0,0,8191,1147,1,0,0,0,8192,8202,3,1160,580,0,8193,8202,3,1166,583,
  	0,8194,8202,3,1172,586,0,8195,8202,3,1170,585,0,8196,8202,3,1168,584,
  	0,8197,8199,5,794,0,0,8198,8197,1,0,0,0,8198,8199,1,0,0,0,8199,8200,1,
  	0,0,0,8200,8202,7,132,0,0,8201,8192,1,0,0,0,8201,8193,1,0,0,0,8201,8194,
  	1,0,0,0,8201,8195,1,0,0,0,8201,8196,1,0,0,0,8201,8198,1,0,0,0,8202,1149,
  	1,0,0,0,8203,8209,3,1148,574,0,8204,8205,5,758,0,0,8205,8209,3,1140,570,
  	0,8206,8207,5,759,0,0,8207,8209,3,1140,570,0,8208,8203,1,0,0,0,8208,8204,
  	1,0,0,0,8208,8206,1,0,0,0,8209,1151,1,0,0,0,8210,8211,5,776,0,0,8211,
  	8216,3,1156,578,0,8212,8213,5,773,0,0,8213,8215,3,1156,578,0,8214,8212,
  	1,0,0,0,8215,8218,1,0,0,0,8216,8214,1,0,0,0,8216,8217,1,0,0,0,8217,8219,
  	1,0,0,0,8218,8216,1,0,0,0,8219,8220,5,777,0,0,8220,1153,1,0,0,0,8221,
  	8225,5,799,0,0,8222,8223,4,577,209,0,8223,8225,5,798,0,0,8224,8221,1,
  	0,0,0,8224,8222,1,0,0,0,8225,1155,1,0,0,0,8226,8230,3,1154,577,0,8227,
  	8230,5,788,0,0,8228,8230,5,789,0,0,8229,8226,1,0,0,0,8229,8227,1,0,0,
  	0,8229,8228,1,0,0,0,8230,1157,1,0,0,0,8231,8235,3,1154,577,0,8232,8233,
  	4,579,210,0,8233,8235,5,788,0,0,8234,8231,1,0,0,0,8234,8232,1,0,0,0,8235,
  	1159,1,0,0,0,8236,8238,5,794,0,0,8237,8236,1,0,0,0,8237,8238,1,0,0,0,
  	8238,8239,1,0,0,0,8239,8242,3,1154,577,0,8240,8242,5,796,0,0,8241,8237,
  	1,0,0,0,8241,8240,1,0,0,0,8242,8246,1,0,0,0,8243,8245,3,1154,577,0,8244,
  	8243,1,0,0,0,8245,8248,1,0,0,0,8246,8244,1,0,0,0,8246,8247,1,0,0,0,8247,
  	1161,1,0,0,0,8248,8246,1,0,0,0,8249,8250,3,1154,577,0,8250,1163,1,0,0,
  	0,8251,8256,3,1154,577,0,8252,8253,5,773,0,0,8253,8255,3,1154,577,0,8254,
  	8252,1,0,0,0,8255,8258,1,0,0,0,8256,8254,1,0,0,0,8256,8257,1,0,0,0,8257,
  	1165,1,0,0,0,8258,8256,1,0,0,0,8259,8260,7,131,0,0,8260,1167,1,0,0,0,
  	8261,8262,7,133,0,0,8262,1169,1,0,0,0,8263,8264,7,134,0,0,8264,1171,1,
  	0,0,0,8265,8266,5,116,0,0,8266,8272,5,799,0,0,8267,8268,5,586,0,0,8268,
  	8272,5,799,0,0,8269,8270,5,583,0,0,8270,8272,5,799,0,0,8271,8265,1,0,
  	0,0,8271,8267,1,0,0,0,8271,8269,1,0,0,0,8272,1173,1,0,0,0,8273,8276,3,
  	922,461,0,8274,8276,3,1178,589,0,8275,8273,1,0,0,0,8275,8274,1,0,0,0,
  	8276,1175,1,0,0,0,8277,8278,3,1178,589,0,8278,1177,1,0,0,0,8279,8280,
  	5,776,0,0,8280,8281,5,747,0,0,8281,8282,5,773,0,0,8282,8283,5,747,0,0,
  	8283,8284,5,777,0,0,8284,1179,1,0,0,0,8285,8288,3,1128,564,0,8286,8288,
  	3,1154,577,0,8287,8285,1,0,0,0,8287,8286,1,0,0,0,8288,1181,1,0,0,0,8289,
  	8292,3,1126,563,0,8290,8292,3,1212,606,0,8291,8289,1,0,0,0,8291,8290,
  	1,0,0,0,8292,1183,1,0,0,0,8293,8296,3,1114,557,0,8294,8296,3,1154,577,
  	0,8295,8293,1,0,0,0,8295,8294,1,0,0,0,8296,1185,1,0,0,0,8297,8300,3,1146,
  	573,0,8298,8300,3,1126,563,0,8299,8297,1,0,0,0,8299,8298,1,0,0,0,8300,
  	1187,1,0,0,0,8301,8302,5,776,0,0,8302,8303,5,777,0,0,8303,1189,1,0,0,
  	0,8304,8305,7,135,0,0,8305,1191,1,0,0,0,8306,8307,7,136,0,0,8307,1193,
  	1,0,0,0,8308,8309,5,214,0,0,8309,8315,5,772,0,0,8310,8311,5,284,0,0,8311,
  	8315,5,772,0,0,8312,8313,5,502,0,0,8313,8315,5,772,0,0,8314,8308,1,0,
  	0,0,8314,8310,1,0,0,0,8314,8312,1,0,0,0,8315,1195,1,0,0,0,8316,8317,5,
  	658,0,0,8317,8327,5,772,0,0,8318,8319,5,673,0,0,8319,8327,5,772,0,0,8320,
  	8321,5,214,0,0,8321,8327,5,772,0,0,8322,8323,5,284,0,0,8323,8327,5,772,
  	0,0,8324,8325,5,502,0,0,8325,8327,5,772,0,0,8326,8316,1,0,0,0,8326,8318,
  	1,0,0,0,8326,8320,1,0,0,0,8326,8322,1,0,0,0,8326,8324,1,0,0,0,8327,1197,
  	1,0,0,0,8328,8336,4,599,211,0,8329,8337,3,1204,602,0,8330,8337,3,1216,
  	608,0,8331,8337,5,173,0,0,8332,8333,4,599,212,0,8333,8337,5,510,0,0,8334,
  	8335,4,599,213,0,8335,8337,5,714,0,0,8336,8329,1,0,0,0,8336,8330,1,0,
  	0,0,8336,8331,1,0,0,0,8336,8332,1,0,0,0,8336,8334,1,0,0,0,8337,8346,1,
  	0,0,0,8338,8344,3,1208,604,0,8339,8344,3,1200,600,0,8340,8344,3,1202,
  	601,0,8341,8344,3,1206,603,0,8342,8344,3,1214,607,0,8343,8338,1,0,0,0,
  	8343,8339,1,0,0,0,8343,8340,1,0,0,0,8343,8341,1,0,0,0,8343,8342,1,0,0,
  	0,8344,8346,1,0,0,0,8345,8328,1,0,0,0,8345,8343,1,0,0,0,8346,1199,1,0,
  	0,0,8347,8348,7,137,0,0,8348,1201,1,0,0,0,8349,8350,7,138,0,0,8350,1203,
  	1,0,0,0,8351,8362,4,602,214,0,8352,8363,3,1218,609,0,8353,8363,5,170,
  	0,0,8354,8363,5,188,0,0,8355,8363,5,369,0,0,8356,8363,5,423,0,0,8357,
  	8363,5,427,0,0,8358,8363,5,451,0,0,8359,8363,5,459,0,0,8360,8363,5,709,
  	0,0,8361,8363,5,565,0,0,8362,8352,1,0,0,0,8362,8353,1,0,0,0,8362,8354,
  	1,0,0,0,8362,8355,1,0,0,0,8362,8356,1,0,0,0,8362,8357,1,0,0,0,8362,8358,
  	1,0,0,0,8362,8359,1,0,0,0,8362,8360,1,0,0,0,8362,8361,1,0,0,0,8363,8370,
  	1,0,0,0,8364,8368,3,1208,604,0,8365,8368,3,1206,603,0,8366,8368,3,1214,
  	607,0,8367,8364,1,0,0,0,8367,8365,1,0,0,0,8367,8366,1,0,0,0,8368,8370,
  	1,0,0,0,8369,8351,1,0,0,0,8369,8367,1,0,0,0,8370,1205,1,0,0,0,8371,8372,
  	7,139,0,0,8372,1207,1,0,0,0,8373,8377,7,140,0,0,8374,8375,4,604,215,0,
  	8375,8377,7,141,0,0,8376,8373,1,0,0,0,8376,8374,1,0,0,0,8377,1209,1,0,
  	0,0,8378,8381,4,605,216,0,8379,8382,3,1218,609,0,8380,8382,3,1216,608,
  	0,8381,8379,1,0,0,0,8381,8380,1,0,0,0,8382,8389,1,0,0,0,8383,8387,3,1208,
  	604,0,8384,8387,3,1202,601,0,8385,8387,3,1214,607,0,8386,8383,1,0,0,0,
  	8386,8384,1,0,0,0,8386,8385,1,0,0,0,8387,8389,1,0,0,0,8388,8378,1,0,0,
  	0,8388,8386,1,0,0,0,8389,1211,1,0,0,0,8390,8395,3,1208,604,0,8391,8395,
  	3,1200,600,0,8392,8395,3,1202,601,0,8393,8395,3,1206,603,0,8394,8390,
  	1,0,0,0,8394,8391,1,0,0,0,8394,8392,1,0,0,0,8394,8393,1,0,0,0,8395,1213,
  	1,0,0,0,8396,8397,7,136,0,0,8397,1215,1,0,0,0,8398,8404,7,142,0,0,8399,
  	8400,4,608,217,0,8400,8404,5,510,0,0,8401,8402,4,608,218,0,8402,8404,
  	5,234,0,0,8403,8398,1,0,0,0,8403,8399,1,0,0,0,8403,8401,1,0,0,0,8404,
  	1217,1,0,0,0,8405,8415,7,143,0,0,8406,8407,4,609,219,0,8407,8415,5,510,
  	0,0,8408,8409,4,609,220,0,8409,8415,7,144,0,0,8410,8411,4,609,221,0,8411,
  	8415,7,145,0,0,8412,8413,4,609,222,0,8413,8415,5,660,0,0,8414,8405,1,
  	0,0,0,8414,8406,1,0,0,0,8414,8408,1,0,0,0,8414,8410,1,0,0,0,8414,8412,
  	1,0,0,0,8415,1219,1,0,0,0,1123,1223,1227,1230,1232,1268,1276,1281,1297,
  	1304,1311,1314,1321,1326,1329,1334,1340,1342,1346,1350,1359,1363,1368,
  	1374,1381,1385,1390,1395,1402,1405,1411,1414,1421,1431,1436,1441,1449,
  	1455,1459,1464,1473,1479,1485,1491,1500,1506,1515,1529,1533,1539,1543,
  	1549,1553,1558,1561,1567,1573,1579,1583,1588,1592,1596,1604,1606,1619,
  	1627,1635,1639,1668,1684,1687,1696,1701,1707,1712,1716,1721,1725,1729,
  	1733,1737,1741,1743,1754,1762,1771,1776,1779,1784,1791,1799,1803,1808,
  	1815,1820,1825,1833,1837,1842,1845,1848,1851,1858,1865,1869,1893,1897,
  	1903,1910,1913,1917,1924,1927,1930,1933,1942,1949,1954,1957,1960,1966,
  	1972,1975,1980,1990,1993,1999,2005,2015,2018,2026,2032,2043,2046,2051,
  	2070,2073,2076,2082,2085,2087,2093,2103,2113,2116,2119,2124,2130,2143,
  	2147,2152,2161,2178,2197,2206,2209,2217,2222,2226,2233,2238,2253,2257,
  	2263,2269,2275,2281,2287,2292,2296,2304,2310,2316,2321,2324,2327,2336,
  	2339,2350,2362,2371,2375,2384,2387,2393,2395,2399,2406,2419,2426,2432,
  	2435,2452,2472,2476,2482,2488,2494,2499,2506,2513,2518,2521,2525,2529,
  	2534,2538,2542,2548,2553,2556,2560,2566,2570,2574,2582,2590,2599,2608,
  	2621,2624,2628,2634,2642,2647,2650,2653,2656,2659,2661,2667,2669,2684,
  	2690,2697,2700,2702,2704,2714,2716,2720,2723,2726,2730,2735,2741,2744,
  	2747,2753,2756,2765,2774,2778,2782,2788,2793,2798,2803,2807,2813,2824,
  	2827,2832,2838,2841,2844,2847,2850,2864,2867,2871,2875,2881,2886,2890,
  	2895,2898,2902,2908,2912,2916,2925,2930,2934,2938,2941,2945,2948,2950,
  	2954,2960,2964,2966,2970,2974,2978,2985,2987,2996,3002,3007,3010,3013,
  	3016,3019,3023,3038,3042,3048,3051,3054,3060,3065,3069,3072,3080,3082,
  	3095,3107,3112,3115,3118,3123,3129,3145,3165,3174,3178,3185,3190,3199,
  	3206,3217,3224,3233,3242,3254,3259,3266,3270,3276,3281,3286,3290,3296,
  	3302,3304,3307,3311,3321,3326,3331,3338,3347,3355,3360,3364,3370,3373,
  	3376,3380,3384,3394,3398,3401,3404,3409,3415,3419,3425,3428,3430,3435,
  	3447,3456,3469,3472,3477,3484,3488,3492,3494,3508,3515,3524,3530,3539,
  	3543,3547,3557,3559,3567,3574,3579,3583,3587,3590,3596,3599,3602,3608,
  	3615,3620,3624,3627,3630,3633,3635,3639,3647,3653,3657,3662,3665,3668,
  	3671,3673,3678,3687,3700,3702,3706,3712,3715,3718,3724,3731,3733,3741,
  	3747,3752,3755,3762,3764,3773,3782,3791,3799,3803,3810,3813,3815,3823,
  	3829,3839,3846,3940,3944,3950,3964,3972,3975,3987,3992,3998,4005,4012,
  	4019,4026,4033,4040,4043,4050,4058,4066,4076,4082,4086,4090,4095,4098,
  	4100,4109,4115,4122,4127,4132,4137,4140,4147,4160,4166,4172,4179,4187,
  	4193,4205,4207,4213,4217,4219,4223,4236,4242,4250,4261,4265,4278,4285,
  	4291,4298,4300,4310,4318,4321,4326,4330,4336,4339,4344,4355,4357,4369,
  	4374,4382,4388,4390,4392,4398,4410,4415,4417,4421,4427,4430,4433,4443,
  	4445,4451,4458,4464,4474,4478,4483,4500,4516,4521,4529,4537,4542,4548,
  	4551,4553,4562,4568,4574,4576,4580,4591,4601,4606,4611,4616,4624,4628,
  	4633,4642,4654,4668,4677,4679,4686,4693,4697,4703,4711,4718,4722,4728,
  	4735,4738,4747,4753,4758,4781,4784,4800,4805,4808,4812,4815,4829,4835,
  	4840,4843,4845,4849,4854,4856,4868,4874,4896,4900,4902,4910,4914,4923,
  	4933,4940,4943,4947,4950,4953,4957,4960,4964,4967,4972,4975,4980,4983,
  	4989,4993,4999,5002,5011,5013,5019,5023,5026,5029,5033,5039,5042,5045,
  	5055,5059,5068,5071,5076,5079,5082,5086,5089,5094,5098,5106,5119,5137,
  	5142,5147,5155,5161,5163,5167,5170,5184,5194,5198,5206,5209,5213,5223,
  	5227,5234,5239,5247,5252,5258,5265,5270,5276,5283,5293,5295,5303,5308,
  	5312,5315,5322,5327,5331,5342,5350,5354,5357,5360,5364,5368,5373,5379,
  	5383,5394,5397,5400,5403,5411,5415,5420,5428,5436,5442,5460,5470,5476,
  	5490,5493,5497,5508,5510,5519,5531,5533,5540,5546,5552,5560,5571,5575,
  	5604,5606,5614,5618,5635,5642,5656,5668,5674,5681,5684,5718,5726,5728,
  	5740,5745,5751,5759,5766,5772,5777,5783,5788,5793,5799,5804,5810,5818,
  	5826,5834,5842,5847,5853,5858,5862,5866,5871,5873,5892,5896,5903,5915,
  	5918,5922,5927,5932,5936,5946,5955,5957,5960,5969,5976,5989,5994,6001,
  	6007,6033,6064,6084,6090,6094,6121,6133,6146,6150,6154,6182,6238,6248,
  	6252,6264,6269,6282,6302,6306,6323,6326,6331,6334,6343,6347,6353,6359,
  	6363,6374,6380,6382,6389,6396,6400,6407,6412,6416,6421,6425,6429,6434,
  	6439,6441,6445,6458,6462,6465,6469,6473,6477,6482,6486,6490,6499,6501,
  	6508,6514,6522,6543,6548,6555,6578,6594,6604,6608,6615,6618,6629,6638,
  	6641,6648,6653,6679,6685,6691,6695,6705,6709,6722,6734,6752,6760,6770,
  	6773,6778,6782,6789,6794,6801,6809,6812,6817,6825,6828,6842,6845,6858,
  	6862,6864,6869,6874,6880,6886,6892,6897,6900,6906,6911,6914,6920,6924,
  	6930,6932,6935,6941,6947,6955,6957,6959,6963,6969,6974,6978,6983,6989,
  	6996,6999,7001,7004,7014,7018,7024,7031,7036,7050,7055,7063,7068,7072,
  	7075,7080,7084,7092,7100,7102,7109,7117,7124,7127,7135,7143,7145,7151,
  	7157,7161,7168,7179,7188,7191,7196,7198,7201,7204,7208,7211,7215,7220,
  	7223,7227,7230,7234,7239,7243,7255,7259,7265,7268,7273,7277,7281,7286,
  	7295,7298,7302,7306,7309,7313,7317,7322,7327,7333,7338,7343,7345,7350,
  	7357,7365,7371,7373,7377,7381,7385,7389,7403,7410,7414,7419,7425,7429,
  	7435,7439,7443,7448,7453,7458,7463,7469,7475,7480,7485,7490,7495,7500,
  	7505,7510,7520,7526,7532,7538,7541,7548,7553,7556,7560,7563,7567,7572,
  	7576,7581,7585,7594,7597,7600,7603,7607,7611,7615,7630,7633,7635,7640,
  	7649,7652,7656,7669,7681,7686,7691,7700,7705,7714,7719,7723,7727,7731,
  	7736,7741,7747,7752,7755,7762,7771,7778,7792,7804,7817,7825,7832,7841,
  	7847,7855,7861,7872,7880,7888,7896,7906,7911,7916,7918,7924,7930,7933,
  	7940,7942,7944,7947,7949,7966,7971,7973,7980,7993,7995,8001,8011,8020,
  	8031,8053,8057,8081,8092,8094,8098,8105,8113,8120,8126,8141,8145,8152,
  	8161,8166,8168,8174,8190,8198,8201,8208,8216,8224,8229,8234,8237,8241,
  	8246,8256,8271,8275,8287,8291,8295,8299,8314,8326,8336,8343,8345,8362,
  	8367,8369,8376,8381,8386,8388,8394,8403,8414
  };
  staticData->serializedATN = antlr4::atn::SerializedATNView(serializedATNSegment, sizeof(serializedATNSegment) / sizeof(serializedATNSegment[0]));

  antlr4::atn::ATNDeserializer deserializer;
  staticData->atn = deserializer.deserialize(staticData->serializedATN);

  const size_t count = staticData->atn->getNumberOfDecisions();
  staticData->decisionToDFA.reserve(count);
  for (size_t i = 0; i < count; i++) { 
    staticData->decisionToDFA.emplace_back(staticData->atn->getDecisionState(i), i);
  }
  mysqlparserParserStaticData = std::move(staticData);
}

}

MySQLParser::MySQLParser(TokenStream *input) : MySQLParser(input, antlr4::atn::ParserATNSimulatorOptions()) {}

MySQLParser::MySQLParser(TokenStream *input, const antlr4::atn::ParserATNSimulatorOptions &options) : MySQLBaseRecognizer(input) {
  MySQLParser::initialize();
  _interpreter = new atn::ParserATNSimulator(this, *mysqlparserParserStaticData->atn, mysqlparserParserStaticData->decisionToDFA, mysqlparserParserStaticData->sharedContextCache, options);
}

MySQLParser::~MySQLParser() {
  delete _interpreter;
}

const atn::ATN& MySQLParser::getATN() const {
  return *mysqlparserParserStaticData->atn;
}

std::string MySQLParser::getGrammarFileName() const {
  return "MySQLParser.g4";
}

const std::vector<std::string>& MySQLParser::getRuleNames() const {
  return mysqlparserParserStaticData->ruleNames;
}

const dfa::Vocabulary& MySQLParser::getVocabulary() const {
  return mysqlparserParserStaticData->vocabulary;
}

antlr4::atn::SerializedATNView MySQLParser::getSerializedATN() const {
  return mysqlparserParserStaticData->serializedATN;
}


//----------------- QueryContext ------------------------------------------------------------------

MySQLParser::QueryContext::QueryContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::QueryContext::EOF() {
  return getToken(MySQLParser::EOF, 0);
}

MySQLParser::SimpleStatementContext* MySQLParser::QueryContext::simpleStatement() {
  return getRuleContext<MySQLParser::SimpleStatementContext>(0);
}

MySQLParser::BeginWorkContext* MySQLParser::QueryContext::beginWork() {
  return getRuleContext<MySQLParser::BeginWorkContext>(0);
}

tree::TerminalNode* MySQLParser::QueryContext::SEMICOLON_SYMBOL() {
  return getToken(MySQLParser::SEMICOLON_SYMBOL, 0);
}


size_t MySQLParser::QueryContext::getRuleIndex() const {
  return MySQLParser::RuleQuery;
}

void MySQLParser::QueryContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterQuery(this);
}

void MySQLParser::QueryContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitQuery(this);
}


std::any MySQLParser::QueryContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitQuery(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::QueryContext* MySQLParser::query() {
  QueryContext *_localctx = _tracker.createInstance<QueryContext>(_ctx, getState());
  enterRule(_localctx, 0, MySQLParser::RuleQuery);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(1232);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 3, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(1220);
      match(MySQLParser::EOF);
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(1223);
      _errHandler->sync(this);
      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 0, _ctx)) {
      case 1: {
        setState(1221);
        simpleStatement();
        break;
      }

      case 2: {
        setState(1222);
        beginWork();
        break;
      }

      default:
        break;
      }
      setState(1230);
      _errHandler->sync(this);
      switch (_input->LA(1)) {
        case MySQLParser::SEMICOLON_SYMBOL: {
          setState(1225);
          match(MySQLParser::SEMICOLON_SYMBOL);
          setState(1227);
          _errHandler->sync(this);

          switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 1, _ctx)) {
          case 1: {
            setState(1226);
            match(MySQLParser::EOF);
            break;
          }

          default:
            break;
          }
          break;
        }

        case MySQLParser::EOF: {
          setState(1229);
          match(MySQLParser::EOF);
          break;
        }

      default:
        throw NoViableAltException(this);
      }
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- SimpleStatementContext ------------------------------------------------------------------

MySQLParser::SimpleStatementContext::SimpleStatementContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::AlterStatementContext* MySQLParser::SimpleStatementContext::alterStatement() {
  return getRuleContext<MySQLParser::AlterStatementContext>(0);
}

MySQLParser::CreateStatementContext* MySQLParser::SimpleStatementContext::createStatement() {
  return getRuleContext<MySQLParser::CreateStatementContext>(0);
}

MySQLParser::DropStatementContext* MySQLParser::SimpleStatementContext::dropStatement() {
  return getRuleContext<MySQLParser::DropStatementContext>(0);
}

MySQLParser::RenameTableStatementContext* MySQLParser::SimpleStatementContext::renameTableStatement() {
  return getRuleContext<MySQLParser::RenameTableStatementContext>(0);
}

MySQLParser::TruncateTableStatementContext* MySQLParser::SimpleStatementContext::truncateTableStatement() {
  return getRuleContext<MySQLParser::TruncateTableStatementContext>(0);
}

MySQLParser::ImportStatementContext* MySQLParser::SimpleStatementContext::importStatement() {
  return getRuleContext<MySQLParser::ImportStatementContext>(0);
}

MySQLParser::CallStatementContext* MySQLParser::SimpleStatementContext::callStatement() {
  return getRuleContext<MySQLParser::CallStatementContext>(0);
}

MySQLParser::DeleteStatementContext* MySQLParser::SimpleStatementContext::deleteStatement() {
  return getRuleContext<MySQLParser::DeleteStatementContext>(0);
}

MySQLParser::DoStatementContext* MySQLParser::SimpleStatementContext::doStatement() {
  return getRuleContext<MySQLParser::DoStatementContext>(0);
}

MySQLParser::HandlerStatementContext* MySQLParser::SimpleStatementContext::handlerStatement() {
  return getRuleContext<MySQLParser::HandlerStatementContext>(0);
}

MySQLParser::InsertStatementContext* MySQLParser::SimpleStatementContext::insertStatement() {
  return getRuleContext<MySQLParser::InsertStatementContext>(0);
}

MySQLParser::LoadStatementContext* MySQLParser::SimpleStatementContext::loadStatement() {
  return getRuleContext<MySQLParser::LoadStatementContext>(0);
}

MySQLParser::ReplaceStatementContext* MySQLParser::SimpleStatementContext::replaceStatement() {
  return getRuleContext<MySQLParser::ReplaceStatementContext>(0);
}

MySQLParser::SelectStatementContext* MySQLParser::SimpleStatementContext::selectStatement() {
  return getRuleContext<MySQLParser::SelectStatementContext>(0);
}

MySQLParser::UpdateStatementContext* MySQLParser::SimpleStatementContext::updateStatement() {
  return getRuleContext<MySQLParser::UpdateStatementContext>(0);
}

MySQLParser::TransactionOrLockingStatementContext* MySQLParser::SimpleStatementContext::transactionOrLockingStatement() {
  return getRuleContext<MySQLParser::TransactionOrLockingStatementContext>(0);
}

MySQLParser::ReplicationStatementContext* MySQLParser::SimpleStatementContext::replicationStatement() {
  return getRuleContext<MySQLParser::ReplicationStatementContext>(0);
}

MySQLParser::PreparedStatementContext* MySQLParser::SimpleStatementContext::preparedStatement() {
  return getRuleContext<MySQLParser::PreparedStatementContext>(0);
}

MySQLParser::CloneStatementContext* MySQLParser::SimpleStatementContext::cloneStatement() {
  return getRuleContext<MySQLParser::CloneStatementContext>(0);
}

MySQLParser::AccountManagementStatementContext* MySQLParser::SimpleStatementContext::accountManagementStatement() {
  return getRuleContext<MySQLParser::AccountManagementStatementContext>(0);
}

MySQLParser::TableAdministrationStatementContext* MySQLParser::SimpleStatementContext::tableAdministrationStatement() {
  return getRuleContext<MySQLParser::TableAdministrationStatementContext>(0);
}

MySQLParser::InstallUninstallStatmentContext* MySQLParser::SimpleStatementContext::installUninstallStatment() {
  return getRuleContext<MySQLParser::InstallUninstallStatmentContext>(0);
}

MySQLParser::SetStatementContext* MySQLParser::SimpleStatementContext::setStatement() {
  return getRuleContext<MySQLParser::SetStatementContext>(0);
}

MySQLParser::ShowStatementContext* MySQLParser::SimpleStatementContext::showStatement() {
  return getRuleContext<MySQLParser::ShowStatementContext>(0);
}

MySQLParser::ResourceGroupManagementContext* MySQLParser::SimpleStatementContext::resourceGroupManagement() {
  return getRuleContext<MySQLParser::ResourceGroupManagementContext>(0);
}

MySQLParser::OtherAdministrativeStatementContext* MySQLParser::SimpleStatementContext::otherAdministrativeStatement() {
  return getRuleContext<MySQLParser::OtherAdministrativeStatementContext>(0);
}

MySQLParser::UtilityStatementContext* MySQLParser::SimpleStatementContext::utilityStatement() {
  return getRuleContext<MySQLParser::UtilityStatementContext>(0);
}

MySQLParser::GetDiagnosticsContext* MySQLParser::SimpleStatementContext::getDiagnostics() {
  return getRuleContext<MySQLParser::GetDiagnosticsContext>(0);
}

MySQLParser::SignalStatementContext* MySQLParser::SimpleStatementContext::signalStatement() {
  return getRuleContext<MySQLParser::SignalStatementContext>(0);
}

MySQLParser::ResignalStatementContext* MySQLParser::SimpleStatementContext::resignalStatement() {
  return getRuleContext<MySQLParser::ResignalStatementContext>(0);
}


size_t MySQLParser::SimpleStatementContext::getRuleIndex() const {
  return MySQLParser::RuleSimpleStatement;
}

void MySQLParser::SimpleStatementContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterSimpleStatement(this);
}

void MySQLParser::SimpleStatementContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitSimpleStatement(this);
}


std::any MySQLParser::SimpleStatementContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitSimpleStatement(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::SimpleStatementContext* MySQLParser::simpleStatement() {
  SimpleStatementContext *_localctx = _tracker.createInstance<SimpleStatementContext>(_ctx, getState());
  enterRule(_localctx, 2, MySQLParser::RuleSimpleStatement);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(1268);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 4, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(1234);
      alterStatement();
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(1235);
      createStatement();
      break;
    }

    case 3: {
      enterOuterAlt(_localctx, 3);
      setState(1236);
      dropStatement();
      break;
    }

    case 4: {
      enterOuterAlt(_localctx, 4);
      setState(1237);
      renameTableStatement();
      break;
    }

    case 5: {
      enterOuterAlt(_localctx, 5);
      setState(1238);
      truncateTableStatement();
      break;
    }

    case 6: {
      enterOuterAlt(_localctx, 6);
      setState(1239);

      if (!(serverVersion >= 80000)) throw FailedPredicateException(this, "serverVersion >= 80000");
      setState(1240);
      importStatement();
      break;
    }

    case 7: {
      enterOuterAlt(_localctx, 7);
      setState(1241);
      callStatement();
      break;
    }

    case 8: {
      enterOuterAlt(_localctx, 8);
      setState(1242);
      deleteStatement();
      break;
    }

    case 9: {
      enterOuterAlt(_localctx, 9);
      setState(1243);
      doStatement();
      break;
    }

    case 10: {
      enterOuterAlt(_localctx, 10);
      setState(1244);
      handlerStatement();
      break;
    }

    case 11: {
      enterOuterAlt(_localctx, 11);
      setState(1245);
      insertStatement();
      break;
    }

    case 12: {
      enterOuterAlt(_localctx, 12);
      setState(1246);
      loadStatement();
      break;
    }

    case 13: {
      enterOuterAlt(_localctx, 13);
      setState(1247);
      replaceStatement();
      break;
    }

    case 14: {
      enterOuterAlt(_localctx, 14);
      setState(1248);
      selectStatement();
      break;
    }

    case 15: {
      enterOuterAlt(_localctx, 15);
      setState(1249);
      updateStatement();
      break;
    }

    case 16: {
      enterOuterAlt(_localctx, 16);
      setState(1250);
      transactionOrLockingStatement();
      break;
    }

    case 17: {
      enterOuterAlt(_localctx, 17);
      setState(1251);
      replicationStatement();
      break;
    }

    case 18: {
      enterOuterAlt(_localctx, 18);
      setState(1252);
      preparedStatement();
      break;
    }

    case 19: {
      enterOuterAlt(_localctx, 19);
      setState(1253);

      if (!(serverVersion >= 80000)) throw FailedPredicateException(this, "serverVersion >= 80000");
      setState(1254);
      cloneStatement();
      break;
    }

    case 20: {
      enterOuterAlt(_localctx, 20);
      setState(1255);
      accountManagementStatement();
      break;
    }

    case 21: {
      enterOuterAlt(_localctx, 21);
      setState(1256);
      tableAdministrationStatement();
      break;
    }

    case 22: {
      enterOuterAlt(_localctx, 22);
      setState(1257);
      installUninstallStatment();
      break;
    }

    case 23: {
      enterOuterAlt(_localctx, 23);
      setState(1258);
      setStatement();
      break;
    }

    case 24: {
      enterOuterAlt(_localctx, 24);
      setState(1259);
      showStatement();
      break;
    }

    case 25: {
      enterOuterAlt(_localctx, 25);
      setState(1260);

      if (!(serverVersion >= 80000)) throw FailedPredicateException(this, "serverVersion >= 80000");
      setState(1261);
      resourceGroupManagement();
      break;
    }

    case 26: {
      enterOuterAlt(_localctx, 26);
      setState(1262);
      otherAdministrativeStatement();
      break;
    }

    case 27: {
      enterOuterAlt(_localctx, 27);
      setState(1263);
      utilityStatement();
      break;
    }

    case 28: {
      enterOuterAlt(_localctx, 28);
      setState(1264);

      if (!(serverVersion >= 50604)) throw FailedPredicateException(this, "serverVersion >= 50604");
      setState(1265);
      getDiagnostics();
      break;
    }

    case 29: {
      enterOuterAlt(_localctx, 29);
      setState(1266);
      signalStatement();
      break;
    }

    case 30: {
      enterOuterAlt(_localctx, 30);
      setState(1267);
      resignalStatement();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterStatementContext ------------------------------------------------------------------

MySQLParser::AlterStatementContext::AlterStatementContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::AlterStatementContext::ALTER_SYMBOL() {
  return getToken(MySQLParser::ALTER_SYMBOL, 0);
}

MySQLParser::AlterTableContext* MySQLParser::AlterStatementContext::alterTable() {
  return getRuleContext<MySQLParser::AlterTableContext>(0);
}

MySQLParser::AlterDatabaseContext* MySQLParser::AlterStatementContext::alterDatabase() {
  return getRuleContext<MySQLParser::AlterDatabaseContext>(0);
}

tree::TerminalNode* MySQLParser::AlterStatementContext::PROCEDURE_SYMBOL() {
  return getToken(MySQLParser::PROCEDURE_SYMBOL, 0);
}

MySQLParser::ProcedureRefContext* MySQLParser::AlterStatementContext::procedureRef() {
  return getRuleContext<MySQLParser::ProcedureRefContext>(0);
}

tree::TerminalNode* MySQLParser::AlterStatementContext::FUNCTION_SYMBOL() {
  return getToken(MySQLParser::FUNCTION_SYMBOL, 0);
}

MySQLParser::FunctionRefContext* MySQLParser::AlterStatementContext::functionRef() {
  return getRuleContext<MySQLParser::FunctionRefContext>(0);
}

MySQLParser::AlterViewContext* MySQLParser::AlterStatementContext::alterView() {
  return getRuleContext<MySQLParser::AlterViewContext>(0);
}

MySQLParser::AlterEventContext* MySQLParser::AlterStatementContext::alterEvent() {
  return getRuleContext<MySQLParser::AlterEventContext>(0);
}

MySQLParser::AlterTablespaceContext* MySQLParser::AlterStatementContext::alterTablespace() {
  return getRuleContext<MySQLParser::AlterTablespaceContext>(0);
}

MySQLParser::AlterUndoTablespaceContext* MySQLParser::AlterStatementContext::alterUndoTablespace() {
  return getRuleContext<MySQLParser::AlterUndoTablespaceContext>(0);
}

MySQLParser::AlterLogfileGroupContext* MySQLParser::AlterStatementContext::alterLogfileGroup() {
  return getRuleContext<MySQLParser::AlterLogfileGroupContext>(0);
}

MySQLParser::AlterServerContext* MySQLParser::AlterStatementContext::alterServer() {
  return getRuleContext<MySQLParser::AlterServerContext>(0);
}

tree::TerminalNode* MySQLParser::AlterStatementContext::INSTANCE_SYMBOL() {
  return getToken(MySQLParser::INSTANCE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterStatementContext::ROTATE_SYMBOL() {
  return getToken(MySQLParser::ROTATE_SYMBOL, 0);
}

MySQLParser::TextOrIdentifierContext* MySQLParser::AlterStatementContext::textOrIdentifier() {
  return getRuleContext<MySQLParser::TextOrIdentifierContext>(0);
}

tree::TerminalNode* MySQLParser::AlterStatementContext::MASTER_SYMBOL() {
  return getToken(MySQLParser::MASTER_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterStatementContext::KEY_SYMBOL() {
  return getToken(MySQLParser::KEY_SYMBOL, 0);
}

MySQLParser::RoutineAlterOptionsContext* MySQLParser::AlterStatementContext::routineAlterOptions() {
  return getRuleContext<MySQLParser::RoutineAlterOptionsContext>(0);
}


size_t MySQLParser::AlterStatementContext::getRuleIndex() const {
  return MySQLParser::RuleAlterStatement;
}

void MySQLParser::AlterStatementContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterStatement(this);
}

void MySQLParser::AlterStatementContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterStatement(this);
}


std::any MySQLParser::AlterStatementContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterStatement(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterStatementContext* MySQLParser::alterStatement() {
  AlterStatementContext *_localctx = _tracker.createInstance<AlterStatementContext>(_ctx, getState());
  enterRule(_localctx, 4, MySQLParser::RuleAlterStatement);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(1270);
    match(MySQLParser::ALTER_SYMBOL);
    setState(1297);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 7, _ctx)) {
    case 1: {
      setState(1271);
      alterTable();
      break;
    }

    case 2: {
      setState(1272);
      alterDatabase();
      break;
    }

    case 3: {
      setState(1273);
      match(MySQLParser::PROCEDURE_SYMBOL);
      setState(1274);
      procedureRef();
      setState(1276);
      _errHandler->sync(this);

      _la = _input->LA(1);
      if (((((_la - 75) & ~ 0x3fULL) == 0) &&
        ((1ULL << (_la - 75)) & 4611686018427420673) != 0) || _la == MySQLParser::LANGUAGE_SYMBOL || ((((_la - 347) & ~ 0x3fULL) == 0) &&
        ((1ULL << (_la - 347)) & 83886081) != 0) || _la == MySQLParser::READS_SYMBOL || _la == MySQLParser::SQL_SYMBOL) {
        setState(1275);
        routineAlterOptions();
      }
      break;
    }

    case 4: {
      setState(1278);
      match(MySQLParser::FUNCTION_SYMBOL);
      setState(1279);
      functionRef();
      setState(1281);
      _errHandler->sync(this);

      _la = _input->LA(1);
      if (((((_la - 75) & ~ 0x3fULL) == 0) &&
        ((1ULL << (_la - 75)) & 4611686018427420673) != 0) || _la == MySQLParser::LANGUAGE_SYMBOL || ((((_la - 347) & ~ 0x3fULL) == 0) &&
        ((1ULL << (_la - 347)) & 83886081) != 0) || _la == MySQLParser::READS_SYMBOL || _la == MySQLParser::SQL_SYMBOL) {
        setState(1280);
        routineAlterOptions();
      }
      break;
    }

    case 5: {
      setState(1283);
      alterView();
      break;
    }

    case 6: {
      setState(1284);
      alterEvent();
      break;
    }

    case 7: {
      setState(1285);
      alterTablespace();
      break;
    }

    case 8: {
      setState(1286);

      if (!(serverVersion >= 80014)) throw FailedPredicateException(this, "serverVersion >= 80014");
      setState(1287);
      alterUndoTablespace();
      break;
    }

    case 9: {
      setState(1288);
      alterLogfileGroup();
      break;
    }

    case 10: {
      setState(1289);
      alterServer();
      break;
    }

    case 11: {
      setState(1290);

      if (!(serverVersion >= 50713)) throw FailedPredicateException(this, "serverVersion >= 50713");
      setState(1291);
      match(MySQLParser::INSTANCE_SYMBOL);
      setState(1292);
      match(MySQLParser::ROTATE_SYMBOL);
      setState(1293);
      textOrIdentifier();
      setState(1294);
      match(MySQLParser::MASTER_SYMBOL);
      setState(1295);
      match(MySQLParser::KEY_SYMBOL);
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterDatabaseContext ------------------------------------------------------------------

MySQLParser::AlterDatabaseContext::AlterDatabaseContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::AlterDatabaseContext::DATABASE_SYMBOL() {
  return getToken(MySQLParser::DATABASE_SYMBOL, 0);
}

MySQLParser::SchemaRefContext* MySQLParser::AlterDatabaseContext::schemaRef() {
  return getRuleContext<MySQLParser::SchemaRefContext>(0);
}

tree::TerminalNode* MySQLParser::AlterDatabaseContext::UPGRADE_SYMBOL() {
  return getToken(MySQLParser::UPGRADE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterDatabaseContext::DATA_SYMBOL() {
  return getToken(MySQLParser::DATA_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterDatabaseContext::DIRECTORY_SYMBOL() {
  return getToken(MySQLParser::DIRECTORY_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterDatabaseContext::NAME_SYMBOL() {
  return getToken(MySQLParser::NAME_SYMBOL, 0);
}

std::vector<MySQLParser::CreateDatabaseOptionContext *> MySQLParser::AlterDatabaseContext::createDatabaseOption() {
  return getRuleContexts<MySQLParser::CreateDatabaseOptionContext>();
}

MySQLParser::CreateDatabaseOptionContext* MySQLParser::AlterDatabaseContext::createDatabaseOption(size_t i) {
  return getRuleContext<MySQLParser::CreateDatabaseOptionContext>(i);
}


size_t MySQLParser::AlterDatabaseContext::getRuleIndex() const {
  return MySQLParser::RuleAlterDatabase;
}

void MySQLParser::AlterDatabaseContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterDatabase(this);
}

void MySQLParser::AlterDatabaseContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterDatabase(this);
}


std::any MySQLParser::AlterDatabaseContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterDatabase(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterDatabaseContext* MySQLParser::alterDatabase() {
  AlterDatabaseContext *_localctx = _tracker.createInstance<AlterDatabaseContext>(_ctx, getState());
  enterRule(_localctx, 6, MySQLParser::RuleAlterDatabase);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    size_t alt;
    enterOuterAlt(_localctx, 1);
    setState(1299);
    match(MySQLParser::DATABASE_SYMBOL);
    setState(1300);
    schemaRef();
    setState(1311);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 9, _ctx)) {
    case 1: {
      setState(1302); 
      _errHandler->sync(this);
      alt = 1;
      do {
        switch (alt) {
          case 1: {
                setState(1301);
                createDatabaseOption();
                break;
              }

        default:
          throw NoViableAltException(this);
        }
        setState(1304); 
        _errHandler->sync(this);
        alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 8, _ctx);
      } while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER);
      break;
    }

    case 2: {
      setState(1306);

      if (!(serverVersion < 80000)) throw FailedPredicateException(this, "serverVersion < 80000");
      setState(1307);
      match(MySQLParser::UPGRADE_SYMBOL);
      setState(1308);
      match(MySQLParser::DATA_SYMBOL);
      setState(1309);
      match(MySQLParser::DIRECTORY_SYMBOL);
      setState(1310);
      match(MySQLParser::NAME_SYMBOL);
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterEventContext ------------------------------------------------------------------

MySQLParser::AlterEventContext::AlterEventContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::AlterEventContext::EVENT_SYMBOL() {
  return getToken(MySQLParser::EVENT_SYMBOL, 0);
}

MySQLParser::EventRefContext* MySQLParser::AlterEventContext::eventRef() {
  return getRuleContext<MySQLParser::EventRefContext>(0);
}

MySQLParser::DefinerClauseContext* MySQLParser::AlterEventContext::definerClause() {
  return getRuleContext<MySQLParser::DefinerClauseContext>(0);
}

std::vector<tree::TerminalNode *> MySQLParser::AlterEventContext::ON_SYMBOL() {
  return getTokens(MySQLParser::ON_SYMBOL);
}

tree::TerminalNode* MySQLParser::AlterEventContext::ON_SYMBOL(size_t i) {
  return getToken(MySQLParser::ON_SYMBOL, i);
}

tree::TerminalNode* MySQLParser::AlterEventContext::SCHEDULE_SYMBOL() {
  return getToken(MySQLParser::SCHEDULE_SYMBOL, 0);
}

MySQLParser::ScheduleContext* MySQLParser::AlterEventContext::schedule() {
  return getRuleContext<MySQLParser::ScheduleContext>(0);
}

tree::TerminalNode* MySQLParser::AlterEventContext::COMPLETION_SYMBOL() {
  return getToken(MySQLParser::COMPLETION_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterEventContext::PRESERVE_SYMBOL() {
  return getToken(MySQLParser::PRESERVE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterEventContext::RENAME_SYMBOL() {
  return getToken(MySQLParser::RENAME_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterEventContext::TO_SYMBOL() {
  return getToken(MySQLParser::TO_SYMBOL, 0);
}

MySQLParser::IdentifierContext* MySQLParser::AlterEventContext::identifier() {
  return getRuleContext<MySQLParser::IdentifierContext>(0);
}

tree::TerminalNode* MySQLParser::AlterEventContext::ENABLE_SYMBOL() {
  return getToken(MySQLParser::ENABLE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterEventContext::DISABLE_SYMBOL() {
  return getToken(MySQLParser::DISABLE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterEventContext::COMMENT_SYMBOL() {
  return getToken(MySQLParser::COMMENT_SYMBOL, 0);
}

MySQLParser::TextLiteralContext* MySQLParser::AlterEventContext::textLiteral() {
  return getRuleContext<MySQLParser::TextLiteralContext>(0);
}

tree::TerminalNode* MySQLParser::AlterEventContext::DO_SYMBOL() {
  return getToken(MySQLParser::DO_SYMBOL, 0);
}

MySQLParser::CompoundStatementContext* MySQLParser::AlterEventContext::compoundStatement() {
  return getRuleContext<MySQLParser::CompoundStatementContext>(0);
}

tree::TerminalNode* MySQLParser::AlterEventContext::NOT_SYMBOL() {
  return getToken(MySQLParser::NOT_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterEventContext::SLAVE_SYMBOL() {
  return getToken(MySQLParser::SLAVE_SYMBOL, 0);
}


size_t MySQLParser::AlterEventContext::getRuleIndex() const {
  return MySQLParser::RuleAlterEvent;
}

void MySQLParser::AlterEventContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterEvent(this);
}

void MySQLParser::AlterEventContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterEvent(this);
}


std::any MySQLParser::AlterEventContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterEvent(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterEventContext* MySQLParser::alterEvent() {
  AlterEventContext *_localctx = _tracker.createInstance<AlterEventContext>(_ctx, getState());
  enterRule(_localctx, 8, MySQLParser::RuleAlterEvent);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(1314);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::DEFINER_SYMBOL) {
      setState(1313);
      definerClause();
    }
    setState(1316);
    match(MySQLParser::EVENT_SYMBOL);
    setState(1317);
    eventRef();
    setState(1321);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 11, _ctx)) {
    case 1: {
      setState(1318);
      match(MySQLParser::ON_SYMBOL);
      setState(1319);
      match(MySQLParser::SCHEDULE_SYMBOL);
      setState(1320);
      schedule();
      break;
    }

    default:
      break;
    }
    setState(1329);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::ON_SYMBOL) {
      setState(1323);
      match(MySQLParser::ON_SYMBOL);
      setState(1324);
      match(MySQLParser::COMPLETION_SYMBOL);
      setState(1326);
      _errHandler->sync(this);

      _la = _input->LA(1);
      if (_la == MySQLParser::NOT_SYMBOL) {
        setState(1325);
        match(MySQLParser::NOT_SYMBOL);
      }
      setState(1328);
      match(MySQLParser::PRESERVE_SYMBOL);
    }
    setState(1334);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::RENAME_SYMBOL) {
      setState(1331);
      match(MySQLParser::RENAME_SYMBOL);
      setState(1332);
      match(MySQLParser::TO_SYMBOL);
      setState(1333);
      identifier();
    }
    setState(1342);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::ENABLE_SYMBOL: {
        setState(1336);
        match(MySQLParser::ENABLE_SYMBOL);
        break;
      }

      case MySQLParser::DISABLE_SYMBOL: {
        setState(1337);
        match(MySQLParser::DISABLE_SYMBOL);
        setState(1340);
        _errHandler->sync(this);

        _la = _input->LA(1);
        if (_la == MySQLParser::ON_SYMBOL) {
          setState(1338);
          match(MySQLParser::ON_SYMBOL);
          setState(1339);
          match(MySQLParser::SLAVE_SYMBOL);
        }
        break;
      }

      case MySQLParser::EOF:
      case MySQLParser::COMMENT_SYMBOL:
      case MySQLParser::DO_SYMBOL:
      case MySQLParser::SEMICOLON_SYMBOL: {
        break;
      }

    default:
      break;
    }
    setState(1346);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::COMMENT_SYMBOL) {
      setState(1344);
      match(MySQLParser::COMMENT_SYMBOL);
      setState(1345);
      textLiteral();
    }
    setState(1350);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::DO_SYMBOL) {
      setState(1348);
      match(MySQLParser::DO_SYMBOL);
      setState(1349);
      compoundStatement();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterLogfileGroupContext ------------------------------------------------------------------

MySQLParser::AlterLogfileGroupContext::AlterLogfileGroupContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::AlterLogfileGroupContext::LOGFILE_SYMBOL() {
  return getToken(MySQLParser::LOGFILE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterLogfileGroupContext::GROUP_SYMBOL() {
  return getToken(MySQLParser::GROUP_SYMBOL, 0);
}

MySQLParser::LogfileGroupRefContext* MySQLParser::AlterLogfileGroupContext::logfileGroupRef() {
  return getRuleContext<MySQLParser::LogfileGroupRefContext>(0);
}

tree::TerminalNode* MySQLParser::AlterLogfileGroupContext::ADD_SYMBOL() {
  return getToken(MySQLParser::ADD_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterLogfileGroupContext::UNDOFILE_SYMBOL() {
  return getToken(MySQLParser::UNDOFILE_SYMBOL, 0);
}

MySQLParser::TextLiteralContext* MySQLParser::AlterLogfileGroupContext::textLiteral() {
  return getRuleContext<MySQLParser::TextLiteralContext>(0);
}

MySQLParser::AlterLogfileGroupOptionsContext* MySQLParser::AlterLogfileGroupContext::alterLogfileGroupOptions() {
  return getRuleContext<MySQLParser::AlterLogfileGroupOptionsContext>(0);
}


size_t MySQLParser::AlterLogfileGroupContext::getRuleIndex() const {
  return MySQLParser::RuleAlterLogfileGroup;
}

void MySQLParser::AlterLogfileGroupContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterLogfileGroup(this);
}

void MySQLParser::AlterLogfileGroupContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterLogfileGroup(this);
}


std::any MySQLParser::AlterLogfileGroupContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterLogfileGroup(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterLogfileGroupContext* MySQLParser::alterLogfileGroup() {
  AlterLogfileGroupContext *_localctx = _tracker.createInstance<AlterLogfileGroupContext>(_ctx, getState());
  enterRule(_localctx, 10, MySQLParser::RuleAlterLogfileGroup);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(1352);
    match(MySQLParser::LOGFILE_SYMBOL);
    setState(1353);
    match(MySQLParser::GROUP_SYMBOL);
    setState(1354);
    logfileGroupRef();
    setState(1355);
    match(MySQLParser::ADD_SYMBOL);
    setState(1356);
    match(MySQLParser::UNDOFILE_SYMBOL);
    setState(1357);
    textLiteral();
    setState(1359);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::ENGINE_SYMBOL || _la == MySQLParser::INITIAL_SIZE_SYMBOL || _la == MySQLParser::NO_WAIT_SYMBOL || _la == MySQLParser::STORAGE_SYMBOL || _la == MySQLParser::WAIT_SYMBOL) {
      setState(1358);
      alterLogfileGroupOptions();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterLogfileGroupOptionsContext ------------------------------------------------------------------

MySQLParser::AlterLogfileGroupOptionsContext::AlterLogfileGroupOptionsContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

std::vector<MySQLParser::AlterLogfileGroupOptionContext *> MySQLParser::AlterLogfileGroupOptionsContext::alterLogfileGroupOption() {
  return getRuleContexts<MySQLParser::AlterLogfileGroupOptionContext>();
}

MySQLParser::AlterLogfileGroupOptionContext* MySQLParser::AlterLogfileGroupOptionsContext::alterLogfileGroupOption(size_t i) {
  return getRuleContext<MySQLParser::AlterLogfileGroupOptionContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::AlterLogfileGroupOptionsContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::AlterLogfileGroupOptionsContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::AlterLogfileGroupOptionsContext::getRuleIndex() const {
  return MySQLParser::RuleAlterLogfileGroupOptions;
}

void MySQLParser::AlterLogfileGroupOptionsContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterLogfileGroupOptions(this);
}

void MySQLParser::AlterLogfileGroupOptionsContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterLogfileGroupOptions(this);
}


std::any MySQLParser::AlterLogfileGroupOptionsContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterLogfileGroupOptions(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterLogfileGroupOptionsContext* MySQLParser::alterLogfileGroupOptions() {
  AlterLogfileGroupOptionsContext *_localctx = _tracker.createInstance<AlterLogfileGroupOptionsContext>(_ctx, getState());
  enterRule(_localctx, 12, MySQLParser::RuleAlterLogfileGroupOptions);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(1361);
    alterLogfileGroupOption();
    setState(1368);
    _errHandler->sync(this);
    _la = _input->LA(1);
    while (_la == MySQLParser::ENGINE_SYMBOL || _la == MySQLParser::INITIAL_SIZE_SYMBOL || _la == MySQLParser::NO_WAIT_SYMBOL || _la == MySQLParser::STORAGE_SYMBOL || _la == MySQLParser::WAIT_SYMBOL || _la == MySQLParser::COMMA_SYMBOL) {
      setState(1363);
      _errHandler->sync(this);

      _la = _input->LA(1);
      if (_la == MySQLParser::COMMA_SYMBOL) {
        setState(1362);
        match(MySQLParser::COMMA_SYMBOL);
      }
      setState(1365);
      alterLogfileGroupOption();
      setState(1370);
      _errHandler->sync(this);
      _la = _input->LA(1);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterLogfileGroupOptionContext ------------------------------------------------------------------

MySQLParser::AlterLogfileGroupOptionContext::AlterLogfileGroupOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::TsOptionInitialSizeContext* MySQLParser::AlterLogfileGroupOptionContext::tsOptionInitialSize() {
  return getRuleContext<MySQLParser::TsOptionInitialSizeContext>(0);
}

MySQLParser::TsOptionEngineContext* MySQLParser::AlterLogfileGroupOptionContext::tsOptionEngine() {
  return getRuleContext<MySQLParser::TsOptionEngineContext>(0);
}

MySQLParser::TsOptionWaitContext* MySQLParser::AlterLogfileGroupOptionContext::tsOptionWait() {
  return getRuleContext<MySQLParser::TsOptionWaitContext>(0);
}


size_t MySQLParser::AlterLogfileGroupOptionContext::getRuleIndex() const {
  return MySQLParser::RuleAlterLogfileGroupOption;
}

void MySQLParser::AlterLogfileGroupOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterLogfileGroupOption(this);
}

void MySQLParser::AlterLogfileGroupOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterLogfileGroupOption(this);
}


std::any MySQLParser::AlterLogfileGroupOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterLogfileGroupOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterLogfileGroupOptionContext* MySQLParser::alterLogfileGroupOption() {
  AlterLogfileGroupOptionContext *_localctx = _tracker.createInstance<AlterLogfileGroupOptionContext>(_ctx, getState());
  enterRule(_localctx, 14, MySQLParser::RuleAlterLogfileGroupOption);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(1374);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::INITIAL_SIZE_SYMBOL: {
        enterOuterAlt(_localctx, 1);
        setState(1371);
        tsOptionInitialSize();
        break;
      }

      case MySQLParser::ENGINE_SYMBOL:
      case MySQLParser::STORAGE_SYMBOL: {
        enterOuterAlt(_localctx, 2);
        setState(1372);
        tsOptionEngine();
        break;
      }

      case MySQLParser::NO_WAIT_SYMBOL:
      case MySQLParser::WAIT_SYMBOL: {
        enterOuterAlt(_localctx, 3);
        setState(1373);
        tsOptionWait();
        break;
      }

    default:
      throw NoViableAltException(this);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterServerContext ------------------------------------------------------------------

MySQLParser::AlterServerContext::AlterServerContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::AlterServerContext::SERVER_SYMBOL() {
  return getToken(MySQLParser::SERVER_SYMBOL, 0);
}

MySQLParser::ServerRefContext* MySQLParser::AlterServerContext::serverRef() {
  return getRuleContext<MySQLParser::ServerRefContext>(0);
}

MySQLParser::ServerOptionsContext* MySQLParser::AlterServerContext::serverOptions() {
  return getRuleContext<MySQLParser::ServerOptionsContext>(0);
}


size_t MySQLParser::AlterServerContext::getRuleIndex() const {
  return MySQLParser::RuleAlterServer;
}

void MySQLParser::AlterServerContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterServer(this);
}

void MySQLParser::AlterServerContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterServer(this);
}


std::any MySQLParser::AlterServerContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterServer(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterServerContext* MySQLParser::alterServer() {
  AlterServerContext *_localctx = _tracker.createInstance<AlterServerContext>(_ctx, getState());
  enterRule(_localctx, 16, MySQLParser::RuleAlterServer);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(1376);
    match(MySQLParser::SERVER_SYMBOL);
    setState(1377);
    serverRef();
    setState(1378);
    serverOptions();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterTableContext ------------------------------------------------------------------

MySQLParser::AlterTableContext::AlterTableContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::AlterTableContext::TABLE_SYMBOL() {
  return getToken(MySQLParser::TABLE_SYMBOL, 0);
}

MySQLParser::TableRefContext* MySQLParser::AlterTableContext::tableRef() {
  return getRuleContext<MySQLParser::TableRefContext>(0);
}

MySQLParser::OnlineOptionContext* MySQLParser::AlterTableContext::onlineOption() {
  return getRuleContext<MySQLParser::OnlineOptionContext>(0);
}

tree::TerminalNode* MySQLParser::AlterTableContext::IGNORE_SYMBOL() {
  return getToken(MySQLParser::IGNORE_SYMBOL, 0);
}

MySQLParser::AlterTableActionsContext* MySQLParser::AlterTableContext::alterTableActions() {
  return getRuleContext<MySQLParser::AlterTableActionsContext>(0);
}


size_t MySQLParser::AlterTableContext::getRuleIndex() const {
  return MySQLParser::RuleAlterTable;
}

void MySQLParser::AlterTableContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterTable(this);
}

void MySQLParser::AlterTableContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterTable(this);
}


std::any MySQLParser::AlterTableContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterTable(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterTableContext* MySQLParser::alterTable() {
  AlterTableContext *_localctx = _tracker.createInstance<AlterTableContext>(_ctx, getState());
  enterRule(_localctx, 18, MySQLParser::RuleAlterTable);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(1381);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 23, _ctx)) {
    case 1: {
      setState(1380);
      onlineOption();
      break;
    }

    default:
      break;
    }
    setState(1385);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 24, _ctx)) {
    case 1: {
      setState(1383);

      if (!(serverVersion < 50700)) throw FailedPredicateException(this, "serverVersion < 50700");
      setState(1384);
      match(MySQLParser::IGNORE_SYMBOL);
      break;
    }

    default:
      break;
    }
    setState(1387);
    match(MySQLParser::TABLE_SYMBOL);
    setState(1388);
    tableRef();
    setState(1390);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 25, _ctx)) {
    case 1: {
      setState(1389);
      alterTableActions();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterTableActionsContext ------------------------------------------------------------------

MySQLParser::AlterTableActionsContext::AlterTableActionsContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::AlterCommandListContext* MySQLParser::AlterTableActionsContext::alterCommandList() {
  return getRuleContext<MySQLParser::AlterCommandListContext>(0);
}

MySQLParser::PartitionClauseContext* MySQLParser::AlterTableActionsContext::partitionClause() {
  return getRuleContext<MySQLParser::PartitionClauseContext>(0);
}

MySQLParser::RemovePartitioningContext* MySQLParser::AlterTableActionsContext::removePartitioning() {
  return getRuleContext<MySQLParser::RemovePartitioningContext>(0);
}

MySQLParser::StandaloneAlterCommandsContext* MySQLParser::AlterTableActionsContext::standaloneAlterCommands() {
  return getRuleContext<MySQLParser::StandaloneAlterCommandsContext>(0);
}

MySQLParser::AlterCommandsModifierListContext* MySQLParser::AlterTableActionsContext::alterCommandsModifierList() {
  return getRuleContext<MySQLParser::AlterCommandsModifierListContext>(0);
}

tree::TerminalNode* MySQLParser::AlterTableActionsContext::COMMA_SYMBOL() {
  return getToken(MySQLParser::COMMA_SYMBOL, 0);
}


size_t MySQLParser::AlterTableActionsContext::getRuleIndex() const {
  return MySQLParser::RuleAlterTableActions;
}

void MySQLParser::AlterTableActionsContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterTableActions(this);
}

void MySQLParser::AlterTableActionsContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterTableActions(this);
}


std::any MySQLParser::AlterTableActionsContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterTableActions(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterTableActionsContext* MySQLParser::alterTableActions() {
  AlterTableActionsContext *_localctx = _tracker.createInstance<AlterTableActionsContext>(_ctx, getState());
  enterRule(_localctx, 20, MySQLParser::RuleAlterTableActions);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(1405);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 28, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(1392);
      alterCommandList();
      setState(1395);
      _errHandler->sync(this);
      switch (_input->LA(1)) {
        case MySQLParser::PARTITION_SYMBOL: {
          setState(1393);
          partitionClause();
          break;
        }

        case MySQLParser::REMOVE_SYMBOL: {
          setState(1394);
          removePartitioning();
          break;
        }

        case MySQLParser::EOF:
        case MySQLParser::SEMICOLON_SYMBOL: {
          break;
        }

      default:
        break;
      }
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(1397);
      partitionClause();
      break;
    }

    case 3: {
      enterOuterAlt(_localctx, 3);
      setState(1398);
      removePartitioning();
      break;
    }

    case 4: {
      enterOuterAlt(_localctx, 4);
      setState(1402);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 27, _ctx)) {
      case 1: {
        setState(1399);
        alterCommandsModifierList();
        setState(1400);
        match(MySQLParser::COMMA_SYMBOL);
        break;
      }

      default:
        break;
      }
      setState(1404);
      standaloneAlterCommands();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterCommandListContext ------------------------------------------------------------------

MySQLParser::AlterCommandListContext::AlterCommandListContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::AlterCommandsModifierListContext* MySQLParser::AlterCommandListContext::alterCommandsModifierList() {
  return getRuleContext<MySQLParser::AlterCommandsModifierListContext>(0);
}

MySQLParser::AlterListContext* MySQLParser::AlterCommandListContext::alterList() {
  return getRuleContext<MySQLParser::AlterListContext>(0);
}

tree::TerminalNode* MySQLParser::AlterCommandListContext::COMMA_SYMBOL() {
  return getToken(MySQLParser::COMMA_SYMBOL, 0);
}


size_t MySQLParser::AlterCommandListContext::getRuleIndex() const {
  return MySQLParser::RuleAlterCommandList;
}

void MySQLParser::AlterCommandListContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterCommandList(this);
}

void MySQLParser::AlterCommandListContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterCommandList(this);
}


std::any MySQLParser::AlterCommandListContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterCommandList(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterCommandListContext* MySQLParser::alterCommandList() {
  AlterCommandListContext *_localctx = _tracker.createInstance<AlterCommandListContext>(_ctx, getState());
  enterRule(_localctx, 22, MySQLParser::RuleAlterCommandList);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(1414);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 30, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(1407);
      alterCommandsModifierList();
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(1411);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 29, _ctx)) {
      case 1: {
        setState(1408);
        alterCommandsModifierList();
        setState(1409);
        match(MySQLParser::COMMA_SYMBOL);
        break;
      }

      default:
        break;
      }
      setState(1413);
      alterList();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterCommandsModifierListContext ------------------------------------------------------------------

MySQLParser::AlterCommandsModifierListContext::AlterCommandsModifierListContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

std::vector<MySQLParser::AlterCommandsModifierContext *> MySQLParser::AlterCommandsModifierListContext::alterCommandsModifier() {
  return getRuleContexts<MySQLParser::AlterCommandsModifierContext>();
}

MySQLParser::AlterCommandsModifierContext* MySQLParser::AlterCommandsModifierListContext::alterCommandsModifier(size_t i) {
  return getRuleContext<MySQLParser::AlterCommandsModifierContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::AlterCommandsModifierListContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::AlterCommandsModifierListContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::AlterCommandsModifierListContext::getRuleIndex() const {
  return MySQLParser::RuleAlterCommandsModifierList;
}

void MySQLParser::AlterCommandsModifierListContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterCommandsModifierList(this);
}

void MySQLParser::AlterCommandsModifierListContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterCommandsModifierList(this);
}


std::any MySQLParser::AlterCommandsModifierListContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterCommandsModifierList(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterCommandsModifierListContext* MySQLParser::alterCommandsModifierList() {
  AlterCommandsModifierListContext *_localctx = _tracker.createInstance<AlterCommandsModifierListContext>(_ctx, getState());
  enterRule(_localctx, 24, MySQLParser::RuleAlterCommandsModifierList);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    size_t alt;
    enterOuterAlt(_localctx, 1);
    setState(1416);
    alterCommandsModifier();
    setState(1421);
    _errHandler->sync(this);
    alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 31, _ctx);
    while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER) {
      if (alt == 1) {
        setState(1417);
        match(MySQLParser::COMMA_SYMBOL);
        setState(1418);
        alterCommandsModifier(); 
      }
      setState(1423);
      _errHandler->sync(this);
      alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 31, _ctx);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- StandaloneAlterCommandsContext ------------------------------------------------------------------

MySQLParser::StandaloneAlterCommandsContext::StandaloneAlterCommandsContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::StandaloneAlterCommandsContext::DISCARD_SYMBOL() {
  return getToken(MySQLParser::DISCARD_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::StandaloneAlterCommandsContext::TABLESPACE_SYMBOL() {
  return getToken(MySQLParser::TABLESPACE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::StandaloneAlterCommandsContext::IMPORT_SYMBOL() {
  return getToken(MySQLParser::IMPORT_SYMBOL, 0);
}

MySQLParser::AlterPartitionContext* MySQLParser::StandaloneAlterCommandsContext::alterPartition() {
  return getRuleContext<MySQLParser::AlterPartitionContext>(0);
}

tree::TerminalNode* MySQLParser::StandaloneAlterCommandsContext::SECONDARY_LOAD_SYMBOL() {
  return getToken(MySQLParser::SECONDARY_LOAD_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::StandaloneAlterCommandsContext::SECONDARY_UNLOAD_SYMBOL() {
  return getToken(MySQLParser::SECONDARY_UNLOAD_SYMBOL, 0);
}


size_t MySQLParser::StandaloneAlterCommandsContext::getRuleIndex() const {
  return MySQLParser::RuleStandaloneAlterCommands;
}

void MySQLParser::StandaloneAlterCommandsContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterStandaloneAlterCommands(this);
}

void MySQLParser::StandaloneAlterCommandsContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitStandaloneAlterCommands(this);
}


std::any MySQLParser::StandaloneAlterCommandsContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitStandaloneAlterCommands(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::StandaloneAlterCommandsContext* MySQLParser::standaloneAlterCommands() {
  StandaloneAlterCommandsContext *_localctx = _tracker.createInstance<StandaloneAlterCommandsContext>(_ctx, getState());
  enterRule(_localctx, 26, MySQLParser::RuleStandaloneAlterCommands);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(1431);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 32, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(1424);
      match(MySQLParser::DISCARD_SYMBOL);
      setState(1425);
      match(MySQLParser::TABLESPACE_SYMBOL);
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(1426);
      match(MySQLParser::IMPORT_SYMBOL);
      setState(1427);
      match(MySQLParser::TABLESPACE_SYMBOL);
      break;
    }

    case 3: {
      enterOuterAlt(_localctx, 3);
      setState(1428);
      alterPartition();
      break;
    }

    case 4: {
      enterOuterAlt(_localctx, 4);
      setState(1429);

      if (!(serverVersion >= 80014)) throw FailedPredicateException(this, "serverVersion >= 80014");
      setState(1430);
      _la = _input->LA(1);
      if (!(_la == MySQLParser::SECONDARY_LOAD_SYMBOL

      || _la == MySQLParser::SECONDARY_UNLOAD_SYMBOL)) {
      _errHandler->recoverInline(this);
      }
      else {
        _errHandler->reportMatch(this);
        consume();
      }
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterPartitionContext ------------------------------------------------------------------

MySQLParser::AlterPartitionContext::AlterPartitionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::AlterPartitionContext::ADD_SYMBOL() {
  return getToken(MySQLParser::ADD_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterPartitionContext::PARTITION_SYMBOL() {
  return getToken(MySQLParser::PARTITION_SYMBOL, 0);
}

MySQLParser::PartitionDefinitionsContext* MySQLParser::AlterPartitionContext::partitionDefinitions() {
  return getRuleContext<MySQLParser::PartitionDefinitionsContext>(0);
}

tree::TerminalNode* MySQLParser::AlterPartitionContext::PARTITIONS_SYMBOL() {
  return getToken(MySQLParser::PARTITIONS_SYMBOL, 0);
}

MySQLParser::Real_ulong_numberContext* MySQLParser::AlterPartitionContext::real_ulong_number() {
  return getRuleContext<MySQLParser::Real_ulong_numberContext>(0);
}

std::vector<MySQLParser::NoWriteToBinLogContext *> MySQLParser::AlterPartitionContext::noWriteToBinLog() {
  return getRuleContexts<MySQLParser::NoWriteToBinLogContext>();
}

MySQLParser::NoWriteToBinLogContext* MySQLParser::AlterPartitionContext::noWriteToBinLog(size_t i) {
  return getRuleContext<MySQLParser::NoWriteToBinLogContext>(i);
}

tree::TerminalNode* MySQLParser::AlterPartitionContext::DROP_SYMBOL() {
  return getToken(MySQLParser::DROP_SYMBOL, 0);
}

MySQLParser::IdentifierListContext* MySQLParser::AlterPartitionContext::identifierList() {
  return getRuleContext<MySQLParser::IdentifierListContext>(0);
}

tree::TerminalNode* MySQLParser::AlterPartitionContext::REBUILD_SYMBOL() {
  return getToken(MySQLParser::REBUILD_SYMBOL, 0);
}

MySQLParser::AllOrPartitionNameListContext* MySQLParser::AlterPartitionContext::allOrPartitionNameList() {
  return getRuleContext<MySQLParser::AllOrPartitionNameListContext>(0);
}

tree::TerminalNode* MySQLParser::AlterPartitionContext::OPTIMIZE_SYMBOL() {
  return getToken(MySQLParser::OPTIMIZE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterPartitionContext::ANALYZE_SYMBOL() {
  return getToken(MySQLParser::ANALYZE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterPartitionContext::CHECK_SYMBOL() {
  return getToken(MySQLParser::CHECK_SYMBOL, 0);
}

std::vector<MySQLParser::CheckOptionContext *> MySQLParser::AlterPartitionContext::checkOption() {
  return getRuleContexts<MySQLParser::CheckOptionContext>();
}

MySQLParser::CheckOptionContext* MySQLParser::AlterPartitionContext::checkOption(size_t i) {
  return getRuleContext<MySQLParser::CheckOptionContext>(i);
}

tree::TerminalNode* MySQLParser::AlterPartitionContext::REPAIR_SYMBOL() {
  return getToken(MySQLParser::REPAIR_SYMBOL, 0);
}

std::vector<MySQLParser::RepairTypeContext *> MySQLParser::AlterPartitionContext::repairType() {
  return getRuleContexts<MySQLParser::RepairTypeContext>();
}

MySQLParser::RepairTypeContext* MySQLParser::AlterPartitionContext::repairType(size_t i) {
  return getRuleContext<MySQLParser::RepairTypeContext>(i);
}

tree::TerminalNode* MySQLParser::AlterPartitionContext::COALESCE_SYMBOL() {
  return getToken(MySQLParser::COALESCE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterPartitionContext::TRUNCATE_SYMBOL() {
  return getToken(MySQLParser::TRUNCATE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterPartitionContext::REORGANIZE_SYMBOL() {
  return getToken(MySQLParser::REORGANIZE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterPartitionContext::INTO_SYMBOL() {
  return getToken(MySQLParser::INTO_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterPartitionContext::EXCHANGE_SYMBOL() {
  return getToken(MySQLParser::EXCHANGE_SYMBOL, 0);
}

MySQLParser::IdentifierContext* MySQLParser::AlterPartitionContext::identifier() {
  return getRuleContext<MySQLParser::IdentifierContext>(0);
}

tree::TerminalNode* MySQLParser::AlterPartitionContext::WITH_SYMBOL() {
  return getToken(MySQLParser::WITH_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterPartitionContext::TABLE_SYMBOL() {
  return getToken(MySQLParser::TABLE_SYMBOL, 0);
}

MySQLParser::TableRefContext* MySQLParser::AlterPartitionContext::tableRef() {
  return getRuleContext<MySQLParser::TableRefContext>(0);
}

MySQLParser::WithValidationContext* MySQLParser::AlterPartitionContext::withValidation() {
  return getRuleContext<MySQLParser::WithValidationContext>(0);
}

tree::TerminalNode* MySQLParser::AlterPartitionContext::DISCARD_SYMBOL() {
  return getToken(MySQLParser::DISCARD_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterPartitionContext::TABLESPACE_SYMBOL() {
  return getToken(MySQLParser::TABLESPACE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterPartitionContext::IMPORT_SYMBOL() {
  return getToken(MySQLParser::IMPORT_SYMBOL, 0);
}


size_t MySQLParser::AlterPartitionContext::getRuleIndex() const {
  return MySQLParser::RuleAlterPartition;
}

void MySQLParser::AlterPartitionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterPartition(this);
}

void MySQLParser::AlterPartitionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterPartition(this);
}


std::any MySQLParser::AlterPartitionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterPartition(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterPartitionContext* MySQLParser::alterPartition() {
  AlterPartitionContext *_localctx = _tracker.createInstance<AlterPartitionContext>(_ctx, getState());
  enterRule(_localctx, 28, MySQLParser::RuleAlterPartition);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(1529);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 46, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(1433);
      match(MySQLParser::ADD_SYMBOL);
      setState(1434);
      match(MySQLParser::PARTITION_SYMBOL);
      setState(1436);
      _errHandler->sync(this);

      _la = _input->LA(1);
      if (_la == MySQLParser::LOCAL_SYMBOL || _la == MySQLParser::NO_WRITE_TO_BINLOG_SYMBOL) {
        setState(1435);
        noWriteToBinLog();
      }
      setState(1441);
      _errHandler->sync(this);
      switch (_input->LA(1)) {
        case MySQLParser::OPEN_PAR_SYMBOL: {
          setState(1438);
          partitionDefinitions();
          break;
        }

        case MySQLParser::PARTITIONS_SYMBOL: {
          setState(1439);
          match(MySQLParser::PARTITIONS_SYMBOL);
          setState(1440);
          real_ulong_number();
          break;
        }

      default:
        throw NoViableAltException(this);
      }
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(1443);
      match(MySQLParser::DROP_SYMBOL);
      setState(1444);
      match(MySQLParser::PARTITION_SYMBOL);
      setState(1445);
      identifierList();
      break;
    }

    case 3: {
      enterOuterAlt(_localctx, 3);
      setState(1446);
      match(MySQLParser::REBUILD_SYMBOL);
      setState(1447);
      match(MySQLParser::PARTITION_SYMBOL);
      setState(1449);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 35, _ctx)) {
      case 1: {
        setState(1448);
        noWriteToBinLog();
        break;
      }

      default:
        break;
      }
      setState(1451);
      allOrPartitionNameList();
      break;
    }

    case 4: {
      enterOuterAlt(_localctx, 4);
      setState(1452);
      match(MySQLParser::OPTIMIZE_SYMBOL);
      setState(1453);
      match(MySQLParser::PARTITION_SYMBOL);
      setState(1455);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 36, _ctx)) {
      case 1: {
        setState(1454);
        noWriteToBinLog();
        break;
      }

      default:
        break;
      }
      setState(1457);
      allOrPartitionNameList();
      setState(1459);
      _errHandler->sync(this);

      _la = _input->LA(1);
      if (_la == MySQLParser::LOCAL_SYMBOL || _la == MySQLParser::NO_WRITE_TO_BINLOG_SYMBOL) {
        setState(1458);
        noWriteToBinLog();
      }
      break;
    }

    case 5: {
      enterOuterAlt(_localctx, 5);
      setState(1461);
      match(MySQLParser::ANALYZE_SYMBOL);
      setState(1462);
      match(MySQLParser::PARTITION_SYMBOL);
      setState(1464);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 38, _ctx)) {
      case 1: {
        setState(1463);
        noWriteToBinLog();
        break;
      }

      default:
        break;
      }
      setState(1466);
      allOrPartitionNameList();
      break;
    }

    case 6: {
      enterOuterAlt(_localctx, 6);
      setState(1467);
      match(MySQLParser::CHECK_SYMBOL);
      setState(1468);
      match(MySQLParser::PARTITION_SYMBOL);
      setState(1469);
      allOrPartitionNameList();
      setState(1473);
      _errHandler->sync(this);
      _la = _input->LA(1);
      while (_la == MySQLParser::CHANGED_SYMBOL || ((((_la - 180) & ~ 0x3fULL) == 0) &&
        ((1ULL << (_la - 180)) & 1048593) != 0) || _la == MySQLParser::MEDIUM_SYMBOL || _la == MySQLParser::QUICK_SYMBOL) {
        setState(1470);
        checkOption();
        setState(1475);
        _errHandler->sync(this);
        _la = _input->LA(1);
      }
      break;
    }

    case 7: {
      enterOuterAlt(_localctx, 7);
      setState(1476);
      match(MySQLParser::REPAIR_SYMBOL);
      setState(1477);
      match(MySQLParser::PARTITION_SYMBOL);
      setState(1479);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 40, _ctx)) {
      case 1: {
        setState(1478);
        noWriteToBinLog();
        break;
      }

      default:
        break;
      }
      setState(1481);
      allOrPartitionNameList();
      setState(1485);
      _errHandler->sync(this);
      _la = _input->LA(1);
      while (_la == MySQLParser::EXTENDED_SYMBOL || _la == MySQLParser::QUICK_SYMBOL || _la == MySQLParser::USE_FRM_SYMBOL) {
        setState(1482);
        repairType();
        setState(1487);
        _errHandler->sync(this);
        _la = _input->LA(1);
      }
      break;
    }

    case 8: {
      enterOuterAlt(_localctx, 8);
      setState(1488);
      match(MySQLParser::COALESCE_SYMBOL);
      setState(1489);
      match(MySQLParser::PARTITION_SYMBOL);
      setState(1491);
      _errHandler->sync(this);

      _la = _input->LA(1);
      if (_la == MySQLParser::LOCAL_SYMBOL || _la == MySQLParser::NO_WRITE_TO_BINLOG_SYMBOL) {
        setState(1490);
        noWriteToBinLog();
      }
      setState(1493);
      real_ulong_number();
      break;
    }

    case 9: {
      enterOuterAlt(_localctx, 9);
      setState(1494);
      match(MySQLParser::TRUNCATE_SYMBOL);
      setState(1495);
      match(MySQLParser::PARTITION_SYMBOL);
      setState(1496);
      allOrPartitionNameList();
      break;
    }

    case 10: {
      enterOuterAlt(_localctx, 10);
      setState(1497);
      match(MySQLParser::REORGANIZE_SYMBOL);
      setState(1498);
      match(MySQLParser::PARTITION_SYMBOL);
      setState(1500);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 43, _ctx)) {
      case 1: {
        setState(1499);
        noWriteToBinLog();
        break;
      }

      default:
        break;
      }
      setState(1506);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 44, _ctx)) {
      case 1: {
        setState(1502);
        identifierList();
        setState(1503);
        match(MySQLParser::INTO_SYMBOL);
        setState(1504);
        partitionDefinitions();
        break;
      }

      default:
        break;
      }
      break;
    }

    case 11: {
      enterOuterAlt(_localctx, 11);
      setState(1508);
      match(MySQLParser::EXCHANGE_SYMBOL);
      setState(1509);
      match(MySQLParser::PARTITION_SYMBOL);
      setState(1510);
      identifier();
      setState(1511);
      match(MySQLParser::WITH_SYMBOL);
      setState(1512);
      match(MySQLParser::TABLE_SYMBOL);
      setState(1513);
      tableRef();
      setState(1515);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 45, _ctx)) {
      case 1: {
        setState(1514);
        withValidation();
        break;
      }

      default:
        break;
      }
      break;
    }

    case 12: {
      enterOuterAlt(_localctx, 12);
      setState(1517);

      if (!(serverVersion >= 50704)) throw FailedPredicateException(this, "serverVersion >= 50704");
      setState(1518);
      match(MySQLParser::DISCARD_SYMBOL);
      setState(1519);
      match(MySQLParser::PARTITION_SYMBOL);
      setState(1520);
      allOrPartitionNameList();
      setState(1521);
      match(MySQLParser::TABLESPACE_SYMBOL);
      break;
    }

    case 13: {
      enterOuterAlt(_localctx, 13);
      setState(1523);

      if (!(serverVersion >= 50704)) throw FailedPredicateException(this, "serverVersion >= 50704");
      setState(1524);
      match(MySQLParser::IMPORT_SYMBOL);
      setState(1525);
      match(MySQLParser::PARTITION_SYMBOL);
      setState(1526);
      allOrPartitionNameList();
      setState(1527);
      match(MySQLParser::TABLESPACE_SYMBOL);
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterListContext ------------------------------------------------------------------

MySQLParser::AlterListContext::AlterListContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

std::vector<MySQLParser::AlterListItemContext *> MySQLParser::AlterListContext::alterListItem() {
  return getRuleContexts<MySQLParser::AlterListItemContext>();
}

MySQLParser::AlterListItemContext* MySQLParser::AlterListContext::alterListItem(size_t i) {
  return getRuleContext<MySQLParser::AlterListItemContext>(i);
}

std::vector<MySQLParser::CreateTableOptionsSpaceSeparatedContext *> MySQLParser::AlterListContext::createTableOptionsSpaceSeparated() {
  return getRuleContexts<MySQLParser::CreateTableOptionsSpaceSeparatedContext>();
}

MySQLParser::CreateTableOptionsSpaceSeparatedContext* MySQLParser::AlterListContext::createTableOptionsSpaceSeparated(size_t i) {
  return getRuleContext<MySQLParser::CreateTableOptionsSpaceSeparatedContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::AlterListContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::AlterListContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}

std::vector<MySQLParser::AlterCommandsModifierContext *> MySQLParser::AlterListContext::alterCommandsModifier() {
  return getRuleContexts<MySQLParser::AlterCommandsModifierContext>();
}

MySQLParser::AlterCommandsModifierContext* MySQLParser::AlterListContext::alterCommandsModifier(size_t i) {
  return getRuleContext<MySQLParser::AlterCommandsModifierContext>(i);
}


size_t MySQLParser::AlterListContext::getRuleIndex() const {
  return MySQLParser::RuleAlterList;
}

void MySQLParser::AlterListContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterList(this);
}

void MySQLParser::AlterListContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterList(this);
}


std::any MySQLParser::AlterListContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterList(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterListContext* MySQLParser::alterList() {
  AlterListContext *_localctx = _tracker.createInstance<AlterListContext>(_ctx, getState());
  enterRule(_localctx, 30, MySQLParser::RuleAlterList);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(1533);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 47, _ctx)) {
    case 1: {
      setState(1531);
      alterListItem();
      break;
    }

    case 2: {
      setState(1532);
      createTableOptionsSpaceSeparated();
      break;
    }

    default:
      break;
    }
    setState(1543);
    _errHandler->sync(this);
    _la = _input->LA(1);
    while (_la == MySQLParser::COMMA_SYMBOL) {
      setState(1535);
      match(MySQLParser::COMMA_SYMBOL);
      setState(1539);
      _errHandler->sync(this);
      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 48, _ctx)) {
      case 1: {
        setState(1536);
        alterListItem();
        break;
      }

      case 2: {
        setState(1537);
        alterCommandsModifier();
        break;
      }

      case 3: {
        setState(1538);
        createTableOptionsSpaceSeparated();
        break;
      }

      default:
        break;
      }
      setState(1545);
      _errHandler->sync(this);
      _la = _input->LA(1);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterCommandsModifierContext ------------------------------------------------------------------

MySQLParser::AlterCommandsModifierContext::AlterCommandsModifierContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::AlterAlgorithmOptionContext* MySQLParser::AlterCommandsModifierContext::alterAlgorithmOption() {
  return getRuleContext<MySQLParser::AlterAlgorithmOptionContext>(0);
}

MySQLParser::AlterLockOptionContext* MySQLParser::AlterCommandsModifierContext::alterLockOption() {
  return getRuleContext<MySQLParser::AlterLockOptionContext>(0);
}

MySQLParser::WithValidationContext* MySQLParser::AlterCommandsModifierContext::withValidation() {
  return getRuleContext<MySQLParser::WithValidationContext>(0);
}


size_t MySQLParser::AlterCommandsModifierContext::getRuleIndex() const {
  return MySQLParser::RuleAlterCommandsModifier;
}

void MySQLParser::AlterCommandsModifierContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterCommandsModifier(this);
}

void MySQLParser::AlterCommandsModifierContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterCommandsModifier(this);
}


std::any MySQLParser::AlterCommandsModifierContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterCommandsModifier(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterCommandsModifierContext* MySQLParser::alterCommandsModifier() {
  AlterCommandsModifierContext *_localctx = _tracker.createInstance<AlterCommandsModifierContext>(_ctx, getState());
  enterRule(_localctx, 32, MySQLParser::RuleAlterCommandsModifier);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(1549);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 50, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(1546);
      alterAlgorithmOption();
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(1547);
      alterLockOption();
      break;
    }

    case 3: {
      enterOuterAlt(_localctx, 3);
      setState(1548);
      withValidation();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterListItemContext ------------------------------------------------------------------

MySQLParser::AlterListItemContext::AlterListItemContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::AlterListItemContext::ADD_SYMBOL() {
  return getToken(MySQLParser::ADD_SYMBOL, 0);
}

MySQLParser::IdentifierContext* MySQLParser::AlterListItemContext::identifier() {
  return getRuleContext<MySQLParser::IdentifierContext>(0);
}

MySQLParser::FieldDefinitionContext* MySQLParser::AlterListItemContext::fieldDefinition() {
  return getRuleContext<MySQLParser::FieldDefinitionContext>(0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::OPEN_PAR_SYMBOL() {
  return getToken(MySQLParser::OPEN_PAR_SYMBOL, 0);
}

MySQLParser::TableElementListContext* MySQLParser::AlterListItemContext::tableElementList() {
  return getRuleContext<MySQLParser::TableElementListContext>(0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::CLOSE_PAR_SYMBOL() {
  return getToken(MySQLParser::CLOSE_PAR_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::COLUMN_SYMBOL() {
  return getToken(MySQLParser::COLUMN_SYMBOL, 0);
}

MySQLParser::CheckOrReferencesContext* MySQLParser::AlterListItemContext::checkOrReferences() {
  return getRuleContext<MySQLParser::CheckOrReferencesContext>(0);
}

MySQLParser::PlaceContext* MySQLParser::AlterListItemContext::place() {
  return getRuleContext<MySQLParser::PlaceContext>(0);
}

MySQLParser::TableConstraintDefContext* MySQLParser::AlterListItemContext::tableConstraintDef() {
  return getRuleContext<MySQLParser::TableConstraintDefContext>(0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::CHANGE_SYMBOL() {
  return getToken(MySQLParser::CHANGE_SYMBOL, 0);
}

MySQLParser::ColumnInternalRefContext* MySQLParser::AlterListItemContext::columnInternalRef() {
  return getRuleContext<MySQLParser::ColumnInternalRefContext>(0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::MODIFY_SYMBOL() {
  return getToken(MySQLParser::MODIFY_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::DROP_SYMBOL() {
  return getToken(MySQLParser::DROP_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::FOREIGN_SYMBOL() {
  return getToken(MySQLParser::FOREIGN_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::KEY_SYMBOL() {
  return getToken(MySQLParser::KEY_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::PRIMARY_SYMBOL() {
  return getToken(MySQLParser::PRIMARY_SYMBOL, 0);
}

MySQLParser::KeyOrIndexContext* MySQLParser::AlterListItemContext::keyOrIndex() {
  return getRuleContext<MySQLParser::KeyOrIndexContext>(0);
}

MySQLParser::IndexRefContext* MySQLParser::AlterListItemContext::indexRef() {
  return getRuleContext<MySQLParser::IndexRefContext>(0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::CHECK_SYMBOL() {
  return getToken(MySQLParser::CHECK_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::CONSTRAINT_SYMBOL() {
  return getToken(MySQLParser::CONSTRAINT_SYMBOL, 0);
}

MySQLParser::RestrictContext* MySQLParser::AlterListItemContext::restrict() {
  return getRuleContext<MySQLParser::RestrictContext>(0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::DISABLE_SYMBOL() {
  return getToken(MySQLParser::DISABLE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::KEYS_SYMBOL() {
  return getToken(MySQLParser::KEYS_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::ENABLE_SYMBOL() {
  return getToken(MySQLParser::ENABLE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::ALTER_SYMBOL() {
  return getToken(MySQLParser::ALTER_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::SET_SYMBOL() {
  return getToken(MySQLParser::SET_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::DEFAULT_SYMBOL() {
  return getToken(MySQLParser::DEFAULT_SYMBOL, 0);
}

MySQLParser::ExprWithParenthesesContext* MySQLParser::AlterListItemContext::exprWithParentheses() {
  return getRuleContext<MySQLParser::ExprWithParenthesesContext>(0);
}

MySQLParser::SignedLiteralContext* MySQLParser::AlterListItemContext::signedLiteral() {
  return getRuleContext<MySQLParser::SignedLiteralContext>(0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::INDEX_SYMBOL() {
  return getToken(MySQLParser::INDEX_SYMBOL, 0);
}

MySQLParser::VisibilityContext* MySQLParser::AlterListItemContext::visibility() {
  return getRuleContext<MySQLParser::VisibilityContext>(0);
}

MySQLParser::ConstraintEnforcementContext* MySQLParser::AlterListItemContext::constraintEnforcement() {
  return getRuleContext<MySQLParser::ConstraintEnforcementContext>(0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::RENAME_SYMBOL() {
  return getToken(MySQLParser::RENAME_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::TO_SYMBOL() {
  return getToken(MySQLParser::TO_SYMBOL, 0);
}

MySQLParser::TableNameContext* MySQLParser::AlterListItemContext::tableName() {
  return getRuleContext<MySQLParser::TableNameContext>(0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::AS_SYMBOL() {
  return getToken(MySQLParser::AS_SYMBOL, 0);
}

MySQLParser::IndexNameContext* MySQLParser::AlterListItemContext::indexName() {
  return getRuleContext<MySQLParser::IndexNameContext>(0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::CONVERT_SYMBOL() {
  return getToken(MySQLParser::CONVERT_SYMBOL, 0);
}

MySQLParser::CharsetContext* MySQLParser::AlterListItemContext::charset() {
  return getRuleContext<MySQLParser::CharsetContext>(0);
}

MySQLParser::CharsetNameContext* MySQLParser::AlterListItemContext::charsetName() {
  return getRuleContext<MySQLParser::CharsetNameContext>(0);
}

MySQLParser::CollateContext* MySQLParser::AlterListItemContext::collate() {
  return getRuleContext<MySQLParser::CollateContext>(0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::FORCE_SYMBOL() {
  return getToken(MySQLParser::FORCE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::ORDER_SYMBOL() {
  return getToken(MySQLParser::ORDER_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::BY_SYMBOL() {
  return getToken(MySQLParser::BY_SYMBOL, 0);
}

MySQLParser::AlterOrderListContext* MySQLParser::AlterListItemContext::alterOrderList() {
  return getRuleContext<MySQLParser::AlterOrderListContext>(0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::UPGRADE_SYMBOL() {
  return getToken(MySQLParser::UPGRADE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterListItemContext::PARTITIONING_SYMBOL() {
  return getToken(MySQLParser::PARTITIONING_SYMBOL, 0);
}


size_t MySQLParser::AlterListItemContext::getRuleIndex() const {
  return MySQLParser::RuleAlterListItem;
}

void MySQLParser::AlterListItemContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterListItem(this);
}

void MySQLParser::AlterListItemContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterListItem(this);
}


std::any MySQLParser::AlterListItemContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterListItem(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterListItemContext* MySQLParser::alterListItem() {
  AlterListItemContext *_localctx = _tracker.createInstance<AlterListItemContext>(_ctx, getState());
  enterRule(_localctx, 34, MySQLParser::RuleAlterListItem);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(1696);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 70, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(1551);
      match(MySQLParser::ADD_SYMBOL);
      setState(1553);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 51, _ctx)) {
      case 1: {
        setState(1552);
        match(MySQLParser::COLUMN_SYMBOL);
        break;
      }

      default:
        break;
      }
      setState(1567);
      _errHandler->sync(this);
      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 54, _ctx)) {
      case 1: {
        setState(1555);
        identifier();
        setState(1556);
        fieldDefinition();
        setState(1558);
        _errHandler->sync(this);

        switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 52, _ctx)) {
        case 1: {
          setState(1557);
          checkOrReferences();
          break;
        }

        default:
          break;
        }
        setState(1561);
        _errHandler->sync(this);

        _la = _input->LA(1);
        if (_la == MySQLParser::AFTER_SYMBOL || _la == MySQLParser::FIRST_SYMBOL) {
          setState(1560);
          place();
        }
        break;
      }

      case 2: {
        setState(1563);
        match(MySQLParser::OPEN_PAR_SYMBOL);
        setState(1564);
        tableElementList();
        setState(1565);
        match(MySQLParser::CLOSE_PAR_SYMBOL);
        break;
      }

      default:
        break;
      }
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(1569);
      match(MySQLParser::ADD_SYMBOL);
      setState(1570);
      tableConstraintDef();
      break;
    }

    case 3: {
      enterOuterAlt(_localctx, 3);
      setState(1571);
      match(MySQLParser::CHANGE_SYMBOL);
      setState(1573);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 55, _ctx)) {
      case 1: {
        setState(1572);
        match(MySQLParser::COLUMN_SYMBOL);
        break;
      }

      default:
        break;
      }
      setState(1575);
      columnInternalRef();
      setState(1576);
      identifier();
      setState(1577);
      fieldDefinition();
      setState(1579);
      _errHandler->sync(this);

      _la = _input->LA(1);
      if (_la == MySQLParser::AFTER_SYMBOL || _la == MySQLParser::FIRST_SYMBOL) {
        setState(1578);
        place();
      }
      break;
    }

    case 4: {
      enterOuterAlt(_localctx, 4);
      setState(1581);
      match(MySQLParser::MODIFY_SYMBOL);
      setState(1583);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 57, _ctx)) {
      case 1: {
        setState(1582);
        match(MySQLParser::COLUMN_SYMBOL);
        break;
      }

      default:
        break;
      }
      setState(1585);
      columnInternalRef();
      setState(1586);
      fieldDefinition();
      setState(1588);
      _errHandler->sync(this);

      _la = _input->LA(1);
      if (_la == MySQLParser::AFTER_SYMBOL || _la == MySQLParser::FIRST_SYMBOL) {
        setState(1587);
        place();
      }
      break;
    }

    case 5: {
      enterOuterAlt(_localctx, 5);
      setState(1590);
      match(MySQLParser::DROP_SYMBOL);
      setState(1619);
      _errHandler->sync(this);
      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 63, _ctx)) {
      case 1: {
        setState(1592);
        _errHandler->sync(this);

        switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 59, _ctx)) {
        case 1: {
          setState(1591);
          match(MySQLParser::COLUMN_SYMBOL);
          break;
        }

        default:
          break;
        }
        setState(1594);
        columnInternalRef();
        setState(1596);
        _errHandler->sync(this);

        _la = _input->LA(1);
        if (_la == MySQLParser::CASCADE_SYMBOL || _la == MySQLParser::RESTRICT_SYMBOL) {
          setState(1595);
          restrict();
        }
        break;
      }

      case 2: {
        setState(1598);
        match(MySQLParser::FOREIGN_SYMBOL);
        setState(1599);
        match(MySQLParser::KEY_SYMBOL);
        setState(1606);
        _errHandler->sync(this);
        switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 62, _ctx)) {
        case 1: {
          setState(1600);

          if (!(serverVersion >= 50700)) throw FailedPredicateException(this, "serverVersion >= 50700");
          setState(1601);
          columnInternalRef();
          break;
        }

        case 2: {
          setState(1602);

          if (!(serverVersion < 50700)) throw FailedPredicateException(this, "serverVersion < 50700");
          setState(1604);
          _errHandler->sync(this);

          switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 61, _ctx)) {
          case 1: {
            setState(1603);
            columnInternalRef();
            break;
          }

          default:
            break;
          }
          break;
        }

        default:
          break;
        }
        break;
      }

      case 3: {
        setState(1608);
        match(MySQLParser::PRIMARY_SYMBOL);
        setState(1609);
        match(MySQLParser::KEY_SYMBOL);
        break;
      }

      case 4: {
        setState(1610);
        keyOrIndex();
        setState(1611);
        indexRef();
        break;
      }

      case 5: {
        setState(1613);

        if (!(serverVersion >= 80017)) throw FailedPredicateException(this, "serverVersion >= 80017");
        setState(1614);
        match(MySQLParser::CHECK_SYMBOL);
        setState(1615);
        identifier();
        break;
      }

      case 6: {
        setState(1616);

        if (!(serverVersion >= 80019)) throw FailedPredicateException(this, "serverVersion >= 80019");
        setState(1617);
        match(MySQLParser::CONSTRAINT_SYMBOL);
        setState(1618);
        identifier();
        break;
      }

      default:
        break;
      }
      break;
    }

    case 6: {
      enterOuterAlt(_localctx, 6);
      setState(1621);
      match(MySQLParser::DISABLE_SYMBOL);
      setState(1622);
      match(MySQLParser::KEYS_SYMBOL);
      break;
    }

    case 7: {
      enterOuterAlt(_localctx, 7);
      setState(1623);
      match(MySQLParser::ENABLE_SYMBOL);
      setState(1624);
      match(MySQLParser::KEYS_SYMBOL);
      break;
    }

    case 8: {
      enterOuterAlt(_localctx, 8);
      setState(1625);
      match(MySQLParser::ALTER_SYMBOL);
      setState(1627);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 64, _ctx)) {
      case 1: {
        setState(1626);
        match(MySQLParser::COLUMN_SYMBOL);
        break;
      }

      default:
        break;
      }
      setState(1629);
      columnInternalRef();
      setState(1639);
      _errHandler->sync(this);
      switch (_input->LA(1)) {
        case MySQLParser::SET_SYMBOL: {
          setState(1630);
          match(MySQLParser::SET_SYMBOL);
          setState(1631);
          match(MySQLParser::DEFAULT_SYMBOL);
          setState(1635);
          _errHandler->sync(this);
          switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 65, _ctx)) {
          case 1: {
            setState(1632);

            if (!(serverVersion >= 80014)) throw FailedPredicateException(this, "serverVersion >= 80014");
            setState(1633);
            exprWithParentheses();
            break;
          }

          case 2: {
            setState(1634);
            signedLiteral();
            break;
          }

          default:
            break;
          }
          break;
        }

        case MySQLParser::DROP_SYMBOL: {
          setState(1637);
          match(MySQLParser::DROP_SYMBOL);
          setState(1638);
          match(MySQLParser::DEFAULT_SYMBOL);
          break;
        }

      default:
        throw NoViableAltException(this);
      }
      break;
    }

    case 9: {
      enterOuterAlt(_localctx, 9);
      setState(1641);

      if (!(serverVersion >= 80000)) throw FailedPredicateException(this, "serverVersion >= 80000");
      setState(1642);
      match(MySQLParser::ALTER_SYMBOL);
      setState(1643);
      match(MySQLParser::INDEX_SYMBOL);
      setState(1644);
      indexRef();
      setState(1645);
      visibility();
      break;
    }

    case 10: {
      enterOuterAlt(_localctx, 10);
      setState(1647);

      if (!(serverVersion >= 80017)) throw FailedPredicateException(this, "serverVersion >= 80017");
      setState(1648);
      match(MySQLParser::ALTER_SYMBOL);
      setState(1649);
      match(MySQLParser::CHECK_SYMBOL);
      setState(1650);
      identifier();
      setState(1651);
      constraintEnforcement();
      break;
    }

    case 11: {
      enterOuterAlt(_localctx, 11);
      setState(1653);

      if (!(serverVersion >= 80019)) throw FailedPredicateException(this, "serverVersion >= 80019");
      setState(1654);
      match(MySQLParser::ALTER_SYMBOL);
      setState(1655);
      match(MySQLParser::CONSTRAINT_SYMBOL);
      setState(1656);
      identifier();
      setState(1657);
      constraintEnforcement();
      break;
    }

    case 12: {
      enterOuterAlt(_localctx, 12);
      setState(1659);

      if (!(serverVersion >= 80000)) throw FailedPredicateException(this, "serverVersion >= 80000");
      setState(1660);
      match(MySQLParser::RENAME_SYMBOL);
      setState(1661);
      match(MySQLParser::COLUMN_SYMBOL);
      setState(1662);
      columnInternalRef();
      setState(1663);
      match(MySQLParser::TO_SYMBOL);
      setState(1664);
      identifier();
      break;
    }

    case 13: {
      enterOuterAlt(_localctx, 13);
      setState(1666);
      match(MySQLParser::RENAME_SYMBOL);
      setState(1668);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 67, _ctx)) {
      case 1: {
        setState(1667);
        _la = _input->LA(1);
        if (!(_la == MySQLParser::AS_SYMBOL || _la == MySQLParser::TO_SYMBOL)) {
        _errHandler->recoverInline(this);
        }
        else {
          _errHandler->reportMatch(this);
          consume();
        }
        break;
      }

      default:
        break;
      }
      setState(1670);
      tableName();
      break;
    }

    case 14: {
      enterOuterAlt(_localctx, 14);
      setState(1671);

      if (!(serverVersion >= 50700)) throw FailedPredicateException(this, "serverVersion >= 50700");
      setState(1672);
      match(MySQLParser::RENAME_SYMBOL);
      setState(1673);
      keyOrIndex();
      setState(1674);
      indexRef();
      setState(1675);
      match(MySQLParser::TO_SYMBOL);
      setState(1676);
      indexName();
      break;
    }

    case 15: {
      enterOuterAlt(_localctx, 15);
      setState(1678);
      match(MySQLParser::CONVERT_SYMBOL);
      setState(1679);
      match(MySQLParser::TO_SYMBOL);
      setState(1680);
      charset();
      setState(1684);
      _errHandler->sync(this);
      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 68, _ctx)) {
      case 1: {
        setState(1681);

        if (!(serverVersion >= 80014)) throw FailedPredicateException(this, "serverVersion >= 80014");
        setState(1682);
        match(MySQLParser::DEFAULT_SYMBOL);
        break;
      }

      case 2: {
        setState(1683);
        charsetName();
        break;
      }

      default:
        break;
      }
      setState(1687);
      _errHandler->sync(this);

      _la = _input->LA(1);
      if (_la == MySQLParser::COLLATE_SYMBOL) {
        setState(1686);
        collate();
      }
      break;
    }

    case 16: {
      enterOuterAlt(_localctx, 16);
      setState(1689);
      match(MySQLParser::FORCE_SYMBOL);
      break;
    }

    case 17: {
      enterOuterAlt(_localctx, 17);
      setState(1690);
      match(MySQLParser::ORDER_SYMBOL);
      setState(1691);
      match(MySQLParser::BY_SYMBOL);
      setState(1692);
      alterOrderList();
      break;
    }

    case 18: {
      enterOuterAlt(_localctx, 18);
      setState(1693);

      if (!(serverVersion >= 50708 && serverVersion < 80000)) throw FailedPredicateException(this, "serverVersion >= 50708 && serverVersion < 80000");
      setState(1694);
      match(MySQLParser::UPGRADE_SYMBOL);
      setState(1695);
      match(MySQLParser::PARTITIONING_SYMBOL);
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- PlaceContext ------------------------------------------------------------------

MySQLParser::PlaceContext::PlaceContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::PlaceContext::AFTER_SYMBOL() {
  return getToken(MySQLParser::AFTER_SYMBOL, 0);
}

MySQLParser::IdentifierContext* MySQLParser::PlaceContext::identifier() {
  return getRuleContext<MySQLParser::IdentifierContext>(0);
}

tree::TerminalNode* MySQLParser::PlaceContext::FIRST_SYMBOL() {
  return getToken(MySQLParser::FIRST_SYMBOL, 0);
}


size_t MySQLParser::PlaceContext::getRuleIndex() const {
  return MySQLParser::RulePlace;
}

void MySQLParser::PlaceContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterPlace(this);
}

void MySQLParser::PlaceContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitPlace(this);
}


std::any MySQLParser::PlaceContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitPlace(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::PlaceContext* MySQLParser::place() {
  PlaceContext *_localctx = _tracker.createInstance<PlaceContext>(_ctx, getState());
  enterRule(_localctx, 36, MySQLParser::RulePlace);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(1701);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::AFTER_SYMBOL: {
        enterOuterAlt(_localctx, 1);
        setState(1698);
        match(MySQLParser::AFTER_SYMBOL);
        setState(1699);
        identifier();
        break;
      }

      case MySQLParser::FIRST_SYMBOL: {
        enterOuterAlt(_localctx, 2);
        setState(1700);
        match(MySQLParser::FIRST_SYMBOL);
        break;
      }

    default:
      throw NoViableAltException(this);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- RestrictContext ------------------------------------------------------------------

MySQLParser::RestrictContext::RestrictContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::RestrictContext::RESTRICT_SYMBOL() {
  return getToken(MySQLParser::RESTRICT_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::RestrictContext::CASCADE_SYMBOL() {
  return getToken(MySQLParser::CASCADE_SYMBOL, 0);
}


size_t MySQLParser::RestrictContext::getRuleIndex() const {
  return MySQLParser::RuleRestrict;
}

void MySQLParser::RestrictContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterRestrict(this);
}

void MySQLParser::RestrictContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitRestrict(this);
}


std::any MySQLParser::RestrictContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitRestrict(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::RestrictContext* MySQLParser::restrict() {
  RestrictContext *_localctx = _tracker.createInstance<RestrictContext>(_ctx, getState());
  enterRule(_localctx, 38, MySQLParser::RuleRestrict);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(1703);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::CASCADE_SYMBOL || _la == MySQLParser::RESTRICT_SYMBOL)) {
    _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterOrderListContext ------------------------------------------------------------------

MySQLParser::AlterOrderListContext::AlterOrderListContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

std::vector<MySQLParser::IdentifierContext *> MySQLParser::AlterOrderListContext::identifier() {
  return getRuleContexts<MySQLParser::IdentifierContext>();
}

MySQLParser::IdentifierContext* MySQLParser::AlterOrderListContext::identifier(size_t i) {
  return getRuleContext<MySQLParser::IdentifierContext>(i);
}

std::vector<MySQLParser::DirectionContext *> MySQLParser::AlterOrderListContext::direction() {
  return getRuleContexts<MySQLParser::DirectionContext>();
}

MySQLParser::DirectionContext* MySQLParser::AlterOrderListContext::direction(size_t i) {
  return getRuleContext<MySQLParser::DirectionContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::AlterOrderListContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::AlterOrderListContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::AlterOrderListContext::getRuleIndex() const {
  return MySQLParser::RuleAlterOrderList;
}

void MySQLParser::AlterOrderListContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterOrderList(this);
}

void MySQLParser::AlterOrderListContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterOrderList(this);
}


std::any MySQLParser::AlterOrderListContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterOrderList(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterOrderListContext* MySQLParser::alterOrderList() {
  AlterOrderListContext *_localctx = _tracker.createInstance<AlterOrderListContext>(_ctx, getState());
  enterRule(_localctx, 40, MySQLParser::RuleAlterOrderList);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    size_t alt;
    enterOuterAlt(_localctx, 1);
    setState(1705);
    identifier();
    setState(1707);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::ASC_SYMBOL || _la == MySQLParser::DESC_SYMBOL) {
      setState(1706);
      direction();
    }
    setState(1716);
    _errHandler->sync(this);
    alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 74, _ctx);
    while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER) {
      if (alt == 1) {
        setState(1709);
        match(MySQLParser::COMMA_SYMBOL);
        setState(1710);
        identifier();
        setState(1712);
        _errHandler->sync(this);

        _la = _input->LA(1);
        if (_la == MySQLParser::ASC_SYMBOL || _la == MySQLParser::DESC_SYMBOL) {
          setState(1711);
          direction();
        } 
      }
      setState(1718);
      _errHandler->sync(this);
      alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 74, _ctx);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterAlgorithmOptionContext ------------------------------------------------------------------

MySQLParser::AlterAlgorithmOptionContext::AlterAlgorithmOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::AlterAlgorithmOptionContext::ALGORITHM_SYMBOL() {
  return getToken(MySQLParser::ALGORITHM_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterAlgorithmOptionContext::DEFAULT_SYMBOL() {
  return getToken(MySQLParser::DEFAULT_SYMBOL, 0);
}

MySQLParser::IdentifierContext* MySQLParser::AlterAlgorithmOptionContext::identifier() {
  return getRuleContext<MySQLParser::IdentifierContext>(0);
}

tree::TerminalNode* MySQLParser::AlterAlgorithmOptionContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}


size_t MySQLParser::AlterAlgorithmOptionContext::getRuleIndex() const {
  return MySQLParser::RuleAlterAlgorithmOption;
}

void MySQLParser::AlterAlgorithmOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterAlgorithmOption(this);
}

void MySQLParser::AlterAlgorithmOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterAlgorithmOption(this);
}


std::any MySQLParser::AlterAlgorithmOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterAlgorithmOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterAlgorithmOptionContext* MySQLParser::alterAlgorithmOption() {
  AlterAlgorithmOptionContext *_localctx = _tracker.createInstance<AlterAlgorithmOptionContext>(_ctx, getState());
  enterRule(_localctx, 42, MySQLParser::RuleAlterAlgorithmOption);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(1719);
    match(MySQLParser::ALGORITHM_SYMBOL);
    setState(1721);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 75, _ctx)) {
    case 1: {
      setState(1720);
      match(MySQLParser::EQUAL_OPERATOR);
      break;
    }

    default:
      break;
    }
    setState(1725);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 76, _ctx)) {
    case 1: {
      setState(1723);
      match(MySQLParser::DEFAULT_SYMBOL);
      break;
    }

    case 2: {
      setState(1724);
      identifier();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterLockOptionContext ------------------------------------------------------------------

MySQLParser::AlterLockOptionContext::AlterLockOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::AlterLockOptionContext::LOCK_SYMBOL() {
  return getToken(MySQLParser::LOCK_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterLockOptionContext::DEFAULT_SYMBOL() {
  return getToken(MySQLParser::DEFAULT_SYMBOL, 0);
}

MySQLParser::IdentifierContext* MySQLParser::AlterLockOptionContext::identifier() {
  return getRuleContext<MySQLParser::IdentifierContext>(0);
}

tree::TerminalNode* MySQLParser::AlterLockOptionContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}


size_t MySQLParser::AlterLockOptionContext::getRuleIndex() const {
  return MySQLParser::RuleAlterLockOption;
}

void MySQLParser::AlterLockOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterLockOption(this);
}

void MySQLParser::AlterLockOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterLockOption(this);
}


std::any MySQLParser::AlterLockOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterLockOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterLockOptionContext* MySQLParser::alterLockOption() {
  AlterLockOptionContext *_localctx = _tracker.createInstance<AlterLockOptionContext>(_ctx, getState());
  enterRule(_localctx, 44, MySQLParser::RuleAlterLockOption);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(1727);
    match(MySQLParser::LOCK_SYMBOL);
    setState(1729);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 77, _ctx)) {
    case 1: {
      setState(1728);
      match(MySQLParser::EQUAL_OPERATOR);
      break;
    }

    default:
      break;
    }
    setState(1733);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 78, _ctx)) {
    case 1: {
      setState(1731);
      match(MySQLParser::DEFAULT_SYMBOL);
      break;
    }

    case 2: {
      setState(1732);
      identifier();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- IndexLockAndAlgorithmContext ------------------------------------------------------------------

MySQLParser::IndexLockAndAlgorithmContext::IndexLockAndAlgorithmContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::AlterAlgorithmOptionContext* MySQLParser::IndexLockAndAlgorithmContext::alterAlgorithmOption() {
  return getRuleContext<MySQLParser::AlterAlgorithmOptionContext>(0);
}

MySQLParser::AlterLockOptionContext* MySQLParser::IndexLockAndAlgorithmContext::alterLockOption() {
  return getRuleContext<MySQLParser::AlterLockOptionContext>(0);
}


size_t MySQLParser::IndexLockAndAlgorithmContext::getRuleIndex() const {
  return MySQLParser::RuleIndexLockAndAlgorithm;
}

void MySQLParser::IndexLockAndAlgorithmContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterIndexLockAndAlgorithm(this);
}

void MySQLParser::IndexLockAndAlgorithmContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitIndexLockAndAlgorithm(this);
}


std::any MySQLParser::IndexLockAndAlgorithmContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitIndexLockAndAlgorithm(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::IndexLockAndAlgorithmContext* MySQLParser::indexLockAndAlgorithm() {
  IndexLockAndAlgorithmContext *_localctx = _tracker.createInstance<IndexLockAndAlgorithmContext>(_ctx, getState());
  enterRule(_localctx, 46, MySQLParser::RuleIndexLockAndAlgorithm);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(1743);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::ALGORITHM_SYMBOL: {
        enterOuterAlt(_localctx, 1);
        setState(1735);
        alterAlgorithmOption();
        setState(1737);
        _errHandler->sync(this);

        _la = _input->LA(1);
        if (_la == MySQLParser::LOCK_SYMBOL) {
          setState(1736);
          alterLockOption();
        }
        break;
      }

      case MySQLParser::LOCK_SYMBOL: {
        enterOuterAlt(_localctx, 2);
        setState(1739);
        alterLockOption();
        setState(1741);
        _errHandler->sync(this);

        _la = _input->LA(1);
        if (_la == MySQLParser::ALGORITHM_SYMBOL) {
          setState(1740);
          alterAlgorithmOption();
        }
        break;
      }

    default:
      throw NoViableAltException(this);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- WithValidationContext ------------------------------------------------------------------

MySQLParser::WithValidationContext::WithValidationContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::WithValidationContext::VALIDATION_SYMBOL() {
  return getToken(MySQLParser::VALIDATION_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::WithValidationContext::WITH_SYMBOL() {
  return getToken(MySQLParser::WITH_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::WithValidationContext::WITHOUT_SYMBOL() {
  return getToken(MySQLParser::WITHOUT_SYMBOL, 0);
}


size_t MySQLParser::WithValidationContext::getRuleIndex() const {
  return MySQLParser::RuleWithValidation;
}

void MySQLParser::WithValidationContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterWithValidation(this);
}

void MySQLParser::WithValidationContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitWithValidation(this);
}


std::any MySQLParser::WithValidationContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitWithValidation(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::WithValidationContext* MySQLParser::withValidation() {
  WithValidationContext *_localctx = _tracker.createInstance<WithValidationContext>(_ctx, getState());
  enterRule(_localctx, 48, MySQLParser::RuleWithValidation);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(1745);

    if (!(serverVersion >= 50706)) throw FailedPredicateException(this, "serverVersion >= 50706");
    setState(1746);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::WITH_SYMBOL

    || _la == MySQLParser::WITHOUT_SYMBOL)) {
    _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
    setState(1747);
    match(MySQLParser::VALIDATION_SYMBOL);
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- RemovePartitioningContext ------------------------------------------------------------------

MySQLParser::RemovePartitioningContext::RemovePartitioningContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::RemovePartitioningContext::REMOVE_SYMBOL() {
  return getToken(MySQLParser::REMOVE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::RemovePartitioningContext::PARTITIONING_SYMBOL() {
  return getToken(MySQLParser::PARTITIONING_SYMBOL, 0);
}


size_t MySQLParser::RemovePartitioningContext::getRuleIndex() const {
  return MySQLParser::RuleRemovePartitioning;
}

void MySQLParser::RemovePartitioningContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterRemovePartitioning(this);
}

void MySQLParser::RemovePartitioningContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitRemovePartitioning(this);
}


std::any MySQLParser::RemovePartitioningContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitRemovePartitioning(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::RemovePartitioningContext* MySQLParser::removePartitioning() {
  RemovePartitioningContext *_localctx = _tracker.createInstance<RemovePartitioningContext>(_ctx, getState());
  enterRule(_localctx, 50, MySQLParser::RuleRemovePartitioning);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(1749);
    match(MySQLParser::REMOVE_SYMBOL);
    setState(1750);
    match(MySQLParser::PARTITIONING_SYMBOL);
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AllOrPartitionNameListContext ------------------------------------------------------------------

MySQLParser::AllOrPartitionNameListContext::AllOrPartitionNameListContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::AllOrPartitionNameListContext::ALL_SYMBOL() {
  return getToken(MySQLParser::ALL_SYMBOL, 0);
}

MySQLParser::IdentifierListContext* MySQLParser::AllOrPartitionNameListContext::identifierList() {
  return getRuleContext<MySQLParser::IdentifierListContext>(0);
}


size_t MySQLParser::AllOrPartitionNameListContext::getRuleIndex() const {
  return MySQLParser::RuleAllOrPartitionNameList;
}

void MySQLParser::AllOrPartitionNameListContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAllOrPartitionNameList(this);
}

void MySQLParser::AllOrPartitionNameListContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAllOrPartitionNameList(this);
}


std::any MySQLParser::AllOrPartitionNameListContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAllOrPartitionNameList(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AllOrPartitionNameListContext* MySQLParser::allOrPartitionNameList() {
  AllOrPartitionNameListContext *_localctx = _tracker.createInstance<AllOrPartitionNameListContext>(_ctx, getState());
  enterRule(_localctx, 52, MySQLParser::RuleAllOrPartitionNameList);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(1754);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 82, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(1752);
      match(MySQLParser::ALL_SYMBOL);
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(1753);
      identifierList();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterTablespaceContext ------------------------------------------------------------------

MySQLParser::AlterTablespaceContext::AlterTablespaceContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::AlterTablespaceContext::TABLESPACE_SYMBOL() {
  return getToken(MySQLParser::TABLESPACE_SYMBOL, 0);
}

MySQLParser::TablespaceRefContext* MySQLParser::AlterTablespaceContext::tablespaceRef() {
  return getRuleContext<MySQLParser::TablespaceRefContext>(0);
}

tree::TerminalNode* MySQLParser::AlterTablespaceContext::DATAFILE_SYMBOL() {
  return getToken(MySQLParser::DATAFILE_SYMBOL, 0);
}

MySQLParser::TextLiteralContext* MySQLParser::AlterTablespaceContext::textLiteral() {
  return getRuleContext<MySQLParser::TextLiteralContext>(0);
}

tree::TerminalNode* MySQLParser::AlterTablespaceContext::RENAME_SYMBOL() {
  return getToken(MySQLParser::RENAME_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterTablespaceContext::TO_SYMBOL() {
  return getToken(MySQLParser::TO_SYMBOL, 0);
}

MySQLParser::IdentifierContext* MySQLParser::AlterTablespaceContext::identifier() {
  return getRuleContext<MySQLParser::IdentifierContext>(0);
}

MySQLParser::AlterTablespaceOptionsContext* MySQLParser::AlterTablespaceContext::alterTablespaceOptions() {
  return getRuleContext<MySQLParser::AlterTablespaceOptionsContext>(0);
}

tree::TerminalNode* MySQLParser::AlterTablespaceContext::ADD_SYMBOL() {
  return getToken(MySQLParser::ADD_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterTablespaceContext::DROP_SYMBOL() {
  return getToken(MySQLParser::DROP_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterTablespaceContext::CHANGE_SYMBOL() {
  return getToken(MySQLParser::CHANGE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterTablespaceContext::NOT_SYMBOL() {
  return getToken(MySQLParser::NOT_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterTablespaceContext::ACCESSIBLE_SYMBOL() {
  return getToken(MySQLParser::ACCESSIBLE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterTablespaceContext::READ_ONLY_SYMBOL() {
  return getToken(MySQLParser::READ_ONLY_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterTablespaceContext::READ_WRITE_SYMBOL() {
  return getToken(MySQLParser::READ_WRITE_SYMBOL, 0);
}

std::vector<MySQLParser::ChangeTablespaceOptionContext *> MySQLParser::AlterTablespaceContext::changeTablespaceOption() {
  return getRuleContexts<MySQLParser::ChangeTablespaceOptionContext>();
}

MySQLParser::ChangeTablespaceOptionContext* MySQLParser::AlterTablespaceContext::changeTablespaceOption(size_t i) {
  return getRuleContext<MySQLParser::ChangeTablespaceOptionContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::AlterTablespaceContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::AlterTablespaceContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::AlterTablespaceContext::getRuleIndex() const {
  return MySQLParser::RuleAlterTablespace;
}

void MySQLParser::AlterTablespaceContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterTablespace(this);
}

void MySQLParser::AlterTablespaceContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterTablespace(this);
}


std::any MySQLParser::AlterTablespaceContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterTablespace(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterTablespaceContext* MySQLParser::alterTablespace() {
  AlterTablespaceContext *_localctx = _tracker.createInstance<AlterTablespaceContext>(_ctx, getState());
  enterRule(_localctx, 54, MySQLParser::RuleAlterTablespace);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(1756);
    match(MySQLParser::TABLESPACE_SYMBOL);
    setState(1757);
    tablespaceRef();
    setState(1791);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 88, _ctx)) {
    case 1: {
      setState(1758);
      _la = _input->LA(1);
      if (!(_la == MySQLParser::ADD_SYMBOL || _la == MySQLParser::DROP_SYMBOL)) {
      _errHandler->recoverInline(this);
      }
      else {
        _errHandler->reportMatch(this);
        consume();
      }
      setState(1759);
      match(MySQLParser::DATAFILE_SYMBOL);
      setState(1760);
      textLiteral();
      setState(1762);
      _errHandler->sync(this);

      _la = _input->LA(1);
      if (_la == MySQLParser::AUTOEXTEND_SIZE_SYMBOL || _la == MySQLParser::ENCRYPTION_SYMBOL

      || _la == MySQLParser::ENGINE_SYMBOL || _la == MySQLParser::INITIAL_SIZE_SYMBOL || _la == MySQLParser::MAX_SIZE_SYMBOL

      || _la == MySQLParser::NO_WAIT_SYMBOL || _la == MySQLParser::STORAGE_SYMBOL || _la == MySQLParser::WAIT_SYMBOL) {
        setState(1761);
        alterTablespaceOptions();
      }
      break;
    }

    case 2: {
      setState(1764);

      if (!(serverVersion < 80000)) throw FailedPredicateException(this, "serverVersion < 80000");
      setState(1784);
      _errHandler->sync(this);
      switch (_input->LA(1)) {
        case MySQLParser::EOF:
        case MySQLParser::SEMICOLON_SYMBOL: {
          break;
        }

        case MySQLParser::CHANGE_SYMBOL: {
          setState(1766);
          match(MySQLParser::CHANGE_SYMBOL);
          setState(1767);
          match(MySQLParser::DATAFILE_SYMBOL);
          setState(1768);
          textLiteral();
          setState(1779);
          _errHandler->sync(this);

          _la = _input->LA(1);
          if (_la == MySQLParser::AUTOEXTEND_SIZE_SYMBOL || _la == MySQLParser::INITIAL_SIZE_SYMBOL || _la == MySQLParser::MAX_SIZE_SYMBOL) {
            setState(1769);
            changeTablespaceOption();
            setState(1776);
            _errHandler->sync(this);
            _la = _input->LA(1);
            while (_la == MySQLParser::AUTOEXTEND_SIZE_SYMBOL || _la == MySQLParser::INITIAL_SIZE_SYMBOL || _la == MySQLParser::MAX_SIZE_SYMBOL || _la == MySQLParser::COMMA_SYMBOL) {
              setState(1771);
              _errHandler->sync(this);

              _la = _input->LA(1);
              if (_la == MySQLParser::COMMA_SYMBOL) {
                setState(1770);
                match(MySQLParser::COMMA_SYMBOL);
              }
              setState(1773);
              changeTablespaceOption();
              setState(1778);
              _errHandler->sync(this);
              _la = _input->LA(1);
            }
          }
          break;
        }

        case MySQLParser::READ_ONLY_SYMBOL:
        case MySQLParser::READ_WRITE_SYMBOL: {
          setState(1781);
          _la = _input->LA(1);
          if (!(_la == MySQLParser::READ_ONLY_SYMBOL

          || _la == MySQLParser::READ_WRITE_SYMBOL)) {
          _errHandler->recoverInline(this);
          }
          else {
            _errHandler->reportMatch(this);
            consume();
          }
          break;
        }

        case MySQLParser::NOT_SYMBOL: {
          setState(1782);
          match(MySQLParser::NOT_SYMBOL);
          setState(1783);
          match(MySQLParser::ACCESSIBLE_SYMBOL);
          break;
        }

      default:
        throw NoViableAltException(this);
      }
      break;
    }

    case 3: {
      setState(1786);
      match(MySQLParser::RENAME_SYMBOL);
      setState(1787);
      match(MySQLParser::TO_SYMBOL);
      setState(1788);
      identifier();
      break;
    }

    case 4: {
      setState(1789);

      if (!(serverVersion >= 80014)) throw FailedPredicateException(this, "serverVersion >= 80014");
      setState(1790);
      alterTablespaceOptions();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterUndoTablespaceContext ------------------------------------------------------------------

MySQLParser::AlterUndoTablespaceContext::AlterUndoTablespaceContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::AlterUndoTablespaceContext::UNDO_SYMBOL() {
  return getToken(MySQLParser::UNDO_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterUndoTablespaceContext::TABLESPACE_SYMBOL() {
  return getToken(MySQLParser::TABLESPACE_SYMBOL, 0);
}

MySQLParser::TablespaceRefContext* MySQLParser::AlterUndoTablespaceContext::tablespaceRef() {
  return getRuleContext<MySQLParser::TablespaceRefContext>(0);
}

tree::TerminalNode* MySQLParser::AlterUndoTablespaceContext::SET_SYMBOL() {
  return getToken(MySQLParser::SET_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterUndoTablespaceContext::ACTIVE_SYMBOL() {
  return getToken(MySQLParser::ACTIVE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::AlterUndoTablespaceContext::INACTIVE_SYMBOL() {
  return getToken(MySQLParser::INACTIVE_SYMBOL, 0);
}

MySQLParser::UndoTableSpaceOptionsContext* MySQLParser::AlterUndoTablespaceContext::undoTableSpaceOptions() {
  return getRuleContext<MySQLParser::UndoTableSpaceOptionsContext>(0);
}


size_t MySQLParser::AlterUndoTablespaceContext::getRuleIndex() const {
  return MySQLParser::RuleAlterUndoTablespace;
}

void MySQLParser::AlterUndoTablespaceContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterUndoTablespace(this);
}

void MySQLParser::AlterUndoTablespaceContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterUndoTablespace(this);
}


std::any MySQLParser::AlterUndoTablespaceContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterUndoTablespace(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterUndoTablespaceContext* MySQLParser::alterUndoTablespace() {
  AlterUndoTablespaceContext *_localctx = _tracker.createInstance<AlterUndoTablespaceContext>(_ctx, getState());
  enterRule(_localctx, 56, MySQLParser::RuleAlterUndoTablespace);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(1793);
    match(MySQLParser::UNDO_SYMBOL);
    setState(1794);
    match(MySQLParser::TABLESPACE_SYMBOL);
    setState(1795);
    tablespaceRef();
    setState(1796);
    match(MySQLParser::SET_SYMBOL);
    setState(1797);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::ACTIVE_SYMBOL

    || _la == MySQLParser::INACTIVE_SYMBOL)) {
    _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
    setState(1799);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::ENGINE_SYMBOL || _la == MySQLParser::STORAGE_SYMBOL) {
      setState(1798);
      undoTableSpaceOptions();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- UndoTableSpaceOptionsContext ------------------------------------------------------------------

MySQLParser::UndoTableSpaceOptionsContext::UndoTableSpaceOptionsContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

std::vector<MySQLParser::UndoTableSpaceOptionContext *> MySQLParser::UndoTableSpaceOptionsContext::undoTableSpaceOption() {
  return getRuleContexts<MySQLParser::UndoTableSpaceOptionContext>();
}

MySQLParser::UndoTableSpaceOptionContext* MySQLParser::UndoTableSpaceOptionsContext::undoTableSpaceOption(size_t i) {
  return getRuleContext<MySQLParser::UndoTableSpaceOptionContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::UndoTableSpaceOptionsContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::UndoTableSpaceOptionsContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::UndoTableSpaceOptionsContext::getRuleIndex() const {
  return MySQLParser::RuleUndoTableSpaceOptions;
}

void MySQLParser::UndoTableSpaceOptionsContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterUndoTableSpaceOptions(this);
}

void MySQLParser::UndoTableSpaceOptionsContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitUndoTableSpaceOptions(this);
}


std::any MySQLParser::UndoTableSpaceOptionsContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitUndoTableSpaceOptions(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::UndoTableSpaceOptionsContext* MySQLParser::undoTableSpaceOptions() {
  UndoTableSpaceOptionsContext *_localctx = _tracker.createInstance<UndoTableSpaceOptionsContext>(_ctx, getState());
  enterRule(_localctx, 58, MySQLParser::RuleUndoTableSpaceOptions);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(1801);
    undoTableSpaceOption();
    setState(1808);
    _errHandler->sync(this);
    _la = _input->LA(1);
    while (_la == MySQLParser::ENGINE_SYMBOL || _la == MySQLParser::STORAGE_SYMBOL || _la == MySQLParser::COMMA_SYMBOL) {
      setState(1803);
      _errHandler->sync(this);

      _la = _input->LA(1);
      if (_la == MySQLParser::COMMA_SYMBOL) {
        setState(1802);
        match(MySQLParser::COMMA_SYMBOL);
      }
      setState(1805);
      undoTableSpaceOption();
      setState(1810);
      _errHandler->sync(this);
      _la = _input->LA(1);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- UndoTableSpaceOptionContext ------------------------------------------------------------------

MySQLParser::UndoTableSpaceOptionContext::UndoTableSpaceOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::TsOptionEngineContext* MySQLParser::UndoTableSpaceOptionContext::tsOptionEngine() {
  return getRuleContext<MySQLParser::TsOptionEngineContext>(0);
}


size_t MySQLParser::UndoTableSpaceOptionContext::getRuleIndex() const {
  return MySQLParser::RuleUndoTableSpaceOption;
}

void MySQLParser::UndoTableSpaceOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterUndoTableSpaceOption(this);
}

void MySQLParser::UndoTableSpaceOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitUndoTableSpaceOption(this);
}


std::any MySQLParser::UndoTableSpaceOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitUndoTableSpaceOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::UndoTableSpaceOptionContext* MySQLParser::undoTableSpaceOption() {
  UndoTableSpaceOptionContext *_localctx = _tracker.createInstance<UndoTableSpaceOptionContext>(_ctx, getState());
  enterRule(_localctx, 60, MySQLParser::RuleUndoTableSpaceOption);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(1811);
    tsOptionEngine();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterTablespaceOptionsContext ------------------------------------------------------------------

MySQLParser::AlterTablespaceOptionsContext::AlterTablespaceOptionsContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

std::vector<MySQLParser::AlterTablespaceOptionContext *> MySQLParser::AlterTablespaceOptionsContext::alterTablespaceOption() {
  return getRuleContexts<MySQLParser::AlterTablespaceOptionContext>();
}

MySQLParser::AlterTablespaceOptionContext* MySQLParser::AlterTablespaceOptionsContext::alterTablespaceOption(size_t i) {
  return getRuleContext<MySQLParser::AlterTablespaceOptionContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::AlterTablespaceOptionsContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::AlterTablespaceOptionsContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::AlterTablespaceOptionsContext::getRuleIndex() const {
  return MySQLParser::RuleAlterTablespaceOptions;
}

void MySQLParser::AlterTablespaceOptionsContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterTablespaceOptions(this);
}

void MySQLParser::AlterTablespaceOptionsContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterTablespaceOptions(this);
}


std::any MySQLParser::AlterTablespaceOptionsContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterTablespaceOptions(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterTablespaceOptionsContext* MySQLParser::alterTablespaceOptions() {
  AlterTablespaceOptionsContext *_localctx = _tracker.createInstance<AlterTablespaceOptionsContext>(_ctx, getState());
  enterRule(_localctx, 62, MySQLParser::RuleAlterTablespaceOptions);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(1813);
    alterTablespaceOption();
    setState(1820);
    _errHandler->sync(this);
    _la = _input->LA(1);
    while (_la == MySQLParser::AUTOEXTEND_SIZE_SYMBOL || _la == MySQLParser::ENCRYPTION_SYMBOL

    || _la == MySQLParser::ENGINE_SYMBOL || _la == MySQLParser::INITIAL_SIZE_SYMBOL || _la == MySQLParser::MAX_SIZE_SYMBOL

    || _la == MySQLParser::NO_WAIT_SYMBOL || _la == MySQLParser::STORAGE_SYMBOL || _la == MySQLParser::WAIT_SYMBOL || _la == MySQLParser::COMMA_SYMBOL) {
      setState(1815);
      _errHandler->sync(this);

      _la = _input->LA(1);
      if (_la == MySQLParser::COMMA_SYMBOL) {
        setState(1814);
        match(MySQLParser::COMMA_SYMBOL);
      }
      setState(1817);
      alterTablespaceOption();
      setState(1822);
      _errHandler->sync(this);
      _la = _input->LA(1);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterTablespaceOptionContext ------------------------------------------------------------------

MySQLParser::AlterTablespaceOptionContext::AlterTablespaceOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::AlterTablespaceOptionContext::INITIAL_SIZE_SYMBOL() {
  return getToken(MySQLParser::INITIAL_SIZE_SYMBOL, 0);
}

MySQLParser::SizeNumberContext* MySQLParser::AlterTablespaceOptionContext::sizeNumber() {
  return getRuleContext<MySQLParser::SizeNumberContext>(0);
}

tree::TerminalNode* MySQLParser::AlterTablespaceOptionContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}

MySQLParser::TsOptionAutoextendSizeContext* MySQLParser::AlterTablespaceOptionContext::tsOptionAutoextendSize() {
  return getRuleContext<MySQLParser::TsOptionAutoextendSizeContext>(0);
}

MySQLParser::TsOptionMaxSizeContext* MySQLParser::AlterTablespaceOptionContext::tsOptionMaxSize() {
  return getRuleContext<MySQLParser::TsOptionMaxSizeContext>(0);
}

MySQLParser::TsOptionEngineContext* MySQLParser::AlterTablespaceOptionContext::tsOptionEngine() {
  return getRuleContext<MySQLParser::TsOptionEngineContext>(0);
}

MySQLParser::TsOptionWaitContext* MySQLParser::AlterTablespaceOptionContext::tsOptionWait() {
  return getRuleContext<MySQLParser::TsOptionWaitContext>(0);
}

MySQLParser::TsOptionEncryptionContext* MySQLParser::AlterTablespaceOptionContext::tsOptionEncryption() {
  return getRuleContext<MySQLParser::TsOptionEncryptionContext>(0);
}


size_t MySQLParser::AlterTablespaceOptionContext::getRuleIndex() const {
  return MySQLParser::RuleAlterTablespaceOption;
}

void MySQLParser::AlterTablespaceOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterTablespaceOption(this);
}

void MySQLParser::AlterTablespaceOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterTablespaceOption(this);
}


std::any MySQLParser::AlterTablespaceOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterTablespaceOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterTablespaceOptionContext* MySQLParser::alterTablespaceOption() {
  AlterTablespaceOptionContext *_localctx = _tracker.createInstance<AlterTablespaceOptionContext>(_ctx, getState());
  enterRule(_localctx, 64, MySQLParser::RuleAlterTablespaceOption);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(1833);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::INITIAL_SIZE_SYMBOL: {
        enterOuterAlt(_localctx, 1);
        setState(1823);
        match(MySQLParser::INITIAL_SIZE_SYMBOL);
        setState(1825);
        _errHandler->sync(this);

        switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 94, _ctx)) {
        case 1: {
          setState(1824);
          match(MySQLParser::EQUAL_OPERATOR);
          break;
        }

        default:
          break;
        }
        setState(1827);
        sizeNumber();
        break;
      }

      case MySQLParser::AUTOEXTEND_SIZE_SYMBOL: {
        enterOuterAlt(_localctx, 2);
        setState(1828);
        tsOptionAutoextendSize();
        break;
      }

      case MySQLParser::MAX_SIZE_SYMBOL: {
        enterOuterAlt(_localctx, 3);
        setState(1829);
        tsOptionMaxSize();
        break;
      }

      case MySQLParser::ENGINE_SYMBOL:
      case MySQLParser::STORAGE_SYMBOL: {
        enterOuterAlt(_localctx, 4);
        setState(1830);
        tsOptionEngine();
        break;
      }

      case MySQLParser::NO_WAIT_SYMBOL:
      case MySQLParser::WAIT_SYMBOL: {
        enterOuterAlt(_localctx, 5);
        setState(1831);
        tsOptionWait();
        break;
      }

      case MySQLParser::ENCRYPTION_SYMBOL: {
        enterOuterAlt(_localctx, 6);
        setState(1832);
        tsOptionEncryption();
        break;
      }

    default:
      throw NoViableAltException(this);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- ChangeTablespaceOptionContext ------------------------------------------------------------------

MySQLParser::ChangeTablespaceOptionContext::ChangeTablespaceOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::ChangeTablespaceOptionContext::INITIAL_SIZE_SYMBOL() {
  return getToken(MySQLParser::INITIAL_SIZE_SYMBOL, 0);
}

MySQLParser::SizeNumberContext* MySQLParser::ChangeTablespaceOptionContext::sizeNumber() {
  return getRuleContext<MySQLParser::SizeNumberContext>(0);
}

tree::TerminalNode* MySQLParser::ChangeTablespaceOptionContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}

MySQLParser::TsOptionAutoextendSizeContext* MySQLParser::ChangeTablespaceOptionContext::tsOptionAutoextendSize() {
  return getRuleContext<MySQLParser::TsOptionAutoextendSizeContext>(0);
}

MySQLParser::TsOptionMaxSizeContext* MySQLParser::ChangeTablespaceOptionContext::tsOptionMaxSize() {
  return getRuleContext<MySQLParser::TsOptionMaxSizeContext>(0);
}


size_t MySQLParser::ChangeTablespaceOptionContext::getRuleIndex() const {
  return MySQLParser::RuleChangeTablespaceOption;
}

void MySQLParser::ChangeTablespaceOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterChangeTablespaceOption(this);
}

void MySQLParser::ChangeTablespaceOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitChangeTablespaceOption(this);
}


std::any MySQLParser::ChangeTablespaceOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitChangeTablespaceOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::ChangeTablespaceOptionContext* MySQLParser::changeTablespaceOption() {
  ChangeTablespaceOptionContext *_localctx = _tracker.createInstance<ChangeTablespaceOptionContext>(_ctx, getState());
  enterRule(_localctx, 66, MySQLParser::RuleChangeTablespaceOption);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(1842);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::INITIAL_SIZE_SYMBOL: {
        enterOuterAlt(_localctx, 1);
        setState(1835);
        match(MySQLParser::INITIAL_SIZE_SYMBOL);
        setState(1837);
        _errHandler->sync(this);

        switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 96, _ctx)) {
        case 1: {
          setState(1836);
          match(MySQLParser::EQUAL_OPERATOR);
          break;
        }

        default:
          break;
        }
        setState(1839);
        sizeNumber();
        break;
      }

      case MySQLParser::AUTOEXTEND_SIZE_SYMBOL: {
        enterOuterAlt(_localctx, 2);
        setState(1840);
        tsOptionAutoextendSize();
        break;
      }

      case MySQLParser::MAX_SIZE_SYMBOL: {
        enterOuterAlt(_localctx, 3);
        setState(1841);
        tsOptionMaxSize();
        break;
      }

    default:
      throw NoViableAltException(this);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- AlterViewContext ------------------------------------------------------------------

MySQLParser::AlterViewContext::AlterViewContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::AlterViewContext::VIEW_SYMBOL() {
  return getToken(MySQLParser::VIEW_SYMBOL, 0);
}

MySQLParser::ViewRefContext* MySQLParser::AlterViewContext::viewRef() {
  return getRuleContext<MySQLParser::ViewRefContext>(0);
}

MySQLParser::ViewTailContext* MySQLParser::AlterViewContext::viewTail() {
  return getRuleContext<MySQLParser::ViewTailContext>(0);
}

MySQLParser::ViewAlgorithmContext* MySQLParser::AlterViewContext::viewAlgorithm() {
  return getRuleContext<MySQLParser::ViewAlgorithmContext>(0);
}

MySQLParser::DefinerClauseContext* MySQLParser::AlterViewContext::definerClause() {
  return getRuleContext<MySQLParser::DefinerClauseContext>(0);
}

MySQLParser::ViewSuidContext* MySQLParser::AlterViewContext::viewSuid() {
  return getRuleContext<MySQLParser::ViewSuidContext>(0);
}


size_t MySQLParser::AlterViewContext::getRuleIndex() const {
  return MySQLParser::RuleAlterView;
}

void MySQLParser::AlterViewContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterAlterView(this);
}

void MySQLParser::AlterViewContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitAlterView(this);
}


std::any MySQLParser::AlterViewContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitAlterView(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::AlterViewContext* MySQLParser::alterView() {
  AlterViewContext *_localctx = _tracker.createInstance<AlterViewContext>(_ctx, getState());
  enterRule(_localctx, 68, MySQLParser::RuleAlterView);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(1845);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::ALGORITHM_SYMBOL) {
      setState(1844);
      viewAlgorithm();
    }
    setState(1848);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::DEFINER_SYMBOL) {
      setState(1847);
      definerClause();
    }
    setState(1851);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::SQL_SYMBOL) {
      setState(1850);
      viewSuid();
    }
    setState(1853);
    match(MySQLParser::VIEW_SYMBOL);
    setState(1854);
    viewRef();
    setState(1855);
    viewTail();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- ViewTailContext ------------------------------------------------------------------

MySQLParser::ViewTailContext::ViewTailContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::ViewTailContext::AS_SYMBOL() {
  return getToken(MySQLParser::AS_SYMBOL, 0);
}

MySQLParser::ViewSelectContext* MySQLParser::ViewTailContext::viewSelect() {
  return getRuleContext<MySQLParser::ViewSelectContext>(0);
}

MySQLParser::ColumnInternalRefListContext* MySQLParser::ViewTailContext::columnInternalRefList() {
  return getRuleContext<MySQLParser::ColumnInternalRefListContext>(0);
}


size_t MySQLParser::ViewTailContext::getRuleIndex() const {
  return MySQLParser::RuleViewTail;
}

void MySQLParser::ViewTailContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterViewTail(this);
}

void MySQLParser::ViewTailContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitViewTail(this);
}


std::any MySQLParser::ViewTailContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitViewTail(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::ViewTailContext* MySQLParser::viewTail() {
  ViewTailContext *_localctx = _tracker.createInstance<ViewTailContext>(_ctx, getState());
  enterRule(_localctx, 70, MySQLParser::RuleViewTail);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(1858);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::OPEN_PAR_SYMBOL) {
      setState(1857);
      columnInternalRefList();
    }
    setState(1860);
    match(MySQLParser::AS_SYMBOL);
    setState(1861);
    viewSelect();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- ViewSelectContext ------------------------------------------------------------------

MySQLParser::ViewSelectContext::ViewSelectContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::QueryExpressionOrParensContext* MySQLParser::ViewSelectContext::queryExpressionOrParens() {
  return getRuleContext<MySQLParser::QueryExpressionOrParensContext>(0);
}

MySQLParser::ViewCheckOptionContext* MySQLParser::ViewSelectContext::viewCheckOption() {
  return getRuleContext<MySQLParser::ViewCheckOptionContext>(0);
}


size_t MySQLParser::ViewSelectContext::getRuleIndex() const {
  return MySQLParser::RuleViewSelect;
}

void MySQLParser::ViewSelectContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterViewSelect(this);
}

void MySQLParser::ViewSelectContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitViewSelect(this);
}


std::any MySQLParser::ViewSelectContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitViewSelect(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::ViewSelectContext* MySQLParser::viewSelect() {
  ViewSelectContext *_localctx = _tracker.createInstance<ViewSelectContext>(_ctx, getState());
  enterRule(_localctx, 72, MySQLParser::RuleViewSelect);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(1863);
    queryExpressionOrParens();
    setState(1865);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::WITH_SYMBOL) {
      setState(1864);
      viewCheckOption();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- ViewCheckOptionContext ------------------------------------------------------------------

MySQLParser::ViewCheckOptionContext::ViewCheckOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::ViewCheckOptionContext::WITH_SYMBOL() {
  return getToken(MySQLParser::WITH_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ViewCheckOptionContext::CHECK_SYMBOL() {
  return getToken(MySQLParser::CHECK_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ViewCheckOptionContext::OPTION_SYMBOL() {
  return getToken(MySQLParser::OPTION_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ViewCheckOptionContext::CASCADED_SYMBOL() {
  return getToken(MySQLParser::CASCADED_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ViewCheckOptionContext::LOCAL_SYMBOL() {
  return getToken(MySQLParser::LOCAL_SYMBOL, 0);
}


size_t MySQLParser::ViewCheckOptionContext::getRuleIndex() const {
  return MySQLParser::RuleViewCheckOption;
}

void MySQLParser::ViewCheckOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterViewCheckOption(this);
}

void MySQLParser::ViewCheckOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitViewCheckOption(this);
}


std::any MySQLParser::ViewCheckOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitViewCheckOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::ViewCheckOptionContext* MySQLParser::viewCheckOption() {
  ViewCheckOptionContext *_localctx = _tracker.createInstance<ViewCheckOptionContext>(_ctx, getState());
  enterRule(_localctx, 74, MySQLParser::RuleViewCheckOption);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(1867);
    match(MySQLParser::WITH_SYMBOL);
    setState(1869);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::CASCADED_SYMBOL || _la == MySQLParser::LOCAL_SYMBOL) {
      setState(1868);
      _la = _input->LA(1);
      if (!(_la == MySQLParser::CASCADED_SYMBOL || _la == MySQLParser::LOCAL_SYMBOL)) {
      _errHandler->recoverInline(this);
      }
      else {
        _errHandler->reportMatch(this);
        consume();
      }
    }
    setState(1871);
    match(MySQLParser::CHECK_SYMBOL);
    setState(1872);
    match(MySQLParser::OPTION_SYMBOL);
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CreateStatementContext ------------------------------------------------------------------

MySQLParser::CreateStatementContext::CreateStatementContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::CreateStatementContext::CREATE_SYMBOL() {
  return getToken(MySQLParser::CREATE_SYMBOL, 0);
}

MySQLParser::CreateDatabaseContext* MySQLParser::CreateStatementContext::createDatabase() {
  return getRuleContext<MySQLParser::CreateDatabaseContext>(0);
}

MySQLParser::CreateTableContext* MySQLParser::CreateStatementContext::createTable() {
  return getRuleContext<MySQLParser::CreateTableContext>(0);
}

MySQLParser::CreateFunctionContext* MySQLParser::CreateStatementContext::createFunction() {
  return getRuleContext<MySQLParser::CreateFunctionContext>(0);
}

MySQLParser::CreateProcedureContext* MySQLParser::CreateStatementContext::createProcedure() {
  return getRuleContext<MySQLParser::CreateProcedureContext>(0);
}

MySQLParser::CreateUdfContext* MySQLParser::CreateStatementContext::createUdf() {
  return getRuleContext<MySQLParser::CreateUdfContext>(0);
}

MySQLParser::CreateLogfileGroupContext* MySQLParser::CreateStatementContext::createLogfileGroup() {
  return getRuleContext<MySQLParser::CreateLogfileGroupContext>(0);
}

MySQLParser::CreateViewContext* MySQLParser::CreateStatementContext::createView() {
  return getRuleContext<MySQLParser::CreateViewContext>(0);
}

MySQLParser::CreateTriggerContext* MySQLParser::CreateStatementContext::createTrigger() {
  return getRuleContext<MySQLParser::CreateTriggerContext>(0);
}

MySQLParser::CreateIndexContext* MySQLParser::CreateStatementContext::createIndex() {
  return getRuleContext<MySQLParser::CreateIndexContext>(0);
}

MySQLParser::CreateServerContext* MySQLParser::CreateStatementContext::createServer() {
  return getRuleContext<MySQLParser::CreateServerContext>(0);
}

MySQLParser::CreateTablespaceContext* MySQLParser::CreateStatementContext::createTablespace() {
  return getRuleContext<MySQLParser::CreateTablespaceContext>(0);
}

MySQLParser::CreateEventContext* MySQLParser::CreateStatementContext::createEvent() {
  return getRuleContext<MySQLParser::CreateEventContext>(0);
}

MySQLParser::CreateRoleContext* MySQLParser::CreateStatementContext::createRole() {
  return getRuleContext<MySQLParser::CreateRoleContext>(0);
}

MySQLParser::CreateSpatialReferenceContext* MySQLParser::CreateStatementContext::createSpatialReference() {
  return getRuleContext<MySQLParser::CreateSpatialReferenceContext>(0);
}

MySQLParser::CreateUndoTablespaceContext* MySQLParser::CreateStatementContext::createUndoTablespace() {
  return getRuleContext<MySQLParser::CreateUndoTablespaceContext>(0);
}


size_t MySQLParser::CreateStatementContext::getRuleIndex() const {
  return MySQLParser::RuleCreateStatement;
}

void MySQLParser::CreateStatementContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCreateStatement(this);
}

void MySQLParser::CreateStatementContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCreateStatement(this);
}


std::any MySQLParser::CreateStatementContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCreateStatement(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CreateStatementContext* MySQLParser::createStatement() {
  CreateStatementContext *_localctx = _tracker.createInstance<CreateStatementContext>(_ctx, getState());
  enterRule(_localctx, 76, MySQLParser::RuleCreateStatement);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(1874);
    match(MySQLParser::CREATE_SYMBOL);
    setState(1893);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 104, _ctx)) {
    case 1: {
      setState(1875);
      createDatabase();
      break;
    }

    case 2: {
      setState(1876);
      createTable();
      break;
    }

    case 3: {
      setState(1877);
      createFunction();
      break;
    }

    case 4: {
      setState(1878);
      createProcedure();
      break;
    }

    case 5: {
      setState(1879);
      createUdf();
      break;
    }

    case 6: {
      setState(1880);
      createLogfileGroup();
      break;
    }

    case 7: {
      setState(1881);
      createView();
      break;
    }

    case 8: {
      setState(1882);
      createTrigger();
      break;
    }

    case 9: {
      setState(1883);
      createIndex();
      break;
    }

    case 10: {
      setState(1884);
      createServer();
      break;
    }

    case 11: {
      setState(1885);
      createTablespace();
      break;
    }

    case 12: {
      setState(1886);
      createEvent();
      break;
    }

    case 13: {
      setState(1887);

      if (!(serverVersion >= 80000)) throw FailedPredicateException(this, "serverVersion >= 80000");
      setState(1888);
      createRole();
      break;
    }

    case 14: {
      setState(1889);

      if (!(serverVersion >= 80011)) throw FailedPredicateException(this, "serverVersion >= 80011");
      setState(1890);
      createSpatialReference();
      break;
    }

    case 15: {
      setState(1891);

      if (!(serverVersion >= 80014)) throw FailedPredicateException(this, "serverVersion >= 80014");
      setState(1892);
      createUndoTablespace();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CreateDatabaseContext ------------------------------------------------------------------

MySQLParser::CreateDatabaseContext::CreateDatabaseContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::CreateDatabaseContext::DATABASE_SYMBOL() {
  return getToken(MySQLParser::DATABASE_SYMBOL, 0);
}

MySQLParser::SchemaNameContext* MySQLParser::CreateDatabaseContext::schemaName() {
  return getRuleContext<MySQLParser::SchemaNameContext>(0);
}

MySQLParser::IfNotExistsContext* MySQLParser::CreateDatabaseContext::ifNotExists() {
  return getRuleContext<MySQLParser::IfNotExistsContext>(0);
}

std::vector<MySQLParser::CreateDatabaseOptionContext *> MySQLParser::CreateDatabaseContext::createDatabaseOption() {
  return getRuleContexts<MySQLParser::CreateDatabaseOptionContext>();
}

MySQLParser::CreateDatabaseOptionContext* MySQLParser::CreateDatabaseContext::createDatabaseOption(size_t i) {
  return getRuleContext<MySQLParser::CreateDatabaseOptionContext>(i);
}


size_t MySQLParser::CreateDatabaseContext::getRuleIndex() const {
  return MySQLParser::RuleCreateDatabase;
}

void MySQLParser::CreateDatabaseContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCreateDatabase(this);
}

void MySQLParser::CreateDatabaseContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCreateDatabase(this);
}


std::any MySQLParser::CreateDatabaseContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCreateDatabase(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CreateDatabaseContext* MySQLParser::createDatabase() {
  CreateDatabaseContext *_localctx = _tracker.createInstance<CreateDatabaseContext>(_ctx, getState());
  enterRule(_localctx, 78, MySQLParser::RuleCreateDatabase);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    size_t alt;
    enterOuterAlt(_localctx, 1);
    setState(1895);
    match(MySQLParser::DATABASE_SYMBOL);
    setState(1897);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 105, _ctx)) {
    case 1: {
      setState(1896);
      ifNotExists();
      break;
    }

    default:
      break;
    }
    setState(1899);
    schemaName();
    setState(1903);
    _errHandler->sync(this);
    alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 106, _ctx);
    while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER) {
      if (alt == 1) {
        setState(1900);
        createDatabaseOption(); 
      }
      setState(1905);
      _errHandler->sync(this);
      alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 106, _ctx);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CreateDatabaseOptionContext ------------------------------------------------------------------

MySQLParser::CreateDatabaseOptionContext::CreateDatabaseOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::DefaultCharsetContext* MySQLParser::CreateDatabaseOptionContext::defaultCharset() {
  return getRuleContext<MySQLParser::DefaultCharsetContext>(0);
}

MySQLParser::DefaultCollationContext* MySQLParser::CreateDatabaseOptionContext::defaultCollation() {
  return getRuleContext<MySQLParser::DefaultCollationContext>(0);
}

MySQLParser::DefaultEncryptionContext* MySQLParser::CreateDatabaseOptionContext::defaultEncryption() {
  return getRuleContext<MySQLParser::DefaultEncryptionContext>(0);
}


size_t MySQLParser::CreateDatabaseOptionContext::getRuleIndex() const {
  return MySQLParser::RuleCreateDatabaseOption;
}

void MySQLParser::CreateDatabaseOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCreateDatabaseOption(this);
}

void MySQLParser::CreateDatabaseOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCreateDatabaseOption(this);
}


std::any MySQLParser::CreateDatabaseOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCreateDatabaseOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CreateDatabaseOptionContext* MySQLParser::createDatabaseOption() {
  CreateDatabaseOptionContext *_localctx = _tracker.createInstance<CreateDatabaseOptionContext>(_ctx, getState());
  enterRule(_localctx, 80, MySQLParser::RuleCreateDatabaseOption);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(1910);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 107, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(1906);
      defaultCharset();
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(1907);
      defaultCollation();
      break;
    }

    case 3: {
      enterOuterAlt(_localctx, 3);
      setState(1908);

      if (!(serverVersion >= 80016)) throw FailedPredicateException(this, "serverVersion >= 80016");
      setState(1909);
      defaultEncryption();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CreateTableContext ------------------------------------------------------------------

MySQLParser::CreateTableContext::CreateTableContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::CreateTableContext::TABLE_SYMBOL() {
  return getToken(MySQLParser::TABLE_SYMBOL, 0);
}

MySQLParser::TableNameContext* MySQLParser::CreateTableContext::tableName() {
  return getRuleContext<MySQLParser::TableNameContext>(0);
}

tree::TerminalNode* MySQLParser::CreateTableContext::LIKE_SYMBOL() {
  return getToken(MySQLParser::LIKE_SYMBOL, 0);
}

MySQLParser::TableRefContext* MySQLParser::CreateTableContext::tableRef() {
  return getRuleContext<MySQLParser::TableRefContext>(0);
}

tree::TerminalNode* MySQLParser::CreateTableContext::OPEN_PAR_SYMBOL() {
  return getToken(MySQLParser::OPEN_PAR_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateTableContext::CLOSE_PAR_SYMBOL() {
  return getToken(MySQLParser::CLOSE_PAR_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateTableContext::TEMPORARY_SYMBOL() {
  return getToken(MySQLParser::TEMPORARY_SYMBOL, 0);
}

MySQLParser::IfNotExistsContext* MySQLParser::CreateTableContext::ifNotExists() {
  return getRuleContext<MySQLParser::IfNotExistsContext>(0);
}

MySQLParser::TableElementListContext* MySQLParser::CreateTableContext::tableElementList() {
  return getRuleContext<MySQLParser::TableElementListContext>(0);
}

MySQLParser::CreateTableOptionsContext* MySQLParser::CreateTableContext::createTableOptions() {
  return getRuleContext<MySQLParser::CreateTableOptionsContext>(0);
}

MySQLParser::PartitionClauseContext* MySQLParser::CreateTableContext::partitionClause() {
  return getRuleContext<MySQLParser::PartitionClauseContext>(0);
}

MySQLParser::DuplicateAsQueryExpressionContext* MySQLParser::CreateTableContext::duplicateAsQueryExpression() {
  return getRuleContext<MySQLParser::DuplicateAsQueryExpressionContext>(0);
}


size_t MySQLParser::CreateTableContext::getRuleIndex() const {
  return MySQLParser::RuleCreateTable;
}

void MySQLParser::CreateTableContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCreateTable(this);
}

void MySQLParser::CreateTableContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCreateTable(this);
}


std::any MySQLParser::CreateTableContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCreateTable(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CreateTableContext* MySQLParser::createTable() {
  CreateTableContext *_localctx = _tracker.createInstance<CreateTableContext>(_ctx, getState());
  enterRule(_localctx, 82, MySQLParser::RuleCreateTable);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(1913);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::TEMPORARY_SYMBOL) {
      setState(1912);
      match(MySQLParser::TEMPORARY_SYMBOL);
    }
    setState(1915);
    match(MySQLParser::TABLE_SYMBOL);
    setState(1917);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 109, _ctx)) {
    case 1: {
      setState(1916);
      ifNotExists();
      break;
    }

    default:
      break;
    }
    setState(1919);
    tableName();
    setState(1942);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 114, _ctx)) {
    case 1: {
      setState(1924);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 110, _ctx)) {
      case 1: {
        setState(1920);
        match(MySQLParser::OPEN_PAR_SYMBOL);
        setState(1921);
        tableElementList();
        setState(1922);
        match(MySQLParser::CLOSE_PAR_SYMBOL);
        break;
      }

      default:
        break;
      }
      setState(1927);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 111, _ctx)) {
      case 1: {
        setState(1926);
        createTableOptions();
        break;
      }

      default:
        break;
      }
      setState(1930);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 112, _ctx)) {
      case 1: {
        setState(1929);
        partitionClause();
        break;
      }

      default:
        break;
      }
      setState(1933);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 113, _ctx)) {
      case 1: {
        setState(1932);
        duplicateAsQueryExpression();
        break;
      }

      default:
        break;
      }
      break;
    }

    case 2: {
      setState(1935);
      match(MySQLParser::LIKE_SYMBOL);
      setState(1936);
      tableRef();
      break;
    }

    case 3: {
      setState(1937);
      match(MySQLParser::OPEN_PAR_SYMBOL);
      setState(1938);
      match(MySQLParser::LIKE_SYMBOL);
      setState(1939);
      tableRef();
      setState(1940);
      match(MySQLParser::CLOSE_PAR_SYMBOL);
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TableElementListContext ------------------------------------------------------------------

MySQLParser::TableElementListContext::TableElementListContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

std::vector<MySQLParser::TableElementContext *> MySQLParser::TableElementListContext::tableElement() {
  return getRuleContexts<MySQLParser::TableElementContext>();
}

MySQLParser::TableElementContext* MySQLParser::TableElementListContext::tableElement(size_t i) {
  return getRuleContext<MySQLParser::TableElementContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::TableElementListContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::TableElementListContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::TableElementListContext::getRuleIndex() const {
  return MySQLParser::RuleTableElementList;
}

void MySQLParser::TableElementListContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTableElementList(this);
}

void MySQLParser::TableElementListContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTableElementList(this);
}


std::any MySQLParser::TableElementListContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTableElementList(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TableElementListContext* MySQLParser::tableElementList() {
  TableElementListContext *_localctx = _tracker.createInstance<TableElementListContext>(_ctx, getState());
  enterRule(_localctx, 84, MySQLParser::RuleTableElementList);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(1944);
    tableElement();
    setState(1949);
    _errHandler->sync(this);
    _la = _input->LA(1);
    while (_la == MySQLParser::COMMA_SYMBOL) {
      setState(1945);
      match(MySQLParser::COMMA_SYMBOL);
      setState(1946);
      tableElement();
      setState(1951);
      _errHandler->sync(this);
      _la = _input->LA(1);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TableElementContext ------------------------------------------------------------------

MySQLParser::TableElementContext::TableElementContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::ColumnDefinitionContext* MySQLParser::TableElementContext::columnDefinition() {
  return getRuleContext<MySQLParser::ColumnDefinitionContext>(0);
}

MySQLParser::TableConstraintDefContext* MySQLParser::TableElementContext::tableConstraintDef() {
  return getRuleContext<MySQLParser::TableConstraintDefContext>(0);
}


size_t MySQLParser::TableElementContext::getRuleIndex() const {
  return MySQLParser::RuleTableElement;
}

void MySQLParser::TableElementContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTableElement(this);
}

void MySQLParser::TableElementContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTableElement(this);
}


std::any MySQLParser::TableElementContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTableElement(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TableElementContext* MySQLParser::tableElement() {
  TableElementContext *_localctx = _tracker.createInstance<TableElementContext>(_ctx, getState());
  enterRule(_localctx, 86, MySQLParser::RuleTableElement);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(1954);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 116, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(1952);
      columnDefinition();
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(1953);
      tableConstraintDef();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DuplicateAsQueryExpressionContext ------------------------------------------------------------------

MySQLParser::DuplicateAsQueryExpressionContext::DuplicateAsQueryExpressionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::QueryExpressionOrParensContext* MySQLParser::DuplicateAsQueryExpressionContext::queryExpressionOrParens() {
  return getRuleContext<MySQLParser::QueryExpressionOrParensContext>(0);
}

tree::TerminalNode* MySQLParser::DuplicateAsQueryExpressionContext::AS_SYMBOL() {
  return getToken(MySQLParser::AS_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::DuplicateAsQueryExpressionContext::REPLACE_SYMBOL() {
  return getToken(MySQLParser::REPLACE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::DuplicateAsQueryExpressionContext::IGNORE_SYMBOL() {
  return getToken(MySQLParser::IGNORE_SYMBOL, 0);
}


size_t MySQLParser::DuplicateAsQueryExpressionContext::getRuleIndex() const {
  return MySQLParser::RuleDuplicateAsQueryExpression;
}

void MySQLParser::DuplicateAsQueryExpressionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDuplicateAsQueryExpression(this);
}

void MySQLParser::DuplicateAsQueryExpressionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDuplicateAsQueryExpression(this);
}


std::any MySQLParser::DuplicateAsQueryExpressionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDuplicateAsQueryExpression(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DuplicateAsQueryExpressionContext* MySQLParser::duplicateAsQueryExpression() {
  DuplicateAsQueryExpressionContext *_localctx = _tracker.createInstance<DuplicateAsQueryExpressionContext>(_ctx, getState());
  enterRule(_localctx, 88, MySQLParser::RuleDuplicateAsQueryExpression);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(1957);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 117, _ctx)) {
    case 1: {
      setState(1956);
      _la = _input->LA(1);
      if (!(_la == MySQLParser::IGNORE_SYMBOL || _la == MySQLParser::REPLACE_SYMBOL)) {
      _errHandler->recoverInline(this);
      }
      else {
        _errHandler->reportMatch(this);
        consume();
      }
      break;
    }

    default:
      break;
    }
    setState(1960);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 118, _ctx)) {
    case 1: {
      setState(1959);
      match(MySQLParser::AS_SYMBOL);
      break;
    }

    default:
      break;
    }
    setState(1962);
    queryExpressionOrParens();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- QueryExpressionOrParensContext ------------------------------------------------------------------

MySQLParser::QueryExpressionOrParensContext::QueryExpressionOrParensContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::QueryExpressionContext* MySQLParser::QueryExpressionOrParensContext::queryExpression() {
  return getRuleContext<MySQLParser::QueryExpressionContext>(0);
}

MySQLParser::QueryExpressionParensContext* MySQLParser::QueryExpressionOrParensContext::queryExpressionParens() {
  return getRuleContext<MySQLParser::QueryExpressionParensContext>(0);
}


size_t MySQLParser::QueryExpressionOrParensContext::getRuleIndex() const {
  return MySQLParser::RuleQueryExpressionOrParens;
}

void MySQLParser::QueryExpressionOrParensContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterQueryExpressionOrParens(this);
}

void MySQLParser::QueryExpressionOrParensContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitQueryExpressionOrParens(this);
}


std::any MySQLParser::QueryExpressionOrParensContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitQueryExpressionOrParens(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::QueryExpressionOrParensContext* MySQLParser::queryExpressionOrParens() {
  QueryExpressionOrParensContext *_localctx = _tracker.createInstance<QueryExpressionOrParensContext>(_ctx, getState());
  enterRule(_localctx, 90, MySQLParser::RuleQueryExpressionOrParens);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(1966);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 119, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(1964);
      queryExpression();
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(1965);
      queryExpressionParens();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CreateRoutineContext ------------------------------------------------------------------

MySQLParser::CreateRoutineContext::CreateRoutineContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::CreateRoutineContext::CREATE_SYMBOL() {
  return getToken(MySQLParser::CREATE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateRoutineContext::EOF() {
  return getToken(MySQLParser::EOF, 0);
}

MySQLParser::CreateProcedureContext* MySQLParser::CreateRoutineContext::createProcedure() {
  return getRuleContext<MySQLParser::CreateProcedureContext>(0);
}

MySQLParser::CreateFunctionContext* MySQLParser::CreateRoutineContext::createFunction() {
  return getRuleContext<MySQLParser::CreateFunctionContext>(0);
}

MySQLParser::CreateUdfContext* MySQLParser::CreateRoutineContext::createUdf() {
  return getRuleContext<MySQLParser::CreateUdfContext>(0);
}

tree::TerminalNode* MySQLParser::CreateRoutineContext::SEMICOLON_SYMBOL() {
  return getToken(MySQLParser::SEMICOLON_SYMBOL, 0);
}


size_t MySQLParser::CreateRoutineContext::getRuleIndex() const {
  return MySQLParser::RuleCreateRoutine;
}

void MySQLParser::CreateRoutineContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCreateRoutine(this);
}

void MySQLParser::CreateRoutineContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCreateRoutine(this);
}


std::any MySQLParser::CreateRoutineContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCreateRoutine(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CreateRoutineContext* MySQLParser::createRoutine() {
  CreateRoutineContext *_localctx = _tracker.createInstance<CreateRoutineContext>(_ctx, getState());
  enterRule(_localctx, 92, MySQLParser::RuleCreateRoutine);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(1968);
    match(MySQLParser::CREATE_SYMBOL);
    setState(1972);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 120, _ctx)) {
    case 1: {
      setState(1969);
      createProcedure();
      break;
    }

    case 2: {
      setState(1970);
      createFunction();
      break;
    }

    case 3: {
      setState(1971);
      createUdf();
      break;
    }

    default:
      break;
    }
    setState(1975);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::SEMICOLON_SYMBOL) {
      setState(1974);
      match(MySQLParser::SEMICOLON_SYMBOL);
    }
    setState(1977);
    match(MySQLParser::EOF);
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CreateProcedureContext ------------------------------------------------------------------

MySQLParser::CreateProcedureContext::CreateProcedureContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::CreateProcedureContext::PROCEDURE_SYMBOL() {
  return getToken(MySQLParser::PROCEDURE_SYMBOL, 0);
}

MySQLParser::ProcedureNameContext* MySQLParser::CreateProcedureContext::procedureName() {
  return getRuleContext<MySQLParser::ProcedureNameContext>(0);
}

tree::TerminalNode* MySQLParser::CreateProcedureContext::OPEN_PAR_SYMBOL() {
  return getToken(MySQLParser::OPEN_PAR_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateProcedureContext::CLOSE_PAR_SYMBOL() {
  return getToken(MySQLParser::CLOSE_PAR_SYMBOL, 0);
}

MySQLParser::CompoundStatementContext* MySQLParser::CreateProcedureContext::compoundStatement() {
  return getRuleContext<MySQLParser::CompoundStatementContext>(0);
}

MySQLParser::DefinerClauseContext* MySQLParser::CreateProcedureContext::definerClause() {
  return getRuleContext<MySQLParser::DefinerClauseContext>(0);
}

std::vector<MySQLParser::ProcedureParameterContext *> MySQLParser::CreateProcedureContext::procedureParameter() {
  return getRuleContexts<MySQLParser::ProcedureParameterContext>();
}

MySQLParser::ProcedureParameterContext* MySQLParser::CreateProcedureContext::procedureParameter(size_t i) {
  return getRuleContext<MySQLParser::ProcedureParameterContext>(i);
}

std::vector<MySQLParser::RoutineCreateOptionContext *> MySQLParser::CreateProcedureContext::routineCreateOption() {
  return getRuleContexts<MySQLParser::RoutineCreateOptionContext>();
}

MySQLParser::RoutineCreateOptionContext* MySQLParser::CreateProcedureContext::routineCreateOption(size_t i) {
  return getRuleContext<MySQLParser::RoutineCreateOptionContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::CreateProcedureContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::CreateProcedureContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::CreateProcedureContext::getRuleIndex() const {
  return MySQLParser::RuleCreateProcedure;
}

void MySQLParser::CreateProcedureContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCreateProcedure(this);
}

void MySQLParser::CreateProcedureContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCreateProcedure(this);
}


std::any MySQLParser::CreateProcedureContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCreateProcedure(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CreateProcedureContext* MySQLParser::createProcedure() {
  CreateProcedureContext *_localctx = _tracker.createInstance<CreateProcedureContext>(_ctx, getState());
  enterRule(_localctx, 94, MySQLParser::RuleCreateProcedure);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    size_t alt;
    enterOuterAlt(_localctx, 1);
    setState(1980);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::DEFINER_SYMBOL) {
      setState(1979);
      definerClause();
    }
    setState(1982);
    match(MySQLParser::PROCEDURE_SYMBOL);
    setState(1983);
    procedureName();
    setState(1984);
    match(MySQLParser::OPEN_PAR_SYMBOL);
    setState(1993);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 124, _ctx)) {
    case 1: {
      setState(1985);
      procedureParameter();
      setState(1990);
      _errHandler->sync(this);
      _la = _input->LA(1);
      while (_la == MySQLParser::COMMA_SYMBOL) {
        setState(1986);
        match(MySQLParser::COMMA_SYMBOL);
        setState(1987);
        procedureParameter();
        setState(1992);
        _errHandler->sync(this);
        _la = _input->LA(1);
      }
      break;
    }

    default:
      break;
    }
    setState(1995);
    match(MySQLParser::CLOSE_PAR_SYMBOL);
    setState(1999);
    _errHandler->sync(this);
    alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 125, _ctx);
    while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER) {
      if (alt == 1) {
        setState(1996);
        routineCreateOption(); 
      }
      setState(2001);
      _errHandler->sync(this);
      alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 125, _ctx);
    }
    setState(2002);
    compoundStatement();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CreateFunctionContext ------------------------------------------------------------------

MySQLParser::CreateFunctionContext::CreateFunctionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::CreateFunctionContext::FUNCTION_SYMBOL() {
  return getToken(MySQLParser::FUNCTION_SYMBOL, 0);
}

MySQLParser::FunctionNameContext* MySQLParser::CreateFunctionContext::functionName() {
  return getRuleContext<MySQLParser::FunctionNameContext>(0);
}

tree::TerminalNode* MySQLParser::CreateFunctionContext::OPEN_PAR_SYMBOL() {
  return getToken(MySQLParser::OPEN_PAR_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateFunctionContext::CLOSE_PAR_SYMBOL() {
  return getToken(MySQLParser::CLOSE_PAR_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateFunctionContext::RETURNS_SYMBOL() {
  return getToken(MySQLParser::RETURNS_SYMBOL, 0);
}

MySQLParser::TypeWithOptCollateContext* MySQLParser::CreateFunctionContext::typeWithOptCollate() {
  return getRuleContext<MySQLParser::TypeWithOptCollateContext>(0);
}

MySQLParser::CompoundStatementContext* MySQLParser::CreateFunctionContext::compoundStatement() {
  return getRuleContext<MySQLParser::CompoundStatementContext>(0);
}

MySQLParser::DefinerClauseContext* MySQLParser::CreateFunctionContext::definerClause() {
  return getRuleContext<MySQLParser::DefinerClauseContext>(0);
}

std::vector<MySQLParser::FunctionParameterContext *> MySQLParser::CreateFunctionContext::functionParameter() {
  return getRuleContexts<MySQLParser::FunctionParameterContext>();
}

MySQLParser::FunctionParameterContext* MySQLParser::CreateFunctionContext::functionParameter(size_t i) {
  return getRuleContext<MySQLParser::FunctionParameterContext>(i);
}

std::vector<MySQLParser::RoutineCreateOptionContext *> MySQLParser::CreateFunctionContext::routineCreateOption() {
  return getRuleContexts<MySQLParser::RoutineCreateOptionContext>();
}

MySQLParser::RoutineCreateOptionContext* MySQLParser::CreateFunctionContext::routineCreateOption(size_t i) {
  return getRuleContext<MySQLParser::RoutineCreateOptionContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::CreateFunctionContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::CreateFunctionContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::CreateFunctionContext::getRuleIndex() const {
  return MySQLParser::RuleCreateFunction;
}

void MySQLParser::CreateFunctionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCreateFunction(this);
}

void MySQLParser::CreateFunctionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCreateFunction(this);
}


std::any MySQLParser::CreateFunctionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCreateFunction(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CreateFunctionContext* MySQLParser::createFunction() {
  CreateFunctionContext *_localctx = _tracker.createInstance<CreateFunctionContext>(_ctx, getState());
  enterRule(_localctx, 96, MySQLParser::RuleCreateFunction);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    size_t alt;
    enterOuterAlt(_localctx, 1);
    setState(2005);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::DEFINER_SYMBOL) {
      setState(2004);
      definerClause();
    }
    setState(2007);
    match(MySQLParser::FUNCTION_SYMBOL);
    setState(2008);
    functionName();
    setState(2009);
    match(MySQLParser::OPEN_PAR_SYMBOL);
    setState(2018);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 128, _ctx)) {
    case 1: {
      setState(2010);
      functionParameter();
      setState(2015);
      _errHandler->sync(this);
      _la = _input->LA(1);
      while (_la == MySQLParser::COMMA_SYMBOL) {
        setState(2011);
        match(MySQLParser::COMMA_SYMBOL);
        setState(2012);
        functionParameter();
        setState(2017);
        _errHandler->sync(this);
        _la = _input->LA(1);
      }
      break;
    }

    default:
      break;
    }
    setState(2020);
    match(MySQLParser::CLOSE_PAR_SYMBOL);
    setState(2021);
    match(MySQLParser::RETURNS_SYMBOL);
    setState(2022);
    typeWithOptCollate();
    setState(2026);
    _errHandler->sync(this);
    alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 129, _ctx);
    while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER) {
      if (alt == 1) {
        setState(2023);
        routineCreateOption(); 
      }
      setState(2028);
      _errHandler->sync(this);
      alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 129, _ctx);
    }
    setState(2029);
    compoundStatement();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CreateUdfContext ------------------------------------------------------------------

MySQLParser::CreateUdfContext::CreateUdfContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::CreateUdfContext::FUNCTION_SYMBOL() {
  return getToken(MySQLParser::FUNCTION_SYMBOL, 0);
}

MySQLParser::UdfNameContext* MySQLParser::CreateUdfContext::udfName() {
  return getRuleContext<MySQLParser::UdfNameContext>(0);
}

tree::TerminalNode* MySQLParser::CreateUdfContext::RETURNS_SYMBOL() {
  return getToken(MySQLParser::RETURNS_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateUdfContext::SONAME_SYMBOL() {
  return getToken(MySQLParser::SONAME_SYMBOL, 0);
}

MySQLParser::TextLiteralContext* MySQLParser::CreateUdfContext::textLiteral() {
  return getRuleContext<MySQLParser::TextLiteralContext>(0);
}

tree::TerminalNode* MySQLParser::CreateUdfContext::STRING_SYMBOL() {
  return getToken(MySQLParser::STRING_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateUdfContext::INT_SYMBOL() {
  return getToken(MySQLParser::INT_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateUdfContext::REAL_SYMBOL() {
  return getToken(MySQLParser::REAL_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateUdfContext::DECIMAL_SYMBOL() {
  return getToken(MySQLParser::DECIMAL_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateUdfContext::AGGREGATE_SYMBOL() {
  return getToken(MySQLParser::AGGREGATE_SYMBOL, 0);
}


size_t MySQLParser::CreateUdfContext::getRuleIndex() const {
  return MySQLParser::RuleCreateUdf;
}

void MySQLParser::CreateUdfContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCreateUdf(this);
}

void MySQLParser::CreateUdfContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCreateUdf(this);
}


std::any MySQLParser::CreateUdfContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCreateUdf(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CreateUdfContext* MySQLParser::createUdf() {
  CreateUdfContext *_localctx = _tracker.createInstance<CreateUdfContext>(_ctx, getState());
  enterRule(_localctx, 98, MySQLParser::RuleCreateUdf);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2032);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::AGGREGATE_SYMBOL) {
      setState(2031);
      match(MySQLParser::AGGREGATE_SYMBOL);
    }
    setState(2034);
    match(MySQLParser::FUNCTION_SYMBOL);
    setState(2035);
    udfName();
    setState(2036);
    match(MySQLParser::RETURNS_SYMBOL);
    setState(2037);
    antlrcpp::downCast<CreateUdfContext *>(_localctx)->type = _input->LT(1);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::DECIMAL_SYMBOL || _la == MySQLParser::INT_SYMBOL || _la == MySQLParser::REAL_SYMBOL || _la == MySQLParser::STRING_SYMBOL)) {
      antlrcpp::downCast<CreateUdfContext *>(_localctx)->type = _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
    setState(2038);
    match(MySQLParser::SONAME_SYMBOL);
    setState(2039);
    textLiteral();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- RoutineCreateOptionContext ------------------------------------------------------------------

MySQLParser::RoutineCreateOptionContext::RoutineCreateOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::RoutineOptionContext* MySQLParser::RoutineCreateOptionContext::routineOption() {
  return getRuleContext<MySQLParser::RoutineOptionContext>(0);
}

tree::TerminalNode* MySQLParser::RoutineCreateOptionContext::DETERMINISTIC_SYMBOL() {
  return getToken(MySQLParser::DETERMINISTIC_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::RoutineCreateOptionContext::NOT_SYMBOL() {
  return getToken(MySQLParser::NOT_SYMBOL, 0);
}


size_t MySQLParser::RoutineCreateOptionContext::getRuleIndex() const {
  return MySQLParser::RuleRoutineCreateOption;
}

void MySQLParser::RoutineCreateOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterRoutineCreateOption(this);
}

void MySQLParser::RoutineCreateOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitRoutineCreateOption(this);
}


std::any MySQLParser::RoutineCreateOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitRoutineCreateOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::RoutineCreateOptionContext* MySQLParser::routineCreateOption() {
  RoutineCreateOptionContext *_localctx = _tracker.createInstance<RoutineCreateOptionContext>(_ctx, getState());
  enterRule(_localctx, 100, MySQLParser::RuleRoutineCreateOption);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2046);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::COMMENT_SYMBOL:
      case MySQLParser::CONTAINS_SYMBOL:
      case MySQLParser::LANGUAGE_SYMBOL:
      case MySQLParser::MODIFIES_SYMBOL:
      case MySQLParser::NO_SYMBOL:
      case MySQLParser::READS_SYMBOL:
      case MySQLParser::SQL_SYMBOL: {
        enterOuterAlt(_localctx, 1);
        setState(2041);
        routineOption();
        break;
      }

      case MySQLParser::DETERMINISTIC_SYMBOL:
      case MySQLParser::NOT_SYMBOL: {
        enterOuterAlt(_localctx, 2);
        setState(2043);
        _errHandler->sync(this);

        _la = _input->LA(1);
        if (_la == MySQLParser::NOT_SYMBOL) {
          setState(2042);
          match(MySQLParser::NOT_SYMBOL);
        }
        setState(2045);
        match(MySQLParser::DETERMINISTIC_SYMBOL);
        break;
      }

    default:
      throw NoViableAltException(this);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- RoutineAlterOptionsContext ------------------------------------------------------------------

MySQLParser::RoutineAlterOptionsContext::RoutineAlterOptionsContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

std::vector<MySQLParser::RoutineCreateOptionContext *> MySQLParser::RoutineAlterOptionsContext::routineCreateOption() {
  return getRuleContexts<MySQLParser::RoutineCreateOptionContext>();
}

MySQLParser::RoutineCreateOptionContext* MySQLParser::RoutineAlterOptionsContext::routineCreateOption(size_t i) {
  return getRuleContext<MySQLParser::RoutineCreateOptionContext>(i);
}


size_t MySQLParser::RoutineAlterOptionsContext::getRuleIndex() const {
  return MySQLParser::RuleRoutineAlterOptions;
}

void MySQLParser::RoutineAlterOptionsContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterRoutineAlterOptions(this);
}

void MySQLParser::RoutineAlterOptionsContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitRoutineAlterOptions(this);
}


std::any MySQLParser::RoutineAlterOptionsContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitRoutineAlterOptions(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::RoutineAlterOptionsContext* MySQLParser::routineAlterOptions() {
  RoutineAlterOptionsContext *_localctx = _tracker.createInstance<RoutineAlterOptionsContext>(_ctx, getState());
  enterRule(_localctx, 102, MySQLParser::RuleRoutineAlterOptions);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2049); 
    _errHandler->sync(this);
    _la = _input->LA(1);
    do {
      setState(2048);
      routineCreateOption();
      setState(2051); 
      _errHandler->sync(this);
      _la = _input->LA(1);
    } while (((((_la - 75) & ~ 0x3fULL) == 0) &&
      ((1ULL << (_la - 75)) & 4611686018427420673) != 0) || _la == MySQLParser::LANGUAGE_SYMBOL || ((((_la - 347) & ~ 0x3fULL) == 0) &&
      ((1ULL << (_la - 347)) & 83886081) != 0) || _la == MySQLParser::READS_SYMBOL || _la == MySQLParser::SQL_SYMBOL);
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- RoutineOptionContext ------------------------------------------------------------------

MySQLParser::RoutineOptionContext::RoutineOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::TextLiteralContext* MySQLParser::RoutineOptionContext::textLiteral() {
  return getRuleContext<MySQLParser::TextLiteralContext>(0);
}

tree::TerminalNode* MySQLParser::RoutineOptionContext::COMMENT_SYMBOL() {
  return getToken(MySQLParser::COMMENT_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::RoutineOptionContext::SQL_SYMBOL() {
  return getToken(MySQLParser::SQL_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::RoutineOptionContext::LANGUAGE_SYMBOL() {
  return getToken(MySQLParser::LANGUAGE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::RoutineOptionContext::NO_SYMBOL() {
  return getToken(MySQLParser::NO_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::RoutineOptionContext::CONTAINS_SYMBOL() {
  return getToken(MySQLParser::CONTAINS_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::RoutineOptionContext::DATA_SYMBOL() {
  return getToken(MySQLParser::DATA_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::RoutineOptionContext::READS_SYMBOL() {
  return getToken(MySQLParser::READS_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::RoutineOptionContext::MODIFIES_SYMBOL() {
  return getToken(MySQLParser::MODIFIES_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::RoutineOptionContext::SECURITY_SYMBOL() {
  return getToken(MySQLParser::SECURITY_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::RoutineOptionContext::DEFINER_SYMBOL() {
  return getToken(MySQLParser::DEFINER_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::RoutineOptionContext::INVOKER_SYMBOL() {
  return getToken(MySQLParser::INVOKER_SYMBOL, 0);
}


size_t MySQLParser::RoutineOptionContext::getRuleIndex() const {
  return MySQLParser::RuleRoutineOption;
}

void MySQLParser::RoutineOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterRoutineOption(this);
}

void MySQLParser::RoutineOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitRoutineOption(this);
}


std::any MySQLParser::RoutineOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitRoutineOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::RoutineOptionContext* MySQLParser::routineOption() {
  RoutineOptionContext *_localctx = _tracker.createInstance<RoutineOptionContext>(_ctx, getState());
  enterRule(_localctx, 104, MySQLParser::RuleRoutineOption);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2070);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::COMMENT_SYMBOL: {
        enterOuterAlt(_localctx, 1);
        setState(2053);
        antlrcpp::downCast<RoutineOptionContext *>(_localctx)->option = match(MySQLParser::COMMENT_SYMBOL);
        setState(2054);
        textLiteral();
        break;
      }

      case MySQLParser::LANGUAGE_SYMBOL: {
        enterOuterAlt(_localctx, 2);
        setState(2055);
        antlrcpp::downCast<RoutineOptionContext *>(_localctx)->option = match(MySQLParser::LANGUAGE_SYMBOL);
        setState(2056);
        match(MySQLParser::SQL_SYMBOL);
        break;
      }

      case MySQLParser::NO_SYMBOL: {
        enterOuterAlt(_localctx, 3);
        setState(2057);
        antlrcpp::downCast<RoutineOptionContext *>(_localctx)->option = match(MySQLParser::NO_SYMBOL);
        setState(2058);
        match(MySQLParser::SQL_SYMBOL);
        break;
      }

      case MySQLParser::CONTAINS_SYMBOL: {
        enterOuterAlt(_localctx, 4);
        setState(2059);
        antlrcpp::downCast<RoutineOptionContext *>(_localctx)->option = match(MySQLParser::CONTAINS_SYMBOL);
        setState(2060);
        match(MySQLParser::SQL_SYMBOL);
        break;
      }

      case MySQLParser::READS_SYMBOL: {
        enterOuterAlt(_localctx, 5);
        setState(2061);
        antlrcpp::downCast<RoutineOptionContext *>(_localctx)->option = match(MySQLParser::READS_SYMBOL);
        setState(2062);
        match(MySQLParser::SQL_SYMBOL);
        setState(2063);
        match(MySQLParser::DATA_SYMBOL);
        break;
      }

      case MySQLParser::MODIFIES_SYMBOL: {
        enterOuterAlt(_localctx, 6);
        setState(2064);
        antlrcpp::downCast<RoutineOptionContext *>(_localctx)->option = match(MySQLParser::MODIFIES_SYMBOL);
        setState(2065);
        match(MySQLParser::SQL_SYMBOL);
        setState(2066);
        match(MySQLParser::DATA_SYMBOL);
        break;
      }

      case MySQLParser::SQL_SYMBOL: {
        enterOuterAlt(_localctx, 7);
        setState(2067);
        antlrcpp::downCast<RoutineOptionContext *>(_localctx)->option = match(MySQLParser::SQL_SYMBOL);
        setState(2068);
        match(MySQLParser::SECURITY_SYMBOL);
        setState(2069);
        antlrcpp::downCast<RoutineOptionContext *>(_localctx)->security = _input->LT(1);
        _la = _input->LA(1);
        if (!(_la == MySQLParser::DEFINER_SYMBOL || _la == MySQLParser::INVOKER_SYMBOL)) {
          antlrcpp::downCast<RoutineOptionContext *>(_localctx)->security = _errHandler->recoverInline(this);
        }
        else {
          _errHandler->reportMatch(this);
          consume();
        }
        break;
      }

    default:
      throw NoViableAltException(this);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CreateIndexContext ------------------------------------------------------------------

MySQLParser::CreateIndexContext::CreateIndexContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::CreateIndexTargetContext* MySQLParser::CreateIndexContext::createIndexTarget() {
  return getRuleContext<MySQLParser::CreateIndexTargetContext>(0);
}

tree::TerminalNode* MySQLParser::CreateIndexContext::INDEX_SYMBOL() {
  return getToken(MySQLParser::INDEX_SYMBOL, 0);
}

MySQLParser::IndexNameContext* MySQLParser::CreateIndexContext::indexName() {
  return getRuleContext<MySQLParser::IndexNameContext>(0);
}

MySQLParser::OnlineOptionContext* MySQLParser::CreateIndexContext::onlineOption() {
  return getRuleContext<MySQLParser::OnlineOptionContext>(0);
}

tree::TerminalNode* MySQLParser::CreateIndexContext::FULLTEXT_SYMBOL() {
  return getToken(MySQLParser::FULLTEXT_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateIndexContext::SPATIAL_SYMBOL() {
  return getToken(MySQLParser::SPATIAL_SYMBOL, 0);
}

MySQLParser::IndexLockAndAlgorithmContext* MySQLParser::CreateIndexContext::indexLockAndAlgorithm() {
  return getRuleContext<MySQLParser::IndexLockAndAlgorithmContext>(0);
}

tree::TerminalNode* MySQLParser::CreateIndexContext::UNIQUE_SYMBOL() {
  return getToken(MySQLParser::UNIQUE_SYMBOL, 0);
}

std::vector<MySQLParser::IndexOptionContext *> MySQLParser::CreateIndexContext::indexOption() {
  return getRuleContexts<MySQLParser::IndexOptionContext>();
}

MySQLParser::IndexOptionContext* MySQLParser::CreateIndexContext::indexOption(size_t i) {
  return getRuleContext<MySQLParser::IndexOptionContext>(i);
}

std::vector<MySQLParser::FulltextIndexOptionContext *> MySQLParser::CreateIndexContext::fulltextIndexOption() {
  return getRuleContexts<MySQLParser::FulltextIndexOptionContext>();
}

MySQLParser::FulltextIndexOptionContext* MySQLParser::CreateIndexContext::fulltextIndexOption(size_t i) {
  return getRuleContext<MySQLParser::FulltextIndexOptionContext>(i);
}

std::vector<MySQLParser::SpatialIndexOptionContext *> MySQLParser::CreateIndexContext::spatialIndexOption() {
  return getRuleContexts<MySQLParser::SpatialIndexOptionContext>();
}

MySQLParser::SpatialIndexOptionContext* MySQLParser::CreateIndexContext::spatialIndexOption(size_t i) {
  return getRuleContext<MySQLParser::SpatialIndexOptionContext>(i);
}

MySQLParser::IndexTypeClauseContext* MySQLParser::CreateIndexContext::indexTypeClause() {
  return getRuleContext<MySQLParser::IndexTypeClauseContext>(0);
}

MySQLParser::IndexNameAndTypeContext* MySQLParser::CreateIndexContext::indexNameAndType() {
  return getRuleContext<MySQLParser::IndexNameAndTypeContext>(0);
}


size_t MySQLParser::CreateIndexContext::getRuleIndex() const {
  return MySQLParser::RuleCreateIndex;
}

void MySQLParser::CreateIndexContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCreateIndex(this);
}

void MySQLParser::CreateIndexContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCreateIndex(this);
}


std::any MySQLParser::CreateIndexContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCreateIndex(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CreateIndexContext* MySQLParser::createIndex() {
  CreateIndexContext *_localctx = _tracker.createInstance<CreateIndexContext>(_ctx, getState());
  enterRule(_localctx, 106, MySQLParser::RuleCreateIndex);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    size_t alt;
    enterOuterAlt(_localctx, 1);
    setState(2073);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::OFFLINE_SYMBOL

    || _la == MySQLParser::ONLINE_SYMBOL) {
      setState(2072);
      onlineOption();
    }
    setState(2116);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::INDEX_SYMBOL:
      case MySQLParser::UNIQUE_SYMBOL: {
        setState(2076);
        _errHandler->sync(this);

        _la = _input->LA(1);
        if (_la == MySQLParser::UNIQUE_SYMBOL) {
          setState(2075);
          match(MySQLParser::UNIQUE_SYMBOL);
        }
        setState(2078);
        antlrcpp::downCast<CreateIndexContext *>(_localctx)->type = match(MySQLParser::INDEX_SYMBOL);
        setState(2087);
        _errHandler->sync(this);
        switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 139, _ctx)) {
        case 1: {
          setState(2079);

          if (!(serverVersion >= 80014)) throw FailedPredicateException(this, "serverVersion >= 80014");
          setState(2080);
          indexName();
          setState(2082);
          _errHandler->sync(this);

          _la = _input->LA(1);
          if (_la == MySQLParser::TYPE_SYMBOL

          || _la == MySQLParser::USING_SYMBOL) {
            setState(2081);
            indexTypeClause();
          }
          break;
        }

        case 2: {
          setState(2085);
          _errHandler->sync(this);

          switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 138, _ctx)) {
          case 1: {
            setState(2084);
            indexNameAndType();
            break;
          }

          default:
            break;
          }
          break;
        }

        default:
          break;
        }
        setState(2089);
        createIndexTarget();
        setState(2093);
        _errHandler->sync(this);
        alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 140, _ctx);
        while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER) {
          if (alt == 1) {
            setState(2090);
            indexOption(); 
          }
          setState(2095);
          _errHandler->sync(this);
          alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 140, _ctx);
        }
        break;
      }

      case MySQLParser::FULLTEXT_SYMBOL: {
        setState(2096);
        antlrcpp::downCast<CreateIndexContext *>(_localctx)->type = match(MySQLParser::FULLTEXT_SYMBOL);
        setState(2097);
        match(MySQLParser::INDEX_SYMBOL);
        setState(2098);
        indexName();
        setState(2099);
        createIndexTarget();
        setState(2103);
        _errHandler->sync(this);
        alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 141, _ctx);
        while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER) {
          if (alt == 1) {
            setState(2100);
            fulltextIndexOption(); 
          }
          setState(2105);
          _errHandler->sync(this);
          alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 141, _ctx);
        }
        break;
      }

      case MySQLParser::SPATIAL_SYMBOL: {
        setState(2106);
        antlrcpp::downCast<CreateIndexContext *>(_localctx)->type = match(MySQLParser::SPATIAL_SYMBOL);
        setState(2107);
        match(MySQLParser::INDEX_SYMBOL);
        setState(2108);
        indexName();
        setState(2109);
        createIndexTarget();
        setState(2113);
        _errHandler->sync(this);
        alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 142, _ctx);
        while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER) {
          if (alt == 1) {
            setState(2110);
            spatialIndexOption(); 
          }
          setState(2115);
          _errHandler->sync(this);
          alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 142, _ctx);
        }
        break;
      }

    default:
      throw NoViableAltException(this);
    }
    setState(2119);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::ALGORITHM_SYMBOL || _la == MySQLParser::LOCK_SYMBOL) {
      setState(2118);
      indexLockAndAlgorithm();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- IndexNameAndTypeContext ------------------------------------------------------------------

MySQLParser::IndexNameAndTypeContext::IndexNameAndTypeContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::IndexNameContext* MySQLParser::IndexNameAndTypeContext::indexName() {
  return getRuleContext<MySQLParser::IndexNameContext>(0);
}

tree::TerminalNode* MySQLParser::IndexNameAndTypeContext::USING_SYMBOL() {
  return getToken(MySQLParser::USING_SYMBOL, 0);
}

MySQLParser::IndexTypeContext* MySQLParser::IndexNameAndTypeContext::indexType() {
  return getRuleContext<MySQLParser::IndexTypeContext>(0);
}

tree::TerminalNode* MySQLParser::IndexNameAndTypeContext::TYPE_SYMBOL() {
  return getToken(MySQLParser::TYPE_SYMBOL, 0);
}


size_t MySQLParser::IndexNameAndTypeContext::getRuleIndex() const {
  return MySQLParser::RuleIndexNameAndType;
}

void MySQLParser::IndexNameAndTypeContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterIndexNameAndType(this);
}

void MySQLParser::IndexNameAndTypeContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitIndexNameAndType(this);
}


std::any MySQLParser::IndexNameAndTypeContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitIndexNameAndType(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::IndexNameAndTypeContext* MySQLParser::indexNameAndType() {
  IndexNameAndTypeContext *_localctx = _tracker.createInstance<IndexNameAndTypeContext>(_ctx, getState());
  enterRule(_localctx, 108, MySQLParser::RuleIndexNameAndType);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2130);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 146, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(2121);
      indexName();
      setState(2124);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 145, _ctx)) {
      case 1: {
        setState(2122);
        match(MySQLParser::USING_SYMBOL);
        setState(2123);
        indexType();
        break;
      }

      default:
        break;
      }
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(2126);
      indexName();
      setState(2127);
      match(MySQLParser::TYPE_SYMBOL);
      setState(2128);
      indexType();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CreateIndexTargetContext ------------------------------------------------------------------

MySQLParser::CreateIndexTargetContext::CreateIndexTargetContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::CreateIndexTargetContext::ON_SYMBOL() {
  return getToken(MySQLParser::ON_SYMBOL, 0);
}

MySQLParser::TableRefContext* MySQLParser::CreateIndexTargetContext::tableRef() {
  return getRuleContext<MySQLParser::TableRefContext>(0);
}

MySQLParser::KeyListVariantsContext* MySQLParser::CreateIndexTargetContext::keyListVariants() {
  return getRuleContext<MySQLParser::KeyListVariantsContext>(0);
}


size_t MySQLParser::CreateIndexTargetContext::getRuleIndex() const {
  return MySQLParser::RuleCreateIndexTarget;
}

void MySQLParser::CreateIndexTargetContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCreateIndexTarget(this);
}

void MySQLParser::CreateIndexTargetContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCreateIndexTarget(this);
}


std::any MySQLParser::CreateIndexTargetContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCreateIndexTarget(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CreateIndexTargetContext* MySQLParser::createIndexTarget() {
  CreateIndexTargetContext *_localctx = _tracker.createInstance<CreateIndexTargetContext>(_ctx, getState());
  enterRule(_localctx, 110, MySQLParser::RuleCreateIndexTarget);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2132);
    match(MySQLParser::ON_SYMBOL);
    setState(2133);
    tableRef();
    setState(2134);
    keyListVariants();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CreateLogfileGroupContext ------------------------------------------------------------------

MySQLParser::CreateLogfileGroupContext::CreateLogfileGroupContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::CreateLogfileGroupContext::LOGFILE_SYMBOL() {
  return getToken(MySQLParser::LOGFILE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateLogfileGroupContext::GROUP_SYMBOL() {
  return getToken(MySQLParser::GROUP_SYMBOL, 0);
}

MySQLParser::LogfileGroupNameContext* MySQLParser::CreateLogfileGroupContext::logfileGroupName() {
  return getRuleContext<MySQLParser::LogfileGroupNameContext>(0);
}

tree::TerminalNode* MySQLParser::CreateLogfileGroupContext::ADD_SYMBOL() {
  return getToken(MySQLParser::ADD_SYMBOL, 0);
}

MySQLParser::TextLiteralContext* MySQLParser::CreateLogfileGroupContext::textLiteral() {
  return getRuleContext<MySQLParser::TextLiteralContext>(0);
}

tree::TerminalNode* MySQLParser::CreateLogfileGroupContext::UNDOFILE_SYMBOL() {
  return getToken(MySQLParser::UNDOFILE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateLogfileGroupContext::REDOFILE_SYMBOL() {
  return getToken(MySQLParser::REDOFILE_SYMBOL, 0);
}

MySQLParser::LogfileGroupOptionsContext* MySQLParser::CreateLogfileGroupContext::logfileGroupOptions() {
  return getRuleContext<MySQLParser::LogfileGroupOptionsContext>(0);
}


size_t MySQLParser::CreateLogfileGroupContext::getRuleIndex() const {
  return MySQLParser::RuleCreateLogfileGroup;
}

void MySQLParser::CreateLogfileGroupContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCreateLogfileGroup(this);
}

void MySQLParser::CreateLogfileGroupContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCreateLogfileGroup(this);
}


std::any MySQLParser::CreateLogfileGroupContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCreateLogfileGroup(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CreateLogfileGroupContext* MySQLParser::createLogfileGroup() {
  CreateLogfileGroupContext *_localctx = _tracker.createInstance<CreateLogfileGroupContext>(_ctx, getState());
  enterRule(_localctx, 112, MySQLParser::RuleCreateLogfileGroup);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2136);
    match(MySQLParser::LOGFILE_SYMBOL);
    setState(2137);
    match(MySQLParser::GROUP_SYMBOL);
    setState(2138);
    logfileGroupName();
    setState(2139);
    match(MySQLParser::ADD_SYMBOL);
    setState(2140);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::REDOFILE_SYMBOL || _la == MySQLParser::UNDOFILE_SYMBOL)) {
    _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
    setState(2141);
    textLiteral();
    setState(2143);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::COMMENT_SYMBOL || _la == MySQLParser::ENGINE_SYMBOL || _la == MySQLParser::INITIAL_SIZE_SYMBOL || _la == MySQLParser::NODEGROUP_SYMBOL

    || _la == MySQLParser::NO_WAIT_SYMBOL || _la == MySQLParser::REDO_BUFFER_SIZE_SYMBOL || _la == MySQLParser::STORAGE_SYMBOL

    || _la == MySQLParser::UNDO_BUFFER_SIZE_SYMBOL || _la == MySQLParser::WAIT_SYMBOL) {
      setState(2142);
      logfileGroupOptions();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- LogfileGroupOptionsContext ------------------------------------------------------------------

MySQLParser::LogfileGroupOptionsContext::LogfileGroupOptionsContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

std::vector<MySQLParser::LogfileGroupOptionContext *> MySQLParser::LogfileGroupOptionsContext::logfileGroupOption() {
  return getRuleContexts<MySQLParser::LogfileGroupOptionContext>();
}

MySQLParser::LogfileGroupOptionContext* MySQLParser::LogfileGroupOptionsContext::logfileGroupOption(size_t i) {
  return getRuleContext<MySQLParser::LogfileGroupOptionContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::LogfileGroupOptionsContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::LogfileGroupOptionsContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::LogfileGroupOptionsContext::getRuleIndex() const {
  return MySQLParser::RuleLogfileGroupOptions;
}

void MySQLParser::LogfileGroupOptionsContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterLogfileGroupOptions(this);
}

void MySQLParser::LogfileGroupOptionsContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitLogfileGroupOptions(this);
}


std::any MySQLParser::LogfileGroupOptionsContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitLogfileGroupOptions(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::LogfileGroupOptionsContext* MySQLParser::logfileGroupOptions() {
  LogfileGroupOptionsContext *_localctx = _tracker.createInstance<LogfileGroupOptionsContext>(_ctx, getState());
  enterRule(_localctx, 114, MySQLParser::RuleLogfileGroupOptions);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2145);
    logfileGroupOption();
    setState(2152);
    _errHandler->sync(this);
    _la = _input->LA(1);
    while (_la == MySQLParser::COMMENT_SYMBOL || _la == MySQLParser::ENGINE_SYMBOL || _la == MySQLParser::INITIAL_SIZE_SYMBOL || _la == MySQLParser::NODEGROUP_SYMBOL

    || _la == MySQLParser::NO_WAIT_SYMBOL || _la == MySQLParser::REDO_BUFFER_SIZE_SYMBOL || _la == MySQLParser::STORAGE_SYMBOL

    || _la == MySQLParser::UNDO_BUFFER_SIZE_SYMBOL || _la == MySQLParser::WAIT_SYMBOL || _la == MySQLParser::COMMA_SYMBOL) {
      setState(2147);
      _errHandler->sync(this);

      _la = _input->LA(1);
      if (_la == MySQLParser::COMMA_SYMBOL) {
        setState(2146);
        match(MySQLParser::COMMA_SYMBOL);
      }
      setState(2149);
      logfileGroupOption();
      setState(2154);
      _errHandler->sync(this);
      _la = _input->LA(1);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- LogfileGroupOptionContext ------------------------------------------------------------------

MySQLParser::LogfileGroupOptionContext::LogfileGroupOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::TsOptionInitialSizeContext* MySQLParser::LogfileGroupOptionContext::tsOptionInitialSize() {
  return getRuleContext<MySQLParser::TsOptionInitialSizeContext>(0);
}

MySQLParser::TsOptionUndoRedoBufferSizeContext* MySQLParser::LogfileGroupOptionContext::tsOptionUndoRedoBufferSize() {
  return getRuleContext<MySQLParser::TsOptionUndoRedoBufferSizeContext>(0);
}

MySQLParser::TsOptionNodegroupContext* MySQLParser::LogfileGroupOptionContext::tsOptionNodegroup() {
  return getRuleContext<MySQLParser::TsOptionNodegroupContext>(0);
}

MySQLParser::TsOptionEngineContext* MySQLParser::LogfileGroupOptionContext::tsOptionEngine() {
  return getRuleContext<MySQLParser::TsOptionEngineContext>(0);
}

MySQLParser::TsOptionWaitContext* MySQLParser::LogfileGroupOptionContext::tsOptionWait() {
  return getRuleContext<MySQLParser::TsOptionWaitContext>(0);
}

MySQLParser::TsOptionCommentContext* MySQLParser::LogfileGroupOptionContext::tsOptionComment() {
  return getRuleContext<MySQLParser::TsOptionCommentContext>(0);
}


size_t MySQLParser::LogfileGroupOptionContext::getRuleIndex() const {
  return MySQLParser::RuleLogfileGroupOption;
}

void MySQLParser::LogfileGroupOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterLogfileGroupOption(this);
}

void MySQLParser::LogfileGroupOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitLogfileGroupOption(this);
}


std::any MySQLParser::LogfileGroupOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitLogfileGroupOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::LogfileGroupOptionContext* MySQLParser::logfileGroupOption() {
  LogfileGroupOptionContext *_localctx = _tracker.createInstance<LogfileGroupOptionContext>(_ctx, getState());
  enterRule(_localctx, 116, MySQLParser::RuleLogfileGroupOption);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2161);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::INITIAL_SIZE_SYMBOL: {
        enterOuterAlt(_localctx, 1);
        setState(2155);
        tsOptionInitialSize();
        break;
      }

      case MySQLParser::REDO_BUFFER_SIZE_SYMBOL:
      case MySQLParser::UNDO_BUFFER_SIZE_SYMBOL: {
        enterOuterAlt(_localctx, 2);
        setState(2156);
        tsOptionUndoRedoBufferSize();
        break;
      }

      case MySQLParser::NODEGROUP_SYMBOL: {
        enterOuterAlt(_localctx, 3);
        setState(2157);
        tsOptionNodegroup();
        break;
      }

      case MySQLParser::ENGINE_SYMBOL:
      case MySQLParser::STORAGE_SYMBOL: {
        enterOuterAlt(_localctx, 4);
        setState(2158);
        tsOptionEngine();
        break;
      }

      case MySQLParser::NO_WAIT_SYMBOL:
      case MySQLParser::WAIT_SYMBOL: {
        enterOuterAlt(_localctx, 5);
        setState(2159);
        tsOptionWait();
        break;
      }

      case MySQLParser::COMMENT_SYMBOL: {
        enterOuterAlt(_localctx, 6);
        setState(2160);
        tsOptionComment();
        break;
      }

    default:
      throw NoViableAltException(this);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CreateServerContext ------------------------------------------------------------------

MySQLParser::CreateServerContext::CreateServerContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::CreateServerContext::SERVER_SYMBOL() {
  return getToken(MySQLParser::SERVER_SYMBOL, 0);
}

MySQLParser::ServerNameContext* MySQLParser::CreateServerContext::serverName() {
  return getRuleContext<MySQLParser::ServerNameContext>(0);
}

tree::TerminalNode* MySQLParser::CreateServerContext::FOREIGN_SYMBOL() {
  return getToken(MySQLParser::FOREIGN_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateServerContext::DATA_SYMBOL() {
  return getToken(MySQLParser::DATA_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateServerContext::WRAPPER_SYMBOL() {
  return getToken(MySQLParser::WRAPPER_SYMBOL, 0);
}

MySQLParser::TextOrIdentifierContext* MySQLParser::CreateServerContext::textOrIdentifier() {
  return getRuleContext<MySQLParser::TextOrIdentifierContext>(0);
}

MySQLParser::ServerOptionsContext* MySQLParser::CreateServerContext::serverOptions() {
  return getRuleContext<MySQLParser::ServerOptionsContext>(0);
}


size_t MySQLParser::CreateServerContext::getRuleIndex() const {
  return MySQLParser::RuleCreateServer;
}

void MySQLParser::CreateServerContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCreateServer(this);
}

void MySQLParser::CreateServerContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCreateServer(this);
}


std::any MySQLParser::CreateServerContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCreateServer(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CreateServerContext* MySQLParser::createServer() {
  CreateServerContext *_localctx = _tracker.createInstance<CreateServerContext>(_ctx, getState());
  enterRule(_localctx, 118, MySQLParser::RuleCreateServer);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2163);
    match(MySQLParser::SERVER_SYMBOL);
    setState(2164);
    serverName();
    setState(2165);
    match(MySQLParser::FOREIGN_SYMBOL);
    setState(2166);
    match(MySQLParser::DATA_SYMBOL);
    setState(2167);
    match(MySQLParser::WRAPPER_SYMBOL);
    setState(2168);
    textOrIdentifier();
    setState(2169);
    serverOptions();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- ServerOptionsContext ------------------------------------------------------------------

MySQLParser::ServerOptionsContext::ServerOptionsContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::ServerOptionsContext::OPTIONS_SYMBOL() {
  return getToken(MySQLParser::OPTIONS_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ServerOptionsContext::OPEN_PAR_SYMBOL() {
  return getToken(MySQLParser::OPEN_PAR_SYMBOL, 0);
}

std::vector<MySQLParser::ServerOptionContext *> MySQLParser::ServerOptionsContext::serverOption() {
  return getRuleContexts<MySQLParser::ServerOptionContext>();
}

MySQLParser::ServerOptionContext* MySQLParser::ServerOptionsContext::serverOption(size_t i) {
  return getRuleContext<MySQLParser::ServerOptionContext>(i);
}

tree::TerminalNode* MySQLParser::ServerOptionsContext::CLOSE_PAR_SYMBOL() {
  return getToken(MySQLParser::CLOSE_PAR_SYMBOL, 0);
}

std::vector<tree::TerminalNode *> MySQLParser::ServerOptionsContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::ServerOptionsContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::ServerOptionsContext::getRuleIndex() const {
  return MySQLParser::RuleServerOptions;
}

void MySQLParser::ServerOptionsContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterServerOptions(this);
}

void MySQLParser::ServerOptionsContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitServerOptions(this);
}


std::any MySQLParser::ServerOptionsContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitServerOptions(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::ServerOptionsContext* MySQLParser::serverOptions() {
  ServerOptionsContext *_localctx = _tracker.createInstance<ServerOptionsContext>(_ctx, getState());
  enterRule(_localctx, 120, MySQLParser::RuleServerOptions);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2171);
    match(MySQLParser::OPTIONS_SYMBOL);
    setState(2172);
    match(MySQLParser::OPEN_PAR_SYMBOL);
    setState(2173);
    serverOption();
    setState(2178);
    _errHandler->sync(this);
    _la = _input->LA(1);
    while (_la == MySQLParser::COMMA_SYMBOL) {
      setState(2174);
      match(MySQLParser::COMMA_SYMBOL);
      setState(2175);
      serverOption();
      setState(2180);
      _errHandler->sync(this);
      _la = _input->LA(1);
    }
    setState(2181);
    match(MySQLParser::CLOSE_PAR_SYMBOL);
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- ServerOptionContext ------------------------------------------------------------------

MySQLParser::ServerOptionContext::ServerOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::TextLiteralContext* MySQLParser::ServerOptionContext::textLiteral() {
  return getRuleContext<MySQLParser::TextLiteralContext>(0);
}

tree::TerminalNode* MySQLParser::ServerOptionContext::HOST_SYMBOL() {
  return getToken(MySQLParser::HOST_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ServerOptionContext::DATABASE_SYMBOL() {
  return getToken(MySQLParser::DATABASE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ServerOptionContext::USER_SYMBOL() {
  return getToken(MySQLParser::USER_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ServerOptionContext::PASSWORD_SYMBOL() {
  return getToken(MySQLParser::PASSWORD_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ServerOptionContext::SOCKET_SYMBOL() {
  return getToken(MySQLParser::SOCKET_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ServerOptionContext::OWNER_SYMBOL() {
  return getToken(MySQLParser::OWNER_SYMBOL, 0);
}

MySQLParser::Ulong_numberContext* MySQLParser::ServerOptionContext::ulong_number() {
  return getRuleContext<MySQLParser::Ulong_numberContext>(0);
}

tree::TerminalNode* MySQLParser::ServerOptionContext::PORT_SYMBOL() {
  return getToken(MySQLParser::PORT_SYMBOL, 0);
}


size_t MySQLParser::ServerOptionContext::getRuleIndex() const {
  return MySQLParser::RuleServerOption;
}

void MySQLParser::ServerOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterServerOption(this);
}

void MySQLParser::ServerOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitServerOption(this);
}


std::any MySQLParser::ServerOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitServerOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::ServerOptionContext* MySQLParser::serverOption() {
  ServerOptionContext *_localctx = _tracker.createInstance<ServerOptionContext>(_ctx, getState());
  enterRule(_localctx, 122, MySQLParser::RuleServerOption);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2197);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::HOST_SYMBOL: {
        enterOuterAlt(_localctx, 1);
        setState(2183);
        antlrcpp::downCast<ServerOptionContext *>(_localctx)->option = match(MySQLParser::HOST_SYMBOL);
        setState(2184);
        textLiteral();
        break;
      }

      case MySQLParser::DATABASE_SYMBOL: {
        enterOuterAlt(_localctx, 2);
        setState(2185);
        antlrcpp::downCast<ServerOptionContext *>(_localctx)->option = match(MySQLParser::DATABASE_SYMBOL);
        setState(2186);
        textLiteral();
        break;
      }

      case MySQLParser::USER_SYMBOL: {
        enterOuterAlt(_localctx, 3);
        setState(2187);
        antlrcpp::downCast<ServerOptionContext *>(_localctx)->option = match(MySQLParser::USER_SYMBOL);
        setState(2188);
        textLiteral();
        break;
      }

      case MySQLParser::PASSWORD_SYMBOL: {
        enterOuterAlt(_localctx, 4);
        setState(2189);
        antlrcpp::downCast<ServerOptionContext *>(_localctx)->option = match(MySQLParser::PASSWORD_SYMBOL);
        setState(2190);
        textLiteral();
        break;
      }

      case MySQLParser::SOCKET_SYMBOL: {
        enterOuterAlt(_localctx, 5);
        setState(2191);
        antlrcpp::downCast<ServerOptionContext *>(_localctx)->option = match(MySQLParser::SOCKET_SYMBOL);
        setState(2192);
        textLiteral();
        break;
      }

      case MySQLParser::OWNER_SYMBOL: {
        enterOuterAlt(_localctx, 6);
        setState(2193);
        antlrcpp::downCast<ServerOptionContext *>(_localctx)->option = match(MySQLParser::OWNER_SYMBOL);
        setState(2194);
        textLiteral();
        break;
      }

      case MySQLParser::PORT_SYMBOL: {
        enterOuterAlt(_localctx, 7);
        setState(2195);
        antlrcpp::downCast<ServerOptionContext *>(_localctx)->option = match(MySQLParser::PORT_SYMBOL);
        setState(2196);
        ulong_number();
        break;
      }

    default:
      throw NoViableAltException(this);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CreateTablespaceContext ------------------------------------------------------------------

MySQLParser::CreateTablespaceContext::CreateTablespaceContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::CreateTablespaceContext::TABLESPACE_SYMBOL() {
  return getToken(MySQLParser::TABLESPACE_SYMBOL, 0);
}

MySQLParser::TablespaceNameContext* MySQLParser::CreateTablespaceContext::tablespaceName() {
  return getRuleContext<MySQLParser::TablespaceNameContext>(0);
}

MySQLParser::TsDataFileNameContext* MySQLParser::CreateTablespaceContext::tsDataFileName() {
  return getRuleContext<MySQLParser::TsDataFileNameContext>(0);
}

tree::TerminalNode* MySQLParser::CreateTablespaceContext::USE_SYMBOL() {
  return getToken(MySQLParser::USE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateTablespaceContext::LOGFILE_SYMBOL() {
  return getToken(MySQLParser::LOGFILE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateTablespaceContext::GROUP_SYMBOL() {
  return getToken(MySQLParser::GROUP_SYMBOL, 0);
}

MySQLParser::LogfileGroupRefContext* MySQLParser::CreateTablespaceContext::logfileGroupRef() {
  return getRuleContext<MySQLParser::LogfileGroupRefContext>(0);
}

MySQLParser::TablespaceOptionsContext* MySQLParser::CreateTablespaceContext::tablespaceOptions() {
  return getRuleContext<MySQLParser::TablespaceOptionsContext>(0);
}


size_t MySQLParser::CreateTablespaceContext::getRuleIndex() const {
  return MySQLParser::RuleCreateTablespace;
}

void MySQLParser::CreateTablespaceContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCreateTablespace(this);
}

void MySQLParser::CreateTablespaceContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCreateTablespace(this);
}


std::any MySQLParser::CreateTablespaceContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCreateTablespace(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CreateTablespaceContext* MySQLParser::createTablespace() {
  CreateTablespaceContext *_localctx = _tracker.createInstance<CreateTablespaceContext>(_ctx, getState());
  enterRule(_localctx, 124, MySQLParser::RuleCreateTablespace);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2199);
    match(MySQLParser::TABLESPACE_SYMBOL);
    setState(2200);
    tablespaceName();
    setState(2201);
    tsDataFileName();
    setState(2206);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 153, _ctx)) {
    case 1: {
      setState(2202);
      match(MySQLParser::USE_SYMBOL);
      setState(2203);
      match(MySQLParser::LOGFILE_SYMBOL);
      setState(2204);
      match(MySQLParser::GROUP_SYMBOL);
      setState(2205);
      logfileGroupRef();
      break;
    }

    default:
      break;
    }
    setState(2209);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 154, _ctx)) {
    case 1: {
      setState(2208);
      tablespaceOptions();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CreateUndoTablespaceContext ------------------------------------------------------------------

MySQLParser::CreateUndoTablespaceContext::CreateUndoTablespaceContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::CreateUndoTablespaceContext::UNDO_SYMBOL() {
  return getToken(MySQLParser::UNDO_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateUndoTablespaceContext::TABLESPACE_SYMBOL() {
  return getToken(MySQLParser::TABLESPACE_SYMBOL, 0);
}

MySQLParser::TablespaceNameContext* MySQLParser::CreateUndoTablespaceContext::tablespaceName() {
  return getRuleContext<MySQLParser::TablespaceNameContext>(0);
}

tree::TerminalNode* MySQLParser::CreateUndoTablespaceContext::ADD_SYMBOL() {
  return getToken(MySQLParser::ADD_SYMBOL, 0);
}

MySQLParser::TsDataFileContext* MySQLParser::CreateUndoTablespaceContext::tsDataFile() {
  return getRuleContext<MySQLParser::TsDataFileContext>(0);
}

MySQLParser::UndoTableSpaceOptionsContext* MySQLParser::CreateUndoTablespaceContext::undoTableSpaceOptions() {
  return getRuleContext<MySQLParser::UndoTableSpaceOptionsContext>(0);
}


size_t MySQLParser::CreateUndoTablespaceContext::getRuleIndex() const {
  return MySQLParser::RuleCreateUndoTablespace;
}

void MySQLParser::CreateUndoTablespaceContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCreateUndoTablespace(this);
}

void MySQLParser::CreateUndoTablespaceContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCreateUndoTablespace(this);
}


std::any MySQLParser::CreateUndoTablespaceContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCreateUndoTablespace(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CreateUndoTablespaceContext* MySQLParser::createUndoTablespace() {
  CreateUndoTablespaceContext *_localctx = _tracker.createInstance<CreateUndoTablespaceContext>(_ctx, getState());
  enterRule(_localctx, 126, MySQLParser::RuleCreateUndoTablespace);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2211);
    match(MySQLParser::UNDO_SYMBOL);
    setState(2212);
    match(MySQLParser::TABLESPACE_SYMBOL);
    setState(2213);
    tablespaceName();
    setState(2214);
    match(MySQLParser::ADD_SYMBOL);
    setState(2215);
    tsDataFile();
    setState(2217);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::ENGINE_SYMBOL || _la == MySQLParser::STORAGE_SYMBOL) {
      setState(2216);
      undoTableSpaceOptions();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TsDataFileNameContext ------------------------------------------------------------------

MySQLParser::TsDataFileNameContext::TsDataFileNameContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::TsDataFileNameContext::ADD_SYMBOL() {
  return getToken(MySQLParser::ADD_SYMBOL, 0);
}

MySQLParser::TsDataFileContext* MySQLParser::TsDataFileNameContext::tsDataFile() {
  return getRuleContext<MySQLParser::TsDataFileContext>(0);
}


size_t MySQLParser::TsDataFileNameContext::getRuleIndex() const {
  return MySQLParser::RuleTsDataFileName;
}

void MySQLParser::TsDataFileNameContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTsDataFileName(this);
}

void MySQLParser::TsDataFileNameContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTsDataFileName(this);
}


std::any MySQLParser::TsDataFileNameContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTsDataFileName(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TsDataFileNameContext* MySQLParser::tsDataFileName() {
  TsDataFileNameContext *_localctx = _tracker.createInstance<TsDataFileNameContext>(_ctx, getState());
  enterRule(_localctx, 128, MySQLParser::RuleTsDataFileName);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2226);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 157, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(2219);

      if (!(serverVersion >= 80014)) throw FailedPredicateException(this, "serverVersion >= 80014");
      setState(2222);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 156, _ctx)) {
      case 1: {
        setState(2220);
        match(MySQLParser::ADD_SYMBOL);
        setState(2221);
        tsDataFile();
        break;
      }

      default:
        break;
      }
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(2224);
      match(MySQLParser::ADD_SYMBOL);
      setState(2225);
      tsDataFile();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TsDataFileContext ------------------------------------------------------------------

MySQLParser::TsDataFileContext::TsDataFileContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::TsDataFileContext::DATAFILE_SYMBOL() {
  return getToken(MySQLParser::DATAFILE_SYMBOL, 0);
}

MySQLParser::TextLiteralContext* MySQLParser::TsDataFileContext::textLiteral() {
  return getRuleContext<MySQLParser::TextLiteralContext>(0);
}


size_t MySQLParser::TsDataFileContext::getRuleIndex() const {
  return MySQLParser::RuleTsDataFile;
}

void MySQLParser::TsDataFileContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTsDataFile(this);
}

void MySQLParser::TsDataFileContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTsDataFile(this);
}


std::any MySQLParser::TsDataFileContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTsDataFile(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TsDataFileContext* MySQLParser::tsDataFile() {
  TsDataFileContext *_localctx = _tracker.createInstance<TsDataFileContext>(_ctx, getState());
  enterRule(_localctx, 130, MySQLParser::RuleTsDataFile);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2228);
    match(MySQLParser::DATAFILE_SYMBOL);
    setState(2229);
    textLiteral();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TablespaceOptionsContext ------------------------------------------------------------------

MySQLParser::TablespaceOptionsContext::TablespaceOptionsContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

std::vector<MySQLParser::TablespaceOptionContext *> MySQLParser::TablespaceOptionsContext::tablespaceOption() {
  return getRuleContexts<MySQLParser::TablespaceOptionContext>();
}

MySQLParser::TablespaceOptionContext* MySQLParser::TablespaceOptionsContext::tablespaceOption(size_t i) {
  return getRuleContext<MySQLParser::TablespaceOptionContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::TablespaceOptionsContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::TablespaceOptionsContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::TablespaceOptionsContext::getRuleIndex() const {
  return MySQLParser::RuleTablespaceOptions;
}

void MySQLParser::TablespaceOptionsContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTablespaceOptions(this);
}

void MySQLParser::TablespaceOptionsContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTablespaceOptions(this);
}


std::any MySQLParser::TablespaceOptionsContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTablespaceOptions(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TablespaceOptionsContext* MySQLParser::tablespaceOptions() {
  TablespaceOptionsContext *_localctx = _tracker.createInstance<TablespaceOptionsContext>(_ctx, getState());
  enterRule(_localctx, 132, MySQLParser::RuleTablespaceOptions);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    size_t alt;
    enterOuterAlt(_localctx, 1);
    setState(2231);
    tablespaceOption();
    setState(2238);
    _errHandler->sync(this);
    alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 159, _ctx);
    while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER) {
      if (alt == 1) {
        setState(2233);
        _errHandler->sync(this);

        switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 158, _ctx)) {
        case 1: {
          setState(2232);
          match(MySQLParser::COMMA_SYMBOL);
          break;
        }

        default:
          break;
        }
        setState(2235);
        tablespaceOption(); 
      }
      setState(2240);
      _errHandler->sync(this);
      alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 159, _ctx);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TablespaceOptionContext ------------------------------------------------------------------

MySQLParser::TablespaceOptionContext::TablespaceOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::TsOptionInitialSizeContext* MySQLParser::TablespaceOptionContext::tsOptionInitialSize() {
  return getRuleContext<MySQLParser::TsOptionInitialSizeContext>(0);
}

MySQLParser::TsOptionAutoextendSizeContext* MySQLParser::TablespaceOptionContext::tsOptionAutoextendSize() {
  return getRuleContext<MySQLParser::TsOptionAutoextendSizeContext>(0);
}

MySQLParser::TsOptionMaxSizeContext* MySQLParser::TablespaceOptionContext::tsOptionMaxSize() {
  return getRuleContext<MySQLParser::TsOptionMaxSizeContext>(0);
}

MySQLParser::TsOptionExtentSizeContext* MySQLParser::TablespaceOptionContext::tsOptionExtentSize() {
  return getRuleContext<MySQLParser::TsOptionExtentSizeContext>(0);
}

MySQLParser::TsOptionNodegroupContext* MySQLParser::TablespaceOptionContext::tsOptionNodegroup() {
  return getRuleContext<MySQLParser::TsOptionNodegroupContext>(0);
}

MySQLParser::TsOptionEngineContext* MySQLParser::TablespaceOptionContext::tsOptionEngine() {
  return getRuleContext<MySQLParser::TsOptionEngineContext>(0);
}

MySQLParser::TsOptionWaitContext* MySQLParser::TablespaceOptionContext::tsOptionWait() {
  return getRuleContext<MySQLParser::TsOptionWaitContext>(0);
}

MySQLParser::TsOptionCommentContext* MySQLParser::TablespaceOptionContext::tsOptionComment() {
  return getRuleContext<MySQLParser::TsOptionCommentContext>(0);
}

MySQLParser::TsOptionFileblockSizeContext* MySQLParser::TablespaceOptionContext::tsOptionFileblockSize() {
  return getRuleContext<MySQLParser::TsOptionFileblockSizeContext>(0);
}

MySQLParser::TsOptionEncryptionContext* MySQLParser::TablespaceOptionContext::tsOptionEncryption() {
  return getRuleContext<MySQLParser::TsOptionEncryptionContext>(0);
}


size_t MySQLParser::TablespaceOptionContext::getRuleIndex() const {
  return MySQLParser::RuleTablespaceOption;
}

void MySQLParser::TablespaceOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTablespaceOption(this);
}

void MySQLParser::TablespaceOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTablespaceOption(this);
}


std::any MySQLParser::TablespaceOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTablespaceOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TablespaceOptionContext* MySQLParser::tablespaceOption() {
  TablespaceOptionContext *_localctx = _tracker.createInstance<TablespaceOptionContext>(_ctx, getState());
  enterRule(_localctx, 134, MySQLParser::RuleTablespaceOption);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2253);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 160, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(2241);
      tsOptionInitialSize();
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(2242);
      tsOptionAutoextendSize();
      break;
    }

    case 3: {
      enterOuterAlt(_localctx, 3);
      setState(2243);
      tsOptionMaxSize();
      break;
    }

    case 4: {
      enterOuterAlt(_localctx, 4);
      setState(2244);
      tsOptionExtentSize();
      break;
    }

    case 5: {
      enterOuterAlt(_localctx, 5);
      setState(2245);
      tsOptionNodegroup();
      break;
    }

    case 6: {
      enterOuterAlt(_localctx, 6);
      setState(2246);
      tsOptionEngine();
      break;
    }

    case 7: {
      enterOuterAlt(_localctx, 7);
      setState(2247);
      tsOptionWait();
      break;
    }

    case 8: {
      enterOuterAlt(_localctx, 8);
      setState(2248);
      tsOptionComment();
      break;
    }

    case 9: {
      enterOuterAlt(_localctx, 9);
      setState(2249);

      if (!(serverVersion >= 50707)) throw FailedPredicateException(this, "serverVersion >= 50707");
      setState(2250);
      tsOptionFileblockSize();
      break;
    }

    case 10: {
      enterOuterAlt(_localctx, 10);
      setState(2251);

      if (!(serverVersion >= 80014)) throw FailedPredicateException(this, "serverVersion >= 80014");
      setState(2252);
      tsOptionEncryption();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TsOptionInitialSizeContext ------------------------------------------------------------------

MySQLParser::TsOptionInitialSizeContext::TsOptionInitialSizeContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::TsOptionInitialSizeContext::INITIAL_SIZE_SYMBOL() {
  return getToken(MySQLParser::INITIAL_SIZE_SYMBOL, 0);
}

MySQLParser::SizeNumberContext* MySQLParser::TsOptionInitialSizeContext::sizeNumber() {
  return getRuleContext<MySQLParser::SizeNumberContext>(0);
}

tree::TerminalNode* MySQLParser::TsOptionInitialSizeContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}


size_t MySQLParser::TsOptionInitialSizeContext::getRuleIndex() const {
  return MySQLParser::RuleTsOptionInitialSize;
}

void MySQLParser::TsOptionInitialSizeContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTsOptionInitialSize(this);
}

void MySQLParser::TsOptionInitialSizeContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTsOptionInitialSize(this);
}


std::any MySQLParser::TsOptionInitialSizeContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTsOptionInitialSize(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TsOptionInitialSizeContext* MySQLParser::tsOptionInitialSize() {
  TsOptionInitialSizeContext *_localctx = _tracker.createInstance<TsOptionInitialSizeContext>(_ctx, getState());
  enterRule(_localctx, 136, MySQLParser::RuleTsOptionInitialSize);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2255);
    match(MySQLParser::INITIAL_SIZE_SYMBOL);
    setState(2257);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 161, _ctx)) {
    case 1: {
      setState(2256);
      match(MySQLParser::EQUAL_OPERATOR);
      break;
    }

    default:
      break;
    }
    setState(2259);
    sizeNumber();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TsOptionUndoRedoBufferSizeContext ------------------------------------------------------------------

MySQLParser::TsOptionUndoRedoBufferSizeContext::TsOptionUndoRedoBufferSizeContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::SizeNumberContext* MySQLParser::TsOptionUndoRedoBufferSizeContext::sizeNumber() {
  return getRuleContext<MySQLParser::SizeNumberContext>(0);
}

tree::TerminalNode* MySQLParser::TsOptionUndoRedoBufferSizeContext::UNDO_BUFFER_SIZE_SYMBOL() {
  return getToken(MySQLParser::UNDO_BUFFER_SIZE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::TsOptionUndoRedoBufferSizeContext::REDO_BUFFER_SIZE_SYMBOL() {
  return getToken(MySQLParser::REDO_BUFFER_SIZE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::TsOptionUndoRedoBufferSizeContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}


size_t MySQLParser::TsOptionUndoRedoBufferSizeContext::getRuleIndex() const {
  return MySQLParser::RuleTsOptionUndoRedoBufferSize;
}

void MySQLParser::TsOptionUndoRedoBufferSizeContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTsOptionUndoRedoBufferSize(this);
}

void MySQLParser::TsOptionUndoRedoBufferSizeContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTsOptionUndoRedoBufferSize(this);
}


std::any MySQLParser::TsOptionUndoRedoBufferSizeContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTsOptionUndoRedoBufferSize(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TsOptionUndoRedoBufferSizeContext* MySQLParser::tsOptionUndoRedoBufferSize() {
  TsOptionUndoRedoBufferSizeContext *_localctx = _tracker.createInstance<TsOptionUndoRedoBufferSizeContext>(_ctx, getState());
  enterRule(_localctx, 138, MySQLParser::RuleTsOptionUndoRedoBufferSize);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2261);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::REDO_BUFFER_SIZE_SYMBOL || _la == MySQLParser::UNDO_BUFFER_SIZE_SYMBOL)) {
    _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
    setState(2263);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 162, _ctx)) {
    case 1: {
      setState(2262);
      match(MySQLParser::EQUAL_OPERATOR);
      break;
    }

    default:
      break;
    }
    setState(2265);
    sizeNumber();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TsOptionAutoextendSizeContext ------------------------------------------------------------------

MySQLParser::TsOptionAutoextendSizeContext::TsOptionAutoextendSizeContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::TsOptionAutoextendSizeContext::AUTOEXTEND_SIZE_SYMBOL() {
  return getToken(MySQLParser::AUTOEXTEND_SIZE_SYMBOL, 0);
}

MySQLParser::SizeNumberContext* MySQLParser::TsOptionAutoextendSizeContext::sizeNumber() {
  return getRuleContext<MySQLParser::SizeNumberContext>(0);
}

tree::TerminalNode* MySQLParser::TsOptionAutoextendSizeContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}


size_t MySQLParser::TsOptionAutoextendSizeContext::getRuleIndex() const {
  return MySQLParser::RuleTsOptionAutoextendSize;
}

void MySQLParser::TsOptionAutoextendSizeContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTsOptionAutoextendSize(this);
}

void MySQLParser::TsOptionAutoextendSizeContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTsOptionAutoextendSize(this);
}


std::any MySQLParser::TsOptionAutoextendSizeContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTsOptionAutoextendSize(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TsOptionAutoextendSizeContext* MySQLParser::tsOptionAutoextendSize() {
  TsOptionAutoextendSizeContext *_localctx = _tracker.createInstance<TsOptionAutoextendSizeContext>(_ctx, getState());
  enterRule(_localctx, 140, MySQLParser::RuleTsOptionAutoextendSize);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2267);
    match(MySQLParser::AUTOEXTEND_SIZE_SYMBOL);
    setState(2269);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 163, _ctx)) {
    case 1: {
      setState(2268);
      match(MySQLParser::EQUAL_OPERATOR);
      break;
    }

    default:
      break;
    }
    setState(2271);
    sizeNumber();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TsOptionMaxSizeContext ------------------------------------------------------------------

MySQLParser::TsOptionMaxSizeContext::TsOptionMaxSizeContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::TsOptionMaxSizeContext::MAX_SIZE_SYMBOL() {
  return getToken(MySQLParser::MAX_SIZE_SYMBOL, 0);
}

MySQLParser::SizeNumberContext* MySQLParser::TsOptionMaxSizeContext::sizeNumber() {
  return getRuleContext<MySQLParser::SizeNumberContext>(0);
}

tree::TerminalNode* MySQLParser::TsOptionMaxSizeContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}


size_t MySQLParser::TsOptionMaxSizeContext::getRuleIndex() const {
  return MySQLParser::RuleTsOptionMaxSize;
}

void MySQLParser::TsOptionMaxSizeContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTsOptionMaxSize(this);
}

void MySQLParser::TsOptionMaxSizeContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTsOptionMaxSize(this);
}


std::any MySQLParser::TsOptionMaxSizeContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTsOptionMaxSize(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TsOptionMaxSizeContext* MySQLParser::tsOptionMaxSize() {
  TsOptionMaxSizeContext *_localctx = _tracker.createInstance<TsOptionMaxSizeContext>(_ctx, getState());
  enterRule(_localctx, 142, MySQLParser::RuleTsOptionMaxSize);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2273);
    match(MySQLParser::MAX_SIZE_SYMBOL);
    setState(2275);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 164, _ctx)) {
    case 1: {
      setState(2274);
      match(MySQLParser::EQUAL_OPERATOR);
      break;
    }

    default:
      break;
    }
    setState(2277);
    sizeNumber();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TsOptionExtentSizeContext ------------------------------------------------------------------

MySQLParser::TsOptionExtentSizeContext::TsOptionExtentSizeContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::TsOptionExtentSizeContext::EXTENT_SIZE_SYMBOL() {
  return getToken(MySQLParser::EXTENT_SIZE_SYMBOL, 0);
}

MySQLParser::SizeNumberContext* MySQLParser::TsOptionExtentSizeContext::sizeNumber() {
  return getRuleContext<MySQLParser::SizeNumberContext>(0);
}

tree::TerminalNode* MySQLParser::TsOptionExtentSizeContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}


size_t MySQLParser::TsOptionExtentSizeContext::getRuleIndex() const {
  return MySQLParser::RuleTsOptionExtentSize;
}

void MySQLParser::TsOptionExtentSizeContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTsOptionExtentSize(this);
}

void MySQLParser::TsOptionExtentSizeContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTsOptionExtentSize(this);
}


std::any MySQLParser::TsOptionExtentSizeContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTsOptionExtentSize(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TsOptionExtentSizeContext* MySQLParser::tsOptionExtentSize() {
  TsOptionExtentSizeContext *_localctx = _tracker.createInstance<TsOptionExtentSizeContext>(_ctx, getState());
  enterRule(_localctx, 144, MySQLParser::RuleTsOptionExtentSize);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2279);
    match(MySQLParser::EXTENT_SIZE_SYMBOL);
    setState(2281);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 165, _ctx)) {
    case 1: {
      setState(2280);
      match(MySQLParser::EQUAL_OPERATOR);
      break;
    }

    default:
      break;
    }
    setState(2283);
    sizeNumber();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TsOptionNodegroupContext ------------------------------------------------------------------

MySQLParser::TsOptionNodegroupContext::TsOptionNodegroupContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::TsOptionNodegroupContext::NODEGROUP_SYMBOL() {
  return getToken(MySQLParser::NODEGROUP_SYMBOL, 0);
}

MySQLParser::Real_ulong_numberContext* MySQLParser::TsOptionNodegroupContext::real_ulong_number() {
  return getRuleContext<MySQLParser::Real_ulong_numberContext>(0);
}

tree::TerminalNode* MySQLParser::TsOptionNodegroupContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}


size_t MySQLParser::TsOptionNodegroupContext::getRuleIndex() const {
  return MySQLParser::RuleTsOptionNodegroup;
}

void MySQLParser::TsOptionNodegroupContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTsOptionNodegroup(this);
}

void MySQLParser::TsOptionNodegroupContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTsOptionNodegroup(this);
}


std::any MySQLParser::TsOptionNodegroupContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTsOptionNodegroup(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TsOptionNodegroupContext* MySQLParser::tsOptionNodegroup() {
  TsOptionNodegroupContext *_localctx = _tracker.createInstance<TsOptionNodegroupContext>(_ctx, getState());
  enterRule(_localctx, 146, MySQLParser::RuleTsOptionNodegroup);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2285);
    match(MySQLParser::NODEGROUP_SYMBOL);
    setState(2287);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::EQUAL_OPERATOR) {
      setState(2286);
      match(MySQLParser::EQUAL_OPERATOR);
    }
    setState(2289);
    real_ulong_number();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TsOptionEngineContext ------------------------------------------------------------------

MySQLParser::TsOptionEngineContext::TsOptionEngineContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::TsOptionEngineContext::ENGINE_SYMBOL() {
  return getToken(MySQLParser::ENGINE_SYMBOL, 0);
}

MySQLParser::EngineRefContext* MySQLParser::TsOptionEngineContext::engineRef() {
  return getRuleContext<MySQLParser::EngineRefContext>(0);
}

tree::TerminalNode* MySQLParser::TsOptionEngineContext::STORAGE_SYMBOL() {
  return getToken(MySQLParser::STORAGE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::TsOptionEngineContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}


size_t MySQLParser::TsOptionEngineContext::getRuleIndex() const {
  return MySQLParser::RuleTsOptionEngine;
}

void MySQLParser::TsOptionEngineContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTsOptionEngine(this);
}

void MySQLParser::TsOptionEngineContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTsOptionEngine(this);
}


std::any MySQLParser::TsOptionEngineContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTsOptionEngine(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TsOptionEngineContext* MySQLParser::tsOptionEngine() {
  TsOptionEngineContext *_localctx = _tracker.createInstance<TsOptionEngineContext>(_ctx, getState());
  enterRule(_localctx, 148, MySQLParser::RuleTsOptionEngine);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2292);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::STORAGE_SYMBOL) {
      setState(2291);
      match(MySQLParser::STORAGE_SYMBOL);
    }
    setState(2294);
    match(MySQLParser::ENGINE_SYMBOL);
    setState(2296);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 168, _ctx)) {
    case 1: {
      setState(2295);
      match(MySQLParser::EQUAL_OPERATOR);
      break;
    }

    default:
      break;
    }
    setState(2298);
    engineRef();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TsOptionWaitContext ------------------------------------------------------------------

MySQLParser::TsOptionWaitContext::TsOptionWaitContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::TsOptionWaitContext::WAIT_SYMBOL() {
  return getToken(MySQLParser::WAIT_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::TsOptionWaitContext::NO_WAIT_SYMBOL() {
  return getToken(MySQLParser::NO_WAIT_SYMBOL, 0);
}


size_t MySQLParser::TsOptionWaitContext::getRuleIndex() const {
  return MySQLParser::RuleTsOptionWait;
}

void MySQLParser::TsOptionWaitContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTsOptionWait(this);
}

void MySQLParser::TsOptionWaitContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTsOptionWait(this);
}


std::any MySQLParser::TsOptionWaitContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTsOptionWait(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TsOptionWaitContext* MySQLParser::tsOptionWait() {
  TsOptionWaitContext *_localctx = _tracker.createInstance<TsOptionWaitContext>(_ctx, getState());
  enterRule(_localctx, 150, MySQLParser::RuleTsOptionWait);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2300);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::NO_WAIT_SYMBOL || _la == MySQLParser::WAIT_SYMBOL)) {
    _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TsOptionCommentContext ------------------------------------------------------------------

MySQLParser::TsOptionCommentContext::TsOptionCommentContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::TsOptionCommentContext::COMMENT_SYMBOL() {
  return getToken(MySQLParser::COMMENT_SYMBOL, 0);
}

MySQLParser::TextLiteralContext* MySQLParser::TsOptionCommentContext::textLiteral() {
  return getRuleContext<MySQLParser::TextLiteralContext>(0);
}

tree::TerminalNode* MySQLParser::TsOptionCommentContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}


size_t MySQLParser::TsOptionCommentContext::getRuleIndex() const {
  return MySQLParser::RuleTsOptionComment;
}

void MySQLParser::TsOptionCommentContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTsOptionComment(this);
}

void MySQLParser::TsOptionCommentContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTsOptionComment(this);
}


std::any MySQLParser::TsOptionCommentContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTsOptionComment(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TsOptionCommentContext* MySQLParser::tsOptionComment() {
  TsOptionCommentContext *_localctx = _tracker.createInstance<TsOptionCommentContext>(_ctx, getState());
  enterRule(_localctx, 152, MySQLParser::RuleTsOptionComment);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2302);
    match(MySQLParser::COMMENT_SYMBOL);
    setState(2304);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 169, _ctx)) {
    case 1: {
      setState(2303);
      match(MySQLParser::EQUAL_OPERATOR);
      break;
    }

    default:
      break;
    }
    setState(2306);
    textLiteral();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TsOptionFileblockSizeContext ------------------------------------------------------------------

MySQLParser::TsOptionFileblockSizeContext::TsOptionFileblockSizeContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::TsOptionFileblockSizeContext::FILE_BLOCK_SIZE_SYMBOL() {
  return getToken(MySQLParser::FILE_BLOCK_SIZE_SYMBOL, 0);
}

MySQLParser::SizeNumberContext* MySQLParser::TsOptionFileblockSizeContext::sizeNumber() {
  return getRuleContext<MySQLParser::SizeNumberContext>(0);
}

tree::TerminalNode* MySQLParser::TsOptionFileblockSizeContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}


size_t MySQLParser::TsOptionFileblockSizeContext::getRuleIndex() const {
  return MySQLParser::RuleTsOptionFileblockSize;
}

void MySQLParser::TsOptionFileblockSizeContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTsOptionFileblockSize(this);
}

void MySQLParser::TsOptionFileblockSizeContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTsOptionFileblockSize(this);
}


std::any MySQLParser::TsOptionFileblockSizeContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTsOptionFileblockSize(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TsOptionFileblockSizeContext* MySQLParser::tsOptionFileblockSize() {
  TsOptionFileblockSizeContext *_localctx = _tracker.createInstance<TsOptionFileblockSizeContext>(_ctx, getState());
  enterRule(_localctx, 154, MySQLParser::RuleTsOptionFileblockSize);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2308);
    match(MySQLParser::FILE_BLOCK_SIZE_SYMBOL);
    setState(2310);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 170, _ctx)) {
    case 1: {
      setState(2309);
      match(MySQLParser::EQUAL_OPERATOR);
      break;
    }

    default:
      break;
    }
    setState(2312);
    sizeNumber();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TsOptionEncryptionContext ------------------------------------------------------------------

MySQLParser::TsOptionEncryptionContext::TsOptionEncryptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::TsOptionEncryptionContext::ENCRYPTION_SYMBOL() {
  return getToken(MySQLParser::ENCRYPTION_SYMBOL, 0);
}

MySQLParser::TextStringLiteralContext* MySQLParser::TsOptionEncryptionContext::textStringLiteral() {
  return getRuleContext<MySQLParser::TextStringLiteralContext>(0);
}

tree::TerminalNode* MySQLParser::TsOptionEncryptionContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}


size_t MySQLParser::TsOptionEncryptionContext::getRuleIndex() const {
  return MySQLParser::RuleTsOptionEncryption;
}

void MySQLParser::TsOptionEncryptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTsOptionEncryption(this);
}

void MySQLParser::TsOptionEncryptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTsOptionEncryption(this);
}


std::any MySQLParser::TsOptionEncryptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTsOptionEncryption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TsOptionEncryptionContext* MySQLParser::tsOptionEncryption() {
  TsOptionEncryptionContext *_localctx = _tracker.createInstance<TsOptionEncryptionContext>(_ctx, getState());
  enterRule(_localctx, 156, MySQLParser::RuleTsOptionEncryption);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2314);
    match(MySQLParser::ENCRYPTION_SYMBOL);
    setState(2316);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 171, _ctx)) {
    case 1: {
      setState(2315);
      match(MySQLParser::EQUAL_OPERATOR);
      break;
    }

    default:
      break;
    }
    setState(2318);
    textStringLiteral();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CreateViewContext ------------------------------------------------------------------

MySQLParser::CreateViewContext::CreateViewContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::CreateViewContext::VIEW_SYMBOL() {
  return getToken(MySQLParser::VIEW_SYMBOL, 0);
}

MySQLParser::ViewNameContext* MySQLParser::CreateViewContext::viewName() {
  return getRuleContext<MySQLParser::ViewNameContext>(0);
}

MySQLParser::ViewTailContext* MySQLParser::CreateViewContext::viewTail() {
  return getRuleContext<MySQLParser::ViewTailContext>(0);
}

MySQLParser::ViewReplaceOrAlgorithmContext* MySQLParser::CreateViewContext::viewReplaceOrAlgorithm() {
  return getRuleContext<MySQLParser::ViewReplaceOrAlgorithmContext>(0);
}

MySQLParser::DefinerClauseContext* MySQLParser::CreateViewContext::definerClause() {
  return getRuleContext<MySQLParser::DefinerClauseContext>(0);
}

MySQLParser::ViewSuidContext* MySQLParser::CreateViewContext::viewSuid() {
  return getRuleContext<MySQLParser::ViewSuidContext>(0);
}


size_t MySQLParser::CreateViewContext::getRuleIndex() const {
  return MySQLParser::RuleCreateView;
}

void MySQLParser::CreateViewContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCreateView(this);
}

void MySQLParser::CreateViewContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCreateView(this);
}


std::any MySQLParser::CreateViewContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCreateView(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CreateViewContext* MySQLParser::createView() {
  CreateViewContext *_localctx = _tracker.createInstance<CreateViewContext>(_ctx, getState());
  enterRule(_localctx, 158, MySQLParser::RuleCreateView);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2321);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::ALGORITHM_SYMBOL || _la == MySQLParser::OR_SYMBOL) {
      setState(2320);
      viewReplaceOrAlgorithm();
    }
    setState(2324);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::DEFINER_SYMBOL) {
      setState(2323);
      definerClause();
    }
    setState(2327);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::SQL_SYMBOL) {
      setState(2326);
      viewSuid();
    }
    setState(2329);
    match(MySQLParser::VIEW_SYMBOL);
    setState(2330);
    viewName();
    setState(2331);
    viewTail();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- ViewReplaceOrAlgorithmContext ------------------------------------------------------------------

MySQLParser::ViewReplaceOrAlgorithmContext::ViewReplaceOrAlgorithmContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::ViewReplaceOrAlgorithmContext::OR_SYMBOL() {
  return getToken(MySQLParser::OR_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ViewReplaceOrAlgorithmContext::REPLACE_SYMBOL() {
  return getToken(MySQLParser::REPLACE_SYMBOL, 0);
}

MySQLParser::ViewAlgorithmContext* MySQLParser::ViewReplaceOrAlgorithmContext::viewAlgorithm() {
  return getRuleContext<MySQLParser::ViewAlgorithmContext>(0);
}


size_t MySQLParser::ViewReplaceOrAlgorithmContext::getRuleIndex() const {
  return MySQLParser::RuleViewReplaceOrAlgorithm;
}

void MySQLParser::ViewReplaceOrAlgorithmContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterViewReplaceOrAlgorithm(this);
}

void MySQLParser::ViewReplaceOrAlgorithmContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitViewReplaceOrAlgorithm(this);
}


std::any MySQLParser::ViewReplaceOrAlgorithmContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitViewReplaceOrAlgorithm(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::ViewReplaceOrAlgorithmContext* MySQLParser::viewReplaceOrAlgorithm() {
  ViewReplaceOrAlgorithmContext *_localctx = _tracker.createInstance<ViewReplaceOrAlgorithmContext>(_ctx, getState());
  enterRule(_localctx, 160, MySQLParser::RuleViewReplaceOrAlgorithm);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2339);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::OR_SYMBOL: {
        enterOuterAlt(_localctx, 1);
        setState(2333);
        match(MySQLParser::OR_SYMBOL);
        setState(2334);
        match(MySQLParser::REPLACE_SYMBOL);
        setState(2336);
        _errHandler->sync(this);

        _la = _input->LA(1);
        if (_la == MySQLParser::ALGORITHM_SYMBOL) {
          setState(2335);
          viewAlgorithm();
        }
        break;
      }

      case MySQLParser::ALGORITHM_SYMBOL: {
        enterOuterAlt(_localctx, 2);
        setState(2338);
        viewAlgorithm();
        break;
      }

    default:
      throw NoViableAltException(this);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- ViewAlgorithmContext ------------------------------------------------------------------

MySQLParser::ViewAlgorithmContext::ViewAlgorithmContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::ViewAlgorithmContext::ALGORITHM_SYMBOL() {
  return getToken(MySQLParser::ALGORITHM_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ViewAlgorithmContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}

tree::TerminalNode* MySQLParser::ViewAlgorithmContext::UNDEFINED_SYMBOL() {
  return getToken(MySQLParser::UNDEFINED_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ViewAlgorithmContext::MERGE_SYMBOL() {
  return getToken(MySQLParser::MERGE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ViewAlgorithmContext::TEMPTABLE_SYMBOL() {
  return getToken(MySQLParser::TEMPTABLE_SYMBOL, 0);
}


size_t MySQLParser::ViewAlgorithmContext::getRuleIndex() const {
  return MySQLParser::RuleViewAlgorithm;
}

void MySQLParser::ViewAlgorithmContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterViewAlgorithm(this);
}

void MySQLParser::ViewAlgorithmContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitViewAlgorithm(this);
}


std::any MySQLParser::ViewAlgorithmContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitViewAlgorithm(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::ViewAlgorithmContext* MySQLParser::viewAlgorithm() {
  ViewAlgorithmContext *_localctx = _tracker.createInstance<ViewAlgorithmContext>(_ctx, getState());
  enterRule(_localctx, 162, MySQLParser::RuleViewAlgorithm);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2341);
    match(MySQLParser::ALGORITHM_SYMBOL);
    setState(2342);
    match(MySQLParser::EQUAL_OPERATOR);
    setState(2343);
    antlrcpp::downCast<ViewAlgorithmContext *>(_localctx)->algorithm = _input->LT(1);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::MERGE_SYMBOL || _la == MySQLParser::TEMPTABLE_SYMBOL

    || _la == MySQLParser::UNDEFINED_SYMBOL)) {
      antlrcpp::downCast<ViewAlgorithmContext *>(_localctx)->algorithm = _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- ViewSuidContext ------------------------------------------------------------------

MySQLParser::ViewSuidContext::ViewSuidContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::ViewSuidContext::SQL_SYMBOL() {
  return getToken(MySQLParser::SQL_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ViewSuidContext::SECURITY_SYMBOL() {
  return getToken(MySQLParser::SECURITY_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ViewSuidContext::DEFINER_SYMBOL() {
  return getToken(MySQLParser::DEFINER_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ViewSuidContext::INVOKER_SYMBOL() {
  return getToken(MySQLParser::INVOKER_SYMBOL, 0);
}


size_t MySQLParser::ViewSuidContext::getRuleIndex() const {
  return MySQLParser::RuleViewSuid;
}

void MySQLParser::ViewSuidContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterViewSuid(this);
}

void MySQLParser::ViewSuidContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitViewSuid(this);
}


std::any MySQLParser::ViewSuidContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitViewSuid(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::ViewSuidContext* MySQLParser::viewSuid() {
  ViewSuidContext *_localctx = _tracker.createInstance<ViewSuidContext>(_ctx, getState());
  enterRule(_localctx, 164, MySQLParser::RuleViewSuid);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2345);
    match(MySQLParser::SQL_SYMBOL);
    setState(2346);
    match(MySQLParser::SECURITY_SYMBOL);
    setState(2347);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::DEFINER_SYMBOL || _la == MySQLParser::INVOKER_SYMBOL)) {
    _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CreateTriggerContext ------------------------------------------------------------------

MySQLParser::CreateTriggerContext::CreateTriggerContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::CreateTriggerContext::TRIGGER_SYMBOL() {
  return getToken(MySQLParser::TRIGGER_SYMBOL, 0);
}

MySQLParser::TriggerNameContext* MySQLParser::CreateTriggerContext::triggerName() {
  return getRuleContext<MySQLParser::TriggerNameContext>(0);
}

tree::TerminalNode* MySQLParser::CreateTriggerContext::ON_SYMBOL() {
  return getToken(MySQLParser::ON_SYMBOL, 0);
}

MySQLParser::TableRefContext* MySQLParser::CreateTriggerContext::tableRef() {
  return getRuleContext<MySQLParser::TableRefContext>(0);
}

tree::TerminalNode* MySQLParser::CreateTriggerContext::FOR_SYMBOL() {
  return getToken(MySQLParser::FOR_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateTriggerContext::EACH_SYMBOL() {
  return getToken(MySQLParser::EACH_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateTriggerContext::ROW_SYMBOL() {
  return getToken(MySQLParser::ROW_SYMBOL, 0);
}

MySQLParser::CompoundStatementContext* MySQLParser::CreateTriggerContext::compoundStatement() {
  return getRuleContext<MySQLParser::CompoundStatementContext>(0);
}

tree::TerminalNode* MySQLParser::CreateTriggerContext::BEFORE_SYMBOL() {
  return getToken(MySQLParser::BEFORE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateTriggerContext::AFTER_SYMBOL() {
  return getToken(MySQLParser::AFTER_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateTriggerContext::INSERT_SYMBOL() {
  return getToken(MySQLParser::INSERT_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateTriggerContext::UPDATE_SYMBOL() {
  return getToken(MySQLParser::UPDATE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateTriggerContext::DELETE_SYMBOL() {
  return getToken(MySQLParser::DELETE_SYMBOL, 0);
}

MySQLParser::DefinerClauseContext* MySQLParser::CreateTriggerContext::definerClause() {
  return getRuleContext<MySQLParser::DefinerClauseContext>(0);
}

MySQLParser::TriggerFollowsPrecedesClauseContext* MySQLParser::CreateTriggerContext::triggerFollowsPrecedesClause() {
  return getRuleContext<MySQLParser::TriggerFollowsPrecedesClauseContext>(0);
}


size_t MySQLParser::CreateTriggerContext::getRuleIndex() const {
  return MySQLParser::RuleCreateTrigger;
}

void MySQLParser::CreateTriggerContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCreateTrigger(this);
}

void MySQLParser::CreateTriggerContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCreateTrigger(this);
}


std::any MySQLParser::CreateTriggerContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCreateTrigger(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CreateTriggerContext* MySQLParser::createTrigger() {
  CreateTriggerContext *_localctx = _tracker.createInstance<CreateTriggerContext>(_ctx, getState());
  enterRule(_localctx, 166, MySQLParser::RuleCreateTrigger);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2350);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::DEFINER_SYMBOL) {
      setState(2349);
      definerClause();
    }
    setState(2352);
    match(MySQLParser::TRIGGER_SYMBOL);
    setState(2353);
    triggerName();
    setState(2354);
    antlrcpp::downCast<CreateTriggerContext *>(_localctx)->timing = _input->LT(1);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::AFTER_SYMBOL

    || _la == MySQLParser::BEFORE_SYMBOL)) {
      antlrcpp::downCast<CreateTriggerContext *>(_localctx)->timing = _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
    setState(2355);
    antlrcpp::downCast<CreateTriggerContext *>(_localctx)->event = _input->LT(1);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::DELETE_SYMBOL || _la == MySQLParser::INSERT_SYMBOL || _la == MySQLParser::UPDATE_SYMBOL)) {
      antlrcpp::downCast<CreateTriggerContext *>(_localctx)->event = _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
    setState(2356);
    match(MySQLParser::ON_SYMBOL);
    setState(2357);
    tableRef();
    setState(2358);
    match(MySQLParser::FOR_SYMBOL);
    setState(2359);
    match(MySQLParser::EACH_SYMBOL);
    setState(2360);
    match(MySQLParser::ROW_SYMBOL);
    setState(2362);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 178, _ctx)) {
    case 1: {
      setState(2361);
      triggerFollowsPrecedesClause();
      break;
    }

    default:
      break;
    }
    setState(2364);
    compoundStatement();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TriggerFollowsPrecedesClauseContext ------------------------------------------------------------------

MySQLParser::TriggerFollowsPrecedesClauseContext::TriggerFollowsPrecedesClauseContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::TextOrIdentifierContext* MySQLParser::TriggerFollowsPrecedesClauseContext::textOrIdentifier() {
  return getRuleContext<MySQLParser::TextOrIdentifierContext>(0);
}

tree::TerminalNode* MySQLParser::TriggerFollowsPrecedesClauseContext::FOLLOWS_SYMBOL() {
  return getToken(MySQLParser::FOLLOWS_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::TriggerFollowsPrecedesClauseContext::PRECEDES_SYMBOL() {
  return getToken(MySQLParser::PRECEDES_SYMBOL, 0);
}


size_t MySQLParser::TriggerFollowsPrecedesClauseContext::getRuleIndex() const {
  return MySQLParser::RuleTriggerFollowsPrecedesClause;
}

void MySQLParser::TriggerFollowsPrecedesClauseContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTriggerFollowsPrecedesClause(this);
}

void MySQLParser::TriggerFollowsPrecedesClauseContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTriggerFollowsPrecedesClause(this);
}


std::any MySQLParser::TriggerFollowsPrecedesClauseContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTriggerFollowsPrecedesClause(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TriggerFollowsPrecedesClauseContext* MySQLParser::triggerFollowsPrecedesClause() {
  TriggerFollowsPrecedesClauseContext *_localctx = _tracker.createInstance<TriggerFollowsPrecedesClauseContext>(_ctx, getState());
  enterRule(_localctx, 168, MySQLParser::RuleTriggerFollowsPrecedesClause);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2366);

    if (!(serverVersion >= 50700)) throw FailedPredicateException(this, "serverVersion >= 50700");
    setState(2367);
    antlrcpp::downCast<TriggerFollowsPrecedesClauseContext *>(_localctx)->ordering = _input->LT(1);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::FOLLOWS_SYMBOL || _la == MySQLParser::PRECEDES_SYMBOL)) {
      antlrcpp::downCast<TriggerFollowsPrecedesClauseContext *>(_localctx)->ordering = _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
    setState(2368);
    textOrIdentifier();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CreateEventContext ------------------------------------------------------------------

MySQLParser::CreateEventContext::CreateEventContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::CreateEventContext::EVENT_SYMBOL() {
  return getToken(MySQLParser::EVENT_SYMBOL, 0);
}

MySQLParser::EventNameContext* MySQLParser::CreateEventContext::eventName() {
  return getRuleContext<MySQLParser::EventNameContext>(0);
}

std::vector<tree::TerminalNode *> MySQLParser::CreateEventContext::ON_SYMBOL() {
  return getTokens(MySQLParser::ON_SYMBOL);
}

tree::TerminalNode* MySQLParser::CreateEventContext::ON_SYMBOL(size_t i) {
  return getToken(MySQLParser::ON_SYMBOL, i);
}

tree::TerminalNode* MySQLParser::CreateEventContext::SCHEDULE_SYMBOL() {
  return getToken(MySQLParser::SCHEDULE_SYMBOL, 0);
}

MySQLParser::ScheduleContext* MySQLParser::CreateEventContext::schedule() {
  return getRuleContext<MySQLParser::ScheduleContext>(0);
}

tree::TerminalNode* MySQLParser::CreateEventContext::DO_SYMBOL() {
  return getToken(MySQLParser::DO_SYMBOL, 0);
}

MySQLParser::CompoundStatementContext* MySQLParser::CreateEventContext::compoundStatement() {
  return getRuleContext<MySQLParser::CompoundStatementContext>(0);
}

MySQLParser::DefinerClauseContext* MySQLParser::CreateEventContext::definerClause() {
  return getRuleContext<MySQLParser::DefinerClauseContext>(0);
}

MySQLParser::IfNotExistsContext* MySQLParser::CreateEventContext::ifNotExists() {
  return getRuleContext<MySQLParser::IfNotExistsContext>(0);
}

tree::TerminalNode* MySQLParser::CreateEventContext::COMPLETION_SYMBOL() {
  return getToken(MySQLParser::COMPLETION_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateEventContext::PRESERVE_SYMBOL() {
  return getToken(MySQLParser::PRESERVE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateEventContext::ENABLE_SYMBOL() {
  return getToken(MySQLParser::ENABLE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateEventContext::DISABLE_SYMBOL() {
  return getToken(MySQLParser::DISABLE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateEventContext::COMMENT_SYMBOL() {
  return getToken(MySQLParser::COMMENT_SYMBOL, 0);
}

MySQLParser::TextLiteralContext* MySQLParser::CreateEventContext::textLiteral() {
  return getRuleContext<MySQLParser::TextLiteralContext>(0);
}

tree::TerminalNode* MySQLParser::CreateEventContext::NOT_SYMBOL() {
  return getToken(MySQLParser::NOT_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateEventContext::SLAVE_SYMBOL() {
  return getToken(MySQLParser::SLAVE_SYMBOL, 0);
}


size_t MySQLParser::CreateEventContext::getRuleIndex() const {
  return MySQLParser::RuleCreateEvent;
}

void MySQLParser::CreateEventContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCreateEvent(this);
}

void MySQLParser::CreateEventContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCreateEvent(this);
}


std::any MySQLParser::CreateEventContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCreateEvent(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CreateEventContext* MySQLParser::createEvent() {
  CreateEventContext *_localctx = _tracker.createInstance<CreateEventContext>(_ctx, getState());
  enterRule(_localctx, 170, MySQLParser::RuleCreateEvent);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2371);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::DEFINER_SYMBOL) {
      setState(2370);
      definerClause();
    }
    setState(2373);
    match(MySQLParser::EVENT_SYMBOL);
    setState(2375);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 180, _ctx)) {
    case 1: {
      setState(2374);
      ifNotExists();
      break;
    }

    default:
      break;
    }
    setState(2377);
    eventName();
    setState(2378);
    match(MySQLParser::ON_SYMBOL);
    setState(2379);
    match(MySQLParser::SCHEDULE_SYMBOL);
    setState(2380);
    schedule();
    setState(2387);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::ON_SYMBOL) {
      setState(2381);
      match(MySQLParser::ON_SYMBOL);
      setState(2382);
      match(MySQLParser::COMPLETION_SYMBOL);
      setState(2384);
      _errHandler->sync(this);

      _la = _input->LA(1);
      if (_la == MySQLParser::NOT_SYMBOL) {
        setState(2383);
        match(MySQLParser::NOT_SYMBOL);
      }
      setState(2386);
      match(MySQLParser::PRESERVE_SYMBOL);
    }
    setState(2395);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::ENABLE_SYMBOL: {
        setState(2389);
        match(MySQLParser::ENABLE_SYMBOL);
        break;
      }

      case MySQLParser::DISABLE_SYMBOL: {
        setState(2390);
        match(MySQLParser::DISABLE_SYMBOL);
        setState(2393);
        _errHandler->sync(this);

        _la = _input->LA(1);
        if (_la == MySQLParser::ON_SYMBOL) {
          setState(2391);
          match(MySQLParser::ON_SYMBOL);
          setState(2392);
          match(MySQLParser::SLAVE_SYMBOL);
        }
        break;
      }

      case MySQLParser::COMMENT_SYMBOL:
      case MySQLParser::DO_SYMBOL: {
        break;
      }

    default:
      break;
    }
    setState(2399);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::COMMENT_SYMBOL) {
      setState(2397);
      match(MySQLParser::COMMENT_SYMBOL);
      setState(2398);
      textLiteral();
    }
    setState(2401);
    match(MySQLParser::DO_SYMBOL);
    setState(2402);
    compoundStatement();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CreateRoleContext ------------------------------------------------------------------

MySQLParser::CreateRoleContext::CreateRoleContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::CreateRoleContext::ROLE_SYMBOL() {
  return getToken(MySQLParser::ROLE_SYMBOL, 0);
}

MySQLParser::RoleListContext* MySQLParser::CreateRoleContext::roleList() {
  return getRuleContext<MySQLParser::RoleListContext>(0);
}

MySQLParser::IfNotExistsContext* MySQLParser::CreateRoleContext::ifNotExists() {
  return getRuleContext<MySQLParser::IfNotExistsContext>(0);
}


size_t MySQLParser::CreateRoleContext::getRuleIndex() const {
  return MySQLParser::RuleCreateRole;
}

void MySQLParser::CreateRoleContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCreateRole(this);
}

void MySQLParser::CreateRoleContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCreateRole(this);
}


std::any MySQLParser::CreateRoleContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCreateRole(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CreateRoleContext* MySQLParser::createRole() {
  CreateRoleContext *_localctx = _tracker.createInstance<CreateRoleContext>(_ctx, getState());
  enterRule(_localctx, 172, MySQLParser::RuleCreateRole);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2404);
    match(MySQLParser::ROLE_SYMBOL);
    setState(2406);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 186, _ctx)) {
    case 1: {
      setState(2405);
      ifNotExists();
      break;
    }

    default:
      break;
    }
    setState(2408);
    roleList();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CreateSpatialReferenceContext ------------------------------------------------------------------

MySQLParser::CreateSpatialReferenceContext::CreateSpatialReferenceContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::CreateSpatialReferenceContext::OR_SYMBOL() {
  return getToken(MySQLParser::OR_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateSpatialReferenceContext::REPLACE_SYMBOL() {
  return getToken(MySQLParser::REPLACE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateSpatialReferenceContext::SPATIAL_SYMBOL() {
  return getToken(MySQLParser::SPATIAL_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateSpatialReferenceContext::REFERENCE_SYMBOL() {
  return getToken(MySQLParser::REFERENCE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CreateSpatialReferenceContext::SYSTEM_SYMBOL() {
  return getToken(MySQLParser::SYSTEM_SYMBOL, 0);
}

MySQLParser::Real_ulonglong_numberContext* MySQLParser::CreateSpatialReferenceContext::real_ulonglong_number() {
  return getRuleContext<MySQLParser::Real_ulonglong_numberContext>(0);
}

std::vector<MySQLParser::SrsAttributeContext *> MySQLParser::CreateSpatialReferenceContext::srsAttribute() {
  return getRuleContexts<MySQLParser::SrsAttributeContext>();
}

MySQLParser::SrsAttributeContext* MySQLParser::CreateSpatialReferenceContext::srsAttribute(size_t i) {
  return getRuleContext<MySQLParser::SrsAttributeContext>(i);
}

MySQLParser::IfNotExistsContext* MySQLParser::CreateSpatialReferenceContext::ifNotExists() {
  return getRuleContext<MySQLParser::IfNotExistsContext>(0);
}


size_t MySQLParser::CreateSpatialReferenceContext::getRuleIndex() const {
  return MySQLParser::RuleCreateSpatialReference;
}

void MySQLParser::CreateSpatialReferenceContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCreateSpatialReference(this);
}

void MySQLParser::CreateSpatialReferenceContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCreateSpatialReference(this);
}


std::any MySQLParser::CreateSpatialReferenceContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCreateSpatialReference(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CreateSpatialReferenceContext* MySQLParser::createSpatialReference() {
  CreateSpatialReferenceContext *_localctx = _tracker.createInstance<CreateSpatialReferenceContext>(_ctx, getState());
  enterRule(_localctx, 174, MySQLParser::RuleCreateSpatialReference);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2435);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::OR_SYMBOL: {
        enterOuterAlt(_localctx, 1);
        setState(2410);
        match(MySQLParser::OR_SYMBOL);
        setState(2411);
        match(MySQLParser::REPLACE_SYMBOL);
        setState(2412);
        match(MySQLParser::SPATIAL_SYMBOL);
        setState(2413);
        match(MySQLParser::REFERENCE_SYMBOL);
        setState(2414);
        match(MySQLParser::SYSTEM_SYMBOL);
        setState(2415);
        real_ulonglong_number();
        setState(2419);
        _errHandler->sync(this);
        _la = _input->LA(1);
        while (_la == MySQLParser::NAME_SYMBOL || ((((_la - 715) & ~ 0x3fULL) == 0) &&
          ((1ULL << (_la - 715)) & 7) != 0)) {
          setState(2416);
          srsAttribute();
          setState(2421);
          _errHandler->sync(this);
          _la = _input->LA(1);
        }
        break;
      }

      case MySQLParser::SPATIAL_SYMBOL: {
        enterOuterAlt(_localctx, 2);
        setState(2422);
        match(MySQLParser::SPATIAL_SYMBOL);
        setState(2423);
        match(MySQLParser::REFERENCE_SYMBOL);
        setState(2424);
        match(MySQLParser::SYSTEM_SYMBOL);
        setState(2426);
        _errHandler->sync(this);

        switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 188, _ctx)) {
        case 1: {
          setState(2425);
          ifNotExists();
          break;
        }

        default:
          break;
        }
        setState(2428);
        real_ulonglong_number();
        setState(2432);
        _errHandler->sync(this);
        _la = _input->LA(1);
        while (_la == MySQLParser::NAME_SYMBOL || ((((_la - 715) & ~ 0x3fULL) == 0) &&
          ((1ULL << (_la - 715)) & 7) != 0)) {
          setState(2429);
          srsAttribute();
          setState(2434);
          _errHandler->sync(this);
          _la = _input->LA(1);
        }
        break;
      }

    default:
      throw NoViableAltException(this);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- SrsAttributeContext ------------------------------------------------------------------

MySQLParser::SrsAttributeContext::SrsAttributeContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::SrsAttributeContext::NAME_SYMBOL() {
  return getToken(MySQLParser::NAME_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::SrsAttributeContext::TEXT_SYMBOL() {
  return getToken(MySQLParser::TEXT_SYMBOL, 0);
}

MySQLParser::TextStringNoLinebreakContext* MySQLParser::SrsAttributeContext::textStringNoLinebreak() {
  return getRuleContext<MySQLParser::TextStringNoLinebreakContext>(0);
}

tree::TerminalNode* MySQLParser::SrsAttributeContext::DEFINITION_SYMBOL() {
  return getToken(MySQLParser::DEFINITION_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::SrsAttributeContext::ORGANIZATION_SYMBOL() {
  return getToken(MySQLParser::ORGANIZATION_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::SrsAttributeContext::IDENTIFIED_SYMBOL() {
  return getToken(MySQLParser::IDENTIFIED_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::SrsAttributeContext::BY_SYMBOL() {
  return getToken(MySQLParser::BY_SYMBOL, 0);
}

MySQLParser::Real_ulonglong_numberContext* MySQLParser::SrsAttributeContext::real_ulonglong_number() {
  return getRuleContext<MySQLParser::Real_ulonglong_numberContext>(0);
}

tree::TerminalNode* MySQLParser::SrsAttributeContext::DESCRIPTION_SYMBOL() {
  return getToken(MySQLParser::DESCRIPTION_SYMBOL, 0);
}


size_t MySQLParser::SrsAttributeContext::getRuleIndex() const {
  return MySQLParser::RuleSrsAttribute;
}

void MySQLParser::SrsAttributeContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterSrsAttribute(this);
}

void MySQLParser::SrsAttributeContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitSrsAttribute(this);
}


std::any MySQLParser::SrsAttributeContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitSrsAttribute(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::SrsAttributeContext* MySQLParser::srsAttribute() {
  SrsAttributeContext *_localctx = _tracker.createInstance<SrsAttributeContext>(_ctx, getState());
  enterRule(_localctx, 176, MySQLParser::RuleSrsAttribute);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2452);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::NAME_SYMBOL: {
        enterOuterAlt(_localctx, 1);
        setState(2437);
        match(MySQLParser::NAME_SYMBOL);
        setState(2438);
        match(MySQLParser::TEXT_SYMBOL);
        setState(2439);
        textStringNoLinebreak();
        break;
      }

      case MySQLParser::DEFINITION_SYMBOL: {
        enterOuterAlt(_localctx, 2);
        setState(2440);
        match(MySQLParser::DEFINITION_SYMBOL);
        setState(2441);
        match(MySQLParser::TEXT_SYMBOL);
        setState(2442);
        textStringNoLinebreak();
        break;
      }

      case MySQLParser::ORGANIZATION_SYMBOL: {
        enterOuterAlt(_localctx, 3);
        setState(2443);
        match(MySQLParser::ORGANIZATION_SYMBOL);
        setState(2444);
        textStringNoLinebreak();
        setState(2445);
        match(MySQLParser::IDENTIFIED_SYMBOL);
        setState(2446);
        match(MySQLParser::BY_SYMBOL);
        setState(2447);
        real_ulonglong_number();
        break;
      }

      case MySQLParser::DESCRIPTION_SYMBOL: {
        enterOuterAlt(_localctx, 4);
        setState(2449);
        match(MySQLParser::DESCRIPTION_SYMBOL);
        setState(2450);
        match(MySQLParser::TEXT_SYMBOL);
        setState(2451);
        textStringNoLinebreak();
        break;
      }

    default:
      throw NoViableAltException(this);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DropStatementContext ------------------------------------------------------------------

MySQLParser::DropStatementContext::DropStatementContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::DropStatementContext::DROP_SYMBOL() {
  return getToken(MySQLParser::DROP_SYMBOL, 0);
}

MySQLParser::DropDatabaseContext* MySQLParser::DropStatementContext::dropDatabase() {
  return getRuleContext<MySQLParser::DropDatabaseContext>(0);
}

MySQLParser::DropEventContext* MySQLParser::DropStatementContext::dropEvent() {
  return getRuleContext<MySQLParser::DropEventContext>(0);
}

MySQLParser::DropFunctionContext* MySQLParser::DropStatementContext::dropFunction() {
  return getRuleContext<MySQLParser::DropFunctionContext>(0);
}

MySQLParser::DropProcedureContext* MySQLParser::DropStatementContext::dropProcedure() {
  return getRuleContext<MySQLParser::DropProcedureContext>(0);
}

MySQLParser::DropIndexContext* MySQLParser::DropStatementContext::dropIndex() {
  return getRuleContext<MySQLParser::DropIndexContext>(0);
}

MySQLParser::DropLogfileGroupContext* MySQLParser::DropStatementContext::dropLogfileGroup() {
  return getRuleContext<MySQLParser::DropLogfileGroupContext>(0);
}

MySQLParser::DropServerContext* MySQLParser::DropStatementContext::dropServer() {
  return getRuleContext<MySQLParser::DropServerContext>(0);
}

MySQLParser::DropTableContext* MySQLParser::DropStatementContext::dropTable() {
  return getRuleContext<MySQLParser::DropTableContext>(0);
}

MySQLParser::DropTableSpaceContext* MySQLParser::DropStatementContext::dropTableSpace() {
  return getRuleContext<MySQLParser::DropTableSpaceContext>(0);
}

MySQLParser::DropTriggerContext* MySQLParser::DropStatementContext::dropTrigger() {
  return getRuleContext<MySQLParser::DropTriggerContext>(0);
}

MySQLParser::DropViewContext* MySQLParser::DropStatementContext::dropView() {
  return getRuleContext<MySQLParser::DropViewContext>(0);
}

MySQLParser::DropRoleContext* MySQLParser::DropStatementContext::dropRole() {
  return getRuleContext<MySQLParser::DropRoleContext>(0);
}

MySQLParser::DropSpatialReferenceContext* MySQLParser::DropStatementContext::dropSpatialReference() {
  return getRuleContext<MySQLParser::DropSpatialReferenceContext>(0);
}

MySQLParser::DropUndoTablespaceContext* MySQLParser::DropStatementContext::dropUndoTablespace() {
  return getRuleContext<MySQLParser::DropUndoTablespaceContext>(0);
}


size_t MySQLParser::DropStatementContext::getRuleIndex() const {
  return MySQLParser::RuleDropStatement;
}

void MySQLParser::DropStatementContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDropStatement(this);
}

void MySQLParser::DropStatementContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDropStatement(this);
}


std::any MySQLParser::DropStatementContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDropStatement(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DropStatementContext* MySQLParser::dropStatement() {
  DropStatementContext *_localctx = _tracker.createInstance<DropStatementContext>(_ctx, getState());
  enterRule(_localctx, 178, MySQLParser::RuleDropStatement);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2454);
    match(MySQLParser::DROP_SYMBOL);
    setState(2472);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 192, _ctx)) {
    case 1: {
      setState(2455);
      dropDatabase();
      break;
    }

    case 2: {
      setState(2456);
      dropEvent();
      break;
    }

    case 3: {
      setState(2457);
      dropFunction();
      break;
    }

    case 4: {
      setState(2458);
      dropProcedure();
      break;
    }

    case 5: {
      setState(2459);
      dropIndex();
      break;
    }

    case 6: {
      setState(2460);
      dropLogfileGroup();
      break;
    }

    case 7: {
      setState(2461);
      dropServer();
      break;
    }

    case 8: {
      setState(2462);
      dropTable();
      break;
    }

    case 9: {
      setState(2463);
      dropTableSpace();
      break;
    }

    case 10: {
      setState(2464);
      dropTrigger();
      break;
    }

    case 11: {
      setState(2465);
      dropView();
      break;
    }

    case 12: {
      setState(2466);

      if (!(serverVersion >= 80000)) throw FailedPredicateException(this, "serverVersion >= 80000");
      setState(2467);
      dropRole();
      break;
    }

    case 13: {
      setState(2468);

      if (!(serverVersion >= 80011)) throw FailedPredicateException(this, "serverVersion >= 80011");
      setState(2469);
      dropSpatialReference();
      break;
    }

    case 14: {
      setState(2470);

      if (!(serverVersion >= 80014)) throw FailedPredicateException(this, "serverVersion >= 80014");
      setState(2471);
      dropUndoTablespace();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DropDatabaseContext ------------------------------------------------------------------

MySQLParser::DropDatabaseContext::DropDatabaseContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::DropDatabaseContext::DATABASE_SYMBOL() {
  return getToken(MySQLParser::DATABASE_SYMBOL, 0);
}

MySQLParser::SchemaRefContext* MySQLParser::DropDatabaseContext::schemaRef() {
  return getRuleContext<MySQLParser::SchemaRefContext>(0);
}

MySQLParser::IfExistsContext* MySQLParser::DropDatabaseContext::ifExists() {
  return getRuleContext<MySQLParser::IfExistsContext>(0);
}


size_t MySQLParser::DropDatabaseContext::getRuleIndex() const {
  return MySQLParser::RuleDropDatabase;
}

void MySQLParser::DropDatabaseContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDropDatabase(this);
}

void MySQLParser::DropDatabaseContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDropDatabase(this);
}


std::any MySQLParser::DropDatabaseContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDropDatabase(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DropDatabaseContext* MySQLParser::dropDatabase() {
  DropDatabaseContext *_localctx = _tracker.createInstance<DropDatabaseContext>(_ctx, getState());
  enterRule(_localctx, 180, MySQLParser::RuleDropDatabase);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2474);
    match(MySQLParser::DATABASE_SYMBOL);
    setState(2476);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 193, _ctx)) {
    case 1: {
      setState(2475);
      ifExists();
      break;
    }

    default:
      break;
    }
    setState(2478);
    schemaRef();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DropEventContext ------------------------------------------------------------------

MySQLParser::DropEventContext::DropEventContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::DropEventContext::EVENT_SYMBOL() {
  return getToken(MySQLParser::EVENT_SYMBOL, 0);
}

MySQLParser::EventRefContext* MySQLParser::DropEventContext::eventRef() {
  return getRuleContext<MySQLParser::EventRefContext>(0);
}

MySQLParser::IfExistsContext* MySQLParser::DropEventContext::ifExists() {
  return getRuleContext<MySQLParser::IfExistsContext>(0);
}


size_t MySQLParser::DropEventContext::getRuleIndex() const {
  return MySQLParser::RuleDropEvent;
}

void MySQLParser::DropEventContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDropEvent(this);
}

void MySQLParser::DropEventContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDropEvent(this);
}


std::any MySQLParser::DropEventContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDropEvent(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DropEventContext* MySQLParser::dropEvent() {
  DropEventContext *_localctx = _tracker.createInstance<DropEventContext>(_ctx, getState());
  enterRule(_localctx, 182, MySQLParser::RuleDropEvent);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2480);
    match(MySQLParser::EVENT_SYMBOL);
    setState(2482);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 194, _ctx)) {
    case 1: {
      setState(2481);
      ifExists();
      break;
    }

    default:
      break;
    }
    setState(2484);
    eventRef();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DropFunctionContext ------------------------------------------------------------------

MySQLParser::DropFunctionContext::DropFunctionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::DropFunctionContext::FUNCTION_SYMBOL() {
  return getToken(MySQLParser::FUNCTION_SYMBOL, 0);
}

MySQLParser::FunctionRefContext* MySQLParser::DropFunctionContext::functionRef() {
  return getRuleContext<MySQLParser::FunctionRefContext>(0);
}

MySQLParser::IfExistsContext* MySQLParser::DropFunctionContext::ifExists() {
  return getRuleContext<MySQLParser::IfExistsContext>(0);
}


size_t MySQLParser::DropFunctionContext::getRuleIndex() const {
  return MySQLParser::RuleDropFunction;
}

void MySQLParser::DropFunctionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDropFunction(this);
}

void MySQLParser::DropFunctionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDropFunction(this);
}


std::any MySQLParser::DropFunctionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDropFunction(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DropFunctionContext* MySQLParser::dropFunction() {
  DropFunctionContext *_localctx = _tracker.createInstance<DropFunctionContext>(_ctx, getState());
  enterRule(_localctx, 184, MySQLParser::RuleDropFunction);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2486);
    match(MySQLParser::FUNCTION_SYMBOL);
    setState(2488);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 195, _ctx)) {
    case 1: {
      setState(2487);
      ifExists();
      break;
    }

    default:
      break;
    }
    setState(2490);
    functionRef();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DropProcedureContext ------------------------------------------------------------------

MySQLParser::DropProcedureContext::DropProcedureContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::DropProcedureContext::PROCEDURE_SYMBOL() {
  return getToken(MySQLParser::PROCEDURE_SYMBOL, 0);
}

MySQLParser::ProcedureRefContext* MySQLParser::DropProcedureContext::procedureRef() {
  return getRuleContext<MySQLParser::ProcedureRefContext>(0);
}

MySQLParser::IfExistsContext* MySQLParser::DropProcedureContext::ifExists() {
  return getRuleContext<MySQLParser::IfExistsContext>(0);
}


size_t MySQLParser::DropProcedureContext::getRuleIndex() const {
  return MySQLParser::RuleDropProcedure;
}

void MySQLParser::DropProcedureContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDropProcedure(this);
}

void MySQLParser::DropProcedureContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDropProcedure(this);
}


std::any MySQLParser::DropProcedureContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDropProcedure(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DropProcedureContext* MySQLParser::dropProcedure() {
  DropProcedureContext *_localctx = _tracker.createInstance<DropProcedureContext>(_ctx, getState());
  enterRule(_localctx, 186, MySQLParser::RuleDropProcedure);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2492);
    match(MySQLParser::PROCEDURE_SYMBOL);
    setState(2494);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 196, _ctx)) {
    case 1: {
      setState(2493);
      ifExists();
      break;
    }

    default:
      break;
    }
    setState(2496);
    procedureRef();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DropIndexContext ------------------------------------------------------------------

MySQLParser::DropIndexContext::DropIndexContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::IndexRefContext* MySQLParser::DropIndexContext::indexRef() {
  return getRuleContext<MySQLParser::IndexRefContext>(0);
}

tree::TerminalNode* MySQLParser::DropIndexContext::ON_SYMBOL() {
  return getToken(MySQLParser::ON_SYMBOL, 0);
}

MySQLParser::TableRefContext* MySQLParser::DropIndexContext::tableRef() {
  return getRuleContext<MySQLParser::TableRefContext>(0);
}

tree::TerminalNode* MySQLParser::DropIndexContext::INDEX_SYMBOL() {
  return getToken(MySQLParser::INDEX_SYMBOL, 0);
}

MySQLParser::OnlineOptionContext* MySQLParser::DropIndexContext::onlineOption() {
  return getRuleContext<MySQLParser::OnlineOptionContext>(0);
}

MySQLParser::IndexLockAndAlgorithmContext* MySQLParser::DropIndexContext::indexLockAndAlgorithm() {
  return getRuleContext<MySQLParser::IndexLockAndAlgorithmContext>(0);
}


size_t MySQLParser::DropIndexContext::getRuleIndex() const {
  return MySQLParser::RuleDropIndex;
}

void MySQLParser::DropIndexContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDropIndex(this);
}

void MySQLParser::DropIndexContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDropIndex(this);
}


std::any MySQLParser::DropIndexContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDropIndex(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DropIndexContext* MySQLParser::dropIndex() {
  DropIndexContext *_localctx = _tracker.createInstance<DropIndexContext>(_ctx, getState());
  enterRule(_localctx, 188, MySQLParser::RuleDropIndex);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2499);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::OFFLINE_SYMBOL

    || _la == MySQLParser::ONLINE_SYMBOL) {
      setState(2498);
      onlineOption();
    }
    setState(2501);
    antlrcpp::downCast<DropIndexContext *>(_localctx)->type = match(MySQLParser::INDEX_SYMBOL);
    setState(2502);
    indexRef();
    setState(2503);
    match(MySQLParser::ON_SYMBOL);
    setState(2504);
    tableRef();
    setState(2506);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::ALGORITHM_SYMBOL || _la == MySQLParser::LOCK_SYMBOL) {
      setState(2505);
      indexLockAndAlgorithm();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DropLogfileGroupContext ------------------------------------------------------------------

MySQLParser::DropLogfileGroupContext::DropLogfileGroupContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::DropLogfileGroupContext::LOGFILE_SYMBOL() {
  return getToken(MySQLParser::LOGFILE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::DropLogfileGroupContext::GROUP_SYMBOL() {
  return getToken(MySQLParser::GROUP_SYMBOL, 0);
}

MySQLParser::LogfileGroupRefContext* MySQLParser::DropLogfileGroupContext::logfileGroupRef() {
  return getRuleContext<MySQLParser::LogfileGroupRefContext>(0);
}

std::vector<MySQLParser::DropLogfileGroupOptionContext *> MySQLParser::DropLogfileGroupContext::dropLogfileGroupOption() {
  return getRuleContexts<MySQLParser::DropLogfileGroupOptionContext>();
}

MySQLParser::DropLogfileGroupOptionContext* MySQLParser::DropLogfileGroupContext::dropLogfileGroupOption(size_t i) {
  return getRuleContext<MySQLParser::DropLogfileGroupOptionContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::DropLogfileGroupContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::DropLogfileGroupContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::DropLogfileGroupContext::getRuleIndex() const {
  return MySQLParser::RuleDropLogfileGroup;
}

void MySQLParser::DropLogfileGroupContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDropLogfileGroup(this);
}

void MySQLParser::DropLogfileGroupContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDropLogfileGroup(this);
}


std::any MySQLParser::DropLogfileGroupContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDropLogfileGroup(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DropLogfileGroupContext* MySQLParser::dropLogfileGroup() {
  DropLogfileGroupContext *_localctx = _tracker.createInstance<DropLogfileGroupContext>(_ctx, getState());
  enterRule(_localctx, 190, MySQLParser::RuleDropLogfileGroup);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2508);
    match(MySQLParser::LOGFILE_SYMBOL);
    setState(2509);
    match(MySQLParser::GROUP_SYMBOL);
    setState(2510);
    logfileGroupRef();
    setState(2521);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::ENGINE_SYMBOL || _la == MySQLParser::NO_WAIT_SYMBOL || _la == MySQLParser::STORAGE_SYMBOL || _la == MySQLParser::WAIT_SYMBOL) {
      setState(2511);
      dropLogfileGroupOption();
      setState(2518);
      _errHandler->sync(this);
      _la = _input->LA(1);
      while (_la == MySQLParser::ENGINE_SYMBOL || _la == MySQLParser::NO_WAIT_SYMBOL || _la == MySQLParser::STORAGE_SYMBOL || _la == MySQLParser::WAIT_SYMBOL || _la == MySQLParser::COMMA_SYMBOL) {
        setState(2513);
        _errHandler->sync(this);

        _la = _input->LA(1);
        if (_la == MySQLParser::COMMA_SYMBOL) {
          setState(2512);
          match(MySQLParser::COMMA_SYMBOL);
        }
        setState(2515);
        dropLogfileGroupOption();
        setState(2520);
        _errHandler->sync(this);
        _la = _input->LA(1);
      }
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DropLogfileGroupOptionContext ------------------------------------------------------------------

MySQLParser::DropLogfileGroupOptionContext::DropLogfileGroupOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::TsOptionWaitContext* MySQLParser::DropLogfileGroupOptionContext::tsOptionWait() {
  return getRuleContext<MySQLParser::TsOptionWaitContext>(0);
}

MySQLParser::TsOptionEngineContext* MySQLParser::DropLogfileGroupOptionContext::tsOptionEngine() {
  return getRuleContext<MySQLParser::TsOptionEngineContext>(0);
}


size_t MySQLParser::DropLogfileGroupOptionContext::getRuleIndex() const {
  return MySQLParser::RuleDropLogfileGroupOption;
}

void MySQLParser::DropLogfileGroupOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDropLogfileGroupOption(this);
}

void MySQLParser::DropLogfileGroupOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDropLogfileGroupOption(this);
}


std::any MySQLParser::DropLogfileGroupOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDropLogfileGroupOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DropLogfileGroupOptionContext* MySQLParser::dropLogfileGroupOption() {
  DropLogfileGroupOptionContext *_localctx = _tracker.createInstance<DropLogfileGroupOptionContext>(_ctx, getState());
  enterRule(_localctx, 192, MySQLParser::RuleDropLogfileGroupOption);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2525);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::NO_WAIT_SYMBOL:
      case MySQLParser::WAIT_SYMBOL: {
        enterOuterAlt(_localctx, 1);
        setState(2523);
        tsOptionWait();
        break;
      }

      case MySQLParser::ENGINE_SYMBOL:
      case MySQLParser::STORAGE_SYMBOL: {
        enterOuterAlt(_localctx, 2);
        setState(2524);
        tsOptionEngine();
        break;
      }

    default:
      throw NoViableAltException(this);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DropServerContext ------------------------------------------------------------------

MySQLParser::DropServerContext::DropServerContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::DropServerContext::SERVER_SYMBOL() {
  return getToken(MySQLParser::SERVER_SYMBOL, 0);
}

MySQLParser::ServerRefContext* MySQLParser::DropServerContext::serverRef() {
  return getRuleContext<MySQLParser::ServerRefContext>(0);
}

MySQLParser::IfExistsContext* MySQLParser::DropServerContext::ifExists() {
  return getRuleContext<MySQLParser::IfExistsContext>(0);
}


size_t MySQLParser::DropServerContext::getRuleIndex() const {
  return MySQLParser::RuleDropServer;
}

void MySQLParser::DropServerContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDropServer(this);
}

void MySQLParser::DropServerContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDropServer(this);
}


std::any MySQLParser::DropServerContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDropServer(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DropServerContext* MySQLParser::dropServer() {
  DropServerContext *_localctx = _tracker.createInstance<DropServerContext>(_ctx, getState());
  enterRule(_localctx, 194, MySQLParser::RuleDropServer);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2527);
    match(MySQLParser::SERVER_SYMBOL);
    setState(2529);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 203, _ctx)) {
    case 1: {
      setState(2528);
      ifExists();
      break;
    }

    default:
      break;
    }
    setState(2531);
    serverRef();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DropTableContext ------------------------------------------------------------------

MySQLParser::DropTableContext::DropTableContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::TableRefListContext* MySQLParser::DropTableContext::tableRefList() {
  return getRuleContext<MySQLParser::TableRefListContext>(0);
}

tree::TerminalNode* MySQLParser::DropTableContext::TABLE_SYMBOL() {
  return getToken(MySQLParser::TABLE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::DropTableContext::TABLES_SYMBOL() {
  return getToken(MySQLParser::TABLES_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::DropTableContext::TEMPORARY_SYMBOL() {
  return getToken(MySQLParser::TEMPORARY_SYMBOL, 0);
}

MySQLParser::IfExistsContext* MySQLParser::DropTableContext::ifExists() {
  return getRuleContext<MySQLParser::IfExistsContext>(0);
}

tree::TerminalNode* MySQLParser::DropTableContext::RESTRICT_SYMBOL() {
  return getToken(MySQLParser::RESTRICT_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::DropTableContext::CASCADE_SYMBOL() {
  return getToken(MySQLParser::CASCADE_SYMBOL, 0);
}


size_t MySQLParser::DropTableContext::getRuleIndex() const {
  return MySQLParser::RuleDropTable;
}

void MySQLParser::DropTableContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDropTable(this);
}

void MySQLParser::DropTableContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDropTable(this);
}


std::any MySQLParser::DropTableContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDropTable(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DropTableContext* MySQLParser::dropTable() {
  DropTableContext *_localctx = _tracker.createInstance<DropTableContext>(_ctx, getState());
  enterRule(_localctx, 196, MySQLParser::RuleDropTable);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2534);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::TEMPORARY_SYMBOL) {
      setState(2533);
      match(MySQLParser::TEMPORARY_SYMBOL);
    }
    setState(2536);
    antlrcpp::downCast<DropTableContext *>(_localctx)->type = _input->LT(1);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::TABLES_SYMBOL

    || _la == MySQLParser::TABLE_SYMBOL)) {
      antlrcpp::downCast<DropTableContext *>(_localctx)->type = _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
    setState(2538);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 205, _ctx)) {
    case 1: {
      setState(2537);
      ifExists();
      break;
    }

    default:
      break;
    }
    setState(2540);
    tableRefList();
    setState(2542);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::CASCADE_SYMBOL || _la == MySQLParser::RESTRICT_SYMBOL) {
      setState(2541);
      _la = _input->LA(1);
      if (!(_la == MySQLParser::CASCADE_SYMBOL || _la == MySQLParser::RESTRICT_SYMBOL)) {
      _errHandler->recoverInline(this);
      }
      else {
        _errHandler->reportMatch(this);
        consume();
      }
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DropTableSpaceContext ------------------------------------------------------------------

MySQLParser::DropTableSpaceContext::DropTableSpaceContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::DropTableSpaceContext::TABLESPACE_SYMBOL() {
  return getToken(MySQLParser::TABLESPACE_SYMBOL, 0);
}

MySQLParser::TablespaceRefContext* MySQLParser::DropTableSpaceContext::tablespaceRef() {
  return getRuleContext<MySQLParser::TablespaceRefContext>(0);
}

std::vector<MySQLParser::DropLogfileGroupOptionContext *> MySQLParser::DropTableSpaceContext::dropLogfileGroupOption() {
  return getRuleContexts<MySQLParser::DropLogfileGroupOptionContext>();
}

MySQLParser::DropLogfileGroupOptionContext* MySQLParser::DropTableSpaceContext::dropLogfileGroupOption(size_t i) {
  return getRuleContext<MySQLParser::DropLogfileGroupOptionContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::DropTableSpaceContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::DropTableSpaceContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::DropTableSpaceContext::getRuleIndex() const {
  return MySQLParser::RuleDropTableSpace;
}

void MySQLParser::DropTableSpaceContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDropTableSpace(this);
}

void MySQLParser::DropTableSpaceContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDropTableSpace(this);
}


std::any MySQLParser::DropTableSpaceContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDropTableSpace(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DropTableSpaceContext* MySQLParser::dropTableSpace() {
  DropTableSpaceContext *_localctx = _tracker.createInstance<DropTableSpaceContext>(_ctx, getState());
  enterRule(_localctx, 198, MySQLParser::RuleDropTableSpace);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2544);
    match(MySQLParser::TABLESPACE_SYMBOL);
    setState(2545);
    tablespaceRef();
    setState(2556);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::ENGINE_SYMBOL || _la == MySQLParser::NO_WAIT_SYMBOL || _la == MySQLParser::STORAGE_SYMBOL || _la == MySQLParser::WAIT_SYMBOL) {
      setState(2546);
      dropLogfileGroupOption();
      setState(2553);
      _errHandler->sync(this);
      _la = _input->LA(1);
      while (_la == MySQLParser::ENGINE_SYMBOL || _la == MySQLParser::NO_WAIT_SYMBOL || _la == MySQLParser::STORAGE_SYMBOL || _la == MySQLParser::WAIT_SYMBOL || _la == MySQLParser::COMMA_SYMBOL) {
        setState(2548);
        _errHandler->sync(this);

        _la = _input->LA(1);
        if (_la == MySQLParser::COMMA_SYMBOL) {
          setState(2547);
          match(MySQLParser::COMMA_SYMBOL);
        }
        setState(2550);
        dropLogfileGroupOption();
        setState(2555);
        _errHandler->sync(this);
        _la = _input->LA(1);
      }
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DropTriggerContext ------------------------------------------------------------------

MySQLParser::DropTriggerContext::DropTriggerContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::DropTriggerContext::TRIGGER_SYMBOL() {
  return getToken(MySQLParser::TRIGGER_SYMBOL, 0);
}

MySQLParser::TriggerRefContext* MySQLParser::DropTriggerContext::triggerRef() {
  return getRuleContext<MySQLParser::TriggerRefContext>(0);
}

MySQLParser::IfExistsContext* MySQLParser::DropTriggerContext::ifExists() {
  return getRuleContext<MySQLParser::IfExistsContext>(0);
}


size_t MySQLParser::DropTriggerContext::getRuleIndex() const {
  return MySQLParser::RuleDropTrigger;
}

void MySQLParser::DropTriggerContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDropTrigger(this);
}

void MySQLParser::DropTriggerContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDropTrigger(this);
}


std::any MySQLParser::DropTriggerContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDropTrigger(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DropTriggerContext* MySQLParser::dropTrigger() {
  DropTriggerContext *_localctx = _tracker.createInstance<DropTriggerContext>(_ctx, getState());
  enterRule(_localctx, 200, MySQLParser::RuleDropTrigger);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2558);
    match(MySQLParser::TRIGGER_SYMBOL);
    setState(2560);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 210, _ctx)) {
    case 1: {
      setState(2559);
      ifExists();
      break;
    }

    default:
      break;
    }
    setState(2562);
    triggerRef();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DropViewContext ------------------------------------------------------------------

MySQLParser::DropViewContext::DropViewContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::DropViewContext::VIEW_SYMBOL() {
  return getToken(MySQLParser::VIEW_SYMBOL, 0);
}

MySQLParser::ViewRefListContext* MySQLParser::DropViewContext::viewRefList() {
  return getRuleContext<MySQLParser::ViewRefListContext>(0);
}

MySQLParser::IfExistsContext* MySQLParser::DropViewContext::ifExists() {
  return getRuleContext<MySQLParser::IfExistsContext>(0);
}

tree::TerminalNode* MySQLParser::DropViewContext::RESTRICT_SYMBOL() {
  return getToken(MySQLParser::RESTRICT_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::DropViewContext::CASCADE_SYMBOL() {
  return getToken(MySQLParser::CASCADE_SYMBOL, 0);
}


size_t MySQLParser::DropViewContext::getRuleIndex() const {
  return MySQLParser::RuleDropView;
}

void MySQLParser::DropViewContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDropView(this);
}

void MySQLParser::DropViewContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDropView(this);
}


std::any MySQLParser::DropViewContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDropView(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DropViewContext* MySQLParser::dropView() {
  DropViewContext *_localctx = _tracker.createInstance<DropViewContext>(_ctx, getState());
  enterRule(_localctx, 202, MySQLParser::RuleDropView);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2564);
    match(MySQLParser::VIEW_SYMBOL);
    setState(2566);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 211, _ctx)) {
    case 1: {
      setState(2565);
      ifExists();
      break;
    }

    default:
      break;
    }
    setState(2568);
    viewRefList();
    setState(2570);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::CASCADE_SYMBOL || _la == MySQLParser::RESTRICT_SYMBOL) {
      setState(2569);
      _la = _input->LA(1);
      if (!(_la == MySQLParser::CASCADE_SYMBOL || _la == MySQLParser::RESTRICT_SYMBOL)) {
      _errHandler->recoverInline(this);
      }
      else {
        _errHandler->reportMatch(this);
        consume();
      }
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DropRoleContext ------------------------------------------------------------------

MySQLParser::DropRoleContext::DropRoleContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::DropRoleContext::ROLE_SYMBOL() {
  return getToken(MySQLParser::ROLE_SYMBOL, 0);
}

MySQLParser::RoleListContext* MySQLParser::DropRoleContext::roleList() {
  return getRuleContext<MySQLParser::RoleListContext>(0);
}

MySQLParser::IfExistsContext* MySQLParser::DropRoleContext::ifExists() {
  return getRuleContext<MySQLParser::IfExistsContext>(0);
}


size_t MySQLParser::DropRoleContext::getRuleIndex() const {
  return MySQLParser::RuleDropRole;
}

void MySQLParser::DropRoleContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDropRole(this);
}

void MySQLParser::DropRoleContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDropRole(this);
}


std::any MySQLParser::DropRoleContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDropRole(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DropRoleContext* MySQLParser::dropRole() {
  DropRoleContext *_localctx = _tracker.createInstance<DropRoleContext>(_ctx, getState());
  enterRule(_localctx, 204, MySQLParser::RuleDropRole);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2572);
    match(MySQLParser::ROLE_SYMBOL);
    setState(2574);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 213, _ctx)) {
    case 1: {
      setState(2573);
      ifExists();
      break;
    }

    default:
      break;
    }
    setState(2576);
    roleList();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DropSpatialReferenceContext ------------------------------------------------------------------

MySQLParser::DropSpatialReferenceContext::DropSpatialReferenceContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::DropSpatialReferenceContext::SPATIAL_SYMBOL() {
  return getToken(MySQLParser::SPATIAL_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::DropSpatialReferenceContext::REFERENCE_SYMBOL() {
  return getToken(MySQLParser::REFERENCE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::DropSpatialReferenceContext::SYSTEM_SYMBOL() {
  return getToken(MySQLParser::SYSTEM_SYMBOL, 0);
}

MySQLParser::Real_ulonglong_numberContext* MySQLParser::DropSpatialReferenceContext::real_ulonglong_number() {
  return getRuleContext<MySQLParser::Real_ulonglong_numberContext>(0);
}

MySQLParser::IfExistsContext* MySQLParser::DropSpatialReferenceContext::ifExists() {
  return getRuleContext<MySQLParser::IfExistsContext>(0);
}


size_t MySQLParser::DropSpatialReferenceContext::getRuleIndex() const {
  return MySQLParser::RuleDropSpatialReference;
}

void MySQLParser::DropSpatialReferenceContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDropSpatialReference(this);
}

void MySQLParser::DropSpatialReferenceContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDropSpatialReference(this);
}


std::any MySQLParser::DropSpatialReferenceContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDropSpatialReference(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DropSpatialReferenceContext* MySQLParser::dropSpatialReference() {
  DropSpatialReferenceContext *_localctx = _tracker.createInstance<DropSpatialReferenceContext>(_ctx, getState());
  enterRule(_localctx, 206, MySQLParser::RuleDropSpatialReference);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2578);
    match(MySQLParser::SPATIAL_SYMBOL);
    setState(2579);
    match(MySQLParser::REFERENCE_SYMBOL);
    setState(2580);
    match(MySQLParser::SYSTEM_SYMBOL);
    setState(2582);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 214, _ctx)) {
    case 1: {
      setState(2581);
      ifExists();
      break;
    }

    default:
      break;
    }
    setState(2584);
    real_ulonglong_number();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DropUndoTablespaceContext ------------------------------------------------------------------

MySQLParser::DropUndoTablespaceContext::DropUndoTablespaceContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::DropUndoTablespaceContext::UNDO_SYMBOL() {
  return getToken(MySQLParser::UNDO_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::DropUndoTablespaceContext::TABLESPACE_SYMBOL() {
  return getToken(MySQLParser::TABLESPACE_SYMBOL, 0);
}

MySQLParser::TablespaceRefContext* MySQLParser::DropUndoTablespaceContext::tablespaceRef() {
  return getRuleContext<MySQLParser::TablespaceRefContext>(0);
}

MySQLParser::UndoTableSpaceOptionsContext* MySQLParser::DropUndoTablespaceContext::undoTableSpaceOptions() {
  return getRuleContext<MySQLParser::UndoTableSpaceOptionsContext>(0);
}


size_t MySQLParser::DropUndoTablespaceContext::getRuleIndex() const {
  return MySQLParser::RuleDropUndoTablespace;
}

void MySQLParser::DropUndoTablespaceContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDropUndoTablespace(this);
}

void MySQLParser::DropUndoTablespaceContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDropUndoTablespace(this);
}


std::any MySQLParser::DropUndoTablespaceContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDropUndoTablespace(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DropUndoTablespaceContext* MySQLParser::dropUndoTablespace() {
  DropUndoTablespaceContext *_localctx = _tracker.createInstance<DropUndoTablespaceContext>(_ctx, getState());
  enterRule(_localctx, 208, MySQLParser::RuleDropUndoTablespace);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2586);
    match(MySQLParser::UNDO_SYMBOL);
    setState(2587);
    match(MySQLParser::TABLESPACE_SYMBOL);
    setState(2588);
    tablespaceRef();
    setState(2590);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::ENGINE_SYMBOL || _la == MySQLParser::STORAGE_SYMBOL) {
      setState(2589);
      undoTableSpaceOptions();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- RenameTableStatementContext ------------------------------------------------------------------

MySQLParser::RenameTableStatementContext::RenameTableStatementContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::RenameTableStatementContext::RENAME_SYMBOL() {
  return getToken(MySQLParser::RENAME_SYMBOL, 0);
}

std::vector<MySQLParser::RenamePairContext *> MySQLParser::RenameTableStatementContext::renamePair() {
  return getRuleContexts<MySQLParser::RenamePairContext>();
}

MySQLParser::RenamePairContext* MySQLParser::RenameTableStatementContext::renamePair(size_t i) {
  return getRuleContext<MySQLParser::RenamePairContext>(i);
}

tree::TerminalNode* MySQLParser::RenameTableStatementContext::TABLE_SYMBOL() {
  return getToken(MySQLParser::TABLE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::RenameTableStatementContext::TABLES_SYMBOL() {
  return getToken(MySQLParser::TABLES_SYMBOL, 0);
}

std::vector<tree::TerminalNode *> MySQLParser::RenameTableStatementContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::RenameTableStatementContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::RenameTableStatementContext::getRuleIndex() const {
  return MySQLParser::RuleRenameTableStatement;
}

void MySQLParser::RenameTableStatementContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterRenameTableStatement(this);
}

void MySQLParser::RenameTableStatementContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitRenameTableStatement(this);
}


std::any MySQLParser::RenameTableStatementContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitRenameTableStatement(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::RenameTableStatementContext* MySQLParser::renameTableStatement() {
  RenameTableStatementContext *_localctx = _tracker.createInstance<RenameTableStatementContext>(_ctx, getState());
  enterRule(_localctx, 210, MySQLParser::RuleRenameTableStatement);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2592);
    match(MySQLParser::RENAME_SYMBOL);
    setState(2593);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::TABLES_SYMBOL

    || _la == MySQLParser::TABLE_SYMBOL)) {
    _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
    setState(2594);
    renamePair();
    setState(2599);
    _errHandler->sync(this);
    _la = _input->LA(1);
    while (_la == MySQLParser::COMMA_SYMBOL) {
      setState(2595);
      match(MySQLParser::COMMA_SYMBOL);
      setState(2596);
      renamePair();
      setState(2601);
      _errHandler->sync(this);
      _la = _input->LA(1);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- RenamePairContext ------------------------------------------------------------------

MySQLParser::RenamePairContext::RenamePairContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::TableRefContext* MySQLParser::RenamePairContext::tableRef() {
  return getRuleContext<MySQLParser::TableRefContext>(0);
}

tree::TerminalNode* MySQLParser::RenamePairContext::TO_SYMBOL() {
  return getToken(MySQLParser::TO_SYMBOL, 0);
}

MySQLParser::TableNameContext* MySQLParser::RenamePairContext::tableName() {
  return getRuleContext<MySQLParser::TableNameContext>(0);
}


size_t MySQLParser::RenamePairContext::getRuleIndex() const {
  return MySQLParser::RuleRenamePair;
}

void MySQLParser::RenamePairContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterRenamePair(this);
}

void MySQLParser::RenamePairContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitRenamePair(this);
}


std::any MySQLParser::RenamePairContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitRenamePair(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::RenamePairContext* MySQLParser::renamePair() {
  RenamePairContext *_localctx = _tracker.createInstance<RenamePairContext>(_ctx, getState());
  enterRule(_localctx, 212, MySQLParser::RuleRenamePair);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2602);
    tableRef();
    setState(2603);
    match(MySQLParser::TO_SYMBOL);
    setState(2604);
    tableName();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TruncateTableStatementContext ------------------------------------------------------------------

MySQLParser::TruncateTableStatementContext::TruncateTableStatementContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::TruncateTableStatementContext::TRUNCATE_SYMBOL() {
  return getToken(MySQLParser::TRUNCATE_SYMBOL, 0);
}

MySQLParser::TableRefContext* MySQLParser::TruncateTableStatementContext::tableRef() {
  return getRuleContext<MySQLParser::TableRefContext>(0);
}

tree::TerminalNode* MySQLParser::TruncateTableStatementContext::TABLE_SYMBOL() {
  return getToken(MySQLParser::TABLE_SYMBOL, 0);
}


size_t MySQLParser::TruncateTableStatementContext::getRuleIndex() const {
  return MySQLParser::RuleTruncateTableStatement;
}

void MySQLParser::TruncateTableStatementContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTruncateTableStatement(this);
}

void MySQLParser::TruncateTableStatementContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTruncateTableStatement(this);
}


std::any MySQLParser::TruncateTableStatementContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTruncateTableStatement(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TruncateTableStatementContext* MySQLParser::truncateTableStatement() {
  TruncateTableStatementContext *_localctx = _tracker.createInstance<TruncateTableStatementContext>(_ctx, getState());
  enterRule(_localctx, 214, MySQLParser::RuleTruncateTableStatement);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2606);
    match(MySQLParser::TRUNCATE_SYMBOL);
    setState(2608);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 217, _ctx)) {
    case 1: {
      setState(2607);
      match(MySQLParser::TABLE_SYMBOL);
      break;
    }

    default:
      break;
    }
    setState(2610);
    tableRef();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- ImportStatementContext ------------------------------------------------------------------

MySQLParser::ImportStatementContext::ImportStatementContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::ImportStatementContext::IMPORT_SYMBOL() {
  return getToken(MySQLParser::IMPORT_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ImportStatementContext::TABLE_SYMBOL() {
  return getToken(MySQLParser::TABLE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ImportStatementContext::FROM_SYMBOL() {
  return getToken(MySQLParser::FROM_SYMBOL, 0);
}

MySQLParser::TextStringLiteralListContext* MySQLParser::ImportStatementContext::textStringLiteralList() {
  return getRuleContext<MySQLParser::TextStringLiteralListContext>(0);
}


size_t MySQLParser::ImportStatementContext::getRuleIndex() const {
  return MySQLParser::RuleImportStatement;
}

void MySQLParser::ImportStatementContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterImportStatement(this);
}

void MySQLParser::ImportStatementContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitImportStatement(this);
}


std::any MySQLParser::ImportStatementContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitImportStatement(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::ImportStatementContext* MySQLParser::importStatement() {
  ImportStatementContext *_localctx = _tracker.createInstance<ImportStatementContext>(_ctx, getState());
  enterRule(_localctx, 216, MySQLParser::RuleImportStatement);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2612);
    match(MySQLParser::IMPORT_SYMBOL);
    setState(2613);
    match(MySQLParser::TABLE_SYMBOL);
    setState(2614);
    match(MySQLParser::FROM_SYMBOL);
    setState(2615);
    textStringLiteralList();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CallStatementContext ------------------------------------------------------------------

MySQLParser::CallStatementContext::CallStatementContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::CallStatementContext::CALL_SYMBOL() {
  return getToken(MySQLParser::CALL_SYMBOL, 0);
}

MySQLParser::ProcedureRefContext* MySQLParser::CallStatementContext::procedureRef() {
  return getRuleContext<MySQLParser::ProcedureRefContext>(0);
}

tree::TerminalNode* MySQLParser::CallStatementContext::OPEN_PAR_SYMBOL() {
  return getToken(MySQLParser::OPEN_PAR_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::CallStatementContext::CLOSE_PAR_SYMBOL() {
  return getToken(MySQLParser::CLOSE_PAR_SYMBOL, 0);
}

MySQLParser::ExprListContext* MySQLParser::CallStatementContext::exprList() {
  return getRuleContext<MySQLParser::ExprListContext>(0);
}


size_t MySQLParser::CallStatementContext::getRuleIndex() const {
  return MySQLParser::RuleCallStatement;
}

void MySQLParser::CallStatementContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCallStatement(this);
}

void MySQLParser::CallStatementContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCallStatement(this);
}


std::any MySQLParser::CallStatementContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCallStatement(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CallStatementContext* MySQLParser::callStatement() {
  CallStatementContext *_localctx = _tracker.createInstance<CallStatementContext>(_ctx, getState());
  enterRule(_localctx, 218, MySQLParser::RuleCallStatement);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2617);
    match(MySQLParser::CALL_SYMBOL);
    setState(2618);
    procedureRef();
    setState(2624);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::OPEN_PAR_SYMBOL) {
      setState(2619);
      match(MySQLParser::OPEN_PAR_SYMBOL);
      setState(2621);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 218, _ctx)) {
      case 1: {
        setState(2620);
        exprList();
        break;
      }

      default:
        break;
      }
      setState(2623);
      match(MySQLParser::CLOSE_PAR_SYMBOL);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DeleteStatementContext ------------------------------------------------------------------

MySQLParser::DeleteStatementContext::DeleteStatementContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::DeleteStatementContext::DELETE_SYMBOL() {
  return getToken(MySQLParser::DELETE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::DeleteStatementContext::FROM_SYMBOL() {
  return getToken(MySQLParser::FROM_SYMBOL, 0);
}

MySQLParser::TableAliasRefListContext* MySQLParser::DeleteStatementContext::tableAliasRefList() {
  return getRuleContext<MySQLParser::TableAliasRefListContext>(0);
}

MySQLParser::TableReferenceListContext* MySQLParser::DeleteStatementContext::tableReferenceList() {
  return getRuleContext<MySQLParser::TableReferenceListContext>(0);
}

MySQLParser::WithClauseContext* MySQLParser::DeleteStatementContext::withClause() {
  return getRuleContext<MySQLParser::WithClauseContext>(0);
}

std::vector<MySQLParser::DeleteStatementOptionContext *> MySQLParser::DeleteStatementContext::deleteStatementOption() {
  return getRuleContexts<MySQLParser::DeleteStatementOptionContext>();
}

MySQLParser::DeleteStatementOptionContext* MySQLParser::DeleteStatementContext::deleteStatementOption(size_t i) {
  return getRuleContext<MySQLParser::DeleteStatementOptionContext>(i);
}

tree::TerminalNode* MySQLParser::DeleteStatementContext::USING_SYMBOL() {
  return getToken(MySQLParser::USING_SYMBOL, 0);
}

MySQLParser::TableRefContext* MySQLParser::DeleteStatementContext::tableRef() {
  return getRuleContext<MySQLParser::TableRefContext>(0);
}

MySQLParser::WhereClauseContext* MySQLParser::DeleteStatementContext::whereClause() {
  return getRuleContext<MySQLParser::WhereClauseContext>(0);
}

MySQLParser::TableAliasContext* MySQLParser::DeleteStatementContext::tableAlias() {
  return getRuleContext<MySQLParser::TableAliasContext>(0);
}

MySQLParser::PartitionDeleteContext* MySQLParser::DeleteStatementContext::partitionDelete() {
  return getRuleContext<MySQLParser::PartitionDeleteContext>(0);
}

MySQLParser::OrderClauseContext* MySQLParser::DeleteStatementContext::orderClause() {
  return getRuleContext<MySQLParser::OrderClauseContext>(0);
}

MySQLParser::SimpleLimitClauseContext* MySQLParser::DeleteStatementContext::simpleLimitClause() {
  return getRuleContext<MySQLParser::SimpleLimitClauseContext>(0);
}


size_t MySQLParser::DeleteStatementContext::getRuleIndex() const {
  return MySQLParser::RuleDeleteStatement;
}

void MySQLParser::DeleteStatementContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDeleteStatement(this);
}

void MySQLParser::DeleteStatementContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDeleteStatement(this);
}


std::any MySQLParser::DeleteStatementContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDeleteStatement(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DeleteStatementContext* MySQLParser::deleteStatement() {
  DeleteStatementContext *_localctx = _tracker.createInstance<DeleteStatementContext>(_ctx, getState());
  enterRule(_localctx, 220, MySQLParser::RuleDeleteStatement);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    size_t alt;
    enterOuterAlt(_localctx, 1);
    setState(2628);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 220, _ctx)) {
    case 1: {
      setState(2626);

      if (!(serverVersion >= 80000)) throw FailedPredicateException(this, "serverVersion >= 80000");
      setState(2627);
      withClause();
      break;
    }

    default:
      break;
    }
    setState(2630);
    match(MySQLParser::DELETE_SYMBOL);
    setState(2634);
    _errHandler->sync(this);
    alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 221, _ctx);
    while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER) {
      if (alt == 1) {
        setState(2631);
        deleteStatementOption(); 
      }
      setState(2636);
      _errHandler->sync(this);
      alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 221, _ctx);
    }
    setState(2669);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 230, _ctx)) {
    case 1: {
      setState(2637);
      match(MySQLParser::FROM_SYMBOL);
      setState(2661);
      _errHandler->sync(this);
      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 228, _ctx)) {
      case 1: {
        setState(2638);
        tableAliasRefList();
        setState(2639);
        match(MySQLParser::USING_SYMBOL);
        setState(2640);
        tableReferenceList();
        setState(2642);
        _errHandler->sync(this);

        _la = _input->LA(1);
        if (_la == MySQLParser::WHERE_SYMBOL) {
          setState(2641);
          whereClause();
        }
        break;
      }

      case 2: {
        setState(2644);
        tableRef();
        setState(2647);
        _errHandler->sync(this);

        switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 223, _ctx)) {
        case 1: {
          setState(2645);

          if (!(serverVersion >= 80017)) throw FailedPredicateException(this, "serverVersion >= 80017");
          setState(2646);
          tableAlias();
          break;
        }

        default:
          break;
        }
        setState(2650);
        _errHandler->sync(this);

        switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 224, _ctx)) {
        case 1: {
          setState(2649);
          partitionDelete();
          break;
        }

        default:
          break;
        }
        setState(2653);
        _errHandler->sync(this);

        _la = _input->LA(1);
        if (_la == MySQLParser::WHERE_SYMBOL) {
          setState(2652);
          whereClause();
        }
        setState(2656);
        _errHandler->sync(this);

        _la = _input->LA(1);
        if (_la == MySQLParser::ORDER_SYMBOL) {
          setState(2655);
          orderClause();
        }
        setState(2659);
        _errHandler->sync(this);

        _la = _input->LA(1);
        if (_la == MySQLParser::LIMIT_SYMBOL) {
          setState(2658);
          simpleLimitClause();
        }
        break;
      }

      default:
        break;
      }
      break;
    }

    case 2: {
      setState(2663);
      tableAliasRefList();
      setState(2664);
      match(MySQLParser::FROM_SYMBOL);
      setState(2665);
      tableReferenceList();
      setState(2667);
      _errHandler->sync(this);

      _la = _input->LA(1);
      if (_la == MySQLParser::WHERE_SYMBOL) {
        setState(2666);
        whereClause();
      }
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- PartitionDeleteContext ------------------------------------------------------------------

MySQLParser::PartitionDeleteContext::PartitionDeleteContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::PartitionDeleteContext::PARTITION_SYMBOL() {
  return getToken(MySQLParser::PARTITION_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::PartitionDeleteContext::OPEN_PAR_SYMBOL() {
  return getToken(MySQLParser::OPEN_PAR_SYMBOL, 0);
}

MySQLParser::IdentifierListContext* MySQLParser::PartitionDeleteContext::identifierList() {
  return getRuleContext<MySQLParser::IdentifierListContext>(0);
}

tree::TerminalNode* MySQLParser::PartitionDeleteContext::CLOSE_PAR_SYMBOL() {
  return getToken(MySQLParser::CLOSE_PAR_SYMBOL, 0);
}


size_t MySQLParser::PartitionDeleteContext::getRuleIndex() const {
  return MySQLParser::RulePartitionDelete;
}

void MySQLParser::PartitionDeleteContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterPartitionDelete(this);
}

void MySQLParser::PartitionDeleteContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitPartitionDelete(this);
}


std::any MySQLParser::PartitionDeleteContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitPartitionDelete(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::PartitionDeleteContext* MySQLParser::partitionDelete() {
  PartitionDeleteContext *_localctx = _tracker.createInstance<PartitionDeleteContext>(_ctx, getState());
  enterRule(_localctx, 222, MySQLParser::RulePartitionDelete);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2671);

    if (!(serverVersion >= 50602)) throw FailedPredicateException(this, "serverVersion >= 50602");
    setState(2672);
    match(MySQLParser::PARTITION_SYMBOL);
    setState(2673);
    match(MySQLParser::OPEN_PAR_SYMBOL);
    setState(2674);
    identifierList();
    setState(2675);
    match(MySQLParser::CLOSE_PAR_SYMBOL);
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DeleteStatementOptionContext ------------------------------------------------------------------

MySQLParser::DeleteStatementOptionContext::DeleteStatementOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::DeleteStatementOptionContext::QUICK_SYMBOL() {
  return getToken(MySQLParser::QUICK_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::DeleteStatementOptionContext::LOW_PRIORITY_SYMBOL() {
  return getToken(MySQLParser::LOW_PRIORITY_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::DeleteStatementOptionContext::IGNORE_SYMBOL() {
  return getToken(MySQLParser::IGNORE_SYMBOL, 0);
}


size_t MySQLParser::DeleteStatementOptionContext::getRuleIndex() const {
  return MySQLParser::RuleDeleteStatementOption;
}

void MySQLParser::DeleteStatementOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDeleteStatementOption(this);
}

void MySQLParser::DeleteStatementOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDeleteStatementOption(this);
}


std::any MySQLParser::DeleteStatementOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDeleteStatementOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DeleteStatementOptionContext* MySQLParser::deleteStatementOption() {
  DeleteStatementOptionContext *_localctx = _tracker.createInstance<DeleteStatementOptionContext>(_ctx, getState());
  enterRule(_localctx, 224, MySQLParser::RuleDeleteStatementOption);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2677);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::IGNORE_SYMBOL

    || _la == MySQLParser::LOW_PRIORITY_SYMBOL || _la == MySQLParser::QUICK_SYMBOL)) {
    _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DoStatementContext ------------------------------------------------------------------

MySQLParser::DoStatementContext::DoStatementContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::DoStatementContext::DO_SYMBOL() {
  return getToken(MySQLParser::DO_SYMBOL, 0);
}

MySQLParser::ExprListContext* MySQLParser::DoStatementContext::exprList() {
  return getRuleContext<MySQLParser::ExprListContext>(0);
}

MySQLParser::SelectItemListContext* MySQLParser::DoStatementContext::selectItemList() {
  return getRuleContext<MySQLParser::SelectItemListContext>(0);
}


size_t MySQLParser::DoStatementContext::getRuleIndex() const {
  return MySQLParser::RuleDoStatement;
}

void MySQLParser::DoStatementContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDoStatement(this);
}

void MySQLParser::DoStatementContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDoStatement(this);
}


std::any MySQLParser::DoStatementContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDoStatement(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DoStatementContext* MySQLParser::doStatement() {
  DoStatementContext *_localctx = _tracker.createInstance<DoStatementContext>(_ctx, getState());
  enterRule(_localctx, 226, MySQLParser::RuleDoStatement);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2679);
    match(MySQLParser::DO_SYMBOL);
    setState(2684);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 231, _ctx)) {
    case 1: {
      setState(2680);

      if (!(serverVersion < 50709)) throw FailedPredicateException(this, "serverVersion < 50709");
      setState(2681);
      exprList();
      break;
    }

    case 2: {
      setState(2682);

      if (!(serverVersion >= 50709)) throw FailedPredicateException(this, "serverVersion >= 50709");
      setState(2683);
      selectItemList();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- HandlerStatementContext ------------------------------------------------------------------

MySQLParser::HandlerStatementContext::HandlerStatementContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::HandlerStatementContext::HANDLER_SYMBOL() {
  return getToken(MySQLParser::HANDLER_SYMBOL, 0);
}

MySQLParser::TableRefContext* MySQLParser::HandlerStatementContext::tableRef() {
  return getRuleContext<MySQLParser::TableRefContext>(0);
}

tree::TerminalNode* MySQLParser::HandlerStatementContext::OPEN_SYMBOL() {
  return getToken(MySQLParser::OPEN_SYMBOL, 0);
}

MySQLParser::IdentifierContext* MySQLParser::HandlerStatementContext::identifier() {
  return getRuleContext<MySQLParser::IdentifierContext>(0);
}

tree::TerminalNode* MySQLParser::HandlerStatementContext::CLOSE_SYMBOL() {
  return getToken(MySQLParser::CLOSE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::HandlerStatementContext::READ_SYMBOL() {
  return getToken(MySQLParser::READ_SYMBOL, 0);
}

MySQLParser::HandlerReadOrScanContext* MySQLParser::HandlerStatementContext::handlerReadOrScan() {
  return getRuleContext<MySQLParser::HandlerReadOrScanContext>(0);
}

MySQLParser::TableAliasContext* MySQLParser::HandlerStatementContext::tableAlias() {
  return getRuleContext<MySQLParser::TableAliasContext>(0);
}

MySQLParser::WhereClauseContext* MySQLParser::HandlerStatementContext::whereClause() {
  return getRuleContext<MySQLParser::WhereClauseContext>(0);
}

MySQLParser::LimitClauseContext* MySQLParser::HandlerStatementContext::limitClause() {
  return getRuleContext<MySQLParser::LimitClauseContext>(0);
}


size_t MySQLParser::HandlerStatementContext::getRuleIndex() const {
  return MySQLParser::RuleHandlerStatement;
}

void MySQLParser::HandlerStatementContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterHandlerStatement(this);
}

void MySQLParser::HandlerStatementContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitHandlerStatement(this);
}


std::any MySQLParser::HandlerStatementContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitHandlerStatement(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::HandlerStatementContext* MySQLParser::handlerStatement() {
  HandlerStatementContext *_localctx = _tracker.createInstance<HandlerStatementContext>(_ctx, getState());
  enterRule(_localctx, 228, MySQLParser::RuleHandlerStatement);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2686);
    match(MySQLParser::HANDLER_SYMBOL);
    setState(2704);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 236, _ctx)) {
    case 1: {
      setState(2687);
      tableRef();
      setState(2688);
      match(MySQLParser::OPEN_SYMBOL);
      setState(2690);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 232, _ctx)) {
      case 1: {
        setState(2689);
        tableAlias();
        break;
      }

      default:
        break;
      }
      break;
    }

    case 2: {
      setState(2692);
      identifier();
      setState(2702);
      _errHandler->sync(this);
      switch (_input->LA(1)) {
        case MySQLParser::CLOSE_SYMBOL: {
          setState(2693);
          match(MySQLParser::CLOSE_SYMBOL);
          break;
        }

        case MySQLParser::READ_SYMBOL: {
          setState(2694);
          match(MySQLParser::READ_SYMBOL);
          setState(2695);
          handlerReadOrScan();
          setState(2697);
          _errHandler->sync(this);

          _la = _input->LA(1);
          if (_la == MySQLParser::WHERE_SYMBOL) {
            setState(2696);
            whereClause();
          }
          setState(2700);
          _errHandler->sync(this);

          _la = _input->LA(1);
          if (_la == MySQLParser::LIMIT_SYMBOL) {
            setState(2699);
            limitClause();
          }
          break;
        }

      default:
        throw NoViableAltException(this);
      }
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- HandlerReadOrScanContext ------------------------------------------------------------------

MySQLParser::HandlerReadOrScanContext::HandlerReadOrScanContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::HandlerReadOrScanContext::FIRST_SYMBOL() {
  return getToken(MySQLParser::FIRST_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::HandlerReadOrScanContext::NEXT_SYMBOL() {
  return getToken(MySQLParser::NEXT_SYMBOL, 0);
}

MySQLParser::IdentifierContext* MySQLParser::HandlerReadOrScanContext::identifier() {
  return getRuleContext<MySQLParser::IdentifierContext>(0);
}

tree::TerminalNode* MySQLParser::HandlerReadOrScanContext::OPEN_PAR_SYMBOL() {
  return getToken(MySQLParser::OPEN_PAR_SYMBOL, 0);
}

MySQLParser::ValuesContext* MySQLParser::HandlerReadOrScanContext::values() {
  return getRuleContext<MySQLParser::ValuesContext>(0);
}

tree::TerminalNode* MySQLParser::HandlerReadOrScanContext::CLOSE_PAR_SYMBOL() {
  return getToken(MySQLParser::CLOSE_PAR_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::HandlerReadOrScanContext::PREV_SYMBOL() {
  return getToken(MySQLParser::PREV_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::HandlerReadOrScanContext::LAST_SYMBOL() {
  return getToken(MySQLParser::LAST_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::HandlerReadOrScanContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}

tree::TerminalNode* MySQLParser::HandlerReadOrScanContext::LESS_THAN_OPERATOR() {
  return getToken(MySQLParser::LESS_THAN_OPERATOR, 0);
}

tree::TerminalNode* MySQLParser::HandlerReadOrScanContext::GREATER_THAN_OPERATOR() {
  return getToken(MySQLParser::GREATER_THAN_OPERATOR, 0);
}

tree::TerminalNode* MySQLParser::HandlerReadOrScanContext::LESS_OR_EQUAL_OPERATOR() {
  return getToken(MySQLParser::LESS_OR_EQUAL_OPERATOR, 0);
}

tree::TerminalNode* MySQLParser::HandlerReadOrScanContext::GREATER_OR_EQUAL_OPERATOR() {
  return getToken(MySQLParser::GREATER_OR_EQUAL_OPERATOR, 0);
}


size_t MySQLParser::HandlerReadOrScanContext::getRuleIndex() const {
  return MySQLParser::RuleHandlerReadOrScan;
}

void MySQLParser::HandlerReadOrScanContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterHandlerReadOrScan(this);
}

void MySQLParser::HandlerReadOrScanContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitHandlerReadOrScan(this);
}


std::any MySQLParser::HandlerReadOrScanContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitHandlerReadOrScan(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::HandlerReadOrScanContext* MySQLParser::handlerReadOrScan() {
  HandlerReadOrScanContext *_localctx = _tracker.createInstance<HandlerReadOrScanContext>(_ctx, getState());
  enterRule(_localctx, 230, MySQLParser::RuleHandlerReadOrScan);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2716);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 238, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(2706);
      _la = _input->LA(1);
      if (!(_la == MySQLParser::FIRST_SYMBOL || _la == MySQLParser::NEXT_SYMBOL)) {
      _errHandler->recoverInline(this);
      }
      else {
        _errHandler->reportMatch(this);
        consume();
      }
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(2707);
      identifier();
      setState(2714);
      _errHandler->sync(this);
      switch (_input->LA(1)) {
        case MySQLParser::FIRST_SYMBOL:
        case MySQLParser::LAST_SYMBOL:
        case MySQLParser::NEXT_SYMBOL:
        case MySQLParser::PREV_SYMBOL: {
          setState(2708);
          _la = _input->LA(1);
          if (!(_la == MySQLParser::FIRST_SYMBOL || _la == MySQLParser::LAST_SYMBOL || _la == MySQLParser::NEXT_SYMBOL

          || _la == MySQLParser::PREV_SYMBOL)) {
          _errHandler->recoverInline(this);
          }
          else {
            _errHandler->reportMatch(this);
            consume();
          }
          break;
        }

        case MySQLParser::EQUAL_OPERATOR:
        case MySQLParser::GREATER_OR_EQUAL_OPERATOR:
        case MySQLParser::GREATER_THAN_OPERATOR:
        case MySQLParser::LESS_OR_EQUAL_OPERATOR:
        case MySQLParser::LESS_THAN_OPERATOR: {
          setState(2709);
          _la = _input->LA(1);
          if (!(((((_la - 750) & ~ 0x3fULL) == 0) &&
            ((1ULL << (_la - 750)) & 121) != 0))) {
          _errHandler->recoverInline(this);
          }
          else {
            _errHandler->reportMatch(this);
            consume();
          }
          setState(2710);
          match(MySQLParser::OPEN_PAR_SYMBOL);
          setState(2711);
          values();
          setState(2712);
          match(MySQLParser::CLOSE_PAR_SYMBOL);
          break;
        }

      default:
        throw NoViableAltException(this);
      }
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- InsertStatementContext ------------------------------------------------------------------

MySQLParser::InsertStatementContext::InsertStatementContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::InsertStatementContext::INSERT_SYMBOL() {
  return getToken(MySQLParser::INSERT_SYMBOL, 0);
}

MySQLParser::TableRefContext* MySQLParser::InsertStatementContext::tableRef() {
  return getRuleContext<MySQLParser::TableRefContext>(0);
}

MySQLParser::InsertFromConstructorContext* MySQLParser::InsertStatementContext::insertFromConstructor() {
  return getRuleContext<MySQLParser::InsertFromConstructorContext>(0);
}

tree::TerminalNode* MySQLParser::InsertStatementContext::SET_SYMBOL() {
  return getToken(MySQLParser::SET_SYMBOL, 0);
}

MySQLParser::UpdateListContext* MySQLParser::InsertStatementContext::updateList() {
  return getRuleContext<MySQLParser::UpdateListContext>(0);
}

MySQLParser::InsertQueryExpressionContext* MySQLParser::InsertStatementContext::insertQueryExpression() {
  return getRuleContext<MySQLParser::InsertQueryExpressionContext>(0);
}

MySQLParser::InsertLockOptionContext* MySQLParser::InsertStatementContext::insertLockOption() {
  return getRuleContext<MySQLParser::InsertLockOptionContext>(0);
}

tree::TerminalNode* MySQLParser::InsertStatementContext::IGNORE_SYMBOL() {
  return getToken(MySQLParser::IGNORE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::InsertStatementContext::INTO_SYMBOL() {
  return getToken(MySQLParser::INTO_SYMBOL, 0);
}

MySQLParser::UsePartitionContext* MySQLParser::InsertStatementContext::usePartition() {
  return getRuleContext<MySQLParser::UsePartitionContext>(0);
}

MySQLParser::InsertUpdateListContext* MySQLParser::InsertStatementContext::insertUpdateList() {
  return getRuleContext<MySQLParser::InsertUpdateListContext>(0);
}

MySQLParser::ValuesReferenceContext* MySQLParser::InsertStatementContext::valuesReference() {
  return getRuleContext<MySQLParser::ValuesReferenceContext>(0);
}


size_t MySQLParser::InsertStatementContext::getRuleIndex() const {
  return MySQLParser::RuleInsertStatement;
}

void MySQLParser::InsertStatementContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterInsertStatement(this);
}

void MySQLParser::InsertStatementContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitInsertStatement(this);
}


std::any MySQLParser::InsertStatementContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitInsertStatement(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::InsertStatementContext* MySQLParser::insertStatement() {
  InsertStatementContext *_localctx = _tracker.createInstance<InsertStatementContext>(_ctx, getState());
  enterRule(_localctx, 232, MySQLParser::RuleInsertStatement);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2718);
    match(MySQLParser::INSERT_SYMBOL);
    setState(2720);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 239, _ctx)) {
    case 1: {
      setState(2719);
      insertLockOption();
      break;
    }

    default:
      break;
    }
    setState(2723);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 240, _ctx)) {
    case 1: {
      setState(2722);
      match(MySQLParser::IGNORE_SYMBOL);
      break;
    }

    default:
      break;
    }
    setState(2726);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 241, _ctx)) {
    case 1: {
      setState(2725);
      match(MySQLParser::INTO_SYMBOL);
      break;
    }

    default:
      break;
    }
    setState(2728);
    tableRef();
    setState(2730);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 242, _ctx)) {
    case 1: {
      setState(2729);
      usePartition();
      break;
    }

    default:
      break;
    }
    setState(2744);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 245, _ctx)) {
    case 1: {
      setState(2732);
      insertFromConstructor();
      setState(2735);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 243, _ctx)) {
      case 1: {
        setState(2733);

        if (!( serverVersion >= 80018)) throw FailedPredicateException(this, " serverVersion >= 80018");
        setState(2734);
        valuesReference();
        break;
      }

      default:
        break;
      }
      break;
    }

    case 2: {
      setState(2737);
      match(MySQLParser::SET_SYMBOL);
      setState(2738);
      updateList();
      setState(2741);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 244, _ctx)) {
      case 1: {
        setState(2739);

        if (!( serverVersion >= 80018)) throw FailedPredicateException(this, " serverVersion >= 80018");
        setState(2740);
        valuesReference();
        break;
      }

      default:
        break;
      }
      break;
    }

    case 3: {
      setState(2743);
      insertQueryExpression();
      break;
    }

    default:
      break;
    }
    setState(2747);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::ON_SYMBOL) {
      setState(2746);
      insertUpdateList();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- InsertLockOptionContext ------------------------------------------------------------------

MySQLParser::InsertLockOptionContext::InsertLockOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::InsertLockOptionContext::LOW_PRIORITY_SYMBOL() {
  return getToken(MySQLParser::LOW_PRIORITY_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::InsertLockOptionContext::DELAYED_SYMBOL() {
  return getToken(MySQLParser::DELAYED_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::InsertLockOptionContext::HIGH_PRIORITY_SYMBOL() {
  return getToken(MySQLParser::HIGH_PRIORITY_SYMBOL, 0);
}


size_t MySQLParser::InsertLockOptionContext::getRuleIndex() const {
  return MySQLParser::RuleInsertLockOption;
}

void MySQLParser::InsertLockOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterInsertLockOption(this);
}

void MySQLParser::InsertLockOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitInsertLockOption(this);
}


std::any MySQLParser::InsertLockOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitInsertLockOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::InsertLockOptionContext* MySQLParser::insertLockOption() {
  InsertLockOptionContext *_localctx = _tracker.createInstance<InsertLockOptionContext>(_ctx, getState());
  enterRule(_localctx, 234, MySQLParser::RuleInsertLockOption);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2749);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::DELAYED_SYMBOL || _la == MySQLParser::HIGH_PRIORITY_SYMBOL || _la == MySQLParser::LOW_PRIORITY_SYMBOL)) {
    _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- InsertFromConstructorContext ------------------------------------------------------------------

MySQLParser::InsertFromConstructorContext::InsertFromConstructorContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::InsertValuesContext* MySQLParser::InsertFromConstructorContext::insertValues() {
  return getRuleContext<MySQLParser::InsertValuesContext>(0);
}

tree::TerminalNode* MySQLParser::InsertFromConstructorContext::OPEN_PAR_SYMBOL() {
  return getToken(MySQLParser::OPEN_PAR_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::InsertFromConstructorContext::CLOSE_PAR_SYMBOL() {
  return getToken(MySQLParser::CLOSE_PAR_SYMBOL, 0);
}

MySQLParser::FieldsContext* MySQLParser::InsertFromConstructorContext::fields() {
  return getRuleContext<MySQLParser::FieldsContext>(0);
}


size_t MySQLParser::InsertFromConstructorContext::getRuleIndex() const {
  return MySQLParser::RuleInsertFromConstructor;
}

void MySQLParser::InsertFromConstructorContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterInsertFromConstructor(this);
}

void MySQLParser::InsertFromConstructorContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitInsertFromConstructor(this);
}


std::any MySQLParser::InsertFromConstructorContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitInsertFromConstructor(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::InsertFromConstructorContext* MySQLParser::insertFromConstructor() {
  InsertFromConstructorContext *_localctx = _tracker.createInstance<InsertFromConstructorContext>(_ctx, getState());
  enterRule(_localctx, 236, MySQLParser::RuleInsertFromConstructor);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2756);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::OPEN_PAR_SYMBOL) {
      setState(2751);
      match(MySQLParser::OPEN_PAR_SYMBOL);
      setState(2753);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 247, _ctx)) {
      case 1: {
        setState(2752);
        fields();
        break;
      }

      default:
        break;
      }
      setState(2755);
      match(MySQLParser::CLOSE_PAR_SYMBOL);
    }
    setState(2758);
    insertValues();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- FieldsContext ------------------------------------------------------------------

MySQLParser::FieldsContext::FieldsContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

std::vector<MySQLParser::InsertIdentifierContext *> MySQLParser::FieldsContext::insertIdentifier() {
  return getRuleContexts<MySQLParser::InsertIdentifierContext>();
}

MySQLParser::InsertIdentifierContext* MySQLParser::FieldsContext::insertIdentifier(size_t i) {
  return getRuleContext<MySQLParser::InsertIdentifierContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::FieldsContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::FieldsContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::FieldsContext::getRuleIndex() const {
  return MySQLParser::RuleFields;
}

void MySQLParser::FieldsContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterFields(this);
}

void MySQLParser::FieldsContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitFields(this);
}


std::any MySQLParser::FieldsContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitFields(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::FieldsContext* MySQLParser::fields() {
  FieldsContext *_localctx = _tracker.createInstance<FieldsContext>(_ctx, getState());
  enterRule(_localctx, 238, MySQLParser::RuleFields);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2760);
    insertIdentifier();
    setState(2765);
    _errHandler->sync(this);
    _la = _input->LA(1);
    while (_la == MySQLParser::COMMA_SYMBOL) {
      setState(2761);
      match(MySQLParser::COMMA_SYMBOL);
      setState(2762);
      insertIdentifier();
      setState(2767);
      _errHandler->sync(this);
      _la = _input->LA(1);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- InsertValuesContext ------------------------------------------------------------------

MySQLParser::InsertValuesContext::InsertValuesContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::ValueListContext* MySQLParser::InsertValuesContext::valueList() {
  return getRuleContext<MySQLParser::ValueListContext>(0);
}

tree::TerminalNode* MySQLParser::InsertValuesContext::VALUES_SYMBOL() {
  return getToken(MySQLParser::VALUES_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::InsertValuesContext::VALUE_SYMBOL() {
  return getToken(MySQLParser::VALUE_SYMBOL, 0);
}


size_t MySQLParser::InsertValuesContext::getRuleIndex() const {
  return MySQLParser::RuleInsertValues;
}

void MySQLParser::InsertValuesContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterInsertValues(this);
}

void MySQLParser::InsertValuesContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitInsertValues(this);
}


std::any MySQLParser::InsertValuesContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitInsertValues(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::InsertValuesContext* MySQLParser::insertValues() {
  InsertValuesContext *_localctx = _tracker.createInstance<InsertValuesContext>(_ctx, getState());
  enterRule(_localctx, 240, MySQLParser::RuleInsertValues);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2768);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::VALUES_SYMBOL

    || _la == MySQLParser::VALUE_SYMBOL)) {
    _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
    setState(2769);
    valueList();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- InsertQueryExpressionContext ------------------------------------------------------------------

MySQLParser::InsertQueryExpressionContext::InsertQueryExpressionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::QueryExpressionOrParensContext* MySQLParser::InsertQueryExpressionContext::queryExpressionOrParens() {
  return getRuleContext<MySQLParser::QueryExpressionOrParensContext>(0);
}

tree::TerminalNode* MySQLParser::InsertQueryExpressionContext::OPEN_PAR_SYMBOL() {
  return getToken(MySQLParser::OPEN_PAR_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::InsertQueryExpressionContext::CLOSE_PAR_SYMBOL() {
  return getToken(MySQLParser::CLOSE_PAR_SYMBOL, 0);
}

MySQLParser::FieldsContext* MySQLParser::InsertQueryExpressionContext::fields() {
  return getRuleContext<MySQLParser::FieldsContext>(0);
}


size_t MySQLParser::InsertQueryExpressionContext::getRuleIndex() const {
  return MySQLParser::RuleInsertQueryExpression;
}

void MySQLParser::InsertQueryExpressionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterInsertQueryExpression(this);
}

void MySQLParser::InsertQueryExpressionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitInsertQueryExpression(this);
}


std::any MySQLParser::InsertQueryExpressionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitInsertQueryExpression(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::InsertQueryExpressionContext* MySQLParser::insertQueryExpression() {
  InsertQueryExpressionContext *_localctx = _tracker.createInstance<InsertQueryExpressionContext>(_ctx, getState());
  enterRule(_localctx, 242, MySQLParser::RuleInsertQueryExpression);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2778);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 251, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(2771);
      queryExpressionOrParens();
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(2772);
      match(MySQLParser::OPEN_PAR_SYMBOL);
      setState(2774);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 250, _ctx)) {
      case 1: {
        setState(2773);
        fields();
        break;
      }

      default:
        break;
      }
      setState(2776);
      match(MySQLParser::CLOSE_PAR_SYMBOL);
      setState(2777);
      queryExpressionOrParens();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- ValueListContext ------------------------------------------------------------------

MySQLParser::ValueListContext::ValueListContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

std::vector<tree::TerminalNode *> MySQLParser::ValueListContext::OPEN_PAR_SYMBOL() {
  return getTokens(MySQLParser::OPEN_PAR_SYMBOL);
}

tree::TerminalNode* MySQLParser::ValueListContext::OPEN_PAR_SYMBOL(size_t i) {
  return getToken(MySQLParser::OPEN_PAR_SYMBOL, i);
}

std::vector<tree::TerminalNode *> MySQLParser::ValueListContext::CLOSE_PAR_SYMBOL() {
  return getTokens(MySQLParser::CLOSE_PAR_SYMBOL);
}

tree::TerminalNode* MySQLParser::ValueListContext::CLOSE_PAR_SYMBOL(size_t i) {
  return getToken(MySQLParser::CLOSE_PAR_SYMBOL, i);
}

std::vector<MySQLParser::ValuesContext *> MySQLParser::ValueListContext::values() {
  return getRuleContexts<MySQLParser::ValuesContext>();
}

MySQLParser::ValuesContext* MySQLParser::ValueListContext::values(size_t i) {
  return getRuleContext<MySQLParser::ValuesContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::ValueListContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::ValueListContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::ValueListContext::getRuleIndex() const {
  return MySQLParser::RuleValueList;
}

void MySQLParser::ValueListContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterValueList(this);
}

void MySQLParser::ValueListContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitValueList(this);
}


std::any MySQLParser::ValueListContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitValueList(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::ValueListContext* MySQLParser::valueList() {
  ValueListContext *_localctx = _tracker.createInstance<ValueListContext>(_ctx, getState());
  enterRule(_localctx, 244, MySQLParser::RuleValueList);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    size_t alt;
    enterOuterAlt(_localctx, 1);
    setState(2780);
    match(MySQLParser::OPEN_PAR_SYMBOL);
    setState(2782);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 252, _ctx)) {
    case 1: {
      setState(2781);
      values();
      break;
    }

    default:
      break;
    }
    setState(2784);
    match(MySQLParser::CLOSE_PAR_SYMBOL);
    setState(2793);
    _errHandler->sync(this);
    alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 254, _ctx);
    while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER) {
      if (alt == 1) {
        setState(2785);
        match(MySQLParser::COMMA_SYMBOL);
        setState(2786);
        match(MySQLParser::OPEN_PAR_SYMBOL);
        setState(2788);
        _errHandler->sync(this);

        switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 253, _ctx)) {
        case 1: {
          setState(2787);
          values();
          break;
        }

        default:
          break;
        }
        setState(2790);
        match(MySQLParser::CLOSE_PAR_SYMBOL); 
      }
      setState(2795);
      _errHandler->sync(this);
      alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 254, _ctx);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- ValuesContext ------------------------------------------------------------------

MySQLParser::ValuesContext::ValuesContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

std::vector<MySQLParser::ExprContext *> MySQLParser::ValuesContext::expr() {
  return getRuleContexts<MySQLParser::ExprContext>();
}

MySQLParser::ExprContext* MySQLParser::ValuesContext::expr(size_t i) {
  return getRuleContext<MySQLParser::ExprContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::ValuesContext::DEFAULT_SYMBOL() {
  return getTokens(MySQLParser::DEFAULT_SYMBOL);
}

tree::TerminalNode* MySQLParser::ValuesContext::DEFAULT_SYMBOL(size_t i) {
  return getToken(MySQLParser::DEFAULT_SYMBOL, i);
}

std::vector<tree::TerminalNode *> MySQLParser::ValuesContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::ValuesContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::ValuesContext::getRuleIndex() const {
  return MySQLParser::RuleValues;
}

void MySQLParser::ValuesContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterValues(this);
}

void MySQLParser::ValuesContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitValues(this);
}


std::any MySQLParser::ValuesContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitValues(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::ValuesContext* MySQLParser::values() {
  ValuesContext *_localctx = _tracker.createInstance<ValuesContext>(_ctx, getState());
  enterRule(_localctx, 246, MySQLParser::RuleValues);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2798);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 255, _ctx)) {
    case 1: {
      setState(2796);
      expr(0);
      break;
    }

    case 2: {
      setState(2797);
      match(MySQLParser::DEFAULT_SYMBOL);
      break;
    }

    default:
      break;
    }
    setState(2807);
    _errHandler->sync(this);
    _la = _input->LA(1);
    while (_la == MySQLParser::COMMA_SYMBOL) {
      setState(2800);
      match(MySQLParser::COMMA_SYMBOL);
      setState(2803);
      _errHandler->sync(this);
      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 256, _ctx)) {
      case 1: {
        setState(2801);
        expr(0);
        break;
      }

      case 2: {
        setState(2802);
        match(MySQLParser::DEFAULT_SYMBOL);
        break;
      }

      default:
        break;
      }
      setState(2809);
      _errHandler->sync(this);
      _la = _input->LA(1);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- ValuesReferenceContext ------------------------------------------------------------------

MySQLParser::ValuesReferenceContext::ValuesReferenceContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::ValuesReferenceContext::AS_SYMBOL() {
  return getToken(MySQLParser::AS_SYMBOL, 0);
}

MySQLParser::IdentifierContext* MySQLParser::ValuesReferenceContext::identifier() {
  return getRuleContext<MySQLParser::IdentifierContext>(0);
}

MySQLParser::ColumnInternalRefListContext* MySQLParser::ValuesReferenceContext::columnInternalRefList() {
  return getRuleContext<MySQLParser::ColumnInternalRefListContext>(0);
}


size_t MySQLParser::ValuesReferenceContext::getRuleIndex() const {
  return MySQLParser::RuleValuesReference;
}

void MySQLParser::ValuesReferenceContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterValuesReference(this);
}

void MySQLParser::ValuesReferenceContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitValuesReference(this);
}


std::any MySQLParser::ValuesReferenceContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitValuesReference(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::ValuesReferenceContext* MySQLParser::valuesReference() {
  ValuesReferenceContext *_localctx = _tracker.createInstance<ValuesReferenceContext>(_ctx, getState());
  enterRule(_localctx, 248, MySQLParser::RuleValuesReference);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2810);
    match(MySQLParser::AS_SYMBOL);
    setState(2811);
    identifier();
    setState(2813);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::OPEN_PAR_SYMBOL) {
      setState(2812);
      columnInternalRefList();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- InsertUpdateListContext ------------------------------------------------------------------

MySQLParser::InsertUpdateListContext::InsertUpdateListContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::InsertUpdateListContext::ON_SYMBOL() {
  return getToken(MySQLParser::ON_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::InsertUpdateListContext::DUPLICATE_SYMBOL() {
  return getToken(MySQLParser::DUPLICATE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::InsertUpdateListContext::KEY_SYMBOL() {
  return getToken(MySQLParser::KEY_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::InsertUpdateListContext::UPDATE_SYMBOL() {
  return getToken(MySQLParser::UPDATE_SYMBOL, 0);
}

MySQLParser::UpdateListContext* MySQLParser::InsertUpdateListContext::updateList() {
  return getRuleContext<MySQLParser::UpdateListContext>(0);
}


size_t MySQLParser::InsertUpdateListContext::getRuleIndex() const {
  return MySQLParser::RuleInsertUpdateList;
}

void MySQLParser::InsertUpdateListContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterInsertUpdateList(this);
}

void MySQLParser::InsertUpdateListContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitInsertUpdateList(this);
}


std::any MySQLParser::InsertUpdateListContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitInsertUpdateList(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::InsertUpdateListContext* MySQLParser::insertUpdateList() {
  InsertUpdateListContext *_localctx = _tracker.createInstance<InsertUpdateListContext>(_ctx, getState());
  enterRule(_localctx, 250, MySQLParser::RuleInsertUpdateList);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2815);
    match(MySQLParser::ON_SYMBOL);
    setState(2816);
    match(MySQLParser::DUPLICATE_SYMBOL);
    setState(2817);
    match(MySQLParser::KEY_SYMBOL);
    setState(2818);
    match(MySQLParser::UPDATE_SYMBOL);
    setState(2819);
    updateList();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- LoadStatementContext ------------------------------------------------------------------

MySQLParser::LoadStatementContext::LoadStatementContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::LoadStatementContext::LOAD_SYMBOL() {
  return getToken(MySQLParser::LOAD_SYMBOL, 0);
}

MySQLParser::DataOrXmlContext* MySQLParser::LoadStatementContext::dataOrXml() {
  return getRuleContext<MySQLParser::DataOrXmlContext>(0);
}

tree::TerminalNode* MySQLParser::LoadStatementContext::INFILE_SYMBOL() {
  return getToken(MySQLParser::INFILE_SYMBOL, 0);
}

MySQLParser::TextLiteralContext* MySQLParser::LoadStatementContext::textLiteral() {
  return getRuleContext<MySQLParser::TextLiteralContext>(0);
}

tree::TerminalNode* MySQLParser::LoadStatementContext::INTO_SYMBOL() {
  return getToken(MySQLParser::INTO_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::LoadStatementContext::TABLE_SYMBOL() {
  return getToken(MySQLParser::TABLE_SYMBOL, 0);
}

MySQLParser::TableRefContext* MySQLParser::LoadStatementContext::tableRef() {
  return getRuleContext<MySQLParser::TableRefContext>(0);
}

MySQLParser::LoadDataFileTailContext* MySQLParser::LoadStatementContext::loadDataFileTail() {
  return getRuleContext<MySQLParser::LoadDataFileTailContext>(0);
}

tree::TerminalNode* MySQLParser::LoadStatementContext::LOCAL_SYMBOL() {
  return getToken(MySQLParser::LOCAL_SYMBOL, 0);
}

MySQLParser::UsePartitionContext* MySQLParser::LoadStatementContext::usePartition() {
  return getRuleContext<MySQLParser::UsePartitionContext>(0);
}

MySQLParser::CharsetClauseContext* MySQLParser::LoadStatementContext::charsetClause() {
  return getRuleContext<MySQLParser::CharsetClauseContext>(0);
}

MySQLParser::XmlRowsIdentifiedByContext* MySQLParser::LoadStatementContext::xmlRowsIdentifiedBy() {
  return getRuleContext<MySQLParser::XmlRowsIdentifiedByContext>(0);
}

MySQLParser::FieldsClauseContext* MySQLParser::LoadStatementContext::fieldsClause() {
  return getRuleContext<MySQLParser::FieldsClauseContext>(0);
}

MySQLParser::LinesClauseContext* MySQLParser::LoadStatementContext::linesClause() {
  return getRuleContext<MySQLParser::LinesClauseContext>(0);
}

tree::TerminalNode* MySQLParser::LoadStatementContext::LOW_PRIORITY_SYMBOL() {
  return getToken(MySQLParser::LOW_PRIORITY_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::LoadStatementContext::CONCURRENT_SYMBOL() {
  return getToken(MySQLParser::CONCURRENT_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::LoadStatementContext::REPLACE_SYMBOL() {
  return getToken(MySQLParser::REPLACE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::LoadStatementContext::IGNORE_SYMBOL() {
  return getToken(MySQLParser::IGNORE_SYMBOL, 0);
}


size_t MySQLParser::LoadStatementContext::getRuleIndex() const {
  return MySQLParser::RuleLoadStatement;
}

void MySQLParser::LoadStatementContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterLoadStatement(this);
}

void MySQLParser::LoadStatementContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitLoadStatement(this);
}


std::any MySQLParser::LoadStatementContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitLoadStatement(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::LoadStatementContext* MySQLParser::loadStatement() {
  LoadStatementContext *_localctx = _tracker.createInstance<LoadStatementContext>(_ctx, getState());
  enterRule(_localctx, 252, MySQLParser::RuleLoadStatement);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2821);
    match(MySQLParser::LOAD_SYMBOL);
    setState(2822);
    dataOrXml();
    setState(2824);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::CONCURRENT_SYMBOL || _la == MySQLParser::LOW_PRIORITY_SYMBOL) {
      setState(2823);
      _la = _input->LA(1);
      if (!(_la == MySQLParser::CONCURRENT_SYMBOL || _la == MySQLParser::LOW_PRIORITY_SYMBOL)) {
      _errHandler->recoverInline(this);
      }
      else {
        _errHandler->reportMatch(this);
        consume();
      }
    }
    setState(2827);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::LOCAL_SYMBOL) {
      setState(2826);
      match(MySQLParser::LOCAL_SYMBOL);
    }
    setState(2829);
    match(MySQLParser::INFILE_SYMBOL);
    setState(2830);
    textLiteral();
    setState(2832);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::IGNORE_SYMBOL || _la == MySQLParser::REPLACE_SYMBOL) {
      setState(2831);
      _la = _input->LA(1);
      if (!(_la == MySQLParser::IGNORE_SYMBOL || _la == MySQLParser::REPLACE_SYMBOL)) {
      _errHandler->recoverInline(this);
      }
      else {
        _errHandler->reportMatch(this);
        consume();
      }
    }
    setState(2834);
    match(MySQLParser::INTO_SYMBOL);
    setState(2835);
    match(MySQLParser::TABLE_SYMBOL);
    setState(2836);
    tableRef();
    setState(2838);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 262, _ctx)) {
    case 1: {
      setState(2837);
      usePartition();
      break;
    }

    default:
      break;
    }
    setState(2841);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::CHARSET_SYMBOL

    || _la == MySQLParser::CHAR_SYMBOL) {
      setState(2840);
      charsetClause();
    }
    setState(2844);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::ROWS_SYMBOL) {
      setState(2843);
      xmlRowsIdentifiedBy();
    }
    setState(2847);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::COLUMNS_SYMBOL) {
      setState(2846);
      fieldsClause();
    }
    setState(2850);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::LINES_SYMBOL) {
      setState(2849);
      linesClause();
    }
    setState(2852);
    loadDataFileTail();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DataOrXmlContext ------------------------------------------------------------------

MySQLParser::DataOrXmlContext::DataOrXmlContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::DataOrXmlContext::DATA_SYMBOL() {
  return getToken(MySQLParser::DATA_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::DataOrXmlContext::XML_SYMBOL() {
  return getToken(MySQLParser::XML_SYMBOL, 0);
}


size_t MySQLParser::DataOrXmlContext::getRuleIndex() const {
  return MySQLParser::RuleDataOrXml;
}

void MySQLParser::DataOrXmlContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDataOrXml(this);
}

void MySQLParser::DataOrXmlContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDataOrXml(this);
}


std::any MySQLParser::DataOrXmlContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDataOrXml(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DataOrXmlContext* MySQLParser::dataOrXml() {
  DataOrXmlContext *_localctx = _tracker.createInstance<DataOrXmlContext>(_ctx, getState());
  enterRule(_localctx, 254, MySQLParser::RuleDataOrXml);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2854);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::DATA_SYMBOL || _la == MySQLParser::XML_SYMBOL)) {
    _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- XmlRowsIdentifiedByContext ------------------------------------------------------------------

MySQLParser::XmlRowsIdentifiedByContext::XmlRowsIdentifiedByContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::XmlRowsIdentifiedByContext::ROWS_SYMBOL() {
  return getToken(MySQLParser::ROWS_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::XmlRowsIdentifiedByContext::IDENTIFIED_SYMBOL() {
  return getToken(MySQLParser::IDENTIFIED_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::XmlRowsIdentifiedByContext::BY_SYMBOL() {
  return getToken(MySQLParser::BY_SYMBOL, 0);
}

MySQLParser::TextStringContext* MySQLParser::XmlRowsIdentifiedByContext::textString() {
  return getRuleContext<MySQLParser::TextStringContext>(0);
}


size_t MySQLParser::XmlRowsIdentifiedByContext::getRuleIndex() const {
  return MySQLParser::RuleXmlRowsIdentifiedBy;
}

void MySQLParser::XmlRowsIdentifiedByContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterXmlRowsIdentifiedBy(this);
}

void MySQLParser::XmlRowsIdentifiedByContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitXmlRowsIdentifiedBy(this);
}


std::any MySQLParser::XmlRowsIdentifiedByContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitXmlRowsIdentifiedBy(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::XmlRowsIdentifiedByContext* MySQLParser::xmlRowsIdentifiedBy() {
  XmlRowsIdentifiedByContext *_localctx = _tracker.createInstance<XmlRowsIdentifiedByContext>(_ctx, getState());
  enterRule(_localctx, 256, MySQLParser::RuleXmlRowsIdentifiedBy);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2856);
    match(MySQLParser::ROWS_SYMBOL);
    setState(2857);
    match(MySQLParser::IDENTIFIED_SYMBOL);
    setState(2858);
    match(MySQLParser::BY_SYMBOL);
    setState(2859);
    textString();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- LoadDataFileTailContext ------------------------------------------------------------------

MySQLParser::LoadDataFileTailContext::LoadDataFileTailContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::LoadDataFileTailContext::IGNORE_SYMBOL() {
  return getToken(MySQLParser::IGNORE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::LoadDataFileTailContext::INT_NUMBER() {
  return getToken(MySQLParser::INT_NUMBER, 0);
}

MySQLParser::LoadDataFileTargetListContext* MySQLParser::LoadDataFileTailContext::loadDataFileTargetList() {
  return getRuleContext<MySQLParser::LoadDataFileTargetListContext>(0);
}

tree::TerminalNode* MySQLParser::LoadDataFileTailContext::SET_SYMBOL() {
  return getToken(MySQLParser::SET_SYMBOL, 0);
}

MySQLParser::UpdateListContext* MySQLParser::LoadDataFileTailContext::updateList() {
  return getRuleContext<MySQLParser::UpdateListContext>(0);
}

tree::TerminalNode* MySQLParser::LoadDataFileTailContext::LINES_SYMBOL() {
  return getToken(MySQLParser::LINES_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::LoadDataFileTailContext::ROWS_SYMBOL() {
  return getToken(MySQLParser::ROWS_SYMBOL, 0);
}


size_t MySQLParser::LoadDataFileTailContext::getRuleIndex() const {
  return MySQLParser::RuleLoadDataFileTail;
}

void MySQLParser::LoadDataFileTailContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterLoadDataFileTail(this);
}

void MySQLParser::LoadDataFileTailContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitLoadDataFileTail(this);
}


std::any MySQLParser::LoadDataFileTailContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitLoadDataFileTail(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::LoadDataFileTailContext* MySQLParser::loadDataFileTail() {
  LoadDataFileTailContext *_localctx = _tracker.createInstance<LoadDataFileTailContext>(_ctx, getState());
  enterRule(_localctx, 258, MySQLParser::RuleLoadDataFileTail);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2864);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::IGNORE_SYMBOL) {
      setState(2861);
      match(MySQLParser::IGNORE_SYMBOL);
      setState(2862);
      match(MySQLParser::INT_NUMBER);
      setState(2863);
      _la = _input->LA(1);
      if (!(_la == MySQLParser::LINES_SYMBOL || _la == MySQLParser::ROWS_SYMBOL)) {
      _errHandler->recoverInline(this);
      }
      else {
        _errHandler->reportMatch(this);
        consume();
      }
    }
    setState(2867);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::OPEN_PAR_SYMBOL) {
      setState(2866);
      loadDataFileTargetList();
    }
    setState(2871);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::SET_SYMBOL) {
      setState(2869);
      match(MySQLParser::SET_SYMBOL);
      setState(2870);
      updateList();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- LoadDataFileTargetListContext ------------------------------------------------------------------

MySQLParser::LoadDataFileTargetListContext::LoadDataFileTargetListContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::LoadDataFileTargetListContext::OPEN_PAR_SYMBOL() {
  return getToken(MySQLParser::OPEN_PAR_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::LoadDataFileTargetListContext::CLOSE_PAR_SYMBOL() {
  return getToken(MySQLParser::CLOSE_PAR_SYMBOL, 0);
}

MySQLParser::FieldOrVariableListContext* MySQLParser::LoadDataFileTargetListContext::fieldOrVariableList() {
  return getRuleContext<MySQLParser::FieldOrVariableListContext>(0);
}


size_t MySQLParser::LoadDataFileTargetListContext::getRuleIndex() const {
  return MySQLParser::RuleLoadDataFileTargetList;
}

void MySQLParser::LoadDataFileTargetListContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterLoadDataFileTargetList(this);
}

void MySQLParser::LoadDataFileTargetListContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitLoadDataFileTargetList(this);
}


std::any MySQLParser::LoadDataFileTargetListContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitLoadDataFileTargetList(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::LoadDataFileTargetListContext* MySQLParser::loadDataFileTargetList() {
  LoadDataFileTargetListContext *_localctx = _tracker.createInstance<LoadDataFileTargetListContext>(_ctx, getState());
  enterRule(_localctx, 260, MySQLParser::RuleLoadDataFileTargetList);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2873);
    match(MySQLParser::OPEN_PAR_SYMBOL);
    setState(2875);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 270, _ctx)) {
    case 1: {
      setState(2874);
      fieldOrVariableList();
      break;
    }

    default:
      break;
    }
    setState(2877);
    match(MySQLParser::CLOSE_PAR_SYMBOL);
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- FieldOrVariableListContext ------------------------------------------------------------------

MySQLParser::FieldOrVariableListContext::FieldOrVariableListContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

std::vector<MySQLParser::ColumnRefContext *> MySQLParser::FieldOrVariableListContext::columnRef() {
  return getRuleContexts<MySQLParser::ColumnRefContext>();
}

MySQLParser::ColumnRefContext* MySQLParser::FieldOrVariableListContext::columnRef(size_t i) {
  return getRuleContext<MySQLParser::ColumnRefContext>(i);
}

std::vector<MySQLParser::UserVariableContext *> MySQLParser::FieldOrVariableListContext::userVariable() {
  return getRuleContexts<MySQLParser::UserVariableContext>();
}

MySQLParser::UserVariableContext* MySQLParser::FieldOrVariableListContext::userVariable(size_t i) {
  return getRuleContext<MySQLParser::UserVariableContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::FieldOrVariableListContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::FieldOrVariableListContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::FieldOrVariableListContext::getRuleIndex() const {
  return MySQLParser::RuleFieldOrVariableList;
}

void MySQLParser::FieldOrVariableListContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterFieldOrVariableList(this);
}

void MySQLParser::FieldOrVariableListContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitFieldOrVariableList(this);
}


std::any MySQLParser::FieldOrVariableListContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitFieldOrVariableList(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::FieldOrVariableListContext* MySQLParser::fieldOrVariableList() {
  FieldOrVariableListContext *_localctx = _tracker.createInstance<FieldOrVariableListContext>(_ctx, getState());
  enterRule(_localctx, 262, MySQLParser::RuleFieldOrVariableList);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2881);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 271, _ctx)) {
    case 1: {
      setState(2879);
      columnRef();
      break;
    }

    case 2: {
      setState(2880);
      userVariable();
      break;
    }

    default:
      break;
    }
    setState(2890);
    _errHandler->sync(this);
    _la = _input->LA(1);
    while (_la == MySQLParser::COMMA_SYMBOL) {
      setState(2883);
      match(MySQLParser::COMMA_SYMBOL);
      setState(2886);
      _errHandler->sync(this);
      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 272, _ctx)) {
      case 1: {
        setState(2884);
        columnRef();
        break;
      }

      case 2: {
        setState(2885);
        userVariable();
        break;
      }

      default:
        break;
      }
      setState(2892);
      _errHandler->sync(this);
      _la = _input->LA(1);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- ReplaceStatementContext ------------------------------------------------------------------

MySQLParser::ReplaceStatementContext::ReplaceStatementContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::ReplaceStatementContext::REPLACE_SYMBOL() {
  return getToken(MySQLParser::REPLACE_SYMBOL, 0);
}

MySQLParser::TableRefContext* MySQLParser::ReplaceStatementContext::tableRef() {
  return getRuleContext<MySQLParser::TableRefContext>(0);
}

MySQLParser::InsertFromConstructorContext* MySQLParser::ReplaceStatementContext::insertFromConstructor() {
  return getRuleContext<MySQLParser::InsertFromConstructorContext>(0);
}

tree::TerminalNode* MySQLParser::ReplaceStatementContext::SET_SYMBOL() {
  return getToken(MySQLParser::SET_SYMBOL, 0);
}

MySQLParser::UpdateListContext* MySQLParser::ReplaceStatementContext::updateList() {
  return getRuleContext<MySQLParser::UpdateListContext>(0);
}

MySQLParser::InsertQueryExpressionContext* MySQLParser::ReplaceStatementContext::insertQueryExpression() {
  return getRuleContext<MySQLParser::InsertQueryExpressionContext>(0);
}

tree::TerminalNode* MySQLParser::ReplaceStatementContext::INTO_SYMBOL() {
  return getToken(MySQLParser::INTO_SYMBOL, 0);
}

MySQLParser::UsePartitionContext* MySQLParser::ReplaceStatementContext::usePartition() {
  return getRuleContext<MySQLParser::UsePartitionContext>(0);
}

tree::TerminalNode* MySQLParser::ReplaceStatementContext::LOW_PRIORITY_SYMBOL() {
  return getToken(MySQLParser::LOW_PRIORITY_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ReplaceStatementContext::DELAYED_SYMBOL() {
  return getToken(MySQLParser::DELAYED_SYMBOL, 0);
}


size_t MySQLParser::ReplaceStatementContext::getRuleIndex() const {
  return MySQLParser::RuleReplaceStatement;
}

void MySQLParser::ReplaceStatementContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterReplaceStatement(this);
}

void MySQLParser::ReplaceStatementContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitReplaceStatement(this);
}


std::any MySQLParser::ReplaceStatementContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitReplaceStatement(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::ReplaceStatementContext* MySQLParser::replaceStatement() {
  ReplaceStatementContext *_localctx = _tracker.createInstance<ReplaceStatementContext>(_ctx, getState());
  enterRule(_localctx, 264, MySQLParser::RuleReplaceStatement);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2893);
    match(MySQLParser::REPLACE_SYMBOL);
    setState(2895);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 274, _ctx)) {
    case 1: {
      setState(2894);
      _la = _input->LA(1);
      if (!(_la == MySQLParser::DELAYED_SYMBOL || _la == MySQLParser::LOW_PRIORITY_SYMBOL)) {
      _errHandler->recoverInline(this);
      }
      else {
        _errHandler->reportMatch(this);
        consume();
      }
      break;
    }

    default:
      break;
    }
    setState(2898);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 275, _ctx)) {
    case 1: {
      setState(2897);
      match(MySQLParser::INTO_SYMBOL);
      break;
    }

    default:
      break;
    }
    setState(2900);
    tableRef();
    setState(2902);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 276, _ctx)) {
    case 1: {
      setState(2901);
      usePartition();
      break;
    }

    default:
      break;
    }
    setState(2908);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 277, _ctx)) {
    case 1: {
      setState(2904);
      insertFromConstructor();
      break;
    }

    case 2: {
      setState(2905);
      match(MySQLParser::SET_SYMBOL);
      setState(2906);
      updateList();
      break;
    }

    case 3: {
      setState(2907);
      insertQueryExpression();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- SelectStatementContext ------------------------------------------------------------------

MySQLParser::SelectStatementContext::SelectStatementContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::QueryExpressionContext* MySQLParser::SelectStatementContext::queryExpression() {
  return getRuleContext<MySQLParser::QueryExpressionContext>(0);
}

MySQLParser::LockingClauseListContext* MySQLParser::SelectStatementContext::lockingClauseList() {
  return getRuleContext<MySQLParser::LockingClauseListContext>(0);
}

MySQLParser::QueryExpressionParensContext* MySQLParser::SelectStatementContext::queryExpressionParens() {
  return getRuleContext<MySQLParser::QueryExpressionParensContext>(0);
}

MySQLParser::SelectStatementWithIntoContext* MySQLParser::SelectStatementContext::selectStatementWithInto() {
  return getRuleContext<MySQLParser::SelectStatementWithIntoContext>(0);
}


size_t MySQLParser::SelectStatementContext::getRuleIndex() const {
  return MySQLParser::RuleSelectStatement;
}

void MySQLParser::SelectStatementContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterSelectStatement(this);
}

void MySQLParser::SelectStatementContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitSelectStatement(this);
}


std::any MySQLParser::SelectStatementContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitSelectStatement(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::SelectStatementContext* MySQLParser::selectStatement() {
  SelectStatementContext *_localctx = _tracker.createInstance<SelectStatementContext>(_ctx, getState());
  enterRule(_localctx, 266, MySQLParser::RuleSelectStatement);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2916);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 279, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(2910);
      queryExpression();
      setState(2912);
      _errHandler->sync(this);

      _la = _input->LA(1);
      if (_la == MySQLParser::FOR_SYMBOL || _la == MySQLParser::LOCK_SYMBOL) {
        setState(2911);
        lockingClauseList();
      }
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(2914);
      queryExpressionParens();
      break;
    }

    case 3: {
      enterOuterAlt(_localctx, 3);
      setState(2915);
      selectStatementWithInto();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- SelectStatementWithIntoContext ------------------------------------------------------------------

MySQLParser::SelectStatementWithIntoContext::SelectStatementWithIntoContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::SelectStatementWithIntoContext::OPEN_PAR_SYMBOL() {
  return getToken(MySQLParser::OPEN_PAR_SYMBOL, 0);
}

MySQLParser::SelectStatementWithIntoContext* MySQLParser::SelectStatementWithIntoContext::selectStatementWithInto() {
  return getRuleContext<MySQLParser::SelectStatementWithIntoContext>(0);
}

tree::TerminalNode* MySQLParser::SelectStatementWithIntoContext::CLOSE_PAR_SYMBOL() {
  return getToken(MySQLParser::CLOSE_PAR_SYMBOL, 0);
}

MySQLParser::QueryExpressionContext* MySQLParser::SelectStatementWithIntoContext::queryExpression() {
  return getRuleContext<MySQLParser::QueryExpressionContext>(0);
}

MySQLParser::IntoClauseContext* MySQLParser::SelectStatementWithIntoContext::intoClause() {
  return getRuleContext<MySQLParser::IntoClauseContext>(0);
}

MySQLParser::LockingClauseListContext* MySQLParser::SelectStatementWithIntoContext::lockingClauseList() {
  return getRuleContext<MySQLParser::LockingClauseListContext>(0);
}


size_t MySQLParser::SelectStatementWithIntoContext::getRuleIndex() const {
  return MySQLParser::RuleSelectStatementWithInto;
}

void MySQLParser::SelectStatementWithIntoContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterSelectStatementWithInto(this);
}

void MySQLParser::SelectStatementWithIntoContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitSelectStatementWithInto(this);
}


std::any MySQLParser::SelectStatementWithIntoContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitSelectStatementWithInto(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::SelectStatementWithIntoContext* MySQLParser::selectStatementWithInto() {
  SelectStatementWithIntoContext *_localctx = _tracker.createInstance<SelectStatementWithIntoContext>(_ctx, getState());
  enterRule(_localctx, 268, MySQLParser::RuleSelectStatementWithInto);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2930);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 281, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(2918);
      match(MySQLParser::OPEN_PAR_SYMBOL);
      setState(2919);
      selectStatementWithInto();
      setState(2920);
      match(MySQLParser::CLOSE_PAR_SYMBOL);
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(2922);
      queryExpression();
      setState(2923);
      intoClause();
      setState(2925);
      _errHandler->sync(this);

      _la = _input->LA(1);
      if (_la == MySQLParser::FOR_SYMBOL || _la == MySQLParser::LOCK_SYMBOL) {
        setState(2924);
        lockingClauseList();
      }
      break;
    }

    case 3: {
      enterOuterAlt(_localctx, 3);
      setState(2927);
      lockingClauseList();
      setState(2928);
      intoClause();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- QueryExpressionContext ------------------------------------------------------------------

MySQLParser::QueryExpressionContext::QueryExpressionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::QueryExpressionBodyContext* MySQLParser::QueryExpressionContext::queryExpressionBody() {
  return getRuleContext<MySQLParser::QueryExpressionBodyContext>(0);
}

MySQLParser::QueryExpressionParensContext* MySQLParser::QueryExpressionContext::queryExpressionParens() {
  return getRuleContext<MySQLParser::QueryExpressionParensContext>(0);
}

MySQLParser::WithClauseContext* MySQLParser::QueryExpressionContext::withClause() {
  return getRuleContext<MySQLParser::WithClauseContext>(0);
}

MySQLParser::ProcedureAnalyseClauseContext* MySQLParser::QueryExpressionContext::procedureAnalyseClause() {
  return getRuleContext<MySQLParser::ProcedureAnalyseClauseContext>(0);
}

MySQLParser::OrderClauseContext* MySQLParser::QueryExpressionContext::orderClause() {
  return getRuleContext<MySQLParser::OrderClauseContext>(0);
}

MySQLParser::LimitClauseContext* MySQLParser::QueryExpressionContext::limitClause() {
  return getRuleContext<MySQLParser::LimitClauseContext>(0);
}


size_t MySQLParser::QueryExpressionContext::getRuleIndex() const {
  return MySQLParser::RuleQueryExpression;
}

void MySQLParser::QueryExpressionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterQueryExpression(this);
}

void MySQLParser::QueryExpressionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitQueryExpression(this);
}


std::any MySQLParser::QueryExpressionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitQueryExpression(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::QueryExpressionContext* MySQLParser::queryExpression() {
  QueryExpressionContext *_localctx = _tracker.createInstance<QueryExpressionContext>(_ctx, getState());
  enterRule(_localctx, 270, MySQLParser::RuleQueryExpression);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2934);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 282, _ctx)) {
    case 1: {
      setState(2932);

      if (!(serverVersion >= 80000)) throw FailedPredicateException(this, "serverVersion >= 80000");
      setState(2933);
      withClause();
      break;
    }

    default:
      break;
    }
    setState(2950);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 287, _ctx)) {
    case 1: {
      setState(2936);
      queryExpressionBody();
      setState(2938);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 283, _ctx)) {
      case 1: {
        setState(2937);
        orderClause();
        break;
      }

      default:
        break;
      }
      setState(2941);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 284, _ctx)) {
      case 1: {
        setState(2940);
        limitClause();
        break;
      }

      default:
        break;
      }
      break;
    }

    case 2: {
      setState(2943);
      queryExpressionParens();
      setState(2945);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 285, _ctx)) {
      case 1: {
        setState(2944);
        orderClause();
        break;
      }

      default:
        break;
      }
      setState(2948);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 286, _ctx)) {
      case 1: {
        setState(2947);
        limitClause();
        break;
      }

      default:
        break;
      }
      break;
    }

    default:
      break;
    }
    setState(2954);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 288, _ctx)) {
    case 1: {
      setState(2952);

      if (!(serverVersion < 80000)) throw FailedPredicateException(this, "serverVersion < 80000");
      setState(2953);
      procedureAnalyseClause();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- QueryExpressionBodyContext ------------------------------------------------------------------

MySQLParser::QueryExpressionBodyContext::QueryExpressionBodyContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

std::vector<MySQLParser::QueryPrimaryContext *> MySQLParser::QueryExpressionBodyContext::queryPrimary() {
  return getRuleContexts<MySQLParser::QueryPrimaryContext>();
}

MySQLParser::QueryPrimaryContext* MySQLParser::QueryExpressionBodyContext::queryPrimary(size_t i) {
  return getRuleContext<MySQLParser::QueryPrimaryContext>(i);
}

std::vector<MySQLParser::QueryExpressionParensContext *> MySQLParser::QueryExpressionBodyContext::queryExpressionParens() {
  return getRuleContexts<MySQLParser::QueryExpressionParensContext>();
}

MySQLParser::QueryExpressionParensContext* MySQLParser::QueryExpressionBodyContext::queryExpressionParens(size_t i) {
  return getRuleContext<MySQLParser::QueryExpressionParensContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::QueryExpressionBodyContext::UNION_SYMBOL() {
  return getTokens(MySQLParser::UNION_SYMBOL);
}

tree::TerminalNode* MySQLParser::QueryExpressionBodyContext::UNION_SYMBOL(size_t i) {
  return getToken(MySQLParser::UNION_SYMBOL, i);
}

std::vector<MySQLParser::UnionOptionContext *> MySQLParser::QueryExpressionBodyContext::unionOption() {
  return getRuleContexts<MySQLParser::UnionOptionContext>();
}

MySQLParser::UnionOptionContext* MySQLParser::QueryExpressionBodyContext::unionOption(size_t i) {
  return getRuleContext<MySQLParser::UnionOptionContext>(i);
}


size_t MySQLParser::QueryExpressionBodyContext::getRuleIndex() const {
  return MySQLParser::RuleQueryExpressionBody;
}

void MySQLParser::QueryExpressionBodyContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterQueryExpressionBody(this);
}

void MySQLParser::QueryExpressionBodyContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitQueryExpressionBody(this);
}


std::any MySQLParser::QueryExpressionBodyContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitQueryExpressionBody(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::QueryExpressionBodyContext* MySQLParser::queryExpressionBody() {
  QueryExpressionBodyContext *_localctx = _tracker.createInstance<QueryExpressionBodyContext>(_ctx, getState());
  enterRule(_localctx, 272, MySQLParser::RuleQueryExpressionBody);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    size_t alt;
    enterOuterAlt(_localctx, 1);
    setState(2966);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 291, _ctx)) {
    case 1: {
      setState(2956);
      queryPrimary();
      break;
    }

    case 2: {
      setState(2957);
      queryExpressionParens();
      setState(2958);
      match(MySQLParser::UNION_SYMBOL);
      setState(2960);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 289, _ctx)) {
      case 1: {
        setState(2959);
        unionOption();
        break;
      }

      default:
        break;
      }
      setState(2964);
      _errHandler->sync(this);
      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 290, _ctx)) {
      case 1: {
        setState(2962);
        queryPrimary();
        break;
      }

      case 2: {
        setState(2963);
        queryExpressionParens();
        break;
      }

      default:
        break;
      }
      break;
    }

    default:
      break;
    }
    setState(2978);
    _errHandler->sync(this);
    alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 294, _ctx);
    while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER) {
      if (alt == 1) {
        setState(2968);
        match(MySQLParser::UNION_SYMBOL);
        setState(2970);
        _errHandler->sync(this);

        switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 292, _ctx)) {
        case 1: {
          setState(2969);
          unionOption();
          break;
        }

        default:
          break;
        }
        setState(2974);
        _errHandler->sync(this);
        switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 293, _ctx)) {
        case 1: {
          setState(2972);
          queryPrimary();
          break;
        }

        case 2: {
          setState(2973);
          queryExpressionParens();
          break;
        }

        default:
          break;
        } 
      }
      setState(2980);
      _errHandler->sync(this);
      alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 294, _ctx);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- QueryExpressionParensContext ------------------------------------------------------------------

MySQLParser::QueryExpressionParensContext::QueryExpressionParensContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::QueryExpressionParensContext::OPEN_PAR_SYMBOL() {
  return getToken(MySQLParser::OPEN_PAR_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::QueryExpressionParensContext::CLOSE_PAR_SYMBOL() {
  return getToken(MySQLParser::CLOSE_PAR_SYMBOL, 0);
}

MySQLParser::QueryExpressionParensContext* MySQLParser::QueryExpressionParensContext::queryExpressionParens() {
  return getRuleContext<MySQLParser::QueryExpressionParensContext>(0);
}

MySQLParser::QueryExpressionContext* MySQLParser::QueryExpressionParensContext::queryExpression() {
  return getRuleContext<MySQLParser::QueryExpressionContext>(0);
}

MySQLParser::LockingClauseListContext* MySQLParser::QueryExpressionParensContext::lockingClauseList() {
  return getRuleContext<MySQLParser::LockingClauseListContext>(0);
}


size_t MySQLParser::QueryExpressionParensContext::getRuleIndex() const {
  return MySQLParser::RuleQueryExpressionParens;
}

void MySQLParser::QueryExpressionParensContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterQueryExpressionParens(this);
}

void MySQLParser::QueryExpressionParensContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitQueryExpressionParens(this);
}


std::any MySQLParser::QueryExpressionParensContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitQueryExpressionParens(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::QueryExpressionParensContext* MySQLParser::queryExpressionParens() {
  QueryExpressionParensContext *_localctx = _tracker.createInstance<QueryExpressionParensContext>(_ctx, getState());
  enterRule(_localctx, 274, MySQLParser::RuleQueryExpressionParens);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(2981);
    match(MySQLParser::OPEN_PAR_SYMBOL);
    setState(2987);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 296, _ctx)) {
    case 1: {
      setState(2982);
      queryExpressionParens();
      break;
    }

    case 2: {
      setState(2983);
      queryExpression();
      setState(2985);
      _errHandler->sync(this);

      _la = _input->LA(1);
      if (_la == MySQLParser::FOR_SYMBOL || _la == MySQLParser::LOCK_SYMBOL) {
        setState(2984);
        lockingClauseList();
      }
      break;
    }

    default:
      break;
    }
    setState(2989);
    match(MySQLParser::CLOSE_PAR_SYMBOL);
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- QueryPrimaryContext ------------------------------------------------------------------

MySQLParser::QueryPrimaryContext::QueryPrimaryContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::QuerySpecificationContext* MySQLParser::QueryPrimaryContext::querySpecification() {
  return getRuleContext<MySQLParser::QuerySpecificationContext>(0);
}

MySQLParser::TableValueConstructorContext* MySQLParser::QueryPrimaryContext::tableValueConstructor() {
  return getRuleContext<MySQLParser::TableValueConstructorContext>(0);
}

MySQLParser::ExplicitTableContext* MySQLParser::QueryPrimaryContext::explicitTable() {
  return getRuleContext<MySQLParser::ExplicitTableContext>(0);
}


size_t MySQLParser::QueryPrimaryContext::getRuleIndex() const {
  return MySQLParser::RuleQueryPrimary;
}

void MySQLParser::QueryPrimaryContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterQueryPrimary(this);
}

void MySQLParser::QueryPrimaryContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitQueryPrimary(this);
}


std::any MySQLParser::QueryPrimaryContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitQueryPrimary(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::QueryPrimaryContext* MySQLParser::queryPrimary() {
  QueryPrimaryContext *_localctx = _tracker.createInstance<QueryPrimaryContext>(_ctx, getState());
  enterRule(_localctx, 276, MySQLParser::RuleQueryPrimary);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(2996);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 297, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(2991);
      querySpecification();
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(2992);

      if (!(serverVersion >= 80019)) throw FailedPredicateException(this, "serverVersion >= 80019");
      setState(2993);
      tableValueConstructor();
      break;
    }

    case 3: {
      enterOuterAlt(_localctx, 3);
      setState(2994);

      if (!(serverVersion >= 80019)) throw FailedPredicateException(this, "serverVersion >= 80019");
      setState(2995);
      explicitTable();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- QuerySpecificationContext ------------------------------------------------------------------

MySQLParser::QuerySpecificationContext::QuerySpecificationContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::QuerySpecificationContext::SELECT_SYMBOL() {
  return getToken(MySQLParser::SELECT_SYMBOL, 0);
}

MySQLParser::SelectItemListContext* MySQLParser::QuerySpecificationContext::selectItemList() {
  return getRuleContext<MySQLParser::SelectItemListContext>(0);
}

std::vector<MySQLParser::SelectOptionContext *> MySQLParser::QuerySpecificationContext::selectOption() {
  return getRuleContexts<MySQLParser::SelectOptionContext>();
}

MySQLParser::SelectOptionContext* MySQLParser::QuerySpecificationContext::selectOption(size_t i) {
  return getRuleContext<MySQLParser::SelectOptionContext>(i);
}

MySQLParser::IntoClauseContext* MySQLParser::QuerySpecificationContext::intoClause() {
  return getRuleContext<MySQLParser::IntoClauseContext>(0);
}

MySQLParser::FromClauseContext* MySQLParser::QuerySpecificationContext::fromClause() {
  return getRuleContext<MySQLParser::FromClauseContext>(0);
}

MySQLParser::WhereClauseContext* MySQLParser::QuerySpecificationContext::whereClause() {
  return getRuleContext<MySQLParser::WhereClauseContext>(0);
}

MySQLParser::GroupByClauseContext* MySQLParser::QuerySpecificationContext::groupByClause() {
  return getRuleContext<MySQLParser::GroupByClauseContext>(0);
}

MySQLParser::HavingClauseContext* MySQLParser::QuerySpecificationContext::havingClause() {
  return getRuleContext<MySQLParser::HavingClauseContext>(0);
}

MySQLParser::WindowClauseContext* MySQLParser::QuerySpecificationContext::windowClause() {
  return getRuleContext<MySQLParser::WindowClauseContext>(0);
}


size_t MySQLParser::QuerySpecificationContext::getRuleIndex() const {
  return MySQLParser::RuleQuerySpecification;
}

void MySQLParser::QuerySpecificationContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterQuerySpecification(this);
}

void MySQLParser::QuerySpecificationContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitQuerySpecification(this);
}


std::any MySQLParser::QuerySpecificationContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitQuerySpecification(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::QuerySpecificationContext* MySQLParser::querySpecification() {
  QuerySpecificationContext *_localctx = _tracker.createInstance<QuerySpecificationContext>(_ctx, getState());
  enterRule(_localctx, 278, MySQLParser::RuleQuerySpecification);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    size_t alt;
    enterOuterAlt(_localctx, 1);
    setState(2998);
    match(MySQLParser::SELECT_SYMBOL);
    setState(3002);
    _errHandler->sync(this);
    alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 298, _ctx);
    while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER) {
      if (alt == 1) {
        setState(2999);
        selectOption(); 
      }
      setState(3004);
      _errHandler->sync(this);
      alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 298, _ctx);
    }
    setState(3005);
    selectItemList();
    setState(3007);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 299, _ctx)) {
    case 1: {
      setState(3006);
      intoClause();
      break;
    }

    default:
      break;
    }
    setState(3010);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 300, _ctx)) {
    case 1: {
      setState(3009);
      fromClause();
      break;
    }

    default:
      break;
    }
    setState(3013);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 301, _ctx)) {
    case 1: {
      setState(3012);
      whereClause();
      break;
    }

    default:
      break;
    }
    setState(3016);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 302, _ctx)) {
    case 1: {
      setState(3015);
      groupByClause();
      break;
    }

    default:
      break;
    }
    setState(3019);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 303, _ctx)) {
    case 1: {
      setState(3018);
      havingClause();
      break;
    }

    default:
      break;
    }
    setState(3023);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 304, _ctx)) {
    case 1: {
      setState(3021);

      if (!(serverVersion >= 80000)) throw FailedPredicateException(this, "serverVersion >= 80000");
      setState(3022);
      windowClause();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- SubqueryContext ------------------------------------------------------------------

MySQLParser::SubqueryContext::SubqueryContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::QueryExpressionParensContext* MySQLParser::SubqueryContext::queryExpressionParens() {
  return getRuleContext<MySQLParser::QueryExpressionParensContext>(0);
}


size_t MySQLParser::SubqueryContext::getRuleIndex() const {
  return MySQLParser::RuleSubquery;
}

void MySQLParser::SubqueryContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterSubquery(this);
}

void MySQLParser::SubqueryContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitSubquery(this);
}


std::any MySQLParser::SubqueryContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitSubquery(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::SubqueryContext* MySQLParser::subquery() {
  SubqueryContext *_localctx = _tracker.createInstance<SubqueryContext>(_ctx, getState());
  enterRule(_localctx, 280, MySQLParser::RuleSubquery);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3025);
    queryExpressionParens();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- QuerySpecOptionContext ------------------------------------------------------------------

MySQLParser::QuerySpecOptionContext::QuerySpecOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::QuerySpecOptionContext::ALL_SYMBOL() {
  return getToken(MySQLParser::ALL_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::QuerySpecOptionContext::DISTINCT_SYMBOL() {
  return getToken(MySQLParser::DISTINCT_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::QuerySpecOptionContext::STRAIGHT_JOIN_SYMBOL() {
  return getToken(MySQLParser::STRAIGHT_JOIN_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::QuerySpecOptionContext::HIGH_PRIORITY_SYMBOL() {
  return getToken(MySQLParser::HIGH_PRIORITY_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::QuerySpecOptionContext::SQL_SMALL_RESULT_SYMBOL() {
  return getToken(MySQLParser::SQL_SMALL_RESULT_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::QuerySpecOptionContext::SQL_BIG_RESULT_SYMBOL() {
  return getToken(MySQLParser::SQL_BIG_RESULT_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::QuerySpecOptionContext::SQL_BUFFER_RESULT_SYMBOL() {
  return getToken(MySQLParser::SQL_BUFFER_RESULT_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::QuerySpecOptionContext::SQL_CALC_FOUND_ROWS_SYMBOL() {
  return getToken(MySQLParser::SQL_CALC_FOUND_ROWS_SYMBOL, 0);
}


size_t MySQLParser::QuerySpecOptionContext::getRuleIndex() const {
  return MySQLParser::RuleQuerySpecOption;
}

void MySQLParser::QuerySpecOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterQuerySpecOption(this);
}

void MySQLParser::QuerySpecOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitQuerySpecOption(this);
}


std::any MySQLParser::QuerySpecOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitQuerySpecOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::QuerySpecOptionContext* MySQLParser::querySpecOption() {
  QuerySpecOptionContext *_localctx = _tracker.createInstance<QuerySpecOptionContext>(_ctx, getState());
  enterRule(_localctx, 282, MySQLParser::RuleQuerySpecOption);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3027);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::ALL_SYMBOL || _la == MySQLParser::DISTINCT_SYMBOL || _la == MySQLParser::HIGH_PRIORITY_SYMBOL || ((((_la - 531) & ~ 0x3fULL) == 0) &&
      ((1ULL << (_la - 531)) & 16777259) != 0))) {
    _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- LimitClauseContext ------------------------------------------------------------------

MySQLParser::LimitClauseContext::LimitClauseContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::LimitClauseContext::LIMIT_SYMBOL() {
  return getToken(MySQLParser::LIMIT_SYMBOL, 0);
}

MySQLParser::LimitOptionsContext* MySQLParser::LimitClauseContext::limitOptions() {
  return getRuleContext<MySQLParser::LimitOptionsContext>(0);
}


size_t MySQLParser::LimitClauseContext::getRuleIndex() const {
  return MySQLParser::RuleLimitClause;
}

void MySQLParser::LimitClauseContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterLimitClause(this);
}

void MySQLParser::LimitClauseContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitLimitClause(this);
}


std::any MySQLParser::LimitClauseContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitLimitClause(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::LimitClauseContext* MySQLParser::limitClause() {
  LimitClauseContext *_localctx = _tracker.createInstance<LimitClauseContext>(_ctx, getState());
  enterRule(_localctx, 284, MySQLParser::RuleLimitClause);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3029);
    match(MySQLParser::LIMIT_SYMBOL);
    setState(3030);
    limitOptions();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- SimpleLimitClauseContext ------------------------------------------------------------------

MySQLParser::SimpleLimitClauseContext::SimpleLimitClauseContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::SimpleLimitClauseContext::LIMIT_SYMBOL() {
  return getToken(MySQLParser::LIMIT_SYMBOL, 0);
}

MySQLParser::LimitOptionContext* MySQLParser::SimpleLimitClauseContext::limitOption() {
  return getRuleContext<MySQLParser::LimitOptionContext>(0);
}


size_t MySQLParser::SimpleLimitClauseContext::getRuleIndex() const {
  return MySQLParser::RuleSimpleLimitClause;
}

void MySQLParser::SimpleLimitClauseContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterSimpleLimitClause(this);
}

void MySQLParser::SimpleLimitClauseContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitSimpleLimitClause(this);
}


std::any MySQLParser::SimpleLimitClauseContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitSimpleLimitClause(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::SimpleLimitClauseContext* MySQLParser::simpleLimitClause() {
  SimpleLimitClauseContext *_localctx = _tracker.createInstance<SimpleLimitClauseContext>(_ctx, getState());
  enterRule(_localctx, 286, MySQLParser::RuleSimpleLimitClause);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3032);
    match(MySQLParser::LIMIT_SYMBOL);
    setState(3033);
    limitOption();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- LimitOptionsContext ------------------------------------------------------------------

MySQLParser::LimitOptionsContext::LimitOptionsContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

std::vector<MySQLParser::LimitOptionContext *> MySQLParser::LimitOptionsContext::limitOption() {
  return getRuleContexts<MySQLParser::LimitOptionContext>();
}

MySQLParser::LimitOptionContext* MySQLParser::LimitOptionsContext::limitOption(size_t i) {
  return getRuleContext<MySQLParser::LimitOptionContext>(i);
}

tree::TerminalNode* MySQLParser::LimitOptionsContext::COMMA_SYMBOL() {
  return getToken(MySQLParser::COMMA_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::LimitOptionsContext::OFFSET_SYMBOL() {
  return getToken(MySQLParser::OFFSET_SYMBOL, 0);
}


size_t MySQLParser::LimitOptionsContext::getRuleIndex() const {
  return MySQLParser::RuleLimitOptions;
}

void MySQLParser::LimitOptionsContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterLimitOptions(this);
}

void MySQLParser::LimitOptionsContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitLimitOptions(this);
}


std::any MySQLParser::LimitOptionsContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitLimitOptions(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::LimitOptionsContext* MySQLParser::limitOptions() {
  LimitOptionsContext *_localctx = _tracker.createInstance<LimitOptionsContext>(_ctx, getState());
  enterRule(_localctx, 288, MySQLParser::RuleLimitOptions);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3035);
    limitOption();
    setState(3038);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 305, _ctx)) {
    case 1: {
      setState(3036);
      _la = _input->LA(1);
      if (!(_la == MySQLParser::OFFSET_SYMBOL || _la == MySQLParser::COMMA_SYMBOL)) {
      _errHandler->recoverInline(this);
      }
      else {
        _errHandler->reportMatch(this);
        consume();
      }
      setState(3037);
      limitOption();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- LimitOptionContext ------------------------------------------------------------------

MySQLParser::LimitOptionContext::LimitOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::IdentifierContext* MySQLParser::LimitOptionContext::identifier() {
  return getRuleContext<MySQLParser::IdentifierContext>(0);
}

tree::TerminalNode* MySQLParser::LimitOptionContext::PARAM_MARKER() {
  return getToken(MySQLParser::PARAM_MARKER, 0);
}

tree::TerminalNode* MySQLParser::LimitOptionContext::ULONGLONG_NUMBER() {
  return getToken(MySQLParser::ULONGLONG_NUMBER, 0);
}

tree::TerminalNode* MySQLParser::LimitOptionContext::LONG_NUMBER() {
  return getToken(MySQLParser::LONG_NUMBER, 0);
}

tree::TerminalNode* MySQLParser::LimitOptionContext::INT_NUMBER() {
  return getToken(MySQLParser::INT_NUMBER, 0);
}


size_t MySQLParser::LimitOptionContext::getRuleIndex() const {
  return MySQLParser::RuleLimitOption;
}

void MySQLParser::LimitOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterLimitOption(this);
}

void MySQLParser::LimitOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitLimitOption(this);
}


std::any MySQLParser::LimitOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitLimitOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::LimitOptionContext* MySQLParser::limitOption() {
  LimitOptionContext *_localctx = _tracker.createInstance<LimitOptionContext>(_ctx, getState());
  enterRule(_localctx, 290, MySQLParser::RuleLimitOption);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(3042);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 306, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(3040);
      identifier();
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(3041);
      _la = _input->LA(1);
      if (!(((((_la - 747) & ~ 0x3fULL) == 0) &&
        ((1ULL << (_la - 747)) & 1099511627783) != 0))) {
      _errHandler->recoverInline(this);
      }
      else {
        _errHandler->reportMatch(this);
        consume();
      }
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- IntoClauseContext ------------------------------------------------------------------

MySQLParser::IntoClauseContext::IntoClauseContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::IntoClauseContext::INTO_SYMBOL() {
  return getToken(MySQLParser::INTO_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::IntoClauseContext::OUTFILE_SYMBOL() {
  return getToken(MySQLParser::OUTFILE_SYMBOL, 0);
}

MySQLParser::TextStringLiteralContext* MySQLParser::IntoClauseContext::textStringLiteral() {
  return getRuleContext<MySQLParser::TextStringLiteralContext>(0);
}

tree::TerminalNode* MySQLParser::IntoClauseContext::DUMPFILE_SYMBOL() {
  return getToken(MySQLParser::DUMPFILE_SYMBOL, 0);
}

std::vector<MySQLParser::TextOrIdentifierContext *> MySQLParser::IntoClauseContext::textOrIdentifier() {
  return getRuleContexts<MySQLParser::TextOrIdentifierContext>();
}

MySQLParser::TextOrIdentifierContext* MySQLParser::IntoClauseContext::textOrIdentifier(size_t i) {
  return getRuleContext<MySQLParser::TextOrIdentifierContext>(i);
}

std::vector<MySQLParser::UserVariableContext *> MySQLParser::IntoClauseContext::userVariable() {
  return getRuleContexts<MySQLParser::UserVariableContext>();
}

MySQLParser::UserVariableContext* MySQLParser::IntoClauseContext::userVariable(size_t i) {
  return getRuleContext<MySQLParser::UserVariableContext>(i);
}

MySQLParser::CharsetClauseContext* MySQLParser::IntoClauseContext::charsetClause() {
  return getRuleContext<MySQLParser::CharsetClauseContext>(0);
}

MySQLParser::FieldsClauseContext* MySQLParser::IntoClauseContext::fieldsClause() {
  return getRuleContext<MySQLParser::FieldsClauseContext>(0);
}

MySQLParser::LinesClauseContext* MySQLParser::IntoClauseContext::linesClause() {
  return getRuleContext<MySQLParser::LinesClauseContext>(0);
}

std::vector<tree::TerminalNode *> MySQLParser::IntoClauseContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::IntoClauseContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::IntoClauseContext::getRuleIndex() const {
  return MySQLParser::RuleIntoClause;
}

void MySQLParser::IntoClauseContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterIntoClause(this);
}

void MySQLParser::IntoClauseContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitIntoClause(this);
}


std::any MySQLParser::IntoClauseContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitIntoClause(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::IntoClauseContext* MySQLParser::intoClause() {
  IntoClauseContext *_localctx = _tracker.createInstance<IntoClauseContext>(_ctx, getState());
  enterRule(_localctx, 292, MySQLParser::RuleIntoClause);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    size_t alt;
    enterOuterAlt(_localctx, 1);
    setState(3044);
    match(MySQLParser::INTO_SYMBOL);
    setState(3072);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 313, _ctx)) {
    case 1: {
      setState(3045);
      match(MySQLParser::OUTFILE_SYMBOL);
      setState(3046);
      textStringLiteral();
      setState(3048);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 307, _ctx)) {
      case 1: {
        setState(3047);
        charsetClause();
        break;
      }

      default:
        break;
      }
      setState(3051);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 308, _ctx)) {
      case 1: {
        setState(3050);
        fieldsClause();
        break;
      }

      default:
        break;
      }
      setState(3054);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 309, _ctx)) {
      case 1: {
        setState(3053);
        linesClause();
        break;
      }

      default:
        break;
      }
      break;
    }

    case 2: {
      setState(3056);
      match(MySQLParser::DUMPFILE_SYMBOL);
      setState(3057);
      textStringLiteral();
      break;
    }

    case 3: {
      setState(3060);
      _errHandler->sync(this);
      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 310, _ctx)) {
      case 1: {
        setState(3058);
        textOrIdentifier();
        break;
      }

      case 2: {
        setState(3059);
        userVariable();
        break;
      }

      default:
        break;
      }
      setState(3069);
      _errHandler->sync(this);
      alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 312, _ctx);
      while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER) {
        if (alt == 1) {
          setState(3062);
          match(MySQLParser::COMMA_SYMBOL);
          setState(3065);
          _errHandler->sync(this);
          switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 311, _ctx)) {
          case 1: {
            setState(3063);
            textOrIdentifier();
            break;
          }

          case 2: {
            setState(3064);
            userVariable();
            break;
          }

          default:
            break;
          } 
        }
        setState(3071);
        _errHandler->sync(this);
        alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 312, _ctx);
      }
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- ProcedureAnalyseClauseContext ------------------------------------------------------------------

MySQLParser::ProcedureAnalyseClauseContext::ProcedureAnalyseClauseContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::ProcedureAnalyseClauseContext::PROCEDURE_SYMBOL() {
  return getToken(MySQLParser::PROCEDURE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ProcedureAnalyseClauseContext::ANALYSE_SYMBOL() {
  return getToken(MySQLParser::ANALYSE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ProcedureAnalyseClauseContext::OPEN_PAR_SYMBOL() {
  return getToken(MySQLParser::OPEN_PAR_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ProcedureAnalyseClauseContext::CLOSE_PAR_SYMBOL() {
  return getToken(MySQLParser::CLOSE_PAR_SYMBOL, 0);
}

std::vector<tree::TerminalNode *> MySQLParser::ProcedureAnalyseClauseContext::INT_NUMBER() {
  return getTokens(MySQLParser::INT_NUMBER);
}

tree::TerminalNode* MySQLParser::ProcedureAnalyseClauseContext::INT_NUMBER(size_t i) {
  return getToken(MySQLParser::INT_NUMBER, i);
}

tree::TerminalNode* MySQLParser::ProcedureAnalyseClauseContext::COMMA_SYMBOL() {
  return getToken(MySQLParser::COMMA_SYMBOL, 0);
}


size_t MySQLParser::ProcedureAnalyseClauseContext::getRuleIndex() const {
  return MySQLParser::RuleProcedureAnalyseClause;
}

void MySQLParser::ProcedureAnalyseClauseContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterProcedureAnalyseClause(this);
}

void MySQLParser::ProcedureAnalyseClauseContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitProcedureAnalyseClause(this);
}


std::any MySQLParser::ProcedureAnalyseClauseContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitProcedureAnalyseClause(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::ProcedureAnalyseClauseContext* MySQLParser::procedureAnalyseClause() {
  ProcedureAnalyseClauseContext *_localctx = _tracker.createInstance<ProcedureAnalyseClauseContext>(_ctx, getState());
  enterRule(_localctx, 294, MySQLParser::RuleProcedureAnalyseClause);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3074);
    match(MySQLParser::PROCEDURE_SYMBOL);
    setState(3075);
    match(MySQLParser::ANALYSE_SYMBOL);
    setState(3076);
    match(MySQLParser::OPEN_PAR_SYMBOL);
    setState(3082);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::INT_NUMBER) {
      setState(3077);
      match(MySQLParser::INT_NUMBER);
      setState(3080);
      _errHandler->sync(this);

      _la = _input->LA(1);
      if (_la == MySQLParser::COMMA_SYMBOL) {
        setState(3078);
        match(MySQLParser::COMMA_SYMBOL);
        setState(3079);
        match(MySQLParser::INT_NUMBER);
      }
    }
    setState(3084);
    match(MySQLParser::CLOSE_PAR_SYMBOL);
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- HavingClauseContext ------------------------------------------------------------------

MySQLParser::HavingClauseContext::HavingClauseContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::HavingClauseContext::HAVING_SYMBOL() {
  return getToken(MySQLParser::HAVING_SYMBOL, 0);
}

MySQLParser::ExprContext* MySQLParser::HavingClauseContext::expr() {
  return getRuleContext<MySQLParser::ExprContext>(0);
}


size_t MySQLParser::HavingClauseContext::getRuleIndex() const {
  return MySQLParser::RuleHavingClause;
}

void MySQLParser::HavingClauseContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterHavingClause(this);
}

void MySQLParser::HavingClauseContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitHavingClause(this);
}


std::any MySQLParser::HavingClauseContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitHavingClause(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::HavingClauseContext* MySQLParser::havingClause() {
  HavingClauseContext *_localctx = _tracker.createInstance<HavingClauseContext>(_ctx, getState());
  enterRule(_localctx, 296, MySQLParser::RuleHavingClause);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3086);
    match(MySQLParser::HAVING_SYMBOL);
    setState(3087);
    expr(0);
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- WindowClauseContext ------------------------------------------------------------------

MySQLParser::WindowClauseContext::WindowClauseContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::WindowClauseContext::WINDOW_SYMBOL() {
  return getToken(MySQLParser::WINDOW_SYMBOL, 0);
}

std::vector<MySQLParser::WindowDefinitionContext *> MySQLParser::WindowClauseContext::windowDefinition() {
  return getRuleContexts<MySQLParser::WindowDefinitionContext>();
}

MySQLParser::WindowDefinitionContext* MySQLParser::WindowClauseContext::windowDefinition(size_t i) {
  return getRuleContext<MySQLParser::WindowDefinitionContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::WindowClauseContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::WindowClauseContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::WindowClauseContext::getRuleIndex() const {
  return MySQLParser::RuleWindowClause;
}

void MySQLParser::WindowClauseContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterWindowClause(this);
}

void MySQLParser::WindowClauseContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitWindowClause(this);
}


std::any MySQLParser::WindowClauseContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitWindowClause(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::WindowClauseContext* MySQLParser::windowClause() {
  WindowClauseContext *_localctx = _tracker.createInstance<WindowClauseContext>(_ctx, getState());
  enterRule(_localctx, 298, MySQLParser::RuleWindowClause);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    size_t alt;
    enterOuterAlt(_localctx, 1);
    setState(3089);
    match(MySQLParser::WINDOW_SYMBOL);
    setState(3090);
    windowDefinition();
    setState(3095);
    _errHandler->sync(this);
    alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 316, _ctx);
    while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER) {
      if (alt == 1) {
        setState(3091);
        match(MySQLParser::COMMA_SYMBOL);
        setState(3092);
        windowDefinition(); 
      }
      setState(3097);
      _errHandler->sync(this);
      alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 316, _ctx);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- WindowDefinitionContext ------------------------------------------------------------------

MySQLParser::WindowDefinitionContext::WindowDefinitionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::WindowNameContext* MySQLParser::WindowDefinitionContext::windowName() {
  return getRuleContext<MySQLParser::WindowNameContext>(0);
}

tree::TerminalNode* MySQLParser::WindowDefinitionContext::AS_SYMBOL() {
  return getToken(MySQLParser::AS_SYMBOL, 0);
}

MySQLParser::WindowSpecContext* MySQLParser::WindowDefinitionContext::windowSpec() {
  return getRuleContext<MySQLParser::WindowSpecContext>(0);
}


size_t MySQLParser::WindowDefinitionContext::getRuleIndex() const {
  return MySQLParser::RuleWindowDefinition;
}

void MySQLParser::WindowDefinitionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterWindowDefinition(this);
}

void MySQLParser::WindowDefinitionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitWindowDefinition(this);
}


std::any MySQLParser::WindowDefinitionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitWindowDefinition(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::WindowDefinitionContext* MySQLParser::windowDefinition() {
  WindowDefinitionContext *_localctx = _tracker.createInstance<WindowDefinitionContext>(_ctx, getState());
  enterRule(_localctx, 300, MySQLParser::RuleWindowDefinition);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3098);
    windowName();
    setState(3099);
    match(MySQLParser::AS_SYMBOL);
    setState(3100);
    windowSpec();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- WindowSpecContext ------------------------------------------------------------------

MySQLParser::WindowSpecContext::WindowSpecContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::WindowSpecContext::OPEN_PAR_SYMBOL() {
  return getToken(MySQLParser::OPEN_PAR_SYMBOL, 0);
}

MySQLParser::WindowSpecDetailsContext* MySQLParser::WindowSpecContext::windowSpecDetails() {
  return getRuleContext<MySQLParser::WindowSpecDetailsContext>(0);
}

tree::TerminalNode* MySQLParser::WindowSpecContext::CLOSE_PAR_SYMBOL() {
  return getToken(MySQLParser::CLOSE_PAR_SYMBOL, 0);
}


size_t MySQLParser::WindowSpecContext::getRuleIndex() const {
  return MySQLParser::RuleWindowSpec;
}

void MySQLParser::WindowSpecContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterWindowSpec(this);
}

void MySQLParser::WindowSpecContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitWindowSpec(this);
}


std::any MySQLParser::WindowSpecContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitWindowSpec(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::WindowSpecContext* MySQLParser::windowSpec() {
  WindowSpecContext *_localctx = _tracker.createInstance<WindowSpecContext>(_ctx, getState());
  enterRule(_localctx, 302, MySQLParser::RuleWindowSpec);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3102);
    match(MySQLParser::OPEN_PAR_SYMBOL);
    setState(3103);
    windowSpecDetails();
    setState(3104);
    match(MySQLParser::CLOSE_PAR_SYMBOL);
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- WindowSpecDetailsContext ------------------------------------------------------------------

MySQLParser::WindowSpecDetailsContext::WindowSpecDetailsContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::WindowNameContext* MySQLParser::WindowSpecDetailsContext::windowName() {
  return getRuleContext<MySQLParser::WindowNameContext>(0);
}

tree::TerminalNode* MySQLParser::WindowSpecDetailsContext::PARTITION_SYMBOL() {
  return getToken(MySQLParser::PARTITION_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::WindowSpecDetailsContext::BY_SYMBOL() {
  return getToken(MySQLParser::BY_SYMBOL, 0);
}

MySQLParser::OrderListContext* MySQLParser::WindowSpecDetailsContext::orderList() {
  return getRuleContext<MySQLParser::OrderListContext>(0);
}

MySQLParser::OrderClauseContext* MySQLParser::WindowSpecDetailsContext::orderClause() {
  return getRuleContext<MySQLParser::OrderClauseContext>(0);
}

MySQLParser::WindowFrameClauseContext* MySQLParser::WindowSpecDetailsContext::windowFrameClause() {
  return getRuleContext<MySQLParser::WindowFrameClauseContext>(0);
}


size_t MySQLParser::WindowSpecDetailsContext::getRuleIndex() const {
  return MySQLParser::RuleWindowSpecDetails;
}

void MySQLParser::WindowSpecDetailsContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterWindowSpecDetails(this);
}

void MySQLParser::WindowSpecDetailsContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitWindowSpecDetails(this);
}


std::any MySQLParser::WindowSpecDetailsContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitWindowSpecDetails(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::WindowSpecDetailsContext* MySQLParser::windowSpecDetails() {
  WindowSpecDetailsContext *_localctx = _tracker.createInstance<WindowSpecDetailsContext>(_ctx, getState());
  enterRule(_localctx, 304, MySQLParser::RuleWindowSpecDetails);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3107);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 317, _ctx)) {
    case 1: {
      setState(3106);
      windowName();
      break;
    }

    default:
      break;
    }
    setState(3112);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::PARTITION_SYMBOL) {
      setState(3109);
      match(MySQLParser::PARTITION_SYMBOL);
      setState(3110);
      match(MySQLParser::BY_SYMBOL);
      setState(3111);
      orderList();
    }
    setState(3115);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::ORDER_SYMBOL) {
      setState(3114);
      orderClause();
    }
    setState(3118);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::RANGE_SYMBOL

    || _la == MySQLParser::ROWS_SYMBOL || _la == MySQLParser::GROUPS_SYMBOL) {
      setState(3117);
      windowFrameClause();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- WindowFrameClauseContext ------------------------------------------------------------------

MySQLParser::WindowFrameClauseContext::WindowFrameClauseContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::WindowFrameUnitsContext* MySQLParser::WindowFrameClauseContext::windowFrameUnits() {
  return getRuleContext<MySQLParser::WindowFrameUnitsContext>(0);
}

MySQLParser::WindowFrameExtentContext* MySQLParser::WindowFrameClauseContext::windowFrameExtent() {
  return getRuleContext<MySQLParser::WindowFrameExtentContext>(0);
}

MySQLParser::WindowFrameExclusionContext* MySQLParser::WindowFrameClauseContext::windowFrameExclusion() {
  return getRuleContext<MySQLParser::WindowFrameExclusionContext>(0);
}


size_t MySQLParser::WindowFrameClauseContext::getRuleIndex() const {
  return MySQLParser::RuleWindowFrameClause;
}

void MySQLParser::WindowFrameClauseContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterWindowFrameClause(this);
}

void MySQLParser::WindowFrameClauseContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitWindowFrameClause(this);
}


std::any MySQLParser::WindowFrameClauseContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitWindowFrameClause(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::WindowFrameClauseContext* MySQLParser::windowFrameClause() {
  WindowFrameClauseContext *_localctx = _tracker.createInstance<WindowFrameClauseContext>(_ctx, getState());
  enterRule(_localctx, 306, MySQLParser::RuleWindowFrameClause);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3120);
    windowFrameUnits();
    setState(3121);
    windowFrameExtent();
    setState(3123);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::EXCLUDE_SYMBOL) {
      setState(3122);
      windowFrameExclusion();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- WindowFrameUnitsContext ------------------------------------------------------------------

MySQLParser::WindowFrameUnitsContext::WindowFrameUnitsContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::WindowFrameUnitsContext::ROWS_SYMBOL() {
  return getToken(MySQLParser::ROWS_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::WindowFrameUnitsContext::RANGE_SYMBOL() {
  return getToken(MySQLParser::RANGE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::WindowFrameUnitsContext::GROUPS_SYMBOL() {
  return getToken(MySQLParser::GROUPS_SYMBOL, 0);
}


size_t MySQLParser::WindowFrameUnitsContext::getRuleIndex() const {
  return MySQLParser::RuleWindowFrameUnits;
}

void MySQLParser::WindowFrameUnitsContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterWindowFrameUnits(this);
}

void MySQLParser::WindowFrameUnitsContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitWindowFrameUnits(this);
}


std::any MySQLParser::WindowFrameUnitsContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitWindowFrameUnits(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::WindowFrameUnitsContext* MySQLParser::windowFrameUnits() {
  WindowFrameUnitsContext *_localctx = _tracker.createInstance<WindowFrameUnitsContext>(_ctx, getState());
  enterRule(_localctx, 308, MySQLParser::RuleWindowFrameUnits);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3125);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::RANGE_SYMBOL

    || _la == MySQLParser::ROWS_SYMBOL || _la == MySQLParser::GROUPS_SYMBOL)) {
    _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- WindowFrameExtentContext ------------------------------------------------------------------

MySQLParser::WindowFrameExtentContext::WindowFrameExtentContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::WindowFrameStartContext* MySQLParser::WindowFrameExtentContext::windowFrameStart() {
  return getRuleContext<MySQLParser::WindowFrameStartContext>(0);
}

MySQLParser::WindowFrameBetweenContext* MySQLParser::WindowFrameExtentContext::windowFrameBetween() {
  return getRuleContext<MySQLParser::WindowFrameBetweenContext>(0);
}


size_t MySQLParser::WindowFrameExtentContext::getRuleIndex() const {
  return MySQLParser::RuleWindowFrameExtent;
}

void MySQLParser::WindowFrameExtentContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterWindowFrameExtent(this);
}

void MySQLParser::WindowFrameExtentContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitWindowFrameExtent(this);
}


std::any MySQLParser::WindowFrameExtentContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitWindowFrameExtent(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::WindowFrameExtentContext* MySQLParser::windowFrameExtent() {
  WindowFrameExtentContext *_localctx = _tracker.createInstance<WindowFrameExtentContext>(_ctx, getState());
  enterRule(_localctx, 310, MySQLParser::RuleWindowFrameExtent);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(3129);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::CURRENT_SYMBOL:
      case MySQLParser::INTERVAL_SYMBOL:
      case MySQLParser::UNBOUNDED_SYMBOL:
      case MySQLParser::INT_NUMBER:
      case MySQLParser::LONG_NUMBER:
      case MySQLParser::ULONGLONG_NUMBER:
      case MySQLParser::PARAM_MARKER:
      case MySQLParser::DECIMAL_NUMBER:
      case MySQLParser::FLOAT_NUMBER: {
        enterOuterAlt(_localctx, 1);
        setState(3127);
        windowFrameStart();
        break;
      }

      case MySQLParser::BETWEEN_SYMBOL: {
        enterOuterAlt(_localctx, 2);
        setState(3128);
        windowFrameBetween();
        break;
      }

    default:
      throw NoViableAltException(this);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- WindowFrameStartContext ------------------------------------------------------------------

MySQLParser::WindowFrameStartContext::WindowFrameStartContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::WindowFrameStartContext::UNBOUNDED_SYMBOL() {
  return getToken(MySQLParser::UNBOUNDED_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::WindowFrameStartContext::PRECEDING_SYMBOL() {
  return getToken(MySQLParser::PRECEDING_SYMBOL, 0);
}

MySQLParser::Ulonglong_numberContext* MySQLParser::WindowFrameStartContext::ulonglong_number() {
  return getRuleContext<MySQLParser::Ulonglong_numberContext>(0);
}

tree::TerminalNode* MySQLParser::WindowFrameStartContext::PARAM_MARKER() {
  return getToken(MySQLParser::PARAM_MARKER, 0);
}

tree::TerminalNode* MySQLParser::WindowFrameStartContext::INTERVAL_SYMBOL() {
  return getToken(MySQLParser::INTERVAL_SYMBOL, 0);
}

MySQLParser::ExprContext* MySQLParser::WindowFrameStartContext::expr() {
  return getRuleContext<MySQLParser::ExprContext>(0);
}

MySQLParser::IntervalContext* MySQLParser::WindowFrameStartContext::interval() {
  return getRuleContext<MySQLParser::IntervalContext>(0);
}

tree::TerminalNode* MySQLParser::WindowFrameStartContext::CURRENT_SYMBOL() {
  return getToken(MySQLParser::CURRENT_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::WindowFrameStartContext::ROW_SYMBOL() {
  return getToken(MySQLParser::ROW_SYMBOL, 0);
}


size_t MySQLParser::WindowFrameStartContext::getRuleIndex() const {
  return MySQLParser::RuleWindowFrameStart;
}

void MySQLParser::WindowFrameStartContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterWindowFrameStart(this);
}

void MySQLParser::WindowFrameStartContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitWindowFrameStart(this);
}


std::any MySQLParser::WindowFrameStartContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitWindowFrameStart(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::WindowFrameStartContext* MySQLParser::windowFrameStart() {
  WindowFrameStartContext *_localctx = _tracker.createInstance<WindowFrameStartContext>(_ctx, getState());
  enterRule(_localctx, 312, MySQLParser::RuleWindowFrameStart);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(3145);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::UNBOUNDED_SYMBOL: {
        enterOuterAlt(_localctx, 1);
        setState(3131);
        match(MySQLParser::UNBOUNDED_SYMBOL);
        setState(3132);
        match(MySQLParser::PRECEDING_SYMBOL);
        break;
      }

      case MySQLParser::INT_NUMBER:
      case MySQLParser::LONG_NUMBER:
      case MySQLParser::ULONGLONG_NUMBER:
      case MySQLParser::DECIMAL_NUMBER:
      case MySQLParser::FLOAT_NUMBER: {
        enterOuterAlt(_localctx, 2);
        setState(3133);
        ulonglong_number();
        setState(3134);
        match(MySQLParser::PRECEDING_SYMBOL);
        break;
      }

      case MySQLParser::PARAM_MARKER: {
        enterOuterAlt(_localctx, 3);
        setState(3136);
        match(MySQLParser::PARAM_MARKER);
        setState(3137);
        match(MySQLParser::PRECEDING_SYMBOL);
        break;
      }

      case MySQLParser::INTERVAL_SYMBOL: {
        enterOuterAlt(_localctx, 4);
        setState(3138);
        match(MySQLParser::INTERVAL_SYMBOL);
        setState(3139);
        expr(0);
        setState(3140);
        interval();
        setState(3141);
        match(MySQLParser::PRECEDING_SYMBOL);
        break;
      }

      case MySQLParser::CURRENT_SYMBOL: {
        enterOuterAlt(_localctx, 5);
        setState(3143);
        match(MySQLParser::CURRENT_SYMBOL);
        setState(3144);
        match(MySQLParser::ROW_SYMBOL);
        break;
      }

    default:
      throw NoViableAltException(this);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- WindowFrameBetweenContext ------------------------------------------------------------------

MySQLParser::WindowFrameBetweenContext::WindowFrameBetweenContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::WindowFrameBetweenContext::BETWEEN_SYMBOL() {
  return getToken(MySQLParser::BETWEEN_SYMBOL, 0);
}

std::vector<MySQLParser::WindowFrameBoundContext *> MySQLParser::WindowFrameBetweenContext::windowFrameBound() {
  return getRuleContexts<MySQLParser::WindowFrameBoundContext>();
}

MySQLParser::WindowFrameBoundContext* MySQLParser::WindowFrameBetweenContext::windowFrameBound(size_t i) {
  return getRuleContext<MySQLParser::WindowFrameBoundContext>(i);
}

tree::TerminalNode* MySQLParser::WindowFrameBetweenContext::AND_SYMBOL() {
  return getToken(MySQLParser::AND_SYMBOL, 0);
}


size_t MySQLParser::WindowFrameBetweenContext::getRuleIndex() const {
  return MySQLParser::RuleWindowFrameBetween;
}

void MySQLParser::WindowFrameBetweenContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterWindowFrameBetween(this);
}

void MySQLParser::WindowFrameBetweenContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitWindowFrameBetween(this);
}


std::any MySQLParser::WindowFrameBetweenContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitWindowFrameBetween(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::WindowFrameBetweenContext* MySQLParser::windowFrameBetween() {
  WindowFrameBetweenContext *_localctx = _tracker.createInstance<WindowFrameBetweenContext>(_ctx, getState());
  enterRule(_localctx, 314, MySQLParser::RuleWindowFrameBetween);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3147);
    match(MySQLParser::BETWEEN_SYMBOL);
    setState(3148);
    windowFrameBound();
    setState(3149);
    match(MySQLParser::AND_SYMBOL);
    setState(3150);
    windowFrameBound();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- WindowFrameBoundContext ------------------------------------------------------------------

MySQLParser::WindowFrameBoundContext::WindowFrameBoundContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::WindowFrameStartContext* MySQLParser::WindowFrameBoundContext::windowFrameStart() {
  return getRuleContext<MySQLParser::WindowFrameStartContext>(0);
}

tree::TerminalNode* MySQLParser::WindowFrameBoundContext::UNBOUNDED_SYMBOL() {
  return getToken(MySQLParser::UNBOUNDED_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::WindowFrameBoundContext::FOLLOWING_SYMBOL() {
  return getToken(MySQLParser::FOLLOWING_SYMBOL, 0);
}

MySQLParser::Ulonglong_numberContext* MySQLParser::WindowFrameBoundContext::ulonglong_number() {
  return getRuleContext<MySQLParser::Ulonglong_numberContext>(0);
}

tree::TerminalNode* MySQLParser::WindowFrameBoundContext::PARAM_MARKER() {
  return getToken(MySQLParser::PARAM_MARKER, 0);
}

tree::TerminalNode* MySQLParser::WindowFrameBoundContext::INTERVAL_SYMBOL() {
  return getToken(MySQLParser::INTERVAL_SYMBOL, 0);
}

MySQLParser::ExprContext* MySQLParser::WindowFrameBoundContext::expr() {
  return getRuleContext<MySQLParser::ExprContext>(0);
}

MySQLParser::IntervalContext* MySQLParser::WindowFrameBoundContext::interval() {
  return getRuleContext<MySQLParser::IntervalContext>(0);
}


size_t MySQLParser::WindowFrameBoundContext::getRuleIndex() const {
  return MySQLParser::RuleWindowFrameBound;
}

void MySQLParser::WindowFrameBoundContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterWindowFrameBound(this);
}

void MySQLParser::WindowFrameBoundContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitWindowFrameBound(this);
}


std::any MySQLParser::WindowFrameBoundContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitWindowFrameBound(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::WindowFrameBoundContext* MySQLParser::windowFrameBound() {
  WindowFrameBoundContext *_localctx = _tracker.createInstance<WindowFrameBoundContext>(_ctx, getState());
  enterRule(_localctx, 316, MySQLParser::RuleWindowFrameBound);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(3165);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 324, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(3152);
      windowFrameStart();
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(3153);
      match(MySQLParser::UNBOUNDED_SYMBOL);
      setState(3154);
      match(MySQLParser::FOLLOWING_SYMBOL);
      break;
    }

    case 3: {
      enterOuterAlt(_localctx, 3);
      setState(3155);
      ulonglong_number();
      setState(3156);
      match(MySQLParser::FOLLOWING_SYMBOL);
      break;
    }

    case 4: {
      enterOuterAlt(_localctx, 4);
      setState(3158);
      match(MySQLParser::PARAM_MARKER);
      setState(3159);
      match(MySQLParser::FOLLOWING_SYMBOL);
      break;
    }

    case 5: {
      enterOuterAlt(_localctx, 5);
      setState(3160);
      match(MySQLParser::INTERVAL_SYMBOL);
      setState(3161);
      expr(0);
      setState(3162);
      interval();
      setState(3163);
      match(MySQLParser::FOLLOWING_SYMBOL);
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- WindowFrameExclusionContext ------------------------------------------------------------------

MySQLParser::WindowFrameExclusionContext::WindowFrameExclusionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::WindowFrameExclusionContext::EXCLUDE_SYMBOL() {
  return getToken(MySQLParser::EXCLUDE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::WindowFrameExclusionContext::CURRENT_SYMBOL() {
  return getToken(MySQLParser::CURRENT_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::WindowFrameExclusionContext::ROW_SYMBOL() {
  return getToken(MySQLParser::ROW_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::WindowFrameExclusionContext::GROUP_SYMBOL() {
  return getToken(MySQLParser::GROUP_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::WindowFrameExclusionContext::TIES_SYMBOL() {
  return getToken(MySQLParser::TIES_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::WindowFrameExclusionContext::NO_SYMBOL() {
  return getToken(MySQLParser::NO_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::WindowFrameExclusionContext::OTHERS_SYMBOL() {
  return getToken(MySQLParser::OTHERS_SYMBOL, 0);
}


size_t MySQLParser::WindowFrameExclusionContext::getRuleIndex() const {
  return MySQLParser::RuleWindowFrameExclusion;
}

void MySQLParser::WindowFrameExclusionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterWindowFrameExclusion(this);
}

void MySQLParser::WindowFrameExclusionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitWindowFrameExclusion(this);
}


std::any MySQLParser::WindowFrameExclusionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitWindowFrameExclusion(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::WindowFrameExclusionContext* MySQLParser::windowFrameExclusion() {
  WindowFrameExclusionContext *_localctx = _tracker.createInstance<WindowFrameExclusionContext>(_ctx, getState());
  enterRule(_localctx, 318, MySQLParser::RuleWindowFrameExclusion);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3167);
    match(MySQLParser::EXCLUDE_SYMBOL);
    setState(3174);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::CURRENT_SYMBOL: {
        setState(3168);
        match(MySQLParser::CURRENT_SYMBOL);
        setState(3169);
        match(MySQLParser::ROW_SYMBOL);
        break;
      }

      case MySQLParser::GROUP_SYMBOL: {
        setState(3170);
        match(MySQLParser::GROUP_SYMBOL);
        break;
      }

      case MySQLParser::TIES_SYMBOL: {
        setState(3171);
        match(MySQLParser::TIES_SYMBOL);
        break;
      }

      case MySQLParser::NO_SYMBOL: {
        setState(3172);
        match(MySQLParser::NO_SYMBOL);
        setState(3173);
        match(MySQLParser::OTHERS_SYMBOL);
        break;
      }

    default:
      throw NoViableAltException(this);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- WithClauseContext ------------------------------------------------------------------

MySQLParser::WithClauseContext::WithClauseContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::WithClauseContext::WITH_SYMBOL() {
  return getToken(MySQLParser::WITH_SYMBOL, 0);
}

std::vector<MySQLParser::CommonTableExpressionContext *> MySQLParser::WithClauseContext::commonTableExpression() {
  return getRuleContexts<MySQLParser::CommonTableExpressionContext>();
}

MySQLParser::CommonTableExpressionContext* MySQLParser::WithClauseContext::commonTableExpression(size_t i) {
  return getRuleContext<MySQLParser::CommonTableExpressionContext>(i);
}

tree::TerminalNode* MySQLParser::WithClauseContext::RECURSIVE_SYMBOL() {
  return getToken(MySQLParser::RECURSIVE_SYMBOL, 0);
}

std::vector<tree::TerminalNode *> MySQLParser::WithClauseContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::WithClauseContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::WithClauseContext::getRuleIndex() const {
  return MySQLParser::RuleWithClause;
}

void MySQLParser::WithClauseContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterWithClause(this);
}

void MySQLParser::WithClauseContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitWithClause(this);
}


std::any MySQLParser::WithClauseContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitWithClause(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::WithClauseContext* MySQLParser::withClause() {
  WithClauseContext *_localctx = _tracker.createInstance<WithClauseContext>(_ctx, getState());
  enterRule(_localctx, 320, MySQLParser::RuleWithClause);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    size_t alt;
    enterOuterAlt(_localctx, 1);
    setState(3176);
    match(MySQLParser::WITH_SYMBOL);
    setState(3178);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 326, _ctx)) {
    case 1: {
      setState(3177);
      match(MySQLParser::RECURSIVE_SYMBOL);
      break;
    }

    default:
      break;
    }
    setState(3180);
    commonTableExpression();
    setState(3185);
    _errHandler->sync(this);
    alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 327, _ctx);
    while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER) {
      if (alt == 1) {
        setState(3181);
        match(MySQLParser::COMMA_SYMBOL);
        setState(3182);
        commonTableExpression(); 
      }
      setState(3187);
      _errHandler->sync(this);
      alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 327, _ctx);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- CommonTableExpressionContext ------------------------------------------------------------------

MySQLParser::CommonTableExpressionContext::CommonTableExpressionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::IdentifierContext* MySQLParser::CommonTableExpressionContext::identifier() {
  return getRuleContext<MySQLParser::IdentifierContext>(0);
}

tree::TerminalNode* MySQLParser::CommonTableExpressionContext::AS_SYMBOL() {
  return getToken(MySQLParser::AS_SYMBOL, 0);
}

MySQLParser::SubqueryContext* MySQLParser::CommonTableExpressionContext::subquery() {
  return getRuleContext<MySQLParser::SubqueryContext>(0);
}

MySQLParser::ColumnInternalRefListContext* MySQLParser::CommonTableExpressionContext::columnInternalRefList() {
  return getRuleContext<MySQLParser::ColumnInternalRefListContext>(0);
}


size_t MySQLParser::CommonTableExpressionContext::getRuleIndex() const {
  return MySQLParser::RuleCommonTableExpression;
}

void MySQLParser::CommonTableExpressionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterCommonTableExpression(this);
}

void MySQLParser::CommonTableExpressionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitCommonTableExpression(this);
}


std::any MySQLParser::CommonTableExpressionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitCommonTableExpression(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::CommonTableExpressionContext* MySQLParser::commonTableExpression() {
  CommonTableExpressionContext *_localctx = _tracker.createInstance<CommonTableExpressionContext>(_ctx, getState());
  enterRule(_localctx, 322, MySQLParser::RuleCommonTableExpression);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3188);
    identifier();
    setState(3190);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::OPEN_PAR_SYMBOL) {
      setState(3189);
      columnInternalRefList();
    }
    setState(3192);
    match(MySQLParser::AS_SYMBOL);
    setState(3193);
    subquery();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- GroupByClauseContext ------------------------------------------------------------------

MySQLParser::GroupByClauseContext::GroupByClauseContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::GroupByClauseContext::GROUP_SYMBOL() {
  return getToken(MySQLParser::GROUP_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::GroupByClauseContext::BY_SYMBOL() {
  return getToken(MySQLParser::BY_SYMBOL, 0);
}

MySQLParser::OrderListContext* MySQLParser::GroupByClauseContext::orderList() {
  return getRuleContext<MySQLParser::OrderListContext>(0);
}

MySQLParser::OlapOptionContext* MySQLParser::GroupByClauseContext::olapOption() {
  return getRuleContext<MySQLParser::OlapOptionContext>(0);
}


size_t MySQLParser::GroupByClauseContext::getRuleIndex() const {
  return MySQLParser::RuleGroupByClause;
}

void MySQLParser::GroupByClauseContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterGroupByClause(this);
}

void MySQLParser::GroupByClauseContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitGroupByClause(this);
}


std::any MySQLParser::GroupByClauseContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitGroupByClause(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::GroupByClauseContext* MySQLParser::groupByClause() {
  GroupByClauseContext *_localctx = _tracker.createInstance<GroupByClauseContext>(_ctx, getState());
  enterRule(_localctx, 324, MySQLParser::RuleGroupByClause);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3195);
    match(MySQLParser::GROUP_SYMBOL);
    setState(3196);
    match(MySQLParser::BY_SYMBOL);
    setState(3197);
    orderList();
    setState(3199);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 329, _ctx)) {
    case 1: {
      setState(3198);
      olapOption();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- OlapOptionContext ------------------------------------------------------------------

MySQLParser::OlapOptionContext::OlapOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::OlapOptionContext::WITH_SYMBOL() {
  return getToken(MySQLParser::WITH_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::OlapOptionContext::ROLLUP_SYMBOL() {
  return getToken(MySQLParser::ROLLUP_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::OlapOptionContext::CUBE_SYMBOL() {
  return getToken(MySQLParser::CUBE_SYMBOL, 0);
}


size_t MySQLParser::OlapOptionContext::getRuleIndex() const {
  return MySQLParser::RuleOlapOption;
}

void MySQLParser::OlapOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterOlapOption(this);
}

void MySQLParser::OlapOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitOlapOption(this);
}


std::any MySQLParser::OlapOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitOlapOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::OlapOptionContext* MySQLParser::olapOption() {
  OlapOptionContext *_localctx = _tracker.createInstance<OlapOptionContext>(_ctx, getState());
  enterRule(_localctx, 326, MySQLParser::RuleOlapOption);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(3206);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 330, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(3201);
      match(MySQLParser::WITH_SYMBOL);
      setState(3202);
      match(MySQLParser::ROLLUP_SYMBOL);
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(3203);

      if (!(serverVersion < 80000)) throw FailedPredicateException(this, "serverVersion < 80000");
      setState(3204);
      match(MySQLParser::WITH_SYMBOL);
      setState(3205);
      match(MySQLParser::CUBE_SYMBOL);
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- OrderClauseContext ------------------------------------------------------------------

MySQLParser::OrderClauseContext::OrderClauseContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::OrderClauseContext::ORDER_SYMBOL() {
  return getToken(MySQLParser::ORDER_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::OrderClauseContext::BY_SYMBOL() {
  return getToken(MySQLParser::BY_SYMBOL, 0);
}

MySQLParser::OrderListContext* MySQLParser::OrderClauseContext::orderList() {
  return getRuleContext<MySQLParser::OrderListContext>(0);
}


size_t MySQLParser::OrderClauseContext::getRuleIndex() const {
  return MySQLParser::RuleOrderClause;
}

void MySQLParser::OrderClauseContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterOrderClause(this);
}

void MySQLParser::OrderClauseContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitOrderClause(this);
}


std::any MySQLParser::OrderClauseContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitOrderClause(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::OrderClauseContext* MySQLParser::orderClause() {
  OrderClauseContext *_localctx = _tracker.createInstance<OrderClauseContext>(_ctx, getState());
  enterRule(_localctx, 328, MySQLParser::RuleOrderClause);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3208);
    match(MySQLParser::ORDER_SYMBOL);
    setState(3209);
    match(MySQLParser::BY_SYMBOL);
    setState(3210);
    orderList();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DirectionContext ------------------------------------------------------------------

MySQLParser::DirectionContext::DirectionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::DirectionContext::ASC_SYMBOL() {
  return getToken(MySQLParser::ASC_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::DirectionContext::DESC_SYMBOL() {
  return getToken(MySQLParser::DESC_SYMBOL, 0);
}


size_t MySQLParser::DirectionContext::getRuleIndex() const {
  return MySQLParser::RuleDirection;
}

void MySQLParser::DirectionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDirection(this);
}

void MySQLParser::DirectionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDirection(this);
}


std::any MySQLParser::DirectionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDirection(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DirectionContext* MySQLParser::direction() {
  DirectionContext *_localctx = _tracker.createInstance<DirectionContext>(_ctx, getState());
  enterRule(_localctx, 330, MySQLParser::RuleDirection);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3212);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::ASC_SYMBOL || _la == MySQLParser::DESC_SYMBOL)) {
    _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- FromClauseContext ------------------------------------------------------------------

MySQLParser::FromClauseContext::FromClauseContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::FromClauseContext::FROM_SYMBOL() {
  return getToken(MySQLParser::FROM_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::FromClauseContext::DUAL_SYMBOL() {
  return getToken(MySQLParser::DUAL_SYMBOL, 0);
}

MySQLParser::TableReferenceListContext* MySQLParser::FromClauseContext::tableReferenceList() {
  return getRuleContext<MySQLParser::TableReferenceListContext>(0);
}


size_t MySQLParser::FromClauseContext::getRuleIndex() const {
  return MySQLParser::RuleFromClause;
}

void MySQLParser::FromClauseContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterFromClause(this);
}

void MySQLParser::FromClauseContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitFromClause(this);
}


std::any MySQLParser::FromClauseContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitFromClause(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::FromClauseContext* MySQLParser::fromClause() {
  FromClauseContext *_localctx = _tracker.createInstance<FromClauseContext>(_ctx, getState());
  enterRule(_localctx, 332, MySQLParser::RuleFromClause);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3214);
    match(MySQLParser::FROM_SYMBOL);
    setState(3217);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 331, _ctx)) {
    case 1: {
      setState(3215);
      match(MySQLParser::DUAL_SYMBOL);
      break;
    }

    case 2: {
      setState(3216);
      tableReferenceList();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TableReferenceListContext ------------------------------------------------------------------

MySQLParser::TableReferenceListContext::TableReferenceListContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

std::vector<MySQLParser::TableReferenceContext *> MySQLParser::TableReferenceListContext::tableReference() {
  return getRuleContexts<MySQLParser::TableReferenceContext>();
}

MySQLParser::TableReferenceContext* MySQLParser::TableReferenceListContext::tableReference(size_t i) {
  return getRuleContext<MySQLParser::TableReferenceContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::TableReferenceListContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::TableReferenceListContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::TableReferenceListContext::getRuleIndex() const {
  return MySQLParser::RuleTableReferenceList;
}

void MySQLParser::TableReferenceListContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTableReferenceList(this);
}

void MySQLParser::TableReferenceListContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTableReferenceList(this);
}


std::any MySQLParser::TableReferenceListContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTableReferenceList(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TableReferenceListContext* MySQLParser::tableReferenceList() {
  TableReferenceListContext *_localctx = _tracker.createInstance<TableReferenceListContext>(_ctx, getState());
  enterRule(_localctx, 334, MySQLParser::RuleTableReferenceList);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    size_t alt;
    enterOuterAlt(_localctx, 1);
    setState(3219);
    tableReference();
    setState(3224);
    _errHandler->sync(this);
    alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 332, _ctx);
    while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER) {
      if (alt == 1) {
        setState(3220);
        match(MySQLParser::COMMA_SYMBOL);
        setState(3221);
        tableReference(); 
      }
      setState(3226);
      _errHandler->sync(this);
      alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 332, _ctx);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TableValueConstructorContext ------------------------------------------------------------------

MySQLParser::TableValueConstructorContext::TableValueConstructorContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::TableValueConstructorContext::VALUES_SYMBOL() {
  return getToken(MySQLParser::VALUES_SYMBOL, 0);
}

std::vector<MySQLParser::RowValueExplicitContext *> MySQLParser::TableValueConstructorContext::rowValueExplicit() {
  return getRuleContexts<MySQLParser::RowValueExplicitContext>();
}

MySQLParser::RowValueExplicitContext* MySQLParser::TableValueConstructorContext::rowValueExplicit(size_t i) {
  return getRuleContext<MySQLParser::RowValueExplicitContext>(i);
}

std::vector<tree::TerminalNode *> MySQLParser::TableValueConstructorContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::TableValueConstructorContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::TableValueConstructorContext::getRuleIndex() const {
  return MySQLParser::RuleTableValueConstructor;
}

void MySQLParser::TableValueConstructorContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTableValueConstructor(this);
}

void MySQLParser::TableValueConstructorContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTableValueConstructor(this);
}


std::any MySQLParser::TableValueConstructorContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTableValueConstructor(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TableValueConstructorContext* MySQLParser::tableValueConstructor() {
  TableValueConstructorContext *_localctx = _tracker.createInstance<TableValueConstructorContext>(_ctx, getState());
  enterRule(_localctx, 336, MySQLParser::RuleTableValueConstructor);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    size_t alt;
    enterOuterAlt(_localctx, 1);
    setState(3227);
    match(MySQLParser::VALUES_SYMBOL);
    setState(3228);
    rowValueExplicit();
    setState(3233);
    _errHandler->sync(this);
    alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 333, _ctx);
    while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER) {
      if (alt == 1) {
        setState(3229);
        match(MySQLParser::COMMA_SYMBOL);
        setState(3230);
        rowValueExplicit(); 
      }
      setState(3235);
      _errHandler->sync(this);
      alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 333, _ctx);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- ExplicitTableContext ------------------------------------------------------------------

MySQLParser::ExplicitTableContext::ExplicitTableContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::ExplicitTableContext::TABLE_SYMBOL() {
  return getToken(MySQLParser::TABLE_SYMBOL, 0);
}

MySQLParser::TableRefContext* MySQLParser::ExplicitTableContext::tableRef() {
  return getRuleContext<MySQLParser::TableRefContext>(0);
}


size_t MySQLParser::ExplicitTableContext::getRuleIndex() const {
  return MySQLParser::RuleExplicitTable;
}

void MySQLParser::ExplicitTableContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterExplicitTable(this);
}

void MySQLParser::ExplicitTableContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitExplicitTable(this);
}


std::any MySQLParser::ExplicitTableContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitExplicitTable(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::ExplicitTableContext* MySQLParser::explicitTable() {
  ExplicitTableContext *_localctx = _tracker.createInstance<ExplicitTableContext>(_ctx, getState());
  enterRule(_localctx, 338, MySQLParser::RuleExplicitTable);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3236);
    match(MySQLParser::TABLE_SYMBOL);
    setState(3237);
    tableRef();
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- RowValueExplicitContext ------------------------------------------------------------------

MySQLParser::RowValueExplicitContext::RowValueExplicitContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::RowValueExplicitContext::ROW_SYMBOL() {
  return getToken(MySQLParser::ROW_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::RowValueExplicitContext::OPEN_PAR_SYMBOL() {
  return getToken(MySQLParser::OPEN_PAR_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::RowValueExplicitContext::CLOSE_PAR_SYMBOL() {
  return getToken(MySQLParser::CLOSE_PAR_SYMBOL, 0);
}

MySQLParser::ValuesContext* MySQLParser::RowValueExplicitContext::values() {
  return getRuleContext<MySQLParser::ValuesContext>(0);
}


size_t MySQLParser::RowValueExplicitContext::getRuleIndex() const {
  return MySQLParser::RuleRowValueExplicit;
}

void MySQLParser::RowValueExplicitContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterRowValueExplicit(this);
}

void MySQLParser::RowValueExplicitContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitRowValueExplicit(this);
}


std::any MySQLParser::RowValueExplicitContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitRowValueExplicit(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::RowValueExplicitContext* MySQLParser::rowValueExplicit() {
  RowValueExplicitContext *_localctx = _tracker.createInstance<RowValueExplicitContext>(_ctx, getState());
  enterRule(_localctx, 340, MySQLParser::RuleRowValueExplicit);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3239);
    match(MySQLParser::ROW_SYMBOL);
    setState(3240);
    match(MySQLParser::OPEN_PAR_SYMBOL);
    setState(3242);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 334, _ctx)) {
    case 1: {
      setState(3241);
      values();
      break;
    }

    default:
      break;
    }
    setState(3244);
    match(MySQLParser::CLOSE_PAR_SYMBOL);
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- SelectOptionContext ------------------------------------------------------------------

MySQLParser::SelectOptionContext::SelectOptionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::QuerySpecOptionContext* MySQLParser::SelectOptionContext::querySpecOption() {
  return getRuleContext<MySQLParser::QuerySpecOptionContext>(0);
}

tree::TerminalNode* MySQLParser::SelectOptionContext::SQL_NO_CACHE_SYMBOL() {
  return getToken(MySQLParser::SQL_NO_CACHE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::SelectOptionContext::SQL_CACHE_SYMBOL() {
  return getToken(MySQLParser::SQL_CACHE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::SelectOptionContext::MAX_STATEMENT_TIME_SYMBOL() {
  return getToken(MySQLParser::MAX_STATEMENT_TIME_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::SelectOptionContext::EQUAL_OPERATOR() {
  return getToken(MySQLParser::EQUAL_OPERATOR, 0);
}

MySQLParser::Real_ulong_numberContext* MySQLParser::SelectOptionContext::real_ulong_number() {
  return getRuleContext<MySQLParser::Real_ulong_numberContext>(0);
}


size_t MySQLParser::SelectOptionContext::getRuleIndex() const {
  return MySQLParser::RuleSelectOption;
}

void MySQLParser::SelectOptionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterSelectOption(this);
}

void MySQLParser::SelectOptionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitSelectOption(this);
}


std::any MySQLParser::SelectOptionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitSelectOption(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::SelectOptionContext* MySQLParser::selectOption() {
  SelectOptionContext *_localctx = _tracker.createInstance<SelectOptionContext>(_ctx, getState());
  enterRule(_localctx, 342, MySQLParser::RuleSelectOption);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(3254);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 335, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(3246);
      querySpecOption();
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(3247);
      match(MySQLParser::SQL_NO_CACHE_SYMBOL);
      break;
    }

    case 3: {
      enterOuterAlt(_localctx, 3);
      setState(3248);

      if (!(serverVersion < 80000)) throw FailedPredicateException(this, "serverVersion < 80000");
      setState(3249);
      match(MySQLParser::SQL_CACHE_SYMBOL);
      break;
    }

    case 4: {
      enterOuterAlt(_localctx, 4);
      setState(3250);

      if (!(serverVersion >= 50704 && serverVersion < 50708)) throw FailedPredicateException(this, "serverVersion >= 50704 && serverVersion < 50708");
      setState(3251);
      match(MySQLParser::MAX_STATEMENT_TIME_SYMBOL);
      setState(3252);
      match(MySQLParser::EQUAL_OPERATOR);
      setState(3253);
      real_ulong_number();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- LockingClauseListContext ------------------------------------------------------------------

MySQLParser::LockingClauseListContext::LockingClauseListContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

std::vector<MySQLParser::LockingClauseContext *> MySQLParser::LockingClauseListContext::lockingClause() {
  return getRuleContexts<MySQLParser::LockingClauseContext>();
}

MySQLParser::LockingClauseContext* MySQLParser::LockingClauseListContext::lockingClause(size_t i) {
  return getRuleContext<MySQLParser::LockingClauseContext>(i);
}


size_t MySQLParser::LockingClauseListContext::getRuleIndex() const {
  return MySQLParser::RuleLockingClauseList;
}

void MySQLParser::LockingClauseListContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterLockingClauseList(this);
}

void MySQLParser::LockingClauseListContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitLockingClauseList(this);
}


std::any MySQLParser::LockingClauseListContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitLockingClauseList(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::LockingClauseListContext* MySQLParser::lockingClauseList() {
  LockingClauseListContext *_localctx = _tracker.createInstance<LockingClauseListContext>(_ctx, getState());
  enterRule(_localctx, 344, MySQLParser::RuleLockingClauseList);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3257); 
    _errHandler->sync(this);
    _la = _input->LA(1);
    do {
      setState(3256);
      lockingClause();
      setState(3259); 
      _errHandler->sync(this);
      _la = _input->LA(1);
    } while (_la == MySQLParser::FOR_SYMBOL || _la == MySQLParser::LOCK_SYMBOL);
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- LockingClauseContext ------------------------------------------------------------------

MySQLParser::LockingClauseContext::LockingClauseContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::LockingClauseContext::FOR_SYMBOL() {
  return getToken(MySQLParser::FOR_SYMBOL, 0);
}

MySQLParser::LockStrenghContext* MySQLParser::LockingClauseContext::lockStrengh() {
  return getRuleContext<MySQLParser::LockStrenghContext>(0);
}

tree::TerminalNode* MySQLParser::LockingClauseContext::OF_SYMBOL() {
  return getToken(MySQLParser::OF_SYMBOL, 0);
}

MySQLParser::TableAliasRefListContext* MySQLParser::LockingClauseContext::tableAliasRefList() {
  return getRuleContext<MySQLParser::TableAliasRefListContext>(0);
}

MySQLParser::LockedRowActionContext* MySQLParser::LockingClauseContext::lockedRowAction() {
  return getRuleContext<MySQLParser::LockedRowActionContext>(0);
}

tree::TerminalNode* MySQLParser::LockingClauseContext::LOCK_SYMBOL() {
  return getToken(MySQLParser::LOCK_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::LockingClauseContext::IN_SYMBOL() {
  return getToken(MySQLParser::IN_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::LockingClauseContext::SHARE_SYMBOL() {
  return getToken(MySQLParser::SHARE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::LockingClauseContext::MODE_SYMBOL() {
  return getToken(MySQLParser::MODE_SYMBOL, 0);
}


size_t MySQLParser::LockingClauseContext::getRuleIndex() const {
  return MySQLParser::RuleLockingClause;
}

void MySQLParser::LockingClauseContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterLockingClause(this);
}

void MySQLParser::LockingClauseContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitLockingClause(this);
}


std::any MySQLParser::LockingClauseContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitLockingClause(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::LockingClauseContext* MySQLParser::lockingClause() {
  LockingClauseContext *_localctx = _tracker.createInstance<LockingClauseContext>(_ctx, getState());
  enterRule(_localctx, 346, MySQLParser::RuleLockingClause);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(3276);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::FOR_SYMBOL: {
        enterOuterAlt(_localctx, 1);
        setState(3261);
        match(MySQLParser::FOR_SYMBOL);
        setState(3262);
        lockStrengh();
        setState(3266);
        _errHandler->sync(this);

        switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 337, _ctx)) {
        case 1: {
          setState(3263);

          if (!(serverVersion >= 80000)) throw FailedPredicateException(this, "serverVersion >= 80000");
          setState(3264);
          match(MySQLParser::OF_SYMBOL);
          setState(3265);
          tableAliasRefList();
          break;
        }

        default:
          break;
        }
        setState(3270);
        _errHandler->sync(this);

        switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 338, _ctx)) {
        case 1: {
          setState(3268);

          if (!(serverVersion >= 80000)) throw FailedPredicateException(this, "serverVersion >= 80000");
          setState(3269);
          lockedRowAction();
          break;
        }

        default:
          break;
        }
        break;
      }

      case MySQLParser::LOCK_SYMBOL: {
        enterOuterAlt(_localctx, 2);
        setState(3272);
        match(MySQLParser::LOCK_SYMBOL);
        setState(3273);
        match(MySQLParser::IN_SYMBOL);
        setState(3274);
        match(MySQLParser::SHARE_SYMBOL);
        setState(3275);
        match(MySQLParser::MODE_SYMBOL);
        break;
      }

    default:
      throw NoViableAltException(this);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- LockStrenghContext ------------------------------------------------------------------

MySQLParser::LockStrenghContext::LockStrenghContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::LockStrenghContext::UPDATE_SYMBOL() {
  return getToken(MySQLParser::UPDATE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::LockStrenghContext::SHARE_SYMBOL() {
  return getToken(MySQLParser::SHARE_SYMBOL, 0);
}


size_t MySQLParser::LockStrenghContext::getRuleIndex() const {
  return MySQLParser::RuleLockStrengh;
}

void MySQLParser::LockStrenghContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterLockStrengh(this);
}

void MySQLParser::LockStrenghContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitLockStrengh(this);
}


std::any MySQLParser::LockStrenghContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitLockStrengh(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::LockStrenghContext* MySQLParser::lockStrengh() {
  LockStrenghContext *_localctx = _tracker.createInstance<LockStrenghContext>(_ctx, getState());
  enterRule(_localctx, 348, MySQLParser::RuleLockStrengh);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(3281);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 340, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(3278);
      match(MySQLParser::UPDATE_SYMBOL);
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(3279);

      if (!(serverVersion >= 80000)) throw FailedPredicateException(this, "serverVersion >= 80000");
      setState(3280);
      match(MySQLParser::SHARE_SYMBOL);
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- LockedRowActionContext ------------------------------------------------------------------

MySQLParser::LockedRowActionContext::LockedRowActionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::LockedRowActionContext::SKIP_SYMBOL() {
  return getToken(MySQLParser::SKIP_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::LockedRowActionContext::LOCKED_SYMBOL() {
  return getToken(MySQLParser::LOCKED_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::LockedRowActionContext::NOWAIT_SYMBOL() {
  return getToken(MySQLParser::NOWAIT_SYMBOL, 0);
}


size_t MySQLParser::LockedRowActionContext::getRuleIndex() const {
  return MySQLParser::RuleLockedRowAction;
}

void MySQLParser::LockedRowActionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterLockedRowAction(this);
}

void MySQLParser::LockedRowActionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitLockedRowAction(this);
}


std::any MySQLParser::LockedRowActionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitLockedRowAction(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::LockedRowActionContext* MySQLParser::lockedRowAction() {
  LockedRowActionContext *_localctx = _tracker.createInstance<LockedRowActionContext>(_ctx, getState());
  enterRule(_localctx, 350, MySQLParser::RuleLockedRowAction);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(3286);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::SKIP_SYMBOL: {
        enterOuterAlt(_localctx, 1);
        setState(3283);
        match(MySQLParser::SKIP_SYMBOL);
        setState(3284);
        match(MySQLParser::LOCKED_SYMBOL);
        break;
      }

      case MySQLParser::NOWAIT_SYMBOL: {
        enterOuterAlt(_localctx, 2);
        setState(3285);
        match(MySQLParser::NOWAIT_SYMBOL);
        break;
      }

    default:
      throw NoViableAltException(this);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- SelectItemListContext ------------------------------------------------------------------

MySQLParser::SelectItemListContext::SelectItemListContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

std::vector<MySQLParser::SelectItemContext *> MySQLParser::SelectItemListContext::selectItem() {
  return getRuleContexts<MySQLParser::SelectItemContext>();
}

MySQLParser::SelectItemContext* MySQLParser::SelectItemListContext::selectItem(size_t i) {
  return getRuleContext<MySQLParser::SelectItemContext>(i);
}

tree::TerminalNode* MySQLParser::SelectItemListContext::MULT_OPERATOR() {
  return getToken(MySQLParser::MULT_OPERATOR, 0);
}

std::vector<tree::TerminalNode *> MySQLParser::SelectItemListContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::SelectItemListContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::SelectItemListContext::getRuleIndex() const {
  return MySQLParser::RuleSelectItemList;
}

void MySQLParser::SelectItemListContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterSelectItemList(this);
}

void MySQLParser::SelectItemListContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitSelectItemList(this);
}


std::any MySQLParser::SelectItemListContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitSelectItemList(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::SelectItemListContext* MySQLParser::selectItemList() {
  SelectItemListContext *_localctx = _tracker.createInstance<SelectItemListContext>(_ctx, getState());
  enterRule(_localctx, 352, MySQLParser::RuleSelectItemList);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    size_t alt;
    enterOuterAlt(_localctx, 1);
    setState(3290);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 342, _ctx)) {
    case 1: {
      setState(3288);
      selectItem();
      break;
    }

    case 2: {
      setState(3289);
      match(MySQLParser::MULT_OPERATOR);
      break;
    }

    default:
      break;
    }
    setState(3296);
    _errHandler->sync(this);
    alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 343, _ctx);
    while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER) {
      if (alt == 1) {
        setState(3292);
        match(MySQLParser::COMMA_SYMBOL);
        setState(3293);
        selectItem(); 
      }
      setState(3298);
      _errHandler->sync(this);
      alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 343, _ctx);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- SelectItemContext ------------------------------------------------------------------

MySQLParser::SelectItemContext::SelectItemContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::TableWildContext* MySQLParser::SelectItemContext::tableWild() {
  return getRuleContext<MySQLParser::TableWildContext>(0);
}

MySQLParser::ExprContext* MySQLParser::SelectItemContext::expr() {
  return getRuleContext<MySQLParser::ExprContext>(0);
}

MySQLParser::SelectAliasContext* MySQLParser::SelectItemContext::selectAlias() {
  return getRuleContext<MySQLParser::SelectAliasContext>(0);
}


size_t MySQLParser::SelectItemContext::getRuleIndex() const {
  return MySQLParser::RuleSelectItem;
}

void MySQLParser::SelectItemContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterSelectItem(this);
}

void MySQLParser::SelectItemContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitSelectItem(this);
}


std::any MySQLParser::SelectItemContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitSelectItem(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::SelectItemContext* MySQLParser::selectItem() {
  SelectItemContext *_localctx = _tracker.createInstance<SelectItemContext>(_ctx, getState());
  enterRule(_localctx, 354, MySQLParser::RuleSelectItem);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(3304);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 345, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(3299);
      tableWild();
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(3300);
      expr(0);
      setState(3302);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 344, _ctx)) {
      case 1: {
        setState(3301);
        selectAlias();
        break;
      }

      default:
        break;
      }
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- SelectAliasContext ------------------------------------------------------------------

MySQLParser::SelectAliasContext::SelectAliasContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::IdentifierContext* MySQLParser::SelectAliasContext::identifier() {
  return getRuleContext<MySQLParser::IdentifierContext>(0);
}

MySQLParser::TextStringLiteralContext* MySQLParser::SelectAliasContext::textStringLiteral() {
  return getRuleContext<MySQLParser::TextStringLiteralContext>(0);
}

tree::TerminalNode* MySQLParser::SelectAliasContext::AS_SYMBOL() {
  return getToken(MySQLParser::AS_SYMBOL, 0);
}


size_t MySQLParser::SelectAliasContext::getRuleIndex() const {
  return MySQLParser::RuleSelectAlias;
}

void MySQLParser::SelectAliasContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterSelectAlias(this);
}

void MySQLParser::SelectAliasContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitSelectAlias(this);
}


std::any MySQLParser::SelectAliasContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitSelectAlias(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::SelectAliasContext* MySQLParser::selectAlias() {
  SelectAliasContext *_localctx = _tracker.createInstance<SelectAliasContext>(_ctx, getState());
  enterRule(_localctx, 356, MySQLParser::RuleSelectAlias);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3307);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 346, _ctx)) {
    case 1: {
      setState(3306);
      match(MySQLParser::AS_SYMBOL);
      break;
    }

    default:
      break;
    }
    setState(3311);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 347, _ctx)) {
    case 1: {
      setState(3309);
      identifier();
      break;
    }

    case 2: {
      setState(3310);
      textStringLiteral();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- WhereClauseContext ------------------------------------------------------------------

MySQLParser::WhereClauseContext::WhereClauseContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::WhereClauseContext::WHERE_SYMBOL() {
  return getToken(MySQLParser::WHERE_SYMBOL, 0);
}

MySQLParser::ExprContext* MySQLParser::WhereClauseContext::expr() {
  return getRuleContext<MySQLParser::ExprContext>(0);
}


size_t MySQLParser::WhereClauseContext::getRuleIndex() const {
  return MySQLParser::RuleWhereClause;
}

void MySQLParser::WhereClauseContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterWhereClause(this);
}

void MySQLParser::WhereClauseContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitWhereClause(this);
}


std::any MySQLParser::WhereClauseContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitWhereClause(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::WhereClauseContext* MySQLParser::whereClause() {
  WhereClauseContext *_localctx = _tracker.createInstance<WhereClauseContext>(_ctx, getState());
  enterRule(_localctx, 358, MySQLParser::RuleWhereClause);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3313);
    match(MySQLParser::WHERE_SYMBOL);
    setState(3314);
    expr(0);
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TableReferenceContext ------------------------------------------------------------------

MySQLParser::TableReferenceContext::TableReferenceContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::TableFactorContext* MySQLParser::TableReferenceContext::tableFactor() {
  return getRuleContext<MySQLParser::TableFactorContext>(0);
}

tree::TerminalNode* MySQLParser::TableReferenceContext::OPEN_CURLY_SYMBOL() {
  return getToken(MySQLParser::OPEN_CURLY_SYMBOL, 0);
}

MySQLParser::EscapedTableReferenceContext* MySQLParser::TableReferenceContext::escapedTableReference() {
  return getRuleContext<MySQLParser::EscapedTableReferenceContext>(0);
}

tree::TerminalNode* MySQLParser::TableReferenceContext::CLOSE_CURLY_SYMBOL() {
  return getToken(MySQLParser::CLOSE_CURLY_SYMBOL, 0);
}

std::vector<MySQLParser::JoinedTableContext *> MySQLParser::TableReferenceContext::joinedTable() {
  return getRuleContexts<MySQLParser::JoinedTableContext>();
}

MySQLParser::JoinedTableContext* MySQLParser::TableReferenceContext::joinedTable(size_t i) {
  return getRuleContext<MySQLParser::JoinedTableContext>(i);
}

MySQLParser::IdentifierContext* MySQLParser::TableReferenceContext::identifier() {
  return getRuleContext<MySQLParser::IdentifierContext>(0);
}

tree::TerminalNode* MySQLParser::TableReferenceContext::OJ_SYMBOL() {
  return getToken(MySQLParser::OJ_SYMBOL, 0);
}


size_t MySQLParser::TableReferenceContext::getRuleIndex() const {
  return MySQLParser::RuleTableReference;
}

void MySQLParser::TableReferenceContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTableReference(this);
}

void MySQLParser::TableReferenceContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTableReference(this);
}


std::any MySQLParser::TableReferenceContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTableReference(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TableReferenceContext* MySQLParser::tableReference() {
  TableReferenceContext *_localctx = _tracker.createInstance<TableReferenceContext>(_ctx, getState());
  enterRule(_localctx, 360, MySQLParser::RuleTableReference);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    size_t alt;
    enterOuterAlt(_localctx, 1);
    setState(3326);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 349, _ctx)) {
    case 1: {
      setState(3316);
      tableFactor();
      break;
    }

    case 2: {
      setState(3317);
      match(MySQLParser::OPEN_CURLY_SYMBOL);
      setState(3321);
      _errHandler->sync(this);
      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 348, _ctx)) {
      case 1: {
        setState(3318);

        if (!(serverVersion < 80017)) throw FailedPredicateException(this, "serverVersion < 80017");
        setState(3319);
        identifier();
        break;
      }

      case 2: {
        setState(3320);
        match(MySQLParser::OJ_SYMBOL);
        break;
      }

      default:
        break;
      }
      setState(3323);
      escapedTableReference();
      setState(3324);
      match(MySQLParser::CLOSE_CURLY_SYMBOL);
      break;
    }

    default:
      break;
    }
    setState(3331);
    _errHandler->sync(this);
    alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 350, _ctx);
    while (alt != 2 && alt != atn::ATN::INVALID_ALT_NUMBER) {
      if (alt == 1) {
        setState(3328);
        joinedTable(); 
      }
      setState(3333);
      _errHandler->sync(this);
      alt = getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 350, _ctx);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- EscapedTableReferenceContext ------------------------------------------------------------------

MySQLParser::EscapedTableReferenceContext::EscapedTableReferenceContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::TableFactorContext* MySQLParser::EscapedTableReferenceContext::tableFactor() {
  return getRuleContext<MySQLParser::TableFactorContext>(0);
}

std::vector<MySQLParser::JoinedTableContext *> MySQLParser::EscapedTableReferenceContext::joinedTable() {
  return getRuleContexts<MySQLParser::JoinedTableContext>();
}

MySQLParser::JoinedTableContext* MySQLParser::EscapedTableReferenceContext::joinedTable(size_t i) {
  return getRuleContext<MySQLParser::JoinedTableContext>(i);
}


size_t MySQLParser::EscapedTableReferenceContext::getRuleIndex() const {
  return MySQLParser::RuleEscapedTableReference;
}

void MySQLParser::EscapedTableReferenceContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterEscapedTableReference(this);
}

void MySQLParser::EscapedTableReferenceContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitEscapedTableReference(this);
}


std::any MySQLParser::EscapedTableReferenceContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitEscapedTableReference(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::EscapedTableReferenceContext* MySQLParser::escapedTableReference() {
  EscapedTableReferenceContext *_localctx = _tracker.createInstance<EscapedTableReferenceContext>(_ctx, getState());
  enterRule(_localctx, 362, MySQLParser::RuleEscapedTableReference);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3334);
    tableFactor();
    setState(3338);
    _errHandler->sync(this);
    _la = _input->LA(1);
    while (_la == MySQLParser::CROSS_SYMBOL || ((((_la - 239) & ~ 0x3fULL) == 0) &&
      ((1ULL << (_la - 239)) & 8594128897) != 0) || _la == MySQLParser::NATURAL_SYMBOL || _la == MySQLParser::RIGHT_SYMBOL || _la == MySQLParser::STRAIGHT_JOIN_SYMBOL) {
      setState(3335);
      joinedTable();
      setState(3340);
      _errHandler->sync(this);
      _la = _input->LA(1);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- JoinedTableContext ------------------------------------------------------------------

MySQLParser::JoinedTableContext::JoinedTableContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::InnerJoinTypeContext* MySQLParser::JoinedTableContext::innerJoinType() {
  return getRuleContext<MySQLParser::InnerJoinTypeContext>(0);
}

MySQLParser::TableReferenceContext* MySQLParser::JoinedTableContext::tableReference() {
  return getRuleContext<MySQLParser::TableReferenceContext>(0);
}

tree::TerminalNode* MySQLParser::JoinedTableContext::ON_SYMBOL() {
  return getToken(MySQLParser::ON_SYMBOL, 0);
}

MySQLParser::ExprContext* MySQLParser::JoinedTableContext::expr() {
  return getRuleContext<MySQLParser::ExprContext>(0);
}

tree::TerminalNode* MySQLParser::JoinedTableContext::USING_SYMBOL() {
  return getToken(MySQLParser::USING_SYMBOL, 0);
}

MySQLParser::IdentifierListWithParenthesesContext* MySQLParser::JoinedTableContext::identifierListWithParentheses() {
  return getRuleContext<MySQLParser::IdentifierListWithParenthesesContext>(0);
}

MySQLParser::OuterJoinTypeContext* MySQLParser::JoinedTableContext::outerJoinType() {
  return getRuleContext<MySQLParser::OuterJoinTypeContext>(0);
}

MySQLParser::NaturalJoinTypeContext* MySQLParser::JoinedTableContext::naturalJoinType() {
  return getRuleContext<MySQLParser::NaturalJoinTypeContext>(0);
}

MySQLParser::TableFactorContext* MySQLParser::JoinedTableContext::tableFactor() {
  return getRuleContext<MySQLParser::TableFactorContext>(0);
}


size_t MySQLParser::JoinedTableContext::getRuleIndex() const {
  return MySQLParser::RuleJoinedTable;
}

void MySQLParser::JoinedTableContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterJoinedTable(this);
}

void MySQLParser::JoinedTableContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitJoinedTable(this);
}


std::any MySQLParser::JoinedTableContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitJoinedTable(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::JoinedTableContext* MySQLParser::joinedTable() {
  JoinedTableContext *_localctx = _tracker.createInstance<JoinedTableContext>(_ctx, getState());
  enterRule(_localctx, 364, MySQLParser::RuleJoinedTable);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(3360);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::CROSS_SYMBOL:
      case MySQLParser::INNER_SYMBOL:
      case MySQLParser::JOIN_SYMBOL:
      case MySQLParser::STRAIGHT_JOIN_SYMBOL: {
        enterOuterAlt(_localctx, 1);
        setState(3341);
        innerJoinType();
        setState(3342);
        tableReference();
        setState(3347);
        _errHandler->sync(this);

        switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 352, _ctx)) {
        case 1: {
          setState(3343);
          match(MySQLParser::ON_SYMBOL);
          setState(3344);
          expr(0);
          break;
        }

        case 2: {
          setState(3345);
          match(MySQLParser::USING_SYMBOL);
          setState(3346);
          identifierListWithParentheses();
          break;
        }

        default:
          break;
        }
        break;
      }

      case MySQLParser::LEFT_SYMBOL:
      case MySQLParser::RIGHT_SYMBOL: {
        enterOuterAlt(_localctx, 2);
        setState(3349);
        outerJoinType();
        setState(3350);
        tableReference();
        setState(3355);
        _errHandler->sync(this);
        switch (_input->LA(1)) {
          case MySQLParser::ON_SYMBOL: {
            setState(3351);
            match(MySQLParser::ON_SYMBOL);
            setState(3352);
            expr(0);
            break;
          }

          case MySQLParser::USING_SYMBOL: {
            setState(3353);
            match(MySQLParser::USING_SYMBOL);
            setState(3354);
            identifierListWithParentheses();
            break;
          }

        default:
          throw NoViableAltException(this);
        }
        break;
      }

      case MySQLParser::NATURAL_SYMBOL: {
        enterOuterAlt(_localctx, 3);
        setState(3357);
        naturalJoinType();
        setState(3358);
        tableFactor();
        break;
      }

    default:
      throw NoViableAltException(this);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- NaturalJoinTypeContext ------------------------------------------------------------------

MySQLParser::NaturalJoinTypeContext::NaturalJoinTypeContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::NaturalJoinTypeContext::NATURAL_SYMBOL() {
  return getToken(MySQLParser::NATURAL_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::NaturalJoinTypeContext::JOIN_SYMBOL() {
  return getToken(MySQLParser::JOIN_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::NaturalJoinTypeContext::INNER_SYMBOL() {
  return getToken(MySQLParser::INNER_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::NaturalJoinTypeContext::LEFT_SYMBOL() {
  return getToken(MySQLParser::LEFT_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::NaturalJoinTypeContext::RIGHT_SYMBOL() {
  return getToken(MySQLParser::RIGHT_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::NaturalJoinTypeContext::OUTER_SYMBOL() {
  return getToken(MySQLParser::OUTER_SYMBOL, 0);
}


size_t MySQLParser::NaturalJoinTypeContext::getRuleIndex() const {
  return MySQLParser::RuleNaturalJoinType;
}

void MySQLParser::NaturalJoinTypeContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterNaturalJoinType(this);
}

void MySQLParser::NaturalJoinTypeContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitNaturalJoinType(this);
}


std::any MySQLParser::NaturalJoinTypeContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitNaturalJoinType(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::NaturalJoinTypeContext* MySQLParser::naturalJoinType() {
  NaturalJoinTypeContext *_localctx = _tracker.createInstance<NaturalJoinTypeContext>(_ctx, getState());
  enterRule(_localctx, 366, MySQLParser::RuleNaturalJoinType);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(3373);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 357, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(3362);
      match(MySQLParser::NATURAL_SYMBOL);
      setState(3364);
      _errHandler->sync(this);

      _la = _input->LA(1);
      if (_la == MySQLParser::INNER_SYMBOL) {
        setState(3363);
        match(MySQLParser::INNER_SYMBOL);
      }
      setState(3366);
      match(MySQLParser::JOIN_SYMBOL);
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(3367);
      match(MySQLParser::NATURAL_SYMBOL);
      setState(3368);
      _la = _input->LA(1);
      if (!(_la == MySQLParser::LEFT_SYMBOL || _la == MySQLParser::RIGHT_SYMBOL)) {
      _errHandler->recoverInline(this);
      }
      else {
        _errHandler->reportMatch(this);
        consume();
      }
      setState(3370);
      _errHandler->sync(this);

      _la = _input->LA(1);
      if (_la == MySQLParser::OUTER_SYMBOL) {
        setState(3369);
        match(MySQLParser::OUTER_SYMBOL);
      }
      setState(3372);
      match(MySQLParser::JOIN_SYMBOL);
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- InnerJoinTypeContext ------------------------------------------------------------------

MySQLParser::InnerJoinTypeContext::InnerJoinTypeContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::InnerJoinTypeContext::JOIN_SYMBOL() {
  return getToken(MySQLParser::JOIN_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::InnerJoinTypeContext::INNER_SYMBOL() {
  return getToken(MySQLParser::INNER_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::InnerJoinTypeContext::CROSS_SYMBOL() {
  return getToken(MySQLParser::CROSS_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::InnerJoinTypeContext::STRAIGHT_JOIN_SYMBOL() {
  return getToken(MySQLParser::STRAIGHT_JOIN_SYMBOL, 0);
}


size_t MySQLParser::InnerJoinTypeContext::getRuleIndex() const {
  return MySQLParser::RuleInnerJoinType;
}

void MySQLParser::InnerJoinTypeContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterInnerJoinType(this);
}

void MySQLParser::InnerJoinTypeContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitInnerJoinType(this);
}


std::any MySQLParser::InnerJoinTypeContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitInnerJoinType(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::InnerJoinTypeContext* MySQLParser::innerJoinType() {
  InnerJoinTypeContext *_localctx = _tracker.createInstance<InnerJoinTypeContext>(_ctx, getState());
  enterRule(_localctx, 368, MySQLParser::RuleInnerJoinType);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(3380);
    _errHandler->sync(this);
    switch (_input->LA(1)) {
      case MySQLParser::CROSS_SYMBOL:
      case MySQLParser::INNER_SYMBOL:
      case MySQLParser::JOIN_SYMBOL: {
        enterOuterAlt(_localctx, 1);
        setState(3376);
        _errHandler->sync(this);

        _la = _input->LA(1);
        if (_la == MySQLParser::CROSS_SYMBOL || _la == MySQLParser::INNER_SYMBOL) {
          setState(3375);
          antlrcpp::downCast<InnerJoinTypeContext *>(_localctx)->type = _input->LT(1);
          _la = _input->LA(1);
          if (!(_la == MySQLParser::CROSS_SYMBOL || _la == MySQLParser::INNER_SYMBOL)) {
            antlrcpp::downCast<InnerJoinTypeContext *>(_localctx)->type = _errHandler->recoverInline(this);
          }
          else {
            _errHandler->reportMatch(this);
            consume();
          }
        }
        setState(3378);
        match(MySQLParser::JOIN_SYMBOL);
        break;
      }

      case MySQLParser::STRAIGHT_JOIN_SYMBOL: {
        enterOuterAlt(_localctx, 2);
        setState(3379);
        antlrcpp::downCast<InnerJoinTypeContext *>(_localctx)->type = match(MySQLParser::STRAIGHT_JOIN_SYMBOL);
        break;
      }

    default:
      throw NoViableAltException(this);
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- OuterJoinTypeContext ------------------------------------------------------------------

MySQLParser::OuterJoinTypeContext::OuterJoinTypeContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::OuterJoinTypeContext::JOIN_SYMBOL() {
  return getToken(MySQLParser::JOIN_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::OuterJoinTypeContext::LEFT_SYMBOL() {
  return getToken(MySQLParser::LEFT_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::OuterJoinTypeContext::RIGHT_SYMBOL() {
  return getToken(MySQLParser::RIGHT_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::OuterJoinTypeContext::OUTER_SYMBOL() {
  return getToken(MySQLParser::OUTER_SYMBOL, 0);
}


size_t MySQLParser::OuterJoinTypeContext::getRuleIndex() const {
  return MySQLParser::RuleOuterJoinType;
}

void MySQLParser::OuterJoinTypeContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterOuterJoinType(this);
}

void MySQLParser::OuterJoinTypeContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitOuterJoinType(this);
}


std::any MySQLParser::OuterJoinTypeContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitOuterJoinType(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::OuterJoinTypeContext* MySQLParser::outerJoinType() {
  OuterJoinTypeContext *_localctx = _tracker.createInstance<OuterJoinTypeContext>(_ctx, getState());
  enterRule(_localctx, 370, MySQLParser::RuleOuterJoinType);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3382);
    antlrcpp::downCast<OuterJoinTypeContext *>(_localctx)->type = _input->LT(1);
    _la = _input->LA(1);
    if (!(_la == MySQLParser::LEFT_SYMBOL || _la == MySQLParser::RIGHT_SYMBOL)) {
      antlrcpp::downCast<OuterJoinTypeContext *>(_localctx)->type = _errHandler->recoverInline(this);
    }
    else {
      _errHandler->reportMatch(this);
      consume();
    }
    setState(3384);
    _errHandler->sync(this);

    _la = _input->LA(1);
    if (_la == MySQLParser::OUTER_SYMBOL) {
      setState(3383);
      match(MySQLParser::OUTER_SYMBOL);
    }
    setState(3386);
    match(MySQLParser::JOIN_SYMBOL);
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TableFactorContext ------------------------------------------------------------------

MySQLParser::TableFactorContext::TableFactorContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::SingleTableContext* MySQLParser::TableFactorContext::singleTable() {
  return getRuleContext<MySQLParser::SingleTableContext>(0);
}

MySQLParser::SingleTableParensContext* MySQLParser::TableFactorContext::singleTableParens() {
  return getRuleContext<MySQLParser::SingleTableParensContext>(0);
}

MySQLParser::DerivedTableContext* MySQLParser::TableFactorContext::derivedTable() {
  return getRuleContext<MySQLParser::DerivedTableContext>(0);
}

MySQLParser::TableReferenceListParensContext* MySQLParser::TableFactorContext::tableReferenceListParens() {
  return getRuleContext<MySQLParser::TableReferenceListParensContext>(0);
}

MySQLParser::TableFunctionContext* MySQLParser::TableFactorContext::tableFunction() {
  return getRuleContext<MySQLParser::TableFunctionContext>(0);
}


size_t MySQLParser::TableFactorContext::getRuleIndex() const {
  return MySQLParser::RuleTableFactor;
}

void MySQLParser::TableFactorContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTableFactor(this);
}

void MySQLParser::TableFactorContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTableFactor(this);
}


std::any MySQLParser::TableFactorContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTableFactor(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TableFactorContext* MySQLParser::tableFactor() {
  TableFactorContext *_localctx = _tracker.createInstance<TableFactorContext>(_ctx, getState());
  enterRule(_localctx, 372, MySQLParser::RuleTableFactor);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(3394);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 361, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(3388);
      singleTable();
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(3389);
      singleTableParens();
      break;
    }

    case 3: {
      enterOuterAlt(_localctx, 3);
      setState(3390);
      derivedTable();
      break;
    }

    case 4: {
      enterOuterAlt(_localctx, 4);
      setState(3391);
      tableReferenceListParens();
      break;
    }

    case 5: {
      enterOuterAlt(_localctx, 5);
      setState(3392);

      if (!(serverVersion >= 80004)) throw FailedPredicateException(this, "serverVersion >= 80004");
      setState(3393);
      tableFunction();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- SingleTableContext ------------------------------------------------------------------

MySQLParser::SingleTableContext::SingleTableContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::TableRefContext* MySQLParser::SingleTableContext::tableRef() {
  return getRuleContext<MySQLParser::TableRefContext>(0);
}

MySQLParser::UsePartitionContext* MySQLParser::SingleTableContext::usePartition() {
  return getRuleContext<MySQLParser::UsePartitionContext>(0);
}

MySQLParser::TableAliasContext* MySQLParser::SingleTableContext::tableAlias() {
  return getRuleContext<MySQLParser::TableAliasContext>(0);
}

MySQLParser::IndexHintListContext* MySQLParser::SingleTableContext::indexHintList() {
  return getRuleContext<MySQLParser::IndexHintListContext>(0);
}


size_t MySQLParser::SingleTableContext::getRuleIndex() const {
  return MySQLParser::RuleSingleTable;
}

void MySQLParser::SingleTableContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterSingleTable(this);
}

void MySQLParser::SingleTableContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitSingleTable(this);
}


std::any MySQLParser::SingleTableContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitSingleTable(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::SingleTableContext* MySQLParser::singleTable() {
  SingleTableContext *_localctx = _tracker.createInstance<SingleTableContext>(_ctx, getState());
  enterRule(_localctx, 374, MySQLParser::RuleSingleTable);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3396);
    tableRef();
    setState(3398);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 362, _ctx)) {
    case 1: {
      setState(3397);
      usePartition();
      break;
    }

    default:
      break;
    }
    setState(3401);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 363, _ctx)) {
    case 1: {
      setState(3400);
      tableAlias();
      break;
    }

    default:
      break;
    }
    setState(3404);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 364, _ctx)) {
    case 1: {
      setState(3403);
      indexHintList();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- SingleTableParensContext ------------------------------------------------------------------

MySQLParser::SingleTableParensContext::SingleTableParensContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::SingleTableParensContext::OPEN_PAR_SYMBOL() {
  return getToken(MySQLParser::OPEN_PAR_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::SingleTableParensContext::CLOSE_PAR_SYMBOL() {
  return getToken(MySQLParser::CLOSE_PAR_SYMBOL, 0);
}

MySQLParser::SingleTableContext* MySQLParser::SingleTableParensContext::singleTable() {
  return getRuleContext<MySQLParser::SingleTableContext>(0);
}

MySQLParser::SingleTableParensContext* MySQLParser::SingleTableParensContext::singleTableParens() {
  return getRuleContext<MySQLParser::SingleTableParensContext>(0);
}


size_t MySQLParser::SingleTableParensContext::getRuleIndex() const {
  return MySQLParser::RuleSingleTableParens;
}

void MySQLParser::SingleTableParensContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterSingleTableParens(this);
}

void MySQLParser::SingleTableParensContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitSingleTableParens(this);
}


std::any MySQLParser::SingleTableParensContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitSingleTableParens(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::SingleTableParensContext* MySQLParser::singleTableParens() {
  SingleTableParensContext *_localctx = _tracker.createInstance<SingleTableParensContext>(_ctx, getState());
  enterRule(_localctx, 376, MySQLParser::RuleSingleTableParens);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3406);
    match(MySQLParser::OPEN_PAR_SYMBOL);
    setState(3409);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 365, _ctx)) {
    case 1: {
      setState(3407);
      singleTable();
      break;
    }

    case 2: {
      setState(3408);
      singleTableParens();
      break;
    }

    default:
      break;
    }
    setState(3411);
    match(MySQLParser::CLOSE_PAR_SYMBOL);
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- DerivedTableContext ------------------------------------------------------------------

MySQLParser::DerivedTableContext::DerivedTableContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::SubqueryContext* MySQLParser::DerivedTableContext::subquery() {
  return getRuleContext<MySQLParser::SubqueryContext>(0);
}

MySQLParser::TableAliasContext* MySQLParser::DerivedTableContext::tableAlias() {
  return getRuleContext<MySQLParser::TableAliasContext>(0);
}

MySQLParser::ColumnInternalRefListContext* MySQLParser::DerivedTableContext::columnInternalRefList() {
  return getRuleContext<MySQLParser::ColumnInternalRefListContext>(0);
}

tree::TerminalNode* MySQLParser::DerivedTableContext::LATERAL_SYMBOL() {
  return getToken(MySQLParser::LATERAL_SYMBOL, 0);
}


size_t MySQLParser::DerivedTableContext::getRuleIndex() const {
  return MySQLParser::RuleDerivedTable;
}

void MySQLParser::DerivedTableContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterDerivedTable(this);
}

void MySQLParser::DerivedTableContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitDerivedTable(this);
}


std::any MySQLParser::DerivedTableContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitDerivedTable(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::DerivedTableContext* MySQLParser::derivedTable() {
  DerivedTableContext *_localctx = _tracker.createInstance<DerivedTableContext>(_ctx, getState());
  enterRule(_localctx, 378, MySQLParser::RuleDerivedTable);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    setState(3430);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 370, _ctx)) {
    case 1: {
      enterOuterAlt(_localctx, 1);
      setState(3413);
      subquery();
      setState(3415);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 366, _ctx)) {
      case 1: {
        setState(3414);
        tableAlias();
        break;
      }

      default:
        break;
      }
      setState(3419);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 367, _ctx)) {
      case 1: {
        setState(3417);

        if (!(serverVersion >= 80000)) throw FailedPredicateException(this, "serverVersion >= 80000");
        setState(3418);
        columnInternalRefList();
        break;
      }

      default:
        break;
      }
      break;
    }

    case 2: {
      enterOuterAlt(_localctx, 2);
      setState(3421);

      if (!(serverVersion >= 80014)) throw FailedPredicateException(this, "serverVersion >= 80014");
      setState(3422);
      match(MySQLParser::LATERAL_SYMBOL);
      setState(3423);
      subquery();
      setState(3425);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 368, _ctx)) {
      case 1: {
        setState(3424);
        tableAlias();
        break;
      }

      default:
        break;
      }
      setState(3428);
      _errHandler->sync(this);

      switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 369, _ctx)) {
      case 1: {
        setState(3427);
        columnInternalRefList();
        break;
      }

      default:
        break;
      }
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TableReferenceListParensContext ------------------------------------------------------------------

MySQLParser::TableReferenceListParensContext::TableReferenceListParensContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::TableReferenceListParensContext::OPEN_PAR_SYMBOL() {
  return getToken(MySQLParser::OPEN_PAR_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::TableReferenceListParensContext::CLOSE_PAR_SYMBOL() {
  return getToken(MySQLParser::CLOSE_PAR_SYMBOL, 0);
}

MySQLParser::TableReferenceListContext* MySQLParser::TableReferenceListParensContext::tableReferenceList() {
  return getRuleContext<MySQLParser::TableReferenceListContext>(0);
}

MySQLParser::TableReferenceListParensContext* MySQLParser::TableReferenceListParensContext::tableReferenceListParens() {
  return getRuleContext<MySQLParser::TableReferenceListParensContext>(0);
}


size_t MySQLParser::TableReferenceListParensContext::getRuleIndex() const {
  return MySQLParser::RuleTableReferenceListParens;
}

void MySQLParser::TableReferenceListParensContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTableReferenceListParens(this);
}

void MySQLParser::TableReferenceListParensContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTableReferenceListParens(this);
}


std::any MySQLParser::TableReferenceListParensContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTableReferenceListParens(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TableReferenceListParensContext* MySQLParser::tableReferenceListParens() {
  TableReferenceListParensContext *_localctx = _tracker.createInstance<TableReferenceListParensContext>(_ctx, getState());
  enterRule(_localctx, 380, MySQLParser::RuleTableReferenceListParens);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3432);
    match(MySQLParser::OPEN_PAR_SYMBOL);
    setState(3435);
    _errHandler->sync(this);
    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 371, _ctx)) {
    case 1: {
      setState(3433);
      tableReferenceList();
      break;
    }

    case 2: {
      setState(3434);
      tableReferenceListParens();
      break;
    }

    default:
      break;
    }
    setState(3437);
    match(MySQLParser::CLOSE_PAR_SYMBOL);
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- TableFunctionContext ------------------------------------------------------------------

MySQLParser::TableFunctionContext::TableFunctionContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::TableFunctionContext::JSON_TABLE_SYMBOL() {
  return getToken(MySQLParser::JSON_TABLE_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::TableFunctionContext::OPEN_PAR_SYMBOL() {
  return getToken(MySQLParser::OPEN_PAR_SYMBOL, 0);
}

MySQLParser::ExprContext* MySQLParser::TableFunctionContext::expr() {
  return getRuleContext<MySQLParser::ExprContext>(0);
}

tree::TerminalNode* MySQLParser::TableFunctionContext::COMMA_SYMBOL() {
  return getToken(MySQLParser::COMMA_SYMBOL, 0);
}

MySQLParser::TextStringLiteralContext* MySQLParser::TableFunctionContext::textStringLiteral() {
  return getRuleContext<MySQLParser::TextStringLiteralContext>(0);
}

MySQLParser::ColumnsClauseContext* MySQLParser::TableFunctionContext::columnsClause() {
  return getRuleContext<MySQLParser::ColumnsClauseContext>(0);
}

tree::TerminalNode* MySQLParser::TableFunctionContext::CLOSE_PAR_SYMBOL() {
  return getToken(MySQLParser::CLOSE_PAR_SYMBOL, 0);
}

MySQLParser::TableAliasContext* MySQLParser::TableFunctionContext::tableAlias() {
  return getRuleContext<MySQLParser::TableAliasContext>(0);
}


size_t MySQLParser::TableFunctionContext::getRuleIndex() const {
  return MySQLParser::RuleTableFunction;
}

void MySQLParser::TableFunctionContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterTableFunction(this);
}

void MySQLParser::TableFunctionContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitTableFunction(this);
}


std::any MySQLParser::TableFunctionContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitTableFunction(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::TableFunctionContext* MySQLParser::tableFunction() {
  TableFunctionContext *_localctx = _tracker.createInstance<TableFunctionContext>(_ctx, getState());
  enterRule(_localctx, 382, MySQLParser::RuleTableFunction);

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3439);
    match(MySQLParser::JSON_TABLE_SYMBOL);
    setState(3440);
    match(MySQLParser::OPEN_PAR_SYMBOL);
    setState(3441);
    expr(0);
    setState(3442);
    match(MySQLParser::COMMA_SYMBOL);
    setState(3443);
    textStringLiteral();
    setState(3444);
    columnsClause();
    setState(3445);
    match(MySQLParser::CLOSE_PAR_SYMBOL);
    setState(3447);
    _errHandler->sync(this);

    switch (getInterpreter<atn::ParserATNSimulator>()->adaptivePredict(_input, 372, _ctx)) {
    case 1: {
      setState(3446);
      tableAlias();
      break;
    }

    default:
      break;
    }
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- ColumnsClauseContext ------------------------------------------------------------------

MySQLParser::ColumnsClauseContext::ColumnsClauseContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

tree::TerminalNode* MySQLParser::ColumnsClauseContext::COLUMNS_SYMBOL() {
  return getToken(MySQLParser::COLUMNS_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::ColumnsClauseContext::OPEN_PAR_SYMBOL() {
  return getToken(MySQLParser::OPEN_PAR_SYMBOL, 0);
}

std::vector<MySQLParser::JtColumnContext *> MySQLParser::ColumnsClauseContext::jtColumn() {
  return getRuleContexts<MySQLParser::JtColumnContext>();
}

MySQLParser::JtColumnContext* MySQLParser::ColumnsClauseContext::jtColumn(size_t i) {
  return getRuleContext<MySQLParser::JtColumnContext>(i);
}

tree::TerminalNode* MySQLParser::ColumnsClauseContext::CLOSE_PAR_SYMBOL() {
  return getToken(MySQLParser::CLOSE_PAR_SYMBOL, 0);
}

std::vector<tree::TerminalNode *> MySQLParser::ColumnsClauseContext::COMMA_SYMBOL() {
  return getTokens(MySQLParser::COMMA_SYMBOL);
}

tree::TerminalNode* MySQLParser::ColumnsClauseContext::COMMA_SYMBOL(size_t i) {
  return getToken(MySQLParser::COMMA_SYMBOL, i);
}


size_t MySQLParser::ColumnsClauseContext::getRuleIndex() const {
  return MySQLParser::RuleColumnsClause;
}

void MySQLParser::ColumnsClauseContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterColumnsClause(this);
}

void MySQLParser::ColumnsClauseContext::exitRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->exitColumnsClause(this);
}


std::any MySQLParser::ColumnsClauseContext::accept(tree::ParseTreeVisitor *visitor) {
  if (auto parserVisitor = dynamic_cast<MySQLParserVisitor*>(visitor))
    return parserVisitor->visitColumnsClause(this);
  else
    return visitor->visitChildren(this);
}

MySQLParser::ColumnsClauseContext* MySQLParser::columnsClause() {
  ColumnsClauseContext *_localctx = _tracker.createInstance<ColumnsClauseContext>(_ctx, getState());
  enterRule(_localctx, 384, MySQLParser::RuleColumnsClause);
  size_t _la = 0;

#if __cplusplus > 201703L
  auto onExit = finally([=, this] {
#else
  auto onExit = finally([=] {
#endif
    exitRule();
  });
  try {
    enterOuterAlt(_localctx, 1);
    setState(3449);
    match(MySQLParser::COLUMNS_SYMBOL);
    setState(3450);
    match(MySQLParser::OPEN_PAR_SYMBOL);
    setState(3451);
    jtColumn();
    setState(3456);
    _errHandler->sync(this);
    _la = _input->LA(1);
    while (_la == MySQLParser::COMMA_SYMBOL) {
      setState(3452);
      match(MySQLParser::COMMA_SYMBOL);
      setState(3453);
      jtColumn();
      setState(3458);
      _errHandler->sync(this);
      _la = _input->LA(1);
    }
    setState(3459);
    match(MySQLParser::CLOSE_PAR_SYMBOL);
   
  }
  catch (RecognitionException &e) {
    _errHandler->reportError(this, e);
    _localctx->exception = std::current_exception();
    _errHandler->recover(this, _localctx->exception);
  }

  return _localctx;
}

//----------------- JtColumnContext ------------------------------------------------------------------

MySQLParser::JtColumnContext::JtColumnContext(ParserRuleContext *parent, size_t invokingState)
  : ParserRuleContext(parent, invokingState) {
}

MySQLParser::IdentifierContext* MySQLParser::JtColumnContext::identifier() {
  return getRuleContext<MySQLParser::IdentifierContext>(0);
}

tree::TerminalNode* MySQLParser::JtColumnContext::FOR_SYMBOL() {
  return getToken(MySQLParser::FOR_SYMBOL, 0);
}

tree::TerminalNode* MySQLParser::JtColumnContext::ORDINALITY_SYMBOL() {
  return getToken(MySQLParser::ORDINALITY_SYMBOL, 0);
}

MySQLParser::DataTypeContext* MySQLParser::JtColumnContext::dataType() {
  return getRuleContext<MySQLParser::DataTypeContext>(0);
}

tree::TerminalNode* MySQLParser::JtColumnContext::PATH_SYMBOL() {
  return getToken(MySQLParser::PATH_SYMBOL, 0);
}

MySQLParser::TextStringLiteralContext* MySQLParser::JtColumnContext::textStringLiteral() {
  return getRuleContext<MySQLParser::TextStringLiteralContext>(0);
}

MySQLParser::CollateContext* MySQLParser::JtColumnContext::collate() {
  return getRuleContext<MySQLParser::CollateContext>(0);
}

tree::TerminalNode* MySQLParser::JtColumnContext::EXISTS_SYMBOL() {
  return getToken(MySQLParser::EXISTS_SYMBOL, 0);
}

MySQLParser::OnEmptyOrErrorContext* MySQLParser::JtColumnContext::onEmptyOrError() {
  return getRuleContext<MySQLParser::OnEmptyOrErrorContext>(0);
}

tree::TerminalNode* MySQLParser::JtColumnContext::NESTED_SYMBOL() {
  return getToken(MySQLParser::NESTED_SYMBOL, 0);
}

MySQLParser::ColumnsClauseContext* MySQLParser::JtColumnContext::columnsClause() {
  return getRuleContext<MySQLParser::ColumnsClauseContext>(0);
}


size_t MySQLParser::JtColumnContext::getRuleIndex() const {
  return MySQLParser::RuleJtColumn;
}

void MySQLParser::JtColumnContext::enterRule(tree::ParseTreeListener *listener) {
  auto parserListener = dynamic_cast<MySQLParserListener *>(listener);
  if (parserListener != nullptr)
    parserListener->enterJtColumn(this);
}

void MySQLParser::JtColumnContext::exitRule(tree::ParseTr