// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armstorage

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strconv"
	"strings"
)

// TaskAssignmentsInstancesReportClient contains the methods for the StorageTaskAssignmentsInstancesReport group.
// Don't use this type directly, use NewTaskAssignmentsInstancesReportClient() instead.
type TaskAssignmentsInstancesReportClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewTaskAssignmentsInstancesReportClient creates a new instance of TaskAssignmentsInstancesReportClient with the specified values.
//   - subscriptionID - The ID of the target subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewTaskAssignmentsInstancesReportClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*TaskAssignmentsInstancesReportClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &TaskAssignmentsInstancesReportClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// NewListPager - Fetch the report summary of all the storage task assignments and instances in an account
//
// Generated from API version 2024-01-01
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - accountName - The name of the storage account within the specified resource group. Storage account names must be between
//     3 and 24 characters in length and use numbers and lower-case letters only.
//   - options - TaskAssignmentsInstancesReportClientListOptions contains the optional parameters for the TaskAssignmentsInstancesReportClient.NewListPager
//     method.
func (client *TaskAssignmentsInstancesReportClient) NewListPager(resourceGroupName string, accountName string, options *TaskAssignmentsInstancesReportClientListOptions) *runtime.Pager[TaskAssignmentsInstancesReportClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[TaskAssignmentsInstancesReportClientListResponse]{
		More: func(page TaskAssignmentsInstancesReportClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *TaskAssignmentsInstancesReportClientListResponse) (TaskAssignmentsInstancesReportClientListResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "TaskAssignmentsInstancesReportClient.NewListPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listCreateRequest(ctx, resourceGroupName, accountName, options)
			}, nil)
			if err != nil {
				return TaskAssignmentsInstancesReportClientListResponse{}, err
			}
			return client.listHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listCreateRequest creates the List request.
func (client *TaskAssignmentsInstancesReportClient) listCreateRequest(ctx context.Context, resourceGroupName string, accountName string, options *TaskAssignmentsInstancesReportClientListOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/reports"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if accountName == "" {
		return nil, errors.New("parameter accountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{accountName}", url.PathEscape(accountName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Filter != nil {
		reqQP.Set("$filter", *options.Filter)
	}
	if options != nil && options.Maxpagesize != nil {
		reqQP.Set("$maxpagesize", strconv.FormatInt(int64(*options.Maxpagesize), 10))
	}
	reqQP.Set("api-version", "2024-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *TaskAssignmentsInstancesReportClient) listHandleResponse(resp *http.Response) (TaskAssignmentsInstancesReportClientListResponse, error) {
	result := TaskAssignmentsInstancesReportClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.TaskReportSummary); err != nil {
		return TaskAssignmentsInstancesReportClientListResponse{}, err
	}
	return result, nil
}
