/* Scanner.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Scanner.vala, do not modify */

/*-
 * Copyright (c) 2018 elementary LLC. (https://elementary.io)
 *               2014 Marvin Beckers <beckersmarvin@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Marvin Beckers <beckersmarvin@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <langinfo.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define PANTHEON_CALCULATOR_CORE_TYPE_SCANNER_ERROR (pantheon_calculator_core_scanner_error_get_type ())

#define PANTHEON_CALCULATOR_CORE_TYPE_SCANNER (pantheon_calculator_core_scanner_get_type ())
#define PANTHEON_CALCULATOR_CORE_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PANTHEON_CALCULATOR_CORE_TYPE_SCANNER, PantheonCalculatorCoreScanner))
#define PANTHEON_CALCULATOR_CORE_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PANTHEON_CALCULATOR_CORE_TYPE_SCANNER, PantheonCalculatorCoreScannerClass))
#define PANTHEON_CALCULATOR_CORE_IS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PANTHEON_CALCULATOR_CORE_TYPE_SCANNER))
#define PANTHEON_CALCULATOR_CORE_IS_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PANTHEON_CALCULATOR_CORE_TYPE_SCANNER))
#define PANTHEON_CALCULATOR_CORE_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PANTHEON_CALCULATOR_CORE_TYPE_SCANNER, PantheonCalculatorCoreScannerClass))

typedef struct _PantheonCalculatorCoreScanner PantheonCalculatorCoreScanner;
typedef struct _PantheonCalculatorCoreScannerClass PantheonCalculatorCoreScannerClass;
typedef struct _PantheonCalculatorCoreScannerPrivate PantheonCalculatorCoreScannerPrivate;
enum  {
	PANTHEON_CALCULATOR_CORE_SCANNER_0_PROPERTY,
	PANTHEON_CALCULATOR_CORE_SCANNER_DECIMAL_SYMBOL_PROPERTY,
	PANTHEON_CALCULATOR_CORE_SCANNER_SEPARATOR_SYMBOL_PROPERTY,
	PANTHEON_CALCULATOR_CORE_SCANNER_NUM_PROPERTIES
};
static GParamSpec* pantheon_calculator_core_scanner_properties[PANTHEON_CALCULATOR_CORE_SCANNER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))

#define PANTHEON_CALCULATOR_CORE_TYPE_TOKEN (pantheon_calculator_core_token_get_type ())
#define PANTHEON_CALCULATOR_CORE_TOKEN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PANTHEON_CALCULATOR_CORE_TYPE_TOKEN, PantheonCalculatorCoreToken))
#define PANTHEON_CALCULATOR_CORE_TOKEN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PANTHEON_CALCULATOR_CORE_TYPE_TOKEN, PantheonCalculatorCoreTokenClass))
#define PANTHEON_CALCULATOR_CORE_IS_TOKEN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PANTHEON_CALCULATOR_CORE_TYPE_TOKEN))
#define PANTHEON_CALCULATOR_CORE_IS_TOKEN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PANTHEON_CALCULATOR_CORE_TYPE_TOKEN))
#define PANTHEON_CALCULATOR_CORE_TOKEN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PANTHEON_CALCULATOR_CORE_TYPE_TOKEN, PantheonCalculatorCoreTokenClass))

typedef struct _PantheonCalculatorCoreToken PantheonCalculatorCoreToken;
typedef struct _PantheonCalculatorCoreTokenClass PantheonCalculatorCoreTokenClass;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef enum  {
	PANTHEON_CALCULATOR_CORE_TOKEN_TYPE_NULL_NUMBER,
	PANTHEON_CALCULATOR_CORE_TOKEN_TYPE_NUMBER,
	PANTHEON_CALCULATOR_CORE_TOKEN_TYPE_OPERATOR,
	PANTHEON_CALCULATOR_CORE_TOKEN_TYPE_FUNCTION,
	PANTHEON_CALCULATOR_CORE_TOKEN_TYPE_SEPARATOR,
	PANTHEON_CALCULATOR_CORE_TOKEN_TYPE_CONSTANT,
	PANTHEON_CALCULATOR_CORE_TOKEN_TYPE_P_LEFT,
	PANTHEON_CALCULATOR_CORE_TOKEN_TYPE_P_RIGHT,
	PANTHEON_CALCULATOR_CORE_TOKEN_TYPE_ALPHA,
	PANTHEON_CALCULATOR_CORE_TOKEN_TYPE_EOF
} PantheonCalculatorCoreTokenType;

#define PANTHEON_CALCULATOR_CORE_TYPE_TOKEN_TYPE (pantheon_calculator_core_token_type_get_type ())

typedef enum  {
	PANTHEON_CALCULATOR_CORE_SCANNER_ERROR_UNKNOWN_TOKEN,
	PANTHEON_CALCULATOR_CORE_SCANNER_ERROR_ALPHA_INVALID,
	PANTHEON_CALCULATOR_CORE_SCANNER_ERROR_MISMATCHED_PARENTHESES
} PantheonCalculatorCoreSCANNER_ERROR;
#define PANTHEON_CALCULATOR_CORE_SCANNER_ERROR pantheon_calculator_core_scanner_error_quark ()

struct _PantheonCalculatorCoreScanner {
	GObject parent_instance;
	PantheonCalculatorCoreScannerPrivate * priv;
};

struct _PantheonCalculatorCoreScannerClass {
	GObjectClass parent_class;
};

struct _PantheonCalculatorCoreScannerPrivate {
	gssize pos;
	gunichar* uc;
	gint uc_length1;
	gint _uc_size_;
	gchar* _decimal_symbol;
	gchar* _separator_symbol;
};

static gint PantheonCalculatorCoreScanner_private_offset;
static gpointer pantheon_calculator_core_scanner_parent_class = NULL;

VALA_EXTERN GQuark pantheon_calculator_core_scanner_error_quark (void);
VALA_EXTERN GType pantheon_calculator_core_scanner_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType pantheon_calculator_core_scanner_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PantheonCalculatorCoreScanner, g_object_unref)
VALA_EXTERN PantheonCalculatorCoreScanner* pantheon_calculator_core_scanner_new (void);
VALA_EXTERN PantheonCalculatorCoreScanner* pantheon_calculator_core_scanner_construct (GType object_type);
VALA_EXTERN void pantheon_calculator_core_scanner_set_decimal_symbol (PantheonCalculatorCoreScanner* self,
                                                          const gchar* value);
VALA_EXTERN void pantheon_calculator_core_scanner_set_separator_symbol (PantheonCalculatorCoreScanner* self,
                                                            const gchar* value);
VALA_EXTERN GType pantheon_calculator_core_token_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PantheonCalculatorCoreToken, g_object_unref)
VALA_EXTERN GList* pantheon_calculator_core_scanner_scan (PantheonCalculatorCoreScanner* self,
                                              const gchar* input,
                                              GError** error);
VALA_EXTERN const gchar* pantheon_calculator_core_scanner_get_separator_symbol (PantheonCalculatorCoreScanner* self);
static PantheonCalculatorCoreToken* pantheon_calculator_core_scanner_next_token (PantheonCalculatorCoreScanner* self,
                                                                          GError** error);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
VALA_EXTERN GType pantheon_calculator_core_token_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN PantheonCalculatorCoreTokenType pantheon_calculator_core_token_get_token_type (PantheonCalculatorCoreToken* self);
VALA_EXTERN gboolean pantheon_calculator_core_evaluation_is_operator (PantheonCalculatorCoreToken* t);
VALA_EXTERN void pantheon_calculator_core_token_set_token_type (PantheonCalculatorCoreToken* self,
                                                    PantheonCalculatorCoreTokenType value);
VALA_EXTERN gboolean pantheon_calculator_core_evaluation_is_function (PantheonCalculatorCoreToken* t);
VALA_EXTERN gboolean pantheon_calculator_core_evaluation_is_constant (PantheonCalculatorCoreToken* t);
VALA_EXTERN const gchar* pantheon_calculator_core_token_get_content (PantheonCalculatorCoreToken* self);
VALA_EXTERN void pantheon_calculator_core_token_set_content (PantheonCalculatorCoreToken* self,
                                                 const gchar* value);
VALA_EXTERN PantheonCalculatorCoreToken* pantheon_calculator_core_token_new (const gchar* in_content,
                                                                 PantheonCalculatorCoreTokenType in_token_type);
VALA_EXTERN PantheonCalculatorCoreToken* pantheon_calculator_core_token_construct (GType object_type,
                                                                       const gchar* in_content,
                                                                       PantheonCalculatorCoreTokenType in_token_type);
VALA_EXTERN const gchar* pantheon_calculator_core_scanner_get_decimal_symbol (PantheonCalculatorCoreScanner* self);
static void pantheon_calculator_core_scanner_finalize (GObject * obj);
static GType pantheon_calculator_core_scanner_get_type_once (void);
static void _vala_pantheon_calculator_core_scanner_get_property (GObject * object,
                                                          guint property_id,
                                                          GValue * value,
                                                          GParamSpec * pspec);
static void _vala_pantheon_calculator_core_scanner_set_property (GObject * object,
                                                          guint property_id,
                                                          const GValue * value,
                                                          GParamSpec * pspec);

GQuark
pantheon_calculator_core_scanner_error_quark (void)
{
	return g_quark_from_static_string ("pantheon-calculator-core-scanner-error-quark");
}

static GType
pantheon_calculator_core_scanner_error_get_type_once (void)
{
	static const GEnumValue values[] = {{PANTHEON_CALCULATOR_CORE_SCANNER_ERROR_UNKNOWN_TOKEN, "PANTHEON_CALCULATOR_CORE_SCANNER_ERROR_UNKNOWN_TOKEN", "unknown-token"}, {PANTHEON_CALCULATOR_CORE_SCANNER_ERROR_ALPHA_INVALID, "PANTHEON_CALCULATOR_CORE_SCANNER_ERROR_ALPHA_INVALID", "alpha-invalid"}, {PANTHEON_CALCULATOR_CORE_SCANNER_ERROR_MISMATCHED_PARENTHESES, "PANTHEON_CALCULATOR_CORE_SCANNER_ERROR_MISMATCHED_PARENTHESES", "mismatched-parentheses"}, {0, NULL, NULL}};
	GType pantheon_calculator_core_scanner_error_type_id;
	pantheon_calculator_core_scanner_error_type_id = g_enum_register_static ("PantheonCalculatorCoreSCANNER_ERROR", values);
	return pantheon_calculator_core_scanner_error_type_id;
}

GType
pantheon_calculator_core_scanner_error_get_type (void)
{
	static volatile gsize pantheon_calculator_core_scanner_error_type_id__once = 0;
	if (g_once_init_enter (&pantheon_calculator_core_scanner_error_type_id__once)) {
		GType pantheon_calculator_core_scanner_error_type_id;
		pantheon_calculator_core_scanner_error_type_id = pantheon_calculator_core_scanner_error_get_type_once ();
		g_once_init_leave (&pantheon_calculator_core_scanner_error_type_id__once, pantheon_calculator_core_scanner_error_type_id);
	}
	return pantheon_calculator_core_scanner_error_type_id__once;
}

static inline gpointer
pantheon_calculator_core_scanner_get_instance_private (PantheonCalculatorCoreScanner* self)
{
	return G_STRUCT_MEMBER_P (self, PantheonCalculatorCoreScanner_private_offset);
}

PantheonCalculatorCoreScanner*
pantheon_calculator_core_scanner_construct (GType object_type)
{
	PantheonCalculatorCoreScanner * self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	self = (PantheonCalculatorCoreScanner*) g_object_new (object_type, NULL);
	_tmp0_ = nl_langinfo (RADIXCHAR);
	pantheon_calculator_core_scanner_set_decimal_symbol (self, _tmp0_);
	_tmp1_ = nl_langinfo (THOUSEP);
	pantheon_calculator_core_scanner_set_separator_symbol (self, _tmp1_);
	return self;
}

PantheonCalculatorCoreScanner*
pantheon_calculator_core_scanner_new (void)
{
	return pantheon_calculator_core_scanner_construct (PANTHEON_CALCULATOR_CORE_TYPE_SCANNER);
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gboolean
string_get_next_char (const gchar* self,
                      gint* index,
                      gunichar* c)
{
	gunichar _vala_c = 0U;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_vala_c = g_utf8_get_char (((gchar*) self) + (*index));
	if (_vala_c != ((gunichar) 0)) {
		gchar* _tmp0_;
		_tmp0_ = g_utf8_next_char (((gchar*) self) + (*index));
		*index = (gint) (_tmp0_ - ((gchar*) self));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gdouble
double_parse (const gchar* str)
{
	gdouble result;
	g_return_val_if_fail (str != NULL, 0.0);
	result = g_ascii_strtod (str, NULL);
	return result;
}

static gchar*
double_to_string (gdouble self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = G_ASCII_DTOSTR_BUF_SIZE;
	_tmp2_ = g_ascii_dtostr (_tmp1_, (gint) G_ASCII_DTOSTR_BUF_SIZE, self);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp1_ = (g_free (_tmp1_), NULL);
	result = _tmp4_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GList*
pantheon_calculator_core_scanner_scan (PantheonCalculatorCoreScanner* self,
                                       const gchar* input,
                                       GError** error)
{
	gint index = 0;
	gunichar c = 0U;
	gboolean next_number_negative = FALSE;
	gchar* str = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gunichar* _tmp5_;
	PantheonCalculatorCoreToken* last_token = NULL;
	GList* token_list = NULL;
	gint parentheses_balance_counter = 0;
	GError* _inner_error0_ = NULL;
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (input != NULL, NULL);
	index = 0;
	next_number_negative = FALSE;
	_tmp0_ = string_replace (input, " ", "");
	str = _tmp0_;
	_tmp1_ = str;
	_tmp2_ = self->priv->_separator_symbol;
	_tmp3_ = string_replace (_tmp1_, _tmp2_, "");
	_g_free0 (str);
	str = _tmp3_;
	self->priv->pos = (gssize) 0;
	_tmp4_ = str;
	_tmp5_ = g_new0 (gunichar, g_utf8_strlen (_tmp4_, (gssize) -1));
	self->priv->uc = (g_free (self->priv->uc), NULL);
	self->priv->uc = _tmp5_;
	self->priv->uc_length1 = g_utf8_strlen (_tmp4_, (gssize) -1);
	self->priv->_uc_size_ = self->priv->uc_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				const gchar* _tmp8_;
				gunichar _tmp9_ = 0U;
				gboolean _tmp10_;
				gunichar* _tmp11_;
				gint _tmp11__length1;
				if (!_tmp6_) {
					gint _tmp7_;
					_tmp7_ = i;
					i = _tmp7_ + 1;
				}
				_tmp6_ = FALSE;
				_tmp8_ = str;
				_tmp10_ = string_get_next_char (_tmp8_, &index, &_tmp9_);
				c = _tmp9_;
				if (!_tmp10_) {
					break;
				}
				_tmp11_ = self->priv->uc;
				_tmp11__length1 = self->priv->uc_length1;
				_tmp11_[i] = c;
			}
		}
	}
	last_token = NULL;
	token_list = NULL;
	parentheses_balance_counter = 0;
	while (TRUE) {
		gunichar* _tmp12_;
		gint _tmp12__length1;
		PantheonCalculatorCoreToken* t = NULL;
		PantheonCalculatorCoreToken* _tmp13_;
		PantheonCalculatorCoreToken* _tmp14_;
		PantheonCalculatorCoreTokenType _tmp15_;
		PantheonCalculatorCoreTokenType _tmp16_;
		gboolean _tmp61_ = FALSE;
		gboolean _tmp71_ = FALSE;
		gboolean _tmp72_ = FALSE;
		PantheonCalculatorCoreToken* _tmp73_;
		PantheonCalculatorCoreToken* _tmp97_;
		PantheonCalculatorCoreTokenType _tmp98_;
		PantheonCalculatorCoreTokenType _tmp99_;
		PantheonCalculatorCoreToken* _tmp103_;
		PantheonCalculatorCoreToken* _tmp104_;
		PantheonCalculatorCoreToken* _tmp105_;
		PantheonCalculatorCoreToken* _tmp106_;
		_tmp12_ = self->priv->uc;
		_tmp12__length1 = self->priv->uc_length1;
		if (!(self->priv->pos < ((gssize) _tmp12__length1))) {
			break;
		}
		_tmp13_ = pantheon_calculator_core_scanner_next_token (self, &_inner_error0_);
		t = _tmp13_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == PANTHEON_CALCULATOR_CORE_SCANNER_ERROR) {
				g_propagate_error (error, _inner_error0_);
				(token_list == NULL) ? NULL : (token_list = (_g_list_free__g_object_unref0_ (token_list), NULL));
				_g_object_unref0 (last_token);
				_g_free0 (str);
				return NULL;
			} else {
				(token_list == NULL) ? NULL : (token_list = (_g_list_free__g_object_unref0_ (token_list), NULL));
				_g_object_unref0 (last_token);
				_g_free0 (str);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp14_ = t;
		_tmp15_ = pantheon_calculator_core_token_get_token_type (_tmp14_);
		_tmp16_ = _tmp15_;
		if (_tmp16_ == PANTHEON_CALCULATOR_CORE_TOKEN_TYPE_ALPHA) {
			PantheonCalculatorCoreToken* _tmp17_;
			_tmp17_ = t;
			if (pantheon_calculator_core_evaluation_is_operator (_tmp17_)) {
				PantheonCalculatorCoreToken* _tmp18_;
				_tmp18_ = t;
				pantheon_calculator_core_token_set_token_type (_tmp18_, PANTHEON_CALCULATOR_CORE_TOKEN_TYPE_OPERATOR);
			} else {
				PantheonCalculatorCoreToken* _tmp19_;
				_tmp19_ = t;
				if (pantheon_calculator_core_evaluation_is_function (_tmp19_)) {
					PantheonCalculatorCoreToken* _tmp20_;
					_tmp20_ = t;
					pantheon_calculator_core_token_set_token_type (_tmp20_, PANTHEON_CALCULATOR_CORE_TOKEN_TYPE_FUNCTION);
				} else {
					PantheonCalculatorCoreToken* _tmp21_;
					_tmp21_ = t;
					if (pantheon_calculator_core_evaluation_is_constant (_tmp21_)) {
						PantheonCalculatorCoreToken* _tmp22_;
						_tmp22_ = t;
						pantheon_calculator_core_token_set_token_type (_tmp22_, PANTHEON_CALCULATOR_CORE_TOKEN_TYPE_CONSTANT);
					} else {
						PantheonCalculatorCoreToken* _tmp23_;
						const gchar* _tmp24_;
						const gchar* _tmp25_;
						GError* _tmp26_;
						_tmp23_ = t;
						_tmp24_ = pantheon_calculator_core_token_get_content (_tmp23_);
						_tmp25_ = _tmp24_;
						_tmp26_ = g_error_new (PANTHEON_CALCULATOR_CORE_SCANNER_ERROR, PANTHEON_CALCULATOR_CORE_SCANNER_ERROR_ALPHA_INVALID, _ ("'%s' is invalid."), _tmp25_);
						_inner_error0_ = _tmp26_;
						if (_inner_error0_->domain == PANTHEON_CALCULATOR_CORE_SCANNER_ERROR) {
							g_propagate_error (error, _inner_error0_);
							_g_object_unref0 (t);
							(token_list == NULL) ? NULL : (token_list = (_g_list_free__g_object_unref0_ (token_list), NULL));
							_g_object_unref0 (last_token);
							_g_free0 (str);
							return NULL;
						} else {
							_g_object_unref0 (t);
							(token_list == NULL) ? NULL : (token_list = (_g_list_free__g_object_unref0_ (token_list), NULL));
							_g_object_unref0 (last_token);
							_g_free0 (str);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
					}
				}
			}
		} else {
			gboolean _tmp27_ = FALSE;
			PantheonCalculatorCoreToken* _tmp28_;
			PantheonCalculatorCoreTokenType _tmp29_;
			PantheonCalculatorCoreTokenType _tmp30_;
			_tmp28_ = t;
			_tmp29_ = pantheon_calculator_core_token_get_token_type (_tmp28_);
			_tmp30_ = _tmp29_;
			if (_tmp30_ == PANTHEON_CALCULATOR_CORE_TOKEN_TYPE_OPERATOR) {
				PantheonCalculatorCoreToken* _tmp31_;
				const gchar* _tmp32_;
				const gchar* _tmp33_;
				_tmp31_ = t;
				_tmp32_ = pantheon_calculator_core_token_get_content (_tmp31_);
				_tmp33_ = _tmp32_;
				_tmp27_ = string_contains ("-−", _tmp33_);
			} else {
				_tmp27_ = FALSE;
			}
			if (_tmp27_) {
				gboolean _tmp34_ = FALSE;
				PantheonCalculatorCoreToken* _tmp35_;
				_tmp35_ = last_token;
				if (_tmp35_ == NULL) {
					_tmp34_ = TRUE;
				} else {
					gboolean _tmp36_ = FALSE;
					gboolean _tmp37_ = FALSE;
					gboolean _tmp38_ = FALSE;
					PantheonCalculatorCoreToken* _tmp39_;
					PantheonCalculatorCoreTokenType _tmp40_;
					PantheonCalculatorCoreTokenType _tmp41_;
					_tmp39_ = last_token;
					_tmp40_ = pantheon_calculator_core_token_get_token_type (_tmp39_);
					_tmp41_ = _tmp40_;
					if (_tmp41_ == PANTHEON_CALCULATOR_CORE_TOKEN_TYPE_OPERATOR) {
						PantheonCalculatorCoreToken* _tmp42_;
						const gchar* _tmp43_;
						const gchar* _tmp44_;
						_tmp42_ = last_token;
						_tmp43_ = pantheon_calculator_core_token_get_content (_tmp42_);
						_tmp44_ = _tmp43_;
						_tmp38_ = g_strcmp0 (_tmp44_, "%") != 0;
					} else {
						_tmp38_ = FALSE;
					}
					if (_tmp38_) {
						_tmp37_ = TRUE;
					} else {
						PantheonCalculatorCoreToken* _tmp45_;
						PantheonCalculatorCoreTokenType _tmp46_;
						PantheonCalculatorCoreTokenType _tmp47_;
						_tmp45_ = last_token;
						_tmp46_ = pantheon_calculator_core_token_get_token_type (_tmp45_);
						_tmp47_ = _tmp46_;
						_tmp37_ = _tmp47_ == PANTHEON_CALCULATOR_CORE_TOKEN_TYPE_FUNCTION;
					}
					if (_tmp37_) {
						_tmp36_ = TRUE;
					} else {
						PantheonCalculatorCoreToken* _tmp48_;
						PantheonCalculatorCoreTokenType _tmp49_;
						PantheonCalculatorCoreTokenType _tmp50_;
						_tmp48_ = last_token;
						_tmp49_ = pantheon_calculator_core_token_get_token_type (_tmp48_);
						_tmp50_ = _tmp49_;
						_tmp36_ = _tmp50_ == PANTHEON_CALCULATOR_CORE_TOKEN_TYPE_P_LEFT;
					}
					_tmp34_ = _tmp36_;
				}
				if (_tmp34_) {
					next_number_negative = TRUE;
					_g_object_unref0 (t);
					continue;
				}
			} else {
				PantheonCalculatorCoreToken* _tmp51_;
				PantheonCalculatorCoreTokenType _tmp52_;
				PantheonCalculatorCoreTokenType _tmp53_;
				_tmp51_ = t;
				_tmp52_ = pantheon_calculator_core_token_get_token_type (_tmp51_);
				_tmp53_ = _tmp52_;
				if (_tmp53_ == PANTHEON_CALCULATOR_CORE_TOKEN_TYPE_NULL_NUMBER) {
					PantheonCalculatorCoreToken* _tmp54_;
					PantheonCalculatorCoreToken* _tmp55_;
					const gchar* _tmp56_;
					const gchar* _tmp57_;
					gchar* _tmp58_;
					gchar* _tmp59_;
					PantheonCalculatorCoreToken* _tmp60_;
					_tmp54_ = t;
					_tmp55_ = t;
					_tmp56_ = pantheon_calculator_core_token_get_content (_tmp55_);
					_tmp57_ = _tmp56_;
					_tmp58_ = g_strconcat ("0", _tmp57_, NULL);
					_tmp59_ = _tmp58_;
					pantheon_calculator_core_token_set_content (_tmp54_, _tmp59_);
					_g_free0 (_tmp59_);
					_tmp60_ = t;
					pantheon_calculator_core_token_set_token_type (_tmp60_, PANTHEON_CALCULATOR_CORE_TOKEN_TYPE_NUMBER);
				}
			}
		}
		if (next_number_negative) {
			PantheonCalculatorCoreToken* _tmp62_;
			PantheonCalculatorCoreTokenType _tmp63_;
			PantheonCalculatorCoreTokenType _tmp64_;
			_tmp62_ = t;
			_tmp63_ = pantheon_calculator_core_token_get_token_type (_tmp62_);
			_tmp64_ = _tmp63_;
			_tmp61_ = _tmp64_ == PANTHEON_CALCULATOR_CORE_TOKEN_TYPE_NUMBER;
		} else {
			_tmp61_ = FALSE;
		}
		if (_tmp61_) {
			PantheonCalculatorCoreToken* _tmp65_;
			PantheonCalculatorCoreToken* _tmp66_;
			const gchar* _tmp67_;
			const gchar* _tmp68_;
			gchar* _tmp69_;
			gchar* _tmp70_;
			_tmp65_ = t;
			_tmp66_ = t;
			_tmp67_ = pantheon_calculator_core_token_get_content (_tmp66_);
			_tmp68_ = _tmp67_;
			_tmp69_ = double_to_string (double_parse (_tmp68_) * -1);
			_tmp70_ = _tmp69_;
			pantheon_calculator_core_token_set_content (_tmp65_, _tmp70_);
			_g_free0 (_tmp70_);
			next_number_negative = FALSE;
		}
		_tmp73_ = last_token;
		if (_tmp73_ != NULL) {
			gboolean _tmp74_ = FALSE;
			PantheonCalculatorCoreToken* _tmp75_;
			PantheonCalculatorCoreTokenType _tmp76_;
			PantheonCalculatorCoreTokenType _tmp77_;
			_tmp75_ = last_token;
			_tmp76_ = pantheon_calculator_core_token_get_token_type (_tmp75_);
			_tmp77_ = _tmp76_;
			if (_tmp77_ == PANTHEON_CALCULATOR_CORE_TOKEN_TYPE_NUMBER) {
				_tmp74_ = TRUE;
			} else {
				PantheonCalculatorCoreToken* _tmp78_;
				PantheonCalculatorCoreTokenType _tmp79_;
				PantheonCalculatorCoreTokenType _tmp80_;
				_tmp78_ = last_token;
				_tmp79_ = pantheon_calculator_core_token_get_token_type (_tmp78_);
				_tmp80_ = _tmp79_;
				_tmp74_ = _tmp80_ == PANTHEON_CALCULATOR_CORE_TOKEN_TYPE_P_RIGHT;
			}
			_tmp72_ = _tmp74_;
		} else {
			_tmp72_ = FALSE;
		}
		if (_tmp72_) {
			gboolean _tmp81_ = FALSE;
			gboolean _tmp82_ = FALSE;
			gboolean _tmp83_ = FALSE;
			PantheonCalculatorCoreToken* _tmp84_;
			PantheonCalculatorCoreTokenType _tmp85_;
			PantheonCalculatorCoreTokenType _tmp86_;
			_tmp84_ = t;
			_tmp85_ = pantheon_calculator_core_token_get_token_type (_tmp84_);
			_tmp86_ = _tmp85_;
			if (_tmp86_ == PANTHEON_CALCULATOR_CORE_TOKEN_TYPE_FUNCTION) {
				_tmp83_ = TRUE;
			} else {
				PantheonCalculatorCoreToken* _tmp87_;
				PantheonCalculatorCoreTokenType _tmp88_;
				PantheonCalculatorCoreTokenType _tmp89_;
				_tmp87_ = t;
				_tmp88_ = pantheon_calculator_core_token_get_token_type (_tmp87_);
				_tmp89_ = _tmp88_;
				_tmp83_ = _tmp89_ == PANTHEON_CALCULATOR_CORE_TOKEN_TYPE_CONSTANT;
			}
			if (_tmp83_) {
				_tmp82_ = TRUE;
			} else {
				PantheonCalculatorCoreToken* _tmp90_;
				PantheonCalculatorCoreTokenType _tmp91_;
				PantheonCalculatorCoreTokenType _tmp92_;
				_tmp90_ = t;
				_tmp91_ = pantheon_calculator_core_token_get_token_type (_tmp90_);
				_tmp92_ = _tmp91_;
				_tmp82_ = _tmp92_ == PANTHEON_CALCULATOR_CORE_TOKEN_TYPE_P_LEFT;
			}
			if (_tmp82_) {
				_tmp81_ = TRUE;
			} else {
				PantheonCalculatorCoreToken* _tmp93_;
				PantheonCalculatorCoreTokenType _tmp94_;
				PantheonCalculatorCoreTokenType _tmp95_;
				_tmp93_ = t;
				_tmp94_ = pantheon_calculator_core_token_get_token_type (_tmp93_);
				_tmp95_ = _tmp94_;
				_tmp81_ = _tmp95_ == PANTHEON_CALCULATOR_CORE_TOKEN_TYPE_NUMBER;
			}
			_tmp71_ = _tmp81_;
		} else {
			_tmp71_ = FALSE;
		}
		if (_tmp71_) {
			PantheonCalculatorCoreToken* _tmp96_;
			_tmp96_ = pantheon_calculator_core_token_new ("*", PANTHEON_CALCULATOR_CORE_TOKEN_TYPE_OPERATOR);
			token_list = g_list_append (token_list, _tmp96_);
		}
		_tmp97_ = t;
		_tmp98_ = pantheon_calculator_core_token_get_token_type (_tmp97_);
		_tmp99_ = _tmp98_;
		if (_tmp99_ == PANTHEON_CALCULATOR_CORE_TOKEN_TYPE_P_LEFT) {
			parentheses_balance_counter -= 1;
		} else {
			PantheonCalculatorCoreToken* _tmp100_;
			PantheonCalculatorCoreTokenType _tmp101_;
			PantheonCalculatorCoreTokenType _tmp102_;
			_tmp100_ = t;
			_tmp101_ = pantheon_calculator_core_token_get_token_type (_tmp100_);
			_tmp102_ = _tmp101_;
			if (_tmp102_ == PANTHEON_CALCULATOR_CORE_TOKEN_TYPE_P_RIGHT) {
				parentheses_balance_counter += 1;
			}
		}
		_tmp103_ = t;
		_tmp104_ = _g_object_ref0 (_tmp103_);
		token_list = g_list_append (token_list, _tmp104_);
		_tmp105_ = t;
		_tmp106_ = _g_object_ref0 (_tmp105_);
		_g_object_unref0 (last_token);
		last_token = _tmp106_;
		_g_object_unref0 (t);
	}
	if (parentheses_balance_counter != 0) {
		GError* _tmp107_;
		_tmp107_ = g_error_new_literal (PANTHEON_CALCULATOR_CORE_SCANNER_ERROR, PANTHEON_CALCULATOR_CORE_SCANNER_ERROR_MISMATCHED_PARENTHESES, _ ("Mismatched parenthesis."));
		_inner_error0_ = _tmp107_;
		if (_inner_error0_->domain == PANTHEON_CALCULATOR_CORE_SCANNER_ERROR) {
			g_propagate_error (error, _inner_error0_);
			(token_list == NULL) ? NULL : (token_list = (_g_list_free__g_object_unref0_ (token_list), NULL));
			_g_object_unref0 (last_token);
			_g_free0 (str);
			return NULL;
		} else {
			(token_list == NULL) ? NULL : (token_list = (_g_list_free__g_object_unref0_ (token_list), NULL));
			_g_object_unref0 (last_token);
			_g_free0 (str);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	result = token_list;
	_g_object_unref0 (last_token);
	_g_free0 (str);
	return result;
}

static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_utf8_get_char (((gchar*) self) + index);
	return result;
}

static gchar*
g_unichar_to_string (gunichar self)
{
	gchar* str = NULL;
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	g_unichar_to_utf8 (self, str);
	result = str;
	return result;
}

static PantheonCalculatorCoreToken*
pantheon_calculator_core_scanner_next_token (PantheonCalculatorCoreScanner* self,
                                             GError** error)
{
	gssize start = 0L;
	PantheonCalculatorCoreTokenType type = 0;
	gunichar* _tmp0_;
	gint _tmp0__length1;
	gunichar _tmp1_;
	const gchar* _tmp2_;
	gchar* substr = NULL;
	gchar* _tmp79_;
	const gchar* _tmp88_;
	const gchar* _tmp89_;
	gchar* _tmp90_;
	const gchar* _tmp91_;
	PantheonCalculatorCoreToken* _tmp92_;
	GError* _inner_error0_ = NULL;
	PantheonCalculatorCoreToken* result;
	g_return_val_if_fail (self != NULL, NULL);
	start = self->priv->pos;
	_tmp0_ = self->priv->uc;
	_tmp0__length1 = self->priv->uc_length1;
	_tmp1_ = _tmp0_[self->priv->pos];
	_tmp2_ = self->priv->_decimal_symbol;
	if (_tmp1_ == string_get_char (_tmp2_, (glong) 0)) {
		gssize _tmp3_;
		_tmp3_ = self->priv->pos;
		self->priv->pos = _tmp3_ + 1;
		while (TRUE) {
			gboolean _tmp4_ = FALSE;
			gunichar* _tmp5_;
			gint _tmp5__length1;
			gunichar _tmp6_;
			gssize _tmp8_;
			_tmp5_ = self->priv->uc;
			_tmp5__length1 = self->priv->uc_length1;
			_tmp6_ = _tmp5_[self->priv->pos];
			if (g_unichar_isdigit (_tmp6_)) {
				gunichar* _tmp7_;
				gint _tmp7__length1;
				_tmp7_ = self->priv->uc;
				_tmp7__length1 = self->priv->uc_length1;
				_tmp4_ = self->priv->pos < ((gssize) _tmp7__length1);
			} else {
				_tmp4_ = FALSE;
			}
			if (!_tmp4_) {
				break;
			}
			_tmp8_ = self->priv->pos;
			self->priv->pos = _tmp8_ + 1;
		}
		type = PANTHEON_CALCULATOR_CORE_TOKEN_TYPE_NULL_NUMBER;
	} else {
		gunichar* _tmp9_;
		gint _tmp9__length1;
		gunichar _tmp10_;
		_tmp9_ = self->priv->uc;
		_tmp9__length1 = self->priv->uc_length1;
		_tmp10_ = _tmp9_[self->priv->pos];
		if (g_unichar_isdigit (_tmp10_)) {
			gunichar* _tmp16_;
			gint _tmp16__length1;
			gunichar _tmp17_;
			const gchar* _tmp18_;
			while (TRUE) {
				gboolean _tmp11_ = FALSE;
				gunichar* _tmp12_;
				gint _tmp12__length1;
				gunichar _tmp13_;
				gssize _tmp15_;
				_tmp12_ = self->priv->uc;
				_tmp12__length1 = self->priv->uc_length1;
				_tmp13_ = _tmp12_[self->priv->pos];
				if (g_unichar_isdigit (_tmp13_)) {
					gunichar* _tmp14_;
					gint _tmp14__length1;
					_tmp14_ = self->priv->uc;
					_tmp14__length1 = self->priv->uc_length1;
					_tmp11_ = self->priv->pos < ((gssize) _tmp14__length1);
				} else {
					_tmp11_ = FALSE;
				}
				if (!_tmp11_) {
					break;
				}
				_tmp15_ = self->priv->pos;
				self->priv->pos = _tmp15_ + 1;
			}
			_tmp16_ = self->priv->uc;
			_tmp16__length1 = self->priv->uc_length1;
			_tmp17_ = _tmp16_[self->priv->pos];
			_tmp18_ = self->priv->_decimal_symbol;
			if (_tmp17_ == string_get_char (_tmp18_, (glong) 0)) {
				gssize _tmp19_;
				_tmp19_ = self->priv->pos;
				self->priv->pos = _tmp19_ + 1;
			}
			while (TRUE) {
				gboolean _tmp20_ = FALSE;
				gunichar* _tmp21_;
				gint _tmp21__length1;
				gunichar _tmp22_;
				gssize _tmp24_;
				_tmp21_ = self->priv->uc;
				_tmp21__length1 = self->priv->uc_length1;
				_tmp22_ = _tmp21_[self->priv->pos];
				if (g_unichar_isdigit (_tmp22_)) {
					gunichar* _tmp23_;
					gint _tmp23__length1;
					_tmp23_ = self->priv->uc;
					_tmp23__length1 = self->priv->uc_length1;
					_tmp20_ = self->priv->pos < ((gssize) _tmp23__length1);
				} else {
					_tmp20_ = FALSE;
				}
				if (!_tmp20_) {
					break;
				}
				_tmp24_ = self->priv->pos;
				self->priv->pos = _tmp24_ + 1;
			}
			type = PANTHEON_CALCULATOR_CORE_TOKEN_TYPE_NUMBER;
		} else {
			gboolean _tmp25_ = FALSE;
			gboolean _tmp26_ = FALSE;
			gboolean _tmp27_ = FALSE;
			gboolean _tmp28_ = FALSE;
			gboolean _tmp29_ = FALSE;
			gboolean _tmp30_ = FALSE;
			gboolean _tmp31_ = FALSE;
			gboolean _tmp32_ = FALSE;
			gunichar* _tmp33_;
			gint _tmp33__length1;
			gunichar _tmp34_;
			_tmp33_ = self->priv->uc;
			_tmp33__length1 = self->priv->uc_length1;
			_tmp34_ = _tmp33_[self->priv->pos];
			if (_tmp34_ == ((gunichar) '+')) {
				_tmp32_ = TRUE;
			} else {
				gunichar* _tmp35_;
				gint _tmp35__length1;
				gunichar _tmp36_;
				_tmp35_ = self->priv->uc;
				_tmp35__length1 = self->priv->uc_length1;
				_tmp36_ = _tmp35_[self->priv->pos];
				_tmp32_ = _tmp36_ == ((gunichar) '-');
			}
			if (_tmp32_) {
				_tmp31_ = TRUE;
			} else {
				gunichar* _tmp37_;
				gint _tmp37__length1;
				gunichar _tmp38_;
				_tmp37_ = self->priv->uc;
				_tmp37__length1 = self->priv->uc_length1;
				_tmp38_ = _tmp37_[self->priv->pos];
				_tmp31_ = _tmp38_ == ((gunichar) '*');
			}
			if (_tmp31_) {
				_tmp30_ = TRUE;
			} else {
				gunichar* _tmp39_;
				gint _tmp39__length1;
				gunichar _tmp40_;
				_tmp39_ = self->priv->uc;
				_tmp39__length1 = self->priv->uc_length1;
				_tmp40_ = _tmp39_[self->priv->pos];
				_tmp30_ = _tmp40_ == ((gunichar) '/');
			}
			if (_tmp30_) {
				_tmp29_ = TRUE;
			} else {
				gunichar* _tmp41_;
				gint _tmp41__length1;
				gunichar _tmp42_;
				_tmp41_ = self->priv->uc;
				_tmp41__length1 = self->priv->uc_length1;
				_tmp42_ = _tmp41_[self->priv->pos];
				_tmp29_ = _tmp42_ == ((gunichar) '^');
			}
			if (_tmp29_) {
				_tmp28_ = TRUE;
			} else {
				gunichar* _tmp43_;
				gint _tmp43__length1;
				gunichar _tmp44_;
				_tmp43_ = self->priv->uc;
				_tmp43__length1 = self->priv->uc_length1;
				_tmp44_ = _tmp43_[self->priv->pos];
				_tmp28_ = _tmp44_ == ((gunichar) '%');
			}
			if (_tmp28_) {
				_tmp27_ = TRUE;
			} else {
				gunichar* _tmp45_;
				gint _tmp45__length1;
				gunichar _tmp46_;
				_tmp45_ = self->priv->uc;
				_tmp45__length1 = self->priv->uc_length1;
				_tmp46_ = _tmp45_[self->priv->pos];
				_tmp27_ = _tmp46_ == 247U;
			}
			if (_tmp27_) {
				_tmp26_ = TRUE;
			} else {
				gunichar* _tmp47_;
				gint _tmp47__length1;
				gunichar _tmp48_;
				_tmp47_ = self->priv->uc;
				_tmp47__length1 = self->priv->uc_length1;
				_tmp48_ = _tmp47_[self->priv->pos];
				_tmp26_ = _tmp48_ == 215U;
			}
			if (_tmp26_) {
				_tmp25_ = TRUE;
			} else {
				gunichar* _tmp49_;
				gint _tmp49__length1;
				gunichar _tmp50_;
				_tmp49_ = self->priv->uc;
				_tmp49__length1 = self->priv->uc_length1;
				_tmp50_ = _tmp49_[self->priv->pos];
				_tmp25_ = _tmp50_ == 8722U;
			}
			if (_tmp25_) {
				gssize _tmp51_;
				_tmp51_ = self->priv->pos;
				self->priv->pos = _tmp51_ + 1;
				type = PANTHEON_CALCULATOR_CORE_TOKEN_TYPE_OPERATOR;
			} else {
				gunichar* _tmp52_;
				gint _tmp52__length1;
				gunichar _tmp53_;
				_tmp52_ = self->priv->uc;
				_tmp52__length1 = self->priv->uc_length1;
				_tmp53_ = _tmp52_[self->priv->pos];
				if (_tmp53_ == 8730U) {
					gssize _tmp54_;
					_tmp54_ = self->priv->pos;
					self->priv->pos = _tmp54_ + 1;
					type = PANTHEON_CALCULATOR_CORE_TOKEN_TYPE_FUNCTION;
				} else {
					gunichar* _tmp55_;
					gint _tmp55__length1;
					gunichar _tmp56_;
					_tmp55_ = self->priv->uc;
					_tmp55__length1 = self->priv->uc_length1;
					_tmp56_ = _tmp55_[self->priv->pos];
					if (_tmp56_ == 960U) {
						gssize _tmp57_;
						_tmp57_ = self->priv->pos;
						self->priv->pos = _tmp57_ + 1;
						type = PANTHEON_CALCULATOR_CORE_TOKEN_TYPE_CONSTANT;
					} else {
						gunichar* _tmp58_;
						gint _tmp58__length1;
						gunichar _tmp59_;
						_tmp58_ = self->priv->uc;
						_tmp58__length1 = self->priv->uc_length1;
						_tmp59_ = _tmp58_[self->priv->pos];
						if (g_unichar_isalpha (_tmp59_)) {
							while (TRUE) {
								gboolean _tmp60_ = FALSE;
								gunichar* _tmp61_;
								gint _tmp61__length1;
								gunichar _tmp62_;
								gssize _tmp64_;
								_tmp61_ = self->priv->uc;
								_tmp61__length1 = self->priv->uc_length1;
								_tmp62_ = _tmp61_[self->priv->pos];
								if (g_unichar_isalpha (_tmp62_)) {
									gunichar* _tmp63_;
									gint _tmp63__length1;
									_tmp63_ = self->priv->uc;
									_tmp63__length1 = self->priv->uc_length1;
									_tmp60_ = self->priv->pos < ((gssize) _tmp63__length1);
								} else {
									_tmp60_ = FALSE;
								}
								if (!_tmp60_) {
									break;
								}
								_tmp64_ = self->priv->pos;
								self->priv->pos = _tmp64_ + 1;
							}
							type = PANTHEON_CALCULATOR_CORE_TOKEN_TYPE_ALPHA;
						} else {
							gunichar* _tmp65_;
							gint _tmp65__length1;
							gunichar _tmp66_;
							_tmp65_ = self->priv->uc;
							_tmp65__length1 = self->priv->uc_length1;
							_tmp66_ = _tmp65_[self->priv->pos];
							if (_tmp66_ == ((gunichar) '(')) {
								gssize _tmp67_;
								_tmp67_ = self->priv->pos;
								self->priv->pos = _tmp67_ + 1;
								type = PANTHEON_CALCULATOR_CORE_TOKEN_TYPE_P_LEFT;
							} else {
								gunichar* _tmp68_;
								gint _tmp68__length1;
								gunichar _tmp69_;
								_tmp68_ = self->priv->uc;
								_tmp68__length1 = self->priv->uc_length1;
								_tmp69_ = _tmp68_[self->priv->pos];
								if (_tmp69_ == ((gunichar) ')')) {
									gssize _tmp70_;
									_tmp70_ = self->priv->pos;
									self->priv->pos = _tmp70_ + 1;
									type = PANTHEON_CALCULATOR_CORE_TOKEN_TYPE_P_RIGHT;
								} else {
									gunichar* _tmp71_;
									gint _tmp71__length1;
									gunichar _tmp72_;
									_tmp71_ = self->priv->uc;
									_tmp71__length1 = self->priv->uc_length1;
									_tmp72_ = _tmp71_[self->priv->pos];
									if (_tmp72_ == ((gunichar) '\0')) {
										type = PANTHEON_CALCULATOR_CORE_TOKEN_TYPE_EOF;
									} else {
										gunichar* _tmp73_;
										gint _tmp73__length1;
										gunichar _tmp74_;
										gchar* _tmp75_;
										gchar* _tmp76_;
										GError* _tmp77_;
										GError* _tmp78_;
										_tmp73_ = self->priv->uc;
										_tmp73__length1 = self->priv->uc_length1;
										_tmp74_ = _tmp73_[self->priv->pos];
										_tmp75_ = g_unichar_to_string (_tmp74_);
										_tmp76_ = _tmp75_;
										_tmp77_ = g_error_new (PANTHEON_CALCULATOR_CORE_SCANNER_ERROR, PANTHEON_CALCULATOR_CORE_SCANNER_ERROR_UNKNOWN_TOKEN, _ ("'%s' is unknown."), _tmp76_);
										_tmp78_ = _tmp77_;
										_g_free0 (_tmp76_);
										_inner_error0_ = _tmp78_;
										if (_inner_error0_->domain == PANTHEON_CALCULATOR_CORE_SCANNER_ERROR) {
											g_propagate_error (error, _inner_error0_);
											return NULL;
										} else {
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
											g_clear_error (&_inner_error0_);
											return NULL;
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp79_ = g_strdup ("");
	substr = _tmp79_;
	{
		gssize i = 0L;
		i = start;
		{
			gboolean _tmp80_ = FALSE;
			_tmp80_ = TRUE;
			while (TRUE) {
				const gchar* _tmp82_;
				gunichar* _tmp83_;
				gint _tmp83__length1;
				gunichar _tmp84_;
				gchar* _tmp85_;
				gchar* _tmp86_;
				gchar* _tmp87_;
				if (!_tmp80_) {
					gssize _tmp81_;
					_tmp81_ = i;
					i = _tmp81_ + 1;
				}
				_tmp80_ = FALSE;
				if (!(i < self->priv->pos)) {
					break;
				}
				_tmp82_ = substr;
				_tmp83_ = self->priv->uc;
				_tmp83__length1 = self->priv->uc_length1;
				_tmp84_ = _tmp83_[i];
				_tmp85_ = g_unichar_to_string (_tmp84_);
				_tmp86_ = _tmp85_;
				_tmp87_ = g_strconcat (_tmp82_, _tmp86_, NULL);
				_g_free0 (substr);
				substr = _tmp87_;
				_g_free0 (_tmp86_);
			}
		}
	}
	_tmp88_ = substr;
	_tmp89_ = self->priv->_decimal_symbol;
	_tmp90_ = string_replace (_tmp88_, _tmp89_, ".");
	_g_free0 (substr);
	substr = _tmp90_;
	_tmp91_ = substr;
	_tmp92_ = pantheon_calculator_core_token_new (_tmp91_, type);
	result = _tmp92_;
	_g_free0 (substr);
	return result;
}

const gchar*
pantheon_calculator_core_scanner_get_decimal_symbol (PantheonCalculatorCoreScanner* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_decimal_symbol;
	result = _tmp0_;
	return result;
}

void
pantheon_calculator_core_scanner_set_decimal_symbol (PantheonCalculatorCoreScanner* self,
                                                     const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = pantheon_calculator_core_scanner_get_decimal_symbol (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_decimal_symbol);
		self->priv->_decimal_symbol = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, pantheon_calculator_core_scanner_properties[PANTHEON_CALCULATOR_CORE_SCANNER_DECIMAL_SYMBOL_PROPERTY]);
	}
}

const gchar*
pantheon_calculator_core_scanner_get_separator_symbol (PantheonCalculatorCoreScanner* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_separator_symbol;
	result = _tmp0_;
	return result;
}

void
pantheon_calculator_core_scanner_set_separator_symbol (PantheonCalculatorCoreScanner* self,
                                                       const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = pantheon_calculator_core_scanner_get_separator_symbol (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_separator_symbol);
		self->priv->_separator_symbol = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, pantheon_calculator_core_scanner_properties[PANTHEON_CALCULATOR_CORE_SCANNER_SEPARATOR_SYMBOL_PROPERTY]);
	}
}

static void
pantheon_calculator_core_scanner_class_init (PantheonCalculatorCoreScannerClass * klass,
                                             gpointer klass_data)
{
	pantheon_calculator_core_scanner_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PantheonCalculatorCoreScanner_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_pantheon_calculator_core_scanner_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_pantheon_calculator_core_scanner_set_property;
	G_OBJECT_CLASS (klass)->finalize = pantheon_calculator_core_scanner_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PANTHEON_CALCULATOR_CORE_SCANNER_DECIMAL_SYMBOL_PROPERTY, pantheon_calculator_core_scanner_properties[PANTHEON_CALCULATOR_CORE_SCANNER_DECIMAL_SYMBOL_PROPERTY] = g_param_spec_string ("decimal-symbol", "decimal-symbol", "decimal-symbol", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PANTHEON_CALCULATOR_CORE_SCANNER_SEPARATOR_SYMBOL_PROPERTY, pantheon_calculator_core_scanner_properties[PANTHEON_CALCULATOR_CORE_SCANNER_SEPARATOR_SYMBOL_PROPERTY] = g_param_spec_string ("separator-symbol", "separator-symbol", "separator-symbol", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
pantheon_calculator_core_scanner_instance_init (PantheonCalculatorCoreScanner * self,
                                                gpointer klass)
{
	self->priv = pantheon_calculator_core_scanner_get_instance_private (self);
}

static void
pantheon_calculator_core_scanner_finalize (GObject * obj)
{
	PantheonCalculatorCoreScanner * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PANTHEON_CALCULATOR_CORE_TYPE_SCANNER, PantheonCalculatorCoreScanner);
	self->priv->uc = (g_free (self->priv->uc), NULL);
	_g_free0 (self->priv->_decimal_symbol);
	_g_free0 (self->priv->_separator_symbol);
	G_OBJECT_CLASS (pantheon_calculator_core_scanner_parent_class)->finalize (obj);
}

static GType
pantheon_calculator_core_scanner_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PantheonCalculatorCoreScannerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pantheon_calculator_core_scanner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PantheonCalculatorCoreScanner), 0, (GInstanceInitFunc) pantheon_calculator_core_scanner_instance_init, NULL };
	GType pantheon_calculator_core_scanner_type_id;
	pantheon_calculator_core_scanner_type_id = g_type_register_static (G_TYPE_OBJECT, "PantheonCalculatorCoreScanner", &g_define_type_info, 0);
	PantheonCalculatorCoreScanner_private_offset = g_type_add_instance_private (pantheon_calculator_core_scanner_type_id, sizeof (PantheonCalculatorCoreScannerPrivate));
	return pantheon_calculator_core_scanner_type_id;
}

GType
pantheon_calculator_core_scanner_get_type (void)
{
	static volatile gsize pantheon_calculator_core_scanner_type_id__once = 0;
	if (g_once_init_enter (&pantheon_calculator_core_scanner_type_id__once)) {
		GType pantheon_calculator_core_scanner_type_id;
		pantheon_calculator_core_scanner_type_id = pantheon_calculator_core_scanner_get_type_once ();
		g_once_init_leave (&pantheon_calculator_core_scanner_type_id__once, pantheon_calculator_core_scanner_type_id);
	}
	return pantheon_calculator_core_scanner_type_id__once;
}

static void
_vala_pantheon_calculator_core_scanner_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec)
{
	PantheonCalculatorCoreScanner * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PANTHEON_CALCULATOR_CORE_TYPE_SCANNER, PantheonCalculatorCoreScanner);
	switch (property_id) {
		case PANTHEON_CALCULATOR_CORE_SCANNER_DECIMAL_SYMBOL_PROPERTY:
		g_value_set_string (value, pantheon_calculator_core_scanner_get_decimal_symbol (self));
		break;
		case PANTHEON_CALCULATOR_CORE_SCANNER_SEPARATOR_SYMBOL_PROPERTY:
		g_value_set_string (value, pantheon_calculator_core_scanner_get_separator_symbol (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_pantheon_calculator_core_scanner_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec)
{
	PantheonCalculatorCoreScanner * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PANTHEON_CALCULATOR_CORE_TYPE_SCANNER, PantheonCalculatorCoreScanner);
	switch (property_id) {
		case PANTHEON_CALCULATOR_CORE_SCANNER_DECIMAL_SYMBOL_PROPERTY:
		pantheon_calculator_core_scanner_set_decimal_symbol (self, g_value_get_string (value));
		break;
		case PANTHEON_CALCULATOR_CORE_SCANNER_SEPARATOR_SYMBOL_PROPERTY:
		pantheon_calculator_core_scanner_set_separator_symbol (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

