/* SymbolOutline.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from SymbolOutline.vala, do not modify */

/*-
 * Copyright (c) 2013-2018 elementary LLC. (https://elementary.io)
 * Copyright (C) 2013 Tom Beckmann <tomjonabc@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <gtk/gtk.h>
#include <gee.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <gtksourceview/gtksource.h>

#define SCRATCH_SERVICES_SYMBOL_OUTLINE_ACTION_GROUP "symbol"
#define SCRATCH_SERVICES_SYMBOL_OUTLINE_ACTION_PREFIX SCRATCH_SERVICES_SYMBOL_OUTLINE_ACTION_GROUP "."
#define SCRATCH_SERVICES_SYMBOL_OUTLINE_ACTION_SELECT "action-select"
#define SCRATCH_SERVICES_SYMBOL_OUTLINE_ACTION_TOGGLE "toggle-"
#define SCRATCH_SERVICES_SYMBOL_OUTLINE_SPINNER_DELAY_MSEC ((guint) 300)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	SCRATCH_SERVICES_SYMBOL_TYPE_CLASS,
	SCRATCH_SERVICES_SYMBOL_TYPE_PROPERTY,
	SCRATCH_SERVICES_SYMBOL_TYPE_SIGNAL,
	SCRATCH_SERVICES_SYMBOL_TYPE_METHOD,
	SCRATCH_SERVICES_SYMBOL_TYPE_STRUCT,
	SCRATCH_SERVICES_SYMBOL_TYPE_ENUM,
	SCRATCH_SERVICES_SYMBOL_TYPE_CONSTANT,
	SCRATCH_SERVICES_SYMBOL_TYPE_CONSTRUCTOR,
	SCRATCH_SERVICES_SYMBOL_TYPE_INTERFACE,
	SCRATCH_SERVICES_SYMBOL_TYPE_NAMESPACE,
	SCRATCH_SERVICES_SYMBOL_TYPE_OTHER
} ScratchServicesSymbolType;

#define SCRATCH_SERVICES_TYPE_SYMBOL_TYPE (scratch_services_symbol_type_get_type ())

#define SCRATCH_SERVICES_TYPE_SYMBOL_ITEM (scratch_services_symbol_item_get_type ())
#define SCRATCH_SERVICES_SYMBOL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SCRATCH_SERVICES_TYPE_SYMBOL_ITEM, ScratchServicesSymbolItem))
#define SCRATCH_SERVICES_IS_SYMBOL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SCRATCH_SERVICES_TYPE_SYMBOL_ITEM))
#define SCRATCH_SERVICES_SYMBOL_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SCRATCH_SERVICES_TYPE_SYMBOL_ITEM, ScratchServicesSymbolItemIface))

typedef struct _ScratchServicesSymbolItem ScratchServicesSymbolItem;
typedef struct _ScratchServicesSymbolItemIface ScratchServicesSymbolItemIface;

#define CODE_WIDGETS_SOURCE_LIST_TYPE_ITEM (code_widgets_source_list_item_get_type ())
#define CODE_WIDGETS_SOURCE_LIST_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CODE_WIDGETS_SOURCE_LIST_TYPE_ITEM, CodeWidgetsSourceListItem))
#define CODE_WIDGETS_SOURCE_LIST_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CODE_WIDGETS_SOURCE_LIST_TYPE_ITEM, CodeWidgetsSourceListItemClass))
#define CODE_WIDGETS_SOURCE_LIST_IS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CODE_WIDGETS_SOURCE_LIST_TYPE_ITEM))
#define CODE_WIDGETS_SOURCE_LIST_IS_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CODE_WIDGETS_SOURCE_LIST_TYPE_ITEM))
#define CODE_WIDGETS_SOURCE_LIST_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CODE_WIDGETS_SOURCE_LIST_TYPE_ITEM, CodeWidgetsSourceListItemClass))

typedef struct _CodeWidgetsSourceListItem CodeWidgetsSourceListItem;
typedef struct _CodeWidgetsSourceListItemClass CodeWidgetsSourceListItemClass;

#define CODE_WIDGETS_SOURCE_LIST_TYPE_EXPANDABLE_ITEM (code_widgets_source_list_expandable_item_get_type ())
#define CODE_WIDGETS_SOURCE_LIST_EXPANDABLE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CODE_WIDGETS_SOURCE_LIST_TYPE_EXPANDABLE_ITEM, CodeWidgetsSourceListExpandableItem))
#define CODE_WIDGETS_SOURCE_LIST_EXPANDABLE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CODE_WIDGETS_SOURCE_LIST_TYPE_EXPANDABLE_ITEM, CodeWidgetsSourceListExpandableItemClass))
#define CODE_WIDGETS_SOURCE_LIST_IS_EXPANDABLE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CODE_WIDGETS_SOURCE_LIST_TYPE_EXPANDABLE_ITEM))
#define CODE_WIDGETS_SOURCE_LIST_IS_EXPANDABLE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CODE_WIDGETS_SOURCE_LIST_TYPE_EXPANDABLE_ITEM))
#define CODE_WIDGETS_SOURCE_LIST_EXPANDABLE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CODE_WIDGETS_SOURCE_LIST_TYPE_EXPANDABLE_ITEM, CodeWidgetsSourceListExpandableItemClass))

typedef struct _CodeWidgetsSourceListExpandableItem CodeWidgetsSourceListExpandableItem;
typedef struct _CodeWidgetsSourceListExpandableItemClass CodeWidgetsSourceListExpandableItemClass;

#define SCRATCH_SERVICES_TYPE_SYMBOL_OUTLINE (scratch_services_symbol_outline_get_type ())
#define SCRATCH_SERVICES_SYMBOL_OUTLINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SCRATCH_SERVICES_TYPE_SYMBOL_OUTLINE, ScratchServicesSymbolOutline))
#define SCRATCH_SERVICES_SYMBOL_OUTLINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SCRATCH_SERVICES_TYPE_SYMBOL_OUTLINE, ScratchServicesSymbolOutlineClass))
#define SCRATCH_SERVICES_IS_SYMBOL_OUTLINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SCRATCH_SERVICES_TYPE_SYMBOL_OUTLINE))
#define SCRATCH_SERVICES_IS_SYMBOL_OUTLINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SCRATCH_SERVICES_TYPE_SYMBOL_OUTLINE))
#define SCRATCH_SERVICES_SYMBOL_OUTLINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SCRATCH_SERVICES_TYPE_SYMBOL_OUTLINE, ScratchServicesSymbolOutlineClass))

typedef struct _ScratchServicesSymbolOutline ScratchServicesSymbolOutline;
typedef struct _ScratchServicesSymbolOutlineClass ScratchServicesSymbolOutlineClass;
typedef struct _ScratchServicesSymbolOutlinePrivate ScratchServicesSymbolOutlinePrivate;

#define CODE_WIDGETS_TYPE_SOURCE_LIST (code_widgets_source_list_get_type ())
#define CODE_WIDGETS_SOURCE_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CODE_WIDGETS_TYPE_SOURCE_LIST, CodeWidgetsSourceList))
#define CODE_WIDGETS_SOURCE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CODE_WIDGETS_TYPE_SOURCE_LIST, CodeWidgetsSourceListClass))
#define CODE_WIDGETS_IS_SOURCE_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CODE_WIDGETS_TYPE_SOURCE_LIST))
#define CODE_WIDGETS_IS_SOURCE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CODE_WIDGETS_TYPE_SOURCE_LIST))
#define CODE_WIDGETS_SOURCE_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CODE_WIDGETS_TYPE_SOURCE_LIST, CodeWidgetsSourceListClass))

typedef struct _CodeWidgetsSourceList CodeWidgetsSourceList;
typedef struct _CodeWidgetsSourceListClass CodeWidgetsSourceListClass;

#define SCRATCH_SERVICES_TYPE_DOCUMENT (scratch_services_document_get_type ())
#define SCRATCH_SERVICES_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SCRATCH_SERVICES_TYPE_DOCUMENT, ScratchServicesDocument))
#define SCRATCH_SERVICES_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SCRATCH_SERVICES_TYPE_DOCUMENT, ScratchServicesDocumentClass))
#define SCRATCH_SERVICES_IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SCRATCH_SERVICES_TYPE_DOCUMENT))
#define SCRATCH_SERVICES_IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SCRATCH_SERVICES_TYPE_DOCUMENT))
#define SCRATCH_SERVICES_DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SCRATCH_SERVICES_TYPE_DOCUMENT, ScratchServicesDocumentClass))

typedef struct _ScratchServicesDocument ScratchServicesDocument;
typedef struct _ScratchServicesDocumentClass ScratchServicesDocumentClass;
enum  {
	SCRATCH_SERVICES_SYMBOL_OUTLINE_0_PROPERTY,
	SCRATCH_SERVICES_SYMBOL_OUTLINE_DOC_PROPERTY,
	SCRATCH_SERVICES_SYMBOL_OUTLINE_TOOL_BOX_SENSITIVE_PROPERTY,
	SCRATCH_SERVICES_SYMBOL_OUTLINE_NUM_PROPERTIES
};
static GParamSpec* scratch_services_symbol_outline_properties[SCRATCH_SERVICES_SYMBOL_OUTLINE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define SCRATCH_WIDGETS_TYPE_SOURCE_VIEW (scratch_widgets_source_view_get_type ())
#define SCRATCH_WIDGETS_SOURCE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SCRATCH_WIDGETS_TYPE_SOURCE_VIEW, ScratchWidgetsSourceView))
#define SCRATCH_WIDGETS_SOURCE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SCRATCH_WIDGETS_TYPE_SOURCE_VIEW, ScratchWidgetsSourceViewClass))
#define SCRATCH_WIDGETS_IS_SOURCE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SCRATCH_WIDGETS_TYPE_SOURCE_VIEW))
#define SCRATCH_WIDGETS_IS_SOURCE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SCRATCH_WIDGETS_TYPE_SOURCE_VIEW))
#define SCRATCH_WIDGETS_SOURCE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SCRATCH_WIDGETS_TYPE_SOURCE_VIEW, ScratchWidgetsSourceViewClass))

typedef struct _ScratchWidgetsSourceView ScratchWidgetsSourceView;
typedef struct _ScratchWidgetsSourceViewClass ScratchWidgetsSourceViewClass;
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
typedef gboolean (*CodeWidgetsSourceListVisibleFunc) (CodeWidgetsSourceListItem* item, gpointer user_data);

struct _ScratchServicesSymbolItemIface {
	GTypeInterface parent_iface;
	ScratchServicesSymbolType (*get_symbol_type) (ScratchServicesSymbolItem* self);
	void (*set_symbol_type) (ScratchServicesSymbolItem* self, ScratchServicesSymbolType value);
};

struct _ScratchServicesSymbolOutline {
	GtkBox parent_instance;
	ScratchServicesSymbolOutlinePrivate * priv;
	GeeHashMap* checks;
	GtkSearchEntry* search_entry;
	CodeWidgetsSourceList* store;
	CodeWidgetsSourceListExpandableItem* root;
	GtkCssProvider* source_list_style_provider;
	gboolean took_too_long;
};

struct _ScratchServicesSymbolOutlineClass {
	GtkBoxClass parent_class;
	void (*parse_symbols) (ScratchServicesSymbolOutline* self);
	void (*add_tooltips) (ScratchServicesSymbolOutline* self, CodeWidgetsSourceListExpandableItem* root);
};

struct _ScratchServicesSymbolOutlinePrivate {
	GSimpleActionGroup* symbol_action_group;
	ScratchServicesDocument* _doc;
	guint show_spinner_timeout_id;
	GtkMenuButton* filter_button;
	GtkSpinner* spinner;
	GtkStack* stack;
	guint refilter_timeout_id;
	gboolean delay_refilter;
};

static gint ScratchServicesSymbolOutline_private_offset;
static gpointer scratch_services_symbol_outline_parent_class = NULL;
VALA_EXTERN ScratchServicesSymbolType* scratch_services_symbol_outline_filters;
VALA_EXTERN gint scratch_services_symbol_outline_filters_length1;
ScratchServicesSymbolType* scratch_services_symbol_outline_filters = NULL;
gint scratch_services_symbol_outline_filters_length1 = 0;

VALA_EXTERN GType scratch_services_symbol_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN const gchar* scratch_services_symbol_type_to_string (ScratchServicesSymbolType self);
VALA_EXTERN GType code_widgets_source_list_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CodeWidgetsSourceListItem, g_object_unref)
VALA_EXTERN GType code_widgets_source_list_expandable_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CodeWidgetsSourceListExpandableItem, g_object_unref)
VALA_EXTERN GType scratch_services_symbol_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ScratchServicesSymbolItem, g_object_unref)
VALA_EXTERN ScratchServicesSymbolType scratch_services_symbol_item_get_symbol_type (ScratchServicesSymbolItem* self);
VALA_EXTERN void scratch_services_symbol_item_set_symbol_type (ScratchServicesSymbolItem* self,
                                                   ScratchServicesSymbolType value);
static GType scratch_services_symbol_item_get_type_once (void);
VALA_EXTERN GType scratch_services_symbol_outline_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ScratchServicesSymbolOutline, g_object_unref)
VALA_EXTERN GType code_widgets_source_list_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CodeWidgetsSourceList, g_object_unref)
VALA_EXTERN GType scratch_services_document_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ScratchServicesDocument, g_object_unref)
VALA_EXTERN void scratch_services_symbol_outline_parse_symbols (ScratchServicesSymbolOutline* self);
VALA_EXTERN void scratch_services_symbol_outline_add_tooltips (ScratchServicesSymbolOutline* self,
                                                   CodeWidgetsSourceListExpandableItem* root);
VALA_EXTERN GtkWidget* scratch_services_symbol_outline_get_widget (ScratchServicesSymbolOutline* self);
VALA_EXTERN void scratch_services_symbol_outline_before_parse (ScratchServicesSymbolOutline* self);
VALA_EXTERN void scratch_services_symbol_outline_set_tool_box_sensitive (ScratchServicesSymbolOutline* self,
                                                             gboolean value);
static gboolean __lambda32_ (ScratchServicesSymbolOutline* self);
static gboolean ___lambda32__gsource_func (gpointer self);
VALA_EXTERN void scratch_services_symbol_outline_after_parse (ScratchServicesSymbolOutline* self);
static void scratch_services_symbol_outline_real_parse_symbols (ScratchServicesSymbolOutline* self);
static void scratch_services_symbol_outline_real_add_tooltips (ScratchServicesSymbolOutline* self,
                                                        CodeWidgetsSourceListExpandableItem* root);
static void scratch_services_symbol_outline_add_filter_menuitem (ScratchServicesSymbolOutline* self,
                                                          GMenu* menu,
                                                          ScratchServicesSymbolType filter);
static void scratch_services_symbol_outline_action_toggle_filter (ScratchServicesSymbolOutline* self,
                                                           GSimpleAction* action,
                                                           GVariant* param);
static void _scratch_services_symbol_outline_action_toggle_filter_g_simple_action_activate (GSimpleAction* _sender,
                                                                                     GVariant* parameter,
                                                                                     gpointer self);
VALA_EXTERN gboolean scratch_services_symbol_outline_filter_func (ScratchServicesSymbolOutline* self,
                                                      GObject* item);
VALA_EXTERN guint code_widgets_source_list_expandable_item_get_n_children (CodeWidgetsSourceListExpandableItem* self);
VALA_EXTERN const gchar* code_widgets_source_list_item_get_name (CodeWidgetsSourceListItem* self);
VALA_EXTERN void scratch_services_symbol_outline_schedule_refilter (ScratchServicesSymbolOutline* self);
static gboolean __lambda33_ (ScratchServicesSymbolOutline* self);
VALA_EXTERN void code_widgets_source_list_refilter (CodeWidgetsSourceList* self);
VALA_EXTERN CodeWidgetsSourceListExpandableItem* code_widgets_source_list_get_root (CodeWidgetsSourceList* self);
VALA_EXTERN void code_widgets_source_list_expandable_item_expand_all (CodeWidgetsSourceListExpandableItem* self,
                                                          gboolean inclusive,
                                                          gboolean recursive);
static gboolean ___lambda33__gsource_func (gpointer self);
VALA_EXTERN void scratch_services_symbol_outline_set_up_css (ScratchServicesSymbolOutline* self);
VALA_EXTERN void scratch_services_symbol_outline_update_style_scheme (ScratchServicesSymbolOutline* self,
                                                          GtkSourceStyleScheme* style_scheme);
VALA_EXTERN ScratchServicesDocument* scratch_services_symbol_outline_get_doc (ScratchServicesSymbolOutline* self);
VALA_EXTERN GType scratch_widgets_source_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ScratchWidgetsSourceView, g_object_unref)
VALA_EXTERN ScratchWidgetsSourceView* scratch_services_document_get_source_view (ScratchServicesDocument* self);
static void _scratch_services_symbol_outline_update_style_scheme_scratch_widgets_source_view_style_changed (ScratchWidgetsSourceView* _sender,
                                                                                                     GtkSourceStyleScheme* style,
                                                                                                     gpointer self);
static void scratch_services_symbol_outline_action_select_filters (ScratchServicesSymbolOutline* self,
                                                            GSimpleAction* action,
                                                            GVariant* param);
static gboolean __lambda34_ (ScratchServicesSymbolOutline* self);
static gboolean ___lambda34__gsource_func (gpointer self);
VALA_EXTERN ScratchServicesSymbolOutline* scratch_services_symbol_outline_new (void);
VALA_EXTERN ScratchServicesSymbolOutline* scratch_services_symbol_outline_construct (GType object_type);
static void scratch_services_symbol_outline_set_doc (ScratchServicesSymbolOutline* self,
                                              ScratchServicesDocument* value);
static GObject * scratch_services_symbol_outline_constructor (GType type,
                                                       guint n_construct_properties,
                                                       GObjectConstructParam * construct_properties);
VALA_EXTERN CodeWidgetsSourceListExpandableItem* code_widgets_source_list_expandable_item_new (const gchar* name);
VALA_EXTERN CodeWidgetsSourceListExpandableItem* code_widgets_source_list_expandable_item_construct (GType object_type,
                                                                                         const gchar* name);
VALA_EXTERN CodeWidgetsSourceList* code_widgets_source_list_new (CodeWidgetsSourceListExpandableItem* root);
VALA_EXTERN CodeWidgetsSourceList* code_widgets_source_list_construct (GType object_type,
                                                           CodeWidgetsSourceListExpandableItem* root);
VALA_EXTERN void code_widgets_source_list_expandable_item_add (CodeWidgetsSourceListExpandableItem* self,
                                                   CodeWidgetsSourceListItem* item);
static void _scratch_services_symbol_outline_action_select_filters_g_simple_action_activate (GSimpleAction* _sender,
                                                                                      GVariant* parameter,
                                                                                      gpointer self);
static void _scratch_services_symbol_outline___lambda35_ (ScratchServicesSymbolOutline* self);
VALA_EXTERN void code_widgets_source_list_set_filter_func (CodeWidgetsSourceList* self,
                                               CodeWidgetsSourceListVisibleFunc visible_func,
                                               gpointer visible_func_target,
                                               gboolean refilter);
static gboolean _scratch_services_symbol_outline_filter_func_code_widgets_source_list_visible_func (CodeWidgetsSourceListItem* item,
                                                                                             gpointer self);
static void _scratch_services_symbol_outline_schedule_refilter_gtk_editable_changed (GtkEditable* _sender,
                                                                              gpointer self);
static void __scratch_services_symbol_outline___lambda35__gtk_widget_realize (GtkWidget* _sender,
                                                                       gpointer self);
static void scratch_services_symbol_outline_finalize (GObject * obj);
static GType scratch_services_symbol_outline_get_type_once (void);
static void _vala_scratch_services_symbol_outline_get_property (GObject * object,
                                                         guint property_id,
                                                         GValue * value,
                                                         GParamSpec * pspec);
static void _vala_scratch_services_symbol_outline_set_property (GObject * object,
                                                         guint property_id,
                                                         const GValue * value,
                                                         GParamSpec * pspec);

const gchar*
scratch_services_symbol_type_to_string (ScratchServicesSymbolType self)
{
	const gchar* result;
	switch (self) {
		case SCRATCH_SERVICES_SYMBOL_TYPE_CLASS:
		{
			result = _ ("Class");
			return result;
		}
		case SCRATCH_SERVICES_SYMBOL_TYPE_PROPERTY:
		{
			result = _ ("Property");
			return result;
		}
		case SCRATCH_SERVICES_SYMBOL_TYPE_SIGNAL:
		{
			result = _ ("Signal");
			return result;
		}
		case SCRATCH_SERVICES_SYMBOL_TYPE_METHOD:
		{
			result = _ ("Method");
			return result;
		}
		case SCRATCH_SERVICES_SYMBOL_TYPE_STRUCT:
		{
			result = _ ("Struct");
			return result;
		}
		case SCRATCH_SERVICES_SYMBOL_TYPE_ENUM:
		{
			result = _ ("Enum");
			return result;
		}
		case SCRATCH_SERVICES_SYMBOL_TYPE_CONSTANT:
		{
			result = _ ("Constant");
			return result;
		}
		case SCRATCH_SERVICES_SYMBOL_TYPE_CONSTRUCTOR:
		{
			result = _ ("Constructor");
			return result;
		}
		case SCRATCH_SERVICES_SYMBOL_TYPE_INTERFACE:
		{
			result = _ ("Interface");
			return result;
		}
		case SCRATCH_SERVICES_SYMBOL_TYPE_NAMESPACE:
		{
			result = _ ("Namespace");
			return result;
		}
		case SCRATCH_SERVICES_SYMBOL_TYPE_OTHER:
		{
			result = _ ("Other");
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

 G_GNUC_NO_INLINE static GType
scratch_services_symbol_type_get_type_once (void)
{
	static const GEnumValue values[] = {{SCRATCH_SERVICES_SYMBOL_TYPE_CLASS, "SCRATCH_SERVICES_SYMBOL_TYPE_CLASS", "class"}, {SCRATCH_SERVICES_SYMBOL_TYPE_PROPERTY, "SCRATCH_SERVICES_SYMBOL_TYPE_PROPERTY", "property"}, {SCRATCH_SERVICES_SYMBOL_TYPE_SIGNAL, "SCRATCH_SERVICES_SYMBOL_TYPE_SIGNAL", "signal"}, {SCRATCH_SERVICES_SYMBOL_TYPE_METHOD, "SCRATCH_SERVICES_SYMBOL_TYPE_METHOD", "method"}, {SCRATCH_SERVICES_SYMBOL_TYPE_STRUCT, "SCRATCH_SERVICES_SYMBOL_TYPE_STRUCT", "struct"}, {SCRATCH_SERVICES_SYMBOL_TYPE_ENUM, "SCRATCH_SERVICES_SYMBOL_TYPE_ENUM", "enum"}, {SCRATCH_SERVICES_SYMBOL_TYPE_CONSTANT, "SCRATCH_SERVICES_SYMBOL_TYPE_CONSTANT", "constant"}, {SCRATCH_SERVICES_SYMBOL_TYPE_CONSTRUCTOR, "SCRATCH_SERVICES_SYMBOL_TYPE_CONSTRUCTOR", "constructor"}, {SCRATCH_SERVICES_SYMBOL_TYPE_INTERFACE, "SCRATCH_SERVICES_SYMBOL_TYPE_INTERFACE", "interface"}, {SCRATCH_SERVICES_SYMBOL_TYPE_NAMESPACE, "SCRATCH_SERVICES_SYMBOL_TYPE_NAMESPACE", "namespace"}, {SCRATCH_SERVICES_SYMBOL_TYPE_OTHER, "SCRATCH_SERVICES_SYMBOL_TYPE_OTHER", "other"}, {0, NULL, NULL}};
	GType scratch_services_symbol_type_type_id;
	scratch_services_symbol_type_type_id = g_enum_register_static ("ScratchServicesSymbolType", values);
	return scratch_services_symbol_type_type_id;
}

GType
scratch_services_symbol_type_get_type (void)
{
	static gsize scratch_services_symbol_type_type_id__once = 0;
	if (g_once_init_enter (&scratch_services_symbol_type_type_id__once)) {
		GType scratch_services_symbol_type_type_id;
		scratch_services_symbol_type_type_id = scratch_services_symbol_type_get_type_once ();
		g_once_init_leave (&scratch_services_symbol_type_type_id__once, scratch_services_symbol_type_type_id);
	}
	return scratch_services_symbol_type_type_id__once;
}

ScratchServicesSymbolType
scratch_services_symbol_item_get_symbol_type (ScratchServicesSymbolItem* self)
{
	ScratchServicesSymbolItemIface* _iface_;
	g_return_val_if_fail (self != NULL, 0);
	_iface_ = SCRATCH_SERVICES_SYMBOL_ITEM_GET_INTERFACE (self);
	if (_iface_->get_symbol_type) {
		return _iface_->get_symbol_type (self);
	}
	return 0;
}

void
scratch_services_symbol_item_set_symbol_type (ScratchServicesSymbolItem* self,
                                              ScratchServicesSymbolType value)
{
	ScratchServicesSymbolItemIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = SCRATCH_SERVICES_SYMBOL_ITEM_GET_INTERFACE (self);
	if (_iface_->set_symbol_type) {
		_iface_->set_symbol_type (self, value);
	}
}

static void
scratch_services_symbol_item_default_init (ScratchServicesSymbolItemIface * iface,
                                           gpointer iface_data)
{
	g_object_interface_install_property (iface, g_param_spec_enum ("symbol-type", "symbol-type", "symbol-type", SCRATCH_SERVICES_TYPE_SYMBOL_TYPE, SCRATCH_SERVICES_SYMBOL_TYPE_OTHER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

 G_GNUC_NO_INLINE static GType
scratch_services_symbol_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ScratchServicesSymbolItemIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scratch_services_symbol_item_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType scratch_services_symbol_item_type_id;
	scratch_services_symbol_item_type_id = g_type_register_static (G_TYPE_INTERFACE, "ScratchServicesSymbolItem", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (scratch_services_symbol_item_type_id, CODE_WIDGETS_SOURCE_LIST_TYPE_EXPANDABLE_ITEM);
	return scratch_services_symbol_item_type_id;
}

GType
scratch_services_symbol_item_get_type (void)
{
	static gsize scratch_services_symbol_item_type_id__once = 0;
	if (g_once_init_enter (&scratch_services_symbol_item_type_id__once)) {
		GType scratch_services_symbol_item_type_id;
		scratch_services_symbol_item_type_id = scratch_services_symbol_item_get_type_once ();
		g_once_init_leave (&scratch_services_symbol_item_type_id__once, scratch_services_symbol_item_type_id);
	}
	return scratch_services_symbol_item_type_id__once;
}

static inline gpointer
scratch_services_symbol_outline_get_instance_private (ScratchServicesSymbolOutline* self)
{
	return G_STRUCT_MEMBER_P (self, ScratchServicesSymbolOutline_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GtkWidget*
scratch_services_symbol_outline_get_widget (ScratchServicesSymbolOutline* self)
{
	GtkWidget* _tmp0_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _g_object_ref0 ((GtkWidget*) self);
	result = _tmp0_;
	return result;
}

static gboolean
__lambda32_ (ScratchServicesSymbolOutline* self)
{
	GtkStack* _tmp0_;
	GtkSpinner* _tmp1_;
	GtkSpinner* _tmp2_;
	gboolean result;
	self->priv->show_spinner_timeout_id = (guint) 0;
	_tmp0_ = self->priv->stack;
	_tmp1_ = self->priv->spinner;
	gtk_stack_set_visible_child (_tmp0_, (GtkWidget*) _tmp1_);
	_tmp2_ = self->priv->spinner;
	gtk_spinner_start (_tmp2_);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda32__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda32_ ((ScratchServicesSymbolOutline*) self);
	return result;
}

void
scratch_services_symbol_outline_before_parse (ScratchServicesSymbolOutline* self)
{
	g_return_if_fail (self != NULL);
	scratch_services_symbol_outline_set_tool_box_sensitive (self, TRUE);
	self->took_too_long = FALSE;
	self->priv->show_spinner_timeout_id = g_timeout_add_full (G_PRIORITY_DEFAULT, SCRATCH_SERVICES_SYMBOL_OUTLINE_SPINNER_DELAY_MSEC, ___lambda32__gsource_func, g_object_ref (self), g_object_unref);
}

void
scratch_services_symbol_outline_after_parse (ScratchServicesSymbolOutline* self)
{
	GtkSpinner* _tmp0_;
	GtkStack* _tmp1_;
	GtkMenuButton* _tmp2_;
	g_return_if_fail (self != NULL);
	if (self->priv->show_spinner_timeout_id > ((guint) 0)) {
		g_source_remove (self->priv->show_spinner_timeout_id);
		self->priv->show_spinner_timeout_id = (guint) 0;
	}
	_tmp0_ = self->priv->spinner;
	gtk_spinner_stop (_tmp0_);
	_tmp1_ = self->priv->stack;
	_tmp2_ = self->priv->filter_button;
	gtk_stack_set_visible_child (_tmp1_, (GtkWidget*) _tmp2_);
	scratch_services_symbol_outline_set_tool_box_sensitive (self, !self->took_too_long);
}

static void
scratch_services_symbol_outline_real_parse_symbols (ScratchServicesSymbolOutline* self)
{
}

void
scratch_services_symbol_outline_parse_symbols (ScratchServicesSymbolOutline* self)
{
	ScratchServicesSymbolOutlineClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = SCRATCH_SERVICES_SYMBOL_OUTLINE_GET_CLASS (self);
	if (_klass_->parse_symbols) {
		_klass_->parse_symbols (self);
	}
}

static void
scratch_services_symbol_outline_real_add_tooltips (ScratchServicesSymbolOutline* self,
                                                   CodeWidgetsSourceListExpandableItem* root)
{
	g_return_if_fail (root != NULL);
}

void
scratch_services_symbol_outline_add_tooltips (ScratchServicesSymbolOutline* self,
                                              CodeWidgetsSourceListExpandableItem* root)
{
	ScratchServicesSymbolOutlineClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = SCRATCH_SERVICES_SYMBOL_OUTLINE_GET_CLASS (self);
	if (_klass_->add_tooltips) {
		_klass_->add_tooltips (self, root);
	}
}

static void
_scratch_services_symbol_outline_action_toggle_filter_g_simple_action_activate (GSimpleAction* _sender,
                                                                                GVariant* parameter,
                                                                                gpointer self)
{
	scratch_services_symbol_outline_action_toggle_filter ((ScratchServicesSymbolOutline*) self, _sender, parameter);
}

static void
scratch_services_symbol_outline_add_filter_menuitem (ScratchServicesSymbolOutline* self,
                                                     GMenu* menu,
                                                     ScratchServicesSymbolType filter)
{
	GSimpleAction* filter_action = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GVariant* _tmp4_;
	GVariant* _tmp5_;
	GSimpleAction* _tmp6_;
	GSimpleAction* _tmp7_;
	GeeHashMap* _tmp8_;
	GSimpleActionGroup* _tmp9_;
	GMenuItem* filter_item = NULL;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	GMenuItem* _tmp14_;
	GMenuItem* _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (menu != NULL);
	_tmp0_ = g_strdup_printf ("%u", (guint) filter);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (SCRATCH_SERVICES_SYMBOL_OUTLINE_ACTION_TOGGLE, _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_variant_new_boolean (TRUE);
	g_variant_ref_sink (_tmp4_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_simple_action_new_stateful (_tmp3_, NULL, _tmp5_);
	_tmp7_ = _tmp6_;
	_g_variant_unref0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	filter_action = _tmp7_;
	_tmp8_ = self->checks;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp8_, (gpointer) ((gintptr) filter), filter_action);
	g_signal_connect_object (filter_action, "activate", (GCallback) _scratch_services_symbol_outline_action_toggle_filter_g_simple_action_activate, self, 0);
	_tmp9_ = self->priv->symbol_action_group;
	g_action_map_add_action ((GActionMap*) _tmp9_, (GAction*) filter_action);
	_tmp10_ = scratch_services_symbol_type_to_string (filter);
	_tmp11_ = g_action_get_name ((GAction*) filter_action);
	_tmp12_ = g_strconcat (SCRATCH_SERVICES_SYMBOL_OUTLINE_ACTION_PREFIX, _tmp11_, NULL);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_menu_item_new (_tmp10_, _tmp13_);
	_tmp15_ = _tmp14_;
	_g_free0 (_tmp13_);
	filter_item = _tmp15_;
	g_menu_append_item (menu, filter_item);
	_g_object_unref0 (filter_item);
	_g_object_unref0 (filter_action);
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

gboolean
scratch_services_symbol_outline_filter_func (ScratchServicesSymbolOutline* self,
                                             GObject* item)
{
	ScratchServicesSymbolType symbol_type = 0;
	ScratchServicesSymbolType _tmp0_;
	ScratchServicesSymbolType _tmp1_;
	GeeHashMap* _tmp2_;
	gpointer _tmp3_;
	GSimpleAction* _tmp4_;
	gboolean _tmp5_;
	GSimpleAction* filter_action = NULL;
	GeeHashMap* _tmp6_;
	gpointer _tmp7_;
	GSimpleAction* _tmp8_;
	GVariant* _tmp9_;
	GVariant* _tmp10_;
	gboolean _tmp11_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (item != NULL, FALSE);
	if (!SCRATCH_SERVICES_IS_SYMBOL_ITEM (item)) {
		result = TRUE;
		return result;
	}
	_tmp0_ = scratch_services_symbol_item_get_symbol_type (G_TYPE_CHECK_INSTANCE_CAST (item, SCRATCH_SERVICES_TYPE_SYMBOL_ITEM, ScratchServicesSymbolItem));
	_tmp1_ = _tmp0_;
	symbol_type = _tmp1_;
	if (symbol_type == SCRATCH_SERVICES_SYMBOL_TYPE_NAMESPACE) {
		result = TRUE;
		return result;
	}
	_tmp2_ = self->checks;
	_tmp3_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp2_, (gpointer) ((gintptr) symbol_type));
	_tmp4_ = (GSimpleAction*) _tmp3_;
	_tmp5_ = _tmp4_ == NULL;
	_g_object_unref0 (_tmp4_);
	if (_tmp5_) {
		symbol_type = SCRATCH_SERVICES_SYMBOL_TYPE_OTHER;
	}
	_tmp6_ = self->checks;
	_tmp7_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp6_, (gpointer) ((gintptr) symbol_type));
	filter_action = (GSimpleAction*) _tmp7_;
	_tmp8_ = filter_action;
	_tmp9_ = g_action_get_state ((GAction*) _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = !g_variant_get_boolean (_tmp10_);
	_g_variant_unref0 (_tmp10_);
	if (_tmp11_) {
		result = FALSE;
		_g_object_unref0 (filter_action);
		return result;
	}
	if (CODE_WIDGETS_SOURCE_LIST_IS_EXPANDABLE_ITEM (item)) {
		CodeWidgetsSourceListExpandableItem* expandable = NULL;
		CodeWidgetsSourceListExpandableItem* _tmp12_;
		CodeWidgetsSourceListExpandableItem* _tmp13_;
		guint _tmp14_;
		guint _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		GtkSearchEntry* _tmp18_;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		_tmp12_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (item, CODE_WIDGETS_SOURCE_LIST_TYPE_EXPANDABLE_ITEM, CodeWidgetsSourceListExpandableItem));
		expandable = _tmp12_;
		_tmp13_ = expandable;
		_tmp14_ = code_widgets_source_list_expandable_item_get_n_children (_tmp13_);
		_tmp15_ = _tmp14_;
		if (_tmp15_ > ((guint) 0)) {
			result = TRUE;
			_g_object_unref0 (expandable);
			_g_object_unref0 (filter_action);
			return result;
		}
		_tmp16_ = code_widgets_source_list_item_get_name ((CodeWidgetsSourceListItem*) G_TYPE_CHECK_INSTANCE_CAST (item, SCRATCH_SERVICES_TYPE_SYMBOL_ITEM, ScratchServicesSymbolItem));
		_tmp17_ = _tmp16_;
		_tmp18_ = self->search_entry;
		_tmp19_ = gtk_entry_get_text ((GtkEntry*) _tmp18_);
		_tmp20_ = _tmp19_;
		result = string_contains (_tmp17_, _tmp20_);
		_g_object_unref0 (expandable);
		_g_object_unref0 (filter_action);
		return result;
	}
	result = TRUE;
	_g_object_unref0 (filter_action);
	return result;
}

static gboolean
__lambda33_ (ScratchServicesSymbolOutline* self)
{
	gboolean result;
	if (self->priv->delay_refilter) {
		self->priv->delay_refilter = FALSE;
		result = G_SOURCE_CONTINUE;
		return result;
	} else {
		CodeWidgetsSourceList* _tmp0_;
		CodeWidgetsSourceList* _tmp1_;
		CodeWidgetsSourceListExpandableItem* _tmp2_;
		CodeWidgetsSourceListExpandableItem* _tmp3_;
		self->priv->refilter_timeout_id = (guint) 0;
		_tmp0_ = self->store;
		code_widgets_source_list_refilter (_tmp0_);
		_tmp1_ = self->store;
		_tmp2_ = code_widgets_source_list_get_root (_tmp1_);
		_tmp3_ = _tmp2_;
		code_widgets_source_list_expandable_item_expand_all (_tmp3_, TRUE, TRUE);
		result = G_SOURCE_REMOVE;
		return result;
	}
}

static gboolean
___lambda33__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda33_ ((ScratchServicesSymbolOutline*) self);
	return result;
}

void
scratch_services_symbol_outline_schedule_refilter (ScratchServicesSymbolOutline* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->refilter_timeout_id > ((guint) 0)) {
		self->priv->delay_refilter = TRUE;
		return;
	}
	self->priv->refilter_timeout_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 500, ___lambda33__gsource_func, g_object_ref (self), g_object_unref);
}

static void
_scratch_services_symbol_outline_update_style_scheme_scratch_widgets_source_view_style_changed (ScratchWidgetsSourceView* _sender,
                                                                                                GtkSourceStyleScheme* style,
                                                                                                gpointer self)
{
	scratch_services_symbol_outline_update_style_scheme ((ScratchServicesSymbolOutline*) self, style);
}

void
scratch_services_symbol_outline_set_up_css (ScratchServicesSymbolOutline* self)
{
	GtkCssProvider* _tmp0_;
	GdkScreen* _tmp1_;
	GtkCssProvider* _tmp2_;
	GtkStyleContext* _tmp3_;
	ScratchServicesDocument* _tmp4_;
	ScratchWidgetsSourceView* _tmp5_;
	ScratchWidgetsSourceView* _tmp6_;
	GtkTextBuffer* _tmp7_;
	GtkTextBuffer* _tmp8_;
	GtkSourceStyleScheme* _tmp9_;
	GtkSourceStyleScheme* _tmp10_;
	ScratchServicesDocument* _tmp11_;
	ScratchWidgetsSourceView* _tmp12_;
	ScratchWidgetsSourceView* _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_css_provider_new ();
	_g_object_unref0 (self->source_list_style_provider);
	self->source_list_style_provider = _tmp0_;
	_tmp1_ = gdk_screen_get_default ();
	_tmp2_ = self->source_list_style_provider;
	gtk_style_context_add_provider_for_screen (_tmp1_, (GtkStyleProvider*) _tmp2_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp3_, "symbol-outline");
	_tmp4_ = self->priv->_doc;
	_tmp5_ = scratch_services_document_get_source_view (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = gtk_source_buffer_get_style_scheme (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_source_buffer_get_type (), GtkSourceBuffer));
	_tmp10_ = _tmp9_;
	scratch_services_symbol_outline_update_style_scheme (self, _tmp10_);
	_tmp11_ = self->priv->_doc;
	_tmp12_ = scratch_services_document_get_source_view (_tmp11_);
	_tmp13_ = _tmp12_;
	g_signal_connect_object (_tmp13_, "style-changed", (GCallback) _scratch_services_symbol_outline_update_style_scheme_scratch_widgets_source_view_style_changed, self, 0);
}

void
scratch_services_symbol_outline_update_style_scheme (ScratchServicesSymbolOutline* self,
                                                     GtkSourceStyleScheme* style_scheme)
{
	GtkSourceStyle* text_color_data = NULL;
	GtkSourceStyle* _tmp0_;
	GtkSourceStyle* _tmp1_;
	gchar* color = NULL;
	gchar* _tmp2_;
	GtkSourceStyle* _tmp3_;
	gchar* define = NULL;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (style_scheme != NULL);
	_tmp0_ = gtk_source_style_scheme_get_style (style_scheme, "text");
	_tmp1_ = _g_object_ref0 (_tmp0_);
	text_color_data = _tmp1_;
	_tmp2_ = g_strdup ("#FFFFFF");
	color = _tmp2_;
	_tmp3_ = text_color_data;
	if (_tmp3_ != NULL) {
		GtkSourceStyle* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp4_ = text_color_data;
		g_object_get (_tmp4_, "background", &_tmp5_, NULL);
		_tmp6_ = _tmp5_;
		_g_free0 (color);
		color = _tmp6_;
	}
	_tmp7_ = color;
	_tmp8_ = g_strdup_printf (".symbol-outline {background-color: %s;}", _tmp7_);
	define = _tmp8_;
	{
		GtkCssProvider* _tmp9_;
		_tmp9_ = self->source_list_style_provider;
		gtk_css_provider_load_from_data (_tmp9_, define, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		g_critical ("SymbolOutline.vala:299: Unable to sourcelist styling, going back to cl" \
"assic styling");
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (define);
		_g_free0 (color);
		_g_object_unref0 (text_color_data);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (define);
	_g_free0 (color);
	_g_object_unref0 (text_color_data);
}

static gboolean
__lambda34_ (ScratchServicesSymbolOutline* self)
{
	GtkMenuButton* _tmp0_;
	gboolean result;
	_tmp0_ = self->priv->filter_button;
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp0_, TRUE);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda34__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda34_ ((ScratchServicesSymbolOutline*) self);
	return result;
}

static void
scratch_services_symbol_outline_action_select_filters (ScratchServicesSymbolOutline* self,
                                                       GSimpleAction* action,
                                                       GVariant* param)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	{
		GeeIterator* _filter_action_it = NULL;
		GeeHashMap* _tmp0_;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _tmp5_;
		_tmp0_ = self->checks;
		_tmp1_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_filter_action_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			GSimpleAction* filter_action = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			GSimpleAction* _tmp9_;
			GVariant* _tmp10_;
			GVariant* _tmp11_;
			_tmp6_ = _filter_action_it;
			if (!gee_iterator_next (_tmp6_)) {
				break;
			}
			_tmp7_ = _filter_action_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			filter_action = (GSimpleAction*) _tmp8_;
			_tmp9_ = filter_action;
			_tmp10_ = g_variant_new ("b", g_variant_get_boolean (param), NULL);
			g_variant_ref_sink (_tmp10_);
			_tmp11_ = _tmp10_;
			g_simple_action_set_state (_tmp9_, _tmp11_);
			_g_variant_unref0 (_tmp11_);
			_g_object_unref0 (filter_action);
		}
		_g_object_unref0 (_filter_action_it);
	}
	scratch_services_symbol_outline_schedule_refilter (self);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda34__gsource_func, g_object_ref (self), g_object_unref);
}

static void
scratch_services_symbol_outline_action_toggle_filter (ScratchServicesSymbolOutline* self,
                                                      GSimpleAction* action,
                                                      GVariant* param)
{
	gboolean state = FALSE;
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	gboolean _tmp2_;
	GVariant* _tmp3_;
	GVariant* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = g_action_get_state ((GAction*) action);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_get_boolean (_tmp1_);
	_g_variant_unref0 (_tmp1_);
	state = _tmp2_;
	_tmp3_ = g_variant_new ("b", !state, NULL);
	g_variant_ref_sink (_tmp3_);
	_tmp4_ = _tmp3_;
	g_simple_action_set_state (action, _tmp4_);
	_g_variant_unref0 (_tmp4_);
	scratch_services_symbol_outline_schedule_refilter (self);
}

ScratchServicesSymbolOutline*
scratch_services_symbol_outline_construct (GType object_type)
{
	ScratchServicesSymbolOutline * self = NULL;
	self = (ScratchServicesSymbolOutline*) g_object_new (object_type, NULL);
	return self;
}

ScratchServicesSymbolOutline*
scratch_services_symbol_outline_new (void)
{
	return scratch_services_symbol_outline_construct (SCRATCH_SERVICES_TYPE_SYMBOL_OUTLINE);
}

ScratchServicesDocument*
scratch_services_symbol_outline_get_doc (ScratchServicesSymbolOutline* self)
{
	ScratchServicesDocument* result;
	ScratchServicesDocument* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_doc;
	result = _tmp0_;
	return result;
}

static void
scratch_services_symbol_outline_set_doc (ScratchServicesSymbolOutline* self,
                                         ScratchServicesDocument* value)
{
	ScratchServicesDocument* old_value;
	g_return_if_fail (self != NULL);
	old_value = scratch_services_symbol_outline_get_doc (self);
	if (old_value != value) {
		ScratchServicesDocument* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_doc);
		self->priv->_doc = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, scratch_services_symbol_outline_properties[SCRATCH_SERVICES_SYMBOL_OUTLINE_DOC_PROPERTY]);
	}
}

void
scratch_services_symbol_outline_set_tool_box_sensitive (ScratchServicesSymbolOutline* self,
                                                        gboolean value)
{
	GtkSearchEntry* _tmp0_;
	GtkMenuButton* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->search_entry;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, value);
	_tmp1_ = self->priv->filter_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp1_, value);
	g_object_notify_by_pspec ((GObject *) self, scratch_services_symbol_outline_properties[SCRATCH_SERVICES_SYMBOL_OUTLINE_TOOL_BOX_SENSITIVE_PROPERTY]);
}

static void
_scratch_services_symbol_outline_action_select_filters_g_simple_action_activate (GSimpleAction* _sender,
                                                                                 GVariant* parameter,
                                                                                 gpointer self)
{
	scratch_services_symbol_outline_action_select_filters ((ScratchServicesSymbolOutline*) self, _sender, parameter);
}

static gboolean
_scratch_services_symbol_outline_filter_func_code_widgets_source_list_visible_func (CodeWidgetsSourceListItem* item,
                                                                                    gpointer self)
{
	gboolean result;
	result = scratch_services_symbol_outline_filter_func ((ScratchServicesSymbolOutline*) self, item);
	return result;
}

static void
_scratch_services_symbol_outline_schedule_refilter_gtk_editable_changed (GtkEditable* _sender,
                                                                         gpointer self)
{
	scratch_services_symbol_outline_schedule_refilter ((ScratchServicesSymbolOutline*) self);
}

static void
_scratch_services_symbol_outline___lambda35_ (ScratchServicesSymbolOutline* self)
{
	CodeWidgetsSourceList* _tmp0_;
	GtkSearchEntry* _tmp1_;
	_tmp0_ = self->store;
	code_widgets_source_list_set_filter_func (_tmp0_, _scratch_services_symbol_outline_filter_func_code_widgets_source_list_visible_func, self, FALSE);
	_tmp1_ = self->search_entry;
	g_signal_connect_object ((GtkEditable*) _tmp1_, "changed", (GCallback) _scratch_services_symbol_outline_schedule_refilter_gtk_editable_changed, self, 0);
}

static void
__scratch_services_symbol_outline___lambda35__gtk_widget_realize (GtkWidget* _sender,
                                                                  gpointer self)
{
	_scratch_services_symbol_outline___lambda35_ ((ScratchServicesSymbolOutline*) self);
}

static GObject *
scratch_services_symbol_outline_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ScratchServicesSymbolOutline * self;
	GSimpleActionGroup* _tmp0_;
	GSimpleActionGroup* _tmp1_;
	GeeHashMap* _tmp2_;
	CodeWidgetsSourceListExpandableItem* _tmp3_;
	CodeWidgetsSourceListExpandableItem* _tmp4_;
	CodeWidgetsSourceList* _tmp5_;
	CodeWidgetsSourceListExpandableItem* _tmp6_;
	CodeWidgetsSourceList* _tmp7_;
	CodeWidgetsSourceListExpandableItem* _tmp8_;
	CodeWidgetsSourceListExpandableItem* _tmp9_;
	CodeWidgetsSourceListExpandableItem* _tmp10_;
	gchar* _tmp11_;
	GtkSearchEntry* _tmp12_ = NULL;
	GtkImage* _tmp13_;
	gchar* _tmp14_;
	GtkMenuButton* _tmp15_ = NULL;
	GMenu* select_section = NULL;
	GMenu* _tmp16_;
	GMenu* top_model = NULL;
	GMenu* _tmp17_;
	ScratchServicesSymbolType* _tmp18_;
	gint _tmp18__length1;
	GMenu* _tmp20_;
	GSimpleAction* select_action = NULL;
	GVariantType* _tmp21_;
	GVariantType* _tmp22_;
	GSimpleAction* _tmp23_;
	GSimpleAction* _tmp24_;
	GSimpleAction* _tmp25_;
	GSimpleActionGroup* _tmp26_;
	GSimpleAction* _tmp27_;
	GMenu* _tmp28_;
	GVariant* _tmp29_;
	GVariant* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	GMenu* _tmp33_;
	GVariant* _tmp34_;
	GVariant* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	GMenu* _tmp38_;
	GMenu* _tmp39_;
	GtkMenuButton* _tmp40_;
	GMenu* _tmp41_;
	GtkSpinner* _tmp42_;
	GtkStack* _tmp43_;
	GtkStack* _tmp44_;
	GtkMenuButton* _tmp45_;
	GtkStack* _tmp46_;
	GtkSpinner* _tmp47_;
	GtkStack* _tmp48_;
	GtkMenuButton* _tmp49_;
	GtkBox* tool_box = NULL;
	GtkBox* _tmp50_;
	GtkBox* _tmp51_;
	GtkSearchEntry* _tmp52_;
	GtkBox* _tmp53_;
	GtkStack* _tmp54_;
	GtkBox* _tmp55_;
	CodeWidgetsSourceList* _tmp56_;
	parent_class = G_OBJECT_CLASS (scratch_services_symbol_outline_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SCRATCH_SERVICES_TYPE_SYMBOL_OUTLINE, ScratchServicesSymbolOutline);
	_tmp0_ = g_simple_action_group_new ();
	_g_object_unref0 (self->priv->symbol_action_group);
	self->priv->symbol_action_group = _tmp0_;
	_tmp1_ = self->priv->symbol_action_group;
	gtk_widget_insert_action_group ((GtkWidget*) self, SCRATCH_SERVICES_SYMBOL_OUTLINE_ACTION_GROUP, (GActionGroup*) _tmp1_);
	_tmp2_ = gee_hash_map_new (SCRATCH_SERVICES_TYPE_SYMBOL_TYPE, NULL, NULL, g_simple_action_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->checks);
	self->checks = _tmp2_;
	_tmp3_ = code_widgets_source_list_expandable_item_new ("");
	_tmp4_ = _tmp3_;
	_tmp5_ = code_widgets_source_list_new (_tmp4_);
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->store);
	self->store = _tmp5_;
	_g_object_unref0 (_tmp4_);
	_tmp6_ = code_widgets_source_list_expandable_item_new (_ ("Symbols"));
	_g_object_unref0 (self->root);
	self->root = _tmp6_;
	_tmp7_ = self->store;
	_tmp8_ = code_widgets_source_list_get_root (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = self->root;
	code_widgets_source_list_expandable_item_add (_tmp9_, (CodeWidgetsSourceListItem*) _tmp10_);
	_tmp11_ = g_strdup (_ ("Find Symbol"));
	_tmp12_ = (GtkSearchEntry*) gtk_search_entry_new ();
	gtk_entry_set_placeholder_text ((GtkEntry*) _tmp12_, _tmp11_);
	_g_free0 (_tmp11_);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp12_, TRUE);
	g_object_ref_sink (_tmp12_);
	_g_object_unref0 (self->search_entry);
	self->search_entry = _tmp12_;
	_tmp13_ = (GtkImage*) gtk_image_new_from_icon_name ("filter-symbolic", (GtkIconSize) GTK_ICON_SIZE_SMALL_TOOLBAR);
	g_object_ref_sink (_tmp13_);
	_tmp14_ = g_strdup (_ ("Filter symbol type"));
	_tmp15_ = (GtkMenuButton*) gtk_menu_button_new ();
	gtk_button_set_image ((GtkButton*) _tmp15_, (GtkWidget*) _tmp13_);
	_g_object_unref0 (_tmp13_);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp15_, _tmp14_);
	_g_free0 (_tmp14_);
	g_object_ref_sink (_tmp15_);
	_g_object_unref0 (self->priv->filter_button);
	self->priv->filter_button = _tmp15_;
	_tmp16_ = g_menu_new ();
	select_section = _tmp16_;
	_tmp17_ = g_menu_new ();
	top_model = _tmp17_;
	_tmp18_ = scratch_services_symbol_outline_filters;
	_tmp18__length1 = scratch_services_symbol_outline_filters_length1;
	{
		ScratchServicesSymbolType* filter_collection = NULL;
		gint filter_collection_length1 = 0;
		gint _filter_collection_size_ = 0;
		gint filter_it = 0;
		filter_collection = _tmp18_;
		filter_collection_length1 = _tmp18__length1;
		for (filter_it = 0; filter_it < filter_collection_length1; filter_it = filter_it + 1) {
			ScratchServicesSymbolType filter = 0;
			filter = filter_collection[filter_it];
			{
				GMenu* _tmp19_;
				_tmp19_ = top_model;
				scratch_services_symbol_outline_add_filter_menuitem (self, _tmp19_, filter);
			}
		}
	}
	_tmp20_ = top_model;
	scratch_services_symbol_outline_add_filter_menuitem (self, _tmp20_, SCRATCH_SERVICES_SYMBOL_TYPE_OTHER);
	_tmp21_ = g_variant_type_new ("b");
	_tmp22_ = _tmp21_;
	_tmp23_ = g_simple_action_new (SCRATCH_SERVICES_SYMBOL_OUTLINE_ACTION_SELECT, _tmp22_);
	_tmp24_ = _tmp23_;
	_g_variant_type_free0 (_tmp22_);
	select_action = _tmp24_;
	_tmp25_ = select_action;
	g_signal_connect_object (_tmp25_, "activate", (GCallback) _scratch_services_symbol_outline_action_select_filters_g_simple_action_activate, self, 0);
	_tmp26_ = self->priv->symbol_action_group;
	_tmp27_ = select_action;
	g_action_map_add_action ((GActionMap*) _tmp26_, (GAction*) _tmp27_);
	_tmp28_ = select_section;
	_tmp29_ = g_variant_new ("b", TRUE, NULL);
	g_variant_ref_sink (_tmp29_);
	_tmp30_ = _tmp29_;
	_tmp31_ = g_action_print_detailed_name (SCRATCH_SERVICES_SYMBOL_OUTLINE_ACTION_PREFIX SCRATCH_SERVICES_SYMBOL_OUTLINE_ACTION_SELECT, _tmp30_);
	_tmp32_ = _tmp31_;
	g_menu_append (_tmp28_, _ ("Select All"), _tmp32_);
	_g_free0 (_tmp32_);
	_g_variant_unref0 (_tmp30_);
	_tmp33_ = select_section;
	_tmp34_ = g_variant_new ("b", FALSE, NULL);
	g_variant_ref_sink (_tmp34_);
	_tmp35_ = _tmp34_;
	_tmp36_ = g_action_print_detailed_name (SCRATCH_SERVICES_SYMBOL_OUTLINE_ACTION_PREFIX SCRATCH_SERVICES_SYMBOL_OUTLINE_ACTION_SELECT, _tmp35_);
	_tmp37_ = _tmp36_;
	g_menu_append (_tmp33_, _ ("Deselect All"), _tmp37_);
	_g_free0 (_tmp37_);
	_g_variant_unref0 (_tmp35_);
	_tmp38_ = top_model;
	_tmp39_ = select_section;
	g_menu_append_section (_tmp38_, "", (GMenuModel*) _tmp39_);
	_tmp40_ = self->priv->filter_button;
	_tmp41_ = top_model;
	gtk_menu_button_set_menu_model (_tmp40_, (GMenuModel*) _tmp41_);
	_tmp42_ = (GtkSpinner*) gtk_spinner_new ();
	g_object_ref_sink (_tmp42_);
	_g_object_unref0 (self->priv->spinner);
	self->priv->spinner = _tmp42_;
	_tmp43_ = (GtkStack*) gtk_stack_new ();
	g_object_ref_sink (_tmp43_);
	_g_object_unref0 (self->priv->stack);
	self->priv->stack = _tmp43_;
	_tmp44_ = self->priv->stack;
	_tmp45_ = self->priv->filter_button;
	gtk_container_add ((GtkContainer*) _tmp44_, (GtkWidget*) _tmp45_);
	_tmp46_ = self->priv->stack;
	_tmp47_ = self->priv->spinner;
	gtk_container_add ((GtkContainer*) _tmp46_, (GtkWidget*) _tmp47_);
	_tmp48_ = self->priv->stack;
	_tmp49_ = self->priv->filter_button;
	gtk_stack_set_visible_child (_tmp48_, (GtkWidget*) _tmp49_);
	_tmp50_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 3);
	g_object_ref_sink (_tmp50_);
	tool_box = _tmp50_;
	_tmp51_ = tool_box;
	_tmp52_ = self->search_entry;
	gtk_container_add ((GtkContainer*) _tmp51_, (GtkWidget*) _tmp52_);
	_tmp53_ = tool_box;
	_tmp54_ = self->priv->stack;
	gtk_container_add ((GtkContainer*) _tmp53_, (GtkWidget*) _tmp54_);
	_tmp55_ = tool_box;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp55_);
	_tmp56_ = self->store;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp56_);
	scratch_services_symbol_outline_set_up_css (self);
	gtk_widget_show_all ((GtkWidget*) self);
	g_signal_connect_object ((GtkWidget*) self, "realize", (GCallback) __scratch_services_symbol_outline___lambda35__gtk_widget_realize, self, 0);
	_g_object_unref0 (tool_box);
	_g_object_unref0 (select_action);
	_g_object_unref0 (top_model);
	_g_object_unref0 (select_section);
	return obj;
}

static void
scratch_services_symbol_outline_class_init (ScratchServicesSymbolOutlineClass * klass,
                                            gpointer klass_data)
{
	scratch_services_symbol_outline_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ScratchServicesSymbolOutline_private_offset);
	((ScratchServicesSymbolOutlineClass *) klass)->parse_symbols = (void (*) (ScratchServicesSymbolOutline*)) scratch_services_symbol_outline_real_parse_symbols;
	((ScratchServicesSymbolOutlineClass *) klass)->add_tooltips = (void (*) (ScratchServicesSymbolOutline*, CodeWidgetsSourceListExpandableItem*)) scratch_services_symbol_outline_real_add_tooltips;
	G_OBJECT_CLASS (klass)->get_property = _vala_scratch_services_symbol_outline_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_scratch_services_symbol_outline_set_property;
	G_OBJECT_CLASS (klass)->constructor = scratch_services_symbol_outline_constructor;
	G_OBJECT_CLASS (klass)->finalize = scratch_services_symbol_outline_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_SERVICES_SYMBOL_OUTLINE_DOC_PROPERTY, scratch_services_symbol_outline_properties[SCRATCH_SERVICES_SYMBOL_OUTLINE_DOC_PROPERTY] = g_param_spec_object ("doc", "doc", "doc", SCRATCH_SERVICES_TYPE_DOCUMENT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_SERVICES_SYMBOL_OUTLINE_TOOL_BOX_SENSITIVE_PROPERTY, scratch_services_symbol_outline_properties[SCRATCH_SERVICES_SYMBOL_OUTLINE_TOOL_BOX_SENSITIVE_PROPERTY] = g_param_spec_boolean ("tool-box-sensitive", "tool-box-sensitive", "tool-box-sensitive", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE));
}

static void
scratch_services_symbol_outline_instance_init (ScratchServicesSymbolOutline * self,
                                               gpointer klass)
{
	self->priv = scratch_services_symbol_outline_get_instance_private (self);
	self->priv->show_spinner_timeout_id = (guint) 0;
	self->priv->refilter_timeout_id = (guint) 0;
	self->priv->delay_refilter = FALSE;
}

static void
scratch_services_symbol_outline_finalize (GObject * obj)
{
	ScratchServicesSymbolOutline * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SCRATCH_SERVICES_TYPE_SYMBOL_OUTLINE, ScratchServicesSymbolOutline);
	_g_object_unref0 (self->priv->symbol_action_group);
	_g_object_unref0 (self->priv->_doc);
	_g_object_unref0 (self->checks);
	_g_object_unref0 (self->search_entry);
	_g_object_unref0 (self->store);
	_g_object_unref0 (self->root);
	_g_object_unref0 (self->source_list_style_provider);
	_g_object_unref0 (self->priv->filter_button);
	_g_object_unref0 (self->priv->spinner);
	_g_object_unref0 (self->priv->stack);
	G_OBJECT_CLASS (scratch_services_symbol_outline_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
scratch_services_symbol_outline_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ScratchServicesSymbolOutlineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scratch_services_symbol_outline_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScratchServicesSymbolOutline), 0, (GInstanceInitFunc) scratch_services_symbol_outline_instance_init, NULL };
	GType scratch_services_symbol_outline_type_id;
	scratch_services_symbol_outline_type_id = g_type_register_static (gtk_box_get_type (), "ScratchServicesSymbolOutline", &g_define_type_info, 0);
	ScratchServicesSymbolOutline_private_offset = g_type_add_instance_private (scratch_services_symbol_outline_type_id, sizeof (ScratchServicesSymbolOutlinePrivate));
	return scratch_services_symbol_outline_type_id;
}

GType
scratch_services_symbol_outline_get_type (void)
{
	static gsize scratch_services_symbol_outline_type_id__once = 0;
	if (g_once_init_enter (&scratch_services_symbol_outline_type_id__once)) {
		GType scratch_services_symbol_outline_type_id;
		scratch_services_symbol_outline_type_id = scratch_services_symbol_outline_get_type_once ();
		g_once_init_leave (&scratch_services_symbol_outline_type_id__once, scratch_services_symbol_outline_type_id);
	}
	return scratch_services_symbol_outline_type_id__once;
}

static void
_vala_scratch_services_symbol_outline_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec)
{
	ScratchServicesSymbolOutline * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SCRATCH_SERVICES_TYPE_SYMBOL_OUTLINE, ScratchServicesSymbolOutline);
	switch (property_id) {
		case SCRATCH_SERVICES_SYMBOL_OUTLINE_DOC_PROPERTY:
		g_value_set_object (value, scratch_services_symbol_outline_get_doc (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_scratch_services_symbol_outline_set_property (GObject * object,
                                                    guint property_id,
                                                    const GValue * value,
                                                    GParamSpec * pspec)
{
	ScratchServicesSymbolOutline * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SCRATCH_SERVICES_TYPE_SYMBOL_OUTLINE, ScratchServicesSymbolOutline);
	switch (property_id) {
		case SCRATCH_SERVICES_SYMBOL_OUTLINE_DOC_PROPERTY:
		scratch_services_symbol_outline_set_doc (self, g_value_get_object (value));
		break;
		case SCRATCH_SERVICES_SYMBOL_OUTLINE_TOOL_BOX_SENSITIVE_PROPERTY:
		scratch_services_symbol_outline_set_tool_box_sensitive (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

