/* ProjectFolderItem.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from ProjectFolderItem.vala, do not modify */

/*-
 * Copyright (c) 2018 elementary LLC. (https://elementary.io),
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: David Hewitt <davidmhewitt@gmail.com>
 */

#include "codecore.h"
#include <gio/gio.h>
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <libgit2-glib/ggit.h>
#include <granite.h>
#include <glib/gstdio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM_TYPE_VISIBLE_ITEM (scratch_folder_manager_project_folder_item_visible_item_get_type ())
typedef struct _ScratchFolderManagerProjectFolderItemVisibleItem ScratchFolderManagerProjectFolderItemVisibleItem;
enum  {
	SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM_0_PROPERTY,
	SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM_MONITORED_REPO_PROPERTY,
	SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM_IS_GIT_REPO_PROPERTY,
	SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM_NUM_PROPERTIES
};
static GParamSpec* scratch_folder_manager_project_folder_item_properties[SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block22Data Block22Data;
#define _scratch_folder_manager_project_folder_item_visible_item_free0(var) ((var == NULL) ? NULL : (var = (scratch_folder_manager_project_folder_item_visible_item_free (var), NULL)))
typedef struct _Block23Data Block23Data;
typedef struct _Block24Data Block24Data;
typedef struct _Block25Data Block25Data;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define __vala_GgitStatusOptions_free0(var) ((var == NULL) ? NULL : (var = (_vala_GgitStatusOptions_free (var), NULL)))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
enum  {
	SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM_CLOSED_SIGNAL,
	SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM_NUM_SIGNALS
};
static guint scratch_folder_manager_project_folder_item_signals[SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ScratchFolderManagerProjectFolderItemVisibleItem {
	gchar* rel_path;
	ScratchFolderManagerItem* item;
};

struct _ScratchFolderManagerProjectFolderItemPrivate {
	GSimpleAction* checkout_local_branch_action;
	GSimpleAction* checkout_remote_branch_action;
	ScratchServicesMonitoredRepository* _monitored_repo;
	GList* visible_item_list;
};

struct _Block22Data {
	int _ref_count_;
	ScratchFolderManagerProjectFolderItem* self;
	gboolean is_new;
	gchar* start_path;
};

struct _Block23Data {
	int _ref_count_;
	Block22Data * _data22_;
	ScratchFolderManagerItem* item;
	ScratchFolderManagerProjectFolderItemVisibleItem* visible_item;
};

struct _Block24Data {
	int _ref_count_;
	ScratchFolderManagerProjectFolderItem* self;
	GraniteMessageDialog* dialog;
};

struct _Block25Data {
	int _ref_count_;
	ScratchFolderManagerProjectFolderItem* self;
	gchar* search_term;
	gboolean recurse_subfolders;
	gboolean check_is_text;
	GRegex* pattern;
	ScratchDialogsGlobalSearchDialog* dialog;
	GFile* start_folder;
	gchar* term;
};

static gint ScratchFolderManagerProjectFolderItem_private_offset;
static gpointer scratch_folder_manager_project_folder_item_parent_class = NULL;
static GIcon* scratch_folder_manager_project_folder_item_added_icon;
static GIcon* scratch_folder_manager_project_folder_item_added_icon = NULL;
static GIcon* scratch_folder_manager_project_folder_item_modified_icon;
static GIcon* scratch_folder_manager_project_folder_item_modified_icon = NULL;

static GType scratch_folder_manager_project_folder_item_visible_item_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static ScratchFolderManagerProjectFolderItemVisibleItem* scratch_folder_manager_project_folder_item_visible_item_dup (const ScratchFolderManagerProjectFolderItemVisibleItem* self);
static void scratch_folder_manager_project_folder_item_visible_item_free (ScratchFolderManagerProjectFolderItemVisibleItem* self);
static void scratch_folder_manager_project_folder_item_visible_item_copy (const ScratchFolderManagerProjectFolderItemVisibleItem* self,
                                                                   ScratchFolderManagerProjectFolderItemVisibleItem* dest);
static void scratch_folder_manager_project_folder_item_visible_item_destroy (ScratchFolderManagerProjectFolderItemVisibleItem* self);
static void _scratch_folder_manager_project_folder_item_visible_item_free0_ (gpointer var);
static inline void _g_list_free__scratch_folder_manager_project_folder_item_visible_item_free0_ (GList* self);
static void scratch_folder_manager_project_folder_item_branch_or_name_changed (ScratchFolderManagerProjectFolderItem* self);
static GVariant* _variant_new18 (const gchar* value);
static void scratch_folder_manager_project_folder_item_real_on_changed (ScratchFolderManagerFolderItem* base,
                                                                 GFile* source,
                                                                 GFile* dest,
                                                                 GFileMonitorEvent event);
static void scratch_folder_manager_project_folder_item_deprioritize_git_ignored (ScratchFolderManagerProjectFolderItem* self);
static GtkMenu* scratch_folder_manager_project_folder_item_real_get_context_menu (CodeWidgetsSourceListItem* base);
static GVariant* _variant_new19 (const gchar* value);
static GVariant* _variant_new20 (gchar* value);
static GVariant* _variant_new21 (const gchar* value);
static GVariant* _variant_new22 (gchar* value);
static GVariant* _variant_new23 (const gchar* value);
static GVariant* _variant_new24 (gchar* value);
static GVariant* _variant_new25 (const gchar* value);
static GVariant* _variant_new26 (gchar* value);
static GVariant* _variant_new27 (const gchar* value);
static GVariant* _variant_new28 (const gchar* value);
static GVariant* _variant_new29 (gchar* value);
static GVariant* _variant_new30 (const gchar* value);
static GVariant* _variant_new31 (gchar* value);
static void scratch_folder_manager_project_folder_item_handle_checkout_local_branch_action (ScratchFolderManagerProjectFolderItem* self,
                                                                                     GVariant* param);
static void scratch_folder_manager_project_folder_item_handle_checkout_remote_branch_action (ScratchFolderManagerProjectFolderItem* self,
                                                                                      GVariant* param);
static Block22Data* block22_data_ref (Block22Data* _data22_);
static void block22_data_unref (void * _userdata_);
static void __lambda82_ (Block22Data* _data22_,
                  ScratchFolderManagerProjectFolderItemVisibleItem* visible_item);
static Block23Data* block23_data_ref (Block23Data* _data23_);
static void block23_data_unref (void * _userdata_);
static gboolean __lambda83_ (Block23Data* _data23_,
                      GeeMapEntry* entry);
static gboolean ___lambda83__gee_forall_func (gpointer g,
                                       gpointer self);
static void ___lambda82__gfunc (gconstpointer data,
                         gpointer self);
static void __lambda84_ (ScratchFolderManagerProjectFolderItem* self,
                  ScratchFolderManagerProjectFolderItemVisibleItem* visible_item);
static void ___lambda84__gfunc (gconstpointer data,
                         gpointer self);
static Block24Data* block24_data_ref (Block24Data* _data24_);
static void block24_data_unref (void * _userdata_);
static void ___lambda100_ (Block24Data* _data24_);
static void ____lambda100__gtk_dialog_response (GtkDialog* _sender,
                                         gint response_id,
                                         gpointer self);
static Block25Data* block25_data_ref (Block25Data* _data25_);
static void block25_data_unref (void * _userdata_);
static void __lambda97_ (Block25Data* _data25_,
                  gint response);
static void ___lambda97__gtk_dialog_response (GtkDialog* _sender,
                                       gint response_id,
                                       gpointer self);
static gint ____lambda98_ (Block25Data* _data25_,
                    const gchar* rel_path,
                    GgitStatusFlags status);
static void scratch_folder_manager_project_folder_item_perform_match (ScratchFolderManagerProjectFolderItem* self,
                                                               GFile* target,
                                                               GRegex* search_regex,
                                                               gboolean check_is_text,
                                                               GFileInfo* target_info);
static gint _____lambda98__ggit_status_callback (const gchar* path,
                                          GgitStatusFlags status_flags,
                                          gpointer self);
static void _vala_GgitStatusOptions_free (GgitStatusOptions* self);
static void scratch_folder_manager_project_folder_item_search_folder_children (ScratchFolderManagerProjectFolderItem* self,
                                                                        GFile* start_folder,
                                                                        GRegex* pattern,
                                                                        gboolean recurse_subfolders);
static void scratch_folder_manager_project_folder_item_set_monitored_repo (ScratchFolderManagerProjectFolderItem* self,
                                                                    ScratchServicesMonitoredRepository* value);
static GgitRepository* scratch_folder_manager_project_folder_item_get_git_repo (ScratchFolderManagerProjectFolderItem* self);
static GObject * scratch_folder_manager_project_folder_item_constructor (GType type,
                                                                  guint n_construct_properties,
                                                                  GObjectConstructParam * construct_properties);
static void _scratch_folder_manager_project_folder_item_branch_or_name_changed_g_object_notify (GObject* _sender,
                                                                                         GParamSpec* pspec,
                                                                                         gpointer self);
static GVariant* _variant_new32 (const gchar* value);
static GVariant* _variant_new33 (const gchar* value);
static void _scratch_folder_manager_project_folder_item_branch_or_name_changed_scratch_services_monitored_repository_branch_changed (ScratchServicesMonitoredRepository* _sender,
                                                                                                                              gpointer self);
static void _scratch_folder_manager_project_folder_item_deprioritize_git_ignored_scratch_services_monitored_repository_ignored_changed (ScratchServicesMonitoredRepository* _sender,
                                                                                                                                 gpointer self);
static void _scratch_folder_manager_project_folder_item____lambda104_ (ScratchFolderManagerProjectFolderItem* self);
static void __scratch_folder_manager_project_folder_item____lambda104__scratch_services_monitored_repository_file_status_change (ScratchServicesMonitoredRepository* _sender,
                                                                                                                          gpointer self);
static void _scratch_folder_manager_project_folder_item_handle_checkout_local_branch_action_g_simple_action_activate (GSimpleAction* _sender,
                                                                                                               GVariant* parameter,
                                                                                                               gpointer self);
static void _scratch_folder_manager_project_folder_item_handle_checkout_remote_branch_action_g_simple_action_activate (GSimpleAction* _sender,
                                                                                                                GVariant* parameter,
                                                                                                                gpointer self);
static void scratch_folder_manager_project_folder_item_finalize (GObject * obj);
static GType scratch_folder_manager_project_folder_item_get_type_once (void);
static void _vala_scratch_folder_manager_project_folder_item_get_property (GObject * object,
                                                                    guint property_id,
                                                                    GValue * value,
                                                                    GParamSpec * pspec);
static void _vala_scratch_folder_manager_project_folder_item_set_property (GObject * object,
                                                                    guint property_id,
                                                                    const GValue * value,
                                                                    GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
scratch_folder_manager_project_folder_item_get_instance_private (ScratchFolderManagerProjectFolderItem* self)
{
	return G_STRUCT_MEMBER_P (self, ScratchFolderManagerProjectFolderItem_private_offset);
}

static void
_scratch_folder_manager_project_folder_item_visible_item_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (scratch_folder_manager_project_folder_item_visible_item_free (var), NULL));
}

static inline void
_g_list_free__scratch_folder_manager_project_folder_item_visible_item_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _scratch_folder_manager_project_folder_item_visible_item_free0_);
}

ScratchFolderManagerProjectFolderItem*
scratch_folder_manager_project_folder_item_construct (GType object_type,
                                                      ScratchFolderManagerFile* file,
                                                      ScratchFolderManagerFileView* view)
{
	ScratchFolderManagerProjectFolderItem * self = NULL;
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (view != NULL, NULL);
	_tmp0_ = scratch_folder_manager_file_get_is_valid_directory (file);
	_tmp1_ = _tmp0_;
	_vala_return_val_if_fail (_tmp1_, "file.is_valid_directory", NULL);
	self = (ScratchFolderManagerProjectFolderItem*) g_object_new (object_type, "file", file, "view", view, NULL);
	return self;
}

ScratchFolderManagerProjectFolderItem*
scratch_folder_manager_project_folder_item_new (ScratchFolderManagerFile* file,
                                                ScratchFolderManagerFileView* view)
{
	return scratch_folder_manager_project_folder_item_construct (SCRATCH_FOLDER_MANAGER_TYPE_PROJECT_FOLDER_ITEM, file, view);
}

static GVariant*
_variant_new18 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static void
scratch_folder_manager_project_folder_item_branch_or_name_changed (ScratchFolderManagerProjectFolderItem* self)
{
	ScratchServicesMonitoredRepository* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_monitored_repo;
	if (_tmp0_ != NULL) {
		ScratchServicesMonitoredRepository* _tmp1_;
		gboolean _tmp2_;
		gboolean _tmp3_;
		GSimpleAction* _tmp18_;
		ScratchServicesMonitoredRepository* _tmp19_;
		const gchar* _tmp20_;
		const gchar* _tmp21_;
		GVariant* _tmp22_;
		_tmp1_ = self->priv->_monitored_repo;
		_tmp2_ = scratch_services_monitored_repository_get_head_is_branch (_tmp1_);
		_tmp3_ = _tmp2_;
		if (_tmp3_) {
			const gchar* _tmp4_;
			const gchar* _tmp5_;
			ScratchServicesMonitoredRepository* _tmp6_;
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp4_ = code_widgets_source_list_item_get_name ((CodeWidgetsSourceListItem*) self);
			_tmp5_ = _tmp4_;
			_tmp6_ = self->priv->_monitored_repo;
			_tmp7_ = scratch_services_monitored_repository_get_branch_name (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = g_strdup_printf ("%s\n<span size='small' weight='normal'>%s</span>", _tmp5_, _tmp8_);
			_tmp10_ = _tmp9_;
			code_widgets_source_list_item_set_markup ((CodeWidgetsSourceListItem*) self, _tmp10_);
			_g_free0 (_tmp10_);
		} else {
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			ScratchServicesMonitoredRepository* _tmp13_;
			const gchar* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp11_ = code_widgets_source_list_item_get_name ((CodeWidgetsSourceListItem*) self);
			_tmp12_ = _tmp11_;
			_tmp13_ = self->priv->_monitored_repo;
			_tmp14_ = scratch_services_monitored_repository_get_branch_name (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = g_strdup_printf ("%s\n <span size='small' weight='normal' style='italic'>%s</span>", _tmp12_, _tmp15_);
			_tmp17_ = _tmp16_;
			code_widgets_source_list_item_set_markup ((CodeWidgetsSourceListItem*) self, _tmp17_);
			_g_free0 (_tmp17_);
		}
		_tmp18_ = self->priv->checkout_local_branch_action;
		_tmp19_ = self->priv->_monitored_repo;
		_tmp20_ = scratch_services_monitored_repository_get_branch_name (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = _variant_new18 (_tmp21_);
		g_simple_action_set_state (_tmp18_, _tmp22_);
		_g_variant_unref0 (_tmp22_);
	}
}

static void
scratch_folder_manager_project_folder_item_real_on_changed (ScratchFolderManagerFolderItem* base,
                                                            GFile* source,
                                                            GFile* dest,
                                                            GFileMonitorEvent event)
{
	ScratchFolderManagerProjectFolderItem * self;
	gboolean _tmp0_ = FALSE;
	ScratchFolderManagerFile* _tmp1_;
	ScratchFolderManagerFile* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	self = (ScratchFolderManagerProjectFolderItem*) base;
	g_return_if_fail (source != NULL);
	_tmp1_ = scratch_folder_manager_item_get_file ((ScratchFolderManagerItem*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = scratch_folder_manager_file_get_file (_tmp2_);
	_tmp4_ = _tmp3_;
	if (g_file_equal (source, _tmp4_)) {
		_tmp0_ = event == G_FILE_MONITOR_EVENT_DELETED;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		g_signal_emit (self, scratch_folder_manager_project_folder_item_signals[SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM_CLOSED_SIGNAL], 0);
	} else {
		SCRATCH_FOLDER_MANAGER_FOLDER_ITEM_CLASS (scratch_folder_manager_project_folder_item_parent_class)->on_changed (G_TYPE_CHECK_INSTANCE_CAST (self, SCRATCH_FOLDER_MANAGER_TYPE_FOLDER_ITEM, ScratchFolderManagerFolderItem), source, dest, event);
	}
}

void
scratch_folder_manager_project_folder_item_child_folder_changed (ScratchFolderManagerProjectFolderItem* self,
                                                                 ScratchFolderManagerFolderItem* folder)
{
	ScratchServicesMonitoredRepository* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (folder != NULL);
	_tmp0_ = self->priv->_monitored_repo;
	if (_tmp0_ != NULL) {
		ScratchServicesMonitoredRepository* _tmp1_;
		_tmp1_ = self->priv->_monitored_repo;
		scratch_services_monitored_repository_update_status_map (_tmp1_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gpointer
_scratch_folder_manager_project_folder_item_visible_item_dup0 (gpointer self)
{
	return self ? scratch_folder_manager_project_folder_item_visible_item_dup (self) : NULL;
}

void
scratch_folder_manager_project_folder_item_child_folder_loaded (ScratchFolderManagerProjectFolderItem* self,
                                                                ScratchFolderManagerFolderItem* folder)
{
	ScratchServicesMonitoredRepository* _tmp31_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (folder != NULL);
	{
		GeeIterator* _child_it = NULL;
		GeeCollection* _tmp0_;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeIterator* _tmp3_;
		GeeIterator* _tmp4_;
		_tmp0_ = code_widgets_source_list_expandable_item_get_children ((CodeWidgetsSourceListExpandableItem*) folder);
		_tmp1_ = _tmp0_;
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_child_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			CodeWidgetsSourceListItem* child = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			CodeWidgetsSourceListItem* _tmp8_;
			_tmp5_ = _child_it;
			if (!gee_iterator_next (_tmp5_)) {
				break;
			}
			_tmp6_ = _child_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			child = (CodeWidgetsSourceListItem*) _tmp7_;
			_tmp8_ = child;
			if (SCRATCH_FOLDER_MANAGER_IS_ITEM (_tmp8_)) {
				ScratchFolderManagerItem* item = NULL;
				CodeWidgetsSourceListItem* _tmp9_;
				ScratchFolderManagerItem* _tmp10_;
				gchar* rel_path = NULL;
				ScratchFolderManagerFile* _tmp11_;
				ScratchFolderManagerFile* _tmp12_;
				GFile* _tmp13_;
				GFile* _tmp14_;
				ScratchFolderManagerItem* _tmp15_;
				ScratchFolderManagerFile* _tmp16_;
				ScratchFolderManagerFile* _tmp17_;
				GFile* _tmp18_;
				GFile* _tmp19_;
				gchar* _tmp20_;
				gboolean _tmp21_ = FALSE;
				const gchar* _tmp22_;
				_tmp9_ = child;
				_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, SCRATCH_FOLDER_MANAGER_TYPE_ITEM, ScratchFolderManagerItem));
				item = _tmp10_;
				_tmp11_ = scratch_folder_manager_item_get_file ((ScratchFolderManagerItem*) self);
				_tmp12_ = _tmp11_;
				_tmp13_ = scratch_folder_manager_file_get_file (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = item;
				_tmp16_ = scratch_folder_manager_item_get_file (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp18_ = scratch_folder_manager_file_get_file (_tmp17_);
				_tmp19_ = _tmp18_;
				_tmp20_ = g_file_get_relative_path (_tmp14_, _tmp19_);
				rel_path = _tmp20_;
				_tmp22_ = rel_path;
				if (_tmp22_ != NULL) {
					const gchar* _tmp23_;
					_tmp23_ = rel_path;
					_tmp21_ = g_strcmp0 (_tmp23_, "") != 0;
				} else {
					_tmp21_ = FALSE;
				}
				if (_tmp21_) {
					const gchar* _tmp24_;
					gchar* _tmp25_;
					ScratchFolderManagerItem* _tmp26_;
					ScratchFolderManagerItem* _tmp27_;
					ScratchFolderManagerProjectFolderItemVisibleItem _tmp28_ = {0};
					ScratchFolderManagerProjectFolderItemVisibleItem _tmp29_;
					ScratchFolderManagerProjectFolderItemVisibleItem* _tmp30_;
					_tmp24_ = rel_path;
					_tmp25_ = g_strdup (_tmp24_);
					_tmp26_ = item;
					_tmp27_ = _g_object_ref0 (_tmp26_);
					_g_free0 (_tmp28_.rel_path);
					_tmp28_.rel_path = _tmp25_;
					_g_object_unref0 (_tmp28_.item);
					_tmp28_.item = _tmp27_;
					_tmp29_ = _tmp28_;
					_tmp30_ = _scratch_folder_manager_project_folder_item_visible_item_dup0 (&_tmp29_);
					self->priv->visible_item_list = g_list_prepend (self->priv->visible_item_list, _tmp30_);
					scratch_folder_manager_project_folder_item_visible_item_destroy (&_tmp29_);
				}
				_g_free0 (rel_path);
				_g_object_unref0 (item);
			}
			_g_object_unref0 (child);
		}
		_g_object_unref0 (_child_it);
	}
	_tmp31_ = self->priv->_monitored_repo;
	if (_tmp31_ != NULL) {
		ScratchServicesMonitoredRepository* _tmp32_;
		_tmp32_ = self->priv->_monitored_repo;
		scratch_services_monitored_repository_update_status_map (_tmp32_);
		scratch_folder_manager_project_folder_item_update_item_status (self, folder);
		scratch_folder_manager_project_folder_item_deprioritize_git_ignored (self);
	}
}

static GVariant*
_variant_new19 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new20 (gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new21 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new22 (gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new23 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new24 (gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new25 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new26 (gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GtkMenu*
scratch_folder_manager_project_folder_item_real_get_context_menu (CodeWidgetsSourceListItem* base)
{
	ScratchFolderManagerProjectFolderItem * self;
	gchar* file_type = NULL;
	gchar* _tmp0_;
	GMenuItem* set_active_folder_item = NULL;
	gboolean _tmp10_;
	gboolean _tmp11_;
	GMenuItem* _tmp34_;
	GVariant* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	GVariant* _tmp40_;
	GMenu* external_actions_section = NULL;
	GMenu* _tmp41_;
	GMenu* _tmp42_;
	GMenuItem* _tmp43_;
	GMenu* _tmp44_;
	const gchar* _tmp45_;
	GMenuItem* _tmp46_;
	GMenuItem* _tmp47_;
	GMenu* folder_actions_section = NULL;
	GMenu* _tmp48_;
	GMenu* _tmp49_;
	GMenuItem* _tmp50_;
	GMenuItem* _tmp51_;
	ScratchServicesMonitoredRepository* _tmp52_;
	GMenuItem* close_folder_item = NULL;
	ScratchFolderManagerFile* _tmp56_;
	ScratchFolderManagerFile* _tmp57_;
	gchar* _tmp58_;
	gchar* _tmp59_;
	gchar* _tmp60_;
	GVariant* _tmp61_;
	GVariant* _tmp62_;
	gchar* _tmp63_;
	gchar* _tmp64_;
	GMenuItem* _tmp65_;
	GMenuItem* _tmp66_;
	GMenuItem* close_all_except_item = NULL;
	ScratchFolderManagerFile* _tmp67_;
	ScratchFolderManagerFile* _tmp68_;
	gchar* _tmp69_;
	gchar* _tmp70_;
	gchar* _tmp71_;
	GVariant* _tmp72_;
	GVariant* _tmp73_;
	gchar* _tmp74_;
	gchar* _tmp75_;
	GMenuItem* _tmp76_;
	GMenuItem* _tmp77_;
	GSimpleAction* close_other_folders_action = NULL;
	ScratchFolderManagerFileView* _tmp78_;
	ScratchFolderManagerFileView* _tmp79_;
	GSimpleActionGroup* _tmp80_;
	GSimpleActionGroup* _tmp81_;
	GSimpleAction* _tmp82_;
	GSimpleAction* _tmp83_;
	ScratchFolderManagerFileView* _tmp84_;
	ScratchFolderManagerFileView* _tmp85_;
	CodeWidgetsSourceListExpandableItem* _tmp86_;
	CodeWidgetsSourceListExpandableItem* _tmp87_;
	GeeCollection* _tmp88_;
	GeeCollection* _tmp89_;
	GeeCollection* _tmp90_;
	gint _tmp91_;
	gint _tmp92_;
	GMenu* close_actions_section = NULL;
	GMenu* _tmp93_;
	GMenu* _tmp94_;
	GMenuItem* _tmp95_;
	GMenu* _tmp96_;
	GMenuItem* _tmp97_;
	guint n_open = 0U;
	ScratchServicesDocumentManager* _tmp98_;
	ScratchServicesDocumentManager* _tmp99_;
	gchar* _tmp100_;
	gchar* _tmp101_;
	gchar* _tmp102_;
	guint _tmp103_;
	gchar* open_text = NULL;
	gchar* _tmp104_;
	GMenuItem* close_item = NULL;
	const gchar* _tmp105_;
	ScratchFolderManagerFile* _tmp106_;
	ScratchFolderManagerFile* _tmp107_;
	GFile* _tmp108_;
	GFile* _tmp109_;
	gchar* _tmp110_;
	gchar* _tmp111_;
	GVariant* _tmp112_;
	GVariant* _tmp113_;
	gchar* _tmp114_;
	gchar* _tmp115_;
	GMenuItem* _tmp116_;
	GMenuItem* _tmp117_;
	gchar* hide_text = NULL;
	gchar* _tmp118_;
	GMenuItem* hide_item = NULL;
	const gchar* _tmp119_;
	ScratchFolderManagerFile* _tmp120_;
	ScratchFolderManagerFile* _tmp121_;
	GFile* _tmp122_;
	GFile* _tmp123_;
	gchar* _tmp124_;
	gchar* _tmp125_;
	GVariant* _tmp126_;
	GVariant* _tmp127_;
	gchar* _tmp128_;
	gchar* _tmp129_;
	GMenuItem* _tmp130_;
	GMenuItem* _tmp131_;
	GMenuItem* _tmp132_;
	GVariant* _tmp133_;
	gchar* _tmp134_;
	gchar* _tmp135_;
	gchar* _tmp136_;
	gchar* _tmp137_;
	GVariant* _tmp138_;
	guint n_restorable = 0U;
	ScratchServicesDocumentManager* _tmp139_;
	ScratchServicesDocumentManager* _tmp140_;
	gchar* _tmp141_;
	gchar* _tmp142_;
	gchar* _tmp143_;
	guint _tmp144_;
	gchar* restore_text = NULL;
	gchar* _tmp145_;
	GMenuItem* restore_item = NULL;
	const gchar* _tmp146_;
	ScratchFolderManagerFile* _tmp147_;
	ScratchFolderManagerFile* _tmp148_;
	GFile* _tmp149_;
	GFile* _tmp150_;
	gchar* _tmp151_;
	gchar* _tmp152_;
	GVariant* _tmp153_;
	GVariant* _tmp154_;
	gchar* _tmp155_;
	gchar* _tmp156_;
	GMenuItem* _tmp157_;
	GMenuItem* _tmp158_;
	GMenuItem* _tmp159_;
	GVariant* _tmp160_;
	gchar* _tmp161_;
	gchar* _tmp162_;
	gchar* _tmp163_;
	gchar* _tmp164_;
	GVariant* _tmp165_;
	GMenu* direct_actions_section = NULL;
	GMenu* _tmp166_;
	GMenuItem* search_item = NULL;
	ScratchFolderManagerFile* _tmp173_;
	ScratchFolderManagerFile* _tmp174_;
	GFile* _tmp175_;
	GFile* _tmp176_;
	gchar* _tmp177_;
	gchar* _tmp178_;
	GVariant* _tmp179_;
	GVariant* _tmp180_;
	gchar* _tmp181_;
	gchar* _tmp182_;
	GMenuItem* _tmp183_;
	GMenuItem* _tmp184_;
	GVariant* _tmp185_;
	gchar* _tmp186_;
	gchar* _tmp187_;
	gchar* _tmp188_;
	gchar* _tmp189_;
	GVariant* _tmp190_;
	GMenu* search_actions_section = NULL;
	GMenu* _tmp191_;
	GMenu* menu_model = NULL;
	GMenu* _tmp192_;
	GMenu* _tmp193_;
	GMenu* _tmp194_;
	GMenu* _tmp195_;
	GMenu* _tmp196_;
	GtkMenu* menu = NULL;
	GtkMenu* _tmp197_;
	ScratchFolderManagerFileView* _tmp198_;
	ScratchFolderManagerFileView* _tmp199_;
	GSimpleActionGroup* _tmp200_;
	GSimpleActionGroup* _tmp201_;
	GError* _inner_error0_ = NULL;
	GtkMenu* result;
	self = (ScratchFolderManagerProjectFolderItem*) base;
	_tmp0_ = g_strdup ("");
	file_type = _tmp0_;
	{
		GFileInfo* info = NULL;
		ScratchFolderManagerFile* _tmp1_;
		ScratchFolderManagerFile* _tmp2_;
		GFile* _tmp3_;
		GFile* _tmp4_;
		GFileInfo* _tmp5_;
		_tmp1_ = scratch_folder_manager_item_get_file ((ScratchFolderManagerItem*) self);
		_tmp2_ = _tmp1_;
		_tmp3_ = scratch_folder_manager_file_get_file (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_file_query_info (_tmp4_, G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
		info = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		if (g_file_info_has_attribute (info, G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE)) {
			const gchar* _tmp6_;
			gchar* _tmp7_;
			_tmp6_ = g_file_info_get_content_type (info);
			_tmp7_ = g_strdup (_tmp6_);
			_g_free0 (file_type);
			file_type = _tmp7_;
		}
		_g_object_unref0 (info);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		g_warning ("ProjectFolderItem.vala:141: %s", _tmp9_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (file_type);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp10_ = scratch_folder_manager_project_folder_item_get_is_git_repo (self);
	_tmp11_ = _tmp10_;
	if (_tmp11_) {
		ScratchFolderManagerFile* _tmp12_;
		ScratchFolderManagerFile* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		GVariant* _tmp17_;
		GVariant* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		GMenuItem* _tmp21_;
		_tmp12_ = scratch_folder_manager_item_get_file ((ScratchFolderManagerItem*) self);
		_tmp13_ = _tmp12_;
		_tmp14_ = scratch_folder_manager_file_get_path (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = _tmp15_;
		_tmp17_ = g_variant_new_string (_tmp16_);
		g_variant_ref_sink (_tmp17_);
		_tmp18_ = _tmp17_;
		_tmp19_ = g_action_print_detailed_name (SCRATCH_FOLDER_MANAGER_FILE_VIEW_ACTION_PREFIX SCRATCH_FOLDER_MANAGER_FILE_VIEW_ACTION_SET_ACTIVE_PROJECT, _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = g_menu_item_new (_ ("Set as Active Project"), _tmp20_);
		_g_object_unref0 (set_active_folder_item);
		set_active_folder_item = _tmp21_;
		_g_free0 (_tmp20_);
		_g_variant_unref0 (_tmp18_);
		_g_free0 (_tmp16_);
	} else {
		ScratchServicesGitManager* _tmp22_;
		ScratchServicesGitManager* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		GVariant* _tmp29_;
		GVariant* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		GMenuItem* _tmp33_;
		_tmp22_ = scratch_services_git_manager_get_instance ();
		_tmp23_ = _tmp22_;
		_tmp24_ = scratch_folder_manager_item_get_path ((ScratchFolderManagerItem*) self);
		_tmp25_ = _tmp24_;
		_tmp26_ = _tmp25_;
		_tmp27_ = scratch_services_git_manager_get_default_build_dir (_tmp23_, _tmp26_);
		_tmp28_ = _tmp27_;
		_tmp29_ = g_variant_new_string (_tmp28_);
		g_variant_ref_sink (_tmp29_);
		_tmp30_ = _tmp29_;
		_tmp31_ = g_action_print_detailed_name (SCRATCH_MAIN_WINDOW_ACTION_PREFIX SCRATCH_MAIN_WINDOW_ACTION_OPEN_IN_TERMINAL, _tmp30_);
		_tmp32_ = _tmp31_;
		_tmp33_ = g_menu_item_new (_ ("Open in Terminal Pane"), _tmp32_);
		_g_object_unref0 (set_active_folder_item);
		set_active_folder_item = _tmp33_;
		_g_free0 (_tmp32_);
		_g_variant_unref0 (_tmp30_);
		_g_free0 (_tmp28_);
		_g_free0 (_tmp26_);
		_g_object_unref0 (_tmp23_);
	}
	_tmp34_ = set_active_folder_item;
	_tmp35_ = _variant_new19 ("");
	_tmp36_ = g_action_print_detailed_name (SCRATCH_MAIN_WINDOW_ACTION_PREFIX SCRATCH_MAIN_WINDOW_ACTION_OPEN_IN_TERMINAL, _tmp35_);
	_tmp37_ = _tmp36_;
	_tmp38_ = scratch_utils_get_accel_for_action (_tmp37_);
	_tmp39_ = _tmp38_;
	_tmp40_ = _variant_new20 (_tmp39_);
	g_menu_item_set_attribute_value (_tmp34_, "accel", _tmp40_);
	_g_variant_unref0 (_tmp40_);
	_g_free0 (_tmp39_);
	_g_free0 (_tmp37_);
	_g_variant_unref0 (_tmp35_);
	_tmp41_ = g_menu_new ();
	external_actions_section = _tmp41_;
	_tmp42_ = external_actions_section;
	_tmp43_ = set_active_folder_item;
	g_menu_append_item (_tmp42_, _tmp43_);
	_tmp44_ = external_actions_section;
	_tmp45_ = file_type;
	_tmp46_ = scratch_folder_manager_folder_item_create_submenu_for_open_in ((ScratchFolderManagerFolderItem*) self, _tmp45_);
	_tmp47_ = _tmp46_;
	g_menu_append_item (_tmp44_, _tmp47_);
	_g_object_unref0 (_tmp47_);
	_tmp48_ = g_menu_new ();
	folder_actions_section = _tmp48_;
	_tmp49_ = folder_actions_section;
	_tmp50_ = scratch_folder_manager_folder_item_create_submenu_for_new ((ScratchFolderManagerFolderItem*) self);
	_tmp51_ = _tmp50_;
	g_menu_append_item (_tmp49_, _tmp51_);
	_g_object_unref0 (_tmp51_);
	_tmp52_ = self->priv->_monitored_repo;
	if (_tmp52_ != NULL) {
		GMenu* _tmp53_;
		GMenuItem* _tmp54_;
		GMenuItem* _tmp55_;
		_tmp53_ = folder_actions_section;
		_tmp54_ = scratch_folder_manager_project_folder_item_create_submenu_for_branch (self);
		_tmp55_ = _tmp54_;
		g_menu_append_item (_tmp53_, _tmp55_);
		_g_object_unref0 (_tmp55_);
	}
	_tmp56_ = scratch_folder_manager_item_get_file ((ScratchFolderManagerItem*) self);
	_tmp57_ = _tmp56_;
	_tmp58_ = scratch_folder_manager_file_get_path (_tmp57_);
	_tmp59_ = _tmp58_;
	_tmp60_ = _tmp59_;
	_tmp61_ = g_variant_new_string (_tmp60_);
	g_variant_ref_sink (_tmp61_);
	_tmp62_ = _tmp61_;
	_tmp63_ = g_action_print_detailed_name (SCRATCH_FOLDER_MANAGER_FILE_VIEW_ACTION_PREFIX SCRATCH_FOLDER_MANAGER_FILE_VIEW_ACTION_CLOSE_FOLDER, _tmp62_);
	_tmp64_ = _tmp63_;
	_tmp65_ = g_menu_item_new (_ ("Close Folder"), _tmp64_);
	_tmp66_ = _tmp65_;
	_g_free0 (_tmp64_);
	_g_variant_unref0 (_tmp62_);
	_g_free0 (_tmp60_);
	close_folder_item = _tmp66_;
	_tmp67_ = scratch_folder_manager_item_get_file ((ScratchFolderManagerItem*) self);
	_tmp68_ = _tmp67_;
	_tmp69_ = scratch_folder_manager_file_get_path (_tmp68_);
	_tmp70_ = _tmp69_;
	_tmp71_ = _tmp70_;
	_tmp72_ = g_variant_new_string (_tmp71_);
	g_variant_ref_sink (_tmp72_);
	_tmp73_ = _tmp72_;
	_tmp74_ = g_action_print_detailed_name (SCRATCH_FOLDER_MANAGER_FILE_VIEW_ACTION_PREFIX SCRATCH_FOLDER_MANAGER_FILE_VIEW_ACTION_CLOSE_OTHER_FOLDERS, _tmp73_);
	_tmp75_ = _tmp74_;
	_tmp76_ = g_menu_item_new (_ ("Close Other Folders"), _tmp75_);
	_tmp77_ = _tmp76_;
	_g_free0 (_tmp75_);
	_g_variant_unref0 (_tmp73_);
	_g_free0 (_tmp71_);
	close_all_except_item = _tmp77_;
	_tmp78_ = scratch_folder_manager_item_get_view ((ScratchFolderManagerItem*) self);
	_tmp79_ = _tmp78_;
	_tmp80_ = scratch_folder_manager_file_view_get_actions (_tmp79_);
	_tmp81_ = _tmp80_;
	_tmp82_ = scratch_utils_action_from_group (SCRATCH_FOLDER_MANAGER_FILE_VIEW_ACTION_CLOSE_OTHER_FOLDERS, _tmp81_);
	close_other_folders_action = _tmp82_;
	_tmp83_ = close_other_folders_action;
	_tmp84_ = scratch_folder_manager_item_get_view ((ScratchFolderManagerItem*) self);
	_tmp85_ = _tmp84_;
	_tmp86_ = code_widgets_source_list_get_root ((CodeWidgetsSourceList*) _tmp85_);
	_tmp87_ = _tmp86_;
	_tmp88_ = code_widgets_source_list_expandable_item_get_children (_tmp87_);
	_tmp89_ = _tmp88_;
	_tmp90_ = _tmp89_;
	_tmp91_ = gee_collection_get_size (_tmp90_);
	_tmp92_ = _tmp91_;
	g_simple_action_set_enabled (_tmp83_, _tmp92_ > 1);
	_g_object_unref0 (_tmp90_);
	_tmp93_ = g_menu_new ();
	close_actions_section = _tmp93_;
	_tmp94_ = close_actions_section;
	_tmp95_ = close_folder_item;
	g_menu_append_item (_tmp94_, _tmp95_);
	_tmp96_ = close_actions_section;
	_tmp97_ = close_all_except_item;
	g_menu_append_item (_tmp96_, _tmp97_);
	_tmp98_ = scratch_services_document_manager_get_instance ();
	_tmp99_ = _tmp98_;
	_tmp100_ = scratch_folder_manager_item_get_path ((ScratchFolderManagerItem*) self);
	_tmp101_ = _tmp100_;
	_tmp102_ = _tmp101_;
	_tmp103_ = scratch_services_document_manager_open_for_project (_tmp99_, _tmp102_);
	_g_free0 (_tmp102_);
	_g_object_unref0 (_tmp99_);
	n_open = _tmp103_;
	_tmp104_ = g_strdup_printf (ngettext ("Close %u Open Document", "Close %u Open Documents", (gulong) n_open), n_open);
	open_text = _tmp104_;
	_tmp105_ = open_text;
	_tmp106_ = scratch_folder_manager_item_get_file ((ScratchFolderManagerItem*) self);
	_tmp107_ = _tmp106_;
	_tmp108_ = scratch_folder_manager_file_get_file (_tmp107_);
	_tmp109_ = _tmp108_;
	_tmp110_ = g_file_get_path (_tmp109_);
	_tmp111_ = _tmp110_;
	_tmp112_ = g_variant_new_string (_tmp111_);
	g_variant_ref_sink (_tmp112_);
	_tmp113_ = _tmp112_;
	_tmp114_ = g_action_print_detailed_name (SCRATCH_MAIN_WINDOW_ACTION_PREFIX SCRATCH_MAIN_WINDOW_ACTION_CLOSE_PROJECT_DOCS, _tmp113_);
	_tmp115_ = _tmp114_;
	_tmp116_ = g_menu_item_new (_tmp105_, _tmp115_);
	_tmp117_ = _tmp116_;
	_g_free0 (_tmp115_);
	_g_variant_unref0 (_tmp113_);
	_g_free0 (_tmp111_);
	close_item = _tmp117_;
	_tmp118_ = g_strdup_printf (ngettext ("Hide %u Open Document", "Hide %u Open Documents", (gulong) n_open), n_open);
	hide_text = _tmp118_;
	_tmp119_ = hide_text;
	_tmp120_ = scratch_folder_manager_item_get_file ((ScratchFolderManagerItem*) self);
	_tmp121_ = _tmp120_;
	_tmp122_ = scratch_folder_manager_file_get_file (_tmp121_);
	_tmp123_ = _tmp122_;
	_tmp124_ = g_file_get_path (_tmp123_);
	_tmp125_ = _tmp124_;
	_tmp126_ = g_variant_new_string (_tmp125_);
	g_variant_ref_sink (_tmp126_);
	_tmp127_ = _tmp126_;
	_tmp128_ = g_action_print_detailed_name (SCRATCH_MAIN_WINDOW_ACTION_PREFIX SCRATCH_MAIN_WINDOW_ACTION_HIDE_PROJECT_DOCS, _tmp127_);
	_tmp129_ = _tmp128_;
	_tmp130_ = g_menu_item_new (_tmp119_, _tmp129_);
	_tmp131_ = _tmp130_;
	_g_free0 (_tmp129_);
	_g_variant_unref0 (_tmp127_);
	_g_free0 (_tmp125_);
	hide_item = _tmp131_;
	_tmp132_ = hide_item;
	_tmp133_ = _variant_new21 ("");
	_tmp134_ = g_action_print_detailed_name (SCRATCH_MAIN_WINDOW_ACTION_PREFIX SCRATCH_MAIN_WINDOW_ACTION_HIDE_PROJECT_DOCS, _tmp133_);
	_tmp135_ = _tmp134_;
	_tmp136_ = scratch_utils_get_accel_for_action (_tmp135_);
	_tmp137_ = _tmp136_;
	_tmp138_ = _variant_new22 (_tmp137_);
	g_menu_item_set_attribute_value (_tmp132_, "accel", _tmp138_);
	_g_variant_unref0 (_tmp138_);
	_g_free0 (_tmp137_);
	_g_free0 (_tmp135_);
	_g_variant_unref0 (_tmp133_);
	_tmp139_ = scratch_services_document_manager_get_instance ();
	_tmp140_ = _tmp139_;
	_tmp141_ = scratch_folder_manager_item_get_path ((ScratchFolderManagerItem*) self);
	_tmp142_ = _tmp141_;
	_tmp143_ = _tmp142_;
	_tmp144_ = scratch_services_document_manager_restorable_for_project (_tmp140_, _tmp143_);
	_g_free0 (_tmp143_);
	_g_object_unref0 (_tmp140_);
	n_restorable = _tmp144_;
	_tmp145_ = g_strdup_printf (ngettext ("Restore %u Hidden Document", "Restore %u Hidden Documents", (gulong) n_restorable), n_restorable);
	restore_text = _tmp145_;
	_tmp146_ = restore_text;
	_tmp147_ = scratch_folder_manager_item_get_file ((ScratchFolderManagerItem*) self);
	_tmp148_ = _tmp147_;
	_tmp149_ = scratch_folder_manager_file_get_file (_tmp148_);
	_tmp150_ = _tmp149_;
	_tmp151_ = g_file_get_path (_tmp150_);
	_tmp152_ = _tmp151_;
	_tmp153_ = g_variant_new_string (_tmp152_);
	g_variant_ref_sink (_tmp153_);
	_tmp154_ = _tmp153_;
	_tmp155_ = g_action_print_detailed_name (SCRATCH_MAIN_WINDOW_ACTION_PREFIX SCRATCH_MAIN_WINDOW_ACTION_RESTORE_PROJECT_DOCS, _tmp154_);
	_tmp156_ = _tmp155_;
	_tmp157_ = g_menu_item_new (_tmp146_, _tmp156_);
	_tmp158_ = _tmp157_;
	_g_free0 (_tmp156_);
	_g_variant_unref0 (_tmp154_);
	_g_free0 (_tmp152_);
	restore_item = _tmp158_;
	_tmp159_ = restore_item;
	_tmp160_ = _variant_new23 ("");
	_tmp161_ = g_action_print_detailed_name (SCRATCH_MAIN_WINDOW_ACTION_PREFIX SCRATCH_MAIN_WINDOW_ACTION_RESTORE_PROJECT_DOCS, _tmp160_);
	_tmp162_ = _tmp161_;
	_tmp163_ = scratch_utils_get_accel_for_action (_tmp162_);
	_tmp164_ = _tmp163_;
	_tmp165_ = _variant_new24 (_tmp164_);
	g_menu_item_set_attribute_value (_tmp159_, "accel", _tmp165_);
	_g_variant_unref0 (_tmp165_);
	_g_free0 (_tmp164_);
	_g_free0 (_tmp162_);
	_g_variant_unref0 (_tmp160_);
	_tmp166_ = g_menu_new ();
	direct_actions_section = _tmp166_;
	if (n_restorable > ((guint) 0)) {
		GMenu* _tmp167_;
		GMenuItem* _tmp168_;
		_tmp167_ = direct_actions_section;
		_tmp168_ = restore_item;
		g_menu_append_item (_tmp167_, _tmp168_);
	}
	if (n_open > ((guint) 0)) {
		GMenu* _tmp169_;
		GMenuItem* _tmp170_;
		GMenu* _tmp171_;
		GMenuItem* _tmp172_;
		_tmp169_ = direct_actions_section;
		_tmp170_ = hide_item;
		g_menu_append_item (_tmp169_, _tmp170_);
		_tmp171_ = direct_actions_section;
		_tmp172_ = close_item;
		g_menu_append_item (_tmp171_, _tmp172_);
	}
	_tmp173_ = scratch_folder_manager_item_get_file ((ScratchFolderManagerItem*) self);
	_tmp174_ = _tmp173_;
	_tmp175_ = scratch_folder_manager_file_get_file (_tmp174_);
	_tmp176_ = _tmp175_;
	_tmp177_ = g_file_get_path (_tmp176_);
	_tmp178_ = _tmp177_;
	_tmp179_ = g_variant_new_string (_tmp178_);
	g_variant_ref_sink (_tmp179_);
	_tmp180_ = _tmp179_;
	_tmp181_ = g_action_print_detailed_name (SCRATCH_MAIN_WINDOW_ACTION_PREFIX SCRATCH_MAIN_WINDOW_ACTION_FIND_GLOBAL, _tmp180_);
	_tmp182_ = _tmp181_;
	_tmp183_ = g_menu_item_new (_ ("Find in Project…"), _tmp182_);
	_tmp184_ = _tmp183_;
	_g_free0 (_tmp182_);
	_g_variant_unref0 (_tmp180_);
	_g_free0 (_tmp178_);
	search_item = _tmp184_;
	_tmp185_ = _variant_new25 ("");
	_tmp186_ = g_action_print_detailed_name (SCRATCH_MAIN_WINDOW_ACTION_PREFIX SCRATCH_MAIN_WINDOW_ACTION_FIND_GLOBAL, _tmp185_);
	_tmp187_ = _tmp186_;
	_tmp188_ = scratch_utils_get_accel_for_action (_tmp187_);
	_tmp189_ = _tmp188_;
	_tmp190_ = _variant_new26 (_tmp189_);
	g_menu_item_set_attribute_value (search_item, "accel", _tmp190_);
	_g_variant_unref0 (_tmp190_);
	_g_free0 (_tmp189_);
	_g_free0 (_tmp187_);
	_g_variant_unref0 (_tmp185_);
	_tmp191_ = g_menu_new ();
	search_actions_section = _tmp191_;
	g_menu_append_item (search_actions_section, search_item);
	_tmp192_ = g_menu_new ();
	menu_model = _tmp192_;
	_tmp193_ = external_actions_section;
	g_menu_append_section (menu_model, NULL, (GMenuModel*) _tmp193_);
	_tmp194_ = folder_actions_section;
	g_menu_append_section (menu_model, NULL, (GMenuModel*) _tmp194_);
	_tmp195_ = close_actions_section;
	g_menu_append_section (menu_model, NULL, (GMenuModel*) _tmp195_);
	_tmp196_ = direct_actions_section;
	g_menu_append_section (menu_model, NULL, (GMenuModel*) _tmp196_);
	g_menu_append_section (menu_model, NULL, (GMenuModel*) search_actions_section);
	_tmp197_ = (GtkMenu*) gtk_menu_new_from_model ((GMenuModel*) menu_model);
	g_object_ref_sink (_tmp197_);
	menu = _tmp197_;
	_tmp198_ = scratch_folder_manager_item_get_view ((ScratchFolderManagerItem*) self);
	_tmp199_ = _tmp198_;
	_tmp200_ = scratch_folder_manager_file_view_get_actions (_tmp199_);
	_tmp201_ = _tmp200_;
	gtk_widget_insert_action_group ((GtkWidget*) menu, SCRATCH_FOLDER_MANAGER_FILE_VIEW_ACTION_GROUP, (GActionGroup*) _tmp201_);
	result = menu;
	_g_object_unref0 (menu_model);
	_g_object_unref0 (search_actions_section);
	_g_object_unref0 (search_item);
	_g_object_unref0 (direct_actions_section);
	_g_object_unref0 (restore_item);
	_g_free0 (restore_text);
	_g_object_unref0 (hide_item);
	_g_free0 (hide_text);
	_g_object_unref0 (close_item);
	_g_free0 (open_text);
	_g_object_unref0 (close_actions_section);
	_g_object_unref0 (close_other_folders_action);
	_g_object_unref0 (close_all_except_item);
	_g_object_unref0 (close_folder_item);
	_g_object_unref0 (folder_actions_section);
	_g_object_unref0 (external_actions_section);
	_g_object_unref0 (set_active_folder_item);
	_g_free0 (file_type);
	return result;
}

static GVariant*
_variant_new27 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new28 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new29 (gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new30 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new31 (gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

GMenuItem*
scratch_folder_manager_project_folder_item_create_submenu_for_branch (ScratchFolderManagerProjectFolderItem* self)
{
	ScratchFolderManagerFileView* _tmp0_;
	ScratchFolderManagerFileView* _tmp1_;
	GSimpleActionGroup* _tmp2_;
	GSimpleActionGroup* _tmp3_;
	GSimpleAction* _tmp4_;
	ScratchFolderManagerFileView* _tmp5_;
	ScratchFolderManagerFileView* _tmp6_;
	GSimpleActionGroup* _tmp7_;
	GSimpleActionGroup* _tmp8_;
	GSimpleAction* _tmp9_;
	GList* local_branches = NULL;
	ScratchServicesMonitoredRepository* _tmp10_;
	GList* _tmp11_;
	GMenu* local_branch_submenu = NULL;
	GMenu* _tmp12_;
	GMenu* local_branch_menu = NULL;
	GMenu* _tmp13_;
	GList* _tmp14_;
	GList* remote_branches = NULL;
	ScratchServicesMonitoredRepository* _tmp24_;
	GList* _tmp25_;
	GMenu* remote_branch_submenu = NULL;
	GMenu* _tmp26_;
	GMenu* remote_branch_menu = NULL;
	GMenu* _tmp27_;
	GList* _tmp28_;
	GMenuItem* new_branch_item = NULL;
	ScratchFolderManagerFile* _tmp38_;
	ScratchFolderManagerFile* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	GVariant* _tmp43_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	GMenuItem* _tmp46_;
	GMenuItem* _tmp47_;
	GVariant* _tmp48_;
	gchar* _tmp49_;
	gchar* _tmp50_;
	gchar* _tmp51_;
	gchar* _tmp52_;
	GVariant* _tmp53_;
	GMenu* bottom_section = NULL;
	GMenu* _tmp54_;
	GMenu* menu = NULL;
	GMenu* _tmp55_;
	GMenu* _tmp56_;
	GMenu* _tmp57_;
	GMenuItem* menu_item = NULL;
	GMenuItem* _tmp58_;
	GMenuItem* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = scratch_folder_manager_item_get_view ((ScratchFolderManagerItem*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = scratch_folder_manager_file_view_get_actions (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->checkout_local_branch_action;
	g_action_map_add_action ((GActionMap*) _tmp3_, (GAction*) _tmp4_);
	_tmp5_ = scratch_folder_manager_item_get_view ((ScratchFolderManagerItem*) self);
	_tmp6_ = _tmp5_;
	_tmp7_ = scratch_folder_manager_file_view_get_actions (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = self->priv->checkout_remote_branch_action;
	g_action_map_add_action ((GActionMap*) _tmp8_, (GAction*) _tmp9_);
	_tmp10_ = self->priv->_monitored_repo;
	_tmp11_ = scratch_services_monitored_repository_get_local_branches (_tmp10_);
	local_branches = _tmp11_;
	_tmp12_ = g_menu_new ();
	local_branch_submenu = _tmp12_;
	_tmp13_ = g_menu_new ();
	local_branch_menu = _tmp13_;
	_tmp14_ = local_branches;
	if (g_list_length (_tmp14_) > ((guint) 0)) {
		GMenu* _tmp15_;
		GMenu* _tmp16_;
		GList* _tmp17_;
		_tmp15_ = local_branch_submenu;
		_tmp16_ = local_branch_menu;
		g_menu_append_submenu (_tmp15_, _ ("Local"), (GMenuModel*) _tmp16_);
		_tmp17_ = local_branches;
		{
			GList* branch_name_collection = NULL;
			GList* branch_name_it = NULL;
			branch_name_collection = _tmp17_;
			for (branch_name_it = branch_name_collection; branch_name_it != NULL; branch_name_it = branch_name_it->next) {
				const gchar* branch_name = NULL;
				branch_name = (const gchar*) branch_name_it->data;
				{
					GMenu* _tmp18_;
					const gchar* _tmp19_;
					const gchar* _tmp20_;
					GVariant* _tmp21_;
					gchar* _tmp22_;
					gchar* _tmp23_;
					_tmp18_ = local_branch_menu;
					_tmp19_ = branch_name;
					_tmp20_ = branch_name;
					_tmp21_ = _variant_new27 (_tmp20_);
					_tmp22_ = g_action_print_detailed_name (SCRATCH_FOLDER_MANAGER_FILE_VIEW_ACTION_PREFIX SCRATCH_FOLDER_MANAGER_FILE_VIEW_ACTION_CHECKOUT_LOCAL_BRANCH, _tmp21_);
					_tmp23_ = _tmp22_;
					g_menu_append (_tmp18_, _tmp19_, _tmp23_);
					_g_free0 (_tmp23_);
					_g_variant_unref0 (_tmp21_);
				}
			}
		}
	}
	_tmp24_ = self->priv->_monitored_repo;
	_tmp25_ = scratch_services_monitored_repository_get_remote_branches (_tmp24_);
	remote_branches = _tmp25_;
	_tmp26_ = g_menu_new ();
	remote_branch_submenu = _tmp26_;
	_tmp27_ = g_menu_new ();
	remote_branch_menu = _tmp27_;
	_tmp28_ = remote_branches;
	if (g_list_length (_tmp28_) > ((guint) 0)) {
		GMenu* _tmp29_;
		GMenu* _tmp30_;
		GList* _tmp31_;
		_tmp29_ = remote_branch_submenu;
		_tmp30_ = remote_branch_menu;
		g_menu_append_submenu (_tmp29_, _ ("Remote"), (GMenuModel*) _tmp30_);
		_tmp31_ = remote_branches;
		{
			GList* branch_name_collection = NULL;
			GList* branch_name_it = NULL;
			branch_name_collection = _tmp31_;
			for (branch_name_it = branch_name_collection; branch_name_it != NULL; branch_name_it = branch_name_it->next) {
				const gchar* branch_name = NULL;
				branch_name = (const gchar*) branch_name_it->data;
				{
					GMenu* _tmp32_;
					const gchar* _tmp33_;
					const gchar* _tmp34_;
					GVariant* _tmp35_;
					gchar* _tmp36_;
					gchar* _tmp37_;
					_tmp32_ = remote_branch_menu;
					_tmp33_ = branch_name;
					_tmp34_ = branch_name;
					_tmp35_ = _variant_new28 (_tmp34_);
					_tmp36_ = g_action_print_detailed_name (SCRATCH_FOLDER_MANAGER_FILE_VIEW_ACTION_PREFIX SCRATCH_FOLDER_MANAGER_FILE_VIEW_ACTION_CHECKOUT_REMOTE_BRANCH, _tmp35_);
					_tmp37_ = _tmp36_;
					g_menu_append (_tmp32_, _tmp33_, _tmp37_);
					_g_free0 (_tmp37_);
					_g_variant_unref0 (_tmp35_);
				}
			}
		}
	}
	_tmp38_ = scratch_folder_manager_item_get_file ((ScratchFolderManagerItem*) self);
	_tmp39_ = _tmp38_;
	_tmp40_ = scratch_folder_manager_file_get_path (_tmp39_);
	_tmp41_ = _tmp40_;
	_tmp42_ = _tmp41_;
	_tmp43_ = _variant_new29 (_tmp42_);
	_tmp44_ = g_action_print_detailed_name (SCRATCH_MAIN_WINDOW_ACTION_PREFIX SCRATCH_MAIN_WINDOW_ACTION_NEW_BRANCH, _tmp43_);
	_tmp45_ = _tmp44_;
	_tmp46_ = g_menu_item_new (_ ("New Branch…"), _tmp45_);
	_tmp47_ = _tmp46_;
	_g_free0 (_tmp45_);
	_g_variant_unref0 (_tmp43_);
	_g_free0 (_tmp42_);
	new_branch_item = _tmp47_;
	_tmp48_ = _variant_new30 ("");
	_tmp49_ = g_action_print_detailed_name (SCRATCH_MAIN_WINDOW_ACTION_PREFIX SCRATCH_MAIN_WINDOW_ACTION_NEW_BRANCH, _tmp48_);
	_tmp50_ = _tmp49_;
	_tmp51_ = scratch_utils_get_accel_for_action (_tmp50_);
	_tmp52_ = _tmp51_;
	_tmp53_ = _variant_new31 (_tmp52_);
	g_menu_item_set_attribute_value (new_branch_item, "accel", _tmp53_);
	_g_variant_unref0 (_tmp53_);
	_g_free0 (_tmp52_);
	_g_free0 (_tmp50_);
	_g_variant_unref0 (_tmp48_);
	_tmp54_ = g_menu_new ();
	bottom_section = _tmp54_;
	g_menu_append_item (bottom_section, new_branch_item);
	_tmp55_ = g_menu_new ();
	menu = _tmp55_;
	_tmp56_ = local_branch_submenu;
	g_menu_append_section (menu, NULL, (GMenuModel*) _tmp56_);
	_tmp57_ = remote_branch_submenu;
	g_menu_append_section (menu, NULL, (GMenuModel*) _tmp57_);
	g_menu_append_section (menu, NULL, (GMenuModel*) bottom_section);
	_tmp58_ = g_menu_item_new_submenu (_ ("Branch"), (GMenuModel*) menu);
	menu_item = _tmp58_;
	result = menu_item;
	_g_object_unref0 (menu);
	_g_object_unref0 (bottom_section);
	_g_object_unref0 (new_branch_item);
	_g_object_unref0 (remote_branch_menu);
	_g_object_unref0 (remote_branch_submenu);
	_g_object_unref0 (local_branch_menu);
	_g_object_unref0 (local_branch_submenu);
	return result;
}

static void
scratch_folder_manager_project_folder_item_handle_checkout_local_branch_action (ScratchFolderManagerProjectFolderItem* self,
                                                                                GVariant* param)
{
	const gchar* _tmp0_ = NULL;
	gchar* branch_name = NULL;
	gchar* _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	if (param != NULL) {
		const gchar* _tmp1_;
		_tmp1_ = g_variant_get_string (param, NULL);
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = "";
	}
	_tmp2_ = g_strdup (_tmp0_);
	branch_name = _tmp2_;
	{
		ScratchServicesMonitoredRepository* _tmp3_;
		_tmp3_ = self->priv->_monitored_repo;
		scratch_services_monitored_repository_change_local_branch (_tmp3_, branch_name, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("ProjectFolderItem.vala:386: Failed to change branch to %s. %s", branch_name, _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (branch_name);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (branch_name);
}

static void
scratch_folder_manager_project_folder_item_handle_checkout_remote_branch_action (ScratchFolderManagerProjectFolderItem* self,
                                                                                 GVariant* param)
{
	const gchar* _tmp0_ = NULL;
	gchar* branch_name = NULL;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	if (param != NULL) {
		const gchar* _tmp1_;
		_tmp1_ = g_variant_get_string (param, NULL);
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = "";
	}
	_tmp2_ = g_strdup (_tmp0_);
	branch_name = _tmp2_;
	_tmp3_ = branch_name;
	if (g_strcmp0 (_tmp3_, "") == 0) {
		_g_free0 (branch_name);
		return;
	}
	{
		ScratchServicesMonitoredRepository* _tmp4_;
		const gchar* _tmp5_;
		_tmp4_ = self->priv->_monitored_repo;
		_tmp5_ = branch_name;
		scratch_services_monitored_repository_checkout_remote_branch (_tmp4_, _tmp5_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp6_;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = branch_name;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_warning ("ProjectFolderItem.vala:399: Failed to change branch to %s. %s", _tmp6_, _tmp8_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (branch_name);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (branch_name);
}

static Block22Data*
block22_data_ref (Block22Data* _data22_)
{
	g_atomic_int_inc (&_data22_->_ref_count_);
	return _data22_;
}

static void
block22_data_unref (void * _userdata_)
{
	Block22Data* _data22_;
	_data22_ = (Block22Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data22_->_ref_count_)) {
		ScratchFolderManagerProjectFolderItem* self;
		self = _data22_->self;
		_g_free0 (_data22_->start_path);
		_g_object_unref0 (self);
		g_slice_free (Block22Data, _data22_);
	}
}

static Block23Data*
block23_data_ref (Block23Data* _data23_)
{
	g_atomic_int_inc (&_data23_->_ref_count_);
	return _data23_;
}

static void
block23_data_unref (void * _userdata_)
{
	Block23Data* _data23_;
	_data23_ = (Block23Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data23_->_ref_count_)) {
		ScratchFolderManagerProjectFolderItem* self;
		self = _data23_->_data22_->self;
		_g_object_unref0 (_data23_->item);
		_scratch_folder_manager_project_folder_item_visible_item_free0 (_data23_->visible_item);
		block22_data_unref (_data23_->_data22_);
		_data23_->_data22_ = NULL;
		g_slice_free (Block23Data, _data23_);
	}
}

static gboolean
__lambda83_ (Block23Data* _data23_,
             GeeMapEntry* entry)
{
	Block22Data* _data22_;
	ScratchFolderManagerProjectFolderItem* self;
	gboolean match = FALSE;
	gconstpointer _tmp0_;
	gconstpointer _tmp1_;
	const gchar* _tmp2_;
	gboolean result;
	_data22_ = _data23_->_data22_;
	self = _data22_->self;
	g_return_val_if_fail (entry != NULL, FALSE);
	_tmp0_ = gee_map_entry_get_key (entry);
	_tmp1_ = _tmp0_;
	_tmp2_ = (*_data23_->visible_item).rel_path;
	match = g_str_has_prefix ((const gchar*) _tmp1_, _tmp2_);
	if (match) {
		gconstpointer _tmp3_;
		gconstpointer _tmp4_;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		ScratchFolderManagerItem* _tmp7_;
		gboolean _tmp14_ = FALSE;
		ScratchFolderManagerItem* _tmp15_;
		_tmp3_ = gee_map_entry_get_value (entry);
		_tmp4_ = _tmp3_;
		_data22_->is_new = ((*((GgitStatusFlags*) _tmp4_)) & (GGIT_STATUS_WORKING_TREE_NEW | GGIT_STATUS_INDEX_NEW)) > 0;
		_tmp7_ = _data23_->item;
		if (SCRATCH_FOLDER_MANAGER_IS_FOLDER_ITEM (_tmp7_)) {
			_tmp6_ = _data22_->is_new;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			ScratchFolderManagerItem* _tmp8_;
			GIcon* _tmp9_;
			GIcon* _tmp10_;
			_tmp8_ = _data23_->item;
			_tmp9_ = code_widgets_source_list_item_get_activatable ((CodeWidgetsSourceListItem*) _tmp8_);
			_tmp10_ = _tmp9_;
			_tmp5_ = _tmp10_ == NULL;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			ScratchFolderManagerItem* _tmp11_;
			GIcon* _tmp12_;
			ScratchFolderManagerItem* _tmp13_;
			_tmp11_ = _data23_->item;
			_tmp12_ = scratch_folder_manager_project_folder_item_added_icon;
			code_widgets_source_list_item_set_activatable ((CodeWidgetsSourceListItem*) _tmp11_, _tmp12_);
			_tmp13_ = _data23_->item;
			code_widgets_source_list_item_set_activatable_tooltip ((CodeWidgetsSourceListItem*) _tmp13_, _ ("New"));
			result = TRUE;
			_g_object_unref0 (entry);
			return result;
		}
		_tmp15_ = _data23_->item;
		if (!SCRATCH_FOLDER_MANAGER_IS_FOLDER_ITEM (_tmp15_)) {
			_tmp14_ = TRUE;
		} else {
			ScratchFolderManagerItem* _tmp16_;
			gboolean _tmp17_;
			gboolean _tmp18_;
			_tmp16_ = _data23_->item;
			_tmp17_ = code_widgets_source_list_expandable_item_get_expanded ((CodeWidgetsSourceListExpandableItem*) _tmp16_);
			_tmp18_ = _tmp17_;
			_tmp14_ = !_tmp18_;
		}
		if (_tmp14_) {
			GIcon* _tmp19_ = NULL;
			ScratchFolderManagerItem* _tmp22_;
			const gchar* _tmp23_ = NULL;
			ScratchFolderManagerItem* _tmp24_;
			if (_data22_->is_new) {
				GIcon* _tmp20_;
				_tmp20_ = scratch_folder_manager_project_folder_item_added_icon;
				_tmp19_ = _tmp20_;
			} else {
				GIcon* _tmp21_;
				_tmp21_ = scratch_folder_manager_project_folder_item_modified_icon;
				_tmp19_ = _tmp21_;
			}
			_tmp22_ = _data23_->item;
			code_widgets_source_list_item_set_activatable ((CodeWidgetsSourceListItem*) _tmp22_, _tmp19_);
			if (_data22_->is_new) {
				_tmp23_ = _ ("New");
			} else {
				_tmp23_ = _ ("Modified");
			}
			_tmp24_ = _data23_->item;
			code_widgets_source_list_item_set_activatable_tooltip ((CodeWidgetsSourceListItem*) _tmp24_, _tmp23_);
		}
		result = FALSE;
		_g_object_unref0 (entry);
		return result;
	} else {
		result = TRUE;
		_g_object_unref0 (entry);
		return result;
	}
}

static gboolean
___lambda83__gee_forall_func (gpointer g,
                              gpointer self)
{
	gboolean result;
	result = __lambda83_ (self, (GeeMapEntry*) g);
	return result;
}

static void
__lambda82_ (Block22Data* _data22_,
             ScratchFolderManagerProjectFolderItemVisibleItem* visible_item)
{
	ScratchFolderManagerProjectFolderItem* self;
	Block23Data* _data23_;
	ScratchFolderManagerProjectFolderItemVisibleItem* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	ScratchFolderManagerItem* _tmp3_;
	ScratchFolderManagerItem* _tmp4_;
	ScratchFolderManagerItem* _tmp5_;
	ScratchServicesMonitoredRepository* _tmp6_;
	GeeSet* _tmp7_;
	GeeSet* _tmp8_;
	GeeSet* _tmp9_;
	self = _data22_->self;
	_data23_ = g_slice_new0 (Block23Data);
	_data23_->_ref_count_ = 1;
	_data23_->_data22_ = block22_data_ref (_data22_);
	_tmp0_ = _scratch_folder_manager_project_folder_item_visible_item_dup0 (visible_item);
	_scratch_folder_manager_project_folder_item_visible_item_free0 (_data23_->visible_item);
	_data23_->visible_item = _tmp0_;
	_tmp1_ = _data22_->start_path;
	_tmp2_ = (*_data23_->visible_item).rel_path;
	if (g_str_has_prefix (_tmp1_, _tmp2_)) {
		block23_data_unref (_data23_);
		_data23_ = NULL;
		return;
	}
	_tmp3_ = (*_data23_->visible_item).item;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_data23_->item = _tmp4_;
	_tmp5_ = _data23_->item;
	code_widgets_source_list_item_set_activatable ((CodeWidgetsSourceListItem*) _tmp5_, NULL);
	_tmp6_ = self->priv->_monitored_repo;
	_tmp7_ = scratch_services_monitored_repository_get_non_current_entries (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _tmp8_;
	gee_traversable_foreach ((GeeTraversable*) _tmp9_, ___lambda83__gee_forall_func, _data23_);
	_g_object_unref0 (_tmp9_);
	block23_data_unref (_data23_);
	_data23_ = NULL;
}

static void
___lambda82__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda82_ (self, (ScratchFolderManagerProjectFolderItemVisibleItem*) data);
}

void
scratch_folder_manager_project_folder_item_update_item_status (ScratchFolderManagerProjectFolderItem* self,
                                                               ScratchFolderManagerFolderItem* start_folder)
{
	Block22Data* _data22_;
	ScratchServicesMonitoredRepository* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp5_;
	GList* _tmp6_;
	g_return_if_fail (self != NULL);
	_data22_ = g_slice_new0 (Block22Data);
	_data22_->_ref_count_ = 1;
	_data22_->self = g_object_ref (self);
	_tmp0_ = self->priv->_monitored_repo;
	if (_tmp0_ == NULL) {
		g_debug ("ProjectFolderItem.vala:405: Ignore non-git folders");
		block22_data_unref (_data22_);
		_data22_ = NULL;
		return;
	}
	_data22_->is_new = FALSE;
	if (start_folder != NULL) {
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = scratch_folder_manager_item_get_path ((ScratchFolderManagerItem*) start_folder);
		_tmp3_ = _tmp2_;
		_g_free0 (_tmp1_);
		_tmp1_ = _tmp3_;
	} else {
		gchar* _tmp4_;
		_tmp4_ = g_strdup ("");
		_g_free0 (_tmp1_);
		_tmp1_ = _tmp4_;
	}
	_tmp5_ = g_strdup (_tmp1_);
	_data22_->start_path = _tmp5_;
	_tmp6_ = self->priv->visible_item_list;
	g_list_foreach (_tmp6_, ___lambda82__gfunc, _data22_);
	_g_free0 (_tmp1_);
	block22_data_unref (_data22_);
	_data22_ = NULL;
}

gboolean
scratch_folder_manager_project_folder_item_contains_file (ScratchFolderManagerProjectFolderItem* self,
                                                          GFile* descendant)
{
	ScratchFolderManagerFile* _tmp0_;
	ScratchFolderManagerFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (descendant != NULL, FALSE);
	_tmp0_ = scratch_folder_manager_item_get_file ((ScratchFolderManagerItem*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = scratch_folder_manager_file_get_file (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_file_get_relative_path (_tmp3_, descendant);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_ != NULL;
	_g_free0 (_tmp5_);
	result = _tmp6_;
	return result;
}

static void
__lambda84_ (ScratchFolderManagerProjectFolderItem* self,
             ScratchFolderManagerProjectFolderItemVisibleItem* visible_item)
{
	ScratchFolderManagerItem* item = NULL;
	ScratchFolderManagerItem* _tmp0_;
	ScratchFolderManagerItem* _tmp1_;
	GError* _inner_error0_ = NULL;
	_tmp0_ = (*visible_item).item;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	item = _tmp1_;
	{
		gboolean _tmp2_ = FALSE;
		ScratchServicesMonitoredRepository* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = self->priv->_monitored_repo;
		_tmp4_ = (*visible_item).rel_path;
		_tmp2_ = scratch_services_monitored_repository_path_is_ignored (_tmp3_, _tmp4_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		if (_tmp2_) {
			const gchar* _tmp5_;
			const gchar* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp5_ = code_widgets_source_list_item_get_name ((CodeWidgetsSourceListItem*) item);
			_tmp6_ = _tmp5_;
			_tmp7_ = g_markup_printf_escaped ("<span fgalpha='75&#37;'><i>%s</i></span>", _tmp6_);
			_tmp8_ = _tmp7_;
			code_widgets_source_list_item_set_markup ((CodeWidgetsSourceListItem*) item, _tmp8_);
			_g_free0 (_tmp8_);
		} else {
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			_tmp9_ = code_widgets_source_list_item_get_name ((CodeWidgetsSourceListItem*) item);
			_tmp10_ = _tmp9_;
			code_widgets_source_list_item_set_markup ((CodeWidgetsSourceListItem*) item, _tmp10_);
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		GError* _tmp13_;
		const gchar* _tmp14_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp11_ = code_widgets_source_list_item_get_name ((CodeWidgetsSourceListItem*) item);
		_tmp12_ = _tmp11_;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		g_warning ("ProjectFolderItem.vala:457: An error occurred while checking if item '" \
"%s' is git-ignored: %s", _tmp12_, _tmp14_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (item);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (item);
}

static void
___lambda84__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda84_ ((ScratchFolderManagerProjectFolderItem*) self, (ScratchFolderManagerProjectFolderItemVisibleItem*) data);
}

static void
scratch_folder_manager_project_folder_item_deprioritize_git_ignored (ScratchFolderManagerProjectFolderItem* self)
{
	ScratchServicesMonitoredRepository* _tmp0_;
	GList* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_monitored_repo;
	_vala_return_if_fail (_tmp0_ != NULL, "monitored_repo != null");
	_tmp1_ = self->priv->visible_item_list;
	g_list_foreach (_tmp1_, ___lambda84__gfunc, self);
}

static Block24Data*
block24_data_ref (Block24Data* _data24_)
{
	g_atomic_int_inc (&_data24_->_ref_count_);
	return _data24_;
}

static void
block24_data_unref (void * _userdata_)
{
	Block24Data* _data24_;
	_data24_ = (Block24Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data24_->_ref_count_)) {
		ScratchFolderManagerProjectFolderItem* self;
		self = _data24_->self;
		_g_object_unref0 (_data24_->dialog);
		_g_object_unref0 (self);
		g_slice_free (Block24Data, _data24_);
	}
}

static void
___lambda100_ (Block24Data* _data24_)
{
	ScratchFolderManagerProjectFolderItem* self;
	GraniteMessageDialog* _tmp0_;
	self = _data24_->self;
	_tmp0_ = _data24_->dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
}

static void
____lambda100__gtk_dialog_response (GtkDialog* _sender,
                                    gint response_id,
                                    gpointer self)
{
	___lambda100_ (self);
}

void
scratch_folder_manager_project_folder_item_new_branch (ScratchFolderManagerProjectFolderItem* self,
                                                       const gchar* branch_name)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (branch_name != NULL);
	{
		ScratchServicesMonitoredRepository* _tmp0_;
		gboolean _tmp1_;
		gboolean _tmp2_;
		_tmp0_ = self->priv->_monitored_repo;
		_tmp1_ = scratch_services_monitored_repository_get_head_is_branch (_tmp0_);
		_tmp2_ = _tmp1_;
		if (_tmp2_) {
			ScratchServicesMonitoredRepository* _tmp3_;
			_tmp3_ = self->priv->_monitored_repo;
			scratch_services_monitored_repository_create_new_branch (_tmp3_, branch_name, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		} else {
			GError* _tmp4_;
			_tmp4_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_NOT_FOUND, "Cannot create a new branch when head is detached");
			_inner_error0_ = _tmp4_;
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		Block24Data* _data24_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		GError* _tmp7_;
		const gchar* _tmp8_;
		GThemedIcon* _tmp9_;
		GThemedIcon* _tmp10_;
		GThemedIcon* _tmp11_;
		GraniteMessageDialog* _tmp12_ = NULL;
		GraniteMessageDialog* _tmp13_;
		GraniteMessageDialog* _tmp14_;
		ScratchFolderManagerFileView* _tmp15_;
		ScratchFolderManagerFileView* _tmp16_;
		GtkWidget* _tmp17_;
		GraniteMessageDialog* _tmp18_;
		GraniteMessageDialog* _tmp19_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_data24_ = g_slice_new0 (Block24Data);
		_data24_->_ref_count_ = 1;
		_data24_->self = g_object_ref (self);
		_tmp5_ = g_strdup_printf (_ ("Error while creating new branch: “%s”"), branch_name);
		_tmp6_ = _tmp5_;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		_tmp9_ = (GThemedIcon*) g_themed_icon_new ("git");
		_tmp10_ = _tmp9_;
		_tmp11_ = (GThemedIcon*) g_themed_icon_new ("dialog-error");
		_tmp12_ = granite_message_dialog_new (_tmp6_, _tmp8_, (GIcon*) _tmp10_, GTK_BUTTONS_CLOSE);
		granite_message_dialog_set_badge_icon (_tmp12_, (GIcon*) _tmp11_);
		_g_object_unref0 (_tmp11_);
		g_object_ref_sink (_tmp12_);
		_tmp13_ = _tmp12_;
		_g_object_unref0 (_tmp10_);
		_g_free0 (_tmp6_);
		_data24_->dialog = _tmp13_;
		_tmp14_ = _data24_->dialog;
		_tmp15_ = scratch_folder_manager_item_get_view ((ScratchFolderManagerItem*) self);
		_tmp16_ = _tmp15_;
		_tmp17_ = gtk_widget_get_toplevel ((GtkWidget*) _tmp16_);
		gtk_window_set_transient_for ((GtkWindow*) _tmp14_, G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_window_get_type (), GtkWindow));
		_tmp18_ = _data24_->dialog;
		g_signal_connect_data ((GtkDialog*) _tmp18_, "response", (GCallback) ____lambda100__gtk_dialog_response, block24_data_ref (_data24_), (GClosureNotify) block24_data_unref, 0);
		_tmp19_ = _data24_->dialog;
		gtk_dialog_run ((GtkDialog*) _tmp19_);
		_g_error_free0 (e);
		block24_data_unref (_data24_);
		_data24_ = NULL;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

GList*
scratch_folder_manager_project_folder_item_get_branch_names (ScratchFolderManagerProjectFolderItem* self)
{
	GList* _tmp0_ = NULL;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = scratch_folder_manager_project_folder_item_get_is_git_repo (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		ScratchServicesMonitoredRepository* _tmp3_;
		GList* _tmp4_;
		_tmp3_ = self->priv->_monitored_repo;
		_tmp4_ = scratch_services_monitored_repository_get_local_branches (_tmp3_);
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = NULL;
	}
	result = _tmp0_;
	return result;
}

gboolean
scratch_folder_manager_project_folder_item_has_local_branch_name (ScratchFolderManagerProjectFolderItem* self,
                                                                  const gchar* name)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp1_ = scratch_folder_manager_project_folder_item_get_is_git_repo (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		ScratchServicesMonitoredRepository* _tmp3_;
		_tmp3_ = self->priv->_monitored_repo;
		_tmp0_ = scratch_services_monitored_repository_has_local_branch_name (_tmp3_, name);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

gchar*
scratch_folder_manager_project_folder_item_get_current_branch_name (ScratchFolderManagerProjectFolderItem* self)
{
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gchar* _tmp6_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = scratch_folder_manager_project_folder_item_get_is_git_repo (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		ScratchServicesMonitoredRepository* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		_tmp3_ = self->priv->_monitored_repo;
		_tmp4_ = scratch_services_monitored_repository_get_branch_name (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp0_ = _tmp5_;
	} else {
		_tmp0_ = "";
	}
	_tmp6_ = g_strdup (_tmp0_);
	result = _tmp6_;
	return result;
}

gboolean
scratch_folder_manager_project_folder_item_is_valid_new_branch_name (ScratchFolderManagerProjectFolderItem* self,
                                                                     const gchar* new_name)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (new_name != NULL, FALSE);
	_tmp1_ = scratch_folder_manager_project_folder_item_get_is_git_repo (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		ScratchServicesMonitoredRepository* _tmp3_;
		_tmp3_ = self->priv->_monitored_repo;
		_tmp0_ = scratch_services_monitored_repository_is_valid_new_local_branch_name (_tmp3_, new_name);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static Block25Data*
block25_data_ref (Block25Data* _data25_)
{
	g_atomic_int_inc (&_data25_->_ref_count_);
	return _data25_;
}

static void
block25_data_unref (void * _userdata_)
{
	Block25Data* _data25_;
	_data25_ = (Block25Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data25_->_ref_count_)) {
		ScratchFolderManagerProjectFolderItem* self;
		self = _data25_->self;
		_g_object_unref0 (_data25_->dialog);
		_g_regex_unref0 (_data25_->pattern);
		_g_free0 (_data25_->search_term);
		_g_object_unref0 (_data25_->start_folder);
		_g_free0 (_data25_->term);
		_g_object_unref0 (self);
		g_slice_free (Block25Data, _data25_);
	}
}

static void
__lambda97_ (Block25Data* _data25_,
             gint response)
{
	ScratchFolderManagerProjectFolderItem* self;
	ScratchDialogsGlobalSearchDialog* _tmp5_;
	self = _data25_->self;
	switch (response) {
		case GTK_RESPONSE_ACCEPT:
		{
			ScratchDialogsGlobalSearchDialog* _tmp0_;
			const gchar* _tmp1_;
			const gchar* _tmp2_;
			gchar* _tmp3_;
			_tmp0_ = _data25_->dialog;
			_tmp1_ = scratch_dialogs_global_search_dialog_get_search_term (_tmp0_);
			_tmp2_ = _tmp1_;
			_tmp3_ = g_strdup (_tmp2_);
			_g_free0 (_data25_->search_term);
			_data25_->search_term = _tmp3_;
			break;
		}
		default:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup (NULL);
			_g_free0 (_data25_->term);
			_data25_->term = _tmp4_;
			break;
		}
	}
	_tmp5_ = _data25_->dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp5_);
}

static void
___lambda97__gtk_dialog_response (GtkDialog* _sender,
                                  gint response_id,
                                  gpointer self)
{
	__lambda97_ (self, response_id);
}

static gint
____lambda98_ (Block25Data* _data25_,
               const gchar* rel_path,
               GgitStatusFlags status)
{
	ScratchFolderManagerProjectFolderItem* self;
	GFile* target = NULL;
	ScratchFolderManagerFile* _tmp0_;
	ScratchFolderManagerFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gint result;
	self = _data25_->self;
	g_return_val_if_fail (rel_path != NULL, 0);
	_tmp0_ = scratch_folder_manager_item_get_file ((ScratchFolderManagerItem*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = scratch_folder_manager_file_get_file (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_file_resolve_relative_path (_tmp3_, rel_path);
	target = _tmp4_;
	if (_data25_->check_is_text) {
		_tmp5_ = g_str_has_prefix (rel_path, "po/");
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		result = 0;
		_g_object_unref0 (target);
		return result;
	}
	if (_data25_->recurse_subfolders) {
		GFile* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp8_ = target;
		_tmp9_ = g_file_get_relative_path (_data25_->start_folder, _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp7_ = _tmp10_ != NULL;
		_g_free0 (_tmp10_);
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		_tmp6_ = TRUE;
	} else {
		GFile* _tmp11_;
		GFile* _tmp12_;
		GFile* _tmp13_;
		_tmp11_ = target;
		_tmp12_ = g_file_get_parent (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp6_ = g_file_equal (_data25_->start_folder, _tmp13_);
		_g_object_unref0 (_tmp13_);
	}
	if (_tmp6_) {
		GFile* _tmp14_;
		GRegex* _tmp15_;
		_tmp14_ = target;
		_tmp15_ = _data25_->pattern;
		scratch_folder_manager_project_folder_item_perform_match (self, _tmp14_, _tmp15_, _data25_->check_is_text, NULL);
	}
	result = 0;
	_g_object_unref0 (target);
	return result;
}

static gint
_____lambda98__ggit_status_callback (const gchar* path,
                                     GgitStatusFlags status_flags,
                                     gpointer self)
{
	gint result;
	result = ____lambda98_ (self, path, status_flags);
	return result;
}

static void
_vala_GgitStatusOptions_free (GgitStatusOptions* self)
{
	g_boxed_free (ggit_status_options_get_type (), self);
}

void
scratch_folder_manager_project_folder_item_global_search (ScratchFolderManagerProjectFolderItem* self,
                                                          GFile* start_folder,
                                                          const gchar* term,
                                                          gboolean is_explicit)
{
	Block25Data* _data25_;
	GFile* _tmp0_;
	gchar* _tmp1_;
	gboolean search_tracked_only = FALSE;
	gchar** path_spec = NULL;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gint path_spec_length1;
	gint _path_spec_size_;
	gboolean modified_only = FALSE;
	gboolean case_sensitive = FALSE;
	gboolean wholeword_search = FALSE;
	GSettings* _tmp4_;
	ScratchCaseSensitiveMode case_mode = 0;
	GSettings* _tmp5_;
	gboolean use_regex = FALSE;
	GSettings* _tmp6_;
	gchar* folder_name = NULL;
	gchar* _tmp13_;
	ScratchFolderManagerFile* _tmp14_;
	ScratchFolderManagerFile* _tmp15_;
	GFile* _tmp16_;
	GFile* _tmp17_;
	gboolean _tmp21_ = FALSE;
	ScratchServicesMonitoredRepository* _tmp22_;
	const gchar* _tmp26_;
	gchar* _tmp27_;
	ScratchDialogsGlobalSearchDialog* _tmp28_ = NULL;
	ScratchDialogsGlobalSearchDialog* _tmp29_;
	ScratchDialogsGlobalSearchDialog* _tmp30_;
	const gchar* _tmp31_;
	GgitStatusOption status_scope = 0U;
	GgitStatusOptions* status_options = NULL;
	gchar** _tmp53_;
	gint _tmp53__length1;
	GgitStatusOptions* _tmp54_;
	gboolean _tmp55_ = FALSE;
	ScratchServicesMonitoredRepository* _tmp56_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (start_folder != NULL);
	_data25_ = g_slice_new0 (Block25Data);
	_data25_->_ref_count_ = 1;
	_data25_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (start_folder);
	_g_object_unref0 (_data25_->start_folder);
	_data25_->start_folder = _tmp0_;
	_tmp1_ = g_strdup (term);
	_g_free0 (_data25_->term);
	_data25_->term = _tmp1_;
	_data25_->search_term = NULL;
	search_tracked_only = FALSE;
	_data25_->recurse_subfolders = TRUE;
	_data25_->check_is_text = TRUE;
	_tmp2_ = g_strdup ("*.*");
	_tmp3_ = g_new0 (gchar*, 1 + 1);
	_tmp3_[0] = _tmp2_;
	path_spec = _tmp3_;
	path_spec_length1 = 1;
	_path_spec_size_ = path_spec_length1;
	modified_only = FALSE;
	case_sensitive = FALSE;
	_data25_->pattern = NULL;
	_tmp4_ = scratch_settings;
	wholeword_search = g_settings_get_boolean (_tmp4_, "wholeword-search");
	_tmp5_ = scratch_settings;
	case_mode = (ScratchCaseSensitiveMode) g_settings_get_enum (_tmp5_, "case-sensitive-search");
	_tmp6_ = scratch_settings;
	use_regex = g_settings_get_boolean (_tmp6_, "regex-search");
	switch (case_mode) {
		case SCRATCH_CASE_SENSITIVE_MODE_NEVER:
		{
			case_sensitive = FALSE;
			break;
		}
		case SCRATCH_CASE_SENSITIVE_MODE_MIXED:
		{
			gboolean _tmp7_ = FALSE;
			gchar* _tmp8_;
			gchar* _tmp9_;
			gboolean _tmp10_;
			_tmp8_ = g_ascii_strup (_data25_->term, (gssize) -1);
			_tmp9_ = _tmp8_;
			_tmp10_ = g_strcmp0 (_data25_->term, _tmp9_) != 0;
			_g_free0 (_tmp9_);
			if (_tmp10_) {
				gchar* _tmp11_;
				gchar* _tmp12_;
				_tmp11_ = g_ascii_strdown (_data25_->term, (gssize) -1);
				_tmp12_ = _tmp11_;
				_tmp7_ = g_strcmp0 (_data25_->term, _tmp12_) != 0;
				_g_free0 (_tmp12_);
			} else {
				_tmp7_ = FALSE;
			}
			case_sensitive = _tmp7_;
			break;
		}
		case SCRATCH_CASE_SENSITIVE_MODE_ALWAYS:
		{
			case_sensitive = TRUE;
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_tmp13_ = g_file_get_basename (_data25_->start_folder);
	folder_name = _tmp13_;
	_tmp14_ = scratch_folder_manager_item_get_file ((ScratchFolderManagerItem*) self);
	_tmp15_ = _tmp14_;
	_tmp16_ = scratch_folder_manager_file_get_file (_tmp15_);
	_tmp17_ = _tmp16_;
	if (g_file_equal (_tmp17_, _data25_->start_folder)) {
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		gchar* _tmp20_;
		_tmp18_ = code_widgets_source_list_item_get_name ((CodeWidgetsSourceListItem*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = g_strdup (_tmp19_);
		_g_free0 (folder_name);
		folder_name = _tmp20_;
	}
	_tmp22_ = self->priv->_monitored_repo;
	if (_tmp22_ != NULL) {
		ScratchServicesMonitoredRepository* _tmp23_;
		GgitRepository* _tmp24_;
		GgitRepository* _tmp25_;
		_tmp23_ = self->priv->_monitored_repo;
		_tmp24_ = scratch_services_monitored_repository_get_git_repo (_tmp23_);
		_tmp25_ = _tmp24_;
		_tmp21_ = _tmp25_ != NULL;
	} else {
		_tmp21_ = FALSE;
	}
	_tmp26_ = folder_name;
	_tmp27_ = g_strdup (_data25_->term);
	_tmp28_ = scratch_dialogs_global_search_dialog_new (_tmp26_, _tmp21_, case_sensitive, wholeword_search, use_regex);
	scratch_dialogs_global_search_dialog_set_search_term (_tmp28_, _tmp27_);
	_g_free0 (_tmp27_);
	g_object_ref_sink (_tmp28_);
	_data25_->dialog = _tmp28_;
	_tmp29_ = _data25_->dialog;
	g_signal_connect_data ((GtkDialog*) _tmp29_, "response", (GCallback) ___lambda97__gtk_dialog_response, block25_data_ref (_data25_), (GClosureNotify) block25_data_unref, 0);
	_tmp30_ = _data25_->dialog;
	gtk_dialog_run ((GtkDialog*) _tmp30_);
	_tmp31_ = _data25_->search_term;
	if (_tmp31_ != NULL) {
		GVariant* search_variant = NULL;
		const gchar* _tmp32_;
		GVariant* _tmp33_;
		GtkApplication* app = NULL;
		GApplication* _tmp34_;
		GtkApplication* _tmp35_;
		ScratchMainWindow* win = NULL;
		GtkApplication* _tmp36_;
		GtkWindow* _tmp37_;
		ScratchMainWindow* _tmp38_;
		ScratchMainWindow* _tmp39_;
		GSimpleActionGroup* _tmp40_;
		GSimpleActionGroup* _tmp41_;
		GAction* _tmp42_;
		GVariant* _tmp43_;
		_tmp32_ = _data25_->search_term;
		_tmp33_ = g_variant_new_string (_tmp32_);
		g_variant_ref_sink (_tmp33_);
		search_variant = _tmp33_;
		_tmp34_ = g_application_get_default ();
		_tmp35_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, gtk_application_get_type (), GtkApplication));
		app = _tmp35_;
		_tmp36_ = app;
		_tmp37_ = gtk_application_get_active_window (_tmp36_);
		_tmp38_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, SCRATCH_TYPE_MAIN_WINDOW, ScratchMainWindow));
		win = _tmp38_;
		_tmp39_ = win;
		_tmp40_ = scratch_main_window_get_actions (_tmp39_);
		_tmp41_ = _tmp40_;
		_tmp42_ = g_action_map_lookup_action ((GActionMap*) _tmp41_, "action-find");
		_tmp43_ = search_variant;
		g_action_activate (_tmp42_, _tmp43_);
		if (!use_regex) {
			if (wholeword_search) {
				const gchar* _tmp44_;
				gchar* _tmp45_;
				_tmp44_ = _data25_->search_term;
				_tmp45_ = g_strdup_printf ("\\b%s\\b", _tmp44_);
				_g_free0 (_data25_->search_term);
				_data25_->search_term = _tmp45_;
			}
		}
		{
			GRegexCompileFlags flags = 0U;
			GRegex* _tmp46_ = NULL;
			const gchar* _tmp47_;
			GRegex* _tmp48_;
			GRegex* _tmp49_;
			flags = G_REGEX_MULTILINE;
			if (!case_sensitive) {
				flags |= G_REGEX_CASELESS;
			}
			_tmp47_ = _data25_->search_term;
			_tmp48_ = g_regex_new (_tmp47_, flags, 0, &_inner_error0_);
			_tmp46_ = _tmp48_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp49_ = _tmp46_;
			_tmp46_ = NULL;
			_g_regex_unref0 (_data25_->pattern);
			_data25_->pattern = _tmp49_;
			_g_regex_unref0 (_tmp46_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			const gchar* _tmp50_;
			GError* _tmp51_;
			const gchar* _tmp52_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp50_ = _data25_->search_term;
			_tmp51_ = e;
			_tmp52_ = _tmp51_->message;
			g_critical ("ProjectFolderItem.vala:591: Error creating regex from '%s': %s", _tmp50_, _tmp52_);
			_g_error_free0 (e);
			_g_object_unref0 (win);
			_g_object_unref0 (app);
			_g_variant_unref0 (search_variant);
			_g_free0 (folder_name);
			path_spec = (_vala_array_free (path_spec, path_spec_length1, (GDestroyNotify) g_free), NULL);
			block25_data_unref (_data25_);
			_data25_ = NULL;
			return;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (win);
			_g_object_unref0 (app);
			_g_variant_unref0 (search_variant);
			_g_free0 (folder_name);
			path_spec = (_vala_array_free (path_spec, path_spec_length1, (GDestroyNotify) g_free), NULL);
			block25_data_unref (_data25_);
			_data25_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_g_object_unref0 (win);
		_g_object_unref0 (app);
		_g_variant_unref0 (search_variant);
	} else {
		_g_free0 (folder_name);
		path_spec = (_vala_array_free (path_spec, path_spec_length1, (GDestroyNotify) g_free), NULL);
		block25_data_unref (_data25_);
		_data25_ = NULL;
		return;
	}
	status_scope = GGIT_STATUS_OPTION_DEFAULT;
	if (!modified_only) {
		status_scope |= GGIT_STATUS_OPTION_INCLUDE_UNMODIFIED;
	}
	if (!search_tracked_only) {
		status_scope |= GGIT_STATUS_OPTION_INCLUDE_UNTRACKED;
	}
	_tmp53_ = path_spec;
	_tmp53__length1 = path_spec_length1;
	_tmp54_ = ggit_status_options_new (status_scope, GGIT_STATUS_SHOW_WORKDIR_ONLY, _tmp53_);
	status_options = _tmp54_;
	scratch_folder_manager_folder_item_remove_all_badges ((ScratchFolderManagerFolderItem*) self);
	code_widgets_source_list_expandable_item_collapse_all ((CodeWidgetsSourceListExpandableItem*) self, TRUE, TRUE);
	_tmp56_ = self->priv->_monitored_repo;
	if (_tmp56_ != NULL) {
		_tmp55_ = !is_explicit;
	} else {
		_tmp55_ = FALSE;
	}
	if (_tmp55_) {
		{
			ScratchServicesMonitoredRepository* _tmp57_;
			GgitRepository* _tmp58_;
			GgitRepository* _tmp59_;
			GgitStatusOptions* _tmp60_;
			_tmp57_ = self->priv->_monitored_repo;
			_tmp58_ = scratch_services_monitored_repository_get_git_repo (_tmp57_);
			_tmp59_ = _tmp58_;
			_tmp60_ = status_options;
			ggit_repository_file_status_foreach (_tmp59_, _tmp60_, _____lambda98__ggit_status_callback, _data25_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* err = NULL;
			GError* _tmp61_;
			const gchar* _tmp62_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp61_ = err;
			_tmp62_ = _tmp61_->message;
			g_warning ("ProjectFolderItem.vala:631: Error getting file status: %s", _tmp62_);
			_g_error_free0 (err);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			__vala_GgitStatusOptions_free0 (status_options);
			_g_free0 (folder_name);
			path_spec = (_vala_array_free (path_spec, path_spec_length1, (GDestroyNotify) g_free), NULL);
			block25_data_unref (_data25_);
			_data25_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	} else {
		GRegex* _tmp63_;
		_tmp63_ = _data25_->pattern;
		scratch_folder_manager_project_folder_item_search_folder_children (self, _data25_->start_folder, _tmp63_, _data25_->recurse_subfolders);
	}
	__vala_GgitStatusOptions_free0 (status_options);
	_g_free0 (folder_name);
	path_spec = (_vala_array_free (path_spec, path_spec_length1, (GDestroyNotify) g_free), NULL);
	block25_data_unref (_data25_);
	_data25_ = NULL;
	return;
}

static void
scratch_folder_manager_project_folder_item_search_folder_children (ScratchFolderManagerProjectFolderItem* self,
                                                                   GFile* start_folder,
                                                                   GRegex* pattern,
                                                                   gboolean recurse_subfolders)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (start_folder != NULL);
	g_return_if_fail (pattern != NULL);
	{
		GFileEnumerator* enumerator = NULL;
		GFileEnumerator* _tmp0_;
		GFileInfo* info = NULL;
		GFile* child = NULL;
		_tmp0_ = g_file_enumerate_children (start_folder, G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE "," G_FILE_ATTRIBUTE_STANDARD_TYPE, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error0_);
		enumerator = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		info = NULL;
		child = NULL;
		while (TRUE) {
			gboolean _tmp1_ = FALSE;
			gboolean _tmp2_ = FALSE;
			GFileEnumerator* _tmp3_;
			GFileInfo* _tmp4_ = NULL;
			GFile* _tmp5_ = NULL;
			gboolean _tmp6_;
			gboolean _tmp8_ = FALSE;
			GFileInfo* _tmp9_;
			_tmp3_ = enumerator;
			_tmp6_ = g_file_enumerator_iterate (_tmp3_, &_tmp4_, &_tmp5_, NULL, &_inner_error0_);
			info = _tmp4_;
			child = _tmp5_;
			_tmp2_ = _tmp6_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (enumerator);
				goto __catch0_g_error;
			}
			if (_tmp2_) {
				GFileInfo* _tmp7_;
				_tmp7_ = info;
				_tmp1_ = _tmp7_ != NULL;
			} else {
				_tmp1_ = FALSE;
			}
			if (!_tmp1_) {
				break;
			}
			_tmp9_ = info;
			if (_tmp9_ != NULL) {
				GFileInfo* _tmp10_;
				_tmp10_ = info;
				_tmp8_ = g_file_info_has_attribute (_tmp10_, G_FILE_ATTRIBUTE_STANDARD_TYPE);
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				GFileInfo* _tmp11_;
				_tmp11_ = info;
				if (g_file_info_get_file_type (_tmp11_) == G_FILE_TYPE_DIRECTORY) {
					if (recurse_subfolders) {
						GFile* _tmp12_;
						_tmp12_ = child;
						scratch_folder_manager_project_folder_item_search_folder_children (self, _tmp12_, pattern, recurse_subfolders);
					}
				} else {
					GFile* _tmp13_;
					GFileInfo* _tmp14_;
					_tmp13_ = child;
					_tmp14_ = info;
					scratch_folder_manager_project_folder_item_perform_match (self, _tmp13_, pattern, TRUE, _tmp14_);
				}
			}
		}
		_g_object_unref0 (enumerator);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* enumerate_error = NULL;
		gchar* _tmp15_;
		gchar* _tmp16_;
		GError* _tmp17_;
		const gchar* _tmp18_;
		enumerate_error = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp15_ = g_file_get_path (start_folder);
		_tmp16_ = _tmp15_;
		_tmp17_ = enumerate_error;
		_tmp18_ = _tmp17_->message;
		g_warning ("ProjectFolderItem.vala:662: Error enumerating children of %s: %s", _tmp16_, _tmp18_);
		_g_free0 (_tmp16_);
		_g_error_free0 (enumerate_error);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
scratch_folder_manager_project_folder_item_perform_match (ScratchFolderManagerProjectFolderItem* self,
                                                          GFile* target,
                                                          GRegex* search_regex,
                                                          gboolean check_is_text,
                                                          GFileInfo* target_info)
{
	gchar* contents = NULL;
	gchar* target_path = NULL;
	gchar* _tmp0_;
	GMatchInfo* match_info = NULL;
	gint match_count = 0;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (target != NULL);
	g_return_if_fail (search_regex != NULL);
	_tmp0_ = g_file_get_path (target);
	target_path = _tmp0_;
	if (check_is_text) {
		GFileInfo* info = NULL;
		GFileInfo* _tmp9_;
		gchar* type = NULL;
		GFileInfo* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		gboolean _tmp13_ = FALSE;
		const gchar* _tmp14_;
		info = NULL;
		if (target_info == NULL) {
			{
				GFileInfo* _tmp1_ = NULL;
				GFileInfo* _tmp2_;
				GFileInfo* _tmp3_;
				_tmp2_ = g_file_query_info (target, G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error0_);
				_tmp1_ = _tmp2_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				_tmp3_ = _tmp1_;
				_tmp1_ = NULL;
				_g_object_unref0 (info);
				info = _tmp3_;
				_g_object_unref0 (_tmp1_);
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* query_error = NULL;
				gchar* _tmp4_;
				gchar* _tmp5_;
				GError* _tmp6_;
				const gchar* _tmp7_;
				query_error = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp4_ = g_file_get_path (target);
				_tmp5_ = _tmp4_;
				_tmp6_ = query_error;
				_tmp7_ = _tmp6_->message;
				g_warning ("ProjectFolderItem.vala:682: Error getting file info for %s: %s.  Ignor" \
"ing.", _tmp5_, _tmp7_);
				_g_free0 (_tmp5_);
				_g_error_free0 (query_error);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (info);
				_g_free0 (target_path);
				_g_free0 (contents);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		} else {
			GFileInfo* _tmp8_;
			_tmp8_ = _g_object_ref0 (target_info);
			_g_object_unref0 (info);
			info = _tmp8_;
		}
		_tmp9_ = info;
		if (_tmp9_ == NULL) {
			_g_object_unref0 (info);
			_g_free0 (target_path);
			_g_free0 (contents);
			return;
		}
		_tmp10_ = info;
		_tmp11_ = g_file_info_get_content_type (_tmp10_);
		_tmp12_ = g_strdup (_tmp11_);
		type = _tmp12_;
		_tmp14_ = type;
		if (!g_content_type_is_mime_type (_tmp14_, "text/*")) {
			_tmp13_ = TRUE;
		} else {
			const gchar* _tmp15_;
			_tmp15_ = type;
			_tmp13_ = g_content_type_is_mime_type (_tmp15_, "image/*");
		}
		if (_tmp13_) {
			_g_free0 (type);
			_g_object_unref0 (info);
			_g_free0 (target_path);
			_g_free0 (contents);
			return;
		}
		_g_free0 (type);
		_g_object_unref0 (info);
	}
	{
		const gchar* _tmp16_;
		gchar* _tmp17_ = NULL;
		_tmp16_ = target_path;
		g_file_get_contents (_tmp16_, &_tmp17_, NULL, &_inner_error0_);
		_g_free0 (contents);
		contents = _tmp17_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp18_;
		const gchar* _tmp19_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp18_ = e;
		_tmp19_ = _tmp18_->message;
		g_warning ("ProjectFolderItem.vala:704: error getting contents: %s", _tmp19_);
		_g_error_free0 (e);
		_g_free0 (target_path);
		_g_free0 (contents);
		return;
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (target_path);
		_g_free0 (contents);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	match_info = NULL;
	match_count = 0;
	{
		{
			const gchar* _tmp20_;
			GMatchInfo* _tmp21_ = NULL;
			gboolean _tmp22_ = FALSE;
			_tmp20_ = contents;
			g_regex_match (search_regex, _tmp20_, G_REGEX_MATCH_NOTEMPTY, &_tmp21_);
			_g_match_info_unref0 (match_info);
			match_info = _tmp21_;
			_tmp22_ = TRUE;
			while (TRUE) {
				GMatchInfo* _tmp24_;
				gint _tmp25_;
				if (!_tmp22_) {
					GMatchInfo* _tmp23_;
					_tmp23_ = match_info;
					g_match_info_next (_tmp23_, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == G_REGEX_ERROR) {
							goto __catch2_g_regex_error;
						}
						_g_match_info_unref0 (match_info);
						_g_free0 (target_path);
						_g_free0 (contents);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
				_tmp22_ = FALSE;
				_tmp24_ = match_info;
				if (!g_match_info_matches (_tmp24_)) {
					break;
				}
				_tmp25_ = match_count;
				match_count = _tmp25_ + 1;
			}
		}
	}
	goto __finally2;
	__catch2_g_regex_error:
	{
		GError* next_error = NULL;
		GError* _tmp26_;
		const gchar* _tmp27_;
		next_error = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp26_ = next_error;
		_tmp27_ = _tmp26_->message;
		g_critical ("ProjectFolderItem.vala:718: Error getting next match: %s", _tmp27_);
		_g_error_free0 (next_error);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_match_info_unref0 (match_info);
		_g_free0 (target_path);
		_g_free0 (contents);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	if (match_count > 0) {
		CodeWidgetsSourceListItem* item = NULL;
		ScratchFolderManagerFileView* _tmp28_;
		ScratchFolderManagerFileView* _tmp29_;
		const gchar* _tmp30_;
		CodeWidgetsSourceListItem* _tmp31_;
		CodeWidgetsSourceListItem* _tmp32_;
		_tmp28_ = scratch_folder_manager_item_get_view ((ScratchFolderManagerItem*) self);
		_tmp29_ = _tmp28_;
		_tmp30_ = target_path;
		_tmp31_ = scratch_folder_manager_file_view_expand_to_path (_tmp29_, _tmp30_);
		item = _tmp31_;
		_tmp32_ = item;
		if (_tmp32_ != NULL) {
			CodeWidgetsSourceListItem* _tmp33_;
			gchar* _tmp34_;
			gchar* _tmp35_;
			_tmp33_ = item;
			_tmp34_ = g_strdup_printf ("%i", match_count);
			_tmp35_ = _tmp34_;
			code_widgets_source_list_item_set_badge (_tmp33_, _tmp35_);
			_g_free0 (_tmp35_);
		}
	}
	_g_match_info_unref0 (match_info);
	_g_free0 (target_path);
	_g_free0 (contents);
	return;
}

void
scratch_folder_manager_project_folder_item_refresh_diff (ScratchFolderManagerProjectFolderItem* self,
                                                         GeeHashMap** line_status_map,
                                                         const gchar* doc_path)
{
	ScratchServicesMonitoredRepository* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (*line_status_map != NULL);
	g_return_if_fail (doc_path != NULL);
	_tmp0_ = self->priv->_monitored_repo;
	scratch_services_monitored_repository_refresh_diff (_tmp0_, doc_path, line_status_map);
}

ScratchServicesMonitoredRepository*
scratch_folder_manager_project_folder_item_get_monitored_repo (ScratchFolderManagerProjectFolderItem* self)
{
	ScratchServicesMonitoredRepository* result;
	ScratchServicesMonitoredRepository* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_monitored_repo;
	result = _tmp0_;
	return result;
}

static void
scratch_folder_manager_project_folder_item_set_monitored_repo (ScratchFolderManagerProjectFolderItem* self,
                                                               ScratchServicesMonitoredRepository* value)
{
	ScratchServicesMonitoredRepository* old_value;
	g_return_if_fail (self != NULL);
	old_value = scratch_folder_manager_project_folder_item_get_monitored_repo (self);
	if (old_value != value) {
		ScratchServicesMonitoredRepository* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_monitored_repo);
		self->priv->_monitored_repo = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, scratch_folder_manager_project_folder_item_properties[SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM_MONITORED_REPO_PROPERTY]);
	}
}

gboolean
scratch_folder_manager_project_folder_item_get_is_git_repo (ScratchFolderManagerProjectFolderItem* self)
{
	gboolean result;
	ScratchServicesMonitoredRepository* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_monitored_repo;
	result = _tmp0_ != NULL;
	return result;
}

static GgitRepository*
scratch_folder_manager_project_folder_item_get_git_repo (ScratchFolderManagerProjectFolderItem* self)
{
	GgitRepository* result;
	GgitRepository* _tmp0_ = NULL;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = scratch_folder_manager_project_folder_item_get_is_git_repo (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		ScratchServicesMonitoredRepository* _tmp3_;
		GgitRepository* _tmp4_;
		GgitRepository* _tmp5_;
		_tmp3_ = self->priv->_monitored_repo;
		_tmp4_ = scratch_services_monitored_repository_get_git_repo (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp0_ = _tmp5_;
	} else {
		_tmp0_ = NULL;
	}
	result = _tmp0_;
	return result;
}

static void
scratch_folder_manager_project_folder_item_visible_item_copy (const ScratchFolderManagerProjectFolderItemVisibleItem* self,
                                                              ScratchFolderManagerProjectFolderItemVisibleItem* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	ScratchFolderManagerItem* _tmp2_;
	ScratchFolderManagerItem* _tmp3_;
	_tmp0_ = (*self).rel_path;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).rel_path);
	(*dest).rel_path = _tmp1_;
	_tmp2_ = (*self).item;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 ((*dest).item);
	(*dest).item = _tmp3_;
}

static void
scratch_folder_manager_project_folder_item_visible_item_destroy (ScratchFolderManagerProjectFolderItemVisibleItem* self)
{
	_g_free0 ((*self).rel_path);
	_g_object_unref0 ((*self).item);
}

static ScratchFolderManagerProjectFolderItemVisibleItem*
scratch_folder_manager_project_folder_item_visible_item_dup (const ScratchFolderManagerProjectFolderItemVisibleItem* self)
{
	ScratchFolderManagerProjectFolderItemVisibleItem* dup;
	dup = g_new0 (ScratchFolderManagerProjectFolderItemVisibleItem, 1);
	scratch_folder_manager_project_folder_item_visible_item_copy (self, dup);
	return dup;
}

static void
scratch_folder_manager_project_folder_item_visible_item_free (ScratchFolderManagerProjectFolderItemVisibleItem* self)
{
	scratch_folder_manager_project_folder_item_visible_item_destroy (self);
	g_free (self);
}

 G_GNUC_NO_INLINE static GType
scratch_folder_manager_project_folder_item_visible_item_get_type_once (void)
{
	GType scratch_folder_manager_project_folder_item_visible_item_type_id;
	scratch_folder_manager_project_folder_item_visible_item_type_id = g_boxed_type_register_static ("ScratchFolderManagerProjectFolderItemVisibleItem", (GBoxedCopyFunc) scratch_folder_manager_project_folder_item_visible_item_dup, (GBoxedFreeFunc) scratch_folder_manager_project_folder_item_visible_item_free);
	return scratch_folder_manager_project_folder_item_visible_item_type_id;
}

static GType
scratch_folder_manager_project_folder_item_visible_item_get_type (void)
{
	static gsize scratch_folder_manager_project_folder_item_visible_item_type_id__once = 0;
	if (g_once_init_enter (&scratch_folder_manager_project_folder_item_visible_item_type_id__once)) {
		GType scratch_folder_manager_project_folder_item_visible_item_type_id;
		scratch_folder_manager_project_folder_item_visible_item_type_id = scratch_folder_manager_project_folder_item_visible_item_get_type_once ();
		g_once_init_leave (&scratch_folder_manager_project_folder_item_visible_item_type_id__once, scratch_folder_manager_project_folder_item_visible_item_type_id);
	}
	return scratch_folder_manager_project_folder_item_visible_item_type_id__once;
}

static void
_scratch_folder_manager_project_folder_item_branch_or_name_changed_g_object_notify (GObject* _sender,
                                                                                    GParamSpec* pspec,
                                                                                    gpointer self)
{
	scratch_folder_manager_project_folder_item_branch_or_name_changed ((ScratchFolderManagerProjectFolderItem*) self);
}

static GVariant*
_variant_new32 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new33 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static void
_scratch_folder_manager_project_folder_item_branch_or_name_changed_scratch_services_monitored_repository_branch_changed (ScratchServicesMonitoredRepository* _sender,
                                                                                                                         gpointer self)
{
	scratch_folder_manager_project_folder_item_branch_or_name_changed ((ScratchFolderManagerProjectFolderItem*) self);
}

static void
_scratch_folder_manager_project_folder_item_deprioritize_git_ignored_scratch_services_monitored_repository_ignored_changed (ScratchServicesMonitoredRepository* _sender,
                                                                                                                            gpointer self)
{
	scratch_folder_manager_project_folder_item_deprioritize_git_ignored ((ScratchFolderManagerProjectFolderItem*) self);
}

static void
_scratch_folder_manager_project_folder_item____lambda104_ (ScratchFolderManagerProjectFolderItem* self)
{
	scratch_folder_manager_project_folder_item_update_item_status (self, NULL);
}

static void
__scratch_folder_manager_project_folder_item____lambda104__scratch_services_monitored_repository_file_status_change (ScratchServicesMonitoredRepository* _sender,
                                                                                                                     gpointer self)
{
	_scratch_folder_manager_project_folder_item____lambda104_ ((ScratchFolderManagerProjectFolderItem*) self);
}

static void
_scratch_folder_manager_project_folder_item_handle_checkout_local_branch_action_g_simple_action_activate (GSimpleAction* _sender,
                                                                                                          GVariant* parameter,
                                                                                                          gpointer self)
{
	scratch_folder_manager_project_folder_item_handle_checkout_local_branch_action ((ScratchFolderManagerProjectFolderItem*) self, parameter);
}

static void
_scratch_folder_manager_project_folder_item_handle_checkout_remote_branch_action_g_simple_action_activate (GSimpleAction* _sender,
                                                                                                           GVariant* parameter,
                                                                                                           gpointer self)
{
	scratch_folder_manager_project_folder_item_handle_checkout_remote_branch_action ((ScratchFolderManagerProjectFolderItem*) self, parameter);
}

static GObject *
scratch_folder_manager_project_folder_item_constructor (GType type,
                                                        guint n_construct_properties,
                                                        GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ScratchFolderManagerProjectFolderItem * self;
	ScratchServicesGitManager* _tmp0_;
	ScratchServicesGitManager* _tmp1_;
	ScratchServicesMonitoredRepository* _tmp2_;
	ScratchServicesMonitoredRepository* _tmp3_;
	ScratchServicesMonitoredRepository* _tmp4_;
	parent_class = G_OBJECT_CLASS (scratch_folder_manager_project_folder_item_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SCRATCH_FOLDER_MANAGER_TYPE_PROJECT_FOLDER_ITEM, ScratchFolderManagerProjectFolderItem);
	_tmp0_ = scratch_services_git_manager_get_instance ();
	_tmp1_ = _tmp0_;
	_tmp2_ = scratch_services_git_manager_add_project (_tmp1_, self);
	_tmp3_ = _tmp2_;
	scratch_folder_manager_project_folder_item_set_monitored_repo (self, _tmp3_);
	_g_object_unref0 (_tmp3_);
	_g_object_unref0 (_tmp1_);
	g_signal_connect_object ((GObject*) self, "notify::name", (GCallback) _scratch_folder_manager_project_folder_item_branch_or_name_changed_g_object_notify, self, 0);
	_tmp4_ = self->priv->_monitored_repo;
	if (_tmp4_ != NULL) {
		const GVariantType* _tmp5_;
		GVariant* _tmp6_;
		GSimpleAction* _tmp7_;
		const GVariantType* _tmp8_;
		GVariant* _tmp9_;
		GSimpleAction* _tmp10_;
		ScratchServicesMonitoredRepository* _tmp11_;
		ScratchServicesMonitoredRepository* _tmp12_;
		ScratchServicesMonitoredRepository* _tmp13_;
		ScratchServicesMonitoredRepository* _tmp14_;
		ScratchServicesMonitoredRepository* _tmp15_;
		GSimpleAction* _tmp16_;
		GSimpleAction* _tmp17_;
		_tmp5_ = G_VARIANT_TYPE_STRING;
		_tmp6_ = _variant_new32 ("");
		_tmp7_ = g_simple_action_new_stateful (SCRATCH_FOLDER_MANAGER_FILE_VIEW_ACTION_CHECKOUT_LOCAL_BRANCH, _tmp5_, _tmp6_);
		_g_object_unref0 (self->priv->checkout_local_branch_action);
		self->priv->checkout_local_branch_action = _tmp7_;
		_g_variant_unref0 (_tmp6_);
		_tmp8_ = G_VARIANT_TYPE_STRING;
		_tmp9_ = _variant_new33 ("");
		_tmp10_ = g_simple_action_new_stateful (SCRATCH_FOLDER_MANAGER_FILE_VIEW_ACTION_CHECKOUT_REMOTE_BRANCH, _tmp8_, _tmp9_);
		_g_object_unref0 (self->priv->checkout_remote_branch_action);
		self->priv->checkout_remote_branch_action = _tmp10_;
		_g_variant_unref0 (_tmp9_);
		_tmp11_ = self->priv->_monitored_repo;
		g_signal_connect_object (_tmp11_, "branch-changed", (GCallback) _scratch_folder_manager_project_folder_item_branch_or_name_changed_scratch_services_monitored_repository_branch_changed, self, 0);
		_tmp12_ = self->priv->_monitored_repo;
		g_signal_connect_object (_tmp12_, "ignored-changed", (GCallback) _scratch_folder_manager_project_folder_item_deprioritize_git_ignored_scratch_services_monitored_repository_ignored_changed, self, 0);
		_tmp13_ = self->priv->_monitored_repo;
		g_signal_connect_object (_tmp13_, "file-status-change", (GCallback) __scratch_folder_manager_project_folder_item____lambda104__scratch_services_monitored_repository_file_status_change, self, 0);
		_tmp14_ = self->priv->_monitored_repo;
		scratch_services_monitored_repository_update_status_map (_tmp14_);
		_tmp15_ = self->priv->_monitored_repo;
		g_signal_emit_by_name (_tmp15_, "branch-changed");
		_tmp16_ = self->priv->checkout_local_branch_action;
		g_signal_connect_object (_tmp16_, "activate", (GCallback) _scratch_folder_manager_project_folder_item_handle_checkout_local_branch_action_g_simple_action_activate, self, 0);
		_tmp17_ = self->priv->checkout_remote_branch_action;
		g_signal_connect_object (_tmp17_, "activate", (GCallback) _scratch_folder_manager_project_folder_item_handle_checkout_remote_branch_action_g_simple_action_activate, self, 0);
	}
	return obj;
}

static void
scratch_folder_manager_project_folder_item_class_init (ScratchFolderManagerProjectFolderItemClass * klass,
                                                       gpointer klass_data)
{
	GThemedIcon* _tmp0_;
	GThemedIcon* _tmp1_;
	scratch_folder_manager_project_folder_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ScratchFolderManagerProjectFolderItem_private_offset);
	((ScratchFolderManagerFolderItemClass *) klass)->on_changed = (void (*) (ScratchFolderManagerFolderItem*, GFile*, GFile*, GFileMonitorEvent)) scratch_folder_manager_project_folder_item_real_on_changed;
	((CodeWidgetsSourceListItemClass *) klass)->get_context_menu = (GtkMenu* (*) (CodeWidgetsSourceListItem*)) scratch_folder_manager_project_folder_item_real_get_context_menu;
	G_OBJECT_CLASS (klass)->get_property = _vala_scratch_folder_manager_project_folder_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_scratch_folder_manager_project_folder_item_set_property;
	G_OBJECT_CLASS (klass)->constructor = scratch_folder_manager_project_folder_item_constructor;
	G_OBJECT_CLASS (klass)->finalize = scratch_folder_manager_project_folder_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM_MONITORED_REPO_PROPERTY, scratch_folder_manager_project_folder_item_properties[SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM_MONITORED_REPO_PROPERTY] = g_param_spec_object ("monitored-repo", "monitored-repo", "monitored-repo", SCRATCH_SERVICES_TYPE_MONITORED_REPOSITORY, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM_IS_GIT_REPO_PROPERTY, scratch_folder_manager_project_folder_item_properties[SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM_IS_GIT_REPO_PROPERTY] = g_param_spec_boolean ("is-git-repo", "is-git-repo", "is-git-repo", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	scratch_folder_manager_project_folder_item_signals[SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM_CLOSED_SIGNAL] = g_signal_new ("closed", SCRATCH_FOLDER_MANAGER_TYPE_PROJECT_FOLDER_ITEM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	_tmp0_ = (GThemedIcon*) g_themed_icon_new ("emblem-git-new-symbolic");
	_g_object_unref0 (scratch_folder_manager_project_folder_item_added_icon);
	scratch_folder_manager_project_folder_item_added_icon = (GIcon*) _tmp0_;
	_tmp1_ = (GThemedIcon*) g_themed_icon_new ("emblem-git-modified-symbolic");
	_g_object_unref0 (scratch_folder_manager_project_folder_item_modified_icon);
	scratch_folder_manager_project_folder_item_modified_icon = (GIcon*) _tmp1_;
}

static void
scratch_folder_manager_project_folder_item_instance_init (ScratchFolderManagerProjectFolderItem * self,
                                                          gpointer klass)
{
	self->priv = scratch_folder_manager_project_folder_item_get_instance_private (self);
	self->priv->_monitored_repo = NULL;
	self->priv->visible_item_list = NULL;
}

static void
scratch_folder_manager_project_folder_item_finalize (GObject * obj)
{
	ScratchFolderManagerProjectFolderItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SCRATCH_FOLDER_MANAGER_TYPE_PROJECT_FOLDER_ITEM, ScratchFolderManagerProjectFolderItem);
	_g_object_unref0 (self->priv->checkout_local_branch_action);
	_g_object_unref0 (self->priv->checkout_remote_branch_action);
	_g_object_unref0 (self->priv->_monitored_repo);
	(self->priv->visible_item_list == NULL) ? NULL : (self->priv->visible_item_list = (_g_list_free__scratch_folder_manager_project_folder_item_visible_item_free0_ (self->priv->visible_item_list), NULL));
	G_OBJECT_CLASS (scratch_folder_manager_project_folder_item_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
scratch_folder_manager_project_folder_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ScratchFolderManagerProjectFolderItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scratch_folder_manager_project_folder_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScratchFolderManagerProjectFolderItem), 0, (GInstanceInitFunc) scratch_folder_manager_project_folder_item_instance_init, NULL };
	GType scratch_folder_manager_project_folder_item_type_id;
	scratch_folder_manager_project_folder_item_type_id = g_type_register_static (SCRATCH_FOLDER_MANAGER_TYPE_FOLDER_ITEM, "ScratchFolderManagerProjectFolderItem", &g_define_type_info, 0);
	ScratchFolderManagerProjectFolderItem_private_offset = g_type_add_instance_private (scratch_folder_manager_project_folder_item_type_id, sizeof (ScratchFolderManagerProjectFolderItemPrivate));
	return scratch_folder_manager_project_folder_item_type_id;
}

GType
scratch_folder_manager_project_folder_item_get_type (void)
{
	static gsize scratch_folder_manager_project_folder_item_type_id__once = 0;
	if (g_once_init_enter (&scratch_folder_manager_project_folder_item_type_id__once)) {
		GType scratch_folder_manager_project_folder_item_type_id;
		scratch_folder_manager_project_folder_item_type_id = scratch_folder_manager_project_folder_item_get_type_once ();
		g_once_init_leave (&scratch_folder_manager_project_folder_item_type_id__once, scratch_folder_manager_project_folder_item_type_id);
	}
	return scratch_folder_manager_project_folder_item_type_id__once;
}

static void
_vala_scratch_folder_manager_project_folder_item_get_property (GObject * object,
                                                               guint property_id,
                                                               GValue * value,
                                                               GParamSpec * pspec)
{
	ScratchFolderManagerProjectFolderItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SCRATCH_FOLDER_MANAGER_TYPE_PROJECT_FOLDER_ITEM, ScratchFolderManagerProjectFolderItem);
	switch (property_id) {
		case SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM_MONITORED_REPO_PROPERTY:
		g_value_set_object (value, scratch_folder_manager_project_folder_item_get_monitored_repo (self));
		break;
		case SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM_IS_GIT_REPO_PROPERTY:
		g_value_set_boolean (value, scratch_folder_manager_project_folder_item_get_is_git_repo (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_scratch_folder_manager_project_folder_item_set_property (GObject * object,
                                                               guint property_id,
                                                               const GValue * value,
                                                               GParamSpec * pspec)
{
	ScratchFolderManagerProjectFolderItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SCRATCH_FOLDER_MANAGER_TYPE_PROJECT_FOLDER_ITEM, ScratchFolderManagerProjectFolderItem);
	switch (property_id) {
		case SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM_MONITORED_REPO_PROPERTY:
		scratch_folder_manager_project_folder_item_set_monitored_repo (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

