/* MailPage.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from MailPage.vala, do not modify */

/*-
 * Copyright 2020 elementary, Inc. (https://elementary.io)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: David Hewitt <davidmhewitt@gmail.com>
 *              Corentin Noël <corentin@elementary.io>
 */

#include "io.elementary.mail-webkit-extension.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <webkit2/webkit-web-extension.h>
#include <glib-object.h>
#include <jsc/jsc.h>
#include <gdk/gdk.h>

#define MAIL_PAGE_JS_EXPAND_BODY "\n" \
"        var body = document.querySelector('#elementary-message-body');" \
"\n" \
"        var signature = document.querySelector('#elementary-message-si" \
"gnature');\n" \
"        var quote = document.querySelector('#elementary-message-quote'" \
");\n" \
"        if (!signature.hidden || !quote.hidden) {\n" \
"            body.style.height = \"initial\";\n" \
"        } else {\n" \
"            body.style.height = \"100%\";\n" \
"        }\n" \
"    "
#define MAIL_PAGE_JS_CLEAN_HTML "\n" \
"        var body = document.querySelector('#elementary-message-body');" \
"\n" \
"        body.removeAttribute (\"contenteditable\");\n" \
"        body.removeAttribute (\"id\");\n" \
"        body.style.height = \"initial\";\n" \
"\n" \
"        var signature = document.querySelector('#elementary-message-si" \
"gnature');\n" \
"        if (signature.hidden) {\n" \
"            signature.remove ();\n" \
"        } else {\n" \
"            signature.removeAttribute (\"contenteditable\");\n" \
"            signature.removeAttribute (\"id\");\n" \
"        }\n" \
"\n" \
"        var quote = document.querySelector('#elementary-message-quote'" \
");\n" \
"        if (quote.hidden) {\n" \
"            quote.remove ();\n" \
"        } else {\n" \
"            quote.removeAttribute (\"contenteditable\");\n" \
"            quote.removeAttribute (\"id\");\n" \
"        }\n" \
"    "
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	MAIL_PAGE_0_PROPERTY,
	MAIL_PAGE_NUM_PROPERTIES
};
static GParamSpec* mail_page_properties[MAIL_PAGE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_uri_unref0(var) ((var == NULL) ? NULL : (var = (g_uri_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _MailPagePrivate {
	gboolean show_images;
	GList* image_uris;
	WebKitWebPage* page;
};

struct _Block1Data {
	int _ref_count_;
	MailPage* self;
	WebKitWebPage* page;
};

static gint MailPage_private_offset;
static gpointer mail_page_parent_class = NULL;

static void _g_free0_ (gpointer var);
static inline void _g_list_free__g_free0_ (GList* self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gboolean mail_page_on_send_request (MailPage* self,
                                    WebKitWebPage* page,
                                    WebKitURIRequest* request,
                                    WebKitURIResponse* response);
static gboolean _mail_page_on_send_request_webkit_web_page_send_request (WebKitWebPage* _sender,
                                                                  WebKitURIRequest* request,
                                                                  WebKitURIResponse* redirected_response,
                                                                  gpointer self);
static gboolean mail_page_on_page_user_message_received (MailPage* self,
                                                  WebKitWebPage* page,
                                                  WebKitUserMessage* message);
static gboolean _mail_page_on_page_user_message_received_webkit_web_page_user_message_received (WebKitWebPage* _sender,
                                                                                         WebKitUserMessage* message,
                                                                                         gpointer self);
static void __lambda4_ (Block1Data* _data1_);
static GVariant* _variant_new1 (const gchar* value);
static void ___lambda4__webkit_web_editor_selection_changed (WebKitWebEditor* _sender,
                                                      gpointer self);
static gboolean _vala_string_array_contains (const gchar* * stack,
                                      gssize stack_length,
                                      const const gchar* needle);
static void mail_page_finalize (GObject * obj);
static GType mail_page_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const gchar* MAIL_PAGE_ALLOWED_SCHEMES[4] = {"cid", "data", "about", "elementary-mail"};

static inline gpointer
mail_page_get_instance_private (MailPage* self)
{
	return G_STRUCT_MEMBER_P (self, MailPage_private_offset);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static inline void
_g_list_free__g_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_free0_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		MailPage* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->page);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static gboolean
_mail_page_on_send_request_webkit_web_page_send_request (WebKitWebPage* _sender,
                                                         WebKitURIRequest* request,
                                                         WebKitURIResponse* redirected_response,
                                                         gpointer self)
{
	gboolean result;
	result = mail_page_on_send_request ((MailPage*) self, _sender, request, redirected_response);
	return result;
}

static gboolean
_mail_page_on_page_user_message_received_webkit_web_page_user_message_received (WebKitWebPage* _sender,
                                                                                WebKitUserMessage* message,
                                                                                gpointer self)
{
	gboolean result;
	result = mail_page_on_page_user_message_received ((MailPage*) self, _sender, message);
	return result;
}

static GVariant*
_variant_new1 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static void
__lambda4_ (Block1Data* _data1_)
{
	MailPage* self;
	WebKitUserMessage* _tmp0_;
	WebKitUserMessage* _tmp1_;
	JSCContext* js_context = NULL;
	WebKitFrame* _tmp2_;
	JSCContext* _tmp3_;
	GList* _tmp4_;
	self = _data1_->self;
	_tmp0_ = webkit_user_message_new ("selection-changed", NULL);
	g_object_ref_sink (_tmp0_);
	_tmp1_ = _tmp0_;
	webkit_web_page_send_message_to_view (_data1_->page, _tmp1_, NULL, NULL, NULL);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = webkit_web_page_get_main_frame (_data1_->page);
	_tmp3_ = webkit_frame_get_js_context (_tmp2_);
	js_context = _tmp3_;
	_tmp4_ = self->priv->image_uris;
	{
		GList* image_uri_collection = NULL;
		GList* image_uri_it = NULL;
		image_uri_collection = _tmp4_;
		for (image_uri_it = image_uri_collection; image_uri_it != NULL; image_uri_it = image_uri_it->next) {
			gchar* _tmp5_;
			gchar* image_uri = NULL;
			_tmp5_ = g_strdup ((const gchar*) image_uri_it->data);
			image_uri = _tmp5_;
			{
				JSCValue* val = NULL;
				JSCContext* _tmp6_;
				const gchar* _tmp7_;
				gchar* _tmp8_;
				gchar* _tmp9_;
				JSCValue* _tmp10_;
				JSCValue* _tmp11_;
				JSCValue* _tmp12_;
				_tmp6_ = js_context;
				_tmp7_ = image_uri;
				_tmp8_ = g_strdup_printf ("document.querySelector('[src=\"%s\"]')", _tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = jsc_context_evaluate (_tmp6_, _tmp9_, (gssize) -1);
				_tmp11_ = _tmp10_;
				_g_free0 (_tmp9_);
				val = _tmp11_;
				_tmp12_ = val;
				if (jsc_value_is_null (_tmp12_)) {
					GList* entry = NULL;
					GList* _tmp13_;
					const gchar* _tmp14_;
					GCompareFunc _tmp15_;
					GList* _tmp16_;
					GList* _tmp17_;
					const gchar* _tmp18_;
					GVariant* _tmp19_;
					WebKitUserMessage* _tmp20_;
					WebKitUserMessage* _tmp21_;
					_tmp13_ = self->priv->image_uris;
					_tmp14_ = image_uri;
					_tmp15_ = ((GCompareFunc) g_strcmp0);
					_tmp16_ = g_list_find_custom (_tmp13_, _tmp14_, _tmp15_);
					entry = _tmp16_;
					_tmp17_ = entry;
					self->priv->image_uris = g_list_remove_link (self->priv->image_uris, _tmp17_);
					_tmp18_ = image_uri;
					_tmp19_ = _variant_new1 (_tmp18_);
					_tmp20_ = webkit_user_message_new ("image-removed", _tmp19_);
					g_object_ref_sink (_tmp20_);
					_tmp21_ = _tmp20_;
					webkit_web_page_send_message_to_view (_data1_->page, _tmp21_, NULL, NULL, NULL);
					_g_object_unref0 (_tmp21_);
					_g_variant_unref0 (_tmp19_);
				}
				_g_object_unref0 (val);
				_g_free0 (image_uri);
			}
		}
	}
	_g_object_unref0 (js_context);
}

static void
___lambda4__webkit_web_editor_selection_changed (WebKitWebEditor* _sender,
                                                 gpointer self)
{
	__lambda4_ (self);
}

MailPage*
mail_page_construct (GType object_type,
                     WebKitWebPage* page)
{
	MailPage * self = NULL;
	Block1Data* _data1_;
	WebKitWebPage* _tmp0_;
	WebKitWebEditor* _tmp1_;
	g_return_val_if_fail (page != NULL, NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_tmp0_ = _g_object_ref0 (page);
	_g_object_unref0 (_data1_->page);
	_data1_->page = _tmp0_;
	self = (MailPage*) g_object_new (object_type, NULL);
	_data1_->self = g_object_ref (self);
	self->priv->page = _data1_->page;
	(self->priv->image_uris == NULL) ? NULL : (self->priv->image_uris = (_g_list_free__g_free0_ (self->priv->image_uris), NULL));
	self->priv->image_uris = NULL;
	g_signal_connect_object (_data1_->page, "send-request", (GCallback) _mail_page_on_send_request_webkit_web_page_send_request, self, 0);
	g_signal_connect_object (_data1_->page, "user-message-received", (GCallback) _mail_page_on_page_user_message_received_webkit_web_page_user_message_received, self, 0);
	_tmp1_ = webkit_web_page_get_editor (_data1_->page);
	g_signal_connect_data (_tmp1_, "selection-changed", (GCallback) ___lambda4__webkit_web_editor_selection_changed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return self;
}

MailPage*
mail_page_new (WebKitWebPage* page)
{
	return mail_page_construct (MAIL_TYPE_PAGE, page);
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gboolean
mail_page_on_page_user_message_received (MailPage* self,
                                         WebKitWebPage* page,
                                         WebKitUserMessage* message)
{
	JSCContext* js_context = NULL;
	WebKitFrame* _tmp0_;
	JSCContext* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GQuark _tmp6_ = 0U;
	static GQuark _tmp5_label0 = 0;
	static GQuark _tmp5_label1 = 0;
	static GQuark _tmp5_label2 = 0;
	static GQuark _tmp5_label3 = 0;
	static GQuark _tmp5_label4 = 0;
	static GQuark _tmp5_label5 = 0;
	static GQuark _tmp5_label6 = 0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (page != NULL, FALSE);
	g_return_val_if_fail (message != NULL, FALSE);
	_tmp0_ = webkit_web_page_get_main_frame (page);
	_tmp1_ = webkit_frame_get_js_context (_tmp0_);
	js_context = _tmp1_;
	_tmp2_ = webkit_user_message_get_name (message);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp6_ = (NULL == _tmp4_) ? 0 : g_quark_from_string (_tmp4_);
	if (_tmp6_ == ((0 != _tmp5_label0) ? _tmp5_label0 : (_tmp5_label0 = g_quark_from_static_string ("set-content-of-element")))) {
		switch (0) {
			default:
			{
				gchar* element_selector = NULL;
				gchar* content = NULL;
				GVariant* _tmp7_;
				GVariant* _tmp8_;
				gchar* _tmp9_ = NULL;
				gchar* _tmp10_ = NULL;
				JSCValue* element = NULL;
				JSCContext* _tmp11_;
				const gchar* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				JSCValue* _tmp15_;
				JSCValue* _tmp16_;
				JSCValue* _tmp17_;
				gboolean _tmp19_ = FALSE;
				const gchar* _tmp20_;
				JSCValue* _tmp29_;
				JSCContext* _tmp30_;
				const gchar* _tmp31_;
				JSCValue* _tmp32_;
				JSCValue* _tmp33_;
				JSCContext* _tmp34_;
				JSCValue* _tmp35_;
				JSCValue* _tmp36_;
				_tmp7_ = webkit_user_message_get_parameters (message);
				_tmp8_ = _tmp7_;
				g_variant_get (_tmp8_, "(ss)", &_tmp9_, &_tmp10_, NULL);
				_g_free0 (element_selector);
				element_selector = _tmp9_;
				_g_free0 (content);
				content = _tmp10_;
				_tmp11_ = js_context;
				_tmp12_ = element_selector;
				_tmp13_ = g_strdup_printf ("document.querySelector('%s')", _tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = jsc_context_evaluate (_tmp11_, _tmp14_, (gssize) -1);
				_tmp16_ = _tmp15_;
				_g_free0 (_tmp14_);
				element = _tmp16_;
				_tmp17_ = element;
				if (jsc_value_is_null (_tmp17_)) {
					const gchar* _tmp18_;
					_tmp18_ = element_selector;
					g_warning ("MailPage.vala:92: HTML element '%s' not found.", _tmp18_);
					result = TRUE;
					_g_object_unref0 (element);
					_g_free0 (content);
					_g_free0 (element_selector);
					_g_object_unref0 (js_context);
					return result;
				}
				_tmp20_ = element_selector;
				if (g_strcmp0 (_tmp20_, "#elementary-message-signature") == 0) {
					_tmp19_ = TRUE;
				} else {
					const gchar* _tmp21_;
					_tmp21_ = element_selector;
					_tmp19_ = g_strcmp0 (_tmp21_, "#elementary-message-quote") == 0;
				}
				if (_tmp19_) {
					JSCValue* _tmp22_;
					JSCContext* _tmp23_;
					const gchar* _tmp24_;
					gchar* _tmp25_;
					gchar* _tmp26_;
					JSCValue* _tmp27_;
					JSCValue* _tmp28_;
					_tmp22_ = element;
					_tmp23_ = js_context;
					_tmp24_ = content;
					_tmp25_ = string_strip (_tmp24_);
					_tmp26_ = _tmp25_;
					_tmp27_ = jsc_value_new_boolean (_tmp23_, g_strcmp0 (_tmp26_, "") == 0);
					_tmp28_ = _tmp27_;
					jsc_value_object_set_property (_tmp22_, "hidden", _tmp28_);
					_g_object_unref0 (_tmp28_);
					_g_free0 (_tmp26_);
				}
				_tmp29_ = element;
				_tmp30_ = js_context;
				_tmp31_ = content;
				_tmp32_ = jsc_value_new_string (_tmp30_, _tmp31_);
				_tmp33_ = _tmp32_;
				jsc_value_object_set_property (_tmp29_, "innerHTML", _tmp33_);
				_g_object_unref0 (_tmp33_);
				_tmp34_ = js_context;
				_tmp35_ = jsc_context_evaluate (_tmp34_, MAIL_PAGE_JS_EXPAND_BODY, (gssize) -1);
				_tmp36_ = _tmp35_;
				_g_object_unref0 (_tmp36_);
				result = TRUE;
				_g_object_unref0 (element);
				_g_free0 (content);
				_g_free0 (element_selector);
				_g_object_unref0 (js_context);
				return result;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label1) ? _tmp5_label1 : (_tmp5_label1 = g_quark_from_static_string ("get-body-html")))) {
		switch (0) {
			default:
			{
				GVariant* _tmp37_;
				GVariant* _tmp38_;
				JSCValue* val = NULL;
				JSCContext* _tmp42_;
				JSCValue* _tmp43_;
				JSCValue* _tmp44_;
				gchar* _tmp45_;
				GVariant* _tmp46_;
				GVariant* _tmp47_;
				WebKitUserMessage* _tmp48_;
				WebKitUserMessage* _tmp49_;
				_tmp37_ = webkit_user_message_get_parameters (message);
				_tmp38_ = _tmp37_;
				if (g_variant_get_boolean (_tmp38_)) {
					JSCContext* _tmp39_;
					JSCValue* _tmp40_;
					JSCValue* _tmp41_;
					_tmp39_ = js_context;
					_tmp40_ = jsc_context_evaluate (_tmp39_, MAIL_PAGE_JS_CLEAN_HTML, (gssize) -1);
					_tmp41_ = _tmp40_;
					_g_object_unref0 (_tmp41_);
				}
				_tmp42_ = js_context;
				_tmp43_ = jsc_context_evaluate (_tmp42_, "document.querySelector('body').innerHTML;", (gssize) -1);
				val = _tmp43_;
				_tmp44_ = val;
				_tmp45_ = jsc_value_to_string (_tmp44_);
				_tmp46_ = g_variant_new_take_string (_tmp45_);
				g_variant_ref_sink (_tmp46_);
				_tmp47_ = _tmp46_;
				_tmp48_ = webkit_user_message_new ("get-body-html", _tmp47_);
				g_object_ref_sink (_tmp48_);
				_tmp49_ = _tmp48_;
				webkit_user_message_send_reply (message, _tmp49_);
				_g_object_unref0 (_tmp49_);
				_g_variant_unref0 (_tmp47_);
				result = TRUE;
				_g_object_unref0 (val);
				_g_object_unref0 (js_context);
				return result;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label2) ? _tmp5_label2 : (_tmp5_label2 = g_quark_from_static_string ("get-page-height")))) {
		switch (0) {
			default:
			{
				JSCValue* val = NULL;
				JSCContext* _tmp50_;
				JSCValue* _tmp51_;
				JSCValue* _tmp52_;
				GVariant* _tmp53_;
				GVariant* _tmp54_;
				WebKitUserMessage* _tmp55_;
				WebKitUserMessage* _tmp56_;
				_tmp50_ = js_context;
				_tmp51_ = jsc_context_evaluate (_tmp50_, "\n" \
"                Math.max(\n" \
"                    document.body.scrollHeight, document.body.offsetHe" \
"ight,\n" \
"                    document.documentElement.clientHeight, document.do" \
"cumentElement.scrollHeight, document.documentElement.offsetHeight\n" \
"                );\n" \
"                ", (gssize) -1);
				val = _tmp51_;
				_tmp52_ = val;
				_tmp53_ = g_variant_new_int32 (jsc_value_to_int32 (_tmp52_));
				g_variant_ref_sink (_tmp53_);
				_tmp54_ = _tmp53_;
				_tmp55_ = webkit_user_message_new ("get-page-height", _tmp54_);
				g_object_ref_sink (_tmp55_);
				_tmp56_ = _tmp55_;
				webkit_user_message_send_reply (message, _tmp56_);
				_g_object_unref0 (_tmp56_);
				_g_variant_unref0 (_tmp54_);
				result = TRUE;
				_g_object_unref0 (val);
				_g_object_unref0 (js_context);
				return result;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label3) ? _tmp5_label3 : (_tmp5_label3 = g_quark_from_static_string ("set-image-loading-enabled")))) {
		switch (0) {
			default:
			{
				gboolean enabled = FALSE;
				GVariant* _tmp57_;
				GVariant* _tmp58_;
				_tmp57_ = webkit_user_message_get_parameters (message);
				_tmp58_ = _tmp57_;
				enabled = g_variant_get_boolean (_tmp58_);
				self->priv->show_images = enabled;
				if (enabled) {
					JSCContext* _tmp59_;
					JSCValue* _tmp60_;
					JSCValue* _tmp61_;
					_tmp59_ = js_context;
					_tmp60_ = jsc_context_evaluate (_tmp59_, "var images = document.images;\n" \
"                        for(var i = 0; i < images.length; i++) {\n" \
"                            images[i].src = images[i].src\n" \
"                        }", (gssize) -1);
					_tmp61_ = _tmp60_;
					_g_object_unref0 (_tmp61_);
				}
				result = TRUE;
				_g_object_unref0 (js_context);
				return result;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label4) ? _tmp5_label4 : (_tmp5_label4 = g_quark_from_static_string ("execute-editor-command")))) {
		switch (0) {
			default:
			{
				gchar* command = NULL;
				gchar* argument = NULL;
				GVariant* _tmp62_;
				GVariant* _tmp63_;
				gchar* _tmp64_ = NULL;
				gchar* _tmp65_ = NULL;
				JSCValue* document = NULL;
				JSCContext* _tmp66_;
				JSCValue* _tmp67_;
				JSCValue** parameters = NULL;
				JSCContext* _tmp68_;
				const gchar* _tmp69_;
				JSCValue* _tmp70_;
				JSCContext* _tmp71_;
				JSCValue* _tmp72_;
				JSCContext* _tmp73_;
				const gchar* _tmp74_;
				JSCValue* _tmp75_;
				JSCValue** _tmp76_;
				gint parameters_length1;
				gint _parameters_size_;
				const gchar* _tmp77_;
				JSCValue* ret = NULL;
				JSCValue* _tmp80_;
				JSCValue** _tmp81_;
				gint _tmp81__length1;
				JSCValue* _tmp82_;
				gboolean _tmp83_ = FALSE;
				JSCValue* _tmp84_;
				_tmp62_ = webkit_user_message_get_parameters (message);
				_tmp63_ = _tmp62_;
				g_variant_get (_tmp63_, "(ss)", &_tmp64_, &_tmp65_, NULL);
				_g_free0 (command);
				command = _tmp64_;
				_g_free0 (argument);
				argument = _tmp65_;
				_tmp66_ = js_context;
				_tmp67_ = jsc_context_evaluate (_tmp66_, "document", (gssize) -1);
				document = _tmp67_;
				_tmp68_ = js_context;
				_tmp69_ = command;
				_tmp70_ = jsc_value_new_string (_tmp68_, _tmp69_);
				_tmp71_ = js_context;
				_tmp72_ = jsc_value_new_boolean (_tmp71_, FALSE);
				_tmp73_ = js_context;
				_tmp74_ = argument;
				_tmp75_ = jsc_value_new_string (_tmp73_, _tmp74_);
				_tmp76_ = g_new0 (JSCValue*, 3 + 1);
				_tmp76_[0] = _tmp70_;
				_tmp76_[1] = _tmp72_;
				_tmp76_[2] = _tmp75_;
				parameters = _tmp76_;
				parameters_length1 = 3;
				_parameters_size_ = parameters_length1;
				_tmp77_ = command;
				if (g_strcmp0 (_tmp77_, "insertImage") == 0) {
					const gchar* _tmp78_;
					gchar* _tmp79_;
					_tmp78_ = argument;
					_tmp79_ = g_strdup (_tmp78_);
					self->priv->image_uris = g_list_append (self->priv->image_uris, _tmp79_);
				}
				_tmp80_ = document;
				_tmp81_ = parameters;
				_tmp81__length1 = parameters_length1;
				_tmp82_ = jsc_value_object_invoke_methodv (_tmp80_, "execCommand", (guint) _tmp81__length1, _tmp81_);
				ret = _tmp82_;
				_tmp84_ = ret;
				if (!jsc_value_is_boolean (_tmp84_)) {
					_tmp83_ = TRUE;
				} else {
					JSCValue* _tmp85_;
					_tmp85_ = ret;
					_tmp83_ = jsc_value_to_boolean (_tmp85_) == FALSE;
				}
				if (_tmp83_) {
					JSCValue* _tmp86_;
					gchar* _tmp87_;
					gchar* _tmp88_;
					_tmp86_ = ret;
					_tmp87_ = jsc_value_to_string (_tmp86_);
					_tmp88_ = _tmp87_;
					g_critical ("MailPage.vala:152: %s", _tmp88_);
					_g_free0 (_tmp88_);
				}
				result = TRUE;
				_g_object_unref0 (ret);
				parameters = (_vala_array_free (parameters, parameters_length1, (GDestroyNotify) g_object_unref), NULL);
				_g_object_unref0 (document);
				_g_free0 (argument);
				_g_free0 (command);
				_g_object_unref0 (js_context);
				return result;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label5) ? _tmp5_label5 : (_tmp5_label5 = g_quark_from_static_string ("query-command-state")))) {
		switch (0) {
			default:
			{
				const gchar* command = NULL;
				GVariant* _tmp89_;
				GVariant* _tmp90_;
				const gchar* _tmp91_;
				JSCValue* document = NULL;
				JSCContext* _tmp92_;
				JSCValue* _tmp93_;
				JSCValue** parameters = NULL;
				JSCContext* _tmp94_;
				const gchar* _tmp95_;
				JSCValue* _tmp96_;
				JSCValue** _tmp97_;
				gint parameters_length1;
				gint _parameters_size_;
				JSCValue* ret = NULL;
				JSCValue* _tmp98_;
				JSCValue** _tmp99_;
				gint _tmp99__length1;
				JSCValue* _tmp100_;
				JSCValue* _tmp101_;
				_tmp89_ = webkit_user_message_get_parameters (message);
				_tmp90_ = _tmp89_;
				_tmp91_ = g_variant_get_string (_tmp90_, NULL);
				command = _tmp91_;
				_tmp92_ = js_context;
				_tmp93_ = jsc_context_evaluate (_tmp92_, "document", (gssize) -1);
				document = _tmp93_;
				_tmp94_ = js_context;
				_tmp95_ = command;
				_tmp96_ = jsc_value_new_string (_tmp94_, _tmp95_);
				_tmp97_ = g_new0 (JSCValue*, 1 + 1);
				_tmp97_[0] = _tmp96_;
				parameters = _tmp97_;
				parameters_length1 = 1;
				_parameters_size_ = parameters_length1;
				_tmp98_ = document;
				_tmp99_ = parameters;
				_tmp99__length1 = parameters_length1;
				_tmp100_ = jsc_value_object_invoke_methodv (_tmp98_, "queryCommandState", (guint) _tmp99__length1, _tmp99_);
				ret = _tmp100_;
				_tmp101_ = ret;
				if (jsc_value_is_boolean (_tmp101_)) {
					JSCValue* _tmp102_;
					GVariant* _tmp103_;
					GVariant* _tmp104_;
					WebKitUserMessage* _tmp105_;
					WebKitUserMessage* _tmp106_;
					_tmp102_ = ret;
					_tmp103_ = g_variant_new_boolean (jsc_value_to_boolean (_tmp102_));
					g_variant_ref_sink (_tmp103_);
					_tmp104_ = _tmp103_;
					_tmp105_ = webkit_user_message_new ("query-command-state", _tmp104_);
					g_object_ref_sink (_tmp105_);
					_tmp106_ = _tmp105_;
					webkit_user_message_send_reply (message, _tmp106_);
					_g_object_unref0 (_tmp106_);
					_g_variant_unref0 (_tmp104_);
				} else {
					JSCValue* _tmp107_;
					gchar* _tmp108_;
					gchar* _tmp109_;
					_tmp107_ = ret;
					_tmp108_ = jsc_value_to_string (_tmp107_);
					_tmp109_ = _tmp108_;
					g_critical ("MailPage.vala:166: %s", _tmp109_);
					_g_free0 (_tmp109_);
				}
				result = TRUE;
				_g_object_unref0 (ret);
				parameters = (_vala_array_free (parameters, parameters_length1, (GDestroyNotify) g_object_unref), NULL);
				_g_object_unref0 (document);
				_g_object_unref0 (js_context);
				return result;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label6) ? _tmp5_label6 : (_tmp5_label6 = g_quark_from_static_string ("get-selected-text")))) {
		switch (0) {
			default:
			{
				JSCValue* val = NULL;
				JSCContext* _tmp110_;
				JSCValue* _tmp111_;
				JSCValue* _tmp112_;
				_tmp110_ = js_context;
				_tmp111_ = jsc_context_evaluate (_tmp110_, "document.defaultView.getSelection().getRangeAt(0).toString();", (gssize) -1);
				val = _tmp111_;
				_tmp112_ = val;
				if (jsc_value_is_string (_tmp112_)) {
					JSCValue* _tmp113_;
					gchar* _tmp114_;
					gchar* _tmp115_;
					GVariant* _tmp116_;
					GVariant* _tmp117_;
					WebKitUserMessage* _tmp118_;
					WebKitUserMessage* _tmp119_;
					_tmp113_ = val;
					_tmp114_ = jsc_value_to_string (_tmp113_);
					_tmp115_ = _tmp114_;
					_tmp116_ = g_variant_new_string (_tmp115_);
					g_variant_ref_sink (_tmp116_);
					_tmp117_ = _tmp116_;
					_tmp118_ = webkit_user_message_new ("get-selected-text", _tmp117_);
					g_object_ref_sink (_tmp118_);
					_tmp119_ = _tmp118_;
					webkit_user_message_send_reply (message, _tmp119_);
					_g_object_unref0 (_tmp119_);
					_g_variant_unref0 (_tmp117_);
					_g_free0 (_tmp115_);
				} else {
					JSCValue* _tmp120_;
					gchar* _tmp121_;
					gchar* _tmp122_;
					_tmp120_ = val;
					_tmp121_ = jsc_value_to_string (_tmp120_);
					_tmp122_ = _tmp121_;
					g_critical ("MailPage.vala:175: no selection range: %s", _tmp122_);
					_g_free0 (_tmp122_);
				}
				result = TRUE;
				_g_object_unref0 (val);
				_g_object_unref0 (js_context);
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				const gchar* _tmp123_;
				const gchar* _tmp124_;
				_tmp123_ = webkit_user_message_get_name (message);
				_tmp124_ = _tmp123_;
				g_critical ("MailPage.vala:180: Unhandled message name: %s", _tmp124_);
				break;
			}
		}
	}
	result = FALSE;
	_g_object_unref0 (js_context);
	return result;
}

static gboolean
_vala_string_array_contains (const gchar* * stack,
                             gssize stack_length,
                             const const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static gboolean
mail_page_on_send_request (MailPage* self,
                           WebKitWebPage* page,
                           WebKitURIRequest* request,
                           WebKitURIResponse* response)
{
	gboolean should_load = FALSE;
	GUri* uri = NULL;
	gboolean _tmp7_ = FALSE;
	GUri* _tmp8_;
	gboolean _tmp13_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (page != NULL, FALSE);
	g_return_val_if_fail (request != NULL, FALSE);
	should_load = FALSE;
	uri = NULL;
	{
		GUri* _tmp0_ = NULL;
		const gchar* _tmp1_;
		GUri* _tmp2_;
		GUri* _tmp3_;
		_tmp1_ = webkit_uri_request_get_uri (request);
		_tmp2_ = g_uri_parse (_tmp1_, G_URI_FLAGS_NONE, &_inner_error0_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_uri_unref0 (uri);
		uri = _tmp3_;
		_g_uri_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("MailPage.vala:194: Could not parse uri: %s", _tmp5_);
		result = should_load;
		_g_error_free0 (e);
		_g_uri_unref0 (uri);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp6_ = FALSE;
		_g_uri_unref0 (uri);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp6_;
	}
	_tmp8_ = uri;
	if (_tmp8_ != NULL) {
		GUri* _tmp9_;
		const gchar* _tmp10_;
		_tmp9_ = uri;
		_tmp10_ = g_uri_get_scheme (_tmp9_);
		_tmp7_ = _vala_string_array_contains (MAIL_PAGE_ALLOWED_SCHEMES, G_N_ELEMENTS (MAIL_PAGE_ALLOWED_SCHEMES), _tmp10_);
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		should_load = TRUE;
	} else {
		if (self->priv->show_images) {
			should_load = TRUE;
		} else {
			WebKitUserMessage* _tmp11_;
			WebKitUserMessage* _tmp12_;
			_tmp11_ = webkit_user_message_new ("image-load-blocked", NULL);
			g_object_ref_sink (_tmp11_);
			_tmp12_ = _tmp11_;
			webkit_web_page_send_message_to_view (page, _tmp12_, NULL, NULL, NULL);
			_g_object_unref0 (_tmp12_);
		}
	}
	if (should_load) {
		_tmp13_ = GDK_EVENT_PROPAGATE;
	} else {
		_tmp13_ = GDK_EVENT_STOP;
	}
	result = _tmp13_;
	_g_uri_unref0 (uri);
	return result;
}

static void
mail_page_class_init (MailPageClass * klass,
                      gpointer klass_data)
{
	mail_page_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MailPage_private_offset);
	G_OBJECT_CLASS (klass)->finalize = mail_page_finalize;
}

static void
mail_page_instance_init (MailPage * self,
                         gpointer klass)
{
	self->priv = mail_page_get_instance_private (self);
	self->priv->show_images = FALSE;
}

static void
mail_page_finalize (GObject * obj)
{
	MailPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAIL_TYPE_PAGE, MailPage);
	(self->priv->image_uris == NULL) ? NULL : (self->priv->image_uris = (_g_list_free__g_free0_ (self->priv->image_uris), NULL));
	G_OBJECT_CLASS (mail_page_parent_class)->finalize (obj);
}

static GType
mail_page_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MailPageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mail_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MailPage), 0, (GInstanceInitFunc) mail_page_instance_init, NULL };
	GType mail_page_type_id;
	mail_page_type_id = g_type_register_static (G_TYPE_OBJECT, "MailPage", &g_define_type_info, 0);
	MailPage_private_offset = g_type_add_instance_private (mail_page_type_id, sizeof (MailPagePrivate));
	return mail_page_type_id;
}

GType
mail_page_get_type (void)
{
	static volatile gsize mail_page_type_id__once = 0;
	if (g_once_init_enter (&mail_page_type_id__once)) {
		GType mail_page_type_id;
		mail_page_type_id = mail_page_get_type_once ();
		g_once_init_leave (&mail_page_type_id__once, mail_page_type_id);
	}
	return mail_page_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

