// python wrapper for vtkCameraManipulator
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkCameraManipulator.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkCameraManipulator(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkCameraManipulator_ClassNew(); }


static PyObject *
PyvtkCameraManipulator_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkCameraManipulator::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCameraManipulator_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCameraManipulator *op = static_cast<vtkCameraManipulator *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkCameraManipulator::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCameraManipulator_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkCameraManipulator *tempr = vtkCameraManipulator::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCameraManipulator_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCameraManipulator *op = static_cast<vtkCameraManipulator *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkCameraManipulator *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkCameraManipulator::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCameraManipulator_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkCameraManipulator::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCameraManipulator_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCameraManipulator *op = static_cast<vtkCameraManipulator *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkCameraManipulator::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCameraManipulator_StartInteraction(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "StartInteraction");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCameraManipulator *op = static_cast<vtkCameraManipulator *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->StartInteraction();
    }
    else
    {
      op->vtkCameraManipulator::StartInteraction();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCameraManipulator_EndInteraction(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "EndInteraction");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCameraManipulator *op = static_cast<vtkCameraManipulator *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->EndInteraction();
    }
    else
    {
      op->vtkCameraManipulator::EndInteraction();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCameraManipulator_OnMouseMove(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "OnMouseMove");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCameraManipulator *op = static_cast<vtkCameraManipulator *>(vp);

  int temp0;
  int temp1;
  vtkRenderer *temp2 = nullptr;
  vtkRenderWindowInteractor *temp3 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetVTKObject(temp2, "vtkRenderer") &&
      ap.GetVTKObject(temp3, "vtkRenderWindowInteractor"))
  {
    if (ap.IsBound())
    {
      op->OnMouseMove(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkCameraManipulator::OnMouseMove(temp0, temp1, temp2, temp3);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCameraManipulator_OnButtonDown(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "OnButtonDown");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCameraManipulator *op = static_cast<vtkCameraManipulator *>(vp);

  int temp0;
  int temp1;
  vtkRenderer *temp2 = nullptr;
  vtkRenderWindowInteractor *temp3 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetVTKObject(temp2, "vtkRenderer") &&
      ap.GetVTKObject(temp3, "vtkRenderWindowInteractor"))
  {
    if (ap.IsBound())
    {
      op->OnButtonDown(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkCameraManipulator::OnButtonDown(temp0, temp1, temp2, temp3);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCameraManipulator_OnButtonUp(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "OnButtonUp");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCameraManipulator *op = static_cast<vtkCameraManipulator *>(vp);

  int temp0;
  int temp1;
  vtkRenderer *temp2 = nullptr;
  vtkRenderWindowInteractor *temp3 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetVTKObject(temp2, "vtkRenderer") &&
      ap.GetVTKObject(temp3, "vtkRenderWindowInteractor"))
  {
    if (ap.IsBound())
    {
      op->OnButtonUp(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkCameraManipulator::OnButtonUp(temp0, temp1, temp2, temp3);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCameraManipulator_OnKeyUp(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "OnKeyUp");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCameraManipulator *op = static_cast<vtkCameraManipulator *>(vp);

  vtkRenderWindowInteractor *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkRenderWindowInteractor"))
  {
    if (ap.IsBound())
    {
      op->OnKeyUp(temp0);
    }
    else
    {
      op->vtkCameraManipulator::OnKeyUp(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCameraManipulator_OnKeyDown(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "OnKeyDown");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCameraManipulator *op = static_cast<vtkCameraManipulator *>(vp);

  vtkRenderWindowInteractor *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkRenderWindowInteractor"))
  {
    if (ap.IsBound())
    {
      op->OnKeyDown(temp0);
    }
    else
    {
      op->vtkCameraManipulator::OnKeyDown(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCameraManipulator_SetButton(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetButton");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCameraManipulator *op = static_cast<vtkCameraManipulator *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetButton(temp0);
    }
    else
    {
      op->vtkCameraManipulator::SetButton(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCameraManipulator_GetButton(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetButton");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCameraManipulator *op = static_cast<vtkCameraManipulator *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetButton() :
      op->vtkCameraManipulator::GetButton());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCameraManipulator_SetShift(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetShift");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCameraManipulator *op = static_cast<vtkCameraManipulator *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetShift(temp0);
    }
    else
    {
      op->vtkCameraManipulator::SetShift(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCameraManipulator_GetShift(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetShift");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCameraManipulator *op = static_cast<vtkCameraManipulator *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetShift() :
      op->vtkCameraManipulator::GetShift());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCameraManipulator_ShiftOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ShiftOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCameraManipulator *op = static_cast<vtkCameraManipulator *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ShiftOn();
    }
    else
    {
      op->vtkCameraManipulator::ShiftOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCameraManipulator_ShiftOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ShiftOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCameraManipulator *op = static_cast<vtkCameraManipulator *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ShiftOff();
    }
    else
    {
      op->vtkCameraManipulator::ShiftOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCameraManipulator_SetControl(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetControl");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCameraManipulator *op = static_cast<vtkCameraManipulator *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetControl(temp0);
    }
    else
    {
      op->vtkCameraManipulator::SetControl(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCameraManipulator_GetControl(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetControl");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCameraManipulator *op = static_cast<vtkCameraManipulator *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetControl() :
      op->vtkCameraManipulator::GetControl());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCameraManipulator_ControlOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ControlOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCameraManipulator *op = static_cast<vtkCameraManipulator *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ControlOn();
    }
    else
    {
      op->vtkCameraManipulator::ControlOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCameraManipulator_ControlOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ControlOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCameraManipulator *op = static_cast<vtkCameraManipulator *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ControlOff();
    }
    else
    {
      op->vtkCameraManipulator::ControlOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCameraManipulator_SetCenter_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCenter");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCameraManipulator *op = static_cast<vtkCameraManipulator *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetCenter(temp0, temp1, temp2);
    }
    else
    {
      op->vtkCameraManipulator::SetCenter(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkCameraManipulator_SetCenter_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCenter");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCameraManipulator *op = static_cast<vtkCameraManipulator *>(vp);

  const size_t size0 = 3;
  double temp0[3];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->SetCenter(temp0);
    }
    else
    {
      op->vtkCameraManipulator::SetCenter(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkCameraManipulator_SetCenter(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyvtkCameraManipulator_SetCenter_s1(self, args);
    case 1:
      return PyvtkCameraManipulator_SetCenter_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetCenter");
  return nullptr;
}


static PyObject *
PyvtkCameraManipulator_GetCenter(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCenter");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCameraManipulator *op = static_cast<vtkCameraManipulator *>(vp);

  size_t sizer = 3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double *tempr = (ap.IsBound() ?
      op->GetCenter() :
      op->vtkCameraManipulator::GetCenter());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyvtkCameraManipulator_SetRotationFactor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRotationFactor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCameraManipulator *op = static_cast<vtkCameraManipulator *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRotationFactor(temp0);
    }
    else
    {
      op->vtkCameraManipulator::SetRotationFactor(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCameraManipulator_GetRotationFactor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRotationFactor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCameraManipulator *op = static_cast<vtkCameraManipulator *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetRotationFactor() :
      op->vtkCameraManipulator::GetRotationFactor());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCameraManipulator_SetManipulatorName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetManipulatorName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCameraManipulator *op = static_cast<vtkCameraManipulator *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetManipulatorName(temp0);
    }
    else
    {
      op->vtkCameraManipulator::SetManipulatorName(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCameraManipulator_GetManipulatorName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetManipulatorName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCameraManipulator *op = static_cast<vtkCameraManipulator *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetManipulatorName() :
      op->vtkCameraManipulator::GetManipulatorName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCameraManipulator_SetGUIHelper(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetGUIHelper");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCameraManipulator *op = static_cast<vtkCameraManipulator *>(vp);

  vtkCameraManipulatorGUIHelper *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkCameraManipulatorGUIHelper"))
  {
    if (ap.IsBound())
    {
      op->SetGUIHelper(temp0);
    }
    else
    {
      op->vtkCameraManipulator::SetGUIHelper(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCameraManipulator_GetGUIHelper(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetGUIHelper");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCameraManipulator *op = static_cast<vtkCameraManipulator *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkCameraManipulatorGUIHelper *tempr = (ap.IsBound() ?
      op->GetGUIHelper() :
      op->vtkCameraManipulator::GetGUIHelper());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkCameraManipulator_Methods[] = {
  {"IsTypeOf", PyvtkCameraManipulator_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkCameraManipulator_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkCameraManipulator_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkCameraManipulator\nC++: static vtkCameraManipulator *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkCameraManipulator_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkCameraManipulator\nC++: vtkCameraManipulator *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkCameraManipulator_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkCameraManipulator_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"StartInteraction", PyvtkCameraManipulator_StartInteraction, METH_VARARGS,
   "StartInteraction(self) -> None\nC++: virtual void StartInteraction()\n\nEvent bindings controlling the effects of pressing mouse buttons\nor moving the mouse.\n"},
  {"EndInteraction", PyvtkCameraManipulator_EndInteraction, METH_VARARGS,
   "EndInteraction(self) -> None\nC++: virtual void EndInteraction()\n\n"},
  {"OnMouseMove", PyvtkCameraManipulator_OnMouseMove, METH_VARARGS,
   "OnMouseMove(self, x:int, y:int, ren:vtkRenderer,\n    iren:vtkRenderWindowInteractor) -> None\nC++: virtual void OnMouseMove(int x, int y, vtkRenderer *ren,\n    vtkRenderWindowInteractor *iren)\n\n"},
  {"OnButtonDown", PyvtkCameraManipulator_OnButtonDown, METH_VARARGS,
   "OnButtonDown(self, x:int, y:int, ren:vtkRenderer,\n    iren:vtkRenderWindowInteractor) -> None\nC++: virtual void OnButtonDown(int x, int y, vtkRenderer *ren,\n    vtkRenderWindowInteractor *iren)\n\n"},
  {"OnButtonUp", PyvtkCameraManipulator_OnButtonUp, METH_VARARGS,
   "OnButtonUp(self, x:int, y:int, ren:vtkRenderer,\n    iren:vtkRenderWindowInteractor) -> None\nC++: virtual void OnButtonUp(int x, int y, vtkRenderer *ren,\n    vtkRenderWindowInteractor *iren)\n\n"},
  {"OnKeyUp", PyvtkCameraManipulator_OnKeyUp, METH_VARARGS,
   "OnKeyUp(self, iren:vtkRenderWindowInteractor) -> None\nC++: virtual void OnKeyUp(vtkRenderWindowInteractor *iren)\n\nThese methods are called on all registered manipulators, not just\nthe active one. Hence, these should just be used to record state\nand not perform any interactions.\n"},
  {"OnKeyDown", PyvtkCameraManipulator_OnKeyDown, METH_VARARGS,
   "OnKeyDown(self, iren:vtkRenderWindowInteractor) -> None\nC++: virtual void OnKeyDown(vtkRenderWindowInteractor *iren)\n\n"},
  {"SetButton", PyvtkCameraManipulator_SetButton, METH_VARARGS,
   "SetButton(self, _arg:int) -> None\nC++: virtual void SetButton(int _arg)\n\nThese settings determine which button and modifiers the\nmanipulator responds to. Button can be either 1 (left), 2\n(middle), and 3 right.\n"},
  {"GetButton", PyvtkCameraManipulator_GetButton, METH_VARARGS,
   "GetButton(self) -> int\nC++: virtual int GetButton()\n\n"},
  {"SetShift", PyvtkCameraManipulator_SetShift, METH_VARARGS,
   "SetShift(self, _arg:int) -> None\nC++: virtual void SetShift(int _arg)\n\n"},
  {"GetShift", PyvtkCameraManipulator_GetShift, METH_VARARGS,
   "GetShift(self) -> int\nC++: virtual int GetShift()\n\n"},
  {"ShiftOn", PyvtkCameraManipulator_ShiftOn, METH_VARARGS,
   "ShiftOn(self) -> None\nC++: virtual void ShiftOn()\n\n"},
  {"ShiftOff", PyvtkCameraManipulator_ShiftOff, METH_VARARGS,
   "ShiftOff(self) -> None\nC++: virtual void ShiftOff()\n\n"},
  {"SetControl", PyvtkCameraManipulator_SetControl, METH_VARARGS,
   "SetControl(self, _arg:int) -> None\nC++: virtual void SetControl(int _arg)\n\n"},
  {"GetControl", PyvtkCameraManipulator_GetControl, METH_VARARGS,
   "GetControl(self) -> int\nC++: virtual int GetControl()\n\n"},
  {"ControlOn", PyvtkCameraManipulator_ControlOn, METH_VARARGS,
   "ControlOn(self) -> None\nC++: virtual void ControlOn()\n\n"},
  {"ControlOff", PyvtkCameraManipulator_ControlOff, METH_VARARGS,
   "ControlOff(self) -> None\nC++: virtual void ControlOff()\n\n"},
  {"SetCenter", PyvtkCameraManipulator_SetCenter, METH_VARARGS,
   "SetCenter(self, _arg1:float, _arg2:float, _arg3:float) -> None\nC++: virtual void SetCenter(double _arg1, double _arg2,\n    double _arg3)\nSetCenter(self, _arg:(float, float, float)) -> None\nC++: virtual void SetCenter(const double _arg[3])\n\nFor setting the center of rotation.\n"},
  {"GetCenter", PyvtkCameraManipulator_GetCenter, METH_VARARGS,
   "GetCenter(self) -> (float, float, float)\nC++: virtual double *GetCenter()\n\n"},
  {"SetRotationFactor", PyvtkCameraManipulator_SetRotationFactor, METH_VARARGS,
   "SetRotationFactor(self, _arg:float) -> None\nC++: virtual void SetRotationFactor(double _arg)\n\nSet and get the rotation factor.\n"},
  {"GetRotationFactor", PyvtkCameraManipulator_GetRotationFactor, METH_VARARGS,
   "GetRotationFactor(self) -> float\nC++: virtual double GetRotationFactor()\n\n"},
  {"SetManipulatorName", PyvtkCameraManipulator_SetManipulatorName, METH_VARARGS,
   "SetManipulatorName(self, _arg:str) -> None\nC++: virtual void SetManipulatorName(const char *_arg)\n\nSet and get the manipulator name.\n"},
  {"GetManipulatorName", PyvtkCameraManipulator_GetManipulatorName, METH_VARARGS,
   "GetManipulatorName(self) -> str\nC++: virtual char *GetManipulatorName()\n\n"},
  {"SetGUIHelper", PyvtkCameraManipulator_SetGUIHelper, METH_VARARGS,
   "SetGUIHelper(self, __a:vtkCameraManipulatorGUIHelper) -> None\nC++: void SetGUIHelper(vtkCameraManipulatorGUIHelper *)\n\nGet/Set the GUI helper.\n"},
  {"GetGUIHelper", PyvtkCameraManipulator_GetGUIHelper, METH_VARARGS,
   "GetGUIHelper(self) -> vtkCameraManipulatorGUIHelper\nC++: virtual vtkCameraManipulatorGUIHelper *GetGUIHelper()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkCameraManipulator_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("button"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkCameraManipulator_GetButton(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkCameraManipulator_SetButton(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkCameraManipulator_SetButton(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetButton/SetButton\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("shift"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkCameraManipulator_GetShift(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkCameraManipulator_SetShift(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkCameraManipulator_SetShift(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetShift/SetShift\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("control"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkCameraManipulator_GetControl(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkCameraManipulator_SetControl(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkCameraManipulator_SetControl(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetControl/SetControl\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("center"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkCameraManipulator_GetCenter(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkCameraManipulator_SetCenter(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkCameraManipulator_SetCenter(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetCenter/SetCenter\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("rotation_factor"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkCameraManipulator_GetRotationFactor(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkCameraManipulator_SetRotationFactor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkCameraManipulator_SetRotationFactor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetRotationFactor/SetRotationFactor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("manipulator_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkCameraManipulator_GetManipulatorName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkCameraManipulator_SetManipulatorName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkCameraManipulator_SetManipulatorName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetManipulatorName/SetManipulatorName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("gui_helper"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkCameraManipulator_GetGUIHelper(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkCameraManipulator_SetGUIHelper(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkCameraManipulator_SetGUIHelper(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetGUIHelper/SetGUIHelper\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkCameraManipulator_Doc =
  "vtkCameraManipulator - Abstraction of style away from button.\n\n"
  "Superclass: vtkObject\n\n"
  "vtkCameraManipulator is a superclass foractions inside an interactor\n"
  "style and associated with a single button. An example might be\n"
  "rubber-band bounding-box zoom. This abstraction allows a camera\n"
  "manipulator to be assigned to any button.  This super class might\n"
  "become a subclass of vtkInteractorObserver in the future.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkCameraManipulator_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkPVVTKExtensionsInteractionStyle.vtkCameraManipulator", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkCameraManipulator_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkCameraManipulator_StaticNew()
{
  return vtkCameraManipulator::New();
}

PyObject *PyvtkCameraManipulator_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkCameraManipulator_Type, PyvtkCameraManipulator_Methods,
    "vtkCameraManipulator",
 &PyvtkCameraManipulator_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkObject");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkCameraManipulator_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkCameraManipulator(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkCameraManipulator_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkCameraManipulator", o) != 0)
  {
    Py_DECREF(o);
  }

}

