// python wrapper for vtkPVRayCastPickingHelper
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkPVRayCastPickingHelper.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPVRayCastPickingHelper(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPVRayCastPickingHelper_ClassNew(); }


static PyObject *
PyvtkPVRayCastPickingHelper_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkPVRayCastPickingHelper::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRayCastPickingHelper_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRayCastPickingHelper *op = static_cast<vtkPVRayCastPickingHelper *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkPVRayCastPickingHelper::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRayCastPickingHelper_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkPVRayCastPickingHelper *tempr = vtkPVRayCastPickingHelper::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRayCastPickingHelper_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRayCastPickingHelper *op = static_cast<vtkPVRayCastPickingHelper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVRayCastPickingHelper *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkPVRayCastPickingHelper::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRayCastPickingHelper_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkPVRayCastPickingHelper::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRayCastPickingHelper_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRayCastPickingHelper *op = static_cast<vtkPVRayCastPickingHelper *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkPVRayCastPickingHelper::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRayCastPickingHelper_SetInput(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetInput");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRayCastPickingHelper *op = static_cast<vtkPVRayCastPickingHelper *>(vp);

  vtkAlgorithm *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkAlgorithm"))
  {
    if (ap.IsBound())
    {
      op->SetInput(temp0);
    }
    else
    {
      op->vtkPVRayCastPickingHelper::SetInput(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRayCastPickingHelper_SetSelection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSelection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRayCastPickingHelper *op = static_cast<vtkPVRayCastPickingHelper *>(vp);

  vtkAlgorithm *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkAlgorithm"))
  {
    if (ap.IsBound())
    {
      op->SetSelection(temp0);
    }
    else
    {
      op->vtkPVRayCastPickingHelper::SetSelection(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRayCastPickingHelper_SetPointA_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPointA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRayCastPickingHelper *op = static_cast<vtkPVRayCastPickingHelper *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetPointA(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVRayCastPickingHelper::SetPointA(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVRayCastPickingHelper_SetPointA_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPointA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRayCastPickingHelper *op = static_cast<vtkPVRayCastPickingHelper *>(vp);

  const size_t size0 = 3;
  double temp0[3];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->SetPointA(temp0);
    }
    else
    {
      op->vtkPVRayCastPickingHelper::SetPointA(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVRayCastPickingHelper_SetPointA(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyvtkPVRayCastPickingHelper_SetPointA_s1(self, args);
    case 1:
      return PyvtkPVRayCastPickingHelper_SetPointA_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetPointA");
  return nullptr;
}


static PyObject *
PyvtkPVRayCastPickingHelper_GetPointA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPointA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRayCastPickingHelper *op = static_cast<vtkPVRayCastPickingHelper *>(vp);

  size_t sizer = 3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double *tempr = (ap.IsBound() ?
      op->GetPointA() :
      op->vtkPVRayCastPickingHelper::GetPointA());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRayCastPickingHelper_SetPointB_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPointB");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRayCastPickingHelper *op = static_cast<vtkPVRayCastPickingHelper *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetPointB(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVRayCastPickingHelper::SetPointB(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVRayCastPickingHelper_SetPointB_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPointB");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRayCastPickingHelper *op = static_cast<vtkPVRayCastPickingHelper *>(vp);

  const size_t size0 = 3;
  double temp0[3];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->SetPointB(temp0);
    }
    else
    {
      op->vtkPVRayCastPickingHelper::SetPointB(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVRayCastPickingHelper_SetPointB(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyvtkPVRayCastPickingHelper_SetPointB_s1(self, args);
    case 1:
      return PyvtkPVRayCastPickingHelper_SetPointB_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetPointB");
  return nullptr;
}


static PyObject *
PyvtkPVRayCastPickingHelper_GetPointB(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPointB");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRayCastPickingHelper *op = static_cast<vtkPVRayCastPickingHelper *>(vp);

  size_t sizer = 3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double *tempr = (ap.IsBound() ?
      op->GetPointB() :
      op->vtkPVRayCastPickingHelper::GetPointB());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRayCastPickingHelper_SetSnapOnMeshPoint(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSnapOnMeshPoint");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRayCastPickingHelper *op = static_cast<vtkPVRayCastPickingHelper *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSnapOnMeshPoint(temp0);
    }
    else
    {
      op->vtkPVRayCastPickingHelper::SetSnapOnMeshPoint(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRayCastPickingHelper_GetSnapOnMeshPoint(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSnapOnMeshPoint");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRayCastPickingHelper *op = static_cast<vtkPVRayCastPickingHelper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetSnapOnMeshPoint() :
      op->vtkPVRayCastPickingHelper::GetSnapOnMeshPoint());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRayCastPickingHelper_ComputeIntersection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ComputeIntersection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRayCastPickingHelper *op = static_cast<vtkPVRayCastPickingHelper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ComputeIntersection();
    }
    else
    {
      op->vtkPVRayCastPickingHelper::ComputeIntersection();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRayCastPickingHelper_GetIntersection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetIntersection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRayCastPickingHelper *op = static_cast<vtkPVRayCastPickingHelper *>(vp);

  size_t sizer = 3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double *tempr = (ap.IsBound() ?
      op->GetIntersection() :
      op->vtkPVRayCastPickingHelper::GetIntersection());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRayCastPickingHelper_GetIntersectionNormal(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetIntersectionNormal");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRayCastPickingHelper *op = static_cast<vtkPVRayCastPickingHelper *>(vp);

  size_t sizer = 3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double *tempr = (ap.IsBound() ?
      op->GetIntersectionNormal() :
      op->vtkPVRayCastPickingHelper::GetIntersectionNormal());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}

static PyMethodDef PyvtkPVRayCastPickingHelper_Methods[] = {
  {"IsTypeOf", PyvtkPVRayCastPickingHelper_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkPVRayCastPickingHelper_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkPVRayCastPickingHelper_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkPVRayCastPickingHelper\nC++: static vtkPVRayCastPickingHelper *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkPVRayCastPickingHelper_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkPVRayCastPickingHelper\nC++: vtkPVRayCastPickingHelper *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkPVRayCastPickingHelper_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkPVRayCastPickingHelper_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetInput", PyvtkPVRayCastPickingHelper_SetInput, METH_VARARGS,
   "SetInput(self, __a:vtkAlgorithm) -> None\nC++: void SetInput(vtkAlgorithm *)\n\nSet input on which the selection apply\n"},
  {"SetSelection", PyvtkPVRayCastPickingHelper_SetSelection, METH_VARARGS,
   "SetSelection(self, __a:vtkAlgorithm) -> None\nC++: void SetSelection(vtkAlgorithm *)\n\nSet the selection that extract the cell that intersect the ray\n"},
  {"SetPointA", PyvtkPVRayCastPickingHelper_SetPointA, METH_VARARGS,
   "SetPointA(self, _arg1:float, _arg2:float, _arg3:float) -> None\nC++: virtual void SetPointA(double _arg1, double _arg2,\n    double _arg3)\nSetPointA(self, _arg:(float, float, float)) -> None\nC++: virtual void SetPointA(const double _arg[3])\n\nSet the point 1 that compose the ray\n"},
  {"GetPointA", PyvtkPVRayCastPickingHelper_GetPointA, METH_VARARGS,
   "GetPointA(self) -> (float, float, float)\nC++: virtual double *GetPointA()\n\n"},
  {"SetPointB", PyvtkPVRayCastPickingHelper_SetPointB, METH_VARARGS,
   "SetPointB(self, _arg1:float, _arg2:float, _arg3:float) -> None\nC++: virtual void SetPointB(double _arg1, double _arg2,\n    double _arg3)\nSetPointB(self, _arg:(float, float, float)) -> None\nC++: virtual void SetPointB(const double _arg[3])\n\nSet the point 2 that compose the ray\n"},
  {"GetPointB", PyvtkPVRayCastPickingHelper_GetPointB, METH_VARARGS,
   "GetPointB(self) -> (float, float, float)\nC++: virtual double *GetPointB()\n\n"},
  {"SetSnapOnMeshPoint", PyvtkPVRayCastPickingHelper_SetSnapOnMeshPoint, METH_VARARGS,
   "SetSnapOnMeshPoint(self, _arg:bool) -> None\nC++: virtual void SetSnapOnMeshPoint(bool _arg)\n\nSet the flag to use directly selected points on mesh as\nintersection\n"},
  {"GetSnapOnMeshPoint", PyvtkPVRayCastPickingHelper_GetSnapOnMeshPoint, METH_VARARGS,
   "GetSnapOnMeshPoint(self) -> bool\nC++: virtual bool GetSnapOnMeshPoint()\n\n"},
  {"ComputeIntersection", PyvtkPVRayCastPickingHelper_ComputeIntersection, METH_VARARGS,
   "ComputeIntersection(self) -> None\nC++: void ComputeIntersection()\n\nCompute the intersection\n"},
  {"GetIntersection", PyvtkPVRayCastPickingHelper_GetIntersection, METH_VARARGS,
   "GetIntersection(self) -> (float, float, float)\nC++: virtual double *GetIntersection()\n\n"},
  {"GetIntersectionNormal", PyvtkPVRayCastPickingHelper_GetIntersectionNormal, METH_VARARGS,
   "GetIntersectionNormal(self) -> (float, float, float)\nC++: virtual double *GetIntersectionNormal()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPVRayCastPickingHelper_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("input"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRayCastPickingHelper_SetInput(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRayCastPickingHelper_SetInput(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetInput\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("selection"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRayCastPickingHelper_SetSelection(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRayCastPickingHelper_SetSelection(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetSelection\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("point_a"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVRayCastPickingHelper_GetPointA(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRayCastPickingHelper_SetPointA(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRayCastPickingHelper_SetPointA(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetPointA/SetPointA\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("point_b"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVRayCastPickingHelper_GetPointB(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRayCastPickingHelper_SetPointB(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRayCastPickingHelper_SetPointB(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetPointB/SetPointB\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("snap_on_mesh_point"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVRayCastPickingHelper_GetSnapOnMeshPoint(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRayCastPickingHelper_SetSnapOnMeshPoint(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRayCastPickingHelper_SetSnapOnMeshPoint(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetSnapOnMeshPoint/SetSnapOnMeshPoint\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("intersection"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVRayCastPickingHelper_GetIntersection(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetIntersection\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("intersection_normal"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVRayCastPickingHelper_GetIntersectionNormal(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetIntersectionNormal\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkPVRayCastPickingHelper_Doc =
  "vtkPVRayCastPickingHelper - helper class that used selection and ray\ncasting to find the intersection point between the user picking point\nand the concreate cell underneath.\n\n"
  "Superclass: vtkObject\n\n"
;

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVRayCastPickingHelper_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingViews.vtkPVRayCastPickingHelper", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkPVRayCastPickingHelper_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkPVRayCastPickingHelper_StaticNew()
{
  return vtkPVRayCastPickingHelper::New();
}

PyObject *PyvtkPVRayCastPickingHelper_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkPVRayCastPickingHelper_Type, PyvtkPVRayCastPickingHelper_Methods,
    "vtkPVRayCastPickingHelper",
 &PyvtkPVRayCastPickingHelper_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkObject");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkPVRayCastPickingHelper_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPVRayCastPickingHelper(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPVRayCastPickingHelper_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkPVRayCastPickingHelper", o) != 0)
  {
    Py_DECREF(o);
  }

}

