// python wrapper for vtkSpyPlotUniReader
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkSpyPlotUniReader.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkSpyPlotUniReader(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkSpyPlotUniReader_ClassNew(); }


static PyObject *
PyvtkSpyPlotUniReader_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkSpyPlotUniReader::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotUniReader_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotUniReader *op = static_cast<vtkSpyPlotUniReader *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkSpyPlotUniReader::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotUniReader_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkSpyPlotUniReader *tempr = vtkSpyPlotUniReader::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotUniReader_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotUniReader *op = static_cast<vtkSpyPlotUniReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSpyPlotUniReader *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkSpyPlotUniReader::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotUniReader_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkSpyPlotUniReader::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotUniReader_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotUniReader *op = static_cast<vtkSpyPlotUniReader *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkSpyPlotUniReader::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotUniReader_SetFileName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFileName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotUniReader *op = static_cast<vtkSpyPlotUniReader *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetFilePath(temp0))
  {
    if (ap.IsBound())
    {
      op->SetFileName(temp0);
    }
    else
    {
      op->vtkSpyPlotUniReader::SetFileName(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotUniReader_GetFileName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFileName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotUniReader *op = static_cast<vtkSpyPlotUniReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetFileName() :
      op->vtkSpyPlotUniReader::GetFileName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotUniReader_SetCellArraySelection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCellArraySelection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotUniReader *op = static_cast<vtkSpyPlotUniReader *>(vp);

  vtkDataArraySelection *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkDataArraySelection"))
  {
    if (ap.IsBound())
    {
      op->SetCellArraySelection(temp0);
    }
    else
    {
      op->vtkSpyPlotUniReader::SetCellArraySelection(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotUniReader_ReadInformation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ReadInformation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotUniReader *op = static_cast<vtkSpyPlotUniReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->ReadInformation() :
      op->vtkSpyPlotUniReader::ReadInformation());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotUniReader_MakeCurrent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "MakeCurrent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotUniReader *op = static_cast<vtkSpyPlotUniReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->MakeCurrent() :
      op->vtkSpyPlotUniReader::MakeCurrent());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotUniReader_PrintInformation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "PrintInformation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotUniReader *op = static_cast<vtkSpyPlotUniReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->PrintInformation();
    }
    else
    {
      op->vtkSpyPlotUniReader::PrintInformation();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotUniReader_PrintMemoryUsage(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "PrintMemoryUsage");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotUniReader *op = static_cast<vtkSpyPlotUniReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->PrintMemoryUsage();
    }
    else
    {
      op->vtkSpyPlotUniReader::PrintMemoryUsage();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotUniReader_SetCurrentTime(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCurrentTime");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotUniReader *op = static_cast<vtkSpyPlotUniReader *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->SetCurrentTime(temp0) :
      op->vtkSpyPlotUniReader::SetCurrentTime(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotUniReader_GetCurrentTime(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCurrentTime");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotUniReader *op = static_cast<vtkSpyPlotUniReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetCurrentTime() :
      op->vtkSpyPlotUniReader::GetCurrentTime());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotUniReader_SetCurrentTimeStep(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCurrentTimeStep");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotUniReader *op = static_cast<vtkSpyPlotUniReader *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->SetCurrentTimeStep(temp0) :
      op->vtkSpyPlotUniReader::SetCurrentTimeStep(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotUniReader_GetCurrentTimeStep(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCurrentTimeStep");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotUniReader *op = static_cast<vtkSpyPlotUniReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetCurrentTimeStep() :
      op->vtkSpyPlotUniReader::GetCurrentTimeStep());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotUniReader_GetTimeStepRange(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTimeStepRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotUniReader *op = static_cast<vtkSpyPlotUniReader *>(vp);

  size_t sizer = 2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int *tempr = (ap.IsBound() ?
      op->GetTimeStepRange() :
      op->vtkSpyPlotUniReader::GetTimeStepRange());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotUniReader_GetTimeRange(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTimeRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotUniReader *op = static_cast<vtkSpyPlotUniReader *>(vp);

  size_t sizer = 2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double *tempr = (ap.IsBound() ?
      op->GetTimeRange() :
      op->vtkSpyPlotUniReader::GetTimeRange());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotUniReader_SetNeedToCheck(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNeedToCheck");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotUniReader *op = static_cast<vtkSpyPlotUniReader *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNeedToCheck(temp0);
    }
    else
    {
      op->vtkSpyPlotUniReader::SetNeedToCheck(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotUniReader_GetTimeStepFromTime(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTimeStepFromTime");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotUniReader *op = static_cast<vtkSpyPlotUniReader *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->GetTimeStepFromTime(temp0) :
      op->vtkSpyPlotUniReader::GetTimeStepFromTime(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotUniReader_GetTimeFromTimeStep(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTimeFromTimeStep");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotUniReader *op = static_cast<vtkSpyPlotUniReader *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    double tempr = (ap.IsBound() ?
      op->GetTimeFromTimeStep(temp0) :
      op->vtkSpyPlotUniReader::GetTimeFromTimeStep(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotUniReader_GetNumberOfCellFields(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfCellFields");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotUniReader *op = static_cast<vtkSpyPlotUniReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNumberOfCellFields() :
      op->vtkSpyPlotUniReader::GetNumberOfCellFields());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotUniReader_GetTimeArray(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTimeArray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotUniReader *op = static_cast<vtkSpyPlotUniReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double *tempr = (ap.IsBound() ?
      op->GetTimeArray() :
      op->vtkSpyPlotUniReader::GetTimeArray());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotUniReader_IsAMR(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsAMR");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotUniReader *op = static_cast<vtkSpyPlotUniReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->IsAMR() :
      op->vtkSpyPlotUniReader::IsAMR());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotUniReader_GetNumberOfDataBlocks(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfDataBlocks");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotUniReader *op = static_cast<vtkSpyPlotUniReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNumberOfDataBlocks() :
      op->vtkSpyPlotUniReader::GetNumberOfDataBlocks());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotUniReader_GetCellFieldName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCellFieldName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotUniReader *op = static_cast<vtkSpyPlotUniReader *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetCellFieldName(temp0) :
      op->vtkSpyPlotUniReader::GetCellFieldName(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotUniReader_GetCellFieldData(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCellFieldData");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotUniReader *op = static_cast<vtkSpyPlotUniReader *>(vp);

  int temp0;
  int temp1;
  size_t size2 = ap.GetArgSize(2);
  vtkPythonArgs::Array<int> store2(2*size2);
  int *temp2 = store2.Data();
  int *save2 = (size2 == 0 ? nullptr : temp2 + size2);
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetArray(temp2, size2))
  {
    vtkPythonArgs::Save(temp2, save2, size2);

    vtkDataArray *tempr = (ap.IsBound() ?
      op->GetCellFieldData(temp0, temp1, temp2) :
      op->vtkSpyPlotUniReader::GetCellFieldData(temp0, temp1, temp2));

    if (vtkPythonArgs::HasChanged(temp2, save2, size2) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(2, temp2, size2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotUniReader_GetMaterialMassField(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMaterialMassField");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotUniReader *op = static_cast<vtkSpyPlotUniReader *>(vp);

  int temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    vtkDataArray *tempr = (ap.IsBound() ?
      op->GetMaterialMassField(temp0, temp1) :
      op->vtkSpyPlotUniReader::GetMaterialMassField(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotUniReader_GetMaterialVolumeFractionField(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMaterialVolumeFractionField");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotUniReader *op = static_cast<vtkSpyPlotUniReader *>(vp);

  int temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    vtkDataArray *tempr = (ap.IsBound() ?
      op->GetMaterialVolumeFractionField(temp0, temp1) :
      op->vtkSpyPlotUniReader::GetMaterialVolumeFractionField(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotUniReader_MarkCellFieldDataFixed(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "MarkCellFieldDataFixed");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotUniReader *op = static_cast<vtkSpyPlotUniReader *>(vp);

  int temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    int tempr = (ap.IsBound() ?
      op->MarkCellFieldDataFixed(temp0, temp1) :
      op->vtkSpyPlotUniReader::MarkCellFieldDataFixed(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotUniReader_GetTracers(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTracers");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotUniReader *op = static_cast<vtkSpyPlotUniReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkFloatArray *tempr = (ap.IsBound() ?
      op->GetTracers() :
      op->vtkSpyPlotUniReader::GetTracers());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotUniReader_GetNumberOfMaterials(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfMaterials");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotUniReader *op = static_cast<vtkSpyPlotUniReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNumberOfMaterials() :
      op->vtkSpyPlotUniReader::GetNumberOfMaterials());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotUniReader_GetNumberOfDimensions(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfDimensions");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotUniReader *op = static_cast<vtkSpyPlotUniReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNumberOfDimensions() :
      op->vtkSpyPlotUniReader::GetNumberOfDimensions());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotUniReader_GetCoordinateSystem(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCoordinateSystem");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotUniReader *op = static_cast<vtkSpyPlotUniReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetCoordinateSystem() :
      op->vtkSpyPlotUniReader::GetCoordinateSystem());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotUniReader_SetGenerateMarkers(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetGenerateMarkers");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotUniReader *op = static_cast<vtkSpyPlotUniReader *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetGenerateMarkers(temp0);
    }
    else
    {
      op->vtkSpyPlotUniReader::SetGenerateMarkers(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotUniReader_GetGenerateMarkers(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetGenerateMarkers");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotUniReader *op = static_cast<vtkSpyPlotUniReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetGenerateMarkers() :
      op->vtkSpyPlotUniReader::GetGenerateMarkers());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotUniReader_GetMarkersOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMarkersOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotUniReader *op = static_cast<vtkSpyPlotUniReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetMarkersOn() :
      op->vtkSpyPlotUniReader::GetMarkersOn());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotUniReader_SetDataTypeChanged(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDataTypeChanged");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotUniReader *op = static_cast<vtkSpyPlotUniReader *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDataTypeChanged(temp0);
    }
    else
    {
      op->vtkSpyPlotUniReader::SetDataTypeChanged(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSpyPlotUniReader_SetDownConvertVolumeFraction(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDownConvertVolumeFraction");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSpyPlotUniReader *op = static_cast<vtkSpyPlotUniReader *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDownConvertVolumeFraction(temp0);
    }
    else
    {
      op->vtkSpyPlotUniReader::SetDownConvertVolumeFraction(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkSpyPlotUniReader_Methods[] = {
  {"IsTypeOf", PyvtkSpyPlotUniReader_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkSpyPlotUniReader_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkSpyPlotUniReader_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkSpyPlotUniReader\nC++: static vtkSpyPlotUniReader *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkSpyPlotUniReader_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkSpyPlotUniReader\nC++: vtkSpyPlotUniReader *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkSpyPlotUniReader_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkSpyPlotUniReader_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetFileName", PyvtkSpyPlotUniReader_SetFileName, METH_VARARGS,
   "SetFileName(self, _arg:str) -> None\nC++: virtual void SetFileName(const char *_arg)\n\nSet and get the Binary SpyPlot File name the reader will process\n"},
  {"GetFileName", PyvtkSpyPlotUniReader_GetFileName, METH_VARARGS,
   "GetFileName(self) -> str\nC++: virtual char *GetFileName()\n\n"},
  {"SetCellArraySelection", PyvtkSpyPlotUniReader_SetCellArraySelection, METH_VARARGS,
   "SetCellArraySelection(self, da:vtkDataArraySelection) -> None\nC++: virtual void SetCellArraySelection(vtkDataArraySelection *da)\n\n"},
  {"ReadInformation", PyvtkSpyPlotUniReader_ReadInformation, METH_VARARGS,
   "ReadInformation(self) -> int\nC++: virtual int ReadInformation()\n\nReads the basic information from the file such as the header,\nnumber of fields, etc.\n"},
  {"MakeCurrent", PyvtkSpyPlotUniReader_MakeCurrent, METH_VARARGS,
   "MakeCurrent(self) -> int\nC++: int MakeCurrent()\n\nMake sure that actual data (including grid blocks) is current\nelse it will read in the required data from file\n"},
  {"PrintInformation", PyvtkSpyPlotUniReader_PrintInformation, METH_VARARGS,
   "PrintInformation(self) -> None\nC++: void PrintInformation()\n\n"},
  {"PrintMemoryUsage", PyvtkSpyPlotUniReader_PrintMemoryUsage, METH_VARARGS,
   "PrintMemoryUsage(self) -> None\nC++: void PrintMemoryUsage()\n\n"},
  {"SetCurrentTime", PyvtkSpyPlotUniReader_SetCurrentTime, METH_VARARGS,
   "SetCurrentTime(self, time:float) -> int\nC++: int SetCurrentTime(double time)\n\nSet and get the current time step to process\n"},
  {"GetCurrentTime", PyvtkSpyPlotUniReader_GetCurrentTime, METH_VARARGS,
   "GetCurrentTime(self) -> float\nC++: virtual double GetCurrentTime()\n\n"},
  {"SetCurrentTimeStep", PyvtkSpyPlotUniReader_SetCurrentTimeStep, METH_VARARGS,
   "SetCurrentTimeStep(self, timeStep:int) -> int\nC++: int SetCurrentTimeStep(int timeStep)\n\n"},
  {"GetCurrentTimeStep", PyvtkSpyPlotUniReader_GetCurrentTimeStep, METH_VARARGS,
   "GetCurrentTimeStep(self) -> int\nC++: virtual int GetCurrentTimeStep()\n\n"},
  {"GetTimeStepRange", PyvtkSpyPlotUniReader_GetTimeStepRange, METH_VARARGS,
   "GetTimeStepRange(self) -> (int, int)\nC++: virtual int *GetTimeStepRange()\n\nSet and Get the time range for the simulation run\n"},
  {"GetTimeRange", PyvtkSpyPlotUniReader_GetTimeRange, METH_VARARGS,
   "GetTimeRange(self) -> (float, float)\nC++: virtual double *GetTimeRange()\n\n"},
  {"SetNeedToCheck", PyvtkSpyPlotUniReader_SetNeedToCheck, METH_VARARGS,
   "SetNeedToCheck(self, _arg:int) -> None\nC++: virtual void SetNeedToCheck(int _arg)\n\n"},
  {"GetTimeStepFromTime", PyvtkSpyPlotUniReader_GetTimeStepFromTime, METH_VARARGS,
   "GetTimeStepFromTime(self, time:float) -> int\nC++: int GetTimeStepFromTime(double time)\n\nFunctions that map from time to time step and vice versa\n"},
  {"GetTimeFromTimeStep", PyvtkSpyPlotUniReader_GetTimeFromTimeStep, METH_VARARGS,
   "GetTimeFromTimeStep(self, timeStep:int) -> float\nC++: double GetTimeFromTimeStep(int timeStep)\n\n"},
  {"GetNumberOfCellFields", PyvtkSpyPlotUniReader_GetNumberOfCellFields, METH_VARARGS,
   "GetNumberOfCellFields(self) -> int\nC++: virtual int GetNumberOfCellFields()\n\n"},
  {"GetTimeArray", PyvtkSpyPlotUniReader_GetTimeArray, METH_VARARGS,
   "GetTimeArray(self) -> Pointer\nC++: double *GetTimeArray()\n\n"},
  {"IsAMR", PyvtkSpyPlotUniReader_IsAMR, METH_VARARGS,
   "IsAMR(self) -> int\nC++: int IsAMR()\n\nReturns 1 if the grid information contained in the file has\nAdaptive Mesh Refinement (AMR) else it returns 0\n"},
  {"GetNumberOfDataBlocks", PyvtkSpyPlotUniReader_GetNumberOfDataBlocks, METH_VARARGS,
   "GetNumberOfDataBlocks(self) -> int\nC++: int GetNumberOfDataBlocks()\n\nReturn the number of grids in the reader\n"},
  {"GetCellFieldName", PyvtkSpyPlotUniReader_GetCellFieldName, METH_VARARGS,
   "GetCellFieldName(self, field:int) -> str\nC++: const char *GetCellFieldName(int field)\n\nReturn the name of the ith field\n"},
  {"GetCellFieldData", PyvtkSpyPlotUniReader_GetCellFieldData, METH_VARARGS,
   "GetCellFieldData(self, block:int, field:int, fixed:[int, ...])\n    -> vtkDataArray\nC++: vtkDataArray *GetCellFieldData(int block, int field,\n    int *fixed)\n\nReturn the data array of the block's field.  The \"fixed\" argument\nis set to 1 if the array has been corrected for bad ghost cells\nelse it is set to 0\n"},
  {"GetMaterialMassField", PyvtkSpyPlotUniReader_GetMaterialMassField, METH_VARARGS,
   "GetMaterialMassField(self, block:int, materialIndex:int)\n    -> vtkDataArray\nC++: vtkDataArray *GetMaterialMassField(const int &block,\n    const int &materialIndex)\n\nReturn the mass data array for the material index passed in for\nthe passed in block\n"},
  {"GetMaterialVolumeFractionField", PyvtkSpyPlotUniReader_GetMaterialVolumeFractionField, METH_VARARGS,
   "GetMaterialVolumeFractionField(self, block:int, materialIndex:int)\n     -> vtkDataArray\nC++: vtkDataArray *GetMaterialVolumeFractionField(\n    const int &block, const int &materialIndex)\n\nReturn the volume fraction data array for the material index\npassed in for the passed in block\n"},
  {"MarkCellFieldDataFixed", PyvtkSpyPlotUniReader_MarkCellFieldDataFixed, METH_VARARGS,
   "MarkCellFieldDataFixed(self, block:int, field:int) -> int\nC++: int MarkCellFieldDataFixed(int block, int field)\n\nMark the block's field to have been fixed w/r bad ghost cells\n"},
  {"GetTracers", PyvtkSpyPlotUniReader_GetTracers, METH_VARARGS,
   "GetTracers(self) -> vtkFloatArray\nC++: vtkFloatArray *GetTracers()\n\nReturn the data array for the tracer positions.\n"},
  {"GetNumberOfMaterials", PyvtkSpyPlotUniReader_GetNumberOfMaterials, METH_VARARGS,
   "GetNumberOfMaterials(self) -> int\nC++: int GetNumberOfMaterials()\n\n"},
  {"GetNumberOfDimensions", PyvtkSpyPlotUniReader_GetNumberOfDimensions, METH_VARARGS,
   "GetNumberOfDimensions(self) -> int\nC++: int GetNumberOfDimensions()\n\n"},
  {"GetCoordinateSystem", PyvtkSpyPlotUniReader_GetCoordinateSystem, METH_VARARGS,
   "GetCoordinateSystem(self) -> int\nC++: int GetCoordinateSystem()\n\n"},
  {"SetGenerateMarkers", PyvtkSpyPlotUniReader_SetGenerateMarkers, METH_VARARGS,
   "SetGenerateMarkers(self, _arg:int) -> None\nC++: virtual void SetGenerateMarkers(int _arg)\n\n"},
  {"GetGenerateMarkers", PyvtkSpyPlotUniReader_GetGenerateMarkers, METH_VARARGS,
   "GetGenerateMarkers(self) -> int\nC++: virtual int GetGenerateMarkers()\n\n"},
  {"GetMarkersOn", PyvtkSpyPlotUniReader_GetMarkersOn, METH_VARARGS,
   "GetMarkersOn(self) -> int\nC++: virtual int GetMarkersOn()\n\n"},
  {"SetDataTypeChanged", PyvtkSpyPlotUniReader_SetDataTypeChanged, METH_VARARGS,
   "SetDataTypeChanged(self, _arg:int) -> None\nC++: virtual void SetDataTypeChanged(int _arg)\n\n"},
  {"SetDownConvertVolumeFraction", PyvtkSpyPlotUniReader_SetDownConvertVolumeFraction, METH_VARARGS,
   "SetDownConvertVolumeFraction(self, vf:int) -> None\nC++: void SetDownConvertVolumeFraction(int vf)\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkSpyPlotUniReader_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("file_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSpyPlotUniReader_GetFileName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSpyPlotUniReader_SetFileName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSpyPlotUniReader_SetFileName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetFileName/SetFileName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("cell_array_selection"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSpyPlotUniReader_SetCellArraySelection(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSpyPlotUniReader_SetCellArraySelection(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetCellArraySelection\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("need_to_check"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSpyPlotUniReader_SetNeedToCheck(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSpyPlotUniReader_SetNeedToCheck(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetNeedToCheck\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("generate_markers"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSpyPlotUniReader_GetGenerateMarkers(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSpyPlotUniReader_SetGenerateMarkers(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSpyPlotUniReader_SetGenerateMarkers(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetGenerateMarkers/SetGenerateMarkers\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("data_type_changed"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSpyPlotUniReader_SetDataTypeChanged(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSpyPlotUniReader_SetDataTypeChanged(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetDataTypeChanged\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("down_convert_volume_fraction"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSpyPlotUniReader_SetDownConvertVolumeFraction(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSpyPlotUniReader_SetDownConvertVolumeFraction(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetDownConvertVolumeFraction\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("current_time"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSpyPlotUniReader_GetCurrentTime(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetCurrentTime\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("current_time_step"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSpyPlotUniReader_GetCurrentTimeStep(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetCurrentTimeStep\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("time_step_range"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSpyPlotUniReader_GetTimeStepRange(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetTimeStepRange\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("time_range"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSpyPlotUniReader_GetTimeRange(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetTimeRange\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("time_array"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSpyPlotUniReader_GetTimeArray(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetTimeArray\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("tracers"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSpyPlotUniReader_GetTracers(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetTracers\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("coordinate_system"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSpyPlotUniReader_GetCoordinateSystem(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetCoordinateSystem\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("markers_on"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSpyPlotUniReader_GetMarkersOn(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetMarkersOn\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_cell_fields"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSpyPlotUniReader_GetNumberOfCellFields(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNumberOfCellFields\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_materials"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSpyPlotUniReader_GetNumberOfMaterials(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNumberOfMaterials\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_dimensions"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSpyPlotUniReader_GetNumberOfDimensions(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNumberOfDimensions\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkSpyPlotUniReader_Doc =
  "vtkSpyPlotUniReader - Read SPCTH Spy Plot file format\n\n"
  "Superclass: vtkObject\n\n"
  "vtkSpyPlotUniReader is a reader that reads SPCTH Spy Plot file binary\n"
  "format that describes part of a dataset (in the case that the\n"
  "simulation consists of more than 1 file) or the entire simulation.\n"
  "The reader supports both Spy dataset types: flat mesh and AMR\n"
  "(Adaptive Mesh Refinement).\n\n"
  "@par Implementation Details: Class was extracted from\n"
  "vtkSpyPlotReader.cxx and is a helper to that class.  Note the grids\n"
  "in the reader may have bad ghost cells that will need to be taken\n"
  "into consideration in terms of both geometry and cell data\n"
  "----------------------------------------------------------------------\n"
  "    -------\n"
  "    ==================================================================\n"
  "    ===========\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkSpyPlotUniReader_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkPVVTKExtensionsIOSPCTH.vtkSpyPlotUniReader", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkSpyPlotUniReader_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkSpyPlotUniReader_StaticNew()
{
  return vtkSpyPlotUniReader::New();
}

PyObject *PyvtkSpyPlotUniReader_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkSpyPlotUniReader_Type, PyvtkSpyPlotUniReader_Methods,
    "vtkSpyPlotUniReader",
 &PyvtkSpyPlotUniReader_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkObject");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkSpyPlotUniReader_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkSpyPlotUniReader(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkSpyPlotUniReader_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkSpyPlotUniReader", o) != 0)
  {
    Py_DECREF(o);
  }

}

