#include "vtkABI.h"
#include "vtkClientServerInterpreter.h"

extern "C" { void vtkCameraManipulator_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkCameraManipulatorGUIHelper_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPVInteractorStyle_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPVJoystickFly_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPVJoystickFlyIn_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPVJoystickFlyOut_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPVTrackballMoveActor_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPVTrackballMultiRotate_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPVTrackballPan_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPVTrackballRoll_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPVTrackballRotate_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPVTrackballEnvironmentRotate_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPVTrackballZoom_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPVTrackballZoomToMouse_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkTrackballPan_Init(vtkClientServerInterpreter*); }

extern "C" VTK_ABI_EXPORT void vtkPVVTKExtensionsInteractionStyleCS_Initialize(vtkClientServerInterpreter* csi)
{
  (void)csi;
  vtkCameraManipulator_Init(csi);
  vtkCameraManipulatorGUIHelper_Init(csi);
  vtkPVInteractorStyle_Init(csi);
  vtkPVJoystickFly_Init(csi);
  vtkPVJoystickFlyIn_Init(csi);
  vtkPVJoystickFlyOut_Init(csi);
  vtkPVTrackballMoveActor_Init(csi);
  vtkPVTrackballMultiRotate_Init(csi);
  vtkPVTrackballPan_Init(csi);
  vtkPVTrackballRoll_Init(csi);
  vtkPVTrackballRotate_Init(csi);
  vtkPVTrackballEnvironmentRotate_Init(csi);
  vtkPVTrackballZoom_Init(csi);
  vtkPVTrackballZoomToMouse_Init(csi);
  vtkTrackballPan_Init(csi);
}
