// python wrapper for vtkPVDataInformation
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkPVDataInformation.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPVDataInformation(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPVDataInformation_ClassNew(); }

#ifndef DECLARED_PyvtkPVInformation_ClassNew
extern "C" { PyObject *PyvtkPVInformation_ClassNew(); }
#define DECLARED_PyvtkPVInformation_ClassNew
#endif

static PyObject *
PyvtkPVDataInformation_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkPVDataInformation::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataInformation_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataInformation *op = static_cast<vtkPVDataInformation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkPVDataInformation::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataInformation_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkPVDataInformation *tempr = vtkPVDataInformation::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataInformation_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataInformation *op = static_cast<vtkPVDataInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVDataInformation *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkPVDataInformation::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataInformation_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkPVDataInformation::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataInformation_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataInformation *op = static_cast<vtkPVDataInformation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkPVDataInformation::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataInformation_SetPortNumber(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPortNumber");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataInformation *op = static_cast<vtkPVDataInformation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPortNumber(temp0);
    }
    else
    {
      op->vtkPVDataInformation::SetPortNumber(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataInformation_GetPortNumber(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPortNumber");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataInformation *op = static_cast<vtkPVDataInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetPortNumber() :
      op->vtkPVDataInformation::GetPortNumber());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataInformation_SetRank(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRank");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataInformation *op = static_cast<vtkPVDataInformation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRank(temp0);
    }
    else
    {
      op->vtkPVDataInformation::SetRank(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataInformation_GetRankMinValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRankMinValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataInformation *op = static_cast<vtkPVDataInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetRankMinValue() :
      op->vtkPVDataInformation::GetRankMinValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataInformation_GetRankMaxValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRankMaxValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataInformation *op = static_cast<vtkPVDataInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetRankMaxValue() :
      op->vtkPVDataInformation::GetRankMaxValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataInformation_GetRank(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRank");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataInformation *op = static_cast<vtkPVDataInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetRank() :
      op->vtkPVDataInformation::GetRank());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataInformation_GetSubsetSelector(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSubsetSelector");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataInformation *op = static_cast<vtkPVDataInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetSubsetSelector() :
      op->vtkPVDataInformation::GetSubsetSelector());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataInformation_SetSubsetSelector(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSubsetSelector");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataInformation *op = static_cast<vtkPVDataInformation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSubsetSelector(temp0);
    }
    else
    {
      op->vtkPVDataInformation::SetSubsetSelector(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataInformation_SetSubsetAssemblyName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSubsetAssemblyName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataInformation *op = static_cast<vtkPVDataInformation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSubsetAssemblyName(temp0);
    }
    else
    {
      op->vtkPVDataInformation::SetSubsetAssemblyName(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataInformation_GetSubsetAssemblyName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSubsetAssemblyName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataInformation *op = static_cast<vtkPVDataInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetSubsetAssemblyName() :
      op->vtkPVDataInformation::GetSubsetAssemblyName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataInformation_SetSubsetAssemblyNameToHierarchy(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSubsetAssemblyNameToHierarchy");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataInformation *op = static_cast<vtkPVDataInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SetSubsetAssemblyNameToHierarchy();
    }
    else
    {
      op->vtkPVDataInformation::SetSubsetAssemblyNameToHierarchy();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataInformation_CopyFromObject(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "CopyFromObject");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataInformation *op = static_cast<vtkPVDataInformation *>(vp);

  vtkObject *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObject"))
  {
    if (ap.IsBound())
    {
      op->CopyFromObject(temp0);
    }
    else
    {
      op->vtkPVDataInformation::CopyFromObject(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataInformation_AddInformation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddInformation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataInformation *op = static_cast<vtkPVDataInformation *>(vp);

  vtkPVInformation *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkPVInformation"))
  {
    if (ap.IsBound())
    {
      op->AddInformation(temp0);
    }
    else
    {
      op->vtkPVDataInformation::AddInformation(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataInformation_CopyParametersToStream(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "CopyParametersToStream");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataInformation *op = static_cast<vtkPVDataInformation *>(vp);

  vtkMultiProcessStream *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetSpecialObject(temp0, "vtkMultiProcessStream"))
  {
    if (ap.IsBound())
    {
      op->CopyParametersToStream(*temp0);
    }
    else
    {
      op->vtkPVDataInformation::CopyParametersToStream(*temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataInformation_CopyParametersFromStream(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "CopyParametersFromStream");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataInformation *op = static_cast<vtkPVDataInformation *>(vp);

  vtkMultiProcessStream *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetSpecialObject(temp0, "vtkMultiProcessStream"))
  {
    if (ap.IsBound())
    {
      op->CopyParametersFromStream(*temp0);
    }
    else
    {
      op->vtkPVDataInformation::CopyParametersFromStream(*temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataInformation_Initialize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Initialize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataInformation *op = static_cast<vtkPVDataInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->Initialize();
    }
    else
    {
      op->vtkPVDataInformation::Initialize();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataInformation_DeepCopy(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "DeepCopy");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataInformation *op = static_cast<vtkPVDataInformation *>(vp);

  vtkPVDataInformation *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkPVDataInformation"))
  {
    if (ap.IsBound())
    {
      op->DeepCopy(temp0);
    }
    else
    {
      op->vtkPVDataInformation::DeepCopy(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataInformation_GetArrayInformation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetArrayInformation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataInformation *op = static_cast<vtkPVDataInformation *>(vp);

  const char *temp0 = nullptr;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    vtkPVArrayInformation *tempr = (ap.IsBound() ?
      op->GetArrayInformation(temp0, temp1) :
      op->vtkPVDataInformation::GetArrayInformation(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataInformation_GetDataSetType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDataSetType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataInformation *op = static_cast<vtkPVDataInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetDataSetType() :
      op->vtkPVDataInformation::GetDataSetType());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataInformation_GetCompositeDataSetType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCompositeDataSetType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataInformation *op = static_cast<vtkPVDataInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetCompositeDataSetType() :
      op->vtkPVDataInformation::GetCompositeDataSetType());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataInformation_IsCompositeDataSet(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsCompositeDataSet");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataInformation *op = static_cast<vtkPVDataInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->IsCompositeDataSet() :
      op->vtkPVDataInformation::IsCompositeDataSet());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataInformation_IsNull(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsNull");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataInformation *op = static_cast<vtkPVDataInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->IsNull() :
      op->vtkPVDataInformation::IsNull());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataInformation_GetUniqueBlockTypes(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUniqueBlockTypes");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataInformation *op = static_cast<vtkPVDataInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const std::vector<int> *tempr = (ap.IsBound() ?
      &op->GetUniqueBlockTypes() :
      &op->vtkPVDataInformation::GetUniqueBlockTypes());

    if (!ap.ErrorOccurred())
    {
      if (tempr->empty())
      {
        result = PyTuple_New(0);
      }
      else
      {
        result = vtkPythonArgs::BuildTuple(tempr->data(), tempr->size());
      }
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataInformation_GetNumberOfUniqueBlockTypes(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfUniqueBlockTypes");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataInformation *op = static_cast<vtkPVDataInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned int tempr = (ap.IsBound() ?
      op->GetNumberOfUniqueBlockTypes() :
      op->vtkPVDataInformation::GetNumberOfUniqueBlockTypes());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataInformation_GetUniqueBlockType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUniqueBlockType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataInformation *op = static_cast<vtkPVDataInformation *>(vp);

  unsigned int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->GetUniqueBlockType(temp0) :
      op->vtkPVDataInformation::GetUniqueBlockType(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataInformation_GetDataSetTypeAsString_s1(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetDataSetTypeAsString");

  int temp0;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    const char *tempr = vtkPVDataInformation::GetDataSetTypeAsString(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkPVDataInformation_GetDataSetTypeAsString_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDataSetTypeAsString");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataInformation *op = static_cast<vtkPVDataInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetDataSetTypeAsString() :
      op->vtkPVDataInformation::GetDataSetTypeAsString());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkPVDataInformation_GetDataSetTypeAsString_Methods[] = {
  {"GetDataSetTypeAsString", PyvtkPVDataInformation_GetDataSetTypeAsString_s1, METH_VARARGS | METH_STATIC,
   "i"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkPVDataInformation_GetDataSetTypeAsString(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkPVDataInformation_GetDataSetTypeAsString_Methods;
  int nargs = vtkPythonArgs::GetArgCount(args);

  switch(nargs)
  {
    case 0:
      return PyvtkPVDataInformation_GetDataSetTypeAsString_s2(self, args);
    case 1:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetDataSetTypeAsString");
  return nullptr;
}


static PyObject *
PyvtkPVDataInformation_GetDataClassName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDataClassName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataInformation *op = static_cast<vtkPVDataInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetDataClassName() :
      op->vtkPVDataInformation::GetDataClassName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataInformation_GetCompositeDataClassName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCompositeDataClassName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataInformation *op = static_cast<vtkPVDataInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetCompositeDataClassName() :
      op->vtkPVDataInformation::GetCompositeDataClassName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataInformation_GetPrettyDataTypeString_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPrettyDataTypeString");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataInformation *op = static_cast<vtkPVDataInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetPrettyDataTypeString() :
      op->vtkPVDataInformation::GetPrettyDataTypeString());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkPVDataInformation_GetPrettyDataTypeString_s2(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetPrettyDataTypeString");

  int temp0;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    const char *tempr = vtkPVDataInformation::GetPrettyDataTypeString(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkPVDataInformation_GetPrettyDataTypeString(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(args);

  switch(nargs)
  {
    case 0:
      return PyvtkPVDataInformation_GetPrettyDataTypeString_s1(self, args);
    case 1:
      return PyvtkPVDataInformation_GetPrettyDataTypeString_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetPrettyDataTypeString");
  return nullptr;
}


static PyObject *
PyvtkPVDataInformation_DataSetTypeIsA_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "DataSetTypeIsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataInformation *op = static_cast<vtkPVDataInformation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = (ap.IsBound() ?
      op->DataSetTypeIsA(temp0) :
      op->vtkPVDataInformation::DataSetTypeIsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkPVDataInformation_DataSetTypeIsA_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "DataSetTypeIsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataInformation *op = static_cast<vtkPVDataInformation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = (ap.IsBound() ?
      op->DataSetTypeIsA(temp0) :
      op->vtkPVDataInformation::DataSetTypeIsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkPVDataInformation_DataSetTypeIsA_Methods[] = {
  {"DataSetTypeIsA", PyvtkPVDataInformation_DataSetTypeIsA_s1, METH_VARARGS,
   "@z"},
  {"DataSetTypeIsA", PyvtkPVDataInformation_DataSetTypeIsA_s2, METH_VARARGS,
   "@i"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkPVDataInformation_DataSetTypeIsA(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkPVDataInformation_DataSetTypeIsA_Methods;
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "DataSetTypeIsA");
  return nullptr;
}


static PyObject *
PyvtkPVDataInformation_HasDataSetType_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "HasDataSetType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataInformation *op = static_cast<vtkPVDataInformation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = (ap.IsBound() ?
      op->HasDataSetType(temp0) :
      op->vtkPVDataInformation::HasDataSetType(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkPVDataInformation_HasDataSetType_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "HasDataSetType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataInformation *op = static_cast<vtkPVDataInformation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = (ap.IsBound() ?
      op->HasDataSetType(temp0) :
      op->vtkPVDataInformation::HasDataSetType(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkPVDataInformation_HasDataSetType_Methods[] = {
  {"HasDataSetType", PyvtkPVDataInformation_HasDataSetType_s1, METH_VARARGS,
   "@z"},
  {"HasDataSetType", PyvtkPVDataInformation_HasDataSetType_s2, METH_VARARGS,
   "@i"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkPVDataInformation_HasDataSetType(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkPVDataInformation_HasDataSetType_Methods;
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "HasDataSetType");
  return nullptr;
}


static PyObject *
PyvtkPVDataInformation_GetNumberOfElements(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfElements");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataInformation *op = static_cast<vtkPVDataInformation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfElements(temp0) :
      op->vtkPVDataInformation::GetNumberOfElements(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataInformation_GetNumberOfPoints(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfPoints");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataInformation *op = static_cast<vtkPVDataInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfPoints() :
      op->vtkPVDataInformation::GetNumberOfPoints());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataInformation_GetNumberOfCells(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfCells");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataInformation *op = static_cast<vtkPVDataInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfCells() :
      op->vtkPVDataInformation::GetNumberOfCells());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataInformation_GetNumberOfVertices(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfVertices");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataInformation *op = static_cast<vtkPVDataInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfVertices() :
      op->vtkPVDataInformation::GetNumberOfVertices());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataInformation_GetNumberOfEdges(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfEdges");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataInformation *op = static_cast<vtkPVDataInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfEdges() :
      op->vtkPVDataInformation::GetNumberOfEdges());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataInformation_GetNumberOfRows(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfRows");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataInformation *op = static_cast<vtkPVDataInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfRows() :
      op->vtkPVDataInformation::GetNumberOfRows());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataInformation_GetNumberOfTrees(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfTrees");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataInformation *op = static_cast<vtkPVDataInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfTrees() :
      op->vtkPVDataInformation::GetNumberOfTrees());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataInformation_GetNumberOfLeaves(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfLeaves");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataInformation *op = static_cast<vtkPVDataInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfLeaves() :
      op->vtkPVDataInformation::GetNumberOfLeaves());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataInformation_GetNumberOfAMRLevels(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfAMRLevels");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataInformation *op = static_cast<vtkPVDataInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfAMRLevels() :
      op->vtkPVDataInformation::GetNumberOfAMRLevels());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataInformation_GetNumberOfAMRDataSets(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfAMRDataSets");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataInformation *op = static_cast<vtkPVDataInformation *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfAMRDataSets(temp0) :
      op->vtkPVDataInformation::GetNumberOfAMRDataSets(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataInformation_GetNumberOfDataSets(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfDataSets");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataInformation *op = static_cast<vtkPVDataInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfDataSets() :
      op->vtkPVDataInformation::GetNumberOfDataSets());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataInformation_GetMemorySize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMemorySize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataInformation *op = static_cast<vtkPVDataInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetMemorySize() :
      op->vtkPVDataInformation::GetMemorySize());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataInformation_GetBounds(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBounds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataInformation *op = static_cast<vtkPVDataInformation *>(vp);

  size_t sizer = 6;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double *tempr = (ap.IsBound() ?
      op->GetBounds() :
      op->vtkPVDataInformation::GetBounds());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataInformation_GetExtent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetExtent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataInformation *op = static_cast<vtkPVDataInformation *>(vp);

  size_t sizer = 6;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int *tempr = (ap.IsBound() ?
      op->GetExtent() :
      op->vtkPVDataInformation::GetExtent());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataInformation_GetAttributeInformation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAttributeInformation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataInformation *op = static_cast<vtkPVDataInformation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkPVDataSetAttributesInformation *tempr = (ap.IsBound() ?
      op->GetAttributeInformation(temp0) :
      op->vtkPVDataInformation::GetAttributeInformation(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataInformation_GetPointDataInformation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPointDataInformation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataInformation *op = static_cast<vtkPVDataInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVDataSetAttributesInformation *tempr = (ap.IsBound() ?
      op->GetPointDataInformation() :
      op->vtkPVDataInformation::GetPointDataInformation());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataInformation_GetCellDataInformation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCellDataInformation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataInformation *op = static_cast<vtkPVDataInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVDataSetAttributesInformation *tempr = (ap.IsBound() ?
      op->GetCellDataInformation() :
      op->vtkPVDataInformation::GetCellDataInformation());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataInformation_GetVertexDataInformation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetVertexDataInformation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataInformation *op = static_cast<vtkPVDataInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVDataSetAttributesInformation *tempr = (ap.IsBound() ?
      op->GetVertexDataInformation() :
      op->vtkPVDataInformation::GetVertexDataInformation());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataInformation_GetEdgeDataInformation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetEdgeDataInformation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataInformation *op = static_cast<vtkPVDataInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVDataSetAttributesInformation *tempr = (ap.IsBound() ?
      op->GetEdgeDataInformation() :
      op->vtkPVDataInformation::GetEdgeDataInformation());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataInformation_GetRowDataInformation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRowDataInformation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataInformation *op = static_cast<vtkPVDataInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVDataSetAttributesInformation *tempr = (ap.IsBound() ?
      op->GetRowDataInformation() :
      op->vtkPVDataInformation::GetRowDataInformation());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataInformation_GetFieldDataInformation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFieldDataInformation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataInformation *op = static_cast<vtkPVDataInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVDataSetAttributesInformation *tempr = (ap.IsBound() ?
      op->GetFieldDataInformation() :
      op->vtkPVDataInformation::GetFieldDataInformation());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataInformation_GetPointArrayInformation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPointArrayInformation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataInformation *op = static_cast<vtkPVDataInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVArrayInformation *tempr = (ap.IsBound() ?
      op->GetPointArrayInformation() :
      op->vtkPVDataInformation::GetPointArrayInformation());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataInformation_GetHasTime(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetHasTime");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataInformation *op = static_cast<vtkPVDataInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetHasTime() :
      op->vtkPVDataInformation::GetHasTime());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataInformation_GetTime(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTime");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataInformation *op = static_cast<vtkPVDataInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetTime() :
      op->vtkPVDataInformation::GetTime());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataInformation_GetTimeRange(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTimeRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataInformation *op = static_cast<vtkPVDataInformation *>(vp);

  size_t sizer = 2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double *tempr = (ap.IsBound() ?
      op->GetTimeRange() :
      op->vtkPVDataInformation::GetTimeRange());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataInformation_GetTimeLabel(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTimeLabel");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataInformation *op = static_cast<vtkPVDataInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetTimeLabel() :
      op->vtkPVDataInformation::GetTimeLabel());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataInformation_GetNumberOfTimeSteps(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfTimeSteps");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataInformation *op = static_cast<vtkPVDataInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfTimeSteps() :
      op->vtkPVDataInformation::GetNumberOfTimeSteps());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataInformation_IsDataStructured(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsDataStructured");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataInformation *op = static_cast<vtkPVDataInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->IsDataStructured() :
      op->vtkPVDataInformation::IsDataStructured());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataInformation_HasStructuredData(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "HasStructuredData");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataInformation *op = static_cast<vtkPVDataInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->HasStructuredData() :
      op->vtkPVDataInformation::HasStructuredData());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataInformation_HasUnstructuredData(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "HasUnstructuredData");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataInformation *op = static_cast<vtkPVDataInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->HasUnstructuredData() :
      op->vtkPVDataInformation::HasUnstructuredData());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataInformation_IsAttributeValid(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsAttributeValid");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataInformation *op = static_cast<vtkPVDataInformation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = (ap.IsBound() ?
      op->IsAttributeValid(temp0) :
      op->vtkPVDataInformation::IsAttributeValid(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataInformation_GetExtentType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetExtentType");

  int temp0;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkPVDataInformation::GetExtentType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataInformation_GetHierarchy(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetHierarchy");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataInformation *op = static_cast<vtkPVDataInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkDataAssembly *tempr = (ap.IsBound() ?
      op->GetHierarchy() :
      op->vtkPVDataInformation::GetHierarchy());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataInformation_GetDataAssembly_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDataAssembly");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataInformation *op = static_cast<vtkPVDataInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkDataAssembly *tempr = (ap.IsBound() ?
      op->GetDataAssembly() :
      op->vtkPVDataInformation::GetDataAssembly());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkPVDataInformation_GetDataAssembly_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDataAssembly");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataInformation *op = static_cast<vtkPVDataInformation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkDataAssembly *tempr = (ap.IsBound() ?
      op->GetDataAssembly(temp0) :
      op->vtkPVDataInformation::GetDataAssembly(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkPVDataInformation_GetDataAssembly(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 0:
      return PyvtkPVDataInformation_GetDataAssembly_s1(self, args);
    case 1:
      return PyvtkPVDataInformation_GetDataAssembly_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetDataAssembly");
  return nullptr;
}


static PyObject *
PyvtkPVDataInformation_GetFirstLeafCompositeIndex(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFirstLeafCompositeIndex");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataInformation *op = static_cast<vtkPVDataInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned long long tempr = (ap.IsBound() ?
      op->GetFirstLeafCompositeIndex() :
      op->vtkPVDataInformation::GetFirstLeafCompositeIndex());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataInformation_GetBlockName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBlockName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataInformation *op = static_cast<vtkPVDataInformation *>(vp);

  unsigned long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetBlockName(temp0) :
      op->vtkPVDataInformation::GetBlockName(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataInformation_GetBlockNames(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBlockNames");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataInformation *op = static_cast<vtkPVDataInformation *>(vp);

  std::vector<std::string> temp0(ap.GetArgSize(0));
  const char *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetArray(temp0.data(), temp0.size()) &&
      ap.GetValue(temp1))
  {
    std::vector<std::string> tempr = (ap.IsBound() ?
      op->GetBlockNames(temp0, temp1) :
      op->vtkPVDataInformation::GetBlockNames(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      if (tempr.empty())
      {
        result = PyTuple_New(0);
      }
      else
      {
        result = vtkPythonArgs::BuildTuple(tempr.data(), tempr.size());
      }
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataInformation_ComputeCompositeIndexForAMR(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ComputeCompositeIndexForAMR");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataInformation *op = static_cast<vtkPVDataInformation *>(vp);

  unsigned int temp0;
  unsigned int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    unsigned int tempr = (ap.IsBound() ?
      op->ComputeCompositeIndexForAMR(temp0, temp1) :
      op->vtkPVDataInformation::ComputeCompositeIndexForAMR(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkPVDataInformation_Methods[] = {
  {"IsTypeOf", PyvtkPVDataInformation_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkPVDataInformation_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkPVDataInformation_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkPVDataInformation\nC++: static vtkPVDataInformation *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkPVDataInformation_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkPVDataInformation\nC++: vtkPVDataInformation *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkPVDataInformation_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkPVDataInformation_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetPortNumber", PyvtkPVDataInformation_SetPortNumber, METH_VARARGS,
   "SetPortNumber(self, _arg:int) -> None\nC++: virtual void SetPortNumber(int _arg)\n\nIndicates which output port of an algorithm this data should\ninformation should be / has been collected from.\n\nDefault is 0.\n"},
  {"GetPortNumber", PyvtkPVDataInformation_GetPortNumber, METH_VARARGS,
   "GetPortNumber(self) -> int\nC++: virtual int GetPortNumber()\n\n"},
  {"SetRank", PyvtkPVDataInformation_SetRank, METH_VARARGS,
   "SetRank(self, _arg:int) -> None\nC++: virtual void SetRank(int _arg)\n\nIndicates which rank to gather the information from. Default is\n-1 which means all ranks.\n"},
  {"GetRankMinValue", PyvtkPVDataInformation_GetRankMinValue, METH_VARARGS,
   "GetRankMinValue(self) -> int\nC++: virtual int GetRankMinValue()\n\n"},
  {"GetRankMaxValue", PyvtkPVDataInformation_GetRankMaxValue, METH_VARARGS,
   "GetRankMaxValue(self) -> int\nC++: virtual int GetRankMaxValue()\n\n"},
  {"GetRank", PyvtkPVDataInformation_GetRank, METH_VARARGS,
   "GetRank(self) -> int\nC++: virtual int GetRank()\n\n"},
  {"GetSubsetSelector", PyvtkPVDataInformation_GetSubsetSelector, METH_VARARGS,
   "GetSubsetSelector(self) -> str\nC++: virtual char *GetSubsetSelector()\n\nPath if non-null, used to limit blocks from a composite dataset.\nFor details on support form of selector expressions see\n`vtkDataAssembly::SelectNodes`.\n"},
  {"SetSubsetSelector", PyvtkPVDataInformation_SetSubsetSelector, METH_VARARGS,
   "SetSubsetSelector(self, _arg:str) -> None\nC++: virtual void SetSubsetSelector(const char *_arg)\n\n"},
  {"SetSubsetAssemblyName", PyvtkPVDataInformation_SetSubsetAssemblyName, METH_VARARGS,
   "SetSubsetAssemblyName(self, _arg:str) -> None\nC++: virtual void SetSubsetAssemblyName(const char *_arg)\n\nGet/Set the assembly to use for subsetting. To use hierarchy, set\nthis to `vtkDataAssembly::HierarchyName()` or simply use\n`SetSubsetAssemblyNameToHierarchy()`.\n"},
  {"GetSubsetAssemblyName", PyvtkPVDataInformation_GetSubsetAssemblyName, METH_VARARGS,
   "GetSubsetAssemblyName(self) -> str\nC++: virtual char *GetSubsetAssemblyName()\n\n"},
  {"SetSubsetAssemblyNameToHierarchy", PyvtkPVDataInformation_SetSubsetAssemblyNameToHierarchy, METH_VARARGS,
   "SetSubsetAssemblyNameToHierarchy(self) -> None\nC++: void SetSubsetAssemblyNameToHierarchy()\n\n"},
  {"CopyFromObject", PyvtkPVDataInformation_CopyFromObject, METH_VARARGS,
   "CopyFromObject(self, object:vtkObject) -> None\nC++: void CopyFromObject(vtkObject *object) override;\n\nPopulate vtkPVDataInformation using `object`. The object can be a\n`vtkDataObject`, `vtkAlgorithm` or `vtkAlgorithmOutput`.\n"},
  {"AddInformation", PyvtkPVDataInformation_AddInformation, METH_VARARGS,
   "AddInformation(self, info:vtkPVInformation) -> None\nC++: void AddInformation(vtkPVInformation *info) override;\n\nvtkPVInformation API implementation.\n"},
  {"CopyParametersToStream", PyvtkPVDataInformation_CopyParametersToStream, METH_VARARGS,
   "CopyParametersToStream(self, __a:vtkMultiProcessStream) -> None\nC++: void CopyParametersToStream(vtkMultiProcessStream &)\n    override;\n\nSerialize/Deserialize the parameters that control how/what\ninformation is gathered. This are different from the ivars that\nconstitute the gathered information itself. For example,\nPortNumber on vtkPVDataInformation controls what output port the\ndata-information is gathered from.\n"},
  {"CopyParametersFromStream", PyvtkPVDataInformation_CopyParametersFromStream, METH_VARARGS,
   "CopyParametersFromStream(self, __a:vtkMultiProcessStream) -> None\nC++: void CopyParametersFromStream(vtkMultiProcessStream &)\n    override;\n\n"},
  {"Initialize", PyvtkPVDataInformation_Initialize, METH_VARARGS,
   "Initialize(self) -> None\nC++: void Initialize()\n\nInitializes and clears all values updated in `CopyFromObject`.\n"},
  {"DeepCopy", PyvtkPVDataInformation_DeepCopy, METH_VARARGS,
   "DeepCopy(self, info:vtkPVDataInformation) -> None\nC++: void DeepCopy(vtkPVDataInformation *info)\n\nSimply copies from another vtkPVDataInformation.\n"},
  {"GetArrayInformation", PyvtkPVDataInformation_GetArrayInformation, METH_VARARGS,
   "GetArrayInformation(self, arrayname:str, fieldAssociation:int)\n    -> vtkPVArrayInformation\nC++: vtkPVArrayInformation *GetArrayInformation(\n    const char *arrayname, int fieldAssociation)\n\nFinds and returns array information associated with the chosen\narray. `fieldAssociation` must be one of\n`vtkDataObject::FieldAssociations` or\n`vtkDataObject::AttributeTypes`.\n"},
  {"GetDataSetType", PyvtkPVDataInformation_GetDataSetType, METH_VARARGS,
   "GetDataSetType(self) -> int\nC++: virtual int GetDataSetType()\n\nReturns the data set type. Returned values are defined in\n`vtkType.h`. For composite datasets, this returns the common\nsuperclass for all non-null leaf nodes in the composite dataset.\n\n`-1` indicates that the information has not be collected yet, was\ncollected from nullptr data object, or from a composite dataset\nwith no non-null leaf nodes.\n\n@sa GetCompositeDataSetType\n"},
  {"GetCompositeDataSetType", PyvtkPVDataInformation_GetCompositeDataSetType, METH_VARARGS,
   "GetCompositeDataSetType(self) -> int\nC++: virtual int GetCompositeDataSetType()\n\nReturns the type flag for composite datasets. For non-composite\ndatasets, this is set to `-1`.\n"},
  {"IsCompositeDataSet", PyvtkPVDataInformation_IsCompositeDataSet, METH_VARARGS,
   "IsCompositeDataSet(self) -> bool\nC++: bool IsCompositeDataSet()\n\nReturns true if the data information corresponds to a composite\ndataset.\n"},
  {"IsNull", PyvtkPVDataInformation_IsNull, METH_VARARGS,
   "IsNull(self) -> bool\nC++: bool IsNull()\n\nReturns true if the data information is empty or invalid.\n"},
  {"GetUniqueBlockTypes", PyvtkPVDataInformation_GetUniqueBlockTypes, METH_VARARGS,
   "GetUniqueBlockTypes(self) -> (int, ...)\nC++: const std::vector<int> &GetUniqueBlockTypes()\n\nFor a composite dataset, returns a list of unique data set types\nfor all non-null leaf nodes. May be empty if there are non-null\nleaf nodes are the dataset is not a composite dataset.\n\note There is no significance to the order of the types.\n"},
  {"GetNumberOfUniqueBlockTypes", PyvtkPVDataInformation_GetNumberOfUniqueBlockTypes, METH_VARARGS,
   "GetNumberOfUniqueBlockTypes(self) -> int\nC++: unsigned int GetNumberOfUniqueBlockTypes()\n\n"},
  {"GetUniqueBlockType", PyvtkPVDataInformation_GetUniqueBlockType, METH_VARARGS,
   "GetUniqueBlockType(self, index:int) -> int\nC++: int GetUniqueBlockType(unsigned int index)\n\n"},
  {"GetDataSetTypeAsString", PyvtkPVDataInformation_GetDataSetTypeAsString, METH_VARARGS,
   "GetDataSetTypeAsString(type:int) -> str\nC++: static const char *GetDataSetTypeAsString(int type)\nGetDataSetTypeAsString(self) -> str\nC++: const char *GetDataSetTypeAsString()\n\nReturns a string for the given type. This directly returns the\nclassname and hence may not be user-friendly.\n\n@sa GetPrettyDataTypeString\n"},
  {"GetDataClassName", PyvtkPVDataInformation_GetDataClassName, METH_VARARGS,
   "GetDataClassName(self) -> str\nC++: const char *GetDataClassName()\n\n"},
  {"GetCompositeDataClassName", PyvtkPVDataInformation_GetCompositeDataClassName, METH_VARARGS,
   "GetCompositeDataClassName(self) -> str\nC++: const char *GetCompositeDataClassName()\n\n"},
  {"GetPrettyDataTypeString", PyvtkPVDataInformation_GetPrettyDataTypeString, METH_VARARGS,
   "GetPrettyDataTypeString(self) -> str\nC++: const char *GetPrettyDataTypeString()\nGetPrettyDataTypeString(dtype:int) -> str\nC++: static const char *GetPrettyDataTypeString(int dtype)\n\nReturns a user-friendly string describing the datatype.\n"},
  {"DataSetTypeIsA", PyvtkPVDataInformation_DataSetTypeIsA, METH_VARARGS,
   "DataSetTypeIsA(self, classname:str) -> bool\nC++: bool DataSetTypeIsA(const char *classname)\nDataSetTypeIsA(self, typeId:int) -> bool\nC++: bool DataSetTypeIsA(int typeId)\n\nReturns true if the type is of the requested `classname` (or\n`typeId`).\n\nIf `this->CompositeDataSetType` is valid i.e. the information\nrepresents a composite dataset, the composite dataset type is\nfirst checked. If not, `this->DataSetType` is checked. Since\n`this->DataSetType` is set to the most common data type among all\nthe leaf nodes in the composite dataset, true implies all\ndatasets in the composite dataset match the type.\n\n@sa `HasDataSetType`\n"},
  {"HasDataSetType", PyvtkPVDataInformation_HasDataSetType, METH_VARARGS,
   "HasDataSetType(self, classname:str) -> bool\nC++: bool HasDataSetType(const char *classname)\nHasDataSetType(self, typeId:int) -> bool\nC++: bool HasDataSetType(int typeId)\n\nSimilar to `DataSetTypeIsA` except, in case of composite\ndatasets, returns true if any of the leaf nodes match the\nrequested type.\n\nFor non-composite datasets, this is same as `DataSetTypeIsA`.\n"},
  {"GetNumberOfElements", PyvtkPVDataInformation_GetNumberOfElements, METH_VARARGS,
   "GetNumberOfElements(self, elementType:int) -> int\nC++: vtkTypeInt64 GetNumberOfElements(int elementType)\n\nReturns number of elements of the chosen type in the data. For a\ncomposite dataset, this is a sum of the element count across all\nleaf nodes.\n\n`elementType` must be `vtkDataObject::AttributeTypes`. For\n`vtkDataObject::FIELD`, and `vtkDataObject::POINT_THEN_CELL`\nreturns 0.\n"},
  {"GetNumberOfPoints", PyvtkPVDataInformation_GetNumberOfPoints, METH_VARARGS,
   "GetNumberOfPoints(self) -> int\nC++: vtkTypeInt64 GetNumberOfPoints()\n\nConvenience methods that simply call `GetNumberOfElements` with\nappropriate element type.\n"},
  {"GetNumberOfCells", PyvtkPVDataInformation_GetNumberOfCells, METH_VARARGS,
   "GetNumberOfCells(self) -> int\nC++: vtkTypeInt64 GetNumberOfCells()\n\n"},
  {"GetNumberOfVertices", PyvtkPVDataInformation_GetNumberOfVertices, METH_VARARGS,
   "GetNumberOfVertices(self) -> int\nC++: vtkTypeInt64 GetNumberOfVertices()\n\n"},
  {"GetNumberOfEdges", PyvtkPVDataInformation_GetNumberOfEdges, METH_VARARGS,
   "GetNumberOfEdges(self) -> int\nC++: vtkTypeInt64 GetNumberOfEdges()\n\n"},
  {"GetNumberOfRows", PyvtkPVDataInformation_GetNumberOfRows, METH_VARARGS,
   "GetNumberOfRows(self) -> int\nC++: vtkTypeInt64 GetNumberOfRows()\n\n"},
  {"GetNumberOfTrees", PyvtkPVDataInformation_GetNumberOfTrees, METH_VARARGS,
   "GetNumberOfTrees(self) -> int\nC++: virtual vtkTypeInt64 GetNumberOfTrees()\n\nvtkHyperTreeGrid / vtkUniformHyperTreeGrid specific properties.\nWill return 0 for all other data types.\n"},
  {"GetNumberOfLeaves", PyvtkPVDataInformation_GetNumberOfLeaves, METH_VARARGS,
   "GetNumberOfLeaves(self) -> int\nC++: virtual vtkTypeInt64 GetNumberOfLeaves()\n\n"},
  {"GetNumberOfAMRLevels", PyvtkPVDataInformation_GetNumberOfAMRLevels, METH_VARARGS,
   "GetNumberOfAMRLevels(self) -> int\nC++: virtual vtkTypeInt64 GetNumberOfAMRLevels()\n\nFor vtkUniformGridAMR and subclasses, this returns the number of\nlevels\n"},
  {"GetNumberOfAMRDataSets", PyvtkPVDataInformation_GetNumberOfAMRDataSets, METH_VARARGS,
   "GetNumberOfAMRDataSets(self, level:int) -> int\nC++: vtkTypeInt64 GetNumberOfAMRDataSets(vtkTypeInt64 level)\n\nFor vtkUniformGridAMR and subclasses, this returns the number of\ndatasets at each level.\n"},
  {"GetNumberOfDataSets", PyvtkPVDataInformation_GetNumberOfDataSets, METH_VARARGS,
   "GetNumberOfDataSets(self) -> int\nC++: virtual vtkTypeInt64 GetNumberOfDataSets()\n\nThis is count of non-null non-composite datasets. A count of 0\nmay mean:\n* the data is nullptr\n* the data is a composite dataset with no non-null leaf nodes A\n  count of 1 may mean:\n* the data is non-composite dataset\n* the data is a composite dataset with exactly 1 non-null leaf\n  node. A count of > 1 may mean:\n* the data is non-composite, but distributed across ranks.\n* the data is composite with multiple non-null leaf nodes.\n"},
  {"GetMemorySize", PyvtkPVDataInformation_GetMemorySize, METH_VARARGS,
   "GetMemorySize(self) -> int\nC++: virtual vtkTypeInt64 GetMemorySize()\n\nReturns the memory size as reported by\n`vtkDataObject::GetActualMemorySize`. For composite datasets,\nthis is simply a sum of the values returned by\n`vtkDataObject::GetActualMemorySize` per non-null leaf node. For\ndatasets that share internal arrays, this will overestimate the\nsize.\n"},
  {"GetBounds", PyvtkPVDataInformation_GetBounds, METH_VARARGS,
   "GetBounds(self) -> (float, float, float, float, float, float)\nC++: virtual double *GetBounds()\n\nReturns bounds for the dataset. May return an invalid bounding\nbox for data types where bounds don't make sense. For composite\ndatasets, this is a bounding box of all valid bounding boxes.\n"},
  {"GetExtent", PyvtkPVDataInformation_GetExtent, METH_VARARGS,
   "GetExtent(self) -> (int, int, int, int, int, int)\nC++: virtual int *GetExtent()\n\nReturns structured extents for the data. These are only valid for\nstructured data types like vtkStructuredGrid, vtkImageData etc.\nFor composite dataset, these represent the combined extents for\nstructured datasets in the collection.\n"},
  {"GetAttributeInformation", PyvtkPVDataInformation_GetAttributeInformation, METH_VARARGS,
   "GetAttributeInformation(self, fieldAssociation:int)\n    -> vtkPVDataSetAttributesInformation\nC++: vtkPVDataSetAttributesInformation *GetAttributeInformation(\n    int fieldAssociation)\n\nGet vtkPVDataSetAttributesInformation information for the given\nassociation. `vtkPVDataSetAttributesInformation` can be used to\ndetermine available arrays and get meta-data about each of the\navailable arrays.\n\n`fieldAssociation` must be `vtkDataObject::FieldAssociations` (or\n`vtkDataObject::AttributeTypes`).\nvtkDataObject::FIELD_ASSOCIATION_POINTS_THEN_CELLS (or\nvtkDataObject::POINT_THEN_CELL) is not supported.\n"},
  {"GetPointDataInformation", PyvtkPVDataInformation_GetPointDataInformation, METH_VARARGS,
   "GetPointDataInformation(self) -> vtkPVDataSetAttributesInformation\nC++: vtkPVDataSetAttributesInformation *GetPointDataInformation()\n\nConvenience methods to get vtkPVDataSetAttributesInformation for\nspecific field type. Same as calling `GetAttributeInformation`\nwith appropriate type.\n"},
  {"GetCellDataInformation", PyvtkPVDataInformation_GetCellDataInformation, METH_VARARGS,
   "GetCellDataInformation(self) -> vtkPVDataSetAttributesInformation\nC++: vtkPVDataSetAttributesInformation *GetCellDataInformation()\n\n"},
  {"GetVertexDataInformation", PyvtkPVDataInformation_GetVertexDataInformation, METH_VARARGS,
   "GetVertexDataInformation(self)\n    -> vtkPVDataSetAttributesInformation\nC++: vtkPVDataSetAttributesInformation *GetVertexDataInformation()\n\n"},
  {"GetEdgeDataInformation", PyvtkPVDataInformation_GetEdgeDataInformation, METH_VARARGS,
   "GetEdgeDataInformation(self) -> vtkPVDataSetAttributesInformation\nC++: vtkPVDataSetAttributesInformation *GetEdgeDataInformation()\n\n"},
  {"GetRowDataInformation", PyvtkPVDataInformation_GetRowDataInformation, METH_VARARGS,
   "GetRowDataInformation(self) -> vtkPVDataSetAttributesInformation\nC++: vtkPVDataSetAttributesInformation *GetRowDataInformation()\n\n"},
  {"GetFieldDataInformation", PyvtkPVDataInformation_GetFieldDataInformation, METH_VARARGS,
   "GetFieldDataInformation(self) -> vtkPVDataSetAttributesInformation\nC++: vtkPVDataSetAttributesInformation *GetFieldDataInformation()\n\n"},
  {"GetPointArrayInformation", PyvtkPVDataInformation_GetPointArrayInformation, METH_VARARGS,
   "GetPointArrayInformation(self) -> vtkPVArrayInformation\nC++: virtual vtkPVArrayInformation *GetPointArrayInformation()\n\nFor a vtkPointSet and subclasses, this provides information about\nthe `vtkPoints` array. For composite datasets, this is the\nobtained by accumulating information from all point-sets in the\ncollection.\n"},
  {"GetHasTime", PyvtkPVDataInformation_GetHasTime, METH_VARARGS,
   "GetHasTime(self) -> bool\nC++: virtual bool GetHasTime()\n\nReturns `DATA_TIME_STEP`, if any, provided by the information\nobject associated with data.\n"},
  {"GetTime", PyvtkPVDataInformation_GetTime, METH_VARARGS,
   "GetTime(self) -> float\nC++: virtual double GetTime()\n\n"},
  {"GetTimeRange", PyvtkPVDataInformation_GetTimeRange, METH_VARARGS,
   "GetTimeRange(self) -> (float, float)\nC++: virtual double *GetTimeRange()\n\nStrictly speaking, these are not data information since these\ncannot be obtained from the data but from the pipeline producing\nthe data. However, they are provided as part data information for\nsimplicity.\n"},
  {"GetTimeLabel", PyvtkPVDataInformation_GetTimeLabel, METH_VARARGS,
   "GetTimeLabel(self) -> str\nC++: virtual std::string GetTimeLabel()\n\n"},
  {"GetNumberOfTimeSteps", PyvtkPVDataInformation_GetNumberOfTimeSteps, METH_VARARGS,
   "GetNumberOfTimeSteps(self) -> int\nC++: vtkTypeInt64 GetNumberOfTimeSteps()\n\n"},
  {"IsDataStructured", PyvtkPVDataInformation_IsDataStructured, METH_VARARGS,
   "IsDataStructured(self) -> bool\nC++: bool IsDataStructured()\n\nReturns true if the data is structured i.e. supports i-j-k\nindexing. For composite datasets, this returns true if all leaf\nnodes are structured.\n"},
  {"HasStructuredData", PyvtkPVDataInformation_HasStructuredData, METH_VARARGS,
   "HasStructuredData(self) -> bool\nC++: bool HasStructuredData()\n\nReturns true if the data has structured data. For composite\ndatasets, this returns true if *any* of the datasets are\nstructured.\n"},
  {"HasUnstructuredData", PyvtkPVDataInformation_HasUnstructuredData, METH_VARARGS,
   "HasUnstructuredData(self) -> bool\nC++: bool HasUnstructuredData()\n\nReturns true if the data has unstructured data. For composite\ndatasets, this returns true if *any* of the datasets are\nunstructured.\n"},
  {"IsAttributeValid", PyvtkPVDataInformation_IsAttributeValid, METH_VARARGS,
   "IsAttributeValid(self, fieldAssociation:int) -> bool\nC++: bool IsAttributeValid(int fieldAssociation)\n\nReturns true if provided fieldAssociation is valid for this\ndataset, false otherwise. For composite datasets, this returns\ntrue if the attribute type if valid for any of the datasets in\nthe collection.\n"},
  {"GetExtentType", PyvtkPVDataInformation_GetExtentType, METH_VARARGS,
   "GetExtentType(dataType:int) -> int\nC++: static int GetExtentType(int dataType)\n\nReturns the extent type for a given data-object type.\n"},
  {"GetHierarchy", PyvtkPVDataInformation_GetHierarchy, METH_VARARGS,
   "GetHierarchy(self) -> vtkDataAssembly\nC++: vtkDataAssembly *GetHierarchy()\n\nFor composite datasets, this provides access to the information\nabout the dataset hierarchy and any data assembly associated with\nit.\n\nHierarchy represents the hierarchy of the datatype while assembly\nprovides access to logical grouping and organization, if any.\n"},
  {"GetDataAssembly", PyvtkPVDataInformation_GetDataAssembly, METH_VARARGS,
   "GetDataAssembly(self) -> vtkDataAssembly\nC++: vtkDataAssembly *GetDataAssembly()\nGetDataAssembly(self, assemblyName:str) -> vtkDataAssembly\nC++: vtkDataAssembly *GetDataAssembly(const char *assemblyName)\n\n"},
  {"GetFirstLeafCompositeIndex", PyvtkPVDataInformation_GetFirstLeafCompositeIndex, METH_VARARGS,
   "GetFirstLeafCompositeIndex(self) -> int\nC++: virtual vtkTypeUInt64 GetFirstLeafCompositeIndex()\n\nUntil multiblock dataset is deprecated, applications often want\nto locate the composite-index for the first leaf node.\n\nReturns 0 if not applicable.\n"},
  {"GetBlockName", PyvtkPVDataInformation_GetBlockName, METH_VARARGS,
   "GetBlockName(self, cid:int) -> str\nC++: std::string GetBlockName(vtkTypeUInt64 cid)\n\nGiven a composite index, return the blockname, if any. Note, this\nis not reliable if executed on partitioned-dataset collection\nsince partitioned-dataset collection may have different composite\nindices across ranks. Thus, this must only be used in code that\nis currently only slated for migration from using composite-ids\nto selectors and hence does not encounter partitioned-dataset\ncollections.\n\nThis uses `Hierarchy` and hence it only supported when hierarchy\nis defined/available.\n\nReturns empty string if no name available or cannot be\ndetermined.\n"},
  {"GetBlockNames", PyvtkPVDataInformation_GetBlockNames, METH_VARARGS,
   "GetBlockNames(self, selectors:(str, ...), assemblyName:str) -> (\n    str, ...)\nC++: std::vector<std::string> GetBlockNames(\n    const std::vector<std::string> &selectors,\n    const char *assemblyName)\n\nGiven a collection of selectors, returns all block names for\nchosen blocks.\n"},
  {"ComputeCompositeIndexForAMR", PyvtkPVDataInformation_ComputeCompositeIndexForAMR, METH_VARARGS,
   "ComputeCompositeIndexForAMR(self, level:int, index:int) -> int\nC++: unsigned int ComputeCompositeIndexForAMR(unsigned int level,\n    unsigned int index)\n\nA helper method to convert an AMR level-index to a flat index.\nThis uses the hierarchy to compute the flat index.\n\nCalling this on a non-AMR dataset will simply return 0.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPVDataInformation_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("port_number"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVDataInformation_GetPortNumber(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVDataInformation_SetPortNumber(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVDataInformation_SetPortNumber(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetPortNumber/SetPortNumber\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("rank"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVDataInformation_GetRank(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVDataInformation_SetRank(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVDataInformation_SetRank(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetRank/SetRank\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("subset_selector"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVDataInformation_GetSubsetSelector(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVDataInformation_SetSubsetSelector(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVDataInformation_SetSubsetSelector(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetSubsetSelector/SetSubsetSelector\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("subset_assembly_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVDataInformation_GetSubsetAssemblyName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVDataInformation_SetSubsetAssemblyName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVDataInformation_SetSubsetAssemblyName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetSubsetAssemblyName/SetSubsetAssemblyName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("data_set_type"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVDataInformation_GetDataSetType(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetDataSetType\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("composite_data_set_type"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVDataInformation_GetCompositeDataSetType(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetCompositeDataSetType\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("unique_block_types"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVDataInformation_GetUniqueBlockTypes(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetUniqueBlockTypes\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("data_class_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVDataInformation_GetDataClassName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetDataClassName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("composite_data_class_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVDataInformation_GetCompositeDataClassName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetCompositeDataClassName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("pretty_data_type_string"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVDataInformation_GetPrettyDataTypeString(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetPrettyDataTypeString\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("memory_size"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVDataInformation_GetMemorySize(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetMemorySize\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("bounds"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVDataInformation_GetBounds(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetBounds\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("extent"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVDataInformation_GetExtent(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetExtent\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("point_data_information"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVDataInformation_GetPointDataInformation(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetPointDataInformation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("cell_data_information"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVDataInformation_GetCellDataInformation(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetCellDataInformation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("vertex_data_information"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVDataInformation_GetVertexDataInformation(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetVertexDataInformation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("edge_data_information"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVDataInformation_GetEdgeDataInformation(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetEdgeDataInformation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("row_data_information"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVDataInformation_GetRowDataInformation(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetRowDataInformation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("field_data_information"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVDataInformation_GetFieldDataInformation(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetFieldDataInformation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("point_array_information"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVDataInformation_GetPointArrayInformation(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetPointArrayInformation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("has_time"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVDataInformation_GetHasTime(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetHasTime\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("time"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVDataInformation_GetTime(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetTime\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("time_range"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVDataInformation_GetTimeRange(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetTimeRange\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("time_label"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVDataInformation_GetTimeLabel(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetTimeLabel\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("hierarchy"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVDataInformation_GetHierarchy(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetHierarchy\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("data_assembly"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVDataInformation_GetDataAssembly(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetDataAssembly\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("first_leaf_composite_index"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVDataInformation_GetFirstLeafCompositeIndex(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetFirstLeafCompositeIndex\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_unique_block_types"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVDataInformation_GetNumberOfUniqueBlockTypes(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNumberOfUniqueBlockTypes\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_points"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVDataInformation_GetNumberOfPoints(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNumberOfPoints\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_cells"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVDataInformation_GetNumberOfCells(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNumberOfCells\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_vertices"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVDataInformation_GetNumberOfVertices(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNumberOfVertices\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_edges"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVDataInformation_GetNumberOfEdges(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNumberOfEdges\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_rows"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVDataInformation_GetNumberOfRows(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNumberOfRows\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_trees"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVDataInformation_GetNumberOfTrees(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNumberOfTrees\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_leaves"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVDataInformation_GetNumberOfLeaves(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNumberOfLeaves\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_amr_levels"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVDataInformation_GetNumberOfAMRLevels(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNumberOfAMRLevels\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_data_sets"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVDataInformation_GetNumberOfDataSets(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNumberOfDataSets\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_time_steps"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVDataInformation_GetNumberOfTimeSteps(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNumberOfTimeSteps\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkPVDataInformation_Doc =
  "vtkPVDataInformation - provides meta data about a vtkDataObject\nsubclass.\n\n"
  "Superclass: vtkPVInformation\n\n"
  "vtkPVDataInformation is a vtkPVInformation subclass intended to\n"
  "collect information from vtkDataObject and subclasses. It designed to\n"
  "be used by application in lieu of actual data to glean insight into\n"
  "the data e.g. data type, number of points, number of cells, arrays,\n"
  "ranges etc.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVDataInformation_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingCore.vtkPVDataInformation", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkPVDataInformation_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkPVDataInformation_StaticNew()
{
  return vtkPVDataInformation::New();
}

PyObject *PyvtkPVDataInformation_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkPVDataInformation_Type, PyvtkPVDataInformation_Methods,
    "vtkPVDataInformation",
 &PyvtkPVDataInformation_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = (PyTypeObject *)PyvtkPVInformation_ClassNew();

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkPVDataInformation_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPVDataInformation(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPVDataInformation_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkPVDataInformation", o) != 0)
  {
    Py_DECREF(o);
  }

}

