// python wrapper for vtkPVWebExporter
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkPVWebExporter.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPVWebExporter(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPVWebExporter_ClassNew(); }


static PyObject *
PyvtkPVWebExporter_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkPVWebExporter::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVWebExporter_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVWebExporter *op = static_cast<vtkPVWebExporter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkPVWebExporter::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVWebExporter_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkPVWebExporter *tempr = vtkPVWebExporter::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVWebExporter_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVWebExporter *op = static_cast<vtkPVWebExporter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVWebExporter *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkPVWebExporter::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVWebExporter_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkPVWebExporter::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVWebExporter_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVWebExporter *op = static_cast<vtkPVWebExporter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkPVWebExporter::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVWebExporter_SetParaViewGlanceHTML(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetParaViewGlanceHTML");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVWebExporter *op = static_cast<vtkPVWebExporter *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetParaViewGlanceHTML(temp0);
    }
    else
    {
      op->vtkPVWebExporter::SetParaViewGlanceHTML(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVWebExporter_GetParaViewGlanceHTML(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetParaViewGlanceHTML");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVWebExporter *op = static_cast<vtkPVWebExporter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetParaViewGlanceHTML() :
      op->vtkPVWebExporter::GetParaViewGlanceHTML());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVWebExporter_GetExportToGlance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetExportToGlance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVWebExporter *op = static_cast<vtkPVWebExporter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetExportToGlance() :
      op->vtkPVWebExporter::GetExportToGlance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVWebExporter_SetExportToGlance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetExportToGlance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVWebExporter *op = static_cast<vtkPVWebExporter *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetExportToGlance(temp0);
    }
    else
    {
      op->vtkPVWebExporter::SetExportToGlance(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVWebExporter_GetAutomaticGlanceHTML(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAutomaticGlanceHTML");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVWebExporter *op = static_cast<vtkPVWebExporter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetAutomaticGlanceHTML() :
      op->vtkPVWebExporter::GetAutomaticGlanceHTML());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVWebExporter_SetAutomaticGlanceHTML(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAutomaticGlanceHTML");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVWebExporter *op = static_cast<vtkPVWebExporter *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetAutomaticGlanceHTML(temp0);
    }
    else
    {
      op->vtkPVWebExporter::SetAutomaticGlanceHTML(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVWebExporter_GetDisableNetwork(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDisableNetwork");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVWebExporter *op = static_cast<vtkPVWebExporter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetDisableNetwork() :
      op->vtkPVWebExporter::GetDisableNetwork());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVWebExporter_SetDisableNetwork(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDisableNetwork");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVWebExporter *op = static_cast<vtkPVWebExporter *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDisableNetwork(temp0);
    }
    else
    {
      op->vtkPVWebExporter::SetDisableNetwork(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkPVWebExporter_Methods[] = {
  {"IsTypeOf", PyvtkPVWebExporter_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkPVWebExporter_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkPVWebExporter_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkPVWebExporter\nC++: static vtkPVWebExporter *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkPVWebExporter_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkPVWebExporter\nC++: vtkPVWebExporter *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkPVWebExporter_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkPVWebExporter_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetParaViewGlanceHTML", PyvtkPVWebExporter_SetParaViewGlanceHTML, METH_VARARGS,
   "SetParaViewGlanceHTML(self, _arg:str) -> None\nC++: virtual void SetParaViewGlanceHTML(std::string _arg)\n\nSpecify file name of the custom ParaViewGlance HTML file to use\nto embed the data in.\n"},
  {"GetParaViewGlanceHTML", PyvtkPVWebExporter_GetParaViewGlanceHTML, METH_VARARGS,
   "GetParaViewGlanceHTML(self) -> str\nC++: virtual std::string GetParaViewGlanceHTML()\n\n"},
  {"GetExportToGlance", PyvtkPVWebExporter_GetExportToGlance, METH_VARARGS,
   "GetExportToGlance(self) -> bool\nC++: virtual bool GetExportToGlance()\n\nIn addition to writing the scene as a .vtkjs file, bundle its\ncontent encoded in base64 into a Kitware Glance viewer standalone\nHTML file. Defaults to true.\n"},
  {"SetExportToGlance", PyvtkPVWebExporter_SetExportToGlance, METH_VARARGS,
   "SetExportToGlance(self, _arg:bool) -> None\nC++: virtual void SetExportToGlance(bool _arg)\n\n"},
  {"GetAutomaticGlanceHTML", PyvtkPVWebExporter_GetAutomaticGlanceHTML, METH_VARARGS,
   "GetAutomaticGlanceHTML(self) -> bool\nC++: virtual bool GetAutomaticGlanceHTML()\n\nIgnore ParaViewGlanceHTML file path and try to find the\nParaViewGlance.html file coming with the ParaView distribution.\nThis file is supposed to be in [PARAVIEW\nROOT]/share/paraview-[VERSION]/web/glance/ParaViewGlance.html\nDefaults to true.\n"},
  {"SetAutomaticGlanceHTML", PyvtkPVWebExporter_SetAutomaticGlanceHTML, METH_VARARGS,
   "SetAutomaticGlanceHTML(self, _arg:bool) -> None\nC++: virtual void SetAutomaticGlanceHTML(bool _arg)\n\n"},
  {"GetDisableNetwork", PyvtkPVWebExporter_GetDisableNetwork, METH_VARARGS,
   "GetDisableNetwork(self) -> bool\nC++: virtual bool GetDisableNetwork()\n\nDisable components requiring network access through Girder in the\nGlance application, by forcing the URL parameter 'noGirder'. This\nwill inject a script reloading the page if the 'noGirder'\nparameter is not set, effectively preventing any external network\ncall from the Glance webapp. Defaults to true (Girder disabled).\n"},
  {"SetDisableNetwork", PyvtkPVWebExporter_SetDisableNetwork, METH_VARARGS,
   "SetDisableNetwork(self, _arg:bool) -> None\nC++: virtual void SetDisableNetwork(bool _arg)\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPVWebExporter_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("para_view_glance_html"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVWebExporter_GetParaViewGlanceHTML(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVWebExporter_SetParaViewGlanceHTML(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVWebExporter_SetParaViewGlanceHTML(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetParaViewGlanceHTML/SetParaViewGlanceHTML\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("export_to_glance"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVWebExporter_GetExportToGlance(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVWebExporter_SetExportToGlance(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVWebExporter_SetExportToGlance(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetExportToGlance/SetExportToGlance\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("automatic_glance_html"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVWebExporter_GetAutomaticGlanceHTML(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVWebExporter_SetAutomaticGlanceHTML(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVWebExporter_SetAutomaticGlanceHTML(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetAutomaticGlanceHTML/SetAutomaticGlanceHTML\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("disable_network"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVWebExporter_GetDisableNetwork(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVWebExporter_SetDisableNetwork(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVWebExporter_SetDisableNetwork(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetDisableNetwork/SetDisableNetwork\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkPVWebExporter_Doc =
  "vtkPVWebExporter - vtkPVWebExporter is used to produce vtkjs export\nin the ParaView application.\n\n"
  "Superclass: vtkJSONSceneExporter\n\n"
  "vtkPVWebExporter is used to produce scene export for web sharing.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVWebExporter_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingExport.vtkPVWebExporter", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkPVWebExporter_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkPVWebExporter_StaticNew()
{
  return vtkPVWebExporter::New();
}

PyObject *PyvtkPVWebExporter_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkPVWebExporter_Type, PyvtkPVWebExporter_Methods,
    "vtkPVWebExporter",
 &PyvtkPVWebExporter_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkJSONSceneExporter");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkPVWebExporter_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPVWebExporter(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPVWebExporter_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkPVWebExporter", o) != 0)
  {
    Py_DECREF(o);
  }

}

