// python wrapper for vtkSMRepresentationProxy
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkSMRepresentationProxy.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkSMRepresentationProxy(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkSMRepresentationProxy_ClassNew(); }


static PyObject *
PyvtkSMRepresentationProxy_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkSMRepresentationProxy::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMRepresentationProxy_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRepresentationProxy *op = static_cast<vtkSMRepresentationProxy *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkSMRepresentationProxy::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMRepresentationProxy_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkSMRepresentationProxy *tempr = vtkSMRepresentationProxy::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMRepresentationProxy_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRepresentationProxy *op = static_cast<vtkSMRepresentationProxy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSMRepresentationProxy *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkSMRepresentationProxy::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMRepresentationProxy_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkSMRepresentationProxy::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMRepresentationProxy_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRepresentationProxy *op = static_cast<vtkSMRepresentationProxy *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkSMRepresentationProxy::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMRepresentationProxy_GetRepresentedDataInformation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRepresentedDataInformation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRepresentationProxy *op = static_cast<vtkSMRepresentationProxy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVDataInformation *tempr = (ap.IsBound() ?
      op->GetRepresentedDataInformation() :
      op->vtkSMRepresentationProxy::GetRepresentedDataInformation());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMRepresentationProxy_GetProminentValuesInformation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetProminentValuesInformation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRepresentationProxy *op = static_cast<vtkSMRepresentationProxy *>(vp);

  std::string temp0;
  int temp1;
  int temp2;
  double temp3 = 1e-6;
  double temp4 = 1e-3;
  bool temp5 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3, 6) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      (ap.NoArgsLeft() || ap.GetValue(temp3)) &&
      (ap.NoArgsLeft() || ap.GetValue(temp4)) &&
      (ap.NoArgsLeft() || ap.GetValue(temp5)))
  {
    vtkPVProminentValuesInformation *tempr = (ap.IsBound() ?
      op->GetProminentValuesInformation(temp0, temp1, temp2, temp3, temp4, temp5) :
      op->vtkSMRepresentationProxy::GetProminentValuesInformation(temp0, temp1, temp2, temp3, temp4, temp5));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMRepresentationProxy_GetBlockProminentValuesInformation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBlockProminentValuesInformation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRepresentationProxy *op = static_cast<vtkSMRepresentationProxy *>(vp);

  std::string temp0;
  std::string temp1;
  std::string temp2;
  int temp3;
  int temp4;
  double temp5 = 1e-6;
  double temp6 = 1e-3;
  bool temp7 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(5, 8) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3) &&
      ap.GetValue(temp4) &&
      (ap.NoArgsLeft() || ap.GetValue(temp5)) &&
      (ap.NoArgsLeft() || ap.GetValue(temp6)) &&
      (ap.NoArgsLeft() || ap.GetValue(temp7)))
  {
    vtkPVProminentValuesInformation *tempr = (ap.IsBound() ?
      op->GetBlockProminentValuesInformation(temp0, temp1, temp2, temp3, temp4, temp5, temp6, temp7) :
      op->vtkSMRepresentationProxy::GetBlockProminentValuesInformation(temp0, temp1, temp2, temp3, temp4, temp5, temp6, temp7));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMRepresentationProxy_UpdatePipeline_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UpdatePipeline");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRepresentationProxy *op = static_cast<vtkSMRepresentationProxy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->UpdatePipeline();
    }
    else
    {
      op->vtkSMRepresentationProxy::UpdatePipeline();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkSMRepresentationProxy_UpdatePipeline_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UpdatePipeline");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRepresentationProxy *op = static_cast<vtkSMRepresentationProxy *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->UpdatePipeline(temp0);
    }
    else
    {
      op->vtkSMRepresentationProxy::UpdatePipeline(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkSMRepresentationProxy_UpdatePipeline(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 0:
      return PyvtkSMRepresentationProxy_UpdatePipeline_s1(self, args);
    case 1:
      return PyvtkSMRepresentationProxy_UpdatePipeline_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "UpdatePipeline");
  return nullptr;
}


static PyObject *
PyvtkSMRepresentationProxy_PostUpdateData(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "PostUpdateData");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRepresentationProxy *op = static_cast<vtkSMRepresentationProxy *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->PostUpdateData(temp0);
    }
    else
    {
      op->vtkSMRepresentationProxy::PostUpdateData(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMRepresentationProxy_ViewUpdated(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ViewUpdated");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRepresentationProxy *op = static_cast<vtkSMRepresentationProxy *>(vp);

  vtkSMProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProxy"))
  {
    if (ap.IsBound())
    {
      op->ViewUpdated(temp0);
    }
    else
    {
      op->vtkSMRepresentationProxy::ViewUpdated(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMRepresentationProxy_GetGlobalID(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetGlobalID");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRepresentationProxy *op = static_cast<vtkSMRepresentationProxy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned int tempr = (ap.IsBound() ?
      op->GetGlobalID() :
      op->vtkSMRepresentationProxy::GetGlobalID());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMRepresentationProxy_SetRepresentationType_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRepresentationType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRepresentationProxy *op = static_cast<vtkSMRepresentationProxy *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = (ap.IsBound() ?
      op->SetRepresentationType(temp0) :
      op->vtkSMRepresentationProxy::SetRepresentationType(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMRepresentationProxy_SetRepresentationType_s2(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetRepresentationType");

  vtkSMProxy *temp0 = nullptr;
  const char *temp1 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetValue(temp1))
  {
    bool tempr = vtkSMRepresentationProxy::SetRepresentationType(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMRepresentationProxy_SetRepresentationType(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(args);

  switch(nargs)
  {
    case 1:
      return PyvtkSMRepresentationProxy_SetRepresentationType_s1(self, args);
    case 2:
      return PyvtkSMRepresentationProxy_SetRepresentationType_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetRepresentationType");
  return nullptr;
}


static PyObject *
PyvtkSMRepresentationProxy_GetRepresentationType_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRepresentationType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRepresentationProxy *op = static_cast<vtkSMRepresentationProxy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetRepresentationType() :
      op->vtkSMRepresentationProxy::GetRepresentationType());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMRepresentationProxy_GetRepresentationType_s2(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetRepresentationType");

  vtkSMProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProxy"))
  {
    const char *tempr = vtkSMRepresentationProxy::GetRepresentationType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMRepresentationProxy_GetRepresentationType(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(args);

  switch(nargs)
  {
    case 0:
      return PyvtkSMRepresentationProxy_GetRepresentationType_s1(self, args);
    case 1:
      return PyvtkSMRepresentationProxy_GetRepresentationType_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetRepresentationType");
  return nullptr;
}


static PyObject *
PyvtkSMRepresentationProxy_IsVolumeRendering_s1(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsVolumeRendering");

  vtkSMProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProxy"))
  {
    bool tempr = vtkSMRepresentationProxy::IsVolumeRendering(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMRepresentationProxy_IsVolumeRendering_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsVolumeRendering");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRepresentationProxy *op = static_cast<vtkSMRepresentationProxy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->IsVolumeRendering() :
      op->vtkSMRepresentationProxy::IsVolumeRendering());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkSMRepresentationProxy_IsVolumeRendering_Methods[] = {
  {"IsVolumeRendering", PyvtkSMRepresentationProxy_IsVolumeRendering_s1, METH_VARARGS | METH_STATIC,
   "V *vtkSMProxy"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkSMRepresentationProxy_IsVolumeRendering(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkSMRepresentationProxy_IsVolumeRendering_Methods;
  int nargs = vtkPythonArgs::GetArgCount(args);

  switch(nargs)
  {
    case 0:
      return PyvtkSMRepresentationProxy_IsVolumeRendering_s2(self, args);
    case 1:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "IsVolumeRendering");
  return nullptr;
}


static PyObject *
PyvtkSMRepresentationProxy_GetUsing2DTransferFunction_s1(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetUsing2DTransferFunction");

  vtkSMProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProxy"))
  {
    bool tempr = vtkSMRepresentationProxy::GetUsing2DTransferFunction(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMRepresentationProxy_GetUsing2DTransferFunction_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUsing2DTransferFunction");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRepresentationProxy *op = static_cast<vtkSMRepresentationProxy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetUsing2DTransferFunction() :
      op->vtkSMRepresentationProxy::GetUsing2DTransferFunction());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkSMRepresentationProxy_GetUsing2DTransferFunction_Methods[] = {
  {"GetUsing2DTransferFunction", PyvtkSMRepresentationProxy_GetUsing2DTransferFunction_s1, METH_VARARGS | METH_STATIC,
   "V *vtkSMProxy"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkSMRepresentationProxy_GetUsing2DTransferFunction(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkSMRepresentationProxy_GetUsing2DTransferFunction_Methods;
  int nargs = vtkPythonArgs::GetArgCount(args);

  switch(nargs)
  {
    case 0:
      return PyvtkSMRepresentationProxy_GetUsing2DTransferFunction_s2(self, args);
    case 1:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetUsing2DTransferFunction");
  return nullptr;
}


static PyObject *
PyvtkSMRepresentationProxy_MarkDirty(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "MarkDirty");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRepresentationProxy *op = static_cast<vtkSMRepresentationProxy *>(vp);

  vtkSMProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProxy"))
  {
    if (ap.IsBound())
    {
      op->MarkDirty(temp0);
    }
    else
    {
      op->vtkSMRepresentationProxy::MarkDirty(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkSMRepresentationProxy_Methods[] = {
  {"IsTypeOf", PyvtkSMRepresentationProxy_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkSMRepresentationProxy_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkSMRepresentationProxy_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkSMRepresentationProxy\nC++: static vtkSMRepresentationProxy *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkSMRepresentationProxy_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkSMRepresentationProxy\nC++: vtkSMRepresentationProxy *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkSMRepresentationProxy_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkSMRepresentationProxy_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetRepresentedDataInformation", PyvtkSMRepresentationProxy_GetRepresentedDataInformation, METH_VARARGS,
   "GetRepresentedDataInformation(self) -> vtkPVDataInformation\nC++: virtual vtkPVDataInformation *GetRepresentedDataInformation()\n\nReturns information about the data that is finally rendered by\nthis representation.\n"},
  {"GetProminentValuesInformation", PyvtkSMRepresentationProxy_GetProminentValuesInformation, METH_VARARGS,
   "GetProminentValuesInformation(self, name:str, fieldAssoc:int,\n    numComponents:int, uncertaintyAllowed:float=1e-6,\n    fraction:float=1e-3, force:bool=False)\n    -> vtkPVProminentValuesInformation\nC++: virtual vtkPVProminentValuesInformation *GetProminentValuesInformation(\n    std::string name, int fieldAssoc, int numComponents,\n    double uncertaintyAllowed=1e-6, double fraction=1e-3,\n    bool force=false)\n\nReturns information about a specific array component's prominent\nvalues (or nullptr).\n\n* The name, fieldAssoc, and numComponents arguments specify\n* which arrays on the input dataset to examine. Because\n  multiblock\n* datasets may have multiple arrays of the same name on different\nblocks,\n* and these arrays may not have the same storage type or number\n  of\n* components, this method requires you to specify the number of\n* components per tuple the array(s) of interest must have.\n* You may call GetRepresentedDataInformation() to obtain the\n  number of\n* components for any array.\n\n* See vtkAbstractArray::GetProminentComponentValues for more\n  information\n* about the uncertaintyAllowed and fraction arguments.\n"},
  {"GetBlockProminentValuesInformation", PyvtkSMRepresentationProxy_GetBlockProminentValuesInformation, METH_VARARGS,
   "GetBlockProminentValuesInformation(self, blockSelector:str,\n    assemblyName:str, name:str, fieldAssoc:int, numComponents:int,\n     uncertaintyAllowed:float=1e-6, fraction:float=1e-3,\n    force:bool=False) -> vtkPVProminentValuesInformation\nC++: virtual vtkPVProminentValuesInformation *GetBlockProminentValuesInformation(\n    std::string blockSelector, std::string assemblyName,\n    std::string name, int fieldAssoc, int numComponents,\n    double uncertaintyAllowed=1e-6, double fraction=1e-3,\n    bool force=false)\n\n"},
  {"UpdatePipeline", PyvtkSMRepresentationProxy_UpdatePipeline, METH_VARARGS,
   "UpdatePipeline(self) -> None\nC++: void UpdatePipeline() override;\nUpdatePipeline(self, time:float) -> None\nC++: void UpdatePipeline(double time) override;\n\nCalls Update() on all sources. It also creates output ports if\nthey are not already created.\n"},
  {"PostUpdateData", PyvtkSMRepresentationProxy_PostUpdateData, METH_VARARGS,
   "PostUpdateData(self, __a:bool) -> None\nC++: void PostUpdateData(bool) override;\n\nOverridden to reset this->MarkedModified flag.\n"},
  {"ViewUpdated", PyvtkSMRepresentationProxy_ViewUpdated, METH_VARARGS,
   "ViewUpdated(self, view:vtkSMProxy) -> None\nC++: virtual void ViewUpdated(vtkSMProxy *view)\n\nCalled after the view updates.\n"},
  {"GetGlobalID", PyvtkSMRepresentationProxy_GetGlobalID, METH_VARARGS,
   "GetGlobalID(self) -> int\nC++: vtkTypeUInt32 GetGlobalID() override;\n\nOverridden to reserve additional IDs for use by internal\ncomposite representation\n"},
  {"SetRepresentationType", PyvtkSMRepresentationProxy_SetRepresentationType, METH_VARARGS,
   "SetRepresentationType(self, type:str) -> bool\nC++: virtual bool SetRepresentationType(const char *type)\nSetRepresentationType(repr:vtkSMProxy, type:str) -> bool\nC++: static bool SetRepresentationType(vtkSMProxy *repr,\n    const char *type)\n\nSet the representation type. Default implementation simply\nupdates the \"Representation\" property, if present with the value\nprovided. Subclasses can override this method to add custom logic\nto manage the representation state to support the change e.g.\npick a scalar color array when switching to Volume or Slice\nrepresentation, for example. Returns true, if the change was\nsuccessful, otherwise returns false.\n"},
  {"GetRepresentationType", PyvtkSMRepresentationProxy_GetRepresentationType, METH_VARARGS,
   "GetRepresentationType(self) -> str\nC++: const char *GetRepresentationType()\nGetRepresentationType(repr:vtkSMProxy) -> str\nC++: static const char *GetRepresentationType(vtkSMProxy *repr)\n\n"},
  {"IsVolumeRendering", PyvtkSMRepresentationProxy_IsVolumeRendering, METH_VARARGS,
   "IsVolumeRendering(repr:vtkSMProxy) -> bool\nC++: static bool IsVolumeRendering(vtkSMProxy *repr)\nIsVolumeRendering(self) -> bool\nC++: bool IsVolumeRendering()\n\nConvenient method to check if this representation is currently\nrendering volumes, using 2D Transfer function.\n"},
  {"GetUsing2DTransferFunction", PyvtkSMRepresentationProxy_GetUsing2DTransferFunction, METH_VARARGS,
   "GetUsing2DTransferFunction(repr:vtkSMProxy) -> bool\nC++: static bool GetUsing2DTransferFunction(vtkSMProxy *repr)\nGetUsing2DTransferFunction(self) -> bool\nC++: bool GetUsing2DTransferFunction()\n\n"},
  {"MarkDirty", PyvtkSMRepresentationProxy_MarkDirty, METH_VARARGS,
   "MarkDirty(self, modifiedProxy:vtkSMProxy) -> None\nC++: void MarkDirty(vtkSMProxy *modifiedProxy) override;\n\nMarks the selection proxies dirty as well as chain to superclass.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkSMRepresentationProxy_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("represented_data_information"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMRepresentationProxy_GetRepresentedDataInformation(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetRepresentedDataInformation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("global_id"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMRepresentationProxy_GetGlobalID(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetGlobalID\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("representation_type"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMRepresentationProxy_GetRepresentationType(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetRepresentationType\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("using2d_transfer_function"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMRepresentationProxy_GetUsing2DTransferFunction(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetUsing2DTransferFunction\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkSMRepresentationProxy_Doc =
  "vtkSMRepresentationProxy - Proxy for a representations\n\n"
  "Superclass: vtkSMSourceProxy\n\n"
  "vtkSMRepresentationProxy is a vtkSMSourceProxy subclass that is\n"
  "designed to be used either directly or as a superclass for \"data\"\n"
  "representations i.e. representation that have an input (as against\n"
  "proxies for annotations such as 3D widgets).\n\n"
  "@section RepresentationMarkDirty Special handling of `MarkDirty`\n\n"
  "`vtkSMProxy::MarkDirty` is a mechanism that ParaView uses to know on\n"
  "the client side (i.e. in the server-manager layer) when a pipeline on\n"
  "the server side is \"dirty\" or has potential to execute on an update\n"
  "causing things like data information to be invalidated. Simply\n"
  "speaking, when a property on a vtkSMProxy is modified and pushed\n"
  "(using `vtkSMProxy::UpdateVTKObjects` or\n"
  "`vtkSMProxy::UpdateProperty`), it calls `this->MarkDirty(this)`.\n"
  "`vtkSMProxy::MarkDirty` invokes `vtkSMProxy::MarkConsumersAsDirty`\n"
  "which results in any consumers of this dirtied proxy also getting the\n"
  "notification. Consumers (and conversely producers) are setup via\n"
  "ProxyProperty and InputProperty connections. For standard data\n"
  "processing pipelines, this mechanism works quite well. Consider a\n"
  "filter proxy, say `Clip`, which has an input set via a InputProperty\n"
  "and a implicit function set via a ProxyProperty. If either the input\n"
  "or the implicit function is modified, it is reasonable to expect the\n"
  "Clip filter to re-execute on an `UpdatePipeline` call. Whether the\n"
  "call will truly cause the VTK pipeline (server side) to execute is\n"
  "not that important. The pipeline may not re-execute and that's not a\n"
  "big deal.\n\n"
  "Things get a little complicated for representations, however. Data\n"
  "representations don't necessary have valid input connections on all\n"
  "processes where their VTK objects are present (note, representations\n"
  "create VTK objects on all process while data input is only available\n"
  "on the data server nodes). As a result representations have to be\n"
  "explicitly told to re-execute following upstream changes since they\n"
  "cannot rely on their VTK-level upstream. Re-executing a\n"
  "representation means regenerating the geometry or data artifacts for\n"
  "rendering, redelivering them to the rendering nodes, etc. It can also\n"
  "mean cleaning up any caches the representation built for flip-book\n"
  "animation support. In other words, re-executing a representation is\n"
  "non-trivial task. Thus, we want do it only when absolutely needed.\n\n"
  "The explicit pipeline update is often referred to as \"update\n"
  "suppression\" and handled by `vtkPVDataRepresentation` and\n"
  "`vtkPVDataRepresentationPipeline`. In short, calling `Update` on\n"
  "vtkPVDataRepresentation has no effect unless\n"
  "`vtkPVDataRepresentation::MarkModified` was explicitly called at some\n"
  "point since the last `Update`.\n\n"
  "To explicitly call `vtkPVDataRepresentation::MarkModified` for only\n"
  "those cases where the representation must be re-executed, we follow\n"
  "the following strategy.\n\n"
  "\\li vtkPVDataRepresentation subclasses explicitly call\n"
  "    `this->MarkModified`\n"
  "    when a public API that invalidates the data pipeline is invoked.\n"
  "\\li vtkSMRepresentationProxy overrides\n"
  "    `vtkSMProxy::MarkDirtyFromProducer`\n"
  "    to call `MarkModified` on the VTK object if the producer was\n"
  "connected to\n"
  "    the representation via a InputProperty and not a ProxyProperty.\n"
  "The\n"
  "    assumption is that InputProperty connections typically imply\n"
  "pipeline\n"
  "    connections while ProxyProperty connections are other supporting\n"
  "VTK\n"
  "    objects e.g. LUT.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkSMRepresentationProxy_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingViews.vtkSMRepresentationProxy", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkSMRepresentationProxy_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkSMRepresentationProxy_StaticNew()
{
  return vtkSMRepresentationProxy::New();
}

PyObject *PyvtkSMRepresentationProxy_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkSMRepresentationProxy_Type, PyvtkSMRepresentationProxy_Methods,
    "vtkSMRepresentationProxy",
 &PyvtkSMRepresentationProxy_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkSMSourceProxy");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkSMRepresentationProxy_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkSMRepresentationProxy(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkSMRepresentationProxy_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkSMRepresentationProxy", o) != 0)
  {
    Py_DECREF(o);
  }

}

