#include "vtkABI.h"
#include "vtkClientServerInterpreter.h"

extern "C" { void vtkPAutoCorrelativeStatistics_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPBivariateLinearTableThreshold_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPComputeQuantiles_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPComputeQuartiles_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPContingencyStatistics_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPCorrelativeStatistics_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPDescriptiveStatistics_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPKMeansStatistics_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPMultiCorrelativeStatistics_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPOrderStatistics_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPPCAStatistics_Init(vtkClientServerInterpreter*); }

extern "C" VTK_ABI_EXPORT void vtkFiltersParallelStatisticsCS_Initialize(vtkClientServerInterpreter* csi)
{
  (void)csi;
  vtkPAutoCorrelativeStatistics_Init(csi);
  vtkPBivariateLinearTableThreshold_Init(csi);
  vtkPComputeQuantiles_Init(csi);
  vtkPComputeQuartiles_Init(csi);
  vtkPContingencyStatistics_Init(csi);
  vtkPCorrelativeStatistics_Init(csi);
  vtkPDescriptiveStatistics_Init(csi);
  vtkPKMeansStatistics_Init(csi);
  vtkPMultiCorrelativeStatistics_Init(csi);
  vtkPOrderStatistics_Init(csi);
  vtkPPCAStatistics_Init(csi);
}
